/* rygel-database-test.c generated by valac 0.36.6, the Vala compiler
 * generated from rygel-database-test.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-db.h>
#include <stdlib.h>
#include <string.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))



void test_bgo683926_1 (void);
static void _vala_GValue_array_free (GValue * array, gint array_length);
gint _vala_main (gchar** args, int args_length1);
static void _test_bgo683926_1_gtest_func (void);


/**
 * Test that database errors are reported correctly. This is a side-bug
 * discovered during fixing this bug.
 */
static void _vala_GValue_array_free (GValue * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}


void test_bgo683926_1 (void) {
	RygelDatabaseDatabase* db = NULL;
	GError * _inner_error_ = NULL;
	db = NULL;
	{
		RygelDatabaseDatabase* _tmp0_ = NULL;
		RygelDatabaseDatabase* _tmp1_;
		RygelDatabaseDatabase* _tmp2_;
		RygelDatabaseDatabase* _tmp3_;
		RygelDatabaseDatabase* _tmp4_;
		_tmp1_ = rygel_database_database_new (":memory:", RYGEL_DATABASE_FLAVOR_CACHE, RYGEL_DATABASE_FLAGS_READ_WRITE, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (db);
		db = _tmp2_;
		_tmp3_ = db;
		rygel_database_database_exec (_tmp3_, "create table object (id text not null, title text not null);", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp4_ = db;
		rygel_database_database_exec (_tmp4_, "insert into object (id, title) VALUES ('a', 'b');", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e->message;
		g_error ("rygel-database-test.vala:35: => Database preparation failed: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (db);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GValue* val = NULL;
		GValue _tmp6_ = {0};
		GValue* _tmp7_;
		gint val_length1;
		gint _val_size_;
		RygelDatabaseDatabase* _tmp8_;
		g_value_init (&_tmp6_, G_TYPE_STRING);
		g_value_set_string (&_tmp6_, "c");
		_tmp7_ = g_new0 (GValue, 1);
		_tmp7_[0] = _tmp6_;
		val = _tmp7_;
		val_length1 = 1;
		_val_size_ = val_length1;
		_tmp8_ = db;
		rygel_database_database_exec (_tmp8_, "replace into object (title) VALUES (?);", val, val_length1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			val = (_vala_GValue_array_free (val, val_length1), NULL);
			goto __catch1_g_error;
		}
		g_assert_not_reached ();
		val = (_vala_GValue_array_free (val, val_length1), NULL);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (db);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (db);
}


static void _test_bgo683926_1_gtest_func (void) {
	test_bgo683926_1 ();
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gint _tmp0_;
	g_test_init (&args_length1, &args, NULL);
	g_test_add_func ("/librygel-db/regression/bgo689326_1", _test_bgo683926_1_gtest_func);
	_tmp0_ = g_test_run ();
	result = _tmp0_;
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}



