/* rygel-object-creator.c generated by valac 0.36.6, the Vala compiler
 * generated from rygel-object-creator.vala, do not modify */

/*
 * Copyright (C) 2010-2011 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <gio/gio.h>
#include <rygel-core.h>
#include <libgupnp/gupnp.h>
#include <glib/gi18n-lib.h>
#include <libsoup/soup.h>
#include <stdio.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_BASE_MEDIA_CONTAINER (rygel_base_media_container_get_type ())
#define RYGEL_BASE_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASE_MEDIA_CONTAINER, RygelBaseMediaContainer))
#define RYGEL_BASE_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASE_MEDIA_CONTAINER, RygelBaseMediaContainerClass))
#define RYGEL_IS_BASE_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASE_MEDIA_CONTAINER))
#define RYGEL_IS_BASE_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASE_MEDIA_CONTAINER))
#define RYGEL_BASE_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASE_MEDIA_CONTAINER, RygelBaseMediaContainerClass))

typedef struct _RygelBaseMediaContainer RygelBaseMediaContainer;
typedef struct _RygelBaseMediaContainerClass RygelBaseMediaContainerClass;
typedef struct _RygelBaseMediaContainerPrivate RygelBaseMediaContainerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelBaseMediaContainerGetChildrenData RygelBaseMediaContainerGetChildrenData;
typedef struct _RygelBaseMediaContainerFindObjectData RygelBaseMediaContainerFindObjectData;

#define RYGEL_TYPE_OBJECT_CREATOR (rygel_object_creator_get_type ())
#define RYGEL_OBJECT_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreator))
#define RYGEL_OBJECT_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreatorClass))
#define RYGEL_IS_OBJECT_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_OBJECT_CREATOR))
#define RYGEL_IS_OBJECT_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_OBJECT_CREATOR))
#define RYGEL_OBJECT_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreatorClass))

typedef struct _RygelObjectCreator RygelObjectCreator;
typedef struct _RygelObjectCreatorClass RygelObjectCreatorClass;
typedef struct _RygelObjectCreatorPrivate RygelObjectCreatorPrivate;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_SERIALIZER_TYPE (rygel_serializer_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;

#define RYGEL_TYPE_OBJECT_REMOVAL_QUEUE (rygel_object_removal_queue_get_type ())
#define RYGEL_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueue))
#define RYGEL_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_OBJECT_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))

typedef struct _RygelObjectRemovalQueue RygelObjectRemovalQueue;
typedef struct _RygelObjectRemovalQueueClass RygelObjectRemovalQueueClass;
typedef struct _RygelObjectCreatorRunData RygelObjectCreatorRunData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

#define RYGEL_TYPE_SEARCH_CRITERIA_PARSER (rygel_search_criteria_parser_get_type ())
#define RYGEL_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParser))
#define RYGEL_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_SEARCH_CRITERIA_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))

typedef struct _RygelSearchCriteriaParser RygelSearchCriteriaParser;
typedef struct _RygelSearchCriteriaParserClass RygelSearchCriteriaParserClass;

#define RYGEL_TYPE_LOGICAL_EXPRESSION (rygel_logical_expression_get_type ())
#define RYGEL_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpression))
#define RYGEL_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))
#define RYGEL_IS_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_IS_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_LOGICAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))

typedef struct _RygelLogicalExpression RygelLogicalExpression;
typedef struct _RygelLogicalExpressionClass RygelLogicalExpressionClass;

#define RYGEL_TYPE_LOGICAL_OPERATOR (rygel_logical_operator_get_type ())
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
typedef struct _RygelSearchCriteriaParserPrivate RygelSearchCriteriaParserPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _RygelObjectCreatorBuildCreateClassExpressionData RygelObjectCreatorBuildCreateClassExpressionData;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelObjectCreatorFindAnyContainerData RygelObjectCreatorFindAnyContainerData;
typedef struct _RygelObjectCreatorFetchContainerData RygelObjectCreatorFetchContainerData;

#define RYGEL_TYPE_IMAGE_ITEM (rygel_image_item_get_type ())
#define RYGEL_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItem))
#define RYGEL_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))
#define RYGEL_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))

typedef struct _RygelImageItem RygelImageItem;
typedef struct _RygelImageItemClass RygelImageItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelObjectCreatorCreateObjectFromDidlData RygelObjectCreatorCreateObjectFromDidlData;
#define __vala_SoupDate_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupDate_free (var), NULL)))

#define RYGEL_TYPE_PHOTO_ITEM (rygel_photo_item_get_type ())
#define RYGEL_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItem))
#define RYGEL_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))
#define RYGEL_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))

typedef struct _RygelPhotoItem RygelPhotoItem;
typedef struct _RygelPhotoItemClass RygelPhotoItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;

#define RYGEL_TYPE_PLAYLIST_ITEM (rygel_playlist_item_get_type ())
#define RYGEL_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYLIST_ITEM, RygelPlaylistItem))
#define RYGEL_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAYLIST_ITEM, RygelPlaylistItemClass))
#define RYGEL_IS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYLIST_ITEM))
#define RYGEL_IS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAYLIST_ITEM))
#define RYGEL_PLAYLIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAYLIST_ITEM, RygelPlaylistItemClass))

typedef struct _RygelPlaylistItem RygelPlaylistItem;
typedef struct _RygelPlaylistItemClass RygelPlaylistItemClass;
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
typedef struct _RygelObjectCreatorCreateUriData RygelObjectCreatorCreateUriData;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;

#define RYGEL_TYPE_OBJECT_EVENT_TYPE (rygel_object_event_type_get_type ())
typedef struct _RygelObjectCreatorWaitForObjectData RygelObjectCreatorWaitForObjectData;

#define RYGEL_TYPE_MEDIA_SERVER_PLUGIN (rygel_media_server_plugin_get_type ())
#define RYGEL_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin))
#define RYGEL_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_MEDIA_SERVER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))

typedef struct _RygelMediaServerPlugin RygelMediaServerPlugin;
typedef struct _RygelMediaServerPluginClass RygelMediaServerPluginClass;
#define _rygel_dlna_profile_unref0(var) ((var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL)))

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	RygelDataSource* (*create_stream_source_for_resource) (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	guint32 update_id;
	gint64 storage_used;
	gint64 total_deleted_child_count;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelBaseMediaContainer {
	RygelMediaContainer parent_instance;
	RygelBaseMediaContainerPrivate * priv;
};

struct _RygelBaseMediaContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelBaseMediaContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelBaseMediaContainer* self;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
};

struct _RygelBaseMediaContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelBaseMediaContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
};

struct _RygelObjectCreator {
	GObject parent_instance;
	RygelObjectCreatorPrivate * priv;
};

struct _RygelObjectCreatorClass {
	GObjectClass parent_class;
};

struct _RygelObjectCreatorPrivate {
	gchar* container_id;
	gchar* elements;
	GUPnPDIDLLiteObject* didl_object;
	RygelMediaObject* object;
	RygelContentDirectory* content_dir;
	GUPnPServiceAction* action;
	RygelSerializer* serializer;
	GUPnPDIDLLiteParser* didl_parser;
	GRegex* title_regex;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

typedef enum  {
	RYGEL_SERIALIZER_TYPE_GENERIC_DIDL,
	RYGEL_SERIALIZER_TYPE_DIDL_S,
	RYGEL_SERIALIZER_TYPE_M3UEXT
} RygelSerializerType;

struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaFileItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_container) (RygelWritableContainer* self, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_reference) (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*add_reference_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_container) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelObjectCreatorRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelObjectCreator* self;
	RygelWritableContainer* container;
	RygelWritableContainer* _tmp0_;
	gboolean _tmp1_;
	RygelWritableContainer* _tmp2_;
	GUPnPDIDLLiteObject* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	GUPnPDIDLLiteObject* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	RygelWritableContainer* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	gboolean _tmp15_;
	GUPnPDIDLLiteObject* _tmp16_;
	RygelWritableContainer* _tmp17_;
	gboolean _tmp18_;
	GError* _tmp19_;
	RygelWritableContainer* _tmp20_;
	RygelMediaObject* _tmp21_;
	RygelWritableContainer* _tmp22_;
	RygelMediaObject* _tmp23_;
	GCancellable* _tmp24_;
	GCancellable* _tmp25_;
	RygelWritableContainer* _tmp26_;
	RygelMediaObject* _tmp27_;
	GCancellable* _tmp28_;
	GCancellable* _tmp29_;
	RygelWritableContainer* _tmp30_;
	RygelMediaObject* _tmp31_;
	RygelSerializer* _tmp32_;
	RygelContentDirectory* _tmp33_;
	RygelHTTPServer* _tmp34_;
	GUPnPDIDLLiteObject* _tmp35_;
	GUPnPDIDLLiteObject* _tmp36_;
	gboolean _tmp37_;
	const gchar* _tmp38_;
	gboolean _tmp39_;
	RygelMediaObject* _tmp40_;
	RygelMediaObject* _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	RygelObjectRemovalQueue* queue;
	RygelObjectRemovalQueue* _tmp44_;
	RygelObjectRemovalQueue* _tmp45_;
	RygelMediaObject* _tmp46_;
	GCancellable* _tmp47_;
	GCancellable* _tmp48_;
	GError* err;
	GError* _tmp49_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_LOGICAL_OPERATOR_AND,
	RYGEL_LOGICAL_OPERATOR_OR
} RygelLogicalOperator;

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelSearchCriteriaParser {
	GObject parent_instance;
	RygelSearchCriteriaParserPrivate * priv;
	gchar* str;
	RygelSearchExpression* expression;
	GError* err;
};

struct _RygelSearchCriteriaParserClass {
	GObjectClass parent_class;
};

struct _RygelObjectCreatorBuildCreateClassExpressionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelObjectCreator* self;
	RygelSearchExpression* expression;
	RygelSearchExpression* result;
	GUPnPDIDLLiteObject* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	GUPnPDIDLLiteContainer* didl_container;
	GUPnPDIDLLiteObject* _tmp3_;
	GUPnPDIDLLiteContainer* _tmp4_;
	GList* create_classes;
	GUPnPDIDLLiteContainer* _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	RygelSearchExpression* _tmp8_;
	RygelSearchExpression* _tmp9_;
	GString* builder;
	GString* _tmp10_;
	GList* _tmp11_;
	GList* create_class_collection;
	GList* create_class_it;
	gchar* _tmp12_;
	gchar* create_class;
	GString* _tmp13_;
	const gchar* _tmp14_;
	GString* _tmp15_;
	GString* _tmp16_;
	gssize _tmp17_;
	GString* _tmp18_;
	RygelSearchCriteriaParser* parser;
	GString* _tmp19_;
	const gchar* _tmp20_;
	RygelSearchCriteriaParser* _tmp21_;
	RygelSearchCriteriaParser* _tmp22_;
	RygelLogicalExpression* rel;
	RygelLogicalExpression* _tmp23_;
	RygelLogicalExpression* _tmp24_;
	RygelSearchExpression* _tmp25_;
	RygelSearchExpression* _tmp26_;
	RygelLogicalExpression* _tmp27_;
	RygelLogicalExpression* _tmp28_;
	RygelSearchCriteriaParser* _tmp29_;
	RygelSearchExpression* _tmp30_;
	RygelSearchExpression* _tmp31_;
	GError* _error_;
	GError * _inner_error_;
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelObjectCreatorFindAnyContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelObjectCreator* self;
	RygelMediaObject* result;
	RygelSearchableContainer* root_container;
	RygelContentDirectory* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelSearchableContainer* _tmp2_;
	RygelSearchableContainer* _tmp3_;
	gchar* upnp_class;
	GUPnPDIDLLiteObject* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp8_;
	RygelRelationalExpression* _tmp9_;
	RygelRelationalExpression* _tmp10_;
	gchar* _tmp11_;
	RygelSearchExpression* search_expression;
	RygelRelationalExpression* _tmp12_;
	RygelSearchExpression* _tmp13_;
	const gchar* _tmp14_;
	RygelRelationalExpression* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	guint total_matches;
	RygelMediaObjects* _result_;
	RygelSearchableContainer* _tmp18_;
	RygelSearchExpression* _tmp19_;
	RygelSearchableContainer* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GCancellable* _tmp23_;
	GCancellable* _tmp24_;
	guint _tmp25_;
	RygelMediaObjects* _tmp26_;
	RygelMediaObjects* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	GUPnPDIDLLiteObject* _tmp30_;
	const gchar* _tmp31_;
	RygelMediaObjects* _tmp32_;
	gpointer _tmp33_;
	const gchar* _tmp34_;
	GUPnPDIDLLiteObject* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	GError* _tmp38_;
	GError * _inner_error_;
};

struct _RygelObjectCreatorFetchContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelObjectCreator* self;
	RygelWritableContainer* result;
	RygelMediaObject* media_object;
	const gchar* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaObject* _tmp2_;
	RygelMediaObject* _tmp3_;
	RygelMediaObject* _tmp4_;
	RygelContentDirectory* _tmp5_;
	RygelMediaContainer* _tmp6_;
	const gchar* _tmp7_;
	GCancellable* _tmp8_;
	GCancellable* _tmp9_;
	RygelMediaObject* _tmp10_;
	RygelMediaObject* _tmp11_;
	gboolean _tmp12_;
	RygelMediaObject* _tmp13_;
	RygelMediaObject* _tmp14_;
	GError* _tmp15_;
	RygelMediaObject* _tmp16_;
	RygelMediaObject* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GError* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	GUPnPDIDLLiteObject* _tmp23_;
	RygelMediaObject* _tmp24_;
	GUPnPOCMFlags _tmp25_;
	GUPnPOCMFlags _tmp26_;
	gboolean _tmp27_;
	GUPnPDIDLLiteObject* _tmp28_;
	RygelMediaObject* _tmp29_;
	GUPnPOCMFlags _tmp30_;
	GUPnPOCMFlags _tmp31_;
	RygelMediaObject* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	GError* _tmp35_;
	RygelMediaObject* _tmp36_;
	RygelWritableContainer* _tmp37_;
	GError * _inner_error_;
};

struct _RygelObjectCreatorCreateObjectFromDidlData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelObjectCreator* self;
	RygelWritableContainer* container;
	RygelMediaObject* _tmp0_;
	GUPnPDIDLLiteObject* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	RygelWritableContainer* _tmp4_;
	GUPnPDIDLLiteObject* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GUPnPDIDLLiteObject* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	RygelMediaObject* _tmp11_;
	RygelMediaObject* _tmp12_;
	RygelMediaObject* _tmp13_;
	GUPnPDIDLLiteObject* _tmp14_;
	RygelMediaObject* _tmp15_;
	RygelMediaObject* _tmp16_;
	GeeList* _tmp17_;
	GeeList* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gchar* uri;
	RygelWritableContainer* _tmp22_;
	RygelMediaObject* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	RygelMediaObject* _tmp27_;
	const gchar* _tmp28_;
	RygelMediaObject* _tmp29_;
	RygelMediaObject* _tmp30_;
	RygelMediaObject* _tmp31_;
	GFile* file;
	RygelMediaObject* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GFile* _tmp35_;
	GFile* _tmp36_;
	RygelMediaObject* _tmp37_;
	GFile* _tmp38_;
	gboolean _tmp39_;
	RygelMediaObject* _tmp40_;
	RygelMediaObject* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GError * _inner_error_;
};

struct _RygelObjectCreatorCreateUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelObjectCreator* self;
	RygelWritableContainer* container;
	gchar* title;
	gchar* result;
	GFile* dir;
	RygelWritableContainer* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	RygelWritableContainer* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* file;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	gchar* _tmp15_;
	GError * _inner_error_;
};

struct _Block8Data {
	int _ref_count_;
	RygelObjectCreator* self;
	RygelWritableContainer* container;
	gpointer _async_data_;
};

struct _Block9Data {
	int _ref_count_;
	Block8Data * _data8_;
	guint timeout;
};

typedef enum  {
	RYGEL_OBJECT_EVENT_TYPE_ADDED = 0,
	RYGEL_OBJECT_EVENT_TYPE_MODIFIED = 1,
	RYGEL_OBJECT_EVENT_TYPE_DELETED = 2
} RygelObjectEventType;

struct _RygelObjectCreatorWaitForObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelObjectCreator* self;
	RygelWritableContainer* container;
	Block8Data* _data8_;
	RygelWritableContainer* _tmp0_;
	RygelWritableContainer* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaObject* object;
	RygelMediaObject* _tmp4_;
	RygelMediaObject* _tmp5_;
	RygelWritableContainer* _tmp6_;
	RygelMediaObject* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GCancellable* _tmp10_;
	GCancellable* _tmp11_;
	RygelMediaObject* _tmp12_;
	RygelMediaObject* _tmp13_;
	GError* _error_;
	gchar* msg;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	RygelWritableContainer* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	RygelMediaObject* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GError* _tmp22_;
	const gchar* _tmp23_;
	RygelMediaObject* _tmp24_;
	Block9Data* _data9_;
	gulong id;
	RygelWritableContainer* _tmp25_;
	gulong _tmp26_;
	guint _tmp27_;
	RygelWritableContainer* _tmp28_;
	gulong _tmp29_;
	guint _tmp30_;
	guint _tmp31_;
	RygelWritableContainer* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	RygelMediaObject* _tmp35_;
	RygelMediaObject* _tmp36_;
	GError * _inner_error_;
};


static gpointer rygel_base_media_container_parent_class = NULL;
static gpointer rygel_object_creator_parent_class = NULL;
static GPatternSpec* rygel_object_creator_comment_pattern;
static GPatternSpec* rygel_object_creator_comment_pattern = NULL;
static RygelStateMachineIface * rygel_object_creator_rygel_state_machine_parent_iface = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_base_media_container_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_BASE_MEDIA_CONTAINER_DUMMY_PROPERTY
};
RygelBaseMediaContainer* rygel_base_media_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count);
RygelBaseMediaContainer* rygel_base_media_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count);
static void rygel_base_media_container_real_get_children_data_free (gpointer _data);
static void rygel_base_media_container_real_get_children_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void rygel_base_media_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_base_media_container_real_get_children_co (RygelBaseMediaContainerGetChildrenData* _data_);
static void rygel_base_media_container_real_find_object_data_free (gpointer _data);
static void rygel_base_media_container_real_find_object_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void rygel_base_media_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_base_media_container_real_find_object_co (RygelBaseMediaContainerFindObjectData* _data_);
GType rygel_object_creator_get_type (void) G_GNUC_CONST;
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
#define RYGEL_OBJECT_CREATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreatorPrivate))
enum  {
	RYGEL_OBJECT_CREATOR_DUMMY_PROPERTY,
	RYGEL_OBJECT_CREATOR_CANCELLABLE_PROPERTY
};
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
#define RYGEL_OBJECT_CREATOR_INVALID_CHARS "/?<>\\:*|\""
RygelObjectCreator* rygel_object_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelObjectCreator* rygel_object_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_serializer_type_get_type (void) G_GNUC_CONST;
RygelSerializer* rygel_serializer_new (RygelSerializerType type);
RygelSerializer* rygel_serializer_construct (GType object_type, RygelSerializerType type);
static void rygel_object_creator_real_run_data_free (gpointer _data);
static void rygel_object_creator_real_run_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void rygel_object_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_object_creator_real_run_co (RygelObjectCreatorRunData* _data_);
static void rygel_object_creator_parse_args (RygelObjectCreator* self, GError** error);
static void rygel_object_creator_parse_didl (RygelObjectCreator* self, GError** error);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
static void rygel_object_creator_fetch_container (RygelObjectCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelWritableContainer* rygel_object_creator_fetch_container_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error);
static void rygel_object_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean rygel_writable_container_can_create (RygelWritableContainer* self, const gchar* upnp_class);
#define RYGEL_MEDIA_CONTAINER_ANY "DLNA.ORG_AnyContainer"
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
GQuark rygel_content_directory_error_quark (void);
static gboolean rygel_object_creator_validate_create_class (RygelObjectCreator* self, RygelWritableContainer* container);
static void rygel_object_creator_create_object_from_didl (RygelObjectCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_object_creator_create_object_from_didl_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error);
void rygel_writable_container_add_item (RygelWritableContainer* self, RygelMediaFileItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_item_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
void rygel_writable_container_add_container (RygelWritableContainer* self, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_container_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_object_creator_wait_for_object (RygelObjectCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_object_creator_wait_for_object_finish (RygelObjectCreator* self, GAsyncResult* _res_);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
static void rygel_object_creator_conclude (RygelObjectCreator* self);
gboolean rygel_media_file_item_get_place_holder (RygelMediaFileItem* self);
GType rygel_object_removal_queue_get_type (void) G_GNUC_CONST;
RygelObjectRemovalQueue* rygel_object_removal_queue_get_default (void);
void rygel_object_removal_queue_queue (RygelObjectRemovalQueue* self, RygelMediaObject* object, GCancellable* cancellable);
static void rygel_object_creator_handle_error (RygelObjectCreator* self, GError* _error_);
static void __lambda8_ (RygelObjectCreator* self, GUPnPDIDLLiteObject* didl_object);
static void ___lambda8__gupnp_didl_lite_parser_object_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteObject* object, gpointer self);
#define RYGEL_PLAYLIST_ITEM_UPNP_CLASS "object.item.playlistItem"
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void rygel_object_creator_generalize_upnp_class (RygelObjectCreator* self, gchar* * upnp_class);
static void rygel_object_creator_build_create_class_expression_data_free (gpointer _data);
static void rygel_object_creator_build_create_class_expression_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
static void rygel_object_creator_build_create_class_expression (RygelObjectCreator* self, RygelSearchExpression* expression, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelSearchExpression* rygel_object_creator_build_create_class_expression_finish (RygelObjectCreator* self, GAsyncResult* _res_);
static gboolean rygel_object_creator_build_create_class_expression_co (RygelObjectCreatorBuildCreateClassExpressionData* _data_);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
GType rygel_search_criteria_parser_get_type (void) G_GNUC_CONST;
RygelSearchCriteriaParser* rygel_search_criteria_parser_new (const gchar* str, GError** error);
RygelSearchCriteriaParser* rygel_search_criteria_parser_construct (GType object_type, const gchar* str, GError** error);
static void rygel_object_creator_build_create_class_expression_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_logical_expression_get_type (void) G_GNUC_CONST;
RygelLogicalExpression* rygel_logical_expression_new (void);
RygelLogicalExpression* rygel_logical_expression_construct (GType object_type);
GType rygel_logical_operator_get_type (void) G_GNUC_CONST;
static void rygel_object_creator_find_any_container_data_free (gpointer _data);
static void rygel_object_creator_find_any_container_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void rygel_object_creator_find_any_container (RygelObjectCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObject* rygel_object_creator_find_any_container_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_object_creator_find_any_container_co (RygelObjectCreatorFindAnyContainerData* _data_);
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
static void rygel_object_creator_find_any_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
const gchar* rygel_media_container_get_sort_criteria (RygelMediaContainer* self);
static void rygel_object_creator_fetch_container_data_free (gpointer _data);
static void rygel_object_creator_fetch_container_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static gboolean rygel_object_creator_fetch_container_co (RygelObjectCreatorFetchContainerData* _data_);
static void rygel_object_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
gchar* rygel_serializer_get_string (RygelSerializer* self);
static gchar* rygel_object_creator_get_generic_mime_type (RygelObjectCreator* self);
GType rygel_image_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
static void rygel_object_creator_create_object_from_didl_data_free (gpointer _data);
static void rygel_object_creator_create_object_from_didl_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static gboolean rygel_object_creator_create_object_from_didl_co (RygelObjectCreatorCreateObjectFromDidlData* _data_);
static RygelMediaObject* rygel_object_creator_create_object (RygelObjectCreator* self, const gchar* id, RygelWritableContainer* parent, const gchar* title, const gchar* upnp_class, GError** error);
void rygel_media_object_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
static void rygel_object_creator_extract_item_parameters (RygelObjectCreator* self, GError** error);
GeeList* rygel_media_object_get_uris (RygelMediaObject* self);
static void rygel_object_creator_create_uri (RygelObjectCreator* self, RygelWritableContainer* container, const gchar* title, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar* rygel_object_creator_create_uri_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
static void rygel_object_creator_create_object_from_didl_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_object_add_uri (RygelMediaObject* self, const gchar* uri);
void rygel_media_file_item_set_place_holder (RygelMediaFileItem* self, gboolean value);
gchar* rygel_media_object_get_primary_uri (RygelMediaObject* self);
void rygel_media_object_set_id (RygelMediaObject* self, const gchar* value);
static void rygel_object_creator_parse_and_verify_didl_date (RygelObjectCreator* self, GError** error);
static gboolean rygel_object_creator_is_profile_valid (RygelObjectCreator* self, const gchar* profile);
void rygel_media_file_item_set_dlna_profile (RygelMediaFileItem* self, const gchar* value);
void rygel_media_file_item_set_mime_type (RygelMediaFileItem* self, const gchar* value);
static gboolean rygel_object_creator_is_valid_uri (RygelObjectCreator* self, const gchar* uri, gchar* * sanitized_uri);
void rygel_media_file_item_set_size (RygelMediaFileItem* self, gint64 value);
const gchar* rygel_media_file_item_get_mime_type (RygelMediaFileItem* self);
gint64 rygel_media_file_item_get_size (RygelMediaFileItem* self);
void rygel_media_object_set_date (RygelMediaObject* self, const gchar* value);
static void _vala_SoupDate_free (SoupDate* self);
#define RYGEL_IMAGE_ITEM_UPNP_CLASS "object.item.imageItem"
#define RYGEL_PHOTO_ITEM_UPNP_CLASS "object.item.imageItem.photo"
#define RYGEL_VIDEO_ITEM_UPNP_CLASS "object.item.videoItem"
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
#define RYGEL_MUSIC_ITEM_UPNP_CLASS "object.item.audioItem.musicTrack"
#define RYGEL_MEDIA_CONTAINER_UPNP_CLASS "object.container"
#define RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".storageFolder"
#define RYGEL_MEDIA_CONTAINER_PLAYLIST RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".playlistContainer"
RygelImageItem* rygel_image_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelImageItem* rygel_image_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelPhotoItem* rygel_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelPhotoItem* rygel_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_photo_item_get_type (void) G_GNUC_CONST;
RygelVideoItem* rygel_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelVideoItem* rygel_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_music_item_get_type (void) G_GNUC_CONST;
RygelPlaylistItem* rygel_playlist_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelPlaylistItem* rygel_playlist_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_playlist_item_get_type (void) G_GNUC_CONST;
void rygel_media_object_set_upnp_class (RygelMediaObject* self, const gchar* value);
static void _vala_SoupURI_free (SoupURI* self);
static gchar* rygel_object_creator_mangle_title (RygelObjectCreator* self, const gchar* title, GError** error);
static void rygel_object_creator_create_uri_data_free (gpointer _data);
static void rygel_object_creator_create_uri_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static gboolean rygel_object_creator_create_uri_co (RygelObjectCreatorCreateUriData* _data_);
void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static void rygel_object_creator_create_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_object_creator_wait_for_object_data_free (gpointer _data);
static void rygel_object_creator_wait_for_object_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static gboolean rygel_object_creator_wait_for_object_co (RygelObjectCreatorWaitForObjectData* _data_);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void rygel_object_creator_wait_for_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void ____lambda9_ (Block9Data* _data9_, RygelMediaContainer* container);
GType rygel_object_event_type_get_type (void) G_GNUC_CONST;
static void _____lambda9__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self);
static gboolean ____lambda10_ (Block9Data* _data9_);
static gboolean _____lambda10__gsource_func (gpointer self);
GType rygel_media_server_plugin_get_type (void) G_GNUC_CONST;
GList* rygel_media_server_plugin_get_upload_profiles (RygelMediaServerPlugin* self);
static gint _rygel_dlna_profile_compare_by_name_gcompare_func (gconstpointer a, gconstpointer b);
static void rygel_object_creator_finalize (GObject * obj);
static void _vala_rygel_object_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_object_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Create a media container with the specified details.
     *
     * @param id See the id property of the #RygelMediaObject class.
     * @param parent The parent container, if any.
     * @param title See the title property of the #RygelMediaObject class.
     * @param child_count The initially-known number of child items.
     */
RygelBaseMediaContainer* rygel_base_media_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count) {
	RygelBaseMediaContainer * self = NULL;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = parent;
	_tmp2_ = title;
	_tmp3_ = child_count;
	self = (RygelBaseMediaContainer*) g_object_new (object_type, "id", _tmp0_, "parent", _tmp1_, "title", _tmp2_, "child-count", _tmp3_, NULL);
	return self;
}


RygelBaseMediaContainer* rygel_base_media_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count) {
	return rygel_base_media_container_construct (RYGEL_TYPE_BASE_MEDIA_CONTAINER, id, parent, title, child_count);
}


static void rygel_base_media_container_real_get_children_data_free (gpointer _data) {
	RygelBaseMediaContainerGetChildrenData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelBaseMediaContainerGetChildrenData, _data_);
}


static void rygel_base_media_container_real_get_children_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelBaseMediaContainerGetChildrenData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_base_media_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelBaseMediaContainer * self;
	RygelBaseMediaContainerGetChildrenData* _data_;
	RygelBaseMediaContainer* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	self = (RygelBaseMediaContainer*) base;
	_data_ = g_slice_new0 (RygelBaseMediaContainerGetChildrenData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, rygel_base_media_container_real_get_children_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_base_media_container_real_get_children_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = offset;
	_data_->offset = _tmp1_;
	_tmp2_ = max_count;
	_data_->max_count = _tmp2_;
	_tmp3_ = sort_criteria;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp4_;
	_tmp5_ = cancellable;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp6_;
	rygel_base_media_container_real_get_children_co (_data_);
}


static RygelMediaObjects* rygel_base_media_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelBaseMediaContainerGetChildrenData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Fetches the list of media objects directly under this container.
     *
     * @param offset zero-based index of the first item to return
     * @param max_count maximum number of objects to return
     * @param sort_criteria sorting order of objects to return
     * @param cancellable optional cancellable for this operation
     *
     * @return A list of media objects.
     */
static gboolean rygel_base_media_container_real_get_children_co (RygelBaseMediaContainerGetChildrenData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->result = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_base_media_container_real_find_object_data_free (gpointer _data) {
	RygelBaseMediaContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelBaseMediaContainerFindObjectData, _data_);
}


static void rygel_base_media_container_real_find_object_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelBaseMediaContainerFindObjectData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void rygel_base_media_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelBaseMediaContainer * self;
	RygelBaseMediaContainerFindObjectData* _data_;
	RygelBaseMediaContainer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	self = (RygelBaseMediaContainer*) base;
	_data_ = g_slice_new0 (RygelBaseMediaContainerFindObjectData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, rygel_base_media_container_real_find_object_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_base_media_container_real_find_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_base_media_container_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_base_media_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelBaseMediaContainerFindObjectData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Recursively searches this container for a media object with the given ID.
     *
     * @param id ID of the media object to search for
     * @param cancellable optional cancellable for this operation
     *
     * @return the found media object.
     */
static gboolean rygel_base_media_container_real_find_object_co (RygelBaseMediaContainerFindObjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->result = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_base_media_container_class_init (RygelBaseMediaContainerClass * klass) {
	rygel_base_media_container_parent_class = g_type_class_peek_parent (klass);
	((RygelMediaContainerClass *) klass)->get_children = (void (*) (RygelMediaContainer *, guint, guint, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_base_media_container_real_get_children;
	((RygelMediaContainerClass *) klass)->get_children_finish = (RygelMediaObjects* (*) (RygelMediaContainer *, GAsyncResult*, GError**)) rygel_base_media_container_real_get_children_finish;
	((RygelMediaContainerClass *) klass)->find_object = (void (*) (RygelMediaContainer *, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_base_media_container_real_find_object;
	((RygelMediaContainerClass *) klass)->find_object_finish = (RygelMediaObject* (*) (RygelMediaContainer *, GAsyncResult*, GError**)) rygel_base_media_container_real_find_object_finish;
}


static void rygel_base_media_container_instance_init (RygelBaseMediaContainer * self) {
}


/**
 * Dummy implementation of Rygel.MediaContainer to pass on to
 * Rygel.WritableContianer for creation.
 */
GType rygel_base_media_container_get_type (void) {
	static volatile gsize rygel_base_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_base_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelBaseMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_base_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelBaseMediaContainer), 0, (GInstanceInitFunc) rygel_base_media_container_instance_init, NULL };
		GType rygel_base_media_container_type_id;
		rygel_base_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelBaseMediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_base_media_container_type_id__volatile, rygel_base_media_container_type_id);
	}
	return rygel_base_media_container_type_id__volatile;
}


static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self) {
	g_boxed_free (gupnp_service_action_get_type (), self);
}


RygelObjectCreator* rygel_object_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelObjectCreator * self = NULL;
	RygelContentDirectory* _tmp0_;
	RygelContentDirectory* _tmp1_;
	RygelContentDirectory* _tmp2_;
	GCancellable* _tmp3_;
	GUPnPServiceAction* _tmp4_;
	RygelSerializer* _tmp5_;
	GUPnPDIDLLiteParser* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	self = (RygelObjectCreator*) g_object_new (object_type, NULL);
	_tmp0_ = content_dir;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->content_dir);
	self->priv->content_dir = _tmp1_;
	_tmp2_ = content_dir;
	_tmp3_ = _tmp2_->cancellable;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp3_);
	_tmp4_ = action;
	action = NULL;
	__vala_GUPnPServiceAction_free0 (self->priv->action);
	self->priv->action = _tmp4_;
	_tmp5_ = rygel_serializer_new (RYGEL_SERIALIZER_TYPE_GENERIC_DIDL);
	_g_object_unref0 (self->priv->serializer);
	self->priv->serializer = _tmp5_;
	_tmp6_ = gupnp_didl_lite_parser_new ();
	_g_object_unref0 (self->priv->didl_parser);
	self->priv->didl_parser = _tmp6_;
	{
		gchar* pattern = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GRegex* _tmp13_ = NULL;
		GRegex* _tmp14_;
		GRegex* _tmp15_;
		_tmp7_ = g_regex_escape_string (RYGEL_OBJECT_CREATOR_INVALID_CHARS, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat ("[", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp10_, "]", NULL);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		pattern = _tmp12_;
		_tmp14_ = g_regex_new (pattern, G_REGEX_OPTIMIZE, G_REGEX_MATCH_NOTEMPTY, &_inner_error_);
		_tmp13_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (pattern);
			goto __catch62_g_error;
		}
		_tmp15_ = _tmp13_;
		_tmp13_ = NULL;
		_g_regex_unref0 (self->priv->title_regex);
		self->priv->title_regex = _tmp15_;
		_g_regex_unref0 (_tmp13_);
		_g_free0 (pattern);
	}
	goto __finally62;
	__catch62_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally62:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		__vala_GUPnPServiceAction_free0 (action);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	__vala_GUPnPServiceAction_free0 (action);
	return self;
}


RygelObjectCreator* rygel_object_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	return rygel_object_creator_construct (RYGEL_TYPE_OBJECT_CREATOR, content_dir, action);
}


static void rygel_object_creator_real_run_data_free (gpointer _data) {
	RygelObjectCreatorRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelObjectCreatorRunData, _data_);
}


static void rygel_object_creator_real_run_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelObjectCreatorRunData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void rygel_object_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreator * self;
	RygelObjectCreatorRunData* _data_;
	RygelObjectCreator* _tmp0_;
	self = (RygelObjectCreator*) base;
	_data_ = g_slice_new0 (RygelObjectCreatorRunData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_object_creator_real_run_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_object_creator_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_object_creator_real_run_co (_data_);
}


static void rygel_object_creator_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelObjectCreatorRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void rygel_object_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_object_creator_real_run_co (_data_);
}


static gboolean rygel_object_creator_real_run_co (RygelObjectCreatorRunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		rygel_object_creator_parse_args (_data_->self, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch63_g_error;
		}
		rygel_object_creator_parse_didl (_data_->self, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch63_g_error;
		}
		_data_->_state_ = 1;
		rygel_object_creator_fetch_container (_data_->self, rygel_object_creator_run_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = rygel_object_creator_fetch_container_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->container = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch63_g_error;
		}
		_data_->_tmp2_ = _data_->container;
		_data_->_tmp3_ = _data_->self->priv->didl_object;
		_data_->_tmp4_ = gupnp_didl_lite_object_get_upnp_class (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = rygel_writable_container_can_create (_data_->_tmp2_, _data_->_tmp5_);
		if (!_data_->_tmp6_) {
			_data_->_tmp7_ = _data_->self->priv->container_id;
			_data_->_tmp1_ = g_strcmp0 (_data_->_tmp7_, RYGEL_MEDIA_CONTAINER_ANY) != 0;
		} else {
			_data_->_tmp1_ = FALSE;
		}
		if (_data_->_tmp1_) {
			_data_->_tmp8_ = _data_->self->priv->didl_object;
			_data_->_tmp9_ = gupnp_didl_lite_object_get_upnp_class (_data_->_tmp8_);
			_data_->_tmp10_ = _data_->_tmp9_;
			_data_->_tmp11_ = _data_->container;
			_data_->_tmp12_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp11_);
			_data_->_tmp13_ = _data_->_tmp12_;
			_data_->_tmp14_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Creating of objects with class %s " "is not supported in %s", _data_->_tmp10_, _data_->_tmp13_);
			_data_->_inner_error_ = _data_->_tmp14_;
			_g_object_unref0 (_data_->container);
			goto __catch63_g_error;
		}
		_data_->_tmp16_ = _data_->self->priv->didl_object;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp16_, gupnp_didl_lite_container_get_type ())) {
			_data_->_tmp17_ = _data_->container;
			_data_->_tmp18_ = rygel_object_creator_validate_create_class (_data_->self, _data_->_tmp17_);
			_data_->_tmp15_ = !_data_->_tmp18_;
		} else {
			_data_->_tmp15_ = FALSE;
		}
		if (_data_->_tmp15_) {
			_data_->_tmp19_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _ ("upnp:createClass value not supported"));
			_data_->_inner_error_ = _data_->_tmp19_;
			_g_object_unref0 (_data_->container);
			goto __catch63_g_error;
		}
		_data_->_tmp20_ = _data_->container;
		_data_->_state_ = 2;
		rygel_object_creator_create_object_from_didl (_data_->self, _data_->_tmp20_, rygel_object_creator_run_ready, _data_);
		return FALSE;
		_state_2:
		rygel_object_creator_create_object_from_didl_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->container);
			goto __catch63_g_error;
		}
		_data_->_tmp21_ = _data_->self->priv->object;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp21_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
			_data_->_tmp22_ = _data_->container;
			_data_->_tmp23_ = _data_->self->priv->object;
			_data_->_tmp24_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
			_data_->_tmp25_ = _data_->_tmp24_;
			_data_->_state_ = 3;
			rygel_writable_container_add_item (_data_->_tmp22_, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp23_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp23_) : NULL, _data_->_tmp25_, rygel_object_creator_run_ready, _data_);
			return FALSE;
			_state_3:
			rygel_writable_container_add_item_finish (_data_->_tmp22_, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_object_unref0 (_data_->container);
				goto __catch63_g_error;
			}
		} else {
			_data_->_tmp26_ = _data_->container;
			_data_->_tmp27_ = _data_->self->priv->object;
			_data_->_tmp28_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
			_data_->_tmp29_ = _data_->_tmp28_;
			_data_->_state_ = 4;
			rygel_writable_container_add_container (_data_->_tmp26_, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp27_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _data_->_tmp27_) : NULL, _data_->_tmp29_, rygel_object_creator_run_ready, _data_);
			return FALSE;
			_state_4:
			rygel_writable_container_add_container_finish (_data_->_tmp26_, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_object_unref0 (_data_->container);
				goto __catch63_g_error;
			}
		}
		_data_->_tmp30_ = _data_->container;
		_data_->_state_ = 5;
		rygel_object_creator_wait_for_object (_data_->self, _data_->_tmp30_, rygel_object_creator_run_ready, _data_);
		return FALSE;
		_state_5:
		rygel_object_creator_wait_for_object_finish (_data_->self, _data_->_res_);
		_data_->_tmp31_ = _data_->self->priv->object;
		_data_->_tmp32_ = _data_->self->priv->serializer;
		_data_->_tmp33_ = _data_->self->priv->content_dir;
		_data_->_tmp34_ = _data_->_tmp33_->http_server;
		_data_->_tmp35_ = rygel_media_object_serialize (_data_->_tmp31_, _data_->_tmp32_, _data_->_tmp34_, &_data_->_inner_error_);
		_data_->_tmp36_ = _data_->_tmp35_;
		_g_object_unref0 (_data_->_tmp36_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->container);
			goto __catch63_g_error;
		}
		rygel_object_creator_conclude (_data_->self);
		_data_->_tmp38_ = _data_->self->priv->container_id;
		if (g_strcmp0 (_data_->_tmp38_, RYGEL_MEDIA_CONTAINER_ANY) == 0) {
			_data_->_tmp40_ = _data_->self->priv->object;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp40_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
				_data_->_tmp41_ = _data_->self->priv->object;
				_data_->_tmp42_ = rygel_media_file_item_get_place_holder (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp41_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp41_) : NULL);
				_data_->_tmp43_ = _data_->_tmp42_;
				_data_->_tmp39_ = _data_->_tmp43_;
			} else {
				_data_->_tmp39_ = FALSE;
			}
			_data_->_tmp37_ = _data_->_tmp39_;
		} else {
			_data_->_tmp37_ = FALSE;
		}
		if (_data_->_tmp37_) {
			_data_->_tmp44_ = rygel_object_removal_queue_get_default ();
			_data_->queue = _data_->_tmp44_;
			_data_->_tmp45_ = _data_->queue;
			_data_->_tmp46_ = _data_->self->priv->object;
			_data_->_tmp47_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
			_data_->_tmp48_ = _data_->_tmp47_;
			rygel_object_removal_queue_queue (_data_->_tmp45_, _data_->_tmp46_, _data_->_tmp48_);
			_g_object_unref0 (_data_->queue);
		}
		_g_object_unref0 (_data_->container);
	}
	goto __finally63;
	__catch63_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp49_ = _data_->err;
		rygel_object_creator_handle_error (_data_->self, _data_->_tmp49_);
		_g_error_free0 (_data_->err);
	}
	__finally63:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Check the supplied input parameters.
     */
static void rygel_object_creator_parse_args (RygelObjectCreator* self, GError** error) {
	GUPnPServiceAction* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->action;
	gupnp_service_action_get (_tmp0_, "ContainerID", G_TYPE_STRING, &self->priv->container_id, "Elements", G_TYPE_STRING, &self->priv->elements, NULL);
	_tmp1_ = self->priv->elements;
	if (_tmp1_ == NULL) {
		GError* _tmp2_;
		_tmp2_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _ ("“Elements” argument missing."));
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return;
	} else {
		GPatternSpec* _tmp3_;
		const gchar* _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = rygel_object_creator_comment_pattern;
		_tmp4_ = self->priv->elements;
		_tmp5_ = g_pattern_match_string (_tmp3_, _tmp4_);
		if (_tmp5_) {
			GError* _tmp6_;
			_tmp6_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _ ("Comments not allowed in XML"));
			_inner_error_ = _tmp6_;
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	_tmp7_ = self->priv->container_id;
	if (_tmp7_ == NULL) {
		GError* _tmp8_;
		_tmp8_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _ ("Missing ContainerID argument"));
		_inner_error_ = _tmp8_;
		g_propagate_error (error, _inner_error_);
		return;
	}
}


/**
     * Parse the given DIDL-Lite snippet.
     *
     * Parses the DIDL-Lite and performs checking of the passed meta-data
     * according to UPnP and DLNA guidelines.
     */
static void __lambda8_ (RygelObjectCreator* self, GUPnPDIDLLiteObject* didl_object) {
	GUPnPDIDLLiteObject* _tmp0_;
	GUPnPDIDLLiteObject* _tmp1_;
	g_return_if_fail (didl_object != NULL);
	_tmp0_ = didl_object;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->didl_object);
	self->priv->didl_object = _tmp1_;
}


static void ___lambda8__gupnp_didl_lite_parser_object_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteObject* object, gpointer self) {
	__lambda8_ ((RygelObjectCreator*) self, object);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void rygel_object_creator_parse_didl (RygelObjectCreator* self, GError** error) {
	GUPnPDIDLLiteParser* _tmp0_;
	GUPnPDIDLLiteObject* _tmp4_;
	gboolean _tmp9_ = FALSE;
	GUPnPDIDLLiteObject* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GUPnPDIDLLiteObject* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gboolean _tmp25_ = FALSE;
	GUPnPDIDLLiteObject* _tmp26_;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	GUPnPDIDLLiteObject* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	GUPnPDIDLLiteObject* _tmp46_;
	gboolean _tmp47_;
	GUPnPDIDLLiteObject* _tmp51_;
	gboolean _tmp52_;
	gboolean _tmp53_;
	GUPnPDIDLLiteObject* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->didl_parser;
	g_signal_connect_object (_tmp0_, "object-available", (GCallback) ___lambda8__gupnp_didl_lite_parser_object_available, self, 0);
	{
		GUPnPDIDLLiteParser* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->didl_parser;
		_tmp2_ = self->priv->elements;
		gupnp_didl_lite_parser_parse_didl (_tmp1_, _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch64_g_error;
		}
	}
	goto __finally64;
	__catch64_g_error:
	{
		GError* parse_err = NULL;
		GError* _tmp3_;
		parse_err = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Bad metadata");
		_inner_error_ = _tmp3_;
		_g_error_free0 (parse_err);
		goto __finally64;
	}
	__finally64:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp4_ = self->priv->didl_object;
	if (_tmp4_ == NULL) {
		gchar* message = NULL;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp8_;
		_tmp5_ = g_strdup (_ ("No objects in DIDL-Lite from client: “%s”"));
		message = _tmp5_;
		_tmp6_ = message;
		_tmp7_ = self->priv->elements;
		_tmp8_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp6_, _tmp7_);
		_inner_error_ = _tmp8_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (message);
		return;
	}
	_tmp10_ = self->priv->didl_object;
	_tmp11_ = gupnp_didl_lite_object_get_id (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == NULL) {
		_tmp9_ = TRUE;
	} else {
		GUPnPDIDLLiteObject* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp13_ = self->priv->didl_object;
		_tmp14_ = gupnp_didl_lite_object_get_id (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp9_ = g_strcmp0 (_tmp15_, "") != 0;
	}
	if (_tmp9_) {
		gchar* msg = NULL;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		GError* _tmp18_;
		_tmp16_ = g_strdup (_ ("@id must be set to \"\" in CreateObject call"));
		msg = _tmp16_;
		_tmp17_ = msg;
		_tmp18_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp17_);
		_inner_error_ = _tmp18_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		return;
	}
	_tmp19_ = self->priv->didl_object;
	_tmp20_ = gupnp_didl_lite_object_get_title (_tmp19_);
	_tmp21_ = _tmp20_;
	if (_tmp21_ == NULL) {
		gchar* msg = NULL;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		GError* _tmp24_;
		_tmp22_ = g_strdup (_ ("dc:title must not be empty in CreateObject call"));
		msg = _tmp22_;
		_tmp23_ = msg;
		_tmp24_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp23_);
		_inner_error_ = _tmp24_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		return;
	}
	_tmp26_ = self->priv->didl_object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, gupnp_didl_lite_item_get_type ())) {
		GUPnPDIDLLiteObject* _tmp27_;
		GUPnPOCMFlags _tmp28_;
		GUPnPOCMFlags _tmp29_;
		_tmp27_ = self->priv->didl_object;
		_tmp28_ = gupnp_didl_lite_object_get_dlna_managed (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp25_ = (_tmp29_ & ((GUPNP_OCM_FLAGS_UPLOAD | GUPNP_OCM_FLAGS_CREATE_CONTAINER) | GUPNP_OCM_FLAGS_UPLOAD_DESTROYABLE)) != 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		gchar* msg = NULL;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		GError* _tmp32_;
		_tmp30_ = g_strdup (_ ("Flags that must not be set were found in “dlnaManaged”"));
		msg = _tmp30_;
		_tmp31_ = msg;
		_tmp32_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp31_);
		_inner_error_ = _tmp32_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		return;
	}
	_tmp35_ = self->priv->didl_object;
	_tmp36_ = gupnp_didl_lite_object_get_upnp_class (_tmp35_);
	_tmp37_ = _tmp36_;
	if (_tmp37_ == NULL) {
		_tmp34_ = TRUE;
	} else {
		GUPnPDIDLLiteObject* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		_tmp38_ = self->priv->didl_object;
		_tmp39_ = gupnp_didl_lite_object_get_upnp_class (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp34_ = g_strcmp0 (_tmp40_, "") == 0;
	}
	if (_tmp34_) {
		_tmp33_ = TRUE;
	} else {
		GUPnPDIDLLiteObject* _tmp41_;
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		gboolean _tmp44_;
		_tmp41_ = self->priv->didl_object;
		_tmp42_ = gupnp_didl_lite_object_get_upnp_class (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_str_has_prefix (_tmp43_, "object");
		_tmp33_ = !_tmp44_;
	}
	if (_tmp33_) {
		GError* _tmp45_;
		_tmp45_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _ ("Invalid upnp:class given in CreateObject"));
		_inner_error_ = _tmp45_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp46_ = self->priv->didl_object;
	_tmp47_ = gupnp_didl_lite_object_is_restricted_set (_tmp46_);
	if (!_tmp47_) {
		gchar* msg = NULL;
		gchar* _tmp48_;
		const gchar* _tmp49_;
		GError* _tmp50_;
		_tmp48_ = g_strdup (_ ("Object is missing the @restricted attribute"));
		msg = _tmp48_;
		_tmp49_ = msg;
		_tmp50_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp49_);
		_inner_error_ = _tmp50_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		return;
	}
	_tmp51_ = self->priv->didl_object;
	_tmp52_ = gupnp_didl_lite_object_get_restricted (_tmp51_);
	_tmp53_ = _tmp52_;
	if (_tmp53_) {
		GError* _tmp54_;
		_tmp54_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _ ("Cannot create restricted item"));
		_inner_error_ = _tmp54_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp55_ = self->priv->didl_object;
	_tmp56_ = gupnp_didl_lite_object_get_upnp_class (_tmp55_);
	_tmp57_ = _tmp56_;
	if (g_strcmp0 (_tmp57_, "object.item") == 0) {
		GList* resources = NULL;
		GUPnPDIDLLiteObject* _tmp58_;
		GList* _tmp59_;
		gboolean _tmp60_ = FALSE;
		GList* _tmp61_;
		_tmp58_ = self->priv->didl_object;
		_tmp59_ = gupnp_didl_lite_object_get_resources (_tmp58_);
		resources = _tmp59_;
		_tmp61_ = resources;
		if (_tmp61_ != NULL) {
			GList* _tmp62_;
			gconstpointer _tmp63_;
			GUPnPProtocolInfo* _tmp64_;
			GUPnPProtocolInfo* _tmp65_;
			const gchar* _tmp66_;
			const gchar* _tmp67_;
			_tmp62_ = resources;
			_tmp63_ = _tmp62_->data;
			_tmp64_ = gupnp_didl_lite_resource_get_protocol_info ((GUPnPDIDLLiteResource*) _tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = gupnp_protocol_info_get_dlna_profile (_tmp65_);
			_tmp67_ = _tmp66_;
			_tmp60_ = g_strcmp0 (_tmp67_, "DIDL_S") == 0;
		} else {
			_tmp60_ = FALSE;
		}
		if (_tmp60_) {
			GUPnPDIDLLiteObject* _tmp68_;
			_tmp68_ = self->priv->didl_object;
			gupnp_didl_lite_object_set_upnp_class (_tmp68_, RYGEL_PLAYLIST_ITEM_UPNP_CLASS);
		}
		__g_list_free__g_object_unref0_0 (resources);
	}
}


/**
     * Modify the give UPnP class to be a more general one.
     *
     * Used to simplify the search for a valid container in the
     * DLNA.ORG_AnyContainer use-case.
     * Example: object.item.videoItem.videoBroadcast → object.item.videoItem
     *
     * @param upnp_class the current UPnP class which will be modified in-place.
     */
static void rygel_object_creator_generalize_upnp_class (RygelObjectCreator* self, gchar* * upnp_class) {
	gchar* needle = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*upnp_class != NULL);
	_tmp0_ = *upnp_class;
	_tmp1_ = g_strrstr_len (_tmp0_, (gssize) -1, ".");
	needle = _tmp1_;
	_tmp2_ = needle;
	if (_tmp2_ != NULL) {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = needle;
		*_tmp3_ = '\0';
		_tmp4_ = *_tmp3_;
	}
}


static void rygel_object_creator_build_create_class_expression_data_free (gpointer _data) {
	RygelObjectCreatorBuildCreateClassExpressionData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_rygel_search_expression_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelObjectCreatorBuildCreateClassExpressionData, _data_);
}


static void rygel_object_creator_build_create_class_expression_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelObjectCreatorBuildCreateClassExpressionData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_object_creator_build_create_class_expression (RygelObjectCreator* self, RygelSearchExpression* expression, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorBuildCreateClassExpressionData* _data_;
	RygelObjectCreator* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	_data_ = g_slice_new0 (RygelObjectCreatorBuildCreateClassExpressionData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_object_creator_build_create_class_expression_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_object_creator_build_create_class_expression_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = expression;
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
	_rygel_search_expression_unref0 (_data_->expression);
	_data_->expression = _tmp2_;
	rygel_object_creator_build_create_class_expression_co (_data_);
}


static RygelSearchExpression* rygel_object_creator_build_create_class_expression_finish (RygelObjectCreator* self, GAsyncResult* _res_) {
	RygelSearchExpression* result;
	RygelObjectCreatorBuildCreateClassExpressionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void rygel_object_creator_build_create_class_expression_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorBuildCreateClassExpressionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_object_creator_build_create_class_expression_co (_data_);
}


static gboolean rygel_object_creator_build_create_class_expression_co (RygelObjectCreatorBuildCreateClassExpressionData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->didl_object;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp0_, gupnp_didl_lite_container_get_type ())) {
		_data_->_tmp1_ = _data_->expression;
		_data_->_tmp2_ = _rygel_search_expression_ref0 (_data_->_tmp1_);
		_data_->result = _data_->_tmp2_;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->self->priv->didl_object;
	_data_->_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp3_, gupnp_didl_lite_container_get_type ()) ? ((GUPnPDIDLLiteContainer*) _data_->_tmp3_) : NULL);
	_data_->didl_container = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->didl_container;
	_data_->_tmp6_ = gupnp_didl_lite_container_get_create_classes (_data_->_tmp5_);
	_data_->create_classes = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->create_classes;
	if (_data_->_tmp7_ == NULL) {
		_data_->_tmp8_ = _data_->expression;
		_data_->_tmp9_ = _rygel_search_expression_ref0 (_data_->_tmp8_);
		_data_->result = _data_->_tmp9_;
		__g_list_free__g_free0_0 (_data_->create_classes);
		_g_object_unref0 (_data_->didl_container);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = g_string_new ("(");
	_data_->builder = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->create_classes;
	{
		_data_->create_class_collection = _data_->_tmp11_;
		for (_data_->create_class_it = _data_->create_class_collection; _data_->create_class_it != NULL; _data_->create_class_it = _data_->create_class_it->next) {
			_data_->_tmp12_ = g_strdup ((const gchar*) _data_->create_class_it->data);
			_data_->create_class = _data_->_tmp12_;
			{
				_data_->_tmp13_ = _data_->builder;
				_data_->_tmp14_ = _data_->create_class;
				g_string_append_printf (_data_->_tmp13_, "(upnp:createClass derivedfrom \"%s\") AND", _data_->_tmp14_);
				_g_free0 (_data_->create_class);
			}
		}
	}
	_data_->_tmp15_ = _data_->builder;
	_data_->_tmp16_ = _data_->builder;
	_data_->_tmp17_ = _data_->_tmp16_->len;
	g_string_truncate (_data_->_tmp15_, (gsize) (_data_->_tmp17_ - 3));
	_data_->_tmp18_ = _data_->builder;
	g_string_append (_data_->_tmp18_, ")");
	{
		_data_->_tmp19_ = _data_->builder;
		_data_->_tmp20_ = _data_->_tmp19_->str;
		_data_->_tmp21_ = rygel_search_criteria_parser_new (_data_->_tmp20_, &_data_->_inner_error_);
		_data_->parser = _data_->_tmp21_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch65_g_error;
		}
		_data_->_tmp22_ = _data_->parser;
		_data_->_state_ = 1;
		rygel_state_machine_run ((RygelStateMachine*) _data_->_tmp22_, rygel_object_creator_build_create_class_expression_ready, _data_);
		return FALSE;
		_state_1:
		rygel_state_machine_run_finish ((RygelStateMachine*) _data_->_tmp22_, _data_->_res_);
		_data_->_tmp23_ = rygel_logical_expression_new ();
		_data_->rel = _data_->_tmp23_;
		_data_->_tmp24_ = _data_->rel;
		_data_->_tmp25_ = _data_->expression;
		_data_->_tmp26_ = _rygel_search_expression_ref0 (_data_->_tmp25_);
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _data_->_tmp24_)->operand1);
		((RygelSearchExpression*) _data_->_tmp24_)->operand1 = _data_->_tmp26_;
		_data_->_tmp27_ = _data_->rel;
		((RygelSearchExpression*) _data_->_tmp27_)->op = (gpointer) ((gintptr) RYGEL_LOGICAL_OPERATOR_AND);
		_data_->_tmp28_ = _data_->rel;
		_data_->_tmp29_ = _data_->parser;
		_data_->_tmp30_ = _data_->_tmp29_->expression;
		_data_->_tmp31_ = _rygel_search_expression_ref0 (_data_->_tmp30_);
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _data_->_tmp28_)->operand2);
		((RygelSearchExpression*) _data_->_tmp28_)->operand2 = _data_->_tmp31_;
		_data_->result = (RygelSearchExpression*) _data_->rel;
		_g_object_unref0 (_data_->parser);
		_g_string_free0 (_data_->builder);
		__g_list_free__g_free0_0 (_data_->create_classes);
		_g_object_unref0 (_data_->didl_container);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally65;
	__catch65_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_data_->_error_);
	}
	__finally65:
	_g_string_free0 (_data_->builder);
	__g_list_free__g_free0_0 (_data_->create_classes);
	_g_object_unref0 (_data_->didl_container);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
	g_clear_error (&_data_->_inner_error_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_object_creator_find_any_container_data_free (gpointer _data) {
	RygelObjectCreatorFindAnyContainerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelObjectCreatorFindAnyContainerData, _data_);
}


static void rygel_object_creator_find_any_container_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelObjectCreatorFindAnyContainerData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void rygel_object_creator_find_any_container (RygelObjectCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorFindAnyContainerData* _data_;
	RygelObjectCreator* _tmp0_;
	_data_ = g_slice_new0 (RygelObjectCreatorFindAnyContainerData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_object_creator_find_any_container_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_object_creator_find_any_container_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_object_creator_find_any_container_co (_data_);
}


static RygelMediaObject* rygel_object_creator_find_any_container_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelObjectCreatorFindAnyContainerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Find a container that can create items matching the UPnP class of the
     * requested item.
     *
     * If the item's UPnP class cannot be found, generalize the UPnP class until
     * we reach object.item according to DLNA guideline 7.3.120.4.
     *
     * @returns a container able to create the item or null if no such container
     *          can be found.
     */
static void rygel_object_creator_find_any_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorFindAnyContainerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_object_creator_find_any_container_co (_data_);
}


static gboolean rygel_object_creator_find_any_container_co (RygelObjectCreatorFindAnyContainerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->content_dir;
	_data_->_tmp1_ = _data_->_tmp0_->root_container;
	_data_->_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) _data_->_tmp1_) : NULL);
	_data_->root_container = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->root_container;
	if (_data_->_tmp3_ == NULL) {
		_data_->result = NULL;
		_g_object_unref0 (_data_->root_container);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->didl_object;
	_data_->_tmp5_ = gupnp_didl_lite_object_get_upnp_class (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
	_data_->upnp_class = _data_->_tmp7_;
	_data_->_tmp8_ = rygel_relational_expression_new ();
	_data_->expression = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->expression;
	((RygelSearchExpression*) _data_->_tmp9_)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM);
	_data_->_tmp10_ = _data_->expression;
	_data_->_tmp11_ = g_strdup ("upnp:createClass");
	_g_free0 (((RygelSearchExpression*) _data_->_tmp10_)->operand1);
	((RygelSearchExpression*) _data_->_tmp10_)->operand1 = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->expression;
	_data_->_state_ = 1;
	rygel_object_creator_build_create_class_expression (_data_->self, (RygelSearchExpression*) _data_->_tmp12_, rygel_object_creator_find_any_container_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp13_ = rygel_object_creator_build_create_class_expression_finish (_data_->self, _data_->_res_);
	_data_->search_expression = _data_->_tmp13_;
	while (TRUE) {
		_data_->_tmp14_ = _data_->upnp_class;
		if (!(g_strcmp0 (_data_->_tmp14_, "object") != 0)) {
			break;
		}
		_data_->_tmp15_ = _data_->expression;
		_data_->_tmp16_ = _data_->upnp_class;
		_data_->_tmp17_ = g_strdup (_data_->_tmp16_);
		_g_free0 (((RygelSearchExpression*) _data_->_tmp15_)->operand2);
		((RygelSearchExpression*) _data_->_tmp15_)->operand2 = _data_->_tmp17_;
		_data_->_tmp18_ = _data_->root_container;
		_data_->_tmp19_ = _data_->search_expression;
		_data_->_tmp20_ = _data_->root_container;
		_data_->_tmp21_ = rygel_media_container_get_sort_criteria ((RygelMediaContainer*) _data_->_tmp20_);
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp24_ = _data_->_tmp23_;
		_data_->_tmp25_ = 0U;
		_data_->_state_ = 2;
		rygel_searchable_container_search (_data_->_tmp18_, _data_->_tmp19_, (guint) 0, (guint) 1, _data_->_tmp22_, _data_->_tmp24_, rygel_object_creator_find_any_container_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp26_ = rygel_searchable_container_search_finish (_data_->_tmp18_, _data_->_res_, &_data_->_tmp25_, &_data_->_inner_error_);
		_data_->total_matches = _data_->_tmp25_;
		_data_->_result_ = _data_->_tmp26_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_rygel_search_expression_unref0 (_data_->search_expression);
			_rygel_search_expression_unref0 (_data_->expression);
			_g_free0 (_data_->upnp_class);
			_g_object_unref0 (_data_->root_container);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp27_ = _data_->_result_;
		_data_->_tmp28_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp27_);
		_data_->_tmp29_ = _data_->_tmp28_;
		if (_data_->_tmp29_ > 0) {
			_data_->_tmp30_ = _data_->self->priv->didl_object;
			_data_->_tmp31_ = _data_->upnp_class;
			gupnp_didl_lite_object_set_upnp_class (_data_->_tmp30_, _data_->_tmp31_);
			_data_->_tmp32_ = _data_->_result_;
			_data_->_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp32_, 0);
			_data_->result = (RygelMediaObject*) _data_->_tmp33_;
			_g_object_unref0 (_data_->_result_);
			_rygel_search_expression_unref0 (_data_->search_expression);
			_rygel_search_expression_unref0 (_data_->expression);
			_g_free0 (_data_->upnp_class);
			_g_object_unref0 (_data_->root_container);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (_data_->_task_complete_ != TRUE) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			rygel_object_creator_generalize_upnp_class (_data_->self, &_data_->upnp_class);
		}
		_g_object_unref0 (_data_->_result_);
	}
	_data_->_tmp34_ = _data_->upnp_class;
	if (g_strcmp0 (_data_->_tmp34_, "object") == 0) {
		_data_->_tmp35_ = _data_->self->priv->didl_object;
		_data_->_tmp36_ = gupnp_didl_lite_object_get_upnp_class (_data_->_tmp35_);
		_data_->_tmp37_ = _data_->_tmp36_;
		_data_->_tmp38_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _ ("UPnP class “%s” not supported"), _data_->_tmp37_);
		_data_->_inner_error_ = _data_->_tmp38_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_rygel_search_expression_unref0 (_data_->search_expression);
		_rygel_search_expression_unref0 (_data_->expression);
		_g_free0 (_data_->upnp_class);
		_g_object_unref0 (_data_->root_container);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = NULL;
	_rygel_search_expression_unref0 (_data_->search_expression);
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->upnp_class);
	_g_object_unref0 (_data_->root_container);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_object_creator_fetch_container_data_free (gpointer _data) {
	RygelObjectCreatorFetchContainerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelObjectCreatorFetchContainerData, _data_);
}


static void rygel_object_creator_fetch_container_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelObjectCreatorFetchContainerData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void rygel_object_creator_fetch_container (RygelObjectCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorFetchContainerData* _data_;
	RygelObjectCreator* _tmp0_;
	_data_ = g_slice_new0 (RygelObjectCreatorFetchContainerData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_object_creator_fetch_container_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_object_creator_fetch_container_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_object_creator_fetch_container_co (_data_);
}


static RygelWritableContainer* rygel_object_creator_fetch_container_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error) {
	RygelWritableContainer* result;
	RygelObjectCreatorFetchContainerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Get the container to create the item in.
     *
     * This will either try to fetch the container supplied by the caller or
     * search for a container if the caller supplied the "DLNA.ORG_AnyContainer"
     * id.
     *
     * @return an instance of WritableContainer matching the criteria
     * @throws ContentDirectoryError for various problems
     */
static void rygel_object_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorFetchContainerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_object_creator_fetch_container_co (_data_);
}


static gboolean rygel_object_creator_fetch_container_co (RygelObjectCreatorFetchContainerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->media_object = NULL;
	_data_->_tmp0_ = _data_->self->priv->container_id;
	if (g_strcmp0 (_data_->_tmp0_, RYGEL_MEDIA_CONTAINER_ANY) == 0) {
		_data_->_state_ = 1;
		rygel_object_creator_find_any_container (_data_->self, rygel_object_creator_fetch_container_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = rygel_object_creator_find_any_container_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp1_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_g_object_unref0 (_data_->media_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp3_ = _data_->_tmp1_;
		_data_->_tmp1_ = NULL;
		_g_object_unref0 (_data_->media_object);
		_data_->media_object = _data_->_tmp3_;
		_g_object_unref0 (_data_->_tmp1_);
	} else {
		_data_->_tmp5_ = _data_->self->priv->content_dir;
		_data_->_tmp6_ = _data_->_tmp5_->root_container;
		_data_->_tmp7_ = _data_->self->priv->container_id;
		_data_->_tmp8_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_state_ = 2;
		rygel_media_container_find_object (_data_->_tmp6_, _data_->_tmp7_, _data_->_tmp9_, rygel_object_creator_fetch_container_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp10_ = rygel_media_container_find_object_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp4_ = _data_->_tmp10_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_g_object_unref0 (_data_->media_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp11_ = _data_->_tmp4_;
		_data_->_tmp4_ = NULL;
		_g_object_unref0 (_data_->media_object);
		_data_->media_object = _data_->_tmp11_;
		_g_object_unref0 (_data_->_tmp4_);
	}
	_data_->_tmp13_ = _data_->media_object;
	if (_data_->_tmp13_ == NULL) {
		_data_->_tmp12_ = TRUE;
	} else {
		_data_->_tmp14_ = _data_->media_object;
		_data_->_tmp12_ = !G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp14_, RYGEL_TYPE_MEDIA_CONTAINER);
	}
	if (_data_->_tmp12_) {
		_data_->_tmp15_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER, _ ("No such container"));
		_data_->_inner_error_ = _data_->_tmp15_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_object_unref0 (_data_->media_object);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp16_ = _data_->media_object;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp16_, RYGEL_TYPE_WRITABLE_CONTAINER)) {
		_data_->_tmp17_ = _data_->media_object;
		_data_->_tmp18_ = rygel_media_object_get_id (_data_->_tmp17_);
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_tmp20_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _ ("Object creation in %s not allowed"), _data_->_tmp19_);
		_data_->_inner_error_ = _data_->_tmp20_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_object_unref0 (_data_->media_object);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp23_ = _data_->self->priv->didl_object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp23_, gupnp_didl_lite_item_get_type ())) {
		_data_->_tmp24_ = _data_->media_object;
		_data_->_tmp25_ = rygel_media_object_get_ocm_flags (_data_->_tmp24_);
		_data_->_tmp26_ = _data_->_tmp25_;
		_data_->_tmp22_ = (_data_->_tmp26_ & GUPNP_OCM_FLAGS_UPLOAD) == GUPNP_OCM_FLAGS_UPLOAD;
	} else {
		_data_->_tmp22_ = FALSE;
	}
	if (_data_->_tmp22_) {
		_data_->_tmp21_ = TRUE;
	} else {
		_data_->_tmp28_ = _data_->self->priv->didl_object;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp28_, gupnp_didl_lite_container_get_type ())) {
			_data_->_tmp29_ = _data_->media_object;
			_data_->_tmp30_ = rygel_media_object_get_ocm_flags (_data_->_tmp29_);
			_data_->_tmp31_ = _data_->_tmp30_;
			_data_->_tmp27_ = (_data_->_tmp31_ & GUPNP_OCM_FLAGS_CREATE_CONTAINER) == GUPNP_OCM_FLAGS_CREATE_CONTAINER;
		} else {
			_data_->_tmp27_ = FALSE;
		}
		_data_->_tmp21_ = _data_->_tmp27_;
	}
	if (!_data_->_tmp21_) {
		_data_->_tmp32_ = _data_->media_object;
		_data_->_tmp33_ = rygel_media_object_get_id (_data_->_tmp32_);
		_data_->_tmp34_ = _data_->_tmp33_;
		_data_->_tmp35_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _ ("Object creation in %s not allowed"), _data_->_tmp34_);
		_data_->_inner_error_ = _data_->_tmp35_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_object_unref0 (_data_->media_object);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp36_ = _data_->media_object;
	_data_->_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp36_, RYGEL_TYPE_WRITABLE_CONTAINER) ? ((RygelWritableContainer*) _data_->_tmp36_) : NULL);
	_data_->result = _data_->_tmp37_;
	_g_object_unref0 (_data_->media_object);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_object_creator_conclude (RygelObjectCreator* self) {
	gchar* didl = NULL;
	RygelSerializer* _tmp0_;
	gchar* _tmp1_;
	GUPnPServiceAction* _tmp2_;
	RygelMediaObject* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GUPnPServiceAction* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->serializer;
	_tmp1_ = rygel_serializer_get_string (_tmp0_);
	didl = _tmp1_;
	_tmp2_ = self->priv->action;
	_tmp3_ = self->priv->object;
	_tmp4_ = rygel_media_object_get_id (_tmp3_);
	_tmp5_ = _tmp4_;
	gupnp_service_action_set (_tmp2_, "ObjectID", G_TYPE_STRING, _tmp5_, "Result", G_TYPE_STRING, didl, NULL);
	_tmp6_ = self->priv->action;
	gupnp_service_action_return (_tmp6_);
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
	_g_free0 (didl);
}


static gboolean rygel_object_creator_validate_create_class (RygelObjectCreator* self, RygelWritableContainer* container) {
	gboolean result = FALSE;
	GUPnPDIDLLiteContainer* didl_cont = NULL;
	GUPnPDIDLLiteObject* _tmp0_;
	GUPnPDIDLLiteContainer* _tmp1_;
	GList* create_classes = NULL;
	GUPnPDIDLLiteContainer* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (container != NULL, FALSE);
	_tmp0_ = self->priv->didl_object;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gupnp_didl_lite_container_get_type ()) ? ((GUPnPDIDLLiteContainer*) _tmp0_) : NULL);
	didl_cont = _tmp1_;
	_tmp2_ = didl_cont;
	_tmp3_ = gupnp_didl_lite_container_get_create_classes (_tmp2_);
	create_classes = _tmp3_;
	_tmp4_ = create_classes;
	if (_tmp4_ == NULL) {
		result = TRUE;
		__g_list_free__g_free0_0 (create_classes);
		_g_object_unref0 (didl_cont);
		return result;
	}
	_tmp5_ = create_classes;
	{
		GList* create_class_collection = NULL;
		GList* create_class_it = NULL;
		create_class_collection = _tmp5_;
		for (create_class_it = create_class_collection; create_class_it != NULL; create_class_it = create_class_it->next) {
			gchar* _tmp6_;
			gchar* create_class = NULL;
			_tmp6_ = g_strdup ((const gchar*) create_class_it->data);
			create_class = _tmp6_;
			{
				RygelWritableContainer* _tmp7_;
				const gchar* _tmp8_;
				gboolean _tmp9_;
				_tmp7_ = container;
				_tmp8_ = create_class;
				_tmp9_ = rygel_writable_container_can_create (_tmp7_, _tmp8_);
				if (!_tmp9_) {
					result = FALSE;
					_g_free0 (create_class);
					__g_list_free__g_free0_0 (create_classes);
					_g_object_unref0 (didl_cont);
					return result;
				}
				_g_free0 (create_class);
			}
		}
	}
	result = TRUE;
	__g_list_free__g_free0_0 (create_classes);
	_g_object_unref0 (didl_cont);
	return result;
}


static void rygel_object_creator_handle_error (RygelObjectCreator* self, GError* _error_) {
	GError* _tmp0_;
	const gchar* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _error_;
	if (_tmp0_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
		GUPnPServiceAction* _tmp1_;
		GError* _tmp2_;
		gint _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_tmp1_ = self->priv->action;
		_tmp2_ = _error_;
		_tmp3_ = _tmp2_->code;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		gupnp_service_action_return_error (_tmp1_, (guint) _tmp3_, _tmp5_);
	} else {
		GUPnPServiceAction* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = self->priv->action;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		gupnp_service_action_return_error (_tmp6_, (guint) 701, _tmp8_);
	}
	_tmp9_ = self->priv->container_id;
	_tmp10_ = _error_;
	_tmp11_ = _tmp10_->message;
	g_warning (_ ("Failed to create item under “%s”: %s"), _tmp9_, _tmp11_);
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
}


static gchar* rygel_object_creator_get_generic_mime_type (RygelObjectCreator* self) {
	gchar* result = NULL;
	RygelMediaObject* _tmp0_;
	RygelMediaFileItem* item = NULL;
	RygelMediaObject* _tmp2_;
	RygelMediaFileItem* _tmp3_;
	RygelMediaFileItem* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->object;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp2_) : NULL);
	item = _tmp3_;
	_tmp4_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_IMAGE_ITEM)) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("image");
		result = _tmp5_;
		_g_object_unref0 (item);
		return result;
	} else {
		RygelMediaFileItem* _tmp6_;
		_tmp6_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, RYGEL_TYPE_VIDEO_ITEM)) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("video");
			result = _tmp7_;
			_g_object_unref0 (item);
			return result;
		} else {
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("audio");
			result = _tmp8_;
			_g_object_unref0 (item);
			return result;
		}
	}
	_g_object_unref0 (item);
}


static void rygel_object_creator_create_object_from_didl_data_free (gpointer _data) {
	RygelObjectCreatorCreateObjectFromDidlData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->container);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelObjectCreatorCreateObjectFromDidlData, _data_);
}


static void rygel_object_creator_create_object_from_didl_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelObjectCreatorCreateObjectFromDidlData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void rygel_object_creator_create_object_from_didl (RygelObjectCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorCreateObjectFromDidlData* _data_;
	RygelObjectCreator* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* _tmp2_;
	_data_ = g_slice_new0 (RygelObjectCreatorCreateObjectFromDidlData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_object_creator_create_object_from_didl_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_object_creator_create_object_from_didl_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = container;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->container);
	_data_->container = _tmp2_;
	rygel_object_creator_create_object_from_didl_co (_data_);
}


static void rygel_object_creator_create_object_from_didl_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error) {
	RygelObjectCreatorCreateObjectFromDidlData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


/**
     * Transfer information passed by caller to a MediaObject.
     *
     * WritableContainer works on MediaObject so we transfer the supplied data
     * to one. Additionally some checks are performed (e.g. whether the DLNA
     * profile is supported or not) or sanitize the supplied title for use as
     * part of the on-disk filename.
     *
     * This function fills ObjectCreator.object.
     */
static void rygel_object_creator_create_object_from_didl_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorCreateObjectFromDidlData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_object_creator_create_object_from_didl_co (_data_);
}


static gboolean rygel_object_creator_create_object_from_didl_co (RygelObjectCreatorCreateObjectFromDidlData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->didl_object;
	_data_->_tmp2_ = gupnp_didl_lite_object_get_id (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->container;
	_data_->_tmp5_ = _data_->self->priv->didl_object;
	_data_->_tmp6_ = gupnp_didl_lite_object_get_title (_data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = _data_->self->priv->didl_object;
	_data_->_tmp9_ = gupnp_didl_lite_object_get_upnp_class (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = rygel_object_creator_create_object (_data_->self, _data_->_tmp3_, _data_->_tmp4_, _data_->_tmp7_, _data_->_tmp10_, &_data_->_inner_error_);
	_data_->_tmp0_ = _data_->_tmp11_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_g_object_unref0 (_data_->self->priv->object);
	_data_->self->priv->object = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->self->priv->object;
	_data_->_tmp14_ = _data_->self->priv->didl_object;
	rygel_media_object_apply_didl_lite (_data_->_tmp13_, _data_->_tmp14_);
	_data_->_tmp15_ = _data_->self->priv->object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp15_, RYGEL_TYPE_MEDIA_ITEM)) {
		rygel_object_creator_extract_item_parameters (_data_->self, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_g_object_unref0 (_data_->_tmp0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp16_ = _data_->self->priv->object;
	_data_->_tmp17_ = rygel_media_object_get_uris (_data_->_tmp16_);
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp19_ = gee_collection_get_is_empty ((GeeCollection*) _data_->_tmp18_);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = _data_->_tmp20_;
	_g_object_unref0 (_data_->_tmp18_);
	if (_data_->_tmp21_) {
		_data_->_tmp22_ = _data_->container;
		_data_->_tmp23_ = _data_->self->priv->object;
		_data_->_tmp24_ = rygel_media_object_get_title (_data_->_tmp23_);
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_state_ = 1;
		rygel_object_creator_create_uri (_data_->self, _data_->_tmp22_, _data_->_tmp25_, rygel_object_creator_create_object_from_didl_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp26_ = rygel_object_creator_create_uri_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->uri = _data_->_tmp26_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_g_object_unref0 (_data_->_tmp0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp27_ = _data_->self->priv->object;
		_data_->_tmp28_ = _data_->uri;
		rygel_media_object_add_uri (_data_->_tmp27_, _data_->_tmp28_);
		_data_->_tmp29_ = _data_->self->priv->object;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp29_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
			_data_->_tmp30_ = _data_->self->priv->object;
			rygel_media_file_item_set_place_holder (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp30_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp30_) : NULL, TRUE);
		}
		_g_free0 (_data_->uri);
	} else {
		_data_->_tmp31_ = _data_->self->priv->object;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp31_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
			_data_->_tmp32_ = _data_->self->priv->object;
			_data_->_tmp33_ = rygel_media_object_get_primary_uri (_data_->_tmp32_);
			_data_->_tmp34_ = _data_->_tmp33_;
			_data_->_tmp35_ = g_file_new_for_uri (_data_->_tmp34_);
			_data_->_tmp36_ = _data_->_tmp35_;
			_g_free0 (_data_->_tmp34_);
			_data_->file = _data_->_tmp36_;
			_data_->_tmp37_ = _data_->self->priv->object;
			_data_->_tmp38_ = _data_->file;
			_data_->_tmp39_ = g_file_is_native (_data_->_tmp38_);
			rygel_media_file_item_set_place_holder (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp37_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp37_) : NULL, !_data_->_tmp39_);
			_g_object_unref0 (_data_->file);
		}
	}
	_data_->_tmp40_ = _data_->self->priv->object;
	_data_->_tmp41_ = _data_->self->priv->object;
	_data_->_tmp42_ = rygel_media_object_get_primary_uri (_data_->_tmp41_);
	_data_->_tmp43_ = _data_->_tmp42_;
	rygel_media_object_set_id (_data_->_tmp40_, _data_->_tmp43_);
	_g_free0 (_data_->_tmp43_);
	rygel_object_creator_parse_and_verify_didl_date (_data_->self, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_object_unref0 (_data_->_tmp0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_object_creator_extract_item_parameters (RygelObjectCreator* self, GError** error) {
	RygelMediaFileItem* item = NULL;
	RygelMediaObject* _tmp0_;
	RygelMediaFileItem* _tmp1_;
	GUPnPDIDLLiteObject* _tmp2_;
	GList* _tmp3_;
	RygelMediaFileItem* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	RygelMediaFileItem* _tmp54_;
	gint64 _tmp55_;
	gint64 _tmp56_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->object;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp0_) : NULL);
	item = _tmp1_;
	_tmp2_ = self->priv->didl_object;
	_tmp3_ = gupnp_didl_lite_object_get_resources (_tmp2_);
	{
		GList* resource_collection = NULL;
		GList* resource_it = NULL;
		resource_collection = _tmp3_;
		for (resource_it = resource_collection; resource_it != NULL; resource_it = resource_it->next) {
			GUPnPDIDLLiteResource* _tmp4_;
			GUPnPDIDLLiteResource* resource = NULL;
			_tmp4_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) resource_it->data);
			resource = _tmp4_;
			{
				GUPnPProtocolInfo* info = NULL;
				GUPnPDIDLLiteResource* _tmp5_;
				GUPnPProtocolInfo* _tmp6_;
				GUPnPProtocolInfo* _tmp7_;
				GUPnPProtocolInfo* _tmp8_;
				GUPnPProtocolInfo* _tmp9_;
				gchar* sanitized_uri = NULL;
				GUPnPDIDLLiteResource* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				gchar* _tmp37_ = NULL;
				gboolean _tmp38_;
				GUPnPDIDLLiteResource* _tmp41_;
				glong _tmp42_;
				glong _tmp43_;
				_tmp5_ = resource;
				_tmp6_ = gupnp_didl_lite_resource_get_protocol_info (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = _g_object_ref0 (_tmp7_);
				info = _tmp8_;
				_tmp9_ = info;
				if (_tmp9_ != NULL) {
					GUPnPProtocolInfo* _tmp10_;
					const gchar* _tmp11_;
					const gchar* _tmp12_;
					GUPnPProtocolInfo* _tmp27_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					_tmp10_ = info;
					_tmp11_ = gupnp_protocol_info_get_dlna_profile (_tmp10_);
					_tmp12_ = _tmp11_;
					if (_tmp12_ != NULL) {
						GUPnPProtocolInfo* _tmp13_;
						const gchar* _tmp14_;
						const gchar* _tmp15_;
						gboolean _tmp16_;
						RygelMediaFileItem* _tmp23_;
						GUPnPProtocolInfo* _tmp24_;
						const gchar* _tmp25_;
						const gchar* _tmp26_;
						_tmp13_ = info;
						_tmp14_ = gupnp_protocol_info_get_dlna_profile (_tmp13_);
						_tmp15_ = _tmp14_;
						_tmp16_ = rygel_object_creator_is_profile_valid (self, _tmp15_);
						if (!_tmp16_) {
							gchar* msg = NULL;
							gchar* _tmp17_;
							const gchar* _tmp18_;
							GUPnPProtocolInfo* _tmp19_;
							const gchar* _tmp20_;
							const gchar* _tmp21_;
							GError* _tmp22_;
							_tmp17_ = g_strdup (_ ("DLNA profile “%s” not supported"));
							msg = _tmp17_;
							_tmp18_ = msg;
							_tmp19_ = info;
							_tmp20_ = gupnp_protocol_info_get_dlna_profile (_tmp19_);
							_tmp21_ = _tmp20_;
							_tmp22_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp18_, _tmp21_);
							_inner_error_ = _tmp22_;
							g_propagate_error (error, _inner_error_);
							_g_free0 (msg);
							_g_object_unref0 (info);
							_g_object_unref0 (resource);
							__g_list_free__g_object_unref0_0 (resource_collection);
							_g_object_unref0 (item);
							return;
						}
						_tmp23_ = item;
						_tmp24_ = info;
						_tmp25_ = gupnp_protocol_info_get_dlna_profile (_tmp24_);
						_tmp26_ = _tmp25_;
						rygel_media_file_item_set_dlna_profile (_tmp23_, _tmp26_);
					}
					_tmp27_ = info;
					_tmp28_ = gupnp_protocol_info_get_mime_type (_tmp27_);
					_tmp29_ = _tmp28_;
					if (_tmp29_ != NULL) {
						RygelMediaFileItem* _tmp30_;
						GUPnPProtocolInfo* _tmp31_;
						const gchar* _tmp32_;
						const gchar* _tmp33_;
						_tmp30_ = item;
						_tmp31_ = info;
						_tmp32_ = gupnp_protocol_info_get_mime_type (_tmp31_);
						_tmp33_ = _tmp32_;
						rygel_media_file_item_set_mime_type (_tmp30_, _tmp33_);
					}
				}
				sanitized_uri = NULL;
				_tmp34_ = resource;
				_tmp35_ = gupnp_didl_lite_resource_get_uri (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp38_ = rygel_object_creator_is_valid_uri (self, _tmp36_, &_tmp37_);
				_g_free0 (sanitized_uri);
				sanitized_uri = _tmp37_;
				if (_tmp38_) {
					RygelMediaFileItem* _tmp39_;
					const gchar* _tmp40_;
					_tmp39_ = item;
					_tmp40_ = sanitized_uri;
					rygel_media_object_add_uri ((RygelMediaObject*) _tmp39_, _tmp40_);
				}
				_tmp41_ = resource;
				_tmp42_ = gupnp_didl_lite_resource_get_size (_tmp41_);
				_tmp43_ = _tmp42_;
				if (_tmp43_ >= ((glong) 0)) {
					RygelMediaFileItem* _tmp44_;
					GUPnPDIDLLiteResource* _tmp45_;
					glong _tmp46_;
					glong _tmp47_;
					_tmp44_ = item;
					_tmp45_ = resource;
					_tmp46_ = gupnp_didl_lite_resource_get_size (_tmp45_);
					_tmp47_ = _tmp46_;
					rygel_media_file_item_set_size (_tmp44_, (gint64) _tmp47_);
				}
				_g_free0 (sanitized_uri);
				_g_object_unref0 (info);
				_g_object_unref0 (resource);
			}
		}
		__g_list_free__g_object_unref0_0 (resource_collection);
	}
	_tmp48_ = item;
	_tmp49_ = rygel_media_file_item_get_mime_type (_tmp48_);
	_tmp50_ = _tmp49_;
	if (_tmp50_ == NULL) {
		RygelMediaFileItem* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		_tmp51_ = item;
		_tmp52_ = rygel_object_creator_get_generic_mime_type (self);
		_tmp53_ = _tmp52_;
		rygel_media_file_item_set_mime_type (_tmp51_, _tmp53_);
		_g_free0 (_tmp53_);
	}
	_tmp54_ = item;
	_tmp55_ = rygel_media_file_item_get_size (_tmp54_);
	_tmp56_ = _tmp55_;
	if (_tmp56_ < ((gint64) 0)) {
		RygelMediaFileItem* _tmp57_;
		_tmp57_ = item;
		rygel_media_file_item_set_size (_tmp57_, (gint64) 0);
	}
	_g_object_unref0 (item);
}


static void _vala_SoupDate_free (SoupDate* self) {
	g_boxed_free (soup_date_get_type (), self);
}


static void rygel_object_creator_parse_and_verify_didl_date (RygelObjectCreator* self, GError** error) {
	GUPnPDIDLLiteObject* _tmp0_;
	GUPnPDIDLLiteItem* didl_item = NULL;
	GUPnPDIDLLiteObject* _tmp1_;
	GUPnPDIDLLiteItem* _tmp2_;
	GUPnPDIDLLiteItem* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	SoupDate* parsed_date = NULL;
	GUPnPDIDLLiteItem* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	SoupDate* _tmp9_;
	SoupDate* _tmp10_;
	gint year = 0;
	gint month = 0;
	gint day = 0;
	GUPnPDIDLLiteItem* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gint _tmp18_;
	GDate date = {0};
	gint _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gboolean _tmp26_;
	RygelMediaObject* _tmp31_;
	GUPnPDIDLLiteItem* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->didl_object;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gupnp_didl_lite_item_get_type ())) {
		return;
	}
	_tmp1_ = self->priv->didl_object;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gupnp_didl_lite_item_get_type ()) ? ((GUPnPDIDLLiteItem*) _tmp1_) : NULL);
	didl_item = _tmp2_;
	_tmp3_ = didl_item;
	_tmp4_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (didl_item);
		return;
	}
	_tmp6_ = didl_item;
	_tmp7_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = soup_date_new_from_string (_tmp8_);
	parsed_date = _tmp9_;
	_tmp10_ = parsed_date;
	if (_tmp10_ != NULL) {
		RygelMediaObject* _tmp11_;
		SoupDate* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp11_ = self->priv->object;
		_tmp12_ = parsed_date;
		_tmp13_ = soup_date_to_string (_tmp12_, SOUP_DATE_ISO8601);
		_tmp14_ = _tmp13_;
		rygel_media_object_set_date ((RygelMediaObject*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp11_) : NULL), _tmp14_);
		_g_free0 (_tmp14_);
		__vala_SoupDate_free0 (parsed_date);
		_g_object_unref0 (didl_item);
		return;
	}
	year = 0;
	month = 0;
	day = 0;
	_tmp15_ = didl_item;
	_tmp16_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = sscanf (_tmp17_, "%4d-%02d-%02d", &year, &month, &day);
	if (_tmp18_ != 3) {
		GUPnPDIDLLiteItem* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		GError* _tmp22_;
		_tmp19_ = didl_item;
		_tmp20_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _ ("Invalid date format: %s"), _tmp21_);
		_inner_error_ = _tmp22_;
		g_propagate_error (error, _inner_error_);
		__vala_SoupDate_free0 (parsed_date);
		_g_object_unref0 (didl_item);
		return;
	}
	memset (&date, 0, sizeof (GDate));
	_tmp23_ = day;
	_tmp24_ = month;
	_tmp25_ = year;
	g_date_set_dmy (&date, (GDateDay) _tmp23_, (gint) ((GDateMonth) _tmp24_), (GDateYear) _tmp25_);
	_tmp26_ = g_date_valid (&date);
	if (!_tmp26_) {
		GUPnPDIDLLiteItem* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		GError* _tmp30_;
		_tmp27_ = didl_item;
		_tmp28_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _ ("Invalid date: %s"), _tmp29_);
		_inner_error_ = _tmp30_;
		g_propagate_error (error, _inner_error_);
		__vala_SoupDate_free0 (parsed_date);
		_g_object_unref0 (didl_item);
		return;
	}
	_tmp31_ = self->priv->object;
	_tmp32_ = didl_item;
	_tmp33_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_strconcat (_tmp34_, "T00:00:00", NULL);
	_tmp36_ = _tmp35_;
	rygel_media_object_set_date ((RygelMediaObject*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp31_) : NULL), _tmp36_);
	_g_free0 (_tmp36_);
	__vala_SoupDate_free0 (parsed_date);
	_g_object_unref0 (didl_item);
}


static RygelMediaObject* rygel_object_creator_create_object (RygelObjectCreator* self, const gchar* id, RygelWritableContainer* parent, const gchar* title, const gchar* upnp_class, GError** error) {
	RygelMediaObject* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	_tmp0_ = upnp_class;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == g_quark_from_string (RYGEL_IMAGE_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp4_;
				RygelWritableContainer* _tmp5_;
				const gchar* _tmp6_;
				RygelImageItem* _tmp7_;
				_tmp4_ = id;
				_tmp5_ = parent;
				_tmp6_ = title;
				_tmp7_ = rygel_image_item_new (_tmp4_, (RygelMediaContainer*) _tmp5_, _tmp6_, RYGEL_IMAGE_ITEM_UPNP_CLASS);
				result = (RygelMediaObject*) _tmp7_;
				return result;
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_PHOTO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp8_;
				RygelWritableContainer* _tmp9_;
				const gchar* _tmp10_;
				RygelPhotoItem* _tmp11_;
				_tmp8_ = id;
				_tmp9_ = parent;
				_tmp10_ = title;
				_tmp11_ = rygel_photo_item_new (_tmp8_, (RygelMediaContainer*) _tmp9_, _tmp10_, RYGEL_PHOTO_ITEM_UPNP_CLASS);
				result = (RygelMediaObject*) _tmp11_;
				return result;
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_VIDEO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp12_;
				RygelWritableContainer* _tmp13_;
				const gchar* _tmp14_;
				RygelVideoItem* _tmp15_;
				_tmp12_ = id;
				_tmp13_ = parent;
				_tmp14_ = title;
				_tmp15_ = rygel_video_item_new (_tmp12_, (RygelMediaContainer*) _tmp13_, _tmp14_, RYGEL_VIDEO_ITEM_UPNP_CLASS);
				result = (RygelMediaObject*) _tmp15_;
				return result;
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_AUDIO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp16_;
				RygelWritableContainer* _tmp17_;
				const gchar* _tmp18_;
				RygelAudioItem* _tmp19_;
				_tmp16_ = id;
				_tmp17_ = parent;
				_tmp18_ = title;
				_tmp19_ = rygel_audio_item_new (_tmp16_, (RygelMediaContainer*) _tmp17_, _tmp18_, RYGEL_AUDIO_ITEM_UPNP_CLASS);
				result = (RygelMediaObject*) _tmp19_;
				return result;
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_MUSIC_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp20_;
				RygelWritableContainer* _tmp21_;
				const gchar* _tmp22_;
				RygelMusicItem* _tmp23_;
				_tmp20_ = id;
				_tmp21_ = parent;
				_tmp22_ = title;
				_tmp23_ = rygel_music_item_new (_tmp20_, (RygelMediaContainer*) _tmp21_, _tmp22_, RYGEL_MUSIC_ITEM_UPNP_CLASS);
				result = (RygelMediaObject*) _tmp23_;
				return result;
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_PLAYLIST_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp24_;
				RygelWritableContainer* _tmp25_;
				const gchar* _tmp26_;
				RygelPlaylistItem* _tmp27_;
				_tmp24_ = id;
				_tmp25_ = parent;
				_tmp26_ = title;
				_tmp27_ = rygel_playlist_item_new (_tmp24_, (RygelMediaContainer*) _tmp25_, _tmp26_, RYGEL_PLAYLIST_ITEM_UPNP_CLASS);
				result = (RygelMediaObject*) _tmp27_;
				return result;
			}
		}
	} else if ((_tmp3_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_UPNP_CLASS)) || (_tmp3_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER))) {
		switch (0) {
			default:
			{
				const gchar* _tmp28_;
				RygelWritableContainer* _tmp29_;
				const gchar* _tmp30_;
				RygelBaseMediaContainer* _tmp31_;
				_tmp28_ = id;
				_tmp29_ = parent;
				_tmp30_ = title;
				_tmp31_ = rygel_base_media_container_new (_tmp28_, (RygelMediaContainer*) _tmp29_, _tmp30_, 0);
				result = (RygelMediaObject*) _tmp31_;
				return result;
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_PLAYLIST)) {
		switch (0) {
			default:
			{
				RygelBaseMediaContainer* container = NULL;
				const gchar* _tmp32_;
				RygelWritableContainer* _tmp33_;
				const gchar* _tmp34_;
				RygelBaseMediaContainer* _tmp35_;
				RygelBaseMediaContainer* _tmp36_;
				const gchar* _tmp37_;
				_tmp32_ = id;
				_tmp33_ = parent;
				_tmp34_ = title;
				_tmp35_ = rygel_base_media_container_new (_tmp32_, (RygelMediaContainer*) _tmp33_, _tmp34_, 0);
				container = _tmp35_;
				_tmp36_ = container;
				_tmp37_ = upnp_class;
				rygel_media_object_set_upnp_class ((RygelMediaObject*) _tmp36_, _tmp37_);
				result = (RygelMediaObject*) container;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* msg = NULL;
				gchar* _tmp38_;
				const gchar* _tmp39_;
				const gchar* _tmp40_;
				GError* _tmp41_;
				_tmp38_ = g_strdup (_ ("Cannot create object of class “%s”: Not supported"));
				msg = _tmp38_;
				_tmp39_ = msg;
				_tmp40_ = upnp_class;
				_tmp41_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp39_, _tmp40_);
				_inner_error_ = _tmp41_;
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return NULL;
			}
		}
	}
}


/**
     * Simple check for the validity of an URI.
     *
     * Check is done by parsing the URI with soup. Additionaly a cleaned-up
     * version of the URI is returned in sanitized_uri.
     *
     * @param uri the input URI
     * @param sanitized_uri containes a sanitized version of the URI on return
     * @returns true if the URI is valid, false otherwise.
     */
static void _vala_SoupURI_free (SoupURI* self) {
	g_boxed_free (soup_uri_get_type (), self);
}


static gboolean rygel_object_creator_is_valid_uri (RygelObjectCreator* self, const gchar* uri, gchar* * sanitized_uri) {
	gchar* _vala_sanitized_uri = NULL;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	SoupURI* soup_uri = NULL;
	const gchar* _tmp3_;
	SoupURI* _tmp4_;
	gboolean _tmp5_ = FALSE;
	SoupURI* _tmp6_;
	SoupURI* _tmp9_;
	gchar* _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	_g_free0 (_vala_sanitized_uri);
	_vala_sanitized_uri = NULL;
	_tmp1_ = uri;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = uri;
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
	}
	if (_tmp0_) {
		result = FALSE;
		if (sanitized_uri) {
			*sanitized_uri = _vala_sanitized_uri;
		} else {
			_g_free0 (_vala_sanitized_uri);
		}
		return result;
	}
	_tmp3_ = uri;
	_tmp4_ = soup_uri_new (_tmp3_);
	soup_uri = _tmp4_;
	_tmp6_ = soup_uri;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		SoupURI* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = soup_uri;
		_tmp8_ = _tmp7_->scheme;
		_tmp5_ = _tmp8_ == NULL;
	}
	if (_tmp5_) {
		result = FALSE;
		__vala_SoupURI_free0 (soup_uri);
		if (sanitized_uri) {
			*sanitized_uri = _vala_sanitized_uri;
		} else {
			_g_free0 (_vala_sanitized_uri);
		}
		return result;
	}
	_tmp9_ = soup_uri;
	_tmp10_ = soup_uri_to_string (_tmp9_, FALSE);
	_g_free0 (_vala_sanitized_uri);
	_vala_sanitized_uri = _tmp10_;
	result = TRUE;
	__vala_SoupURI_free0 (soup_uri);
	if (sanitized_uri) {
		*sanitized_uri = _vala_sanitized_uri;
	} else {
		_g_free0 (_vala_sanitized_uri);
	}
	return result;
}


/**
     * Transform the title to be usable on legacy file-systems such as FAT32.
     *
     * The function trims down the title to 205 chars (leaving room for an UUID)
     * and replaces all special characters.
     *
     * @param title of the the media item
     * @return the cleaned and shortened title
     */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* rygel_object_creator_mangle_title (RygelObjectCreator* self, const gchar* title, GError** error) {
	gchar* result = NULL;
	gchar* mangled = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	GRegex* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = title;
	_tmp1_ = title;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = MIN (_tmp3_, 205);
	_tmp5_ = string_substring (_tmp0_, (glong) 0, (glong) _tmp4_);
	mangled = _tmp5_;
	_tmp7_ = self->priv->title_regex;
	_tmp8_ = mangled;
	_tmp9_ = g_regex_replace_literal (_tmp7_, _tmp8_, (gssize) -1, 0, "_", G_REGEX_MATCH_NOTEMPTY, &_inner_error_);
	_tmp6_ = _tmp9_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (mangled);
		return NULL;
	}
	_tmp10_ = _tmp6_;
	_tmp6_ = NULL;
	_g_free0 (mangled);
	mangled = _tmp10_;
	_tmp11_ = gupnp_get_uuid ();
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp12_, "-", NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = mangled;
	_tmp16_ = g_strconcat (_tmp14_, _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	result = _tmp17_;
	_g_free0 (_tmp6_);
	_g_free0 (mangled);
	return result;
}


static void rygel_object_creator_create_uri_data_free (gpointer _data) {
	RygelObjectCreatorCreateUriData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->container);
	_g_free0 (_data_->title);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelObjectCreatorCreateUriData, _data_);
}


static void rygel_object_creator_create_uri_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelObjectCreatorCreateUriData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void rygel_object_creator_create_uri (RygelObjectCreator* self, RygelWritableContainer* container, const gchar* title, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorCreateUriData* _data_;
	RygelObjectCreator* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	_data_ = g_slice_new0 (RygelObjectCreatorCreateUriData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_object_creator_create_uri_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_object_creator_create_uri_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = container;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->container);
	_data_->container = _tmp2_;
	_tmp3_ = title;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->title);
	_data_->title = _tmp4_;
	rygel_object_creator_create_uri_co (_data_);
}


static gchar* rygel_object_creator_create_uri_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	RygelObjectCreatorCreateUriData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Create an URI from the item's title.
     *
     * Create an unique URI from the supplied title by cleaning it from
     * unwanted characters, shortening it and adding an UUID.
     *
     * @param container to create the item in
     * @param title of the item to base the name on
     * @returns an URI for the newly created item
     */
static void rygel_object_creator_create_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorCreateUriData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_object_creator_create_uri_co (_data_);
}


static gboolean rygel_object_creator_create_uri_co (RygelObjectCreatorCreateUriData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->container;
	_data_->_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_state_ = 1;
	rygel_media_object_get_writable ((RygelMediaObject*) _data_->_tmp0_, _data_->_tmp2_, rygel_object_creator_create_uri_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = rygel_media_object_get_writable_finish ((RygelMediaObject*) _data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
	_data_->dir = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->dir;
	if (_data_->_tmp4_ == NULL) {
		_data_->_tmp5_ = _data_->container;
		_data_->_tmp6_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _ ("Object creation in %s not allowed"), _data_->_tmp7_);
		_data_->_inner_error_ = _data_->_tmp8_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_object_unref0 (_data_->dir);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->title;
	_data_->_tmp11_ = rygel_object_creator_mangle_title (_data_->self, _data_->_tmp10_, &_data_->_inner_error_);
	_data_->_tmp9_ = _data_->_tmp11_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_object_unref0 (_data_->dir);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->dir;
	_data_->_tmp13_ = g_file_get_child_for_display_name (_data_->_tmp12_, _data_->_tmp9_, &_data_->_inner_error_);
	_data_->file = _data_->_tmp13_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_free0 (_data_->_tmp9_);
		_g_object_unref0 (_data_->dir);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = _data_->file;
	_data_->_tmp15_ = g_file_get_uri (_data_->_tmp14_);
	_data_->result = _data_->_tmp15_;
	_g_object_unref0 (_data_->file);
	_g_free0 (_data_->_tmp9_);
	_g_object_unref0 (_data_->dir);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_object_creator_wait_for_object_data_free (gpointer _data) {
	RygelObjectCreatorWaitForObjectData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelObjectCreatorWaitForObjectData, _data_);
}


static void rygel_object_creator_wait_for_object_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelObjectCreatorWaitForObjectData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void rygel_object_creator_wait_for_object (RygelObjectCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorWaitForObjectData* _data_;
	RygelObjectCreator* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* _tmp2_;
	_data_ = g_slice_new0 (RygelObjectCreatorWaitForObjectData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_object_creator_wait_for_object_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_object_creator_wait_for_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = container;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->container);
	_data_->container = _tmp2_;
	rygel_object_creator_wait_for_object_co (_data_);
}


static void rygel_object_creator_wait_for_object_finish (RygelObjectCreator* self, GAsyncResult* _res_) {
	RygelObjectCreatorWaitForObjectData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


/**
     * Wait for the new object
     *
     * When creating an object in the back-end via WritableContainer.add_item
     * or WritableContainer.add_container there might be a delay between the
     * creation and the back-end having the newly created item available. This
     * function waits for the item to become available by hooking into the
     * container_updated signal. The maximum time to wait is 5 seconds.
     *
     * @param container to watch
     */
static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		RygelObjectCreator* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->container);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}


static void rygel_object_creator_wait_for_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorWaitForObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_object_creator_wait_for_object_co (_data_);
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		RygelObjectCreator* self;
		self = _data9_->_data8_->self;
		block8_data_unref (_data9_->_data8_);
		_data9_->_data8_ = NULL;
		g_slice_free (Block9Data, _data9_);
	}
}


static void ____lambda9_ (Block9Data* _data9_, RygelMediaContainer* container) {
	Block8Data* _data8_;
	RygelObjectCreator* self;
	_data8_ = _data9_->_data8_;
	self = _data8_->self;
	g_return_if_fail (container != NULL);
	rygel_object_creator_wait_for_object_co (_data8_->_async_data_);
}


static void _____lambda9__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self) {
	____lambda9_ (self, container);
}


static gboolean ____lambda10_ (Block9Data* _data9_) {
	Block8Data* _data8_;
	RygelObjectCreator* self;
	gboolean result = FALSE;
	RygelWritableContainer* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	_data8_ = _data9_->_data8_;
	self = _data8_->self;
	_tmp0_ = _data8_->container;
	_tmp1_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_debug ("rygel-object-creator.vala:757: Timeout on waiting for 'updated' signal" \
" on '%s'.", _tmp2_);
	_data9_->timeout = (guint) 0;
	rygel_object_creator_wait_for_object_co (_data8_->_async_data_);
	result = FALSE;
	return result;
}


static gboolean _____lambda10__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda10_ (self);
	return result;
}


static gboolean rygel_object_creator_wait_for_object_co (RygelObjectCreatorWaitForObjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data8_ = g_slice_new0 (Block8Data);
	_data_->_data8_->_ref_count_ = 1;
	_data_->_data8_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = _data_->container;
	_g_object_unref0 (_data_->_data8_->container);
	_data_->_data8_->container = _data_->_tmp0_;
	_data_->_data8_->_async_data_ = _data_;
	_data_->_tmp1_ = _data_->_data8_->container;
	_data_->_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	g_debug ("rygel-object-creator.vala:736: Waiting for new object to appear under " \
"container '%s'…", _data_->_tmp3_);
	_data_->object = NULL;
	while (TRUE) {
		_data_->_tmp4_ = _data_->object;
		if (!(_data_->_tmp4_ == NULL)) {
			break;
		}
		{
			_data_->_tmp6_ = _data_->_data8_->container;
			_data_->_tmp7_ = _data_->self->priv->object;
			_data_->_tmp8_ = rygel_media_object_get_id (_data_->_tmp7_);
			_data_->_tmp9_ = _data_->_tmp8_;
			_data_->_tmp10_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
			_data_->_tmp11_ = _data_->_tmp10_;
			_data_->_state_ = 1;
			rygel_media_container_find_object ((RygelMediaContainer*) _data_->_tmp6_, _data_->_tmp9_, _data_->_tmp11_, rygel_object_creator_wait_for_object_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp12_ = rygel_media_container_find_object_finish ((RygelMediaContainer*) _data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp5_ = _data_->_tmp12_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch66_g_error;
			}
			_data_->_tmp13_ = _data_->_tmp5_;
			_data_->_tmp5_ = NULL;
			_g_object_unref0 (_data_->object);
			_data_->object = _data_->_tmp13_;
			_g_object_unref0 (_data_->_tmp5_);
		}
		goto __finally66;
		__catch66_g_error:
		{
			_data_->_error_ = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp14_ = g_strdup (_ ("Error from container “%s” on trying to find the newly added child obje" \
"ct “%s” in it: %s"));
			_data_->msg = _data_->_tmp14_;
			_data_->_tmp15_ = _data_->msg;
			_data_->_tmp16_ = _data_->_data8_->container;
			_data_->_tmp17_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp16_);
			_data_->_tmp18_ = _data_->_tmp17_;
			_data_->_tmp19_ = _data_->self->priv->object;
			_data_->_tmp20_ = rygel_media_object_get_id (_data_->_tmp19_);
			_data_->_tmp21_ = _data_->_tmp20_;
			_data_->_tmp22_ = _data_->_error_;
			_data_->_tmp23_ = _data_->_tmp22_->message;
			g_warning (_data_->_tmp15_, _data_->_tmp18_, _data_->_tmp21_, _data_->_tmp23_);
			_g_free0 (_data_->msg);
			_g_error_free0 (_data_->_error_);
		}
		__finally66:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->object);
			block8_data_unref (_data_->_data8_);
			_data_->_data8_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp24_ = _data_->object;
		if (_data_->_tmp24_ == NULL) {
			_data_->_data9_ = g_slice_new0 (Block9Data);
			_data_->_data9_->_ref_count_ = 1;
			_data_->_data9_->_data8_ = block8_data_ref (_data_->_data8_);
			_data_->_tmp25_ = _data_->_data8_->container;
			_data_->_tmp26_ = g_signal_connect_data ((RygelMediaContainer*) _data_->_tmp25_, "container-updated", (GCallback) _____lambda9__rygel_media_container_container_updated, block9_data_ref (_data_->_data9_), (GClosureNotify) block9_data_unref, 0);
			_data_->id = _data_->_tmp26_;
			_data_->_data9_->timeout = (guint) 0;
			_data_->_tmp27_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, _____lambda10__gsource_func, block9_data_ref (_data_->_data9_), block9_data_unref);
			_data_->_data9_->timeout = _data_->_tmp27_;
			_data_->_state_ = 2;
			return FALSE;
			_state_2:
			;
			_data_->_tmp28_ = _data_->_data8_->container;
			_data_->_tmp29_ = _data_->id;
			g_signal_handler_disconnect ((GObject*) _data_->_tmp28_, _data_->_tmp29_);
			_data_->_tmp30_ = _data_->_data9_->timeout;
			if (_data_->_tmp30_ != ((guint) 0)) {
				_data_->_tmp31_ = _data_->_data9_->timeout;
				g_source_remove (_data_->_tmp31_);
			} else {
				block9_data_unref (_data_->_data9_);
				_data_->_data9_ = NULL;
				break;
			}
			block9_data_unref (_data_->_data9_);
			_data_->_data9_ = NULL;
		}
	}
	_data_->_tmp32_ = _data_->_data8_->container;
	_data_->_tmp33_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp32_);
	_data_->_tmp34_ = _data_->_tmp33_;
	g_debug ("rygel-object-creator.vala:776: Finished waiting for new object to appe" \
"ar under container '%s'", _data_->_tmp34_);
	_data_->_tmp35_ = _data_->object;
	_data_->_tmp36_ = _g_object_ref0 (_data_->_tmp35_);
	_g_object_unref0 (_data_->self->priv->object);
	_data_->self->priv->object = _data_->_tmp36_;
	_g_object_unref0 (_data_->object);
	block8_data_unref (_data_->_data8_);
	_data_->_data8_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Check if the profile is supported.
     *
     * The check is performed against the MediaEngine's database explicitly excluding
     * the transcoders.
     *
     * @param profile to check
     * @returns true if the profile is supported, false otherwise.
     */
static gint _rygel_dlna_profile_compare_by_name_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = rygel_dlna_profile_compare_by_name ((RygelDLNAProfile*) a, (RygelDLNAProfile*) b);
	return result;
}


static gboolean rygel_object_creator_is_profile_valid (RygelObjectCreator* self, const gchar* profile) {
	gboolean result = FALSE;
	GList* profiles = NULL;
	GList* _result_ = NULL;
	RygelMediaServerPlugin* plugin = NULL;
	RygelContentDirectory* _tmp0_;
	GUPnPRootDevice* _tmp1_;
	GUPnPRootDevice* _tmp2_;
	GUPnPRootDevice* _tmp3_;
	GUPnPResourceFactory* _tmp4_;
	GUPnPResourceFactory* _tmp5_;
	RygelMediaServerPlugin* _tmp6_;
	RygelMediaServerPlugin* _tmp7_;
	GList* _tmp8_;
	GList* _tmp9_;
	RygelDLNAProfile* p = NULL;
	const gchar* _tmp10_;
	RygelDLNAProfile* _tmp11_;
	GList* _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (profile != NULL, FALSE);
	_tmp0_ = self->priv->content_dir;
	g_object_get ((GUPnPService*) _tmp0_, "root-device", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _tmp5_) : NULL);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp3_);
	plugin = _tmp7_;
	_tmp8_ = rygel_media_server_plugin_get_upload_profiles (plugin);
	_tmp9_ = _tmp8_;
	profiles = _tmp9_;
	_tmp10_ = profile;
	_tmp11_ = rygel_dlna_profile_new (_tmp10_, "");
	p = _tmp11_;
	_tmp12_ = g_list_find_custom (profiles, p, _rygel_dlna_profile_compare_by_name_gcompare_func);
	_result_ = _tmp12_;
	result = _result_ != NULL;
	_rygel_dlna_profile_unref0 (p);
	_g_object_unref0 (plugin);
	return result;
}


static GCancellable* rygel_object_creator_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelObjectCreator* self;
	GCancellable* _tmp0_;
	self = (RygelObjectCreator*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}


static void rygel_object_creator_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelObjectCreator* self;
	self = (RygelObjectCreator*) base;
	if (rygel_object_creator_real_get_cancellable (base) != value) {
		GCancellable* _tmp0_;
		GCancellable* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_cancellable);
		self->priv->_cancellable = _tmp1_;
		g_object_notify ((GObject *) self, "cancellable");
	}
}


static void rygel_object_creator_class_init (RygelObjectCreatorClass * klass) {
	GPatternSpec* _tmp0_;
	rygel_object_creator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelObjectCreatorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_object_creator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_object_creator_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_object_creator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_OBJECT_CREATOR_CANCELLABLE_PROPERTY, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_pattern_spec_new ("*<!--*-->*");
	rygel_object_creator_comment_pattern = _tmp0_;
}


static void rygel_object_creator_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_object_creator_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*) (RygelStateMachine *, GAsyncReadyCallback, gpointer)) rygel_object_creator_real_run;
	iface->run_finish = (void (*) (RygelStateMachine *, GAsyncResult*)) rygel_object_creator_real_run_finish;
	iface->get_cancellable = rygel_object_creator_real_get_cancellable;
	iface->set_cancellable = rygel_object_creator_real_set_cancellable;
}


static void rygel_object_creator_instance_init (RygelObjectCreator * self) {
	self->priv = RYGEL_OBJECT_CREATOR_GET_PRIVATE (self);
}


static void rygel_object_creator_finalize (GObject * obj) {
	RygelObjectCreator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreator);
	_g_free0 (self->priv->container_id);
	_g_free0 (self->priv->elements);
	_g_object_unref0 (self->priv->didl_object);
	_g_object_unref0 (self->priv->object);
	_g_object_unref0 (self->priv->content_dir);
	__vala_GUPnPServiceAction_free0 (self->priv->action);
	_g_object_unref0 (self->priv->serializer);
	_g_object_unref0 (self->priv->didl_parser);
	_g_regex_unref0 (self->priv->title_regex);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_object_creator_parent_class)->finalize (obj);
}


/**
 * CreateObject action implementation.
 */
GType rygel_object_creator_get_type (void) {
	static volatile gsize rygel_object_creator_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_object_creator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelObjectCreatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_object_creator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelObjectCreator), 0, (GInstanceInitFunc) rygel_object_creator_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_object_creator_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_object_creator_type_id;
		rygel_object_creator_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelObjectCreator", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_object_creator_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_object_creator_type_id__volatile, rygel_object_creator_type_id);
	}
	return rygel_object_creator_type_id__volatile;
}


static void _vala_rygel_object_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelObjectCreator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreator);
	switch (property_id) {
		case RYGEL_OBJECT_CREATOR_CANCELLABLE_PROPERTY:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_object_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelObjectCreator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreator);
	switch (property_id) {
		case RYGEL_OBJECT_CREATOR_CANCELLABLE_PROPERTY:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



