/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file CLIOpt.hxx
    \author Romain BONDUE
    \date 29/10/2006
    \warning This file should only be included from CLIOpt.h */
inline bool nsCore::CCLIOpt::Help () const throw() {return m_Flags & HelpFlag;}


inline bool nsCore::CCLIOpt::Version () const throw()
{
    return m_Flags & VersionFlag;

} // Version()


inline bool nsCore::CCLIOpt::Hidden () const throw()
{
    return m_Flags & HiddenFlag;

} // Hidden()


inline bool nsCore::CCLIOpt::Exit () const throw() {return m_Flags & ExitFlag;}


inline bool nsCore::CCLIOpt::Dhcp () const throw() {return m_Flags & DhcpFlag;}


inline const std::string& nsCore::CCLIOpt::ProfileName () const throw()
{
    return m_ProfileName;

} // ProfileName()


inline const std::string& nsCore::CCLIOpt::IfaceName () const throw()
{
    return m_IfaceName;

} // IfaceName()


inline bool nsCore::CCLIOpt::Profile () const throw()
{
    return m_Flags & ProfileFlag;

} // Profile()


inline bool nsCore::CCLIOpt::Iface () const throw()
{
    return !m_IfaceName.empty();

} // Iface()
