A type alias impl trait can only have its hidden type assigned
when used fully generically (and within their defining scope).
This means

```compile_fail,E0792
#![feature(type_alias_impl_trait)]

type Foo<T> = impl std::fmt::Debug;

#[define_opaque(Foo)]
fn foo() -> Foo<u32> {
    5u32
}
```

is not accepted. If it were accepted, one could create unsound situations like

```compile_fail,E0792
#![feature(type_alias_impl_trait)]

type Foo<T> = impl Default;

#[define_opaque(Foo)]
fn foo() -> Foo<u32> {
    5u32
}

fn main() {
    let x = Foo::<&'static mut String>::default();
}
```


Instead you need to make the function generic:

```
#![feature(type_alias_impl_trait)]

type Foo<T> = impl std::fmt::Debug;

#[define_opaque(Foo)]
fn foo<U>() -> Foo<U> {
    5u32
}

fn main() {}
```

This means that no matter the generic parameter to `foo`,
the hidden type will always be `u32`.
If you want to link the generic parameter to the hidden type,
you can do that, too:


```
#![feature(type_alias_impl_trait)]

use std::fmt::Debug;

type Foo<T: Debug> = impl Debug;

#[define_opaque(Foo)]
fn foo<U: Debug>() -> Foo<U> {
    Vec::<U>::new()
}

fn main() {}
```
