/*
 * nghttp2 - HTTP/2 C Library
 *
 * Copyright (c) 2012 Tatsuhiro Tsujikawa
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef NGHTTP2_SESSION_TEST_H
#define NGHTTP2_SESSION_TEST_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif /* HAVE_CONFIG_H */

#define MUNIT_ENABLE_ASSERT_ALIASES

#include "munit.h"

extern const MunitSuite session_suite;

munit_void_test_decl(test_nghttp2_session_recv)
munit_void_test_decl(test_nghttp2_session_recv_invalid_stream_id)
munit_void_test_decl(test_nghttp2_session_recv_invalid_frame)
munit_void_test_decl(test_nghttp2_session_recv_eof)
munit_void_test_decl(test_nghttp2_session_recv_data)
munit_void_test_decl(test_nghttp2_session_recv_data_no_auto_flow_control)
munit_void_test_decl(test_nghttp2_session_recv_continuation)
munit_void_test_decl(test_nghttp2_session_recv_headers_with_priority)
munit_void_test_decl(test_nghttp2_session_recv_headers_with_padding)
munit_void_test_decl(test_nghttp2_session_recv_headers_early_response)
munit_void_test_decl(test_nghttp2_session_recv_headers_for_closed_stream)
munit_void_test_decl(test_nghttp2_session_recv_headers_with_extpri)
munit_void_test_decl(test_nghttp2_session_server_recv_push_response)
munit_void_test_decl(test_nghttp2_session_recv_premature_headers)
munit_void_test_decl(test_nghttp2_session_recv_unknown_frame)
munit_void_test_decl(test_nghttp2_session_recv_unexpected_continuation)
munit_void_test_decl(test_nghttp2_session_recv_settings_header_table_size)
munit_void_test_decl(test_nghttp2_session_recv_too_large_frame_length)
munit_void_test_decl(test_nghttp2_session_recv_extension)
munit_void_test_decl(test_nghttp2_session_recv_altsvc)
munit_void_test_decl(test_nghttp2_session_recv_origin)
munit_void_test_decl(test_nghttp2_session_recv_priority_update)
munit_void_test_decl(test_nghttp2_session_continue)
munit_void_test_decl(test_nghttp2_session_add_frame)
munit_void_test_decl(test_nghttp2_session_on_request_headers_received)
munit_void_test_decl(test_nghttp2_session_on_response_headers_received)
munit_void_test_decl(test_nghttp2_session_on_headers_received)
munit_void_test_decl(test_nghttp2_session_on_push_response_headers_received)
munit_void_test_decl(test_nghttp2_session_on_priority_received)
munit_void_test_decl(test_nghttp2_session_on_rst_stream_received)
munit_void_test_decl(test_nghttp2_session_on_settings_received)
munit_void_test_decl(test_nghttp2_session_on_push_promise_received)
munit_void_test_decl(test_nghttp2_session_on_ping_received)
munit_void_test_decl(test_nghttp2_session_on_goaway_received)
munit_void_test_decl(test_nghttp2_session_on_window_update_received)
munit_void_test_decl(test_nghttp2_session_on_data_received)
munit_void_test_decl(test_nghttp2_session_on_data_received_fail_fast)
munit_void_test_decl(test_nghttp2_session_on_altsvc_received)
munit_void_test_decl(test_nghttp2_session_send_headers_start_stream)
munit_void_test_decl(test_nghttp2_session_send_headers_reply)
munit_void_test_decl(test_nghttp2_session_send_headers_frame_size_error)
munit_void_test_decl(test_nghttp2_session_send_headers_push_reply)
munit_void_test_decl(test_nghttp2_session_send_rst_stream)
munit_void_test_decl(test_nghttp2_session_send_push_promise)
munit_void_test_decl(test_nghttp2_session_is_my_stream_id)
munit_void_test_decl(test_nghttp2_session_upgrade2)
munit_void_test_decl(test_nghttp2_session_reprioritize_stream)
munit_void_test_decl(
  test_nghttp2_session_reprioritize_stream_with_idle_stream_dep)
munit_void_test_decl(test_nghttp2_submit_data)
munit_void_test_decl(test_nghttp2_submit_data_read_length_too_large)
munit_void_test_decl(test_nghttp2_submit_data_read_length_smallest)
munit_void_test_decl(test_nghttp2_submit_data_twice)
munit_void_test_decl(test_nghttp2_submit_request_with_data)
munit_void_test_decl(test_nghttp2_submit_request_without_data)
munit_void_test_decl(test_nghttp2_submit_response_with_data)
munit_void_test_decl(test_nghttp2_submit_response_without_data)
munit_void_test_decl(test_nghttp2_submit_response_push_response)
munit_void_test_decl(test_nghttp2_submit_trailer)
munit_void_test_decl(test_nghttp2_submit_headers_start_stream)
munit_void_test_decl(test_nghttp2_submit_headers_reply)
munit_void_test_decl(test_nghttp2_submit_headers_push_reply)
munit_void_test_decl(test_nghttp2_submit_headers)
munit_void_test_decl(test_nghttp2_submit_headers_continuation)
munit_void_test_decl(test_nghttp2_submit_headers_continuation_extra_large)
munit_void_test_decl(test_nghttp2_submit_priority)
munit_void_test_decl(test_nghttp2_submit_settings)
munit_void_test_decl(test_nghttp2_submit_settings_update_local_window_size)
munit_void_test_decl(test_nghttp2_submit_settings_multiple_times)
munit_void_test_decl(test_nghttp2_submit_push_promise)
munit_void_test_decl(test_nghttp2_submit_window_update)
munit_void_test_decl(test_nghttp2_submit_window_update_local_window_size)
munit_void_test_decl(test_nghttp2_submit_shutdown_notice)
munit_void_test_decl(test_nghttp2_submit_invalid_nv)
munit_void_test_decl(test_nghttp2_submit_extension)
munit_void_test_decl(test_nghttp2_submit_altsvc)
munit_void_test_decl(test_nghttp2_submit_origin)
munit_void_test_decl(test_nghttp2_submit_priority_update)
munit_void_test_decl(test_nghttp2_submit_rst_stream)
munit_void_test_decl(test_nghttp2_session_open_stream)
munit_void_test_decl(test_nghttp2_session_open_stream_with_idle_stream_dep)
munit_void_test_decl(test_nghttp2_session_get_next_ob_item)
munit_void_test_decl(test_nghttp2_session_pop_next_ob_item)
munit_void_test_decl(test_nghttp2_session_reply_fail)
munit_void_test_decl(test_nghttp2_session_max_concurrent_streams)
munit_void_test_decl(test_nghttp2_session_stop_data_with_rst_stream)
munit_void_test_decl(test_nghttp2_session_defer_data)
munit_void_test_decl(test_nghttp2_session_flow_control)
munit_void_test_decl(test_nghttp2_session_flow_control_data_recv)
munit_void_test_decl(test_nghttp2_session_flow_control_data_with_padding_recv)
munit_void_test_decl(test_nghttp2_session_data_read_temporal_failure)
munit_void_test_decl(test_nghttp2_session_on_stream_close)
munit_void_test_decl(test_nghttp2_session_on_ctrl_not_send)
munit_void_test_decl(test_nghttp2_session_get_outbound_queue_size)
munit_void_test_decl(test_nghttp2_session_get_effective_local_window_size)
munit_void_test_decl(test_nghttp2_session_set_option)
munit_void_test_decl(test_nghttp2_session_data_backoff_by_high_pri_frame)
munit_void_test_decl(test_nghttp2_session_pack_data_with_padding)
munit_void_test_decl(test_nghttp2_session_pack_headers_with_padding)
munit_void_test_decl(test_nghttp2_pack_settings_payload)
munit_void_test_decl(test_nghttp2_session_stream_dep_add)
munit_void_test_decl(test_nghttp2_session_stream_dep_remove)
munit_void_test_decl(test_nghttp2_session_stream_dep_add_subtree)
munit_void_test_decl(test_nghttp2_session_stream_dep_remove_subtree)
munit_void_test_decl(
  test_nghttp2_session_stream_dep_all_your_stream_are_belong_to_us)
munit_void_test_decl(test_nghttp2_session_stream_attach_item)
munit_void_test_decl(test_nghttp2_session_stream_attach_item_subtree)
munit_void_test_decl(test_nghttp2_session_stream_get_state)
munit_void_test_decl(test_nghttp2_session_stream_get_something)
munit_void_test_decl(test_nghttp2_session_find_stream)
munit_void_test_decl(test_nghttp2_session_keep_closed_stream)
munit_void_test_decl(test_nghttp2_session_keep_idle_stream)
munit_void_test_decl(test_nghttp2_session_detach_idle_stream)
munit_void_test_decl(test_nghttp2_session_large_dep_tree)
munit_void_test_decl(test_nghttp2_session_graceful_shutdown)
munit_void_test_decl(test_nghttp2_session_on_header_temporal_failure)
munit_void_test_decl(test_nghttp2_session_recv_client_magic)
munit_void_test_decl(test_nghttp2_session_delete_data_item)
munit_void_test_decl(test_nghttp2_session_open_idle_stream)
munit_void_test_decl(test_nghttp2_session_cancel_reserved_remote)
munit_void_test_decl(test_nghttp2_session_reset_pending_headers)
munit_void_test_decl(test_nghttp2_session_send_data_callback)
munit_void_test_decl(test_nghttp2_session_on_begin_headers_temporal_failure)
munit_void_test_decl(test_nghttp2_session_defer_then_close)
munit_void_test_decl(test_nghttp2_session_detach_item_from_closed_stream)
munit_void_test_decl(test_nghttp2_session_flooding)
munit_void_test_decl(test_nghttp2_session_change_stream_priority)
munit_void_test_decl(test_nghttp2_session_change_extpri_stream_priority)
munit_void_test_decl(test_nghttp2_session_create_idle_stream)
munit_void_test_decl(test_nghttp2_session_repeated_priority_change)
munit_void_test_decl(test_nghttp2_session_repeated_priority_submission)
munit_void_test_decl(test_nghttp2_session_set_local_window_size)
munit_void_test_decl(test_nghttp2_session_cancel_from_before_frame_send)
munit_void_test_decl(test_nghttp2_session_too_many_settings)
munit_void_test_decl(test_nghttp2_session_removed_closed_stream)
munit_void_test_decl(test_nghttp2_session_pause_data)
munit_void_test_decl(test_nghttp2_session_no_closed_streams)
munit_void_test_decl(test_nghttp2_session_set_stream_user_data)
munit_void_test_decl(test_nghttp2_session_no_rfc7540_priorities)
munit_void_test_decl(test_nghttp2_session_server_fallback_rfc7540_priorities)
munit_void_test_decl(test_nghttp2_session_stream_reset_ratelim)
munit_void_test_decl(test_nghttp2_http_mandatory_headers)
munit_void_test_decl(test_nghttp2_http_content_length)
munit_void_test_decl(test_nghttp2_http_content_length_mismatch)
munit_void_test_decl(test_nghttp2_http_non_final_response)
munit_void_test_decl(test_nghttp2_http_trailer_headers)
munit_void_test_decl(test_nghttp2_http_ignore_regular_header)
munit_void_test_decl(test_nghttp2_http_ignore_content_length)
munit_void_test_decl(test_nghttp2_http_record_request_method)
munit_void_test_decl(test_nghttp2_http_push_promise)
munit_void_test_decl(test_nghttp2_http_head_method_upgrade_workaround)
munit_void_test_decl(
  test_nghttp2_http_no_rfc9113_leading_and_trailing_ws_validation)

#endif /* NGHTTP2_SESSION_TEST_H */
