![](https://github.com/erlware/relx/workflows/Common%20Test/badge.svg)
![Cirrus CI - Task and Script Build Status](https://img.shields.io/cirrus/github/erlware/relx?label=OSX%20Tests)

Relx
=======

Relx is a library that assembles Erlang/OTP releases. Given a release
specification and a list of directories in which to search for OTP
applications it will generate a release output.

It is generally used through the Erlang/OTP build tool
[rebar3](https://www.rebar3.org/) which provides a cli interface.

Documentation
-----------

`relx` is a library used by [rebar3](https://www.rebar3.org/). Documentation on
using `rebar3` for building releases with `relx` can be found on
[rebar3.org](https://rebar3.org/docs/deployment/releases/).

Also see [Adopting Erlang's Releases
chapter](https://adoptingerlang.org/docs/production/releases/). 


Building and Testing
--------

Common Test suites can be run with `rebar3`:

``` shell
$ rebar3 compile
$ rebar3 ct
```

Tests for the start scripts that are generated by `relx` are tested with
[shelltestrunner](https://github.com/simonmichael/shelltestrunner/).

The script `shelltests/run_tests.sh` will clone `rebar3` master and build it
with the current `relx` as a checkout dependency and then run the tests using
that `rebar3` escript:

``` shell
$ shelltests/run_tests.sh
```
