% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{server_opts}
\alias{server_opts}
\title{Webfakes web server options}
\usage{
server_opts(
  remote = FALSE,
  port = NULL,
  num_threads = 1,
  interfaces = "127.0.0.1",
  enable_keep_alive = FALSE,
  access_log_file = remote,
  error_log_file = TRUE,
  tcp_nodelay = FALSE,
  throttle = Inf,
  decode_url = TRUE
)
}
\arguments{
\item{remote}{Meta-option. If set to \code{TRUE}, webfakes uses slightly
different defaults, that are more appropriate for a background
server process.}

\item{port}{Port to start the web server on. Defaults to a randomly
chosen port.}

\item{num_threads}{Number of request handler threads to use. Typically
you don't need more than one thread, unless you run test cases in
parallel or you make concurrent HTTP requests.}

\item{interfaces}{The network interfaces to listen on. Being a test
web server, it defaults to the localhost. Only bind to a public
interface if you know what you are doing. webfakes was not designed
to serve public web pages.}

\item{enable_keep_alive}{Whether the server keeps connections alive.}

\item{access_log_file}{\code{TRUE}, \code{FALSE}, or a path. See 'Logging'
below.}

\item{error_log_file}{\code{TRUE}, \code{FALSE}, or a path. See 'Logging'
below.}

\item{tcp_nodelay}{if \code{TRUE} then packages will be sent as soon as
possible, instead of waiting for a full buffer or timeout to occur.}

\item{throttle}{Limit download speed for clients. If not \code{Inf},
then it is the maximum number of bytes per second, that is sent to
as connection.}

\item{decode_url}{Whether the server should automatically decode
URL-encodded URLs. If \code{TRUE} (the default), \verb{/foo\%2fbar} will be
converted to \verb{/foo/bar} automatically. If \code{FALSE}, URLs as not
URL-decoded.}
}
\value{
List of options that can be passed to \code{webfakes_app$listen()}
(see \code{\link[=new_app]{new_app()}}), and \code{\link[=new_app_process]{new_app_process()}}.
}
\description{
Webfakes web server options
}
\section{Logging}{

\itemize{
\item For \code{access_log_file}, \code{TRUE} means \verb{<log-dir>/access.log}.
\item For \code{error_log_file}, \code{TRUE} means \verb{<log-dir>/error.log}.
}

\verb{<log-dir>} is set to the contents of the \code{WEBFAKES_LOG_DIR}
environment variable, if it is set. Otherwise it is set to
\verb{<tmpdir>/webfakes} for local apps and \verb{<tmpdir>/<pid>/webfakes} for
remote apps (started with \code{new_app_procss()}).

\verb{<tmpdir>} is the session temporary directory of the \emph{main process}.

\verb{<pid>} is the process id of the subprocess.
}

\examples{
# See the defaults
server_opts()
}
