% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github-actions.R
\name{use_github_action}
\alias{use_github_action}
\title{Set up a GitHub Actions workflow}
\usage{
use_github_action(
  name = NULL,
  ref = NULL,
  url = NULL,
  save_as = NULL,
  readme = NULL,
  ignore = TRUE,
  open = FALSE,
  badge = NULL
)
}
\arguments{
\item{name}{For \code{use_github_action()}: Name of one of the example workflow
from \url{https://github.com/r-lib/actions/tree/v2/examples} (with or
without extension), e.g. \code{"pkgdown"}, \code{"check-standard.yaml"}.

If the \code{name} starts with \verb{check-}, \code{save_as} will default to
\code{R-CMD-check.yaml} and \code{badge} default to \code{TRUE}.}

\item{ref}{Desired Git reference, usually the name of a tag (\code{"v2"}) or
branch (\code{"main"}). Other possibilities include a commit SHA (\code{"d1c516d"})
or \code{"HEAD"} (meaning "tip of remote's default branch"). If not specified,
defaults to the latest published release of \code{r-lib/actions}
(\url{https://github.com/r-lib/actions/releases}).}

\item{url}{The full URL to a \code{.yaml} file on GitHub. See more details in
\code{\link[=use_github_file]{use_github_file()}}.}

\item{save_as}{Name of the local workflow file. Defaults to \code{name} or
\code{fs::path_file(url)} for \code{use_github_action()}. Do not specify any other
part of the path; the parent directory will always be \code{.github/workflows},
within the active project.}

\item{readme}{The full URL to a \code{README} file that provides more details
about the workflow. Ignored when \code{url} is \code{NULL}.}

\item{ignore}{Should the newly created file be added to \code{.Rbuildignore}?}

\item{open}{Open the newly created file for editing? Happens in RStudio, if
applicable, or via \code{\link[utils:file.edit]{utils::file.edit()}} otherwise.}

\item{badge}{Should we add a badge to the \code{README}?}
}
\description{
Sets up continuous integration (CI) for an R package that is developed on
GitHub using \href{https://github.com/features/actions}{GitHub Actions}. CI can be
used to trigger various operations for each push or pull request, e.g.
running \verb{R CMD check} or building and deploying a pkgdown site.
\subsection{Workflows}{

There are four particularly important workflows that are used by many
packages:
\itemize{
\item \code{check-standard}: Run \verb{R CMD check} using R-latest on Linux, Mac, and
Windows, and using R-devel and R-oldrel on Linux. This is a good baseline
if you plan on submitting your package to CRAN.
\item \code{test-coverage}: Compute test coverage and report to
\url{https://about.codecov.io} by calling \code{\link[covr:codecov]{covr::codecov()}}.
\item \code{pkgdown}: Automatically build and publish a pkgdown website.
But we recommend instead calling \code{\link[=use_pkgdown_github_pages]{use_pkgdown_github_pages()}} which
performs other important set up.
\item \code{pr-commands}: Enables the use of two R-specific commands in pull request
issue comments: \verb{/document} to run \code{roxygen2::roxygenise()} and
\verb{/style} to run \code{styler::style_pkg()}. Both will update the PR with any
changes once they're done.
}

If you call \code{use_github_action()} without arguments, you'll be prompted to
pick from one of these. Otherwise you can see a complete list of
possibilities provided by r-lib at
\url{https://github.com/r-lib/actions/tree/v2/examples}, or you can supply
your own \code{url} to use any other workflow.
}
}
\examples{
\dontrun{
use_github_action()

use_github_action_check_standard()

use_github_action("pkgdown")
}
}
