% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/version.R
\name{use_version}
\alias{use_version}
\alias{use_dev_version}
\title{Increment package version}
\usage{
use_version(which = NULL)

use_dev_version()
}
\arguments{
\item{which}{A string specifying which level to increment, one of: "major",
"minor", "patch", "dev". If \code{NULL}, user can choose interactively.}
}
\description{
\code{use_version()} increments the "Version" field in \code{DESCRIPTION},
adds a new heading to \code{NEWS.md} (if it exists), and commits those changes
(if package uses Git).

\code{use_dev_version()} increments to a development version, e.g.
from 1.0.0 to 1.0.0.9000. If the existing version is already a development
version with four components, it does nothing. Thin wrapper around
\code{use_version()}.
}
\examples{
\dontrun{
## for interactive selection, do this:
use_version()

## request a specific type of increment
use_version("minor")
use_dev_version()
}

}
\seealso{
The \href{https://r-pkgs.org/description.html#version}{version section} of \href{https://r-pkgs.org}{R Packages}.
}
