% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proj.R
\name{proj_utils}
\alias{proj_utils}
\alias{proj_get}
\alias{proj_set}
\alias{proj_path}
\alias{with_project}
\alias{local_project}
\title{Utility functions for the active project}
\usage{
proj_get()

proj_set(path = ".", force = FALSE)

proj_path(..., ext = "")

with_project(path = ".", code, force = FALSE,
  quiet = getOption("usethis.quiet", default = FALSE))

local_project(path = ".", force = FALSE,
  quiet = getOption("usethis.quiet", default = FALSE),
  .local_envir = parent.frame())
}
\arguments{
\item{path}{Path to set. This \code{path} should exist or be \code{NULL}.}

\item{force}{If \code{TRUE}, use this path without checking the usual criteria for
a project. Use sparingly! The main application is to solve a temporary
chicken-egg problem: you need to set the active project in order to add
project-signalling infrastructure, such as initialising a Git repo or
adding a \code{DESCRIPTION} file.}

\item{...}{character vectors, if any values are NA, the result will also be
NA.}

\item{ext}{An optional extension to append to the generated path.}

\item{code}{Code to run with temporary active project.}

\item{quiet}{Whether to suppress user-facing messages, while operating in the
temporary active project.}

\item{.local_envir}{The environment to use for scoping. Defaults to current
execution environment.}
}
\description{
Most \code{use_*()} functions act on the \strong{active project}. If it is
unset, usethis uses \href{https://rprojroot.r-lib.org}{rprojroot} to
find the project root of the current working directory. It establishes the
project root by looking for a \code{.here} file, an RStudio Project, a package
\code{DESCRIPTION}, Git infrastructure, a \code{remake.yml} file, or a \code{.projectile}
file. It then stores the active project for use for the remainder of the
session.
}
\details{
In general, end user scripts should not contain direct calls to
\code{usethis::proj_*()} utility functions. They are internal functions that are
exported for occasional interactive use or use in packages that extend
usethis. End user code should call functions in
\href{https://rprojroot.r-lib.org}{rprojroot} or its simpler companion,
\href{https://here.r-lib.org}{here}, to programmatically detect a project and
build paths within it.
}
\section{Functions}{
\itemize{
\item \code{proj_get}: Retrieves the active project and, if necessary,
attempts to set it in the first place.

\item \code{proj_set}: Sets the active project.

\item \code{proj_path}: Builds a path within the active project returned by
\code{proj_get()}. Thin wrapper around \code{\link[fs:path]{fs::path()}}.

\item \code{with_project}: Runs code with a temporary active project. It is an
example of the \code{with_*()} functions in \href{https://withr.r-lib.org}{withr}.

\item \code{local_project}: Sets an active project until the current execution
environment goes out of scope, e.g. the end of the current function or
test.  It is an example of the \code{local_*()} functions in
\href{https://withr.r-lib.org}{withr}.
}}

\examples{
\dontrun{
## see the active project
proj_get()

## manually set the active project
proj_set("path/to/target/project")

## build a path within the active project (both produce same result)
proj_path("R/foo.R")
proj_path("R", "foo", ext = "R")

## build a path within SOME OTHER project
with_project("path/to/some/other/project", proj_path("blah.R"))

## convince yourself that with_project() temporarily changes the project
with_project("path/to/some/other/project", print(proj_sitrep()))
}
}
\seealso{
Other project functions: \code{\link{proj_sitrep}}
}
\concept{project functions}
