% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality.R
\docType{methods}
\name{reconstruction_error,dimRedResult-method}
\alias{reconstruction_error,dimRedResult-method}
\alias{reconstruction_error}
\title{Method reconstruction_error}
\usage{
\S4method{reconstruction_error}{dimRedResult}(object,
  n = seq_len(ndims(object)), error_fun = "rmse")
}
\arguments{
\item{object}{of class dimRedResult}

\item{n}{a positive integer or vector of integers \code{<= ndims(object)}}

\item{error_fun}{a function or string indicating an error function.}
}
\value{
a vector of number with the same length as \code{n} with the
}
\description{
Calculate the error using only the first \code{n} dimensions of the embedded
data. \code{error_fun} can either be one of \code{c("rmse", "mae")} to
calculate the root mean square error or the mean absolute error respectively,
or a function that takes to equally sized vectors as input and returns a
single number as output.
}
\examples{
\dontrun{
ir <- loadDataSet("Iris")
ir.drr <- embed(ir, "DRR", ndim = ndims(ir))
ir.pca <- embed(ir, "PCA", ndim = ndims(ir))

rmse <- data.frame(
  rmse_drr = reconstruction_error(ir.drr),
  rmse_pca = reconstruction_error(ir.pca)
)

matplot(rmse, type = "l")
plot(ir)
plot(ir.drr)
plot(ir.pca)
}
}
\seealso{
Other Quality scores for dimensionality reduction: \code{\link{AUC_lnK_R_NX,dimRedResult-method}},
  \code{\link{LCMC,dimRedResult-method}},
  \code{\link{Q_NX,dimRedResult-method}},
  \code{\link{Q_global,dimRedResult-method}},
  \code{\link{Q_local,dimRedResult-method}},
  \code{\link{R_NX,dimRedResult-method}},
  \code{\link{cophenetic_correlation,dimRedResult-method}},
  \code{\link{distance_correlation,dimRedResult-method}},
  \code{\link{mean_R_NX,dimRedResult-method}},
  \code{\link{quality,dimRedResult-method}},
  \code{\link{reconstruction_rmse,dimRedResult-method}},
  \code{\link{total_correlation,dimRedResult-method}}
}
\author{
Guido Kraemer
}
