% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-failure-modes.R
\name{geom_jitter_failure_mode}
\alias{geom_jitter_failure_mode}
\title{Jittered points showing (possibly multiple) failure modes}
\usage{
geom_jitter_failure_mode(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "jitter",
  ...,
  width = NULL,
  height = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  sep = "[/, ]+"
)
}
\arguments{
\item{mapping}{Set of aesthetic mapping created by \code{aes()}.
See \code{\link[ggplot2:geom_jitter]{ggplot2::geom_jitter()}} for additional details.}

\item{data}{The data to be displayed by this layer.
See \code{\link[ggplot2:geom_jitter]{ggplot2::geom_jitter()}} for additional details.}

\item{stat}{The statistical transformation to use on the data for this layer.
See \code{\link[ggplot2:geom_jitter]{ggplot2::geom_jitter()}} for additional details.}

\item{position}{A position adjustment to use on the data for this layer.
See \code{\link[ggplot2:geom_jitter]{ggplot2::geom_jitter()}} for additional details.}

\item{...}{Other arguments passed on to \code{layer()}'s \code{params} argument.
See \code{\link[ggplot2:geom_jitter]{ggplot2::geom_jitter()}} for additional details.}

\item{width}{The amount of horizontal jitter.
See \code{\link[ggplot2:geom_jitter]{ggplot2::geom_jitter()}} for additional details.}

\item{height}{The amount of vertical jitter.
See \code{\link[ggplot2:geom_jitter]{ggplot2::geom_jitter()}} for additional details.}

\item{na.rm}{If FALSE, the default, missing values are removed with warning.
See \code{\link[ggplot2:geom_jitter]{ggplot2::geom_jitter()}} for additional details.}

\item{show.legend}{\code{NA}, the default, indicates that nay aesthetics are
mapped.
See \code{\link[ggplot2:geom_jitter]{ggplot2::geom_jitter()}} for additional details.}

\item{inherit.aes}{if FALSE, overrides the default aesthetics.
See \code{\link[ggplot2:geom_jitter]{ggplot2::geom_jitter()}} for additional details.}

\item{sep}{A regular expression indicating the character(s) separating
multiple failure modes. By default \code{"[/, ]+"}}
}
\description{
The \code{geom_jitter_failure_mode} is very similar to
\code{\link[ggplot2:geom_jitter]{ggplot2::geom_jitter()}} except that a failure mode variable specified
as the color and/or shape aesthetic is parsed to separate multiple
failure modes and plot them separately. For example, if an observation
has the failure mode "LAT/LAB", two points will be plotted, one with the
failure mode "LAT" and the second with the failure mode "LAB".
}
\details{
The variable specified for the aesthetics \code{shape} and \code{color} are passed
to the function \code{\link[=separate_failure_modes]{separate_failure_modes()}} to parse the failure modes and
separate multiple failure modes separated by character(s) specified in
the regular expression given in the parameter \code{sep}. By default, multiple
failure modes are expected to be separated by spaces, commas or forward
slashes, but this can be overridden.

If both \code{shape} and \code{color} aesthetics are specified, both must be identical.
}
\examples{
library(dplyr)
library(ggplot2)
carbon.fabric.2 \%>\%
  filter(test == "WT") \%>\%
  ggplot(aes(x = condition, y = strength)) +
  geom_boxplot() +
  geom_jitter_failure_mode(aes(color = failure_mode, shape = failure_mode))

}
\seealso{
\code{\link[=separate_failure_modes]{separate_failure_modes()}}

\code{\link[ggplot2:geom_jitter]{ggplot2::geom_jitter()}}
}
