% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cmd_file_expect}
\alias{cmd_file_expect}
\title{Creates list of paths by file extension & checks they exist}
\usage{
cmd_file_expect(prefix, ext, outdir = ".")
}
\arguments{
\item{prefix}{name of file prefix for each extension.}

\item{ext}{vector of file extensions}

\item{outdir}{directory the files will be inside}
}
\value{
vector of valid file paths
}
\description{
Ext or prefix can be a vector or single character. The shorter value will be
propagated across all values of the other. See Examples for details.
}
\details{
If files are not found, throws an error
}
\examples{
\dontrun{
# Expects many file types of same prefix
# ie myFile.txt, myFile.html, myFile.xml
cmd_file_expect("myFile", c("txt", "html", "xml"))

# Expects many files of same type
# ie myFile1.txt, myFile2.txt, myFile3.txt
cmd_file_expect(c("myFile1", "myFile2", "myFile3"), "txt")

# Expects many files with each prefix and each extension
# ie myFile1.txt, myFile1.html, myFile2.txt, myFile2.html
cmd_file_expect(c("myFile1", "myFile2"), c("txt", "html"))

}


}
