% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional_effects.R
\name{rows2labels}
\alias{rows2labels}
\title{Convert Rows to Labels}
\usage{
rows2labels(x, digits = 2, sep = " & ", incl_vars = TRUE, ...)
}
\arguments{
\item{x}{A \code{data.frame} for which to extract labels.}

\item{digits}{Minimal number of decimal places shown in
the labels of numeric variables.}

\item{sep}{A single character string defining the separator
between variables used in the labels.}

\item{incl_vars}{Indicates if variable names should
be part of the labels. Defaults to \code{TRUE}.}

\item{...}{Currently unused.}
}
\value{
A character vector of the same length as the number
  of rows of \code{x}.
}
\description{
Convert information in rows to labels for each row.
}
\seealso{
\code{\link{make_conditions}}, \code{\link{conditional_effects}}
}
