% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibtex.R
\name{write.bib}
\alias{write.bib}
\title{Generate a Bibtex File from Package Citations}
\usage{
write.bib(entry, file = "Rpackages.bib", append = FALSE, verbose = TRUE)
}
\arguments{
\item{entry}{a \code{\link{bibentry}} object or a character vector of package
names. If \code{NULL}, then the list of all installed packages is used.}

\item{file}{output Bibtex file.}

\item{append}{logical. If \code{TRUE} content is appended to the file.}

\item{verbose}{a logical to toggle verbosity.}
}
\value{
the list of Bibtex objects -- invisibly.
}
\description{
Generates a Bibtex file from a list of packages or all the installed packages.
It is useful for adding relevant citations in Sweave documents.
}
\examples{

write.bib(c('bibtex', 'utils', 'tools'), file='references')
bibs <- read.bib('references.bib')
write.bib(bibs, 'references2.bib')
md5 <- tools::md5sum(c('references.bib', 'references2.bib'))
md5[1] == md5[2]

\dontshow{unlink(c('references.bib', 'references2.bib'))}
}
\references{
\emph{[R] Creating bibtex file of all installed packages?}
Achim Zeileis. R-help mailing list.
}
\author{
Renaud Gaujoux, based on the function \code{Rpackages.bib}
from Achim Zeileis (see \emph{References}).
}
