/*
  This file was generated by the Qt Quick 1 Application wizard of Qt Creator.
  QtQuick1ApplicationViewer is a convenience class containing mobile device
  specific code such as screen orientation handling. Also QML paths are
  handled here.
  It is recommended not to modify this file, since newer versions of Qt Creator
  may offer an updated version of it.
*/

#include "qtquick1applicationviewer.h"

#include <QDir>
#include <QFileInfo>
#include <QApplication>
#include <QDeclarativeComponent>
#include <QDeclarativeEngine>
#include <QDeclarativeContext>

#include <qplatformdefs.h> // MEEGO_EDITION_HARMATTAN

class QtQuick1ApplicationViewerPrivate
{
    QString mainQmlFile;
    friend class QtQuick1ApplicationViewer;
    static QString adjustPath(const QString &path);
};

QString QtQuick1ApplicationViewerPrivate::adjustPath(const QString &path)
{
#if defined(Q_OS_IOS)
    if (!QDir::isAbsolutePath(path))
        return QString::fromLatin1("%1/%2")
                .arg(QCoreApplication::applicationDirPath(), path);
#elif defined(Q_OS_MAC)
    if (!QDir::isAbsolutePath(path))
        return QString::fromLatin1("%1/../Resources/%2")
                .arg(QCoreApplication::applicationDirPath(), path);
#elif defined(Q_OS_BLACKBERRY)
    if (!QDir::isAbsolutePath(path))
        return QString::fromLatin1("app/native/%1").arg(path);
#elif !defined(Q_OS_ANDROID)
    QString pathInInstallDir =
            QString::fromLatin1("%1/../%2").arg(
                QCoreApplication::applicationDirPath(), path);
    if (QFileInfo(pathInInstallDir).exists())
        return pathInInstallDir;
    pathInInstallDir =
            QString::fromLatin1("%1/%2").arg(
                QCoreApplication::applicationDirPath(), path);
    if (QFileInfo(pathInInstallDir).exists())
        return pathInInstallDir;
#endif
    return path;
}

QtQuick1ApplicationViewer::QtQuick1ApplicationViewer(QWidget *parent)
    : QDeclarativeView(parent)
    , d(new QtQuick1ApplicationViewerPrivate())
{
    connect(engine(), SIGNAL(quit()), SLOT(close()));
    setResizeMode(QDeclarativeView::SizeRootObjectToView);
}

QtQuick1ApplicationViewer::~QtQuick1ApplicationViewer()
{
    delete d;
}

QtQuick1ApplicationViewer *QtQuick1ApplicationViewer::create()
{
    return new QtQuick1ApplicationViewer();
}

void QtQuick1ApplicationViewer::setMainQmlFile(const QString &file)
{
    d->mainQmlFile = QtQuick1ApplicationViewerPrivate::adjustPath(file);
#ifdef Q_OS_ANDROID
    setSource(QUrl(QLatin1String("assets:/")+d->mainQmlFile));
#else
    setSource(QUrl::fromLocalFile(d->mainQmlFile));
#endif
}

void QtQuick1ApplicationViewer::addImportPath(const QString &path)
{
    engine()->addImportPath(QtQuick1ApplicationViewerPrivate::adjustPath(path));
}

void QtQuick1ApplicationViewer::setOrientation(ScreenOrientation orientation)
{
#if QT_VERSION < 0x050000
    Qt::WidgetAttribute attribute;
    switch (orientation) {
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
    };
    setAttribute(attribute, true);
#else // QT_VERSION < 0x050000
    Q_UNUSED(orientation)
#endif // QT_VERSION < 0x050000
}

void QtQuick1ApplicationViewer::showExpanded()
{
#if defined(Q_WS_SIMULATOR) || defined(Q_OS_QNX)
    showFullScreen();
#else
    show();
#endif
}
