% MBEDFLSH(1) 1.4.4 | User Commands
% 
% December 2018

# NAME

**mbedflsh** - flash Mbed Enabled devices from the command line

# SYNOPSIS

| **mbedflsh** **\-\-file** _FILE_ **\-\-disk** _TARGET\_PATH_ \[**\-\-copy** _METHOD_\]

| **mbedflsh** **\–\-plugins**

| **mbedflsh** **\–\-version**

| **mbedflsh** **\–\-help**

# DESCRIPTION

**mbedflsh** allows a file to be flashed directly to a mounted Mbed Enabled
device from the command line.

Whilst test automation tools such as **mbed-test-wrapper** can provide
automated flashing of Mbed devices after successful embedded software build,
**mbedflsh** provides a simple and convenient CLI to flash devices directly.

# OPTIONS

-f, \-\-file _FILE_
:   file to flash onto Mbed Enabled device

-d, \-\-disk _TARGET\_PATH_
:   target path (mount point) to flash file to

-c, \-\-copy _METHOD_
:   method to use for flashing; use `mbedflsh --plugins` to see available plugins

\-\-plugins
:   print registered plugins and exit

\-\-version
:   print version and exit

\-\-help
:   print usage details and exit

# EXAMPLES

To flash the file `/tmp/firmware.bin` to the mounted path `/mnt/MBED`, run:

```
$ mbedflsh --file /tmp/firmware.bin --disk /mnt/MBED
```

# REPORTING BUGS

Upstream bug tracker: https://github.com/ARMmbed/htrun/issues

# COPYRIGHT

Copyright (c) 2011-2018 ARM Limited

# AUTHOR

This manual page is based on the mbed-host-tests documentation. It was created by Nick Morrott <nickm@debian.org> for the Debian GNU/Linux system, but may be used by others

# SEE ALSO

**yotta**(1), **mbed-test-wrapper**(1), **mbedhtrun**(1)
