# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class B2CResourceSKUName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The name of the SKU for the tenant.
    """

    STANDARD = "Standard"  #: Azure AD B2C usage is billed to a linked Azure subscription and uses a monthly active users (MAU) billing model.
    PREMIUM_P1 = "PremiumP1"  #: Azure AD B2C usage is billed to a linked Azure subscription and uses number of authentications based billing.
    PREMIUM_P2 = "PremiumP2"  #: Azure AD B2C usage is billed to a linked Azure subscription and uses number of authentications based billing.

class BillingType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of billing. Will be MAU for all new customers. If 'Auths', it can be updated to 'MAU'.
    Cannot be changed if value is 'MAU'. Learn more about Azure AD B2C billing at
    `aka.ms/b2cBilling <https://aka.ms/b2cbilling>`_.
    """

    MAU = "MAU"  #: Azure AD B2C usage is billed to a linked Azure subscription and uses a monthly active users (MAU) billing model.
    AUTHS = "Auths"  #: Azure AD B2C usage is billed to a linked Azure subscription and uses number of authentications based billing.

class NameAvailabilityReasonType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes the reason for the 'nameAvailable' value.
    """

    ALREADY_EXISTS = "AlreadyExists"  #: The name is already in use and is therefore unavailable.
    INVALID = "Invalid"  #: The name provided does not match the resource provider’s naming requirements (incorrect length, unsupported characters, etc.).

class StatusType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the operation.
    """

    SUCCEEDED = "Succeeded"  #: The operation succeeded.
    PENDING = "Pending"  #: The operation is pending.
    FAILED = "Failed"  #: The operation failed.
