/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexOutput;

public abstract class IndexInput
extends DataInput
implements Cloneable,
Closeable {
    protected byte[] copyBuf = null;

    @Deprecated
    public void skipChars(int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            byte b = this.readByte();
            if ((b & 0x80) == 0) continue;
            if ((b & 0xE0) != 224) {
                this.readByte();
                continue;
            }
            this.readByte();
            this.readByte();
        }
    }

    public abstract void close() throws IOException;

    public abstract long getFilePointer();

    public abstract void seek(long var1) throws IOException;

    public abstract long length();

    public void copyBytes(IndexOutput out, long numBytes) throws IOException {
        assert (numBytes >= 0L) : "numBytes=" + numBytes;
        if (this.copyBuf == null) {
            this.copyBuf = new byte[1024];
        }
        while (numBytes > 0L) {
            int toCopy = (int)(numBytes > (long)this.copyBuf.length ? (long)this.copyBuf.length : numBytes);
            this.readBytes(this.copyBuf, 0, toCopy);
            out.writeBytes(this.copyBuf, 0, toCopy);
            numBytes -= (long)toCopy;
        }
    }
}

