------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--                                S H E L L                                 --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--           Copyright (C) 2008, Free Software Foundation, Inc.             --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 51 Franklin Street, Fifth    --
-- Floor, Boston, MA 02111-1301, USA.                                       --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO; use Ada.Text_IO;

package body Shell is

   procedure Interact is
      Line    : String (1 .. 80);
      Last    : Integer;
      Space   : Integer;
      Command : Command_Type;
   begin
      Main_Loop : loop
         begin
            Get_Command : loop
               Put ("> ");
               Get_Line (Line, Last);
               Space := 1;
               while Space <= Last and then Line (Space) /= ' ' loop
                  Space := Space + 1;
               end loop;

               begin
                  Command := Command_Type'Value (Line (1 .. Space - 1));
                  exit Get_Command;
               exception
                  when Constraint_Error =>
                     Put_Line ("?");
               end;
            end loop Get_Command;
            Handle_Command (Command, Line (Space + 1 .. Last));
         end;
      end loop Main_Loop;
   exception
      when Exit_Shell =>
         null;
   end Interact;
end Shell;
