package org.codehaus.plexus.classworlds;

/*
 * Copyright 2001-2006 Codehaus Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * @author <a href="bwalding@jakarta.org">Ben Walding</a>
 */
public class TestUtil
{

    public static URL getTestResourceUrl( String resourceName )
    {
        File baseDir = new File( getBasedir() );

        File testDir = new File( baseDir, "src/test/test-data" );

        File resourceFile = new File( testDir, resourceName );

        try
        {
            return resourceFile.toURI().toURL();
        }
        catch ( MalformedURLException e )
        {
            throw new RuntimeException( e );
        }
    }

    public static String getBasedir()
    {
        String basedir = System.getProperty( "basedir" );

        /* do our best if we are not running from surefire */
        if ( basedir == null || basedir.length() <= 0 )
        {
            basedir = ( new File( "" ) ).getAbsolutePath();
        }

        return basedir;
    }

}
