/***************************************************************************
 *   Copyright (C) 2009 by Mathias Rabe <masterunderlined [at] web.de>     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/
#include <kdebug.h>
#include <klocalizedstring.h>

#include "urlgenerator.h" 

UrlGenerator::UrlGenerator()
{

}

UrlGenerator::~UrlGenerator()
{

}

void UrlGenerator::setProtocol(const QString &newProtocol)
{
    protocol = newProtocol;
    generateDummyUrl();
}

void UrlGenerator::setUrl(const KUrl &newUrl)
{
    url = newUrl;
    generateDummyUrl();
}

void UrlGenerator::setUrl(const QString &newUrl)
{
    url = KUrl(newUrl);
    generateDummyUrl();
}

void UrlGenerator::setSyntax(const QString &newSyntax)
{
    syntax = newSyntax;
    generateDummyUrl();
}

/******************************/

void UrlGenerator::usableUrl()
{
    newUrl.append(protocol);
    for(int i = 0; i < syntax.size(); i++) {
        if (syntax.at(i) != '%') {
            newUrl.append(syntax.at(i));
        } else {
            if (++i >= syntax.size()) {
                break;
            }
            if (syntax.at(i) == 'h') {
                QString str;
                str.append(url.prettyUrl());
                str.remove(url.protocol());
                str.remove(0, 3); //because of :// remaining
                if (str.contains(":")) { //remove port if given
                    //remove everything between ":" and "/"
                    str.remove(str.indexOf(":"), str.indexOf("/", str.indexOf(":")) - str.indexOf(":"));
                }
                str.remove(url.path());
                newUrl.append(str);
            } else if (syntax.at(i) == 'p') {
                newUrl.append(url.path(/*KUrl::RemoveTrailingSlash*/));
            }
        }
    }
}

/******************************/

void UrlGenerator::generateDummyUrl()
{
    newUrl.clear();
    if (syntax.isEmpty() || url == "") {
        emit dummyUrlGenerated(newUrl);
        return;
    }
    usableUrl();
    newUrl.append(i18n("/<FILENAME>"));
    emit dummyUrlGenerated(newUrl);
}

QString UrlGenerator::dummyUrl()
{
    return newUrl;
}

/******************************/

QStringList UrlGenerator::generateUrlList(const QStringList &urlList)
{
    newUrl.clear();
    usableUrl();

    QStringList strList;
    QStringListIterator urlIterator(urlList);
    QString str;
    while (urlIterator.hasNext()) {
        str = urlIterator.next();
        str.remove(0, str.lastIndexOf("/"));
        strList << newUrl + str;
    }

    return strList;
}
