/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

%{

/* Bikous d'includes ici didon!
 */
#include <src/global/global.h>

#include <src/donnees/general/general.h>
#include <src/analyseur/donnees/pilechaine.h>
#include <src/analyseur/donnees/pileentier.h>
#include <src/analyseur/donnees/pilelocalisationfichier.h>

#include <src/analyseur/donnees/filenomfichier.h>

#include <src/donnees/flux/flux.h>
#include <src/donnees/commandes/localisationfichier.h>
#include <src/donnees/commandes/commande.h>
#include <src/donnees/commandes/commandeoption.h>
#include <src/donnees/commandes/commandeoptions.h>
#include <src/donnees/commandes/commandedefine.h>
#include <src/donnees/commandes/commandewarning.h>
#include <src/donnees/commandes/commandeerror.h>
#include <src/donnees/commandes/commandestart.h>
#include <src/donnees/commandes/commandehead.h>
#include <src/donnees/commandes/commandefoot.h>
#include <src/donnees/commandes/commandesection.h>
#include <src/donnees/commandes/commandereference.h>
#include <src/donnees/commandes/commandemessage.h>
#include <src/donnees/commandes/commandetitle.h>
#include <src/donnees/commandes/commanderef.h>
#include <src/donnees/commandes/commandetxt.h>
#include <src/donnees/commandes/commandesec.h>
#include <src/donnees/commandes/commandemesg.h>
#include <src/donnees/commandes/commandeidea.h>
#include <src/donnees/commandes/commandemissing.h>
#include <src/donnees/commandes/commandegeneric.h>
#include <src/donnees/commandes/commandeindex.h>
#include <src/donnees/commandes/commandeextref.h>
#include <src/donnees/commandes/commandeextrefs.h>
#include <src/donnees/commandes/commandedep.h>
#include <src/donnees/commandes/commandedepref.h>
#include <src/donnees/commandes/commandedepref.h>
#include <src/donnees/commandes/commandecommentaire.h>
#include <src/donnees/commandes/commandeechappement.h>
#include <src/donnees/commandes/commandetexte.h>
#include <src/donnees/commandes/commandemacro.h>
#include <src/donnees/commandes/commandeparametre.h>


/* Debuguons un peu...
 */
#define YYDEBUG	0
int yydebug=0;

/* Elements gnrs par flex et bison
 */
extern FILE *yyin;
extern int yylex();

void yyerror();


extern STOCKAGE(General) general;
STOCKAGE_SCALAIRE(Entier) niveauimbricationmacro=0;
/* Sert  reprer le niveau d'imbrication des appels
 * de macros, lors de leur enregistrement dans yylex().
 */

/* Quelques fonctions utiles pour la construction des flux
 */
 
static Resultat analyseur_detruiredernierelocalisation(TRAVAIL(PileLocalisationFichier) pilelocalisation)
{
	/* Permet de detruire les localisations des tokens ne correspondant pas  une commande,
	 * comme #end, #{ et #}, ou correspondant  des commandes sans localisation, comme
	 * #txt, #case et #other.
	 * Renvoie RESULTAT_ERREUR si pilelocalisation vaut NULL.
	 * Renvoie RESULTAT_ERREUR si la pile est vide.
	 */
	STOCKAGE(LocalisationFichier) localisationobsolete;
	TRAVAIL_SCALAIRE(Booleen) pile_vide;
	DEBUTZONESECURISEE
	if(S_T(pilelocalisation)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(pilelocalisationfichier_vide(pilelocalisation,R_T_(pile_vide)));
	if(pile_vide==T_S_(VRAI))
		return RESULTAT_ERREUR;
	SECURISE(pilelocalisationfichier_retrait(pilelocalisation,C_S(localisationobsolete)));
	SECURISE(localisationfichier_destruction(T_S(localisationobsolete)));
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat analyseur_verificationcopielocalisation(TRAVAIL(Environnement) environnement , REFERENCE_SCALAIRE(Booleen) copielocalisation)
{
	/* Sert  dterminer si les localisations de fichier doivent tre affiches.
	 * Renvoie RESULTAT_ERREUR si environnement vaut NULL.
	 */
	TRAVAIL(Options) options;
	DEBUTZONESECURISEE
	if(S_T(environnement)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(environnement_lecture_options(environnement,R_T(options)));
	SECURISE(options_lecture_copielocalisation(options,copielocalisation));
	FINZONESECURISEE
	return RESULTAT_OK;
}

%}

%union	{	STOCKAGE_SCALAIRE(Chaine) _Chaine;
		STOCKAGE_SCALAIRE(Entier) _Entier;
		STOCKAGE(struct flux) _Flux;
		STOCKAGE(struct commande) _Commande;
		STOCKAGE(struct commandeoption) _CommandeOption;
		STOCKAGE(struct commandeoptions) _CommandeOptions;
		STOCKAGE(struct commandeoptionsclauses) _CommandeOptionsClauses;
		STOCKAGE(struct commandeoptionsclause) _CommandeOptionsClause;
		STOCKAGE(struct commandedefine) _CommandeDefine;
		STOCKAGE(struct commandewarning) _CommandeWarning;
		STOCKAGE(struct commandeerror) _CommandeError;
		STOCKAGE(struct commandestart) _CommandeStart;
		STOCKAGE(struct commandehead) _CommandeHead;
		STOCKAGE(struct commandefoot) _CommandeFoot;
		STOCKAGE(struct commandesection) _CommandeSection;
		STOCKAGE(struct commandereference) _CommandeReference;
		STOCKAGE(struct commandemessage) _CommandeMessage;
		STOCKAGE(struct commandetitle) _CommandeTitle;
		STOCKAGE(struct commanderef) _CommandeRef;
		STOCKAGE(struct commandetxt) _CommandeTxt;
		STOCKAGE(struct commandesec) _CommandeSec;
		STOCKAGE(struct commandemesg) _CommandeMesg;
		STOCKAGE(struct commandeidea) _CommandeIdea;
		STOCKAGE(struct commandemissing) _CommandeMissing;
		STOCKAGE(struct commandegeneric) _CommandeGeneric;
		STOCKAGE(struct commandeindex) _CommandeIndex;
		STOCKAGE(struct commandeextref) _CommandeExtRef;
		STOCKAGE(struct commandeextrefs) _CommandeExtRefs;
		STOCKAGE(struct commandedep) _CommandeDep;
		STOCKAGE(struct commandedepref) _CommandeDepRef;
		STOCKAGE(struct commandecommentaire) _CommandeCommentaire;
		STOCKAGE(struct commandeechappement) _CommandeEchappement;
		STOCKAGE(struct commandetexte) _CommandeTexte;
		STOCKAGE(struct commandemacro) _CommandeMacro;
		STOCKAGE(struct commandemacroparametres) _CommandeMacroParametres;
		STOCKAGE(struct commandeparametre) _CommandeParametre;
		STOCKAGE(struct commandeinclude) _CommandeInclude;
		STOCKAGE(struct commandestandard) _CommandeStandard;
	}

%token TOKEN_TEXTE

%token TOKEN_STANDARD
%token TOKEN_INCLUDE

%token TOKEN_OPTION
%token TOKEN_OPTIONS
%token TOKEN_CASE
%token TOKEN_OTHER
%token TOKEN_END


%token TOKEN_DEFINE
%token TOKEN_PARAMETRE

%token TOKEN_MACRO


%token TOKEN_WARNING
%token TOKEN_ERROR

%token TOKEN_START
%token TOKEN_HEAD
%token TOKEN_FOOT
%token TOKEN_SECTION
%token TOKEN_REFERENCE
%token TOKEN_MESSAGE

%token TOKEN_TITLE
%token TOKEN_REF
%token TOKEN_TXT
%token TOKEN_SEC
%token TOKEN_MESG

%token TOKEN_IDEA
%token TOKEN_MISSING
%token TOKEN_GENERIC
%token TOKEN_TEXT

%token TOKEN_INDEX
%token TOKEN_EXTREF
%token TOKEN_EXTREFS

%token TOKEN_DEP
%token TOKEN_DEPREF

%token TOKEN_COMMENT

%token TOKEN_PARAM_DEBUT
%token TOKEN_PARAM_FIN

%token TOKEN_ECHAP_COMMANDE
%token TOKEN_ECHAP_PARAM_DEBUT
%token TOKEN_ECHAP_PARAM_FIN
%token TOKEN_ECHAP_RETOURLIGNE
%token TOKEN_ECHAP_ESPACE
%token TOKEN_ECHAP_TAB

/* Declaration des types.
 */

%type<_Flux>			flux_planfacile

%type<_Flux>			flux
%type<_Commande>		commande
%type<_CommandeOption>		commande_option
%type<_CommandeOptions>		commande_options
%type<_CommandeOptionsClauses>	liste_options
%type<_CommandeOptionsClause>	option
%type<_CommandeDefine>		commande_define
%type<_CommandeError>		commande_error
%type<_CommandeWarning>		commande_warning
%type<_CommandeStart>		commande_start
%type<_CommandeHead>		commande_head
%type<_CommandeFoot>		commande_foot
%type<_CommandeSection>		commande_section
%type<_CommandeReference>	commande_reference
%type<_CommandeMessage>		commande_message
%type<_CommandeTitle>		commande_title
%type<_CommandeRef>		commande_ref
%type<_CommandeTxt>		commande_txt
%type<_CommandeSec>		commande_sec
%type<_CommandeMesg>		commande_mesg
%type<_CommandeIdea>		commande_idea
%type<_CommandeMissing>		commande_missing
%type<_CommandeGeneric>		commande_generic
%type<_CommandeIndex>		commande_index
%type<_CommandeExtRef>		commande_extref
%type<_CommandeExtRefs>		commande_extrefs
%type<_CommandeDep>		commande_dep
%type<_CommandeDepRef>		commande_depref
%type<_CommandeCommentaire>	commande_comment
%type<_CommandeEchappement>	commande_echappement
%type<_CommandeTexte>		commande_texte
%type<_CommandeMacro>		commande_macro
%type<_CommandeMacroParametres>	liste_parametre
%type<_CommandeParametre>	commande_parametre
%type<_CommandeInclude>		commande_include
%type<_CommandeStandard>	commande_standard

%type<_Chaine>			parametre_texte
%type<_Flux>			parametre_flux


%start flux_planfacile

%%

flux_planfacile: flux
	{
		DEBUTZONESECURISEE
		SECURISE(flux_definition_type(T_S($1),T_S_(FLUX_PRINCIPAL)));
		FINZONESECURISEE
		CHAMP_STOCKAGE(general , principal)=$1;
	}

flux:
	{	
		/* Initialisation d'un nouveau flux
		 */
		STOCKAGE(Flux) flux;
		DEBUTZONESECURISEE
		SECURISE(flux_initialisation(T_S(flux)));
		FINZONESECURISEE
		$$=flux;
	}
|	flux commande
	{
		/* Ajout d'un commande dans le flux courant
		 */
		DEBUTZONESECURISEE
		SECURISE(flux_ajout_commande(T_S($1),T_S($2),T_S(general)));
		SECURISE(commande_destruction(T_S($2)));
		FINZONESECURISEE
		$$=$1;
	};


commande:	commande_standard
	{
		/* commande gre par l'analyseur lexical, elle n'est prsente ici que pour valider la grammaire
		 */
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_standard(T_S(commande),T_S($1)));
		SECURISE(commandestandard_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_include
	{
		/* commande gre par l'analyseur lexical, elle n'est prsente ici que pour valider la grammaire
		 */
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_include(T_S(commande),T_S($1)));
		SECURISE(commandeinclude_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_option
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_option(T_S(commande),T_S($1)));
		SECURISE(commandeoption_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_options
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_options(T_S(commande),T_S($1)));
		SECURISE(commandeoptions_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_define
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_define(T_S(commande),T_S($1)));
		SECURISE(commandedefine_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_warning
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_warning(T_S(commande),T_S($1)));
		SECURISE(commandewarning_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_error
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_error(T_S(commande),T_S($1)));
		SECURISE(commandeerror_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_start
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_start(T_S(commande),T_S($1)));
		SECURISE(commandestart_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_head
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_head(T_S(commande),T_S($1)));
		SECURISE(commandehead_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_foot
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_foot(T_S(commande),T_S($1)));
		SECURISE(commandefoot_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_section
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_section(T_S(commande),T_S($1)));
		SECURISE(commandesection_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_reference
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_reference(T_S(commande),T_S($1)));
		SECURISE(commandereference_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_message
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_message(T_S(commande),T_S($1)));
		SECURISE(commandemessage_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_title
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_title(T_S(commande),T_S($1)));
		SECURISE(commandetitle_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_ref
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_ref(T_S(commande),T_S($1)));
		SECURISE(commanderef_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_txt
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_txt(T_S(commande),T_S($1)));
		SECURISE(commandetxt_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_sec
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_sec(T_S(commande),T_S($1)));
		SECURISE(commandesec_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_mesg
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_mesg(T_S(commande),T_S($1)));
		SECURISE(commandemesg_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_idea
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_idea(T_S(commande),T_S($1)));
		SECURISE(commandeidea_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_missing
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_missing(T_S(commande),T_S($1)));
		SECURISE(commandemissing_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_generic
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_generic(T_S(commande),T_S($1)));
		SECURISE(commandegeneric_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_index
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_index(T_S(commande),T_S($1)));
		SECURISE(commandeindex_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_extref
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_extref(T_S(commande),T_S($1)));
		SECURISE(commandeextref_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_extrefs
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_extrefs(T_S(commande),T_S($1)));
		SECURISE(commandeextrefs_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_dep
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_dep(T_S(commande),T_S($1)));
		SECURISE(commandedep_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_depref
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_depref(T_S(commande),T_S($1)));
		SECURISE(commandedepref_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_comment
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_commentaire(T_S(commande),T_S($1)));
		SECURISE(commandecommentaire_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_echappement
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_echappement(T_S(commande),T_S($1)));
		SECURISE(commandeechappement_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_texte
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_texte(T_S(commande),T_S($1)));
		SECURISE(commandetexte_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_macro
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_macro(T_S(commande),T_S($1)));
		SECURISE(commandemacro_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	}
|		commande_parametre
	{
		STOCKAGE(Commande) commande;
		DEBUTZONESECURISEE
		SECURISE(commande_initialisation(T_S(commande)));
		SECURISE(commande_definition_parametre(T_S(commande),T_S($1)));
		SECURISE(commandeparametre_destruction(T_S($1)));
		FINZONESECURISEE
		$$=commande;
	};

commande_include:	TOKEN_INCLUDE
	{
		/* L'inclusion est gre par l'analyseur lexical
		 */
		STOCKAGE(CommandeInclude) commandeinclude;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(NomFichier) nomfichierinclude;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandeinclude_initialisation(T_S(commandeinclude)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandeinclude_definition_localisationfichier(T_S(commandeinclude),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandeinclude_definition_localisationfichier(T_S(commandeinclude),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		SECURISE(localisationfichier_lecture_nom(T_S(CHAMP_STOCKAGE(general , localisation)),R_T_(nomfichierinclude)));
		SECURISE(commandeinclude_definition_inclusion(T_S(commandeinclude),nomfichierinclude));
		FINZONESECURISEE
		$$=commandeinclude;
	};

commande_standard:	TOKEN_STANDARD
	{
		/* L'inclusion est gre par l'analyseur lexical
		 */
		STOCKAGE(CommandeStandard) commandestandard;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandestandard_initialisation(T_S(commandestandard)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandestandard_definition_localisationfichier(T_S(commandestandard),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandestandard_definition_localisationfichier(T_S(commandestandard),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandestandard;
	};

commande_option:	TOKEN_OPTION parametre_texte
	{
		STOCKAGE(CommandeOption) commandeoption;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandeoption_initialisation(T_S(commandeoption)));
		SECURISE(commandeoption_definition_option(T_S(commandeoption),(TRAVAIL_SCALAIRE(NomOption))(T_S_($2))));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandeoption_definition_localisationfichier(T_S(commandeoption),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandeoption_definition_localisationfichier(T_S(commandeoption),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		free($2);
		FINZONESECURISEE
		$$=commandeoption;
	};

commande_options:	TOKEN_OPTIONS parametre_texte liste_options TOKEN_END
	{
		STOCKAGE(CommandeOptions) commandeoptions;
		STOCKAGE(LocalisationFichier) localisation;
		STOCKAGE(Flux) fluxvide;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(analyseur_detruiredernierelocalisation(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));//localisation du TOKEN_END
		SECURISE(commandeoptions_initialisation(T_S(commandeoptions)));
		SECURISE(commandeoptions_definition_label(T_S(commandeoptions),T_S_($2)));
		SECURISE(commandeoptions_definition_clauses(T_S(commandeoptions),T_S($3)));
		SECURISE(flux_initialisation(T_S(fluxvide)));
		SECURISE(flux_definition_type(T_S(fluxvide),T_S_(FLUX_OPTIONS)));
		SECURISE(commandeoptions_definition_autres(T_S(commandeoptions),T_S(fluxvide)));
		SECURISE(commandeoptionsclauses_destruction(T_S($3)));
		SECURISE(flux_destruction(T_S(fluxvide)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandeoptions_definition_localisationfichier(T_S(commandeoptions),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandeoptions_definition_localisationfichier(T_S(commandeoptions),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		free($2);
		FINZONESECURISEE
		$$=commandeoptions;
	}
|			TOKEN_OPTIONS parametre_texte liste_options TOKEN_OTHER flux TOKEN_END
	{
		STOCKAGE(CommandeOptions) commandeoptions;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(analyseur_detruiredernierelocalisation(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));//localisation du TOKEN_END
		SECURISE(analyseur_detruiredernierelocalisation(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));//localisation du TOKEN_OTHER
		SECURISE(commandeoptions_initialisation(T_S(commandeoptions)));
		SECURISE(commandeoptions_definition_label(T_S(commandeoptions),T_S_($2)));
		SECURISE(commandeoptions_definition_clauses(T_S(commandeoptions),T_S($3)));
		SECURISE(flux_definition_type(T_S($5),T_S_(FLUX_OPTIONS)));
		SECURISE(commandeoptions_definition_autres(T_S(commandeoptions),T_S($5)));
		SECURISE(commandeoptionsclauses_destruction(T_S($3)));
		SECURISE(flux_destruction(T_S($5)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandeoptions_definition_localisationfichier(T_S(commandeoptions),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandeoptions_definition_localisationfichier(T_S(commandeoptions),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		free($2);
		FINZONESECURISEE
		$$=commandeoptions;
	};
liste_options:	liste_options option
	{
		DEBUTZONESECURISEE
		SECURISE(commandeoptionsclauses_ajout_clause(T_S($1),T_S($2)));
		SECURISE(commandeoptionsclause_destruction(T_S($2)));
		FINZONESECURISEE
		$$=$1;
	}
|
	{
		STOCKAGE(CommandeOptionsClauses) commandeoptionsclauses;
		DEBUTZONESECURISEE
		SECURISE(commandeoptionsclauses_initialisation(T_S(commandeoptionsclauses)));
		FINZONESECURISEE
		$$=commandeoptionsclauses;
	};
option:	TOKEN_CASE parametre_texte flux
	{
		STOCKAGE(CommandeOptionsClause) commandeoptionsclause;
		DEBUTZONESECURISEE
		SECURISE(commandeoptionsclause_initialisation(T_S(commandeoptionsclause)));
		SECURISE(flux_definition_type(T_S($3),T_S_(FLUX_OPTIONS)));
		SECURISE(commandeoptionsclause_definition(T_S(commandeoptionsclause),T_S_($2),T_S($3)));
		free($2);
		SECURISE(flux_destruction(T_S($3)));
		SECURISE(analyseur_detruiredernierelocalisation(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));//localisation du TOKEN_CASE
		FINZONESECURISEE
		$$=commandeoptionsclause;
	};

commande_define:	TOKEN_DEFINE parametre_texte parametre_flux
	{
		STOCKAGE(CommandeDefine) commandedefine;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandedefine_initialisation(T_S(commandedefine)));
		SECURISE(commandedefine_definition_nom(T_S(commandedefine),(TRAVAIL_SCALAIRE(NomMacro))(T_S_($2))));
		SECURISE(flux_definition_type(T_S($3),T_S_(FLUX_MACRO_DEFINITION)));
		SECURISE(commandedefine_definition_definition(T_S(commandedefine),T_S($3)));
		SECURISE(flux_destruction(T_S($3)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandedefine_definition_localisationfichier(T_S(commandedefine),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandedefine_definition_localisationfichier(T_S(commandedefine),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		free($2);
		FINZONESECURISEE
		$$=commandedefine;
	};

commande_warning:	TOKEN_WARNING parametre_flux
	{
		STOCKAGE(CommandeWarning) commandewarning;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandewarning_initialisation(T_S(commandewarning)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_COMPILATEUR)));
		SECURISE(commandewarning_definition_avertissement(T_S(commandewarning),T_S($2)));
		SECURISE(flux_destruction(T_S($2)));	
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandewarning_definition_localisationfichier(T_S(commandewarning),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandewarning_definition_localisationfichier(T_S(commandewarning),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandewarning;
	};

commande_error:		TOKEN_ERROR parametre_flux
	{
		STOCKAGE(CommandeError) commandeerror;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandeerror_initialisation(T_S(commandeerror)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_COMPILATEUR)));
		SECURISE(commandeerror_definition_erreur(T_S(commandeerror),T_S($2)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandeerror_definition_localisationfichier(T_S(commandeerror),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandeerror_definition_localisationfichier(T_S(commandeerror),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandeerror;
	};

commande_start:		TOKEN_START parametre_flux
	{
		STOCKAGE(CommandeStart) commandestart;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandestart_initialisation(T_S(commandestart)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_NIVEAU)));
		SECURISE(commandestart_definition_niveau(T_S(commandestart),T_S($2)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandestart_definition_localisationfichier(T_S(commandestart),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandestart_definition_localisationfichier(T_S(commandestart),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandestart;
	};

commande_head:		TOKEN_HEAD parametre_flux
	{
		STOCKAGE(CommandeHead) commandehead;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandehead_initialisation(T_S(commandehead)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_DOCUMENT)));
		SECURISE(commandehead_definition_entete(T_S(commandehead),T_S($2)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandehead_definition_localisationfichier(T_S(commandehead),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandehead_definition_localisationfichier(T_S(commandehead),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandehead;
	};

commande_foot:		TOKEN_FOOT parametre_flux
	{
		STOCKAGE(CommandeFoot) commandefoot;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandefoot_initialisation(T_S(commandefoot)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_DOCUMENT)));
		SECURISE(commandefoot_definition_pied(T_S(commandefoot),T_S($2)));
		SECURISE(flux_destruction(T_S($2)));	
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandefoot_definition_localisationfichier(T_S(commandefoot),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandefoot_definition_localisationfichier(T_S(commandefoot),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandefoot;
	};

commande_section:	TOKEN_SECTION parametre_flux parametre_flux parametre_flux parametre_flux parametre_flux
	{	
		STOCKAGE(CommandeSection) commandesection;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		STOCKAGE(Flux) fluxnul;
		DEBUTZONESECURISEE
		fluxnul=NULL;
		SECURISE(commandesection_initialisation(T_S(commandesection)));
		SECURISE(commandesection_definition_niveau(T_S(commandesection),T_S(fluxnul)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_SECTION_NOM)));
		SECURISE(commandesection_definition_nom(T_S(commandesection),T_S($2)));
		SECURISE(flux_definition_type(T_S($3),T_S_(FLUX_SECTION_FORMAT)));
		SECURISE(commandesection_definition_formatavant(T_S(commandesection),T_S($3)));
		SECURISE(flux_definition_type(T_S($4),T_S_(FLUX_SECTION_FORMAT)));
		SECURISE(commandesection_definition_formatapres(T_S(commandesection),T_S($4)));
		SECURISE(flux_definition_type(T_S($5),T_S_(FLUX_SECTION_SECTION)));
		SECURISE(commandesection_definition_presection(T_S(commandesection),T_S($5)));
		SECURISE(flux_definition_type(T_S($6),T_S_(FLUX_SECTION_SECTION)));
		SECURISE(commandesection_definition_postsection(T_S(commandesection),T_S($6)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(flux_destruction(T_S($3)));
		SECURISE(flux_destruction(T_S($4)));
		SECURISE(flux_destruction(T_S($5)));
		SECURISE(flux_destruction(T_S($6)));
		SECURISE(pilelocalisationfichier_echange(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandesection_definition_localisationfichier(T_S(commandesection),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandesection_definition_localisationfichier(T_S(commandesection),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandesection;
	}
|			TOKEN_SECTION parametre_flux parametre_flux parametre_flux parametre_flux parametre_flux parametre_flux
	{
		STOCKAGE(CommandeSection) commandesection;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandesection_initialisation(T_S(commandesection)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_NIVEAU)));
		SECURISE(commandesection_definition_niveau(T_S(commandesection),T_S($2)));
		SECURISE(flux_definition_type(T_S($3),T_S_(FLUX_SECTION_NOM)));
		SECURISE(commandesection_definition_nom(T_S(commandesection),T_S($3)));
		SECURISE(flux_definition_type(T_S($4),T_S_(FLUX_SECTION_FORMAT)));
		SECURISE(commandesection_definition_formatavant(T_S(commandesection),T_S($4)));
		SECURISE(flux_definition_type(T_S($5),T_S_(FLUX_SECTION_FORMAT)));
		SECURISE(commandesection_definition_formatapres(T_S(commandesection),T_S($5)));
		SECURISE(flux_definition_type(T_S($6),T_S_(FLUX_SECTION_SECTION)));
		SECURISE(commandesection_definition_presection(T_S(commandesection),T_S($6)));
		SECURISE(flux_definition_type(T_S($7),T_S_(FLUX_SECTION_SECTION)));
		SECURISE(commandesection_definition_postsection(T_S(commandesection),T_S($7)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(flux_destruction(T_S($3)));
		SECURISE(flux_destruction(T_S($4)));
		SECURISE(flux_destruction(T_S($5)));
		SECURISE(flux_destruction(T_S($6)));
		SECURISE(flux_destruction(T_S($7)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandesection_definition_localisationfichier(T_S(commandesection),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandesection_definition_localisationfichier(T_S(commandesection),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandesection;
	};

commande_reference:	TOKEN_REFERENCE parametre_flux
	{
		STOCKAGE(CommandeReference) commandereference;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		STOCKAGE(Flux) fluxnul;
		DEBUTZONESECURISEE
		fluxnul=NULL;
		SECURISE(commandereference_initialisation(T_S(commandereference)));
		SECURISE(commandereference_definition_niveau(T_S(commandereference),T_S(fluxnul)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_REFERENCE_FORMAT)));
		SECURISE(commandereference_definition_format(T_S(commandereference),T_S($2)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(pilelocalisationfichier_echange(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandereference_definition_localisationfichier(T_S(commandereference),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandereference_definition_localisationfichier(T_S(commandereference),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandereference;
	}
|			TOKEN_REFERENCE parametre_flux parametre_flux
	{
		STOCKAGE(CommandeReference) commandereference;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandereference_initialisation(T_S(commandereference)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_NIVEAU)));
		SECURISE(commandereference_definition_niveau(T_S(commandereference),T_S($2)));
		SECURISE(flux_definition_type(T_S($3),T_S_(FLUX_REFERENCE_FORMAT)));
		SECURISE(commandereference_definition_format(T_S(commandereference),T_S($3)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(flux_destruction(T_S($3)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandereference_definition_localisationfichier(T_S(commandereference),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandereference_definition_localisationfichier(T_S(commandereference),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandereference;
	};

commande_message:	TOKEN_MESSAGE parametre_flux
	{
		STOCKAGE(CommandeMessage) commandemessage;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandemessage_initialisation(T_S(commandemessage)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_MESSAGE)));
		SECURISE(commandemessage_definition_message(T_S(commandemessage),T_S($2)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandemessage_definition_localisationfichier(T_S(commandemessage),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandemessage_definition_localisationfichier(T_S(commandemessage),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandemessage;
	};

commande_title:		TOKEN_TITLE
	{
		STOCKAGE(CommandeTitle) commandetitle;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandetitle_initialisation(T_S(commandetitle)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandetitle_definition_localisationfichier(T_S(commandetitle),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandetitle_definition_localisationfichier(T_S(commandetitle),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandetitle;
	};

commande_ref:		TOKEN_REF
	{
		STOCKAGE(CommandeRef) commanderef;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commanderef_initialisation(T_S(commanderef)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commanderef_definition_localisationfichier(T_S(commanderef),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commanderef_definition_localisationfichier(T_S(commanderef),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commanderef;
	};

commande_txt:		TOKEN_TXT
	{
		STOCKAGE(CommandeTxt) commandetxt;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandetxt_initialisation(T_S(commandetxt)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandetxt_definition_localisationfichier(T_S(commandetxt),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandetxt_definition_localisationfichier(T_S(commandetxt),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandetxt;
	};

commande_sec:		TOKEN_SEC
	{
		STOCKAGE(CommandeSec) commandesec;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		STOCKAGE(Flux) fluxnul;
		DEBUTZONESECURISEE
		fluxnul=NULL;
		SECURISE(commandesec_initialisation(T_S(commandesec)));
		SECURISE(commandesec_definition_niveau(T_S(commandesec),T_S(fluxnul)));
		SECURISE(pilelocalisationfichier_echange(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandesec_definition_localisationfichier(T_S(commandesec),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandesec_definition_localisationfichier(T_S(commandesec),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandesec;
	}
|			TOKEN_SEC parametre_flux
	{
		STOCKAGE(CommandeSec) commandesec;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandesec_initialisation(T_S(commandesec)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_NIVEAU)));
		SECURISE(commandesec_definition_niveau(T_S(commandesec),T_S($2)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandesec_definition_localisationfichier(T_S(commandesec),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandesec_definition_localisationfichier(T_S(commandesec),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandesec;
	};

commande_mesg:		TOKEN_MESG
	{
		STOCKAGE(CommandeMesg) commandemesg;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandemesg_initialisation(T_S(commandemesg)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandemesg_definition_localisationfichier(T_S(commandemesg),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandemesg_definition_localisationfichier(T_S(commandemesg),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandemesg;
	};

commande_idea:		TOKEN_IDEA parametre_flux flux TOKEN_TEXT flux TOKEN_END
	{
		STOCKAGE(CommandeIdea) commandeidea;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(analyseur_detruiredernierelocalisation(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));//localisation du TOKEN_END
		SECURISE(analyseur_detruiredernierelocalisation(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));//localisation du TOKEN_TEXT
		SECURISE(commandeidea_initialisation(T_S(commandeidea)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_REFERENCE)));
		SECURISE(commandeidea_definition_reference(T_S(commandeidea),T_S($2)));
		SECURISE(flux_definition_type(T_S($3),T_S_(FLUX_TITRE)));
		SECURISE(commandeidea_definition_titre(T_S(commandeidea),T_S($3)));
		SECURISE(flux_definition_type(T_S($5),T_S_(FLUX_TEXTE)));
		SECURISE(commandeidea_definition_texte(T_S(commandeidea),T_S($5)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(flux_destruction(T_S($3)));
		SECURISE(flux_destruction(T_S($5)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandeidea_definition_localisationfichier(T_S(commandeidea),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandeidea_definition_localisationfichier(T_S(commandeidea),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandeidea;
	};

commande_missing:	TOKEN_MISSING parametre_flux flux TOKEN_TEXT flux TOKEN_END
	{
		STOCKAGE(CommandeMissing) commandemissing;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		STOCKAGE(Flux) indicenul;
		DEBUTZONESECURISEE
		indicenul=NULL;
		SECURISE(analyseur_detruiredernierelocalisation(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));//localisation du TOKEN_END
		SECURISE(analyseur_detruiredernierelocalisation(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));//localisation du TOKEN_TXT
		SECURISE(commandemissing_initialisation(T_S(commandemissing)));
		SECURISE(commandemissing_definition_indice(T_S(commandemissing),T_S(indicenul)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_REFERENCE_AUTOMATIQUE)));
		SECURISE(commandemissing_definition_reference(T_S(commandemissing),T_S($2)));
		SECURISE(flux_definition_type(T_S($3),T_S_(FLUX_TITRE_AUTOMATIQUE)));
		SECURISE(commandemissing_definition_titre(T_S(commandemissing),T_S($3)));
		SECURISE(flux_definition_type(T_S($5),T_S_(FLUX_TEXTE_MANQUANTE)));
		SECURISE(commandemissing_definition_texte(T_S(commandemissing),T_S($5)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(flux_destruction(T_S($3)));
		SECURISE(flux_destruction(T_S($5)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandemissing_definition_localisationfichier(T_S(commandemissing),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandemissing_definition_localisationfichier(T_S(commandemissing),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandemissing;
	}
|			TOKEN_MISSING parametre_flux parametre_flux flux TOKEN_TEXT flux TOKEN_END
	{
		STOCKAGE(CommandeMissing) commandemissing;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(analyseur_detruiredernierelocalisation(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));//localisation du TOKEN_END
		SECURISE(analyseur_detruiredernierelocalisation(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));//localisation du TOKEN_TXT
		SECURISE(commandemissing_initialisation(T_S(commandemissing)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_INDICE)));
		SECURISE(commandemissing_definition_indice(T_S(commandemissing),T_S($2)));
		SECURISE(flux_definition_type(T_S($3),T_S_(FLUX_REFERENCE_AUTOMATIQUE)));
		SECURISE(commandemissing_definition_reference(T_S(commandemissing),T_S($3)));
		SECURISE(flux_definition_type(T_S($4),T_S_(FLUX_TITRE_AUTOMATIQUE)));
		SECURISE(commandemissing_definition_titre(T_S(commandemissing),T_S($4)));
		SECURISE(flux_definition_type(T_S($6),T_S_(FLUX_TEXTE_MANQUANTE)));
		SECURISE(commandemissing_definition_texte(T_S(commandemissing),T_S($6)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(flux_destruction(T_S($3)));
		SECURISE(flux_destruction(T_S($4)));
		SECURISE(flux_destruction(T_S($6)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandemissing_definition_localisationfichier(T_S(commandemissing),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandemissing_definition_localisationfichier(T_S(commandemissing),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandemissing;
	};

commande_generic:	TOKEN_GENERIC parametre_flux flux TOKEN_TEXT flux TOKEN_END
	{
		STOCKAGE(CommandeGeneric) commandegeneric;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		STOCKAGE(Flux) indicenul;
		DEBUTZONESECURISEE
		indicenul=NULL;
		SECURISE(analyseur_detruiredernierelocalisation(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));//localisation du TOKEN_END
		SECURISE(analyseur_detruiredernierelocalisation(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));//localisation du TOKEN_TXT
		SECURISE(commandegeneric_initialisation(T_S(commandegeneric)));
		SECURISE(commandegeneric_definition_indice(T_S(commandegeneric),T_S(indicenul)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_REFERENCE_AUTOMATIQUE)));
		SECURISE(commandegeneric_definition_reference(T_S(commandegeneric),T_S($2)));
		SECURISE(flux_definition_type(T_S($3),T_S_(FLUX_TITRE_AUTOMATIQUE)));
		SECURISE(commandegeneric_definition_titre(T_S(commandegeneric),T_S($3)));
		SECURISE(flux_definition_type(T_S($5),T_S_(FLUX_TEXTE_GENERIQUE)));
		SECURISE(commandegeneric_definition_texte(T_S(commandegeneric),T_S($5)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(flux_destruction(T_S($3)));
		SECURISE(flux_destruction(T_S($5)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandegeneric_definition_localisationfichier(T_S(commandegeneric),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandegeneric_definition_localisationfichier(T_S(commandegeneric),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandegeneric;
	}
|			TOKEN_GENERIC parametre_flux parametre_flux flux TOKEN_TEXT flux TOKEN_END
	{
		STOCKAGE(CommandeGeneric) commandegeneric;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(analyseur_detruiredernierelocalisation(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));//localisation du TOKEN_END
		SECURISE(analyseur_detruiredernierelocalisation(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));//localisation du TOKEN_TXT
		SECURISE(commandegeneric_initialisation(T_S(commandegeneric)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_INDICE)));
		SECURISE(commandegeneric_definition_indice(T_S(commandegeneric),T_S($2)));
		SECURISE(flux_definition_type(T_S($3),T_S_(FLUX_REFERENCE_AUTOMATIQUE)));
		SECURISE(commandegeneric_definition_reference(T_S(commandegeneric),T_S($3)));
		SECURISE(flux_definition_type(T_S($4),T_S_(FLUX_TITRE_AUTOMATIQUE)));
		SECURISE(commandegeneric_definition_titre(T_S(commandegeneric),T_S($4)));
		SECURISE(flux_definition_type(T_S($6),T_S_(FLUX_TEXTE_GENERIQUE)));
		SECURISE(commandegeneric_definition_texte(T_S(commandegeneric),T_S($6)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(flux_destruction(T_S($3)));
		SECURISE(flux_destruction(T_S($4)));
		SECURISE(flux_destruction(T_S($6)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandegeneric_definition_localisationfichier(T_S(commandegeneric),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandegeneric_definition_localisationfichier(T_S(commandegeneric),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandegeneric;
	};

commande_index:		TOKEN_INDEX
	{
		STOCKAGE(CommandeIndex) commandeindex;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandeindex_initialisation(T_S(commandeindex)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandeindex_definition_localisationfichier(T_S(commandeindex),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandeindex_definition_localisationfichier(T_S(commandeindex),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandeindex;
	};

commande_extref:	TOKEN_EXTREF parametre_flux
	{
		STOCKAGE(CommandeExtRef) commandeextref;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		STOCKAGE(Flux) fluxnul;
		DEBUTZONESECURISEE
		fluxnul=NULL;
		SECURISE(commandeextref_initialisation(T_S(commandeextref)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_INDICE)));
		SECURISE(commandeextref_definition_indice(T_S(commandeextref),T_S($2)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(commandeextref_definition_format(T_S(commandeextref),T_S(fluxnul)));
		SECURISE(pilelocalisationfichier_echange(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandeextref_definition_localisationfichier(T_S(commandeextref),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandeextref_definition_localisationfichier(T_S(commandeextref),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandeextref;
	}
|			TOKEN_EXTREF parametre_flux parametre_flux	
	{
		STOCKAGE(CommandeExtRef) commandeextref;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandeextref_initialisation(T_S(commandeextref)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_INDICE)));
		SECURISE(commandeextref_definition_indice(T_S(commandeextref),T_S($2)));
		SECURISE(flux_definition_type(T_S($3),T_S_(FLUX_REFERENCE_FORMAT)));
		SECURISE(commandeextref_definition_format(T_S(commandeextref),T_S($3)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(flux_destruction(T_S($3)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandeextref_definition_localisationfichier(T_S(commandeextref),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandeextref_definition_localisationfichier(T_S(commandeextref),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandeextref;
	};

commande_extrefs:	TOKEN_EXTREFS
	{
		STOCKAGE(CommandeExtRefs) commandeextrefs;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		STOCKAGE(Flux) fluxnul;
		DEBUTZONESECURISEE
		fluxnul=NULL;
		SECURISE(commandeextrefs_initialisation(T_S(commandeextrefs)));
		SECURISE(commandeextrefs_definition_format(T_S(commandeextrefs),T_S(fluxnul)));
		SECURISE(pilelocalisationfichier_echange(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandeextrefs_definition_localisationfichier(T_S(commandeextrefs),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandeextrefs_definition_localisationfichier(T_S(commandeextrefs),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandeextrefs;
	}
|			TOKEN_EXTREFS parametre_flux
	{
		STOCKAGE(CommandeExtRefs) commandeextrefs;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandeextrefs_initialisation(T_S(commandeextrefs)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_REFERENCE_FORMAT)));
		SECURISE(commandeextrefs_definition_format(T_S(commandeextrefs),T_S($2)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandeextrefs_definition_localisationfichier(T_S(commandeextrefs),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandeextrefs_definition_localisationfichier(T_S(commandeextrefs),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandeextrefs;
	};

commande_dep:		TOKEN_DEP parametre_flux parametre_flux parametre_flux
	{
		STOCKAGE(CommandeDep) commandedep;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		STOCKAGE(Flux) fluxnul;
		DEBUTZONESECURISEE
		fluxnul=NULL;
		SECURISE(commandedep_initialisation(T_S(commandedep)));
		SECURISE(commandedep_definition_pertinence(T_S(commandedep),T_S(fluxnul)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_REFERENCE)));
		SECURISE(commandedep_definition_destination(T_S(commandedep),T_S($2)));
		SECURISE(flux_definition_type(T_S($3),T_S_(FLUX_TEXTE_IRREDUCTIBLE)));
		SECURISE(commandedep_definition_irreductible(T_S(commandedep),T_S($3)));
		SECURISE(flux_definition_type(T_S($4),T_S_(FLUX_TEXTE_REDUCTIBLE)));
		SECURISE(commandedep_definition_reductible(T_S(commandedep),T_S($4)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(flux_destruction(T_S($3)));
		SECURISE(flux_destruction(T_S($4)));
		SECURISE(pilelocalisationfichier_echange(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandedep_definition_localisationfichier(T_S(commandedep),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandedep_definition_localisationfichier(T_S(commandedep),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandedep;
	}
|			TOKEN_DEP parametre_flux parametre_flux parametre_flux parametre_flux
	{
		STOCKAGE(CommandeDep) commandedep;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandedep_initialisation(T_S(commandedep)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_PERTINENCE)));
		SECURISE(commandedep_definition_pertinence(T_S(commandedep),T_S($2)));
		SECURISE(flux_definition_type(T_S($3),T_S_(FLUX_REFERENCE)));
		SECURISE(commandedep_definition_destination(T_S(commandedep),T_S($3)));
		SECURISE(flux_definition_type(T_S($4),T_S_(FLUX_TEXTE_IRREDUCTIBLE)));
		SECURISE(commandedep_definition_irreductible(T_S(commandedep),T_S($4)));
		SECURISE(flux_definition_type(T_S($5),T_S_(FLUX_TEXTE_REDUCTIBLE)));
		SECURISE(commandedep_definition_reductible(T_S(commandedep),T_S($5)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(flux_destruction(T_S($3)));
		SECURISE(flux_destruction(T_S($4)));
		SECURISE(flux_destruction(T_S($5)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandedep_definition_localisationfichier(T_S(commandedep),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandedep_definition_localisationfichier(T_S(commandedep),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandedep;
	};

commande_depref:	TOKEN_DEPREF
	{
		STOCKAGE(CommandeDepRef) commandedepref;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		STOCKAGE(Flux) fluxnul;
		DEBUTZONESECURISEE
		fluxnul=NULL;
		SECURISE(commandedepref_initialisation(T_S(commandedepref)));
		SECURISE(commandedepref_definition_format(T_S(commandedepref),T_S(fluxnul)));
		SECURISE(pilelocalisationfichier_echange(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandedepref_definition_localisationfichier(T_S(commandedepref),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandedepref_definition_localisationfichier(T_S(commandedepref),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandedepref;
	}
|			TOKEN_DEPREF parametre_flux
	{
		STOCKAGE(CommandeDepRef) commandedepref;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandedepref_initialisation(T_S(commandedepref)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_REFERENCE_FORMAT)));
		SECURISE(commandedepref_definition_format(T_S(commandedepref),T_S($2)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandedepref_definition_localisationfichier(T_S(commandedepref),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandedepref_definition_localisationfichier(T_S(commandedepref),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandedepref;
	};

commande_comment:	TOKEN_COMMENT parametre_flux
	{
		STOCKAGE(CommandeCommentaire) commandecommentaire;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandecommentaire_initialisation(T_S(commandecommentaire)));
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_COMMENTAIRE)));
		SECURISE(commandecommentaire_definition_commentaire(T_S(commandecommentaire),T_S($2)));
		SECURISE(flux_destruction(T_S($2)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandecommentaire_definition_localisationfichier(T_S(commandecommentaire),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandecommentaire_definition_localisationfichier(T_S(commandecommentaire),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandecommentaire;
	};

commande_echappement:	TOKEN_ECHAP_TAB
	{
		STOCKAGE(CommandeEchappement) commandeechappement;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandeechappement_initialisation(T_S(commandeechappement)));
		SECURISE(commandeechappement_definition_caractere(T_S(commandeechappement),T_S_('\t')));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandeechappement_definition_localisationfichier(T_S(commandeechappement),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandeechappement_definition_localisationfichier(T_S(commandeechappement),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandeechappement;
	}
|			TOKEN_ECHAP_ESPACE
	{
		STOCKAGE(CommandeEchappement) commandeechappement;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandeechappement_initialisation(T_S(commandeechappement)));
		SECURISE(commandeechappement_definition_caractere(T_S(commandeechappement),T_S_(' ')));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandeechappement_definition_localisationfichier(T_S(commandeechappement),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandeechappement_definition_localisationfichier(T_S(commandeechappement),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandeechappement;
	}
|			TOKEN_ECHAP_RETOURLIGNE
	{
		STOCKAGE(CommandeEchappement) commandeechappement;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandeechappement_initialisation(T_S(commandeechappement)));
		SECURISE(commandeechappement_definition_caractere(T_S(commandeechappement),T_S_('\n')));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandeechappement_definition_localisationfichier(T_S(commandeechappement),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandeechappement_definition_localisationfichier(T_S(commandeechappement),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandeechappement;
	}
|			TOKEN_ECHAP_COMMANDE
	{	
		STOCKAGE(CommandeEchappement) commandeechappement;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandeechappement_initialisation(T_S(commandeechappement)));
		SECURISE(commandeechappement_definition_caractere(T_S(commandeechappement),T_S_('#')));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandeechappement_definition_localisationfichier(T_S(commandeechappement),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandeechappement_definition_localisationfichier(T_S(commandeechappement),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandeechappement;
	}
|			TOKEN_ECHAP_PARAM_DEBUT
	{
		STOCKAGE(CommandeEchappement) commandeechappement;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandeechappement_initialisation(T_S(commandeechappement)));
		SECURISE(commandeechappement_definition_caractere(T_S(commandeechappement),T_S_('{')));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandeechappement_definition_localisationfichier(T_S(commandeechappement),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandeechappement_definition_localisationfichier(T_S(commandeechappement),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandeechappement;
	}
|			TOKEN_ECHAP_PARAM_FIN
	{
		STOCKAGE(CommandeEchappement) commandeechappement;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(commandeechappement_initialisation(T_S(commandeechappement)));
		SECURISE(commandeechappement_definition_caractere(T_S(commandeechappement),T_S_('}')));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandeechappement_definition_localisationfichier(T_S(commandeechappement),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandeechappement_definition_localisationfichier(T_S(commandeechappement),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandeechappement;
	};

commande_texte:		TOKEN_TEXTE
	{
		STOCKAGE(CommandeTexte) commandetexte;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Chaine) texte;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(pilechaine_retrait(T_S(CHAMP_STOCKAGE(general , piletexte)),R_T_(texte)));
		SECURISE(commandetexte_initialisation(T_S(commandetexte)));
		SECURISE(commandetexte_definition_texte(T_S(commandetexte),texte));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandetexte_definition_localisationfichier(T_S(commandetexte),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandetexte_definition_localisationfichier(T_S(commandetexte),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		free(S_T_(texte));
		FINZONESECURISEE
		$$=commandetexte;
	};

commande_macro:		TOKEN_MACRO liste_parametre
	{
		STOCKAGE(CommandeMacro) commandemacro;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Chaine) nommacro;
		TRAVAIL_SCALAIRE(Booleen) appelssuccessifs;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		niveauimbricationmacro--;//on enregistre un appel de macro : on sort d'un appel de macro
		SECURISE(pilenommacro_definition_niveauimbrication(T_S(CHAMP_STOCKAGE(general , pilenommacro)),T_S_(niveauimbricationmacro)));//MaJ niveau sommet de la pile
		SECURISE(pilenommacro_appels_successifs(T_S(CHAMP_STOCKAGE(general , pilenommacro)),R_T_(appelssuccessifs)));
		if(appelssuccessifs==T_S_(VRAI))
		{
			SECURISE(pilenommacro_echange(T_S(CHAMP_STOCKAGE(general , pilenommacro))));
		}
		SECURISE(pilelocalisationfichier_echange(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));
		SECURISE(pilenommacro_retrait(T_S(CHAMP_STOCKAGE(general , pilenommacro)),R_T_(nommacro)));
		SECURISE(commandemacro_initialisation(T_S(commandemacro)));
		SECURISE(commandemacro_definition_nom(T_S(commandemacro),nommacro));
		SECURISE(commandemacro_definition_parametres(T_S(commandemacro),T_S($2)));
		SECURISE(commandemacroparametres_destruction(T_S($2)));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandemacro_definition_localisationfichier(T_S(commandemacro),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandemacro_definition_localisationfichier(T_S(commandemacro),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		free(S_T_(nommacro));
		FINZONESECURISEE
		$$=commandemacro;
	};

liste_parametre:	liste_parametre parametre_flux
	{
		DEBUTZONESECURISEE
		SECURISE(flux_definition_type(T_S($2),T_S_(FLUX_MACRO_PARAMETRE)));
		SECURISE(commandemacroparametres_ajout_parametre(T_S($1),T_S($2)));
		SECURISE(flux_destruction(T_S($2)));
		FINZONESECURISEE
		$$=$1;
	}
|
	{
		STOCKAGE(CommandeMacroParametres) commandemacroparametres;
		DEBUTZONESECURISEE
		SECURISE(commandemacroparametres_initialisation(T_S(commandemacroparametres)));
		niveauimbricationmacro++;//on initialise une liste de parametres : on est dans un appel de macro
		FINZONESECURISEE
		$$=commandemacroparametres;
	};

commande_parametre:	TOKEN_PARAMETRE
	{
		STOCKAGE(CommandeParametre) commandeparametre;
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Entier) parametre;
		TRAVAIL_SCALAIRE(Booleen) copielocalisation;
		DEBUTZONESECURISEE
		SECURISE(pileentier_retrait(T_S(CHAMP_STOCKAGE(general , pileparametre)),R_T_(parametre)));
		SECURISE(commandeparametre_initialisation(T_S(commandeparametre)));
		SECURISE(commandeparametre_definition_indice(T_S(commandeparametre),parametre));
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(commandeparametre_definition_localisationfichier(T_S(commandeparametre),T_S(localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationvide;
			SECURISE(localisationfichier_initialisation(T_S(localisationvide)));
			SECURISE(commandeparametre_definition_localisationfichier(T_S(commandeparametre),T_S(localisationvide)));
			SECURISE(localisationfichier_destruction(T_S(localisationvide)));
		}
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		FINZONESECURISEE
		$$=commandeparametre;
	};



parametre_flux:		TOKEN_PARAM_DEBUT flux TOKEN_PARAM_FIN
	{
		DEBUTZONESECURISEE
		SECURISE(analyseur_detruiredernierelocalisation(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));//localisation du TOKEN_PARAM_FIN
		$$=$2;
		SECURISE(analyseur_detruiredernierelocalisation(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));//localisation du TOKEN_PARAM_DEBUT
		FINZONESECURISEE
	};
parametre_texte:	TOKEN_PARAM_DEBUT TOKEN_TEXTE TOKEN_PARAM_FIN
	{
		STOCKAGE(LocalisationFichier) localisation;
		TRAVAIL_SCALAIRE(Chaine) texte;
		DEBUTZONESECURISEE
		SECURISE(analyseur_detruiredernierelocalisation(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));//localisation du TOKEN_PARAM_FIN
		SECURISE(pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisation)));
		SECURISE(localisationfichier_destruction(T_S(localisation)));
		SECURISE(pilechaine_retrait(T_S(CHAMP_STOCKAGE(general , piletexte)),R_T_(texte)));
		SECURISE(analyseur_detruiredernierelocalisation(T_S(CHAMP_STOCKAGE(general , pilelocalisation))));//localisation du TOKEN_PARAM_DEBUT
		$$=texte;
		FINZONESECURISEE
	};

%%
void yyerror()
{
	STOCKAGE(LocalisationFichier) localisationprobleme;
	TRAVAIL_SCALAIRE(Booleen) copielocalisation;
	pilelocalisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),C_S(localisationprobleme));
	analyseur_verificationcopielocalisation(T_S(CHAMP_STOCKAGE(general , environnement)),R_T_(copielocalisation));
	if(copielocalisation==T_S_(VRAI))
	{
		probleme_probleme(T_S(general),T_S_(PROBLEME_ERREUR_SYNTAXE),T_S(localisationprobleme),T_S_(CHAMP_STOCKAGE(general , erreursyntaxe)));
	}
	else
	{
		STOCKAGE(LocalisationFichier) localisationvide;
		localisationfichier_initialisation(T_S(localisationvide));
		probleme_probleme(T_S(general),T_S_(PROBLEME_ERREUR_SYNTAXE),T_S(localisationvide),T_S_(CHAMP_STOCKAGE(general , erreursyntaxe)));
		localisationfichier_destruction(T_S(localisationvide));
	}
	/* Normalement on atteint jamais cette portion, une erreur de syntaxe provoquant toujours l'arret du programme.
	 */
	localisationfichier_destruction(T_S(localisationprobleme));
	general_destruction(T_S(general));
	fprintf(stderr,"Syntax error. This is not the usual error message, maybe due to unexpected error.\n");
	exit(1);
}
