#!/usr/bin/perl
# To get log:
# git log --shortstat >~/tmp/picviz/kern.log
#
# This script is (c) Eric Leblond 2008
# Built for ulogd2 git commits (see hardcoded authors)
# but a little tweaking may make it more generic

our ($timestamp,$author,$files,$inserted,$deleted,$getintodetail);

print "header {\n";
print "    title = \"Kernel commit picviz analysis\";\n";
print "}\n";

print "axes {\n";
print "    timeline time[label=\"Time\"];\n"; # Time
print "    enum name[label=\"Author\"];\n";
print "    gold  file[label=\"File\"];\n"; # SPT
print "    short  insert[label=\"Insert\"];\n"; # DPT
print "    short  delete[label=\"Deletion\"];\n"; # DPT
print "}\n";

print "data {\n";

$getintodetail=0;
while ($line = <>) {

        if ($line =~ m/Date: .* (\d+:\d+):\d+/) {
		$timestamp = "$1";
	}

	if ($line =~ m/Author: (.*)/) {
		$author=$1;
		if ($author =~m/emailAddress=(.*) </) {
			$author = $1;
			$getintodetail=1;
		} else {
			if ($author =~ m/laforge/ or $author=~ m/root/) {
				$author="laforge\@netfilter.org";
			}  else {
				$author =~ s/.*<(.*)>.*/$1/;
			}
		}

	} elsif ($getintodetail == 1) {
		if ($line =~ m/<(\S+\@\S+)>/) {
			$author=$1;
		}
	}
 	if ($line =~ m/ +(\d+) files changed, (\d+) insertions\(\+\), (\d+) deletions\(-\)$/) {
		$files = $1;
		$inserted = $2;
		$deleted = $3;

		$getintodetail=0;

		$author = "Simon" if ($author=~m /Signed-off/);
		if ($author =~ m/kaber/) {
			$author="kaber\@trash.net";
		}
		if ($author =~ m/regit/) {
			$author="eric\@inl.fr";
		}
		if ($author =~ m/chiffl/) {
			$author="pierre\@inl.fr";
		}

		print "time=\"$timestamp\", name=\"$author\",file=\"$files\",insert=\"$inserted\",delete=\"$deleted\";\n";
	}
}


print "}\n";
