/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <avtLabelMetaData.h>
#include <DataNode.h>

// ****************************************************************************
// Method: avtLabelMetaData::avtLabelMetaData
//
// Purpose: 
//   Init utility for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void avtLabelMetaData::Init()
{

    avtLabelMetaData::SelectAll();
}

// ****************************************************************************
// Method: avtLabelMetaData::avtLabelMetaData
//
// Purpose: 
//   Copy utility for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void avtLabelMetaData::Copy(const avtLabelMetaData &obj)
{

    avtLabelMetaData::SelectAll();
}

// Type map format string
const char *avtLabelMetaData::TypeMapFormatString = AVTLABELMETADATA_TMFS;
const AttributeGroup::private_tmfs_t avtLabelMetaData::TmfsStruct = {AVTLABELMETADATA_TMFS};


// ****************************************************************************
// Method: avtLabelMetaData::avtLabelMetaData
//
// Purpose: 
//   Default constructor for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtLabelMetaData::avtLabelMetaData() : 
    avtVarMetaData(avtLabelMetaData::TmfsStruct)
{
    avtLabelMetaData::Init();
}

// ****************************************************************************
// Method: avtLabelMetaData::avtLabelMetaData
//
// Purpose: 
//   Constructor for the derived classes of avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtLabelMetaData::avtLabelMetaData(private_tmfs_t tmfs) : 
    avtVarMetaData(tmfs)
{
    avtLabelMetaData::Init();
}

// ****************************************************************************
// Method: avtLabelMetaData::avtLabelMetaData
//
// Purpose: 
//   Copy constructor for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtLabelMetaData::avtLabelMetaData(const avtLabelMetaData &obj) : 
    avtVarMetaData(obj,avtLabelMetaData::TmfsStruct)
{
    avtLabelMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtLabelMetaData::avtLabelMetaData
//
// Purpose: 
//   Copy constructor for derived classes of the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtLabelMetaData::avtLabelMetaData(const avtLabelMetaData &obj, private_tmfs_t tmfs) : 
    avtVarMetaData(obj,tmfs)
{
    avtLabelMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtLabelMetaData::~avtLabelMetaData
//
// Purpose: 
//   Destructor for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtLabelMetaData::~avtLabelMetaData()
{
    // nothing here
}

// ****************************************************************************
// Method: avtLabelMetaData::operator = 
//
// Purpose: 
//   Assignment operator for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtLabelMetaData& 
avtLabelMetaData::operator = (const avtLabelMetaData &obj)
{
    if (this == &obj) return *this;

    // call the base class' assignment operator first
    avtVarMetaData::operator=(obj);

    avtLabelMetaData::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: avtLabelMetaData::operator == 
//
// Purpose: 
//   Comparison operator == for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtLabelMetaData::operator == (const avtLabelMetaData &obj) const
{
    // Create the return value
    return (true);
}

// ****************************************************************************
// Method: avtLabelMetaData::operator != 
//
// Purpose: 
//   Comparison operator != for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtLabelMetaData::operator != (const avtLabelMetaData &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: avtLabelMetaData::TypeName
//
// Purpose: 
//   Type name method for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
avtLabelMetaData::TypeName() const
{
    return "avtLabelMetaData";
}

// ****************************************************************************
// Method: avtLabelMetaData::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtLabelMetaData::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const avtLabelMetaData *tmp = (const avtLabelMetaData *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: avtLabelMetaData::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
avtLabelMetaData::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new avtLabelMetaData(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: avtLabelMetaData::NewInstance
//
// Purpose: 
//   NewInstance method for the avtLabelMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
avtLabelMetaData::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new avtLabelMetaData(*this);
    else
        retval = new avtLabelMetaData;

    return retval;
}

// ****************************************************************************
// Method: avtLabelMetaData::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
avtLabelMetaData::SelectAll()
{
    // call the base class' SelectAll() first
    avtVarMetaData::SelectAll();
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: avtLabelMetaData::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
avtLabelMetaData::GetFieldName(int index) const
{
    return avtVarMetaData::GetFieldName(index);
}

// ****************************************************************************
// Method: avtLabelMetaData::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
avtLabelMetaData::GetFieldType(int index) const
{
    return avtVarMetaData::GetFieldType(index);
}

// ****************************************************************************
// Method: avtLabelMetaData::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
avtLabelMetaData::GetFieldTypeName(int index) const
{
    return avtVarMetaData::GetFieldTypeName(index);
}

// ****************************************************************************
// Method: avtLabelMetaData::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtLabelMetaData::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    return avtVarMetaData::FieldsEqual(index_, rhs);
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

avtLabelMetaData::avtLabelMetaData(const std::string &n, const std::string &mn,
   avtCentering c) : avtVarMetaData(avtLabelMetaData::TmfsStruct, n, mn, c)
{
    avtLabelMetaData::Init();
}

