/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export.compressors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.web3d.vrml.export.compressors.BitPacker;
import org.web3d.vrml.export.compressors.BitUnpacker;
import org.web3d.vrml.export.compressors.ByteHuffmanNode;
import org.web3d.vrml.export.compressors.CodeInputUnpacker;
import org.web3d.vrml.export.compressors.CodeOutputPacker;
import org.web3d.vrml.export.compressors.FloatPacker;
import org.web3d.vrml.export.compressors.HuffmanTable;
import org.web3d.vrml.export.compressors.IntegerHuffmanNode;
import org.web3d.vrml.export.compressors.LZW;
import org.web3d.vrml.export.compressors.ShortHuffmanNode;

public class CompressionTools {
    private static int[] bcnts = new int[40];
    private static boolean debug = false;
    private static int huffmanTablesSize;
    private static int lastTableDataLength;
    private static byte[] outputBuff;

    public static int convertFloatArrayToIntArray(float[] fArray, int[] nArray) {
        int n;
        float f = Float.MIN_VALUE;
        float f2 = Float.MAX_VALUE;
        int n2 = 0;
        for (n = 0; n < fArray.length; ++n) {
            int n3;
            double d = Math.rint(fArray[n]);
            float f3 = Math.abs((float)((double)fArray[n] - d));
            if ((double)f3 > 1.0E-9) {
                for (n3 = 0; f3 < 1.0f && n3 < 8; ++n3, f3 *= 10.0f) {
                }
            }
            if (n3 > n2) {
                n2 = n3;
            }
            if (fArray[n] < f2) {
                f2 = fArray[n];
            }
            if (!(fArray[n] > f)) continue;
            f = fArray[n];
        }
        n2 = (int)Math.pow(10.0, n2);
        for (n = 0; n < fArray.length; ++n) {
            nArray[n] = (int)(fArray[n] * (float)n2);
        }
        return n2;
    }

    public static float calcTolerance(float[] fArray, float f) {
        if (fArray.length < 3) {
            return 1.0E-7f;
        }
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        float f5 = fArray[0];
        float f6 = fArray[1];
        float f7 = fArray[2];
        f4 = fArray[2];
        f7 = fArray[2];
        int n = 3;
        int n2 = fArray.length / 3;
        for (int i = 1; i < n2; ++i) {
            if (fArray[n] < f2) {
                f2 = fArray[n];
            }
            if (fArray[n] > f5) {
                f5 = fArray[n];
            }
            if (fArray[++n] < f3) {
                f3 = fArray[n];
            }
            if (fArray[n] > f6) {
                f6 = fArray[n];
            }
            if (fArray[++n] < f4) {
                f4 = fArray[n];
            }
            if (fArray[n] > f7) {
                f7 = fArray[n];
            }
            ++n;
        }
        float f8 = Math.abs(f5 - f2);
        float f9 = Math.abs(f6 - f3);
        float f10 = Math.abs(f7 - f4);
        float f11 = f8 > f9 && f8 > f10 ? f8 * f : (f9 > f8 && f9 > f10 ? f9 * f : f10 * f);
        if (f11 == 0.0f) {
            f11 = 1.0E-5f;
        }
        return f11;
    }

    public static void quantizeFloatArray(DataOutputStream dataOutputStream, float[] fArray, float f) throws IOException {
        boolean bl = false;
        if (fArray.length == 0) {
            return;
        }
        float[] fArray2 = new float[3];
        CompressionTools.findMinMax(fArray, fArray2);
        int n = CompressionTools.exponentNeeded(fArray2);
        int n2 = CompressionTools.mantissaNeeded(fArray, n, f);
        if (fArray2[2] > 0.0f) {
            bl = true;
        }
        int n3 = n + n2 + 1;
        FloatPacker floatPacker = new FloatPacker(n, n2);
        int n4 = fArray.length;
        BitPacker bitPacker = new BitPacker((int)Math.ceil((float)(n4 * n3) / 8.0f));
        dataOutputStream.writeByte(n);
        dataOutputStream.writeByte(n2);
        for (int i = 0; i < n4; ++i) {
            int n5 = (int)floatPacker.encode(fArray[i], true);
            bitPacker.pack(n5, n3);
        }
        byte[] byArray = new byte[bitPacker.size()];
        bitPacker.getResult(byArray);
        int n6 = bitPacker.size();
        dataOutputStream.writeInt(n4);
        dataOutputStream.write(byArray, 0, n6);
    }

    public static float[] dequantizeFloatArray(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte by = (byte)dataInputStream.read();
        byte by2 = (byte)dataInputStream.read();
        int n = dataInputStream.readInt();
        boolean bl = true;
        int n2 = by + by2 + 1;
        int n3 = (int)Math.ceil((float)(n * n2) / 8.0f);
        byte[] byArray = new byte[n3];
        dataInputStream.read(byArray);
        BitUnpacker bitUnpacker = new BitUnpacker(byArray);
        FloatPacker floatPacker = new FloatPacker(by, by2);
        float[] fArray = new float[n];
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            long l = bitUnpacker.unpack(n2);
            fArray[i] = floatPacker.decode(l, bl);
        }
        return fArray;
    }

    public static void quantizeVector(DataOutputStream dataOutputStream, int n, int n2, boolean bl, float[] fArray) throws IOException {
        int n3 = n + n2;
        if (bl) {
            ++n3;
        }
        FloatPacker floatPacker = new FloatPacker(n, n2);
        int n4 = fArray.length;
        BitPacker bitPacker = new BitPacker((int)Math.ceil((double)(n4 * n3) / 8.0));
        for (int i = 0; i < n4; ++i) {
            int n5 = (int)floatPacker.encode(fArray[i], true);
            bitPacker.pack(n5, n3);
        }
        byte[] byArray = new byte[bitPacker.size()];
        bitPacker.getResult(byArray);
        int n6 = bitPacker.size();
        dataOutputStream.write(byArray, 0, n6);
    }

    public static float[] dequantizeVector(InputStream inputStream, int n, int n2, boolean bl, int n3) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n4 = n + n2;
        if (bl) {
            ++n4;
        }
        FloatPacker floatPacker = new FloatPacker(n, n2);
        int n5 = (int)Math.ceil(n3 * n4 / 8);
        byte[] byArray = new byte[n5];
        int n6 = (int)Math.floor((float)(n5 * 8) / (float)n4);
        float[] fArray = new float[n6];
        dataInputStream.read(byArray);
        BitUnpacker bitUnpacker = new BitUnpacker(byArray);
        for (int i = 0; i < n6; ++i) {
            long l = bitUnpacker.unpack(n4);
            fArray[i] = floatPacker.decode(l, bl);
        }
        return fArray;
    }

    public static void compressFloatArray(DataOutputStream dataOutputStream, boolean bl, int n, float[] fArray) throws IOException {
        int n2;
        int[] nArray = new int[fArray.length];
        float f = Float.MIN_VALUE;
        float f2 = Float.MAX_VALUE;
        int n3 = 0;
        for (n2 = 0; n2 < fArray.length; ++n2) {
            int n4;
            double d = Math.rint(fArray[n2]);
            float f3 = Math.abs((float)((double)fArray[n2] - d));
            if ((double)f3 > 1.0E-9) {
                for (n4 = 0; f3 < 1.0f && n4 < 8; ++n4, f3 *= 10.0f) {
                }
            }
            if (n4 > n3) {
                n3 = n4;
            }
            if (fArray[n2] < f2) {
                f2 = fArray[n2];
            }
            if (!(fArray[n2] > f)) continue;
            f = fArray[n2];
        }
        if (n3 > 8) {
            n3 = 8;
        }
        dataOutputStream.writeByte(n3);
        n3 = (int)Math.pow(10.0, n3);
        for (n2 = 0; n2 < fArray.length; ++n2) {
            nArray[n2] = (int)(fArray[n2] * (float)n3);
        }
        CompressionTools.rangeCompressIntArray(dataOutputStream, bl, n, nArray);
    }

    public static float[] decompressFloatArray(InputStream inputStream, boolean bl, int n) throws IOException {
        int n2 = inputStream.read();
        n2 = (int)Math.pow(10.0, n2);
        int[] nArray = CompressionTools.rangeDecompressIntArray(inputStream, bl, n);
        float[] fArray = new float[nArray.length];
        int n3 = nArray.length;
        for (int i = 0; i < n3; ++i) {
            fArray[i] = (float)nArray[i] / (float)n2;
        }
        return fArray;
    }

    public static int calcRange(boolean bl, int n, int[] nArray) {
        int n2;
        int[] nArray2 = new int[nArray.length];
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MAX_VALUE;
        int[] nArray3 = new int[n];
        int n5 = 0;
        if (bl) {
            int n6;
            for (n2 = 0; n2 < n; ++n2) {
                nArray3[n2] = nArray[n2];
            }
            for (n6 = 0; n6 < nArray.length; ++n6) {
                n2 = nArray[n6];
                nArray2[n6] = nArray[n6] - nArray3[n5];
                nArray3[n5++] = n2;
                if (n5 != n) continue;
                n5 = 0;
            }
            for (n6 = 0; n6 < nArray2.length; ++n6) {
                if (nArray2[n6] > n3) {
                    n3 = nArray2[n6];
                }
                if (nArray2[n6] >= n4) continue;
                n4 = nArray2[n6];
            }
        } else {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (nArray[n2] > n3) {
                    n3 = nArray[n2];
                }
                if (nArray[n2] >= n4) continue;
                n4 = nArray[n2];
            }
        }
        n2 = CompressionTools.computeBits(n3 - n4);
        return n2;
    }

    public static void quantizeFloatArrayHuffman(DataOutputStream dataOutputStream, float[] fArray, float f) throws IOException {
        int n;
        int n2;
        boolean bl = false;
        if (fArray.length == 0) {
            return;
        }
        float[] fArray2 = new float[3];
        CompressionTools.findMinMax(fArray, fArray2);
        int n3 = CompressionTools.exponentNeeded(fArray2);
        int n4 = CompressionTools.mantissaNeeded(fArray, n3, f);
        if (fArray2[2] > 0.0f) {
            bl = true;
        }
        int n5 = n3 + n4 + 1;
        FloatPacker floatPacker = new FloatPacker(n3, n4);
        int n6 = fArray.length;
        dataOutputStream.writeByte(n3);
        dataOutputStream.writeByte(n4);
        HuffmanTable huffmanTable = new HuffmanTable();
        int n7 = 0;
        int n8 = 0;
        int[] nArray = new int[n6];
        int n9 = n2 = (int)floatPacker.encode(fArray[0], true);
        for (n = 0; n < n6; ++n) {
            nArray[n] = (int)floatPacker.encode(fArray[n], true);
            if (nArray[n] < n2) {
                n2 = nArray[n];
                continue;
            }
            if (nArray[n] <= n9) continue;
            n9 = nArray[n];
        }
        n8 = -n2;
        n9 += n8;
        n2 = 0;
        for (n = 0; n < n6; ++n) {
            int n10 = n;
            nArray[n10] = nArray[n10] + n8;
            IntegerHuffmanNode integerHuffmanNode = new IntegerHuffmanNode(nArray[n]);
            huffmanTable.addEntry(integerHuffmanNode);
        }
        huffmanTable.computeTags();
        n = n5;
        CompressionTools.writeIntHuffman(dataOutputStream, huffmanTable, n7, n8, n, nArray, false);
    }

    public static float[] dequantizeFloatArrayHuffman(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte by = (byte)dataInputStream.read();
        byte by2 = (byte)dataInputStream.read();
        int n = by + by2 + 1;
        int[] nArray = CompressionTools.decompressIntArrayDeltaHuffman(dataInputStream);
        BitPacker bitPacker = new BitPacker((int)Math.ceil((float)(nArray.length * n) / 8.0f));
        for (int i = 0; i < nArray.length; ++i) {
            bitPacker.pack(nArray[i], n);
        }
        byte[] byArray = new byte[bitPacker.size()];
        bitPacker.getResult(byArray);
        int n2 = nArray.length;
        boolean bl = true;
        BitUnpacker bitUnpacker = new BitUnpacker(byArray);
        FloatPacker floatPacker = new FloatPacker(by, by2);
        float[] fArray = new float[n2];
        boolean bl2 = false;
        for (int i = 0; i < n2; ++i) {
            long l = bitUnpacker.unpack(n);
            fArray[i] = floatPacker.decode(l, bl);
        }
        return fArray;
    }

    public static void quantizeFloatArrayLZW(DataOutputStream dataOutputStream, float[] fArray, float f) throws IOException {
        boolean bl = false;
        float[] fArray2 = new float[3];
        CompressionTools.findMinMax(fArray, fArray2);
        int n = CompressionTools.exponentNeeded(fArray2);
        int n2 = CompressionTools.mantissaNeeded(fArray, n, f);
        if (fArray2[2] > 0.0f) {
            bl = true;
        }
        int n3 = n + n2 + 1;
        FloatPacker floatPacker = new FloatPacker(n, n2);
        int n4 = fArray.length;
        dataOutputStream.writeByte(n);
        dataOutputStream.writeByte(n2);
        BitPacker bitPacker = new BitPacker((int)Math.ceil((float)(n4 * n3) / 8.0f));
        for (int i = 0; i < n4; ++i) {
            int n5 = (int)floatPacker.encode(fArray[i], true);
            bitPacker.pack(n5, n3);
        }
        byte[] byArray = new byte[bitPacker.size()];
        bitPacker.getResult(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n6 = byArray.length < 50 ? 250 : (int)((float)byArray.length * 2.5f);
        CodeOutputPacker codeOutputPacker = new CodeOutputPacker(n6, 16);
        int n7 = LZW.Compress(byteArrayInputStream, codeOutputPacker);
        byte[] byArray2 = codeOutputPacker.toByteArray();
        dataOutputStream.writeInt(byArray2.length);
        dataOutputStream.writeInt(n4);
        dataOutputStream.write(byArray2);
        System.out.println("compressed size: " + byArray2.length + " orig: " + n7);
    }

    public static void quantizeFloatArrayDeflater(DataOutputStream dataOutputStream, float[] fArray, float f) throws IOException {
        int n = 0;
        int[] nArray = new int[3];
        CompressionTools.findFloatParams(fArray, f, nArray);
        int n2 = nArray[0];
        int n3 = nArray[1];
        n = nArray[2];
        int n4 = n2 + n3 + 1;
        FloatPacker floatPacker = new FloatPacker(n2, n3);
        int n5 = fArray.length;
        dataOutputStream.writeByte(n2);
        dataOutputStream.writeByte(n3);
        BitPacker bitPacker = new BitPacker((int)Math.ceil((float)(n5 * n4) / 8.0f));
        boolean bl = true;
        for (int i = 0; i < n5; ++i) {
            float f2;
            int n6 = (int)floatPacker.encode(fArray[i], false);
            if (bl && Math.abs(fArray[i] - (f2 = floatPacker.decode(n6, true))) > f) {
                System.out.println("*** error on: " + fArray[i] + " = " + f2 + " exp: " + n2 + " mantissa: " + n3);
            }
            bitPacker.pack(n6, n4);
        }
        byte[] byArray = new byte[bitPacker.size()];
        bitPacker.getResult(byArray);
        Deflater deflater = new Deflater(9, false);
        deflater.setInput(byArray);
        deflater.finish();
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.writeInt(n5);
        boolean bl2 = true;
        while (bl2) {
            int n7 = deflater.deflate(outputBuff);
            if (n7 != outputBuff.length) {
                bl2 = false;
            }
            dataOutputStream.write(outputBuff, 0, n7);
        }
    }

    public static float[] dequantizeFloatArrayInflater(byte[] byArray, int n, int n2) throws IOException {
        Object object;
        byte by = byArray[n++];
        byte by2 = byArray[n++];
        int n3 = CompressionTools.readInt(byArray, n);
        int n4 = CompressionTools.readInt(byArray, n += 4);
        n += 4;
        int n5 = by + by2 + 1;
        byte[] byArray2 = null;
        try {
            object = new Inflater(false);
            ((Inflater)object).setInput(byArray, n, n2 - 10);
            byArray2 = new byte[n3];
            int n6 = ((Inflater)object).inflate(byArray2);
            ((Inflater)object).end();
        }
        catch (Exception exception) {
            System.out.println("Invalid format in dequantizeFloatArrayInflater");
            exception.printStackTrace();
        }
        object = new BitUnpacker(byArray2);
        FloatPacker floatPacker = new FloatPacker(by, by2);
        float[] fArray = new float[n4];
        for (int i = 0; i < n4; ++i) {
            long l = ((BitUnpacker)object).unpack(n5);
            fArray[i] = floatPacker.decode(l, true);
        }
        return fArray;
    }

    public static float[] dequantizeFloatArrayLZW(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[4];
        byte by = (byte)dataInputStream.read();
        byte by2 = (byte)dataInputStream.read();
        int n = CompressionTools.readInt(dataInputStream, byArray);
        int n2 = CompressionTools.readInt(dataInputStream, byArray);
        int n3 = by + by2 + 1;
        byte[] byArray2 = new byte[n];
        dataInputStream.read(byArray2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n4 = LZW.Expand(new CodeInputUnpacker(byArray2, 16), byteArrayOutputStream);
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        System.out.println("post lzw size: " + byArray3.length);
        BitUnpacker bitUnpacker = new BitUnpacker(byArray3);
        FloatPacker floatPacker = new FloatPacker(by, by2);
        float[] fArray = new float[n2];
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            long l = bitUnpacker.unpack(n3);
            fArray[i] = floatPacker.decode(l, true);
        }
        return fArray;
    }

    public static void compressIntArrayDeltaHuffman(DataOutputStream dataOutputStream, int[] nArray) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = nArray.length;
        boolean bl = false;
        if (n4 < 2) {
            BitPacker bitPacker = new BitPacker(8);
            bitPacker.pack(1, 0);
            bitPacker.pack(0, 7);
            byte[] byArray = new byte[1];
            bitPacker.getResult(byArray);
            dataOutputStream.write(byArray, 0, 1);
            dataOutputStream.writeInt(n4);
            for (int i = 0; i < n4; ++i) {
                dataOutputStream.writeInt(nArray[i]);
            }
            return;
        }
        HuffmanTable huffmanTable = new HuffmanTable();
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        int n8 = n4 < 20 ? n4 : 20;
        for (n3 = 0; n3 < n8; ++n3) {
            ++n6;
            if (nArray[n3] != -1) continue;
            if (n5 == -1) {
                n5 = n6;
                n6 = 0;
                continue;
            }
            if (n5 != n6) {
                n5 = -1;
                break;
            }
            n6 = 0;
        }
        if (n5 == -1) {
            IntegerHuffmanNode integerHuffmanNode;
            n5 = 0;
            n2 = nArray[0];
            n = nArray[0];
            for (n3 = 0; n3 < n4; ++n3) {
                integerHuffmanNode = new IntegerHuffmanNode(nArray[n3]);
                if (nArray[n3] > n) {
                    n = nArray[n3];
                } else if (nArray[n3] < n2) {
                    n2 = nArray[n3];
                }
                huffmanTable.addEntry(integerHuffmanNode);
            }
            n7 = -n2;
            n2 = 0;
            n += n7;
            for (n3 = 0; n3 < n4; ++n3) {
                int n9 = n3;
                nArray[n9] = nArray[n9] + n7;
                integerHuffmanNode = new IntegerHuffmanNode(nArray[n3]);
                huffmanTable.addEntry(integerHuffmanNode);
            }
            huffmanTable.computeTags();
        } else {
            int n10;
            n3 = 0;
            int[] nArray2 = new int[n4];
            n2 = nArray[0];
            n = nArray[0];
            n3 = 0;
            int[] nArray3 = new int[n5];
            int[] nArray4 = nArray2;
            int n11 = 0;
            if (bl) {
                nArray4 = new int[nArray2.length * (n5 - 1) / n5];
            }
            for (n10 = 0; n10 < n4; ++n10) {
                int n12 = nArray[n10];
                nArray2[n10] = nArray[n10] - nArray3[n3];
                if (nArray2[n10] > n) {
                    n = nArray2[n10];
                } else if (nArray2[n10] < n2) {
                    n2 = nArray2[n10];
                }
                nArray3[n3++] = n12;
                if (n3 == n5) {
                    n3 = 0;
                }
                if (!bl || (n10 + 1) % n5 == 0) continue;
                nArray4[n11++] = nArray2[n10];
            }
            if (bl) {
                nArray2 = nArray4;
                n4 = nArray2.length;
            }
            n7 = -n2;
            n2 = 0;
            n += n7;
            n10 = 0;
            while (n10 < n4) {
                int n13 = n10++;
                nArray2[n13] = nArray2[n13] + n7;
            }
            HuffmanTable huffmanTable2 = new HuffmanTable();
            for (int i = 0; i < n4; ++i) {
                IntegerHuffmanNode integerHuffmanNode = new IntegerHuffmanNode(nArray2[i]);
                huffmanTable2.addEntry(integerHuffmanNode);
            }
            huffmanTable2.computeTags();
            huffmanTable = huffmanTable2;
            nArray = nArray2;
        }
        lastTableDataLength = n3 = CompressionTools.computeBits(n - n2);
        CompressionTools.writeIntHuffman(dataOutputStream, huffmanTable, n5, n7, n3, nArray, false);
    }

    public static int[] decompressIntArrayDeltaHuffman(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[1];
        inputStream.read(byArray2);
        BitUnpacker bitUnpacker = new BitUnpacker(byArray2);
        int n2 = bitUnpacker.unpack(1);
        int n3 = bitUnpacker.unpack(7);
        if (n2 == 0) {
            int n4 = CompressionTools.readInt(inputStream, byArray);
            int[] nArray = new int[n4];
            for (int i = 0; i < n4; ++i) {
                nArray[i] = CompressionTools.readInt(inputStream, byArray);
            }
            return nArray;
        }
        int n5 = CompressionTools.readInt(inputStream, byArray);
        int n6 = CompressionTools.readInt(inputStream, byArray);
        HuffmanTable huffmanTable = new HuffmanTable();
        huffmanTable.readDict(inputStream);
        int n7 = CompressionTools.readInt(inputStream, byArray);
        byte[] byArray3 = new byte[n7];
        inputStream.read(byArray3);
        int[] nArray = new int[n6];
        huffmanTable.decode(byArray3, nArray);
        if (n3 == 0) {
            int n8 = 0;
            while (n8 < n6) {
                int n9 = n8++;
                nArray[n9] = nArray[n9] - n5;
            }
            return nArray;
        }
        int[] nArray2 = new int[n3];
        for (n = 0; n < n3; ++n) {
            nArray2[n] = nArray[n] - n5;
            nArray[n] = nArray2[n];
        }
        n = 0;
        for (int i = n3; i < n6; ++i) {
            nArray[i] = nArray[i] + nArray2[n] - n5;
            nArray2[n++] = nArray[i];
            if (n != n3) continue;
            n = 0;
        }
        return nArray;
    }

    public static void compressByteArrayDeltaHuffman(DataOutputStream dataOutputStream, byte[] byArray) throws IOException {
        int n;
        ByteHuffmanNode byteHuffmanNode;
        int n2;
        byte by;
        int n3;
        int n4 = byArray.length;
        int n5 = dataOutputStream.size();
        if (n4 < 2) {
            BitPacker bitPacker = new BitPacker(8);
            bitPacker.pack(1, 0);
            bitPacker.pack(0, 7);
            byte[] byArray2 = new byte[1];
            bitPacker.getResult(byArray2);
            dataOutputStream.write(byArray2, 0, 1);
            dataOutputStream.writeInt(n4);
            for (int i = 0; i < n4; ++i) {
                dataOutputStream.write(byArray[i]);
            }
            return;
        }
        HuffmanTable huffmanTable = new HuffmanTable();
        int n6 = -1;
        int n7 = 0;
        byte by2 = 0;
        int n8 = n4 < 20 ? n4 : 20;
        for (n3 = 0; n3 < n8; ++n3) {
            ++n7;
            if (byArray[n3] != -1) continue;
            if (n6 == -1) {
                n6 = n7;
                n7 = 0;
                continue;
            }
            if (n6 != n7) {
                n6 = -1;
                break;
            }
            n7 = 0;
        }
        if (n6 == -1) {
            n6 = 0;
            by = byArray[0];
            n2 = byArray[0];
            for (n3 = 0; n3 < n4; ++n3) {
                byteHuffmanNode = new ByteHuffmanNode(byArray[n3]);
                if (byArray[n3] > n2) {
                    n2 = byArray[n3];
                } else if (byArray[n3] < by) {
                    by = byArray[n3];
                }
                huffmanTable.addEntry(byteHuffmanNode);
            }
            by2 = -by;
            n2 += by2;
            for (n3 = 0; n3 < n4; ++n3) {
                if (byArray[n3] + by2 > 255) {
                    System.out.println("Overflow in byte shift");
                }
                int n9 = n3;
                byArray[n9] = (byte)(byArray[n9] + by2);
                byteHuffmanNode = new ByteHuffmanNode(byArray[n3]);
                huffmanTable.addEntry(byteHuffmanNode);
            }
            huffmanTable.computeTags();
            System.out.println("Regular Size: " + huffmanTable.streamBits());
        } else {
            int n10;
            n3 = 0;
            byte[] byArray3 = new byte[n4];
            by = byArray[0];
            n2 = byArray[0];
            n3 = 0;
            int[] nArray = new int[n6];
            for (n10 = 0; n10 < n4; ++n10) {
                int n11 = byArray[n10];
                byArray3[n10] = (byte)(byArray[n10] - nArray[n3]);
                if (byArray3[n10] > n2) {
                    n2 = byArray3[n10];
                } else if (byArray3[n10] < by) {
                    by = byArray3[n10];
                }
                nArray[n3++] = n11;
                if (n3 != n6) continue;
                n3 = 0;
            }
            by2 = -by;
            n2 += by2;
            n10 = 0;
            while (n10 < n4) {
                if (byArray3[n10] + by2 > 255) {
                    System.out.println("Overflow in byte shift");
                }
                int n12 = n10++;
                byArray3[n12] = (byte)(byArray3[n12] + by2);
            }
            HuffmanTable huffmanTable2 = new HuffmanTable();
            for (int i = 0; i < n4; ++i) {
                byteHuffmanNode = new ByteHuffmanNode(byArray3[i]);
                huffmanTable2.addEntry(byteHuffmanNode);
            }
            huffmanTable2.computeTags();
            huffmanTable = huffmanTable2;
            byArray = byArray3;
        }
        BitPacker bitPacker = new BitPacker(8);
        bitPacker.pack(1, 1);
        bitPacker.pack(n6, 7);
        byte[] byArray4 = new byte[1];
        bitPacker.getResult(byArray4);
        dataOutputStream.write(byArray4, 0, 1);
        dataOutputStream.write(by2);
        dataOutputStream.writeInt(n4);
        n3 = CompressionTools.computeBits(n2 - by);
        huffmanTable.setDataLength(n3);
        huffmanTable.writeDict(dataOutputStream);
        bitPacker = new BitPacker(huffmanTable.streamBits());
        ByteHuffmanNode byteHuffmanNode2 = new ByteHuffmanNode();
        for (n = 0; n < n4; ++n) {
            byteHuffmanNode2.setValue(byArray[n]);
            byteHuffmanNode = (ByteHuffmanNode)huffmanTable.getEntry(byteHuffmanNode2);
            bitPacker.pack(byteHuffmanNode.tag, byteHuffmanNode.tagLength);
        }
        byArray4 = new byte[bitPacker.size()];
        bitPacker.getResult(byArray4);
        n = bitPacker.size();
        dataOutputStream.writeInt(n);
        dataOutputStream.write(byArray4, 0, n);
    }

    public static void compressShortArrayDeltaHuffman(DataOutputStream dataOutputStream, short[] sArray) throws IOException {
        int n;
        ShortHuffmanNode shortHuffmanNode;
        int n2;
        short s;
        int n3;
        int n4 = sArray.length;
        int n5 = dataOutputStream.size();
        if (n4 < 2) {
            BitPacker bitPacker = new BitPacker(8);
            bitPacker.pack(1, 0);
            bitPacker.pack(0, 7);
            byte[] byArray = new byte[1];
            bitPacker.getResult(byArray);
            dataOutputStream.write(byArray, 0, 1);
            dataOutputStream.writeInt(n4);
            for (int i = 0; i < n4; ++i) {
                dataOutputStream.write(sArray[i]);
            }
            return;
        }
        HuffmanTable huffmanTable = new HuffmanTable();
        int n6 = -1;
        int n7 = 0;
        short s2 = 0;
        int n8 = n4 < 20 ? n4 : 20;
        for (n3 = 0; n3 < n8; ++n3) {
            ++n7;
            if (sArray[n3] != -1) continue;
            if (n6 == -1) {
                n6 = n7;
                n7 = 0;
                continue;
            }
            if (n6 != n7) {
                n6 = -1;
                break;
            }
            n7 = 0;
        }
        if (n6 == -1) {
            n6 = 0;
            s = sArray[0];
            n2 = sArray[0];
            for (n3 = 0; n3 < n4; ++n3) {
                shortHuffmanNode = new ShortHuffmanNode(sArray[n3]);
                if (sArray[n3] > n2) {
                    n2 = sArray[n3];
                } else if (sArray[n3] < s) {
                    s = sArray[n3];
                }
                huffmanTable.addEntry(shortHuffmanNode);
            }
            s2 = -s;
            n2 += s2;
            for (n3 = 0; n3 < n4; ++n3) {
                if (sArray[n3] + s2 > 65535) {
                    System.out.println("Overflow in short shift");
                }
                int n9 = n3;
                sArray[n9] = (short)(sArray[n9] + s2);
                shortHuffmanNode = new ShortHuffmanNode(sArray[n3]);
                huffmanTable.addEntry(shortHuffmanNode);
            }
            huffmanTable.computeTags();
        } else {
            int n10;
            n3 = 0;
            short[] sArray2 = new short[n4];
            s = sArray[0];
            n2 = sArray[0];
            n3 = 0;
            int[] nArray = new int[n6];
            for (n10 = 0; n10 < n4; ++n10) {
                int n11 = sArray[n10];
                sArray2[n10] = (byte)(sArray[n10] - nArray[n3]);
                if (sArray2[n10] > n2) {
                    n2 = sArray2[n10];
                } else if (sArray2[n10] < s) {
                    s = sArray2[n10];
                }
                nArray[n3++] = n11;
                if (n3 != n6) continue;
                n3 = 0;
            }
            s2 = -s;
            n2 += s2;
            n10 = 0;
            while (n10 < n4) {
                if (sArray2[n10] + s2 > 65536) {
                    System.out.println("Overflow in byte shift");
                }
                int n12 = n10++;
                sArray2[n12] = (short)(sArray2[n12] + s2);
            }
            HuffmanTable huffmanTable2 = new HuffmanTable();
            for (int i = 0; i < n4; ++i) {
                shortHuffmanNode = new ShortHuffmanNode((byte)sArray2[i]);
                huffmanTable2.addEntry(shortHuffmanNode);
            }
            huffmanTable2.computeTags();
            huffmanTable = huffmanTable2;
            sArray = sArray2;
        }
        BitPacker bitPacker = new BitPacker(8);
        bitPacker.pack(1, 1);
        bitPacker.pack(n6, 7);
        byte[] byArray = new byte[1];
        bitPacker.getResult(byArray);
        dataOutputStream.write(byArray, 0, 1);
        dataOutputStream.writeShort(s2);
        dataOutputStream.writeInt(n4);
        n3 = CompressionTools.computeBits(n2 - s);
        huffmanTable.setDataLength(n3);
        huffmanTable.writeDict(dataOutputStream);
        bitPacker = new BitPacker(huffmanTable.streamBits());
        ShortHuffmanNode shortHuffmanNode2 = new ShortHuffmanNode();
        for (n = 0; n < n4; ++n) {
            shortHuffmanNode2.setValue(sArray[n]);
            shortHuffmanNode = (ShortHuffmanNode)huffmanTable.getEntry(shortHuffmanNode2);
            bitPacker.pack(shortHuffmanNode.tag, shortHuffmanNode.tagLength);
        }
        byArray = new byte[bitPacker.size()];
        bitPacker.getResult(byArray);
        n = bitPacker.size();
        dataOutputStream.writeInt(n);
        dataOutputStream.write(byArray, 0, n);
    }

    private static void writeIntHuffman(DataOutputStream dataOutputStream, HuffmanTable huffmanTable, int n, int n2, int n3, int[] nArray, boolean bl) throws IOException {
        int n4;
        int n5 = nArray.length;
        BitPacker bitPacker = new BitPacker(8);
        bitPacker.pack(1, 1);
        bitPacker.pack(n, 7);
        byte[] byArray = new byte[1];
        bitPacker.getResult(byArray);
        dataOutputStream.write(byArray, 0, 1);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(n5);
        huffmanTable.setDataLength(n3);
        if (!bl) {
            int n6 = dataOutputStream.size();
            huffmanTable.writeDict(dataOutputStream);
            huffmanTablesSize += dataOutputStream.size() - n6;
        }
        bitPacker = new BitPacker(huffmanTable.streamBits());
        IntegerHuffmanNode integerHuffmanNode = new IntegerHuffmanNode();
        for (n4 = 0; n4 < n5; ++n4) {
            integerHuffmanNode.setValue(nArray[n4]);
            IntegerHuffmanNode integerHuffmanNode2 = (IntegerHuffmanNode)huffmanTable.getEntry(integerHuffmanNode);
            bitPacker.pack(integerHuffmanNode2.tag, integerHuffmanNode2.tagLength);
        }
        byArray = new byte[bitPacker.size()];
        bitPacker.getResult(byArray);
        n4 = bitPacker.size();
        dataOutputStream.writeInt(n4);
        dataOutputStream.write(byArray, 0, n4);
    }

    public static void rangeCompressIntArray(DataOutputStream dataOutputStream, boolean bl, int n, int[] nArray) throws IOException {
        int n2;
        int n3;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MAX_VALUE;
        boolean bl2 = false;
        boolean bl3 = false;
        int n6 = nArray.length;
        boolean bl4 = false;
        if (nArray.length < 5) {
            bl4 = false;
        }
        BitPacker bitPacker = !bl ? new BitPacker(8) : new BitPacker(8 + n * 4);
        bitPacker.pack(nArray.length, 27);
        int[] nArray2 = new int[n];
        int n7 = 0;
        if (bl) {
            for (n3 = 0; n3 < nArray.length; ++n3) {
                int n8 = nArray[n3];
                nArray[n3] = nArray[n3] - nArray2[n7];
                nArray2[n7++] = n8;
                if (n7 != n) continue;
                n7 = 0;
            }
        }
        int[] nArray3 = nArray;
        if (bl4) {
            nArray3 = new int[nArray.length * (n - 1) / n];
        }
        n3 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] > n4) {
                n4 = nArray[n2];
            }
            if (nArray[n2] < n5) {
                n5 = nArray[n2];
            }
            if (!bl4 || (n2 + 1) % n == 0) continue;
            nArray3[n3++] = nArray[n2];
        }
        if (bl4) {
            nArray = nArray3;
        }
        n2 = CompressionTools.computeBits(n4 - n5);
        int n9 = n5 < 0 ? -n5 : n5;
        bitPacker.pack(n2, 5);
        if (nArray.length == 0) {
            bitPacker.writeStream(dataOutputStream);
            return;
        }
        bitPacker.pack(n9, 32);
        if (bl) {
            for (int i = 0; i < n; ++i) {
                nArray2[i] = nArray[i];
                bitPacker.pack(nArray2[i], 32);
            }
        }
        BitPacker bitPacker2 = new BitPacker((int)Math.ceil((double)(nArray.length * n2) / 8.0));
        for (int i = 0; i < nArray.length; ++i) {
            int n10 = nArray[i] + n9;
            bitPacker2.pack(n10, n2);
        }
        bitPacker.writeStream(dataOutputStream);
        bitPacker2.writeStream(dataOutputStream);
        int n11 = n2;
        bcnts[n11] = bcnts[n11] + 1;
    }

    public static int[] rangeDecompressIntArray(InputStream inputStream, boolean bl, int n) throws IOException {
        byte[] byArray = new byte[4];
        inputStream.read(byArray);
        BitUnpacker bitUnpacker = new BitUnpacker(byArray);
        int n2 = bitUnpacker.unpack(27);
        int n3 = bitUnpacker.unpack(5);
        if (n2 == 0) {
            return new int[0];
        }
        int n4 = CompressionTools.readInt(inputStream, byArray);
        int[] nArray = new int[n];
        if (bl) {
            for (int i = 0; i < n; ++i) {
                nArray[i] = CompressionTools.readInt(inputStream, byArray);
            }
        }
        int[] nArray2 = new int[n2];
        int n5 = (int)Math.ceil((double)(n2 * n3) / 8.0);
        if (byArray.length < n5) {
            byArray = new byte[n5];
        }
        inputStream.read(byArray, 0, n5);
        bitUnpacker.reset(byArray);
        if (!bl) {
            for (int i = 0; i < n2; ++i) {
                int n6 = bitUnpacker.unpack(n3);
                nArray2[i] = n6 - n4;
            }
        } else {
            int[] nArray3 = new int[n];
            int n7 = 0;
            for (int i = 0; i < nArray2.length; ++i) {
                int n8 = bitUnpacker.unpack(n3);
                nArray2[i] = n8 - n4;
                nArray2[i] = nArray2[i] + nArray3[n7];
                nArray3[n7++] = nArray2[i];
                if (n7 != n) continue;
                n7 = 0;
            }
        }
        return nArray2;
    }

    public static int computeBits(int n) {
        int n2 = 0;
        if (n == 0) {
            return 1;
        }
        do {
            if (n == 0) {
                return n2;
            }
            n >>= 1;
        } while (++n2 < 32);
        return 32;
    }

    public static void printStats() {
        System.out.println("Huffman Tables Size: " + huffmanTablesSize);
    }

    private static int readInt(InputStream inputStream, byte[] byArray) throws IOException {
        inputStream.read(byArray);
        byte by = byArray[0];
        int n = byArray[1] & 0xFF;
        int n2 = byArray[2] & 0xFF;
        int n3 = byArray[3] & 0xFF;
        return (by << 24) + (n << 16) + (n2 << 8) + (n3 << 0);
    }

    private static int readInt(byte[] byArray, int n) throws IOException {
        byte by = byArray[n++];
        int n2 = byArray[n++] & 0xFF;
        int n3 = byArray[n++] & 0xFF;
        int n4 = byArray[n++] & 0xFF;
        return (by << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    private static void findMinMax(float[] fArray, float[] fArray2) {
        int n = fArray.length;
        float f = Float.POSITIVE_INFINITY;
        float f2 = Float.NEGATIVE_INFINITY;
        float f3 = 0.0f;
        for (int i = 0; i < n; ++i) {
            if (fArray[i] < 0.0f) {
                f3 = 1.0f;
            }
            if (fArray[i] < f) {
                f = fArray[i];
            }
            if (!(fArray[i] > f2)) continue;
            f2 = fArray[i];
        }
        fArray2[0] = f;
        fArray2[1] = f2;
        fArray2[2] = f3;
    }

    private static int exponentNeededOld(float[] fArray) {
        int n = 22;
        int n2 = 3;
        boolean bl = false;
        float f = 1.0f;
        while (!bl) {
            float f2;
            FloatPacker floatPacker;
            int n3 = (int)floatPacker.encode(fArray[0], true);
            if (Math.abs(fArray[0] - (f2 = (floatPacker = new FloatPacker(++n2, n)).decode(n3, true))) >= f) continue;
            n3 = (int)floatPacker.encode(fArray[1], true);
            f2 = floatPacker.decode(n3, true);
            if (Math.abs(fArray[1] - f2) <= f) {
                bl = true;
            }
            if (n2 < 8) continue;
            System.out.println("Big exponent needed for: " + fArray[0] + " -> " + fArray[1]);
            bl = true;
        }
        return n2;
    }

    private static int exponentNeeded(float[] fArray) {
        int n = Math.round(fArray[0]);
        String string = Integer.toBinaryString(n);
        int n2 = string.length();
        n = Math.round(fArray[1]);
        string = Integer.toBinaryString(n);
        int n3 = string.length();
        if (n3 > n2) {
            n2 = n3;
        }
        return CompressionTools.computeBits(n2);
    }

    private static int mantissaNeeded(float[] fArray, int n, float f) {
        int n2 = 1;
        boolean bl = false;
        int n3 = n2;
        int n4 = fArray.length;
        for (int i = 0; i < n4; ++i) {
            bl = false;
            n2 = n3 - 1;
            while (!bl) {
                if (++n2 == 23) {
                    return 23;
                }
                if (debug) {
                    System.out.println("Trying mantissa: " + n2 + " exp: " + n);
                }
                FloatPacker floatPacker = new FloatPacker(n, n2);
                int n5 = (int)floatPacker.encode(fArray[i], true);
                float f2 = floatPacker.decode(n5, true);
                if (debug) {
                    System.out.println("orig min: " + fArray[i] + " newval: " + f2);
                }
                if (Math.abs(fArray[i] - f2) > f) continue;
                if (!debug) break;
                System.out.println("Pass with err: " + Math.abs(fArray[i] - f2));
                break;
            }
            if (n2 <= n3) continue;
            n3 = n2;
        }
        if (debug) {
            System.out.println("final mantissa: " + n2);
        }
        return n3;
    }

    private static int displayFloatArrayParams(float[] fArray, int n, float f) {
        int n2 = 1;
        boolean bl = false;
        int n3 = n2;
        int n4 = fArray.length;
        System.out.println("Displaying float calcs   exponent: " + n + " tolerance: " + f + " len: " + fArray.length);
        for (int i = 0; i < n4; ++i) {
            bl = false;
            n2 = n3 - 1;
            while (!bl) {
                if (++n2 == 23) {
                    return 23;
                }
                System.out.println("Trying mantissa: " + n2 + " exp: " + n);
                FloatPacker floatPacker = new FloatPacker(n, n2);
                int n5 = (int)floatPacker.encode(fArray[i], true);
                float f2 = floatPacker.decode(n5, true);
                System.out.println("orig val: " + fArray[i] + " newval: " + f2);
                if (Math.abs(fArray[i] - f2) > f) continue;
                System.out.println("Pass with err: " + Math.abs(fArray[i] - f2));
                break;
            }
            if (n2 <= n3) continue;
            n3 = n2;
        }
        System.out.println("final mantissa: " + n2);
        return n3;
    }

    public static void findFloatParams(float f, float f2, int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4 = 6;
        int n5 = 23;
        int n6 = 0;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        if (f < 0.0f) {
            n6 = 1;
        }
        int n7 = Float.floatToIntBits(f);
        long l = 0x7FFFFFL;
        long l2 = 2139095040L;
        if (bl) {
            System.out.println("initial value: " + f);
        }
        if ((n4 = (int)(((long)n7 & l2) >> 23)) == 0) {
            n4 = 0;
        } else {
            n4 += 127;
            if (bl) {
                System.out.println("exponent bits: " + Integer.toBinaryString((int)((long)n7 & l2)) + " val: " + n4);
            }
            n4 = n4 > 63 ? 8 : (n4 > 31 ? 7 : (n4 > 15 ? 6 : (n4 > 7 ? 5 : (n4 > 3 ? 4 : (n4 > 1 ? 3 : (n4 > 0 ? 2 : (n4 < -64 ? 8 : (n4 < -32 ? 7 : (n4 < -16 ? 6 : (n4 < -8 ? 5 : (n4 < -4 ? 4 : (n4 < -2 ? 3 : (n4 < -1 ? 2 : 2)))))))))))));
        }
        if (bl) {
            System.out.println("exponent bits: " + n4);
        }
        n5 = (int)((long)n7 & l);
        if (bl3) {
            n5 = 0;
            FloatPacker floatPacker = new FloatPacker(n4, n5);
            boolean bl4 = false;
            while (!bl4) {
                int n8 = (int)floatPacker.encode(f, false);
                float f3 = floatPacker.decode(n8, true);
                if (Math.abs(f - f3) > f2) {
                    if (n5 == 23) {
                        ++n4;
                    } else {
                        ++n5;
                    }
                } else {
                    bl4 = true;
                    break;
                }
                floatPacker.reinit(n4, n5);
            }
            if (n5 < 0) {
                n5 = 0;
            }
            nArray[0] = n4;
            nArray[1] = n5;
            nArray[2] = n6;
            if (bl) {
                System.out.println("final params: exp: " + n4 + " mantissa: " + n5);
            }
            return;
        }
        if (bl) {
            System.out.println("mantissa: " + Integer.toBinaryString(n5) + " val: " + n5);
        }
        if (n5 > 0) {
            n3 = 23;
            n2 = 2;
            n = n2 - 1;
            while ((n5 & n) != 1) {
                --n3;
                if ((n5 >>>= 1) != 0) continue;
            }
            n5 = n3;
            if (bl) {
                System.out.println("mantissa bits: " + n5);
            }
        } else {
            nArray[0] = n4;
            nArray[1] = 0;
            nArray[2] = n6;
            if (bl) {
                System.out.println("final params: exp: " + n4 + " mantissa: 0");
            }
            return;
        }
        n3 = 1;
        n2 = n5;
        n = n4;
        FloatPacker floatPacker = new FloatPacker(n4, n5);
        boolean bl5 = true;
        int n9 = 0;
        if (!bl2) {
            nArray[0] = n4;
            nArray[1] = n5;
            nArray[2] = n6;
            int n10 = (int)floatPacker.encode(f, false);
            float f4 = floatPacker.decode(n10, true);
            if (Math.abs(f - f4) > f2) {
                System.out.println("FAIL: orig: " + f + " err: " + Math.abs(f - f4));
            }
            return;
        }
        while (n3 != 0 && n5 > -1) {
            int n11 = (int)floatPacker.encode(f, false);
            float f5 = floatPacker.decode(n11, true);
            if (bl) {
                System.out.println("mantissa: " + n5 + " orig val: " + f + " newval: " + f5);
            }
            if (Math.abs(f - f5) > f2) {
                if (bl) {
                    System.out.println("FAIL: err: " + Math.abs(f - f5));
                }
                n3 = 0;
                if (bl5) {
                    ++n4;
                    n5 = 22;
                }
            } else {
                if (bl) {
                    System.out.println("PASS");
                }
                ++n9;
                floatPacker.reinit(n4, --n5);
            }
            bl5 = false;
        }
        nArray[0] = n4;
        nArray[1] = ++n5;
        nArray[2] = n6;
        if (bl) {
            System.out.println("final params: exp: " + n4 + " mantissa: " + n5);
        }
        if (n4 > n || n5 > n2) {
            System.out.println("bigger then original: " + n4 + " mant: " + n5 + " orig: " + n + " " + n2 + " val: " + f);
        }
    }

    public static void findFloatParams(float[] fArray, float f, int[] nArray) {
        int[] nArray2 = new int[3];
        int n = fArray.length;
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        for (int i = 0; i < n; ++i) {
            CompressionTools.findFloatParams(fArray[i], f, nArray2);
            if (nArray2[0] > nArray[0]) {
                nArray[0] = nArray2[0];
            }
            if (nArray2[1] > nArray[1]) {
                nArray[1] = nArray2[1];
            }
            if (nArray2[2] <= nArray[2]) continue;
            nArray[2] = nArray2[2];
        }
    }

    public static void findFloatParamsOld(float[] fArray, float f, int[] nArray) {
        int n = 6;
        int n2 = 23;
        boolean bl = false;
        float[] fArray2 = new float[3];
        CompressionTools.findMinMax(fArray, fArray2);
        n = CompressionTools.exponentNeeded(fArray2);
        n2 = CompressionTools.mantissaNeeded(fArray, n, f);
        if (fArray2[2] > 0.0f) {
            bl = true;
        }
    }

    private static void testSingleFloat(float f, float f2) {
        FloatPacker floatPacker = new FloatPacker(1, 1);
        int[] nArray = new int[3];
        CompressionTools.findFloatParams(f, f2, nArray);
        System.out.println("val: " + f + " exponent: " + nArray[0] + " mantissa: " + nArray[1]);
        floatPacker.reinit(nArray[0], nArray[1]);
        int n = (int)floatPacker.encode(f, false);
        float f3 = floatPacker.decode(n, true);
        if (Math.abs(f - f3) > f2) {
            System.out.println("FAIL: err: " + Math.abs(f - f3) + " orig: " + f + " decode: " + f3 + " exponent: " + nArray[0] + " mantissa: " + nArray[1]);
        } else {
            System.out.println("PASS:  orig: " + f + " new: " + f3);
        }
    }

    private static void testAllFloatsSize(int n, float f, int n2, float f2) {
        FloatPacker floatPacker = new FloatPacker(1, 1);
        int[] nArray = new int[3];
        int n3 = 0;
        float[] fArray = new float[n];
        int n4 = Float.floatToIntBits(f);
        while (n3 < n) {
            int n5 = n4 + n3 * n2;
            float f3 = Float.intBitsToFloat(n5);
            if (Float.isNaN(f3)) continue;
            fArray[n3] = f3;
            ++n3;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n * 4);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            CompressionTools.quantizeFloatArrayDeflater(dataOutputStream, fArray, f2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("Original size: " + n * 4 + " compressed: " + dataOutputStream.size());
    }

    private static void testAllWholeFloatsSize(int n, float f, float f2) {
        FloatPacker floatPacker = new FloatPacker(1, 1);
        int[] nArray = new int[3];
        int n2 = 0;
        float[] fArray = new float[n];
        int n3 = Float.floatToIntBits(f);
        while (n2 < n) {
            float f3 = f + (float)n2;
            if (Float.isNaN(f3)) continue;
            fArray[n2] = f3;
            ++n2;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n * 4);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            CompressionTools.quantizeFloatArrayDeflater(dataOutputStream, fArray, f2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("Original size: " + n * 4 + " compressed: " + dataOutputStream.size());
    }

    private static void testAllFloats(int n, float f) {
        FloatPacker floatPacker = new FloatPacker(1, 1);
        int[] nArray = new int[3];
        boolean bl = false;
        int n2 = 0;
        for (int i = Integer.MIN_VALUE; !(i >= Integer.MAX_VALUE || bl && i < 0); i += n) {
            if (i > 0) {
                bl = true;
            }
            ++n2;
            float f2 = Float.intBitsToFloat(i);
            if (i % 100000 == 0) {
                System.out.println("Number: " + n2 + " Testing: " + f2 + " i: " + i);
            }
            if (Float.isNaN(f2)) continue;
            CompressionTools.findFloatParams(f2, f, nArray);
            floatPacker.reinit(nArray[0], nArray[1]);
            int n3 = (int)floatPacker.encode(f2, false);
            float f3 = floatPacker.decode(n3, true);
            if (!(Math.abs(f2 - f3) > f)) continue;
            System.out.println("FAIL: err: " + Math.abs(f2 - f3) + " orig: " + f2 + " decode: " + f3 + " exponent: " + nArray[0] + " mantissa: " + nArray[1]);
        }
    }

    public static void main(String[] stringArray) {
        float f = 0.25f;
        float f2 = 1.0E-7f;
        CompressionTools.testAllWholeFloatsSize(1000, -500.0f, 1.0f);
    }

    static {
        lastTableDataLength = -1;
        outputBuff = new byte[1024];
    }
}

