/*
 * Copyright (c) 2007 Cray Inc.
 * Contributed by Steve Kaufmann <sbk@cray.com> based on code from
 * Copyright (c) 2001-2006 Hewlett-Packard Development Company, L.P.
 * Contributed by Stephane Eranian <eranian@hpl.hp.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef __CRAYX2_EVENTS_H__
#define __CRAYX2_EVENTS_H__ 1

#include "pfmlib_crayx2_priv.h"

/*
 *****************************************************************
 ******* THIS TABLE IS GENERATED AUTOMATICALLY
 ******* MODIFICATIONS REQUIRED FOR THE EVENT NAMES
 ******* OR EVENT DESCRIPTIONS SHOULD BE MADE TO
 ******* THE TEXT FILE AND THE TABLE REGENERATED
 ******* Sat Nov 10 14:40:30 CST 2007
 *****************************************************************
 */

static pme_crayx2_entry_t crayx2_pe[ ] =
{
	/* P Counter 0 Event 0 */
	{
		.pme_name = "CYCLES",
		.pme_desc = "Cycles.",
		.pme_code = 0,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 0,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 0 Event 1 */
	{
		.pme_name = "CYCLES",
		.pme_desc = "Cycles.",
		.pme_code = 1,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 0,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 0 Event 2 */
	{
		.pme_name = "CYCLES",
		.pme_desc = "Cycles.",
		.pme_code = 2,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 0,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 0 Event 3 */
	{
		.pme_name = "CYCLES",
		.pme_desc = "Cycles.",
		.pme_code = 3,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 0,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 1 Event 0 */
	{
		.pme_name = "INST_GRAD",
		.pme_desc = "Number of instructions graduated.",
		.pme_code = 4,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 1,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 1 Event 1 */
	{
		.pme_name = "INST_GRAD",
		.pme_desc = "Number of instructions graduated.",
		.pme_code = 5,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 1,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 1 Event 2 */
	{
		.pme_name = "INST_GRAD",
		.pme_desc = "Number of instructions graduated.",
		.pme_code = 6,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 1,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 1 Event 3 */
	{
		.pme_name = "INST_GRAD",
		.pme_desc = "Number of instructions graduated.",
		.pme_code = 7,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 1,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 2 Event 0 */
	{
		.pme_name = "INST_DISPATCH",
		.pme_desc = "Number of instructions dispatched.",
		.pme_code = 8,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 2,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 2 Event 1 */
	{
		.pme_name = "ITLB_MISS",
		.pme_desc = "Number of Instruction TLB misses.",
		.pme_code = 9,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 2,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 2 Event 2 */
	{
		.pme_name = "JB_CORRECT",
		.pme_desc = "Number of jumps and branches predicted correctly.",
		.pme_code = 10,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 2,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 2 Event 3 */
	{
		.pme_name = "STALL_VU_FUG1",
		.pme_desc = "CPs VU stalled waiting for FUG 1.",
		.pme_code = 11,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 2,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 3 Event 0 */
	{
		.pme_name = "INST_SYNCS",
		.pme_desc = "Number of synchronization instructions graduated g=02.",
		.pme_code = 12,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 3,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 3 Event 1 */
	{
		.pme_name = "INST_GSYNCS",
		.pme_desc = "Number of Gsync instructions graduated g=02 & f=0-3.",
		.pme_code = 13,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 3,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 3 Event 2 */
	{
		.pme_name = "STALL_DU_ICACHE",
		.pme_desc = "CPs dispatch stalled waiting for instruction from Icache.",
		.pme_code = 14,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 3,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 3 Event 3 */
	{
		.pme_name = "STALL_VU_FUG2",
		.pme_desc = "CPs VU stalled waiting for FUG 2.",
		.pme_code = 15,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 3,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 4 Event 0 */
	{
		.pme_name = "INST_AMO",
		.pme_desc = "Number of AMO instructions graduated g=04.",
		.pme_code = 16,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 4,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 4 Event 1 */
	{
		.pme_name = "ICACHE_FETCH",
		.pme_desc = "Number of instruction fetch requests to memory.",
		.pme_code = 17,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 4,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 4 Event 2 */
	{
		.pme_name = "STALL_DU_BRANCH_PRED",
		.pme_desc = "CPs Dispatch stalled waiting for branch prediction register.",
		.pme_code = 18,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 4,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 4 Event 3 */
	{
		.pme_name = "STALL_VU_FUG3",
		.pme_desc = "CPs VU stalled waiting for FUG 3.",
		.pme_code = 19,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 4,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 5 Event 0 */
	{
		.pme_name = "INST_A",
		.pme_desc = "Number of A register instructions graduated g=05,40,42,43.",
		.pme_code = 20,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 5,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 5 Event 1 */
	{
		.pme_name = "ICACHE_HIT",
		.pme_desc = "Number of Icache hits.",
		.pme_code = 21,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 5,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 5 Event 2 */
	{
		.pme_name = "STALL_DU_AREG",
		.pme_desc = "CPs instruction dispatch stalled waiting for free A register.",
		.pme_code = 22,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 5,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 5 Event 3 */
	{
		.pme_name = "STALL_VU",
		.pme_desc = "CPs VU is stalled with a valid instruction.",
		.pme_code = 23,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 5,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 6 Event 0 */
	{
		.pme_name = "INST_S_INT",
		.pme_desc = "Number of S register integer instructions graduated g=60,62 & t1=1,63.",
		.pme_code = 24,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 6,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 6 Event 1 */
	{
		.pme_name = "INST_MSYNCS",
		.pme_desc = "Number of Msync instructions graduated g=02 & f=20-22.",
		.pme_code = 25,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 6,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 6 Event 2 */
	{
		.pme_name = "STALL_DU_ACT_LIST_FULL",
		.pme_desc = "CPs dispatch stalled waiting for active list entry.",
		.pme_code = 26,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 6,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 6 Event 3 */
	{
		.pme_name = "STALL_VU_NO_INST",
		.pme_desc = "CPs VU has no valid instruction.",
		.pme_code = 27,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 6,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 7 Event 0 */
	{
		.pme_name = "INST_S_FP",
		.pme_desc = "Number of S register FP instructions graduated g=62 & t1=0.",
		.pme_code = 28,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 7,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 7 Event 1 */
	{
		.pme_name = "STLB_MISS",
		.pme_desc = "Number of Scalar TLB misses.",
		.pme_code = 29,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 7,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 7 Event 2 */
	{
		.pme_name = "STALL_DU_SREG",
		.pme_desc = "CPs instruction dispatch stalled waiting for free S register.",
		.pme_code = 30,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 7,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 7 Event 3 */
	{
		.pme_name = "STALL_VU_VR",
		.pme_desc = "CPs VU is stalled waiting for busy V Reg.",
		.pme_code = 31,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 7,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 8 Event 0 */
	{
		.pme_name = "INST_MISC",
		.pme_desc = "Number of Misc. scalar instructions graduated g=00, 01, 03, 06, 34.",
		.pme_code = 32,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 8,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 8 Event 1 */
	{
		.pme_name = "VTLB_MISS",
		.pme_desc = "Number of vector TLB misses.",
		.pme_code = 33,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 8,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 8 Event 2 */
	{
		.pme_name = "STALL_DU_INST",
		.pme_desc = "CPs dispatch stalled due to an instruction such as a Gsync or Lsync FP that stops dispatch until it executes.",
		.pme_code = 34,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 8,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 8 Event 3 */
	{
		.pme_name = "STALL_VLSU_NO_INST",
		.pme_desc = "CPs VLSU has no valid instruction.",
		.pme_code = 35,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 8,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 9 Event 0 */
	{
		.pme_name = "INST_JB",
		.pme_desc = "Number of Jump and Branch instructions graduated g=50-57, 70-76.",
		.pme_code = 36,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 9,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 9 Event 1 */
	{
		.pme_name = "ICACHE_MISS",
		.pme_desc = "Number of Icache misses.",
		.pme_code = 37,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 9,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 9 Event 2 */
	{
		.pme_name = "STALL_GRAD",
		.pme_desc = "CPs no instructions graduate for any reason.",
		.pme_code = 38,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 9,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 9 Event 3 */
	{
		.pme_name = "STALL_VLSU_LB",
		.pme_desc = "CPs VLSU stalled waiting for load buffers (LB).",
		.pme_code = 39,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 9,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 10 Event 0 */
	{
		.pme_name = "INST_MEM",
		.pme_desc = "Number of A and S register load and store instructions graduated g=41, 44-47, 61, 64-67.",
		.pme_code = 40,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 10,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 10 Event 1 */
	{
		.pme_name = "ICACHE_HIT_PEND",
		.pme_desc = "Number of Icache hits to blocks with allocations pending.",
		.pme_code = 41,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 10,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 10 Event 2 */
	{
		.pme_name = "STALL_GRAD_NO_INST",
		.pme_desc = "CPs no instructions graduated due to empty active list.",
		.pme_code = 42,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 10,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 10 Event 3 */
	{
		.pme_name = "STALL_VLSU_SB",
		.pme_desc = "CPs VLSU stalled waiting for store buffer (SB).",
		.pme_code = 43,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 10,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 11 Event 0 */
	{
		.pme_name = "INST_VFUG1",
		.pme_desc = "Number of vector FUG 1 instructions graduated g=20-27, f=0-7,60-77 Add, sub, compare.",
		.pme_code = 44,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 11,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 11 Event 1 */
	{
		.pme_name = "TLB_MISS",
		.pme_desc = "Total number of TLB misses including ITLB, STLB, and VTLB.",
		.pme_code = 45,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 11,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 11 Event 2 */
	{
		.pme_name = "STALL_GRAD_AX_INST",
		.pme_desc = "CPs no instructions graduate and an A FUG instruction is at the head of the active list g=5, 40, 42, 43.",
		.pme_code = 46,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 11,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 11 Event 3 */
	{
		.pme_name = "STALL_VLSU_RB",
		.pme_desc = "CPs VLSU stalled waiting for request buffer (RB).",
		.pme_code = 47,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 11,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 12 Event 0 */
	{
		.pme_name = "INST_VFUG2",
		.pme_desc = "Number of vector FUG 2 instructions graduated g=20-27, f=30-37 (multiply, shift).",
		.pme_code = 48,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 12,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 12 Event 1 */
	{
		.pme_name = "DCACHE_HIT",
		.pme_desc = "Number of A or S loads that hit in the Dcache.",
		.pme_code = 49,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 12,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 12 Event 2 */
	{
		.pme_name = "STALL_GRAD_SX_INST",
		.pme_desc = "CPs no instructions graduate and an S FUG instruction is at the head of the active list g=60, 62, 63.",
		.pme_code = 50,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 12,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 12 Event 3 */
	{
		.pme_name = "STALL_VLSU_VM",
		.pme_desc = "CPs VLSU stalled waiting for VU vector mask (VM).",
		.pme_code = 51,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 12,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 13 Event 0 */
	{
		.pme_name = "INST_VFUG3",
		.pme_desc = "Number of vector FUG 3 instructions graduated g=20-27, f=10-27, 40-57, 77 div, sqrt, abs, cpsign, compress, merge, logical, bmm.",
		.pme_code = 52,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 13,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 13 Event 1 */
	{
		.pme_name = "DCACHE_MISS",
		.pme_desc = "Number of A or S loads that miss in the Dcache.",
		.pme_code = 53,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 13,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 13 Event 2 */
	{
		.pme_name = "STALL_GRAD_FP_INST",
		.pme_desc = "CPs no instructions graduate and an S FP instruction is at the head of the active list g=62, t1=0.",
		.pme_code = 54,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 13,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 13 Event 3 */
	{
		.pme_name = "STALL_VLSU_SREF",
		.pme_desc = "CPs VLSU stalled waiting for prior scalar instruction reference sent.",
		.pme_code = 55,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 13,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 14 Event 0 */
	{
		.pme_name = "VOPS_EXT_FUG3",
		.pme_desc = "Number of vector FUG 3 external operations g=20-27 f=25,57,77 compress, merge, bmm.",
		.pme_code = 56,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 14,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 14 Event 1 */
	{
		.pme_name = "DCACHE_HIT_PEND",
		.pme_desc = "Number of scalar loads that hit in the Dcache and in the FOQ and the load is merged with a pending allocation.",
		.pme_code = 57,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 14,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 14 Event 2 */
	{
		.pme_name = "STALL_GRAD_LOAD_INST",
		.pme_desc = "CPs no instructions graduate and a scalar load is at the head of the active list.",
		.pme_code = 58,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 14,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 14 Event 3 */
	{
		.pme_name = "STALL_VLSU_INDEX",
		.pme_desc = "CPS VLSU stalled waiting for busy scatter or gather index register.",
		.pme_code = 59,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 14,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 15 Event 0 */
	{
		.pme_name = "VOPS_LOG_FUG3",
		.pme_desc = "Number of vector FUG 3 logical operations.",
		.pme_code = 60,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 15,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 15 Event 1 */
	{
		.pme_name = "DCACHE_HIT_WORD",
		.pme_desc = "Number of scalar loads that hit in the Dcache and hit in the FOQ and were not merged with a pending allocation.",
		.pme_code = 61,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 15,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 15 Event 2 */
	{
		.pme_name = "STALL_GRAD_STORE_INST",
		.pme_desc = "CPs no instructions graduate and a scalar store is at the head of the active list.",
		.pme_code = 62,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 15,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 15 Event 3 */
	{
		.pme_name = "STALL_VLSU_FOM",
		.pme_desc = "CPs VLSU stalled in forced order mode.",
		.pme_code = 63,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 15,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 16 Event 0 */
	{
		.pme_name = "INST_V",
		.pme_desc = "Number of elemental vector instructions graduated g=20-27, 30-33.",
		.pme_code = 64,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 16,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 16 Event 1 */
	{
		.pme_name = "INST_V_INT",
		.pme_desc = "Number of elemental vector integer instructions graduated g=20-27 & t1=",
		.pme_code = 65,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 16,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 16 Event 2 */
	{
		.pme_name = "INST_V_FP",
		.pme_desc = "Number of elemental vector FP instructions graduated g=20-27 & t1=0.",
		.pme_code = 66,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 16,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 16 Event 3 */
	{
		.pme_name = "INST_V_MEM",
		.pme_desc = "Number of elemental vector memory instructions graduated g=30-33.",
		.pme_code = 67,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 16,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 17 Event 0 */
	{
		.pme_name = "VOPS_VL",
		.pme_desc = "Inst_V * Current VL.",
		.pme_code = 68,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 17,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 17 Event 1 */
	{
		.pme_name = "DCACHE_INVAL_V",
		.pme_desc = "Number of Dcache invalidates due to vector stores.",
		.pme_code = 69,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 17,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 17 Event 2 */
	{
		.pme_name = "VOPS_VL_32-BIT",
		.pme_desc = "Inst_V * Current VL for 32-bit operations only.",
		.pme_code = 70,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 17,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 17 Event 3 */
	{
		.pme_name = "STALL_VLSU",
		.pme_desc = "Stall vector load store for any reason.",
		.pme_code = 71,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 17,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 18 Event 0 */
	{
		.pme_name = "VOPS_INT_ADD",
		.pme_desc = "Number of selected vector integer add operations g=20-27 & f=0-3 & t1=",
		.pme_code = 72,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 18,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 18 Event 1 */
	{
		.pme_name = "DCACHE_INVAL_L2",
		.pme_desc = "Number of Dcache invalidates from L2 cache.",
		.pme_code = 73,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 18,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 18 Event 2 */
	{
		.pme_name = "STALL_GRAD_XFER_INST",
		.pme_desc = "Number of CPs no instruction graduates and an A to S or S to A move is at the head of the active list.",
		.pme_code = 74,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 18,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 18 Event 3 */
	{
		.pme_name = "STALL_VU_VM",
		.pme_desc = "CPs VU stalled waiting for vector mask.",
		.pme_code = 75,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 18,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 19 Event 0 */
	{
		.pme_name = "VOPS_FP_ADD",
		.pme_desc = "Number of selected vector FP add operations g=20-27 & f=0-3 & t1=0.",
		.pme_code = 76,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 19,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 19 Event 1 */
	{
		.pme_name = "DCACHE_INVALIDATE",
		.pme_desc = "Total Number of Dcache invalidates.",
		.pme_code = 77,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 19,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 19 Event 2 */
	{
		.pme_name = "STALL_GRAD_VXFER_INST",
		.pme_desc = "CPs no instruction graduates and a V to A or V to S move is at the head of the active list.",
		.pme_code = 78,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 19,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 19 Event 3 */
	{
		.pme_name = "STALL_VU_VR_MEM",
		.pme_desc = "CPs VU is stalled waiting on a busy vector register being loaded from memory.",
		.pme_code = 79,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 19,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 20 Event 0 */
	{
		.pme_name = "VOPS_INT_LOG",
		.pme_desc = "Number of selected vector integer logical operations g=20-27 & f=10-27 & t1=1.",
		.pme_code = 80,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 20,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 20 Event 1 */
	{
		.pme_name = "BRANCH_PRED",
		.pme_desc = "Number of branches predicted.",
		.pme_code = 81,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 20,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 20 Event 2 */
	{
		.pme_name = "STALL_GRAD_VLSU_INST",
		.pme_desc = "Number of CPs no instruction graduates and a vector load, store, or AMO instruction is at the head of the active list.",
		.pme_code = 82,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 20,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 20 Event 3 */
	{
		.pme_name = "STALL_VU_TLB",
		.pme_desc = "CPs VU stalled waiting for a memory translation.",
		.pme_code = 83,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 20,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 21 Event 0 */
	{
		.pme_name = "VOPS_FP_DIV",
		.pme_desc = "Number of selected vector FP divide and sqrt operations g=20-27 & f=10-11 & t1=0.",
		.pme_code = 84,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 21,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 21 Event 1 */
	{
		.pme_name = "BRANCH_CORRECT",
		.pme_desc = "Number of branches predicted correctly.",
		.pme_code = 85,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 21,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 21 Event 2 */
	{
		.pme_name = "STALL_SLSQ_DEST",
		.pme_desc = "SLS issue stall for FOQ, PARB, ORB full or Lsync vs active.",
		.pme_code = 86,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 21,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 21 Event 3 */
	{
		.pme_name = "STALL_VLSU_VK_PORT",
		.pme_desc = "CPs VLSU stalled waiting for scatter or gather index register read port.",
		.pme_code = 87,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 21,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 22 Event 0 */
	{
		.pme_name = "VOPS_INT_SHIFT",
		.pme_desc = "Number of selected vector integer shift operations g=20-27 & f=30-37 & t1=",
		.pme_code = 88,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 22,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 22 Event 1 */
	{
		.pme_name = "JTB_PRED",
		.pme_desc = "Number of jumps predicted g=57 & f=0,20.",
		.pme_code = 89,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 22,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 22 Event 2 */
	{
		.pme_name = "STALL_GRAD_ARQ_DEST",
		.pme_desc = "Stall arq issue due to vdispatch, control unit, or A to S full.",
		.pme_code = 90,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 22,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 22 Event 3 */
	{
		.pme_name = "STALL_VLSU_ADR_PORT",
		.pme_desc = "CPs VLSU stalled waiting for address read port.",
		.pme_code = 91,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 22,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 23 Event 0 */
	{
		.pme_name = "VOPS_FP_MULT",
		.pme_desc = "Number of selected vector FP multiply operations g=20-27 & f=30-37 & t1=0.",
		.pme_code = 92,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 23,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 23 Event 1 */
	{
		.pme_name = "JTB_CORRECT",
		.pme_desc = "Number of jumps predicted correctly g=57 & f=0,20.",
		.pme_code = 93,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 23,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 23 Event 2 */
	{
		.pme_name = "STALL_SRQ_DEST",
		.pme_desc = "Stall srq issue due to vdispatch or S to A full.",
		.pme_code = 94,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 23,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 23 Event 3 */
	{
		.pme_name = "STALL_VLSU_MISC",
		.pme_desc = "CPs VLSU stalled due to miscellaneous instructions.",
		.pme_code = 95,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 23,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 24 Event 0 */
	{
		.pme_name = "VOPS_LOAD_INDEX",
		.pme_desc = "Number of selected vector load indexed references g=30-33 & f2=1 & f0=0.",
		.pme_code = 96,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 24,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 24 Event 1 */
	{
		.pme_name = "VOPS_INT_MISC",
		.pme_desc = "Number of selected vector integer misc. operations g=20-27 & f=40-77 & t1=",
		.pme_code = 97,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 24,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 24 Event 2 */
	{
		.pme_name = "INST_LSYNCVS",
		.pme_desc = "Number of LsyncVS instructions graduated.",
		.pme_code = 98,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 24,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 24 Event 3 */
	{
		.pme_name = "VOPS_VL_64-BIT",
		.pme_desc = "Inst_V * Current VL for 64-bit operations only.",
		.pme_code = 99,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 24,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 25 Event 0 */
	{
		.pme_name = "VOPS_STORE_INDEX",
		.pme_desc = "Number of selected vector store indexed references g=30-33 & f2=1 & f0=1",
		.pme_code = 100,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 25,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 25 Event 1 */
	{
		.pme_name = "JRS_PRED",
		.pme_desc = "Number of return jumps predicted g=57, f=40.",
		.pme_code = 101,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 25,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 25 Event 2 */
	{
		.pme_name = "STALL_SLSQ_PARB",
		.pme_desc = "Number of CPs SLS issue stalled due to PARB full.",
		.pme_code = 102,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 25,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 25 Event 3 */
	{
		.pme_name = "<P:25:3>",
		.pme_desc = "<NA>",
		.pme_code = 103,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 25,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 26 Event 0 */
	{
		.pme_name = "VOPS_LOADS",
		.pme_desc = "Number of selected vector load references g=30-33 & f0=0.",
		.pme_code = 104,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 26,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 26 Event 1 */
	{
		.pme_name = "JRS_CORRECT",
		.pme_desc = "Number of return jumps predicted correctly g=57, f=40.",
		.pme_code = 105,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 26,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 26 Event 2 */
	{
		.pme_name = "STALL_SLSQ_ORB",
		.pme_desc = "Number of CPs SLS issue stalled due to all ORB entries in use.",
		.pme_code = 106,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 26,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 26 Event 3 */
	{
		.pme_name = "STALL_VU_MISC",
		.pme_desc = "CPs VU stalled due to miscellaneous instructions.",
		.pme_code = 107,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 26,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 27 Event 0 */
	{
		.pme_name = "VOPS_STORE",
		.pme_desc = "Number of selected vector store references g=30-33 & f0=",
		.pme_code = 108,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 27,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 27 Event 1 */
	{
		.pme_name = "INST_MEM_ALLOC",
		.pme_desc = "Number of A and S register memory instructions that allocate.",
		.pme_code = 109,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 27,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 27 Event 2 */
	{
		.pme_name = "STALL_SLSQ_FOQ",
		.pme_desc = "Number of CPs SLS issue stalled due to full FOQ.",
		.pme_code = 110,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 27,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 27 Event 3 */
	{
		.pme_name = "STALL_VDU_NO_INST_VU",
		.pme_desc = "CPs VDU and VU have no valid instructions.",
		.pme_code = 111,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 27,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 28 Event 0 */
	{
		.pme_name = "VOPS_LOAD_STRIDE",
		.pme_desc = "Number of selected vector load references that were stride >2 or <-2.",
		.pme_code = 112,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 28,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 28 Event 1 */
	{
		.pme_name = "INST_SYSCALL",
		.pme_desc = "Number of syscall instructions graduated g=01.",
		.pme_code = 113,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 28,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 28 Event 2 */
	{
		.pme_name = "STALL_SLSQ_LSYNC_VS",
		.pme_desc = "Number of CPs SLS issue is stalled due to active Lsync vs instruction.",
		.pme_code = 114,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 28,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 28 Event 3 */
	{
		.pme_name = "STALL_VDU_SOP_VU",
		.pme_desc = "Number of CPs vector issue has no instructions and the next instruction is waiting on an S reg operand.",
		.pme_code = 115,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 28,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 29 Event 0 */
	{
		.pme_name = "VOPS_STORE_STRIDE",
		.pme_desc = "Number of selected vector store references that were stride >2 or <-2.",
		.pme_code = 116,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 29,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 29 Event 1 */
	{
		.pme_name = "<P:29:1>",
		.pme_desc = "<NA>",
		.pme_code = 117,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 29,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 29 Event 2 */
	{
		.pme_name = "<P:29:2>",
		.pme_desc = "<NA>",
		.pme_code = 118,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 29,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 29 Event 3 */
	{
		.pme_name = "STALL_VDU_NO_INST_VLSU",
		.pme_desc = "CPs VDU and VLSU have no valid instructions.",
		.pme_code = 119,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 29,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 30 Event 0 */
	{
		.pme_name = "VOPS_LOAD_ALLOC",
		.pme_desc = "Number of selected vector load references that were marked allocate (cache line requests count as 1).",
		.pme_code = 120,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 30,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 30 Event 1 */
	{
		.pme_name = "INST_LOAD",
		.pme_desc = "Number of A or S memory loads g=44, 45, 41 & f0=0, 64, 65, 61 & f0=0.",
		.pme_code = 121,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 30,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 30 Event 2 */
	{
		.pme_name = "EXCEPTIONS_TAKEN",
		.pme_desc = "Taken exception count.",
		.pme_code = 122,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 30,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 30 Event 3 */
	{
		.pme_name = "STALL_VDU_SCM_VLSU",
		.pme_desc = "CPs VDU stalled waiting for scalar commit and VLSU has no valid instruction.",
		.pme_code = 123,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 30,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 31 Event 0 */
	{
		.pme_name = "VOPS_STORE_ALLOC",
		.pme_desc = "Number of selected vector stores references that were marked allocate (cache line requests count as 1).",
		.pme_code = 124,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 31,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 31 Event 1 */
	{
		.pme_name = "BRANCH_TAKEN",
		.pme_desc = "Number of taken branches.",
		.pme_code = 125,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 31,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 31 Event 2 */
	{
		.pme_name = "INST_LSYNCSV",
		.pme_desc = "Number of graduated Lsync SV instructions.",
		.pme_code = 126,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 31,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* P Counter 31 Event 3 */
	{
		.pme_name = "STALL_VDU_SCM_VU",
		.pme_desc = "CPs VDU stalled waiting for scalar commit and VU has no valid instruction.",
		.pme_code = 127,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CPU,
		.pme_ctr = 31,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CPU_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CPU_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CPU_CHIPS
	},
	/* C Counter 0 Event 0 */
	{
		.pme_name = "REQUESTS",
		.pme_desc = "Processor requests processed.",
		.pme_code = 128,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 0,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 0 Event 1 */
	{
		.pme_name = "L2_MISSES",
		.pme_desc = "Cache line allocations.",
		.pme_code = 129,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 0,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 0 Event 2 */
	{
		.pme_name = "M_OUT_BUSY",
		.pme_desc = "Cycles W chip output port busy.",
		.pme_code = 130,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 0,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 0 Event 3 */
	{
		.pme_name = "REPLAYED",
		.pme_desc = "Requests sent to replay queue.",
		.pme_code = 131,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 0,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 1 Event 0 */
	{
		.pme_name = "ALLOC_REQUESTS",
		.pme_desc = "Allocating requests (Read, ReadUC, ReadShared, ReadUCShared, ReadMod, SWrite, VWrite).",
		.pme_code = 132,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 1,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 1 Event 1 */
	{
		.pme_name = "<C:1:1>",
		.pme_desc = "<NA>",
		.pme_code = 133,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 1,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 1 Event 2 */
	{
		.pme_name = "M_OUT_BLOCK",
		.pme_desc = "CyclesWchip output port blocked (something to send but no flow control credits).",
		.pme_code = 134,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 1,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 1 Event 3 */
	{
		.pme_name = "LS/VS",
		.pme_desc = "Replayed Ls or Vs Requests sent to the replay queue.",
		.pme_code = 135,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 1,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 2 Event 0 */
	{
		.pme_name = "DWORDS_ALLOCATED",
		.pme_desc = "Dwords written into L2 from L3 (excluding updates).",
		.pme_code = 136,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 2,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 2 Event 1 */
	{
		.pme_name = "<C:2:1>",
		.pme_desc = "<NA>",
		.pme_code = 137,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 2,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 2 Event 2 */
	{
		.pme_name = "NW_OUT_BUSY",
		.pme_desc = "Cycles NIF output port busy.",
		.pme_code = 138,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 2,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 2 Event 3 */
	{
		.pme_name = "REPLAY_PENDING",
		.pme_desc = "Requests sent to replay queue because the line was in PendingReq state.",
		.pme_code = 139,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 2,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 3 Event 0 */
	{
		.pme_name = "DWORDS_EVICTED",
		.pme_desc = "Dwords written back to L3.",
		.pme_code = 140,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 3,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 3 Event 1 */
	{
		.pme_name = "CACHE_LINE_EVICTIONS",
		.pme_desc = "Cache lines evicted due to new allocations.",
		.pme_code = 141,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 3,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 3 Event 2 */
	{
		.pme_name = "NW_OUT_BLOCK",
		.pme_desc = "Cycles NIF output port blocked (something to send but no flow control credits).",
		.pme_code = 142,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 3,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 3 Event 3 */
	{
		.pme_name = "REPLAY_ALLOC",
		.pme_desc = "Requests sent to replay queue because a line could not be allocated due to all ways pending.",
		.pme_code = 143,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 3,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 4 Event 0 */
	{
		.pme_name = "ALLOC_WRITE_TO_L2",
		.pme_desc = "Dwords written to L2 by local allocating write requests.",
		.pme_code = 144,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 4,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 4 Event 1 */
	{
		.pme_name = "DROPS",
		.pme_desc = "Drops sent to directory.",
		.pme_code = 145,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 4,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 4 Event 2 */
	{
		.pme_name = "<C:4:2>",
		.pme_desc = "<NA>",
		.pme_code = 146,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 4,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 4 Event 3 */
	{
		.pme_name = "REPLAY_WAKEUPS",
		.pme_desc = "Replay queue wakeups.",
		.pme_code = 147,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 4,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 5 Event 0 */
	{
		.pme_name = "NON_ALLOC_WRITE_TO_L2",
		.pme_desc = "Dwords written to L2 by local non-allocating write requests.",
		.pme_code = 148,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 5,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 5 Event 1 */
	{
		.pme_name = "WRITE_BACKS",
		.pme_desc = "WriteBacks sent to directory.",
		.pme_code = 149,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 5,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 5 Event 2 */
	{
		.pme_name = "<C:5:2>",
		.pme_desc = "<NA>",
		.pme_code = 150,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 5,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 5 Event 3 */
	{
		.pme_name = "REPLAY_MATCHES",
		.pme_desc = "Requests matched during replay wakeups (Replay_Matches/Replay_Wakeups=avg. number of matches per wakeup).",
		.pme_code = 151,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 5,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 6 Event 0 */
	{
		.pme_name = "NON_ALLOC_WRITE_TO_L3",
		.pme_desc = "Dwords written to L3 by local non-allocating write requests.",
		.pme_code = 152,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 6,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 6 Event 1 */
	{
		.pme_name = "FWD_REQ",
		.pme_desc = "Forwarded requests received (FlushReq, FwdRead, FwdReadShared, FwdGet).",
		.pme_code = 153,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 6,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 6 Event 2 */
	{
		.pme_name = "<C:6:2>",
		.pme_desc = "<NA>",
		.pme_code = 154,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 6,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 6 Event 3 */
	{
		.pme_name = "<C:6:3>",
		.pme_desc = "<NA>",
		.pme_code = 155,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 6,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 7 Event 0 */
	{
		.pme_name = "ALLOC_READ_FROM_L2",
		.pme_desc = "Dwords read from L2 by local allocating read requests.",
		.pme_code = 156,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 7,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 7 Event 1 */
	{
		.pme_name = "FWD_READ_ALL",
		.pme_desc = "FwdReads and FwdReadShared received.",
		.pme_code = 157,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 7,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 7 Event 2 */
	{
		.pme_name = "STALL_RP_FULL_NW",
		.pme_desc = "Cycles NW request queue stalled due to replay queue full.",
		.pme_code = 158,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 7,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 7 Event 3 */
	{
		.pme_name = "ALLOC_NO_FILL",
		.pme_desc = "ReadMods sent to directory when the entire line is dirty.",
		.pme_code = 159,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 7,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 8 Event 0 */
	{
		.pme_name = "NON_ALLOC_READ_FROM_L2",
		.pme_desc = "Dwords read from L2 by local non-allocating read requests.",
		.pme_code = 160,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 8,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 8 Event 1 */
	{
		.pme_name = "FWD_READ_SHARED_RECV",
		.pme_desc = "FwdReadShareds received.",
		.pme_code = 161,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 8,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 8 Event 2 */
	{
		.pme_name = "STALL_RP_FULL_PROC",
		.pme_desc = "Cycles Ls/Vs request queue stalled due to replay queue full.",
		.pme_code = 162,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 8,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 8 Event 3 */
	{
		.pme_name = "UPGRADES",
		.pme_desc = "ReadMods sent to directory when the line was currently in ShClean state.",
		.pme_code = 163,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 8,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 9 Event 0 */
	{
		.pme_name = "NON_ALLOC_READ_FROM_L3",
		.pme_desc = "Dwords read from L3 by local non-allocating read requests.",
		.pme_code = 164,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 9,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 9 Event 1 */
	{
		.pme_name = "FWD_GET_RECV",
		.pme_desc = "FwdGets received.",
		.pme_code = 165,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 9,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 9 Event 2 */
	{
		.pme_name = "STALL_TB_FULL",
		.pme_desc = "Cycles bank request queue stalled due to transient buffer full.",
		.pme_code = 166,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 9,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 9 Event 3 */
	{
		.pme_name = "<C:9:3>",
		.pme_desc = "<NA>",
		.pme_code = 167,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 9,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 10 Event 0 */
	{
		.pme_name = "NETWORK_WRITE_TO_L2",
		.pme_desc = "Dwords written to L2 by remote write requests.",
		.pme_code = 168,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 10,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 10 Event 1 */
	{
		.pme_name = "FLUSH_REQ",
		.pme_desc = "FlushReqs received.",
		.pme_code = 169,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 10,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 10 Event 2 */
	{
		.pme_name = "STALL_VWRITENA",
		.pme_desc = "Cycles bank request queue stalled due to VWriteNA bit being set.",
		.pme_code = 170,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 10,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 10 Event 3 */
	{
		.pme_name = "<C:10:3>",
		.pme_desc = "<NA>",
		.pme_code = 171,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 10,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 11 Event 0 */
	{
		.pme_name = "NETWORK_WRITE_TO_L3",
		.pme_desc = "Dwords written to L3 by remote write requests.",
		.pme_code = 172,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 11,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 11 Event 1 */
	{
		.pme_name = "UPDATES_RECV",
		.pme_desc = "Updates received.",
		.pme_code = 173,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 11,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 11 Event 2 */
	{
		.pme_name = "PROT_ENGINE_IDLE_NO_REQUEST",
		.pme_desc = "Cycles protocol engine idle due to no new requests to process.",
		.pme_code = 174,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 11,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 11 Event 3 */
	{
		.pme_name = "READ_DATA_TO_VECTOR_UNIT_PIPE_0_3",
		.pme_desc = "Swords delivered to vector unit via pipes 0 - 3.",
		.pme_code = 175,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 11,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 12 Event 0 */
	{
		.pme_name = "NETWORK_READ_FROM_L2",
		.pme_desc = "Dwords read from L2 by remote read requests.",
		.pme_code = 176,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 12,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 12 Event 1 */
	{
		.pme_name = "<C:12:1>",
		.pme_desc = "<NA>",
		.pme_code = 177,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 12,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 12 Event 2 */
	{
		.pme_name = "UPDATE_NACK_SENT",
		.pme_desc = "UpdateNacks sent.",
		.pme_code = 178,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 12,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 12 Event 3 */
	{
		.pme_name = "READ_DATA_TO_VECTOR_UNIT_PIPE_4_7",
		.pme_desc = "Swords delivered to vector unit via pipes 4 - 7.",
		.pme_code = 179,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 12,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 13 Event 0 */
	{
		.pme_name = "NETWORK_READ_FROM_L3",
		.pme_desc = "Dwords read from L3 by remote read requests.",
		.pme_code = 180,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 13,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 13 Event 1 */
	{
		.pme_name = "NACKS_SENT",
		.pme_desc = "FlushAcks and UpdateNacks sent (these happen when there's a race b/w a forwarded request and an eviction by the current owner).",
		.pme_code = 181,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 13,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 13 Event 2 */
	{
		.pme_name = "INVAL_RECV",
		.pme_desc = "Inval packets received from the directory.",
		.pme_code = 182,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 13,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 13 Event 3 */
	{
		.pme_name = "READ_DATA_TO_SCALAR_UNIT",
		.pme_desc = "Dwords delivered to scalar unit.",
		.pme_code = 183,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 13,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 14 Event 0 */
	{
		.pme_name = "REMOTE_READS",
		.pme_desc = "Dwords read from remote nodes.",
		.pme_code = 184,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 14,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 14 Event 1 */
	{
		.pme_name = "LOCAL_INVAL",
		.pme_desc = "Local writes that cause invals of other Dcaches.",
		.pme_code = 185,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 14,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 14 Event 2 */
	{
		.pme_name = "MARKED_REQS",
		.pme_desc = "Memory requests sent with TID 0.",
		.pme_code = 186,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 14,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 14 Event 3 */
	{
		.pme_name = "READ_DATA_TO_ICACHE",
		.pme_desc = "Dwords delivered to Icache.",
		.pme_code = 187,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 14,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 15 Event 0 */
	{
		.pme_name = "REMOTE_WRITES",
		.pme_desc = "Dwords written to remote nodes.",
		.pme_code = 188,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 15,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 15 Event 1 */
	{
		.pme_name = "DCACHE_INVAL_EVENTS",
		.pme_desc = "State transitions (evictions, directory Invals or forwards, processor writes) requiring Dcache invals.",
		.pme_code = 189,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 15,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 15 Event 2 */
	{
		.pme_name = "MARKED_CYCLES",
		.pme_desc = "Cycles with a TID 0 request outstanding.",
		.pme_code = 190,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 15,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* C Counter 15 Event 3 */
	{
		.pme_name = "READ_DATA_TO_NIF",
		.pme_desc = "Dwords delivered to NIF.",
		.pme_code = 191,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_CACHE,
		.pme_ctr = 15,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_CACHE_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_CACHE_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_CACHE_CHIPS
	},
	/* M Counter 0 Event 0 */
	{
		.pme_name = "W_IN_IDLE_0@0",
		.pme_desc = "Wclk cycles BW2MD input port 0 is idle (no flits in either VC0 or VC2). (M chip 0)",
		.pme_code = 192,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_0@1",
		.pme_desc = "Wclk cycles BW2MD input port 0 is idle (no flits in either VC0 or VC2). (M chip 1)",
		.pme_code = 193,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_0@2",
		.pme_desc = "Wclk cycles BW2MD input port 0 is idle (no flits in either VC0 or VC2). (M chip 2)",
		.pme_code = 194,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_0@3",
		.pme_desc = "Wclk cycles BW2MD input port 0 is idle (no flits in either VC0 or VC2). (M chip 3)",
		.pme_code = 195,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_0@4",
		.pme_desc = "Wclk cycles BW2MD input port 0 is idle (no flits in either VC0 or VC2). (M chip 4)",
		.pme_code = 196,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_0@5",
		.pme_desc = "Wclk cycles BW2MD input port 0 is idle (no flits in either VC0 or VC2). (M chip 5)",
		.pme_code = 197,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_0@6",
		.pme_desc = "Wclk cycles BW2MD input port 0 is idle (no flits in either VC0 or VC2). (M chip 6)",
		.pme_code = 198,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_0@7",
		.pme_desc = "Wclk cycles BW2MD input port 0 is idle (no flits in either VC0 or VC2). (M chip 7)",
		.pme_code = 199,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_0@8",
		.pme_desc = "Wclk cycles BW2MD input port 0 is idle (no flits in either VC0 or VC2). (M chip 8)",
		.pme_code = 200,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_0@9",
		.pme_desc = "Wclk cycles BW2MD input port 0 is idle (no flits in either VC0 or VC2). (M chip 9)",
		.pme_code = 201,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_0@10",
		.pme_desc = "Wclk cycles BW2MD input port 0 is idle (no flits in either VC0 or VC2). (M chip 10)",
		.pme_code = 202,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_0@11",
		.pme_desc = "Wclk cycles BW2MD input port 0 is idle (no flits in either VC0 or VC2). (M chip 11)",
		.pme_code = 203,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_0@12",
		.pme_desc = "Wclk cycles BW2MD input port 0 is idle (no flits in either VC0 or VC2). (M chip 12)",
		.pme_code = 204,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_0@13",
		.pme_desc = "Wclk cycles BW2MD input port 0 is idle (no flits in either VC0 or VC2). (M chip 13)",
		.pme_code = 205,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_0@14",
		.pme_desc = "Wclk cycles BW2MD input port 0 is idle (no flits in either VC0 or VC2). (M chip 14)",
		.pme_code = 206,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_0@15",
		.pme_desc = "Wclk cycles BW2MD input port 0 is idle (no flits in either VC0 or VC2). (M chip 15)",
		.pme_code = 207,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 0 Event 1 */
	{
		.pme_name = "STALL_REPLAY_FULL@0",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to replay queue full (sum of 4 engines). (M chip 0)",
		.pme_code = 208,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_REPLAY_FULL@1",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to replay queue full (sum of 4 engines). (M chip 1)",
		.pme_code = 209,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_REPLAY_FULL@2",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to replay queue full (sum of 4 engines). (M chip 2)",
		.pme_code = 210,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_REPLAY_FULL@3",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to replay queue full (sum of 4 engines). (M chip 3)",
		.pme_code = 211,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_REPLAY_FULL@4",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to replay queue full (sum of 4 engines). (M chip 4)",
		.pme_code = 212,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_REPLAY_FULL@5",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to replay queue full (sum of 4 engines). (M chip 5)",
		.pme_code = 213,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_REPLAY_FULL@6",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to replay queue full (sum of 4 engines). (M chip 6)",
		.pme_code = 214,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_REPLAY_FULL@7",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to replay queue full (sum of 4 engines). (M chip 7)",
		.pme_code = 215,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_REPLAY_FULL@8",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to replay queue full (sum of 4 engines). (M chip 8)",
		.pme_code = 216,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_REPLAY_FULL@9",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to replay queue full (sum of 4 engines). (M chip 9)",
		.pme_code = 217,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_REPLAY_FULL@10",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to replay queue full (sum of 4 engines). (M chip 10)",
		.pme_code = 218,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_REPLAY_FULL@11",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to replay queue full (sum of 4 engines). (M chip 11)",
		.pme_code = 219,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_REPLAY_FULL@12",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to replay queue full (sum of 4 engines). (M chip 12)",
		.pme_code = 220,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_REPLAY_FULL@13",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to replay queue full (sum of 4 engines). (M chip 13)",
		.pme_code = 221,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_REPLAY_FULL@14",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to replay queue full (sum of 4 engines). (M chip 14)",
		.pme_code = 222,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_REPLAY_FULL@15",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to replay queue full (sum of 4 engines). (M chip 15)",
		.pme_code = 223,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 0 Event 2 */
	{
		.pme_name = "W_OUT_IDLE_0@0",
		.pme_desc = "Wclk cycles MD2BW output port 0 is idle (no flits flowing). (M chip 0)",
		.pme_code = 224,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_0@1",
		.pme_desc = "Wclk cycles MD2BW output port 0 is idle (no flits flowing). (M chip 1)",
		.pme_code = 225,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_0@2",
		.pme_desc = "Wclk cycles MD2BW output port 0 is idle (no flits flowing). (M chip 2)",
		.pme_code = 226,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_0@3",
		.pme_desc = "Wclk cycles MD2BW output port 0 is idle (no flits flowing). (M chip 3)",
		.pme_code = 227,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_0@4",
		.pme_desc = "Wclk cycles MD2BW output port 0 is idle (no flits flowing). (M chip 4)",
		.pme_code = 228,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_0@5",
		.pme_desc = "Wclk cycles MD2BW output port 0 is idle (no flits flowing). (M chip 5)",
		.pme_code = 229,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_0@6",
		.pme_desc = "Wclk cycles MD2BW output port 0 is idle (no flits flowing). (M chip 6)",
		.pme_code = 230,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_0@7",
		.pme_desc = "Wclk cycles MD2BW output port 0 is idle (no flits flowing). (M chip 7)",
		.pme_code = 231,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_0@8",
		.pme_desc = "Wclk cycles MD2BW output port 0 is idle (no flits flowing). (M chip 8)",
		.pme_code = 232,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_0@9",
		.pme_desc = "Wclk cycles MD2BW output port 0 is idle (no flits flowing). (M chip 9)",
		.pme_code = 233,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_0@10",
		.pme_desc = "Wclk cycles MD2BW output port 0 is idle (no flits flowing). (M chip 10)",
		.pme_code = 234,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_0@11",
		.pme_desc = "Wclk cycles MD2BW output port 0 is idle (no flits flowing). (M chip 11)",
		.pme_code = 235,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_0@12",
		.pme_desc = "Wclk cycles MD2BW output port 0 is idle (no flits flowing). (M chip 12)",
		.pme_code = 236,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_0@13",
		.pme_desc = "Wclk cycles MD2BW output port 0 is idle (no flits flowing). (M chip 13)",
		.pme_code = 237,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_0@14",
		.pme_desc = "Wclk cycles MD2BW output port 0 is idle (no flits flowing). (M chip 14)",
		.pme_code = 238,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_0@15",
		.pme_desc = "Wclk cycles MD2BW output port 0 is idle (no flits flowing). (M chip 15)",
		.pme_code = 239,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 0 Event 3 */
	{
		.pme_name = "<M:0:3>@0",
		.pme_desc = "<NA>",
		.pme_code = 240,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:0:3>@1",
		.pme_desc = "<NA>",
		.pme_code = 241,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:0:3>@2",
		.pme_desc = "<NA>",
		.pme_code = 242,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:0:3>@3",
		.pme_desc = "<NA>",
		.pme_code = 243,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:0:3>@4",
		.pme_desc = "<NA>",
		.pme_code = 244,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:0:3>@5",
		.pme_desc = "<NA>",
		.pme_code = 245,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:0:3>@6",
		.pme_desc = "<NA>",
		.pme_code = 246,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:0:3>@7",
		.pme_desc = "<NA>",
		.pme_code = 247,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:0:3>@8",
		.pme_desc = "<NA>",
		.pme_code = 248,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:0:3>@9",
		.pme_desc = "<NA>",
		.pme_code = 249,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:0:3>@10",
		.pme_desc = "<NA>",
		.pme_code = 250,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:0:3>@11",
		.pme_desc = "<NA>",
		.pme_code = 251,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:0:3>@12",
		.pme_desc = "<NA>",
		.pme_code = 252,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:0:3>@13",
		.pme_desc = "<NA>",
		.pme_code = 253,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:0:3>@14",
		.pme_desc = "<NA>",
		.pme_code = 254,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:0:3>@15",
		.pme_desc = "<NA>",
		.pme_code = 255,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 0,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 1 Event 0 */
	{
		.pme_name = "W_IN_IDLE_1@0",
		.pme_desc = "Wclk cycles BW2MD input port 1 is idle (no flits in either VC0 or VC2). (M chip 0)",
		.pme_code = 256,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_1@1",
		.pme_desc = "Wclk cycles BW2MD input port 1 is idle (no flits in either VC0 or VC2). (M chip 1)",
		.pme_code = 257,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_1@2",
		.pme_desc = "Wclk cycles BW2MD input port 1 is idle (no flits in either VC0 or VC2). (M chip 2)",
		.pme_code = 258,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_1@3",
		.pme_desc = "Wclk cycles BW2MD input port 1 is idle (no flits in either VC0 or VC2). (M chip 3)",
		.pme_code = 259,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_1@4",
		.pme_desc = "Wclk cycles BW2MD input port 1 is idle (no flits in either VC0 or VC2). (M chip 4)",
		.pme_code = 260,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_1@5",
		.pme_desc = "Wclk cycles BW2MD input port 1 is idle (no flits in either VC0 or VC2). (M chip 5)",
		.pme_code = 261,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_1@6",
		.pme_desc = "Wclk cycles BW2MD input port 1 is idle (no flits in either VC0 or VC2). (M chip 6)",
		.pme_code = 262,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_1@7",
		.pme_desc = "Wclk cycles BW2MD input port 1 is idle (no flits in either VC0 or VC2). (M chip 7)",
		.pme_code = 263,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_1@8",
		.pme_desc = "Wclk cycles BW2MD input port 1 is idle (no flits in either VC0 or VC2). (M chip 8)",
		.pme_code = 264,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_1@9",
		.pme_desc = "Wclk cycles BW2MD input port 1 is idle (no flits in either VC0 or VC2). (M chip 9)",
		.pme_code = 265,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_1@10",
		.pme_desc = "Wclk cycles BW2MD input port 1 is idle (no flits in either VC0 or VC2). (M chip 10)",
		.pme_code = 266,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_1@11",
		.pme_desc = "Wclk cycles BW2MD input port 1 is idle (no flits in either VC0 or VC2). (M chip 11)",
		.pme_code = 267,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_1@12",
		.pme_desc = "Wclk cycles BW2MD input port 1 is idle (no flits in either VC0 or VC2). (M chip 12)",
		.pme_code = 268,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_1@13",
		.pme_desc = "Wclk cycles BW2MD input port 1 is idle (no flits in either VC0 or VC2). (M chip 13)",
		.pme_code = 269,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_1@14",
		.pme_desc = "Wclk cycles BW2MD input port 1 is idle (no flits in either VC0 or VC2). (M chip 14)",
		.pme_code = 270,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_1@15",
		.pme_desc = "Wclk cycles BW2MD input port 1 is idle (no flits in either VC0 or VC2). (M chip 15)",
		.pme_code = 271,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 1 Event 1 */
	{
		.pme_name = "STALL_TDB_FULL@0",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to transient directory buffer full (sum of 4 engines). (M chip 0)",
		.pme_code = 272,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_TDB_FULL@1",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to transient directory buffer full (sum of 4 engines). (M chip 1)",
		.pme_code = 273,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_TDB_FULL@2",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to transient directory buffer full (sum of 4 engines). (M chip 2)",
		.pme_code = 274,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_TDB_FULL@3",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to transient directory buffer full (sum of 4 engines). (M chip 3)",
		.pme_code = 275,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_TDB_FULL@4",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to transient directory buffer full (sum of 4 engines). (M chip 4)",
		.pme_code = 276,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_TDB_FULL@5",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to transient directory buffer full (sum of 4 engines). (M chip 5)",
		.pme_code = 277,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_TDB_FULL@6",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to transient directory buffer full (sum of 4 engines). (M chip 6)",
		.pme_code = 278,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_TDB_FULL@7",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to transient directory buffer full (sum of 4 engines). (M chip 7)",
		.pme_code = 279,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_TDB_FULL@8",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to transient directory buffer full (sum of 4 engines). (M chip 8)",
		.pme_code = 280,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_TDB_FULL@9",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to transient directory buffer full (sum of 4 engines). (M chip 9)",
		.pme_code = 281,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_TDB_FULL@10",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to transient directory buffer full (sum of 4 engines). (M chip 10)",
		.pme_code = 282,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_TDB_FULL@11",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to transient directory buffer full (sum of 4 engines). (M chip 11)",
		.pme_code = 283,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_TDB_FULL@12",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to transient directory buffer full (sum of 4 engines). (M chip 12)",
		.pme_code = 284,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_TDB_FULL@13",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to transient directory buffer full (sum of 4 engines). (M chip 13)",
		.pme_code = 285,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_TDB_FULL@14",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to transient directory buffer full (sum of 4 engines). (M chip 14)",
		.pme_code = 286,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_TDB_FULL@15",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to transient directory buffer full (sum of 4 engines). (M chip 15)",
		.pme_code = 287,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 1 Event 2 */
	{
		.pme_name = "W_OUT_IDLE_1@0",
		.pme_desc = "Wclk cycles MD2BW output port 1 is idle (no flits flowing). (M chip 0)",
		.pme_code = 288,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_1@1",
		.pme_desc = "Wclk cycles MD2BW output port 1 is idle (no flits flowing). (M chip 1)",
		.pme_code = 289,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_1@2",
		.pme_desc = "Wclk cycles MD2BW output port 1 is idle (no flits flowing). (M chip 2)",
		.pme_code = 290,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_1@3",
		.pme_desc = "Wclk cycles MD2BW output port 1 is idle (no flits flowing). (M chip 3)",
		.pme_code = 291,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_1@4",
		.pme_desc = "Wclk cycles MD2BW output port 1 is idle (no flits flowing). (M chip 4)",
		.pme_code = 292,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_1@5",
		.pme_desc = "Wclk cycles MD2BW output port 1 is idle (no flits flowing). (M chip 5)",
		.pme_code = 293,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_1@6",
		.pme_desc = "Wclk cycles MD2BW output port 1 is idle (no flits flowing). (M chip 6)",
		.pme_code = 294,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_1@7",
		.pme_desc = "Wclk cycles MD2BW output port 1 is idle (no flits flowing). (M chip 7)",
		.pme_code = 295,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_1@8",
		.pme_desc = "Wclk cycles MD2BW output port 1 is idle (no flits flowing). (M chip 8)",
		.pme_code = 296,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_1@9",
		.pme_desc = "Wclk cycles MD2BW output port 1 is idle (no flits flowing). (M chip 9)",
		.pme_code = 297,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_1@10",
		.pme_desc = "Wclk cycles MD2BW output port 1 is idle (no flits flowing). (M chip 10)",
		.pme_code = 298,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_1@11",
		.pme_desc = "Wclk cycles MD2BW output port 1 is idle (no flits flowing). (M chip 11)",
		.pme_code = 299,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_1@12",
		.pme_desc = "Wclk cycles MD2BW output port 1 is idle (no flits flowing). (M chip 12)",
		.pme_code = 300,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_1@13",
		.pme_desc = "Wclk cycles MD2BW output port 1 is idle (no flits flowing). (M chip 13)",
		.pme_code = 301,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_1@14",
		.pme_desc = "Wclk cycles MD2BW output port 1 is idle (no flits flowing). (M chip 14)",
		.pme_code = 302,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_1@15",
		.pme_desc = "Wclk cycles MD2BW output port 1 is idle (no flits flowing). (M chip 15)",
		.pme_code = 303,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 1 Event 3 */
	{
		.pme_name = "FWD_READ_SHARED_SENT@0",
		.pme_desc = "FwdReadShared packets sent (Exclusive -> PendFwd transition). (M chip 0)",
		.pme_code = 304,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ_SHARED_SENT@1",
		.pme_desc = "FwdReadShared packets sent (Exclusive -> PendFwd transition). (M chip 1)",
		.pme_code = 305,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ_SHARED_SENT@2",
		.pme_desc = "FwdReadShared packets sent (Exclusive -> PendFwd transition). (M chip 2)",
		.pme_code = 306,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ_SHARED_SENT@3",
		.pme_desc = "FwdReadShared packets sent (Exclusive -> PendFwd transition). (M chip 3)",
		.pme_code = 307,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ_SHARED_SENT@4",
		.pme_desc = "FwdReadShared packets sent (Exclusive -> PendFwd transition). (M chip 4)",
		.pme_code = 308,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ_SHARED_SENT@5",
		.pme_desc = "FwdReadShared packets sent (Exclusive -> PendFwd transition). (M chip 5)",
		.pme_code = 309,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ_SHARED_SENT@6",
		.pme_desc = "FwdReadShared packets sent (Exclusive -> PendFwd transition). (M chip 6)",
		.pme_code = 310,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ_SHARED_SENT@7",
		.pme_desc = "FwdReadShared packets sent (Exclusive -> PendFwd transition). (M chip 7)",
		.pme_code = 311,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ_SHARED_SENT@8",
		.pme_desc = "FwdReadShared packets sent (Exclusive -> PendFwd transition). (M chip 8)",
		.pme_code = 312,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ_SHARED_SENT@9",
		.pme_desc = "FwdReadShared packets sent (Exclusive -> PendFwd transition). (M chip 9)",
		.pme_code = 313,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ_SHARED_SENT@10",
		.pme_desc = "FwdReadShared packets sent (Exclusive -> PendFwd transition). (M chip 10)",
		.pme_code = 314,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ_SHARED_SENT@11",
		.pme_desc = "FwdReadShared packets sent (Exclusive -> PendFwd transition). (M chip 11)",
		.pme_code = 315,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ_SHARED_SENT@12",
		.pme_desc = "FwdReadShared packets sent (Exclusive -> PendFwd transition). (M chip 12)",
		.pme_code = 316,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ_SHARED_SENT@13",
		.pme_desc = "FwdReadShared packets sent (Exclusive -> PendFwd transition). (M chip 13)",
		.pme_code = 317,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ_SHARED_SENT@14",
		.pme_desc = "FwdReadShared packets sent (Exclusive -> PendFwd transition). (M chip 14)",
		.pme_code = 318,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ_SHARED_SENT@15",
		.pme_desc = "FwdReadShared packets sent (Exclusive -> PendFwd transition). (M chip 15)",
		.pme_code = 319,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 1,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 2 Event 0 */
	{
		.pme_name = "UPDATES_SENT@0",
		.pme_desc = "Puts that cause an Update to be sent to owner. (M chip 0)",
		.pme_code = 320,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATES_SENT@1",
		.pme_desc = "Puts that cause an Update to be sent to owner. (M chip 1)",
		.pme_code = 321,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATES_SENT@2",
		.pme_desc = "Puts that cause an Update to be sent to owner. (M chip 2)",
		.pme_code = 322,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATES_SENT@3",
		.pme_desc = "Puts that cause an Update to be sent to owner. (M chip 3)",
		.pme_code = 323,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATES_SENT@4",
		.pme_desc = "Puts that cause an Update to be sent to owner. (M chip 4)",
		.pme_code = 324,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATES_SENT@5",
		.pme_desc = "Puts that cause an Update to be sent to owner. (M chip 5)",
		.pme_code = 325,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATES_SENT@6",
		.pme_desc = "Puts that cause an Update to be sent to owner. (M chip 6)",
		.pme_code = 326,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATES_SENT@7",
		.pme_desc = "Puts that cause an Update to be sent to owner. (M chip 7)",
		.pme_code = 327,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATES_SENT@8",
		.pme_desc = "Puts that cause an Update to be sent to owner. (M chip 8)",
		.pme_code = 328,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATES_SENT@9",
		.pme_desc = "Puts that cause an Update to be sent to owner. (M chip 9)",
		.pme_code = 329,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATES_SENT@10",
		.pme_desc = "Puts that cause an Update to be sent to owner. (M chip 10)",
		.pme_code = 330,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATES_SENT@11",
		.pme_desc = "Puts that cause an Update to be sent to owner. (M chip 11)",
		.pme_code = 331,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATES_SENT@12",
		.pme_desc = "Puts that cause an Update to be sent to owner. (M chip 12)",
		.pme_code = 332,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATES_SENT@13",
		.pme_desc = "Puts that cause an Update to be sent to owner. (M chip 13)",
		.pme_code = 333,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATES_SENT@14",
		.pme_desc = "Puts that cause an Update to be sent to owner. (M chip 14)",
		.pme_code = 334,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATES_SENT@15",
		.pme_desc = "Puts that cause an Update to be sent to owner. (M chip 15)",
		.pme_code = 335,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 2 Event 1 */
	{
		.pme_name = "STALL_MM_RESPQ@0",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to MM VN1 response queue full (sum of 4 engines). (M chip 0)",
		.pme_code = 336,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM_RESPQ@1",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to MM VN1 response queue full (sum of 4 engines). (M chip 1)",
		.pme_code = 337,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM_RESPQ@2",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to MM VN1 response queue full (sum of 4 engines). (M chip 2)",
		.pme_code = 338,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM_RESPQ@3",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to MM VN1 response queue full (sum of 4 engines). (M chip 3)",
		.pme_code = 339,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM_RESPQ@4",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to MM VN1 response queue full (sum of 4 engines). (M chip 4)",
		.pme_code = 340,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM_RESPQ@5",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to MM VN1 response queue full (sum of 4 engines). (M chip 5)",
		.pme_code = 341,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM_RESPQ@6",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to MM VN1 response queue full (sum of 4 engines). (M chip 6)",
		.pme_code = 342,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM_RESPQ@7",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to MM VN1 response queue full (sum of 4 engines). (M chip 7)",
		.pme_code = 343,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM_RESPQ@8",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to MM VN1 response queue full (sum of 4 engines). (M chip 8)",
		.pme_code = 344,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM_RESPQ@9",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to MM VN1 response queue full (sum of 4 engines). (M chip 9)",
		.pme_code = 345,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM_RESPQ@10",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to MM VN1 response queue full (sum of 4 engines). (M chip 10)",
		.pme_code = 346,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM_RESPQ@11",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to MM VN1 response queue full (sum of 4 engines). (M chip 11)",
		.pme_code = 347,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM_RESPQ@12",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to MM VN1 response queue full (sum of 4 engines). (M chip 12)",
		.pme_code = 348,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM_RESPQ@13",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to MM VN1 response queue full (sum of 4 engines). (M chip 13)",
		.pme_code = 349,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM_RESPQ@14",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to MM VN1 response queue full (sum of 4 engines). (M chip 14)",
		.pme_code = 350,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM_RESPQ@15",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to MM VN1 response queue full (sum of 4 engines). (M chip 15)",
		.pme_code = 351,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 2 Event 2 */
	{
		.pme_name = "W_OUT_IDLE_2@0",
		.pme_desc = "Wclk cycles MD2BW output port 2 is idle (no flits flowing). (M chip 0)",
		.pme_code = 352,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_2@1",
		.pme_desc = "Wclk cycles MD2BW output port 2 is idle (no flits flowing). (M chip 1)",
		.pme_code = 353,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_2@2",
		.pme_desc = "Wclk cycles MD2BW output port 2 is idle (no flits flowing). (M chip 2)",
		.pme_code = 354,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_2@3",
		.pme_desc = "Wclk cycles MD2BW output port 2 is idle (no flits flowing). (M chip 3)",
		.pme_code = 355,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_2@4",
		.pme_desc = "Wclk cycles MD2BW output port 2 is idle (no flits flowing). (M chip 4)",
		.pme_code = 356,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_2@5",
		.pme_desc = "Wclk cycles MD2BW output port 2 is idle (no flits flowing). (M chip 5)",
		.pme_code = 357,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_2@6",
		.pme_desc = "Wclk cycles MD2BW output port 2 is idle (no flits flowing). (M chip 6)",
		.pme_code = 358,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_2@7",
		.pme_desc = "Wclk cycles MD2BW output port 2 is idle (no flits flowing). (M chip 7)",
		.pme_code = 359,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_2@8",
		.pme_desc = "Wclk cycles MD2BW output port 2 is idle (no flits flowing). (M chip 8)",
		.pme_code = 360,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_2@9",
		.pme_desc = "Wclk cycles MD2BW output port 2 is idle (no flits flowing). (M chip 9)",
		.pme_code = 361,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_2@10",
		.pme_desc = "Wclk cycles MD2BW output port 2 is idle (no flits flowing). (M chip 10)",
		.pme_code = 362,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_2@11",
		.pme_desc = "Wclk cycles MD2BW output port 2 is idle (no flits flowing). (M chip 11)",
		.pme_code = 363,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_2@12",
		.pme_desc = "Wclk cycles MD2BW output port 2 is idle (no flits flowing). (M chip 12)",
		.pme_code = 364,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_2@13",
		.pme_desc = "Wclk cycles MD2BW output port 2 is idle (no flits flowing). (M chip 13)",
		.pme_code = 365,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_2@14",
		.pme_desc = "Wclk cycles MD2BW output port 2 is idle (no flits flowing). (M chip 14)",
		.pme_code = 366,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_2@15",
		.pme_desc = "Wclk cycles MD2BW output port 2 is idle (no flits flowing). (M chip 15)",
		.pme_code = 367,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 2 Event 3 */
	{
		.pme_name = "W_IN_IDLE_2@0",
		.pme_desc = "Wclk cycles BW2MD input port 2 is idle (no flits in either VC0 or VC2). (M chip 0)",
		.pme_code = 368,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_2@1",
		.pme_desc = "Wclk cycles BW2MD input port 2 is idle (no flits in either VC0 or VC2). (M chip 1)",
		.pme_code = 369,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_2@2",
		.pme_desc = "Wclk cycles BW2MD input port 2 is idle (no flits in either VC0 or VC2). (M chip 2)",
		.pme_code = 370,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_2@3",
		.pme_desc = "Wclk cycles BW2MD input port 2 is idle (no flits in either VC0 or VC2). (M chip 3)",
		.pme_code = 371,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_2@4",
		.pme_desc = "Wclk cycles BW2MD input port 2 is idle (no flits in either VC0 or VC2). (M chip 4)",
		.pme_code = 372,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_2@5",
		.pme_desc = "Wclk cycles BW2MD input port 2 is idle (no flits in either VC0 or VC2). (M chip 5)",
		.pme_code = 373,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_2@6",
		.pme_desc = "Wclk cycles BW2MD input port 2 is idle (no flits in either VC0 or VC2). (M chip 6)",
		.pme_code = 374,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_2@7",
		.pme_desc = "Wclk cycles BW2MD input port 2 is idle (no flits in either VC0 or VC2). (M chip 7)",
		.pme_code = 375,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_2@8",
		.pme_desc = "Wclk cycles BW2MD input port 2 is idle (no flits in either VC0 or VC2). (M chip 8)",
		.pme_code = 376,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_2@9",
		.pme_desc = "Wclk cycles BW2MD input port 2 is idle (no flits in either VC0 or VC2). (M chip 9)",
		.pme_code = 377,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_2@10",
		.pme_desc = "Wclk cycles BW2MD input port 2 is idle (no flits in either VC0 or VC2). (M chip 10)",
		.pme_code = 378,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_2@11",
		.pme_desc = "Wclk cycles BW2MD input port 2 is idle (no flits in either VC0 or VC2). (M chip 11)",
		.pme_code = 379,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_2@12",
		.pme_desc = "Wclk cycles BW2MD input port 2 is idle (no flits in either VC0 or VC2). (M chip 12)",
		.pme_code = 380,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_2@13",
		.pme_desc = "Wclk cycles BW2MD input port 2 is idle (no flits in either VC0 or VC2). (M chip 13)",
		.pme_code = 381,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_2@14",
		.pme_desc = "Wclk cycles BW2MD input port 2 is idle (no flits in either VC0 or VC2). (M chip 14)",
		.pme_code = 382,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_2@15",
		.pme_desc = "Wclk cycles BW2MD input port 2 is idle (no flits in either VC0 or VC2). (M chip 15)",
		.pme_code = 383,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 2,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 3 Event 0 */
	{
		.pme_name = "NON_CACHED@0",
		.pme_desc = "Read requests satisfied from non-cached state. (M chip 0)",
		.pme_code = 384,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NON_CACHED@1",
		.pme_desc = "Read requests satisfied from non-cached state. (M chip 1)",
		.pme_code = 385,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NON_CACHED@2",
		.pme_desc = "Read requests satisfied from non-cached state. (M chip 2)",
		.pme_code = 386,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NON_CACHED@3",
		.pme_desc = "Read requests satisfied from non-cached state. (M chip 3)",
		.pme_code = 387,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NON_CACHED@4",
		.pme_desc = "Read requests satisfied from non-cached state. (M chip 4)",
		.pme_code = 388,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NON_CACHED@5",
		.pme_desc = "Read requests satisfied from non-cached state. (M chip 5)",
		.pme_code = 389,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NON_CACHED@6",
		.pme_desc = "Read requests satisfied from non-cached state. (M chip 6)",
		.pme_code = 390,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NON_CACHED@7",
		.pme_desc = "Read requests satisfied from non-cached state. (M chip 7)",
		.pme_code = 391,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NON_CACHED@8",
		.pme_desc = "Read requests satisfied from non-cached state. (M chip 8)",
		.pme_code = 392,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NON_CACHED@9",
		.pme_desc = "Read requests satisfied from non-cached state. (M chip 9)",
		.pme_code = 393,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NON_CACHED@10",
		.pme_desc = "Read requests satisfied from non-cached state. (M chip 10)",
		.pme_code = 394,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NON_CACHED@11",
		.pme_desc = "Read requests satisfied from non-cached state. (M chip 11)",
		.pme_code = 395,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NON_CACHED@12",
		.pme_desc = "Read requests satisfied from non-cached state. (M chip 12)",
		.pme_code = 396,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NON_CACHED@13",
		.pme_desc = "Read requests satisfied from non-cached state. (M chip 13)",
		.pme_code = 397,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NON_CACHED@14",
		.pme_desc = "Read requests satisfied from non-cached state. (M chip 14)",
		.pme_code = 398,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NON_CACHED@15",
		.pme_desc = "Read requests satisfied from non-cached state. (M chip 15)",
		.pme_code = 399,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 3 Event 1 */
	{
		.pme_name = "STALL_ASSOC@0",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to temporary over-subscription of directory ways. (M chip 0)",
		.pme_code = 400,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_ASSOC@1",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to temporary over-subscription of directory ways. (M chip 1)",
		.pme_code = 401,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_ASSOC@2",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to temporary over-subscription of directory ways. (M chip 2)",
		.pme_code = 402,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_ASSOC@3",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to temporary over-subscription of directory ways. (M chip 3)",
		.pme_code = 403,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_ASSOC@4",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to temporary over-subscription of directory ways. (M chip 4)",
		.pme_code = 404,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_ASSOC@5",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to temporary over-subscription of directory ways. (M chip 5)",
		.pme_code = 405,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_ASSOC@6",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to temporary over-subscription of directory ways. (M chip 6)",
		.pme_code = 406,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_ASSOC@7",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to temporary over-subscription of directory ways. (M chip 7)",
		.pme_code = 407,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_ASSOC@8",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to temporary over-subscription of directory ways. (M chip 8)",
		.pme_code = 408,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_ASSOC@9",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to temporary over-subscription of directory ways. (M chip 9)",
		.pme_code = 409,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_ASSOC@10",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to temporary over-subscription of directory ways. (M chip 10)",
		.pme_code = 410,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_ASSOC@11",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to temporary over-subscription of directory ways. (M chip 11)",
		.pme_code = 411,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_ASSOC@12",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to temporary over-subscription of directory ways. (M chip 12)",
		.pme_code = 412,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_ASSOC@13",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to temporary over-subscription of directory ways. (M chip 13)",
		.pme_code = 413,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_ASSOC@14",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to temporary over-subscription of directory ways. (M chip 14)",
		.pme_code = 414,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_ASSOC@15",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to temporary over-subscription of directory ways. (M chip 15)",
		.pme_code = 415,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 3 Event 2 */
	{
		.pme_name = "W_OUT_IDLE_3@0",
		.pme_desc = "Wclk cycles MD2BW output port 3 is idle (no flits flowing). (M chip 0)",
		.pme_code = 416,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_3@1",
		.pme_desc = "Wclk cycles MD2BW output port 3 is idle (no flits flowing). (M chip 1)",
		.pme_code = 417,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_3@2",
		.pme_desc = "Wclk cycles MD2BW output port 3 is idle (no flits flowing). (M chip 2)",
		.pme_code = 418,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_3@3",
		.pme_desc = "Wclk cycles MD2BW output port 3 is idle (no flits flowing). (M chip 3)",
		.pme_code = 419,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_3@4",
		.pme_desc = "Wclk cycles MD2BW output port 3 is idle (no flits flowing). (M chip 4)",
		.pme_code = 420,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_3@5",
		.pme_desc = "Wclk cycles MD2BW output port 3 is idle (no flits flowing). (M chip 5)",
		.pme_code = 421,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_3@6",
		.pme_desc = "Wclk cycles MD2BW output port 3 is idle (no flits flowing). (M chip 6)",
		.pme_code = 422,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_3@7",
		.pme_desc = "Wclk cycles MD2BW output port 3 is idle (no flits flowing). (M chip 7)",
		.pme_code = 423,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_3@8",
		.pme_desc = "Wclk cycles MD2BW output port 3 is idle (no flits flowing). (M chip 8)",
		.pme_code = 424,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_3@9",
		.pme_desc = "Wclk cycles MD2BW output port 3 is idle (no flits flowing). (M chip 9)",
		.pme_code = 425,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_3@10",
		.pme_desc = "Wclk cycles MD2BW output port 3 is idle (no flits flowing). (M chip 10)",
		.pme_code = 426,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_3@11",
		.pme_desc = "Wclk cycles MD2BW output port 3 is idle (no flits flowing). (M chip 11)",
		.pme_code = 427,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_3@12",
		.pme_desc = "Wclk cycles MD2BW output port 3 is idle (no flits flowing). (M chip 12)",
		.pme_code = 428,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_3@13",
		.pme_desc = "Wclk cycles MD2BW output port 3 is idle (no flits flowing). (M chip 13)",
		.pme_code = 429,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_3@14",
		.pme_desc = "Wclk cycles MD2BW output port 3 is idle (no flits flowing). (M chip 14)",
		.pme_code = 430,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_IDLE_3@15",
		.pme_desc = "Wclk cycles MD2BW output port 3 is idle (no flits flowing). (M chip 15)",
		.pme_code = 431,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 3 Event 3 */
	{
		.pme_name = "W_IN_IDLE_3@0",
		.pme_desc = "Wclk cycles BW2MD input port 3 is idle (no flits in either VC0 or VC2). (M chip 0)",
		.pme_code = 432,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_3@1",
		.pme_desc = "Wclk cycles BW2MD input port 3 is idle (no flits in either VC0 or VC2). (M chip 1)",
		.pme_code = 433,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_3@2",
		.pme_desc = "Wclk cycles BW2MD input port 3 is idle (no flits in either VC0 or VC2). (M chip 2)",
		.pme_code = 434,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_3@3",
		.pme_desc = "Wclk cycles BW2MD input port 3 is idle (no flits in either VC0 or VC2). (M chip 3)",
		.pme_code = 435,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_3@4",
		.pme_desc = "Wclk cycles BW2MD input port 3 is idle (no flits in either VC0 or VC2). (M chip 4)",
		.pme_code = 436,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_3@5",
		.pme_desc = "Wclk cycles BW2MD input port 3 is idle (no flits in either VC0 or VC2). (M chip 5)",
		.pme_code = 437,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_3@6",
		.pme_desc = "Wclk cycles BW2MD input port 3 is idle (no flits in either VC0 or VC2). (M chip 6)",
		.pme_code = 438,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_3@7",
		.pme_desc = "Wclk cycles BW2MD input port 3 is idle (no flits in either VC0 or VC2). (M chip 7)",
		.pme_code = 439,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_3@8",
		.pme_desc = "Wclk cycles BW2MD input port 3 is idle (no flits in either VC0 or VC2). (M chip 8)",
		.pme_code = 440,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_3@9",
		.pme_desc = "Wclk cycles BW2MD input port 3 is idle (no flits in either VC0 or VC2). (M chip 9)",
		.pme_code = 441,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_3@10",
		.pme_desc = "Wclk cycles BW2MD input port 3 is idle (no flits in either VC0 or VC2). (M chip 10)",
		.pme_code = 442,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_3@11",
		.pme_desc = "Wclk cycles BW2MD input port 3 is idle (no flits in either VC0 or VC2). (M chip 11)",
		.pme_code = 443,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_3@12",
		.pme_desc = "Wclk cycles BW2MD input port 3 is idle (no flits in either VC0 or VC2). (M chip 12)",
		.pme_code = 444,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_3@13",
		.pme_desc = "Wclk cycles BW2MD input port 3 is idle (no flits in either VC0 or VC2). (M chip 13)",
		.pme_code = 445,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_3@14",
		.pme_desc = "Wclk cycles BW2MD input port 3 is idle (no flits in either VC0 or VC2). (M chip 14)",
		.pme_code = 446,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_IDLE_3@15",
		.pme_desc = "Wclk cycles BW2MD input port 3 is idle (no flits in either VC0 or VC2). (M chip 15)",
		.pme_code = 447,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 3,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 4 Event 0 */
	{
		.pme_name = "READ_REQ_SHARED@0",
		.pme_desc = "Read requests satisfied from the Shared state. (M chip 0)",
		.pme_code = 448,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "READ_REQ_SHARED@1",
		.pme_desc = "Read requests satisfied from the Shared state. (M chip 1)",
		.pme_code = 449,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "READ_REQ_SHARED@2",
		.pme_desc = "Read requests satisfied from the Shared state. (M chip 2)",
		.pme_code = 450,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "READ_REQ_SHARED@3",
		.pme_desc = "Read requests satisfied from the Shared state. (M chip 3)",
		.pme_code = 451,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "READ_REQ_SHARED@4",
		.pme_desc = "Read requests satisfied from the Shared state. (M chip 4)",
		.pme_code = 452,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "READ_REQ_SHARED@5",
		.pme_desc = "Read requests satisfied from the Shared state. (M chip 5)",
		.pme_code = 453,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "READ_REQ_SHARED@6",
		.pme_desc = "Read requests satisfied from the Shared state. (M chip 6)",
		.pme_code = 454,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "READ_REQ_SHARED@7",
		.pme_desc = "Read requests satisfied from the Shared state. (M chip 7)",
		.pme_code = 455,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "READ_REQ_SHARED@8",
		.pme_desc = "Read requests satisfied from the Shared state. (M chip 8)",
		.pme_code = 456,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "READ_REQ_SHARED@9",
		.pme_desc = "Read requests satisfied from the Shared state. (M chip 9)",
		.pme_code = 457,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "READ_REQ_SHARED@10",
		.pme_desc = "Read requests satisfied from the Shared state. (M chip 10)",
		.pme_code = 458,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "READ_REQ_SHARED@11",
		.pme_desc = "Read requests satisfied from the Shared state. (M chip 11)",
		.pme_code = 459,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "READ_REQ_SHARED@12",
		.pme_desc = "Read requests satisfied from the Shared state. (M chip 12)",
		.pme_code = 460,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "READ_REQ_SHARED@13",
		.pme_desc = "Read requests satisfied from the Shared state. (M chip 13)",
		.pme_code = 461,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "READ_REQ_SHARED@14",
		.pme_desc = "Read requests satisfied from the Shared state. (M chip 14)",
		.pme_code = 462,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "READ_REQ_SHARED@15",
		.pme_desc = "Read requests satisfied from the Shared state. (M chip 15)",
		.pme_code = 463,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 4 Event 1 */
	{
		.pme_name = "STALL_VN1_BLOCKED@0",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to virtual network 1 output blocked. (M chip 0)",
		.pme_code = 464,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_VN1_BLOCKED@1",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to virtual network 1 output blocked. (M chip 1)",
		.pme_code = 465,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_VN1_BLOCKED@2",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to virtual network 1 output blocked. (M chip 2)",
		.pme_code = 466,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_VN1_BLOCKED@3",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to virtual network 1 output blocked. (M chip 3)",
		.pme_code = 467,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_VN1_BLOCKED@4",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to virtual network 1 output blocked. (M chip 4)",
		.pme_code = 468,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_VN1_BLOCKED@5",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to virtual network 1 output blocked. (M chip 5)",
		.pme_code = 469,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_VN1_BLOCKED@6",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to virtual network 1 output blocked. (M chip 6)",
		.pme_code = 470,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_VN1_BLOCKED@7",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to virtual network 1 output blocked. (M chip 7)",
		.pme_code = 471,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_VN1_BLOCKED@8",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to virtual network 1 output blocked. (M chip 8)",
		.pme_code = 472,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_VN1_BLOCKED@9",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to virtual network 1 output blocked. (M chip 9)",
		.pme_code = 473,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_VN1_BLOCKED@10",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to virtual network 1 output blocked. (M chip 10)",
		.pme_code = 474,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_VN1_BLOCKED@11",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to virtual network 1 output blocked. (M chip 11)",
		.pme_code = 475,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_VN1_BLOCKED@12",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to virtual network 1 output blocked. (M chip 12)",
		.pme_code = 476,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_VN1_BLOCKED@13",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to virtual network 1 output blocked. (M chip 13)",
		.pme_code = 477,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_VN1_BLOCKED@14",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to virtual network 1 output blocked. (M chip 14)",
		.pme_code = 478,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_VN1_BLOCKED@15",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to virtual network 1 output blocked. (M chip 15)",
		.pme_code = 479,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 4 Event 2 */
	{
		.pme_name = "W_IN_FLOWING_0@0",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a flit flowing (on either VC0 or VC2). (M chip 0)",
		.pme_code = 480,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_0@1",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a flit flowing (on either VC0 or VC2). (M chip 1)",
		.pme_code = 481,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_0@2",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a flit flowing (on either VC0 or VC2). (M chip 2)",
		.pme_code = 482,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_0@3",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a flit flowing (on either VC0 or VC2). (M chip 3)",
		.pme_code = 483,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_0@4",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a flit flowing (on either VC0 or VC2). (M chip 4)",
		.pme_code = 484,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_0@5",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a flit flowing (on either VC0 or VC2). (M chip 5)",
		.pme_code = 485,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_0@6",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a flit flowing (on either VC0 or VC2). (M chip 6)",
		.pme_code = 486,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_0@7",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a flit flowing (on either VC0 or VC2). (M chip 7)",
		.pme_code = 487,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_0@8",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a flit flowing (on either VC0 or VC2). (M chip 8)",
		.pme_code = 488,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_0@9",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a flit flowing (on either VC0 or VC2). (M chip 9)",
		.pme_code = 489,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_0@10",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a flit flowing (on either VC0 or VC2). (M chip 10)",
		.pme_code = 490,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_0@11",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a flit flowing (on either VC0 or VC2). (M chip 11)",
		.pme_code = 491,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_0@12",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a flit flowing (on either VC0 or VC2). (M chip 12)",
		.pme_code = 492,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_0@13",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a flit flowing (on either VC0 or VC2). (M chip 13)",
		.pme_code = 493,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_0@14",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a flit flowing (on either VC0 or VC2). (M chip 14)",
		.pme_code = 494,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_0@15",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a flit flowing (on either VC0 or VC2). (M chip 15)",
		.pme_code = 495,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 4 Event 3 */
	{
		.pme_name = "W_OUT_FLOWING_0@0",
		.pme_desc = "Wclk cycles MD2BW output port 0 has a flit flowing. (M chip 0)",
		.pme_code = 496,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_0@1",
		.pme_desc = "Wclk cycles MD2BW output port 0 has a flit flowing. (M chip 1)",
		.pme_code = 497,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_0@2",
		.pme_desc = "Wclk cycles MD2BW output port 0 has a flit flowing. (M chip 2)",
		.pme_code = 498,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_0@3",
		.pme_desc = "Wclk cycles MD2BW output port 0 has a flit flowing. (M chip 3)",
		.pme_code = 499,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_0@4",
		.pme_desc = "Wclk cycles MD2BW output port 0 has a flit flowing. (M chip 4)",
		.pme_code = 500,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_0@5",
		.pme_desc = "Wclk cycles MD2BW output port 0 has a flit flowing. (M chip 5)",
		.pme_code = 501,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_0@6",
		.pme_desc = "Wclk cycles MD2BW output port 0 has a flit flowing. (M chip 6)",
		.pme_code = 502,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_0@7",
		.pme_desc = "Wclk cycles MD2BW output port 0 has a flit flowing. (M chip 7)",
		.pme_code = 503,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_0@8",
		.pme_desc = "Wclk cycles MD2BW output port 0 has a flit flowing. (M chip 8)",
		.pme_code = 504,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_0@9",
		.pme_desc = "Wclk cycles MD2BW output port 0 has a flit flowing. (M chip 9)",
		.pme_code = 505,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_0@10",
		.pme_desc = "Wclk cycles MD2BW output port 0 has a flit flowing. (M chip 10)",
		.pme_code = 506,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_0@11",
		.pme_desc = "Wclk cycles MD2BW output port 0 has a flit flowing. (M chip 11)",
		.pme_code = 507,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_0@12",
		.pme_desc = "Wclk cycles MD2BW output port 0 has a flit flowing. (M chip 12)",
		.pme_code = 508,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_0@13",
		.pme_desc = "Wclk cycles MD2BW output port 0 has a flit flowing. (M chip 13)",
		.pme_code = 509,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_0@14",
		.pme_desc = "Wclk cycles MD2BW output port 0 has a flit flowing. (M chip 14)",
		.pme_code = 510,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_0@15",
		.pme_desc = "Wclk cycles MD2BW output port 0 has a flit flowing. (M chip 15)",
		.pme_code = 511,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 4,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 5 Event 0 */
	{
		.pme_name = "FWD_REQ_TO_OWNER@0",
		.pme_desc = "Requests forwarded to current owner (FwdRead, FwdReadShared, FlushReq, FwdGet, Update). (M chip 0)",
		.pme_code = 512,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_REQ_TO_OWNER@1",
		.pme_desc = "Requests forwarded to current owner (FwdRead, FwdReadShared, FlushReq, FwdGet, Update). (M chip 1)",
		.pme_code = 513,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_REQ_TO_OWNER@2",
		.pme_desc = "Requests forwarded to current owner (FwdRead, FwdReadShared, FlushReq, FwdGet, Update). (M chip 2)",
		.pme_code = 514,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_REQ_TO_OWNER@3",
		.pme_desc = "Requests forwarded to current owner (FwdRead, FwdReadShared, FlushReq, FwdGet, Update). (M chip 3)",
		.pme_code = 515,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_REQ_TO_OWNER@4",
		.pme_desc = "Requests forwarded to current owner (FwdRead, FwdReadShared, FlushReq, FwdGet, Update). (M chip 4)",
		.pme_code = 516,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_REQ_TO_OWNER@5",
		.pme_desc = "Requests forwarded to current owner (FwdRead, FwdReadShared, FlushReq, FwdGet, Update). (M chip 5)",
		.pme_code = 517,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_REQ_TO_OWNER@6",
		.pme_desc = "Requests forwarded to current owner (FwdRead, FwdReadShared, FlushReq, FwdGet, Update). (M chip 6)",
		.pme_code = 518,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_REQ_TO_OWNER@7",
		.pme_desc = "Requests forwarded to current owner (FwdRead, FwdReadShared, FlushReq, FwdGet, Update). (M chip 7)",
		.pme_code = 519,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_REQ_TO_OWNER@8",
		.pme_desc = "Requests forwarded to current owner (FwdRead, FwdReadShared, FlushReq, FwdGet, Update). (M chip 8)",
		.pme_code = 520,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_REQ_TO_OWNER@9",
		.pme_desc = "Requests forwarded to current owner (FwdRead, FwdReadShared, FlushReq, FwdGet, Update). (M chip 9)",
		.pme_code = 521,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_REQ_TO_OWNER@10",
		.pme_desc = "Requests forwarded to current owner (FwdRead, FwdReadShared, FlushReq, FwdGet, Update). (M chip 10)",
		.pme_code = 522,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_REQ_TO_OWNER@11",
		.pme_desc = "Requests forwarded to current owner (FwdRead, FwdReadShared, FlushReq, FwdGet, Update). (M chip 11)",
		.pme_code = 523,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_REQ_TO_OWNER@12",
		.pme_desc = "Requests forwarded to current owner (FwdRead, FwdReadShared, FlushReq, FwdGet, Update). (M chip 12)",
		.pme_code = 524,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_REQ_TO_OWNER@13",
		.pme_desc = "Requests forwarded to current owner (FwdRead, FwdReadShared, FlushReq, FwdGet, Update). (M chip 13)",
		.pme_code = 525,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_REQ_TO_OWNER@14",
		.pme_desc = "Requests forwarded to current owner (FwdRead, FwdReadShared, FlushReq, FwdGet, Update). (M chip 14)",
		.pme_code = 526,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_REQ_TO_OWNER@15",
		.pme_desc = "Requests forwarded to current owner (FwdRead, FwdReadShared, FlushReq, FwdGet, Update). (M chip 15)",
		.pme_code = 527,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 5 Event 1 */
	{
		.pme_name = "PROT_ENGINE_IDLE_NO_PACKETS@0",
		.pme_desc = "Wclk cycles protocol engine idle due to no new packets to process. Note: The maximum packet acceptance rate into the MD is 1 packet every 2 Wclk periods. (M chip 0)",
		.pme_code = 528,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PROT_ENGINE_IDLE_NO_PACKETS@1",
		.pme_desc = "Wclk cycles protocol engine idle due to no new packets to process. Note: The maximum packet acceptance rate into the MD is 1 packet every 2 Wclk periods. (M chip 1)",
		.pme_code = 529,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PROT_ENGINE_IDLE_NO_PACKETS@2",
		.pme_desc = "Wclk cycles protocol engine idle due to no new packets to process. Note: The maximum packet acceptance rate into the MD is 1 packet every 2 Wclk periods. (M chip 2)",
		.pme_code = 530,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PROT_ENGINE_IDLE_NO_PACKETS@3",
		.pme_desc = "Wclk cycles protocol engine idle due to no new packets to process. Note: The maximum packet acceptance rate into the MD is 1 packet every 2 Wclk periods. (M chip 3)",
		.pme_code = 531,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PROT_ENGINE_IDLE_NO_PACKETS@4",
		.pme_desc = "Wclk cycles protocol engine idle due to no new packets to process. Note: The maximum packet acceptance rate into the MD is 1 packet every 2 Wclk periods. (M chip 4)",
		.pme_code = 532,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PROT_ENGINE_IDLE_NO_PACKETS@5",
		.pme_desc = "Wclk cycles protocol engine idle due to no new packets to process. Note: The maximum packet acceptance rate into the MD is 1 packet every 2 Wclk periods. (M chip 5)",
		.pme_code = 533,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PROT_ENGINE_IDLE_NO_PACKETS@6",
		.pme_desc = "Wclk cycles protocol engine idle due to no new packets to process. Note: The maximum packet acceptance rate into the MD is 1 packet every 2 Wclk periods. (M chip 6)",
		.pme_code = 534,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PROT_ENGINE_IDLE_NO_PACKETS@7",
		.pme_desc = "Wclk cycles protocol engine idle due to no new packets to process. Note: The maximum packet acceptance rate into the MD is 1 packet every 2 Wclk periods. (M chip 7)",
		.pme_code = 535,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PROT_ENGINE_IDLE_NO_PACKETS@8",
		.pme_desc = "Wclk cycles protocol engine idle due to no new packets to process. Note: The maximum packet acceptance rate into the MD is 1 packet every 2 Wclk periods. (M chip 8)",
		.pme_code = 536,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PROT_ENGINE_IDLE_NO_PACKETS@9",
		.pme_desc = "Wclk cycles protocol engine idle due to no new packets to process. Note: The maximum packet acceptance rate into the MD is 1 packet every 2 Wclk periods. (M chip 9)",
		.pme_code = 537,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PROT_ENGINE_IDLE_NO_PACKETS@10",
		.pme_desc = "Wclk cycles protocol engine idle due to no new packets to process. Note: The maximum packet acceptance rate into the MD is 1 packet every 2 Wclk periods. (M chip 10)",
		.pme_code = 538,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PROT_ENGINE_IDLE_NO_PACKETS@11",
		.pme_desc = "Wclk cycles protocol engine idle due to no new packets to process. Note: The maximum packet acceptance rate into the MD is 1 packet every 2 Wclk periods. (M chip 11)",
		.pme_code = 539,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PROT_ENGINE_IDLE_NO_PACKETS@12",
		.pme_desc = "Wclk cycles protocol engine idle due to no new packets to process. Note: The maximum packet acceptance rate into the MD is 1 packet every 2 Wclk periods. (M chip 12)",
		.pme_code = 540,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PROT_ENGINE_IDLE_NO_PACKETS@13",
		.pme_desc = "Wclk cycles protocol engine idle due to no new packets to process. Note: The maximum packet acceptance rate into the MD is 1 packet every 2 Wclk periods. (M chip 13)",
		.pme_code = 541,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PROT_ENGINE_IDLE_NO_PACKETS@14",
		.pme_desc = "Wclk cycles protocol engine idle due to no new packets to process. Note: The maximum packet acceptance rate into the MD is 1 packet every 2 Wclk periods. (M chip 14)",
		.pme_code = 542,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PROT_ENGINE_IDLE_NO_PACKETS@15",
		.pme_desc = "Wclk cycles protocol engine idle due to no new packets to process. Note: The maximum packet acceptance rate into the MD is 1 packet every 2 Wclk periods. (M chip 15)",
		.pme_code = 543,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 5 Event 2 */
	{
		.pme_name = "W_IN_FLOWING_1@0",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a flit flowing (on either VC0 or VC2). (M chip 0)",
		.pme_code = 544,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_1@1",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a flit flowing (on either VC0 or VC2). (M chip 1)",
		.pme_code = 545,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_1@2",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a flit flowing (on either VC0 or VC2). (M chip 2)",
		.pme_code = 546,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_1@3",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a flit flowing (on either VC0 or VC2). (M chip 3)",
		.pme_code = 547,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_1@4",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a flit flowing (on either VC0 or VC2). (M chip 4)",
		.pme_code = 548,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_1@5",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a flit flowing (on either VC0 or VC2). (M chip 5)",
		.pme_code = 549,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_1@6",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a flit flowing (on either VC0 or VC2). (M chip 6)",
		.pme_code = 550,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_1@7",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a flit flowing (on either VC0 or VC2). (M chip 7)",
		.pme_code = 551,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_1@8",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a flit flowing (on either VC0 or VC2). (M chip 8)",
		.pme_code = 552,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_1@9",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a flit flowing (on either VC0 or VC2). (M chip 9)",
		.pme_code = 553,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_1@10",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a flit flowing (on either VC0 or VC2). (M chip 10)",
		.pme_code = 554,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_1@11",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a flit flowing (on either VC0 or VC2). (M chip 11)",
		.pme_code = 555,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_1@12",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a flit flowing (on either VC0 or VC2). (M chip 12)",
		.pme_code = 556,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_1@13",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a flit flowing (on either VC0 or VC2). (M chip 13)",
		.pme_code = 557,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_1@14",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a flit flowing (on either VC0 or VC2). (M chip 14)",
		.pme_code = 558,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_1@15",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a flit flowing (on either VC0 or VC2). (M chip 15)",
		.pme_code = 559,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 5 Event 3 */
	{
		.pme_name = "FWD_READ@0",
		.pme_desc = "FwdRead packets sent (Exclusive -> PendFwd transition). (M chip 0)",
		.pme_code = 560,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ@1",
		.pme_desc = "FwdRead packets sent (Exclusive -> PendFwd transition). (M chip 1)",
		.pme_code = 561,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ@2",
		.pme_desc = "FwdRead packets sent (Exclusive -> PendFwd transition). (M chip 2)",
		.pme_code = 562,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ@3",
		.pme_desc = "FwdRead packets sent (Exclusive -> PendFwd transition). (M chip 3)",
		.pme_code = 563,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ@4",
		.pme_desc = "FwdRead packets sent (Exclusive -> PendFwd transition). (M chip 4)",
		.pme_code = 564,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ@5",
		.pme_desc = "FwdRead packets sent (Exclusive -> PendFwd transition). (M chip 5)",
		.pme_code = 565,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ@6",
		.pme_desc = "FwdRead packets sent (Exclusive -> PendFwd transition). (M chip 6)",
		.pme_code = 566,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ@7",
		.pme_desc = "FwdRead packets sent (Exclusive -> PendFwd transition). (M chip 7)",
		.pme_code = 567,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ@8",
		.pme_desc = "FwdRead packets sent (Exclusive -> PendFwd transition). (M chip 8)",
		.pme_code = 568,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ@9",
		.pme_desc = "FwdRead packets sent (Exclusive -> PendFwd transition). (M chip 9)",
		.pme_code = 569,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ@10",
		.pme_desc = "FwdRead packets sent (Exclusive -> PendFwd transition). (M chip 10)",
		.pme_code = 570,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ@11",
		.pme_desc = "FwdRead packets sent (Exclusive -> PendFwd transition). (M chip 11)",
		.pme_code = 571,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ@12",
		.pme_desc = "FwdRead packets sent (Exclusive -> PendFwd transition). (M chip 12)",
		.pme_code = 572,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ@13",
		.pme_desc = "FwdRead packets sent (Exclusive -> PendFwd transition). (M chip 13)",
		.pme_code = 573,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ@14",
		.pme_desc = "FwdRead packets sent (Exclusive -> PendFwd transition). (M chip 14)",
		.pme_code = 574,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_READ@15",
		.pme_desc = "FwdRead packets sent (Exclusive -> PendFwd transition). (M chip 15)",
		.pme_code = 575,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 5,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 6 Event 0 */
	{
		.pme_name = "SUPPLY_INV@0",
		.pme_desc = "SupplyInv packets received. (M chip 0)",
		.pme_code = 576,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_INV@1",
		.pme_desc = "SupplyInv packets received. (M chip 1)",
		.pme_code = 577,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_INV@2",
		.pme_desc = "SupplyInv packets received. (M chip 2)",
		.pme_code = 578,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_INV@3",
		.pme_desc = "SupplyInv packets received. (M chip 3)",
		.pme_code = 579,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_INV@4",
		.pme_desc = "SupplyInv packets received. (M chip 4)",
		.pme_code = 580,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_INV@5",
		.pme_desc = "SupplyInv packets received. (M chip 5)",
		.pme_code = 581,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_INV@6",
		.pme_desc = "SupplyInv packets received. (M chip 6)",
		.pme_code = 582,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_INV@7",
		.pme_desc = "SupplyInv packets received. (M chip 7)",
		.pme_code = 583,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_INV@8",
		.pme_desc = "SupplyInv packets received. (M chip 8)",
		.pme_code = 584,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_INV@9",
		.pme_desc = "SupplyInv packets received. (M chip 9)",
		.pme_code = 585,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_INV@10",
		.pme_desc = "SupplyInv packets received. (M chip 10)",
		.pme_code = 586,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_INV@11",
		.pme_desc = "SupplyInv packets received. (M chip 11)",
		.pme_code = 587,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_INV@12",
		.pme_desc = "SupplyInv packets received. (M chip 12)",
		.pme_code = 588,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_INV@13",
		.pme_desc = "SupplyInv packets received. (M chip 13)",
		.pme_code = 589,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_INV@14",
		.pme_desc = "SupplyInv packets received. (M chip 14)",
		.pme_code = 590,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_INV@15",
		.pme_desc = "SupplyInv packets received. (M chip 15)",
		.pme_code = 591,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 6 Event 1 */
	{
		.pme_name = "NUM_REPLAY@0",
		.pme_desc = "Requests sent through replay queue. (M chip 0)",
		.pme_code = 592,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NUM_REPLAY@1",
		.pme_desc = "Requests sent through replay queue. (M chip 1)",
		.pme_code = 593,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NUM_REPLAY@2",
		.pme_desc = "Requests sent through replay queue. (M chip 2)",
		.pme_code = 594,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NUM_REPLAY@3",
		.pme_desc = "Requests sent through replay queue. (M chip 3)",
		.pme_code = 595,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NUM_REPLAY@4",
		.pme_desc = "Requests sent through replay queue. (M chip 4)",
		.pme_code = 596,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NUM_REPLAY@5",
		.pme_desc = "Requests sent through replay queue. (M chip 5)",
		.pme_code = 597,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NUM_REPLAY@6",
		.pme_desc = "Requests sent through replay queue. (M chip 6)",
		.pme_code = 598,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NUM_REPLAY@7",
		.pme_desc = "Requests sent through replay queue. (M chip 7)",
		.pme_code = 599,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NUM_REPLAY@8",
		.pme_desc = "Requests sent through replay queue. (M chip 8)",
		.pme_code = 600,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NUM_REPLAY@9",
		.pme_desc = "Requests sent through replay queue. (M chip 9)",
		.pme_code = 601,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NUM_REPLAY@10",
		.pme_desc = "Requests sent through replay queue. (M chip 10)",
		.pme_code = 602,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NUM_REPLAY@11",
		.pme_desc = "Requests sent through replay queue. (M chip 11)",
		.pme_code = 603,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NUM_REPLAY@12",
		.pme_desc = "Requests sent through replay queue. (M chip 12)",
		.pme_code = 604,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NUM_REPLAY@13",
		.pme_desc = "Requests sent through replay queue. (M chip 13)",
		.pme_code = 605,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NUM_REPLAY@14",
		.pme_desc = "Requests sent through replay queue. (M chip 14)",
		.pme_code = 606,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NUM_REPLAY@15",
		.pme_desc = "Requests sent through replay queue. (M chip 15)",
		.pme_code = 607,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 6 Event 2 */
	{
		.pme_name = "W_IN_FLOWING_2@0",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a flit flowing (on either VC0 or VC2). (M chip 0)",
		.pme_code = 608,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_2@1",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a flit flowing (on either VC0 or VC2). (M chip 1)",
		.pme_code = 609,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_2@2",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a flit flowing (on either VC0 or VC2). (M chip 2)",
		.pme_code = 610,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_2@3",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a flit flowing (on either VC0 or VC2). (M chip 3)",
		.pme_code = 611,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_2@4",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a flit flowing (on either VC0 or VC2). (M chip 4)",
		.pme_code = 612,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_2@5",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a flit flowing (on either VC0 or VC2). (M chip 5)",
		.pme_code = 613,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_2@6",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a flit flowing (on either VC0 or VC2). (M chip 6)",
		.pme_code = 614,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_2@7",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a flit flowing (on either VC0 or VC2). (M chip 7)",
		.pme_code = 615,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_2@8",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a flit flowing (on either VC0 or VC2). (M chip 8)",
		.pme_code = 616,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_2@9",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a flit flowing (on either VC0 or VC2). (M chip 9)",
		.pme_code = 617,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_2@10",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a flit flowing (on either VC0 or VC2). (M chip 10)",
		.pme_code = 618,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_2@11",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a flit flowing (on either VC0 or VC2). (M chip 11)",
		.pme_code = 619,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_2@12",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a flit flowing (on either VC0 or VC2). (M chip 12)",
		.pme_code = 620,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_2@13",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a flit flowing (on either VC0 or VC2). (M chip 13)",
		.pme_code = 621,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_2@14",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a flit flowing (on either VC0 or VC2). (M chip 14)",
		.pme_code = 622,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_2@15",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a flit flowing (on either VC0 or VC2). (M chip 15)",
		.pme_code = 623,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 6 Event 3 */
	{
		.pme_name = "INVAL_1@0",
		.pme_desc = "Invalidations sent to a single BW. (M chip 0)",
		.pme_code = 624,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_1@1",
		.pme_desc = "Invalidations sent to a single BW. (M chip 1)",
		.pme_code = 625,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_1@2",
		.pme_desc = "Invalidations sent to a single BW. (M chip 2)",
		.pme_code = 626,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_1@3",
		.pme_desc = "Invalidations sent to a single BW. (M chip 3)",
		.pme_code = 627,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_1@4",
		.pme_desc = "Invalidations sent to a single BW. (M chip 4)",
		.pme_code = 628,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_1@5",
		.pme_desc = "Invalidations sent to a single BW. (M chip 5)",
		.pme_code = 629,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_1@6",
		.pme_desc = "Invalidations sent to a single BW. (M chip 6)",
		.pme_code = 630,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_1@7",
		.pme_desc = "Invalidations sent to a single BW. (M chip 7)",
		.pme_code = 631,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_1@8",
		.pme_desc = "Invalidations sent to a single BW. (M chip 8)",
		.pme_code = 632,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_1@9",
		.pme_desc = "Invalidations sent to a single BW. (M chip 9)",
		.pme_code = 633,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_1@10",
		.pme_desc = "Invalidations sent to a single BW. (M chip 10)",
		.pme_code = 634,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_1@11",
		.pme_desc = "Invalidations sent to a single BW. (M chip 11)",
		.pme_code = 635,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_1@12",
		.pme_desc = "Invalidations sent to a single BW. (M chip 12)",
		.pme_code = 636,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_1@13",
		.pme_desc = "Invalidations sent to a single BW. (M chip 13)",
		.pme_code = 637,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_1@14",
		.pme_desc = "Invalidations sent to a single BW. (M chip 14)",
		.pme_code = 638,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_1@15",
		.pme_desc = "Invalidations sent to a single BW. (M chip 15)",
		.pme_code = 639,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 6,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 7 Event 0 */
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_HIT@0",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 hit. (M chip 0)",
		.pme_code = 640,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_HIT@1",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 hit. (M chip 1)",
		.pme_code = 641,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_HIT@2",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 hit. (M chip 2)",
		.pme_code = 642,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_HIT@3",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 hit. (M chip 3)",
		.pme_code = 643,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_HIT@4",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 hit. (M chip 4)",
		.pme_code = 644,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_HIT@5",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 hit. (M chip 5)",
		.pme_code = 645,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_HIT@6",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 hit. (M chip 6)",
		.pme_code = 646,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_HIT@7",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 hit. (M chip 7)",
		.pme_code = 647,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_HIT@8",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 hit. (M chip 8)",
		.pme_code = 648,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_HIT@9",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 hit. (M chip 9)",
		.pme_code = 649,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_HIT@10",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 hit. (M chip 10)",
		.pme_code = 650,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_HIT@11",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 hit. (M chip 11)",
		.pme_code = 651,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_HIT@12",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 hit. (M chip 12)",
		.pme_code = 652,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_HIT@13",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 hit. (M chip 13)",
		.pme_code = 653,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_HIT@14",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 hit. (M chip 14)",
		.pme_code = 654,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_HIT@15",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 hit. (M chip 15)",
		.pme_code = 655,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 7 Event 1 */
	{
		.pme_name = "<M:7:1>@0",
		.pme_desc = "<NA>",
		.pme_code = 656,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:7:1>@1",
		.pme_desc = "<NA>",
		.pme_code = 657,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:7:1>@2",
		.pme_desc = "<NA>",
		.pme_code = 658,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:7:1>@3",
		.pme_desc = "<NA>",
		.pme_code = 659,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:7:1>@4",
		.pme_desc = "<NA>",
		.pme_code = 660,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:7:1>@5",
		.pme_desc = "<NA>",
		.pme_code = 661,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:7:1>@6",
		.pme_desc = "<NA>",
		.pme_code = 662,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:7:1>@7",
		.pme_desc = "<NA>",
		.pme_code = 663,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:7:1>@8",
		.pme_desc = "<NA>",
		.pme_code = 664,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:7:1>@9",
		.pme_desc = "<NA>",
		.pme_code = 665,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:7:1>@10",
		.pme_desc = "<NA>",
		.pme_code = 666,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:7:1>@11",
		.pme_desc = "<NA>",
		.pme_code = 667,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:7:1>@12",
		.pme_desc = "<NA>",
		.pme_code = 668,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:7:1>@13",
		.pme_desc = "<NA>",
		.pme_code = 669,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:7:1>@14",
		.pme_desc = "<NA>",
		.pme_code = 670,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:7:1>@15",
		.pme_desc = "<NA>",
		.pme_code = 671,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 7 Event 2 */
	{
		.pme_name = "W_IN_FLOWING_3@0",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a flit flowing (on either VC0 or VC2). (M chip 0)",
		.pme_code = 672,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_3@1",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a flit flowing (on either VC0 or VC2). (M chip 1)",
		.pme_code = 673,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_3@2",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a flit flowing (on either VC0 or VC2). (M chip 2)",
		.pme_code = 674,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_3@3",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a flit flowing (on either VC0 or VC2). (M chip 3)",
		.pme_code = 675,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_3@4",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a flit flowing (on either VC0 or VC2). (M chip 4)",
		.pme_code = 676,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_3@5",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a flit flowing (on either VC0 or VC2). (M chip 5)",
		.pme_code = 677,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_3@6",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a flit flowing (on either VC0 or VC2). (M chip 6)",
		.pme_code = 678,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_3@7",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a flit flowing (on either VC0 or VC2). (M chip 7)",
		.pme_code = 679,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_3@8",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a flit flowing (on either VC0 or VC2). (M chip 8)",
		.pme_code = 680,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_3@9",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a flit flowing (on either VC0 or VC2). (M chip 9)",
		.pme_code = 681,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_3@10",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a flit flowing (on either VC0 or VC2). (M chip 10)",
		.pme_code = 682,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_3@11",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a flit flowing (on either VC0 or VC2). (M chip 11)",
		.pme_code = 683,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_3@12",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a flit flowing (on either VC0 or VC2). (M chip 12)",
		.pme_code = 684,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_3@13",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a flit flowing (on either VC0 or VC2). (M chip 13)",
		.pme_code = 685,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_3@14",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a flit flowing (on either VC0 or VC2). (M chip 14)",
		.pme_code = 686,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_FLOWING_3@15",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a flit flowing (on either VC0 or VC2). (M chip 15)",
		.pme_code = 687,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 7 Event 3 */
	{
		.pme_name = "INVAL_2@0",
		.pme_desc = "Invalidations sent to two BWs. (M chip 0)",
		.pme_code = 688,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_2@1",
		.pme_desc = "Invalidations sent to two BWs. (M chip 1)",
		.pme_code = 689,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_2@2",
		.pme_desc = "Invalidations sent to two BWs. (M chip 2)",
		.pme_code = 690,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_2@3",
		.pme_desc = "Invalidations sent to two BWs. (M chip 3)",
		.pme_code = 691,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_2@4",
		.pme_desc = "Invalidations sent to two BWs. (M chip 4)",
		.pme_code = 692,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_2@5",
		.pme_desc = "Invalidations sent to two BWs. (M chip 5)",
		.pme_code = 693,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_2@6",
		.pme_desc = "Invalidations sent to two BWs. (M chip 6)",
		.pme_code = 694,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_2@7",
		.pme_desc = "Invalidations sent to two BWs. (M chip 7)",
		.pme_code = 695,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_2@8",
		.pme_desc = "Invalidations sent to two BWs. (M chip 8)",
		.pme_code = 696,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_2@9",
		.pme_desc = "Invalidations sent to two BWs. (M chip 9)",
		.pme_code = 697,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_2@10",
		.pme_desc = "Invalidations sent to two BWs. (M chip 10)",
		.pme_code = 698,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_2@11",
		.pme_desc = "Invalidations sent to two BWs. (M chip 11)",
		.pme_code = 699,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_2@12",
		.pme_desc = "Invalidations sent to two BWs. (M chip 12)",
		.pme_code = 700,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_2@13",
		.pme_desc = "Invalidations sent to two BWs. (M chip 13)",
		.pme_code = 701,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_2@14",
		.pme_desc = "Invalidations sent to two BWs. (M chip 14)",
		.pme_code = 702,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_2@15",
		.pme_desc = "Invalidations sent to two BWs. (M chip 15)",
		.pme_code = 703,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 7,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 8 Event 0 */
	{
		.pme_name = "SUPPLY_SH@0",
		.pme_desc = "SupplySh packets received. (M chip 0)",
		.pme_code = 704,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_SH@1",
		.pme_desc = "SupplySh packets received. (M chip 1)",
		.pme_code = 705,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_SH@2",
		.pme_desc = "SupplySh packets received. (M chip 2)",
		.pme_code = 706,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_SH@3",
		.pme_desc = "SupplySh packets received. (M chip 3)",
		.pme_code = 707,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_SH@4",
		.pme_desc = "SupplySh packets received. (M chip 4)",
		.pme_code = 708,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_SH@5",
		.pme_desc = "SupplySh packets received. (M chip 5)",
		.pme_code = 709,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_SH@6",
		.pme_desc = "SupplySh packets received. (M chip 6)",
		.pme_code = 710,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_SH@7",
		.pme_desc = "SupplySh packets received. (M chip 7)",
		.pme_code = 711,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_SH@8",
		.pme_desc = "SupplySh packets received. (M chip 8)",
		.pme_code = 712,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_SH@9",
		.pme_desc = "SupplySh packets received. (M chip 9)",
		.pme_code = 713,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_SH@10",
		.pme_desc = "SupplySh packets received. (M chip 10)",
		.pme_code = 714,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_SH@11",
		.pme_desc = "SupplySh packets received. (M chip 11)",
		.pme_code = 715,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_SH@12",
		.pme_desc = "SupplySh packets received. (M chip 12)",
		.pme_code = 716,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_SH@13",
		.pme_desc = "SupplySh packets received. (M chip 13)",
		.pme_code = 717,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_SH@14",
		.pme_desc = "SupplySh packets received. (M chip 14)",
		.pme_code = 718,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_SH@15",
		.pme_desc = "SupplySh packets received. (M chip 15)",
		.pme_code = 719,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 8 Event 1 */
	{
		.pme_name = "STALL_MM@0",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to back-pressure from memory manager. (M chip 0)",
		.pme_code = 720,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM@1",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to back-pressure from memory manager. (M chip 1)",
		.pme_code = 721,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM@2",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to back-pressure from memory manager. (M chip 2)",
		.pme_code = 722,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM@3",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to back-pressure from memory manager. (M chip 3)",
		.pme_code = 723,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM@4",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to back-pressure from memory manager. (M chip 4)",
		.pme_code = 724,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM@5",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to back-pressure from memory manager. (M chip 5)",
		.pme_code = 725,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM@6",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to back-pressure from memory manager. (M chip 6)",
		.pme_code = 726,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM@7",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to back-pressure from memory manager. (M chip 7)",
		.pme_code = 727,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM@8",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to back-pressure from memory manager. (M chip 8)",
		.pme_code = 728,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM@9",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to back-pressure from memory manager. (M chip 9)",
		.pme_code = 729,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM@10",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to back-pressure from memory manager. (M chip 10)",
		.pme_code = 730,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM@11",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to back-pressure from memory manager. (M chip 11)",
		.pme_code = 731,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM@12",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to back-pressure from memory manager. (M chip 12)",
		.pme_code = 732,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM@13",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to back-pressure from memory manager. (M chip 13)",
		.pme_code = 733,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM@14",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to back-pressure from memory manager. (M chip 14)",
		.pme_code = 734,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "STALL_MM@15",
		.pme_desc = "Wclk cycles protocol engine request queue stalled due to back-pressure from memory manager. (M chip 15)",
		.pme_code = 735,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 8 Event 2 */
	{
		.pme_name = "W_IN_WAITING_0@0",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 0)",
		.pme_code = 736,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_0@1",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 1)",
		.pme_code = 737,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_0@2",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 2)",
		.pme_code = 738,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_0@3",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 3)",
		.pme_code = 739,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_0@4",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 4)",
		.pme_code = 740,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_0@5",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 5)",
		.pme_code = 741,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_0@6",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 6)",
		.pme_code = 742,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_0@7",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 7)",
		.pme_code = 743,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_0@8",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 8)",
		.pme_code = 744,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_0@9",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 9)",
		.pme_code = 745,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_0@10",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 10)",
		.pme_code = 746,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_0@11",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 11)",
		.pme_code = 747,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_0@12",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 12)",
		.pme_code = 748,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_0@13",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 13)",
		.pme_code = 749,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_0@14",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 14)",
		.pme_code = 750,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_0@15",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 15)",
		.pme_code = 751,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 8 Event 3 */
	{
		.pme_name = "W_OUT_FLOWING_1@0",
		.pme_desc = "Wclk cycles MD2BW output port 1 has a flit flowing. (M chip 0)",
		.pme_code = 752,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_1@1",
		.pme_desc = "Wclk cycles MD2BW output port 1 has a flit flowing. (M chip 1)",
		.pme_code = 753,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_1@2",
		.pme_desc = "Wclk cycles MD2BW output port 1 has a flit flowing. (M chip 2)",
		.pme_code = 754,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_1@3",
		.pme_desc = "Wclk cycles MD2BW output port 1 has a flit flowing. (M chip 3)",
		.pme_code = 755,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_1@4",
		.pme_desc = "Wclk cycles MD2BW output port 1 has a flit flowing. (M chip 4)",
		.pme_code = 756,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_1@5",
		.pme_desc = "Wclk cycles MD2BW output port 1 has a flit flowing. (M chip 5)",
		.pme_code = 757,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_1@6",
		.pme_desc = "Wclk cycles MD2BW output port 1 has a flit flowing. (M chip 6)",
		.pme_code = 758,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_1@7",
		.pme_desc = "Wclk cycles MD2BW output port 1 has a flit flowing. (M chip 7)",
		.pme_code = 759,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_1@8",
		.pme_desc = "Wclk cycles MD2BW output port 1 has a flit flowing. (M chip 8)",
		.pme_code = 760,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_1@9",
		.pme_desc = "Wclk cycles MD2BW output port 1 has a flit flowing. (M chip 9)",
		.pme_code = 761,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_1@10",
		.pme_desc = "Wclk cycles MD2BW output port 1 has a flit flowing. (M chip 10)",
		.pme_code = 762,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_1@11",
		.pme_desc = "Wclk cycles MD2BW output port 1 has a flit flowing. (M chip 11)",
		.pme_code = 763,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_1@12",
		.pme_desc = "Wclk cycles MD2BW output port 1 has a flit flowing. (M chip 12)",
		.pme_code = 764,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_1@13",
		.pme_desc = "Wclk cycles MD2BW output port 1 has a flit flowing. (M chip 13)",
		.pme_code = 765,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_1@14",
		.pme_desc = "Wclk cycles MD2BW output port 1 has a flit flowing. (M chip 14)",
		.pme_code = 766,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_1@15",
		.pme_desc = "Wclk cycles MD2BW output port 1 has a flit flowing. (M chip 15)",
		.pme_code = 767,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 8,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 9 Event 0 */
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_MISS@0",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 miss. (M chip 0)",
		.pme_code = 768,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_MISS@1",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 miss. (M chip 1)",
		.pme_code = 769,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_MISS@2",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 miss. (M chip 2)",
		.pme_code = 770,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_MISS@3",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 miss. (M chip 3)",
		.pme_code = 771,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_MISS@4",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 miss. (M chip 4)",
		.pme_code = 772,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_MISS@5",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 miss. (M chip 5)",
		.pme_code = 773,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_MISS@6",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 miss. (M chip 6)",
		.pme_code = 774,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_MISS@7",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 miss. (M chip 7)",
		.pme_code = 775,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_MISS@8",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 miss. (M chip 8)",
		.pme_code = 776,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_MISS@9",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 miss. (M chip 9)",
		.pme_code = 777,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_MISS@10",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 miss. (M chip 10)",
		.pme_code = 778,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_MISS@11",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 miss. (M chip 11)",
		.pme_code = 779,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_MISS@12",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 miss. (M chip 12)",
		.pme_code = 780,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_MISS@13",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 miss. (M chip 13)",
		.pme_code = 781,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_MISS@14",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 miss. (M chip 14)",
		.pme_code = 782,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_GETS_4DWORDS_L3_MISS@15",
		.pme_desc = "NGet or Get Full cache line requests to MDs - L3 miss. (M chip 15)",
		.pme_code = 783,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 9 Event 1 */
	{
		.pme_name = "SECTION_BUSY@0",
		.pme_desc = "Wclk cycles MD pipeline busy. (M chip 0)",
		.pme_code = 784,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SECTION_BUSY@1",
		.pme_desc = "Wclk cycles MD pipeline busy. (M chip 1)",
		.pme_code = 785,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SECTION_BUSY@2",
		.pme_desc = "Wclk cycles MD pipeline busy. (M chip 2)",
		.pme_code = 786,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SECTION_BUSY@3",
		.pme_desc = "Wclk cycles MD pipeline busy. (M chip 3)",
		.pme_code = 787,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SECTION_BUSY@4",
		.pme_desc = "Wclk cycles MD pipeline busy. (M chip 4)",
		.pme_code = 788,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SECTION_BUSY@5",
		.pme_desc = "Wclk cycles MD pipeline busy. (M chip 5)",
		.pme_code = 789,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SECTION_BUSY@6",
		.pme_desc = "Wclk cycles MD pipeline busy. (M chip 6)",
		.pme_code = 790,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SECTION_BUSY@7",
		.pme_desc = "Wclk cycles MD pipeline busy. (M chip 7)",
		.pme_code = 791,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SECTION_BUSY@8",
		.pme_desc = "Wclk cycles MD pipeline busy. (M chip 8)",
		.pme_code = 792,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SECTION_BUSY@9",
		.pme_desc = "Wclk cycles MD pipeline busy. (M chip 9)",
		.pme_code = 793,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SECTION_BUSY@10",
		.pme_desc = "Wclk cycles MD pipeline busy. (M chip 10)",
		.pme_code = 794,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SECTION_BUSY@11",
		.pme_desc = "Wclk cycles MD pipeline busy. (M chip 11)",
		.pme_code = 795,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SECTION_BUSY@12",
		.pme_desc = "Wclk cycles MD pipeline busy. (M chip 12)",
		.pme_code = 796,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SECTION_BUSY@13",
		.pme_desc = "Wclk cycles MD pipeline busy. (M chip 13)",
		.pme_code = 797,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SECTION_BUSY@14",
		.pme_desc = "Wclk cycles MD pipeline busy. (M chip 14)",
		.pme_code = 798,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SECTION_BUSY@15",
		.pme_desc = "Wclk cycles MD pipeline busy. (M chip 15)",
		.pme_code = 799,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 9 Event 2 */
	{
		.pme_name = "W_IN_WAITING_1@0",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 0)",
		.pme_code = 800,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_1@1",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 1)",
		.pme_code = 801,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_1@2",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 2)",
		.pme_code = 802,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_1@3",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 3)",
		.pme_code = 803,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_1@4",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 4)",
		.pme_code = 804,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_1@5",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 5)",
		.pme_code = 805,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_1@6",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 6)",
		.pme_code = 806,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_1@7",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 7)",
		.pme_code = 807,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_1@8",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 8)",
		.pme_code = 808,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_1@9",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 9)",
		.pme_code = 809,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_1@10",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 10)",
		.pme_code = 810,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_1@11",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 11)",
		.pme_code = 811,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_1@12",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 12)",
		.pme_code = 812,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_1@13",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 13)",
		.pme_code = 813,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_1@14",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 14)",
		.pme_code = 814,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_1@15",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 15)",
		.pme_code = 815,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 9 Event 3 */
	{
		.pme_name = "W_OUT_FLOWING_2@0",
		.pme_desc = "Wclk cycles MD2BW output port 2 has a flit flowing. (M chip 0)",
		.pme_code = 816,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_2@1",
		.pme_desc = "Wclk cycles MD2BW output port 2 has a flit flowing. (M chip 1)",
		.pme_code = 817,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_2@2",
		.pme_desc = "Wclk cycles MD2BW output port 2 has a flit flowing. (M chip 2)",
		.pme_code = 818,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_2@3",
		.pme_desc = "Wclk cycles MD2BW output port 2 has a flit flowing. (M chip 3)",
		.pme_code = 819,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_2@4",
		.pme_desc = "Wclk cycles MD2BW output port 2 has a flit flowing. (M chip 4)",
		.pme_code = 820,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_2@5",
		.pme_desc = "Wclk cycles MD2BW output port 2 has a flit flowing. (M chip 5)",
		.pme_code = 821,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_2@6",
		.pme_desc = "Wclk cycles MD2BW output port 2 has a flit flowing. (M chip 6)",
		.pme_code = 822,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_2@7",
		.pme_desc = "Wclk cycles MD2BW output port 2 has a flit flowing. (M chip 7)",
		.pme_code = 823,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_2@8",
		.pme_desc = "Wclk cycles MD2BW output port 2 has a flit flowing. (M chip 8)",
		.pme_code = 824,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_2@9",
		.pme_desc = "Wclk cycles MD2BW output port 2 has a flit flowing. (M chip 9)",
		.pme_code = 825,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_2@10",
		.pme_desc = "Wclk cycles MD2BW output port 2 has a flit flowing. (M chip 10)",
		.pme_code = 826,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_2@11",
		.pme_desc = "Wclk cycles MD2BW output port 2 has a flit flowing. (M chip 11)",
		.pme_code = 827,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_2@12",
		.pme_desc = "Wclk cycles MD2BW output port 2 has a flit flowing. (M chip 12)",
		.pme_code = 828,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_2@13",
		.pme_desc = "Wclk cycles MD2BW output port 2 has a flit flowing. (M chip 13)",
		.pme_code = 829,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_2@14",
		.pme_desc = "Wclk cycles MD2BW output port 2 has a flit flowing. (M chip 14)",
		.pme_code = 830,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_2@15",
		.pme_desc = "Wclk cycles MD2BW output port 2 has a flit flowing. (M chip 15)",
		.pme_code = 831,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 9,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 10 Event 0 */
	{
		.pme_name = "SUPPLY_EXCL@0",
		.pme_desc = "SupplyExcl packets received. (M chip 0)",
		.pme_code = 832,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_EXCL@1",
		.pme_desc = "SupplyExcl packets received. (M chip 1)",
		.pme_code = 833,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_EXCL@2",
		.pme_desc = "SupplyExcl packets received. (M chip 2)",
		.pme_code = 834,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_EXCL@3",
		.pme_desc = "SupplyExcl packets received. (M chip 3)",
		.pme_code = 835,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_EXCL@4",
		.pme_desc = "SupplyExcl packets received. (M chip 4)",
		.pme_code = 836,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_EXCL@5",
		.pme_desc = "SupplyExcl packets received. (M chip 5)",
		.pme_code = 837,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_EXCL@6",
		.pme_desc = "SupplyExcl packets received. (M chip 6)",
		.pme_code = 838,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_EXCL@7",
		.pme_desc = "SupplyExcl packets received. (M chip 7)",
		.pme_code = 839,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_EXCL@8",
		.pme_desc = "SupplyExcl packets received. (M chip 8)",
		.pme_code = 840,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_EXCL@9",
		.pme_desc = "SupplyExcl packets received. (M chip 9)",
		.pme_code = 841,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_EXCL@10",
		.pme_desc = "SupplyExcl packets received. (M chip 10)",
		.pme_code = 842,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_EXCL@11",
		.pme_desc = "SupplyExcl packets received. (M chip 11)",
		.pme_code = 843,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_EXCL@12",
		.pme_desc = "SupplyExcl packets received. (M chip 12)",
		.pme_code = 844,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_EXCL@13",
		.pme_desc = "SupplyExcl packets received. (M chip 13)",
		.pme_code = 845,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_EXCL@14",
		.pme_desc = "SupplyExcl packets received. (M chip 14)",
		.pme_code = 846,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "SUPPLY_EXCL@15",
		.pme_desc = "SupplyExcl packets received. (M chip 15)",
		.pme_code = 847,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 10 Event 1 */
	{
		.pme_name = "W_OUT_FLOWING_3@0",
		.pme_desc = "Wclk cycles MD2BW output port 3 has a flit flowing. (M chip 0)",
		.pme_code = 848,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_3@1",
		.pme_desc = "Wclk cycles MD2BW output port 3 has a flit flowing. (M chip 1)",
		.pme_code = 849,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_3@2",
		.pme_desc = "Wclk cycles MD2BW output port 3 has a flit flowing. (M chip 2)",
		.pme_code = 850,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_3@3",
		.pme_desc = "Wclk cycles MD2BW output port 3 has a flit flowing. (M chip 3)",
		.pme_code = 851,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_3@4",
		.pme_desc = "Wclk cycles MD2BW output port 3 has a flit flowing. (M chip 4)",
		.pme_code = 852,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_3@5",
		.pme_desc = "Wclk cycles MD2BW output port 3 has a flit flowing. (M chip 5)",
		.pme_code = 853,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_3@6",
		.pme_desc = "Wclk cycles MD2BW output port 3 has a flit flowing. (M chip 6)",
		.pme_code = 854,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_3@7",
		.pme_desc = "Wclk cycles MD2BW output port 3 has a flit flowing. (M chip 7)",
		.pme_code = 855,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_3@8",
		.pme_desc = "Wclk cycles MD2BW output port 3 has a flit flowing. (M chip 8)",
		.pme_code = 856,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_3@9",
		.pme_desc = "Wclk cycles MD2BW output port 3 has a flit flowing. (M chip 9)",
		.pme_code = 857,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_3@10",
		.pme_desc = "Wclk cycles MD2BW output port 3 has a flit flowing. (M chip 10)",
		.pme_code = 858,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_3@11",
		.pme_desc = "Wclk cycles MD2BW output port 3 has a flit flowing. (M chip 11)",
		.pme_code = 859,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_3@12",
		.pme_desc = "Wclk cycles MD2BW output port 3 has a flit flowing. (M chip 12)",
		.pme_code = 860,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_3@13",
		.pme_desc = "Wclk cycles MD2BW output port 3 has a flit flowing. (M chip 13)",
		.pme_code = 861,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_3@14",
		.pme_desc = "Wclk cycles MD2BW output port 3 has a flit flowing. (M chip 14)",
		.pme_code = 862,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_FLOWING_3@15",
		.pme_desc = "Wclk cycles MD2BW output port 3 has a flit flowing. (M chip 15)",
		.pme_code = 863,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 10 Event 2 */
	{
		.pme_name = "W_IN_WAITING_2@0",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 0)",
		.pme_code = 864,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_2@1",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 1)",
		.pme_code = 865,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_2@2",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 2)",
		.pme_code = 866,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_2@3",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 3)",
		.pme_code = 867,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_2@4",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 4)",
		.pme_code = 868,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_2@5",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 5)",
		.pme_code = 869,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_2@6",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 6)",
		.pme_code = 870,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_2@7",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 7)",
		.pme_code = 871,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_2@8",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 8)",
		.pme_code = 872,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_2@9",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 9)",
		.pme_code = 873,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_2@10",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 10)",
		.pme_code = 874,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_2@11",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 11)",
		.pme_code = 875,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_2@12",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 12)",
		.pme_code = 876,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_2@13",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 13)",
		.pme_code = 877,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_2@14",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 14)",
		.pme_code = 878,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_2@15",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 15)",
		.pme_code = 879,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 10 Event 3 */
	{
		.pme_name = "INVAL_3@0",
		.pme_desc = "Invalidations sent to three BWs. (M chip 0)",
		.pme_code = 880,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_3@1",
		.pme_desc = "Invalidations sent to three BWs. (M chip 1)",
		.pme_code = 881,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_3@2",
		.pme_desc = "Invalidations sent to three BWs. (M chip 2)",
		.pme_code = 882,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_3@3",
		.pme_desc = "Invalidations sent to three BWs. (M chip 3)",
		.pme_code = 883,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_3@4",
		.pme_desc = "Invalidations sent to three BWs. (M chip 4)",
		.pme_code = 884,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_3@5",
		.pme_desc = "Invalidations sent to three BWs. (M chip 5)",
		.pme_code = 885,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_3@6",
		.pme_desc = "Invalidations sent to three BWs. (M chip 6)",
		.pme_code = 886,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_3@7",
		.pme_desc = "Invalidations sent to three BWs. (M chip 7)",
		.pme_code = 887,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_3@8",
		.pme_desc = "Invalidations sent to three BWs. (M chip 8)",
		.pme_code = 888,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_3@9",
		.pme_desc = "Invalidations sent to three BWs. (M chip 9)",
		.pme_code = 889,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_3@10",
		.pme_desc = "Invalidations sent to three BWs. (M chip 10)",
		.pme_code = 890,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_3@11",
		.pme_desc = "Invalidations sent to three BWs. (M chip 11)",
		.pme_code = 891,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_3@12",
		.pme_desc = "Invalidations sent to three BWs. (M chip 12)",
		.pme_code = 892,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_3@13",
		.pme_desc = "Invalidations sent to three BWs. (M chip 13)",
		.pme_code = 893,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_3@14",
		.pme_desc = "Invalidations sent to three BWs. (M chip 14)",
		.pme_code = 894,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_3@15",
		.pme_desc = "Invalidations sent to three BWs. (M chip 15)",
		.pme_code = 895,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 10,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 11 Event 0 */
	{
		.pme_name = "NACKS_RECV@0",
		.pme_desc = "FlushAck and Update Nack packets received (race between forwarded request and eviction by owner). (M chip 0)",
		.pme_code = 896,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NACKS_RECV@1",
		.pme_desc = "FlushAck and Update Nack packets received (race between forwarded request and eviction by owner). (M chip 1)",
		.pme_code = 897,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NACKS_RECV@2",
		.pme_desc = "FlushAck and Update Nack packets received (race between forwarded request and eviction by owner). (M chip 2)",
		.pme_code = 898,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NACKS_RECV@3",
		.pme_desc = "FlushAck and Update Nack packets received (race between forwarded request and eviction by owner). (M chip 3)",
		.pme_code = 899,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NACKS_RECV@4",
		.pme_desc = "FlushAck and Update Nack packets received (race between forwarded request and eviction by owner). (M chip 4)",
		.pme_code = 900,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NACKS_RECV@5",
		.pme_desc = "FlushAck and Update Nack packets received (race between forwarded request and eviction by owner). (M chip 5)",
		.pme_code = 901,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NACKS_RECV@6",
		.pme_desc = "FlushAck and Update Nack packets received (race between forwarded request and eviction by owner). (M chip 6)",
		.pme_code = 902,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NACKS_RECV@7",
		.pme_desc = "FlushAck and Update Nack packets received (race between forwarded request and eviction by owner). (M chip 7)",
		.pme_code = 903,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NACKS_RECV@8",
		.pme_desc = "FlushAck and Update Nack packets received (race between forwarded request and eviction by owner). (M chip 8)",
		.pme_code = 904,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NACKS_RECV@9",
		.pme_desc = "FlushAck and Update Nack packets received (race between forwarded request and eviction by owner). (M chip 9)",
		.pme_code = 905,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NACKS_RECV@10",
		.pme_desc = "FlushAck and Update Nack packets received (race between forwarded request and eviction by owner). (M chip 10)",
		.pme_code = 906,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NACKS_RECV@11",
		.pme_desc = "FlushAck and Update Nack packets received (race between forwarded request and eviction by owner). (M chip 11)",
		.pme_code = 907,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NACKS_RECV@12",
		.pme_desc = "FlushAck and Update Nack packets received (race between forwarded request and eviction by owner). (M chip 12)",
		.pme_code = 908,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NACKS_RECV@13",
		.pme_desc = "FlushAck and Update Nack packets received (race between forwarded request and eviction by owner). (M chip 13)",
		.pme_code = 909,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NACKS_RECV@14",
		.pme_desc = "FlushAck and Update Nack packets received (race between forwarded request and eviction by owner). (M chip 14)",
		.pme_code = 910,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "NACKS_RECV@15",
		.pme_desc = "FlushAck and Update Nack packets received (race between forwarded request and eviction by owner). (M chip 15)",
		.pme_code = 911,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 11 Event 1 */
	{
		.pme_name = "W_OUT_BLOCK_CRED_0@0",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to lack of credits. (M chip 0)",
		.pme_code = 912,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_0@1",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to lack of credits. (M chip 1)",
		.pme_code = 913,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_0@2",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to lack of credits. (M chip 2)",
		.pme_code = 914,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_0@3",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to lack of credits. (M chip 3)",
		.pme_code = 915,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_0@4",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to lack of credits. (M chip 4)",
		.pme_code = 916,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_0@5",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to lack of credits. (M chip 5)",
		.pme_code = 917,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_0@6",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to lack of credits. (M chip 6)",
		.pme_code = 918,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_0@7",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to lack of credits. (M chip 7)",
		.pme_code = 919,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_0@8",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to lack of credits. (M chip 8)",
		.pme_code = 920,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_0@9",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to lack of credits. (M chip 9)",
		.pme_code = 921,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_0@10",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to lack of credits. (M chip 10)",
		.pme_code = 922,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_0@11",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to lack of credits. (M chip 11)",
		.pme_code = 923,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_0@12",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to lack of credits. (M chip 12)",
		.pme_code = 924,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_0@13",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to lack of credits. (M chip 13)",
		.pme_code = 925,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_0@14",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to lack of credits. (M chip 14)",
		.pme_code = 926,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_0@15",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to lack of credits. (M chip 15)",
		.pme_code = 927,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 11 Event 2 */
	{
		.pme_name = "W_IN_WAITING_3@0",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 0)",
		.pme_code = 928,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_3@1",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 1)",
		.pme_code = 929,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_3@2",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 2)",
		.pme_code = 930,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_3@3",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 3)",
		.pme_code = 931,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_3@4",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 4)",
		.pme_code = 932,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_3@5",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 5)",
		.pme_code = 933,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_3@6",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 6)",
		.pme_code = 934,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_3@7",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 7)",
		.pme_code = 935,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_3@8",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 8)",
		.pme_code = 936,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_3@9",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 9)",
		.pme_code = 937,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_3@10",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 10)",
		.pme_code = 938,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_3@11",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 11)",
		.pme_code = 939,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_3@12",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 12)",
		.pme_code = 940,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_3@13",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 13)",
		.pme_code = 941,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_3@14",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 14)",
		.pme_code = 942,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_WAITING_3@15",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that failed to win arbitration (on either VC0 or VC2). (M chip 15)",
		.pme_code = 943,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 11 Event 3 */
	{
		.pme_name = "INVAL_4@0",
		.pme_desc = "Invalidations sent to four BWs. (M chip 0)",
		.pme_code = 944,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_4@1",
		.pme_desc = "Invalidations sent to four BWs. (M chip 1)",
		.pme_code = 945,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_4@2",
		.pme_desc = "Invalidations sent to four BWs. (M chip 2)",
		.pme_code = 946,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_4@3",
		.pme_desc = "Invalidations sent to four BWs. (M chip 3)",
		.pme_code = 947,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_4@4",
		.pme_desc = "Invalidations sent to four BWs. (M chip 4)",
		.pme_code = 948,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_4@5",
		.pme_desc = "Invalidations sent to four BWs. (M chip 5)",
		.pme_code = 949,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_4@6",
		.pme_desc = "Invalidations sent to four BWs. (M chip 6)",
		.pme_code = 950,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_4@7",
		.pme_desc = "Invalidations sent to four BWs. (M chip 7)",
		.pme_code = 951,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_4@8",
		.pme_desc = "Invalidations sent to four BWs. (M chip 8)",
		.pme_code = 952,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_4@9",
		.pme_desc = "Invalidations sent to four BWs. (M chip 9)",
		.pme_code = 953,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_4@10",
		.pme_desc = "Invalidations sent to four BWs. (M chip 10)",
		.pme_code = 954,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_4@11",
		.pme_desc = "Invalidations sent to four BWs. (M chip 11)",
		.pme_code = 955,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_4@12",
		.pme_desc = "Invalidations sent to four BWs. (M chip 12)",
		.pme_code = 956,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_4@13",
		.pme_desc = "Invalidations sent to four BWs. (M chip 13)",
		.pme_code = 957,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_4@14",
		.pme_desc = "Invalidations sent to four BWs. (M chip 14)",
		.pme_code = 958,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_4@15",
		.pme_desc = "Invalidations sent to four BWs. (M chip 15)",
		.pme_code = 959,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 11,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 12 Event 0 */
	{
		.pme_name = "UPDATE_NACK_RECV@0",
		.pme_desc = "UpdateNacks received. (M chip 0)",
		.pme_code = 960,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATE_NACK_RECV@1",
		.pme_desc = "UpdateNacks received. (M chip 1)",
		.pme_code = 961,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATE_NACK_RECV@2",
		.pme_desc = "UpdateNacks received. (M chip 2)",
		.pme_code = 962,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATE_NACK_RECV@3",
		.pme_desc = "UpdateNacks received. (M chip 3)",
		.pme_code = 963,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATE_NACK_RECV@4",
		.pme_desc = "UpdateNacks received. (M chip 4)",
		.pme_code = 964,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATE_NACK_RECV@5",
		.pme_desc = "UpdateNacks received. (M chip 5)",
		.pme_code = 965,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATE_NACK_RECV@6",
		.pme_desc = "UpdateNacks received. (M chip 6)",
		.pme_code = 966,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATE_NACK_RECV@7",
		.pme_desc = "UpdateNacks received. (M chip 7)",
		.pme_code = 967,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATE_NACK_RECV@8",
		.pme_desc = "UpdateNacks received. (M chip 8)",
		.pme_code = 968,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATE_NACK_RECV@9",
		.pme_desc = "UpdateNacks received. (M chip 9)",
		.pme_code = 969,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATE_NACK_RECV@10",
		.pme_desc = "UpdateNacks received. (M chip 10)",
		.pme_code = 970,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATE_NACK_RECV@11",
		.pme_desc = "UpdateNacks received. (M chip 11)",
		.pme_code = 971,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATE_NACK_RECV@12",
		.pme_desc = "UpdateNacks received. (M chip 12)",
		.pme_code = 972,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATE_NACK_RECV@13",
		.pme_desc = "UpdateNacks received. (M chip 13)",
		.pme_code = 973,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATE_NACK_RECV@14",
		.pme_desc = "UpdateNacks received. (M chip 14)",
		.pme_code = 974,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "UPDATE_NACK_RECV@15",
		.pme_desc = "UpdateNacks received. (M chip 15)",
		.pme_code = 975,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 12 Event 1 */
	{
		.pme_name = "W_OUT_BLOCK_CRED_1@0",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to lack of credits. (M chip 0)",
		.pme_code = 976,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_1@1",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to lack of credits. (M chip 1)",
		.pme_code = 977,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_1@2",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to lack of credits. (M chip 2)",
		.pme_code = 978,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_1@3",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to lack of credits. (M chip 3)",
		.pme_code = 979,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_1@4",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to lack of credits. (M chip 4)",
		.pme_code = 980,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_1@5",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to lack of credits. (M chip 5)",
		.pme_code = 981,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_1@6",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to lack of credits. (M chip 6)",
		.pme_code = 982,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_1@7",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to lack of credits. (M chip 7)",
		.pme_code = 983,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_1@8",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to lack of credits. (M chip 8)",
		.pme_code = 984,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_1@9",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to lack of credits. (M chip 9)",
		.pme_code = 985,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_1@10",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to lack of credits. (M chip 10)",
		.pme_code = 986,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_1@11",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to lack of credits. (M chip 11)",
		.pme_code = 987,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_1@12",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to lack of credits. (M chip 12)",
		.pme_code = 988,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_1@13",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to lack of credits. (M chip 13)",
		.pme_code = 989,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_1@14",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to lack of credits. (M chip 14)",
		.pme_code = 990,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_1@15",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to lack of credits. (M chip 15)",
		.pme_code = 991,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 12 Event 2 */
	{
		.pme_name = "W_IN_BLOCKED_0@0",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that is blocked due to MD full. (M chip 0)",
		.pme_code = 992,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_0@1",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that is blocked due to MD full. (M chip 1)",
		.pme_code = 993,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_0@2",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that is blocked due to MD full. (M chip 2)",
		.pme_code = 994,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_0@3",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that is blocked due to MD full. (M chip 3)",
		.pme_code = 995,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_0@4",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that is blocked due to MD full. (M chip 4)",
		.pme_code = 996,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_0@5",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that is blocked due to MD full. (M chip 5)",
		.pme_code = 997,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_0@6",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that is blocked due to MD full. (M chip 6)",
		.pme_code = 998,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_0@7",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that is blocked due to MD full. (M chip 7)",
		.pme_code = 999,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_0@8",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that is blocked due to MD full. (M chip 8)",
		.pme_code = 1000,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_0@9",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that is blocked due to MD full. (M chip 9)",
		.pme_code = 1001,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_0@10",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that is blocked due to MD full. (M chip 10)",
		.pme_code = 1002,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_0@11",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that is blocked due to MD full. (M chip 11)",
		.pme_code = 1003,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_0@12",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that is blocked due to MD full. (M chip 12)",
		.pme_code = 1004,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_0@13",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that is blocked due to MD full. (M chip 13)",
		.pme_code = 1005,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_0@14",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that is blocked due to MD full. (M chip 14)",
		.pme_code = 1006,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_0@15",
		.pme_desc = "Wclk cycles BW2MD input port 0 has a packet waiting that is blocked due to MD full. (M chip 15)",
		.pme_code = 1007,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 12 Event 3 */
	{
		.pme_name = "FWD_GET_SENT@0",
		.pme_desc = "FwdGet packets sent (Exclusive -> PendFwd transition). (M chip 0)",
		.pme_code = 1008,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_GET_SENT@1",
		.pme_desc = "FwdGet packets sent (Exclusive -> PendFwd transition). (M chip 1)",
		.pme_code = 1009,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_GET_SENT@2",
		.pme_desc = "FwdGet packets sent (Exclusive -> PendFwd transition). (M chip 2)",
		.pme_code = 1010,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_GET_SENT@3",
		.pme_desc = "FwdGet packets sent (Exclusive -> PendFwd transition). (M chip 3)",
		.pme_code = 1011,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_GET_SENT@4",
		.pme_desc = "FwdGet packets sent (Exclusive -> PendFwd transition). (M chip 4)",
		.pme_code = 1012,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_GET_SENT@5",
		.pme_desc = "FwdGet packets sent (Exclusive -> PendFwd transition). (M chip 5)",
		.pme_code = 1013,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_GET_SENT@6",
		.pme_desc = "FwdGet packets sent (Exclusive -> PendFwd transition). (M chip 6)",
		.pme_code = 1014,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_GET_SENT@7",
		.pme_desc = "FwdGet packets sent (Exclusive -> PendFwd transition). (M chip 7)",
		.pme_code = 1015,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_GET_SENT@8",
		.pme_desc = "FwdGet packets sent (Exclusive -> PendFwd transition). (M chip 8)",
		.pme_code = 1016,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_GET_SENT@9",
		.pme_desc = "FwdGet packets sent (Exclusive -> PendFwd transition). (M chip 9)",
		.pme_code = 1017,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_GET_SENT@10",
		.pme_desc = "FwdGet packets sent (Exclusive -> PendFwd transition). (M chip 10)",
		.pme_code = 1018,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_GET_SENT@11",
		.pme_desc = "FwdGet packets sent (Exclusive -> PendFwd transition). (M chip 11)",
		.pme_code = 1019,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_GET_SENT@12",
		.pme_desc = "FwdGet packets sent (Exclusive -> PendFwd transition). (M chip 12)",
		.pme_code = 1020,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_GET_SENT@13",
		.pme_desc = "FwdGet packets sent (Exclusive -> PendFwd transition). (M chip 13)",
		.pme_code = 1021,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_GET_SENT@14",
		.pme_desc = "FwdGet packets sent (Exclusive -> PendFwd transition). (M chip 14)",
		.pme_code = 1022,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FWD_GET_SENT@15",
		.pme_desc = "FwdGet packets sent (Exclusive -> PendFwd transition). (M chip 15)",
		.pme_code = 1023,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 12,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 13 Event 0 */
	{
		.pme_name = "PEND_DROP@0",
		.pme_desc = "Times entering PendDrop state (from Shared). (M chip 0)",
		.pme_code = 1024,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PEND_DROP@1",
		.pme_desc = "Times entering PendDrop state (from Shared). (M chip 1)",
		.pme_code = 1025,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PEND_DROP@2",
		.pme_desc = "Times entering PendDrop state (from Shared). (M chip 2)",
		.pme_code = 1026,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PEND_DROP@3",
		.pme_desc = "Times entering PendDrop state (from Shared). (M chip 3)",
		.pme_code = 1027,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PEND_DROP@4",
		.pme_desc = "Times entering PendDrop state (from Shared). (M chip 4)",
		.pme_code = 1028,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PEND_DROP@5",
		.pme_desc = "Times entering PendDrop state (from Shared). (M chip 5)",
		.pme_code = 1029,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PEND_DROP@6",
		.pme_desc = "Times entering PendDrop state (from Shared). (M chip 6)",
		.pme_code = 1030,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PEND_DROP@7",
		.pme_desc = "Times entering PendDrop state (from Shared). (M chip 7)",
		.pme_code = 1031,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PEND_DROP@8",
		.pme_desc = "Times entering PendDrop state (from Shared). (M chip 8)",
		.pme_code = 1032,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PEND_DROP@9",
		.pme_desc = "Times entering PendDrop state (from Shared). (M chip 9)",
		.pme_code = 1033,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PEND_DROP@10",
		.pme_desc = "Times entering PendDrop state (from Shared). (M chip 10)",
		.pme_code = 1034,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PEND_DROP@11",
		.pme_desc = "Times entering PendDrop state (from Shared). (M chip 11)",
		.pme_code = 1035,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PEND_DROP@12",
		.pme_desc = "Times entering PendDrop state (from Shared). (M chip 12)",
		.pme_code = 1036,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PEND_DROP@13",
		.pme_desc = "Times entering PendDrop state (from Shared). (M chip 13)",
		.pme_code = 1037,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PEND_DROP@14",
		.pme_desc = "Times entering PendDrop state (from Shared). (M chip 14)",
		.pme_code = 1038,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "PEND_DROP@15",
		.pme_desc = "Times entering PendDrop state (from Shared). (M chip 15)",
		.pme_code = 1039,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 13 Event 1 */
	{
		.pme_name = "LINE_EVICTIONS@0",
		.pme_desc = "Counts lines that are evicted. Note: doesn't count AMO forced evictions. Also note that the counter will increment if the line is not dirty and it is evicted. (M chip 0)",
		.pme_code = 1040,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "LINE_EVICTIONS@1",
		.pme_desc = "Counts lines that are evicted. Note: doesn't count AMO forced evictions. Also note that the counter will increment if the line is not dirty and it is evicted. (M chip 1)",
		.pme_code = 1041,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "LINE_EVICTIONS@2",
		.pme_desc = "Counts lines that are evicted. Note: doesn't count AMO forced evictions. Also note that the counter will increment if the line is not dirty and it is evicted. (M chip 2)",
		.pme_code = 1042,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "LINE_EVICTIONS@3",
		.pme_desc = "Counts lines that are evicted. Note: doesn't count AMO forced evictions. Also note that the counter will increment if the line is not dirty and it is evicted. (M chip 3)",
		.pme_code = 1043,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "LINE_EVICTIONS@4",
		.pme_desc = "Counts lines that are evicted. Note: doesn't count AMO forced evictions. Also note that the counter will increment if the line is not dirty and it is evicted. (M chip 4)",
		.pme_code = 1044,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "LINE_EVICTIONS@5",
		.pme_desc = "Counts lines that are evicted. Note: doesn't count AMO forced evictions. Also note that the counter will increment if the line is not dirty and it is evicted. (M chip 5)",
		.pme_code = 1045,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "LINE_EVICTIONS@6",
		.pme_desc = "Counts lines that are evicted. Note: doesn't count AMO forced evictions. Also note that the counter will increment if the line is not dirty and it is evicted. (M chip 6)",
		.pme_code = 1046,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "LINE_EVICTIONS@7",
		.pme_desc = "Counts lines that are evicted. Note: doesn't count AMO forced evictions. Also note that the counter will increment if the line is not dirty and it is evicted. (M chip 7)",
		.pme_code = 1047,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "LINE_EVICTIONS@8",
		.pme_desc = "Counts lines that are evicted. Note: doesn't count AMO forced evictions. Also note that the counter will increment if the line is not dirty and it is evicted. (M chip 8)",
		.pme_code = 1048,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "LINE_EVICTIONS@9",
		.pme_desc = "Counts lines that are evicted. Note: doesn't count AMO forced evictions. Also note that the counter will increment if the line is not dirty and it is evicted. (M chip 9)",
		.pme_code = 1049,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "LINE_EVICTIONS@10",
		.pme_desc = "Counts lines that are evicted. Note: doesn't count AMO forced evictions. Also note that the counter will increment if the line is not dirty and it is evicted. (M chip 10)",
		.pme_code = 1050,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "LINE_EVICTIONS@11",
		.pme_desc = "Counts lines that are evicted. Note: doesn't count AMO forced evictions. Also note that the counter will increment if the line is not dirty and it is evicted. (M chip 11)",
		.pme_code = 1051,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "LINE_EVICTIONS@12",
		.pme_desc = "Counts lines that are evicted. Note: doesn't count AMO forced evictions. Also note that the counter will increment if the line is not dirty and it is evicted. (M chip 12)",
		.pme_code = 1052,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "LINE_EVICTIONS@13",
		.pme_desc = "Counts lines that are evicted. Note: doesn't count AMO forced evictions. Also note that the counter will increment if the line is not dirty and it is evicted. (M chip 13)",
		.pme_code = 1053,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "LINE_EVICTIONS@14",
		.pme_desc = "Counts lines that are evicted. Note: doesn't count AMO forced evictions. Also note that the counter will increment if the line is not dirty and it is evicted. (M chip 14)",
		.pme_code = 1054,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "LINE_EVICTIONS@15",
		.pme_desc = "Counts lines that are evicted. Note: doesn't count AMO forced evictions. Also note that the counter will increment if the line is not dirty and it is evicted. (M chip 15)",
		.pme_code = 1055,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 13 Event 2 */
	{
		.pme_name = "W_IN_BLOCKED_1@0",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that is blocked due to MD full. (M chip 0)",
		.pme_code = 1056,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_1@1",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that is blocked due to MD full. (M chip 1)",
		.pme_code = 1057,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_1@2",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that is blocked due to MD full. (M chip 2)",
		.pme_code = 1058,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_1@3",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that is blocked due to MD full. (M chip 3)",
		.pme_code = 1059,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_1@4",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that is blocked due to MD full. (M chip 4)",
		.pme_code = 1060,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_1@5",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that is blocked due to MD full. (M chip 5)",
		.pme_code = 1061,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_1@6",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that is blocked due to MD full. (M chip 6)",
		.pme_code = 1062,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_1@7",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that is blocked due to MD full. (M chip 7)",
		.pme_code = 1063,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_1@8",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that is blocked due to MD full. (M chip 8)",
		.pme_code = 1064,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_1@9",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that is blocked due to MD full. (M chip 9)",
		.pme_code = 1065,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_1@10",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that is blocked due to MD full. (M chip 10)",
		.pme_code = 1066,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_1@11",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that is blocked due to MD full. (M chip 11)",
		.pme_code = 1067,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_1@12",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that is blocked due to MD full. (M chip 12)",
		.pme_code = 1068,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_1@13",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that is blocked due to MD full. (M chip 13)",
		.pme_code = 1069,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_1@14",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that is blocked due to MD full. (M chip 14)",
		.pme_code = 1070,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_1@15",
		.pme_desc = "Wclk cycles BW2MD input port 1 has a packet waiting that is blocked due to MD full. (M chip 15)",
		.pme_code = 1071,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 13 Event 3 */
	{
		.pme_name = "FLUSH_REQ_PACKETS@0",
		.pme_desc = "FlushReq packets sent (Exclusive -> PendFwd transition). (M chip 0)",
		.pme_code = 1072,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FLUSH_REQ_PACKETS@1",
		.pme_desc = "FlushReq packets sent (Exclusive -> PendFwd transition). (M chip 1)",
		.pme_code = 1073,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FLUSH_REQ_PACKETS@2",
		.pme_desc = "FlushReq packets sent (Exclusive -> PendFwd transition). (M chip 2)",
		.pme_code = 1074,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FLUSH_REQ_PACKETS@3",
		.pme_desc = "FlushReq packets sent (Exclusive -> PendFwd transition). (M chip 3)",
		.pme_code = 1075,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FLUSH_REQ_PACKETS@4",
		.pme_desc = "FlushReq packets sent (Exclusive -> PendFwd transition). (M chip 4)",
		.pme_code = 1076,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FLUSH_REQ_PACKETS@5",
		.pme_desc = "FlushReq packets sent (Exclusive -> PendFwd transition). (M chip 5)",
		.pme_code = 1077,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FLUSH_REQ_PACKETS@6",
		.pme_desc = "FlushReq packets sent (Exclusive -> PendFwd transition). (M chip 6)",
		.pme_code = 1078,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FLUSH_REQ_PACKETS@7",
		.pme_desc = "FlushReq packets sent (Exclusive -> PendFwd transition). (M chip 7)",
		.pme_code = 1079,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FLUSH_REQ_PACKETS@8",
		.pme_desc = "FlushReq packets sent (Exclusive -> PendFwd transition). (M chip 8)",
		.pme_code = 1080,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FLUSH_REQ_PACKETS@9",
		.pme_desc = "FlushReq packets sent (Exclusive -> PendFwd transition). (M chip 9)",
		.pme_code = 1081,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FLUSH_REQ_PACKETS@10",
		.pme_desc = "FlushReq packets sent (Exclusive -> PendFwd transition). (M chip 10)",
		.pme_code = 1082,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FLUSH_REQ_PACKETS@11",
		.pme_desc = "FlushReq packets sent (Exclusive -> PendFwd transition). (M chip 11)",
		.pme_code = 1083,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FLUSH_REQ_PACKETS@12",
		.pme_desc = "FlushReq packets sent (Exclusive -> PendFwd transition). (M chip 12)",
		.pme_code = 1084,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FLUSH_REQ_PACKETS@13",
		.pme_desc = "FlushReq packets sent (Exclusive -> PendFwd transition). (M chip 13)",
		.pme_code = 1085,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FLUSH_REQ_PACKETS@14",
		.pme_desc = "FlushReq packets sent (Exclusive -> PendFwd transition). (M chip 14)",
		.pme_code = 1086,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "FLUSH_REQ_PACKETS@15",
		.pme_desc = "FlushReq packets sent (Exclusive -> PendFwd transition). (M chip 15)",
		.pme_code = 1087,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 13,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 14 Event 0 */
	{
		.pme_name = "INVAL_EVENTS@0",
		.pme_desc = "Invalidation events (any number of sharers). (M chip 0)",
		.pme_code = 1088,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_EVENTS@1",
		.pme_desc = "Invalidation events (any number of sharers). (M chip 1)",
		.pme_code = 1089,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_EVENTS@2",
		.pme_desc = "Invalidation events (any number of sharers). (M chip 2)",
		.pme_code = 1090,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_EVENTS@3",
		.pme_desc = "Invalidation events (any number of sharers). (M chip 3)",
		.pme_code = 1091,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_EVENTS@4",
		.pme_desc = "Invalidation events (any number of sharers). (M chip 4)",
		.pme_code = 1092,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_EVENTS@5",
		.pme_desc = "Invalidation events (any number of sharers). (M chip 5)",
		.pme_code = 1093,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_EVENTS@6",
		.pme_desc = "Invalidation events (any number of sharers). (M chip 6)",
		.pme_code = 1094,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_EVENTS@7",
		.pme_desc = "Invalidation events (any number of sharers). (M chip 7)",
		.pme_code = 1095,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_EVENTS@8",
		.pme_desc = "Invalidation events (any number of sharers). (M chip 8)",
		.pme_code = 1096,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_EVENTS@9",
		.pme_desc = "Invalidation events (any number of sharers). (M chip 9)",
		.pme_code = 1097,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_EVENTS@10",
		.pme_desc = "Invalidation events (any number of sharers). (M chip 10)",
		.pme_code = 1098,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_EVENTS@11",
		.pme_desc = "Invalidation events (any number of sharers). (M chip 11)",
		.pme_code = 1099,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_EVENTS@12",
		.pme_desc = "Invalidation events (any number of sharers). (M chip 12)",
		.pme_code = 1100,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_EVENTS@13",
		.pme_desc = "Invalidation events (any number of sharers). (M chip 13)",
		.pme_code = 1101,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_EVENTS@14",
		.pme_desc = "Invalidation events (any number of sharers). (M chip 14)",
		.pme_code = 1102,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "INVAL_EVENTS@15",
		.pme_desc = "Invalidation events (any number of sharers). (M chip 15)",
		.pme_code = 1103,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 14 Event 1 */
	{
		.pme_name = "L3_LINE_HIT_GLOBAL@0",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was global. (M chip 0)",
		.pme_code = 1104,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_GLOBAL@1",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was global. (M chip 1)",
		.pme_code = 1105,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_GLOBAL@2",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was global. (M chip 2)",
		.pme_code = 1106,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_GLOBAL@3",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was global. (M chip 3)",
		.pme_code = 1107,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_GLOBAL@4",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was global. (M chip 4)",
		.pme_code = 1108,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_GLOBAL@5",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was global. (M chip 5)",
		.pme_code = 1109,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_GLOBAL@6",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was global. (M chip 6)",
		.pme_code = 1110,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_GLOBAL@7",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was global. (M chip 7)",
		.pme_code = 1111,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_GLOBAL@8",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was global. (M chip 8)",
		.pme_code = 1112,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_GLOBAL@9",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was global. (M chip 9)",
		.pme_code = 1113,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_GLOBAL@10",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was global. (M chip 10)",
		.pme_code = 1114,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_GLOBAL@11",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was global. (M chip 11)",
		.pme_code = 1115,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_GLOBAL@12",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was global. (M chip 12)",
		.pme_code = 1116,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_GLOBAL@13",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was global. (M chip 13)",
		.pme_code = 1117,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_GLOBAL@14",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was global. (M chip 14)",
		.pme_code = 1118,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_GLOBAL@15",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was global. (M chip 15)",
		.pme_code = 1119,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 14 Event 2 */
	{
		.pme_name = "W_IN_BLOCKED_2@0",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that is blocked due to MD full. (M chip 0)",
		.pme_code = 1120,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_2@1",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that is blocked due to MD full. (M chip 1)",
		.pme_code = 1121,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_2@2",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that is blocked due to MD full. (M chip 2)",
		.pme_code = 1122,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_2@3",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that is blocked due to MD full. (M chip 3)",
		.pme_code = 1123,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_2@4",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that is blocked due to MD full. (M chip 4)",
		.pme_code = 1124,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_2@5",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that is blocked due to MD full. (M chip 5)",
		.pme_code = 1125,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_2@6",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that is blocked due to MD full. (M chip 6)",
		.pme_code = 1126,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_2@7",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that is blocked due to MD full. (M chip 7)",
		.pme_code = 1127,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_2@8",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that is blocked due to MD full. (M chip 8)",
		.pme_code = 1128,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_2@9",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that is blocked due to MD full. (M chip 9)",
		.pme_code = 1129,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_2@10",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that is blocked due to MD full. (M chip 10)",
		.pme_code = 1130,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_2@11",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that is blocked due to MD full. (M chip 11)",
		.pme_code = 1131,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_2@12",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that is blocked due to MD full. (M chip 12)",
		.pme_code = 1132,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_2@13",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that is blocked due to MD full. (M chip 13)",
		.pme_code = 1133,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_2@14",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that is blocked due to MD full. (M chip 14)",
		.pme_code = 1134,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_2@15",
		.pme_desc = "Wclk cycles BW2MD input port 2 has a packet waiting that is blocked due to MD full. (M chip 15)",
		.pme_code = 1135,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 14 Event 3 */
	{
		.pme_name = "W_OUT_BLOCK_CRED_2@0",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to lack of credits. (M chip 0)",
		.pme_code = 1136,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_2@1",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to lack of credits. (M chip 1)",
		.pme_code = 1137,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_2@2",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to lack of credits. (M chip 2)",
		.pme_code = 1138,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_2@3",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to lack of credits. (M chip 3)",
		.pme_code = 1139,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_2@4",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to lack of credits. (M chip 4)",
		.pme_code = 1140,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_2@5",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to lack of credits. (M chip 5)",
		.pme_code = 1141,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_2@6",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to lack of credits. (M chip 6)",
		.pme_code = 1142,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_2@7",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to lack of credits. (M chip 7)",
		.pme_code = 1143,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_2@8",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to lack of credits. (M chip 8)",
		.pme_code = 1144,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_2@9",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to lack of credits. (M chip 9)",
		.pme_code = 1145,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_2@10",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to lack of credits. (M chip 10)",
		.pme_code = 1146,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_2@11",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to lack of credits. (M chip 11)",
		.pme_code = 1147,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_2@12",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to lack of credits. (M chip 12)",
		.pme_code = 1148,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_2@13",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to lack of credits. (M chip 13)",
		.pme_code = 1149,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_2@14",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to lack of credits. (M chip 14)",
		.pme_code = 1150,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_2@15",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to lack of credits. (M chip 15)",
		.pme_code = 1151,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 14,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 15 Event 0 */
	{
		.pme_name = "REQUEST_ALLOC_NO_FILL@0",
		.pme_desc = "Allocating no fill requests. (M chip 0)",
		.pme_code = 1152,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_ALLOC_NO_FILL@1",
		.pme_desc = "Allocating no fill requests. (M chip 1)",
		.pme_code = 1153,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_ALLOC_NO_FILL@2",
		.pme_desc = "Allocating no fill requests. (M chip 2)",
		.pme_code = 1154,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_ALLOC_NO_FILL@3",
		.pme_desc = "Allocating no fill requests. (M chip 3)",
		.pme_code = 1155,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_ALLOC_NO_FILL@4",
		.pme_desc = "Allocating no fill requests. (M chip 4)",
		.pme_code = 1156,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_ALLOC_NO_FILL@5",
		.pme_desc = "Allocating no fill requests. (M chip 5)",
		.pme_code = 1157,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_ALLOC_NO_FILL@6",
		.pme_desc = "Allocating no fill requests. (M chip 6)",
		.pme_code = 1158,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_ALLOC_NO_FILL@7",
		.pme_desc = "Allocating no fill requests. (M chip 7)",
		.pme_code = 1159,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_ALLOC_NO_FILL@8",
		.pme_desc = "Allocating no fill requests. (M chip 8)",
		.pme_code = 1160,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_ALLOC_NO_FILL@9",
		.pme_desc = "Allocating no fill requests. (M chip 9)",
		.pme_code = 1161,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_ALLOC_NO_FILL@10",
		.pme_desc = "Allocating no fill requests. (M chip 10)",
		.pme_code = 1162,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_ALLOC_NO_FILL@11",
		.pme_desc = "Allocating no fill requests. (M chip 11)",
		.pme_code = 1163,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_ALLOC_NO_FILL@12",
		.pme_desc = "Allocating no fill requests. (M chip 12)",
		.pme_code = 1164,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_ALLOC_NO_FILL@13",
		.pme_desc = "Allocating no fill requests. (M chip 13)",
		.pme_code = 1165,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_ALLOC_NO_FILL@14",
		.pme_desc = "Allocating no fill requests. (M chip 14)",
		.pme_code = 1166,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_ALLOC_NO_FILL@15",
		.pme_desc = "Allocating no fill requests. (M chip 15)",
		.pme_code = 1167,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 15 Event 1 */
	{
		.pme_name = "L3_LINE_HIT_SHARED@0",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was shared. (M chip 0)",
		.pme_code = 1168,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_SHARED@1",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was shared. (M chip 1)",
		.pme_code = 1169,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_SHARED@2",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was shared. (M chip 2)",
		.pme_code = 1170,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_SHARED@3",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was shared. (M chip 3)",
		.pme_code = 1171,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_SHARED@4",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was shared. (M chip 4)",
		.pme_code = 1172,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_SHARED@5",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was shared. (M chip 5)",
		.pme_code = 1173,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_SHARED@6",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was shared. (M chip 6)",
		.pme_code = 1174,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_SHARED@7",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was shared. (M chip 7)",
		.pme_code = 1175,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_SHARED@8",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was shared. (M chip 8)",
		.pme_code = 1176,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_SHARED@9",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was shared. (M chip 9)",
		.pme_code = 1177,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_SHARED@10",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was shared. (M chip 10)",
		.pme_code = 1178,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_SHARED@11",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was shared. (M chip 11)",
		.pme_code = 1179,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_SHARED@12",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was shared. (M chip 12)",
		.pme_code = 1180,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_SHARED@13",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was shared. (M chip 13)",
		.pme_code = 1181,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_SHARED@14",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was shared. (M chip 14)",
		.pme_code = 1182,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "L3_LINE_HIT_SHARED@15",
		.pme_desc = "Allocating read requests that hit out of L3 cached data and state was shared. (M chip 15)",
		.pme_code = 1183,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 15 Event 2 */
	{
		.pme_name = "W_IN_BLOCKED_3@0",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that is blocked due to MD full. (M chip 0)",
		.pme_code = 1184,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_3@1",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that is blocked due to MD full. (M chip 1)",
		.pme_code = 1185,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_3@2",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that is blocked due to MD full. (M chip 2)",
		.pme_code = 1186,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_3@3",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that is blocked due to MD full. (M chip 3)",
		.pme_code = 1187,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_3@4",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that is blocked due to MD full. (M chip 4)",
		.pme_code = 1188,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_3@5",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that is blocked due to MD full. (M chip 5)",
		.pme_code = 1189,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_3@6",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that is blocked due to MD full. (M chip 6)",
		.pme_code = 1190,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_3@7",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that is blocked due to MD full. (M chip 7)",
		.pme_code = 1191,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_3@8",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that is blocked due to MD full. (M chip 8)",
		.pme_code = 1192,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_3@9",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that is blocked due to MD full. (M chip 9)",
		.pme_code = 1193,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_3@10",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that is blocked due to MD full. (M chip 10)",
		.pme_code = 1194,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_3@11",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that is blocked due to MD full. (M chip 11)",
		.pme_code = 1195,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_3@12",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that is blocked due to MD full. (M chip 12)",
		.pme_code = 1196,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_3@13",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that is blocked due to MD full. (M chip 13)",
		.pme_code = 1197,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_3@14",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that is blocked due to MD full. (M chip 14)",
		.pme_code = 1198,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_IN_BLOCKED_3@15",
		.pme_desc = "Wclk cycles BW2MD input port 3 has a packet waiting that is blocked due to MD full. (M chip 15)",
		.pme_code = 1199,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 15 Event 3 */
	{
		.pme_name = "W_OUT_BLOCK_CRED_3@0",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to lack of credits. (M chip 0)",
		.pme_code = 1200,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_3@1",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to lack of credits. (M chip 1)",
		.pme_code = 1201,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_3@2",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to lack of credits. (M chip 2)",
		.pme_code = 1202,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_3@3",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to lack of credits. (M chip 3)",
		.pme_code = 1203,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_3@4",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to lack of credits. (M chip 4)",
		.pme_code = 1204,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_3@5",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to lack of credits. (M chip 5)",
		.pme_code = 1205,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_3@6",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to lack of credits. (M chip 6)",
		.pme_code = 1206,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_3@7",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to lack of credits. (M chip 7)",
		.pme_code = 1207,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_3@8",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to lack of credits. (M chip 8)",
		.pme_code = 1208,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_3@9",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to lack of credits. (M chip 9)",
		.pme_code = 1209,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_3@10",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to lack of credits. (M chip 10)",
		.pme_code = 1210,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_3@11",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to lack of credits. (M chip 11)",
		.pme_code = 1211,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_3@12",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to lack of credits. (M chip 12)",
		.pme_code = 1212,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_3@13",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to lack of credits. (M chip 13)",
		.pme_code = 1213,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_3@14",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to lack of credits. (M chip 14)",
		.pme_code = 1214,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CRED_3@15",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to lack of credits. (M chip 15)",
		.pme_code = 1215,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 15,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 16 Event 0 */
	{
		.pme_name = "REQUEST_1DWORD_L3_HIT@0",
		.pme_desc = "Single DWord Get and NGet requests to MDs - L3 hit. (M chip 0)",
		.pme_code = 1216,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_HIT@1",
		.pme_desc = "Single DWord Get and NGet requests to MDs - L3 hit. (M chip 1)",
		.pme_code = 1217,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_HIT@2",
		.pme_desc = "Single DWord Get and NGet requests to MDs - L3 hit. (M chip 2)",
		.pme_code = 1218,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_HIT@3",
		.pme_desc = "Single DWord Get and NGet requests to MDs - L3 hit. (M chip 3)",
		.pme_code = 1219,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_HIT@4",
		.pme_desc = "Single DWord Get and NGet requests to MDs - L3 hit. (M chip 4)",
		.pme_code = 1220,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_HIT@5",
		.pme_desc = "Single DWord Get and NGet requests to MDs - L3 hit. (M chip 5)",
		.pme_code = 1221,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_HIT@6",
		.pme_desc = "Single DWord Get and NGet requests to MDs - L3 hit. (M chip 6)",
		.pme_code = 1222,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_HIT@7",
		.pme_desc = "Single DWord Get and NGet requests to MDs - L3 hit. (M chip 7)",
		.pme_code = 1223,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_HIT@8",
		.pme_desc = "Single DWord Get and NGet requests to MDs - L3 hit. (M chip 8)",
		.pme_code = 1224,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_HIT@9",
		.pme_desc = "Single DWord Get and NGet requests to MDs - L3 hit. (M chip 9)",
		.pme_code = 1225,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_HIT@10",
		.pme_desc = "Single DWord Get and NGet requests to MDs - L3 hit. (M chip 10)",
		.pme_code = 1226,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_HIT@11",
		.pme_desc = "Single DWord Get and NGet requests to MDs - L3 hit. (M chip 11)",
		.pme_code = 1227,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_HIT@12",
		.pme_desc = "Single DWord Get and NGet requests to MDs - L3 hit. (M chip 12)",
		.pme_code = 1228,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_HIT@13",
		.pme_desc = "Single DWord Get and NGet requests to MDs - L3 hit. (M chip 13)",
		.pme_code = 1229,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_HIT@14",
		.pme_desc = "Single DWord Get and NGet requests to MDs - L3 hit. (M chip 14)",
		.pme_code = 1230,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_HIT@15",
		.pme_desc = "Single DWord Get and NGet requests to MDs - L3 hit. (M chip 15)",
		.pme_code = 1231,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 16 Event 1 */
	{
		.pme_name = "AMOS@0",
		.pme_desc = "AMOs to local memory (memory manager). (M chip 0)",
		.pme_code = 1232,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMOS@1",
		.pme_desc = "AMOs to local memory (memory manager). (M chip 1)",
		.pme_code = 1233,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMOS@2",
		.pme_desc = "AMOs to local memory (memory manager). (M chip 2)",
		.pme_code = 1234,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMOS@3",
		.pme_desc = "AMOs to local memory (memory manager). (M chip 3)",
		.pme_code = 1235,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMOS@4",
		.pme_desc = "AMOs to local memory (memory manager). (M chip 4)",
		.pme_code = 1236,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMOS@5",
		.pme_desc = "AMOs to local memory (memory manager). (M chip 5)",
		.pme_code = 1237,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMOS@6",
		.pme_desc = "AMOs to local memory (memory manager). (M chip 6)",
		.pme_code = 1238,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMOS@7",
		.pme_desc = "AMOs to local memory (memory manager). (M chip 7)",
		.pme_code = 1239,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMOS@8",
		.pme_desc = "AMOs to local memory (memory manager). (M chip 8)",
		.pme_code = 1240,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMOS@9",
		.pme_desc = "AMOs to local memory (memory manager). (M chip 9)",
		.pme_code = 1241,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMOS@10",
		.pme_desc = "AMOs to local memory (memory manager). (M chip 10)",
		.pme_code = 1242,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMOS@11",
		.pme_desc = "AMOs to local memory (memory manager). (M chip 11)",
		.pme_code = 1243,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMOS@12",
		.pme_desc = "AMOs to local memory (memory manager). (M chip 12)",
		.pme_code = 1244,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMOS@13",
		.pme_desc = "AMOs to local memory (memory manager). (M chip 13)",
		.pme_code = 1245,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMOS@14",
		.pme_desc = "AMOs to local memory (memory manager). (M chip 14)",
		.pme_code = 1246,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMOS@15",
		.pme_desc = "AMOs to local memory (memory manager). (M chip 15)",
		.pme_code = 1247,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 16 Event 2 */
	{
		.pme_name = "MM0_ANY_BANK_BUSY@0",
		.pme_desc = "Wclk cycles that any back is busy in MM0. (M chip 0)",
		.pme_code = 1248,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ANY_BANK_BUSY@1",
		.pme_desc = "Wclk cycles that any back is busy in MM0. (M chip 1)",
		.pme_code = 1249,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ANY_BANK_BUSY@2",
		.pme_desc = "Wclk cycles that any back is busy in MM0. (M chip 2)",
		.pme_code = 1250,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ANY_BANK_BUSY@3",
		.pme_desc = "Wclk cycles that any back is busy in MM0. (M chip 3)",
		.pme_code = 1251,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ANY_BANK_BUSY@4",
		.pme_desc = "Wclk cycles that any back is busy in MM0. (M chip 4)",
		.pme_code = 1252,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ANY_BANK_BUSY@5",
		.pme_desc = "Wclk cycles that any back is busy in MM0. (M chip 5)",
		.pme_code = 1253,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ANY_BANK_BUSY@6",
		.pme_desc = "Wclk cycles that any back is busy in MM0. (M chip 6)",
		.pme_code = 1254,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ANY_BANK_BUSY@7",
		.pme_desc = "Wclk cycles that any back is busy in MM0. (M chip 7)",
		.pme_code = 1255,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ANY_BANK_BUSY@8",
		.pme_desc = "Wclk cycles that any back is busy in MM0. (M chip 8)",
		.pme_code = 1256,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ANY_BANK_BUSY@9",
		.pme_desc = "Wclk cycles that any back is busy in MM0. (M chip 9)",
		.pme_code = 1257,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ANY_BANK_BUSY@10",
		.pme_desc = "Wclk cycles that any back is busy in MM0. (M chip 10)",
		.pme_code = 1258,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ANY_BANK_BUSY@11",
		.pme_desc = "Wclk cycles that any back is busy in MM0. (M chip 11)",
		.pme_code = 1259,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ANY_BANK_BUSY@12",
		.pme_desc = "Wclk cycles that any back is busy in MM0. (M chip 12)",
		.pme_code = 1260,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ANY_BANK_BUSY@13",
		.pme_desc = "Wclk cycles that any back is busy in MM0. (M chip 13)",
		.pme_code = 1261,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ANY_BANK_BUSY@14",
		.pme_desc = "Wclk cycles that any back is busy in MM0. (M chip 14)",
		.pme_code = 1262,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ANY_BANK_BUSY@15",
		.pme_desc = "Wclk cycles that any back is busy in MM0. (M chip 15)",
		.pme_code = 1263,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 16 Event 3 */
	{
		.pme_name = "W_OUT_BLOCK_CHN_0@0",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to channel back-pressure. (M chip 0)",
		.pme_code = 1264,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_0@1",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to channel back-pressure. (M chip 1)",
		.pme_code = 1265,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_0@2",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to channel back-pressure. (M chip 2)",
		.pme_code = 1266,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_0@3",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to channel back-pressure. (M chip 3)",
		.pme_code = 1267,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_0@4",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to channel back-pressure. (M chip 4)",
		.pme_code = 1268,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_0@5",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to channel back-pressure. (M chip 5)",
		.pme_code = 1269,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_0@6",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to channel back-pressure. (M chip 6)",
		.pme_code = 1270,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_0@7",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to channel back-pressure. (M chip 7)",
		.pme_code = 1271,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_0@8",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to channel back-pressure. (M chip 8)",
		.pme_code = 1272,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_0@9",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to channel back-pressure. (M chip 9)",
		.pme_code = 1273,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_0@10",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to channel back-pressure. (M chip 10)",
		.pme_code = 1274,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_0@11",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to channel back-pressure. (M chip 11)",
		.pme_code = 1275,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_0@12",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to channel back-pressure. (M chip 12)",
		.pme_code = 1276,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_0@13",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to channel back-pressure. (M chip 13)",
		.pme_code = 1277,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_0@14",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to channel back-pressure. (M chip 14)",
		.pme_code = 1278,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_0@15",
		.pme_desc = "Wclk cycles MD2BW output port 0 is blocked due to channel back-pressure. (M chip 15)",
		.pme_code = 1279,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 16,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 17 Event 0 */
	{
		.pme_name = "REQUEST_4DWORDS_L3_HIT@0",
		.pme_desc = "Allocating read requests to MDs - L3 hit. (M chip 0)",
		.pme_code = 1280,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_HIT@1",
		.pme_desc = "Allocating read requests to MDs - L3 hit. (M chip 1)",
		.pme_code = 1281,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_HIT@2",
		.pme_desc = "Allocating read requests to MDs - L3 hit. (M chip 2)",
		.pme_code = 1282,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_HIT@3",
		.pme_desc = "Allocating read requests to MDs - L3 hit. (M chip 3)",
		.pme_code = 1283,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_HIT@4",
		.pme_desc = "Allocating read requests to MDs - L3 hit. (M chip 4)",
		.pme_code = 1284,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_HIT@5",
		.pme_desc = "Allocating read requests to MDs - L3 hit. (M chip 5)",
		.pme_code = 1285,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_HIT@6",
		.pme_desc = "Allocating read requests to MDs - L3 hit. (M chip 6)",
		.pme_code = 1286,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_HIT@7",
		.pme_desc = "Allocating read requests to MDs - L3 hit. (M chip 7)",
		.pme_code = 1287,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_HIT@8",
		.pme_desc = "Allocating read requests to MDs - L3 hit. (M chip 8)",
		.pme_code = 1288,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_HIT@9",
		.pme_desc = "Allocating read requests to MDs - L3 hit. (M chip 9)",
		.pme_code = 1289,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_HIT@10",
		.pme_desc = "Allocating read requests to MDs - L3 hit. (M chip 10)",
		.pme_code = 1290,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_HIT@11",
		.pme_desc = "Allocating read requests to MDs - L3 hit. (M chip 11)",
		.pme_code = 1291,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_HIT@12",
		.pme_desc = "Allocating read requests to MDs - L3 hit. (M chip 12)",
		.pme_code = 1292,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_HIT@13",
		.pme_desc = "Allocating read requests to MDs - L3 hit. (M chip 13)",
		.pme_code = 1293,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_HIT@14",
		.pme_desc = "Allocating read requests to MDs - L3 hit. (M chip 14)",
		.pme_code = 1294,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_HIT@15",
		.pme_desc = "Allocating read requests to MDs - L3 hit. (M chip 15)",
		.pme_code = 1295,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 17 Event 1 */
	{
		.pme_name = "AMO_MISSES@0",
		.pme_desc = "Misses in AMO cache (memory manager). (M chip 0)",
		.pme_code = 1296,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMO_MISSES@1",
		.pme_desc = "Misses in AMO cache (memory manager). (M chip 1)",
		.pme_code = 1297,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMO_MISSES@2",
		.pme_desc = "Misses in AMO cache (memory manager). (M chip 2)",
		.pme_code = 1298,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMO_MISSES@3",
		.pme_desc = "Misses in AMO cache (memory manager). (M chip 3)",
		.pme_code = 1299,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMO_MISSES@4",
		.pme_desc = "Misses in AMO cache (memory manager). (M chip 4)",
		.pme_code = 1300,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMO_MISSES@5",
		.pme_desc = "Misses in AMO cache (memory manager). (M chip 5)",
		.pme_code = 1301,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMO_MISSES@6",
		.pme_desc = "Misses in AMO cache (memory manager). (M chip 6)",
		.pme_code = 1302,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMO_MISSES@7",
		.pme_desc = "Misses in AMO cache (memory manager). (M chip 7)",
		.pme_code = 1303,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMO_MISSES@8",
		.pme_desc = "Misses in AMO cache (memory manager). (M chip 8)",
		.pme_code = 1304,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMO_MISSES@9",
		.pme_desc = "Misses in AMO cache (memory manager). (M chip 9)",
		.pme_code = 1305,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMO_MISSES@10",
		.pme_desc = "Misses in AMO cache (memory manager). (M chip 10)",
		.pme_code = 1306,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMO_MISSES@11",
		.pme_desc = "Misses in AMO cache (memory manager). (M chip 11)",
		.pme_code = 1307,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMO_MISSES@12",
		.pme_desc = "Misses in AMO cache (memory manager). (M chip 12)",
		.pme_code = 1308,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMO_MISSES@13",
		.pme_desc = "Misses in AMO cache (memory manager). (M chip 13)",
		.pme_code = 1309,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMO_MISSES@14",
		.pme_desc = "Misses in AMO cache (memory manager). (M chip 14)",
		.pme_code = 1310,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "AMO_MISSES@15",
		.pme_desc = "Misses in AMO cache (memory manager). (M chip 15)",
		.pme_code = 1311,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 17 Event 2 */
	{
		.pme_name = "MM0_ACCUM_BANK_BUSY@0",
		.pme_desc = "Accumulation of the MM0 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 0)",
		.pme_code = 1312,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ACCUM_BANK_BUSY@1",
		.pme_desc = "Accumulation of the MM0 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 1)",
		.pme_code = 1313,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ACCUM_BANK_BUSY@2",
		.pme_desc = "Accumulation of the MM0 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 2)",
		.pme_code = 1314,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ACCUM_BANK_BUSY@3",
		.pme_desc = "Accumulation of the MM0 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 3)",
		.pme_code = 1315,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ACCUM_BANK_BUSY@4",
		.pme_desc = "Accumulation of the MM0 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 4)",
		.pme_code = 1316,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ACCUM_BANK_BUSY@5",
		.pme_desc = "Accumulation of the MM0 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 5)",
		.pme_code = 1317,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ACCUM_BANK_BUSY@6",
		.pme_desc = "Accumulation of the MM0 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 6)",
		.pme_code = 1318,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ACCUM_BANK_BUSY@7",
		.pme_desc = "Accumulation of the MM0 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 7)",
		.pme_code = 1319,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ACCUM_BANK_BUSY@8",
		.pme_desc = "Accumulation of the MM0 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 8)",
		.pme_code = 1320,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ACCUM_BANK_BUSY@9",
		.pme_desc = "Accumulation of the MM0 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 9)",
		.pme_code = 1321,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ACCUM_BANK_BUSY@10",
		.pme_desc = "Accumulation of the MM0 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 10)",
		.pme_code = 1322,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ACCUM_BANK_BUSY@11",
		.pme_desc = "Accumulation of the MM0 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 11)",
		.pme_code = 1323,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ACCUM_BANK_BUSY@12",
		.pme_desc = "Accumulation of the MM0 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 12)",
		.pme_code = 1324,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ACCUM_BANK_BUSY@13",
		.pme_desc = "Accumulation of the MM0 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 13)",
		.pme_code = 1325,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ACCUM_BANK_BUSY@14",
		.pme_desc = "Accumulation of the MM0 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 14)",
		.pme_code = 1326,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM0_ACCUM_BANK_BUSY@15",
		.pme_desc = "Accumulation of the MM0 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 15)",
		.pme_code = 1327,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 17 Event 3 */
	{
		.pme_name = "W_OUT_BLOCK_CHN_1@0",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to channel back-pressure. (M chip 0)",
		.pme_code = 1328,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_1@1",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to channel back-pressure. (M chip 1)",
		.pme_code = 1329,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_1@2",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to channel back-pressure. (M chip 2)",
		.pme_code = 1330,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_1@3",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to channel back-pressure. (M chip 3)",
		.pme_code = 1331,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_1@4",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to channel back-pressure. (M chip 4)",
		.pme_code = 1332,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_1@5",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to channel back-pressure. (M chip 5)",
		.pme_code = 1333,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_1@6",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to channel back-pressure. (M chip 6)",
		.pme_code = 1334,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_1@7",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to channel back-pressure. (M chip 7)",
		.pme_code = 1335,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_1@8",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to channel back-pressure. (M chip 8)",
		.pme_code = 1336,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_1@9",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to channel back-pressure. (M chip 9)",
		.pme_code = 1337,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_1@10",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to channel back-pressure. (M chip 10)",
		.pme_code = 1338,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_1@11",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to channel back-pressure. (M chip 11)",
		.pme_code = 1339,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_1@12",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to channel back-pressure. (M chip 12)",
		.pme_code = 1340,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_1@13",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to channel back-pressure. (M chip 13)",
		.pme_code = 1341,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_1@14",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to channel back-pressure. (M chip 14)",
		.pme_code = 1342,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_1@15",
		.pme_desc = "Wclk cycles MD2BW output port 1 is blocked due to channel back-pressure. (M chip 15)",
		.pme_code = 1343,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 17,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 18 Event 0 */
	{
		.pme_name = "REQUEST_1DWORD@0",
		.pme_desc = "Single DWord Get and NGet requests to MDs. (M chip 0)",
		.pme_code = 1344,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD@1",
		.pme_desc = "Single DWord Get and NGet requests to MDs. (M chip 1)",
		.pme_code = 1345,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD@2",
		.pme_desc = "Single DWord Get and NGet requests to MDs. (M chip 2)",
		.pme_code = 1346,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD@3",
		.pme_desc = "Single DWord Get and NGet requests to MDs. (M chip 3)",
		.pme_code = 1347,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD@4",
		.pme_desc = "Single DWord Get and NGet requests to MDs. (M chip 4)",
		.pme_code = 1348,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD@5",
		.pme_desc = "Single DWord Get and NGet requests to MDs. (M chip 5)",
		.pme_code = 1349,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD@6",
		.pme_desc = "Single DWord Get and NGet requests to MDs. (M chip 6)",
		.pme_code = 1350,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD@7",
		.pme_desc = "Single DWord Get and NGet requests to MDs. (M chip 7)",
		.pme_code = 1351,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD@8",
		.pme_desc = "Single DWord Get and NGet requests to MDs. (M chip 8)",
		.pme_code = 1352,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD@9",
		.pme_desc = "Single DWord Get and NGet requests to MDs. (M chip 9)",
		.pme_code = 1353,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD@10",
		.pme_desc = "Single DWord Get and NGet requests to MDs. (M chip 10)",
		.pme_code = 1354,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD@11",
		.pme_desc = "Single DWord Get and NGet requests to MDs. (M chip 11)",
		.pme_code = 1355,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD@12",
		.pme_desc = "Single DWord Get and NGet requests to MDs. (M chip 12)",
		.pme_code = 1356,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD@13",
		.pme_desc = "Single DWord Get and NGet requests to MDs. (M chip 13)",
		.pme_code = 1357,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD@14",
		.pme_desc = "Single DWord Get and NGet requests to MDs. (M chip 14)",
		.pme_code = 1358,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD@15",
		.pme_desc = "Single DWord Get and NGet requests to MDs. (M chip 15)",
		.pme_code = 1359,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 18 Event 1 */
	{
		.pme_name = "RETRIES_MM@0",
		.pme_desc = "Memory Manager retries. (M chip 0)",
		.pme_code = 1360,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "RETRIES_MM@1",
		.pme_desc = "Memory Manager retries. (M chip 1)",
		.pme_code = 1361,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "RETRIES_MM@2",
		.pme_desc = "Memory Manager retries. (M chip 2)",
		.pme_code = 1362,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "RETRIES_MM@3",
		.pme_desc = "Memory Manager retries. (M chip 3)",
		.pme_code = 1363,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "RETRIES_MM@4",
		.pme_desc = "Memory Manager retries. (M chip 4)",
		.pme_code = 1364,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "RETRIES_MM@5",
		.pme_desc = "Memory Manager retries. (M chip 5)",
		.pme_code = 1365,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "RETRIES_MM@6",
		.pme_desc = "Memory Manager retries. (M chip 6)",
		.pme_code = 1366,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "RETRIES_MM@7",
		.pme_desc = "Memory Manager retries. (M chip 7)",
		.pme_code = 1367,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "RETRIES_MM@8",
		.pme_desc = "Memory Manager retries. (M chip 8)",
		.pme_code = 1368,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "RETRIES_MM@9",
		.pme_desc = "Memory Manager retries. (M chip 9)",
		.pme_code = 1369,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "RETRIES_MM@10",
		.pme_desc = "Memory Manager retries. (M chip 10)",
		.pme_code = 1370,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "RETRIES_MM@11",
		.pme_desc = "Memory Manager retries. (M chip 11)",
		.pme_code = 1371,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "RETRIES_MM@12",
		.pme_desc = "Memory Manager retries. (M chip 12)",
		.pme_code = 1372,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "RETRIES_MM@13",
		.pme_desc = "Memory Manager retries. (M chip 13)",
		.pme_code = 1373,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "RETRIES_MM@14",
		.pme_desc = "Memory Manager retries. (M chip 14)",
		.pme_code = 1374,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "RETRIES_MM@15",
		.pme_desc = "Memory Manager retries. (M chip 15)",
		.pme_code = 1375,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 18 Event 2 */
	{
		.pme_name = "MM1_ANY_BANK_BUSY@0",
		.pme_desc = "Wclk cycles that any bank is busy in MM1. (M chip 0)",
		.pme_code = 1376,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ANY_BANK_BUSY@1",
		.pme_desc = "Wclk cycles that any bank is busy in MM1. (M chip 1)",
		.pme_code = 1377,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ANY_BANK_BUSY@2",
		.pme_desc = "Wclk cycles that any bank is busy in MM1. (M chip 2)",
		.pme_code = 1378,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ANY_BANK_BUSY@3",
		.pme_desc = "Wclk cycles that any bank is busy in MM1. (M chip 3)",
		.pme_code = 1379,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ANY_BANK_BUSY@4",
		.pme_desc = "Wclk cycles that any bank is busy in MM1. (M chip 4)",
		.pme_code = 1380,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ANY_BANK_BUSY@5",
		.pme_desc = "Wclk cycles that any bank is busy in MM1. (M chip 5)",
		.pme_code = 1381,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ANY_BANK_BUSY@6",
		.pme_desc = "Wclk cycles that any bank is busy in MM1. (M chip 6)",
		.pme_code = 1382,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ANY_BANK_BUSY@7",
		.pme_desc = "Wclk cycles that any bank is busy in MM1. (M chip 7)",
		.pme_code = 1383,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ANY_BANK_BUSY@8",
		.pme_desc = "Wclk cycles that any bank is busy in MM1. (M chip 8)",
		.pme_code = 1384,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ANY_BANK_BUSY@9",
		.pme_desc = "Wclk cycles that any bank is busy in MM1. (M chip 9)",
		.pme_code = 1385,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ANY_BANK_BUSY@10",
		.pme_desc = "Wclk cycles that any bank is busy in MM1. (M chip 10)",
		.pme_code = 1386,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ANY_BANK_BUSY@11",
		.pme_desc = "Wclk cycles that any bank is busy in MM1. (M chip 11)",
		.pme_code = 1387,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ANY_BANK_BUSY@12",
		.pme_desc = "Wclk cycles that any bank is busy in MM1. (M chip 12)",
		.pme_code = 1388,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ANY_BANK_BUSY@13",
		.pme_desc = "Wclk cycles that any bank is busy in MM1. (M chip 13)",
		.pme_code = 1389,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ANY_BANK_BUSY@14",
		.pme_desc = "Wclk cycles that any bank is busy in MM1. (M chip 14)",
		.pme_code = 1390,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ANY_BANK_BUSY@15",
		.pme_desc = "Wclk cycles that any bank is busy in MM1. (M chip 15)",
		.pme_code = 1391,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 18 Event 3 */
	{
		.pme_name = "W_OUT_BLOCK_CHN_2@0",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to channel back-pressure. (M chip 0)",
		.pme_code = 1392,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_2@1",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to channel back-pressure. (M chip 1)",
		.pme_code = 1393,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_2@2",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to channel back-pressure. (M chip 2)",
		.pme_code = 1394,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_2@3",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to channel back-pressure. (M chip 3)",
		.pme_code = 1395,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_2@4",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to channel back-pressure. (M chip 4)",
		.pme_code = 1396,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_2@5",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to channel back-pressure. (M chip 5)",
		.pme_code = 1397,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_2@6",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to channel back-pressure. (M chip 6)",
		.pme_code = 1398,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_2@7",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to channel back-pressure. (M chip 7)",
		.pme_code = 1399,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_2@8",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to channel back-pressure. (M chip 8)",
		.pme_code = 1400,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_2@9",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to channel back-pressure. (M chip 9)",
		.pme_code = 1401,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_2@10",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to channel back-pressure. (M chip 10)",
		.pme_code = 1402,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_2@11",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to channel back-pressure. (M chip 11)",
		.pme_code = 1403,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_2@12",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to channel back-pressure. (M chip 12)",
		.pme_code = 1404,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_2@13",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to channel back-pressure. (M chip 13)",
		.pme_code = 1405,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_2@14",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to channel back-pressure. (M chip 14)",
		.pme_code = 1406,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_2@15",
		.pme_desc = "Wclk cycles MD2BW output port 2 is blocked due to channel back-pressure. (M chip 15)",
		.pme_code = 1407,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 18,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 19 Event 0 */
	{
		.pme_name = "REQUEST_4DWORDS@0",
		.pme_desc = "Allocating read, Get and NGet full cache line requests to MDs. (M chip 0)",
		.pme_code = 1408,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS@1",
		.pme_desc = "Allocating read, Get and NGet full cache line requests to MDs. (M chip 1)",
		.pme_code = 1409,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS@2",
		.pme_desc = "Allocating read, Get and NGet full cache line requests to MDs. (M chip 2)",
		.pme_code = 1410,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS@3",
		.pme_desc = "Allocating read, Get and NGet full cache line requests to MDs. (M chip 3)",
		.pme_code = 1411,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS@4",
		.pme_desc = "Allocating read, Get and NGet full cache line requests to MDs. (M chip 4)",
		.pme_code = 1412,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS@5",
		.pme_desc = "Allocating read, Get and NGet full cache line requests to MDs. (M chip 5)",
		.pme_code = 1413,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS@6",
		.pme_desc = "Allocating read, Get and NGet full cache line requests to MDs. (M chip 6)",
		.pme_code = 1414,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS@7",
		.pme_desc = "Allocating read, Get and NGet full cache line requests to MDs. (M chip 7)",
		.pme_code = 1415,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS@8",
		.pme_desc = "Allocating read, Get and NGet full cache line requests to MDs. (M chip 8)",
		.pme_code = 1416,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS@9",
		.pme_desc = "Allocating read, Get and NGet full cache line requests to MDs. (M chip 9)",
		.pme_code = 1417,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS@10",
		.pme_desc = "Allocating read, Get and NGet full cache line requests to MDs. (M chip 10)",
		.pme_code = 1418,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS@11",
		.pme_desc = "Allocating read, Get and NGet full cache line requests to MDs. (M chip 11)",
		.pme_code = 1419,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS@12",
		.pme_desc = "Allocating read, Get and NGet full cache line requests to MDs. (M chip 12)",
		.pme_code = 1420,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS@13",
		.pme_desc = "Allocating read, Get and NGet full cache line requests to MDs. (M chip 13)",
		.pme_code = 1421,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS@14",
		.pme_desc = "Allocating read, Get and NGet full cache line requests to MDs. (M chip 14)",
		.pme_code = 1422,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS@15",
		.pme_desc = "Allocating read, Get and NGet full cache line requests to MDs. (M chip 15)",
		.pme_code = 1423,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 19 Event 1 */
	{
		.pme_name = "<M:19:1>@0",
		.pme_desc = "<NA>",
		.pme_code = 1424,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:19:1>@1",
		.pme_desc = "<NA>",
		.pme_code = 1425,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:19:1>@2",
		.pme_desc = "<NA>",
		.pme_code = 1426,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:19:1>@3",
		.pme_desc = "<NA>",
		.pme_code = 1427,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:19:1>@4",
		.pme_desc = "<NA>",
		.pme_code = 1428,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:19:1>@5",
		.pme_desc = "<NA>",
		.pme_code = 1429,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:19:1>@6",
		.pme_desc = "<NA>",
		.pme_code = 1430,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:19:1>@7",
		.pme_desc = "<NA>",
		.pme_code = 1431,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:19:1>@8",
		.pme_desc = "<NA>",
		.pme_code = 1432,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:19:1>@9",
		.pme_desc = "<NA>",
		.pme_code = 1433,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:19:1>@10",
		.pme_desc = "<NA>",
		.pme_code = 1434,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:19:1>@11",
		.pme_desc = "<NA>",
		.pme_code = 1435,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:19:1>@12",
		.pme_desc = "<NA>",
		.pme_code = 1436,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:19:1>@13",
		.pme_desc = "<NA>",
		.pme_code = 1437,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:19:1>@14",
		.pme_desc = "<NA>",
		.pme_code = 1438,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:19:1>@15",
		.pme_desc = "<NA>",
		.pme_code = 1439,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 19 Event 2 */
	{
		.pme_name = "MM1_ACCUM_BANK_BUSY@0",
		.pme_desc = "Accumulation of the MM1 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 0)",
		.pme_code = 1440,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ACCUM_BANK_BUSY@1",
		.pme_desc = "Accumulation of the MM1 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 1)",
		.pme_code = 1441,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ACCUM_BANK_BUSY@2",
		.pme_desc = "Accumulation of the MM1 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 2)",
		.pme_code = 1442,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ACCUM_BANK_BUSY@3",
		.pme_desc = "Accumulation of the MM1 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 3)",
		.pme_code = 1443,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ACCUM_BANK_BUSY@4",
		.pme_desc = "Accumulation of the MM1 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 4)",
		.pme_code = 1444,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ACCUM_BANK_BUSY@5",
		.pme_desc = "Accumulation of the MM1 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 5)",
		.pme_code = 1445,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ACCUM_BANK_BUSY@6",
		.pme_desc = "Accumulation of the MM1 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 6)",
		.pme_code = 1446,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ACCUM_BANK_BUSY@7",
		.pme_desc = "Accumulation of the MM1 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 7)",
		.pme_code = 1447,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ACCUM_BANK_BUSY@8",
		.pme_desc = "Accumulation of the MM1 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 8)",
		.pme_code = 1448,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ACCUM_BANK_BUSY@9",
		.pme_desc = "Accumulation of the MM1 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 9)",
		.pme_code = 1449,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ACCUM_BANK_BUSY@10",
		.pme_desc = "Accumulation of the MM1 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 10)",
		.pme_code = 1450,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ACCUM_BANK_BUSY@11",
		.pme_desc = "Accumulation of the MM1 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 11)",
		.pme_code = 1451,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ACCUM_BANK_BUSY@12",
		.pme_desc = "Accumulation of the MM1 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 12)",
		.pme_code = 1452,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ACCUM_BANK_BUSY@13",
		.pme_desc = "Accumulation of the MM1 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 13)",
		.pme_code = 1453,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ACCUM_BANK_BUSY@14",
		.pme_desc = "Accumulation of the MM1 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 14)",
		.pme_code = 1454,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM1_ACCUM_BANK_BUSY@15",
		.pme_desc = "Accumulation of the MM1 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 15)",
		.pme_code = 1455,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 19 Event 3 */
	{
		.pme_name = "W_OUT_BLOCK_CHN_3@0",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to channel back-pressure. (M chip 0)",
		.pme_code = 1456,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_3@1",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to channel back-pressure. (M chip 1)",
		.pme_code = 1457,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_3@2",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to channel back-pressure. (M chip 2)",
		.pme_code = 1458,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_3@3",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to channel back-pressure. (M chip 3)",
		.pme_code = 1459,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_3@4",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to channel back-pressure. (M chip 4)",
		.pme_code = 1460,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_3@5",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to channel back-pressure. (M chip 5)",
		.pme_code = 1461,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_3@6",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to channel back-pressure. (M chip 6)",
		.pme_code = 1462,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_3@7",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to channel back-pressure. (M chip 7)",
		.pme_code = 1463,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_3@8",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to channel back-pressure. (M chip 8)",
		.pme_code = 1464,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_3@9",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to channel back-pressure. (M chip 9)",
		.pme_code = 1465,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_3@10",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to channel back-pressure. (M chip 10)",
		.pme_code = 1466,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_3@11",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to channel back-pressure. (M chip 11)",
		.pme_code = 1467,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_3@12",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to channel back-pressure. (M chip 12)",
		.pme_code = 1468,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_3@13",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to channel back-pressure. (M chip 13)",
		.pme_code = 1469,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_3@14",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to channel back-pressure. (M chip 14)",
		.pme_code = 1470,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_BLOCK_CHN_3@15",
		.pme_desc = "Wclk cycles MD2BW output port 3 is blocked due to channel back-pressure. (M chip 15)",
		.pme_code = 1471,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 19,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 20 Event 0 */
	{
		.pme_name = "REQUESTS_0@0",
		.pme_desc = "Read or write requests from port 0 to MDs. (M chip 0)",
		.pme_code = 1472,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_0@1",
		.pme_desc = "Read or write requests from port 0 to MDs. (M chip 1)",
		.pme_code = 1473,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_0@2",
		.pme_desc = "Read or write requests from port 0 to MDs. (M chip 2)",
		.pme_code = 1474,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_0@3",
		.pme_desc = "Read or write requests from port 0 to MDs. (M chip 3)",
		.pme_code = 1475,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_0@4",
		.pme_desc = "Read or write requests from port 0 to MDs. (M chip 4)",
		.pme_code = 1476,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_0@5",
		.pme_desc = "Read or write requests from port 0 to MDs. (M chip 5)",
		.pme_code = 1477,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_0@6",
		.pme_desc = "Read or write requests from port 0 to MDs. (M chip 6)",
		.pme_code = 1478,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_0@7",
		.pme_desc = "Read or write requests from port 0 to MDs. (M chip 7)",
		.pme_code = 1479,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_0@8",
		.pme_desc = "Read or write requests from port 0 to MDs. (M chip 8)",
		.pme_code = 1480,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_0@9",
		.pme_desc = "Read or write requests from port 0 to MDs. (M chip 9)",
		.pme_code = 1481,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_0@10",
		.pme_desc = "Read or write requests from port 0 to MDs. (M chip 10)",
		.pme_code = 1482,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_0@11",
		.pme_desc = "Read or write requests from port 0 to MDs. (M chip 11)",
		.pme_code = 1483,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_0@12",
		.pme_desc = "Read or write requests from port 0 to MDs. (M chip 12)",
		.pme_code = 1484,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_0@13",
		.pme_desc = "Read or write requests from port 0 to MDs. (M chip 13)",
		.pme_code = 1485,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_0@14",
		.pme_desc = "Read or write requests from port 0 to MDs. (M chip 14)",
		.pme_code = 1486,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_0@15",
		.pme_desc = "Read or write requests from port 0 to MDs. (M chip 15)",
		.pme_code = 1487,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 20 Event 1 */
	{
		.pme_name = "REQUEST_1DWORD_L3_MISS@0",
		.pme_desc = "Single DWord get requests to MDs - L3 miss. (M chip 0)",
		.pme_code = 1488,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_MISS@1",
		.pme_desc = "Single DWord get requests to MDs - L3 miss. (M chip 1)",
		.pme_code = 1489,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_MISS@2",
		.pme_desc = "Single DWord get requests to MDs - L3 miss. (M chip 2)",
		.pme_code = 1490,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_MISS@3",
		.pme_desc = "Single DWord get requests to MDs - L3 miss. (M chip 3)",
		.pme_code = 1491,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_MISS@4",
		.pme_desc = "Single DWord get requests to MDs - L3 miss. (M chip 4)",
		.pme_code = 1492,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_MISS@5",
		.pme_desc = "Single DWord get requests to MDs - L3 miss. (M chip 5)",
		.pme_code = 1493,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_MISS@6",
		.pme_desc = "Single DWord get requests to MDs - L3 miss. (M chip 6)",
		.pme_code = 1494,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_MISS@7",
		.pme_desc = "Single DWord get requests to MDs - L3 miss. (M chip 7)",
		.pme_code = 1495,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_MISS@8",
		.pme_desc = "Single DWord get requests to MDs - L3 miss. (M chip 8)",
		.pme_code = 1496,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_MISS@9",
		.pme_desc = "Single DWord get requests to MDs - L3 miss. (M chip 9)",
		.pme_code = 1497,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_MISS@10",
		.pme_desc = "Single DWord get requests to MDs - L3 miss. (M chip 10)",
		.pme_code = 1498,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_MISS@11",
		.pme_desc = "Single DWord get requests to MDs - L3 miss. (M chip 11)",
		.pme_code = 1499,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_MISS@12",
		.pme_desc = "Single DWord get requests to MDs - L3 miss. (M chip 12)",
		.pme_code = 1500,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_MISS@13",
		.pme_desc = "Single DWord get requests to MDs - L3 miss. (M chip 13)",
		.pme_code = 1501,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_MISS@14",
		.pme_desc = "Single DWord get requests to MDs - L3 miss. (M chip 14)",
		.pme_code = 1502,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1DWORD_L3_MISS@15",
		.pme_desc = "Single DWord get requests to MDs - L3 miss. (M chip 15)",
		.pme_code = 1503,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 20 Event 2 */
	{
		.pme_name = "MM2_ANY_BANK_BUSY@0",
		.pme_desc = "Wclk cycles that any bank is busy in MM2. (M chip 0)",
		.pme_code = 1504,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ANY_BANK_BUSY@1",
		.pme_desc = "Wclk cycles that any bank is busy in MM2. (M chip 1)",
		.pme_code = 1505,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ANY_BANK_BUSY@2",
		.pme_desc = "Wclk cycles that any bank is busy in MM2. (M chip 2)",
		.pme_code = 1506,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ANY_BANK_BUSY@3",
		.pme_desc = "Wclk cycles that any bank is busy in MM2. (M chip 3)",
		.pme_code = 1507,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ANY_BANK_BUSY@4",
		.pme_desc = "Wclk cycles that any bank is busy in MM2. (M chip 4)",
		.pme_code = 1508,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ANY_BANK_BUSY@5",
		.pme_desc = "Wclk cycles that any bank is busy in MM2. (M chip 5)",
		.pme_code = 1509,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ANY_BANK_BUSY@6",
		.pme_desc = "Wclk cycles that any bank is busy in MM2. (M chip 6)",
		.pme_code = 1510,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ANY_BANK_BUSY@7",
		.pme_desc = "Wclk cycles that any bank is busy in MM2. (M chip 7)",
		.pme_code = 1511,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ANY_BANK_BUSY@8",
		.pme_desc = "Wclk cycles that any bank is busy in MM2. (M chip 8)",
		.pme_code = 1512,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ANY_BANK_BUSY@9",
		.pme_desc = "Wclk cycles that any bank is busy in MM2. (M chip 9)",
		.pme_code = 1513,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ANY_BANK_BUSY@10",
		.pme_desc = "Wclk cycles that any bank is busy in MM2. (M chip 10)",
		.pme_code = 1514,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ANY_BANK_BUSY@11",
		.pme_desc = "Wclk cycles that any bank is busy in MM2. (M chip 11)",
		.pme_code = 1515,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ANY_BANK_BUSY@12",
		.pme_desc = "Wclk cycles that any bank is busy in MM2. (M chip 12)",
		.pme_code = 1516,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ANY_BANK_BUSY@13",
		.pme_desc = "Wclk cycles that any bank is busy in MM2. (M chip 13)",
		.pme_code = 1517,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ANY_BANK_BUSY@14",
		.pme_desc = "Wclk cycles that any bank is busy in MM2. (M chip 14)",
		.pme_code = 1518,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ANY_BANK_BUSY@15",
		.pme_desc = "Wclk cycles that any bank is busy in MM2. (M chip 15)",
		.pme_code = 1519,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 20 Event 3 */
	{
		.pme_name = "W_OUT_QUEUE_BP_0@0",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 0 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 0)",
		.pme_code = 1520,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_0@1",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 0 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 1)",
		.pme_code = 1521,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_0@2",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 0 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 2)",
		.pme_code = 1522,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_0@3",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 0 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 3)",
		.pme_code = 1523,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_0@4",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 0 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 4)",
		.pme_code = 1524,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_0@5",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 0 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 5)",
		.pme_code = 1525,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_0@6",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 0 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 6)",
		.pme_code = 1526,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_0@7",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 0 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 7)",
		.pme_code = 1527,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_0@8",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 0 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 8)",
		.pme_code = 1528,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_0@9",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 0 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 9)",
		.pme_code = 1529,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_0@10",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 0 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 10)",
		.pme_code = 1530,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_0@11",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 0 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 11)",
		.pme_code = 1531,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_0@12",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 0 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 12)",
		.pme_code = 1532,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_0@13",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 0 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 13)",
		.pme_code = 1533,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_0@14",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 0 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 14)",
		.pme_code = 1534,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_0@15",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 0 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 15)",
		.pme_code = 1535,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 20,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 21 Event 0 */
	{
		.pme_name = "REQUESTS_1@0",
		.pme_desc = "Read or write requests from port 1 to MDs. (M chip 0)",
		.pme_code = 1536,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_1@1",
		.pme_desc = "Read or write requests from port 1 to MDs. (M chip 1)",
		.pme_code = 1537,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_1@2",
		.pme_desc = "Read or write requests from port 1 to MDs. (M chip 2)",
		.pme_code = 1538,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_1@3",
		.pme_desc = "Read or write requests from port 1 to MDs. (M chip 3)",
		.pme_code = 1539,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_1@4",
		.pme_desc = "Read or write requests from port 1 to MDs. (M chip 4)",
		.pme_code = 1540,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_1@5",
		.pme_desc = "Read or write requests from port 1 to MDs. (M chip 5)",
		.pme_code = 1541,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_1@6",
		.pme_desc = "Read or write requests from port 1 to MDs. (M chip 6)",
		.pme_code = 1542,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_1@7",
		.pme_desc = "Read or write requests from port 1 to MDs. (M chip 7)",
		.pme_code = 1543,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_1@8",
		.pme_desc = "Read or write requests from port 1 to MDs. (M chip 8)",
		.pme_code = 1544,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_1@9",
		.pme_desc = "Read or write requests from port 1 to MDs. (M chip 9)",
		.pme_code = 1545,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_1@10",
		.pme_desc = "Read or write requests from port 1 to MDs. (M chip 10)",
		.pme_code = 1546,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_1@11",
		.pme_desc = "Read or write requests from port 1 to MDs. (M chip 11)",
		.pme_code = 1547,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_1@12",
		.pme_desc = "Read or write requests from port 1 to MDs. (M chip 12)",
		.pme_code = 1548,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_1@13",
		.pme_desc = "Read or write requests from port 1 to MDs. (M chip 13)",
		.pme_code = 1549,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_1@14",
		.pme_desc = "Read or write requests from port 1 to MDs. (M chip 14)",
		.pme_code = 1550,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_1@15",
		.pme_desc = "Read or write requests from port 1 to MDs. (M chip 15)",
		.pme_code = 1551,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 21 Event 1 */
	{
		.pme_name = "REQUEST_4DWORDS_L3_MISS@0",
		.pme_desc = "Allocating read requests to MDs - L3 miss. (M chip 0)",
		.pme_code = 1552,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_MISS@1",
		.pme_desc = "Allocating read requests to MDs - L3 miss. (M chip 1)",
		.pme_code = 1553,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_MISS@2",
		.pme_desc = "Allocating read requests to MDs - L3 miss. (M chip 2)",
		.pme_code = 1554,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_MISS@3",
		.pme_desc = "Allocating read requests to MDs - L3 miss. (M chip 3)",
		.pme_code = 1555,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_MISS@4",
		.pme_desc = "Allocating read requests to MDs - L3 miss. (M chip 4)",
		.pme_code = 1556,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_MISS@5",
		.pme_desc = "Allocating read requests to MDs - L3 miss. (M chip 5)",
		.pme_code = 1557,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_MISS@6",
		.pme_desc = "Allocating read requests to MDs - L3 miss. (M chip 6)",
		.pme_code = 1558,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_MISS@7",
		.pme_desc = "Allocating read requests to MDs - L3 miss. (M chip 7)",
		.pme_code = 1559,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_MISS@8",
		.pme_desc = "Allocating read requests to MDs - L3 miss. (M chip 8)",
		.pme_code = 1560,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_MISS@9",
		.pme_desc = "Allocating read requests to MDs - L3 miss. (M chip 9)",
		.pme_code = 1561,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_MISS@10",
		.pme_desc = "Allocating read requests to MDs - L3 miss. (M chip 10)",
		.pme_code = 1562,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_MISS@11",
		.pme_desc = "Allocating read requests to MDs - L3 miss. (M chip 11)",
		.pme_code = 1563,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_MISS@12",
		.pme_desc = "Allocating read requests to MDs - L3 miss. (M chip 12)",
		.pme_code = 1564,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_MISS@13",
		.pme_desc = "Allocating read requests to MDs - L3 miss. (M chip 13)",
		.pme_code = 1565,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_MISS@14",
		.pme_desc = "Allocating read requests to MDs - L3 miss. (M chip 14)",
		.pme_code = 1566,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_4DWORDS_L3_MISS@15",
		.pme_desc = "Allocating read requests to MDs - L3 miss. (M chip 15)",
		.pme_code = 1567,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 21 Event 2 */
	{
		.pme_name = "MM2_ACCUM_BANK_BUSY@0",
		.pme_desc = "Accumulation of the MM2 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 0)",
		.pme_code = 1568,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ACCUM_BANK_BUSY@1",
		.pme_desc = "Accumulation of the MM2 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 1)",
		.pme_code = 1569,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ACCUM_BANK_BUSY@2",
		.pme_desc = "Accumulation of the MM2 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 2)",
		.pme_code = 1570,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ACCUM_BANK_BUSY@3",
		.pme_desc = "Accumulation of the MM2 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 3)",
		.pme_code = 1571,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ACCUM_BANK_BUSY@4",
		.pme_desc = "Accumulation of the MM2 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 4)",
		.pme_code = 1572,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ACCUM_BANK_BUSY@5",
		.pme_desc = "Accumulation of the MM2 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 5)",
		.pme_code = 1573,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ACCUM_BANK_BUSY@6",
		.pme_desc = "Accumulation of the MM2 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 6)",
		.pme_code = 1574,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ACCUM_BANK_BUSY@7",
		.pme_desc = "Accumulation of the MM2 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 7)",
		.pme_code = 1575,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ACCUM_BANK_BUSY@8",
		.pme_desc = "Accumulation of the MM2 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 8)",
		.pme_code = 1576,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ACCUM_BANK_BUSY@9",
		.pme_desc = "Accumulation of the MM2 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 9)",
		.pme_code = 1577,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ACCUM_BANK_BUSY@10",
		.pme_desc = "Accumulation of the MM2 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 10)",
		.pme_code = 1578,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ACCUM_BANK_BUSY@11",
		.pme_desc = "Accumulation of the MM2 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 11)",
		.pme_code = 1579,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ACCUM_BANK_BUSY@12",
		.pme_desc = "Accumulation of the MM2 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 12)",
		.pme_code = 1580,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ACCUM_BANK_BUSY@13",
		.pme_desc = "Accumulation of the MM2 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 13)",
		.pme_code = 1581,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ACCUM_BANK_BUSY@14",
		.pme_desc = "Accumulation of the MM2 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 14)",
		.pme_code = 1582,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM2_ACCUM_BANK_BUSY@15",
		.pme_desc = "Accumulation of the MM2 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 15)",
		.pme_code = 1583,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 21 Event 3 */
	{
		.pme_name = "W_OUT_QUEUE_BP_1@0",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 1 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 0)",
		.pme_code = 1584,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_1@1",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 1 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 1)",
		.pme_code = 1585,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_1@2",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 1 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 2)",
		.pme_code = 1586,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_1@3",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 1 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 3)",
		.pme_code = 1587,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_1@4",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 1 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 4)",
		.pme_code = 1588,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_1@5",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 1 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 5)",
		.pme_code = 1589,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_1@6",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 1 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 6)",
		.pme_code = 1590,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_1@7",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 1 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 7)",
		.pme_code = 1591,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_1@8",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 1 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 8)",
		.pme_code = 1592,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_1@9",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 1 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 9)",
		.pme_code = 1593,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_1@10",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 1 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 10)",
		.pme_code = 1594,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_1@11",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 1 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 11)",
		.pme_code = 1595,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_1@12",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 1 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 12)",
		.pme_code = 1596,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_1@13",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 1 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 13)",
		.pme_code = 1597,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_1@14",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 1 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 14)",
		.pme_code = 1598,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_1@15",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 1 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 15)",
		.pme_code = 1599,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 21,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 22 Event 0 */
	{
		.pme_name = "REQUESTS_2@0",
		.pme_desc = "Read or write requests from port 2 to MDs. (M chip 0)",
		.pme_code = 1600,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_2@1",
		.pme_desc = "Read or write requests from port 2 to MDs. (M chip 1)",
		.pme_code = 1601,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_2@2",
		.pme_desc = "Read or write requests from port 2 to MDs. (M chip 2)",
		.pme_code = 1602,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_2@3",
		.pme_desc = "Read or write requests from port 2 to MDs. (M chip 3)",
		.pme_code = 1603,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_2@4",
		.pme_desc = "Read or write requests from port 2 to MDs. (M chip 4)",
		.pme_code = 1604,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_2@5",
		.pme_desc = "Read or write requests from port 2 to MDs. (M chip 5)",
		.pme_code = 1605,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_2@6",
		.pme_desc = "Read or write requests from port 2 to MDs. (M chip 6)",
		.pme_code = 1606,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_2@7",
		.pme_desc = "Read or write requests from port 2 to MDs. (M chip 7)",
		.pme_code = 1607,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_2@8",
		.pme_desc = "Read or write requests from port 2 to MDs. (M chip 8)",
		.pme_code = 1608,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_2@9",
		.pme_desc = "Read or write requests from port 2 to MDs. (M chip 9)",
		.pme_code = 1609,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_2@10",
		.pme_desc = "Read or write requests from port 2 to MDs. (M chip 10)",
		.pme_code = 1610,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_2@11",
		.pme_desc = "Read or write requests from port 2 to MDs. (M chip 11)",
		.pme_code = 1611,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_2@12",
		.pme_desc = "Read or write requests from port 2 to MDs. (M chip 12)",
		.pme_code = 1612,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_2@13",
		.pme_desc = "Read or write requests from port 2 to MDs. (M chip 13)",
		.pme_code = 1613,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_2@14",
		.pme_desc = "Read or write requests from port 2 to MDs. (M chip 14)",
		.pme_code = 1614,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_2@15",
		.pme_desc = "Read or write requests from port 2 to MDs. (M chip 15)",
		.pme_code = 1615,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 22 Event 1 */
	{
		.pme_name = "REQUEST_1SWORD@0",
		.pme_desc = "Single SWord requests to MDs. (M chip 0)",
		.pme_code = 1616,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1SWORD@1",
		.pme_desc = "Single SWord requests to MDs. (M chip 1)",
		.pme_code = 1617,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1SWORD@2",
		.pme_desc = "Single SWord requests to MDs. (M chip 2)",
		.pme_code = 1618,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1SWORD@3",
		.pme_desc = "Single SWord requests to MDs. (M chip 3)",
		.pme_code = 1619,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1SWORD@4",
		.pme_desc = "Single SWord requests to MDs. (M chip 4)",
		.pme_code = 1620,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1SWORD@5",
		.pme_desc = "Single SWord requests to MDs. (M chip 5)",
		.pme_code = 1621,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1SWORD@6",
		.pme_desc = "Single SWord requests to MDs. (M chip 6)",
		.pme_code = 1622,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1SWORD@7",
		.pme_desc = "Single SWord requests to MDs. (M chip 7)",
		.pme_code = 1623,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1SWORD@8",
		.pme_desc = "Single SWord requests to MDs. (M chip 8)",
		.pme_code = 1624,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1SWORD@9",
		.pme_desc = "Single SWord requests to MDs. (M chip 9)",
		.pme_code = 1625,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1SWORD@10",
		.pme_desc = "Single SWord requests to MDs. (M chip 10)",
		.pme_code = 1626,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1SWORD@11",
		.pme_desc = "Single SWord requests to MDs. (M chip 11)",
		.pme_code = 1627,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1SWORD@12",
		.pme_desc = "Single SWord requests to MDs. (M chip 12)",
		.pme_code = 1628,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1SWORD@13",
		.pme_desc = "Single SWord requests to MDs. (M chip 13)",
		.pme_code = 1629,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1SWORD@14",
		.pme_desc = "Single SWord requests to MDs. (M chip 14)",
		.pme_code = 1630,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUEST_1SWORD@15",
		.pme_desc = "Single SWord requests to MDs. (M chip 15)",
		.pme_code = 1631,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 22 Event 2 */
	{
		.pme_name = "MM3_ANY_BANK_BUSY@0",
		.pme_desc = "Wclk cycles that any bank is busy in MM3. (M chip 0)",
		.pme_code = 1632,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ANY_BANK_BUSY@1",
		.pme_desc = "Wclk cycles that any bank is busy in MM3. (M chip 1)",
		.pme_code = 1633,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ANY_BANK_BUSY@2",
		.pme_desc = "Wclk cycles that any bank is busy in MM3. (M chip 2)",
		.pme_code = 1634,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ANY_BANK_BUSY@3",
		.pme_desc = "Wclk cycles that any bank is busy in MM3. (M chip 3)",
		.pme_code = 1635,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ANY_BANK_BUSY@4",
		.pme_desc = "Wclk cycles that any bank is busy in MM3. (M chip 4)",
		.pme_code = 1636,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ANY_BANK_BUSY@5",
		.pme_desc = "Wclk cycles that any bank is busy in MM3. (M chip 5)",
		.pme_code = 1637,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ANY_BANK_BUSY@6",
		.pme_desc = "Wclk cycles that any bank is busy in MM3. (M chip 6)",
		.pme_code = 1638,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ANY_BANK_BUSY@7",
		.pme_desc = "Wclk cycles that any bank is busy in MM3. (M chip 7)",
		.pme_code = 1639,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ANY_BANK_BUSY@8",
		.pme_desc = "Wclk cycles that any bank is busy in MM3. (M chip 8)",
		.pme_code = 1640,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ANY_BANK_BUSY@9",
		.pme_desc = "Wclk cycles that any bank is busy in MM3. (M chip 9)",
		.pme_code = 1641,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ANY_BANK_BUSY@10",
		.pme_desc = "Wclk cycles that any bank is busy in MM3. (M chip 10)",
		.pme_code = 1642,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ANY_BANK_BUSY@11",
		.pme_desc = "Wclk cycles that any bank is busy in MM3. (M chip 11)",
		.pme_code = 1643,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ANY_BANK_BUSY@12",
		.pme_desc = "Wclk cycles that any bank is busy in MM3. (M chip 12)",
		.pme_code = 1644,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ANY_BANK_BUSY@13",
		.pme_desc = "Wclk cycles that any bank is busy in MM3. (M chip 13)",
		.pme_code = 1645,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ANY_BANK_BUSY@14",
		.pme_desc = "Wclk cycles that any bank is busy in MM3. (M chip 14)",
		.pme_code = 1646,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ANY_BANK_BUSY@15",
		.pme_desc = "Wclk cycles that any bank is busy in MM3. (M chip 15)",
		.pme_code = 1647,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 22 Event 3 */
	{
		.pme_name = "W_OUT_QUEUE_BP_2@0",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 2 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 0)",
		.pme_code = 1648,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_2@1",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 2 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 1)",
		.pme_code = 1649,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_2@2",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 2 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 2)",
		.pme_code = 1650,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_2@3",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 2 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 3)",
		.pme_code = 1651,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_2@4",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 2 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 4)",
		.pme_code = 1652,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_2@5",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 2 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 5)",
		.pme_code = 1653,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_2@6",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 2 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 6)",
		.pme_code = 1654,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_2@7",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 2 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 7)",
		.pme_code = 1655,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_2@8",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 2 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 8)",
		.pme_code = 1656,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_2@9",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 2 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 9)",
		.pme_code = 1657,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_2@10",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 2 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 10)",
		.pme_code = 1658,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_2@11",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 2 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 11)",
		.pme_code = 1659,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_2@12",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 2 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 12)",
		.pme_code = 1660,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_2@13",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 2 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 13)",
		.pme_code = 1661,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_2@14",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 2 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 14)",
		.pme_code = 1662,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_2@15",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 2 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 15)",
		.pme_code = 1663,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 22,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 23 Event 0 */
	{
		.pme_name = "REQUESTS_3@0",
		.pme_desc = "Read or write requests from port 3 to MDs. (M chip 0)",
		.pme_code = 1664,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_3@1",
		.pme_desc = "Read or write requests from port 3 to MDs. (M chip 1)",
		.pme_code = 1665,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_3@2",
		.pme_desc = "Read or write requests from port 3 to MDs. (M chip 2)",
		.pme_code = 1666,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_3@3",
		.pme_desc = "Read or write requests from port 3 to MDs. (M chip 3)",
		.pme_code = 1667,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_3@4",
		.pme_desc = "Read or write requests from port 3 to MDs. (M chip 4)",
		.pme_code = 1668,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_3@5",
		.pme_desc = "Read or write requests from port 3 to MDs. (M chip 5)",
		.pme_code = 1669,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_3@6",
		.pme_desc = "Read or write requests from port 3 to MDs. (M chip 6)",
		.pme_code = 1670,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_3@7",
		.pme_desc = "Read or write requests from port 3 to MDs. (M chip 7)",
		.pme_code = 1671,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_3@8",
		.pme_desc = "Read or write requests from port 3 to MDs. (M chip 8)",
		.pme_code = 1672,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_3@9",
		.pme_desc = "Read or write requests from port 3 to MDs. (M chip 9)",
		.pme_code = 1673,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_3@10",
		.pme_desc = "Read or write requests from port 3 to MDs. (M chip 10)",
		.pme_code = 1674,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_3@11",
		.pme_desc = "Read or write requests from port 3 to MDs. (M chip 11)",
		.pme_code = 1675,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_3@12",
		.pme_desc = "Read or write requests from port 3 to MDs. (M chip 12)",
		.pme_code = 1676,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_3@13",
		.pme_desc = "Read or write requests from port 3 to MDs. (M chip 13)",
		.pme_code = 1677,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_3@14",
		.pme_desc = "Read or write requests from port 3 to MDs. (M chip 14)",
		.pme_code = 1678,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "REQUESTS_3@15",
		.pme_desc = "Read or write requests from port 3 to MDs. (M chip 15)",
		.pme_code = 1679,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 23 Event 1 */
	{
		.pme_name = "<M:23:1>@0",
		.pme_desc = "<NA>",
		.pme_code = 1680,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:23:1>@1",
		.pme_desc = "<NA>",
		.pme_code = 1681,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:23:1>@2",
		.pme_desc = "<NA>",
		.pme_code = 1682,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:23:1>@3",
		.pme_desc = "<NA>",
		.pme_code = 1683,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:23:1>@4",
		.pme_desc = "<NA>",
		.pme_code = 1684,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:23:1>@5",
		.pme_desc = "<NA>",
		.pme_code = 1685,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:23:1>@6",
		.pme_desc = "<NA>",
		.pme_code = 1686,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:23:1>@7",
		.pme_desc = "<NA>",
		.pme_code = 1687,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:23:1>@8",
		.pme_desc = "<NA>",
		.pme_code = 1688,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:23:1>@9",
		.pme_desc = "<NA>",
		.pme_code = 1689,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:23:1>@10",
		.pme_desc = "<NA>",
		.pme_code = 1690,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:23:1>@11",
		.pme_desc = "<NA>",
		.pme_code = 1691,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:23:1>@12",
		.pme_desc = "<NA>",
		.pme_code = 1692,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:23:1>@13",
		.pme_desc = "<NA>",
		.pme_code = 1693,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:23:1>@14",
		.pme_desc = "<NA>",
		.pme_code = 1694,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:23:1>@15",
		.pme_desc = "<NA>",
		.pme_code = 1695,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 23 Event 2 */
	{
		.pme_name = "MM3_ACCUM_BANK_BUSY@0",
		.pme_desc = "Accumulation of the MM3 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 0)",
		.pme_code = 1696,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ACCUM_BANK_BUSY@1",
		.pme_desc = "Accumulation of the MM3 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 1)",
		.pme_code = 1697,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ACCUM_BANK_BUSY@2",
		.pme_desc = "Accumulation of the MM3 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 2)",
		.pme_code = 1698,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ACCUM_BANK_BUSY@3",
		.pme_desc = "Accumulation of the MM3 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 3)",
		.pme_code = 1699,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ACCUM_BANK_BUSY@4",
		.pme_desc = "Accumulation of the MM3 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 4)",
		.pme_code = 1700,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ACCUM_BANK_BUSY@5",
		.pme_desc = "Accumulation of the MM3 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 5)",
		.pme_code = 1701,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ACCUM_BANK_BUSY@6",
		.pme_desc = "Accumulation of the MM3 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 6)",
		.pme_code = 1702,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ACCUM_BANK_BUSY@7",
		.pme_desc = "Accumulation of the MM3 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 7)",
		.pme_code = 1703,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ACCUM_BANK_BUSY@8",
		.pme_desc = "Accumulation of the MM3 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 8)",
		.pme_code = 1704,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ACCUM_BANK_BUSY@9",
		.pme_desc = "Accumulation of the MM3 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 9)",
		.pme_code = 1705,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ACCUM_BANK_BUSY@10",
		.pme_desc = "Accumulation of the MM3 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 10)",
		.pme_code = 1706,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ACCUM_BANK_BUSY@11",
		.pme_desc = "Accumulation of the MM3 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 11)",
		.pme_code = 1707,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ACCUM_BANK_BUSY@12",
		.pme_desc = "Accumulation of the MM3 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 12)",
		.pme_code = 1708,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ACCUM_BANK_BUSY@13",
		.pme_desc = "Accumulation of the MM3 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 13)",
		.pme_code = 1709,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ACCUM_BANK_BUSY@14",
		.pme_desc = "Accumulation of the MM3 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 14)",
		.pme_code = 1710,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "MM3_ACCUM_BANK_BUSY@15",
		.pme_desc = "Accumulation of the MM3 memory banks are busy in Mclks. There are 8 banks per MM and this counter will be +1 every Mclk that 1 bank is busy, +2 every Mclk that 2 banks are busy, etc. (M chip 15)",
		.pme_code = 1711,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 23 Event 3 */
	{
		.pme_name = "W_OUT_QUEUE_BP_3@0",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 3 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 0)",
		.pme_code = 1712,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_3@1",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 3 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 1)",
		.pme_code = 1713,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_3@2",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 3 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 2)",
		.pme_code = 1714,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_3@3",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 3 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 3)",
		.pme_code = 1715,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_3@4",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 3 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 4)",
		.pme_code = 1716,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_3@5",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 3 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 5)",
		.pme_code = 1717,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_3@6",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 3 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 6)",
		.pme_code = 1718,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_3@7",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 3 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 7)",
		.pme_code = 1719,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_3@8",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 3 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 8)",
		.pme_code = 1720,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_3@9",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 3 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 9)",
		.pme_code = 1721,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_3@10",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 3 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 10)",
		.pme_code = 1722,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_3@11",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 3 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 11)",
		.pme_code = 1723,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_3@12",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 3 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 12)",
		.pme_code = 1724,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_3@13",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 3 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 13)",
		.pme_code = 1725,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_3@14",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 3 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 14)",
		.pme_code = 1726,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_OUT_QUEUE_BP_3@15",
		.pme_desc = "One of the input FIFOs that is destined for MD2BW output port 3 is full and asserting back-pressure to the MD (Wclk cycles). (M chip 15)",
		.pme_code = 1727,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 23,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 24 Event 0 */
	{
		.pme_name = "W_SWORD_PUTS@0",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with Put commands. Counts up to 2 SWords per memory directory per clock period. (M chip 0)",
		.pme_code = 1728,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_PUTS@1",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with Put commands. Counts up to 2 SWords per memory directory per clock period. (M chip 1)",
		.pme_code = 1729,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_PUTS@2",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with Put commands. Counts up to 2 SWords per memory directory per clock period. (M chip 2)",
		.pme_code = 1730,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_PUTS@3",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with Put commands. Counts up to 2 SWords per memory directory per clock period. (M chip 3)",
		.pme_code = 1731,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_PUTS@4",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with Put commands. Counts up to 2 SWords per memory directory per clock period. (M chip 4)",
		.pme_code = 1732,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_PUTS@5",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with Put commands. Counts up to 2 SWords per memory directory per clock period. (M chip 5)",
		.pme_code = 1733,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_PUTS@6",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with Put commands. Counts up to 2 SWords per memory directory per clock period. (M chip 6)",
		.pme_code = 1734,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_PUTS@7",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with Put commands. Counts up to 2 SWords per memory directory per clock period. (M chip 7)",
		.pme_code = 1735,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_PUTS@8",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with Put commands. Counts up to 2 SWords per memory directory per clock period. (M chip 8)",
		.pme_code = 1736,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_PUTS@9",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with Put commands. Counts up to 2 SWords per memory directory per clock period. (M chip 9)",
		.pme_code = 1737,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_PUTS@10",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with Put commands. Counts up to 2 SWords per memory directory per clock period. (M chip 10)",
		.pme_code = 1738,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_PUTS@11",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with Put commands. Counts up to 2 SWords per memory directory per clock period. (M chip 11)",
		.pme_code = 1739,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_PUTS@12",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with Put commands. Counts up to 2 SWords per memory directory per clock period. (M chip 12)",
		.pme_code = 1740,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_PUTS@13",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with Put commands. Counts up to 2 SWords per memory directory per clock period. (M chip 13)",
		.pme_code = 1741,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_PUTS@14",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with Put commands. Counts up to 2 SWords per memory directory per clock period. (M chip 14)",
		.pme_code = 1742,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_PUTS@15",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with Put commands. Counts up to 2 SWords per memory directory per clock period. (M chip 15)",
		.pme_code = 1743,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 24 Event 1 */
	{
		.pme_name = "<M:24:1>@0",
		.pme_desc = "<NA>",
		.pme_code = 1744,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:1>@1",
		.pme_desc = "<NA>",
		.pme_code = 1745,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:1>@2",
		.pme_desc = "<NA>",
		.pme_code = 1746,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:1>@3",
		.pme_desc = "<NA>",
		.pme_code = 1747,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:1>@4",
		.pme_desc = "<NA>",
		.pme_code = 1748,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:1>@5",
		.pme_desc = "<NA>",
		.pme_code = 1749,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:1>@6",
		.pme_desc = "<NA>",
		.pme_code = 1750,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:1>@7",
		.pme_desc = "<NA>",
		.pme_code = 1751,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:1>@8",
		.pme_desc = "<NA>",
		.pme_code = 1752,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:1>@9",
		.pme_desc = "<NA>",
		.pme_code = 1753,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:1>@10",
		.pme_desc = "<NA>",
		.pme_code = 1754,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:1>@11",
		.pme_desc = "<NA>",
		.pme_code = 1755,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:1>@12",
		.pme_desc = "<NA>",
		.pme_code = 1756,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:1>@13",
		.pme_desc = "<NA>",
		.pme_code = 1757,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:1>@14",
		.pme_desc = "<NA>",
		.pme_code = 1758,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:1>@15",
		.pme_desc = "<NA>",
		.pme_code = 1759,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 24 Event 2 */
	{
		.pme_name = "<M:24:2>@0",
		.pme_desc = "<NA>",
		.pme_code = 1760,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:2>@1",
		.pme_desc = "<NA>",
		.pme_code = 1761,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:2>@2",
		.pme_desc = "<NA>",
		.pme_code = 1762,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:2>@3",
		.pme_desc = "<NA>",
		.pme_code = 1763,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:2>@4",
		.pme_desc = "<NA>",
		.pme_code = 1764,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:2>@5",
		.pme_desc = "<NA>",
		.pme_code = 1765,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:2>@6",
		.pme_desc = "<NA>",
		.pme_code = 1766,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:2>@7",
		.pme_desc = "<NA>",
		.pme_code = 1767,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:2>@8",
		.pme_desc = "<NA>",
		.pme_code = 1768,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:2>@9",
		.pme_desc = "<NA>",
		.pme_code = 1769,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:2>@10",
		.pme_desc = "<NA>",
		.pme_code = 1770,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:2>@11",
		.pme_desc = "<NA>",
		.pme_code = 1771,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:2>@12",
		.pme_desc = "<NA>",
		.pme_code = 1772,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:2>@13",
		.pme_desc = "<NA>",
		.pme_code = 1773,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:2>@14",
		.pme_desc = "<NA>",
		.pme_code = 1774,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:2>@15",
		.pme_desc = "<NA>",
		.pme_code = 1775,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 24 Event 3 */
	{
		.pme_name = "<M:24:3>@0",
		.pme_desc = "<NA>",
		.pme_code = 1776,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:3>@1",
		.pme_desc = "<NA>",
		.pme_code = 1777,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:3>@2",
		.pme_desc = "<NA>",
		.pme_code = 1778,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:3>@3",
		.pme_desc = "<NA>",
		.pme_code = 1779,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:3>@4",
		.pme_desc = "<NA>",
		.pme_code = 1780,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:3>@5",
		.pme_desc = "<NA>",
		.pme_code = 1781,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:3>@6",
		.pme_desc = "<NA>",
		.pme_code = 1782,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:3>@7",
		.pme_desc = "<NA>",
		.pme_code = 1783,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:3>@8",
		.pme_desc = "<NA>",
		.pme_code = 1784,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:3>@9",
		.pme_desc = "<NA>",
		.pme_code = 1785,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:3>@10",
		.pme_desc = "<NA>",
		.pme_code = 1786,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:3>@11",
		.pme_desc = "<NA>",
		.pme_code = 1787,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:3>@12",
		.pme_desc = "<NA>",
		.pme_code = 1788,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:3>@13",
		.pme_desc = "<NA>",
		.pme_code = 1789,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:3>@14",
		.pme_desc = "<NA>",
		.pme_code = 1790,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:24:3>@15",
		.pme_desc = "<NA>",
		.pme_code = 1791,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 24,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 25 Event 0 */
	{
		.pme_name = "W_SWORD_NPUTS@0",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with NPut commands. Counts up to 2 SWords per memory directory per clock period. (M chip 0)",
		.pme_code = 1792,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NPUTS@1",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with NPut commands. Counts up to 2 SWords per memory directory per clock period. (M chip 1)",
		.pme_code = 1793,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NPUTS@2",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with NPut commands. Counts up to 2 SWords per memory directory per clock period. (M chip 2)",
		.pme_code = 1794,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NPUTS@3",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with NPut commands. Counts up to 2 SWords per memory directory per clock period. (M chip 3)",
		.pme_code = 1795,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NPUTS@4",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with NPut commands. Counts up to 2 SWords per memory directory per clock period. (M chip 4)",
		.pme_code = 1796,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NPUTS@5",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with NPut commands. Counts up to 2 SWords per memory directory per clock period. (M chip 5)",
		.pme_code = 1797,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NPUTS@6",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with NPut commands. Counts up to 2 SWords per memory directory per clock period. (M chip 6)",
		.pme_code = 1798,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NPUTS@7",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with NPut commands. Counts up to 2 SWords per memory directory per clock period. (M chip 7)",
		.pme_code = 1799,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NPUTS@8",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with NPut commands. Counts up to 2 SWords per memory directory per clock period. (M chip 8)",
		.pme_code = 1800,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NPUTS@9",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with NPut commands. Counts up to 2 SWords per memory directory per clock period. (M chip 9)",
		.pme_code = 1801,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NPUTS@10",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with NPut commands. Counts up to 2 SWords per memory directory per clock period. (M chip 10)",
		.pme_code = 1802,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NPUTS@11",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with NPut commands. Counts up to 2 SWords per memory directory per clock period. (M chip 11)",
		.pme_code = 1803,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NPUTS@12",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with NPut commands. Counts up to 2 SWords per memory directory per clock period. (M chip 12)",
		.pme_code = 1804,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NPUTS@13",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with NPut commands. Counts up to 2 SWords per memory directory per clock period. (M chip 13)",
		.pme_code = 1805,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NPUTS@14",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with NPut commands. Counts up to 2 SWords per memory directory per clock period. (M chip 14)",
		.pme_code = 1806,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NPUTS@15",
		.pme_desc = "Count of the total number of SWords that are written to memory or the L3 cache with NPut commands. Counts up to 2 SWords per memory directory per clock period. (M chip 15)",
		.pme_code = 1807,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 25 Event 1 */
	{
		.pme_name = "<M:25:1>@0",
		.pme_desc = "<NA>",
		.pme_code = 1808,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:1>@1",
		.pme_desc = "<NA>",
		.pme_code = 1809,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:1>@2",
		.pme_desc = "<NA>",
		.pme_code = 1810,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:1>@3",
		.pme_desc = "<NA>",
		.pme_code = 1811,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:1>@4",
		.pme_desc = "<NA>",
		.pme_code = 1812,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:1>@5",
		.pme_desc = "<NA>",
		.pme_code = 1813,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:1>@6",
		.pme_desc = "<NA>",
		.pme_code = 1814,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:1>@7",
		.pme_desc = "<NA>",
		.pme_code = 1815,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:1>@8",
		.pme_desc = "<NA>",
		.pme_code = 1816,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:1>@9",
		.pme_desc = "<NA>",
		.pme_code = 1817,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:1>@10",
		.pme_desc = "<NA>",
		.pme_code = 1818,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:1>@11",
		.pme_desc = "<NA>",
		.pme_code = 1819,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:1>@12",
		.pme_desc = "<NA>",
		.pme_code = 1820,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:1>@13",
		.pme_desc = "<NA>",
		.pme_code = 1821,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:1>@14",
		.pme_desc = "<NA>",
		.pme_code = 1822,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:1>@15",
		.pme_desc = "<NA>",
		.pme_code = 1823,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 25 Event 2 */
	{
		.pme_name = "<M:25:2>@0",
		.pme_desc = "<NA>",
		.pme_code = 1824,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:2>@1",
		.pme_desc = "<NA>",
		.pme_code = 1825,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:2>@2",
		.pme_desc = "<NA>",
		.pme_code = 1826,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:2>@3",
		.pme_desc = "<NA>",
		.pme_code = 1827,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:2>@4",
		.pme_desc = "<NA>",
		.pme_code = 1828,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:2>@5",
		.pme_desc = "<NA>",
		.pme_code = 1829,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:2>@6",
		.pme_desc = "<NA>",
		.pme_code = 1830,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:2>@7",
		.pme_desc = "<NA>",
		.pme_code = 1831,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:2>@8",
		.pme_desc = "<NA>",
		.pme_code = 1832,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:2>@9",
		.pme_desc = "<NA>",
		.pme_code = 1833,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:2>@10",
		.pme_desc = "<NA>",
		.pme_code = 1834,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:2>@11",
		.pme_desc = "<NA>",
		.pme_code = 1835,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:2>@12",
		.pme_desc = "<NA>",
		.pme_code = 1836,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:2>@13",
		.pme_desc = "<NA>",
		.pme_code = 1837,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:2>@14",
		.pme_desc = "<NA>",
		.pme_code = 1838,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:2>@15",
		.pme_desc = "<NA>",
		.pme_code = 1839,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 25 Event 3 */
	{
		.pme_name = "<M:25:3>@0",
		.pme_desc = "<NA>",
		.pme_code = 1840,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:3>@1",
		.pme_desc = "<NA>",
		.pme_code = 1841,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:3>@2",
		.pme_desc = "<NA>",
		.pme_code = 1842,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:3>@3",
		.pme_desc = "<NA>",
		.pme_code = 1843,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:3>@4",
		.pme_desc = "<NA>",
		.pme_code = 1844,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:3>@5",
		.pme_desc = "<NA>",
		.pme_code = 1845,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:3>@6",
		.pme_desc = "<NA>",
		.pme_code = 1846,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:3>@7",
		.pme_desc = "<NA>",
		.pme_code = 1847,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:3>@8",
		.pme_desc = "<NA>",
		.pme_code = 1848,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:3>@9",
		.pme_desc = "<NA>",
		.pme_code = 1849,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:3>@10",
		.pme_desc = "<NA>",
		.pme_code = 1850,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:3>@11",
		.pme_desc = "<NA>",
		.pme_code = 1851,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:3>@12",
		.pme_desc = "<NA>",
		.pme_code = 1852,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:3>@13",
		.pme_desc = "<NA>",
		.pme_code = 1853,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:3>@14",
		.pme_desc = "<NA>",
		.pme_code = 1854,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:25:3>@15",
		.pme_desc = "<NA>",
		.pme_code = 1855,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 25,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 26 Event 0 */
	{
		.pme_name = "W_SWORD_GETS@0",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with Get commands. Counts up to 2 SWords per memory directory per clock period. (M chip 0)",
		.pme_code = 1856,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_GETS@1",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with Get commands. Counts up to 2 SWords per memory directory per clock period. (M chip 1)",
		.pme_code = 1857,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_GETS@2",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with Get commands. Counts up to 2 SWords per memory directory per clock period. (M chip 2)",
		.pme_code = 1858,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_GETS@3",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with Get commands. Counts up to 2 SWords per memory directory per clock period. (M chip 3)",
		.pme_code = 1859,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_GETS@4",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with Get commands. Counts up to 2 SWords per memory directory per clock period. (M chip 4)",
		.pme_code = 1860,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_GETS@5",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with Get commands. Counts up to 2 SWords per memory directory per clock period. (M chip 5)",
		.pme_code = 1861,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_GETS@6",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with Get commands. Counts up to 2 SWords per memory directory per clock period. (M chip 6)",
		.pme_code = 1862,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_GETS@7",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with Get commands. Counts up to 2 SWords per memory directory per clock period. (M chip 7)",
		.pme_code = 1863,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_GETS@8",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with Get commands. Counts up to 2 SWords per memory directory per clock period. (M chip 8)",
		.pme_code = 1864,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_GETS@9",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with Get commands. Counts up to 2 SWords per memory directory per clock period. (M chip 9)",
		.pme_code = 1865,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_GETS@10",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with Get commands. Counts up to 2 SWords per memory directory per clock period. (M chip 10)",
		.pme_code = 1866,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_GETS@11",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with Get commands. Counts up to 2 SWords per memory directory per clock period. (M chip 11)",
		.pme_code = 1867,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_GETS@12",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with Get commands. Counts up to 2 SWords per memory directory per clock period. (M chip 12)",
		.pme_code = 1868,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_GETS@13",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with Get commands. Counts up to 2 SWords per memory directory per clock period. (M chip 13)",
		.pme_code = 1869,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_GETS@14",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with Get commands. Counts up to 2 SWords per memory directory per clock period. (M chip 14)",
		.pme_code = 1870,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_GETS@15",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with Get commands. Counts up to 2 SWords per memory directory per clock period. (M chip 15)",
		.pme_code = 1871,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 26 Event 1 */
	{
		.pme_name = "<M:26:1>@0",
		.pme_desc = "<NA>",
		.pme_code = 1872,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:1>@1",
		.pme_desc = "<NA>",
		.pme_code = 1873,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:1>@2",
		.pme_desc = "<NA>",
		.pme_code = 1874,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:1>@3",
		.pme_desc = "<NA>",
		.pme_code = 1875,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:1>@4",
		.pme_desc = "<NA>",
		.pme_code = 1876,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:1>@5",
		.pme_desc = "<NA>",
		.pme_code = 1877,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:1>@6",
		.pme_desc = "<NA>",
		.pme_code = 1878,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:1>@7",
		.pme_desc = "<NA>",
		.pme_code = 1879,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:1>@8",
		.pme_desc = "<NA>",
		.pme_code = 1880,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:1>@9",
		.pme_desc = "<NA>",
		.pme_code = 1881,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:1>@10",
		.pme_desc = "<NA>",
		.pme_code = 1882,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:1>@11",
		.pme_desc = "<NA>",
		.pme_code = 1883,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:1>@12",
		.pme_desc = "<NA>",
		.pme_code = 1884,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:1>@13",
		.pme_desc = "<NA>",
		.pme_code = 1885,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:1>@14",
		.pme_desc = "<NA>",
		.pme_code = 1886,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:1>@15",
		.pme_desc = "<NA>",
		.pme_code = 1887,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 26 Event 2 */
	{
		.pme_name = "<M:26:2>@0",
		.pme_desc = "<NA>",
		.pme_code = 1888,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:2>@1",
		.pme_desc = "<NA>",
		.pme_code = 1889,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:2>@2",
		.pme_desc = "<NA>",
		.pme_code = 1890,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:2>@3",
		.pme_desc = "<NA>",
		.pme_code = 1891,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:2>@4",
		.pme_desc = "<NA>",
		.pme_code = 1892,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:2>@5",
		.pme_desc = "<NA>",
		.pme_code = 1893,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:2>@6",
		.pme_desc = "<NA>",
		.pme_code = 1894,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:2>@7",
		.pme_desc = "<NA>",
		.pme_code = 1895,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:2>@8",
		.pme_desc = "<NA>",
		.pme_code = 1896,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:2>@9",
		.pme_desc = "<NA>",
		.pme_code = 1897,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:2>@10",
		.pme_desc = "<NA>",
		.pme_code = 1898,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:2>@11",
		.pme_desc = "<NA>",
		.pme_code = 1899,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:2>@12",
		.pme_desc = "<NA>",
		.pme_code = 1900,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:2>@13",
		.pme_desc = "<NA>",
		.pme_code = 1901,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:2>@14",
		.pme_desc = "<NA>",
		.pme_code = 1902,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:2>@15",
		.pme_desc = "<NA>",
		.pme_code = 1903,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 26 Event 3 */
	{
		.pme_name = "<M:26:3>@0",
		.pme_desc = "<NA>",
		.pme_code = 1904,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:3>@1",
		.pme_desc = "<NA>",
		.pme_code = 1905,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:3>@2",
		.pme_desc = "<NA>",
		.pme_code = 1906,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:3>@3",
		.pme_desc = "<NA>",
		.pme_code = 1907,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:3>@4",
		.pme_desc = "<NA>",
		.pme_code = 1908,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:3>@5",
		.pme_desc = "<NA>",
		.pme_code = 1909,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:3>@6",
		.pme_desc = "<NA>",
		.pme_code = 1910,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:3>@7",
		.pme_desc = "<NA>",
		.pme_code = 1911,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:3>@8",
		.pme_desc = "<NA>",
		.pme_code = 1912,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:3>@9",
		.pme_desc = "<NA>",
		.pme_code = 1913,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:3>@10",
		.pme_desc = "<NA>",
		.pme_code = 1914,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:3>@11",
		.pme_desc = "<NA>",
		.pme_code = 1915,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:3>@12",
		.pme_desc = "<NA>",
		.pme_code = 1916,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:3>@13",
		.pme_desc = "<NA>",
		.pme_code = 1917,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:3>@14",
		.pme_desc = "<NA>",
		.pme_code = 1918,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:26:3>@15",
		.pme_desc = "<NA>",
		.pme_code = 1919,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 26,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 27 Event 0 */
	{
		.pme_name = "W_SWORD_NGETS@0",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with NGet commands. Counts up to 2 SWords per memory directory per clock period. (M chip 0)",
		.pme_code = 1920,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 0,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NGETS@1",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with NGet commands. Counts up to 2 SWords per memory directory per clock period. (M chip 1)",
		.pme_code = 1921,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 0,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NGETS@2",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with NGet commands. Counts up to 2 SWords per memory directory per clock period. (M chip 2)",
		.pme_code = 1922,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 0,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NGETS@3",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with NGet commands. Counts up to 2 SWords per memory directory per clock period. (M chip 3)",
		.pme_code = 1923,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 0,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NGETS@4",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with NGet commands. Counts up to 2 SWords per memory directory per clock period. (M chip 4)",
		.pme_code = 1924,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 0,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NGETS@5",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with NGet commands. Counts up to 2 SWords per memory directory per clock period. (M chip 5)",
		.pme_code = 1925,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 0,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NGETS@6",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with NGet commands. Counts up to 2 SWords per memory directory per clock period. (M chip 6)",
		.pme_code = 1926,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 0,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NGETS@7",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with NGet commands. Counts up to 2 SWords per memory directory per clock period. (M chip 7)",
		.pme_code = 1927,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 0,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NGETS@8",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with NGet commands. Counts up to 2 SWords per memory directory per clock period. (M chip 8)",
		.pme_code = 1928,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 0,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NGETS@9",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with NGet commands. Counts up to 2 SWords per memory directory per clock period. (M chip 9)",
		.pme_code = 1929,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 0,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NGETS@10",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with NGet commands. Counts up to 2 SWords per memory directory per clock period. (M chip 10)",
		.pme_code = 1930,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 0,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NGETS@11",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with NGet commands. Counts up to 2 SWords per memory directory per clock period. (M chip 11)",
		.pme_code = 1931,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 0,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NGETS@12",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with NGet commands. Counts up to 2 SWords per memory directory per clock period. (M chip 12)",
		.pme_code = 1932,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 0,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NGETS@13",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with NGet commands. Counts up to 2 SWords per memory directory per clock period. (M chip 13)",
		.pme_code = 1933,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 0,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NGETS@14",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with NGet commands. Counts up to 2 SWords per memory directory per clock period. (M chip 14)",
		.pme_code = 1934,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 0,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "W_SWORD_NGETS@15",
		.pme_desc = "Count of the total number of SWords that are read from memory or the L3 cache with NGet commands. Counts up to 2 SWords per memory directory per clock period. (M chip 15)",
		.pme_code = 1935,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 0,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 27 Event 1 */
	{
		.pme_name = "<M:27:1>@0",
		.pme_desc = "<NA>",
		.pme_code = 1936,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 1,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:1>@1",
		.pme_desc = "<NA>",
		.pme_code = 1937,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 1,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:1>@2",
		.pme_desc = "<NA>",
		.pme_code = 1938,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 1,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:1>@3",
		.pme_desc = "<NA>",
		.pme_code = 1939,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 1,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:1>@4",
		.pme_desc = "<NA>",
		.pme_code = 1940,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 1,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:1>@5",
		.pme_desc = "<NA>",
		.pme_code = 1941,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 1,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:1>@6",
		.pme_desc = "<NA>",
		.pme_code = 1942,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 1,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:1>@7",
		.pme_desc = "<NA>",
		.pme_code = 1943,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 1,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:1>@8",
		.pme_desc = "<NA>",
		.pme_code = 1944,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 1,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:1>@9",
		.pme_desc = "<NA>",
		.pme_code = 1945,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 1,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:1>@10",
		.pme_desc = "<NA>",
		.pme_code = 1946,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 1,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:1>@11",
		.pme_desc = "<NA>",
		.pme_code = 1947,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 1,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:1>@12",
		.pme_desc = "<NA>",
		.pme_code = 1948,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 1,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:1>@13",
		.pme_desc = "<NA>",
		.pme_code = 1949,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 1,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:1>@14",
		.pme_desc = "<NA>",
		.pme_code = 1950,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 1,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:1>@15",
		.pme_desc = "<NA>",
		.pme_code = 1951,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 1,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 27 Event 2 */
	{
		.pme_name = "<M:27:2>@0",
		.pme_desc = "<NA>",
		.pme_code = 1952,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 2,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:2>@1",
		.pme_desc = "<NA>",
		.pme_code = 1953,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 2,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:2>@2",
		.pme_desc = "<NA>",
		.pme_code = 1954,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 2,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:2>@3",
		.pme_desc = "<NA>",
		.pme_code = 1955,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 2,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:2>@4",
		.pme_desc = "<NA>",
		.pme_code = 1956,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 2,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:2>@5",
		.pme_desc = "<NA>",
		.pme_code = 1957,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 2,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:2>@6",
		.pme_desc = "<NA>",
		.pme_code = 1958,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 2,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:2>@7",
		.pme_desc = "<NA>",
		.pme_code = 1959,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 2,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:2>@8",
		.pme_desc = "<NA>",
		.pme_code = 1960,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 2,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:2>@9",
		.pme_desc = "<NA>",
		.pme_code = 1961,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 2,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:2>@10",
		.pme_desc = "<NA>",
		.pme_code = 1962,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 2,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:2>@11",
		.pme_desc = "<NA>",
		.pme_code = 1963,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 2,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:2>@12",
		.pme_desc = "<NA>",
		.pme_code = 1964,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 2,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:2>@13",
		.pme_desc = "<NA>",
		.pme_code = 1965,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 2,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:2>@14",
		.pme_desc = "<NA>",
		.pme_code = 1966,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 2,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:2>@15",
		.pme_desc = "<NA>",
		.pme_code = 1967,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 2,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	/* M Counter 27 Event 3 */
	{
		.pme_name = "<M:27:3>@0",
		.pme_desc = "<NA>",
		.pme_code = 1968,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 3,
		.pme_chipno = 0,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:3>@1",
		.pme_desc = "<NA>",
		.pme_code = 1969,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 3,
		.pme_chipno = 1,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:3>@2",
		.pme_desc = "<NA>",
		.pme_code = 1970,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 3,
		.pme_chipno = 2,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:3>@3",
		.pme_desc = "<NA>",
		.pme_code = 1971,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 3,
		.pme_chipno = 3,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:3>@4",
		.pme_desc = "<NA>",
		.pme_code = 1972,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 3,
		.pme_chipno = 4,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:3>@5",
		.pme_desc = "<NA>",
		.pme_code = 1973,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 3,
		.pme_chipno = 5,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:3>@6",
		.pme_desc = "<NA>",
		.pme_code = 1974,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 3,
		.pme_chipno = 6,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:3>@7",
		.pme_desc = "<NA>",
		.pme_code = 1975,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 3,
		.pme_chipno = 7,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:3>@8",
		.pme_desc = "<NA>",
		.pme_code = 1976,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 3,
		.pme_chipno = 8,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:3>@9",
		.pme_desc = "<NA>",
		.pme_code = 1977,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 3,
		.pme_chipno = 9,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:3>@10",
		.pme_desc = "<NA>",
		.pme_code = 1978,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 3,
		.pme_chipno = 10,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:3>@11",
		.pme_desc = "<NA>",
		.pme_code = 1979,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 3,
		.pme_chipno = 11,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:3>@12",
		.pme_desc = "<NA>",
		.pme_code = 1980,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 3,
		.pme_chipno = 12,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:3>@13",
		.pme_desc = "<NA>",
		.pme_code = 1981,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 3,
		.pme_chipno = 13,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:3>@14",
		.pme_desc = "<NA>",
		.pme_code = 1982,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 3,
		.pme_chipno = 14,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
	{
		.pme_name = "<M:27:3>@15",
		.pme_desc = "<NA>",
		.pme_code = 1983,
		.pme_flags = 0x0,
		.pme_numasks = 0,
		.pme_chip = PME_CRAYX2_CHIP_MEMORY,
		.pme_ctr = 27,
		.pme_event = 3,
		.pme_chipno = 15,
		.pme_base = PMU_CRAYX2_MEMORY_PMD_BASE,
		.pme_nctrs = PME_CRAYX2_MEMORY_CTRS_PER_CHIP,
		.pme_nchips = PME_CRAYX2_MEMORY_CHIPS
	},
};

#define PME_CRAYX2_CYCLES 0
#define PME_CRAYX2_INSTR_GRADUATED 4
#define PME_CRAYX2_EVENT_COUNT	(sizeof(crayx2_pe)/sizeof(pme_crayx2_entry_t))

#endif /* __CRAYX2_EVENTS_H__ */
