###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_libpng_detect_lin.nasl 851 2009-01-20 16:54:55Z jan $
#
# libpng Version Detection
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900070);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("libpng Version Detection");
  desc = "

  Overview: The script detects the version of libpng and sets the
  result in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set the KB for the version of libpng");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

pngName = find_file(file_name:"libpng-config", file_path:"/", useregex:TRUE,
                    regexpar:"$", sock:sock);
foreach binaryName (pngName)
{
  binaryName = chomp(binaryName);
  pngVer = get_bin_version(full_prog_name:binaryName, version_argv:"--version",
                           ver_pattern:"[0-9.]+", sock:sock);
  if(pngVer[0] != NULL)
  {
    set_kb_item(name:"Libpng/Version", value:pngVer[0]);
    security_note(data:"libpng Version " + pngVer[0] +
          " running at location " + binaryName + " was detected on the host");
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
