/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MacroHelper_H
#define MacroHelper_H


// --------------------------------------------------
// class MacroHelper
// A language helper specific to the Macro language
// --------------------------------------------------

class MacroHelper : public LanguageHelper
{
public:
    MacroHelper();
    virtual ~MacroHelper();

    Highlighter *createHighlighter(QTextDocument *parent = 0);
    bool canCheckSyntax() {return true;}
    bool canDebug()       {return true;}
    bool canRun()         {return true;}
    bool runAsService()   {return true;}
    bool isHelpAvailableForFunction(const QString &function);
    bool isHeaderLine(const QString &text);       // is the text a header line (e.g. "# Metview Macro")?
    QString requiredHeaderLine()  {return QString("# Metview Macro\n\n");}; // required header line to be added automatically
    QString pathToFunctionList();
    QString pathToTemplateList();

private:
    QString pathToMacroFunctionList_;
    QString pathToMacroDeprecatedFunctionList_;
    QString pathToMacroTemplateList_;

};




#endif
