/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.classfile;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import junit.framework.TestCase;
import static junit.framework.TestCase.assertEquals;
import org.netbeans.modules.classfile.CPMethodHandleInfo.ReferenceKind;

/**
 *
 * @author arusinha
 */
public class JDK11ClassFilesTest extends TestCase {

    public JDK11ClassFilesTest(String testName) {
        super(testName);
    }

    public void testDefenderMethods() throws Exception {
        InputStream classData = new ByteArrayInputStream(DATA);
        ClassFile classFile = new ClassFile(classData);

        CPConstantDynamicInfo constDynamic = (CPConstantDynamicInfo) classFile.getConstantPool().get(2);
        assertEquals(ConstantPool.CONSTANT_ConstantDynamic, constDynamic.getTag());
        BootstrapMethod bootstrapMethod = classFile.getBootstrapMethods().get(constDynamic.getBootstrapMethod());
        assertEquals("[17, 18, 17]", Arrays.toString(bootstrapMethod.getArguments()));
        CPMethodHandleInfo bootstrapMH = (CPMethodHandleInfo) classFile.getConstantPool().get(bootstrapMethod.getMethodRef());
        assertEquals(ConstantPool.CONSTANT_MethodHandle, bootstrapMH.getTag());
        assertEquals(ReferenceKind.invokeStatic, bootstrapMH.getReferenceKind());
        CPMethodInfo bootstrapMethodInfo = (CPMethodInfo) classFile.getConstantPool().get(bootstrapMH.getReference());
        assertEquals("Object metafactory(MethodHandles$Lookup,String,Class,MethodType,MethodHandle,MethodType)", bootstrapMethodInfo.getFullMethodName());
        CPNameAndTypeInfo nameAndType = (CPNameAndTypeInfo) classFile.getConstantPool().get(constDynamic.getNameAndType());
        assertEquals("Ljava/lang/Runnable;", nameAndType.getDescriptor());
        assertEquals("run", nameAndType.getName());
        CPMethodTypeInfo methodType = (CPMethodTypeInfo) classFile.getConstantPool().get(17);
        assertEquals(ConstantPool.CONSTANT_MethodType, methodType.getTag());
        CPUTF8Info descriptor = (CPUTF8Info) classFile.getConstantPool().get(methodType.getDescriptor());
        assertEquals("()V", descriptor.getName());
    }

    /*
    The  bytecode array was generate from the below class
    public class LDC {
        private Runnable get() {
            return () -> {
            };
        }
    }

     */
    private static final byte[] DATA = {
        (byte) 0xCA, (byte) 0xFE, (byte) 0xBA, (byte) 0xBE, (byte) 0x00, (byte) 0x00, (byte) 0x00,
        (byte) 0x38, (byte) 0x00, (byte) 0x26, (byte) 0x0A, (byte) 0x00, (byte) 0x04, (byte) 0x00,
        (byte) 0x0E, (byte) 0x11, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x13, (byte) 0x07,
        (byte) 0x00, (byte) 0x14, (byte) 0x07, (byte) 0x00, (byte) 0x15, (byte) 0x01, (byte) 0x00,
        (byte) 0x06, (byte) 0x3C, (byte) 0x69, (byte) 0x6E, (byte) 0x69, (byte) 0x74, (byte) 0x3E,
        (byte) 0x01, (byte) 0x00, (byte) 0x03, (byte) 0x28, (byte) 0x29, (byte) 0x56, (byte) 0x01,
        (byte) 0x00, (byte) 0x04, (byte) 0x43, (byte) 0x6F, (byte) 0x64, (byte) 0x65, (byte) 0x01,
        (byte) 0x00, (byte) 0x0F, (byte) 0x4C, (byte) 0x69, (byte) 0x6E, (byte) 0x65, (byte) 0x4E,
        (byte) 0x75, (byte) 0x6D, (byte) 0x62, (byte) 0x65, (byte) 0x72, (byte) 0x54, (byte) 0x61,
        (byte) 0x62, (byte) 0x6C, (byte) 0x65, (byte) 0x01, (byte) 0x00, (byte) 0x03, (byte) 0x67,
        (byte) 0x65, (byte) 0x74, (byte) 0x01, (byte) 0x00, (byte) 0x16, (byte) 0x28, (byte) 0x29,
        (byte) 0x4C, (byte) 0x6A, (byte) 0x61, (byte) 0x76, (byte) 0x61, (byte) 0x2F, (byte) 0x6C,
        (byte) 0x61, (byte) 0x6E, (byte) 0x67, (byte) 0x2F, (byte) 0x52, (byte) 0x75, (byte) 0x6E,
        (byte) 0x6E, (byte) 0x61, (byte) 0x62, (byte) 0x6C, (byte) 0x65, (byte) 0x3B, (byte) 0x01,
        (byte) 0x00, (byte) 0x0C, (byte) 0x6C, (byte) 0x61, (byte) 0x6D, (byte) 0x62, (byte) 0x64,
        (byte) 0x61, (byte) 0x24, (byte) 0x67, (byte) 0x65, (byte) 0x74, (byte) 0x24, (byte) 0x30,
        (byte) 0x01, (byte) 0x00, (byte) 0x0A, (byte) 0x53, (byte) 0x6F, (byte) 0x75, (byte) 0x72,
        (byte) 0x63, (byte) 0x65, (byte) 0x46, (byte) 0x69, (byte) 0x6C, (byte) 0x65, (byte) 0x01,
        (byte) 0x00, (byte) 0x08, (byte) 0x4C, (byte) 0x44, (byte) 0x43, (byte) 0x2E, (byte) 0x6A,
        (byte) 0x61, (byte) 0x76, (byte) 0x61, (byte) 0x0C, (byte) 0x00, (byte) 0x05, (byte) 0x00,
        (byte) 0x06, (byte) 0x01, (byte) 0x00, (byte) 0x10, (byte) 0x42, (byte) 0x6F, (byte) 0x6F,
        (byte) 0x74, (byte) 0x73, (byte) 0x74, (byte) 0x72, (byte) 0x61, (byte) 0x70, (byte) 0x4D,
        (byte) 0x65, (byte) 0x74, (byte) 0x68, (byte) 0x6F, (byte) 0x64, (byte) 0x73, (byte) 0x0F,
        (byte) 0x06, (byte) 0x00, (byte) 0x16, (byte) 0x10, (byte) 0x00, (byte) 0x06, (byte) 0x0F,
        (byte) 0x06, (byte) 0x00, (byte) 0x17, (byte) 0x0C, (byte) 0x00, (byte) 0x18, (byte) 0x00,
        (byte) 0x19, (byte) 0x01, (byte) 0x00, (byte) 0x03, (byte) 0x4C, (byte) 0x44, (byte) 0x43,
        (byte) 0x01, (byte) 0x00, (byte) 0x10, (byte) 0x6A, (byte) 0x61, (byte) 0x76, (byte) 0x61,
        (byte) 0x2F, (byte) 0x6C, (byte) 0x61, (byte) 0x6E, (byte) 0x67, (byte) 0x2F, (byte) 0x4F,
        (byte) 0x62, (byte) 0x6A, (byte) 0x65, (byte) 0x63, (byte) 0x74, (byte) 0x0A, (byte) 0x00,
        (byte) 0x1A, (byte) 0x00, (byte) 0x1B, (byte) 0x0A, (byte) 0x00, (byte) 0x03, (byte) 0x00,
        (byte) 0x1C, (byte) 0x01, (byte) 0x00, (byte) 0x03, (byte) 0x72, (byte) 0x75, (byte) 0x6E,
        (byte) 0x01, (byte) 0x00, (byte) 0x14, (byte) 0x4C, (byte) 0x6A, (byte) 0x61, (byte) 0x76,
        (byte) 0x61, (byte) 0x2F, (byte) 0x6C, (byte) 0x61, (byte) 0x6E, (byte) 0x67, (byte) 0x2F,
        (byte) 0x52, (byte) 0x75, (byte) 0x6E, (byte) 0x6E, (byte) 0x61, (byte) 0x62, (byte) 0x6C,
        (byte) 0x65, (byte) 0x3B, (byte) 0x07, (byte) 0x00, (byte) 0x1D, (byte) 0x0C, (byte) 0x00,
        (byte) 0x1E, (byte) 0x00, (byte) 0x22, (byte) 0x0C, (byte) 0x00, (byte) 0x0B, (byte) 0x00,
        (byte) 0x06, (byte) 0x01, (byte) 0x00, (byte) 0x22, (byte) 0x6A, (byte) 0x61, (byte) 0x76,
        (byte) 0x61, (byte) 0x2F, (byte) 0x6C, (byte) 0x61, (byte) 0x6E, (byte) 0x67, (byte) 0x2F,
        (byte) 0x69, (byte) 0x6E, (byte) 0x76, (byte) 0x6F, (byte) 0x6B, (byte) 0x65, (byte) 0x2F,
        (byte) 0x4C, (byte) 0x61, (byte) 0x6D, (byte) 0x62, (byte) 0x64, (byte) 0x61, (byte) 0x4D,
        (byte) 0x65, (byte) 0x74, (byte) 0x61, (byte) 0x66, (byte) 0x61, (byte) 0x63, (byte) 0x74,
        (byte) 0x6F, (byte) 0x72, (byte) 0x79, (byte) 0x01, (byte) 0x00, (byte) 0x0B, (byte) 0x6D,
        (byte) 0x65, (byte) 0x74, (byte) 0x61, (byte) 0x66, (byte) 0x61, (byte) 0x63, (byte) 0x74,
        (byte) 0x6F, (byte) 0x72, (byte) 0x79, (byte) 0x07, (byte) 0x00, (byte) 0x24, (byte) 0x01,
        (byte) 0x00, (byte) 0x06, (byte) 0x4C, (byte) 0x6F, (byte) 0x6F, (byte) 0x6B, (byte) 0x75,
        (byte) 0x70, (byte) 0x01, (byte) 0x00, (byte) 0x0C, (byte) 0x49, (byte) 0x6E, (byte) 0x6E,
        (byte) 0x65, (byte) 0x72, (byte) 0x43, (byte) 0x6C, (byte) 0x61, (byte) 0x73, (byte) 0x73,
        (byte) 0x65, (byte) 0x73, (byte) 0x01, (byte) 0x00, (byte) 0xB7, (byte) 0x28, (byte) 0x4C,
        (byte) 0x6A, (byte) 0x61, (byte) 0x76, (byte) 0x61, (byte) 0x2F, (byte) 0x6C, (byte) 0x61,
        (byte) 0x6E, (byte) 0x67, (byte) 0x2F, (byte) 0x69, (byte) 0x6E, (byte) 0x76, (byte) 0x6F,
        (byte) 0x6B, (byte) 0x65, (byte) 0x2F, (byte) 0x4D, (byte) 0x65, (byte) 0x74, (byte) 0x68,
        (byte) 0x6F, (byte) 0x64, (byte) 0x48, (byte) 0x61, (byte) 0x6E, (byte) 0x64, (byte) 0x6C,
        (byte) 0x65, (byte) 0x73, (byte) 0x24, (byte) 0x4C, (byte) 0x6F, (byte) 0x6F, (byte) 0x6B,
        (byte) 0x75, (byte) 0x70, (byte) 0x3B, (byte) 0x4C, (byte) 0x6A, (byte) 0x61, (byte) 0x76,
        (byte) 0x61, (byte) 0x2F, (byte) 0x6C, (byte) 0x61, (byte) 0x6E, (byte) 0x67, (byte) 0x2F,
        (byte) 0x53, (byte) 0x74, (byte) 0x72, (byte) 0x69, (byte) 0x6E, (byte) 0x67, (byte) 0x3B,
        (byte) 0x4C, (byte) 0x6A, (byte) 0x61, (byte) 0x76, (byte) 0x61, (byte) 0x2F, (byte) 0x6C,
        (byte) 0x61, (byte) 0x6E, (byte) 0x67, (byte) 0x2F, (byte) 0x43, (byte) 0x6C, (byte) 0x61,
        (byte) 0x73, (byte) 0x73, (byte) 0x3B, (byte) 0x4C, (byte) 0x6A, (byte) 0x61, (byte) 0x76,
        (byte) 0x61, (byte) 0x2F, (byte) 0x6C, (byte) 0x61, (byte) 0x6E, (byte) 0x67, (byte) 0x2F,
        (byte) 0x69, (byte) 0x6E, (byte) 0x76, (byte) 0x6F, (byte) 0x6B, (byte) 0x65, (byte) 0x2F,
        (byte) 0x4D, (byte) 0x65, (byte) 0x74, (byte) 0x68, (byte) 0x6F, (byte) 0x64, (byte) 0x54,
        (byte) 0x79, (byte) 0x70, (byte) 0x65, (byte) 0x3B, (byte) 0x4C, (byte) 0x6A, (byte) 0x61,
        (byte) 0x76, (byte) 0x61, (byte) 0x2F, (byte) 0x6C, (byte) 0x61, (byte) 0x6E, (byte) 0x67,
        (byte) 0x2F, (byte) 0x69, (byte) 0x6E, (byte) 0x76, (byte) 0x6F, (byte) 0x6B, (byte) 0x65,
        (byte) 0x2F, (byte) 0x4D, (byte) 0x65, (byte) 0x74, (byte) 0x68, (byte) 0x6F, (byte) 0x64,
        (byte) 0x48, (byte) 0x61, (byte) 0x6E, (byte) 0x64, (byte) 0x6C, (byte) 0x65, (byte) 0x3B,
        (byte) 0x4C, (byte) 0x6A, (byte) 0x61, (byte) 0x76, (byte) 0x61, (byte) 0x2F, (byte) 0x6C,
        (byte) 0x61, (byte) 0x6E, (byte) 0x67, (byte) 0x2F, (byte) 0x69, (byte) 0x6E, (byte) 0x76,
        (byte) 0x6F, (byte) 0x6B, (byte) 0x65, (byte) 0x2F, (byte) 0x4D, (byte) 0x65, (byte) 0x74,
        (byte) 0x68, (byte) 0x6F, (byte) 0x64, (byte) 0x54, (byte) 0x79, (byte) 0x70, (byte) 0x65,
        (byte) 0x3B, (byte) 0x29, (byte) 0x4C, (byte) 0x6A, (byte) 0x61, (byte) 0x76, (byte) 0x61,
        (byte) 0x2F, (byte) 0x6C, (byte) 0x61, (byte) 0x6E, (byte) 0x67, (byte) 0x2F, (byte) 0x4F,
        (byte) 0x62, (byte) 0x6A, (byte) 0x65, (byte) 0x63, (byte) 0x74, (byte) 0x3B, (byte) 0x07,
        (byte) 0x00, (byte) 0x25, (byte) 0x01, (byte) 0x00, (byte) 0x25, (byte) 0x6A, (byte) 0x61,
        (byte) 0x76, (byte) 0x61, (byte) 0x2F, (byte) 0x6C, (byte) 0x61, (byte) 0x6E, (byte) 0x67,
        (byte) 0x2F, (byte) 0x69, (byte) 0x6E, (byte) 0x76, (byte) 0x6F, (byte) 0x6B, (byte) 0x65,
        (byte) 0x2F, (byte) 0x4D, (byte) 0x65, (byte) 0x74, (byte) 0x68, (byte) 0x6F, (byte) 0x64,
        (byte) 0x48, (byte) 0x61, (byte) 0x6E, (byte) 0x64, (byte) 0x6C, (byte) 0x65, (byte) 0x73,
        (byte) 0x24, (byte) 0x4C, (byte) 0x6F, (byte) 0x6F, (byte) 0x6B, (byte) 0x75, (byte) 0x70,
        (byte) 0x01, (byte) 0x00, (byte) 0x1E, (byte) 0x6A, (byte) 0x61, (byte) 0x76, (byte) 0x61,
        (byte) 0x2F, (byte) 0x6C, (byte) 0x61, (byte) 0x6E, (byte) 0x67, (byte) 0x2F, (byte) 0x69,
        (byte) 0x6E, (byte) 0x76, (byte) 0x6F, (byte) 0x6B, (byte) 0x65, (byte) 0x2F, (byte) 0x4D,
        (byte) 0x65, (byte) 0x74, (byte) 0x68, (byte) 0x6F, (byte) 0x64, (byte) 0x48, (byte) 0x61,
        (byte) 0x6E, (byte) 0x64, (byte) 0x6C, (byte) 0x65, (byte) 0x73, (byte) 0x00, (byte) 0x21,
        (byte) 0x00, (byte) 0x03, (byte) 0x00, (byte) 0x04, (byte) 0x00, (byte) 0x00, (byte) 0x00,
        (byte) 0x00, (byte) 0x00, (byte) 0x03, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x05,
        (byte) 0x00, (byte) 0x06, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x07, (byte) 0x00,
        (byte) 0x00, (byte) 0x00, (byte) 0x1D, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x01,
        (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x05, (byte) 0x2A, (byte) 0xB7, (byte) 0x00,
        (byte) 0x01, (byte) 0xB1, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00,
        (byte) 0x08, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x06, (byte) 0x00, (byte) 0x01,
        (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x02, (byte) 0x00,
        (byte) 0x09, (byte) 0x00, (byte) 0x0A, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x07,
        (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x1B, (byte) 0x00, (byte) 0x01, (byte) 0x00,
        (byte) 0x01, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x03, (byte) 0x12, (byte) 0x02,
        (byte) 0xB0, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x08,
        (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x06, (byte) 0x00, (byte) 0x01, (byte) 0x00,
        (byte) 0x00, (byte) 0x00, (byte) 0x03, (byte) 0x10, (byte) 0x0A, (byte) 0x00, (byte) 0x0B,
        (byte) 0x00, (byte) 0x06, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x07, (byte) 0x00,
        (byte) 0x00, (byte) 0x00, (byte) 0x19, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
        (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0xB1, (byte) 0x00, (byte) 0x00,
        (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x08, (byte) 0x00, (byte) 0x00, (byte) 0x00,
        (byte) 0x06, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x03,
        (byte) 0x00, (byte) 0x03, (byte) 0x00, (byte) 0x0C, (byte) 0x00, (byte) 0x00, (byte) 0x00,
        (byte) 0x02, (byte) 0x00, (byte) 0x0D, (byte) 0x00, (byte) 0x21, (byte) 0x00, (byte) 0x00,
        (byte) 0x00, (byte) 0x0A, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x1F, (byte) 0x00,
        (byte) 0x23, (byte) 0x00, (byte) 0x20, (byte) 0x00, (byte) 0x19, (byte) 0x00, (byte) 0x0F,
        (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x0C, (byte) 0x00, (byte) 0x01, (byte) 0x00,
        (byte) 0x10, (byte) 0x00, (byte) 0x03, (byte) 0x00, (byte) 0x11, (byte) 0x00, (byte) 0x12,
        (byte) 0x00, (byte) 0x11
    };
}
