/**************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
**************************************************************************/

#include "xml_parser_server.h"

XmlParserServer::XmlParserServer(QObject *parent)
    : QObject(parent)
{
}

Document* XmlParserServer::getDocumentInformation(QString xml)
{
    Document *document = new Document;
    QDomDocument doc;
    doc.setContent(xml);
    QDomElement root = doc.documentElement();
    QDomElement child = root.firstChild().toElement();
    while(!child.isNull())
    {
        if (child.tagName() == DOC_XML)
        {
          document->doc = child.text();
        }
        if (child.tagName() == FILE_XML)
        {
          document->name = child.text();
        }
        if (child.tagName() == FILE_NEW_XML)
        {
          document->newName = child.text();
        }
        if (child.tagName() == PATH)
        {
          document->path = child.text();
        }
        if (child.tagName() == FROM_XML)
        {
          document->from = child.text();
        }
        if (child.tagName() == TO_XML)
        {
          document->to = child.text();
        }
        child = child.nextSibling().toElement();
    }
    return document;
}

