/* 
 * File: sdecode.c
 *
 * Copyright (c) 2005 Johannes Heimansberg
 *
 * Released under the GNU General Public License v2
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>

gchar hex2char(gchar first_digit, gchar second_digit)
{
	gchar result = 0;
	
	if (first_digit >= '0' && first_digit <= '9')
		result = (first_digit - '0') * 16;
	else if (first_digit >= 'a' && first_digit <= 'f')
		result = (first_digit - 'a' + 10) * 16;
	if (second_digit >= '0' && second_digit <= '9')
		result += second_digit - '0';
	else if (second_digit >= 'a' && second_digit <= 'f')
		result += second_digit - 'a' + 10;
	return result;
}

gchar *decode_string(gchar *string)
{
	int i, j;
	gchar *result = g_malloc((strlen(string) + 1) * sizeof(gchar));

	/* decode %XX escape sequences to their corresponding chars: */
	for (i = 0, j = 0; i < strlen(string); i++) {
		if (string[i] == '%') {
			result[j] = hex2char(string[i+1], string[i+2]);
			i+=2;
			j++; 
		} else {
			result[j] = string[i];
			j++;
		}
	}
	result[j] = '\0';
	return result;
}

gchar *get_valid_utf8_str_alloc(const gchar *str_to_validate)
{
	gchar *result = g_malloc(strlen(str_to_validate) + 1);

	if (g_utf8_validate(str_to_validate, -1, NULL)) {
		g_strlcpy(result, str_to_validate, strlen(str_to_validate) + 1);
	} else {
		int i;

		for (i = 0; i < strlen(str_to_validate) + 1; i++) {
			if (str_to_validate[i] >= 0) /* negative chars are non-ASCII (>127) chars */
				result[i] = str_to_validate[i];
			else
				result[i] = '?';
		}
	}
	return result;
}

