/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.math;
public class LongMathTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.math.testModule";
}
public void testBinomial() throws Exception {
  com.google.common.math.LongMathTest testCase = new com.google.common.math.LongMathTest();
  testCase.testBinomial();
}

public void testBinomialNegative() throws Exception {
  com.google.common.math.LongMathTest testCase = new com.google.common.math.LongMathTest();
  testCase.testBinomialNegative();
}

public void testBinomialOutside() throws Exception {
  com.google.common.math.LongMathTest testCase = new com.google.common.math.LongMathTest();
  testCase.testBinomialOutside();
}

public void testGCDExhaustive() throws Exception {
  com.google.common.math.LongMathTest testCase = new com.google.common.math.LongMathTest();
  testCase.testGCDExhaustive();
}

public void testLessThanBranchFree() throws Exception {
  com.google.common.math.LongMathTest testCase = new com.google.common.math.LongMathTest();
  testCase.testLessThanBranchFree();
}

public void testLog2Exact() throws Exception {
  com.google.common.math.LongMathTest testCase = new com.google.common.math.LongMathTest();
  testCase.testLog2Exact();
}

public void testLog2MatchesBigInteger() throws Exception {
  com.google.common.math.LongMathTest testCase = new com.google.common.math.LongMathTest();
  testCase.testLog2MatchesBigInteger();
}

public void testLog2NegativeAlwaysThrows() throws Exception {
  com.google.common.math.LongMathTest testCase = new com.google.common.math.LongMathTest();
  testCase.testLog2NegativeAlwaysThrows();
}

public void testLog2ZeroAlwaysThrows() throws Exception {
  com.google.common.math.LongMathTest testCase = new com.google.common.math.LongMathTest();
  testCase.testLog2ZeroAlwaysThrows();
}

public void testSqrtOfLongIsAtMostFloorSqrtMaxLong() throws Exception {
  com.google.common.math.LongMathTest testCase = new com.google.common.math.LongMathTest();
  testCase.testSqrtOfLongIsAtMostFloorSqrtMaxLong();
}
}
