package spark

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/synapse/2019-11-01-preview/spark"

// BatchJobResultType enumerates the values for batch job result type.
type BatchJobResultType string

const (
	// Cancelled ...
	Cancelled BatchJobResultType = "Cancelled"
	// Failed ...
	Failed BatchJobResultType = "Failed"
	// Succeeded ...
	Succeeded BatchJobResultType = "Succeeded"
	// Uncertain ...
	Uncertain BatchJobResultType = "Uncertain"
)

// PossibleBatchJobResultTypeValues returns an array of possible values for the BatchJobResultType const type.
func PossibleBatchJobResultTypeValues() []BatchJobResultType {
	return []BatchJobResultType{Cancelled, Failed, Succeeded, Uncertain}
}

// ErrorSource enumerates the values for error source.
type ErrorSource string

const (
	// Dependency ...
	Dependency ErrorSource = "Dependency"
	// System ...
	System ErrorSource = "System"
	// Unknown ...
	Unknown ErrorSource = "Unknown"
	// User ...
	User ErrorSource = "User"
)

// PossibleErrorSourceValues returns an array of possible values for the ErrorSource const type.
func PossibleErrorSourceValues() []ErrorSource {
	return []ErrorSource{Dependency, System, Unknown, User}
}

// JobType enumerates the values for job type.
type JobType string

const (
	// SparkBatch ...
	SparkBatch JobType = "SparkBatch"
	// SparkSession ...
	SparkSession JobType = "SparkSession"
)

// PossibleJobTypeValues returns an array of possible values for the JobType const type.
func PossibleJobTypeValues() []JobType {
	return []JobType{SparkBatch, SparkSession}
}

// PluginCurrentState enumerates the values for plugin current state.
type PluginCurrentState string

const (
	// Cleanup ...
	Cleanup PluginCurrentState = "Cleanup"
	// Ended ...
	Ended PluginCurrentState = "Ended"
	// Monitoring ...
	Monitoring PluginCurrentState = "Monitoring"
	// Preparation ...
	Preparation PluginCurrentState = "Preparation"
	// Queued ...
	Queued PluginCurrentState = "Queued"
	// ResourceAcquisition ...
	ResourceAcquisition PluginCurrentState = "ResourceAcquisition"
	// Submission ...
	Submission PluginCurrentState = "Submission"
)

// PossiblePluginCurrentStateValues returns an array of possible values for the PluginCurrentState const type.
func PossiblePluginCurrentStateValues() []PluginCurrentState {
	return []PluginCurrentState{Cleanup, Ended, Monitoring, Preparation, Queued, ResourceAcquisition, Submission}
}

// SchedulerCurrentState enumerates the values for scheduler current state.
type SchedulerCurrentState string

const (
	// SchedulerCurrentStateEnded ...
	SchedulerCurrentStateEnded SchedulerCurrentState = "Ended"
	// SchedulerCurrentStateQueued ...
	SchedulerCurrentStateQueued SchedulerCurrentState = "Queued"
	// SchedulerCurrentStateScheduled ...
	SchedulerCurrentStateScheduled SchedulerCurrentState = "Scheduled"
)

// PossibleSchedulerCurrentStateValues returns an array of possible values for the SchedulerCurrentState const type.
func PossibleSchedulerCurrentStateValues() []SchedulerCurrentState {
	return []SchedulerCurrentState{SchedulerCurrentStateEnded, SchedulerCurrentStateQueued, SchedulerCurrentStateScheduled}
}

// SessionResultType enumerates the values for session result type.
type SessionResultType string

const (
	// SessionResultTypeCancelled ...
	SessionResultTypeCancelled SessionResultType = "Cancelled"
	// SessionResultTypeFailed ...
	SessionResultTypeFailed SessionResultType = "Failed"
	// SessionResultTypeSucceeded ...
	SessionResultTypeSucceeded SessionResultType = "Succeeded"
	// SessionResultTypeUncertain ...
	SessionResultTypeUncertain SessionResultType = "Uncertain"
)

// PossibleSessionResultTypeValues returns an array of possible values for the SessionResultType const type.
func PossibleSessionResultTypeValues() []SessionResultType {
	return []SessionResultType{SessionResultTypeCancelled, SessionResultTypeFailed, SessionResultTypeSucceeded, SessionResultTypeUncertain}
}

// StatementLanguageType enumerates the values for statement language type.
type StatementLanguageType string

const (
	// Dotnetspark ...
	Dotnetspark StatementLanguageType = "dotnetspark"
	// Pyspark ...
	Pyspark StatementLanguageType = "pyspark"
	// Spark ...
	Spark StatementLanguageType = "spark"
	// SQL ...
	SQL StatementLanguageType = "sql"
)

// PossibleStatementLanguageTypeValues returns an array of possible values for the StatementLanguageType const type.
func PossibleStatementLanguageTypeValues() []StatementLanguageType {
	return []StatementLanguageType{Dotnetspark, Pyspark, Spark, SQL}
}

// BatchJob ...
type BatchJob struct {
	autorest.Response `json:"-"`
	LivyInfo          *BatchJobState `json:"livyInfo,omitempty"`
	// Name - The batch name.
	Name *string `json:"name,omitempty"`
	// WorkspaceName - The workspace name.
	WorkspaceName *string `json:"workspaceName,omitempty"`
	// SparkPoolName - The Spark pool name.
	SparkPoolName *string `json:"sparkPoolName,omitempty"`
	// SubmitterName - The submitter name.
	SubmitterName *string `json:"submitterName,omitempty"`
	// SubmitterID - The submitter identifier.
	SubmitterID *string `json:"submitterId,omitempty"`
	// ArtifactID - The artifact identifier.
	ArtifactID *string `json:"artifactId,omitempty"`
	// JobType - The job type. Possible values include: 'SparkBatch', 'SparkSession'
	JobType JobType `json:"jobType,omitempty"`
	// Result - The Spark batch job result. Possible values include: 'Uncertain', 'Succeeded', 'Failed', 'Cancelled'
	Result BatchJobResultType `json:"result,omitempty"`
	// Scheduler - The scheduler information.
	Scheduler *Scheduler `json:"schedulerInfo,omitempty"`
	// Plugin - The plugin information.
	Plugin *ServicePlugin `json:"pluginInfo,omitempty"`
	// Errors - The error information.
	Errors *[]ServiceError `json:"errorInfo,omitempty"`
	// Tags - The tags.
	Tags map[string]*string `json:"tags"`
	// ID - The session Id.
	ID *int32 `json:"id,omitempty"`
	// AppID - The application id of this session
	AppID *string `json:"appId,omitempty"`
	// AppInfo - The detailed application info.
	AppInfo map[string]*string `json:"appInfo"`
	// State - The batch state
	State *string `json:"state,omitempty"`
	// LogLines - The log lines.
	LogLines *[]string `json:"log,omitempty"`
}

// MarshalJSON is the custom marshaler for BatchJob.
func (bj BatchJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bj.LivyInfo != nil {
		objectMap["livyInfo"] = bj.LivyInfo
	}
	if bj.Name != nil {
		objectMap["name"] = bj.Name
	}
	if bj.WorkspaceName != nil {
		objectMap["workspaceName"] = bj.WorkspaceName
	}
	if bj.SparkPoolName != nil {
		objectMap["sparkPoolName"] = bj.SparkPoolName
	}
	if bj.SubmitterName != nil {
		objectMap["submitterName"] = bj.SubmitterName
	}
	if bj.SubmitterID != nil {
		objectMap["submitterId"] = bj.SubmitterID
	}
	if bj.ArtifactID != nil {
		objectMap["artifactId"] = bj.ArtifactID
	}
	if bj.JobType != "" {
		objectMap["jobType"] = bj.JobType
	}
	if bj.Result != "" {
		objectMap["result"] = bj.Result
	}
	if bj.Scheduler != nil {
		objectMap["schedulerInfo"] = bj.Scheduler
	}
	if bj.Plugin != nil {
		objectMap["pluginInfo"] = bj.Plugin
	}
	if bj.Errors != nil {
		objectMap["errorInfo"] = bj.Errors
	}
	if bj.Tags != nil {
		objectMap["tags"] = bj.Tags
	}
	if bj.ID != nil {
		objectMap["id"] = bj.ID
	}
	if bj.AppID != nil {
		objectMap["appId"] = bj.AppID
	}
	if bj.AppInfo != nil {
		objectMap["appInfo"] = bj.AppInfo
	}
	if bj.State != nil {
		objectMap["state"] = bj.State
	}
	if bj.LogLines != nil {
		objectMap["log"] = bj.LogLines
	}
	return json.Marshal(objectMap)
}

// BatchJobCollection response for batch list operation.
type BatchJobCollection struct {
	autorest.Response `json:"-"`
	// From - The start index of fetched sessions.
	From *int32 `json:"from,omitempty"`
	// Total - Number of sessions fetched.
	Total *int32 `json:"total,omitempty"`
	// Sessions - Batch list
	Sessions *[]BatchJob `json:"sessions,omitempty"`
}

// BatchJobOptions ...
type BatchJobOptions struct {
	Tags           map[string]*string `json:"tags"`
	ArtifactID     *string            `json:"artifactId,omitempty"`
	Name           *string            `json:"name,omitempty"`
	File           *string            `json:"file,omitempty"`
	ClassName      *string            `json:"className,omitempty"`
	Arguments      *[]string          `json:"args,omitempty"`
	Jars           *[]string          `json:"jars,omitempty"`
	PythonFiles    *[]string          `json:"pyFiles,omitempty"`
	Files          *[]string          `json:"files,omitempty"`
	Archives       *[]string          `json:"archives,omitempty"`
	Configuration  map[string]*string `json:"conf"`
	DriverMemory   *string            `json:"driverMemory,omitempty"`
	DriverCores    *int32             `json:"driverCores,omitempty"`
	ExecutorMemory *string            `json:"executorMemory,omitempty"`
	ExecutorCores  *int32             `json:"executorCores,omitempty"`
	ExecutorCount  *int32             `json:"numExecutors,omitempty"`
}

// MarshalJSON is the custom marshaler for BatchJobOptions.
func (bjo BatchJobOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bjo.Tags != nil {
		objectMap["tags"] = bjo.Tags
	}
	if bjo.ArtifactID != nil {
		objectMap["artifactId"] = bjo.ArtifactID
	}
	if bjo.Name != nil {
		objectMap["name"] = bjo.Name
	}
	if bjo.File != nil {
		objectMap["file"] = bjo.File
	}
	if bjo.ClassName != nil {
		objectMap["className"] = bjo.ClassName
	}
	if bjo.Arguments != nil {
		objectMap["args"] = bjo.Arguments
	}
	if bjo.Jars != nil {
		objectMap["jars"] = bjo.Jars
	}
	if bjo.PythonFiles != nil {
		objectMap["pyFiles"] = bjo.PythonFiles
	}
	if bjo.Files != nil {
		objectMap["files"] = bjo.Files
	}
	if bjo.Archives != nil {
		objectMap["archives"] = bjo.Archives
	}
	if bjo.Configuration != nil {
		objectMap["conf"] = bjo.Configuration
	}
	if bjo.DriverMemory != nil {
		objectMap["driverMemory"] = bjo.DriverMemory
	}
	if bjo.DriverCores != nil {
		objectMap["driverCores"] = bjo.DriverCores
	}
	if bjo.ExecutorMemory != nil {
		objectMap["executorMemory"] = bjo.ExecutorMemory
	}
	if bjo.ExecutorCores != nil {
		objectMap["executorCores"] = bjo.ExecutorCores
	}
	if bjo.ExecutorCount != nil {
		objectMap["numExecutors"] = bjo.ExecutorCount
	}
	return json.Marshal(objectMap)
}

// BatchJobState ...
type BatchJobState struct {
	// NotStartedAt - the time that at which "not_started" livy state was first seen.
	NotStartedAt *date.Time `json:"notStartedAt,omitempty"`
	// StartingAt - the time that at which "starting" livy state was first seen.
	StartingAt *date.Time `json:"startingAt,omitempty"`
	// RunningAt - the time that at which "running" livy state was first seen.
	RunningAt *date.Time `json:"runningAt,omitempty"`
	// DeadAt - time that at which "dead" livy state was first seen.
	DeadAt *date.Time `json:"deadAt,omitempty"`
	// SuccessAt - the time that at which "success" livy state was first seen.
	SuccessAt *date.Time `json:"successAt,omitempty"`
	// TerminatedAt - the time that at which "killed" livy state was first seen.
	TerminatedAt *date.Time `json:"killedAt,omitempty"`
	// RecoveringAt - the time that at which "recovering" livy state was first seen.
	RecoveringAt *date.Time `json:"recoveringAt,omitempty"`
	// CurrentState - the Spark job state.
	CurrentState       *string  `json:"currentState,omitempty"`
	JobCreationRequest *Request `json:"jobCreationRequest,omitempty"`
}

// Request ...
type Request struct {
	Name           *string            `json:"name,omitempty"`
	File           *string            `json:"file,omitempty"`
	ClassName      *string            `json:"className,omitempty"`
	Arguments      *[]string          `json:"args,omitempty"`
	Jars           *[]string          `json:"jars,omitempty"`
	PythonFiles    *[]string          `json:"pyFiles,omitempty"`
	Files          *[]string          `json:"files,omitempty"`
	Archives       *[]string          `json:"archives,omitempty"`
	Configuration  map[string]*string `json:"conf"`
	DriverMemory   *string            `json:"driverMemory,omitempty"`
	DriverCores    *int32             `json:"driverCores,omitempty"`
	ExecutorMemory *string            `json:"executorMemory,omitempty"`
	ExecutorCores  *int32             `json:"executorCores,omitempty"`
	ExecutorCount  *int32             `json:"numExecutors,omitempty"`
}

// MarshalJSON is the custom marshaler for Request.
func (r Request) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.File != nil {
		objectMap["file"] = r.File
	}
	if r.ClassName != nil {
		objectMap["className"] = r.ClassName
	}
	if r.Arguments != nil {
		objectMap["args"] = r.Arguments
	}
	if r.Jars != nil {
		objectMap["jars"] = r.Jars
	}
	if r.PythonFiles != nil {
		objectMap["pyFiles"] = r.PythonFiles
	}
	if r.Files != nil {
		objectMap["files"] = r.Files
	}
	if r.Archives != nil {
		objectMap["archives"] = r.Archives
	}
	if r.Configuration != nil {
		objectMap["conf"] = r.Configuration
	}
	if r.DriverMemory != nil {
		objectMap["driverMemory"] = r.DriverMemory
	}
	if r.DriverCores != nil {
		objectMap["driverCores"] = r.DriverCores
	}
	if r.ExecutorMemory != nil {
		objectMap["executorMemory"] = r.ExecutorMemory
	}
	if r.ExecutorCores != nil {
		objectMap["executorCores"] = r.ExecutorCores
	}
	if r.ExecutorCount != nil {
		objectMap["numExecutors"] = r.ExecutorCount
	}
	return json.Marshal(objectMap)
}

// Scheduler ...
type Scheduler struct {
	SubmittedAt             *date.Time `json:"submittedAt,omitempty"`
	ScheduledAt             *date.Time `json:"scheduledAt,omitempty"`
	EndedAt                 *date.Time `json:"endedAt,omitempty"`
	CancellationRequestedAt *date.Time `json:"cancellationRequestedAt,omitempty"`
	// CurrentState - Possible values include: 'SchedulerCurrentStateQueued', 'SchedulerCurrentStateScheduled', 'SchedulerCurrentStateEnded'
	CurrentState SchedulerCurrentState `json:"currentState,omitempty"`
}

// ServiceError ...
type ServiceError struct {
	Message   *string `json:"message,omitempty"`
	ErrorCode *string `json:"errorCode,omitempty"`
	// Source - Possible values include: 'System', 'User', 'Unknown', 'Dependency'
	Source ErrorSource `json:"source,omitempty"`
}

// ServicePlugin ...
type ServicePlugin struct {
	PreparationStartedAt         *date.Time `json:"preparationStartedAt,omitempty"`
	ResourceAcquisitionStartedAt *date.Time `json:"resourceAcquisitionStartedAt,omitempty"`
	SubmissionStartedAt          *date.Time `json:"submissionStartedAt,omitempty"`
	MonitoringStartedAt          *date.Time `json:"monitoringStartedAt,omitempty"`
	CleanupStartedAt             *date.Time `json:"cleanupStartedAt,omitempty"`
	// CurrentState - Possible values include: 'Preparation', 'ResourceAcquisition', 'Queued', 'Submission', 'Monitoring', 'Cleanup', 'Ended'
	CurrentState PluginCurrentState `json:"currentState,omitempty"`
}

// Session ...
type Session struct {
	autorest.Response `json:"-"`
	LivyInfo          *SessionState `json:"livyInfo,omitempty"`
	Name              *string       `json:"name,omitempty"`
	WorkspaceName     *string       `json:"workspaceName,omitempty"`
	SparkPoolName     *string       `json:"sparkPoolName,omitempty"`
	SubmitterName     *string       `json:"submitterName,omitempty"`
	SubmitterID       *string       `json:"submitterId,omitempty"`
	ArtifactID        *string       `json:"artifactId,omitempty"`
	// JobType - Possible values include: 'SparkBatch', 'SparkSession'
	JobType JobType `json:"jobType,omitempty"`
	// Result - Possible values include: 'SessionResultTypeUncertain', 'SessionResultTypeSucceeded', 'SessionResultTypeFailed', 'SessionResultTypeCancelled'
	Result    SessionResultType  `json:"result,omitempty"`
	Scheduler *Scheduler         `json:"schedulerInfo,omitempty"`
	Plugin    *ServicePlugin     `json:"pluginInfo,omitempty"`
	Errors    *[]ServiceError    `json:"errorInfo,omitempty"`
	Tags      map[string]*string `json:"tags"`
	ID        *int32             `json:"id,omitempty"`
	AppID     *string            `json:"appId,omitempty"`
	AppInfo   map[string]*string `json:"appInfo"`
	State     *string            `json:"state,omitempty"`
	LogLines  *[]string          `json:"log,omitempty"`
}

// MarshalJSON is the custom marshaler for Session.
func (s Session) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.LivyInfo != nil {
		objectMap["livyInfo"] = s.LivyInfo
	}
	if s.Name != nil {
		objectMap["name"] = s.Name
	}
	if s.WorkspaceName != nil {
		objectMap["workspaceName"] = s.WorkspaceName
	}
	if s.SparkPoolName != nil {
		objectMap["sparkPoolName"] = s.SparkPoolName
	}
	if s.SubmitterName != nil {
		objectMap["submitterName"] = s.SubmitterName
	}
	if s.SubmitterID != nil {
		objectMap["submitterId"] = s.SubmitterID
	}
	if s.ArtifactID != nil {
		objectMap["artifactId"] = s.ArtifactID
	}
	if s.JobType != "" {
		objectMap["jobType"] = s.JobType
	}
	if s.Result != "" {
		objectMap["result"] = s.Result
	}
	if s.Scheduler != nil {
		objectMap["schedulerInfo"] = s.Scheduler
	}
	if s.Plugin != nil {
		objectMap["pluginInfo"] = s.Plugin
	}
	if s.Errors != nil {
		objectMap["errorInfo"] = s.Errors
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	if s.ID != nil {
		objectMap["id"] = s.ID
	}
	if s.AppID != nil {
		objectMap["appId"] = s.AppID
	}
	if s.AppInfo != nil {
		objectMap["appInfo"] = s.AppInfo
	}
	if s.State != nil {
		objectMap["state"] = s.State
	}
	if s.LogLines != nil {
		objectMap["log"] = s.LogLines
	}
	return json.Marshal(objectMap)
}

// SessionCollection ...
type SessionCollection struct {
	autorest.Response `json:"-"`
	From              *int32     `json:"from,omitempty"`
	Total             *int32     `json:"total,omitempty"`
	Sessions          *[]Session `json:"sessions,omitempty"`
}

// SessionOptions ...
type SessionOptions struct {
	Tags           map[string]*string `json:"tags"`
	ArtifactID     *string            `json:"artifactId,omitempty"`
	Name           *string            `json:"name,omitempty"`
	File           *string            `json:"file,omitempty"`
	ClassName      *string            `json:"className,omitempty"`
	Arguments      *[]string          `json:"args,omitempty"`
	Jars           *[]string          `json:"jars,omitempty"`
	PythonFiles    *[]string          `json:"pyFiles,omitempty"`
	Files          *[]string          `json:"files,omitempty"`
	Archives       *[]string          `json:"archives,omitempty"`
	Configuration  map[string]*string `json:"conf"`
	DriverMemory   *string            `json:"driverMemory,omitempty"`
	DriverCores    *int32             `json:"driverCores,omitempty"`
	ExecutorMemory *string            `json:"executorMemory,omitempty"`
	ExecutorCores  *int32             `json:"executorCores,omitempty"`
	ExecutorCount  *int32             `json:"numExecutors,omitempty"`
}

// MarshalJSON is the custom marshaler for SessionOptions.
func (so SessionOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if so.Tags != nil {
		objectMap["tags"] = so.Tags
	}
	if so.ArtifactID != nil {
		objectMap["artifactId"] = so.ArtifactID
	}
	if so.Name != nil {
		objectMap["name"] = so.Name
	}
	if so.File != nil {
		objectMap["file"] = so.File
	}
	if so.ClassName != nil {
		objectMap["className"] = so.ClassName
	}
	if so.Arguments != nil {
		objectMap["args"] = so.Arguments
	}
	if so.Jars != nil {
		objectMap["jars"] = so.Jars
	}
	if so.PythonFiles != nil {
		objectMap["pyFiles"] = so.PythonFiles
	}
	if so.Files != nil {
		objectMap["files"] = so.Files
	}
	if so.Archives != nil {
		objectMap["archives"] = so.Archives
	}
	if so.Configuration != nil {
		objectMap["conf"] = so.Configuration
	}
	if so.DriverMemory != nil {
		objectMap["driverMemory"] = so.DriverMemory
	}
	if so.DriverCores != nil {
		objectMap["driverCores"] = so.DriverCores
	}
	if so.ExecutorMemory != nil {
		objectMap["executorMemory"] = so.ExecutorMemory
	}
	if so.ExecutorCores != nil {
		objectMap["executorCores"] = so.ExecutorCores
	}
	if so.ExecutorCount != nil {
		objectMap["numExecutors"] = so.ExecutorCount
	}
	return json.Marshal(objectMap)
}

// SessionState ...
type SessionState struct {
	NotStartedAt       *date.Time `json:"notStartedAt,omitempty"`
	StartingAt         *date.Time `json:"startingAt,omitempty"`
	IdleAt             *date.Time `json:"idleAt,omitempty"`
	DeadAt             *date.Time `json:"deadAt,omitempty"`
	ShuttingDownAt     *date.Time `json:"shuttingDownAt,omitempty"`
	TerminatedAt       *date.Time `json:"killedAt,omitempty"`
	RecoveringAt       *date.Time `json:"recoveringAt,omitempty"`
	BusyAt             *date.Time `json:"busyAt,omitempty"`
	ErrorAt            *date.Time `json:"errorAt,omitempty"`
	CurrentState       *string    `json:"currentState,omitempty"`
	JobCreationRequest *Request   `json:"jobCreationRequest,omitempty"`
}

// Statement ...
type Statement struct {
	autorest.Response `json:"-"`
	ID                *int32           `json:"id,omitempty"`
	Code              *string          `json:"code,omitempty"`
	State             *string          `json:"state,omitempty"`
	Output            *StatementOutput `json:"output,omitempty"`
}

// StatementCancellationResult ...
type StatementCancellationResult struct {
	autorest.Response `json:"-"`
	Msg               *string `json:"msg,omitempty"`
}

// StatementCollection ...
type StatementCollection struct {
	autorest.Response `json:"-"`
	Total             *int32       `json:"total_statements,omitempty"`
	Statements        *[]Statement `json:"statements,omitempty"`
}

// StatementOptions ...
type StatementOptions struct {
	Code *string `json:"code,omitempty"`
	// Kind - Possible values include: 'Spark', 'Pyspark', 'Dotnetspark', 'SQL'
	Kind StatementLanguageType `json:"kind,omitempty"`
}

// StatementOutput ...
type StatementOutput struct {
	Status         *string     `json:"status,omitempty"`
	ExecutionCount *int32      `json:"execution_count,omitempty"`
	Data           interface{} `json:"data,omitempty"`
	ErrorName      *string     `json:"ename,omitempty"`
	ErrorValue     *string     `json:"evalue,omitempty"`
	Traceback      *[]string   `json:"traceback,omitempty"`
}
