// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package databasemigrationservice provides a client for AWS Database Migration Service.
package databasemigrationservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddTagsToResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddTagsToResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddTagsToResourceRequest method.
//    req, resp := client.AddTagsToResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *request.Request, output *AddTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddTagsToResourceOutput{}
	req.Data = output
	return
}

// AddTagsToResource API operation for AWS Database Migration Service.
//
// Adds metadata tags to a DMS resource, including replication instance, endpoint,
// security group, and migration task. These tags can also be used with cost
// allocation reporting to track cost associated with DMS resources, or used
// in a Condition statement in an IAM policy for DMS.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation AddTagsToResource for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
func (c *DatabaseMigrationService) AddTagsToResource(input *AddTagsToResourceInput) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	err := req.Send()
	return out, err
}

const opCreateEndpoint = "CreateEndpoint"

// CreateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateEndpoint operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateEndpoint for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateEndpoint method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateEndpointRequest method.
//    req, resp := client.CreateEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) CreateEndpointRequest(input *CreateEndpointInput) (req *request.Request, output *CreateEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateEndpointOutput{}
	req.Data = output
	return
}

// CreateEndpoint API operation for AWS Database Migration Service.
//
// Creates an endpoint using the provided settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateEndpoint for usage and error information.
//
// Returned Error Codes:
//   * KMSKeyNotAccessibleFault
//   AWS DMS cannot access the KMS key.
//
//   * ResourceAlreadyExistsFault
//   The resource you are attempting to create already exists.
//
//   * ResourceQuotaExceededFault
//   The quota for this resource quota has been exceeded.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
func (c *DatabaseMigrationService) CreateEndpoint(input *CreateEndpointInput) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	err := req.Send()
	return out, err
}

const opCreateReplicationInstance = "CreateReplicationInstance"

// CreateReplicationInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplicationInstance operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateReplicationInstance for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateReplicationInstance method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateReplicationInstanceRequest method.
//    req, resp := client.CreateReplicationInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) CreateReplicationInstanceRequest(input *CreateReplicationInstanceInput) (req *request.Request, output *CreateReplicationInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateReplicationInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReplicationInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateReplicationInstanceOutput{}
	req.Data = output
	return
}

// CreateReplicationInstance API operation for AWS Database Migration Service.
//
// Creates the replication instance using the specified parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateReplicationInstance for usage and error information.
//
// Returned Error Codes:
//   * AccessDeniedFault
//   AWS DMS was denied access to the endpoint.
//
//   * ResourceAlreadyExistsFault
//   The resource you are attempting to create already exists.
//
//   * InsufficientResourceCapacityFault
//   There are not enough resources allocated to the database migration.
//
//   * ResourceQuotaExceededFault
//   The quota for this resource quota has been exceeded.
//
//   * StorageQuotaExceededFault
//   The storage quota has been exceeded.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * ReplicationSubnetGroupDoesNotCoverEnoughAZs
//   The replication subnet group does not cover enough Availability Zones (AZs).
//   Edit the replication subnet group and add more AZs.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * InvalidSubnet
//   The subnet provided is invalid.
//
//   * KMSKeyNotAccessibleFault
//   AWS DMS cannot access the KMS key.
//
func (c *DatabaseMigrationService) CreateReplicationInstance(input *CreateReplicationInstanceInput) (*CreateReplicationInstanceOutput, error) {
	req, out := c.CreateReplicationInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opCreateReplicationSubnetGroup = "CreateReplicationSubnetGroup"

// CreateReplicationSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplicationSubnetGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateReplicationSubnetGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateReplicationSubnetGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateReplicationSubnetGroupRequest method.
//    req, resp := client.CreateReplicationSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) CreateReplicationSubnetGroupRequest(input *CreateReplicationSubnetGroupInput) (req *request.Request, output *CreateReplicationSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opCreateReplicationSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReplicationSubnetGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateReplicationSubnetGroupOutput{}
	req.Data = output
	return
}

// CreateReplicationSubnetGroup API operation for AWS Database Migration Service.
//
// Creates a replication subnet group given a list of the subnet IDs in a VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateReplicationSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * AccessDeniedFault
//   AWS DMS was denied access to the endpoint.
//
//   * ResourceAlreadyExistsFault
//   The resource you are attempting to create already exists.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * ResourceQuotaExceededFault
//   The quota for this resource quota has been exceeded.
//
//   * ReplicationSubnetGroupDoesNotCoverEnoughAZs
//   The replication subnet group does not cover enough Availability Zones (AZs).
//   Edit the replication subnet group and add more AZs.
//
//   * InvalidSubnet
//   The subnet provided is invalid.
//
func (c *DatabaseMigrationService) CreateReplicationSubnetGroup(input *CreateReplicationSubnetGroupInput) (*CreateReplicationSubnetGroupOutput, error) {
	req, out := c.CreateReplicationSubnetGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateReplicationTask = "CreateReplicationTask"

// CreateReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplicationTask operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateReplicationTask for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateReplicationTask method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateReplicationTaskRequest method.
//    req, resp := client.CreateReplicationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) CreateReplicationTaskRequest(input *CreateReplicationTaskInput) (req *request.Request, output *CreateReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opCreateReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReplicationTaskInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateReplicationTaskOutput{}
	req.Data = output
	return
}

// CreateReplicationTask API operation for AWS Database Migration Service.
//
// Creates a replication task using the specified parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateReplicationTask for usage and error information.
//
// Returned Error Codes:
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceAlreadyExistsFault
//   The resource you are attempting to create already exists.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * KMSKeyNotAccessibleFault
//   AWS DMS cannot access the KMS key.
//
//   * ResourceQuotaExceededFault
//   The quota for this resource quota has been exceeded.
//
func (c *DatabaseMigrationService) CreateReplicationTask(input *CreateReplicationTaskInput) (*CreateReplicationTaskOutput, error) {
	req, out := c.CreateReplicationTaskRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteCertificate = "DeleteCertificate"

// DeleteCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteCertificateRequest method.
//    req, resp := client.DeleteCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) DeleteCertificateRequest(input *DeleteCertificateInput) (req *request.Request, output *DeleteCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteCertificateOutput{}
	req.Data = output
	return
}

// DeleteCertificate API operation for AWS Database Migration Service.
//
// Deletes the specified certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteCertificate for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
func (c *DatabaseMigrationService) DeleteCertificate(input *DeleteCertificateInput) (*DeleteCertificateOutput, error) {
	req, out := c.DeleteCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteEndpoint = "DeleteEndpoint"

// DeleteEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpoint operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteEndpoint for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteEndpoint method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteEndpointRequest method.
//    req, resp := client.DeleteEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) DeleteEndpointRequest(input *DeleteEndpointInput) (req *request.Request, output *DeleteEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEndpointInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteEndpointOutput{}
	req.Data = output
	return
}

// DeleteEndpoint API operation for AWS Database Migration Service.
//
// Deletes the specified endpoint.
//
// All tasks associated with the endpoint must be deleted before you can delete
// the endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
func (c *DatabaseMigrationService) DeleteEndpoint(input *DeleteEndpointInput) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteReplicationInstance = "DeleteReplicationInstance"

// DeleteReplicationInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationInstance operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteReplicationInstance for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteReplicationInstance method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteReplicationInstanceRequest method.
//    req, resp := client.DeleteReplicationInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) DeleteReplicationInstanceRequest(input *DeleteReplicationInstanceInput) (req *request.Request, output *DeleteReplicationInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteReplicationInstanceOutput{}
	req.Data = output
	return
}

// DeleteReplicationInstance API operation for AWS Database Migration Service.
//
// Deletes the specified replication instance.
//
// You must delete any migration tasks that are associated with the replication
// instance before you can delete it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteReplicationInstance for usage and error information.
//
// Returned Error Codes:
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
func (c *DatabaseMigrationService) DeleteReplicationInstance(input *DeleteReplicationInstanceInput) (*DeleteReplicationInstanceOutput, error) {
	req, out := c.DeleteReplicationInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteReplicationSubnetGroup = "DeleteReplicationSubnetGroup"

// DeleteReplicationSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationSubnetGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteReplicationSubnetGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteReplicationSubnetGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteReplicationSubnetGroupRequest method.
//    req, resp := client.DeleteReplicationSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) DeleteReplicationSubnetGroupRequest(input *DeleteReplicationSubnetGroupInput) (req *request.Request, output *DeleteReplicationSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationSubnetGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteReplicationSubnetGroupOutput{}
	req.Data = output
	return
}

// DeleteReplicationSubnetGroup API operation for AWS Database Migration Service.
//
// Deletes a subnet group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteReplicationSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
func (c *DatabaseMigrationService) DeleteReplicationSubnetGroup(input *DeleteReplicationSubnetGroupInput) (*DeleteReplicationSubnetGroupOutput, error) {
	req, out := c.DeleteReplicationSubnetGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteReplicationTask = "DeleteReplicationTask"

// DeleteReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationTask operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteReplicationTask for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteReplicationTask method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteReplicationTaskRequest method.
//    req, resp := client.DeleteReplicationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) DeleteReplicationTaskRequest(input *DeleteReplicationTaskInput) (req *request.Request, output *DeleteReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationTaskInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteReplicationTaskOutput{}
	req.Data = output
	return
}

// DeleteReplicationTask API operation for AWS Database Migration Service.
//
// Deletes the specified replication task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteReplicationTask for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
func (c *DatabaseMigrationService) DeleteReplicationTask(input *DeleteReplicationTaskInput) (*DeleteReplicationTaskOutput, error) {
	req, out := c.DeleteReplicationTaskRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAccountAttributes = "DescribeAccountAttributes"

// DescribeAccountAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAccountAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAccountAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAccountAttributesRequest method.
//    req, resp := client.DescribeAccountAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) DescribeAccountAttributesRequest(input *DescribeAccountAttributesInput) (req *request.Request, output *DescribeAccountAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAccountAttributesOutput{}
	req.Data = output
	return
}

// DescribeAccountAttributes API operation for AWS Database Migration Service.
//
// Lists all of the AWS DMS attributes for a customer account. The attributes
// include AWS DMS quotas for the account, such as the number of replication
// instances allowed. The description for a quota includes the quota name, current
// usage toward that quota, and the quota's maximum value.
//
// This command does not take any parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeAccountAttributes for usage and error information.
func (c *DatabaseMigrationService) DescribeAccountAttributes(input *DescribeAccountAttributesInput) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeCertificates = "DescribeCertificates"

// DescribeCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCertificates operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeCertificates for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeCertificates method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeCertificatesRequest method.
//    req, resp := client.DescribeCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) DescribeCertificatesRequest(input *DescribeCertificatesInput) (req *request.Request, output *DescribeCertificatesOutput) {
	op := &request.Operation{
		Name:       opDescribeCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCertificatesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCertificatesOutput{}
	req.Data = output
	return
}

// DescribeCertificates API operation for AWS Database Migration Service.
//
// Provides a description of the certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeCertificates for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
func (c *DatabaseMigrationService) DescribeCertificates(input *DescribeCertificatesInput) (*DescribeCertificatesOutput, error) {
	req, out := c.DescribeCertificatesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeConnections = "DescribeConnections"

// DescribeConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnections operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeConnections for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeConnections method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeConnectionsRequest method.
//    req, resp := client.DescribeConnectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) DescribeConnectionsRequest(input *DescribeConnectionsInput) (req *request.Request, output *DescribeConnectionsOutput) {
	op := &request.Operation{
		Name:       opDescribeConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeConnectionsOutput{}
	req.Data = output
	return
}

// DescribeConnections API operation for AWS Database Migration Service.
//
// Describes the status of the connections that have been made between the replication
// instance and an endpoint. Connections are created when you test an endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeConnections for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
func (c *DatabaseMigrationService) DescribeConnections(input *DescribeConnectionsInput) (*DescribeConnectionsOutput, error) {
	req, out := c.DescribeConnectionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeEndpointTypes = "DescribeEndpointTypes"

// DescribeEndpointTypesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpointTypes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeEndpointTypes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeEndpointTypes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeEndpointTypesRequest method.
//    req, resp := client.DescribeEndpointTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) DescribeEndpointTypesRequest(input *DescribeEndpointTypesInput) (req *request.Request, output *DescribeEndpointTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpointTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEndpointTypesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEndpointTypesOutput{}
	req.Data = output
	return
}

// DescribeEndpointTypes API operation for AWS Database Migration Service.
//
// Returns information about the type of endpoints available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeEndpointTypes for usage and error information.
func (c *DatabaseMigrationService) DescribeEndpointTypes(input *DescribeEndpointTypesInput) (*DescribeEndpointTypesOutput, error) {
	req, out := c.DescribeEndpointTypesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeEndpoints = "DescribeEndpoints"

// DescribeEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpoints operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeEndpoints for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeEndpoints method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeEndpointsRequest method.
//    req, resp := client.DescribeEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) DescribeEndpointsRequest(input *DescribeEndpointsInput) (req *request.Request, output *DescribeEndpointsOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEndpointsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEndpointsOutput{}
	req.Data = output
	return
}

// DescribeEndpoints API operation for AWS Database Migration Service.
//
// Returns information about the endpoints for your account in the current region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeEndpoints for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
func (c *DatabaseMigrationService) DescribeEndpoints(input *DescribeEndpointsInput) (*DescribeEndpointsOutput, error) {
	req, out := c.DescribeEndpointsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeOrderableReplicationInstances = "DescribeOrderableReplicationInstances"

// DescribeOrderableReplicationInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrderableReplicationInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeOrderableReplicationInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeOrderableReplicationInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeOrderableReplicationInstancesRequest method.
//    req, resp := client.DescribeOrderableReplicationInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) DescribeOrderableReplicationInstancesRequest(input *DescribeOrderableReplicationInstancesInput) (req *request.Request, output *DescribeOrderableReplicationInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeOrderableReplicationInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeOrderableReplicationInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeOrderableReplicationInstancesOutput{}
	req.Data = output
	return
}

// DescribeOrderableReplicationInstances API operation for AWS Database Migration Service.
//
// Returns information about the replication instance types that can be created
// in the specified region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeOrderableReplicationInstances for usage and error information.
func (c *DatabaseMigrationService) DescribeOrderableReplicationInstances(input *DescribeOrderableReplicationInstancesInput) (*DescribeOrderableReplicationInstancesOutput, error) {
	req, out := c.DescribeOrderableReplicationInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeRefreshSchemasStatus = "DescribeRefreshSchemasStatus"

// DescribeRefreshSchemasStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRefreshSchemasStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeRefreshSchemasStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeRefreshSchemasStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeRefreshSchemasStatusRequest method.
//    req, resp := client.DescribeRefreshSchemasStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) DescribeRefreshSchemasStatusRequest(input *DescribeRefreshSchemasStatusInput) (req *request.Request, output *DescribeRefreshSchemasStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeRefreshSchemasStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRefreshSchemasStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeRefreshSchemasStatusOutput{}
	req.Data = output
	return
}

// DescribeRefreshSchemasStatus API operation for AWS Database Migration Service.
//
// Returns the status of the RefreshSchemas operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeRefreshSchemasStatus for usage and error information.
//
// Returned Error Codes:
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
func (c *DatabaseMigrationService) DescribeRefreshSchemasStatus(input *DescribeRefreshSchemasStatusInput) (*DescribeRefreshSchemasStatusOutput, error) {
	req, out := c.DescribeRefreshSchemasStatusRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeReplicationInstances = "DescribeReplicationInstances"

// DescribeReplicationInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeReplicationInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeReplicationInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeReplicationInstancesRequest method.
//    req, resp := client.DescribeReplicationInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) DescribeReplicationInstancesRequest(input *DescribeReplicationInstancesInput) (req *request.Request, output *DescribeReplicationInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReplicationInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeReplicationInstancesOutput{}
	req.Data = output
	return
}

// DescribeReplicationInstances API operation for AWS Database Migration Service.
//
// Returns information about replication instances for your account in the current
// region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationInstances for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
func (c *DatabaseMigrationService) DescribeReplicationInstances(input *DescribeReplicationInstancesInput) (*DescribeReplicationInstancesOutput, error) {
	req, out := c.DescribeReplicationInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeReplicationSubnetGroups = "DescribeReplicationSubnetGroups"

// DescribeReplicationSubnetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationSubnetGroups operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeReplicationSubnetGroups for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeReplicationSubnetGroups method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeReplicationSubnetGroupsRequest method.
//    req, resp := client.DescribeReplicationSubnetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) DescribeReplicationSubnetGroupsRequest(input *DescribeReplicationSubnetGroupsInput) (req *request.Request, output *DescribeReplicationSubnetGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationSubnetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReplicationSubnetGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeReplicationSubnetGroupsOutput{}
	req.Data = output
	return
}

// DescribeReplicationSubnetGroups API operation for AWS Database Migration Service.
//
// Returns information about the replication subnet groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationSubnetGroups for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
func (c *DatabaseMigrationService) DescribeReplicationSubnetGroups(input *DescribeReplicationSubnetGroupsInput) (*DescribeReplicationSubnetGroupsOutput, error) {
	req, out := c.DescribeReplicationSubnetGroupsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeReplicationTasks = "DescribeReplicationTasks"

// DescribeReplicationTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationTasks operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeReplicationTasks for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeReplicationTasks method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeReplicationTasksRequest method.
//    req, resp := client.DescribeReplicationTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) DescribeReplicationTasksRequest(input *DescribeReplicationTasksInput) (req *request.Request, output *DescribeReplicationTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReplicationTasksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeReplicationTasksOutput{}
	req.Data = output
	return
}

// DescribeReplicationTasks API operation for AWS Database Migration Service.
//
// Returns information about replication tasks for your account in the current
// region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationTasks for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
func (c *DatabaseMigrationService) DescribeReplicationTasks(input *DescribeReplicationTasksInput) (*DescribeReplicationTasksOutput, error) {
	req, out := c.DescribeReplicationTasksRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSchemas = "DescribeSchemas"

// DescribeSchemasRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSchemas operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSchemas for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSchemas method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSchemasRequest method.
//    req, resp := client.DescribeSchemasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) DescribeSchemasRequest(input *DescribeSchemasInput) (req *request.Request, output *DescribeSchemasOutput) {
	op := &request.Operation{
		Name:       opDescribeSchemas,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSchemasInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSchemasOutput{}
	req.Data = output
	return
}

// DescribeSchemas API operation for AWS Database Migration Service.
//
// Returns information about the schema for the specified endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeSchemas for usage and error information.
//
// Returned Error Codes:
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
func (c *DatabaseMigrationService) DescribeSchemas(input *DescribeSchemasInput) (*DescribeSchemasOutput, error) {
	req, out := c.DescribeSchemasRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTableStatistics = "DescribeTableStatistics"

// DescribeTableStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTableStatistics operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTableStatistics for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTableStatistics method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTableStatisticsRequest method.
//    req, resp := client.DescribeTableStatisticsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) DescribeTableStatisticsRequest(input *DescribeTableStatisticsInput) (req *request.Request, output *DescribeTableStatisticsOutput) {
	op := &request.Operation{
		Name:       opDescribeTableStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTableStatisticsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTableStatisticsOutput{}
	req.Data = output
	return
}

// DescribeTableStatistics API operation for AWS Database Migration Service.
//
// Returns table statistics on the database migration task, including table
// name, rows inserted, rows updated, and rows deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeTableStatistics for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
func (c *DatabaseMigrationService) DescribeTableStatistics(input *DescribeTableStatisticsInput) (*DescribeTableStatisticsOutput, error) {
	req, out := c.DescribeTableStatisticsRequest(input)
	err := req.Send()
	return out, err
}

const opImportCertificate = "ImportCertificate"

// ImportCertificateRequest generates a "aws/request.Request" representing the
// client's request for the ImportCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ImportCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ImportCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ImportCertificateRequest method.
//    req, resp := client.ImportCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) ImportCertificateRequest(input *ImportCertificateInput) (req *request.Request, output *ImportCertificateOutput) {
	op := &request.Operation{
		Name:       opImportCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ImportCertificateOutput{}
	req.Data = output
	return
}

// ImportCertificate API operation for AWS Database Migration Service.
//
// Uploads the specified certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ImportCertificate for usage and error information.
//
// Returned Error Codes:
//   * ResourceAlreadyExistsFault
//   The resource you are attempting to create already exists.
//
//   * InvalidCertificateFault
//   The certificate was not valid.
//
func (c *DatabaseMigrationService) ImportCertificate(input *ImportCertificateInput) (*ImportCertificateOutput, error) {
	req, out := c.ImportCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTagsForResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTagsForResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTagsForResourceOutput{}
	req.Data = output
	return
}

// ListTagsForResource API operation for AWS Database Migration Service.
//
// Lists all tags for an AWS DMS resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
func (c *DatabaseMigrationService) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	err := req.Send()
	return out, err
}

const opModifyEndpoint = "ModifyEndpoint"

// ModifyEndpointRequest generates a "aws/request.Request" representing the
// client's request for the ModifyEndpoint operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyEndpoint for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyEndpoint method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyEndpointRequest method.
//    req, resp := client.ModifyEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) ModifyEndpointRequest(input *ModifyEndpointInput) (req *request.Request, output *ModifyEndpointOutput) {
	op := &request.Operation{
		Name:       opModifyEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyEndpointInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyEndpointOutput{}
	req.Data = output
	return
}

// ModifyEndpoint API operation for AWS Database Migration Service.
//
// Modifies the specified endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyEndpoint for usage and error information.
//
// Returned Error Codes:
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * ResourceAlreadyExistsFault
//   The resource you are attempting to create already exists.
//
//   * KMSKeyNotAccessibleFault
//   AWS DMS cannot access the KMS key.
//
func (c *DatabaseMigrationService) ModifyEndpoint(input *ModifyEndpointInput) (*ModifyEndpointOutput, error) {
	req, out := c.ModifyEndpointRequest(input)
	err := req.Send()
	return out, err
}

const opModifyReplicationInstance = "ModifyReplicationInstance"

// ModifyReplicationInstanceRequest generates a "aws/request.Request" representing the
// client's request for the ModifyReplicationInstance operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyReplicationInstance for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyReplicationInstance method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyReplicationInstanceRequest method.
//    req, resp := client.ModifyReplicationInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) ModifyReplicationInstanceRequest(input *ModifyReplicationInstanceInput) (req *request.Request, output *ModifyReplicationInstanceOutput) {
	op := &request.Operation{
		Name:       opModifyReplicationInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReplicationInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyReplicationInstanceOutput{}
	req.Data = output
	return
}

// ModifyReplicationInstance API operation for AWS Database Migration Service.
//
// Modifies the replication instance to apply new settings. You can change one
// or more parameters by specifying these parameters and the new values in the
// request.
//
// Some settings are applied during the maintenance window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyReplicationInstance for usage and error information.
//
// Returned Error Codes:
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceAlreadyExistsFault
//   The resource you are attempting to create already exists.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InsufficientResourceCapacityFault
//   There are not enough resources allocated to the database migration.
//
//   * StorageQuotaExceededFault
//   The storage quota has been exceeded.
//
//   * UpgradeDependencyFailureFault
//   An upgrade dependency is preventing the database migration.
//
func (c *DatabaseMigrationService) ModifyReplicationInstance(input *ModifyReplicationInstanceInput) (*ModifyReplicationInstanceOutput, error) {
	req, out := c.ModifyReplicationInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opModifyReplicationSubnetGroup = "ModifyReplicationSubnetGroup"

// ModifyReplicationSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyReplicationSubnetGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyReplicationSubnetGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyReplicationSubnetGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyReplicationSubnetGroupRequest method.
//    req, resp := client.ModifyReplicationSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) ModifyReplicationSubnetGroupRequest(input *ModifyReplicationSubnetGroupInput) (req *request.Request, output *ModifyReplicationSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opModifyReplicationSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReplicationSubnetGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyReplicationSubnetGroupOutput{}
	req.Data = output
	return
}

// ModifyReplicationSubnetGroup API operation for AWS Database Migration Service.
//
// Modifies the settings for the specified replication subnet group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyReplicationSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * AccessDeniedFault
//   AWS DMS was denied access to the endpoint.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * ResourceQuotaExceededFault
//   The quota for this resource quota has been exceeded.
//
//   * SubnetAlreadyInUse
//   The specified subnet is already in use.
//
//   * ReplicationSubnetGroupDoesNotCoverEnoughAZs
//   The replication subnet group does not cover enough Availability Zones (AZs).
//   Edit the replication subnet group and add more AZs.
//
//   * InvalidSubnet
//   The subnet provided is invalid.
//
func (c *DatabaseMigrationService) ModifyReplicationSubnetGroup(input *ModifyReplicationSubnetGroupInput) (*ModifyReplicationSubnetGroupOutput, error) {
	req, out := c.ModifyReplicationSubnetGroupRequest(input)
	err := req.Send()
	return out, err
}

const opRefreshSchemas = "RefreshSchemas"

// RefreshSchemasRequest generates a "aws/request.Request" representing the
// client's request for the RefreshSchemas operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RefreshSchemas for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RefreshSchemas method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RefreshSchemasRequest method.
//    req, resp := client.RefreshSchemasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) RefreshSchemasRequest(input *RefreshSchemasInput) (req *request.Request, output *RefreshSchemasOutput) {
	op := &request.Operation{
		Name:       opRefreshSchemas,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RefreshSchemasInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RefreshSchemasOutput{}
	req.Data = output
	return
}

// RefreshSchemas API operation for AWS Database Migration Service.
//
// Populates the schema for the specified endpoint. This is an asynchronous
// operation and can take several minutes. You can check the status of this
// operation by calling the DescribeRefreshSchemasStatus operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation RefreshSchemas for usage and error information.
//
// Returned Error Codes:
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * KMSKeyNotAccessibleFault
//   AWS DMS cannot access the KMS key.
//
//   * ResourceQuotaExceededFault
//   The quota for this resource quota has been exceeded.
//
func (c *DatabaseMigrationService) RefreshSchemas(input *RefreshSchemasInput) (*RefreshSchemasOutput, error) {
	req, out := c.RefreshSchemasRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemoveTagsFromResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemoveTagsFromResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemoveTagsFromResourceRequest method.
//    req, resp := client.RemoveTagsFromResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *request.Request, output *RemoveTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RemoveTagsFromResourceOutput{}
	req.Data = output
	return
}

// RemoveTagsFromResource API operation for AWS Database Migration Service.
//
// Removes metadata tags from a DMS resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation RemoveTagsFromResource for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
func (c *DatabaseMigrationService) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	err := req.Send()
	return out, err
}

const opStartReplicationTask = "StartReplicationTask"

// StartReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the StartReplicationTask operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See StartReplicationTask for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the StartReplicationTask method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the StartReplicationTaskRequest method.
//    req, resp := client.StartReplicationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) StartReplicationTaskRequest(input *StartReplicationTaskInput) (req *request.Request, output *StartReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opStartReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartReplicationTaskInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StartReplicationTaskOutput{}
	req.Data = output
	return
}

// StartReplicationTask API operation for AWS Database Migration Service.
//
// Starts the replication task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StartReplicationTask for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
func (c *DatabaseMigrationService) StartReplicationTask(input *StartReplicationTaskInput) (*StartReplicationTaskOutput, error) {
	req, out := c.StartReplicationTaskRequest(input)
	err := req.Send()
	return out, err
}

const opStopReplicationTask = "StopReplicationTask"

// StopReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the StopReplicationTask operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See StopReplicationTask for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the StopReplicationTask method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the StopReplicationTaskRequest method.
//    req, resp := client.StopReplicationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) StopReplicationTaskRequest(input *StopReplicationTaskInput) (req *request.Request, output *StopReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opStopReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopReplicationTaskInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StopReplicationTaskOutput{}
	req.Data = output
	return
}

// StopReplicationTask API operation for AWS Database Migration Service.
//
// Stops the replication task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StopReplicationTask for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
func (c *DatabaseMigrationService) StopReplicationTask(input *StopReplicationTaskInput) (*StopReplicationTaskOutput, error) {
	req, out := c.StopReplicationTaskRequest(input)
	err := req.Send()
	return out, err
}

const opTestConnection = "TestConnection"

// TestConnectionRequest generates a "aws/request.Request" representing the
// client's request for the TestConnection operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See TestConnection for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the TestConnection method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the TestConnectionRequest method.
//    req, resp := client.TestConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DatabaseMigrationService) TestConnectionRequest(input *TestConnectionInput) (req *request.Request, output *TestConnectionOutput) {
	op := &request.Operation{
		Name:       opTestConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestConnectionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &TestConnectionOutput{}
	req.Data = output
	return
}

// TestConnection API operation for AWS Database Migration Service.
//
// Tests the connection between the replication instance and the endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation TestConnection for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * KMSKeyNotAccessibleFault
//   AWS DMS cannot access the KMS key.
//
//   * ResourceQuotaExceededFault
//   The quota for this resource quota has been exceeded.
//
func (c *DatabaseMigrationService) TestConnection(input *TestConnectionInput) (*TestConnectionOutput, error) {
	req, out := c.TestConnectionRequest(input)
	err := req.Send()
	return out, err
}

// Describes a quota for an AWS account, for example, the number of replication
// instances allowed.
type AccountQuota struct {
	_ struct{} `type:"structure"`

	// The name of the AWS DMS quota for this AWS account.
	AccountQuotaName *string `type:"string"`

	// The maximum allowed value for the quota.
	Max *int64 `type:"long"`

	// The amount currently used toward the quota maximum.
	Used *int64 `type:"long"`
}

// String returns the string representation
func (s AccountQuota) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountQuota) GoString() string {
	return s.String()
}

type AddTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS DMS resource the tag is to be added
	// to. AWS DMS resources include a replication instance, endpoint, and a replication
	// task.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// The tag to be assigned to the DMS resource.
	//
	// Tags is a required field
	Tags []*Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AddTagsToResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceOutput) GoString() string {
	return s.String()
}

type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the availability zone.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// The SSL certificate that can be used to encrypt connections between the endpoints
// and the replication instance.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the certificate.
	CertificateArn *string `type:"string"`

	// the date the certificate was created.
	CertificateCreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The customer-assigned name of the certificate. Valid characters are [A-z_0-9].
	CertificateIdentifier *string `type:"string"`

	// The owner of the certificate.
	CertificateOwner *string `type:"string"`

	// The contents of the .pem X.509 certificate file.
	CertificatePem *string `type:"string"`

	// The key length of the cryptographic algorithm being used.
	KeyLength *int64 `type:"integer"`

	// The signing algorithm for the certificate.
	SigningAlgorithm *string `type:"string"`

	// The beginning date the certificate is valid.
	ValidFromDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// the final date the certificate is valid.
	ValidToDate *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Certificate) GoString() string {
	return s.String()
}

type Connection struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	EndpointArn *string `type:"string"`

	// The identifier of the endpoint. Identifiers must begin with a letter; must
	// contain only ASCII letters, digits, and hyphens; and must not end with a
	// hyphen or contain two consecutive hyphens.
	EndpointIdentifier *string `type:"string"`

	// The error message when the connection last failed.
	LastFailureMessage *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication instance.
	ReplicationInstanceArn *string `type:"string"`

	// The replication instance identifier. This parameter is stored as a lowercase
	// string.
	ReplicationInstanceIdentifier *string `type:"string"`

	// The connection status.
	Status *string `type:"string"`
}

// String returns the string representation
func (s Connection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Connection) GoString() string {
	return s.String()
}

type CreateEndpointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) for the certificate.
	CertificateArn *string `type:"string"`

	// The name of the endpoint database.
	DatabaseName *string `type:"string"`

	// The database endpoint identifier. Identifiers must begin with a letter; must
	// contain only ASCII letters, digits, and hyphens; and must not end with a
	// hyphen or contain two consecutive hyphens.
	//
	// EndpointIdentifier is a required field
	EndpointIdentifier *string `type:"string" required:"true"`

	// The type of endpoint.
	//
	// EndpointType is a required field
	EndpointType *string `type:"string" required:"true" enum:"ReplicationEndpointTypeValue"`

	// The type of engine for the endpoint. Valid values include MYSQL, ORACLE,
	// POSTGRES, MARIADB, AURORA, REDSHIFT, and SQLSERVER.
	//
	// EngineName is a required field
	EngineName *string `type:"string" required:"true"`

	// Additional attributes associated with the connection.
	ExtraConnectionAttributes *string `type:"string"`

	// The KMS key identifier that will be used to encrypt the connection parameters.
	// If you do not specify a value for the KmsKeyId parameter, then AWS DMS will
	// use your default encryption key. AWS KMS creates the default encryption key
	// for your AWS account. Your AWS account has a different default encryption
	// key for each AWS region.
	KmsKeyId *string `type:"string"`

	// The password to be used to login to the endpoint database.
	//
	// Password is a required field
	Password *string `type:"string" required:"true"`

	// The port used by the endpoint database.
	//
	// Port is a required field
	Port *int64 `type:"integer" required:"true"`

	// The name of the server where the endpoint database resides.
	//
	// ServerName is a required field
	ServerName *string `type:"string" required:"true"`

	// The SSL mode to use for the SSL connection.
	//
	// SSL mode can be one of four values: none, require, verify-ca, verify-full.
	//
	// The default value is none.
	SslMode *string `type:"string" enum:"DmsSslModeValue"`

	// Tags to be added to the endpoint.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The user name to be used to login to the endpoint database.
	//
	// Username is a required field
	Username *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEndpointInput"}
	if s.EndpointIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointIdentifier"))
	}
	if s.EndpointType == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointType"))
	}
	if s.EngineName == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineName"))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.ServerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerName"))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint that was created.
	Endpoint *Endpoint `type:"structure"`
}

// String returns the string representation
func (s CreateEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEndpointOutput) GoString() string {
	return s.String()
}

type CreateReplicationInstanceInput struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) to be initially allocated for the replication
	// instance.
	AllocatedStorage *int64 `type:"integer"`

	// Indicates that minor engine upgrades will be applied automatically to the
	// replication instance during the maintenance window.
	//
	// Default: true
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The EC2 Availability Zone that the replication instance will be created in.
	//
	// Default: A random, system-chosen Availability Zone in the endpoint's region.
	//
	// Example: us-east-1d
	AvailabilityZone *string `type:"string"`

	// The engine version number of the replication instance.
	EngineVersion *string `type:"string"`

	// The KMS key identifier that will be used to encrypt the content on the replication
	// instance. If you do not specify a value for the KmsKeyId parameter, then
	// AWS DMS will use your default encryption key. AWS KMS creates the default
	// encryption key for your AWS account. Your AWS account has a different default
	// encryption key for each AWS region.
	KmsKeyId *string `type:"string"`

	// Specifies if the replication instance is a Multi-AZ deployment. You cannot
	// set the AvailabilityZone parameter if the Multi-AZ parameter is set to true.
	MultiAZ *bool `type:"boolean"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Default: A 30-minute window selected at random from an 8-hour block of time
	// per region, occurring on a random day of the week.
	//
	// Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// Specifies the accessibility options for the replication instance. A value
	// of true represents an instance with a public IP address. A value of false
	// represents an instance with a private IP address. The default value is true.
	PubliclyAccessible *bool `type:"boolean"`

	// The compute and memory capacity of the replication instance as specified
	// by the replication instance class.
	//
	// Valid Values: dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large
	// | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge
	//
	// ReplicationInstanceClass is a required field
	ReplicationInstanceClass *string `type:"string" required:"true"`

	// The replication instance identifier. This parameter is stored as a lowercase
	// string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: myrepinstance
	//
	// ReplicationInstanceIdentifier is a required field
	ReplicationInstanceIdentifier *string `type:"string" required:"true"`

	// A subnet group to associate with the replication instance.
	ReplicationSubnetGroupIdentifier *string `type:"string"`

	// Tags to be associated with the replication instance.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// Specifies the VPC security group to be used with the replication instance.
	// The VPC security group must work with the VPC containing the replication
	// instance.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s CreateReplicationInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationInstanceInput"}
	if s.ReplicationInstanceClass == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceClass"))
	}
	if s.ReplicationInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateReplicationInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The replication instance that was created.
	ReplicationInstance *ReplicationInstance `type:"structure"`
}

// String returns the string representation
func (s CreateReplicationInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationInstanceOutput) GoString() string {
	return s.String()
}

type CreateReplicationSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The description for the subnet group.
	//
	// ReplicationSubnetGroupDescription is a required field
	ReplicationSubnetGroupDescription *string `type:"string" required:"true"`

	// The name for the replication subnet group. This value is stored as a lowercase
	// string.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters, periods,
	// spaces, underscores, or hyphens. Must not be "default".
	//
	// Example: mySubnetgroup
	//
	// ReplicationSubnetGroupIdentifier is a required field
	ReplicationSubnetGroupIdentifier *string `type:"string" required:"true"`

	// The EC2 subnet IDs for the subnet group.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationNameList:"SubnetIdentifier" type:"list" required:"true"`

	// The tag to be assigned to the subnet group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateReplicationSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationSubnetGroupInput"}
	if s.ReplicationSubnetGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationSubnetGroupDescription"))
	}
	if s.ReplicationSubnetGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationSubnetGroupIdentifier"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateReplicationSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The replication subnet group that was created.
	ReplicationSubnetGroup *ReplicationSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s CreateReplicationSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationSubnetGroupOutput) GoString() string {
	return s.String()
}

type CreateReplicationTaskInput struct {
	_ struct{} `type:"structure"`

	// The start time for the Change Data Capture (CDC) operation.
	CdcStartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The migration type.
	//
	// MigrationType is a required field
	MigrationType *string `type:"string" required:"true" enum:"MigrationTypeValue"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`

	// The replication task identifier.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// ReplicationTaskIdentifier is a required field
	ReplicationTaskIdentifier *string `type:"string" required:"true"`

	// Settings for the task, such as target metadata settings.
	ReplicationTaskSettings *string `type:"string"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// SourceEndpointArn is a required field
	SourceEndpointArn *string `type:"string" required:"true"`

	// The path of the JSON file that contains the table mappings. Preceed the path
	// with "file://".
	//
	// For example, --table-mappings file://mappingfile.json
	//
	// TableMappings is a required field
	TableMappings *string `type:"string" required:"true"`

	// Tags to be added to the replication instance.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// TargetEndpointArn is a required field
	TargetEndpointArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateReplicationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationTaskInput"}
	if s.MigrationType == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationType"))
	}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}
	if s.ReplicationTaskIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskIdentifier"))
	}
	if s.SourceEndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceEndpointArn"))
	}
	if s.TableMappings == nil {
		invalidParams.Add(request.NewErrParamRequired("TableMappings"))
	}
	if s.TargetEndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetEndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateReplicationTaskOutput struct {
	_ struct{} `type:"structure"`

	// The replication task that was created.
	ReplicationTask *ReplicationTask `type:"structure"`
}

// String returns the string representation
func (s CreateReplicationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationTaskOutput) GoString() string {
	return s.String()
}

type DeleteCertificateInput struct {
	_ struct{} `type:"structure"`

	// the Amazon Resource Name (ARN) of the deleted certificate.
	//
	// CertificateArn is a required field
	CertificateArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCertificateInput"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The SSL certificate.
	Certificate *Certificate `type:"structure"`
}

// String returns the string representation
func (s DeleteCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateOutput) GoString() string {
	return s.String()
}

type DeleteEndpointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEndpointInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint that was deleted.
	Endpoint *Endpoint `type:"structure"`
}

// String returns the string representation
func (s DeleteEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointOutput) GoString() string {
	return s.String()
}

type DeleteReplicationInstanceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the replication instance to be deleted.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReplicationInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationInstanceInput"}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteReplicationInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The replication instance that was deleted.
	ReplicationInstance *ReplicationInstance `type:"structure"`
}

// String returns the string representation
func (s DeleteReplicationInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationInstanceOutput) GoString() string {
	return s.String()
}

type DeleteReplicationSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The subnet group name of the replication instance.
	//
	// ReplicationSubnetGroupIdentifier is a required field
	ReplicationSubnetGroupIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReplicationSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationSubnetGroupInput"}
	if s.ReplicationSubnetGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationSubnetGroupIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteReplicationSubnetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteReplicationSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationSubnetGroupOutput) GoString() string {
	return s.String()
}

type DeleteReplicationTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the replication task to be deleted.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReplicationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationTaskInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteReplicationTaskOutput struct {
	_ struct{} `type:"structure"`

	// The deleted replication task.
	ReplicationTask *ReplicationTask `type:"structure"`
}

// String returns the string representation
func (s DeleteReplicationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationTaskOutput) GoString() string {
	return s.String()
}

type DescribeAccountAttributesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesInput) GoString() string {
	return s.String()
}

type DescribeAccountAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Account quota information.
	AccountQuotas []*AccountQuota `locationNameList:"AccountQuota" type:"list"`
}

// String returns the string representation
func (s DescribeAccountAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesOutput) GoString() string {
	return s.String()
}

type DescribeCertificatesInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the certificate described in the form of key-value pairs.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 10
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCertificatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCertificatesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// The SSL certificates associated with the replication instance.
	Certificates []*Certificate `locationNameList:"Certificate" type:"list"`

	// The pagination token.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificatesOutput) GoString() string {
	return s.String()
}

type DescribeConnectionsInput struct {
	_ struct{} `type:"structure"`

	// The filters applied to the connection.
	//
	// Valid filter names: endpoint-arn | replication-instance-arn
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConnectionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// A description of the connections.
	Connections []*Connection `locationNameList:"Connection" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectionsOutput) GoString() string {
	return s.String()
}

type DescribeEndpointTypesInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the describe action.
	//
	// Valid filter names: engine-name | endpoint-type
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeEndpointTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEndpointTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEndpointTypesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeEndpointTypesOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The type of endpoints that are supported.
	SupportedEndpointTypes []*SupportedEndpointType `locationNameList:"SupportedEndpointType" type:"list"`
}

// String returns the string representation
func (s DescribeEndpointTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointTypesOutput) GoString() string {
	return s.String()
}

type DescribeEndpointsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the describe action.
	//
	// Valid filter names: endpoint-arn | endpoint-type | endpoint-id | engine-name
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEndpointsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// Endpoint description.
	Endpoints []*Endpoint `locationNameList:"Endpoint" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointsOutput) GoString() string {
	return s.String()
}

type DescribeOrderableReplicationInstancesInput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeOrderableReplicationInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrderableReplicationInstancesInput) GoString() string {
	return s.String()
}

type DescribeOrderableReplicationInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The order-able replication instances available.
	OrderableReplicationInstances []*OrderableReplicationInstance `locationNameList:"OrderableReplicationInstance" type:"list"`
}

// String returns the string representation
func (s DescribeOrderableReplicationInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrderableReplicationInstancesOutput) GoString() string {
	return s.String()
}

type DescribeRefreshSchemasStatusInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRefreshSchemasStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRefreshSchemasStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRefreshSchemasStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRefreshSchemasStatusInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeRefreshSchemasStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status of the schema.
	RefreshSchemasStatus *RefreshSchemasStatus `type:"structure"`
}

// String returns the string representation
func (s DescribeRefreshSchemasStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRefreshSchemasStatusOutput) GoString() string {
	return s.String()
}

type DescribeReplicationInstancesInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the describe action.
	//
	// Valid filter names: replication-instance-arn | replication-instance-id |
	// replication-instance-class | engine-version
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeReplicationInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationInstancesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeReplicationInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The replication instances described.
	ReplicationInstances []*ReplicationInstance `locationNameList:"ReplicationInstance" type:"list"`
}

// String returns the string representation
func (s DescribeReplicationInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationInstancesOutput) GoString() string {
	return s.String()
}

type DescribeReplicationSubnetGroupsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the describe action.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeReplicationSubnetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationSubnetGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationSubnetGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationSubnetGroupsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeReplicationSubnetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// A description of the replication subnet groups.
	ReplicationSubnetGroups []*ReplicationSubnetGroup `locationNameList:"ReplicationSubnetGroup" type:"list"`
}

// String returns the string representation
func (s DescribeReplicationSubnetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationSubnetGroupsOutput) GoString() string {
	return s.String()
}

type DescribeReplicationTasksInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the describe action.
	//
	// Valid filter names: replication-task-arn | replication-task-id | migration-type
	// | endpoint-arn | replication-instance-arn
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeReplicationTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationTasksInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeReplicationTasksOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// A description of the replication tasks.
	ReplicationTasks []*ReplicationTask `locationNameList:"ReplicationTask" type:"list"`
}

// String returns the string representation
func (s DescribeReplicationTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationTasksOutput) GoString() string {
	return s.String()
}

type DescribeSchemasInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeSchemasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSchemasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSchemasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSchemasInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeSchemasOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The described schema.
	Schemas []*string `type:"list"`
}

// String returns the string representation
func (s DescribeSchemasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSchemasOutput) GoString() string {
	return s.String()
}

type DescribeTableStatisticsInput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the replication task.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTableStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTableStatisticsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTableStatisticsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTableStatisticsInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeTableStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication task.
	ReplicationTaskArn *string `type:"string"`

	// The table statistics.
	TableStatistics []*TableStatistics `type:"list"`
}

// String returns the string representation
func (s DescribeTableStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTableStatisticsOutput) GoString() string {
	return s.String()
}

type Endpoint struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) used for SSL connection to the endpoint.
	CertificateArn *string `type:"string"`

	// The name of the database at the endpoint.
	DatabaseName *string `type:"string"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	EndpointArn *string `type:"string"`

	// The database endpoint identifier. Identifiers must begin with a letter; must
	// contain only ASCII letters, digits, and hyphens; and must not end with a
	// hyphen or contain two consecutive hyphens.
	EndpointIdentifier *string `type:"string"`

	// The type of endpoint.
	EndpointType *string `type:"string" enum:"ReplicationEndpointTypeValue"`

	// The database engine name.
	EngineName *string `type:"string"`

	// Additional connection attributes used to connect to the endpoint.
	ExtraConnectionAttributes *string `type:"string"`

	// The KMS key identifier that will be used to encrypt the connection parameters.
	// If you do not specify a value for the KmsKeyId parameter, then AWS DMS will
	// use your default encryption key. AWS KMS creates the default encryption key
	// for your AWS account. Your AWS account has a different default encryption
	// key for each AWS region.
	KmsKeyId *string `type:"string"`

	// The port value used to access the endpoint.
	Port *int64 `type:"integer"`

	// The name of the server at the endpoint.
	ServerName *string `type:"string"`

	// The SSL mode used to connect to the endpoint.
	//
	// SSL mode can be one of four values: none, require, verify-ca, verify-full.
	//
	// The default value is none.
	SslMode *string `type:"string" enum:"DmsSslModeValue"`

	// The status of the endpoint.
	Status *string `type:"string"`

	// The user name used to connect to the endpoint.
	Username *string `type:"string"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Endpoint) GoString() string {
	return s.String()
}

type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The filter value.
	//
	// Values is a required field
	Values []*string `locationNameList:"Value" type:"list" required:"true"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ImportCertificateInput struct {
	_ struct{} `type:"structure"`

	// The customer-assigned name of the certificate. Valid characters are [A-z_0-9].
	//
	// CertificateIdentifier is a required field
	CertificateIdentifier *string `type:"string" required:"true"`

	// The contents of the .pem X.509 certificate file.
	CertificatePem *string `type:"string"`
}

// String returns the string representation
func (s ImportCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportCertificateInput"}
	if s.CertificateIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ImportCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The certificate to be uploaded.
	Certificate *Certificate `type:"structure"`
}

// String returns the string representation
func (s ImportCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportCertificateOutput) GoString() string {
	return s.String()
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the AWS DMS
	// resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags for the resource.
	TagList []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

type ModifyEndpointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the certificate used for SSL connection.
	CertificateArn *string `type:"string"`

	// The name of the endpoint database.
	DatabaseName *string `type:"string"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`

	// The database endpoint identifier. Identifiers must begin with a letter; must
	// contain only ASCII letters, digits, and hyphens; and must not end with a
	// hyphen or contain two consecutive hyphens.
	EndpointIdentifier *string `type:"string"`

	// The type of endpoint.
	EndpointType *string `type:"string" enum:"ReplicationEndpointTypeValue"`

	// The type of engine for the endpoint. Valid values include MYSQL, ORACLE,
	// POSTGRES, MARIADB, AURORA, REDSHIFT, and SQLSERVER.
	EngineName *string `type:"string"`

	// Additional attributes associated with the connection.
	ExtraConnectionAttributes *string `type:"string"`

	// The password to be used to login to the endpoint database.
	Password *string `type:"string"`

	// The port used by the endpoint database.
	Port *int64 `type:"integer"`

	// The name of the server where the endpoint database resides.
	ServerName *string `type:"string"`

	// The SSL mode to be used.
	//
	// SSL mode can be one of four values: none, require, verify-ca, verify-full.
	//
	// The default value is none.
	SslMode *string `type:"string" enum:"DmsSslModeValue"`

	// The user name to be used to login to the endpoint database.
	Username *string `type:"string"`
}

// String returns the string representation
func (s ModifyEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyEndpointInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The modified endpoint.
	Endpoint *Endpoint `type:"structure"`
}

// String returns the string representation
func (s ModifyEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEndpointOutput) GoString() string {
	return s.String()
}

type ModifyReplicationInstanceInput struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) to be allocated for the replication
	// instance.
	AllocatedStorage *int64 `type:"integer"`

	// Indicates that major version upgrades are allowed. Changing this parameter
	// does not result in an outage and the change is asynchronously applied as
	// soon as possible.
	//
	// Constraints: This parameter must be set to true when specifying a value for
	// the EngineVersion parameter that is a different major version than the replication
	// instance's current version.
	AllowMajorVersionUpgrade *bool `type:"boolean"`

	// Indicates whether the changes should be applied immediately or during the
	// next maintenance window.
	ApplyImmediately *bool `type:"boolean"`

	// Indicates that minor version upgrades will be applied automatically to the
	// replication instance during the maintenance window. Changing this parameter
	// does not result in an outage except in the following case and the change
	// is asynchronously applied as soon as possible. An outage will result if this
	// parameter is set to true during the maintenance window, and a newer minor
	// version is available, and AWS DMS has enabled auto patching for that engine
	// version.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The engine version number of the replication instance.
	EngineVersion *string `type:"string"`

	// Specifies if the replication instance is a Multi-AZ deployment. You cannot
	// set the AvailabilityZone parameter if the Multi-AZ parameter is set to true.
	MultiAZ *bool `type:"boolean"`

	// The weekly time range (in UTC) during which system maintenance can occur,
	// which might result in an outage. Changing this parameter does not result
	// in an outage, except in the following situation, and the change is asynchronously
	// applied as soon as possible. If moving this window to the current time, there
	// must be at least 30 minutes between the current time and end of the window
	// to ensure pending changes are applied.
	//
	// Default: Uses existing setting
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
	//
	// Constraints: Must be at least 30 minutes
	PreferredMaintenanceWindow *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`

	// The compute and memory capacity of the replication instance.
	//
	// Valid Values: dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large
	// | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge
	ReplicationInstanceClass *string `type:"string"`

	// The replication instance identifier. This parameter is stored as a lowercase
	// string.
	ReplicationInstanceIdentifier *string `type:"string"`

	// Specifies the VPC security group to be used with the replication instance.
	// The VPC security group must work with the VPC containing the replication
	// instance.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s ModifyReplicationInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyReplicationInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyReplicationInstanceInput"}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyReplicationInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The modified replication instance.
	ReplicationInstance *ReplicationInstance `type:"structure"`
}

// String returns the string representation
func (s ModifyReplicationInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationInstanceOutput) GoString() string {
	return s.String()
}

type ModifyReplicationSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The description of the replication instance subnet group.
	ReplicationSubnetGroupDescription *string `type:"string"`

	// The name of the replication instance subnet group.
	//
	// ReplicationSubnetGroupIdentifier is a required field
	ReplicationSubnetGroupIdentifier *string `type:"string" required:"true"`

	// A list of subnet IDs.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationNameList:"SubnetIdentifier" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyReplicationSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyReplicationSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyReplicationSubnetGroupInput"}
	if s.ReplicationSubnetGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationSubnetGroupIdentifier"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyReplicationSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The modified replication subnet group.
	ReplicationSubnetGroup *ReplicationSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyReplicationSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationSubnetGroupOutput) GoString() string {
	return s.String()
}

type OrderableReplicationInstance struct {
	_ struct{} `type:"structure"`

	// The default amount of storage (in gigabytes) that is allocated for the replication
	// instance.
	DefaultAllocatedStorage *int64 `type:"integer"`

	// The version of the replication engine.
	EngineVersion *string `type:"string"`

	// The amount of storage (in gigabytes) that is allocated for the replication
	// instance.
	IncludedAllocatedStorage *int64 `type:"integer"`

	// The minimum amount of storage (in gigabytes) that can be allocated for the
	// replication instance.
	MaxAllocatedStorage *int64 `type:"integer"`

	// The minimum amount of storage (in gigabytes) that can be allocated for the
	// replication instance.
	MinAllocatedStorage *int64 `type:"integer"`

	// The compute and memory capacity of the replication instance.
	//
	// Valid Values: dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large
	// | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge
	ReplicationInstanceClass *string `type:"string"`

	// The type of storage used by the replication instance.
	StorageType *string `type:"string"`
}

// String returns the string representation
func (s OrderableReplicationInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrderableReplicationInstance) GoString() string {
	return s.String()
}

type RefreshSchemasInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RefreshSchemasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RefreshSchemasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RefreshSchemasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RefreshSchemasInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RefreshSchemasOutput struct {
	_ struct{} `type:"structure"`

	// The status of the refreshed schema.
	RefreshSchemasStatus *RefreshSchemasStatus `type:"structure"`
}

// String returns the string representation
func (s RefreshSchemasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RefreshSchemasOutput) GoString() string {
	return s.String()
}

type RefreshSchemasStatus struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	EndpointArn *string `type:"string"`

	// The last failure message for the schema.
	LastFailureMessage *string `type:"string"`

	// The date the schema was last refreshed.
	LastRefreshDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the replication instance.
	ReplicationInstanceArn *string `type:"string"`

	// The status of the schema.
	Status *string `type:"string" enum:"RefreshSchemasStatusTypeValue"`
}

// String returns the string representation
func (s RefreshSchemasStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RefreshSchemasStatus) GoString() string {
	return s.String()
}

type RemoveTagsFromResourceInput struct {
	_ struct{} `type:"structure"`

	// >The Amazon Resource Name (ARN) of the AWS DMS resource the tag is to be
	// removed from.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// The tag key (name) of the tag to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RemoveTagsFromResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceOutput) GoString() string {
	return s.String()
}

type ReplicationInstance struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) that is allocated for the replication
	// instance.
	AllocatedStorage *int64 `type:"integer"`

	// Boolean value indicating if minor version upgrades will be automatically
	// applied to the instance.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The Availability Zone for the instance.
	AvailabilityZone *string `type:"string"`

	// The engine version number of the replication instance.
	EngineVersion *string `type:"string"`

	// The time the replication instance was created.
	InstanceCreateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The KMS key identifier that is used to encrypt the content on the replication
	// instance. If you do not specify a value for the KmsKeyId parameter, then
	// AWS DMS will use your default encryption key. AWS KMS creates the default
	// encryption key for your AWS account. Your AWS account has a different default
	// encryption key for each AWS region.
	KmsKeyId *string `type:"string"`

	// Specifies if the replication instance is a Multi-AZ deployment. You cannot
	// set the AvailabilityZone parameter if the Multi-AZ parameter is set to true.
	MultiAZ *bool `type:"boolean"`

	// The pending modification values.
	PendingModifiedValues *ReplicationPendingModifiedValues `type:"structure"`

	// The maintenance window times for the replication instance.
	PreferredMaintenanceWindow *string `type:"string"`

	// Specifies the accessibility options for the replication instance. A value
	// of true represents an instance with a public IP address. A value of false
	// represents an instance with a private IP address. The default value is true.
	PubliclyAccessible *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the replication instance.
	ReplicationInstanceArn *string `type:"string"`

	// The compute and memory capacity of the replication instance.
	//
	// Valid Values: dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large
	// | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge
	ReplicationInstanceClass *string `type:"string"`

	// The replication instance identifier. This parameter is stored as a lowercase
	// string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: myrepinstance
	ReplicationInstanceIdentifier *string `type:"string"`

	// The private IP address of the replication instance.
	ReplicationInstancePrivateIpAddress *string `deprecated:"true" type:"string"`

	// The private IP address of the replication instance.
	ReplicationInstancePrivateIpAddresses []*string `type:"list"`

	// The public IP address of the replication instance.
	ReplicationInstancePublicIpAddress *string `deprecated:"true" type:"string"`

	// The public IP address of the replication instance.
	ReplicationInstancePublicIpAddresses []*string `type:"list"`

	// The status of the replication instance.
	ReplicationInstanceStatus *string `type:"string"`

	// The subnet group for the replication instance.
	ReplicationSubnetGroup *ReplicationSubnetGroup `type:"structure"`

	// The VPC security group for the instance.
	VpcSecurityGroups []*VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroupMembership" type:"list"`
}

// String returns the string representation
func (s ReplicationInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationInstance) GoString() string {
	return s.String()
}

type ReplicationPendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) that is allocated for the replication
	// instance.
	AllocatedStorage *int64 `type:"integer"`

	// The engine version number of the replication instance.
	EngineVersion *string `type:"string"`

	// Specifies if the replication instance is a Multi-AZ deployment. You cannot
	// set the AvailabilityZone parameter if the Multi-AZ parameter is set to true.
	MultiAZ *bool `type:"boolean"`

	// The compute and memory capacity of the replication instance.
	//
	// Valid Values: dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large
	// | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge
	ReplicationInstanceClass *string `type:"string"`
}

// String returns the string representation
func (s ReplicationPendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationPendingModifiedValues) GoString() string {
	return s.String()
}

type ReplicationSubnetGroup struct {
	_ struct{} `type:"structure"`

	// The description of the replication subnet group.
	ReplicationSubnetGroupDescription *string `type:"string"`

	// The identifier of the replication instance subnet group.
	ReplicationSubnetGroupIdentifier *string `type:"string"`

	// The status of the subnet group.
	SubnetGroupStatus *string `type:"string"`

	// The subnets that are in the subnet group.
	Subnets []*Subnet `locationNameList:"Subnet" type:"list"`

	// The ID of the VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s ReplicationSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationSubnetGroup) GoString() string {
	return s.String()
}

type ReplicationTask struct {
	_ struct{} `type:"structure"`

	// The last error (failure) message generated for the replication instance.
	LastFailureMessage *string `type:"string"`

	// The type of migration.
	MigrationType *string `type:"string" enum:"MigrationTypeValue"`

	// The Amazon Resource Name (ARN) of the replication instance.
	ReplicationInstanceArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication task.
	ReplicationTaskArn *string `type:"string"`

	// The date the replication task was created.
	ReplicationTaskCreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The replication task identifier.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	ReplicationTaskIdentifier *string `type:"string"`

	// The settings for the replication task.
	ReplicationTaskSettings *string `type:"string"`

	// The date the replication task is scheduled to start.
	ReplicationTaskStartDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The statistics for the task, including elapsed time, tables loaded, and table
	// errors.
	ReplicationTaskStats *ReplicationTaskStats `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	SourceEndpointArn *string `type:"string"`

	// The status of the replication task.
	Status *string `type:"string"`

	// Table mappings specified in the task.
	TableMappings *string `type:"string"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	TargetEndpointArn *string `type:"string"`
}

// String returns the string representation
func (s ReplicationTask) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationTask) GoString() string {
	return s.String()
}

type ReplicationTaskStats struct {
	_ struct{} `type:"structure"`

	// The elapsed time of the task, in milliseconds.
	ElapsedTimeMillis *int64 `type:"long"`

	// The percent complete for the full load migration task.
	FullLoadProgressPercent *int64 `type:"integer"`

	// The number of errors that have occurred during this task.
	TablesErrored *int64 `type:"integer"`

	// The number of tables loaded for this task.
	TablesLoaded *int64 `type:"integer"`

	// The number of tables currently loading for this task.
	TablesLoading *int64 `type:"integer"`

	// The number of tables queued for this task.
	TablesQueued *int64 `type:"integer"`
}

// String returns the string representation
func (s ReplicationTaskStats) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationTaskStats) GoString() string {
	return s.String()
}

type StartReplicationTaskInput struct {
	_ struct{} `type:"structure"`

	// The start time for the Change Data Capture (CDC) operation.
	CdcStartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Number (ARN) of the replication task to be started.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`

	// The type of replication task.
	//
	// StartReplicationTaskType is a required field
	StartReplicationTaskType *string `type:"string" required:"true" enum:"StartReplicationTaskTypeValue"`
}

// String returns the string representation
func (s StartReplicationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartReplicationTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartReplicationTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartReplicationTaskInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}
	if s.StartReplicationTaskType == nil {
		invalidParams.Add(request.NewErrParamRequired("StartReplicationTaskType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartReplicationTaskOutput struct {
	_ struct{} `type:"structure"`

	// The replication task started.
	ReplicationTask *ReplicationTask `type:"structure"`
}

// String returns the string representation
func (s StartReplicationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartReplicationTaskOutput) GoString() string {
	return s.String()
}

type StopReplicationTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number(ARN) of the replication task to be stopped.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopReplicationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopReplicationTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopReplicationTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopReplicationTaskInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopReplicationTaskOutput struct {
	_ struct{} `type:"structure"`

	// The replication task stopped.
	ReplicationTask *ReplicationTask `type:"structure"`
}

// String returns the string representation
func (s StopReplicationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopReplicationTaskOutput) GoString() string {
	return s.String()
}

type Subnet struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of the subnet.
	SubnetAvailabilityZone *AvailabilityZone `type:"structure"`

	// The subnet identifier.
	SubnetIdentifier *string `type:"string"`

	// The status of the subnet.
	SubnetStatus *string `type:"string"`
}

// String returns the string representation
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subnet) GoString() string {
	return s.String()
}

type SupportedEndpointType struct {
	_ struct{} `type:"structure"`

	// The type of endpoint.
	EndpointType *string `type:"string" enum:"ReplicationEndpointTypeValue"`

	// The database engine name.
	EngineName *string `type:"string"`

	// Indicates if Change Data Capture (CDC) is supported.
	SupportsCDC *bool `type:"boolean"`
}

// String returns the string representation
func (s SupportedEndpointType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SupportedEndpointType) GoString() string {
	return s.String()
}

type TableStatistics struct {
	_ struct{} `type:"structure"`

	// The Data Definition Language (DDL) used to build and modify the structure
	// of your tables.
	Ddls *int64 `type:"long"`

	// The number of delete actions performed on a table.
	Deletes *int64 `type:"long"`

	// The number of rows added during the Full Load operation.
	FullLoadRows *int64 `type:"long"`

	// The number of insert actions performed on a table.
	Inserts *int64 `type:"long"`

	// The last time the table was updated.
	LastUpdateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The schema name.
	SchemaName *string `type:"string"`

	// The name of the table.
	TableName *string `type:"string"`

	// The state of the table.
	TableState *string `type:"string"`

	// The number of update actions performed on a table.
	Updates *int64 `type:"long"`
}

// String returns the string representation
func (s TableStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TableStatistics) GoString() string {
	return s.String()
}

type Tag struct {
	_ struct{} `type:"structure"`

	// A key is the required name of the tag. The string value can be from 1 to
	// 128 Unicode characters in length and cannot be prefixed with "aws:" or "dms:".
	// The string can only contain only the set of Unicode letters, digits, white-space,
	// '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Key *string `type:"string"`

	// A value is the optional value of the tag. The string value can be from 1
	// to 256 Unicode characters in length and cannot be prefixed with "aws:" or
	// "dms:". The string can only contain only the set of Unicode letters, digits,
	// white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

type TestConnectionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TestConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestConnectionInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type TestConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The connection tested.
	Connection *Connection `type:"structure"`
}

// String returns the string representation
func (s TestConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestConnectionOutput) GoString() string {
	return s.String()
}

type VpcSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `type:"string"`

	// The VPC security group Id.
	VpcSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s VpcSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcSecurityGroupMembership) GoString() string {
	return s.String()
}

const (
	// DmsSslModeValueNone is a DmsSslModeValue enum value
	DmsSslModeValueNone = "none"

	// DmsSslModeValueRequire is a DmsSslModeValue enum value
	DmsSslModeValueRequire = "require"

	// DmsSslModeValueVerifyCa is a DmsSslModeValue enum value
	DmsSslModeValueVerifyCa = "verify-ca"

	// DmsSslModeValueVerifyFull is a DmsSslModeValue enum value
	DmsSslModeValueVerifyFull = "verify-full"
)

const (
	// MigrationTypeValueFullLoad is a MigrationTypeValue enum value
	MigrationTypeValueFullLoad = "full-load"

	// MigrationTypeValueCdc is a MigrationTypeValue enum value
	MigrationTypeValueCdc = "cdc"

	// MigrationTypeValueFullLoadAndCdc is a MigrationTypeValue enum value
	MigrationTypeValueFullLoadAndCdc = "full-load-and-cdc"
)

const (
	// RefreshSchemasStatusTypeValueSuccessful is a RefreshSchemasStatusTypeValue enum value
	RefreshSchemasStatusTypeValueSuccessful = "successful"

	// RefreshSchemasStatusTypeValueFailed is a RefreshSchemasStatusTypeValue enum value
	RefreshSchemasStatusTypeValueFailed = "failed"

	// RefreshSchemasStatusTypeValueRefreshing is a RefreshSchemasStatusTypeValue enum value
	RefreshSchemasStatusTypeValueRefreshing = "refreshing"
)

const (
	// ReplicationEndpointTypeValueSource is a ReplicationEndpointTypeValue enum value
	ReplicationEndpointTypeValueSource = "source"

	// ReplicationEndpointTypeValueTarget is a ReplicationEndpointTypeValue enum value
	ReplicationEndpointTypeValueTarget = "target"
)

const (
	// StartReplicationTaskTypeValueStartReplication is a StartReplicationTaskTypeValue enum value
	StartReplicationTaskTypeValueStartReplication = "start-replication"

	// StartReplicationTaskTypeValueResumeProcessing is a StartReplicationTaskTypeValue enum value
	StartReplicationTaskTypeValueResumeProcessing = "resume-processing"

	// StartReplicationTaskTypeValueReloadTarget is a StartReplicationTaskTypeValue enum value
	StartReplicationTaskTypeValueReloadTarget = "reload-target"
)
