// Code generated by smithy-go-codegen DO NOT EDIT.

package kinesisanalyticsv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists information about operations performed on a Managed Service for Apache
// Flink application
func (c *Client) ListApplicationOperations(ctx context.Context, params *ListApplicationOperationsInput, optFns ...func(*Options)) (*ListApplicationOperationsOutput, error) {
	if params == nil {
		params = &ListApplicationOperationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListApplicationOperations", params, optFns, c.addOperationListApplicationOperationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListApplicationOperationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Request to list operations performed on an application
type ListApplicationOperationsInput struct {

	// The name of the application
	//
	// This member is required.
	ApplicationName *string

	// Limit on the number of records returned in the response
	Limit *int32

	// If a previous command returned a pagination token, pass it into this value to
	// retrieve the next set of results
	NextToken *string

	// Type of operation performed on an application
	Operation *string

	// Status of the operation performed on an application
	OperationStatus types.OperationStatus

	noSmithyDocumentSerde
}

// Response with the list of operations for an application
type ListApplicationOperationsOutput struct {

	// List of ApplicationOperationInfo for an application
	ApplicationOperationInfoList []types.ApplicationOperationInfo

	// If a previous command returned a pagination token, pass it into this value to
	// retrieve the next set of results
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListApplicationOperationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListApplicationOperations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListApplicationOperations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListApplicationOperations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListApplicationOperationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListApplicationOperations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListApplicationOperationsPaginatorOptions is the paginator options for
// ListApplicationOperations
type ListApplicationOperationsPaginatorOptions struct {
	// Limit on the number of records returned in the response
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListApplicationOperationsPaginator is a paginator for ListApplicationOperations
type ListApplicationOperationsPaginator struct {
	options   ListApplicationOperationsPaginatorOptions
	client    ListApplicationOperationsAPIClient
	params    *ListApplicationOperationsInput
	nextToken *string
	firstPage bool
}

// NewListApplicationOperationsPaginator returns a new
// ListApplicationOperationsPaginator
func NewListApplicationOperationsPaginator(client ListApplicationOperationsAPIClient, params *ListApplicationOperationsInput, optFns ...func(*ListApplicationOperationsPaginatorOptions)) *ListApplicationOperationsPaginator {
	if params == nil {
		params = &ListApplicationOperationsInput{}
	}

	options := ListApplicationOperationsPaginatorOptions{}
	if params.Limit != nil {
		options.Limit = *params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListApplicationOperationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListApplicationOperationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListApplicationOperations page.
func (p *ListApplicationOperationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListApplicationOperationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.Limit = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListApplicationOperations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListApplicationOperationsAPIClient is a client that implements the
// ListApplicationOperations operation.
type ListApplicationOperationsAPIClient interface {
	ListApplicationOperations(context.Context, *ListApplicationOperationsInput, ...func(*Options)) (*ListApplicationOperationsOutput, error)
}

var _ ListApplicationOperationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListApplicationOperations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListApplicationOperations",
	}
}
