/**************************************************************************/
/*  managed_type.h                                                        */
/**************************************************************************/
/*                         This file is part of:                          */
/*                             GODOT ENGINE                               */
/*                        https://godotengine.org                         */
/**************************************************************************/
/* Copyright (c) 2014-present Godot Engine contributors (see AUTHORS.md). */
/* Copyright (c) 2007-2014 Juan Linietsky, Ariel Manzur.                  */
/*                                                                        */
/* Permission is hereby granted, free of charge, to any person obtaining  */
/* a copy of this software and associated documentation files (the        */
/* "Software"), to deal in the Software without restriction, including    */
/* without limitation the rights to use, copy, modify, merge, publish,    */
/* distribute, sublicense, and/or sell copies of the Software, and to     */
/* permit persons to whom the Software is furnished to do so, subject to  */
/* the following conditions:                                              */
/*                                                                        */
/* The above copyright notice and this permission notice shall be         */
/* included in all copies or substantial portions of the Software.        */
/*                                                                        */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,        */
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF     */
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. */
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY   */
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,   */
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE      */
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                 */
/**************************************************************************/

#ifndef MANAGED_TYPE_H
#define MANAGED_TYPE_H

#include <mono/metadata/object.h>

#include "gd_mono_header.h"

struct ManagedType {
	int type_encoding;
	GDMonoClass *type_class;

	static ManagedType from_class(GDMonoClass *p_class);
	static ManagedType from_class(MonoClass *p_mono_class);
	static ManagedType from_type(MonoType *p_mono_type);
	static ManagedType from_reftype(MonoReflectionType *p_mono_reftype);

	ManagedType() :
			type_encoding(0),
			type_class(NULL) {
	}

	ManagedType(int p_type_encoding, GDMonoClass *p_type_class) :
			type_encoding(p_type_encoding),
			type_class(p_type_class) {
	}
};

#endif // MANAGED_TYPE_H
