/*******************************************************************************
*
*       This file is part of the General Hidden Markov Model Library,
*       GHMM version __VERSION__, see http://ghmm.org
*
*       Filename: sclass_change.h
*       Authors:  Benjamin Georgi
*
*       Copyright (C) 1998-2004 Alexander Schliep
*       Copyright (C) 1998-2001 ZAIK/ZPR, Universitaet zu Koeln
*       Copyright (C) 2002-2004 Max-Planck-Institut fuer Molekulare Genetik,
*                               Berlin
*
*       Contact: schliep@ghmm.org
*
*       This library is free software; you can redistribute it and/or
*       modify it under the terms of the GNU Library General Public
*       License as published by the Free Software Foundation; either
*       version 2 of the License, or (at your option) any later version.
*
*       This library is distributed in the hope that it will be useful,
*       but WITHOUT ANY WARRANTY; without even the implied warranty of
*       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*       Library General Public License for more details.
*
*       You should have received a copy of the GNU Library General Public
*       License along with this library; if not, write to the Free
*       Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*
*       This file is version $Revision: 1713 $
*                       from $Date: 2006-10-16 10:06:28 -0400 (Mon, 16 Oct 2006) $
*             last change by $Author: grunau $.
*
*******************************************************************************/

#ifndef SCLASS_CHANGE_H
#define SCLASS_CHANGE_H

#include <stdio.h>
#include <stdlib.h>
#include <ghmm/rng.h>
#include <ghmm/sequence.h>
#include <ghmm/sdmodel.h>

/* Function for class changes for switching models

   smo is a ghmm_cmodel struct
   seq is an double array of observations 
   k is the index of the current sequence w.r. to the collection of sequence seq came from
   t is the current sequence index in seq
*/
int cp_class_change( ghmm_cmodel *smo, double *seq, int k, int t);

/*
   setSwitchingFunction assigns cp_class_change as switching function in ghmm_dmodel smo.
   Needs to be modified for user defined C switching function.
*/
void setSwitchingFunction( ghmm_cmodel *smd );



/* Implements the Python Callback to the switching function defined in smo->class_change.
   Arguments ( which are analogue to cp_class_change (s.a.)) are parsed into Python data structures
   before the call-back.
*/
int python_class_change( ghmm_cmodel* smo, int* seq, int k, int t );


/* Assignment of Python module and function for class change. The values are stored in smo->class_change.
   
   smo: ghmm_cmodel struct with multiple transition classes
   python_module: Name of the module the switching function is defined in
   python_function: Name of the Python function to be used. 
   IMPORTANT: python_function must have a signature compatible to cp_class_change (that means three arguments:
   first the sequence (as a Python list), second sequence number, third the time step in the current sequence.
   See class_change.py in the ghmmwrapper directory for an example.)

*/
void setPythonSwitching( ghmm_cmodel *smd, char* python_module, char* python_function);

#endif
