/*
 * Decompiled with CFR 0.152.
 */
package mspccs_spreadsheet_tester.utility;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageProducer;
import java.net.URL;
import java.text.NumberFormat;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class Utility {
    public static void center(Container container, Component component) {
        Rectangle rectangle;
        Dimension dimension = component.getSize();
        if (container == null) {
            rectangle = new Rectangle(component.getToolkit().getScreenSize());
            rectangle.setLocation(0, 0);
        } else {
            rectangle = container.getBounds();
        }
        int n = rectangle.x + (rectangle.width / 2 - dimension.width / 2);
        int n2 = rectangle.y + (rectangle.height / 2 - dimension.height / 2);
        component.setLocation(n, n2);
    }

    public static void setIcon(JFrame jFrame, String string) {
        URL uRL = jFrame.getClass().getResource(string);
        try {
            Image image = jFrame.createImage((ImageProducer)uRL.getContent());
            jFrame.setIconImage(image);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String parseString(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    public static double getDoubleTextField(JTextField jTextField) {
        return Double.parseDouble(jTextField.getText().trim());
    }

    public static double toDouble(String string) {
        return Double.parseDouble(string);
    }

    public static void setTextField(JTextField jTextField, double d) {
        int n = 10;
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(n);
        numberFormat.setMinimumFractionDigits(n);
        numberFormat.setGroupingUsed(false);
        jTextField.setText(numberFormat.format(d));
        jTextField.setCaretPosition(0);
    }

    public static void setTextField(JTextField jTextField, double d, int n) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(n);
        numberFormat.setMinimumFractionDigits(n);
        numberFormat.setGroupingUsed(false);
        jTextField.setText(numberFormat.format(d));
        jTextField.setCaretPosition(0);
    }
}

