/*
  This file is part of GammaRay, the Qt application inspection and
  manipulation tool.

  Copyright (C) 2010-2019 Klarälvdalens Datakonsult AB, a KDAB Group company, info@kdab.com
  Author: Jan Arne Petersen <jan.petersen@kdab.com>

  Licensees holding valid commercial KDAB GammaRay licenses may use this file in
  accordance with GammaRay Commercial License Agreement provided with the Software.

  Contact info@kdab.com if any conditions of this licensing are not clear to you.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef GAMMARAY_STATEMACHINEVIEWER_QSCXMLSTATEMACHINEDEBUGINTERFACE_H
#define GAMMARAY_STATEMACHINEVIEWER_QSCXMLSTATEMACHINEDEBUGINTERFACE_H

#include "statemachinedebuginterface.h"

#include <private/qscxmlstatemachineinfo_p.h>
#include <QPointer>

QT_BEGIN_NAMESPACE
class QScxmlStateMachine;
class QScxmlStateMachineInfo;
QT_END_NAMESPACE

namespace GammaRay
{

class QScxmlStateMachineDebugInterface: public StateMachineDebugInterface
{
Q_OBJECT

public:
    explicit QScxmlStateMachineDebugInterface(QScxmlStateMachine *stateMachine, QObject *parent = nullptr);
    ~QScxmlStateMachineDebugInterface();

    bool isRunning() const override;
    void start() override;
    void stop() override;

    QVector<State> configuration() const override;
    State rootState() const override;
    bool stateValid(State state) const override;
    QVector<State> stateChildren(State state) const override;
    State parentState(State state) const override;
    bool isInitialState(State state) const override;
    QString transitions(State state) const override;
    QString stateLabel(State state) const override;
    QString stateDisplay(State state) const override;
    QString stateDisplayType(State state) const override;
    StateType stateType(State state) const override;
    QObject *stateObject(State state) const override;
    QVector<Transition> stateTransitions(State state) const override;
    QString transitionLabel(Transition transition) const override;
    State transitionSource(Transition transition) const override;
    QVector<State> transitionTargets(Transition transition) const override;

private slots:
    void statesEntered(const QVector<QScxmlStateMachineInfo::StateId> &states);
    void statesExited(const QVector<QScxmlStateMachineInfo::StateId> &states);
    void transitionsTriggered(const QVector<QScxmlStateMachineInfo::TransitionId> &transitions);

private:
    QScxmlStateMachine *m_stateMachine;
    QPointer<QScxmlStateMachineInfo> m_info;
};
}

#endif
