#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return ""

    def run(self):
        if self.env["runtime"]["PunctuationManager"].cycle_punctuation():
            self.env["runtime"]["OutputManager"].present_text(
                self.env["runtime"]["SettingsManager"].get_setting(
                    "general", "punctuationLevel"
                ),
                interrupt=True,
                ignore_punctuation=True,
            )
        else:
            self.env["runtime"]["OutputManager"].present_text(
                _("No punctuation found."),
                interrupt=True,
                ignore_punctuation=True,
            )

    def set_callback(self, callback):
        pass
