/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 11:37:25 GMT 2018
 */

package uk.ac.sanger.artemis.components;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.FileNotFoundException;
import javax.swing.JFrame;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.BioJavaEntrySource;
import uk.ac.sanger.artemis.components.ProgressThread;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class BioJavaEntrySource_ESTest extends BioJavaEntrySource_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      BioJavaEntrySource bioJavaEntrySource0 = new BioJavaEntrySource();
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("/nfs/team81/kmr/pow/java2/AE002734.game");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, "");
      ProgressThread progressThread0 = new ProgressThread((JFrame) null, "w@c");
      // Undeclared exception!
      try { 
        bioJavaEntrySource0.getEntry(true, progressThread0);
        fail("Expecting exception: NoClassDefFoundError");
      
      } catch(NoClassDefFoundError e) {
         //
         // Could not initialize class org.biojava.bio.seq.DNATools
         //
         verifyException("uk.ac.sanger.artemis.io.BioJavaEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      BioJavaEntrySource bioJavaEntrySource0 = new BioJavaEntrySource();
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("/nfs/team81/kmr/pow/java2/AE002734.game");
      FileSystemHandling.appendLineToFile(evoSuiteFile0, "|/)YF.Lrq,USMZe");
      // Undeclared exception!
      try { 
        bioJavaEntrySource0.getEntry(false);
        fail("Expecting exception: NoClassDefFoundError");
      
      } catch(NoClassDefFoundError e) {
         //
         // Could not initialize class org.biojava.bio.seq.DNATools
         //
         verifyException("uk.ac.sanger.artemis.io.BioJavaEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      BioJavaEntrySource bioJavaEntrySource0 = new BioJavaEntrySource();
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("/nfs/team81/kmr/pow/java2/AB000095.embl");
      FileSystemHandling.appendLineToFile(evoSuiteFile0, "");
      // Undeclared exception!
      try { 
        bioJavaEntrySource0.getEntry((Bases) null, true);
        fail("Expecting exception: NoClassDefFoundError");
      
      } catch(NoClassDefFoundError e) {
         //
         // Could not initialize class org.biojava.bio.seq.DNATools
         //
         verifyException("uk.ac.sanger.artemis.io.BioJavaEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      BioJavaEntrySource bioJavaEntrySource0 = new BioJavaEntrySource();
      ProgressThread progressThread0 = new ProgressThread((JFrame) null, "w@c");
      try { 
        bioJavaEntrySource0.getEntry(true, progressThread0);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      BioJavaEntrySource bioJavaEntrySource0 = new BioJavaEntrySource();
      try { 
        bioJavaEntrySource0.getEntry((Bases) null, true);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      BioJavaEntrySource bioJavaEntrySource0 = new BioJavaEntrySource();
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("/nfs/team81/kmr/pow/java2/AE002734.game");
      Bases bases0 = new Bases(rawStreamSequence0);
      try { 
        bioJavaEntrySource0.getEntry(bases0, (ProgressThread) null, true);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      BioJavaEntrySource bioJavaEntrySource0 = new BioJavaEntrySource();
      try { 
        bioJavaEntrySource0.getEntry(false);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      BioJavaEntrySource bioJavaEntrySource0 = new BioJavaEntrySource();
      String string0 = bioJavaEntrySource0.getSourceName();
      assertEquals("BioJava", string0);
  }

  @Test(timeout = 4000)
  public void test8()  throws Throwable  {
      BioJavaEntrySource bioJavaEntrySource0 = new BioJavaEntrySource();
      boolean boolean0 = bioJavaEntrySource0.isFullEntrySource();
      assertTrue(boolean0);
  }
}
