# ANGLE Starter Projects

For the most up-to-date list of starter projects, see
[anglebug.com](https://bugs.chromium.org/p/angleproject/issues/list?q=Hotlist%3DStarterBug).  If you
decide to take on any task, write a comment so you can get in touch with us, and more importantly,
set yourself as the "owner" of the bug.  This avoids having multiple people accidentally working on
the same issue.

## Refactors

### EGL Validation Refactoring

[anglebug.com/798](http://anglebug.com/798)

Move all EGL validation into separate functions in ValidationEGL.h. This opens up many possibilities
for auto-generation of entry points and is simply a cleaner structure.

### EGL Entry Point Auto-generation

[anglebug.com/2621](http://anglebug.com/2621)

Auto-generate EGL entry points and stub functions. This greatly reduces the chance of bugs in this
highly repetitive code and reduces the friction to adding new extensions.

### Support Separate Read and Draw Surfaces

[anglebug.com/2620](http://anglebug.com/2620)

ANGLE has never supported binding separate read and draw surfaces with eglMakeCurrent due to its
architecture. Some refactoring could be done to support this use case.

### Convert GLenums into typed internal Enums

[anglebug.com/2169](http://anglebug.com/2169)

Using a compact enum instead of GLenum offers type safety. Flat enums can also index into flat
arrays. We are in the process of migrating all internal GLenums into packed enums.

## Medium Features

### Add an AST Validator to the Shader Translator

[anglebug.com/2733](http://anglebug.com/2733)

An AST validator will reduce the number of bugs in our AST transforms and allow us to be more
confident about all ASTs generated by the translator.

## Small Features

### Fix shader source viewing in RenderDoc/NSIGHT

[anglebug.com/2734](http://anglebug.com/2734)

It used to be possible to view the shader source when debugging shaders in graphics debuggers but
now only the shader disassembly is available.

### Implement Android CDD Extensions

[anglebug.com/2506](http://anglebug.com/2506)

The Android CDD requires some EGL and OpenGL ES extensions from every driver. Many of them are
simply exposing the native driver's extension to ANGLE's frontend.

## Performance

### Add perf test for eglMakeCurrent

[anglebug.com/2556](http://anglebug.com/2556)

Many customers switch Contexts frequently. MakeCurrent shows up as a hotspot. A performance test
would protect against regressions.

### Refactor std::maps into Static Arrays

[anglebug.com/1389](http://anglebug.com/1389)

ANGLE uses internal global maps for texture tables. We should rewrite them to save on binary size
and optimize startup time.

## Maintenance

### Add a presubmit python script

[anglebug.com/2626](http://anglebug.com/2626)

This simple script could verify that there is no diff on git cl upload.  This saves developer time
in the long run.

## Conformance

### Vulkan ES2 fixes

[anglebug.com/2615](http://anglebug.com/2615) - see open blocking bugs. Also
[this link](https://bugs.chromium.org/p/angleproject/issues/list?can=2&q=Renderer%3DVulkan+-has%3Aowner&colspec=ID+Type+Status+Priority+Feature+Owner+Summary&cells=ids)
for open issues.

Many small edge cases still need attention.

### WebGL Conformance on Windows

[tracking document](https://docs.google.com/spreadsheets/d/1NQePFOdCKT1WKG2P4Qt8igLrLVy4U3vLOLvVWwbkllw/edit?usp=sharing)

ANGLE is preparing to release its OpenGL backend on Windows in Chrome using the passthrough command
decoder. There are still some failing WebGL tests.

### EGL Conformance

[anglebug.com/2623](http://anglebug.com/2623)

ANGLE's EGL implementation has a lot of holes in it's conformance. There are many tests that fail on
all platforms due to bugs in ANGLE's EGL frontend.
