//! Autogenerated: 'src/ExtractionOCaml/unsaturated_solinas' --lang Rust --inline p448 32 16 '2^448 - 2^224 - 1' carry_mul carry_square carry add sub opp selectznz to_bytes from_bytes relax
//! curve description: p448
//! machine_wordsize = 32 (from "32")
//! requested operations: carry_mul, carry_square, carry, add, sub, opp, selectznz, to_bytes, from_bytes, relax
//! n = 16 (from "16")
//! s-c = 2^448 - [(2^224, 1), (1, 1)] (from "2^448 - 2^224 - 1")
//! tight_bounds_multiplier = 1 (from "")
//!
//! Computed values:
//!   carry_chain = [7, 15, 8, 0, 9, 1, 10, 2, 11, 3, 12, 4, 13, 5, 14, 6, 15, 7, 8, 0]
//!   eval z = z[0] + (z[1] << 28) + (z[2] << 56) + (z[3] << 84) + (z[4] << 112) + (z[5] << 140) + (z[6] << 168) + (z[7] << 196) + (z[8] << 224) + (z[9] << 252) + (z[10] << 0x118) + (z[11] << 0x134) + (z[12] << 0x150) + (z[13] << 0x16c) + (z[14] << 0x188) + (z[15] << 0x1a4)
//!   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178) + (z[48] << 0x180) + (z[49] << 0x188) + (z[50] << 0x190) + (z[51] << 0x198) + (z[52] << 0x1a0) + (z[53] << 0x1a8) + (z[54] << 0x1b0) + (z[55] << 0x1b8)
//!   balance = [0x1ffffffe, 0x1ffffffe, 0x1ffffffe, 0x1ffffffe, 0x1ffffffe, 0x1ffffffe, 0x1ffffffe, 0x1ffffffe, 0x1ffffffc, 0x1ffffffe, 0x1ffffffe, 0x1ffffffe, 0x1ffffffe, 0x1ffffffe, 0x1ffffffe, 0x1ffffffe]

#![allow(unused_parens)]
#![allow(non_camel_case_types)]

pub type fiat_p448_u1 = u8;
pub type fiat_p448_i1 = i8;
pub type fiat_p448_u2 = u8;
pub type fiat_p448_i2 = i8;

/* The type fiat_p448_loose_field_element is a field element with loose bounds. */
/* Bounds: [[0x0 ~> 0x30000000], [0x0 ~> 0x30000000], [0x0 ~> 0x30000000], [0x0 ~> 0x30000000], [0x0 ~> 0x30000000], [0x0 ~> 0x30000000], [0x0 ~> 0x30000000], [0x0 ~> 0x30000000], [0x0 ~> 0x30000000], [0x0 ~> 0x30000000], [0x0 ~> 0x30000000], [0x0 ~> 0x30000000], [0x0 ~> 0x30000000], [0x0 ~> 0x30000000], [0x0 ~> 0x30000000], [0x0 ~> 0x30000000]] */
pub type fiat_p448_loose_field_element = [u32; 16];

/* The type fiat_p448_tight_field_element is a field element with tight bounds. */
/* Bounds: [[0x0 ~> 0x10000000], [0x0 ~> 0x10000000], [0x0 ~> 0x10000000], [0x0 ~> 0x10000000], [0x0 ~> 0x10000000], [0x0 ~> 0x10000000], [0x0 ~> 0x10000000], [0x0 ~> 0x10000000], [0x0 ~> 0x10000000], [0x0 ~> 0x10000000], [0x0 ~> 0x10000000], [0x0 ~> 0x10000000], [0x0 ~> 0x10000000], [0x0 ~> 0x10000000], [0x0 ~> 0x10000000], [0x0 ~> 0x10000000]] */
pub type fiat_p448_tight_field_element = [u32; 16];


/// The function fiat_p448_addcarryx_u28 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^28
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^28⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xfffffff]
///   arg3: [0x0 ~> 0xfffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xfffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p448_addcarryx_u28(out1: &mut u32, out2: &mut fiat_p448_u1, arg1: fiat_p448_u1, arg2: u32, arg3: u32) -> () {
  let x1: u32 = (((arg1 as u32) + arg2) + arg3);
  let x2: u32 = (x1 & 0xfffffff);
  let x3: fiat_p448_u1 = ((x1 >> 28) as fiat_p448_u1);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_p448_subborrowx_u28 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^28
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^28⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xfffffff]
///   arg3: [0x0 ~> 0xfffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xfffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p448_subborrowx_u28(out1: &mut u32, out2: &mut fiat_p448_u1, arg1: fiat_p448_u1, arg2: u32, arg3: u32) -> () {
  let x1: i32 = ((((((arg2 as i64) - (arg1 as i64)) as i32) as i64) - (arg3 as i64)) as i32);
  let x2: fiat_p448_i1 = ((x1 >> 28) as fiat_p448_i1);
  let x3: u32 = (((x1 as i64) & (0xfffffff as i64)) as u32);
  *out1 = x3;
  *out2 = (((0x0 as fiat_p448_i2) - (x2 as fiat_p448_i2)) as fiat_p448_u1);
}

/// The function fiat_p448_cmovznz_u32 is a single-word conditional move.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
#[inline]
pub fn fiat_p448_cmovznz_u32(out1: &mut u32, arg1: fiat_p448_u1, arg2: u32, arg3: u32) -> () {
  let x1: fiat_p448_u1 = (!(!arg1));
  let x2: u32 = ((((((0x0 as fiat_p448_i2) - (x1 as fiat_p448_i2)) as fiat_p448_i1) as i64) & (0xffffffff as i64)) as u32);
  let x3: u32 = ((x2 & arg3) | ((!x2) & arg2));
  *out1 = x3;
}

/// The function fiat_p448_carry_mul multiplies two field elements and reduces the result.
///
/// Postconditions:
///   eval out1 mod m = (eval arg1 * eval arg2) mod m
///
#[inline]
pub fn fiat_p448_carry_mul(out1: &mut fiat_p448_tight_field_element, arg1: &fiat_p448_loose_field_element, arg2: &fiat_p448_loose_field_element) -> () {
  let x1: u64 = (((arg1[15]) as u64) * ((arg2[15]) as u64));
  let x2: u64 = (((arg1[15]) as u64) * ((arg2[14]) as u64));
  let x3: u64 = (((arg1[15]) as u64) * ((arg2[13]) as u64));
  let x4: u64 = (((arg1[15]) as u64) * ((arg2[12]) as u64));
  let x5: u64 = (((arg1[15]) as u64) * ((arg2[11]) as u64));
  let x6: u64 = (((arg1[15]) as u64) * ((arg2[10]) as u64));
  let x7: u64 = (((arg1[15]) as u64) * ((arg2[9]) as u64));
  let x8: u64 = (((arg1[14]) as u64) * ((arg2[15]) as u64));
  let x9: u64 = (((arg1[14]) as u64) * ((arg2[14]) as u64));
  let x10: u64 = (((arg1[14]) as u64) * ((arg2[13]) as u64));
  let x11: u64 = (((arg1[14]) as u64) * ((arg2[12]) as u64));
  let x12: u64 = (((arg1[14]) as u64) * ((arg2[11]) as u64));
  let x13: u64 = (((arg1[14]) as u64) * ((arg2[10]) as u64));
  let x14: u64 = (((arg1[13]) as u64) * ((arg2[15]) as u64));
  let x15: u64 = (((arg1[13]) as u64) * ((arg2[14]) as u64));
  let x16: u64 = (((arg1[13]) as u64) * ((arg2[13]) as u64));
  let x17: u64 = (((arg1[13]) as u64) * ((arg2[12]) as u64));
  let x18: u64 = (((arg1[13]) as u64) * ((arg2[11]) as u64));
  let x19: u64 = (((arg1[12]) as u64) * ((arg2[15]) as u64));
  let x20: u64 = (((arg1[12]) as u64) * ((arg2[14]) as u64));
  let x21: u64 = (((arg1[12]) as u64) * ((arg2[13]) as u64));
  let x22: u64 = (((arg1[12]) as u64) * ((arg2[12]) as u64));
  let x23: u64 = (((arg1[11]) as u64) * ((arg2[15]) as u64));
  let x24: u64 = (((arg1[11]) as u64) * ((arg2[14]) as u64));
  let x25: u64 = (((arg1[11]) as u64) * ((arg2[13]) as u64));
  let x26: u64 = (((arg1[10]) as u64) * ((arg2[15]) as u64));
  let x27: u64 = (((arg1[10]) as u64) * ((arg2[14]) as u64));
  let x28: u64 = (((arg1[9]) as u64) * ((arg2[15]) as u64));
  let x29: u64 = (((arg1[15]) as u64) * ((arg2[15]) as u64));
  let x30: u64 = (((arg1[15]) as u64) * ((arg2[14]) as u64));
  let x31: u64 = (((arg1[15]) as u64) * ((arg2[13]) as u64));
  let x32: u64 = (((arg1[15]) as u64) * ((arg2[12]) as u64));
  let x33: u64 = (((arg1[15]) as u64) * ((arg2[11]) as u64));
  let x34: u64 = (((arg1[15]) as u64) * ((arg2[10]) as u64));
  let x35: u64 = (((arg1[15]) as u64) * ((arg2[9]) as u64));
  let x36: u64 = (((arg1[14]) as u64) * ((arg2[15]) as u64));
  let x37: u64 = (((arg1[14]) as u64) * ((arg2[14]) as u64));
  let x38: u64 = (((arg1[14]) as u64) * ((arg2[13]) as u64));
  let x39: u64 = (((arg1[14]) as u64) * ((arg2[12]) as u64));
  let x40: u64 = (((arg1[14]) as u64) * ((arg2[11]) as u64));
  let x41: u64 = (((arg1[14]) as u64) * ((arg2[10]) as u64));
  let x42: u64 = (((arg1[13]) as u64) * ((arg2[15]) as u64));
  let x43: u64 = (((arg1[13]) as u64) * ((arg2[14]) as u64));
  let x44: u64 = (((arg1[13]) as u64) * ((arg2[13]) as u64));
  let x45: u64 = (((arg1[13]) as u64) * ((arg2[12]) as u64));
  let x46: u64 = (((arg1[13]) as u64) * ((arg2[11]) as u64));
  let x47: u64 = (((arg1[12]) as u64) * ((arg2[15]) as u64));
  let x48: u64 = (((arg1[12]) as u64) * ((arg2[14]) as u64));
  let x49: u64 = (((arg1[12]) as u64) * ((arg2[13]) as u64));
  let x50: u64 = (((arg1[12]) as u64) * ((arg2[12]) as u64));
  let x51: u64 = (((arg1[11]) as u64) * ((arg2[15]) as u64));
  let x52: u64 = (((arg1[11]) as u64) * ((arg2[14]) as u64));
  let x53: u64 = (((arg1[11]) as u64) * ((arg2[13]) as u64));
  let x54: u64 = (((arg1[10]) as u64) * ((arg2[15]) as u64));
  let x55: u64 = (((arg1[10]) as u64) * ((arg2[14]) as u64));
  let x56: u64 = (((arg1[9]) as u64) * ((arg2[15]) as u64));
  let x57: u64 = (((arg1[15]) as u64) * ((arg2[15]) as u64));
  let x58: u64 = (((arg1[15]) as u64) * ((arg2[14]) as u64));
  let x59: u64 = (((arg1[15]) as u64) * ((arg2[13]) as u64));
  let x60: u64 = (((arg1[15]) as u64) * ((arg2[12]) as u64));
  let x61: u64 = (((arg1[15]) as u64) * ((arg2[11]) as u64));
  let x62: u64 = (((arg1[15]) as u64) * ((arg2[10]) as u64));
  let x63: u64 = (((arg1[15]) as u64) * ((arg2[9]) as u64));
  let x64: u64 = (((arg1[15]) as u64) * ((arg2[8]) as u64));
  let x65: u64 = (((arg1[15]) as u64) * ((arg2[7]) as u64));
  let x66: u64 = (((arg1[15]) as u64) * ((arg2[6]) as u64));
  let x67: u64 = (((arg1[15]) as u64) * ((arg2[5]) as u64));
  let x68: u64 = (((arg1[15]) as u64) * ((arg2[4]) as u64));
  let x69: u64 = (((arg1[15]) as u64) * ((arg2[3]) as u64));
  let x70: u64 = (((arg1[15]) as u64) * ((arg2[2]) as u64));
  let x71: u64 = (((arg1[15]) as u64) * ((arg2[1]) as u64));
  let x72: u64 = (((arg1[14]) as u64) * ((arg2[15]) as u64));
  let x73: u64 = (((arg1[14]) as u64) * ((arg2[14]) as u64));
  let x74: u64 = (((arg1[14]) as u64) * ((arg2[13]) as u64));
  let x75: u64 = (((arg1[14]) as u64) * ((arg2[12]) as u64));
  let x76: u64 = (((arg1[14]) as u64) * ((arg2[11]) as u64));
  let x77: u64 = (((arg1[14]) as u64) * ((arg2[10]) as u64));
  let x78: u64 = (((arg1[14]) as u64) * ((arg2[9]) as u64));
  let x79: u64 = (((arg1[14]) as u64) * ((arg2[8]) as u64));
  let x80: u64 = (((arg1[14]) as u64) * ((arg2[7]) as u64));
  let x81: u64 = (((arg1[14]) as u64) * ((arg2[6]) as u64));
  let x82: u64 = (((arg1[14]) as u64) * ((arg2[5]) as u64));
  let x83: u64 = (((arg1[14]) as u64) * ((arg2[4]) as u64));
  let x84: u64 = (((arg1[14]) as u64) * ((arg2[3]) as u64));
  let x85: u64 = (((arg1[14]) as u64) * ((arg2[2]) as u64));
  let x86: u64 = (((arg1[13]) as u64) * ((arg2[15]) as u64));
  let x87: u64 = (((arg1[13]) as u64) * ((arg2[14]) as u64));
  let x88: u64 = (((arg1[13]) as u64) * ((arg2[13]) as u64));
  let x89: u64 = (((arg1[13]) as u64) * ((arg2[12]) as u64));
  let x90: u64 = (((arg1[13]) as u64) * ((arg2[11]) as u64));
  let x91: u64 = (((arg1[13]) as u64) * ((arg2[10]) as u64));
  let x92: u64 = (((arg1[13]) as u64) * ((arg2[9]) as u64));
  let x93: u64 = (((arg1[13]) as u64) * ((arg2[8]) as u64));
  let x94: u64 = (((arg1[13]) as u64) * ((arg2[7]) as u64));
  let x95: u64 = (((arg1[13]) as u64) * ((arg2[6]) as u64));
  let x96: u64 = (((arg1[13]) as u64) * ((arg2[5]) as u64));
  let x97: u64 = (((arg1[13]) as u64) * ((arg2[4]) as u64));
  let x98: u64 = (((arg1[13]) as u64) * ((arg2[3]) as u64));
  let x99: u64 = (((arg1[12]) as u64) * ((arg2[15]) as u64));
  let x100: u64 = (((arg1[12]) as u64) * ((arg2[14]) as u64));
  let x101: u64 = (((arg1[12]) as u64) * ((arg2[13]) as u64));
  let x102: u64 = (((arg1[12]) as u64) * ((arg2[12]) as u64));
  let x103: u64 = (((arg1[12]) as u64) * ((arg2[11]) as u64));
  let x104: u64 = (((arg1[12]) as u64) * ((arg2[10]) as u64));
  let x105: u64 = (((arg1[12]) as u64) * ((arg2[9]) as u64));
  let x106: u64 = (((arg1[12]) as u64) * ((arg2[8]) as u64));
  let x107: u64 = (((arg1[12]) as u64) * ((arg2[7]) as u64));
  let x108: u64 = (((arg1[12]) as u64) * ((arg2[6]) as u64));
  let x109: u64 = (((arg1[12]) as u64) * ((arg2[5]) as u64));
  let x110: u64 = (((arg1[12]) as u64) * ((arg2[4]) as u64));
  let x111: u64 = (((arg1[11]) as u64) * ((arg2[15]) as u64));
  let x112: u64 = (((arg1[11]) as u64) * ((arg2[14]) as u64));
  let x113: u64 = (((arg1[11]) as u64) * ((arg2[13]) as u64));
  let x114: u64 = (((arg1[11]) as u64) * ((arg2[12]) as u64));
  let x115: u64 = (((arg1[11]) as u64) * ((arg2[11]) as u64));
  let x116: u64 = (((arg1[11]) as u64) * ((arg2[10]) as u64));
  let x117: u64 = (((arg1[11]) as u64) * ((arg2[9]) as u64));
  let x118: u64 = (((arg1[11]) as u64) * ((arg2[8]) as u64));
  let x119: u64 = (((arg1[11]) as u64) * ((arg2[7]) as u64));
  let x120: u64 = (((arg1[11]) as u64) * ((arg2[6]) as u64));
  let x121: u64 = (((arg1[11]) as u64) * ((arg2[5]) as u64));
  let x122: u64 = (((arg1[10]) as u64) * ((arg2[15]) as u64));
  let x123: u64 = (((arg1[10]) as u64) * ((arg2[14]) as u64));
  let x124: u64 = (((arg1[10]) as u64) * ((arg2[13]) as u64));
  let x125: u64 = (((arg1[10]) as u64) * ((arg2[12]) as u64));
  let x126: u64 = (((arg1[10]) as u64) * ((arg2[11]) as u64));
  let x127: u64 = (((arg1[10]) as u64) * ((arg2[10]) as u64));
  let x128: u64 = (((arg1[10]) as u64) * ((arg2[9]) as u64));
  let x129: u64 = (((arg1[10]) as u64) * ((arg2[8]) as u64));
  let x130: u64 = (((arg1[10]) as u64) * ((arg2[7]) as u64));
  let x131: u64 = (((arg1[10]) as u64) * ((arg2[6]) as u64));
  let x132: u64 = (((arg1[9]) as u64) * ((arg2[15]) as u64));
  let x133: u64 = (((arg1[9]) as u64) * ((arg2[14]) as u64));
  let x134: u64 = (((arg1[9]) as u64) * ((arg2[13]) as u64));
  let x135: u64 = (((arg1[9]) as u64) * ((arg2[12]) as u64));
  let x136: u64 = (((arg1[9]) as u64) * ((arg2[11]) as u64));
  let x137: u64 = (((arg1[9]) as u64) * ((arg2[10]) as u64));
  let x138: u64 = (((arg1[9]) as u64) * ((arg2[9]) as u64));
  let x139: u64 = (((arg1[9]) as u64) * ((arg2[8]) as u64));
  let x140: u64 = (((arg1[9]) as u64) * ((arg2[7]) as u64));
  let x141: u64 = (((arg1[8]) as u64) * ((arg2[15]) as u64));
  let x142: u64 = (((arg1[8]) as u64) * ((arg2[14]) as u64));
  let x143: u64 = (((arg1[8]) as u64) * ((arg2[13]) as u64));
  let x144: u64 = (((arg1[8]) as u64) * ((arg2[12]) as u64));
  let x145: u64 = (((arg1[8]) as u64) * ((arg2[11]) as u64));
  let x146: u64 = (((arg1[8]) as u64) * ((arg2[10]) as u64));
  let x147: u64 = (((arg1[8]) as u64) * ((arg2[9]) as u64));
  let x148: u64 = (((arg1[8]) as u64) * ((arg2[8]) as u64));
  let x149: u64 = (((arg1[7]) as u64) * ((arg2[15]) as u64));
  let x150: u64 = (((arg1[7]) as u64) * ((arg2[14]) as u64));
  let x151: u64 = (((arg1[7]) as u64) * ((arg2[13]) as u64));
  let x152: u64 = (((arg1[7]) as u64) * ((arg2[12]) as u64));
  let x153: u64 = (((arg1[7]) as u64) * ((arg2[11]) as u64));
  let x154: u64 = (((arg1[7]) as u64) * ((arg2[10]) as u64));
  let x155: u64 = (((arg1[7]) as u64) * ((arg2[9]) as u64));
  let x156: u64 = (((arg1[6]) as u64) * ((arg2[15]) as u64));
  let x157: u64 = (((arg1[6]) as u64) * ((arg2[14]) as u64));
  let x158: u64 = (((arg1[6]) as u64) * ((arg2[13]) as u64));
  let x159: u64 = (((arg1[6]) as u64) * ((arg2[12]) as u64));
  let x160: u64 = (((arg1[6]) as u64) * ((arg2[11]) as u64));
  let x161: u64 = (((arg1[6]) as u64) * ((arg2[10]) as u64));
  let x162: u64 = (((arg1[5]) as u64) * ((arg2[15]) as u64));
  let x163: u64 = (((arg1[5]) as u64) * ((arg2[14]) as u64));
  let x164: u64 = (((arg1[5]) as u64) * ((arg2[13]) as u64));
  let x165: u64 = (((arg1[5]) as u64) * ((arg2[12]) as u64));
  let x166: u64 = (((arg1[5]) as u64) * ((arg2[11]) as u64));
  let x167: u64 = (((arg1[4]) as u64) * ((arg2[15]) as u64));
  let x168: u64 = (((arg1[4]) as u64) * ((arg2[14]) as u64));
  let x169: u64 = (((arg1[4]) as u64) * ((arg2[13]) as u64));
  let x170: u64 = (((arg1[4]) as u64) * ((arg2[12]) as u64));
  let x171: u64 = (((arg1[3]) as u64) * ((arg2[15]) as u64));
  let x172: u64 = (((arg1[3]) as u64) * ((arg2[14]) as u64));
  let x173: u64 = (((arg1[3]) as u64) * ((arg2[13]) as u64));
  let x174: u64 = (((arg1[2]) as u64) * ((arg2[15]) as u64));
  let x175: u64 = (((arg1[2]) as u64) * ((arg2[14]) as u64));
  let x176: u64 = (((arg1[1]) as u64) * ((arg2[15]) as u64));
  let x177: u64 = (((arg1[15]) as u64) * ((arg2[8]) as u64));
  let x178: u64 = (((arg1[15]) as u64) * ((arg2[7]) as u64));
  let x179: u64 = (((arg1[15]) as u64) * ((arg2[6]) as u64));
  let x180: u64 = (((arg1[15]) as u64) * ((arg2[5]) as u64));
  let x181: u64 = (((arg1[15]) as u64) * ((arg2[4]) as u64));
  let x182: u64 = (((arg1[15]) as u64) * ((arg2[3]) as u64));
  let x183: u64 = (((arg1[15]) as u64) * ((arg2[2]) as u64));
  let x184: u64 = (((arg1[15]) as u64) * ((arg2[1]) as u64));
  let x185: u64 = (((arg1[14]) as u64) * ((arg2[9]) as u64));
  let x186: u64 = (((arg1[14]) as u64) * ((arg2[8]) as u64));
  let x187: u64 = (((arg1[14]) as u64) * ((arg2[7]) as u64));
  let x188: u64 = (((arg1[14]) as u64) * ((arg2[6]) as u64));
  let x189: u64 = (((arg1[14]) as u64) * ((arg2[5]) as u64));
  let x190: u64 = (((arg1[14]) as u64) * ((arg2[4]) as u64));
  let x191: u64 = (((arg1[14]) as u64) * ((arg2[3]) as u64));
  let x192: u64 = (((arg1[14]) as u64) * ((arg2[2]) as u64));
  let x193: u64 = (((arg1[13]) as u64) * ((arg2[10]) as u64));
  let x194: u64 = (((arg1[13]) as u64) * ((arg2[9]) as u64));
  let x195: u64 = (((arg1[13]) as u64) * ((arg2[8]) as u64));
  let x196: u64 = (((arg1[13]) as u64) * ((arg2[7]) as u64));
  let x197: u64 = (((arg1[13]) as u64) * ((arg2[6]) as u64));
  let x198: u64 = (((arg1[13]) as u64) * ((arg2[5]) as u64));
  let x199: u64 = (((arg1[13]) as u64) * ((arg2[4]) as u64));
  let x200: u64 = (((arg1[13]) as u64) * ((arg2[3]) as u64));
  let x201: u64 = (((arg1[12]) as u64) * ((arg2[11]) as u64));
  let x202: u64 = (((arg1[12]) as u64) * ((arg2[10]) as u64));
  let x203: u64 = (((arg1[12]) as u64) * ((arg2[9]) as u64));
  let x204: u64 = (((arg1[12]) as u64) * ((arg2[8]) as u64));
  let x205: u64 = (((arg1[12]) as u64) * ((arg2[7]) as u64));
  let x206: u64 = (((arg1[12]) as u64) * ((arg2[6]) as u64));
  let x207: u64 = (((arg1[12]) as u64) * ((arg2[5]) as u64));
  let x208: u64 = (((arg1[12]) as u64) * ((arg2[4]) as u64));
  let x209: u64 = (((arg1[11]) as u64) * ((arg2[12]) as u64));
  let x210: u64 = (((arg1[11]) as u64) * ((arg2[11]) as u64));
  let x211: u64 = (((arg1[11]) as u64) * ((arg2[10]) as u64));
  let x212: u64 = (((arg1[11]) as u64) * ((arg2[9]) as u64));
  let x213: u64 = (((arg1[11]) as u64) * ((arg2[8]) as u64));
  let x214: u64 = (((arg1[11]) as u64) * ((arg2[7]) as u64));
  let x215: u64 = (((arg1[11]) as u64) * ((arg2[6]) as u64));
  let x216: u64 = (((arg1[11]) as u64) * ((arg2[5]) as u64));
  let x217: u64 = (((arg1[10]) as u64) * ((arg2[13]) as u64));
  let x218: u64 = (((arg1[10]) as u64) * ((arg2[12]) as u64));
  let x219: u64 = (((arg1[10]) as u64) * ((arg2[11]) as u64));
  let x220: u64 = (((arg1[10]) as u64) * ((arg2[10]) as u64));
  let x221: u64 = (((arg1[10]) as u64) * ((arg2[9]) as u64));
  let x222: u64 = (((arg1[10]) as u64) * ((arg2[8]) as u64));
  let x223: u64 = (((arg1[10]) as u64) * ((arg2[7]) as u64));
  let x224: u64 = (((arg1[10]) as u64) * ((arg2[6]) as u64));
  let x225: u64 = (((arg1[9]) as u64) * ((arg2[14]) as u64));
  let x226: u64 = (((arg1[9]) as u64) * ((arg2[13]) as u64));
  let x227: u64 = (((arg1[9]) as u64) * ((arg2[12]) as u64));
  let x228: u64 = (((arg1[9]) as u64) * ((arg2[11]) as u64));
  let x229: u64 = (((arg1[9]) as u64) * ((arg2[10]) as u64));
  let x230: u64 = (((arg1[9]) as u64) * ((arg2[9]) as u64));
  let x231: u64 = (((arg1[9]) as u64) * ((arg2[8]) as u64));
  let x232: u64 = (((arg1[9]) as u64) * ((arg2[7]) as u64));
  let x233: u64 = (((arg1[8]) as u64) * ((arg2[15]) as u64));
  let x234: u64 = (((arg1[8]) as u64) * ((arg2[14]) as u64));
  let x235: u64 = (((arg1[8]) as u64) * ((arg2[13]) as u64));
  let x236: u64 = (((arg1[8]) as u64) * ((arg2[12]) as u64));
  let x237: u64 = (((arg1[8]) as u64) * ((arg2[11]) as u64));
  let x238: u64 = (((arg1[8]) as u64) * ((arg2[10]) as u64));
  let x239: u64 = (((arg1[8]) as u64) * ((arg2[9]) as u64));
  let x240: u64 = (((arg1[8]) as u64) * ((arg2[8]) as u64));
  let x241: u64 = (((arg1[7]) as u64) * ((arg2[15]) as u64));
  let x242: u64 = (((arg1[7]) as u64) * ((arg2[14]) as u64));
  let x243: u64 = (((arg1[7]) as u64) * ((arg2[13]) as u64));
  let x244: u64 = (((arg1[7]) as u64) * ((arg2[12]) as u64));
  let x245: u64 = (((arg1[7]) as u64) * ((arg2[11]) as u64));
  let x246: u64 = (((arg1[7]) as u64) * ((arg2[10]) as u64));
  let x247: u64 = (((arg1[7]) as u64) * ((arg2[9]) as u64));
  let x248: u64 = (((arg1[6]) as u64) * ((arg2[15]) as u64));
  let x249: u64 = (((arg1[6]) as u64) * ((arg2[14]) as u64));
  let x250: u64 = (((arg1[6]) as u64) * ((arg2[13]) as u64));
  let x251: u64 = (((arg1[6]) as u64) * ((arg2[12]) as u64));
  let x252: u64 = (((arg1[6]) as u64) * ((arg2[11]) as u64));
  let x253: u64 = (((arg1[6]) as u64) * ((arg2[10]) as u64));
  let x254: u64 = (((arg1[5]) as u64) * ((arg2[15]) as u64));
  let x255: u64 = (((arg1[5]) as u64) * ((arg2[14]) as u64));
  let x256: u64 = (((arg1[5]) as u64) * ((arg2[13]) as u64));
  let x257: u64 = (((arg1[5]) as u64) * ((arg2[12]) as u64));
  let x258: u64 = (((arg1[5]) as u64) * ((arg2[11]) as u64));
  let x259: u64 = (((arg1[4]) as u64) * ((arg2[15]) as u64));
  let x260: u64 = (((arg1[4]) as u64) * ((arg2[14]) as u64));
  let x261: u64 = (((arg1[4]) as u64) * ((arg2[13]) as u64));
  let x262: u64 = (((arg1[4]) as u64) * ((arg2[12]) as u64));
  let x263: u64 = (((arg1[3]) as u64) * ((arg2[15]) as u64));
  let x264: u64 = (((arg1[3]) as u64) * ((arg2[14]) as u64));
  let x265: u64 = (((arg1[3]) as u64) * ((arg2[13]) as u64));
  let x266: u64 = (((arg1[2]) as u64) * ((arg2[15]) as u64));
  let x267: u64 = (((arg1[2]) as u64) * ((arg2[14]) as u64));
  let x268: u64 = (((arg1[1]) as u64) * ((arg2[15]) as u64));
  let x269: u64 = (((arg1[15]) as u64) * ((arg2[0]) as u64));
  let x270: u64 = (((arg1[14]) as u64) * ((arg2[1]) as u64));
  let x271: u64 = (((arg1[14]) as u64) * ((arg2[0]) as u64));
  let x272: u64 = (((arg1[13]) as u64) * ((arg2[2]) as u64));
  let x273: u64 = (((arg1[13]) as u64) * ((arg2[1]) as u64));
  let x274: u64 = (((arg1[13]) as u64) * ((arg2[0]) as u64));
  let x275: u64 = (((arg1[12]) as u64) * ((arg2[3]) as u64));
  let x276: u64 = (((arg1[12]) as u64) * ((arg2[2]) as u64));
  let x277: u64 = (((arg1[12]) as u64) * ((arg2[1]) as u64));
  let x278: u64 = (((arg1[12]) as u64) * ((arg2[0]) as u64));
  let x279: u64 = (((arg1[11]) as u64) * ((arg2[4]) as u64));
  let x280: u64 = (((arg1[11]) as u64) * ((arg2[3]) as u64));
  let x281: u64 = (((arg1[11]) as u64) * ((arg2[2]) as u64));
  let x282: u64 = (((arg1[11]) as u64) * ((arg2[1]) as u64));
  let x283: u64 = (((arg1[11]) as u64) * ((arg2[0]) as u64));
  let x284: u64 = (((arg1[10]) as u64) * ((arg2[5]) as u64));
  let x285: u64 = (((arg1[10]) as u64) * ((arg2[4]) as u64));
  let x286: u64 = (((arg1[10]) as u64) * ((arg2[3]) as u64));
  let x287: u64 = (((arg1[10]) as u64) * ((arg2[2]) as u64));
  let x288: u64 = (((arg1[10]) as u64) * ((arg2[1]) as u64));
  let x289: u64 = (((arg1[10]) as u64) * ((arg2[0]) as u64));
  let x290: u64 = (((arg1[9]) as u64) * ((arg2[6]) as u64));
  let x291: u64 = (((arg1[9]) as u64) * ((arg2[5]) as u64));
  let x292: u64 = (((arg1[9]) as u64) * ((arg2[4]) as u64));
  let x293: u64 = (((arg1[9]) as u64) * ((arg2[3]) as u64));
  let x294: u64 = (((arg1[9]) as u64) * ((arg2[2]) as u64));
  let x295: u64 = (((arg1[9]) as u64) * ((arg2[1]) as u64));
  let x296: u64 = (((arg1[9]) as u64) * ((arg2[0]) as u64));
  let x297: u64 = (((arg1[8]) as u64) * ((arg2[7]) as u64));
  let x298: u64 = (((arg1[8]) as u64) * ((arg2[6]) as u64));
  let x299: u64 = (((arg1[8]) as u64) * ((arg2[5]) as u64));
  let x300: u64 = (((arg1[8]) as u64) * ((arg2[4]) as u64));
  let x301: u64 = (((arg1[8]) as u64) * ((arg2[3]) as u64));
  let x302: u64 = (((arg1[8]) as u64) * ((arg2[2]) as u64));
  let x303: u64 = (((arg1[8]) as u64) * ((arg2[1]) as u64));
  let x304: u64 = (((arg1[8]) as u64) * ((arg2[0]) as u64));
  let x305: u64 = (((arg1[7]) as u64) * ((arg2[8]) as u64));
  let x306: u64 = (((arg1[7]) as u64) * ((arg2[7]) as u64));
  let x307: u64 = (((arg1[7]) as u64) * ((arg2[6]) as u64));
  let x308: u64 = (((arg1[7]) as u64) * ((arg2[5]) as u64));
  let x309: u64 = (((arg1[7]) as u64) * ((arg2[4]) as u64));
  let x310: u64 = (((arg1[7]) as u64) * ((arg2[3]) as u64));
  let x311: u64 = (((arg1[7]) as u64) * ((arg2[2]) as u64));
  let x312: u64 = (((arg1[7]) as u64) * ((arg2[1]) as u64));
  let x313: u64 = (((arg1[7]) as u64) * ((arg2[0]) as u64));
  let x314: u64 = (((arg1[6]) as u64) * ((arg2[9]) as u64));
  let x315: u64 = (((arg1[6]) as u64) * ((arg2[8]) as u64));
  let x316: u64 = (((arg1[6]) as u64) * ((arg2[7]) as u64));
  let x317: u64 = (((arg1[6]) as u64) * ((arg2[6]) as u64));
  let x318: u64 = (((arg1[6]) as u64) * ((arg2[5]) as u64));
  let x319: u64 = (((arg1[6]) as u64) * ((arg2[4]) as u64));
  let x320: u64 = (((arg1[6]) as u64) * ((arg2[3]) as u64));
  let x321: u64 = (((arg1[6]) as u64) * ((arg2[2]) as u64));
  let x322: u64 = (((arg1[6]) as u64) * ((arg2[1]) as u64));
  let x323: u64 = (((arg1[6]) as u64) * ((arg2[0]) as u64));
  let x324: u64 = (((arg1[5]) as u64) * ((arg2[10]) as u64));
  let x325: u64 = (((arg1[5]) as u64) * ((arg2[9]) as u64));
  let x326: u64 = (((arg1[5]) as u64) * ((arg2[8]) as u64));
  let x327: u64 = (((arg1[5]) as u64) * ((arg2[7]) as u64));
  let x328: u64 = (((arg1[5]) as u64) * ((arg2[6]) as u64));
  let x329: u64 = (((arg1[5]) as u64) * ((arg2[5]) as u64));
  let x330: u64 = (((arg1[5]) as u64) * ((arg2[4]) as u64));
  let x331: u64 = (((arg1[5]) as u64) * ((arg2[3]) as u64));
  let x332: u64 = (((arg1[5]) as u64) * ((arg2[2]) as u64));
  let x333: u64 = (((arg1[5]) as u64) * ((arg2[1]) as u64));
  let x334: u64 = (((arg1[5]) as u64) * ((arg2[0]) as u64));
  let x335: u64 = (((arg1[4]) as u64) * ((arg2[11]) as u64));
  let x336: u64 = (((arg1[4]) as u64) * ((arg2[10]) as u64));
  let x337: u64 = (((arg1[4]) as u64) * ((arg2[9]) as u64));
  let x338: u64 = (((arg1[4]) as u64) * ((arg2[8]) as u64));
  let x339: u64 = (((arg1[4]) as u64) * ((arg2[7]) as u64));
  let x340: u64 = (((arg1[4]) as u64) * ((arg2[6]) as u64));
  let x341: u64 = (((arg1[4]) as u64) * ((arg2[5]) as u64));
  let x342: u64 = (((arg1[4]) as u64) * ((arg2[4]) as u64));
  let x343: u64 = (((arg1[4]) as u64) * ((arg2[3]) as u64));
  let x344: u64 = (((arg1[4]) as u64) * ((arg2[2]) as u64));
  let x345: u64 = (((arg1[4]) as u64) * ((arg2[1]) as u64));
  let x346: u64 = (((arg1[4]) as u64) * ((arg2[0]) as u64));
  let x347: u64 = (((arg1[3]) as u64) * ((arg2[12]) as u64));
  let x348: u64 = (((arg1[3]) as u64) * ((arg2[11]) as u64));
  let x349: u64 = (((arg1[3]) as u64) * ((arg2[10]) as u64));
  let x350: u64 = (((arg1[3]) as u64) * ((arg2[9]) as u64));
  let x351: u64 = (((arg1[3]) as u64) * ((arg2[8]) as u64));
  let x352: u64 = (((arg1[3]) as u64) * ((arg2[7]) as u64));
  let x353: u64 = (((arg1[3]) as u64) * ((arg2[6]) as u64));
  let x354: u64 = (((arg1[3]) as u64) * ((arg2[5]) as u64));
  let x355: u64 = (((arg1[3]) as u64) * ((arg2[4]) as u64));
  let x356: u64 = (((arg1[3]) as u64) * ((arg2[3]) as u64));
  let x357: u64 = (((arg1[3]) as u64) * ((arg2[2]) as u64));
  let x358: u64 = (((arg1[3]) as u64) * ((arg2[1]) as u64));
  let x359: u64 = (((arg1[3]) as u64) * ((arg2[0]) as u64));
  let x360: u64 = (((arg1[2]) as u64) * ((arg2[13]) as u64));
  let x361: u64 = (((arg1[2]) as u64) * ((arg2[12]) as u64));
  let x362: u64 = (((arg1[2]) as u64) * ((arg2[11]) as u64));
  let x363: u64 = (((arg1[2]) as u64) * ((arg2[10]) as u64));
  let x364: u64 = (((arg1[2]) as u64) * ((arg2[9]) as u64));
  let x365: u64 = (((arg1[2]) as u64) * ((arg2[8]) as u64));
  let x366: u64 = (((arg1[2]) as u64) * ((arg2[7]) as u64));
  let x367: u64 = (((arg1[2]) as u64) * ((arg2[6]) as u64));
  let x368: u64 = (((arg1[2]) as u64) * ((arg2[5]) as u64));
  let x369: u64 = (((arg1[2]) as u64) * ((arg2[4]) as u64));
  let x370: u64 = (((arg1[2]) as u64) * ((arg2[3]) as u64));
  let x371: u64 = (((arg1[2]) as u64) * ((arg2[2]) as u64));
  let x372: u64 = (((arg1[2]) as u64) * ((arg2[1]) as u64));
  let x373: u64 = (((arg1[2]) as u64) * ((arg2[0]) as u64));
  let x374: u64 = (((arg1[1]) as u64) * ((arg2[14]) as u64));
  let x375: u64 = (((arg1[1]) as u64) * ((arg2[13]) as u64));
  let x376: u64 = (((arg1[1]) as u64) * ((arg2[12]) as u64));
  let x377: u64 = (((arg1[1]) as u64) * ((arg2[11]) as u64));
  let x378: u64 = (((arg1[1]) as u64) * ((arg2[10]) as u64));
  let x379: u64 = (((arg1[1]) as u64) * ((arg2[9]) as u64));
  let x380: u64 = (((arg1[1]) as u64) * ((arg2[8]) as u64));
  let x381: u64 = (((arg1[1]) as u64) * ((arg2[7]) as u64));
  let x382: u64 = (((arg1[1]) as u64) * ((arg2[6]) as u64));
  let x383: u64 = (((arg1[1]) as u64) * ((arg2[5]) as u64));
  let x384: u64 = (((arg1[1]) as u64) * ((arg2[4]) as u64));
  let x385: u64 = (((arg1[1]) as u64) * ((arg2[3]) as u64));
  let x386: u64 = (((arg1[1]) as u64) * ((arg2[2]) as u64));
  let x387: u64 = (((arg1[1]) as u64) * ((arg2[1]) as u64));
  let x388: u64 = (((arg1[1]) as u64) * ((arg2[0]) as u64));
  let x389: u64 = (((arg1[0]) as u64) * ((arg2[15]) as u64));
  let x390: u64 = (((arg1[0]) as u64) * ((arg2[14]) as u64));
  let x391: u64 = (((arg1[0]) as u64) * ((arg2[13]) as u64));
  let x392: u64 = (((arg1[0]) as u64) * ((arg2[12]) as u64));
  let x393: u64 = (((arg1[0]) as u64) * ((arg2[11]) as u64));
  let x394: u64 = (((arg1[0]) as u64) * ((arg2[10]) as u64));
  let x395: u64 = (((arg1[0]) as u64) * ((arg2[9]) as u64));
  let x396: u64 = (((arg1[0]) as u64) * ((arg2[8]) as u64));
  let x397: u64 = (((arg1[0]) as u64) * ((arg2[7]) as u64));
  let x398: u64 = (((arg1[0]) as u64) * ((arg2[6]) as u64));
  let x399: u64 = (((arg1[0]) as u64) * ((arg2[5]) as u64));
  let x400: u64 = (((arg1[0]) as u64) * ((arg2[4]) as u64));
  let x401: u64 = (((arg1[0]) as u64) * ((arg2[3]) as u64));
  let x402: u64 = (((arg1[0]) as u64) * ((arg2[2]) as u64));
  let x403: u64 = (((arg1[0]) as u64) * ((arg2[1]) as u64));
  let x404: u64 = (((arg1[0]) as u64) * ((arg2[0]) as u64));
  let x405: u64 = (x397 + (x382 + (x368 + (x355 + (x343 + (x332 + (x322 + (x313 + (x141 + (x133 + (x124 + (x114 + (x103 + (x91 + (x78 + x64)))))))))))))));
  let x406: u64 = (x405 >> 28);
  let x407: u32 = ((x405 & (0xfffffff as u64)) as u32);
  let x408: u64 = (x389 + (x374 + (x360 + (x347 + (x335 + (x324 + (x314 + (x305 + (x297 + (x290 + (x284 + (x279 + (x275 + (x272 + (x270 + (x269 + (x233 + (x225 + (x217 + (x209 + (x201 + (x193 + (x185 + x177)))))))))))))))))))))));
  let x409: u64 = (x390 + (x375 + (x361 + (x348 + (x336 + (x325 + (x315 + (x306 + (x298 + (x291 + (x285 + (x280 + (x276 + (x273 + (x271 + (x241 + (x234 + (x226 + (x218 + (x210 + (x202 + (x194 + (x186 + (x178 + (x57 + x29)))))))))))))))))))))))));
  let x410: u64 = (x391 + (x376 + (x362 + (x349 + (x337 + (x326 + (x316 + (x307 + (x299 + (x292 + (x286 + (x281 + (x277 + (x274 + (x248 + (x242 + (x235 + (x227 + (x219 + (x211 + (x203 + (x195 + (x187 + (x179 + (x72 + (x58 + (x36 + x30)))))))))))))))))))))))))));
  let x411: u128 = ((x392 as u128) + ((x377 as u128) + ((x363 + (x350 + (x338 + (x327 + (x317 + (x308 + (x300 + (x293 + (x287 + (x282 + (x278 + (x254 + (x249 + (x243 + (x236 + (x228 + (x220 + (x212 + (x204 + (x196 + (x188 + (x180 + (x86 + (x73 + (x59 + (x42 + (x37 + x31))))))))))))))))))))))))))) as u128)));
  let x412: u128 = ((x393 as u128) + ((x378 as u128) + ((x364 as u128) + ((x351 as u128) + ((x339 + (x328 + (x318 + (x309 + (x301 + (x294 + (x288 + (x283 + (x259 + (x255 + (x250 + (x244 + (x237 + (x229 + (x221 + (x213 + (x205 + (x197 + (x189 + (x181 + (x99 + (x87 + (x74 + (x60 + (x47 + (x43 + (x38 + x32))))))))))))))))))))))))))) as u128)))));
  let x413: u128 = ((x394 as u128) + ((x379 as u128) + ((x365 as u128) + ((x352 as u128) + ((x340 as u128) + ((x329 as u128) + ((x319 + (x310 + (x302 + (x295 + (x289 + (x263 + (x260 + (x256 + (x251 + (x245 + (x238 + (x230 + (x222 + (x214 + (x206 + (x198 + (x190 + (x182 + (x111 + (x100 + (x88 + (x75 + (x61 + (x51 + (x48 + (x44 + (x39 + x33))))))))))))))))))))))))))) as u128)))))));
  let x414: u128 = ((x395 as u128) + ((x380 as u128) + ((x366 as u128) + ((x353 as u128) + ((x341 as u128) + ((x330 as u128) + ((x320 as u128) + ((x311 as u128) + ((x303 + (x296 + (x266 + (x264 + (x261 + (x257 + (x252 + (x246 + (x239 + (x231 + (x223 + (x215 + (x207 + (x199 + (x191 + (x183 + (x122 + (x112 + (x101 + (x89 + (x76 + (x62 + (x54 + (x52 + (x49 + (x45 + (x40 + x34))))))))))))))))))))))))))) as u128)))))))));
  let x415: u128 = ((x396 as u128) + ((x381 as u128) + ((x367 as u128) + ((x354 as u128) + ((x342 as u128) + ((x331 as u128) + ((x321 as u128) + ((x312 as u128) + ((x304 as u128) + ((x268 as u128) + ((x267 + (x265 + (x262 + (x258 + (x253 + (x247 + (x240 + (x232 + (x224 + (x216 + (x208 + (x200 + (x192 + (x184 + (x132 + (x123 + (x113 + (x102 + (x90 + (x77 + (x63 + (x56 + (x55 + (x53 + (x50 + (x46 + (x41 + x35))))))))))))))))))))))))))) as u128)))))))))));
  let x416: u64 = (x398 + (x383 + (x369 + (x356 + (x344 + (x333 + (x323 + (x149 + (x142 + (x134 + (x125 + (x115 + (x104 + (x92 + (x79 + (x65 + x1))))))))))))))));
  let x417: u64 = (x399 + (x384 + (x370 + (x357 + (x345 + (x334 + (x156 + (x150 + (x143 + (x135 + (x126 + (x116 + (x105 + (x93 + (x80 + (x66 + (x8 + x2)))))))))))))))));
  let x418: u64 = (x400 + (x385 + (x371 + (x358 + (x346 + (x162 + (x157 + (x151 + (x144 + (x136 + (x127 + (x117 + (x106 + (x94 + (x81 + (x67 + (x14 + (x9 + x3))))))))))))))))));
  let x419: u64 = (x401 + (x386 + (x372 + (x359 + (x167 + (x163 + (x158 + (x152 + (x145 + (x137 + (x128 + (x118 + (x107 + (x95 + (x82 + (x68 + (x19 + (x15 + (x10 + x4)))))))))))))))))));
  let x420: u64 = (x402 + (x387 + (x373 + (x171 + (x168 + (x164 + (x159 + (x153 + (x146 + (x138 + (x129 + (x119 + (x108 + (x96 + (x83 + (x69 + (x23 + (x20 + (x16 + (x11 + x5))))))))))))))))))));
  let x421: u64 = (x403 + (x388 + (x174 + (x172 + (x169 + (x165 + (x160 + (x154 + (x147 + (x139 + (x130 + (x120 + (x109 + (x97 + (x84 + (x70 + (x26 + (x24 + (x21 + (x17 + (x12 + x6)))))))))))))))))))));
  let x422: u64 = (x404 + (x176 + (x175 + (x173 + (x170 + (x166 + (x161 + (x155 + (x148 + (x140 + (x131 + (x121 + (x110 + (x98 + (x85 + (x71 + (x28 + (x27 + (x25 + (x22 + (x18 + (x13 + x7))))))))))))))))))))));
  let x423: u128 = ((x406 as u128) + x415);
  let x424: u64 = (x408 >> 28);
  let x425: u32 = ((x408 & (0xfffffff as u64)) as u32);
  let x426: u128 = (x423 + (x424 as u128));
  let x427: u64 = ((x426 >> 28) as u64);
  let x428: u32 = ((x426 & (0xfffffff as u128)) as u32);
  let x429: u64 = (x422 + x424);
  let x430: u128 = ((x427 as u128) + x414);
  let x431: u64 = (x429 >> 28);
  let x432: u32 = ((x429 & (0xfffffff as u64)) as u32);
  let x433: u64 = (x431 + x421);
  let x434: u64 = ((x430 >> 28) as u64);
  let x435: u32 = ((x430 & (0xfffffff as u128)) as u32);
  let x436: u128 = ((x434 as u128) + x413);
  let x437: u64 = (x433 >> 28);
  let x438: u32 = ((x433 & (0xfffffff as u64)) as u32);
  let x439: u64 = (x437 + x420);
  let x440: u64 = ((x436 >> 28) as u64);
  let x441: u32 = ((x436 & (0xfffffff as u128)) as u32);
  let x442: u128 = ((x440 as u128) + x412);
  let x443: u64 = (x439 >> 28);
  let x444: u32 = ((x439 & (0xfffffff as u64)) as u32);
  let x445: u64 = (x443 + x419);
  let x446: u64 = ((x442 >> 28) as u64);
  let x447: u32 = ((x442 & (0xfffffff as u128)) as u32);
  let x448: u128 = ((x446 as u128) + x411);
  let x449: u64 = (x445 >> 28);
  let x450: u32 = ((x445 & (0xfffffff as u64)) as u32);
  let x451: u64 = (x449 + x418);
  let x452: u64 = ((x448 >> 28) as u64);
  let x453: u32 = ((x448 & (0xfffffff as u128)) as u32);
  let x454: u64 = (x452 + x410);
  let x455: u64 = (x451 >> 28);
  let x456: u32 = ((x451 & (0xfffffff as u64)) as u32);
  let x457: u64 = (x455 + x417);
  let x458: u64 = (x454 >> 28);
  let x459: u32 = ((x454 & (0xfffffff as u64)) as u32);
  let x460: u64 = (x458 + x409);
  let x461: u64 = (x457 >> 28);
  let x462: u32 = ((x457 & (0xfffffff as u64)) as u32);
  let x463: u64 = (x461 + x416);
  let x464: u64 = (x460 >> 28);
  let x465: u32 = ((x460 & (0xfffffff as u64)) as u32);
  let x466: u64 = (x464 + (x425 as u64));
  let x467: u64 = (x463 >> 28);
  let x468: u32 = ((x463 & (0xfffffff as u64)) as u32);
  let x469: u64 = (x467 + (x407 as u64));
  let x470: u32 = ((x466 >> 28) as u32);
  let x471: u32 = ((x466 & (0xfffffff as u64)) as u32);
  let x472: u32 = ((x469 >> 28) as u32);
  let x473: u32 = ((x469 & (0xfffffff as u64)) as u32);
  let x474: u32 = (x428 + x470);
  let x475: u32 = (x432 + x470);
  let x476: u32 = (x472 + x474);
  let x477: fiat_p448_u1 = ((x476 >> 28) as fiat_p448_u1);
  let x478: u32 = (x476 & 0xfffffff);
  let x479: u32 = ((x477 as u32) + x435);
  let x480: fiat_p448_u1 = ((x475 >> 28) as fiat_p448_u1);
  let x481: u32 = (x475 & 0xfffffff);
  let x482: u32 = ((x480 as u32) + x438);
  out1[0] = x481;
  out1[1] = x482;
  out1[2] = x444;
  out1[3] = x450;
  out1[4] = x456;
  out1[5] = x462;
  out1[6] = x468;
  out1[7] = x473;
  out1[8] = x478;
  out1[9] = x479;
  out1[10] = x441;
  out1[11] = x447;
  out1[12] = x453;
  out1[13] = x459;
  out1[14] = x465;
  out1[15] = x471;
}

/// The function fiat_p448_carry_square squares a field element and reduces the result.
///
/// Postconditions:
///   eval out1 mod m = (eval arg1 * eval arg1) mod m
///
#[inline]
pub fn fiat_p448_carry_square(out1: &mut fiat_p448_tight_field_element, arg1: &fiat_p448_loose_field_element) -> () {
  let x1: u32 = (arg1[15]);
  let x2: u32 = (arg1[15]);
  let x3: u32 = (x1 * 0x2);
  let x4: u32 = (x2 * 0x2);
  let x5: u32 = ((arg1[15]) * 0x2);
  let x6: u32 = (arg1[14]);
  let x7: u32 = (arg1[14]);
  let x8: u32 = (x6 * 0x2);
  let x9: u32 = (x7 * 0x2);
  let x10: u32 = ((arg1[14]) * 0x2);
  let x11: u32 = (arg1[13]);
  let x12: u32 = (arg1[13]);
  let x13: u32 = (x11 * 0x2);
  let x14: u32 = (x12 * 0x2);
  let x15: u32 = ((arg1[13]) * 0x2);
  let x16: u32 = (arg1[12]);
  let x17: u32 = (arg1[12]);
  let x18: u32 = (x16 * 0x2);
  let x19: u32 = (x17 * 0x2);
  let x20: u32 = ((arg1[12]) * 0x2);
  let x21: u32 = (arg1[11]);
  let x22: u32 = (arg1[11]);
  let x23: u32 = (x21 * 0x2);
  let x24: u32 = (x22 * 0x2);
  let x25: u32 = ((arg1[11]) * 0x2);
  let x26: u32 = (arg1[10]);
  let x27: u32 = (arg1[10]);
  let x28: u32 = (x26 * 0x2);
  let x29: u32 = (x27 * 0x2);
  let x30: u32 = ((arg1[10]) * 0x2);
  let x31: u32 = (arg1[9]);
  let x32: u32 = (arg1[9]);
  let x33: u32 = (x31 * 0x2);
  let x34: u32 = (x32 * 0x2);
  let x35: u32 = ((arg1[9]) * 0x2);
  let x36: u32 = (arg1[8]);
  let x37: u32 = (arg1[8]);
  let x38: u32 = ((arg1[8]) * 0x2);
  let x39: u32 = ((arg1[7]) * 0x2);
  let x40: u32 = ((arg1[6]) * 0x2);
  let x41: u32 = ((arg1[5]) * 0x2);
  let x42: u32 = ((arg1[4]) * 0x2);
  let x43: u32 = ((arg1[3]) * 0x2);
  let x44: u32 = ((arg1[2]) * 0x2);
  let x45: u32 = ((arg1[1]) * 0x2);
  let x46: u64 = (((arg1[15]) as u64) * (x1 as u64));
  let x47: u64 = (((arg1[14]) as u64) * (x3 as u64));
  let x48: u64 = (((arg1[14]) as u64) * (x6 as u64));
  let x49: u64 = (((arg1[13]) as u64) * (x3 as u64));
  let x50: u64 = (((arg1[13]) as u64) * (x8 as u64));
  let x51: u64 = (((arg1[13]) as u64) * (x11 as u64));
  let x52: u64 = (((arg1[12]) as u64) * (x3 as u64));
  let x53: u64 = (((arg1[12]) as u64) * (x8 as u64));
  let x54: u64 = (((arg1[12]) as u64) * (x13 as u64));
  let x55: u64 = (((arg1[12]) as u64) * (x16 as u64));
  let x56: u64 = (((arg1[11]) as u64) * (x3 as u64));
  let x57: u64 = (((arg1[11]) as u64) * (x8 as u64));
  let x58: u64 = (((arg1[11]) as u64) * (x13 as u64));
  let x59: u64 = (((arg1[10]) as u64) * (x3 as u64));
  let x60: u64 = (((arg1[10]) as u64) * (x8 as u64));
  let x61: u64 = (((arg1[9]) as u64) * (x3 as u64));
  let x62: u64 = (((arg1[15]) as u64) * (x1 as u64));
  let x63: u64 = (((arg1[14]) as u64) * (x3 as u64));
  let x64: u64 = (((arg1[14]) as u64) * (x6 as u64));
  let x65: u64 = (((arg1[13]) as u64) * (x3 as u64));
  let x66: u64 = (((arg1[13]) as u64) * (x8 as u64));
  let x67: u64 = (((arg1[13]) as u64) * (x11 as u64));
  let x68: u64 = (((arg1[12]) as u64) * (x3 as u64));
  let x69: u64 = (((arg1[12]) as u64) * (x8 as u64));
  let x70: u64 = (((arg1[12]) as u64) * (x13 as u64));
  let x71: u64 = (((arg1[12]) as u64) * (x16 as u64));
  let x72: u64 = (((arg1[11]) as u64) * (x3 as u64));
  let x73: u64 = (((arg1[11]) as u64) * (x8 as u64));
  let x74: u64 = (((arg1[11]) as u64) * (x13 as u64));
  let x75: u64 = (((arg1[10]) as u64) * (x3 as u64));
  let x76: u64 = (((arg1[10]) as u64) * (x8 as u64));
  let x77: u64 = (((arg1[9]) as u64) * (x3 as u64));
  let x78: u64 = (((arg1[15]) as u64) * (x2 as u64));
  let x79: u64 = (((arg1[14]) as u64) * (x4 as u64));
  let x80: u64 = (((arg1[14]) as u64) * (x7 as u64));
  let x81: u64 = (((arg1[13]) as u64) * (x4 as u64));
  let x82: u64 = (((arg1[13]) as u64) * (x9 as u64));
  let x83: u64 = (((arg1[13]) as u64) * (x12 as u64));
  let x84: u64 = (((arg1[12]) as u64) * (x4 as u64));
  let x85: u64 = (((arg1[12]) as u64) * (x9 as u64));
  let x86: u64 = (((arg1[12]) as u64) * (x14 as u64));
  let x87: u64 = (((arg1[12]) as u64) * (x17 as u64));
  let x88: u64 = (((arg1[11]) as u64) * (x4 as u64));
  let x89: u64 = (((arg1[11]) as u64) * (x9 as u64));
  let x90: u64 = (((arg1[11]) as u64) * (x14 as u64));
  let x91: u64 = (((arg1[11]) as u64) * (x19 as u64));
  let x92: u64 = (((arg1[11]) as u64) * (x18 as u64));
  let x93: u64 = (((arg1[11]) as u64) * (x22 as u64));
  let x94: u64 = (((arg1[11]) as u64) * (x21 as u64));
  let x95: u64 = (((arg1[10]) as u64) * (x4 as u64));
  let x96: u64 = (((arg1[10]) as u64) * (x9 as u64));
  let x97: u64 = (((arg1[10]) as u64) * (x14 as u64));
  let x98: u64 = (((arg1[10]) as u64) * (x13 as u64));
  let x99: u64 = (((arg1[10]) as u64) * (x19 as u64));
  let x100: u64 = (((arg1[10]) as u64) * (x18 as u64));
  let x101: u64 = (((arg1[10]) as u64) * (x24 as u64));
  let x102: u64 = (((arg1[10]) as u64) * (x23 as u64));
  let x103: u64 = (((arg1[10]) as u64) * (x27 as u64));
  let x104: u64 = (((arg1[10]) as u64) * (x26 as u64));
  let x105: u64 = (((arg1[9]) as u64) * (x4 as u64));
  let x106: u64 = (((arg1[9]) as u64) * (x9 as u64));
  let x107: u64 = (((arg1[9]) as u64) * (x8 as u64));
  let x108: u64 = (((arg1[9]) as u64) * (x14 as u64));
  let x109: u64 = (((arg1[9]) as u64) * (x13 as u64));
  let x110: u64 = (((arg1[9]) as u64) * (x19 as u64));
  let x111: u64 = (((arg1[9]) as u64) * (x18 as u64));
  let x112: u64 = (((arg1[9]) as u64) * (x24 as u64));
  let x113: u64 = (((arg1[9]) as u64) * (x23 as u64));
  let x114: u64 = (((arg1[9]) as u64) * (x29 as u64));
  let x115: u64 = (((arg1[9]) as u64) * (x28 as u64));
  let x116: u64 = (((arg1[9]) as u64) * (x32 as u64));
  let x117: u64 = (((arg1[9]) as u64) * (x31 as u64));
  let x118: u64 = (((arg1[8]) as u64) * (x4 as u64));
  let x119: u64 = (((arg1[8]) as u64) * (x3 as u64));
  let x120: u64 = (((arg1[8]) as u64) * (x9 as u64));
  let x121: u64 = (((arg1[8]) as u64) * (x8 as u64));
  let x122: u64 = (((arg1[8]) as u64) * (x14 as u64));
  let x123: u64 = (((arg1[8]) as u64) * (x13 as u64));
  let x124: u64 = (((arg1[8]) as u64) * (x19 as u64));
  let x125: u64 = (((arg1[8]) as u64) * (x18 as u64));
  let x126: u64 = (((arg1[8]) as u64) * (x24 as u64));
  let x127: u64 = (((arg1[8]) as u64) * (x23 as u64));
  let x128: u64 = (((arg1[8]) as u64) * (x29 as u64));
  let x129: u64 = (((arg1[8]) as u64) * (x28 as u64));
  let x130: u64 = (((arg1[8]) as u64) * (x34 as u64));
  let x131: u64 = (((arg1[8]) as u64) * (x33 as u64));
  let x132: u64 = (((arg1[8]) as u64) * (x37 as u64));
  let x133: u64 = (((arg1[8]) as u64) * (x36 as u64));
  let x134: u64 = (((arg1[7]) as u64) * (x4 as u64));
  let x135: u64 = (((arg1[7]) as u64) * (x3 as u64));
  let x136: u64 = (((arg1[7]) as u64) * (x9 as u64));
  let x137: u64 = (((arg1[7]) as u64) * (x8 as u64));
  let x138: u64 = (((arg1[7]) as u64) * (x14 as u64));
  let x139: u64 = (((arg1[7]) as u64) * (x13 as u64));
  let x140: u64 = (((arg1[7]) as u64) * (x19 as u64));
  let x141: u64 = (((arg1[7]) as u64) * (x18 as u64));
  let x142: u64 = (((arg1[7]) as u64) * (x24 as u64));
  let x143: u64 = (((arg1[7]) as u64) * (x23 as u64));
  let x144: u64 = (((arg1[7]) as u64) * (x29 as u64));
  let x145: u64 = (((arg1[7]) as u64) * (x28 as u64));
  let x146: u64 = (((arg1[7]) as u64) * (x34 as u64));
  let x147: u64 = (((arg1[7]) as u64) * (x33 as u64));
  let x148: u64 = (((arg1[7]) as u64) * (x38 as u64));
  let x149: u64 = (((arg1[7]) as u64) * ((arg1[7]) as u64));
  let x150: u64 = (((arg1[6]) as u64) * (x4 as u64));
  let x151: u64 = (((arg1[6]) as u64) * (x3 as u64));
  let x152: u64 = (((arg1[6]) as u64) * (x9 as u64));
  let x153: u64 = (((arg1[6]) as u64) * (x8 as u64));
  let x154: u64 = (((arg1[6]) as u64) * (x14 as u64));
  let x155: u64 = (((arg1[6]) as u64) * (x13 as u64));
  let x156: u64 = (((arg1[6]) as u64) * (x19 as u64));
  let x157: u64 = (((arg1[6]) as u64) * (x18 as u64));
  let x158: u64 = (((arg1[6]) as u64) * (x24 as u64));
  let x159: u64 = (((arg1[6]) as u64) * (x23 as u64));
  let x160: u64 = (((arg1[6]) as u64) * (x29 as u64));
  let x161: u64 = (((arg1[6]) as u64) * (x28 as u64));
  let x162: u64 = (((arg1[6]) as u64) * (x35 as u64));
  let x163: u64 = (((arg1[6]) as u64) * (x38 as u64));
  let x164: u64 = (((arg1[6]) as u64) * (x39 as u64));
  let x165: u64 = (((arg1[6]) as u64) * ((arg1[6]) as u64));
  let x166: u64 = (((arg1[5]) as u64) * (x4 as u64));
  let x167: u64 = (((arg1[5]) as u64) * (x3 as u64));
  let x168: u64 = (((arg1[5]) as u64) * (x9 as u64));
  let x169: u64 = (((arg1[5]) as u64) * (x8 as u64));
  let x170: u64 = (((arg1[5]) as u64) * (x14 as u64));
  let x171: u64 = (((arg1[5]) as u64) * (x13 as u64));
  let x172: u64 = (((arg1[5]) as u64) * (x19 as u64));
  let x173: u64 = (((arg1[5]) as u64) * (x18 as u64));
  let x174: u64 = (((arg1[5]) as u64) * (x24 as u64));
  let x175: u64 = (((arg1[5]) as u64) * (x23 as u64));
  let x176: u64 = (((arg1[5]) as u64) * (x30 as u64));
  let x177: u64 = (((arg1[5]) as u64) * (x35 as u64));
  let x178: u64 = (((arg1[5]) as u64) * (x38 as u64));
  let x179: u64 = (((arg1[5]) as u64) * (x39 as u64));
  let x180: u64 = (((arg1[5]) as u64) * (x40 as u64));
  let x181: u64 = (((arg1[5]) as u64) * ((arg1[5]) as u64));
  let x182: u64 = (((arg1[4]) as u64) * (x4 as u64));
  let x183: u64 = (((arg1[4]) as u64) * (x3 as u64));
  let x184: u64 = (((arg1[4]) as u64) * (x9 as u64));
  let x185: u64 = (((arg1[4]) as u64) * (x8 as u64));
  let x186: u64 = (((arg1[4]) as u64) * (x14 as u64));
  let x187: u64 = (((arg1[4]) as u64) * (x13 as u64));
  let x188: u64 = (((arg1[4]) as u64) * (x19 as u64));
  let x189: u64 = (((arg1[4]) as u64) * (x18 as u64));
  let x190: u64 = (((arg1[4]) as u64) * (x25 as u64));
  let x191: u64 = (((arg1[4]) as u64) * (x30 as u64));
  let x192: u64 = (((arg1[4]) as u64) * (x35 as u64));
  let x193: u64 = (((arg1[4]) as u64) * (x38 as u64));
  let x194: u64 = (((arg1[4]) as u64) * (x39 as u64));
  let x195: u64 = (((arg1[4]) as u64) * (x40 as u64));
  let x196: u64 = (((arg1[4]) as u64) * (x41 as u64));
  let x197: u64 = (((arg1[4]) as u64) * ((arg1[4]) as u64));
  let x198: u64 = (((arg1[3]) as u64) * (x4 as u64));
  let x199: u64 = (((arg1[3]) as u64) * (x3 as u64));
  let x200: u64 = (((arg1[3]) as u64) * (x9 as u64));
  let x201: u64 = (((arg1[3]) as u64) * (x8 as u64));
  let x202: u64 = (((arg1[3]) as u64) * (x14 as u64));
  let x203: u64 = (((arg1[3]) as u64) * (x13 as u64));
  let x204: u64 = (((arg1[3]) as u64) * (x20 as u64));
  let x205: u64 = (((arg1[3]) as u64) * (x25 as u64));
  let x206: u64 = (((arg1[3]) as u64) * (x30 as u64));
  let x207: u64 = (((arg1[3]) as u64) * (x35 as u64));
  let x208: u64 = (((arg1[3]) as u64) * (x38 as u64));
  let x209: u64 = (((arg1[3]) as u64) * (x39 as u64));
  let x210: u64 = (((arg1[3]) as u64) * (x40 as u64));
  let x211: u64 = (((arg1[3]) as u64) * (x41 as u64));
  let x212: u64 = (((arg1[3]) as u64) * (x42 as u64));
  let x213: u64 = (((arg1[3]) as u64) * ((arg1[3]) as u64));
  let x214: u64 = (((arg1[2]) as u64) * (x4 as u64));
  let x215: u64 = (((arg1[2]) as u64) * (x3 as u64));
  let x216: u64 = (((arg1[2]) as u64) * (x9 as u64));
  let x217: u64 = (((arg1[2]) as u64) * (x8 as u64));
  let x218: u64 = (((arg1[2]) as u64) * (x15 as u64));
  let x219: u64 = (((arg1[2]) as u64) * (x20 as u64));
  let x220: u64 = (((arg1[2]) as u64) * (x25 as u64));
  let x221: u64 = (((arg1[2]) as u64) * (x30 as u64));
  let x222: u64 = (((arg1[2]) as u64) * (x35 as u64));
  let x223: u64 = (((arg1[2]) as u64) * (x38 as u64));
  let x224: u64 = (((arg1[2]) as u64) * (x39 as u64));
  let x225: u64 = (((arg1[2]) as u64) * (x40 as u64));
  let x226: u64 = (((arg1[2]) as u64) * (x41 as u64));
  let x227: u64 = (((arg1[2]) as u64) * (x42 as u64));
  let x228: u64 = (((arg1[2]) as u64) * (x43 as u64));
  let x229: u64 = (((arg1[2]) as u64) * ((arg1[2]) as u64));
  let x230: u64 = (((arg1[1]) as u64) * (x4 as u64));
  let x231: u64 = (((arg1[1]) as u64) * (x3 as u64));
  let x232: u64 = (((arg1[1]) as u64) * (x10 as u64));
  let x233: u64 = (((arg1[1]) as u64) * (x15 as u64));
  let x234: u64 = (((arg1[1]) as u64) * (x20 as u64));
  let x235: u64 = (((arg1[1]) as u64) * (x25 as u64));
  let x236: u64 = (((arg1[1]) as u64) * (x30 as u64));
  let x237: u64 = (((arg1[1]) as u64) * (x35 as u64));
  let x238: u64 = (((arg1[1]) as u64) * (x38 as u64));
  let x239: u64 = (((arg1[1]) as u64) * (x39 as u64));
  let x240: u64 = (((arg1[1]) as u64) * (x40 as u64));
  let x241: u64 = (((arg1[1]) as u64) * (x41 as u64));
  let x242: u64 = (((arg1[1]) as u64) * (x42 as u64));
  let x243: u64 = (((arg1[1]) as u64) * (x43 as u64));
  let x244: u64 = (((arg1[1]) as u64) * (x44 as u64));
  let x245: u64 = (((arg1[1]) as u64) * ((arg1[1]) as u64));
  let x246: u64 = (((arg1[0]) as u64) * (x5 as u64));
  let x247: u64 = (((arg1[0]) as u64) * (x10 as u64));
  let x248: u64 = (((arg1[0]) as u64) * (x15 as u64));
  let x249: u64 = (((arg1[0]) as u64) * (x20 as u64));
  let x250: u64 = (((arg1[0]) as u64) * (x25 as u64));
  let x251: u64 = (((arg1[0]) as u64) * (x30 as u64));
  let x252: u64 = (((arg1[0]) as u64) * (x35 as u64));
  let x253: u64 = (((arg1[0]) as u64) * (x38 as u64));
  let x254: u64 = (((arg1[0]) as u64) * (x39 as u64));
  let x255: u64 = (((arg1[0]) as u64) * (x40 as u64));
  let x256: u64 = (((arg1[0]) as u64) * (x41 as u64));
  let x257: u64 = (((arg1[0]) as u64) * (x42 as u64));
  let x258: u64 = (((arg1[0]) as u64) * (x43 as u64));
  let x259: u64 = (((arg1[0]) as u64) * (x44 as u64));
  let x260: u64 = (((arg1[0]) as u64) * (x45 as u64));
  let x261: u64 = (((arg1[0]) as u64) * ((arg1[0]) as u64));
  let x262: u64 = (x254 + (x240 + (x226 + (x212 + (x118 + (x106 + (x97 + x91)))))));
  let x263: u64 = (x262 >> 28);
  let x264: u32 = ((x262 & (0xfffffff as u64)) as u32);
  let x265: u64 = (x246 + (x232 + (x218 + (x204 + (x190 + (x176 + (x162 + (x148 + (x119 + (x107 + (x98 + x92)))))))))));
  let x266: u64 = (x247 + (x233 + (x219 + (x205 + (x191 + (x177 + (x163 + (x149 + (x135 + (x121 + (x109 + (x100 + (x94 + (x78 + x62))))))))))))));
  let x267: u64 = (x248 + (x234 + (x220 + (x206 + (x192 + (x178 + (x164 + (x151 + (x137 + (x123 + (x111 + (x102 + (x79 + x63)))))))))))));
  let x268: u128 = ((x249 as u128) + ((x235 + (x221 + (x207 + (x193 + (x179 + (x167 + (x165 + (x153 + (x139 + (x125 + (x113 + (x104 + (x81 + (x80 + (x65 + x64))))))))))))))) as u128));
  let x269: u128 = ((x250 as u128) + ((x236 as u128) + ((x222 + (x208 + (x194 + (x183 + (x180 + (x169 + (x155 + (x141 + (x127 + (x115 + (x84 + (x82 + (x68 + x66))))))))))))) as u128)));
  let x270: u128 = ((x251 as u128) + ((x237 as u128) + ((x223 as u128) + ((x209 + (x199 + (x195 + (x185 + (x181 + (x171 + (x157 + (x143 + (x129 + (x117 + (x88 + (x85 + (x83 + (x72 + (x69 + x67))))))))))))))) as u128))));
  let x271: u128 = ((x252 as u128) + ((x238 as u128) + ((x224 as u128) + ((x215 as u128) + ((x210 + (x201 + (x196 + (x187 + (x173 + (x159 + (x145 + (x131 + (x95 + (x89 + (x86 + (x75 + (x73 + x70))))))))))))) as u128)))));
  let x272: u128 = ((x253 as u128) + ((x239 as u128) + ((x231 as u128) + ((x225 as u128) + ((x217 as u128) + ((x211 + (x203 + (x197 + (x189 + (x175 + (x161 + (x147 + (x133 + (x105 + (x96 + (x90 + (x87 + (x77 + (x76 + (x74 + x71))))))))))))))) as u128))))));
  let x273: u64 = (x255 + (x241 + (x227 + (x213 + (x134 + (x120 + (x108 + (x99 + (x93 + x46)))))))));
  let x274: u64 = (x256 + (x242 + (x228 + (x150 + (x136 + (x122 + (x110 + (x101 + x47))))))));
  let x275: u64 = (x257 + (x243 + (x229 + (x166 + (x152 + (x138 + (x124 + (x112 + (x103 + (x49 + x48))))))))));
  let x276: u64 = (x258 + (x244 + (x182 + (x168 + (x154 + (x140 + (x126 + (x114 + (x52 + x50)))))))));
  let x277: u64 = (x259 + (x245 + (x198 + (x184 + (x170 + (x156 + (x142 + (x128 + (x116 + (x56 + (x53 + x51)))))))))));
  let x278: u64 = (x260 + (x214 + (x200 + (x186 + (x172 + (x158 + (x144 + (x130 + (x59 + (x57 + x54))))))))));
  let x279: u64 = (x261 + (x230 + (x216 + (x202 + (x188 + (x174 + (x160 + (x146 + (x132 + (x61 + (x60 + (x58 + x55))))))))))));
  let x280: u128 = ((x263 as u128) + x272);
  let x281: u64 = (x265 >> 28);
  let x282: u32 = ((x265 & (0xfffffff as u64)) as u32);
  let x283: u128 = (x280 + (x281 as u128));
  let x284: u64 = ((x283 >> 28) as u64);
  let x285: u32 = ((x283 & (0xfffffff as u128)) as u32);
  let x286: u64 = (x279 + x281);
  let x287: u128 = ((x284 as u128) + x271);
  let x288: u64 = (x286 >> 28);
  let x289: u32 = ((x286 & (0xfffffff as u64)) as u32);
  let x290: u64 = (x288 + x278);
  let x291: u64 = ((x287 >> 28) as u64);
  let x292: u32 = ((x287 & (0xfffffff as u128)) as u32);
  let x293: u128 = ((x291 as u128) + x270);
  let x294: u64 = (x290 >> 28);
  let x295: u32 = ((x290 & (0xfffffff as u64)) as u32);
  let x296: u64 = (x294 + x277);
  let x297: u64 = ((x293 >> 28) as u64);
  let x298: u32 = ((x293 & (0xfffffff as u128)) as u32);
  let x299: u128 = ((x297 as u128) + x269);
  let x300: u64 = (x296 >> 28);
  let x301: u32 = ((x296 & (0xfffffff as u64)) as u32);
  let x302: u64 = (x300 + x276);
  let x303: u64 = ((x299 >> 28) as u64);
  let x304: u32 = ((x299 & (0xfffffff as u128)) as u32);
  let x305: u128 = ((x303 as u128) + x268);
  let x306: u64 = (x302 >> 28);
  let x307: u32 = ((x302 & (0xfffffff as u64)) as u32);
  let x308: u64 = (x306 + x275);
  let x309: u64 = ((x305 >> 28) as u64);
  let x310: u32 = ((x305 & (0xfffffff as u128)) as u32);
  let x311: u64 = (x309 + x267);
  let x312: u64 = (x308 >> 28);
  let x313: u32 = ((x308 & (0xfffffff as u64)) as u32);
  let x314: u64 = (x312 + x274);
  let x315: u64 = (x311 >> 28);
  let x316: u32 = ((x311 & (0xfffffff as u64)) as u32);
  let x317: u64 = (x315 + x266);
  let x318: u64 = (x314 >> 28);
  let x319: u32 = ((x314 & (0xfffffff as u64)) as u32);
  let x320: u64 = (x318 + x273);
  let x321: u64 = (x317 >> 28);
  let x322: u32 = ((x317 & (0xfffffff as u64)) as u32);
  let x323: u64 = (x321 + (x282 as u64));
  let x324: u64 = (x320 >> 28);
  let x325: u32 = ((x320 & (0xfffffff as u64)) as u32);
  let x326: u64 = (x324 + (x264 as u64));
  let x327: u32 = ((x323 >> 28) as u32);
  let x328: u32 = ((x323 & (0xfffffff as u64)) as u32);
  let x329: u32 = ((x326 >> 28) as u32);
  let x330: u32 = ((x326 & (0xfffffff as u64)) as u32);
  let x331: u32 = (x285 + x327);
  let x332: u32 = (x289 + x327);
  let x333: u32 = (x329 + x331);
  let x334: fiat_p448_u1 = ((x333 >> 28) as fiat_p448_u1);
  let x335: u32 = (x333 & 0xfffffff);
  let x336: u32 = ((x334 as u32) + x292);
  let x337: fiat_p448_u1 = ((x332 >> 28) as fiat_p448_u1);
  let x338: u32 = (x332 & 0xfffffff);
  let x339: u32 = ((x337 as u32) + x295);
  out1[0] = x338;
  out1[1] = x339;
  out1[2] = x301;
  out1[3] = x307;
  out1[4] = x313;
  out1[5] = x319;
  out1[6] = x325;
  out1[7] = x330;
  out1[8] = x335;
  out1[9] = x336;
  out1[10] = x298;
  out1[11] = x304;
  out1[12] = x310;
  out1[13] = x316;
  out1[14] = x322;
  out1[15] = x328;
}

/// The function fiat_p448_carry reduces a field element.
///
/// Postconditions:
///   eval out1 mod m = eval arg1 mod m
///
#[inline]
pub fn fiat_p448_carry(out1: &mut fiat_p448_tight_field_element, arg1: &fiat_p448_loose_field_element) -> () {
  let x1: u32 = (arg1[7]);
  let x2: u32 = (arg1[15]);
  let x3: u32 = (x2 >> 28);
  let x4: u32 = (((x1 >> 28) + (arg1[8])) + x3);
  let x5: u32 = ((arg1[0]) + x3);
  let x6: u32 = ((x4 >> 28) + (arg1[9]));
  let x7: u32 = ((x5 >> 28) + (arg1[1]));
  let x8: u32 = ((x6 >> 28) + (arg1[10]));
  let x9: u32 = ((x7 >> 28) + (arg1[2]));
  let x10: u32 = ((x8 >> 28) + (arg1[11]));
  let x11: u32 = ((x9 >> 28) + (arg1[3]));
  let x12: u32 = ((x10 >> 28) + (arg1[12]));
  let x13: u32 = ((x11 >> 28) + (arg1[4]));
  let x14: u32 = ((x12 >> 28) + (arg1[13]));
  let x15: u32 = ((x13 >> 28) + (arg1[5]));
  let x16: u32 = ((x14 >> 28) + (arg1[14]));
  let x17: u32 = ((x15 >> 28) + (arg1[6]));
  let x18: u32 = ((x16 >> 28) + (x2 & 0xfffffff));
  let x19: u32 = ((x17 >> 28) + (x1 & 0xfffffff));
  let x20: fiat_p448_u1 = ((x18 >> 28) as fiat_p448_u1);
  let x21: u32 = ((x5 & 0xfffffff) + (x20 as u32));
  let x22: u32 = ((((x19 >> 28) as fiat_p448_u1) as u32) + ((x4 & 0xfffffff) + (x20 as u32)));
  let x23: u32 = (x21 & 0xfffffff);
  let x24: u32 = ((((x21 >> 28) as fiat_p448_u1) as u32) + (x7 & 0xfffffff));
  let x25: u32 = (x9 & 0xfffffff);
  let x26: u32 = (x11 & 0xfffffff);
  let x27: u32 = (x13 & 0xfffffff);
  let x28: u32 = (x15 & 0xfffffff);
  let x29: u32 = (x17 & 0xfffffff);
  let x30: u32 = (x19 & 0xfffffff);
  let x31: u32 = (x22 & 0xfffffff);
  let x32: u32 = ((((x22 >> 28) as fiat_p448_u1) as u32) + (x6 & 0xfffffff));
  let x33: u32 = (x8 & 0xfffffff);
  let x34: u32 = (x10 & 0xfffffff);
  let x35: u32 = (x12 & 0xfffffff);
  let x36: u32 = (x14 & 0xfffffff);
  let x37: u32 = (x16 & 0xfffffff);
  let x38: u32 = (x18 & 0xfffffff);
  out1[0] = x23;
  out1[1] = x24;
  out1[2] = x25;
  out1[3] = x26;
  out1[4] = x27;
  out1[5] = x28;
  out1[6] = x29;
  out1[7] = x30;
  out1[8] = x31;
  out1[9] = x32;
  out1[10] = x33;
  out1[11] = x34;
  out1[12] = x35;
  out1[13] = x36;
  out1[14] = x37;
  out1[15] = x38;
}

/// The function fiat_p448_add adds two field elements.
///
/// Postconditions:
///   eval out1 mod m = (eval arg1 + eval arg2) mod m
///
#[inline]
pub fn fiat_p448_add(out1: &mut fiat_p448_loose_field_element, arg1: &fiat_p448_tight_field_element, arg2: &fiat_p448_tight_field_element) -> () {
  let x1: u32 = ((arg1[0]) + (arg2[0]));
  let x2: u32 = ((arg1[1]) + (arg2[1]));
  let x3: u32 = ((arg1[2]) + (arg2[2]));
  let x4: u32 = ((arg1[3]) + (arg2[3]));
  let x5: u32 = ((arg1[4]) + (arg2[4]));
  let x6: u32 = ((arg1[5]) + (arg2[5]));
  let x7: u32 = ((arg1[6]) + (arg2[6]));
  let x8: u32 = ((arg1[7]) + (arg2[7]));
  let x9: u32 = ((arg1[8]) + (arg2[8]));
  let x10: u32 = ((arg1[9]) + (arg2[9]));
  let x11: u32 = ((arg1[10]) + (arg2[10]));
  let x12: u32 = ((arg1[11]) + (arg2[11]));
  let x13: u32 = ((arg1[12]) + (arg2[12]));
  let x14: u32 = ((arg1[13]) + (arg2[13]));
  let x15: u32 = ((arg1[14]) + (arg2[14]));
  let x16: u32 = ((arg1[15]) + (arg2[15]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
  out1[10] = x11;
  out1[11] = x12;
  out1[12] = x13;
  out1[13] = x14;
  out1[14] = x15;
  out1[15] = x16;
}

/// The function fiat_p448_sub subtracts two field elements.
///
/// Postconditions:
///   eval out1 mod m = (eval arg1 - eval arg2) mod m
///
#[inline]
pub fn fiat_p448_sub(out1: &mut fiat_p448_loose_field_element, arg1: &fiat_p448_tight_field_element, arg2: &fiat_p448_tight_field_element) -> () {
  let x1: u32 = ((0x1ffffffe + (arg1[0])) - (arg2[0]));
  let x2: u32 = ((0x1ffffffe + (arg1[1])) - (arg2[1]));
  let x3: u32 = ((0x1ffffffe + (arg1[2])) - (arg2[2]));
  let x4: u32 = ((0x1ffffffe + (arg1[3])) - (arg2[3]));
  let x5: u32 = ((0x1ffffffe + (arg1[4])) - (arg2[4]));
  let x6: u32 = ((0x1ffffffe + (arg1[5])) - (arg2[5]));
  let x7: u32 = ((0x1ffffffe + (arg1[6])) - (arg2[6]));
  let x8: u32 = ((0x1ffffffe + (arg1[7])) - (arg2[7]));
  let x9: u32 = ((0x1ffffffc + (arg1[8])) - (arg2[8]));
  let x10: u32 = ((0x1ffffffe + (arg1[9])) - (arg2[9]));
  let x11: u32 = ((0x1ffffffe + (arg1[10])) - (arg2[10]));
  let x12: u32 = ((0x1ffffffe + (arg1[11])) - (arg2[11]));
  let x13: u32 = ((0x1ffffffe + (arg1[12])) - (arg2[12]));
  let x14: u32 = ((0x1ffffffe + (arg1[13])) - (arg2[13]));
  let x15: u32 = ((0x1ffffffe + (arg1[14])) - (arg2[14]));
  let x16: u32 = ((0x1ffffffe + (arg1[15])) - (arg2[15]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
  out1[10] = x11;
  out1[11] = x12;
  out1[12] = x13;
  out1[13] = x14;
  out1[14] = x15;
  out1[15] = x16;
}

/// The function fiat_p448_opp negates a field element.
///
/// Postconditions:
///   eval out1 mod m = -eval arg1 mod m
///
#[inline]
pub fn fiat_p448_opp(out1: &mut fiat_p448_loose_field_element, arg1: &fiat_p448_tight_field_element) -> () {
  let x1: u32 = (0x1ffffffe - (arg1[0]));
  let x2: u32 = (0x1ffffffe - (arg1[1]));
  let x3: u32 = (0x1ffffffe - (arg1[2]));
  let x4: u32 = (0x1ffffffe - (arg1[3]));
  let x5: u32 = (0x1ffffffe - (arg1[4]));
  let x6: u32 = (0x1ffffffe - (arg1[5]));
  let x7: u32 = (0x1ffffffe - (arg1[6]));
  let x8: u32 = (0x1ffffffe - (arg1[7]));
  let x9: u32 = (0x1ffffffc - (arg1[8]));
  let x10: u32 = (0x1ffffffe - (arg1[9]));
  let x11: u32 = (0x1ffffffe - (arg1[10]));
  let x12: u32 = (0x1ffffffe - (arg1[11]));
  let x13: u32 = (0x1ffffffe - (arg1[12]));
  let x14: u32 = (0x1ffffffe - (arg1[13]));
  let x15: u32 = (0x1ffffffe - (arg1[14]));
  let x16: u32 = (0x1ffffffe - (arg1[15]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
  out1[10] = x11;
  out1[11] = x12;
  out1[12] = x13;
  out1[13] = x14;
  out1[14] = x15;
  out1[15] = x16;
}

/// The function fiat_p448_selectznz is a multi-limb conditional select.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p448_selectznz(out1: &mut [u32; 16], arg1: fiat_p448_u1, arg2: &[u32; 16], arg3: &[u32; 16]) -> () {
  let mut x1: u32 = 0;
  fiat_p448_cmovznz_u32(&mut x1, arg1, (arg2[0]), (arg3[0]));
  let mut x2: u32 = 0;
  fiat_p448_cmovznz_u32(&mut x2, arg1, (arg2[1]), (arg3[1]));
  let mut x3: u32 = 0;
  fiat_p448_cmovznz_u32(&mut x3, arg1, (arg2[2]), (arg3[2]));
  let mut x4: u32 = 0;
  fiat_p448_cmovznz_u32(&mut x4, arg1, (arg2[3]), (arg3[3]));
  let mut x5: u32 = 0;
  fiat_p448_cmovznz_u32(&mut x5, arg1, (arg2[4]), (arg3[4]));
  let mut x6: u32 = 0;
  fiat_p448_cmovznz_u32(&mut x6, arg1, (arg2[5]), (arg3[5]));
  let mut x7: u32 = 0;
  fiat_p448_cmovznz_u32(&mut x7, arg1, (arg2[6]), (arg3[6]));
  let mut x8: u32 = 0;
  fiat_p448_cmovznz_u32(&mut x8, arg1, (arg2[7]), (arg3[7]));
  let mut x9: u32 = 0;
  fiat_p448_cmovznz_u32(&mut x9, arg1, (arg2[8]), (arg3[8]));
  let mut x10: u32 = 0;
  fiat_p448_cmovznz_u32(&mut x10, arg1, (arg2[9]), (arg3[9]));
  let mut x11: u32 = 0;
  fiat_p448_cmovznz_u32(&mut x11, arg1, (arg2[10]), (arg3[10]));
  let mut x12: u32 = 0;
  fiat_p448_cmovznz_u32(&mut x12, arg1, (arg2[11]), (arg3[11]));
  let mut x13: u32 = 0;
  fiat_p448_cmovznz_u32(&mut x13, arg1, (arg2[12]), (arg3[12]));
  let mut x14: u32 = 0;
  fiat_p448_cmovznz_u32(&mut x14, arg1, (arg2[13]), (arg3[13]));
  let mut x15: u32 = 0;
  fiat_p448_cmovznz_u32(&mut x15, arg1, (arg2[14]), (arg3[14]));
  let mut x16: u32 = 0;
  fiat_p448_cmovznz_u32(&mut x16, arg1, (arg2[15]), (arg3[15]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
  out1[10] = x11;
  out1[11] = x12;
  out1[12] = x13;
  out1[13] = x14;
  out1[14] = x15;
  out1[15] = x16;
}

/// The function fiat_p448_to_bytes serializes a field element to bytes in little-endian order.
///
/// Postconditions:
///   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..55]
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
#[inline]
pub fn fiat_p448_to_bytes(out1: &mut [u8; 56], arg1: &fiat_p448_tight_field_element) -> () {
  let mut x1: u32 = 0;
  let mut x2: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u28(&mut x1, &mut x2, 0x0, (arg1[0]), 0xfffffff);
  let mut x3: u32 = 0;
  let mut x4: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u28(&mut x3, &mut x4, x2, (arg1[1]), 0xfffffff);
  let mut x5: u32 = 0;
  let mut x6: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u28(&mut x5, &mut x6, x4, (arg1[2]), 0xfffffff);
  let mut x7: u32 = 0;
  let mut x8: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u28(&mut x7, &mut x8, x6, (arg1[3]), 0xfffffff);
  let mut x9: u32 = 0;
  let mut x10: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u28(&mut x9, &mut x10, x8, (arg1[4]), 0xfffffff);
  let mut x11: u32 = 0;
  let mut x12: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u28(&mut x11, &mut x12, x10, (arg1[5]), 0xfffffff);
  let mut x13: u32 = 0;
  let mut x14: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u28(&mut x13, &mut x14, x12, (arg1[6]), 0xfffffff);
  let mut x15: u32 = 0;
  let mut x16: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u28(&mut x15, &mut x16, x14, (arg1[7]), 0xfffffff);
  let mut x17: u32 = 0;
  let mut x18: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u28(&mut x17, &mut x18, x16, (arg1[8]), 0xffffffe);
  let mut x19: u32 = 0;
  let mut x20: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u28(&mut x19, &mut x20, x18, (arg1[9]), 0xfffffff);
  let mut x21: u32 = 0;
  let mut x22: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u28(&mut x21, &mut x22, x20, (arg1[10]), 0xfffffff);
  let mut x23: u32 = 0;
  let mut x24: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u28(&mut x23, &mut x24, x22, (arg1[11]), 0xfffffff);
  let mut x25: u32 = 0;
  let mut x26: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u28(&mut x25, &mut x26, x24, (arg1[12]), 0xfffffff);
  let mut x27: u32 = 0;
  let mut x28: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u28(&mut x27, &mut x28, x26, (arg1[13]), 0xfffffff);
  let mut x29: u32 = 0;
  let mut x30: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u28(&mut x29, &mut x30, x28, (arg1[14]), 0xfffffff);
  let mut x31: u32 = 0;
  let mut x32: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u28(&mut x31, &mut x32, x30, (arg1[15]), 0xfffffff);
  let mut x33: u32 = 0;
  fiat_p448_cmovznz_u32(&mut x33, x32, (0x0 as u32), 0xffffffff);
  let mut x34: u32 = 0;
  let mut x35: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u28(&mut x34, &mut x35, 0x0, x1, (x33 & 0xfffffff));
  let mut x36: u32 = 0;
  let mut x37: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u28(&mut x36, &mut x37, x35, x3, (x33 & 0xfffffff));
  let mut x38: u32 = 0;
  let mut x39: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u28(&mut x38, &mut x39, x37, x5, (x33 & 0xfffffff));
  let mut x40: u32 = 0;
  let mut x41: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u28(&mut x40, &mut x41, x39, x7, (x33 & 0xfffffff));
  let mut x42: u32 = 0;
  let mut x43: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u28(&mut x42, &mut x43, x41, x9, (x33 & 0xfffffff));
  let mut x44: u32 = 0;
  let mut x45: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u28(&mut x44, &mut x45, x43, x11, (x33 & 0xfffffff));
  let mut x46: u32 = 0;
  let mut x47: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u28(&mut x46, &mut x47, x45, x13, (x33 & 0xfffffff));
  let mut x48: u32 = 0;
  let mut x49: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u28(&mut x48, &mut x49, x47, x15, (x33 & 0xfffffff));
  let mut x50: u32 = 0;
  let mut x51: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u28(&mut x50, &mut x51, x49, x17, (x33 & 0xffffffe));
  let mut x52: u32 = 0;
  let mut x53: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u28(&mut x52, &mut x53, x51, x19, (x33 & 0xfffffff));
  let mut x54: u32 = 0;
  let mut x55: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u28(&mut x54, &mut x55, x53, x21, (x33 & 0xfffffff));
  let mut x56: u32 = 0;
  let mut x57: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u28(&mut x56, &mut x57, x55, x23, (x33 & 0xfffffff));
  let mut x58: u32 = 0;
  let mut x59: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u28(&mut x58, &mut x59, x57, x25, (x33 & 0xfffffff));
  let mut x60: u32 = 0;
  let mut x61: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u28(&mut x60, &mut x61, x59, x27, (x33 & 0xfffffff));
  let mut x62: u32 = 0;
  let mut x63: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u28(&mut x62, &mut x63, x61, x29, (x33 & 0xfffffff));
  let mut x64: u32 = 0;
  let mut x65: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u28(&mut x64, &mut x65, x63, x31, (x33 & 0xfffffff));
  let x66: u32 = (x64 << 4);
  let x67: u32 = (x60 << 4);
  let x68: u32 = (x56 << 4);
  let x69: u32 = (x52 << 4);
  let x70: u32 = (x48 << 4);
  let x71: u32 = (x44 << 4);
  let x72: u32 = (x40 << 4);
  let x73: u32 = (x36 << 4);
  let x74: u8 = ((x34 & (0xff as u32)) as u8);
  let x75: u32 = (x34 >> 8);
  let x76: u8 = ((x75 & (0xff as u32)) as u8);
  let x77: u32 = (x75 >> 8);
  let x78: u8 = ((x77 & (0xff as u32)) as u8);
  let x79: u8 = ((x77 >> 8) as u8);
  let x80: u32 = (x73 + (x79 as u32));
  let x81: u8 = ((x80 & (0xff as u32)) as u8);
  let x82: u32 = (x80 >> 8);
  let x83: u8 = ((x82 & (0xff as u32)) as u8);
  let x84: u32 = (x82 >> 8);
  let x85: u8 = ((x84 & (0xff as u32)) as u8);
  let x86: u8 = ((x84 >> 8) as u8);
  let x87: u8 = ((x38 & (0xff as u32)) as u8);
  let x88: u32 = (x38 >> 8);
  let x89: u8 = ((x88 & (0xff as u32)) as u8);
  let x90: u32 = (x88 >> 8);
  let x91: u8 = ((x90 & (0xff as u32)) as u8);
  let x92: u8 = ((x90 >> 8) as u8);
  let x93: u32 = (x72 + (x92 as u32));
  let x94: u8 = ((x93 & (0xff as u32)) as u8);
  let x95: u32 = (x93 >> 8);
  let x96: u8 = ((x95 & (0xff as u32)) as u8);
  let x97: u32 = (x95 >> 8);
  let x98: u8 = ((x97 & (0xff as u32)) as u8);
  let x99: u8 = ((x97 >> 8) as u8);
  let x100: u8 = ((x42 & (0xff as u32)) as u8);
  let x101: u32 = (x42 >> 8);
  let x102: u8 = ((x101 & (0xff as u32)) as u8);
  let x103: u32 = (x101 >> 8);
  let x104: u8 = ((x103 & (0xff as u32)) as u8);
  let x105: u8 = ((x103 >> 8) as u8);
  let x106: u32 = (x71 + (x105 as u32));
  let x107: u8 = ((x106 & (0xff as u32)) as u8);
  let x108: u32 = (x106 >> 8);
  let x109: u8 = ((x108 & (0xff as u32)) as u8);
  let x110: u32 = (x108 >> 8);
  let x111: u8 = ((x110 & (0xff as u32)) as u8);
  let x112: u8 = ((x110 >> 8) as u8);
  let x113: u8 = ((x46 & (0xff as u32)) as u8);
  let x114: u32 = (x46 >> 8);
  let x115: u8 = ((x114 & (0xff as u32)) as u8);
  let x116: u32 = (x114 >> 8);
  let x117: u8 = ((x116 & (0xff as u32)) as u8);
  let x118: u8 = ((x116 >> 8) as u8);
  let x119: u32 = (x70 + (x118 as u32));
  let x120: u8 = ((x119 & (0xff as u32)) as u8);
  let x121: u32 = (x119 >> 8);
  let x122: u8 = ((x121 & (0xff as u32)) as u8);
  let x123: u32 = (x121 >> 8);
  let x124: u8 = ((x123 & (0xff as u32)) as u8);
  let x125: u8 = ((x123 >> 8) as u8);
  let x126: u8 = ((x50 & (0xff as u32)) as u8);
  let x127: u32 = (x50 >> 8);
  let x128: u8 = ((x127 & (0xff as u32)) as u8);
  let x129: u32 = (x127 >> 8);
  let x130: u8 = ((x129 & (0xff as u32)) as u8);
  let x131: u8 = ((x129 >> 8) as u8);
  let x132: u32 = (x69 + (x131 as u32));
  let x133: u8 = ((x132 & (0xff as u32)) as u8);
  let x134: u32 = (x132 >> 8);
  let x135: u8 = ((x134 & (0xff as u32)) as u8);
  let x136: u32 = (x134 >> 8);
  let x137: u8 = ((x136 & (0xff as u32)) as u8);
  let x138: u8 = ((x136 >> 8) as u8);
  let x139: u8 = ((x54 & (0xff as u32)) as u8);
  let x140: u32 = (x54 >> 8);
  let x141: u8 = ((x140 & (0xff as u32)) as u8);
  let x142: u32 = (x140 >> 8);
  let x143: u8 = ((x142 & (0xff as u32)) as u8);
  let x144: u8 = ((x142 >> 8) as u8);
  let x145: u32 = (x68 + (x144 as u32));
  let x146: u8 = ((x145 & (0xff as u32)) as u8);
  let x147: u32 = (x145 >> 8);
  let x148: u8 = ((x147 & (0xff as u32)) as u8);
  let x149: u32 = (x147 >> 8);
  let x150: u8 = ((x149 & (0xff as u32)) as u8);
  let x151: u8 = ((x149 >> 8) as u8);
  let x152: u8 = ((x58 & (0xff as u32)) as u8);
  let x153: u32 = (x58 >> 8);
  let x154: u8 = ((x153 & (0xff as u32)) as u8);
  let x155: u32 = (x153 >> 8);
  let x156: u8 = ((x155 & (0xff as u32)) as u8);
  let x157: u8 = ((x155 >> 8) as u8);
  let x158: u32 = (x67 + (x157 as u32));
  let x159: u8 = ((x158 & (0xff as u32)) as u8);
  let x160: u32 = (x158 >> 8);
  let x161: u8 = ((x160 & (0xff as u32)) as u8);
  let x162: u32 = (x160 >> 8);
  let x163: u8 = ((x162 & (0xff as u32)) as u8);
  let x164: u8 = ((x162 >> 8) as u8);
  let x165: u8 = ((x62 & (0xff as u32)) as u8);
  let x166: u32 = (x62 >> 8);
  let x167: u8 = ((x166 & (0xff as u32)) as u8);
  let x168: u32 = (x166 >> 8);
  let x169: u8 = ((x168 & (0xff as u32)) as u8);
  let x170: u8 = ((x168 >> 8) as u8);
  let x171: u32 = (x66 + (x170 as u32));
  let x172: u8 = ((x171 & (0xff as u32)) as u8);
  let x173: u32 = (x171 >> 8);
  let x174: u8 = ((x173 & (0xff as u32)) as u8);
  let x175: u32 = (x173 >> 8);
  let x176: u8 = ((x175 & (0xff as u32)) as u8);
  let x177: u8 = ((x175 >> 8) as u8);
  out1[0] = x74;
  out1[1] = x76;
  out1[2] = x78;
  out1[3] = x81;
  out1[4] = x83;
  out1[5] = x85;
  out1[6] = x86;
  out1[7] = x87;
  out1[8] = x89;
  out1[9] = x91;
  out1[10] = x94;
  out1[11] = x96;
  out1[12] = x98;
  out1[13] = x99;
  out1[14] = x100;
  out1[15] = x102;
  out1[16] = x104;
  out1[17] = x107;
  out1[18] = x109;
  out1[19] = x111;
  out1[20] = x112;
  out1[21] = x113;
  out1[22] = x115;
  out1[23] = x117;
  out1[24] = x120;
  out1[25] = x122;
  out1[26] = x124;
  out1[27] = x125;
  out1[28] = x126;
  out1[29] = x128;
  out1[30] = x130;
  out1[31] = x133;
  out1[32] = x135;
  out1[33] = x137;
  out1[34] = x138;
  out1[35] = x139;
  out1[36] = x141;
  out1[37] = x143;
  out1[38] = x146;
  out1[39] = x148;
  out1[40] = x150;
  out1[41] = x151;
  out1[42] = x152;
  out1[43] = x154;
  out1[44] = x156;
  out1[45] = x159;
  out1[46] = x161;
  out1[47] = x163;
  out1[48] = x164;
  out1[49] = x165;
  out1[50] = x167;
  out1[51] = x169;
  out1[52] = x172;
  out1[53] = x174;
  out1[54] = x176;
  out1[55] = x177;
}

/// The function fiat_p448_from_bytes deserializes a field element from bytes in little-endian order.
///
/// Postconditions:
///   eval out1 mod m = bytes_eval arg1 mod m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
#[inline]
pub fn fiat_p448_from_bytes(out1: &mut fiat_p448_tight_field_element, arg1: &[u8; 56]) -> () {
  let x1: u32 = (((arg1[55]) as u32) << 20);
  let x2: u32 = (((arg1[54]) as u32) << 12);
  let x3: u32 = (((arg1[53]) as u32) << 4);
  let x4: u32 = (((arg1[52]) as u32) << 24);
  let x5: u32 = (((arg1[51]) as u32) << 16);
  let x6: u32 = (((arg1[50]) as u32) << 8);
  let x7: u8 = (arg1[49]);
  let x8: u32 = (((arg1[48]) as u32) << 20);
  let x9: u32 = (((arg1[47]) as u32) << 12);
  let x10: u32 = (((arg1[46]) as u32) << 4);
  let x11: u32 = (((arg1[45]) as u32) << 24);
  let x12: u32 = (((arg1[44]) as u32) << 16);
  let x13: u32 = (((arg1[43]) as u32) << 8);
  let x14: u8 = (arg1[42]);
  let x15: u32 = (((arg1[41]) as u32) << 20);
  let x16: u32 = (((arg1[40]) as u32) << 12);
  let x17: u32 = (((arg1[39]) as u32) << 4);
  let x18: u32 = (((arg1[38]) as u32) << 24);
  let x19: u32 = (((arg1[37]) as u32) << 16);
  let x20: u32 = (((arg1[36]) as u32) << 8);
  let x21: u8 = (arg1[35]);
  let x22: u32 = (((arg1[34]) as u32) << 20);
  let x23: u32 = (((arg1[33]) as u32) << 12);
  let x24: u32 = (((arg1[32]) as u32) << 4);
  let x25: u32 = (((arg1[31]) as u32) << 24);
  let x26: u32 = (((arg1[30]) as u32) << 16);
  let x27: u32 = (((arg1[29]) as u32) << 8);
  let x28: u8 = (arg1[28]);
  let x29: u32 = (((arg1[27]) as u32) << 20);
  let x30: u32 = (((arg1[26]) as u32) << 12);
  let x31: u32 = (((arg1[25]) as u32) << 4);
  let x32: u32 = (((arg1[24]) as u32) << 24);
  let x33: u32 = (((arg1[23]) as u32) << 16);
  let x34: u32 = (((arg1[22]) as u32) << 8);
  let x35: u8 = (arg1[21]);
  let x36: u32 = (((arg1[20]) as u32) << 20);
  let x37: u32 = (((arg1[19]) as u32) << 12);
  let x38: u32 = (((arg1[18]) as u32) << 4);
  let x39: u32 = (((arg1[17]) as u32) << 24);
  let x40: u32 = (((arg1[16]) as u32) << 16);
  let x41: u32 = (((arg1[15]) as u32) << 8);
  let x42: u8 = (arg1[14]);
  let x43: u32 = (((arg1[13]) as u32) << 20);
  let x44: u32 = (((arg1[12]) as u32) << 12);
  let x45: u32 = (((arg1[11]) as u32) << 4);
  let x46: u32 = (((arg1[10]) as u32) << 24);
  let x47: u32 = (((arg1[9]) as u32) << 16);
  let x48: u32 = (((arg1[8]) as u32) << 8);
  let x49: u8 = (arg1[7]);
  let x50: u32 = (((arg1[6]) as u32) << 20);
  let x51: u32 = (((arg1[5]) as u32) << 12);
  let x52: u32 = (((arg1[4]) as u32) << 4);
  let x53: u32 = (((arg1[3]) as u32) << 24);
  let x54: u32 = (((arg1[2]) as u32) << 16);
  let x55: u32 = (((arg1[1]) as u32) << 8);
  let x56: u8 = (arg1[0]);
  let x57: u32 = (x55 + (x56 as u32));
  let x58: u32 = (x54 + x57);
  let x59: u32 = (x53 + x58);
  let x60: u32 = (x59 & 0xfffffff);
  let x61: u8 = ((x59 >> 28) as u8);
  let x62: u32 = (x52 + (x61 as u32));
  let x63: u32 = (x51 + x62);
  let x64: u32 = (x50 + x63);
  let x65: u32 = (x48 + (x49 as u32));
  let x66: u32 = (x47 + x65);
  let x67: u32 = (x46 + x66);
  let x68: u32 = (x67 & 0xfffffff);
  let x69: u8 = ((x67 >> 28) as u8);
  let x70: u32 = (x45 + (x69 as u32));
  let x71: u32 = (x44 + x70);
  let x72: u32 = (x43 + x71);
  let x73: u32 = (x41 + (x42 as u32));
  let x74: u32 = (x40 + x73);
  let x75: u32 = (x39 + x74);
  let x76: u32 = (x75 & 0xfffffff);
  let x77: u8 = ((x75 >> 28) as u8);
  let x78: u32 = (x38 + (x77 as u32));
  let x79: u32 = (x37 + x78);
  let x80: u32 = (x36 + x79);
  let x81: u32 = (x34 + (x35 as u32));
  let x82: u32 = (x33 + x81);
  let x83: u32 = (x32 + x82);
  let x84: u32 = (x83 & 0xfffffff);
  let x85: u8 = ((x83 >> 28) as u8);
  let x86: u32 = (x31 + (x85 as u32));
  let x87: u32 = (x30 + x86);
  let x88: u32 = (x29 + x87);
  let x89: u32 = (x27 + (x28 as u32));
  let x90: u32 = (x26 + x89);
  let x91: u32 = (x25 + x90);
  let x92: u32 = (x91 & 0xfffffff);
  let x93: u8 = ((x91 >> 28) as u8);
  let x94: u32 = (x24 + (x93 as u32));
  let x95: u32 = (x23 + x94);
  let x96: u32 = (x22 + x95);
  let x97: u32 = (x20 + (x21 as u32));
  let x98: u32 = (x19 + x97);
  let x99: u32 = (x18 + x98);
  let x100: u32 = (x99 & 0xfffffff);
  let x101: u8 = ((x99 >> 28) as u8);
  let x102: u32 = (x17 + (x101 as u32));
  let x103: u32 = (x16 + x102);
  let x104: u32 = (x15 + x103);
  let x105: u32 = (x13 + (x14 as u32));
  let x106: u32 = (x12 + x105);
  let x107: u32 = (x11 + x106);
  let x108: u32 = (x107 & 0xfffffff);
  let x109: u8 = ((x107 >> 28) as u8);
  let x110: u32 = (x10 + (x109 as u32));
  let x111: u32 = (x9 + x110);
  let x112: u32 = (x8 + x111);
  let x113: u32 = (x6 + (x7 as u32));
  let x114: u32 = (x5 + x113);
  let x115: u32 = (x4 + x114);
  let x116: u32 = (x115 & 0xfffffff);
  let x117: u8 = ((x115 >> 28) as u8);
  let x118: u32 = (x3 + (x117 as u32));
  let x119: u32 = (x2 + x118);
  let x120: u32 = (x1 + x119);
  out1[0] = x60;
  out1[1] = x64;
  out1[2] = x68;
  out1[3] = x72;
  out1[4] = x76;
  out1[5] = x80;
  out1[6] = x84;
  out1[7] = x88;
  out1[8] = x92;
  out1[9] = x96;
  out1[10] = x100;
  out1[11] = x104;
  out1[12] = x108;
  out1[13] = x112;
  out1[14] = x116;
  out1[15] = x120;
}

/// The function fiat_p448_relax is the identity function converting from tight field elements to loose field elements.
///
/// Postconditions:
///   out1 = arg1
///
#[inline]
pub fn fiat_p448_relax(out1: &mut fiat_p448_loose_field_element, arg1: &fiat_p448_tight_field_element) -> () {
  let x1: u32 = (arg1[0]);
  let x2: u32 = (arg1[1]);
  let x3: u32 = (arg1[2]);
  let x4: u32 = (arg1[3]);
  let x5: u32 = (arg1[4]);
  let x6: u32 = (arg1[5]);
  let x7: u32 = (arg1[6]);
  let x8: u32 = (arg1[7]);
  let x9: u32 = (arg1[8]);
  let x10: u32 = (arg1[9]);
  let x11: u32 = (arg1[10]);
  let x12: u32 = (arg1[11]);
  let x13: u32 = (arg1[12]);
  let x14: u32 = (arg1[13]);
  let x15: u32 = (arg1[14]);
  let x16: u32 = (arg1[15]);
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
  out1[10] = x11;
  out1[11] = x12;
  out1[12] = x13;
  out1[13] = x14;
  out1[14] = x15;
  out1[15] = x16;
}
