/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.example;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.oozie.example.Repeatable;
import org.apache.oozie.example.TimeUnit;

public class DateList {
    private static final TimeZone UTC = DateList.getTimeZone("UTC");
    private static String DATE_LIST_SEPARATOR = ",";

    public static void main(String[] args) throws Exception {
        if (args.length < 5) {
            System.out.println("Usage: java DateList <start_time>  <end_time> <frequency> <timeunit> <timezone>");
            System.out.println("Example: java DateList 2009-02-01T01:00Z 2009-02-01T02:00Z 15 MINUTES UTC");
            System.exit(1);
        }
        Date startTime = DateList.parseDateUTC(args[0]);
        Date endTime = DateList.parseDateUTC(args[1]);
        Repeatable rep = new Repeatable();
        rep.setBaseline(startTime);
        rep.setFrequency(Integer.parseInt(args[2]));
        rep.setTimeUnit(TimeUnit.valueOf(args[3]));
        rep.setTimeZone(DateList.getTimeZone(args[4]));
        Date date = null;
        int occurrence = 0;
        StringBuilder dateList = new StringBuilder();
        while ((date = rep.getOccurrenceTime(startTime, occurrence++, null)).before(endTime)) {
            if (occurrence > 1) {
                dateList.append(DATE_LIST_SEPARATOR);
            }
            dateList.append(DateList.formatDateUTC(date));
            if (date != null) continue;
        }
        System.out.println("datelist :" + dateList + ":");
        File file = new File(System.getProperty("oozie.action.output.properties"));
        Properties props = new Properties();
        props.setProperty("datelist", dateList.toString());
        FileOutputStream os = new FileOutputStream(file);
        props.store(os, "");
        ((OutputStream)os).close();
    }

    private static DateFormat getISO8601DateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        dateFormat.setTimeZone(UTC);
        return dateFormat;
    }

    private static TimeZone getTimeZone(String tzId) {
        TimeZone tz = TimeZone.getTimeZone(tzId);
        if (!tz.getID().equals(tzId)) {
            throw new IllegalArgumentException("Invalid TimeZone: " + tzId);
        }
        return tz;
    }

    private static Date parseDateUTC(String s) throws Exception {
        return DateList.getISO8601DateFormat().parse(s);
    }

    private static String formatDateUTC(Date d) throws Exception {
        return d != null ? DateList.getISO8601DateFormat().format(d) : "NULL";
    }

    private static String formatDateUTC(Calendar c) throws Exception {
        return c != null ? DateList.formatDateUTC(c.getTime()) : "NULL";
    }
}

