// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

#pragma warning disable 0184


using System;
using System.Runtime.InteropServices;
using Xunit;

public class Program
{
    private static void Eval(int testCase, bool b1, bool b2)
    {
        if (b1 != b2) throw new Exception(string.Format("case {0:000} failed: v1 {1} v2 {2}", testCase, b1, b2));
    }

    private static void TestCase0001()
    {
        {
            EmptyStruct v = default(EmptyStruct);
            ValueType o = v;
            Eval(0001, o is EmptyStruct, true);
            Eval(0002, o is EmptyStruct[], false);
            Eval(0003, o is EmptyStruct?, true);
            Eval(0004, o is EmptyStruct?[], false);
            Eval(0005, o is NotEmptyStruct, false);
            Eval(0006, o is NotEmptyStruct[], false);
            Eval(0007, o is NotEmptyStruct?, false);
            Eval(0008, o is NotEmptyStruct?[], false);
            Eval(0009, o is EmptyStructGen<int>, false);
            Eval(0010, o is EmptyStructGen<int>[], false);
            Eval(0011, o is EmptyStructGen<int>?, false);
            Eval(0012, o is EmptyStructGen<int>?[], false);
            Eval(0013, o is NotEmptyStructGen<Guid>, false);
            Eval(0014, o is NotEmptyStructGen<Guid>[], false);
            Eval(0015, o is NotEmptyStructGen<Guid>?, false);
            Eval(0016, o is NotEmptyStructGen<Guid>?[], false);
            Eval(0017, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(0018, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(0019, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(0020, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(0021, o is NestedStruct, false);
            Eval(0022, o is NestedStruct[], false);
            Eval(0023, o is NestedStruct?, false);
            Eval(0024, o is NestedStruct?[], false);
            Eval(0025, o is NestedStructGen<Decimal>, false);
            Eval(0026, o is NestedStructGen<Decimal>[], false);
            Eval(0027, o is NestedStructGen<Decimal>?, false);
            Eval(0028, o is NestedStructGen<Decimal>?[], false);
            Eval(0029, o is ExplicitFieldOffsetStruct, false);
            Eval(0030, o is ExplicitFieldOffsetStruct[], false);
            Eval(0031, o is ExplicitFieldOffsetStruct?, false);
            Eval(0032, o is ExplicitFieldOffsetStruct?[], false);
            Eval(0041, o is MarshalAsStruct, false);
            Eval(0042, o is MarshalAsStruct[], false);
            Eval(0043, o is MarshalAsStruct?, false);
            Eval(0044, o is MarshalAsStruct?[], false);
            Eval(0045, o is ImplementOneInterface, false);
            Eval(0046, o is ImplementOneInterface[], false);
            Eval(0047, o is ImplementOneInterface?, false);
            Eval(0048, o is ImplementOneInterface?[], false);
            Eval(0049, o is ImplementTwoInterface, false);
            Eval(0050, o is ImplementTwoInterface[], false);
            Eval(0051, o is ImplementTwoInterface?, false);
            Eval(0052, o is ImplementTwoInterface?[], false);
            Eval(0053, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(0054, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(0055, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(0056, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(0057, o is ImplementTwoInterfaceGen<int>, false);
            Eval(0058, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(0059, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(0060, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(0061, o is ImplementAllInterface<int>, false);
            Eval(0062, o is ImplementAllInterface<int>[], false);
            Eval(0063, o is ImplementAllInterface<int>?, false);
            Eval(0064, o is ImplementAllInterface<int>?[], false);
            Eval(0065, o is IntE, false);
            Eval(0066, o is IntE[], false);
            Eval(0067, o is IntE?, false);
            Eval(0068, o is IntE?[], false);
            Eval(0069, o is ByteE, false);
            Eval(0070, o is ByteE[], false);
            Eval(0071, o is ByteE?, false);
            Eval(0072, o is ByteE?[], false);
            Eval(0073, o is LongE, false);
            Eval(0074, o is LongE[], false);
            Eval(0075, o is LongE?, false);
            Eval(0076, o is LongE?[], false);
            Eval(0077, o is char, false);
            Eval(0078, o is char[], false);
            Eval(0079, o is char?, false);
            Eval(0080, o is char?[], false);
            Eval(0081, o is bool, false);
            Eval(0082, o is bool[], false);
            Eval(0083, o is bool?, false);
            Eval(0084, o is bool?[], false);
            Eval(0085, o is byte, false);
            Eval(0086, o is byte[], false);
            Eval(0087, o is byte?, false);
            Eval(0088, o is byte?[], false);
            Eval(0089, o is sbyte, false);
            Eval(0090, o is sbyte[], false);
            Eval(0091, o is sbyte?, false);
            Eval(0092, o is sbyte?[], false);
            Eval(0093, o is short, false);
            Eval(0094, o is short[], false);
            Eval(0095, o is short?, false);
            Eval(0096, o is short?[], false);
            Eval(0097, o is ushort, false);
            Eval(0098, o is ushort[], false);
            Eval(0099, o is ushort?, false);
            Eval(0100, o is ushort?[], false);
            Eval(0101, o is int, false);
            Eval(0102, o is int[], false);
            Eval(0103, o is int?, false);
            Eval(0104, o is int?[], false);
            Eval(0105, o is uint, false);
            Eval(0106, o is uint[], false);
            Eval(0107, o is uint?, false);
            Eval(0108, o is uint?[], false);
            Eval(0109, o is long, false);
            Eval(0110, o is long[], false);
            Eval(0111, o is long?, false);
            Eval(0112, o is long?[], false);
            Eval(0113, o is ulong, false);
            Eval(0114, o is ulong[], false);
            Eval(0115, o is ulong?, false);
            Eval(0116, o is ulong?[], false);
            Eval(0117, o is float, false);
            Eval(0118, o is float[], false);
            Eval(0119, o is float?, false);
            Eval(0120, o is float?[], false);
            Eval(0121, o is double, false);
            Eval(0122, o is double[], false);
            Eval(0123, o is double?, false);
            Eval(0124, o is double?[], false);
            Eval(0125, o is decimal, false);
            Eval(0126, o is decimal[], false);
            Eval(0127, o is decimal?, false);
            Eval(0128, o is decimal?[], false);
            Eval(0129, o is IntPtr, false);
            Eval(0130, o is IntPtr[], false);
            Eval(0131, o is IntPtr?, false);
            Eval(0132, o is IntPtr?[], false);
            Eval(0133, o is UIntPtr, false);
            Eval(0134, o is UIntPtr[], false);
            Eval(0135, o is UIntPtr?, false);
            Eval(0136, o is UIntPtr?[], false);
            Eval(0137, o is Guid, false);
            Eval(0138, o is Guid[], false);
            Eval(0139, o is Guid?, false);
            Eval(0140, o is Guid?[], false);
            Eval(0141, o is GCHandle, false);
            Eval(0142, o is GCHandle[], false);
            Eval(0143, o is GCHandle?, false);
            Eval(0144, o is GCHandle?[], false);
            Eval(0145, o is object, true);
            Eval(0146, o is object[], false);
            Eval(0147, o is string, false);
            Eval(0148, o is string[], false);
            Eval(0149, o is ValueType, true);
            Eval(0150, o is ValueType[], false);
            Eval(0151, o is Array, false);
            Eval(0152, o is Array[], false);
            Eval(0153, o is Enum, false);
            Eval(0154, o is Enum[], false);
            Eval(0155, o is Delegate, false);
            Eval(0156, o is Delegate[], false);
            Eval(0157, o is MulticastDelegate, false);
            Eval(0158, o is MulticastDelegate[], false);
            Eval(0159, o is IEmpty, false);
            Eval(0160, o is IEmpty[], false);
            Eval(0161, o is INotEmpty, false);
            Eval(0162, o is INotEmpty[], false);
            Eval(0163, o is IEmptyGen<int>, false);
            Eval(0164, o is IEmptyGen<int>[], false);
            Eval(0165, o is INotEmptyGen<int>, false);
            Eval(0166, o is INotEmptyGen<int>[], false);
            Eval(0167, o is SimpleDelegate, false);
            Eval(0168, o is SimpleDelegate[], false);
            Eval(0169, o is GenericDelegate<int>, false);
            Eval(0170, o is GenericDelegate<int>[], false);
            Eval(0171, o is EmptyClass, false);
            Eval(0172, o is EmptyClass[], false);
            Eval(0173, o is NotEmptyClass, false);
            Eval(0174, o is NotEmptyClass[], false);
            Eval(0175, o is EmptyClassGen<int>, false);
            Eval(0176, o is EmptyClassGen<int>[], false);
            Eval(0177, o is NotEmptyClassGen<Guid>, false);
            Eval(0178, o is NotEmptyClassGen<Guid>[], false);
            Eval(0179, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(0180, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(0181, o is NestedClass, false);
            Eval(0182, o is NestedClass[], false);
            Eval(0183, o is NestedClassGen<Decimal>, false);
            Eval(0184, o is NestedClassGen<Decimal>[], false);
            Eval(0185, o is ImplementOneInterfaceC, false);
            Eval(0186, o is ImplementOneInterfaceC[], false);
            Eval(0187, o is ImplementTwoInterfaceC, false);
            Eval(0188, o is ImplementTwoInterfaceC[], false);
            Eval(0189, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(0190, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(0191, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(0192, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(0193, o is ImplementAllInterfaceC<int>, false);
            Eval(0194, o is ImplementAllInterfaceC<int>[], false);
            Eval(0195, o is SealedClass, false);
            Eval(0196, o is SealedClass[], false);
        }
        {
            EmptyStruct? v = default(EmptyStruct);
            ValueType o = v;
            Eval(0197, o is EmptyStruct, true);
            Eval(0198, o is EmptyStruct[], false);
            Eval(0199, o is EmptyStruct?, true);
            Eval(0200, o is EmptyStruct?[], false);
            Eval(0201, o is NotEmptyStruct, false);
            Eval(0202, o is NotEmptyStruct[], false);
            Eval(0203, o is NotEmptyStruct?, false);
            Eval(0204, o is NotEmptyStruct?[], false);
            Eval(0205, o is EmptyStructGen<int>, false);
            Eval(0206, o is EmptyStructGen<int>[], false);
            Eval(0207, o is EmptyStructGen<int>?, false);
            Eval(0208, o is EmptyStructGen<int>?[], false);
            Eval(0209, o is NotEmptyStructGen<Guid>, false);
            Eval(0210, o is NotEmptyStructGen<Guid>[], false);
            Eval(0211, o is NotEmptyStructGen<Guid>?, false);
            Eval(0212, o is NotEmptyStructGen<Guid>?[], false);
            Eval(0213, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(0214, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(0215, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(0216, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(0217, o is NestedStruct, false);
            Eval(0218, o is NestedStruct[], false);
            Eval(0219, o is NestedStruct?, false);
            Eval(0220, o is NestedStruct?[], false);
            Eval(0221, o is NestedStructGen<Decimal>, false);
            Eval(0222, o is NestedStructGen<Decimal>[], false);
            Eval(0223, o is NestedStructGen<Decimal>?, false);
            Eval(0224, o is NestedStructGen<Decimal>?[], false);
            Eval(0225, o is ExplicitFieldOffsetStruct, false);
            Eval(0226, o is ExplicitFieldOffsetStruct[], false);
            Eval(0227, o is ExplicitFieldOffsetStruct?, false);
            Eval(0228, o is ExplicitFieldOffsetStruct?[], false);
            Eval(0237, o is MarshalAsStruct, false);
            Eval(0238, o is MarshalAsStruct[], false);
            Eval(0239, o is MarshalAsStruct?, false);
            Eval(0240, o is MarshalAsStruct?[], false);
            Eval(0241, o is ImplementOneInterface, false);
            Eval(0242, o is ImplementOneInterface[], false);
            Eval(0243, o is ImplementOneInterface?, false);
            Eval(0244, o is ImplementOneInterface?[], false);
            Eval(0245, o is ImplementTwoInterface, false);
            Eval(0246, o is ImplementTwoInterface[], false);
            Eval(0247, o is ImplementTwoInterface?, false);
            Eval(0248, o is ImplementTwoInterface?[], false);
            Eval(0249, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(0250, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(0251, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(0252, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(0253, o is ImplementTwoInterfaceGen<int>, false);
            Eval(0254, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(0255, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(0256, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(0257, o is ImplementAllInterface<int>, false);
            Eval(0258, o is ImplementAllInterface<int>[], false);
            Eval(0259, o is ImplementAllInterface<int>?, false);
            Eval(0260, o is ImplementAllInterface<int>?[], false);
            Eval(0261, o is IntE, false);
            Eval(0262, o is IntE[], false);
            Eval(0263, o is IntE?, false);
            Eval(0264, o is IntE?[], false);
            Eval(0265, o is ByteE, false);
            Eval(0266, o is ByteE[], false);
            Eval(0267, o is ByteE?, false);
            Eval(0268, o is ByteE?[], false);
            Eval(0269, o is LongE, false);
            Eval(0270, o is LongE[], false);
            Eval(0271, o is LongE?, false);
            Eval(0272, o is LongE?[], false);
            Eval(0273, o is char, false);
            Eval(0274, o is char[], false);
            Eval(0275, o is char?, false);
            Eval(0276, o is char?[], false);
            Eval(0277, o is bool, false);
            Eval(0278, o is bool[], false);
            Eval(0279, o is bool?, false);
            Eval(0280, o is bool?[], false);
            Eval(0281, o is byte, false);
            Eval(0282, o is byte[], false);
            Eval(0283, o is byte?, false);
            Eval(0284, o is byte?[], false);
            Eval(0285, o is sbyte, false);
            Eval(0286, o is sbyte[], false);
            Eval(0287, o is sbyte?, false);
            Eval(0288, o is sbyte?[], false);
            Eval(0289, o is short, false);
            Eval(0290, o is short[], false);
            Eval(0291, o is short?, false);
            Eval(0292, o is short?[], false);
            Eval(0293, o is ushort, false);
            Eval(0294, o is ushort[], false);
            Eval(0295, o is ushort?, false);
            Eval(0296, o is ushort?[], false);
            Eval(0297, o is int, false);
            Eval(0298, o is int[], false);
            Eval(0299, o is int?, false);
            Eval(0300, o is int?[], false);
            Eval(0301, o is uint, false);
            Eval(0302, o is uint[], false);
            Eval(0303, o is uint?, false);
            Eval(0304, o is uint?[], false);
            Eval(0305, o is long, false);
            Eval(0306, o is long[], false);
            Eval(0307, o is long?, false);
            Eval(0308, o is long?[], false);
            Eval(0309, o is ulong, false);
            Eval(0310, o is ulong[], false);
            Eval(0311, o is ulong?, false);
            Eval(0312, o is ulong?[], false);
            Eval(0313, o is float, false);
            Eval(0314, o is float[], false);
            Eval(0315, o is float?, false);
            Eval(0316, o is float?[], false);
            Eval(0317, o is double, false);
            Eval(0318, o is double[], false);
            Eval(0319, o is double?, false);
            Eval(0320, o is double?[], false);
            Eval(0321, o is decimal, false);
            Eval(0322, o is decimal[], false);
            Eval(0323, o is decimal?, false);
            Eval(0324, o is decimal?[], false);
            Eval(0325, o is IntPtr, false);
            Eval(0326, o is IntPtr[], false);
            Eval(0327, o is IntPtr?, false);
            Eval(0328, o is IntPtr?[], false);
            Eval(0329, o is UIntPtr, false);
            Eval(0330, o is UIntPtr[], false);
            Eval(0331, o is UIntPtr?, false);
            Eval(0332, o is UIntPtr?[], false);
            Eval(0333, o is Guid, false);
            Eval(0334, o is Guid[], false);
            Eval(0335, o is Guid?, false);
            Eval(0336, o is Guid?[], false);
            Eval(0337, o is GCHandle, false);
            Eval(0338, o is GCHandle[], false);
            Eval(0339, o is GCHandle?, false);
            Eval(0340, o is GCHandle?[], false);
            Eval(0341, o is object, true);
            Eval(0342, o is object[], false);
            Eval(0343, o is string, false);
            Eval(0344, o is string[], false);
            Eval(0345, o is ValueType, true);
            Eval(0346, o is ValueType[], false);
            Eval(0347, o is Array, false);
            Eval(0348, o is Array[], false);
            Eval(0349, o is Enum, false);
            Eval(0350, o is Enum[], false);
            Eval(0351, o is Delegate, false);
            Eval(0352, o is Delegate[], false);
            Eval(0353, o is MulticastDelegate, false);
            Eval(0354, o is MulticastDelegate[], false);
            Eval(0355, o is IEmpty, false);
            Eval(0356, o is IEmpty[], false);
            Eval(0357, o is INotEmpty, false);
            Eval(0358, o is INotEmpty[], false);
            Eval(0359, o is IEmptyGen<int>, false);
            Eval(0360, o is IEmptyGen<int>[], false);
            Eval(0361, o is INotEmptyGen<int>, false);
            Eval(0362, o is INotEmptyGen<int>[], false);
            Eval(0363, o is SimpleDelegate, false);
            Eval(0364, o is SimpleDelegate[], false);
            Eval(0365, o is GenericDelegate<int>, false);
            Eval(0366, o is GenericDelegate<int>[], false);
            Eval(0367, o is EmptyClass, false);
            Eval(0368, o is EmptyClass[], false);
            Eval(0369, o is NotEmptyClass, false);
            Eval(0370, o is NotEmptyClass[], false);
            Eval(0371, o is EmptyClassGen<int>, false);
            Eval(0372, o is EmptyClassGen<int>[], false);
            Eval(0373, o is NotEmptyClassGen<Guid>, false);
            Eval(0374, o is NotEmptyClassGen<Guid>[], false);
            Eval(0375, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(0376, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(0377, o is NestedClass, false);
            Eval(0378, o is NestedClass[], false);
            Eval(0379, o is NestedClassGen<Decimal>, false);
            Eval(0380, o is NestedClassGen<Decimal>[], false);
            Eval(0381, o is ImplementOneInterfaceC, false);
            Eval(0382, o is ImplementOneInterfaceC[], false);
            Eval(0383, o is ImplementTwoInterfaceC, false);
            Eval(0384, o is ImplementTwoInterfaceC[], false);
            Eval(0385, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(0386, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(0387, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(0388, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(0389, o is ImplementAllInterfaceC<int>, false);
            Eval(0390, o is ImplementAllInterfaceC<int>[], false);
            Eval(0391, o is SealedClass, false);
            Eval(0392, o is SealedClass[], false);
        }
        {
            EmptyStruct? v = default(EmptyStruct?);
            ValueType o = v;
            Eval(0393, o is EmptyStruct, false);
            Eval(0394, o is EmptyStruct[], false);
            Eval(0395, o is EmptyStruct?, false);
            Eval(0396, o is EmptyStruct?[], false);
            Eval(0397, o is NotEmptyStruct, false);
            Eval(0398, o is NotEmptyStruct[], false);
            Eval(0399, o is NotEmptyStruct?, false);
            Eval(0400, o is NotEmptyStruct?[], false);
            Eval(0401, o is EmptyStructGen<int>, false);
            Eval(0402, o is EmptyStructGen<int>[], false);
            Eval(0403, o is EmptyStructGen<int>?, false);
            Eval(0404, o is EmptyStructGen<int>?[], false);
            Eval(0405, o is NotEmptyStructGen<Guid>, false);
            Eval(0406, o is NotEmptyStructGen<Guid>[], false);
            Eval(0407, o is NotEmptyStructGen<Guid>?, false);
            Eval(0408, o is NotEmptyStructGen<Guid>?[], false);
            Eval(0409, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(0410, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(0411, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(0412, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(0413, o is NestedStruct, false);
            Eval(0414, o is NestedStruct[], false);
            Eval(0415, o is NestedStruct?, false);
            Eval(0416, o is NestedStruct?[], false);
            Eval(0417, o is NestedStructGen<Decimal>, false);
            Eval(0418, o is NestedStructGen<Decimal>[], false);
            Eval(0419, o is NestedStructGen<Decimal>?, false);
            Eval(0420, o is NestedStructGen<Decimal>?[], false);
            Eval(0421, o is ExplicitFieldOffsetStruct, false);
            Eval(0422, o is ExplicitFieldOffsetStruct[], false);
            Eval(0423, o is ExplicitFieldOffsetStruct?, false);
            Eval(0424, o is ExplicitFieldOffsetStruct?[], false);
            Eval(0433, o is MarshalAsStruct, false);
            Eval(0434, o is MarshalAsStruct[], false);
            Eval(0435, o is MarshalAsStruct?, false);
            Eval(0436, o is MarshalAsStruct?[], false);
            Eval(0437, o is ImplementOneInterface, false);
            Eval(0438, o is ImplementOneInterface[], false);
            Eval(0439, o is ImplementOneInterface?, false);
            Eval(0440, o is ImplementOneInterface?[], false);
            Eval(0441, o is ImplementTwoInterface, false);
            Eval(0442, o is ImplementTwoInterface[], false);
            Eval(0443, o is ImplementTwoInterface?, false);
            Eval(0444, o is ImplementTwoInterface?[], false);
            Eval(0445, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(0446, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(0447, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(0448, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(0449, o is ImplementTwoInterfaceGen<int>, false);
            Eval(0450, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(0451, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(0452, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(0453, o is ImplementAllInterface<int>, false);
            Eval(0454, o is ImplementAllInterface<int>[], false);
            Eval(0455, o is ImplementAllInterface<int>?, false);
            Eval(0456, o is ImplementAllInterface<int>?[], false);
            Eval(0457, o is IntE, false);
            Eval(0458, o is IntE[], false);
            Eval(0459, o is IntE?, false);
            Eval(0460, o is IntE?[], false);
            Eval(0461, o is ByteE, false);
            Eval(0462, o is ByteE[], false);
            Eval(0463, o is ByteE?, false);
            Eval(0464, o is ByteE?[], false);
            Eval(0465, o is LongE, false);
            Eval(0466, o is LongE[], false);
            Eval(0467, o is LongE?, false);
            Eval(0468, o is LongE?[], false);
            Eval(0469, o is char, false);
            Eval(0470, o is char[], false);
            Eval(0471, o is char?, false);
            Eval(0472, o is char?[], false);
            Eval(0473, o is bool, false);
            Eval(0474, o is bool[], false);
            Eval(0475, o is bool?, false);
            Eval(0476, o is bool?[], false);
            Eval(0477, o is byte, false);
            Eval(0478, o is byte[], false);
            Eval(0479, o is byte?, false);
            Eval(0480, o is byte?[], false);
            Eval(0481, o is sbyte, false);
            Eval(0482, o is sbyte[], false);
            Eval(0483, o is sbyte?, false);
            Eval(0484, o is sbyte?[], false);
            Eval(0485, o is short, false);
            Eval(0486, o is short[], false);
            Eval(0487, o is short?, false);
            Eval(0488, o is short?[], false);
            Eval(0489, o is ushort, false);
            Eval(0490, o is ushort[], false);
            Eval(0491, o is ushort?, false);
            Eval(0492, o is ushort?[], false);
            Eval(0493, o is int, false);
            Eval(0494, o is int[], false);
            Eval(0495, o is int?, false);
            Eval(0496, o is int?[], false);
            Eval(0497, o is uint, false);
            Eval(0498, o is uint[], false);
            Eval(0499, o is uint?, false);
            Eval(0500, o is uint?[], false);
            Eval(0501, o is long, false);
            Eval(0502, o is long[], false);
            Eval(0503, o is long?, false);
            Eval(0504, o is long?[], false);
            Eval(0505, o is ulong, false);
            Eval(0506, o is ulong[], false);
            Eval(0507, o is ulong?, false);
            Eval(0508, o is ulong?[], false);
            Eval(0509, o is float, false);
            Eval(0510, o is float[], false);
            Eval(0511, o is float?, false);
            Eval(0512, o is float?[], false);
            Eval(0513, o is double, false);
            Eval(0514, o is double[], false);
            Eval(0515, o is double?, false);
            Eval(0516, o is double?[], false);
            Eval(0517, o is decimal, false);
            Eval(0518, o is decimal[], false);
            Eval(0519, o is decimal?, false);
            Eval(0520, o is decimal?[], false);
            Eval(0521, o is IntPtr, false);
            Eval(0522, o is IntPtr[], false);
            Eval(0523, o is IntPtr?, false);
            Eval(0524, o is IntPtr?[], false);
            Eval(0525, o is UIntPtr, false);
            Eval(0526, o is UIntPtr[], false);
            Eval(0527, o is UIntPtr?, false);
            Eval(0528, o is UIntPtr?[], false);
            Eval(0529, o is Guid, false);
            Eval(0530, o is Guid[], false);
            Eval(0531, o is Guid?, false);
            Eval(0532, o is Guid?[], false);
            Eval(0533, o is GCHandle, false);
            Eval(0534, o is GCHandle[], false);
            Eval(0535, o is GCHandle?, false);
            Eval(0536, o is GCHandle?[], false);
            Eval(0537, o is object, false);
            Eval(0538, o is object[], false);
            Eval(0539, o is string, false);
            Eval(0540, o is string[], false);
            Eval(0541, o is ValueType, false);
            Eval(0542, o is ValueType[], false);
            Eval(0543, o is Array, false);
            Eval(0544, o is Array[], false);
            Eval(0545, o is Enum, false);
            Eval(0546, o is Enum[], false);
            Eval(0547, o is Delegate, false);
            Eval(0548, o is Delegate[], false);
            Eval(0549, o is MulticastDelegate, false);
            Eval(0550, o is MulticastDelegate[], false);
            Eval(0551, o is IEmpty, false);
            Eval(0552, o is IEmpty[], false);
            Eval(0553, o is INotEmpty, false);
            Eval(0554, o is INotEmpty[], false);
            Eval(0555, o is IEmptyGen<int>, false);
            Eval(0556, o is IEmptyGen<int>[], false);
            Eval(0557, o is INotEmptyGen<int>, false);
            Eval(0558, o is INotEmptyGen<int>[], false);
            Eval(0559, o is SimpleDelegate, false);
            Eval(0560, o is SimpleDelegate[], false);
            Eval(0561, o is GenericDelegate<int>, false);
            Eval(0562, o is GenericDelegate<int>[], false);
            Eval(0563, o is EmptyClass, false);
            Eval(0564, o is EmptyClass[], false);
            Eval(0565, o is NotEmptyClass, false);
            Eval(0566, o is NotEmptyClass[], false);
            Eval(0567, o is EmptyClassGen<int>, false);
            Eval(0568, o is EmptyClassGen<int>[], false);
            Eval(0569, o is NotEmptyClassGen<Guid>, false);
            Eval(0570, o is NotEmptyClassGen<Guid>[], false);
            Eval(0571, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(0572, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(0573, o is NestedClass, false);
            Eval(0574, o is NestedClass[], false);
            Eval(0575, o is NestedClassGen<Decimal>, false);
            Eval(0576, o is NestedClassGen<Decimal>[], false);
            Eval(0577, o is ImplementOneInterfaceC, false);
            Eval(0578, o is ImplementOneInterfaceC[], false);
            Eval(0579, o is ImplementTwoInterfaceC, false);
            Eval(0580, o is ImplementTwoInterfaceC[], false);
            Eval(0581, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(0582, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(0583, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(0584, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(0585, o is ImplementAllInterfaceC<int>, false);
            Eval(0586, o is ImplementAllInterfaceC<int>[], false);
            Eval(0587, o is SealedClass, false);
            Eval(0588, o is SealedClass[], false);
        }
    }  // end of test case 0001
    private static void TestCase0002()
    {
        {
            NotEmptyStruct v = default(NotEmptyStruct);
            ValueType o = v;
            Eval(0589, o is EmptyStruct, false);
            Eval(0590, o is EmptyStruct[], false);
            Eval(0591, o is EmptyStruct?, false);
            Eval(0592, o is EmptyStruct?[], false);
            Eval(0593, o is NotEmptyStruct, true);
            Eval(0594, o is NotEmptyStruct[], false);
            Eval(0595, o is NotEmptyStruct?, true);
            Eval(0596, o is NotEmptyStruct?[], false);
            Eval(0597, o is EmptyStructGen<int>, false);
            Eval(0598, o is EmptyStructGen<int>[], false);
            Eval(0599, o is EmptyStructGen<int>?, false);
            Eval(0600, o is EmptyStructGen<int>?[], false);
            Eval(0601, o is NotEmptyStructGen<Guid>, false);
            Eval(0602, o is NotEmptyStructGen<Guid>[], false);
            Eval(0603, o is NotEmptyStructGen<Guid>?, false);
            Eval(0604, o is NotEmptyStructGen<Guid>?[], false);
            Eval(0605, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(0606, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(0607, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(0608, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(0609, o is NestedStruct, false);
            Eval(0610, o is NestedStruct[], false);
            Eval(0611, o is NestedStruct?, false);
            Eval(0612, o is NestedStruct?[], false);
            Eval(0613, o is NestedStructGen<Decimal>, false);
            Eval(0614, o is NestedStructGen<Decimal>[], false);
            Eval(0615, o is NestedStructGen<Decimal>?, false);
            Eval(0616, o is NestedStructGen<Decimal>?[], false);
            Eval(0617, o is ExplicitFieldOffsetStruct, false);
            Eval(0618, o is ExplicitFieldOffsetStruct[], false);
            Eval(0619, o is ExplicitFieldOffsetStruct?, false);
            Eval(0620, o is ExplicitFieldOffsetStruct?[], false);
            Eval(0629, o is MarshalAsStruct, false);
            Eval(0630, o is MarshalAsStruct[], false);
            Eval(0631, o is MarshalAsStruct?, false);
            Eval(0632, o is MarshalAsStruct?[], false);
            Eval(0633, o is ImplementOneInterface, false);
            Eval(0634, o is ImplementOneInterface[], false);
            Eval(0635, o is ImplementOneInterface?, false);
            Eval(0636, o is ImplementOneInterface?[], false);
            Eval(0637, o is ImplementTwoInterface, false);
            Eval(0638, o is ImplementTwoInterface[], false);
            Eval(0639, o is ImplementTwoInterface?, false);
            Eval(0640, o is ImplementTwoInterface?[], false);
            Eval(0641, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(0642, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(0643, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(0644, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(0645, o is ImplementTwoInterfaceGen<int>, false);
            Eval(0646, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(0647, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(0648, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(0649, o is ImplementAllInterface<int>, false);
            Eval(0650, o is ImplementAllInterface<int>[], false);
            Eval(0651, o is ImplementAllInterface<int>?, false);
            Eval(0652, o is ImplementAllInterface<int>?[], false);
            Eval(0653, o is IntE, false);
            Eval(0654, o is IntE[], false);
            Eval(0655, o is IntE?, false);
            Eval(0656, o is IntE?[], false);
            Eval(0657, o is ByteE, false);
            Eval(0658, o is ByteE[], false);
            Eval(0659, o is ByteE?, false);
            Eval(0660, o is ByteE?[], false);
            Eval(0661, o is LongE, false);
            Eval(0662, o is LongE[], false);
            Eval(0663, o is LongE?, false);
            Eval(0664, o is LongE?[], false);
            Eval(0665, o is char, false);
            Eval(0666, o is char[], false);
            Eval(0667, o is char?, false);
            Eval(0668, o is char?[], false);
            Eval(0669, o is bool, false);
            Eval(0670, o is bool[], false);
            Eval(0671, o is bool?, false);
            Eval(0672, o is bool?[], false);
            Eval(0673, o is byte, false);
            Eval(0674, o is byte[], false);
            Eval(0675, o is byte?, false);
            Eval(0676, o is byte?[], false);
            Eval(0677, o is sbyte, false);
            Eval(0678, o is sbyte[], false);
            Eval(0679, o is sbyte?, false);
            Eval(0680, o is sbyte?[], false);
            Eval(0681, o is short, false);
            Eval(0682, o is short[], false);
            Eval(0683, o is short?, false);
            Eval(0684, o is short?[], false);
            Eval(0685, o is ushort, false);
            Eval(0686, o is ushort[], false);
            Eval(0687, o is ushort?, false);
            Eval(0688, o is ushort?[], false);
            Eval(0689, o is int, false);
            Eval(0690, o is int[], false);
            Eval(0691, o is int?, false);
            Eval(0692, o is int?[], false);
            Eval(0693, o is uint, false);
            Eval(0694, o is uint[], false);
            Eval(0695, o is uint?, false);
            Eval(0696, o is uint?[], false);
            Eval(0697, o is long, false);
            Eval(0698, o is long[], false);
            Eval(0699, o is long?, false);
            Eval(0700, o is long?[], false);
            Eval(0701, o is ulong, false);
            Eval(0702, o is ulong[], false);
            Eval(0703, o is ulong?, false);
            Eval(0704, o is ulong?[], false);
            Eval(0705, o is float, false);
            Eval(0706, o is float[], false);
            Eval(0707, o is float?, false);
            Eval(0708, o is float?[], false);
            Eval(0709, o is double, false);
            Eval(0710, o is double[], false);
            Eval(0711, o is double?, false);
            Eval(0712, o is double?[], false);
            Eval(0713, o is decimal, false);
            Eval(0714, o is decimal[], false);
            Eval(0715, o is decimal?, false);
            Eval(0716, o is decimal?[], false);
            Eval(0717, o is IntPtr, false);
            Eval(0718, o is IntPtr[], false);
            Eval(0719, o is IntPtr?, false);
            Eval(0720, o is IntPtr?[], false);
            Eval(0721, o is UIntPtr, false);
            Eval(0722, o is UIntPtr[], false);
            Eval(0723, o is UIntPtr?, false);
            Eval(0724, o is UIntPtr?[], false);
            Eval(0725, o is Guid, false);
            Eval(0726, o is Guid[], false);
            Eval(0727, o is Guid?, false);
            Eval(0728, o is Guid?[], false);
            Eval(0729, o is GCHandle, false);
            Eval(0730, o is GCHandle[], false);
            Eval(0731, o is GCHandle?, false);
            Eval(0732, o is GCHandle?[], false);
            Eval(0733, o is object, true);
            Eval(0734, o is object[], false);
            Eval(0735, o is string, false);
            Eval(0736, o is string[], false);
            Eval(0737, o is ValueType, true);
            Eval(0738, o is ValueType[], false);
            Eval(0739, o is Array, false);
            Eval(0740, o is Array[], false);
            Eval(0741, o is Enum, false);
            Eval(0742, o is Enum[], false);
            Eval(0743, o is Delegate, false);
            Eval(0744, o is Delegate[], false);
            Eval(0745, o is MulticastDelegate, false);
            Eval(0746, o is MulticastDelegate[], false);
            Eval(0747, o is IEmpty, false);
            Eval(0748, o is IEmpty[], false);
            Eval(0749, o is INotEmpty, false);
            Eval(0750, o is INotEmpty[], false);
            Eval(0751, o is IEmptyGen<int>, false);
            Eval(0752, o is IEmptyGen<int>[], false);
            Eval(0753, o is INotEmptyGen<int>, false);
            Eval(0754, o is INotEmptyGen<int>[], false);
            Eval(0755, o is SimpleDelegate, false);
            Eval(0756, o is SimpleDelegate[], false);
            Eval(0757, o is GenericDelegate<int>, false);
            Eval(0758, o is GenericDelegate<int>[], false);
            Eval(0759, o is EmptyClass, false);
            Eval(0760, o is EmptyClass[], false);
            Eval(0761, o is NotEmptyClass, false);
            Eval(0762, o is NotEmptyClass[], false);
            Eval(0763, o is EmptyClassGen<int>, false);
            Eval(0764, o is EmptyClassGen<int>[], false);
            Eval(0765, o is NotEmptyClassGen<Guid>, false);
            Eval(0766, o is NotEmptyClassGen<Guid>[], false);
            Eval(0767, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(0768, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(0769, o is NestedClass, false);
            Eval(0770, o is NestedClass[], false);
            Eval(0771, o is NestedClassGen<Decimal>, false);
            Eval(0772, o is NestedClassGen<Decimal>[], false);
            Eval(0773, o is ImplementOneInterfaceC, false);
            Eval(0774, o is ImplementOneInterfaceC[], false);
            Eval(0775, o is ImplementTwoInterfaceC, false);
            Eval(0776, o is ImplementTwoInterfaceC[], false);
            Eval(0777, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(0778, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(0779, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(0780, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(0781, o is ImplementAllInterfaceC<int>, false);
            Eval(0782, o is ImplementAllInterfaceC<int>[], false);
            Eval(0783, o is SealedClass, false);
            Eval(0784, o is SealedClass[], false);
        }
        {
            NotEmptyStruct? v = default(NotEmptyStruct);
            ValueType o = v;
            Eval(0785, o is EmptyStruct, false);
            Eval(0786, o is EmptyStruct[], false);
            Eval(0787, o is EmptyStruct?, false);
            Eval(0788, o is EmptyStruct?[], false);
            Eval(0789, o is NotEmptyStruct, true);
            Eval(0790, o is NotEmptyStruct[], false);
            Eval(0791, o is NotEmptyStruct?, true);
            Eval(0792, o is NotEmptyStruct?[], false);
            Eval(0793, o is EmptyStructGen<int>, false);
            Eval(0794, o is EmptyStructGen<int>[], false);
            Eval(0795, o is EmptyStructGen<int>?, false);
            Eval(0796, o is EmptyStructGen<int>?[], false);
            Eval(0797, o is NotEmptyStructGen<Guid>, false);
            Eval(0798, o is NotEmptyStructGen<Guid>[], false);
            Eval(0799, o is NotEmptyStructGen<Guid>?, false);
            Eval(0800, o is NotEmptyStructGen<Guid>?[], false);
            Eval(0801, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(0802, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(0803, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(0804, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(0805, o is NestedStruct, false);
            Eval(0806, o is NestedStruct[], false);
            Eval(0807, o is NestedStruct?, false);
            Eval(0808, o is NestedStruct?[], false);
            Eval(0809, o is NestedStructGen<Decimal>, false);
            Eval(0810, o is NestedStructGen<Decimal>[], false);
            Eval(0811, o is NestedStructGen<Decimal>?, false);
            Eval(0812, o is NestedStructGen<Decimal>?[], false);
            Eval(0813, o is ExplicitFieldOffsetStruct, false);
            Eval(0814, o is ExplicitFieldOffsetStruct[], false);
            Eval(0815, o is ExplicitFieldOffsetStruct?, false);
            Eval(0816, o is ExplicitFieldOffsetStruct?[], false);
            Eval(0825, o is MarshalAsStruct, false);
            Eval(0826, o is MarshalAsStruct[], false);
            Eval(0827, o is MarshalAsStruct?, false);
            Eval(0828, o is MarshalAsStruct?[], false);
            Eval(0829, o is ImplementOneInterface, false);
            Eval(0830, o is ImplementOneInterface[], false);
            Eval(0831, o is ImplementOneInterface?, false);
            Eval(0832, o is ImplementOneInterface?[], false);
            Eval(0833, o is ImplementTwoInterface, false);
            Eval(0834, o is ImplementTwoInterface[], false);
            Eval(0835, o is ImplementTwoInterface?, false);
            Eval(0836, o is ImplementTwoInterface?[], false);
            Eval(0837, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(0838, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(0839, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(0840, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(0841, o is ImplementTwoInterfaceGen<int>, false);
            Eval(0842, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(0843, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(0844, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(0845, o is ImplementAllInterface<int>, false);
            Eval(0846, o is ImplementAllInterface<int>[], false);
            Eval(0847, o is ImplementAllInterface<int>?, false);
            Eval(0848, o is ImplementAllInterface<int>?[], false);
            Eval(0849, o is IntE, false);
            Eval(0850, o is IntE[], false);
            Eval(0851, o is IntE?, false);
            Eval(0852, o is IntE?[], false);
            Eval(0853, o is ByteE, false);
            Eval(0854, o is ByteE[], false);
            Eval(0855, o is ByteE?, false);
            Eval(0856, o is ByteE?[], false);
            Eval(0857, o is LongE, false);
            Eval(0858, o is LongE[], false);
            Eval(0859, o is LongE?, false);
            Eval(0860, o is LongE?[], false);
            Eval(0861, o is char, false);
            Eval(0862, o is char[], false);
            Eval(0863, o is char?, false);
            Eval(0864, o is char?[], false);
            Eval(0865, o is bool, false);
            Eval(0866, o is bool[], false);
            Eval(0867, o is bool?, false);
            Eval(0868, o is bool?[], false);
            Eval(0869, o is byte, false);
            Eval(0870, o is byte[], false);
            Eval(0871, o is byte?, false);
            Eval(0872, o is byte?[], false);
            Eval(0873, o is sbyte, false);
            Eval(0874, o is sbyte[], false);
            Eval(0875, o is sbyte?, false);
            Eval(0876, o is sbyte?[], false);
            Eval(0877, o is short, false);
            Eval(0878, o is short[], false);
            Eval(0879, o is short?, false);
            Eval(0880, o is short?[], false);
            Eval(0881, o is ushort, false);
            Eval(0882, o is ushort[], false);
            Eval(0883, o is ushort?, false);
            Eval(0884, o is ushort?[], false);
            Eval(0885, o is int, false);
            Eval(0886, o is int[], false);
            Eval(0887, o is int?, false);
            Eval(0888, o is int?[], false);
            Eval(0889, o is uint, false);
            Eval(0890, o is uint[], false);
            Eval(0891, o is uint?, false);
            Eval(0892, o is uint?[], false);
            Eval(0893, o is long, false);
            Eval(0894, o is long[], false);
            Eval(0895, o is long?, false);
            Eval(0896, o is long?[], false);
            Eval(0897, o is ulong, false);
            Eval(0898, o is ulong[], false);
            Eval(0899, o is ulong?, false);
            Eval(0900, o is ulong?[], false);
            Eval(0901, o is float, false);
            Eval(0902, o is float[], false);
            Eval(0903, o is float?, false);
            Eval(0904, o is float?[], false);
            Eval(0905, o is double, false);
            Eval(0906, o is double[], false);
            Eval(0907, o is double?, false);
            Eval(0908, o is double?[], false);
            Eval(0909, o is decimal, false);
            Eval(0910, o is decimal[], false);
            Eval(0911, o is decimal?, false);
            Eval(0912, o is decimal?[], false);
            Eval(0913, o is IntPtr, false);
            Eval(0914, o is IntPtr[], false);
            Eval(0915, o is IntPtr?, false);
            Eval(0916, o is IntPtr?[], false);
            Eval(0917, o is UIntPtr, false);
            Eval(0918, o is UIntPtr[], false);
            Eval(0919, o is UIntPtr?, false);
            Eval(0920, o is UIntPtr?[], false);
            Eval(0921, o is Guid, false);
            Eval(0922, o is Guid[], false);
            Eval(0923, o is Guid?, false);
            Eval(0924, o is Guid?[], false);
            Eval(0925, o is GCHandle, false);
            Eval(0926, o is GCHandle[], false);
            Eval(0927, o is GCHandle?, false);
            Eval(0928, o is GCHandle?[], false);
            Eval(0929, o is object, true);
            Eval(0930, o is object[], false);
            Eval(0931, o is string, false);
            Eval(0932, o is string[], false);
            Eval(0933, o is ValueType, true);
            Eval(0934, o is ValueType[], false);
            Eval(0935, o is Array, false);
            Eval(0936, o is Array[], false);
            Eval(0937, o is Enum, false);
            Eval(0938, o is Enum[], false);
            Eval(0939, o is Delegate, false);
            Eval(0940, o is Delegate[], false);
            Eval(0941, o is MulticastDelegate, false);
            Eval(0942, o is MulticastDelegate[], false);
            Eval(0943, o is IEmpty, false);
            Eval(0944, o is IEmpty[], false);
            Eval(0945, o is INotEmpty, false);
            Eval(0946, o is INotEmpty[], false);
            Eval(0947, o is IEmptyGen<int>, false);
            Eval(0948, o is IEmptyGen<int>[], false);
            Eval(0949, o is INotEmptyGen<int>, false);
            Eval(0950, o is INotEmptyGen<int>[], false);
            Eval(0951, o is SimpleDelegate, false);
            Eval(0952, o is SimpleDelegate[], false);
            Eval(0953, o is GenericDelegate<int>, false);
            Eval(0954, o is GenericDelegate<int>[], false);
            Eval(0955, o is EmptyClass, false);
            Eval(0956, o is EmptyClass[], false);
            Eval(0957, o is NotEmptyClass, false);
            Eval(0958, o is NotEmptyClass[], false);
            Eval(0959, o is EmptyClassGen<int>, false);
            Eval(0960, o is EmptyClassGen<int>[], false);
            Eval(0961, o is NotEmptyClassGen<Guid>, false);
            Eval(0962, o is NotEmptyClassGen<Guid>[], false);
            Eval(0963, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(0964, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(0965, o is NestedClass, false);
            Eval(0966, o is NestedClass[], false);
            Eval(0967, o is NestedClassGen<Decimal>, false);
            Eval(0968, o is NestedClassGen<Decimal>[], false);
            Eval(0969, o is ImplementOneInterfaceC, false);
            Eval(0970, o is ImplementOneInterfaceC[], false);
            Eval(0971, o is ImplementTwoInterfaceC, false);
            Eval(0972, o is ImplementTwoInterfaceC[], false);
            Eval(0973, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(0974, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(0975, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(0976, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(0977, o is ImplementAllInterfaceC<int>, false);
            Eval(0978, o is ImplementAllInterfaceC<int>[], false);
            Eval(0979, o is SealedClass, false);
            Eval(0980, o is SealedClass[], false);
        }
        {
            NotEmptyStruct? v = default(NotEmptyStruct?);
            ValueType o = v;
            Eval(0981, o is EmptyStruct, false);
            Eval(0982, o is EmptyStruct[], false);
            Eval(0983, o is EmptyStruct?, false);
            Eval(0984, o is EmptyStruct?[], false);
            Eval(0985, o is NotEmptyStruct, false);
            Eval(0986, o is NotEmptyStruct[], false);
            Eval(0987, o is NotEmptyStruct?, false);
            Eval(0988, o is NotEmptyStruct?[], false);
            Eval(0989, o is EmptyStructGen<int>, false);
            Eval(0990, o is EmptyStructGen<int>[], false);
            Eval(0991, o is EmptyStructGen<int>?, false);
            Eval(0992, o is EmptyStructGen<int>?[], false);
            Eval(0993, o is NotEmptyStructGen<Guid>, false);
            Eval(0994, o is NotEmptyStructGen<Guid>[], false);
            Eval(0995, o is NotEmptyStructGen<Guid>?, false);
            Eval(0996, o is NotEmptyStructGen<Guid>?[], false);
            Eval(0997, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(0998, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(0999, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(1000, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(1001, o is NestedStruct, false);
            Eval(1002, o is NestedStruct[], false);
            Eval(1003, o is NestedStruct?, false);
            Eval(1004, o is NestedStruct?[], false);
            Eval(1005, o is NestedStructGen<Decimal>, false);
            Eval(1006, o is NestedStructGen<Decimal>[], false);
            Eval(1007, o is NestedStructGen<Decimal>?, false);
            Eval(1008, o is NestedStructGen<Decimal>?[], false);
            Eval(1009, o is ExplicitFieldOffsetStruct, false);
            Eval(1010, o is ExplicitFieldOffsetStruct[], false);
            Eval(1011, o is ExplicitFieldOffsetStruct?, false);
            Eval(1012, o is ExplicitFieldOffsetStruct?[], false);
            Eval(1021, o is MarshalAsStruct, false);
            Eval(1022, o is MarshalAsStruct[], false);
            Eval(1023, o is MarshalAsStruct?, false);
            Eval(1024, o is MarshalAsStruct?[], false);
            Eval(1025, o is ImplementOneInterface, false);
            Eval(1026, o is ImplementOneInterface[], false);
            Eval(1027, o is ImplementOneInterface?, false);
            Eval(1028, o is ImplementOneInterface?[], false);
            Eval(1029, o is ImplementTwoInterface, false);
            Eval(1030, o is ImplementTwoInterface[], false);
            Eval(1031, o is ImplementTwoInterface?, false);
            Eval(1032, o is ImplementTwoInterface?[], false);
            Eval(1033, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(1034, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(1035, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(1036, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(1037, o is ImplementTwoInterfaceGen<int>, false);
            Eval(1038, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(1039, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(1040, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(1041, o is ImplementAllInterface<int>, false);
            Eval(1042, o is ImplementAllInterface<int>[], false);
            Eval(1043, o is ImplementAllInterface<int>?, false);
            Eval(1044, o is ImplementAllInterface<int>?[], false);
            Eval(1045, o is IntE, false);
            Eval(1046, o is IntE[], false);
            Eval(1047, o is IntE?, false);
            Eval(1048, o is IntE?[], false);
            Eval(1049, o is ByteE, false);
            Eval(1050, o is ByteE[], false);
            Eval(1051, o is ByteE?, false);
            Eval(1052, o is ByteE?[], false);
            Eval(1053, o is LongE, false);
            Eval(1054, o is LongE[], false);
            Eval(1055, o is LongE?, false);
            Eval(1056, o is LongE?[], false);
            Eval(1057, o is char, false);
            Eval(1058, o is char[], false);
            Eval(1059, o is char?, false);
            Eval(1060, o is char?[], false);
            Eval(1061, o is bool, false);
            Eval(1062, o is bool[], false);
            Eval(1063, o is bool?, false);
            Eval(1064, o is bool?[], false);
            Eval(1065, o is byte, false);
            Eval(1066, o is byte[], false);
            Eval(1067, o is byte?, false);
            Eval(1068, o is byte?[], false);
            Eval(1069, o is sbyte, false);
            Eval(1070, o is sbyte[], false);
            Eval(1071, o is sbyte?, false);
            Eval(1072, o is sbyte?[], false);
            Eval(1073, o is short, false);
            Eval(1074, o is short[], false);
            Eval(1075, o is short?, false);
            Eval(1076, o is short?[], false);
            Eval(1077, o is ushort, false);
            Eval(1078, o is ushort[], false);
            Eval(1079, o is ushort?, false);
            Eval(1080, o is ushort?[], false);
            Eval(1081, o is int, false);
            Eval(1082, o is int[], false);
            Eval(1083, o is int?, false);
            Eval(1084, o is int?[], false);
            Eval(1085, o is uint, false);
            Eval(1086, o is uint[], false);
            Eval(1087, o is uint?, false);
            Eval(1088, o is uint?[], false);
            Eval(1089, o is long, false);
            Eval(1090, o is long[], false);
            Eval(1091, o is long?, false);
            Eval(1092, o is long?[], false);
            Eval(1093, o is ulong, false);
            Eval(1094, o is ulong[], false);
            Eval(1095, o is ulong?, false);
            Eval(1096, o is ulong?[], false);
            Eval(1097, o is float, false);
            Eval(1098, o is float[], false);
            Eval(1099, o is float?, false);
            Eval(1100, o is float?[], false);
            Eval(1101, o is double, false);
            Eval(1102, o is double[], false);
            Eval(1103, o is double?, false);
            Eval(1104, o is double?[], false);
            Eval(1105, o is decimal, false);
            Eval(1106, o is decimal[], false);
            Eval(1107, o is decimal?, false);
            Eval(1108, o is decimal?[], false);
            Eval(1109, o is IntPtr, false);
            Eval(1110, o is IntPtr[], false);
            Eval(1111, o is IntPtr?, false);
            Eval(1112, o is IntPtr?[], false);
            Eval(1113, o is UIntPtr, false);
            Eval(1114, o is UIntPtr[], false);
            Eval(1115, o is UIntPtr?, false);
            Eval(1116, o is UIntPtr?[], false);
            Eval(1117, o is Guid, false);
            Eval(1118, o is Guid[], false);
            Eval(1119, o is Guid?, false);
            Eval(1120, o is Guid?[], false);
            Eval(1121, o is GCHandle, false);
            Eval(1122, o is GCHandle[], false);
            Eval(1123, o is GCHandle?, false);
            Eval(1124, o is GCHandle?[], false);
            Eval(1125, o is object, false);
            Eval(1126, o is object[], false);
            Eval(1127, o is string, false);
            Eval(1128, o is string[], false);
            Eval(1129, o is ValueType, false);
            Eval(1130, o is ValueType[], false);
            Eval(1131, o is Array, false);
            Eval(1132, o is Array[], false);
            Eval(1133, o is Enum, false);
            Eval(1134, o is Enum[], false);
            Eval(1135, o is Delegate, false);
            Eval(1136, o is Delegate[], false);
            Eval(1137, o is MulticastDelegate, false);
            Eval(1138, o is MulticastDelegate[], false);
            Eval(1139, o is IEmpty, false);
            Eval(1140, o is IEmpty[], false);
            Eval(1141, o is INotEmpty, false);
            Eval(1142, o is INotEmpty[], false);
            Eval(1143, o is IEmptyGen<int>, false);
            Eval(1144, o is IEmptyGen<int>[], false);
            Eval(1145, o is INotEmptyGen<int>, false);
            Eval(1146, o is INotEmptyGen<int>[], false);
            Eval(1147, o is SimpleDelegate, false);
            Eval(1148, o is SimpleDelegate[], false);
            Eval(1149, o is GenericDelegate<int>, false);
            Eval(1150, o is GenericDelegate<int>[], false);
            Eval(1151, o is EmptyClass, false);
            Eval(1152, o is EmptyClass[], false);
            Eval(1153, o is NotEmptyClass, false);
            Eval(1154, o is NotEmptyClass[], false);
            Eval(1155, o is EmptyClassGen<int>, false);
            Eval(1156, o is EmptyClassGen<int>[], false);
            Eval(1157, o is NotEmptyClassGen<Guid>, false);
            Eval(1158, o is NotEmptyClassGen<Guid>[], false);
            Eval(1159, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(1160, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(1161, o is NestedClass, false);
            Eval(1162, o is NestedClass[], false);
            Eval(1163, o is NestedClassGen<Decimal>, false);
            Eval(1164, o is NestedClassGen<Decimal>[], false);
            Eval(1165, o is ImplementOneInterfaceC, false);
            Eval(1166, o is ImplementOneInterfaceC[], false);
            Eval(1167, o is ImplementTwoInterfaceC, false);
            Eval(1168, o is ImplementTwoInterfaceC[], false);
            Eval(1169, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(1170, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(1171, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(1172, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(1173, o is ImplementAllInterfaceC<int>, false);
            Eval(1174, o is ImplementAllInterfaceC<int>[], false);
            Eval(1175, o is SealedClass, false);
            Eval(1176, o is SealedClass[], false);
        }
    }  // end of test case 0002
    private static void TestCase0003()
    {
        {
            EmptyStructGen<int> v = default(EmptyStructGen<int>);
            ValueType o = v;
            Eval(1177, o is EmptyStruct, false);
            Eval(1178, o is EmptyStruct[], false);
            Eval(1179, o is EmptyStruct?, false);
            Eval(1180, o is EmptyStruct?[], false);
            Eval(1181, o is NotEmptyStruct, false);
            Eval(1182, o is NotEmptyStruct[], false);
            Eval(1183, o is NotEmptyStruct?, false);
            Eval(1184, o is NotEmptyStruct?[], false);
            Eval(1185, o is EmptyStructGen<int>, true);
            Eval(1186, o is EmptyStructGen<int>[], false);
            Eval(1187, o is EmptyStructGen<int>?, true);
            Eval(1188, o is EmptyStructGen<int>?[], false);
            Eval(1189, o is NotEmptyStructGen<Guid>, false);
            Eval(1190, o is NotEmptyStructGen<Guid>[], false);
            Eval(1191, o is NotEmptyStructGen<Guid>?, false);
            Eval(1192, o is NotEmptyStructGen<Guid>?[], false);
            Eval(1193, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(1194, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(1195, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(1196, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(1197, o is NestedStruct, false);
            Eval(1198, o is NestedStruct[], false);
            Eval(1199, o is NestedStruct?, false);
            Eval(1200, o is NestedStruct?[], false);
            Eval(1201, o is NestedStructGen<Decimal>, false);
            Eval(1202, o is NestedStructGen<Decimal>[], false);
            Eval(1203, o is NestedStructGen<Decimal>?, false);
            Eval(1204, o is NestedStructGen<Decimal>?[], false);
            Eval(1205, o is ExplicitFieldOffsetStruct, false);
            Eval(1206, o is ExplicitFieldOffsetStruct[], false);
            Eval(1207, o is ExplicitFieldOffsetStruct?, false);
            Eval(1208, o is ExplicitFieldOffsetStruct?[], false);
            Eval(1217, o is MarshalAsStruct, false);
            Eval(1218, o is MarshalAsStruct[], false);
            Eval(1219, o is MarshalAsStruct?, false);
            Eval(1220, o is MarshalAsStruct?[], false);
            Eval(1221, o is ImplementOneInterface, false);
            Eval(1222, o is ImplementOneInterface[], false);
            Eval(1223, o is ImplementOneInterface?, false);
            Eval(1224, o is ImplementOneInterface?[], false);
            Eval(1225, o is ImplementTwoInterface, false);
            Eval(1226, o is ImplementTwoInterface[], false);
            Eval(1227, o is ImplementTwoInterface?, false);
            Eval(1228, o is ImplementTwoInterface?[], false);
            Eval(1229, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(1230, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(1231, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(1232, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(1233, o is ImplementTwoInterfaceGen<int>, false);
            Eval(1234, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(1235, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(1236, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(1237, o is ImplementAllInterface<int>, false);
            Eval(1238, o is ImplementAllInterface<int>[], false);
            Eval(1239, o is ImplementAllInterface<int>?, false);
            Eval(1240, o is ImplementAllInterface<int>?[], false);
            Eval(1241, o is IntE, false);
            Eval(1242, o is IntE[], false);
            Eval(1243, o is IntE?, false);
            Eval(1244, o is IntE?[], false);
            Eval(1245, o is ByteE, false);
            Eval(1246, o is ByteE[], false);
            Eval(1247, o is ByteE?, false);
            Eval(1248, o is ByteE?[], false);
            Eval(1249, o is LongE, false);
            Eval(1250, o is LongE[], false);
            Eval(1251, o is LongE?, false);
            Eval(1252, o is LongE?[], false);
            Eval(1253, o is char, false);
            Eval(1254, o is char[], false);
            Eval(1255, o is char?, false);
            Eval(1256, o is char?[], false);
            Eval(1257, o is bool, false);
            Eval(1258, o is bool[], false);
            Eval(1259, o is bool?, false);
            Eval(1260, o is bool?[], false);
            Eval(1261, o is byte, false);
            Eval(1262, o is byte[], false);
            Eval(1263, o is byte?, false);
            Eval(1264, o is byte?[], false);
            Eval(1265, o is sbyte, false);
            Eval(1266, o is sbyte[], false);
            Eval(1267, o is sbyte?, false);
            Eval(1268, o is sbyte?[], false);
            Eval(1269, o is short, false);
            Eval(1270, o is short[], false);
            Eval(1271, o is short?, false);
            Eval(1272, o is short?[], false);
            Eval(1273, o is ushort, false);
            Eval(1274, o is ushort[], false);
            Eval(1275, o is ushort?, false);
            Eval(1276, o is ushort?[], false);
            Eval(1277, o is int, false);
            Eval(1278, o is int[], false);
            Eval(1279, o is int?, false);
            Eval(1280, o is int?[], false);
            Eval(1281, o is uint, false);
            Eval(1282, o is uint[], false);
            Eval(1283, o is uint?, false);
            Eval(1284, o is uint?[], false);
            Eval(1285, o is long, false);
            Eval(1286, o is long[], false);
            Eval(1287, o is long?, false);
            Eval(1288, o is long?[], false);
            Eval(1289, o is ulong, false);
            Eval(1290, o is ulong[], false);
            Eval(1291, o is ulong?, false);
            Eval(1292, o is ulong?[], false);
            Eval(1293, o is float, false);
            Eval(1294, o is float[], false);
            Eval(1295, o is float?, false);
            Eval(1296, o is float?[], false);
            Eval(1297, o is double, false);
            Eval(1298, o is double[], false);
            Eval(1299, o is double?, false);
            Eval(1300, o is double?[], false);
            Eval(1301, o is decimal, false);
            Eval(1302, o is decimal[], false);
            Eval(1303, o is decimal?, false);
            Eval(1304, o is decimal?[], false);
            Eval(1305, o is IntPtr, false);
            Eval(1306, o is IntPtr[], false);
            Eval(1307, o is IntPtr?, false);
            Eval(1308, o is IntPtr?[], false);
            Eval(1309, o is UIntPtr, false);
            Eval(1310, o is UIntPtr[], false);
            Eval(1311, o is UIntPtr?, false);
            Eval(1312, o is UIntPtr?[], false);
            Eval(1313, o is Guid, false);
            Eval(1314, o is Guid[], false);
            Eval(1315, o is Guid?, false);
            Eval(1316, o is Guid?[], false);
            Eval(1317, o is GCHandle, false);
            Eval(1318, o is GCHandle[], false);
            Eval(1319, o is GCHandle?, false);
            Eval(1320, o is GCHandle?[], false);
            Eval(1321, o is object, true);
            Eval(1322, o is object[], false);
            Eval(1323, o is string, false);
            Eval(1324, o is string[], false);
            Eval(1325, o is ValueType, true);
            Eval(1326, o is ValueType[], false);
            Eval(1327, o is Array, false);
            Eval(1328, o is Array[], false);
            Eval(1329, o is Enum, false);
            Eval(1330, o is Enum[], false);
            Eval(1331, o is Delegate, false);
            Eval(1332, o is Delegate[], false);
            Eval(1333, o is MulticastDelegate, false);
            Eval(1334, o is MulticastDelegate[], false);
            Eval(1335, o is IEmpty, false);
            Eval(1336, o is IEmpty[], false);
            Eval(1337, o is INotEmpty, false);
            Eval(1338, o is INotEmpty[], false);
            Eval(1339, o is IEmptyGen<int>, false);
            Eval(1340, o is IEmptyGen<int>[], false);
            Eval(1341, o is INotEmptyGen<int>, false);
            Eval(1342, o is INotEmptyGen<int>[], false);
            Eval(1343, o is SimpleDelegate, false);
            Eval(1344, o is SimpleDelegate[], false);
            Eval(1345, o is GenericDelegate<int>, false);
            Eval(1346, o is GenericDelegate<int>[], false);
            Eval(1347, o is EmptyClass, false);
            Eval(1348, o is EmptyClass[], false);
            Eval(1349, o is NotEmptyClass, false);
            Eval(1350, o is NotEmptyClass[], false);
            Eval(1351, o is EmptyClassGen<int>, false);
            Eval(1352, o is EmptyClassGen<int>[], false);
            Eval(1353, o is NotEmptyClassGen<Guid>, false);
            Eval(1354, o is NotEmptyClassGen<Guid>[], false);
            Eval(1355, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(1356, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(1357, o is NestedClass, false);
            Eval(1358, o is NestedClass[], false);
            Eval(1359, o is NestedClassGen<Decimal>, false);
            Eval(1360, o is NestedClassGen<Decimal>[], false);
            Eval(1361, o is ImplementOneInterfaceC, false);
            Eval(1362, o is ImplementOneInterfaceC[], false);
            Eval(1363, o is ImplementTwoInterfaceC, false);
            Eval(1364, o is ImplementTwoInterfaceC[], false);
            Eval(1365, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(1366, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(1367, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(1368, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(1369, o is ImplementAllInterfaceC<int>, false);
            Eval(1370, o is ImplementAllInterfaceC<int>[], false);
            Eval(1371, o is SealedClass, false);
            Eval(1372, o is SealedClass[], false);
        }
        {
            EmptyStructGen<int>? v = default(EmptyStructGen<int>);
            ValueType o = v;
            Eval(1373, o is EmptyStruct, false);
            Eval(1374, o is EmptyStruct[], false);
            Eval(1375, o is EmptyStruct?, false);
            Eval(1376, o is EmptyStruct?[], false);
            Eval(1377, o is NotEmptyStruct, false);
            Eval(1378, o is NotEmptyStruct[], false);
            Eval(1379, o is NotEmptyStruct?, false);
            Eval(1380, o is NotEmptyStruct?[], false);
            Eval(1381, o is EmptyStructGen<int>, true);
            Eval(1382, o is EmptyStructGen<int>[], false);
            Eval(1383, o is EmptyStructGen<int>?, true);
            Eval(1384, o is EmptyStructGen<int>?[], false);
            Eval(1385, o is NotEmptyStructGen<Guid>, false);
            Eval(1386, o is NotEmptyStructGen<Guid>[], false);
            Eval(1387, o is NotEmptyStructGen<Guid>?, false);
            Eval(1388, o is NotEmptyStructGen<Guid>?[], false);
            Eval(1389, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(1390, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(1391, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(1392, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(1393, o is NestedStruct, false);
            Eval(1394, o is NestedStruct[], false);
            Eval(1395, o is NestedStruct?, false);
            Eval(1396, o is NestedStruct?[], false);
            Eval(1397, o is NestedStructGen<Decimal>, false);
            Eval(1398, o is NestedStructGen<Decimal>[], false);
            Eval(1399, o is NestedStructGen<Decimal>?, false);
            Eval(1400, o is NestedStructGen<Decimal>?[], false);
            Eval(1401, o is ExplicitFieldOffsetStruct, false);
            Eval(1402, o is ExplicitFieldOffsetStruct[], false);
            Eval(1403, o is ExplicitFieldOffsetStruct?, false);
            Eval(1404, o is ExplicitFieldOffsetStruct?[], false);
            Eval(1413, o is MarshalAsStruct, false);
            Eval(1414, o is MarshalAsStruct[], false);
            Eval(1415, o is MarshalAsStruct?, false);
            Eval(1416, o is MarshalAsStruct?[], false);
            Eval(1417, o is ImplementOneInterface, false);
            Eval(1418, o is ImplementOneInterface[], false);
            Eval(1419, o is ImplementOneInterface?, false);
            Eval(1420, o is ImplementOneInterface?[], false);
            Eval(1421, o is ImplementTwoInterface, false);
            Eval(1422, o is ImplementTwoInterface[], false);
            Eval(1423, o is ImplementTwoInterface?, false);
            Eval(1424, o is ImplementTwoInterface?[], false);
            Eval(1425, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(1426, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(1427, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(1428, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(1429, o is ImplementTwoInterfaceGen<int>, false);
            Eval(1430, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(1431, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(1432, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(1433, o is ImplementAllInterface<int>, false);
            Eval(1434, o is ImplementAllInterface<int>[], false);
            Eval(1435, o is ImplementAllInterface<int>?, false);
            Eval(1436, o is ImplementAllInterface<int>?[], false);
            Eval(1437, o is IntE, false);
            Eval(1438, o is IntE[], false);
            Eval(1439, o is IntE?, false);
            Eval(1440, o is IntE?[], false);
            Eval(1441, o is ByteE, false);
            Eval(1442, o is ByteE[], false);
            Eval(1443, o is ByteE?, false);
            Eval(1444, o is ByteE?[], false);
            Eval(1445, o is LongE, false);
            Eval(1446, o is LongE[], false);
            Eval(1447, o is LongE?, false);
            Eval(1448, o is LongE?[], false);
            Eval(1449, o is char, false);
            Eval(1450, o is char[], false);
            Eval(1451, o is char?, false);
            Eval(1452, o is char?[], false);
            Eval(1453, o is bool, false);
            Eval(1454, o is bool[], false);
            Eval(1455, o is bool?, false);
            Eval(1456, o is bool?[], false);
            Eval(1457, o is byte, false);
            Eval(1458, o is byte[], false);
            Eval(1459, o is byte?, false);
            Eval(1460, o is byte?[], false);
            Eval(1461, o is sbyte, false);
            Eval(1462, o is sbyte[], false);
            Eval(1463, o is sbyte?, false);
            Eval(1464, o is sbyte?[], false);
            Eval(1465, o is short, false);
            Eval(1466, o is short[], false);
            Eval(1467, o is short?, false);
            Eval(1468, o is short?[], false);
            Eval(1469, o is ushort, false);
            Eval(1470, o is ushort[], false);
            Eval(1471, o is ushort?, false);
            Eval(1472, o is ushort?[], false);
            Eval(1473, o is int, false);
            Eval(1474, o is int[], false);
            Eval(1475, o is int?, false);
            Eval(1476, o is int?[], false);
            Eval(1477, o is uint, false);
            Eval(1478, o is uint[], false);
            Eval(1479, o is uint?, false);
            Eval(1480, o is uint?[], false);
            Eval(1481, o is long, false);
            Eval(1482, o is long[], false);
            Eval(1483, o is long?, false);
            Eval(1484, o is long?[], false);
            Eval(1485, o is ulong, false);
            Eval(1486, o is ulong[], false);
            Eval(1487, o is ulong?, false);
            Eval(1488, o is ulong?[], false);
            Eval(1489, o is float, false);
            Eval(1490, o is float[], false);
            Eval(1491, o is float?, false);
            Eval(1492, o is float?[], false);
            Eval(1493, o is double, false);
            Eval(1494, o is double[], false);
            Eval(1495, o is double?, false);
            Eval(1496, o is double?[], false);
            Eval(1497, o is decimal, false);
            Eval(1498, o is decimal[], false);
            Eval(1499, o is decimal?, false);
            Eval(1500, o is decimal?[], false);
            Eval(1501, o is IntPtr, false);
            Eval(1502, o is IntPtr[], false);
            Eval(1503, o is IntPtr?, false);
            Eval(1504, o is IntPtr?[], false);
            Eval(1505, o is UIntPtr, false);
            Eval(1506, o is UIntPtr[], false);
            Eval(1507, o is UIntPtr?, false);
            Eval(1508, o is UIntPtr?[], false);
            Eval(1509, o is Guid, false);
            Eval(1510, o is Guid[], false);
            Eval(1511, o is Guid?, false);
            Eval(1512, o is Guid?[], false);
            Eval(1513, o is GCHandle, false);
            Eval(1514, o is GCHandle[], false);
            Eval(1515, o is GCHandle?, false);
            Eval(1516, o is GCHandle?[], false);
            Eval(1517, o is object, true);
            Eval(1518, o is object[], false);
            Eval(1519, o is string, false);
            Eval(1520, o is string[], false);
            Eval(1521, o is ValueType, true);
            Eval(1522, o is ValueType[], false);
            Eval(1523, o is Array, false);
            Eval(1524, o is Array[], false);
            Eval(1525, o is Enum, false);
            Eval(1526, o is Enum[], false);
            Eval(1527, o is Delegate, false);
            Eval(1528, o is Delegate[], false);
            Eval(1529, o is MulticastDelegate, false);
            Eval(1530, o is MulticastDelegate[], false);
            Eval(1531, o is IEmpty, false);
            Eval(1532, o is IEmpty[], false);
            Eval(1533, o is INotEmpty, false);
            Eval(1534, o is INotEmpty[], false);
            Eval(1535, o is IEmptyGen<int>, false);
            Eval(1536, o is IEmptyGen<int>[], false);
            Eval(1537, o is INotEmptyGen<int>, false);
            Eval(1538, o is INotEmptyGen<int>[], false);
            Eval(1539, o is SimpleDelegate, false);
            Eval(1540, o is SimpleDelegate[], false);
            Eval(1541, o is GenericDelegate<int>, false);
            Eval(1542, o is GenericDelegate<int>[], false);
            Eval(1543, o is EmptyClass, false);
            Eval(1544, o is EmptyClass[], false);
            Eval(1545, o is NotEmptyClass, false);
            Eval(1546, o is NotEmptyClass[], false);
            Eval(1547, o is EmptyClassGen<int>, false);
            Eval(1548, o is EmptyClassGen<int>[], false);
            Eval(1549, o is NotEmptyClassGen<Guid>, false);
            Eval(1550, o is NotEmptyClassGen<Guid>[], false);
            Eval(1551, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(1552, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(1553, o is NestedClass, false);
            Eval(1554, o is NestedClass[], false);
            Eval(1555, o is NestedClassGen<Decimal>, false);
            Eval(1556, o is NestedClassGen<Decimal>[], false);
            Eval(1557, o is ImplementOneInterfaceC, false);
            Eval(1558, o is ImplementOneInterfaceC[], false);
            Eval(1559, o is ImplementTwoInterfaceC, false);
            Eval(1560, o is ImplementTwoInterfaceC[], false);
            Eval(1561, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(1562, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(1563, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(1564, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(1565, o is ImplementAllInterfaceC<int>, false);
            Eval(1566, o is ImplementAllInterfaceC<int>[], false);
            Eval(1567, o is SealedClass, false);
            Eval(1568, o is SealedClass[], false);
        }
        {
            EmptyStructGen<int>? v = default(EmptyStructGen<int>?);
            ValueType o = v;
            Eval(1569, o is EmptyStruct, false);
            Eval(1570, o is EmptyStruct[], false);
            Eval(1571, o is EmptyStruct?, false);
            Eval(1572, o is EmptyStruct?[], false);
            Eval(1573, o is NotEmptyStruct, false);
            Eval(1574, o is NotEmptyStruct[], false);
            Eval(1575, o is NotEmptyStruct?, false);
            Eval(1576, o is NotEmptyStruct?[], false);
            Eval(1577, o is EmptyStructGen<int>, false);
            Eval(1578, o is EmptyStructGen<int>[], false);
            Eval(1579, o is EmptyStructGen<int>?, false);
            Eval(1580, o is EmptyStructGen<int>?[], false);
            Eval(1581, o is NotEmptyStructGen<Guid>, false);
            Eval(1582, o is NotEmptyStructGen<Guid>[], false);
            Eval(1583, o is NotEmptyStructGen<Guid>?, false);
            Eval(1584, o is NotEmptyStructGen<Guid>?[], false);
            Eval(1585, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(1586, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(1587, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(1588, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(1589, o is NestedStruct, false);
            Eval(1590, o is NestedStruct[], false);
            Eval(1591, o is NestedStruct?, false);
            Eval(1592, o is NestedStruct?[], false);
            Eval(1593, o is NestedStructGen<Decimal>, false);
            Eval(1594, o is NestedStructGen<Decimal>[], false);
            Eval(1595, o is NestedStructGen<Decimal>?, false);
            Eval(1596, o is NestedStructGen<Decimal>?[], false);
            Eval(1597, o is ExplicitFieldOffsetStruct, false);
            Eval(1598, o is ExplicitFieldOffsetStruct[], false);
            Eval(1599, o is ExplicitFieldOffsetStruct?, false);
            Eval(1600, o is ExplicitFieldOffsetStruct?[], false);
            Eval(1609, o is MarshalAsStruct, false);
            Eval(1610, o is MarshalAsStruct[], false);
            Eval(1611, o is MarshalAsStruct?, false);
            Eval(1612, o is MarshalAsStruct?[], false);
            Eval(1613, o is ImplementOneInterface, false);
            Eval(1614, o is ImplementOneInterface[], false);
            Eval(1615, o is ImplementOneInterface?, false);
            Eval(1616, o is ImplementOneInterface?[], false);
            Eval(1617, o is ImplementTwoInterface, false);
            Eval(1618, o is ImplementTwoInterface[], false);
            Eval(1619, o is ImplementTwoInterface?, false);
            Eval(1620, o is ImplementTwoInterface?[], false);
            Eval(1621, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(1622, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(1623, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(1624, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(1625, o is ImplementTwoInterfaceGen<int>, false);
            Eval(1626, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(1627, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(1628, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(1629, o is ImplementAllInterface<int>, false);
            Eval(1630, o is ImplementAllInterface<int>[], false);
            Eval(1631, o is ImplementAllInterface<int>?, false);
            Eval(1632, o is ImplementAllInterface<int>?[], false);
            Eval(1633, o is IntE, false);
            Eval(1634, o is IntE[], false);
            Eval(1635, o is IntE?, false);
            Eval(1636, o is IntE?[], false);
            Eval(1637, o is ByteE, false);
            Eval(1638, o is ByteE[], false);
            Eval(1639, o is ByteE?, false);
            Eval(1640, o is ByteE?[], false);
            Eval(1641, o is LongE, false);
            Eval(1642, o is LongE[], false);
            Eval(1643, o is LongE?, false);
            Eval(1644, o is LongE?[], false);
            Eval(1645, o is char, false);
            Eval(1646, o is char[], false);
            Eval(1647, o is char?, false);
            Eval(1648, o is char?[], false);
            Eval(1649, o is bool, false);
            Eval(1650, o is bool[], false);
            Eval(1651, o is bool?, false);
            Eval(1652, o is bool?[], false);
            Eval(1653, o is byte, false);
            Eval(1654, o is byte[], false);
            Eval(1655, o is byte?, false);
            Eval(1656, o is byte?[], false);
            Eval(1657, o is sbyte, false);
            Eval(1658, o is sbyte[], false);
            Eval(1659, o is sbyte?, false);
            Eval(1660, o is sbyte?[], false);
            Eval(1661, o is short, false);
            Eval(1662, o is short[], false);
            Eval(1663, o is short?, false);
            Eval(1664, o is short?[], false);
            Eval(1665, o is ushort, false);
            Eval(1666, o is ushort[], false);
            Eval(1667, o is ushort?, false);
            Eval(1668, o is ushort?[], false);
            Eval(1669, o is int, false);
            Eval(1670, o is int[], false);
            Eval(1671, o is int?, false);
            Eval(1672, o is int?[], false);
            Eval(1673, o is uint, false);
            Eval(1674, o is uint[], false);
            Eval(1675, o is uint?, false);
            Eval(1676, o is uint?[], false);
            Eval(1677, o is long, false);
            Eval(1678, o is long[], false);
            Eval(1679, o is long?, false);
            Eval(1680, o is long?[], false);
            Eval(1681, o is ulong, false);
            Eval(1682, o is ulong[], false);
            Eval(1683, o is ulong?, false);
            Eval(1684, o is ulong?[], false);
            Eval(1685, o is float, false);
            Eval(1686, o is float[], false);
            Eval(1687, o is float?, false);
            Eval(1688, o is float?[], false);
            Eval(1689, o is double, false);
            Eval(1690, o is double[], false);
            Eval(1691, o is double?, false);
            Eval(1692, o is double?[], false);
            Eval(1693, o is decimal, false);
            Eval(1694, o is decimal[], false);
            Eval(1695, o is decimal?, false);
            Eval(1696, o is decimal?[], false);
            Eval(1697, o is IntPtr, false);
            Eval(1698, o is IntPtr[], false);
            Eval(1699, o is IntPtr?, false);
            Eval(1700, o is IntPtr?[], false);
            Eval(1701, o is UIntPtr, false);
            Eval(1702, o is UIntPtr[], false);
            Eval(1703, o is UIntPtr?, false);
            Eval(1704, o is UIntPtr?[], false);
            Eval(1705, o is Guid, false);
            Eval(1706, o is Guid[], false);
            Eval(1707, o is Guid?, false);
            Eval(1708, o is Guid?[], false);
            Eval(1709, o is GCHandle, false);
            Eval(1710, o is GCHandle[], false);
            Eval(1711, o is GCHandle?, false);
            Eval(1712, o is GCHandle?[], false);
            Eval(1713, o is object, false);
            Eval(1714, o is object[], false);
            Eval(1715, o is string, false);
            Eval(1716, o is string[], false);
            Eval(1717, o is ValueType, false);
            Eval(1718, o is ValueType[], false);
            Eval(1719, o is Array, false);
            Eval(1720, o is Array[], false);
            Eval(1721, o is Enum, false);
            Eval(1722, o is Enum[], false);
            Eval(1723, o is Delegate, false);
            Eval(1724, o is Delegate[], false);
            Eval(1725, o is MulticastDelegate, false);
            Eval(1726, o is MulticastDelegate[], false);
            Eval(1727, o is IEmpty, false);
            Eval(1728, o is IEmpty[], false);
            Eval(1729, o is INotEmpty, false);
            Eval(1730, o is INotEmpty[], false);
            Eval(1731, o is IEmptyGen<int>, false);
            Eval(1732, o is IEmptyGen<int>[], false);
            Eval(1733, o is INotEmptyGen<int>, false);
            Eval(1734, o is INotEmptyGen<int>[], false);
            Eval(1735, o is SimpleDelegate, false);
            Eval(1736, o is SimpleDelegate[], false);
            Eval(1737, o is GenericDelegate<int>, false);
            Eval(1738, o is GenericDelegate<int>[], false);
            Eval(1739, o is EmptyClass, false);
            Eval(1740, o is EmptyClass[], false);
            Eval(1741, o is NotEmptyClass, false);
            Eval(1742, o is NotEmptyClass[], false);
            Eval(1743, o is EmptyClassGen<int>, false);
            Eval(1744, o is EmptyClassGen<int>[], false);
            Eval(1745, o is NotEmptyClassGen<Guid>, false);
            Eval(1746, o is NotEmptyClassGen<Guid>[], false);
            Eval(1747, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(1748, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(1749, o is NestedClass, false);
            Eval(1750, o is NestedClass[], false);
            Eval(1751, o is NestedClassGen<Decimal>, false);
            Eval(1752, o is NestedClassGen<Decimal>[], false);
            Eval(1753, o is ImplementOneInterfaceC, false);
            Eval(1754, o is ImplementOneInterfaceC[], false);
            Eval(1755, o is ImplementTwoInterfaceC, false);
            Eval(1756, o is ImplementTwoInterfaceC[], false);
            Eval(1757, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(1758, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(1759, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(1760, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(1761, o is ImplementAllInterfaceC<int>, false);
            Eval(1762, o is ImplementAllInterfaceC<int>[], false);
            Eval(1763, o is SealedClass, false);
            Eval(1764, o is SealedClass[], false);
        }
    }  // end of test case 0003
    private static void TestCase0004()
    {
        {
            NotEmptyStructGen<Guid> v = default(NotEmptyStructGen<Guid>);
            ValueType o = v;
            Eval(1765, o is EmptyStruct, false);
            Eval(1766, o is EmptyStruct[], false);
            Eval(1767, o is EmptyStruct?, false);
            Eval(1768, o is EmptyStruct?[], false);
            Eval(1769, o is NotEmptyStruct, false);
            Eval(1770, o is NotEmptyStruct[], false);
            Eval(1771, o is NotEmptyStruct?, false);
            Eval(1772, o is NotEmptyStruct?[], false);
            Eval(1773, o is EmptyStructGen<int>, false);
            Eval(1774, o is EmptyStructGen<int>[], false);
            Eval(1775, o is EmptyStructGen<int>?, false);
            Eval(1776, o is EmptyStructGen<int>?[], false);
            Eval(1777, o is NotEmptyStructGen<Guid>, true);
            Eval(1778, o is NotEmptyStructGen<Guid>[], false);
            Eval(1779, o is NotEmptyStructGen<Guid>?, true);
            Eval(1780, o is NotEmptyStructGen<Guid>?[], false);
            Eval(1781, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(1782, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(1783, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(1784, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(1785, o is NestedStruct, false);
            Eval(1786, o is NestedStruct[], false);
            Eval(1787, o is NestedStruct?, false);
            Eval(1788, o is NestedStruct?[], false);
            Eval(1789, o is NestedStructGen<Decimal>, false);
            Eval(1790, o is NestedStructGen<Decimal>[], false);
            Eval(1791, o is NestedStructGen<Decimal>?, false);
            Eval(1792, o is NestedStructGen<Decimal>?[], false);
            Eval(1793, o is ExplicitFieldOffsetStruct, false);
            Eval(1794, o is ExplicitFieldOffsetStruct[], false);
            Eval(1795, o is ExplicitFieldOffsetStruct?, false);
            Eval(1796, o is ExplicitFieldOffsetStruct?[], false);
            Eval(1805, o is MarshalAsStruct, false);
            Eval(1806, o is MarshalAsStruct[], false);
            Eval(1807, o is MarshalAsStruct?, false);
            Eval(1808, o is MarshalAsStruct?[], false);
            Eval(1809, o is ImplementOneInterface, false);
            Eval(1810, o is ImplementOneInterface[], false);
            Eval(1811, o is ImplementOneInterface?, false);
            Eval(1812, o is ImplementOneInterface?[], false);
            Eval(1813, o is ImplementTwoInterface, false);
            Eval(1814, o is ImplementTwoInterface[], false);
            Eval(1815, o is ImplementTwoInterface?, false);
            Eval(1816, o is ImplementTwoInterface?[], false);
            Eval(1817, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(1818, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(1819, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(1820, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(1821, o is ImplementTwoInterfaceGen<int>, false);
            Eval(1822, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(1823, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(1824, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(1825, o is ImplementAllInterface<int>, false);
            Eval(1826, o is ImplementAllInterface<int>[], false);
            Eval(1827, o is ImplementAllInterface<int>?, false);
            Eval(1828, o is ImplementAllInterface<int>?[], false);
            Eval(1829, o is IntE, false);
            Eval(1830, o is IntE[], false);
            Eval(1831, o is IntE?, false);
            Eval(1832, o is IntE?[], false);
            Eval(1833, o is ByteE, false);
            Eval(1834, o is ByteE[], false);
            Eval(1835, o is ByteE?, false);
            Eval(1836, o is ByteE?[], false);
            Eval(1837, o is LongE, false);
            Eval(1838, o is LongE[], false);
            Eval(1839, o is LongE?, false);
            Eval(1840, o is LongE?[], false);
            Eval(1841, o is char, false);
            Eval(1842, o is char[], false);
            Eval(1843, o is char?, false);
            Eval(1844, o is char?[], false);
            Eval(1845, o is bool, false);
            Eval(1846, o is bool[], false);
            Eval(1847, o is bool?, false);
            Eval(1848, o is bool?[], false);
            Eval(1849, o is byte, false);
            Eval(1850, o is byte[], false);
            Eval(1851, o is byte?, false);
            Eval(1852, o is byte?[], false);
            Eval(1853, o is sbyte, false);
            Eval(1854, o is sbyte[], false);
            Eval(1855, o is sbyte?, false);
            Eval(1856, o is sbyte?[], false);
            Eval(1857, o is short, false);
            Eval(1858, o is short[], false);
            Eval(1859, o is short?, false);
            Eval(1860, o is short?[], false);
            Eval(1861, o is ushort, false);
            Eval(1862, o is ushort[], false);
            Eval(1863, o is ushort?, false);
            Eval(1864, o is ushort?[], false);
            Eval(1865, o is int, false);
            Eval(1866, o is int[], false);
            Eval(1867, o is int?, false);
            Eval(1868, o is int?[], false);
            Eval(1869, o is uint, false);
            Eval(1870, o is uint[], false);
            Eval(1871, o is uint?, false);
            Eval(1872, o is uint?[], false);
            Eval(1873, o is long, false);
            Eval(1874, o is long[], false);
            Eval(1875, o is long?, false);
            Eval(1876, o is long?[], false);
            Eval(1877, o is ulong, false);
            Eval(1878, o is ulong[], false);
            Eval(1879, o is ulong?, false);
            Eval(1880, o is ulong?[], false);
            Eval(1881, o is float, false);
            Eval(1882, o is float[], false);
            Eval(1883, o is float?, false);
            Eval(1884, o is float?[], false);
            Eval(1885, o is double, false);
            Eval(1886, o is double[], false);
            Eval(1887, o is double?, false);
            Eval(1888, o is double?[], false);
            Eval(1889, o is decimal, false);
            Eval(1890, o is decimal[], false);
            Eval(1891, o is decimal?, false);
            Eval(1892, o is decimal?[], false);
            Eval(1893, o is IntPtr, false);
            Eval(1894, o is IntPtr[], false);
            Eval(1895, o is IntPtr?, false);
            Eval(1896, o is IntPtr?[], false);
            Eval(1897, o is UIntPtr, false);
            Eval(1898, o is UIntPtr[], false);
            Eval(1899, o is UIntPtr?, false);
            Eval(1900, o is UIntPtr?[], false);
            Eval(1901, o is Guid, false);
            Eval(1902, o is Guid[], false);
            Eval(1903, o is Guid?, false);
            Eval(1904, o is Guid?[], false);
            Eval(1905, o is GCHandle, false);
            Eval(1906, o is GCHandle[], false);
            Eval(1907, o is GCHandle?, false);
            Eval(1908, o is GCHandle?[], false);
            Eval(1909, o is object, true);
            Eval(1910, o is object[], false);
            Eval(1911, o is string, false);
            Eval(1912, o is string[], false);
            Eval(1913, o is ValueType, true);
            Eval(1914, o is ValueType[], false);
            Eval(1915, o is Array, false);
            Eval(1916, o is Array[], false);
            Eval(1917, o is Enum, false);
            Eval(1918, o is Enum[], false);
            Eval(1919, o is Delegate, false);
            Eval(1920, o is Delegate[], false);
            Eval(1921, o is MulticastDelegate, false);
            Eval(1922, o is MulticastDelegate[], false);
            Eval(1923, o is IEmpty, false);
            Eval(1924, o is IEmpty[], false);
            Eval(1925, o is INotEmpty, false);
            Eval(1926, o is INotEmpty[], false);
            Eval(1927, o is IEmptyGen<int>, false);
            Eval(1928, o is IEmptyGen<int>[], false);
            Eval(1929, o is INotEmptyGen<int>, false);
            Eval(1930, o is INotEmptyGen<int>[], false);
            Eval(1931, o is SimpleDelegate, false);
            Eval(1932, o is SimpleDelegate[], false);
            Eval(1933, o is GenericDelegate<int>, false);
            Eval(1934, o is GenericDelegate<int>[], false);
            Eval(1935, o is EmptyClass, false);
            Eval(1936, o is EmptyClass[], false);
            Eval(1937, o is NotEmptyClass, false);
            Eval(1938, o is NotEmptyClass[], false);
            Eval(1939, o is EmptyClassGen<int>, false);
            Eval(1940, o is EmptyClassGen<int>[], false);
            Eval(1941, o is NotEmptyClassGen<Guid>, false);
            Eval(1942, o is NotEmptyClassGen<Guid>[], false);
            Eval(1943, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(1944, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(1945, o is NestedClass, false);
            Eval(1946, o is NestedClass[], false);
            Eval(1947, o is NestedClassGen<Decimal>, false);
            Eval(1948, o is NestedClassGen<Decimal>[], false);
            Eval(1949, o is ImplementOneInterfaceC, false);
            Eval(1950, o is ImplementOneInterfaceC[], false);
            Eval(1951, o is ImplementTwoInterfaceC, false);
            Eval(1952, o is ImplementTwoInterfaceC[], false);
            Eval(1953, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(1954, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(1955, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(1956, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(1957, o is ImplementAllInterfaceC<int>, false);
            Eval(1958, o is ImplementAllInterfaceC<int>[], false);
            Eval(1959, o is SealedClass, false);
            Eval(1960, o is SealedClass[], false);
        }
        {
            NotEmptyStructGen<Guid>? v = default(NotEmptyStructGen<Guid>);
            ValueType o = v;
            Eval(1961, o is EmptyStruct, false);
            Eval(1962, o is EmptyStruct[], false);
            Eval(1963, o is EmptyStruct?, false);
            Eval(1964, o is EmptyStruct?[], false);
            Eval(1965, o is NotEmptyStruct, false);
            Eval(1966, o is NotEmptyStruct[], false);
            Eval(1967, o is NotEmptyStruct?, false);
            Eval(1968, o is NotEmptyStruct?[], false);
            Eval(1969, o is EmptyStructGen<int>, false);
            Eval(1970, o is EmptyStructGen<int>[], false);
            Eval(1971, o is EmptyStructGen<int>?, false);
            Eval(1972, o is EmptyStructGen<int>?[], false);
            Eval(1973, o is NotEmptyStructGen<Guid>, true);
            Eval(1974, o is NotEmptyStructGen<Guid>[], false);
            Eval(1975, o is NotEmptyStructGen<Guid>?, true);
            Eval(1976, o is NotEmptyStructGen<Guid>?[], false);
            Eval(1977, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(1978, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(1979, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(1980, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(1981, o is NestedStruct, false);
            Eval(1982, o is NestedStruct[], false);
            Eval(1983, o is NestedStruct?, false);
            Eval(1984, o is NestedStruct?[], false);
            Eval(1985, o is NestedStructGen<Decimal>, false);
            Eval(1986, o is NestedStructGen<Decimal>[], false);
            Eval(1987, o is NestedStructGen<Decimal>?, false);
            Eval(1988, o is NestedStructGen<Decimal>?[], false);
            Eval(1989, o is ExplicitFieldOffsetStruct, false);
            Eval(1990, o is ExplicitFieldOffsetStruct[], false);
            Eval(1991, o is ExplicitFieldOffsetStruct?, false);
            Eval(1992, o is ExplicitFieldOffsetStruct?[], false);
            Eval(2001, o is MarshalAsStruct, false);
            Eval(2002, o is MarshalAsStruct[], false);
            Eval(2003, o is MarshalAsStruct?, false);
            Eval(2004, o is MarshalAsStruct?[], false);
            Eval(2005, o is ImplementOneInterface, false);
            Eval(2006, o is ImplementOneInterface[], false);
            Eval(2007, o is ImplementOneInterface?, false);
            Eval(2008, o is ImplementOneInterface?[], false);
            Eval(2009, o is ImplementTwoInterface, false);
            Eval(2010, o is ImplementTwoInterface[], false);
            Eval(2011, o is ImplementTwoInterface?, false);
            Eval(2012, o is ImplementTwoInterface?[], false);
            Eval(2013, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(2014, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(2015, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(2016, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(2017, o is ImplementTwoInterfaceGen<int>, false);
            Eval(2018, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(2019, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(2020, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(2021, o is ImplementAllInterface<int>, false);
            Eval(2022, o is ImplementAllInterface<int>[], false);
            Eval(2023, o is ImplementAllInterface<int>?, false);
            Eval(2024, o is ImplementAllInterface<int>?[], false);
            Eval(2025, o is IntE, false);
            Eval(2026, o is IntE[], false);
            Eval(2027, o is IntE?, false);
            Eval(2028, o is IntE?[], false);
            Eval(2029, o is ByteE, false);
            Eval(2030, o is ByteE[], false);
            Eval(2031, o is ByteE?, false);
            Eval(2032, o is ByteE?[], false);
            Eval(2033, o is LongE, false);
            Eval(2034, o is LongE[], false);
            Eval(2035, o is LongE?, false);
            Eval(2036, o is LongE?[], false);
            Eval(2037, o is char, false);
            Eval(2038, o is char[], false);
            Eval(2039, o is char?, false);
            Eval(2040, o is char?[], false);
            Eval(2041, o is bool, false);
            Eval(2042, o is bool[], false);
            Eval(2043, o is bool?, false);
            Eval(2044, o is bool?[], false);
            Eval(2045, o is byte, false);
            Eval(2046, o is byte[], false);
            Eval(2047, o is byte?, false);
            Eval(2048, o is byte?[], false);
            Eval(2049, o is sbyte, false);
            Eval(2050, o is sbyte[], false);
            Eval(2051, o is sbyte?, false);
            Eval(2052, o is sbyte?[], false);
            Eval(2053, o is short, false);
            Eval(2054, o is short[], false);
            Eval(2055, o is short?, false);
            Eval(2056, o is short?[], false);
            Eval(2057, o is ushort, false);
            Eval(2058, o is ushort[], false);
            Eval(2059, o is ushort?, false);
            Eval(2060, o is ushort?[], false);
            Eval(2061, o is int, false);
            Eval(2062, o is int[], false);
            Eval(2063, o is int?, false);
            Eval(2064, o is int?[], false);
            Eval(2065, o is uint, false);
            Eval(2066, o is uint[], false);
            Eval(2067, o is uint?, false);
            Eval(2068, o is uint?[], false);
            Eval(2069, o is long, false);
            Eval(2070, o is long[], false);
            Eval(2071, o is long?, false);
            Eval(2072, o is long?[], false);
            Eval(2073, o is ulong, false);
            Eval(2074, o is ulong[], false);
            Eval(2075, o is ulong?, false);
            Eval(2076, o is ulong?[], false);
            Eval(2077, o is float, false);
            Eval(2078, o is float[], false);
            Eval(2079, o is float?, false);
            Eval(2080, o is float?[], false);
            Eval(2081, o is double, false);
            Eval(2082, o is double[], false);
            Eval(2083, o is double?, false);
            Eval(2084, o is double?[], false);
            Eval(2085, o is decimal, false);
            Eval(2086, o is decimal[], false);
            Eval(2087, o is decimal?, false);
            Eval(2088, o is decimal?[], false);
            Eval(2089, o is IntPtr, false);
            Eval(2090, o is IntPtr[], false);
            Eval(2091, o is IntPtr?, false);
            Eval(2092, o is IntPtr?[], false);
            Eval(2093, o is UIntPtr, false);
            Eval(2094, o is UIntPtr[], false);
            Eval(2095, o is UIntPtr?, false);
            Eval(2096, o is UIntPtr?[], false);
            Eval(2097, o is Guid, false);
            Eval(2098, o is Guid[], false);
            Eval(2099, o is Guid?, false);
            Eval(2100, o is Guid?[], false);
            Eval(2101, o is GCHandle, false);
            Eval(2102, o is GCHandle[], false);
            Eval(2103, o is GCHandle?, false);
            Eval(2104, o is GCHandle?[], false);
            Eval(2105, o is object, true);
            Eval(2106, o is object[], false);
            Eval(2107, o is string, false);
            Eval(2108, o is string[], false);
            Eval(2109, o is ValueType, true);
            Eval(2110, o is ValueType[], false);
            Eval(2111, o is Array, false);
            Eval(2112, o is Array[], false);
            Eval(2113, o is Enum, false);
            Eval(2114, o is Enum[], false);
            Eval(2115, o is Delegate, false);
            Eval(2116, o is Delegate[], false);
            Eval(2117, o is MulticastDelegate, false);
            Eval(2118, o is MulticastDelegate[], false);
            Eval(2119, o is IEmpty, false);
            Eval(2120, o is IEmpty[], false);
            Eval(2121, o is INotEmpty, false);
            Eval(2122, o is INotEmpty[], false);
            Eval(2123, o is IEmptyGen<int>, false);
            Eval(2124, o is IEmptyGen<int>[], false);
            Eval(2125, o is INotEmptyGen<int>, false);
            Eval(2126, o is INotEmptyGen<int>[], false);
            Eval(2127, o is SimpleDelegate, false);
            Eval(2128, o is SimpleDelegate[], false);
            Eval(2129, o is GenericDelegate<int>, false);
            Eval(2130, o is GenericDelegate<int>[], false);
            Eval(2131, o is EmptyClass, false);
            Eval(2132, o is EmptyClass[], false);
            Eval(2133, o is NotEmptyClass, false);
            Eval(2134, o is NotEmptyClass[], false);
            Eval(2135, o is EmptyClassGen<int>, false);
            Eval(2136, o is EmptyClassGen<int>[], false);
            Eval(2137, o is NotEmptyClassGen<Guid>, false);
            Eval(2138, o is NotEmptyClassGen<Guid>[], false);
            Eval(2139, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(2140, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(2141, o is NestedClass, false);
            Eval(2142, o is NestedClass[], false);
            Eval(2143, o is NestedClassGen<Decimal>, false);
            Eval(2144, o is NestedClassGen<Decimal>[], false);
            Eval(2145, o is ImplementOneInterfaceC, false);
            Eval(2146, o is ImplementOneInterfaceC[], false);
            Eval(2147, o is ImplementTwoInterfaceC, false);
            Eval(2148, o is ImplementTwoInterfaceC[], false);
            Eval(2149, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(2150, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(2151, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(2152, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(2153, o is ImplementAllInterfaceC<int>, false);
            Eval(2154, o is ImplementAllInterfaceC<int>[], false);
            Eval(2155, o is SealedClass, false);
            Eval(2156, o is SealedClass[], false);
        }
        {
            NotEmptyStructGen<Guid>? v = default(NotEmptyStructGen<Guid>?);
            ValueType o = v;
            Eval(2157, o is EmptyStruct, false);
            Eval(2158, o is EmptyStruct[], false);
            Eval(2159, o is EmptyStruct?, false);
            Eval(2160, o is EmptyStruct?[], false);
            Eval(2161, o is NotEmptyStruct, false);
            Eval(2162, o is NotEmptyStruct[], false);
            Eval(2163, o is NotEmptyStruct?, false);
            Eval(2164, o is NotEmptyStruct?[], false);
            Eval(2165, o is EmptyStructGen<int>, false);
            Eval(2166, o is EmptyStructGen<int>[], false);
            Eval(2167, o is EmptyStructGen<int>?, false);
            Eval(2168, o is EmptyStructGen<int>?[], false);
            Eval(2169, o is NotEmptyStructGen<Guid>, false);
            Eval(2170, o is NotEmptyStructGen<Guid>[], false);
            Eval(2171, o is NotEmptyStructGen<Guid>?, false);
            Eval(2172, o is NotEmptyStructGen<Guid>?[], false);
            Eval(2173, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(2174, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(2175, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(2176, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(2177, o is NestedStruct, false);
            Eval(2178, o is NestedStruct[], false);
            Eval(2179, o is NestedStruct?, false);
            Eval(2180, o is NestedStruct?[], false);
            Eval(2181, o is NestedStructGen<Decimal>, false);
            Eval(2182, o is NestedStructGen<Decimal>[], false);
            Eval(2183, o is NestedStructGen<Decimal>?, false);
            Eval(2184, o is NestedStructGen<Decimal>?[], false);
            Eval(2185, o is ExplicitFieldOffsetStruct, false);
            Eval(2186, o is ExplicitFieldOffsetStruct[], false);
            Eval(2187, o is ExplicitFieldOffsetStruct?, false);
            Eval(2188, o is ExplicitFieldOffsetStruct?[], false);
            Eval(2197, o is MarshalAsStruct, false);
            Eval(2198, o is MarshalAsStruct[], false);
            Eval(2199, o is MarshalAsStruct?, false);
            Eval(2200, o is MarshalAsStruct?[], false);
            Eval(2201, o is ImplementOneInterface, false);
            Eval(2202, o is ImplementOneInterface[], false);
            Eval(2203, o is ImplementOneInterface?, false);
            Eval(2204, o is ImplementOneInterface?[], false);
            Eval(2205, o is ImplementTwoInterface, false);
            Eval(2206, o is ImplementTwoInterface[], false);
            Eval(2207, o is ImplementTwoInterface?, false);
            Eval(2208, o is ImplementTwoInterface?[], false);
            Eval(2209, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(2210, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(2211, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(2212, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(2213, o is ImplementTwoInterfaceGen<int>, false);
            Eval(2214, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(2215, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(2216, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(2217, o is ImplementAllInterface<int>, false);
            Eval(2218, o is ImplementAllInterface<int>[], false);
            Eval(2219, o is ImplementAllInterface<int>?, false);
            Eval(2220, o is ImplementAllInterface<int>?[], false);
            Eval(2221, o is IntE, false);
            Eval(2222, o is IntE[], false);
            Eval(2223, o is IntE?, false);
            Eval(2224, o is IntE?[], false);
            Eval(2225, o is ByteE, false);
            Eval(2226, o is ByteE[], false);
            Eval(2227, o is ByteE?, false);
            Eval(2228, o is ByteE?[], false);
            Eval(2229, o is LongE, false);
            Eval(2230, o is LongE[], false);
            Eval(2231, o is LongE?, false);
            Eval(2232, o is LongE?[], false);
            Eval(2233, o is char, false);
            Eval(2234, o is char[], false);
            Eval(2235, o is char?, false);
            Eval(2236, o is char?[], false);
            Eval(2237, o is bool, false);
            Eval(2238, o is bool[], false);
            Eval(2239, o is bool?, false);
            Eval(2240, o is bool?[], false);
            Eval(2241, o is byte, false);
            Eval(2242, o is byte[], false);
            Eval(2243, o is byte?, false);
            Eval(2244, o is byte?[], false);
            Eval(2245, o is sbyte, false);
            Eval(2246, o is sbyte[], false);
            Eval(2247, o is sbyte?, false);
            Eval(2248, o is sbyte?[], false);
            Eval(2249, o is short, false);
            Eval(2250, o is short[], false);
            Eval(2251, o is short?, false);
            Eval(2252, o is short?[], false);
            Eval(2253, o is ushort, false);
            Eval(2254, o is ushort[], false);
            Eval(2255, o is ushort?, false);
            Eval(2256, o is ushort?[], false);
            Eval(2257, o is int, false);
            Eval(2258, o is int[], false);
            Eval(2259, o is int?, false);
            Eval(2260, o is int?[], false);
            Eval(2261, o is uint, false);
            Eval(2262, o is uint[], false);
            Eval(2263, o is uint?, false);
            Eval(2264, o is uint?[], false);
            Eval(2265, o is long, false);
            Eval(2266, o is long[], false);
            Eval(2267, o is long?, false);
            Eval(2268, o is long?[], false);
            Eval(2269, o is ulong, false);
            Eval(2270, o is ulong[], false);
            Eval(2271, o is ulong?, false);
            Eval(2272, o is ulong?[], false);
            Eval(2273, o is float, false);
            Eval(2274, o is float[], false);
            Eval(2275, o is float?, false);
            Eval(2276, o is float?[], false);
            Eval(2277, o is double, false);
            Eval(2278, o is double[], false);
            Eval(2279, o is double?, false);
            Eval(2280, o is double?[], false);
            Eval(2281, o is decimal, false);
            Eval(2282, o is decimal[], false);
            Eval(2283, o is decimal?, false);
            Eval(2284, o is decimal?[], false);
            Eval(2285, o is IntPtr, false);
            Eval(2286, o is IntPtr[], false);
            Eval(2287, o is IntPtr?, false);
            Eval(2288, o is IntPtr?[], false);
            Eval(2289, o is UIntPtr, false);
            Eval(2290, o is UIntPtr[], false);
            Eval(2291, o is UIntPtr?, false);
            Eval(2292, o is UIntPtr?[], false);
            Eval(2293, o is Guid, false);
            Eval(2294, o is Guid[], false);
            Eval(2295, o is Guid?, false);
            Eval(2296, o is Guid?[], false);
            Eval(2297, o is GCHandle, false);
            Eval(2298, o is GCHandle[], false);
            Eval(2299, o is GCHandle?, false);
            Eval(2300, o is GCHandle?[], false);
            Eval(2301, o is object, false);
            Eval(2302, o is object[], false);
            Eval(2303, o is string, false);
            Eval(2304, o is string[], false);
            Eval(2305, o is ValueType, false);
            Eval(2306, o is ValueType[], false);
            Eval(2307, o is Array, false);
            Eval(2308, o is Array[], false);
            Eval(2309, o is Enum, false);
            Eval(2310, o is Enum[], false);
            Eval(2311, o is Delegate, false);
            Eval(2312, o is Delegate[], false);
            Eval(2313, o is MulticastDelegate, false);
            Eval(2314, o is MulticastDelegate[], false);
            Eval(2315, o is IEmpty, false);
            Eval(2316, o is IEmpty[], false);
            Eval(2317, o is INotEmpty, false);
            Eval(2318, o is INotEmpty[], false);
            Eval(2319, o is IEmptyGen<int>, false);
            Eval(2320, o is IEmptyGen<int>[], false);
            Eval(2321, o is INotEmptyGen<int>, false);
            Eval(2322, o is INotEmptyGen<int>[], false);
            Eval(2323, o is SimpleDelegate, false);
            Eval(2324, o is SimpleDelegate[], false);
            Eval(2325, o is GenericDelegate<int>, false);
            Eval(2326, o is GenericDelegate<int>[], false);
            Eval(2327, o is EmptyClass, false);
            Eval(2328, o is EmptyClass[], false);
            Eval(2329, o is NotEmptyClass, false);
            Eval(2330, o is NotEmptyClass[], false);
            Eval(2331, o is EmptyClassGen<int>, false);
            Eval(2332, o is EmptyClassGen<int>[], false);
            Eval(2333, o is NotEmptyClassGen<Guid>, false);
            Eval(2334, o is NotEmptyClassGen<Guid>[], false);
            Eval(2335, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(2336, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(2337, o is NestedClass, false);
            Eval(2338, o is NestedClass[], false);
            Eval(2339, o is NestedClassGen<Decimal>, false);
            Eval(2340, o is NestedClassGen<Decimal>[], false);
            Eval(2341, o is ImplementOneInterfaceC, false);
            Eval(2342, o is ImplementOneInterfaceC[], false);
            Eval(2343, o is ImplementTwoInterfaceC, false);
            Eval(2344, o is ImplementTwoInterfaceC[], false);
            Eval(2345, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(2346, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(2347, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(2348, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(2349, o is ImplementAllInterfaceC<int>, false);
            Eval(2350, o is ImplementAllInterfaceC<int>[], false);
            Eval(2351, o is SealedClass, false);
            Eval(2352, o is SealedClass[], false);
        }
    }  // end of test case 0004
    private static void TestCase0005()
    {
        {
            NotEmptyStructConstrainedGen<IntPtr> v = default(NotEmptyStructConstrainedGen<IntPtr>);
            ValueType o = v;
            Eval(2353, o is EmptyStruct, false);
            Eval(2354, o is EmptyStruct[], false);
            Eval(2355, o is EmptyStruct?, false);
            Eval(2356, o is EmptyStruct?[], false);
            Eval(2357, o is NotEmptyStruct, false);
            Eval(2358, o is NotEmptyStruct[], false);
            Eval(2359, o is NotEmptyStruct?, false);
            Eval(2360, o is NotEmptyStruct?[], false);
            Eval(2361, o is EmptyStructGen<int>, false);
            Eval(2362, o is EmptyStructGen<int>[], false);
            Eval(2363, o is EmptyStructGen<int>?, false);
            Eval(2364, o is EmptyStructGen<int>?[], false);
            Eval(2365, o is NotEmptyStructGen<Guid>, false);
            Eval(2366, o is NotEmptyStructGen<Guid>[], false);
            Eval(2367, o is NotEmptyStructGen<Guid>?, false);
            Eval(2368, o is NotEmptyStructGen<Guid>?[], false);
            Eval(2369, o is NotEmptyStructConstrainedGen<IntPtr>, true);
            Eval(2370, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(2371, o is NotEmptyStructConstrainedGen<IntPtr>?, true);
            Eval(2372, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(2373, o is NestedStruct, false);
            Eval(2374, o is NestedStruct[], false);
            Eval(2375, o is NestedStruct?, false);
            Eval(2376, o is NestedStruct?[], false);
            Eval(2377, o is NestedStructGen<Decimal>, false);
            Eval(2378, o is NestedStructGen<Decimal>[], false);
            Eval(2379, o is NestedStructGen<Decimal>?, false);
            Eval(2380, o is NestedStructGen<Decimal>?[], false);
            Eval(2381, o is ExplicitFieldOffsetStruct, false);
            Eval(2382, o is ExplicitFieldOffsetStruct[], false);
            Eval(2383, o is ExplicitFieldOffsetStruct?, false);
            Eval(2384, o is ExplicitFieldOffsetStruct?[], false);
            Eval(2393, o is MarshalAsStruct, false);
            Eval(2394, o is MarshalAsStruct[], false);
            Eval(2395, o is MarshalAsStruct?, false);
            Eval(2396, o is MarshalAsStruct?[], false);
            Eval(2397, o is ImplementOneInterface, false);
            Eval(2398, o is ImplementOneInterface[], false);
            Eval(2399, o is ImplementOneInterface?, false);
            Eval(2400, o is ImplementOneInterface?[], false);
            Eval(2401, o is ImplementTwoInterface, false);
            Eval(2402, o is ImplementTwoInterface[], false);
            Eval(2403, o is ImplementTwoInterface?, false);
            Eval(2404, o is ImplementTwoInterface?[], false);
            Eval(2405, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(2406, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(2407, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(2408, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(2409, o is ImplementTwoInterfaceGen<int>, false);
            Eval(2410, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(2411, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(2412, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(2413, o is ImplementAllInterface<int>, false);
            Eval(2414, o is ImplementAllInterface<int>[], false);
            Eval(2415, o is ImplementAllInterface<int>?, false);
            Eval(2416, o is ImplementAllInterface<int>?[], false);
            Eval(2417, o is IntE, false);
            Eval(2418, o is IntE[], false);
            Eval(2419, o is IntE?, false);
            Eval(2420, o is IntE?[], false);
            Eval(2421, o is ByteE, false);
            Eval(2422, o is ByteE[], false);
            Eval(2423, o is ByteE?, false);
            Eval(2424, o is ByteE?[], false);
            Eval(2425, o is LongE, false);
            Eval(2426, o is LongE[], false);
            Eval(2427, o is LongE?, false);
            Eval(2428, o is LongE?[], false);
            Eval(2429, o is char, false);
            Eval(2430, o is char[], false);
            Eval(2431, o is char?, false);
            Eval(2432, o is char?[], false);
            Eval(2433, o is bool, false);
            Eval(2434, o is bool[], false);
            Eval(2435, o is bool?, false);
            Eval(2436, o is bool?[], false);
            Eval(2437, o is byte, false);
            Eval(2438, o is byte[], false);
            Eval(2439, o is byte?, false);
            Eval(2440, o is byte?[], false);
            Eval(2441, o is sbyte, false);
            Eval(2442, o is sbyte[], false);
            Eval(2443, o is sbyte?, false);
            Eval(2444, o is sbyte?[], false);
            Eval(2445, o is short, false);
            Eval(2446, o is short[], false);
            Eval(2447, o is short?, false);
            Eval(2448, o is short?[], false);
            Eval(2449, o is ushort, false);
            Eval(2450, o is ushort[], false);
            Eval(2451, o is ushort?, false);
            Eval(2452, o is ushort?[], false);
            Eval(2453, o is int, false);
            Eval(2454, o is int[], false);
            Eval(2455, o is int?, false);
            Eval(2456, o is int?[], false);
            Eval(2457, o is uint, false);
            Eval(2458, o is uint[], false);
            Eval(2459, o is uint?, false);
            Eval(2460, o is uint?[], false);
            Eval(2461, o is long, false);
            Eval(2462, o is long[], false);
            Eval(2463, o is long?, false);
            Eval(2464, o is long?[], false);
            Eval(2465, o is ulong, false);
            Eval(2466, o is ulong[], false);
            Eval(2467, o is ulong?, false);
            Eval(2468, o is ulong?[], false);
            Eval(2469, o is float, false);
            Eval(2470, o is float[], false);
            Eval(2471, o is float?, false);
            Eval(2472, o is float?[], false);
            Eval(2473, o is double, false);
            Eval(2474, o is double[], false);
            Eval(2475, o is double?, false);
            Eval(2476, o is double?[], false);
            Eval(2477, o is decimal, false);
            Eval(2478, o is decimal[], false);
            Eval(2479, o is decimal?, false);
            Eval(2480, o is decimal?[], false);
            Eval(2481, o is IntPtr, false);
            Eval(2482, o is IntPtr[], false);
            Eval(2483, o is IntPtr?, false);
            Eval(2484, o is IntPtr?[], false);
            Eval(2485, o is UIntPtr, false);
            Eval(2486, o is UIntPtr[], false);
            Eval(2487, o is UIntPtr?, false);
            Eval(2488, o is UIntPtr?[], false);
            Eval(2489, o is Guid, false);
            Eval(2490, o is Guid[], false);
            Eval(2491, o is Guid?, false);
            Eval(2492, o is Guid?[], false);
            Eval(2493, o is GCHandle, false);
            Eval(2494, o is GCHandle[], false);
            Eval(2495, o is GCHandle?, false);
            Eval(2496, o is GCHandle?[], false);
            Eval(2497, o is object, true);
            Eval(2498, o is object[], false);
            Eval(2499, o is string, false);
            Eval(2500, o is string[], false);
            Eval(2501, o is ValueType, true);
            Eval(2502, o is ValueType[], false);
            Eval(2503, o is Array, false);
            Eval(2504, o is Array[], false);
            Eval(2505, o is Enum, false);
            Eval(2506, o is Enum[], false);
            Eval(2507, o is Delegate, false);
            Eval(2508, o is Delegate[], false);
            Eval(2509, o is MulticastDelegate, false);
            Eval(2510, o is MulticastDelegate[], false);
            Eval(2511, o is IEmpty, false);
            Eval(2512, o is IEmpty[], false);
            Eval(2513, o is INotEmpty, false);
            Eval(2514, o is INotEmpty[], false);
            Eval(2515, o is IEmptyGen<int>, false);
            Eval(2516, o is IEmptyGen<int>[], false);
            Eval(2517, o is INotEmptyGen<int>, false);
            Eval(2518, o is INotEmptyGen<int>[], false);
            Eval(2519, o is SimpleDelegate, false);
            Eval(2520, o is SimpleDelegate[], false);
            Eval(2521, o is GenericDelegate<int>, false);
            Eval(2522, o is GenericDelegate<int>[], false);
            Eval(2523, o is EmptyClass, false);
            Eval(2524, o is EmptyClass[], false);
            Eval(2525, o is NotEmptyClass, false);
            Eval(2526, o is NotEmptyClass[], false);
            Eval(2527, o is EmptyClassGen<int>, false);
            Eval(2528, o is EmptyClassGen<int>[], false);
            Eval(2529, o is NotEmptyClassGen<Guid>, false);
            Eval(2530, o is NotEmptyClassGen<Guid>[], false);
            Eval(2531, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(2532, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(2533, o is NestedClass, false);
            Eval(2534, o is NestedClass[], false);
            Eval(2535, o is NestedClassGen<Decimal>, false);
            Eval(2536, o is NestedClassGen<Decimal>[], false);
            Eval(2537, o is ImplementOneInterfaceC, false);
            Eval(2538, o is ImplementOneInterfaceC[], false);
            Eval(2539, o is ImplementTwoInterfaceC, false);
            Eval(2540, o is ImplementTwoInterfaceC[], false);
            Eval(2541, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(2542, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(2543, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(2544, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(2545, o is ImplementAllInterfaceC<int>, false);
            Eval(2546, o is ImplementAllInterfaceC<int>[], false);
            Eval(2547, o is SealedClass, false);
            Eval(2548, o is SealedClass[], false);
        }
        {
            NotEmptyStructConstrainedGen<IntPtr>? v = default(NotEmptyStructConstrainedGen<IntPtr>);
            ValueType o = v;
            Eval(2549, o is EmptyStruct, false);
            Eval(2550, o is EmptyStruct[], false);
            Eval(2551, o is EmptyStruct?, false);
            Eval(2552, o is EmptyStruct?[], false);
            Eval(2553, o is NotEmptyStruct, false);
            Eval(2554, o is NotEmptyStruct[], false);
            Eval(2555, o is NotEmptyStruct?, false);
            Eval(2556, o is NotEmptyStruct?[], false);
            Eval(2557, o is EmptyStructGen<int>, false);
            Eval(2558, o is EmptyStructGen<int>[], false);
            Eval(2559, o is EmptyStructGen<int>?, false);
            Eval(2560, o is EmptyStructGen<int>?[], false);
            Eval(2561, o is NotEmptyStructGen<Guid>, false);
            Eval(2562, o is NotEmptyStructGen<Guid>[], false);
            Eval(2563, o is NotEmptyStructGen<Guid>?, false);
            Eval(2564, o is NotEmptyStructGen<Guid>?[], false);
            Eval(2565, o is NotEmptyStructConstrainedGen<IntPtr>, true);
            Eval(2566, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(2567, o is NotEmptyStructConstrainedGen<IntPtr>?, true);
            Eval(2568, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(2569, o is NestedStruct, false);
            Eval(2570, o is NestedStruct[], false);
            Eval(2571, o is NestedStruct?, false);
            Eval(2572, o is NestedStruct?[], false);
            Eval(2573, o is NestedStructGen<Decimal>, false);
            Eval(2574, o is NestedStructGen<Decimal>[], false);
            Eval(2575, o is NestedStructGen<Decimal>?, false);
            Eval(2576, o is NestedStructGen<Decimal>?[], false);
            Eval(2577, o is ExplicitFieldOffsetStruct, false);
            Eval(2578, o is ExplicitFieldOffsetStruct[], false);
            Eval(2579, o is ExplicitFieldOffsetStruct?, false);
            Eval(2580, o is ExplicitFieldOffsetStruct?[], false);
            Eval(2589, o is MarshalAsStruct, false);
            Eval(2590, o is MarshalAsStruct[], false);
            Eval(2591, o is MarshalAsStruct?, false);
            Eval(2592, o is MarshalAsStruct?[], false);
            Eval(2593, o is ImplementOneInterface, false);
            Eval(2594, o is ImplementOneInterface[], false);
            Eval(2595, o is ImplementOneInterface?, false);
            Eval(2596, o is ImplementOneInterface?[], false);
            Eval(2597, o is ImplementTwoInterface, false);
            Eval(2598, o is ImplementTwoInterface[], false);
            Eval(2599, o is ImplementTwoInterface?, false);
            Eval(2600, o is ImplementTwoInterface?[], false);
            Eval(2601, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(2602, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(2603, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(2604, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(2605, o is ImplementTwoInterfaceGen<int>, false);
            Eval(2606, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(2607, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(2608, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(2609, o is ImplementAllInterface<int>, false);
            Eval(2610, o is ImplementAllInterface<int>[], false);
            Eval(2611, o is ImplementAllInterface<int>?, false);
            Eval(2612, o is ImplementAllInterface<int>?[], false);
            Eval(2613, o is IntE, false);
            Eval(2614, o is IntE[], false);
            Eval(2615, o is IntE?, false);
            Eval(2616, o is IntE?[], false);
            Eval(2617, o is ByteE, false);
            Eval(2618, o is ByteE[], false);
            Eval(2619, o is ByteE?, false);
            Eval(2620, o is ByteE?[], false);
            Eval(2621, o is LongE, false);
            Eval(2622, o is LongE[], false);
            Eval(2623, o is LongE?, false);
            Eval(2624, o is LongE?[], false);
            Eval(2625, o is char, false);
            Eval(2626, o is char[], false);
            Eval(2627, o is char?, false);
            Eval(2628, o is char?[], false);
            Eval(2629, o is bool, false);
            Eval(2630, o is bool[], false);
            Eval(2631, o is bool?, false);
            Eval(2632, o is bool?[], false);
            Eval(2633, o is byte, false);
            Eval(2634, o is byte[], false);
            Eval(2635, o is byte?, false);
            Eval(2636, o is byte?[], false);
            Eval(2637, o is sbyte, false);
            Eval(2638, o is sbyte[], false);
            Eval(2639, o is sbyte?, false);
            Eval(2640, o is sbyte?[], false);
            Eval(2641, o is short, false);
            Eval(2642, o is short[], false);
            Eval(2643, o is short?, false);
            Eval(2644, o is short?[], false);
            Eval(2645, o is ushort, false);
            Eval(2646, o is ushort[], false);
            Eval(2647, o is ushort?, false);
            Eval(2648, o is ushort?[], false);
            Eval(2649, o is int, false);
            Eval(2650, o is int[], false);
            Eval(2651, o is int?, false);
            Eval(2652, o is int?[], false);
            Eval(2653, o is uint, false);
            Eval(2654, o is uint[], false);
            Eval(2655, o is uint?, false);
            Eval(2656, o is uint?[], false);
            Eval(2657, o is long, false);
            Eval(2658, o is long[], false);
            Eval(2659, o is long?, false);
            Eval(2660, o is long?[], false);
            Eval(2661, o is ulong, false);
            Eval(2662, o is ulong[], false);
            Eval(2663, o is ulong?, false);
            Eval(2664, o is ulong?[], false);
            Eval(2665, o is float, false);
            Eval(2666, o is float[], false);
            Eval(2667, o is float?, false);
            Eval(2668, o is float?[], false);
            Eval(2669, o is double, false);
            Eval(2670, o is double[], false);
            Eval(2671, o is double?, false);
            Eval(2672, o is double?[], false);
            Eval(2673, o is decimal, false);
            Eval(2674, o is decimal[], false);
            Eval(2675, o is decimal?, false);
            Eval(2676, o is decimal?[], false);
            Eval(2677, o is IntPtr, false);
            Eval(2678, o is IntPtr[], false);
            Eval(2679, o is IntPtr?, false);
            Eval(2680, o is IntPtr?[], false);
            Eval(2681, o is UIntPtr, false);
            Eval(2682, o is UIntPtr[], false);
            Eval(2683, o is UIntPtr?, false);
            Eval(2684, o is UIntPtr?[], false);
            Eval(2685, o is Guid, false);
            Eval(2686, o is Guid[], false);
            Eval(2687, o is Guid?, false);
            Eval(2688, o is Guid?[], false);
            Eval(2689, o is GCHandle, false);
            Eval(2690, o is GCHandle[], false);
            Eval(2691, o is GCHandle?, false);
            Eval(2692, o is GCHandle?[], false);
            Eval(2693, o is object, true);
            Eval(2694, o is object[], false);
            Eval(2695, o is string, false);
            Eval(2696, o is string[], false);
            Eval(2697, o is ValueType, true);
            Eval(2698, o is ValueType[], false);
            Eval(2699, o is Array, false);
            Eval(2700, o is Array[], false);
            Eval(2701, o is Enum, false);
            Eval(2702, o is Enum[], false);
            Eval(2703, o is Delegate, false);
            Eval(2704, o is Delegate[], false);
            Eval(2705, o is MulticastDelegate, false);
            Eval(2706, o is MulticastDelegate[], false);
            Eval(2707, o is IEmpty, false);
            Eval(2708, o is IEmpty[], false);
            Eval(2709, o is INotEmpty, false);
            Eval(2710, o is INotEmpty[], false);
            Eval(2711, o is IEmptyGen<int>, false);
            Eval(2712, o is IEmptyGen<int>[], false);
            Eval(2713, o is INotEmptyGen<int>, false);
            Eval(2714, o is INotEmptyGen<int>[], false);
            Eval(2715, o is SimpleDelegate, false);
            Eval(2716, o is SimpleDelegate[], false);
            Eval(2717, o is GenericDelegate<int>, false);
            Eval(2718, o is GenericDelegate<int>[], false);
            Eval(2719, o is EmptyClass, false);
            Eval(2720, o is EmptyClass[], false);
            Eval(2721, o is NotEmptyClass, false);
            Eval(2722, o is NotEmptyClass[], false);
            Eval(2723, o is EmptyClassGen<int>, false);
            Eval(2724, o is EmptyClassGen<int>[], false);
            Eval(2725, o is NotEmptyClassGen<Guid>, false);
            Eval(2726, o is NotEmptyClassGen<Guid>[], false);
            Eval(2727, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(2728, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(2729, o is NestedClass, false);
            Eval(2730, o is NestedClass[], false);
            Eval(2731, o is NestedClassGen<Decimal>, false);
            Eval(2732, o is NestedClassGen<Decimal>[], false);
            Eval(2733, o is ImplementOneInterfaceC, false);
            Eval(2734, o is ImplementOneInterfaceC[], false);
            Eval(2735, o is ImplementTwoInterfaceC, false);
            Eval(2736, o is ImplementTwoInterfaceC[], false);
            Eval(2737, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(2738, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(2739, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(2740, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(2741, o is ImplementAllInterfaceC<int>, false);
            Eval(2742, o is ImplementAllInterfaceC<int>[], false);
            Eval(2743, o is SealedClass, false);
            Eval(2744, o is SealedClass[], false);
        }
        {
            NotEmptyStructConstrainedGen<IntPtr>? v = default(NotEmptyStructConstrainedGen<IntPtr>?);
            ValueType o = v;
            Eval(2745, o is EmptyStruct, false);
            Eval(2746, o is EmptyStruct[], false);
            Eval(2747, o is EmptyStruct?, false);
            Eval(2748, o is EmptyStruct?[], false);
            Eval(2749, o is NotEmptyStruct, false);
            Eval(2750, o is NotEmptyStruct[], false);
            Eval(2751, o is NotEmptyStruct?, false);
            Eval(2752, o is NotEmptyStruct?[], false);
            Eval(2753, o is EmptyStructGen<int>, false);
            Eval(2754, o is EmptyStructGen<int>[], false);
            Eval(2755, o is EmptyStructGen<int>?, false);
            Eval(2756, o is EmptyStructGen<int>?[], false);
            Eval(2757, o is NotEmptyStructGen<Guid>, false);
            Eval(2758, o is NotEmptyStructGen<Guid>[], false);
            Eval(2759, o is NotEmptyStructGen<Guid>?, false);
            Eval(2760, o is NotEmptyStructGen<Guid>?[], false);
            Eval(2761, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(2762, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(2763, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(2764, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(2765, o is NestedStruct, false);
            Eval(2766, o is NestedStruct[], false);
            Eval(2767, o is NestedStruct?, false);
            Eval(2768, o is NestedStruct?[], false);
            Eval(2769, o is NestedStructGen<Decimal>, false);
            Eval(2770, o is NestedStructGen<Decimal>[], false);
            Eval(2771, o is NestedStructGen<Decimal>?, false);
            Eval(2772, o is NestedStructGen<Decimal>?[], false);
            Eval(2773, o is ExplicitFieldOffsetStruct, false);
            Eval(2774, o is ExplicitFieldOffsetStruct[], false);
            Eval(2775, o is ExplicitFieldOffsetStruct?, false);
            Eval(2776, o is ExplicitFieldOffsetStruct?[], false);
            Eval(2785, o is MarshalAsStruct, false);
            Eval(2786, o is MarshalAsStruct[], false);
            Eval(2787, o is MarshalAsStruct?, false);
            Eval(2788, o is MarshalAsStruct?[], false);
            Eval(2789, o is ImplementOneInterface, false);
            Eval(2790, o is ImplementOneInterface[], false);
            Eval(2791, o is ImplementOneInterface?, false);
            Eval(2792, o is ImplementOneInterface?[], false);
            Eval(2793, o is ImplementTwoInterface, false);
            Eval(2794, o is ImplementTwoInterface[], false);
            Eval(2795, o is ImplementTwoInterface?, false);
            Eval(2796, o is ImplementTwoInterface?[], false);
            Eval(2797, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(2798, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(2799, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(2800, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(2801, o is ImplementTwoInterfaceGen<int>, false);
            Eval(2802, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(2803, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(2804, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(2805, o is ImplementAllInterface<int>, false);
            Eval(2806, o is ImplementAllInterface<int>[], false);
            Eval(2807, o is ImplementAllInterface<int>?, false);
            Eval(2808, o is ImplementAllInterface<int>?[], false);
            Eval(2809, o is IntE, false);
            Eval(2810, o is IntE[], false);
            Eval(2811, o is IntE?, false);
            Eval(2812, o is IntE?[], false);
            Eval(2813, o is ByteE, false);
            Eval(2814, o is ByteE[], false);
            Eval(2815, o is ByteE?, false);
            Eval(2816, o is ByteE?[], false);
            Eval(2817, o is LongE, false);
            Eval(2818, o is LongE[], false);
            Eval(2819, o is LongE?, false);
            Eval(2820, o is LongE?[], false);
            Eval(2821, o is char, false);
            Eval(2822, o is char[], false);
            Eval(2823, o is char?, false);
            Eval(2824, o is char?[], false);
            Eval(2825, o is bool, false);
            Eval(2826, o is bool[], false);
            Eval(2827, o is bool?, false);
            Eval(2828, o is bool?[], false);
            Eval(2829, o is byte, false);
            Eval(2830, o is byte[], false);
            Eval(2831, o is byte?, false);
            Eval(2832, o is byte?[], false);
            Eval(2833, o is sbyte, false);
            Eval(2834, o is sbyte[], false);
            Eval(2835, o is sbyte?, false);
            Eval(2836, o is sbyte?[], false);
            Eval(2837, o is short, false);
            Eval(2838, o is short[], false);
            Eval(2839, o is short?, false);
            Eval(2840, o is short?[], false);
            Eval(2841, o is ushort, false);
            Eval(2842, o is ushort[], false);
            Eval(2843, o is ushort?, false);
            Eval(2844, o is ushort?[], false);
            Eval(2845, o is int, false);
            Eval(2846, o is int[], false);
            Eval(2847, o is int?, false);
            Eval(2848, o is int?[], false);
            Eval(2849, o is uint, false);
            Eval(2850, o is uint[], false);
            Eval(2851, o is uint?, false);
            Eval(2852, o is uint?[], false);
            Eval(2853, o is long, false);
            Eval(2854, o is long[], false);
            Eval(2855, o is long?, false);
            Eval(2856, o is long?[], false);
            Eval(2857, o is ulong, false);
            Eval(2858, o is ulong[], false);
            Eval(2859, o is ulong?, false);
            Eval(2860, o is ulong?[], false);
            Eval(2861, o is float, false);
            Eval(2862, o is float[], false);
            Eval(2863, o is float?, false);
            Eval(2864, o is float?[], false);
            Eval(2865, o is double, false);
            Eval(2866, o is double[], false);
            Eval(2867, o is double?, false);
            Eval(2868, o is double?[], false);
            Eval(2869, o is decimal, false);
            Eval(2870, o is decimal[], false);
            Eval(2871, o is decimal?, false);
            Eval(2872, o is decimal?[], false);
            Eval(2873, o is IntPtr, false);
            Eval(2874, o is IntPtr[], false);
            Eval(2875, o is IntPtr?, false);
            Eval(2876, o is IntPtr?[], false);
            Eval(2877, o is UIntPtr, false);
            Eval(2878, o is UIntPtr[], false);
            Eval(2879, o is UIntPtr?, false);
            Eval(2880, o is UIntPtr?[], false);
            Eval(2881, o is Guid, false);
            Eval(2882, o is Guid[], false);
            Eval(2883, o is Guid?, false);
            Eval(2884, o is Guid?[], false);
            Eval(2885, o is GCHandle, false);
            Eval(2886, o is GCHandle[], false);
            Eval(2887, o is GCHandle?, false);
            Eval(2888, o is GCHandle?[], false);
            Eval(2889, o is object, false);
            Eval(2890, o is object[], false);
            Eval(2891, o is string, false);
            Eval(2892, o is string[], false);
            Eval(2893, o is ValueType, false);
            Eval(2894, o is ValueType[], false);
            Eval(2895, o is Array, false);
            Eval(2896, o is Array[], false);
            Eval(2897, o is Enum, false);
            Eval(2898, o is Enum[], false);
            Eval(2899, o is Delegate, false);
            Eval(2900, o is Delegate[], false);
            Eval(2901, o is MulticastDelegate, false);
            Eval(2902, o is MulticastDelegate[], false);
            Eval(2903, o is IEmpty, false);
            Eval(2904, o is IEmpty[], false);
            Eval(2905, o is INotEmpty, false);
            Eval(2906, o is INotEmpty[], false);
            Eval(2907, o is IEmptyGen<int>, false);
            Eval(2908, o is IEmptyGen<int>[], false);
            Eval(2909, o is INotEmptyGen<int>, false);
            Eval(2910, o is INotEmptyGen<int>[], false);
            Eval(2911, o is SimpleDelegate, false);
            Eval(2912, o is SimpleDelegate[], false);
            Eval(2913, o is GenericDelegate<int>, false);
            Eval(2914, o is GenericDelegate<int>[], false);
            Eval(2915, o is EmptyClass, false);
            Eval(2916, o is EmptyClass[], false);
            Eval(2917, o is NotEmptyClass, false);
            Eval(2918, o is NotEmptyClass[], false);
            Eval(2919, o is EmptyClassGen<int>, false);
            Eval(2920, o is EmptyClassGen<int>[], false);
            Eval(2921, o is NotEmptyClassGen<Guid>, false);
            Eval(2922, o is NotEmptyClassGen<Guid>[], false);
            Eval(2923, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(2924, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(2925, o is NestedClass, false);
            Eval(2926, o is NestedClass[], false);
            Eval(2927, o is NestedClassGen<Decimal>, false);
            Eval(2928, o is NestedClassGen<Decimal>[], false);
            Eval(2929, o is ImplementOneInterfaceC, false);
            Eval(2930, o is ImplementOneInterfaceC[], false);
            Eval(2931, o is ImplementTwoInterfaceC, false);
            Eval(2932, o is ImplementTwoInterfaceC[], false);
            Eval(2933, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(2934, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(2935, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(2936, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(2937, o is ImplementAllInterfaceC<int>, false);
            Eval(2938, o is ImplementAllInterfaceC<int>[], false);
            Eval(2939, o is SealedClass, false);
            Eval(2940, o is SealedClass[], false);
        }
    }  // end of test case 0005
    private static void TestCase0006()
    {
        {
            NestedStruct v = default(NestedStruct);
            ValueType o = v;
            Eval(2941, o is EmptyStruct, false);
            Eval(2942, o is EmptyStruct[], false);
            Eval(2943, o is EmptyStruct?, false);
            Eval(2944, o is EmptyStruct?[], false);
            Eval(2945, o is NotEmptyStruct, false);
            Eval(2946, o is NotEmptyStruct[], false);
            Eval(2947, o is NotEmptyStruct?, false);
            Eval(2948, o is NotEmptyStruct?[], false);
            Eval(2949, o is EmptyStructGen<int>, false);
            Eval(2950, o is EmptyStructGen<int>[], false);
            Eval(2951, o is EmptyStructGen<int>?, false);
            Eval(2952, o is EmptyStructGen<int>?[], false);
            Eval(2953, o is NotEmptyStructGen<Guid>, false);
            Eval(2954, o is NotEmptyStructGen<Guid>[], false);
            Eval(2955, o is NotEmptyStructGen<Guid>?, false);
            Eval(2956, o is NotEmptyStructGen<Guid>?[], false);
            Eval(2957, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(2958, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(2959, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(2960, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(2961, o is NestedStruct, true);
            Eval(2962, o is NestedStruct[], false);
            Eval(2963, o is NestedStruct?, true);
            Eval(2964, o is NestedStruct?[], false);
            Eval(2965, o is NestedStructGen<Decimal>, false);
            Eval(2966, o is NestedStructGen<Decimal>[], false);
            Eval(2967, o is NestedStructGen<Decimal>?, false);
            Eval(2968, o is NestedStructGen<Decimal>?[], false);
            Eval(2969, o is ExplicitFieldOffsetStruct, false);
            Eval(2970, o is ExplicitFieldOffsetStruct[], false);
            Eval(2971, o is ExplicitFieldOffsetStruct?, false);
            Eval(2972, o is ExplicitFieldOffsetStruct?[], false);
            Eval(2981, o is MarshalAsStruct, false);
            Eval(2982, o is MarshalAsStruct[], false);
            Eval(2983, o is MarshalAsStruct?, false);
            Eval(2984, o is MarshalAsStruct?[], false);
            Eval(2985, o is ImplementOneInterface, false);
            Eval(2986, o is ImplementOneInterface[], false);
            Eval(2987, o is ImplementOneInterface?, false);
            Eval(2988, o is ImplementOneInterface?[], false);
            Eval(2989, o is ImplementTwoInterface, false);
            Eval(2990, o is ImplementTwoInterface[], false);
            Eval(2991, o is ImplementTwoInterface?, false);
            Eval(2992, o is ImplementTwoInterface?[], false);
            Eval(2993, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(2994, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(2995, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(2996, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(2997, o is ImplementTwoInterfaceGen<int>, false);
            Eval(2998, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(2999, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(3000, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(3001, o is ImplementAllInterface<int>, false);
            Eval(3002, o is ImplementAllInterface<int>[], false);
            Eval(3003, o is ImplementAllInterface<int>?, false);
            Eval(3004, o is ImplementAllInterface<int>?[], false);
            Eval(3005, o is IntE, false);
            Eval(3006, o is IntE[], false);
            Eval(3007, o is IntE?, false);
            Eval(3008, o is IntE?[], false);
            Eval(3009, o is ByteE, false);
            Eval(3010, o is ByteE[], false);
            Eval(3011, o is ByteE?, false);
            Eval(3012, o is ByteE?[], false);
            Eval(3013, o is LongE, false);
            Eval(3014, o is LongE[], false);
            Eval(3015, o is LongE?, false);
            Eval(3016, o is LongE?[], false);
            Eval(3017, o is char, false);
            Eval(3018, o is char[], false);
            Eval(3019, o is char?, false);
            Eval(3020, o is char?[], false);
            Eval(3021, o is bool, false);
            Eval(3022, o is bool[], false);
            Eval(3023, o is bool?, false);
            Eval(3024, o is bool?[], false);
            Eval(3025, o is byte, false);
            Eval(3026, o is byte[], false);
            Eval(3027, o is byte?, false);
            Eval(3028, o is byte?[], false);
            Eval(3029, o is sbyte, false);
            Eval(3030, o is sbyte[], false);
            Eval(3031, o is sbyte?, false);
            Eval(3032, o is sbyte?[], false);
            Eval(3033, o is short, false);
            Eval(3034, o is short[], false);
            Eval(3035, o is short?, false);
            Eval(3036, o is short?[], false);
            Eval(3037, o is ushort, false);
            Eval(3038, o is ushort[], false);
            Eval(3039, o is ushort?, false);
            Eval(3040, o is ushort?[], false);
            Eval(3041, o is int, false);
            Eval(3042, o is int[], false);
            Eval(3043, o is int?, false);
            Eval(3044, o is int?[], false);
            Eval(3045, o is uint, false);
            Eval(3046, o is uint[], false);
            Eval(3047, o is uint?, false);
            Eval(3048, o is uint?[], false);
            Eval(3049, o is long, false);
            Eval(3050, o is long[], false);
            Eval(3051, o is long?, false);
            Eval(3052, o is long?[], false);
            Eval(3053, o is ulong, false);
            Eval(3054, o is ulong[], false);
            Eval(3055, o is ulong?, false);
            Eval(3056, o is ulong?[], false);
            Eval(3057, o is float, false);
            Eval(3058, o is float[], false);
            Eval(3059, o is float?, false);
            Eval(3060, o is float?[], false);
            Eval(3061, o is double, false);
            Eval(3062, o is double[], false);
            Eval(3063, o is double?, false);
            Eval(3064, o is double?[], false);
            Eval(3065, o is decimal, false);
            Eval(3066, o is decimal[], false);
            Eval(3067, o is decimal?, false);
            Eval(3068, o is decimal?[], false);
            Eval(3069, o is IntPtr, false);
            Eval(3070, o is IntPtr[], false);
            Eval(3071, o is IntPtr?, false);
            Eval(3072, o is IntPtr?[], false);
            Eval(3073, o is UIntPtr, false);
            Eval(3074, o is UIntPtr[], false);
            Eval(3075, o is UIntPtr?, false);
            Eval(3076, o is UIntPtr?[], false);
            Eval(3077, o is Guid, false);
            Eval(3078, o is Guid[], false);
            Eval(3079, o is Guid?, false);
            Eval(3080, o is Guid?[], false);
            Eval(3081, o is GCHandle, false);
            Eval(3082, o is GCHandle[], false);
            Eval(3083, o is GCHandle?, false);
            Eval(3084, o is GCHandle?[], false);
            Eval(3085, o is object, true);
            Eval(3086, o is object[], false);
            Eval(3087, o is string, false);
            Eval(3088, o is string[], false);
            Eval(3089, o is ValueType, true);
            Eval(3090, o is ValueType[], false);
            Eval(3091, o is Array, false);
            Eval(3092, o is Array[], false);
            Eval(3093, o is Enum, false);
            Eval(3094, o is Enum[], false);
            Eval(3095, o is Delegate, false);
            Eval(3096, o is Delegate[], false);
            Eval(3097, o is MulticastDelegate, false);
            Eval(3098, o is MulticastDelegate[], false);
            Eval(3099, o is IEmpty, false);
            Eval(3100, o is IEmpty[], false);
            Eval(3101, o is INotEmpty, false);
            Eval(3102, o is INotEmpty[], false);
            Eval(3103, o is IEmptyGen<int>, false);
            Eval(3104, o is IEmptyGen<int>[], false);
            Eval(3105, o is INotEmptyGen<int>, false);
            Eval(3106, o is INotEmptyGen<int>[], false);
            Eval(3107, o is SimpleDelegate, false);
            Eval(3108, o is SimpleDelegate[], false);
            Eval(3109, o is GenericDelegate<int>, false);
            Eval(3110, o is GenericDelegate<int>[], false);
            Eval(3111, o is EmptyClass, false);
            Eval(3112, o is EmptyClass[], false);
            Eval(3113, o is NotEmptyClass, false);
            Eval(3114, o is NotEmptyClass[], false);
            Eval(3115, o is EmptyClassGen<int>, false);
            Eval(3116, o is EmptyClassGen<int>[], false);
            Eval(3117, o is NotEmptyClassGen<Guid>, false);
            Eval(3118, o is NotEmptyClassGen<Guid>[], false);
            Eval(3119, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(3120, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(3121, o is NestedClass, false);
            Eval(3122, o is NestedClass[], false);
            Eval(3123, o is NestedClassGen<Decimal>, false);
            Eval(3124, o is NestedClassGen<Decimal>[], false);
            Eval(3125, o is ImplementOneInterfaceC, false);
            Eval(3126, o is ImplementOneInterfaceC[], false);
            Eval(3127, o is ImplementTwoInterfaceC, false);
            Eval(3128, o is ImplementTwoInterfaceC[], false);
            Eval(3129, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(3130, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(3131, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(3132, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(3133, o is ImplementAllInterfaceC<int>, false);
            Eval(3134, o is ImplementAllInterfaceC<int>[], false);
            Eval(3135, o is SealedClass, false);
            Eval(3136, o is SealedClass[], false);
        }
        {
            NestedStruct? v = default(NestedStruct);
            ValueType o = v;
            Eval(3137, o is EmptyStruct, false);
            Eval(3138, o is EmptyStruct[], false);
            Eval(3139, o is EmptyStruct?, false);
            Eval(3140, o is EmptyStruct?[], false);
            Eval(3141, o is NotEmptyStruct, false);
            Eval(3142, o is NotEmptyStruct[], false);
            Eval(3143, o is NotEmptyStruct?, false);
            Eval(3144, o is NotEmptyStruct?[], false);
            Eval(3145, o is EmptyStructGen<int>, false);
            Eval(3146, o is EmptyStructGen<int>[], false);
            Eval(3147, o is EmptyStructGen<int>?, false);
            Eval(3148, o is EmptyStructGen<int>?[], false);
            Eval(3149, o is NotEmptyStructGen<Guid>, false);
            Eval(3150, o is NotEmptyStructGen<Guid>[], false);
            Eval(3151, o is NotEmptyStructGen<Guid>?, false);
            Eval(3152, o is NotEmptyStructGen<Guid>?[], false);
            Eval(3153, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(3154, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(3155, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(3156, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(3157, o is NestedStruct, true);
            Eval(3158, o is NestedStruct[], false);
            Eval(3159, o is NestedStruct?, true);
            Eval(3160, o is NestedStruct?[], false);
            Eval(3161, o is NestedStructGen<Decimal>, false);
            Eval(3162, o is NestedStructGen<Decimal>[], false);
            Eval(3163, o is NestedStructGen<Decimal>?, false);
            Eval(3164, o is NestedStructGen<Decimal>?[], false);
            Eval(3165, o is ExplicitFieldOffsetStruct, false);
            Eval(3166, o is ExplicitFieldOffsetStruct[], false);
            Eval(3167, o is ExplicitFieldOffsetStruct?, false);
            Eval(3168, o is ExplicitFieldOffsetStruct?[], false);
            Eval(3177, o is MarshalAsStruct, false);
            Eval(3178, o is MarshalAsStruct[], false);
            Eval(3179, o is MarshalAsStruct?, false);
            Eval(3180, o is MarshalAsStruct?[], false);
            Eval(3181, o is ImplementOneInterface, false);
            Eval(3182, o is ImplementOneInterface[], false);
            Eval(3183, o is ImplementOneInterface?, false);
            Eval(3184, o is ImplementOneInterface?[], false);
            Eval(3185, o is ImplementTwoInterface, false);
            Eval(3186, o is ImplementTwoInterface[], false);
            Eval(3187, o is ImplementTwoInterface?, false);
            Eval(3188, o is ImplementTwoInterface?[], false);
            Eval(3189, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(3190, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(3191, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(3192, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(3193, o is ImplementTwoInterfaceGen<int>, false);
            Eval(3194, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(3195, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(3196, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(3197, o is ImplementAllInterface<int>, false);
            Eval(3198, o is ImplementAllInterface<int>[], false);
            Eval(3199, o is ImplementAllInterface<int>?, false);
            Eval(3200, o is ImplementAllInterface<int>?[], false);
            Eval(3201, o is IntE, false);
            Eval(3202, o is IntE[], false);
            Eval(3203, o is IntE?, false);
            Eval(3204, o is IntE?[], false);
            Eval(3205, o is ByteE, false);
            Eval(3206, o is ByteE[], false);
            Eval(3207, o is ByteE?, false);
            Eval(3208, o is ByteE?[], false);
            Eval(3209, o is LongE, false);
            Eval(3210, o is LongE[], false);
            Eval(3211, o is LongE?, false);
            Eval(3212, o is LongE?[], false);
            Eval(3213, o is char, false);
            Eval(3214, o is char[], false);
            Eval(3215, o is char?, false);
            Eval(3216, o is char?[], false);
            Eval(3217, o is bool, false);
            Eval(3218, o is bool[], false);
            Eval(3219, o is bool?, false);
            Eval(3220, o is bool?[], false);
            Eval(3221, o is byte, false);
            Eval(3222, o is byte[], false);
            Eval(3223, o is byte?, false);
            Eval(3224, o is byte?[], false);
            Eval(3225, o is sbyte, false);
            Eval(3226, o is sbyte[], false);
            Eval(3227, o is sbyte?, false);
            Eval(3228, o is sbyte?[], false);
            Eval(3229, o is short, false);
            Eval(3230, o is short[], false);
            Eval(3231, o is short?, false);
            Eval(3232, o is short?[], false);
            Eval(3233, o is ushort, false);
            Eval(3234, o is ushort[], false);
            Eval(3235, o is ushort?, false);
            Eval(3236, o is ushort?[], false);
            Eval(3237, o is int, false);
            Eval(3238, o is int[], false);
            Eval(3239, o is int?, false);
            Eval(3240, o is int?[], false);
            Eval(3241, o is uint, false);
            Eval(3242, o is uint[], false);
            Eval(3243, o is uint?, false);
            Eval(3244, o is uint?[], false);
            Eval(3245, o is long, false);
            Eval(3246, o is long[], false);
            Eval(3247, o is long?, false);
            Eval(3248, o is long?[], false);
            Eval(3249, o is ulong, false);
            Eval(3250, o is ulong[], false);
            Eval(3251, o is ulong?, false);
            Eval(3252, o is ulong?[], false);
            Eval(3253, o is float, false);
            Eval(3254, o is float[], false);
            Eval(3255, o is float?, false);
            Eval(3256, o is float?[], false);
            Eval(3257, o is double, false);
            Eval(3258, o is double[], false);
            Eval(3259, o is double?, false);
            Eval(3260, o is double?[], false);
            Eval(3261, o is decimal, false);
            Eval(3262, o is decimal[], false);
            Eval(3263, o is decimal?, false);
            Eval(3264, o is decimal?[], false);
            Eval(3265, o is IntPtr, false);
            Eval(3266, o is IntPtr[], false);
            Eval(3267, o is IntPtr?, false);
            Eval(3268, o is IntPtr?[], false);
            Eval(3269, o is UIntPtr, false);
            Eval(3270, o is UIntPtr[], false);
            Eval(3271, o is UIntPtr?, false);
            Eval(3272, o is UIntPtr?[], false);
            Eval(3273, o is Guid, false);
            Eval(3274, o is Guid[], false);
            Eval(3275, o is Guid?, false);
            Eval(3276, o is Guid?[], false);
            Eval(3277, o is GCHandle, false);
            Eval(3278, o is GCHandle[], false);
            Eval(3279, o is GCHandle?, false);
            Eval(3280, o is GCHandle?[], false);
            Eval(3281, o is object, true);
            Eval(3282, o is object[], false);
            Eval(3283, o is string, false);
            Eval(3284, o is string[], false);
            Eval(3285, o is ValueType, true);
            Eval(3286, o is ValueType[], false);
            Eval(3287, o is Array, false);
            Eval(3288, o is Array[], false);
            Eval(3289, o is Enum, false);
            Eval(3290, o is Enum[], false);
            Eval(3291, o is Delegate, false);
            Eval(3292, o is Delegate[], false);
            Eval(3293, o is MulticastDelegate, false);
            Eval(3294, o is MulticastDelegate[], false);
            Eval(3295, o is IEmpty, false);
            Eval(3296, o is IEmpty[], false);
            Eval(3297, o is INotEmpty, false);
            Eval(3298, o is INotEmpty[], false);
            Eval(3299, o is IEmptyGen<int>, false);
            Eval(3300, o is IEmptyGen<int>[], false);
            Eval(3301, o is INotEmptyGen<int>, false);
            Eval(3302, o is INotEmptyGen<int>[], false);
            Eval(3303, o is SimpleDelegate, false);
            Eval(3304, o is SimpleDelegate[], false);
            Eval(3305, o is GenericDelegate<int>, false);
            Eval(3306, o is GenericDelegate<int>[], false);
            Eval(3307, o is EmptyClass, false);
            Eval(3308, o is EmptyClass[], false);
            Eval(3309, o is NotEmptyClass, false);
            Eval(3310, o is NotEmptyClass[], false);
            Eval(3311, o is EmptyClassGen<int>, false);
            Eval(3312, o is EmptyClassGen<int>[], false);
            Eval(3313, o is NotEmptyClassGen<Guid>, false);
            Eval(3314, o is NotEmptyClassGen<Guid>[], false);
            Eval(3315, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(3316, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(3317, o is NestedClass, false);
            Eval(3318, o is NestedClass[], false);
            Eval(3319, o is NestedClassGen<Decimal>, false);
            Eval(3320, o is NestedClassGen<Decimal>[], false);
            Eval(3321, o is ImplementOneInterfaceC, false);
            Eval(3322, o is ImplementOneInterfaceC[], false);
            Eval(3323, o is ImplementTwoInterfaceC, false);
            Eval(3324, o is ImplementTwoInterfaceC[], false);
            Eval(3325, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(3326, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(3327, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(3328, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(3329, o is ImplementAllInterfaceC<int>, false);
            Eval(3330, o is ImplementAllInterfaceC<int>[], false);
            Eval(3331, o is SealedClass, false);
            Eval(3332, o is SealedClass[], false);
        }
        {
            NestedStruct? v = default(NestedStruct?);
            ValueType o = v;
            Eval(3333, o is EmptyStruct, false);
            Eval(3334, o is EmptyStruct[], false);
            Eval(3335, o is EmptyStruct?, false);
            Eval(3336, o is EmptyStruct?[], false);
            Eval(3337, o is NotEmptyStruct, false);
            Eval(3338, o is NotEmptyStruct[], false);
            Eval(3339, o is NotEmptyStruct?, false);
            Eval(3340, o is NotEmptyStruct?[], false);
            Eval(3341, o is EmptyStructGen<int>, false);
            Eval(3342, o is EmptyStructGen<int>[], false);
            Eval(3343, o is EmptyStructGen<int>?, false);
            Eval(3344, o is EmptyStructGen<int>?[], false);
            Eval(3345, o is NotEmptyStructGen<Guid>, false);
            Eval(3346, o is NotEmptyStructGen<Guid>[], false);
            Eval(3347, o is NotEmptyStructGen<Guid>?, false);
            Eval(3348, o is NotEmptyStructGen<Guid>?[], false);
            Eval(3349, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(3350, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(3351, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(3352, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(3353, o is NestedStruct, false);
            Eval(3354, o is NestedStruct[], false);
            Eval(3355, o is NestedStruct?, false);
            Eval(3356, o is NestedStruct?[], false);
            Eval(3357, o is NestedStructGen<Decimal>, false);
            Eval(3358, o is NestedStructGen<Decimal>[], false);
            Eval(3359, o is NestedStructGen<Decimal>?, false);
            Eval(3360, o is NestedStructGen<Decimal>?[], false);
            Eval(3361, o is ExplicitFieldOffsetStruct, false);
            Eval(3362, o is ExplicitFieldOffsetStruct[], false);
            Eval(3363, o is ExplicitFieldOffsetStruct?, false);
            Eval(3364, o is ExplicitFieldOffsetStruct?[], false);
            Eval(3373, o is MarshalAsStruct, false);
            Eval(3374, o is MarshalAsStruct[], false);
            Eval(3375, o is MarshalAsStruct?, false);
            Eval(3376, o is MarshalAsStruct?[], false);
            Eval(3377, o is ImplementOneInterface, false);
            Eval(3378, o is ImplementOneInterface[], false);
            Eval(3379, o is ImplementOneInterface?, false);
            Eval(3380, o is ImplementOneInterface?[], false);
            Eval(3381, o is ImplementTwoInterface, false);
            Eval(3382, o is ImplementTwoInterface[], false);
            Eval(3383, o is ImplementTwoInterface?, false);
            Eval(3384, o is ImplementTwoInterface?[], false);
            Eval(3385, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(3386, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(3387, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(3388, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(3389, o is ImplementTwoInterfaceGen<int>, false);
            Eval(3390, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(3391, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(3392, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(3393, o is ImplementAllInterface<int>, false);
            Eval(3394, o is ImplementAllInterface<int>[], false);
            Eval(3395, o is ImplementAllInterface<int>?, false);
            Eval(3396, o is ImplementAllInterface<int>?[], false);
            Eval(3397, o is IntE, false);
            Eval(3398, o is IntE[], false);
            Eval(3399, o is IntE?, false);
            Eval(3400, o is IntE?[], false);
            Eval(3401, o is ByteE, false);
            Eval(3402, o is ByteE[], false);
            Eval(3403, o is ByteE?, false);
            Eval(3404, o is ByteE?[], false);
            Eval(3405, o is LongE, false);
            Eval(3406, o is LongE[], false);
            Eval(3407, o is LongE?, false);
            Eval(3408, o is LongE?[], false);
            Eval(3409, o is char, false);
            Eval(3410, o is char[], false);
            Eval(3411, o is char?, false);
            Eval(3412, o is char?[], false);
            Eval(3413, o is bool, false);
            Eval(3414, o is bool[], false);
            Eval(3415, o is bool?, false);
            Eval(3416, o is bool?[], false);
            Eval(3417, o is byte, false);
            Eval(3418, o is byte[], false);
            Eval(3419, o is byte?, false);
            Eval(3420, o is byte?[], false);
            Eval(3421, o is sbyte, false);
            Eval(3422, o is sbyte[], false);
            Eval(3423, o is sbyte?, false);
            Eval(3424, o is sbyte?[], false);
            Eval(3425, o is short, false);
            Eval(3426, o is short[], false);
            Eval(3427, o is short?, false);
            Eval(3428, o is short?[], false);
            Eval(3429, o is ushort, false);
            Eval(3430, o is ushort[], false);
            Eval(3431, o is ushort?, false);
            Eval(3432, o is ushort?[], false);
            Eval(3433, o is int, false);
            Eval(3434, o is int[], false);
            Eval(3435, o is int?, false);
            Eval(3436, o is int?[], false);
            Eval(3437, o is uint, false);
            Eval(3438, o is uint[], false);
            Eval(3439, o is uint?, false);
            Eval(3440, o is uint?[], false);
            Eval(3441, o is long, false);
            Eval(3442, o is long[], false);
            Eval(3443, o is long?, false);
            Eval(3444, o is long?[], false);
            Eval(3445, o is ulong, false);
            Eval(3446, o is ulong[], false);
            Eval(3447, o is ulong?, false);
            Eval(3448, o is ulong?[], false);
            Eval(3449, o is float, false);
            Eval(3450, o is float[], false);
            Eval(3451, o is float?, false);
            Eval(3452, o is float?[], false);
            Eval(3453, o is double, false);
            Eval(3454, o is double[], false);
            Eval(3455, o is double?, false);
            Eval(3456, o is double?[], false);
            Eval(3457, o is decimal, false);
            Eval(3458, o is decimal[], false);
            Eval(3459, o is decimal?, false);
            Eval(3460, o is decimal?[], false);
            Eval(3461, o is IntPtr, false);
            Eval(3462, o is IntPtr[], false);
            Eval(3463, o is IntPtr?, false);
            Eval(3464, o is IntPtr?[], false);
            Eval(3465, o is UIntPtr, false);
            Eval(3466, o is UIntPtr[], false);
            Eval(3467, o is UIntPtr?, false);
            Eval(3468, o is UIntPtr?[], false);
            Eval(3469, o is Guid, false);
            Eval(3470, o is Guid[], false);
            Eval(3471, o is Guid?, false);
            Eval(3472, o is Guid?[], false);
            Eval(3473, o is GCHandle, false);
            Eval(3474, o is GCHandle[], false);
            Eval(3475, o is GCHandle?, false);
            Eval(3476, o is GCHandle?[], false);
            Eval(3477, o is object, false);
            Eval(3478, o is object[], false);
            Eval(3479, o is string, false);
            Eval(3480, o is string[], false);
            Eval(3481, o is ValueType, false);
            Eval(3482, o is ValueType[], false);
            Eval(3483, o is Array, false);
            Eval(3484, o is Array[], false);
            Eval(3485, o is Enum, false);
            Eval(3486, o is Enum[], false);
            Eval(3487, o is Delegate, false);
            Eval(3488, o is Delegate[], false);
            Eval(3489, o is MulticastDelegate, false);
            Eval(3490, o is MulticastDelegate[], false);
            Eval(3491, o is IEmpty, false);
            Eval(3492, o is IEmpty[], false);
            Eval(3493, o is INotEmpty, false);
            Eval(3494, o is INotEmpty[], false);
            Eval(3495, o is IEmptyGen<int>, false);
            Eval(3496, o is IEmptyGen<int>[], false);
            Eval(3497, o is INotEmptyGen<int>, false);
            Eval(3498, o is INotEmptyGen<int>[], false);
            Eval(3499, o is SimpleDelegate, false);
            Eval(3500, o is SimpleDelegate[], false);
            Eval(3501, o is GenericDelegate<int>, false);
            Eval(3502, o is GenericDelegate<int>[], false);
            Eval(3503, o is EmptyClass, false);
            Eval(3504, o is EmptyClass[], false);
            Eval(3505, o is NotEmptyClass, false);
            Eval(3506, o is NotEmptyClass[], false);
            Eval(3507, o is EmptyClassGen<int>, false);
            Eval(3508, o is EmptyClassGen<int>[], false);
            Eval(3509, o is NotEmptyClassGen<Guid>, false);
            Eval(3510, o is NotEmptyClassGen<Guid>[], false);
            Eval(3511, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(3512, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(3513, o is NestedClass, false);
            Eval(3514, o is NestedClass[], false);
            Eval(3515, o is NestedClassGen<Decimal>, false);
            Eval(3516, o is NestedClassGen<Decimal>[], false);
            Eval(3517, o is ImplementOneInterfaceC, false);
            Eval(3518, o is ImplementOneInterfaceC[], false);
            Eval(3519, o is ImplementTwoInterfaceC, false);
            Eval(3520, o is ImplementTwoInterfaceC[], false);
            Eval(3521, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(3522, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(3523, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(3524, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(3525, o is ImplementAllInterfaceC<int>, false);
            Eval(3526, o is ImplementAllInterfaceC<int>[], false);
            Eval(3527, o is SealedClass, false);
            Eval(3528, o is SealedClass[], false);
        }
    }  // end of test case 0006
    private static void TestCase0007()
    {
        {
            NestedStructGen<Decimal> v = default(NestedStructGen<Decimal>);
            ValueType o = v;
            Eval(3529, o is EmptyStruct, false);
            Eval(3530, o is EmptyStruct[], false);
            Eval(3531, o is EmptyStruct?, false);
            Eval(3532, o is EmptyStruct?[], false);
            Eval(3533, o is NotEmptyStruct, false);
            Eval(3534, o is NotEmptyStruct[], false);
            Eval(3535, o is NotEmptyStruct?, false);
            Eval(3536, o is NotEmptyStruct?[], false);
            Eval(3537, o is EmptyStructGen<int>, false);
            Eval(3538, o is EmptyStructGen<int>[], false);
            Eval(3539, o is EmptyStructGen<int>?, false);
            Eval(3540, o is EmptyStructGen<int>?[], false);
            Eval(3541, o is NotEmptyStructGen<Guid>, false);
            Eval(3542, o is NotEmptyStructGen<Guid>[], false);
            Eval(3543, o is NotEmptyStructGen<Guid>?, false);
            Eval(3544, o is NotEmptyStructGen<Guid>?[], false);
            Eval(3545, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(3546, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(3547, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(3548, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(3549, o is NestedStruct, false);
            Eval(3550, o is NestedStruct[], false);
            Eval(3551, o is NestedStruct?, false);
            Eval(3552, o is NestedStruct?[], false);
            Eval(3553, o is NestedStructGen<Decimal>, true);
            Eval(3554, o is NestedStructGen<Decimal>[], false);
            Eval(3555, o is NestedStructGen<Decimal>?, true);
            Eval(3556, o is NestedStructGen<Decimal>?[], false);
            Eval(3557, o is ExplicitFieldOffsetStruct, false);
            Eval(3558, o is ExplicitFieldOffsetStruct[], false);
            Eval(3559, o is ExplicitFieldOffsetStruct?, false);
            Eval(3560, o is ExplicitFieldOffsetStruct?[], false);
            Eval(3569, o is MarshalAsStruct, false);
            Eval(3570, o is MarshalAsStruct[], false);
            Eval(3571, o is MarshalAsStruct?, false);
            Eval(3572, o is MarshalAsStruct?[], false);
            Eval(3573, o is ImplementOneInterface, false);
            Eval(3574, o is ImplementOneInterface[], false);
            Eval(3575, o is ImplementOneInterface?, false);
            Eval(3576, o is ImplementOneInterface?[], false);
            Eval(3577, o is ImplementTwoInterface, false);
            Eval(3578, o is ImplementTwoInterface[], false);
            Eval(3579, o is ImplementTwoInterface?, false);
            Eval(3580, o is ImplementTwoInterface?[], false);
            Eval(3581, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(3582, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(3583, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(3584, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(3585, o is ImplementTwoInterfaceGen<int>, false);
            Eval(3586, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(3587, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(3588, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(3589, o is ImplementAllInterface<int>, false);
            Eval(3590, o is ImplementAllInterface<int>[], false);
            Eval(3591, o is ImplementAllInterface<int>?, false);
            Eval(3592, o is ImplementAllInterface<int>?[], false);
            Eval(3593, o is IntE, false);
            Eval(3594, o is IntE[], false);
            Eval(3595, o is IntE?, false);
            Eval(3596, o is IntE?[], false);
            Eval(3597, o is ByteE, false);
            Eval(3598, o is ByteE[], false);
            Eval(3599, o is ByteE?, false);
            Eval(3600, o is ByteE?[], false);
            Eval(3601, o is LongE, false);
            Eval(3602, o is LongE[], false);
            Eval(3603, o is LongE?, false);
            Eval(3604, o is LongE?[], false);
            Eval(3605, o is char, false);
            Eval(3606, o is char[], false);
            Eval(3607, o is char?, false);
            Eval(3608, o is char?[], false);
            Eval(3609, o is bool, false);
            Eval(3610, o is bool[], false);
            Eval(3611, o is bool?, false);
            Eval(3612, o is bool?[], false);
            Eval(3613, o is byte, false);
            Eval(3614, o is byte[], false);
            Eval(3615, o is byte?, false);
            Eval(3616, o is byte?[], false);
            Eval(3617, o is sbyte, false);
            Eval(3618, o is sbyte[], false);
            Eval(3619, o is sbyte?, false);
            Eval(3620, o is sbyte?[], false);
            Eval(3621, o is short, false);
            Eval(3622, o is short[], false);
            Eval(3623, o is short?, false);
            Eval(3624, o is short?[], false);
            Eval(3625, o is ushort, false);
            Eval(3626, o is ushort[], false);
            Eval(3627, o is ushort?, false);
            Eval(3628, o is ushort?[], false);
            Eval(3629, o is int, false);
            Eval(3630, o is int[], false);
            Eval(3631, o is int?, false);
            Eval(3632, o is int?[], false);
            Eval(3633, o is uint, false);
            Eval(3634, o is uint[], false);
            Eval(3635, o is uint?, false);
            Eval(3636, o is uint?[], false);
            Eval(3637, o is long, false);
            Eval(3638, o is long[], false);
            Eval(3639, o is long?, false);
            Eval(3640, o is long?[], false);
            Eval(3641, o is ulong, false);
            Eval(3642, o is ulong[], false);
            Eval(3643, o is ulong?, false);
            Eval(3644, o is ulong?[], false);
            Eval(3645, o is float, false);
            Eval(3646, o is float[], false);
            Eval(3647, o is float?, false);
            Eval(3648, o is float?[], false);
            Eval(3649, o is double, false);
            Eval(3650, o is double[], false);
            Eval(3651, o is double?, false);
            Eval(3652, o is double?[], false);
            Eval(3653, o is decimal, false);
            Eval(3654, o is decimal[], false);
            Eval(3655, o is decimal?, false);
            Eval(3656, o is decimal?[], false);
            Eval(3657, o is IntPtr, false);
            Eval(3658, o is IntPtr[], false);
            Eval(3659, o is IntPtr?, false);
            Eval(3660, o is IntPtr?[], false);
            Eval(3661, o is UIntPtr, false);
            Eval(3662, o is UIntPtr[], false);
            Eval(3663, o is UIntPtr?, false);
            Eval(3664, o is UIntPtr?[], false);
            Eval(3665, o is Guid, false);
            Eval(3666, o is Guid[], false);
            Eval(3667, o is Guid?, false);
            Eval(3668, o is Guid?[], false);
            Eval(3669, o is GCHandle, false);
            Eval(3670, o is GCHandle[], false);
            Eval(3671, o is GCHandle?, false);
            Eval(3672, o is GCHandle?[], false);
            Eval(3673, o is object, true);
            Eval(3674, o is object[], false);
            Eval(3675, o is string, false);
            Eval(3676, o is string[], false);
            Eval(3677, o is ValueType, true);
            Eval(3678, o is ValueType[], false);
            Eval(3679, o is Array, false);
            Eval(3680, o is Array[], false);
            Eval(3681, o is Enum, false);
            Eval(3682, o is Enum[], false);
            Eval(3683, o is Delegate, false);
            Eval(3684, o is Delegate[], false);
            Eval(3685, o is MulticastDelegate, false);
            Eval(3686, o is MulticastDelegate[], false);
            Eval(3687, o is IEmpty, false);
            Eval(3688, o is IEmpty[], false);
            Eval(3689, o is INotEmpty, false);
            Eval(3690, o is INotEmpty[], false);
            Eval(3691, o is IEmptyGen<int>, false);
            Eval(3692, o is IEmptyGen<int>[], false);
            Eval(3693, o is INotEmptyGen<int>, false);
            Eval(3694, o is INotEmptyGen<int>[], false);
            Eval(3695, o is SimpleDelegate, false);
            Eval(3696, o is SimpleDelegate[], false);
            Eval(3697, o is GenericDelegate<int>, false);
            Eval(3698, o is GenericDelegate<int>[], false);
            Eval(3699, o is EmptyClass, false);
            Eval(3700, o is EmptyClass[], false);
            Eval(3701, o is NotEmptyClass, false);
            Eval(3702, o is NotEmptyClass[], false);
            Eval(3703, o is EmptyClassGen<int>, false);
            Eval(3704, o is EmptyClassGen<int>[], false);
            Eval(3705, o is NotEmptyClassGen<Guid>, false);
            Eval(3706, o is NotEmptyClassGen<Guid>[], false);
            Eval(3707, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(3708, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(3709, o is NestedClass, false);
            Eval(3710, o is NestedClass[], false);
            Eval(3711, o is NestedClassGen<Decimal>, false);
            Eval(3712, o is NestedClassGen<Decimal>[], false);
            Eval(3713, o is ImplementOneInterfaceC, false);
            Eval(3714, o is ImplementOneInterfaceC[], false);
            Eval(3715, o is ImplementTwoInterfaceC, false);
            Eval(3716, o is ImplementTwoInterfaceC[], false);
            Eval(3717, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(3718, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(3719, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(3720, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(3721, o is ImplementAllInterfaceC<int>, false);
            Eval(3722, o is ImplementAllInterfaceC<int>[], false);
            Eval(3723, o is SealedClass, false);
            Eval(3724, o is SealedClass[], false);
        }
        {
            NestedStructGen<Decimal>? v = default(NestedStructGen<Decimal>);
            ValueType o = v;
            Eval(3725, o is EmptyStruct, false);
            Eval(3726, o is EmptyStruct[], false);
            Eval(3727, o is EmptyStruct?, false);
            Eval(3728, o is EmptyStruct?[], false);
            Eval(3729, o is NotEmptyStruct, false);
            Eval(3730, o is NotEmptyStruct[], false);
            Eval(3731, o is NotEmptyStruct?, false);
            Eval(3732, o is NotEmptyStruct?[], false);
            Eval(3733, o is EmptyStructGen<int>, false);
            Eval(3734, o is EmptyStructGen<int>[], false);
            Eval(3735, o is EmptyStructGen<int>?, false);
            Eval(3736, o is EmptyStructGen<int>?[], false);
            Eval(3737, o is NotEmptyStructGen<Guid>, false);
            Eval(3738, o is NotEmptyStructGen<Guid>[], false);
            Eval(3739, o is NotEmptyStructGen<Guid>?, false);
            Eval(3740, o is NotEmptyStructGen<Guid>?[], false);
            Eval(3741, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(3742, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(3743, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(3744, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(3745, o is NestedStruct, false);
            Eval(3746, o is NestedStruct[], false);
            Eval(3747, o is NestedStruct?, false);
            Eval(3748, o is NestedStruct?[], false);
            Eval(3749, o is NestedStructGen<Decimal>, true);
            Eval(3750, o is NestedStructGen<Decimal>[], false);
            Eval(3751, o is NestedStructGen<Decimal>?, true);
            Eval(3752, o is NestedStructGen<Decimal>?[], false);
            Eval(3753, o is ExplicitFieldOffsetStruct, false);
            Eval(3754, o is ExplicitFieldOffsetStruct[], false);
            Eval(3755, o is ExplicitFieldOffsetStruct?, false);
            Eval(3756, o is ExplicitFieldOffsetStruct?[], false);
            Eval(3765, o is MarshalAsStruct, false);
            Eval(3766, o is MarshalAsStruct[], false);
            Eval(3767, o is MarshalAsStruct?, false);
            Eval(3768, o is MarshalAsStruct?[], false);
            Eval(3769, o is ImplementOneInterface, false);
            Eval(3770, o is ImplementOneInterface[], false);
            Eval(3771, o is ImplementOneInterface?, false);
            Eval(3772, o is ImplementOneInterface?[], false);
            Eval(3773, o is ImplementTwoInterface, false);
            Eval(3774, o is ImplementTwoInterface[], false);
            Eval(3775, o is ImplementTwoInterface?, false);
            Eval(3776, o is ImplementTwoInterface?[], false);
            Eval(3777, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(3778, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(3779, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(3780, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(3781, o is ImplementTwoInterfaceGen<int>, false);
            Eval(3782, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(3783, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(3784, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(3785, o is ImplementAllInterface<int>, false);
            Eval(3786, o is ImplementAllInterface<int>[], false);
            Eval(3787, o is ImplementAllInterface<int>?, false);
            Eval(3788, o is ImplementAllInterface<int>?[], false);
            Eval(3789, o is IntE, false);
            Eval(3790, o is IntE[], false);
            Eval(3791, o is IntE?, false);
            Eval(3792, o is IntE?[], false);
            Eval(3793, o is ByteE, false);
            Eval(3794, o is ByteE[], false);
            Eval(3795, o is ByteE?, false);
            Eval(3796, o is ByteE?[], false);
            Eval(3797, o is LongE, false);
            Eval(3798, o is LongE[], false);
            Eval(3799, o is LongE?, false);
            Eval(3800, o is LongE?[], false);
            Eval(3801, o is char, false);
            Eval(3802, o is char[], false);
            Eval(3803, o is char?, false);
            Eval(3804, o is char?[], false);
            Eval(3805, o is bool, false);
            Eval(3806, o is bool[], false);
            Eval(3807, o is bool?, false);
            Eval(3808, o is bool?[], false);
            Eval(3809, o is byte, false);
            Eval(3810, o is byte[], false);
            Eval(3811, o is byte?, false);
            Eval(3812, o is byte?[], false);
            Eval(3813, o is sbyte, false);
            Eval(3814, o is sbyte[], false);
            Eval(3815, o is sbyte?, false);
            Eval(3816, o is sbyte?[], false);
            Eval(3817, o is short, false);
            Eval(3818, o is short[], false);
            Eval(3819, o is short?, false);
            Eval(3820, o is short?[], false);
            Eval(3821, o is ushort, false);
            Eval(3822, o is ushort[], false);
            Eval(3823, o is ushort?, false);
            Eval(3824, o is ushort?[], false);
            Eval(3825, o is int, false);
            Eval(3826, o is int[], false);
            Eval(3827, o is int?, false);
            Eval(3828, o is int?[], false);
            Eval(3829, o is uint, false);
            Eval(3830, o is uint[], false);
            Eval(3831, o is uint?, false);
            Eval(3832, o is uint?[], false);
            Eval(3833, o is long, false);
            Eval(3834, o is long[], false);
            Eval(3835, o is long?, false);
            Eval(3836, o is long?[], false);
            Eval(3837, o is ulong, false);
            Eval(3838, o is ulong[], false);
            Eval(3839, o is ulong?, false);
            Eval(3840, o is ulong?[], false);
            Eval(3841, o is float, false);
            Eval(3842, o is float[], false);
            Eval(3843, o is float?, false);
            Eval(3844, o is float?[], false);
            Eval(3845, o is double, false);
            Eval(3846, o is double[], false);
            Eval(3847, o is double?, false);
            Eval(3848, o is double?[], false);
            Eval(3849, o is decimal, false);
            Eval(3850, o is decimal[], false);
            Eval(3851, o is decimal?, false);
            Eval(3852, o is decimal?[], false);
            Eval(3853, o is IntPtr, false);
            Eval(3854, o is IntPtr[], false);
            Eval(3855, o is IntPtr?, false);
            Eval(3856, o is IntPtr?[], false);
            Eval(3857, o is UIntPtr, false);
            Eval(3858, o is UIntPtr[], false);
            Eval(3859, o is UIntPtr?, false);
            Eval(3860, o is UIntPtr?[], false);
            Eval(3861, o is Guid, false);
            Eval(3862, o is Guid[], false);
            Eval(3863, o is Guid?, false);
            Eval(3864, o is Guid?[], false);
            Eval(3865, o is GCHandle, false);
            Eval(3866, o is GCHandle[], false);
            Eval(3867, o is GCHandle?, false);
            Eval(3868, o is GCHandle?[], false);
            Eval(3869, o is object, true);
            Eval(3870, o is object[], false);
            Eval(3871, o is string, false);
            Eval(3872, o is string[], false);
            Eval(3873, o is ValueType, true);
            Eval(3874, o is ValueType[], false);
            Eval(3875, o is Array, false);
            Eval(3876, o is Array[], false);
            Eval(3877, o is Enum, false);
            Eval(3878, o is Enum[], false);
            Eval(3879, o is Delegate, false);
            Eval(3880, o is Delegate[], false);
            Eval(3881, o is MulticastDelegate, false);
            Eval(3882, o is MulticastDelegate[], false);
            Eval(3883, o is IEmpty, false);
            Eval(3884, o is IEmpty[], false);
            Eval(3885, o is INotEmpty, false);
            Eval(3886, o is INotEmpty[], false);
            Eval(3887, o is IEmptyGen<int>, false);
            Eval(3888, o is IEmptyGen<int>[], false);
            Eval(3889, o is INotEmptyGen<int>, false);
            Eval(3890, o is INotEmptyGen<int>[], false);
            Eval(3891, o is SimpleDelegate, false);
            Eval(3892, o is SimpleDelegate[], false);
            Eval(3893, o is GenericDelegate<int>, false);
            Eval(3894, o is GenericDelegate<int>[], false);
            Eval(3895, o is EmptyClass, false);
            Eval(3896, o is EmptyClass[], false);
            Eval(3897, o is NotEmptyClass, false);
            Eval(3898, o is NotEmptyClass[], false);
            Eval(3899, o is EmptyClassGen<int>, false);
            Eval(3900, o is EmptyClassGen<int>[], false);
            Eval(3901, o is NotEmptyClassGen<Guid>, false);
            Eval(3902, o is NotEmptyClassGen<Guid>[], false);
            Eval(3903, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(3904, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(3905, o is NestedClass, false);
            Eval(3906, o is NestedClass[], false);
            Eval(3907, o is NestedClassGen<Decimal>, false);
            Eval(3908, o is NestedClassGen<Decimal>[], false);
            Eval(3909, o is ImplementOneInterfaceC, false);
            Eval(3910, o is ImplementOneInterfaceC[], false);
            Eval(3911, o is ImplementTwoInterfaceC, false);
            Eval(3912, o is ImplementTwoInterfaceC[], false);
            Eval(3913, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(3914, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(3915, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(3916, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(3917, o is ImplementAllInterfaceC<int>, false);
            Eval(3918, o is ImplementAllInterfaceC<int>[], false);
            Eval(3919, o is SealedClass, false);
            Eval(3920, o is SealedClass[], false);
        }
        {
            NestedStructGen<Decimal>? v = default(NestedStructGen<Decimal>?);
            ValueType o = v;
            Eval(3921, o is EmptyStruct, false);
            Eval(3922, o is EmptyStruct[], false);
            Eval(3923, o is EmptyStruct?, false);
            Eval(3924, o is EmptyStruct?[], false);
            Eval(3925, o is NotEmptyStruct, false);
            Eval(3926, o is NotEmptyStruct[], false);
            Eval(3927, o is NotEmptyStruct?, false);
            Eval(3928, o is NotEmptyStruct?[], false);
            Eval(3929, o is EmptyStructGen<int>, false);
            Eval(3930, o is EmptyStructGen<int>[], false);
            Eval(3931, o is EmptyStructGen<int>?, false);
            Eval(3932, o is EmptyStructGen<int>?[], false);
            Eval(3933, o is NotEmptyStructGen<Guid>, false);
            Eval(3934, o is NotEmptyStructGen<Guid>[], false);
            Eval(3935, o is NotEmptyStructGen<Guid>?, false);
            Eval(3936, o is NotEmptyStructGen<Guid>?[], false);
            Eval(3937, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(3938, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(3939, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(3940, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(3941, o is NestedStruct, false);
            Eval(3942, o is NestedStruct[], false);
            Eval(3943, o is NestedStruct?, false);
            Eval(3944, o is NestedStruct?[], false);
            Eval(3945, o is NestedStructGen<Decimal>, false);
            Eval(3946, o is NestedStructGen<Decimal>[], false);
            Eval(3947, o is NestedStructGen<Decimal>?, false);
            Eval(3948, o is NestedStructGen<Decimal>?[], false);
            Eval(3949, o is ExplicitFieldOffsetStruct, false);
            Eval(3950, o is ExplicitFieldOffsetStruct[], false);
            Eval(3951, o is ExplicitFieldOffsetStruct?, false);
            Eval(3952, o is ExplicitFieldOffsetStruct?[], false);
            Eval(3961, o is MarshalAsStruct, false);
            Eval(3962, o is MarshalAsStruct[], false);
            Eval(3963, o is MarshalAsStruct?, false);
            Eval(3964, o is MarshalAsStruct?[], false);
            Eval(3965, o is ImplementOneInterface, false);
            Eval(3966, o is ImplementOneInterface[], false);
            Eval(3967, o is ImplementOneInterface?, false);
            Eval(3968, o is ImplementOneInterface?[], false);
            Eval(3969, o is ImplementTwoInterface, false);
            Eval(3970, o is ImplementTwoInterface[], false);
            Eval(3971, o is ImplementTwoInterface?, false);
            Eval(3972, o is ImplementTwoInterface?[], false);
            Eval(3973, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(3974, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(3975, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(3976, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(3977, o is ImplementTwoInterfaceGen<int>, false);
            Eval(3978, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(3979, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(3980, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(3981, o is ImplementAllInterface<int>, false);
            Eval(3982, o is ImplementAllInterface<int>[], false);
            Eval(3983, o is ImplementAllInterface<int>?, false);
            Eval(3984, o is ImplementAllInterface<int>?[], false);
            Eval(3985, o is IntE, false);
            Eval(3986, o is IntE[], false);
            Eval(3987, o is IntE?, false);
            Eval(3988, o is IntE?[], false);
            Eval(3989, o is ByteE, false);
            Eval(3990, o is ByteE[], false);
            Eval(3991, o is ByteE?, false);
            Eval(3992, o is ByteE?[], false);
            Eval(3993, o is LongE, false);
            Eval(3994, o is LongE[], false);
            Eval(3995, o is LongE?, false);
            Eval(3996, o is LongE?[], false);
            Eval(3997, o is char, false);
            Eval(3998, o is char[], false);
            Eval(3999, o is char?, false);
            Eval(4000, o is char?[], false);
            Eval(4001, o is bool, false);
            Eval(4002, o is bool[], false);
            Eval(4003, o is bool?, false);
            Eval(4004, o is bool?[], false);
            Eval(4005, o is byte, false);
            Eval(4006, o is byte[], false);
            Eval(4007, o is byte?, false);
            Eval(4008, o is byte?[], false);
            Eval(4009, o is sbyte, false);
            Eval(4010, o is sbyte[], false);
            Eval(4011, o is sbyte?, false);
            Eval(4012, o is sbyte?[], false);
            Eval(4013, o is short, false);
            Eval(4014, o is short[], false);
            Eval(4015, o is short?, false);
            Eval(4016, o is short?[], false);
            Eval(4017, o is ushort, false);
            Eval(4018, o is ushort[], false);
            Eval(4019, o is ushort?, false);
            Eval(4020, o is ushort?[], false);
            Eval(4021, o is int, false);
            Eval(4022, o is int[], false);
            Eval(4023, o is int?, false);
            Eval(4024, o is int?[], false);
            Eval(4025, o is uint, false);
            Eval(4026, o is uint[], false);
            Eval(4027, o is uint?, false);
            Eval(4028, o is uint?[], false);
            Eval(4029, o is long, false);
            Eval(4030, o is long[], false);
            Eval(4031, o is long?, false);
            Eval(4032, o is long?[], false);
            Eval(4033, o is ulong, false);
            Eval(4034, o is ulong[], false);
            Eval(4035, o is ulong?, false);
            Eval(4036, o is ulong?[], false);
            Eval(4037, o is float, false);
            Eval(4038, o is float[], false);
            Eval(4039, o is float?, false);
            Eval(4040, o is float?[], false);
            Eval(4041, o is double, false);
            Eval(4042, o is double[], false);
            Eval(4043, o is double?, false);
            Eval(4044, o is double?[], false);
            Eval(4045, o is decimal, false);
            Eval(4046, o is decimal[], false);
            Eval(4047, o is decimal?, false);
            Eval(4048, o is decimal?[], false);
            Eval(4049, o is IntPtr, false);
            Eval(4050, o is IntPtr[], false);
            Eval(4051, o is IntPtr?, false);
            Eval(4052, o is IntPtr?[], false);
            Eval(4053, o is UIntPtr, false);
            Eval(4054, o is UIntPtr[], false);
            Eval(4055, o is UIntPtr?, false);
            Eval(4056, o is UIntPtr?[], false);
            Eval(4057, o is Guid, false);
            Eval(4058, o is Guid[], false);
            Eval(4059, o is Guid?, false);
            Eval(4060, o is Guid?[], false);
            Eval(4061, o is GCHandle, false);
            Eval(4062, o is GCHandle[], false);
            Eval(4063, o is GCHandle?, false);
            Eval(4064, o is GCHandle?[], false);
            Eval(4065, o is object, false);
            Eval(4066, o is object[], false);
            Eval(4067, o is string, false);
            Eval(4068, o is string[], false);
            Eval(4069, o is ValueType, false);
            Eval(4070, o is ValueType[], false);
            Eval(4071, o is Array, false);
            Eval(4072, o is Array[], false);
            Eval(4073, o is Enum, false);
            Eval(4074, o is Enum[], false);
            Eval(4075, o is Delegate, false);
            Eval(4076, o is Delegate[], false);
            Eval(4077, o is MulticastDelegate, false);
            Eval(4078, o is MulticastDelegate[], false);
            Eval(4079, o is IEmpty, false);
            Eval(4080, o is IEmpty[], false);
            Eval(4081, o is INotEmpty, false);
            Eval(4082, o is INotEmpty[], false);
            Eval(4083, o is IEmptyGen<int>, false);
            Eval(4084, o is IEmptyGen<int>[], false);
            Eval(4085, o is INotEmptyGen<int>, false);
            Eval(4086, o is INotEmptyGen<int>[], false);
            Eval(4087, o is SimpleDelegate, false);
            Eval(4088, o is SimpleDelegate[], false);
            Eval(4089, o is GenericDelegate<int>, false);
            Eval(4090, o is GenericDelegate<int>[], false);
            Eval(4091, o is EmptyClass, false);
            Eval(4092, o is EmptyClass[], false);
            Eval(4093, o is NotEmptyClass, false);
            Eval(4094, o is NotEmptyClass[], false);
            Eval(4095, o is EmptyClassGen<int>, false);
            Eval(4096, o is EmptyClassGen<int>[], false);
            Eval(4097, o is NotEmptyClassGen<Guid>, false);
            Eval(4098, o is NotEmptyClassGen<Guid>[], false);
            Eval(4099, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(4100, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(4101, o is NestedClass, false);
            Eval(4102, o is NestedClass[], false);
            Eval(4103, o is NestedClassGen<Decimal>, false);
            Eval(4104, o is NestedClassGen<Decimal>[], false);
            Eval(4105, o is ImplementOneInterfaceC, false);
            Eval(4106, o is ImplementOneInterfaceC[], false);
            Eval(4107, o is ImplementTwoInterfaceC, false);
            Eval(4108, o is ImplementTwoInterfaceC[], false);
            Eval(4109, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(4110, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(4111, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(4112, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(4113, o is ImplementAllInterfaceC<int>, false);
            Eval(4114, o is ImplementAllInterfaceC<int>[], false);
            Eval(4115, o is SealedClass, false);
            Eval(4116, o is SealedClass[], false);
        }
    }  // end of test case 0007
    private static void TestCase0008()
    {
        {
            ExplicitFieldOffsetStruct v = default(ExplicitFieldOffsetStruct);
            ValueType o = v;
            Eval(4117, o is EmptyStruct, false);
            Eval(4118, o is EmptyStruct[], false);
            Eval(4119, o is EmptyStruct?, false);
            Eval(4120, o is EmptyStruct?[], false);
            Eval(4121, o is NotEmptyStruct, false);
            Eval(4122, o is NotEmptyStruct[], false);
            Eval(4123, o is NotEmptyStruct?, false);
            Eval(4124, o is NotEmptyStruct?[], false);
            Eval(4125, o is EmptyStructGen<int>, false);
            Eval(4126, o is EmptyStructGen<int>[], false);
            Eval(4127, o is EmptyStructGen<int>?, false);
            Eval(4128, o is EmptyStructGen<int>?[], false);
            Eval(4129, o is NotEmptyStructGen<Guid>, false);
            Eval(4130, o is NotEmptyStructGen<Guid>[], false);
            Eval(4131, o is NotEmptyStructGen<Guid>?, false);
            Eval(4132, o is NotEmptyStructGen<Guid>?[], false);
            Eval(4133, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(4134, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(4135, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(4136, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(4137, o is NestedStruct, false);
            Eval(4138, o is NestedStruct[], false);
            Eval(4139, o is NestedStruct?, false);
            Eval(4140, o is NestedStruct?[], false);
            Eval(4141, o is NestedStructGen<Decimal>, false);
            Eval(4142, o is NestedStructGen<Decimal>[], false);
            Eval(4143, o is NestedStructGen<Decimal>?, false);
            Eval(4144, o is NestedStructGen<Decimal>?[], false);
            Eval(4145, o is ExplicitFieldOffsetStruct, true);
            Eval(4146, o is ExplicitFieldOffsetStruct[], false);
            Eval(4147, o is ExplicitFieldOffsetStruct?, true);
            Eval(4148, o is ExplicitFieldOffsetStruct?[], false);
            Eval(4157, o is MarshalAsStruct, false);
            Eval(4158, o is MarshalAsStruct[], false);
            Eval(4159, o is MarshalAsStruct?, false);
            Eval(4160, o is MarshalAsStruct?[], false);
            Eval(4161, o is ImplementOneInterface, false);
            Eval(4162, o is ImplementOneInterface[], false);
            Eval(4163, o is ImplementOneInterface?, false);
            Eval(4164, o is ImplementOneInterface?[], false);
            Eval(4165, o is ImplementTwoInterface, false);
            Eval(4166, o is ImplementTwoInterface[], false);
            Eval(4167, o is ImplementTwoInterface?, false);
            Eval(4168, o is ImplementTwoInterface?[], false);
            Eval(4169, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(4170, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(4171, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(4172, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(4173, o is ImplementTwoInterfaceGen<int>, false);
            Eval(4174, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(4175, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(4176, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(4177, o is ImplementAllInterface<int>, false);
            Eval(4178, o is ImplementAllInterface<int>[], false);
            Eval(4179, o is ImplementAllInterface<int>?, false);
            Eval(4180, o is ImplementAllInterface<int>?[], false);
            Eval(4181, o is IntE, false);
            Eval(4182, o is IntE[], false);
            Eval(4183, o is IntE?, false);
            Eval(4184, o is IntE?[], false);
            Eval(4185, o is ByteE, false);
            Eval(4186, o is ByteE[], false);
            Eval(4187, o is ByteE?, false);
            Eval(4188, o is ByteE?[], false);
            Eval(4189, o is LongE, false);
            Eval(4190, o is LongE[], false);
            Eval(4191, o is LongE?, false);
            Eval(4192, o is LongE?[], false);
            Eval(4193, o is char, false);
            Eval(4194, o is char[], false);
            Eval(4195, o is char?, false);
            Eval(4196, o is char?[], false);
            Eval(4197, o is bool, false);
            Eval(4198, o is bool[], false);
            Eval(4199, o is bool?, false);
            Eval(4200, o is bool?[], false);
            Eval(4201, o is byte, false);
            Eval(4202, o is byte[], false);
            Eval(4203, o is byte?, false);
            Eval(4204, o is byte?[], false);
            Eval(4205, o is sbyte, false);
            Eval(4206, o is sbyte[], false);
            Eval(4207, o is sbyte?, false);
            Eval(4208, o is sbyte?[], false);
            Eval(4209, o is short, false);
            Eval(4210, o is short[], false);
            Eval(4211, o is short?, false);
            Eval(4212, o is short?[], false);
            Eval(4213, o is ushort, false);
            Eval(4214, o is ushort[], false);
            Eval(4215, o is ushort?, false);
            Eval(4216, o is ushort?[], false);
            Eval(4217, o is int, false);
            Eval(4218, o is int[], false);
            Eval(4219, o is int?, false);
            Eval(4220, o is int?[], false);
            Eval(4221, o is uint, false);
            Eval(4222, o is uint[], false);
            Eval(4223, o is uint?, false);
            Eval(4224, o is uint?[], false);
            Eval(4225, o is long, false);
            Eval(4226, o is long[], false);
            Eval(4227, o is long?, false);
            Eval(4228, o is long?[], false);
            Eval(4229, o is ulong, false);
            Eval(4230, o is ulong[], false);
            Eval(4231, o is ulong?, false);
            Eval(4232, o is ulong?[], false);
            Eval(4233, o is float, false);
            Eval(4234, o is float[], false);
            Eval(4235, o is float?, false);
            Eval(4236, o is float?[], false);
            Eval(4237, o is double, false);
            Eval(4238, o is double[], false);
            Eval(4239, o is double?, false);
            Eval(4240, o is double?[], false);
            Eval(4241, o is decimal, false);
            Eval(4242, o is decimal[], false);
            Eval(4243, o is decimal?, false);
            Eval(4244, o is decimal?[], false);
            Eval(4245, o is IntPtr, false);
            Eval(4246, o is IntPtr[], false);
            Eval(4247, o is IntPtr?, false);
            Eval(4248, o is IntPtr?[], false);
            Eval(4249, o is UIntPtr, false);
            Eval(4250, o is UIntPtr[], false);
            Eval(4251, o is UIntPtr?, false);
            Eval(4252, o is UIntPtr?[], false);
            Eval(4253, o is Guid, false);
            Eval(4254, o is Guid[], false);
            Eval(4255, o is Guid?, false);
            Eval(4256, o is Guid?[], false);
            Eval(4257, o is GCHandle, false);
            Eval(4258, o is GCHandle[], false);
            Eval(4259, o is GCHandle?, false);
            Eval(4260, o is GCHandle?[], false);
            Eval(4261, o is object, true);
            Eval(4262, o is object[], false);
            Eval(4263, o is string, false);
            Eval(4264, o is string[], false);
            Eval(4265, o is ValueType, true);
            Eval(4266, o is ValueType[], false);
            Eval(4267, o is Array, false);
            Eval(4268, o is Array[], false);
            Eval(4269, o is Enum, false);
            Eval(4270, o is Enum[], false);
            Eval(4271, o is Delegate, false);
            Eval(4272, o is Delegate[], false);
            Eval(4273, o is MulticastDelegate, false);
            Eval(4274, o is MulticastDelegate[], false);
            Eval(4275, o is IEmpty, false);
            Eval(4276, o is IEmpty[], false);
            Eval(4277, o is INotEmpty, false);
            Eval(4278, o is INotEmpty[], false);
            Eval(4279, o is IEmptyGen<int>, false);
            Eval(4280, o is IEmptyGen<int>[], false);
            Eval(4281, o is INotEmptyGen<int>, false);
            Eval(4282, o is INotEmptyGen<int>[], false);
            Eval(4283, o is SimpleDelegate, false);
            Eval(4284, o is SimpleDelegate[], false);
            Eval(4285, o is GenericDelegate<int>, false);
            Eval(4286, o is GenericDelegate<int>[], false);
            Eval(4287, o is EmptyClass, false);
            Eval(4288, o is EmptyClass[], false);
            Eval(4289, o is NotEmptyClass, false);
            Eval(4290, o is NotEmptyClass[], false);
            Eval(4291, o is EmptyClassGen<int>, false);
            Eval(4292, o is EmptyClassGen<int>[], false);
            Eval(4293, o is NotEmptyClassGen<Guid>, false);
            Eval(4294, o is NotEmptyClassGen<Guid>[], false);
            Eval(4295, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(4296, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(4297, o is NestedClass, false);
            Eval(4298, o is NestedClass[], false);
            Eval(4299, o is NestedClassGen<Decimal>, false);
            Eval(4300, o is NestedClassGen<Decimal>[], false);
            Eval(4301, o is ImplementOneInterfaceC, false);
            Eval(4302, o is ImplementOneInterfaceC[], false);
            Eval(4303, o is ImplementTwoInterfaceC, false);
            Eval(4304, o is ImplementTwoInterfaceC[], false);
            Eval(4305, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(4306, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(4307, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(4308, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(4309, o is ImplementAllInterfaceC<int>, false);
            Eval(4310, o is ImplementAllInterfaceC<int>[], false);
            Eval(4311, o is SealedClass, false);
            Eval(4312, o is SealedClass[], false);
        }
        {
            ExplicitFieldOffsetStruct? v = default(ExplicitFieldOffsetStruct);
            ValueType o = v;
            Eval(4313, o is EmptyStruct, false);
            Eval(4314, o is EmptyStruct[], false);
            Eval(4315, o is EmptyStruct?, false);
            Eval(4316, o is EmptyStruct?[], false);
            Eval(4317, o is NotEmptyStruct, false);
            Eval(4318, o is NotEmptyStruct[], false);
            Eval(4319, o is NotEmptyStruct?, false);
            Eval(4320, o is NotEmptyStruct?[], false);
            Eval(4321, o is EmptyStructGen<int>, false);
            Eval(4322, o is EmptyStructGen<int>[], false);
            Eval(4323, o is EmptyStructGen<int>?, false);
            Eval(4324, o is EmptyStructGen<int>?[], false);
            Eval(4325, o is NotEmptyStructGen<Guid>, false);
            Eval(4326, o is NotEmptyStructGen<Guid>[], false);
            Eval(4327, o is NotEmptyStructGen<Guid>?, false);
            Eval(4328, o is NotEmptyStructGen<Guid>?[], false);
            Eval(4329, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(4330, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(4331, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(4332, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(4333, o is NestedStruct, false);
            Eval(4334, o is NestedStruct[], false);
            Eval(4335, o is NestedStruct?, false);
            Eval(4336, o is NestedStruct?[], false);
            Eval(4337, o is NestedStructGen<Decimal>, false);
            Eval(4338, o is NestedStructGen<Decimal>[], false);
            Eval(4339, o is NestedStructGen<Decimal>?, false);
            Eval(4340, o is NestedStructGen<Decimal>?[], false);
            Eval(4341, o is ExplicitFieldOffsetStruct, true);
            Eval(4342, o is ExplicitFieldOffsetStruct[], false);
            Eval(4343, o is ExplicitFieldOffsetStruct?, true);
            Eval(4344, o is ExplicitFieldOffsetStruct?[], false);
            Eval(4353, o is MarshalAsStruct, false);
            Eval(4354, o is MarshalAsStruct[], false);
            Eval(4355, o is MarshalAsStruct?, false);
            Eval(4356, o is MarshalAsStruct?[], false);
            Eval(4357, o is ImplementOneInterface, false);
            Eval(4358, o is ImplementOneInterface[], false);
            Eval(4359, o is ImplementOneInterface?, false);
            Eval(4360, o is ImplementOneInterface?[], false);
            Eval(4361, o is ImplementTwoInterface, false);
            Eval(4362, o is ImplementTwoInterface[], false);
            Eval(4363, o is ImplementTwoInterface?, false);
            Eval(4364, o is ImplementTwoInterface?[], false);
            Eval(4365, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(4366, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(4367, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(4368, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(4369, o is ImplementTwoInterfaceGen<int>, false);
            Eval(4370, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(4371, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(4372, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(4373, o is ImplementAllInterface<int>, false);
            Eval(4374, o is ImplementAllInterface<int>[], false);
            Eval(4375, o is ImplementAllInterface<int>?, false);
            Eval(4376, o is ImplementAllInterface<int>?[], false);
            Eval(4377, o is IntE, false);
            Eval(4378, o is IntE[], false);
            Eval(4379, o is IntE?, false);
            Eval(4380, o is IntE?[], false);
            Eval(4381, o is ByteE, false);
            Eval(4382, o is ByteE[], false);
            Eval(4383, o is ByteE?, false);
            Eval(4384, o is ByteE?[], false);
            Eval(4385, o is LongE, false);
            Eval(4386, o is LongE[], false);
            Eval(4387, o is LongE?, false);
            Eval(4388, o is LongE?[], false);
            Eval(4389, o is char, false);
            Eval(4390, o is char[], false);
            Eval(4391, o is char?, false);
            Eval(4392, o is char?[], false);
            Eval(4393, o is bool, false);
            Eval(4394, o is bool[], false);
            Eval(4395, o is bool?, false);
            Eval(4396, o is bool?[], false);
            Eval(4397, o is byte, false);
            Eval(4398, o is byte[], false);
            Eval(4399, o is byte?, false);
            Eval(4400, o is byte?[], false);
            Eval(4401, o is sbyte, false);
            Eval(4402, o is sbyte[], false);
            Eval(4403, o is sbyte?, false);
            Eval(4404, o is sbyte?[], false);
            Eval(4405, o is short, false);
            Eval(4406, o is short[], false);
            Eval(4407, o is short?, false);
            Eval(4408, o is short?[], false);
            Eval(4409, o is ushort, false);
            Eval(4410, o is ushort[], false);
            Eval(4411, o is ushort?, false);
            Eval(4412, o is ushort?[], false);
            Eval(4413, o is int, false);
            Eval(4414, o is int[], false);
            Eval(4415, o is int?, false);
            Eval(4416, o is int?[], false);
            Eval(4417, o is uint, false);
            Eval(4418, o is uint[], false);
            Eval(4419, o is uint?, false);
            Eval(4420, o is uint?[], false);
            Eval(4421, o is long, false);
            Eval(4422, o is long[], false);
            Eval(4423, o is long?, false);
            Eval(4424, o is long?[], false);
            Eval(4425, o is ulong, false);
            Eval(4426, o is ulong[], false);
            Eval(4427, o is ulong?, false);
            Eval(4428, o is ulong?[], false);
            Eval(4429, o is float, false);
            Eval(4430, o is float[], false);
            Eval(4431, o is float?, false);
            Eval(4432, o is float?[], false);
            Eval(4433, o is double, false);
            Eval(4434, o is double[], false);
            Eval(4435, o is double?, false);
            Eval(4436, o is double?[], false);
            Eval(4437, o is decimal, false);
            Eval(4438, o is decimal[], false);
            Eval(4439, o is decimal?, false);
            Eval(4440, o is decimal?[], false);
            Eval(4441, o is IntPtr, false);
            Eval(4442, o is IntPtr[], false);
            Eval(4443, o is IntPtr?, false);
            Eval(4444, o is IntPtr?[], false);
            Eval(4445, o is UIntPtr, false);
            Eval(4446, o is UIntPtr[], false);
            Eval(4447, o is UIntPtr?, false);
            Eval(4448, o is UIntPtr?[], false);
            Eval(4449, o is Guid, false);
            Eval(4450, o is Guid[], false);
            Eval(4451, o is Guid?, false);
            Eval(4452, o is Guid?[], false);
            Eval(4453, o is GCHandle, false);
            Eval(4454, o is GCHandle[], false);
            Eval(4455, o is GCHandle?, false);
            Eval(4456, o is GCHandle?[], false);
            Eval(4457, o is object, true);
            Eval(4458, o is object[], false);
            Eval(4459, o is string, false);
            Eval(4460, o is string[], false);
            Eval(4461, o is ValueType, true);
            Eval(4462, o is ValueType[], false);
            Eval(4463, o is Array, false);
            Eval(4464, o is Array[], false);
            Eval(4465, o is Enum, false);
            Eval(4466, o is Enum[], false);
            Eval(4467, o is Delegate, false);
            Eval(4468, o is Delegate[], false);
            Eval(4469, o is MulticastDelegate, false);
            Eval(4470, o is MulticastDelegate[], false);
            Eval(4471, o is IEmpty, false);
            Eval(4472, o is IEmpty[], false);
            Eval(4473, o is INotEmpty, false);
            Eval(4474, o is INotEmpty[], false);
            Eval(4475, o is IEmptyGen<int>, false);
            Eval(4476, o is IEmptyGen<int>[], false);
            Eval(4477, o is INotEmptyGen<int>, false);
            Eval(4478, o is INotEmptyGen<int>[], false);
            Eval(4479, o is SimpleDelegate, false);
            Eval(4480, o is SimpleDelegate[], false);
            Eval(4481, o is GenericDelegate<int>, false);
            Eval(4482, o is GenericDelegate<int>[], false);
            Eval(4483, o is EmptyClass, false);
            Eval(4484, o is EmptyClass[], false);
            Eval(4485, o is NotEmptyClass, false);
            Eval(4486, o is NotEmptyClass[], false);
            Eval(4487, o is EmptyClassGen<int>, false);
            Eval(4488, o is EmptyClassGen<int>[], false);
            Eval(4489, o is NotEmptyClassGen<Guid>, false);
            Eval(4490, o is NotEmptyClassGen<Guid>[], false);
            Eval(4491, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(4492, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(4493, o is NestedClass, false);
            Eval(4494, o is NestedClass[], false);
            Eval(4495, o is NestedClassGen<Decimal>, false);
            Eval(4496, o is NestedClassGen<Decimal>[], false);
            Eval(4497, o is ImplementOneInterfaceC, false);
            Eval(4498, o is ImplementOneInterfaceC[], false);
            Eval(4499, o is ImplementTwoInterfaceC, false);
            Eval(4500, o is ImplementTwoInterfaceC[], false);
            Eval(4501, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(4502, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(4503, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(4504, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(4505, o is ImplementAllInterfaceC<int>, false);
            Eval(4506, o is ImplementAllInterfaceC<int>[], false);
            Eval(4507, o is SealedClass, false);
            Eval(4508, o is SealedClass[], false);
        }
        {
            ExplicitFieldOffsetStruct? v = default(ExplicitFieldOffsetStruct?);
            ValueType o = v;
            Eval(4509, o is EmptyStruct, false);
            Eval(4510, o is EmptyStruct[], false);
            Eval(4511, o is EmptyStruct?, false);
            Eval(4512, o is EmptyStruct?[], false);
            Eval(4513, o is NotEmptyStruct, false);
            Eval(4514, o is NotEmptyStruct[], false);
            Eval(4515, o is NotEmptyStruct?, false);
            Eval(4516, o is NotEmptyStruct?[], false);
            Eval(4517, o is EmptyStructGen<int>, false);
            Eval(4518, o is EmptyStructGen<int>[], false);
            Eval(4519, o is EmptyStructGen<int>?, false);
            Eval(4520, o is EmptyStructGen<int>?[], false);
            Eval(4521, o is NotEmptyStructGen<Guid>, false);
            Eval(4522, o is NotEmptyStructGen<Guid>[], false);
            Eval(4523, o is NotEmptyStructGen<Guid>?, false);
            Eval(4524, o is NotEmptyStructGen<Guid>?[], false);
            Eval(4525, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(4526, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(4527, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(4528, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(4529, o is NestedStruct, false);
            Eval(4530, o is NestedStruct[], false);
            Eval(4531, o is NestedStruct?, false);
            Eval(4532, o is NestedStruct?[], false);
            Eval(4533, o is NestedStructGen<Decimal>, false);
            Eval(4534, o is NestedStructGen<Decimal>[], false);
            Eval(4535, o is NestedStructGen<Decimal>?, false);
            Eval(4536, o is NestedStructGen<Decimal>?[], false);
            Eval(4537, o is ExplicitFieldOffsetStruct, false);
            Eval(4538, o is ExplicitFieldOffsetStruct[], false);
            Eval(4539, o is ExplicitFieldOffsetStruct?, false);
            Eval(4540, o is ExplicitFieldOffsetStruct?[], false);
            Eval(4549, o is MarshalAsStruct, false);
            Eval(4550, o is MarshalAsStruct[], false);
            Eval(4551, o is MarshalAsStruct?, false);
            Eval(4552, o is MarshalAsStruct?[], false);
            Eval(4553, o is ImplementOneInterface, false);
            Eval(4554, o is ImplementOneInterface[], false);
            Eval(4555, o is ImplementOneInterface?, false);
            Eval(4556, o is ImplementOneInterface?[], false);
            Eval(4557, o is ImplementTwoInterface, false);
            Eval(4558, o is ImplementTwoInterface[], false);
            Eval(4559, o is ImplementTwoInterface?, false);
            Eval(4560, o is ImplementTwoInterface?[], false);
            Eval(4561, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(4562, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(4563, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(4564, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(4565, o is ImplementTwoInterfaceGen<int>, false);
            Eval(4566, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(4567, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(4568, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(4569, o is ImplementAllInterface<int>, false);
            Eval(4570, o is ImplementAllInterface<int>[], false);
            Eval(4571, o is ImplementAllInterface<int>?, false);
            Eval(4572, o is ImplementAllInterface<int>?[], false);
            Eval(4573, o is IntE, false);
            Eval(4574, o is IntE[], false);
            Eval(4575, o is IntE?, false);
            Eval(4576, o is IntE?[], false);
            Eval(4577, o is ByteE, false);
            Eval(4578, o is ByteE[], false);
            Eval(4579, o is ByteE?, false);
            Eval(4580, o is ByteE?[], false);
            Eval(4581, o is LongE, false);
            Eval(4582, o is LongE[], false);
            Eval(4583, o is LongE?, false);
            Eval(4584, o is LongE?[], false);
            Eval(4585, o is char, false);
            Eval(4586, o is char[], false);
            Eval(4587, o is char?, false);
            Eval(4588, o is char?[], false);
            Eval(4589, o is bool, false);
            Eval(4590, o is bool[], false);
            Eval(4591, o is bool?, false);
            Eval(4592, o is bool?[], false);
            Eval(4593, o is byte, false);
            Eval(4594, o is byte[], false);
            Eval(4595, o is byte?, false);
            Eval(4596, o is byte?[], false);
            Eval(4597, o is sbyte, false);
            Eval(4598, o is sbyte[], false);
            Eval(4599, o is sbyte?, false);
            Eval(4600, o is sbyte?[], false);
            Eval(4601, o is short, false);
            Eval(4602, o is short[], false);
            Eval(4603, o is short?, false);
            Eval(4604, o is short?[], false);
            Eval(4605, o is ushort, false);
            Eval(4606, o is ushort[], false);
            Eval(4607, o is ushort?, false);
            Eval(4608, o is ushort?[], false);
            Eval(4609, o is int, false);
            Eval(4610, o is int[], false);
            Eval(4611, o is int?, false);
            Eval(4612, o is int?[], false);
            Eval(4613, o is uint, false);
            Eval(4614, o is uint[], false);
            Eval(4615, o is uint?, false);
            Eval(4616, o is uint?[], false);
            Eval(4617, o is long, false);
            Eval(4618, o is long[], false);
            Eval(4619, o is long?, false);
            Eval(4620, o is long?[], false);
            Eval(4621, o is ulong, false);
            Eval(4622, o is ulong[], false);
            Eval(4623, o is ulong?, false);
            Eval(4624, o is ulong?[], false);
            Eval(4625, o is float, false);
            Eval(4626, o is float[], false);
            Eval(4627, o is float?, false);
            Eval(4628, o is float?[], false);
            Eval(4629, o is double, false);
            Eval(4630, o is double[], false);
            Eval(4631, o is double?, false);
            Eval(4632, o is double?[], false);
            Eval(4633, o is decimal, false);
            Eval(4634, o is decimal[], false);
            Eval(4635, o is decimal?, false);
            Eval(4636, o is decimal?[], false);
            Eval(4637, o is IntPtr, false);
            Eval(4638, o is IntPtr[], false);
            Eval(4639, o is IntPtr?, false);
            Eval(4640, o is IntPtr?[], false);
            Eval(4641, o is UIntPtr, false);
            Eval(4642, o is UIntPtr[], false);
            Eval(4643, o is UIntPtr?, false);
            Eval(4644, o is UIntPtr?[], false);
            Eval(4645, o is Guid, false);
            Eval(4646, o is Guid[], false);
            Eval(4647, o is Guid?, false);
            Eval(4648, o is Guid?[], false);
            Eval(4649, o is GCHandle, false);
            Eval(4650, o is GCHandle[], false);
            Eval(4651, o is GCHandle?, false);
            Eval(4652, o is GCHandle?[], false);
            Eval(4653, o is object, false);
            Eval(4654, o is object[], false);
            Eval(4655, o is string, false);
            Eval(4656, o is string[], false);
            Eval(4657, o is ValueType, false);
            Eval(4658, o is ValueType[], false);
            Eval(4659, o is Array, false);
            Eval(4660, o is Array[], false);
            Eval(4661, o is Enum, false);
            Eval(4662, o is Enum[], false);
            Eval(4663, o is Delegate, false);
            Eval(4664, o is Delegate[], false);
            Eval(4665, o is MulticastDelegate, false);
            Eval(4666, o is MulticastDelegate[], false);
            Eval(4667, o is IEmpty, false);
            Eval(4668, o is IEmpty[], false);
            Eval(4669, o is INotEmpty, false);
            Eval(4670, o is INotEmpty[], false);
            Eval(4671, o is IEmptyGen<int>, false);
            Eval(4672, o is IEmptyGen<int>[], false);
            Eval(4673, o is INotEmptyGen<int>, false);
            Eval(4674, o is INotEmptyGen<int>[], false);
            Eval(4675, o is SimpleDelegate, false);
            Eval(4676, o is SimpleDelegate[], false);
            Eval(4677, o is GenericDelegate<int>, false);
            Eval(4678, o is GenericDelegate<int>[], false);
            Eval(4679, o is EmptyClass, false);
            Eval(4680, o is EmptyClass[], false);
            Eval(4681, o is NotEmptyClass, false);
            Eval(4682, o is NotEmptyClass[], false);
            Eval(4683, o is EmptyClassGen<int>, false);
            Eval(4684, o is EmptyClassGen<int>[], false);
            Eval(4685, o is NotEmptyClassGen<Guid>, false);
            Eval(4686, o is NotEmptyClassGen<Guid>[], false);
            Eval(4687, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(4688, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(4689, o is NestedClass, false);
            Eval(4690, o is NestedClass[], false);
            Eval(4691, o is NestedClassGen<Decimal>, false);
            Eval(4692, o is NestedClassGen<Decimal>[], false);
            Eval(4693, o is ImplementOneInterfaceC, false);
            Eval(4694, o is ImplementOneInterfaceC[], false);
            Eval(4695, o is ImplementTwoInterfaceC, false);
            Eval(4696, o is ImplementTwoInterfaceC[], false);
            Eval(4697, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(4698, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(4699, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(4700, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(4701, o is ImplementAllInterfaceC<int>, false);
            Eval(4702, o is ImplementAllInterfaceC<int>[], false);
            Eval(4703, o is SealedClass, false);
            Eval(4704, o is SealedClass[], false);
        }
    }  // end of test case 0008
    private static void TestCase0011()
    {
        {
            MarshalAsStruct v = default(MarshalAsStruct);
            ValueType o = v;
            Eval(5881, o is EmptyStruct, false);
            Eval(5882, o is EmptyStruct[], false);
            Eval(5883, o is EmptyStruct?, false);
            Eval(5884, o is EmptyStruct?[], false);
            Eval(5885, o is NotEmptyStruct, false);
            Eval(5886, o is NotEmptyStruct[], false);
            Eval(5887, o is NotEmptyStruct?, false);
            Eval(5888, o is NotEmptyStruct?[], false);
            Eval(5889, o is EmptyStructGen<int>, false);
            Eval(5890, o is EmptyStructGen<int>[], false);
            Eval(5891, o is EmptyStructGen<int>?, false);
            Eval(5892, o is EmptyStructGen<int>?[], false);
            Eval(5893, o is NotEmptyStructGen<Guid>, false);
            Eval(5894, o is NotEmptyStructGen<Guid>[], false);
            Eval(5895, o is NotEmptyStructGen<Guid>?, false);
            Eval(5896, o is NotEmptyStructGen<Guid>?[], false);
            Eval(5897, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(5898, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(5899, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(5900, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(5901, o is NestedStruct, false);
            Eval(5902, o is NestedStruct[], false);
            Eval(5903, o is NestedStruct?, false);
            Eval(5904, o is NestedStruct?[], false);
            Eval(5905, o is NestedStructGen<Decimal>, false);
            Eval(5906, o is NestedStructGen<Decimal>[], false);
            Eval(5907, o is NestedStructGen<Decimal>?, false);
            Eval(5908, o is NestedStructGen<Decimal>?[], false);
            Eval(5909, o is ExplicitFieldOffsetStruct, false);
            Eval(5910, o is ExplicitFieldOffsetStruct[], false);
            Eval(5911, o is ExplicitFieldOffsetStruct?, false);
            Eval(5912, o is ExplicitFieldOffsetStruct?[], false);
            Eval(5921, o is MarshalAsStruct, true);
            Eval(5922, o is MarshalAsStruct[], false);
            Eval(5923, o is MarshalAsStruct?, true);
            Eval(5924, o is MarshalAsStruct?[], false);
            Eval(5925, o is ImplementOneInterface, false);
            Eval(5926, o is ImplementOneInterface[], false);
            Eval(5927, o is ImplementOneInterface?, false);
            Eval(5928, o is ImplementOneInterface?[], false);
            Eval(5929, o is ImplementTwoInterface, false);
            Eval(5930, o is ImplementTwoInterface[], false);
            Eval(5931, o is ImplementTwoInterface?, false);
            Eval(5932, o is ImplementTwoInterface?[], false);
            Eval(5933, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(5934, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(5935, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(5936, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(5937, o is ImplementTwoInterfaceGen<int>, false);
            Eval(5938, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(5939, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(5940, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(5941, o is ImplementAllInterface<int>, false);
            Eval(5942, o is ImplementAllInterface<int>[], false);
            Eval(5943, o is ImplementAllInterface<int>?, false);
            Eval(5944, o is ImplementAllInterface<int>?[], false);
            Eval(5945, o is IntE, false);
            Eval(5946, o is IntE[], false);
            Eval(5947, o is IntE?, false);
            Eval(5948, o is IntE?[], false);
            Eval(5949, o is ByteE, false);
            Eval(5950, o is ByteE[], false);
            Eval(5951, o is ByteE?, false);
            Eval(5952, o is ByteE?[], false);
            Eval(5953, o is LongE, false);
            Eval(5954, o is LongE[], false);
            Eval(5955, o is LongE?, false);
            Eval(5956, o is LongE?[], false);
            Eval(5957, o is char, false);
            Eval(5958, o is char[], false);
            Eval(5959, o is char?, false);
            Eval(5960, o is char?[], false);
            Eval(5961, o is bool, false);
            Eval(5962, o is bool[], false);
            Eval(5963, o is bool?, false);
            Eval(5964, o is bool?[], false);
            Eval(5965, o is byte, false);
            Eval(5966, o is byte[], false);
            Eval(5967, o is byte?, false);
            Eval(5968, o is byte?[], false);
            Eval(5969, o is sbyte, false);
            Eval(5970, o is sbyte[], false);
            Eval(5971, o is sbyte?, false);
            Eval(5972, o is sbyte?[], false);
            Eval(5973, o is short, false);
            Eval(5974, o is short[], false);
            Eval(5975, o is short?, false);
            Eval(5976, o is short?[], false);
            Eval(5977, o is ushort, false);
            Eval(5978, o is ushort[], false);
            Eval(5979, o is ushort?, false);
            Eval(5980, o is ushort?[], false);
            Eval(5981, o is int, false);
            Eval(5982, o is int[], false);
            Eval(5983, o is int?, false);
            Eval(5984, o is int?[], false);
            Eval(5985, o is uint, false);
            Eval(5986, o is uint[], false);
            Eval(5987, o is uint?, false);
            Eval(5988, o is uint?[], false);
            Eval(5989, o is long, false);
            Eval(5990, o is long[], false);
            Eval(5991, o is long?, false);
            Eval(5992, o is long?[], false);
            Eval(5993, o is ulong, false);
            Eval(5994, o is ulong[], false);
            Eval(5995, o is ulong?, false);
            Eval(5996, o is ulong?[], false);
            Eval(5997, o is float, false);
            Eval(5998, o is float[], false);
            Eval(5999, o is float?, false);
            Eval(6000, o is float?[], false);
            Eval(6001, o is double, false);
            Eval(6002, o is double[], false);
            Eval(6003, o is double?, false);
            Eval(6004, o is double?[], false);
            Eval(6005, o is decimal, false);
            Eval(6006, o is decimal[], false);
            Eval(6007, o is decimal?, false);
            Eval(6008, o is decimal?[], false);
            Eval(6009, o is IntPtr, false);
            Eval(6010, o is IntPtr[], false);
            Eval(6011, o is IntPtr?, false);
            Eval(6012, o is IntPtr?[], false);
            Eval(6013, o is UIntPtr, false);
            Eval(6014, o is UIntPtr[], false);
            Eval(6015, o is UIntPtr?, false);
            Eval(6016, o is UIntPtr?[], false);
            Eval(6017, o is Guid, false);
            Eval(6018, o is Guid[], false);
            Eval(6019, o is Guid?, false);
            Eval(6020, o is Guid?[], false);
            Eval(6021, o is GCHandle, false);
            Eval(6022, o is GCHandle[], false);
            Eval(6023, o is GCHandle?, false);
            Eval(6024, o is GCHandle?[], false);
            Eval(6025, o is object, true);
            Eval(6026, o is object[], false);
            Eval(6027, o is string, false);
            Eval(6028, o is string[], false);
            Eval(6029, o is ValueType, true);
            Eval(6030, o is ValueType[], false);
            Eval(6031, o is Array, false);
            Eval(6032, o is Array[], false);
            Eval(6033, o is Enum, false);
            Eval(6034, o is Enum[], false);
            Eval(6035, o is Delegate, false);
            Eval(6036, o is Delegate[], false);
            Eval(6037, o is MulticastDelegate, false);
            Eval(6038, o is MulticastDelegate[], false);
            Eval(6039, o is IEmpty, false);
            Eval(6040, o is IEmpty[], false);
            Eval(6041, o is INotEmpty, false);
            Eval(6042, o is INotEmpty[], false);
            Eval(6043, o is IEmptyGen<int>, false);
            Eval(6044, o is IEmptyGen<int>[], false);
            Eval(6045, o is INotEmptyGen<int>, false);
            Eval(6046, o is INotEmptyGen<int>[], false);
            Eval(6047, o is SimpleDelegate, false);
            Eval(6048, o is SimpleDelegate[], false);
            Eval(6049, o is GenericDelegate<int>, false);
            Eval(6050, o is GenericDelegate<int>[], false);
            Eval(6051, o is EmptyClass, false);
            Eval(6052, o is EmptyClass[], false);
            Eval(6053, o is NotEmptyClass, false);
            Eval(6054, o is NotEmptyClass[], false);
            Eval(6055, o is EmptyClassGen<int>, false);
            Eval(6056, o is EmptyClassGen<int>[], false);
            Eval(6057, o is NotEmptyClassGen<Guid>, false);
            Eval(6058, o is NotEmptyClassGen<Guid>[], false);
            Eval(6059, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(6060, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(6061, o is NestedClass, false);
            Eval(6062, o is NestedClass[], false);
            Eval(6063, o is NestedClassGen<Decimal>, false);
            Eval(6064, o is NestedClassGen<Decimal>[], false);
            Eval(6065, o is ImplementOneInterfaceC, false);
            Eval(6066, o is ImplementOneInterfaceC[], false);
            Eval(6067, o is ImplementTwoInterfaceC, false);
            Eval(6068, o is ImplementTwoInterfaceC[], false);
            Eval(6069, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(6070, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(6071, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(6072, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(6073, o is ImplementAllInterfaceC<int>, false);
            Eval(6074, o is ImplementAllInterfaceC<int>[], false);
            Eval(6075, o is SealedClass, false);
            Eval(6076, o is SealedClass[], false);
        }
        {
            MarshalAsStruct? v = default(MarshalAsStruct);
            ValueType o = v;
            Eval(6077, o is EmptyStruct, false);
            Eval(6078, o is EmptyStruct[], false);
            Eval(6079, o is EmptyStruct?, false);
            Eval(6080, o is EmptyStruct?[], false);
            Eval(6081, o is NotEmptyStruct, false);
            Eval(6082, o is NotEmptyStruct[], false);
            Eval(6083, o is NotEmptyStruct?, false);
            Eval(6084, o is NotEmptyStruct?[], false);
            Eval(6085, o is EmptyStructGen<int>, false);
            Eval(6086, o is EmptyStructGen<int>[], false);
            Eval(6087, o is EmptyStructGen<int>?, false);
            Eval(6088, o is EmptyStructGen<int>?[], false);
            Eval(6089, o is NotEmptyStructGen<Guid>, false);
            Eval(6090, o is NotEmptyStructGen<Guid>[], false);
            Eval(6091, o is NotEmptyStructGen<Guid>?, false);
            Eval(6092, o is NotEmptyStructGen<Guid>?[], false);
            Eval(6093, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(6094, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(6095, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(6096, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(6097, o is NestedStruct, false);
            Eval(6098, o is NestedStruct[], false);
            Eval(6099, o is NestedStruct?, false);
            Eval(6100, o is NestedStruct?[], false);
            Eval(6101, o is NestedStructGen<Decimal>, false);
            Eval(6102, o is NestedStructGen<Decimal>[], false);
            Eval(6103, o is NestedStructGen<Decimal>?, false);
            Eval(6104, o is NestedStructGen<Decimal>?[], false);
            Eval(6105, o is ExplicitFieldOffsetStruct, false);
            Eval(6106, o is ExplicitFieldOffsetStruct[], false);
            Eval(6107, o is ExplicitFieldOffsetStruct?, false);
            Eval(6108, o is ExplicitFieldOffsetStruct?[], false);
            Eval(6117, o is MarshalAsStruct, true);
            Eval(6118, o is MarshalAsStruct[], false);
            Eval(6119, o is MarshalAsStruct?, true);
            Eval(6120, o is MarshalAsStruct?[], false);
            Eval(6121, o is ImplementOneInterface, false);
            Eval(6122, o is ImplementOneInterface[], false);
            Eval(6123, o is ImplementOneInterface?, false);
            Eval(6124, o is ImplementOneInterface?[], false);
            Eval(6125, o is ImplementTwoInterface, false);
            Eval(6126, o is ImplementTwoInterface[], false);
            Eval(6127, o is ImplementTwoInterface?, false);
            Eval(6128, o is ImplementTwoInterface?[], false);
            Eval(6129, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(6130, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(6131, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(6132, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(6133, o is ImplementTwoInterfaceGen<int>, false);
            Eval(6134, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(6135, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(6136, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(6137, o is ImplementAllInterface<int>, false);
            Eval(6138, o is ImplementAllInterface<int>[], false);
            Eval(6139, o is ImplementAllInterface<int>?, false);
            Eval(6140, o is ImplementAllInterface<int>?[], false);
            Eval(6141, o is IntE, false);
            Eval(6142, o is IntE[], false);
            Eval(6143, o is IntE?, false);
            Eval(6144, o is IntE?[], false);
            Eval(6145, o is ByteE, false);
            Eval(6146, o is ByteE[], false);
            Eval(6147, o is ByteE?, false);
            Eval(6148, o is ByteE?[], false);
            Eval(6149, o is LongE, false);
            Eval(6150, o is LongE[], false);
            Eval(6151, o is LongE?, false);
            Eval(6152, o is LongE?[], false);
            Eval(6153, o is char, false);
            Eval(6154, o is char[], false);
            Eval(6155, o is char?, false);
            Eval(6156, o is char?[], false);
            Eval(6157, o is bool, false);
            Eval(6158, o is bool[], false);
            Eval(6159, o is bool?, false);
            Eval(6160, o is bool?[], false);
            Eval(6161, o is byte, false);
            Eval(6162, o is byte[], false);
            Eval(6163, o is byte?, false);
            Eval(6164, o is byte?[], false);
            Eval(6165, o is sbyte, false);
            Eval(6166, o is sbyte[], false);
            Eval(6167, o is sbyte?, false);
            Eval(6168, o is sbyte?[], false);
            Eval(6169, o is short, false);
            Eval(6170, o is short[], false);
            Eval(6171, o is short?, false);
            Eval(6172, o is short?[], false);
            Eval(6173, o is ushort, false);
            Eval(6174, o is ushort[], false);
            Eval(6175, o is ushort?, false);
            Eval(6176, o is ushort?[], false);
            Eval(6177, o is int, false);
            Eval(6178, o is int[], false);
            Eval(6179, o is int?, false);
            Eval(6180, o is int?[], false);
            Eval(6181, o is uint, false);
            Eval(6182, o is uint[], false);
            Eval(6183, o is uint?, false);
            Eval(6184, o is uint?[], false);
            Eval(6185, o is long, false);
            Eval(6186, o is long[], false);
            Eval(6187, o is long?, false);
            Eval(6188, o is long?[], false);
            Eval(6189, o is ulong, false);
            Eval(6190, o is ulong[], false);
            Eval(6191, o is ulong?, false);
            Eval(6192, o is ulong?[], false);
            Eval(6193, o is float, false);
            Eval(6194, o is float[], false);
            Eval(6195, o is float?, false);
            Eval(6196, o is float?[], false);
            Eval(6197, o is double, false);
            Eval(6198, o is double[], false);
            Eval(6199, o is double?, false);
            Eval(6200, o is double?[], false);
            Eval(6201, o is decimal, false);
            Eval(6202, o is decimal[], false);
            Eval(6203, o is decimal?, false);
            Eval(6204, o is decimal?[], false);
            Eval(6205, o is IntPtr, false);
            Eval(6206, o is IntPtr[], false);
            Eval(6207, o is IntPtr?, false);
            Eval(6208, o is IntPtr?[], false);
            Eval(6209, o is UIntPtr, false);
            Eval(6210, o is UIntPtr[], false);
            Eval(6211, o is UIntPtr?, false);
            Eval(6212, o is UIntPtr?[], false);
            Eval(6213, o is Guid, false);
            Eval(6214, o is Guid[], false);
            Eval(6215, o is Guid?, false);
            Eval(6216, o is Guid?[], false);
            Eval(6217, o is GCHandle, false);
            Eval(6218, o is GCHandle[], false);
            Eval(6219, o is GCHandle?, false);
            Eval(6220, o is GCHandle?[], false);
            Eval(6221, o is object, true);
            Eval(6222, o is object[], false);
            Eval(6223, o is string, false);
            Eval(6224, o is string[], false);
            Eval(6225, o is ValueType, true);
            Eval(6226, o is ValueType[], false);
            Eval(6227, o is Array, false);
            Eval(6228, o is Array[], false);
            Eval(6229, o is Enum, false);
            Eval(6230, o is Enum[], false);
            Eval(6231, o is Delegate, false);
            Eval(6232, o is Delegate[], false);
            Eval(6233, o is MulticastDelegate, false);
            Eval(6234, o is MulticastDelegate[], false);
            Eval(6235, o is IEmpty, false);
            Eval(6236, o is IEmpty[], false);
            Eval(6237, o is INotEmpty, false);
            Eval(6238, o is INotEmpty[], false);
            Eval(6239, o is IEmptyGen<int>, false);
            Eval(6240, o is IEmptyGen<int>[], false);
            Eval(6241, o is INotEmptyGen<int>, false);
            Eval(6242, o is INotEmptyGen<int>[], false);
            Eval(6243, o is SimpleDelegate, false);
            Eval(6244, o is SimpleDelegate[], false);
            Eval(6245, o is GenericDelegate<int>, false);
            Eval(6246, o is GenericDelegate<int>[], false);
            Eval(6247, o is EmptyClass, false);
            Eval(6248, o is EmptyClass[], false);
            Eval(6249, o is NotEmptyClass, false);
            Eval(6250, o is NotEmptyClass[], false);
            Eval(6251, o is EmptyClassGen<int>, false);
            Eval(6252, o is EmptyClassGen<int>[], false);
            Eval(6253, o is NotEmptyClassGen<Guid>, false);
            Eval(6254, o is NotEmptyClassGen<Guid>[], false);
            Eval(6255, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(6256, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(6257, o is NestedClass, false);
            Eval(6258, o is NestedClass[], false);
            Eval(6259, o is NestedClassGen<Decimal>, false);
            Eval(6260, o is NestedClassGen<Decimal>[], false);
            Eval(6261, o is ImplementOneInterfaceC, false);
            Eval(6262, o is ImplementOneInterfaceC[], false);
            Eval(6263, o is ImplementTwoInterfaceC, false);
            Eval(6264, o is ImplementTwoInterfaceC[], false);
            Eval(6265, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(6266, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(6267, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(6268, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(6269, o is ImplementAllInterfaceC<int>, false);
            Eval(6270, o is ImplementAllInterfaceC<int>[], false);
            Eval(6271, o is SealedClass, false);
            Eval(6272, o is SealedClass[], false);
        }
        {
            MarshalAsStruct? v = default(MarshalAsStruct?);
            ValueType o = v;
            Eval(6273, o is EmptyStruct, false);
            Eval(6274, o is EmptyStruct[], false);
            Eval(6275, o is EmptyStruct?, false);
            Eval(6276, o is EmptyStruct?[], false);
            Eval(6277, o is NotEmptyStruct, false);
            Eval(6278, o is NotEmptyStruct[], false);
            Eval(6279, o is NotEmptyStruct?, false);
            Eval(6280, o is NotEmptyStruct?[], false);
            Eval(6281, o is EmptyStructGen<int>, false);
            Eval(6282, o is EmptyStructGen<int>[], false);
            Eval(6283, o is EmptyStructGen<int>?, false);
            Eval(6284, o is EmptyStructGen<int>?[], false);
            Eval(6285, o is NotEmptyStructGen<Guid>, false);
            Eval(6286, o is NotEmptyStructGen<Guid>[], false);
            Eval(6287, o is NotEmptyStructGen<Guid>?, false);
            Eval(6288, o is NotEmptyStructGen<Guid>?[], false);
            Eval(6289, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(6290, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(6291, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(6292, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(6293, o is NestedStruct, false);
            Eval(6294, o is NestedStruct[], false);
            Eval(6295, o is NestedStruct?, false);
            Eval(6296, o is NestedStruct?[], false);
            Eval(6297, o is NestedStructGen<Decimal>, false);
            Eval(6298, o is NestedStructGen<Decimal>[], false);
            Eval(6299, o is NestedStructGen<Decimal>?, false);
            Eval(6300, o is NestedStructGen<Decimal>?[], false);
            Eval(6301, o is ExplicitFieldOffsetStruct, false);
            Eval(6302, o is ExplicitFieldOffsetStruct[], false);
            Eval(6303, o is ExplicitFieldOffsetStruct?, false);
            Eval(6304, o is ExplicitFieldOffsetStruct?[], false);
            Eval(6313, o is MarshalAsStruct, false);
            Eval(6314, o is MarshalAsStruct[], false);
            Eval(6315, o is MarshalAsStruct?, false);
            Eval(6316, o is MarshalAsStruct?[], false);
            Eval(6317, o is ImplementOneInterface, false);
            Eval(6318, o is ImplementOneInterface[], false);
            Eval(6319, o is ImplementOneInterface?, false);
            Eval(6320, o is ImplementOneInterface?[], false);
            Eval(6321, o is ImplementTwoInterface, false);
            Eval(6322, o is ImplementTwoInterface[], false);
            Eval(6323, o is ImplementTwoInterface?, false);
            Eval(6324, o is ImplementTwoInterface?[], false);
            Eval(6325, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(6326, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(6327, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(6328, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(6329, o is ImplementTwoInterfaceGen<int>, false);
            Eval(6330, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(6331, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(6332, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(6333, o is ImplementAllInterface<int>, false);
            Eval(6334, o is ImplementAllInterface<int>[], false);
            Eval(6335, o is ImplementAllInterface<int>?, false);
            Eval(6336, o is ImplementAllInterface<int>?[], false);
            Eval(6337, o is IntE, false);
            Eval(6338, o is IntE[], false);
            Eval(6339, o is IntE?, false);
            Eval(6340, o is IntE?[], false);
            Eval(6341, o is ByteE, false);
            Eval(6342, o is ByteE[], false);
            Eval(6343, o is ByteE?, false);
            Eval(6344, o is ByteE?[], false);
            Eval(6345, o is LongE, false);
            Eval(6346, o is LongE[], false);
            Eval(6347, o is LongE?, false);
            Eval(6348, o is LongE?[], false);
            Eval(6349, o is char, false);
            Eval(6350, o is char[], false);
            Eval(6351, o is char?, false);
            Eval(6352, o is char?[], false);
            Eval(6353, o is bool, false);
            Eval(6354, o is bool[], false);
            Eval(6355, o is bool?, false);
            Eval(6356, o is bool?[], false);
            Eval(6357, o is byte, false);
            Eval(6358, o is byte[], false);
            Eval(6359, o is byte?, false);
            Eval(6360, o is byte?[], false);
            Eval(6361, o is sbyte, false);
            Eval(6362, o is sbyte[], false);
            Eval(6363, o is sbyte?, false);
            Eval(6364, o is sbyte?[], false);
            Eval(6365, o is short, false);
            Eval(6366, o is short[], false);
            Eval(6367, o is short?, false);
            Eval(6368, o is short?[], false);
            Eval(6369, o is ushort, false);
            Eval(6370, o is ushort[], false);
            Eval(6371, o is ushort?, false);
            Eval(6372, o is ushort?[], false);
            Eval(6373, o is int, false);
            Eval(6374, o is int[], false);
            Eval(6375, o is int?, false);
            Eval(6376, o is int?[], false);
            Eval(6377, o is uint, false);
            Eval(6378, o is uint[], false);
            Eval(6379, o is uint?, false);
            Eval(6380, o is uint?[], false);
            Eval(6381, o is long, false);
            Eval(6382, o is long[], false);
            Eval(6383, o is long?, false);
            Eval(6384, o is long?[], false);
            Eval(6385, o is ulong, false);
            Eval(6386, o is ulong[], false);
            Eval(6387, o is ulong?, false);
            Eval(6388, o is ulong?[], false);
            Eval(6389, o is float, false);
            Eval(6390, o is float[], false);
            Eval(6391, o is float?, false);
            Eval(6392, o is float?[], false);
            Eval(6393, o is double, false);
            Eval(6394, o is double[], false);
            Eval(6395, o is double?, false);
            Eval(6396, o is double?[], false);
            Eval(6397, o is decimal, false);
            Eval(6398, o is decimal[], false);
            Eval(6399, o is decimal?, false);
            Eval(6400, o is decimal?[], false);
            Eval(6401, o is IntPtr, false);
            Eval(6402, o is IntPtr[], false);
            Eval(6403, o is IntPtr?, false);
            Eval(6404, o is IntPtr?[], false);
            Eval(6405, o is UIntPtr, false);
            Eval(6406, o is UIntPtr[], false);
            Eval(6407, o is UIntPtr?, false);
            Eval(6408, o is UIntPtr?[], false);
            Eval(6409, o is Guid, false);
            Eval(6410, o is Guid[], false);
            Eval(6411, o is Guid?, false);
            Eval(6412, o is Guid?[], false);
            Eval(6413, o is GCHandle, false);
            Eval(6414, o is GCHandle[], false);
            Eval(6415, o is GCHandle?, false);
            Eval(6416, o is GCHandle?[], false);
            Eval(6417, o is object, false);
            Eval(6418, o is object[], false);
            Eval(6419, o is string, false);
            Eval(6420, o is string[], false);
            Eval(6421, o is ValueType, false);
            Eval(6422, o is ValueType[], false);
            Eval(6423, o is Array, false);
            Eval(6424, o is Array[], false);
            Eval(6425, o is Enum, false);
            Eval(6426, o is Enum[], false);
            Eval(6427, o is Delegate, false);
            Eval(6428, o is Delegate[], false);
            Eval(6429, o is MulticastDelegate, false);
            Eval(6430, o is MulticastDelegate[], false);
            Eval(6431, o is IEmpty, false);
            Eval(6432, o is IEmpty[], false);
            Eval(6433, o is INotEmpty, false);
            Eval(6434, o is INotEmpty[], false);
            Eval(6435, o is IEmptyGen<int>, false);
            Eval(6436, o is IEmptyGen<int>[], false);
            Eval(6437, o is INotEmptyGen<int>, false);
            Eval(6438, o is INotEmptyGen<int>[], false);
            Eval(6439, o is SimpleDelegate, false);
            Eval(6440, o is SimpleDelegate[], false);
            Eval(6441, o is GenericDelegate<int>, false);
            Eval(6442, o is GenericDelegate<int>[], false);
            Eval(6443, o is EmptyClass, false);
            Eval(6444, o is EmptyClass[], false);
            Eval(6445, o is NotEmptyClass, false);
            Eval(6446, o is NotEmptyClass[], false);
            Eval(6447, o is EmptyClassGen<int>, false);
            Eval(6448, o is EmptyClassGen<int>[], false);
            Eval(6449, o is NotEmptyClassGen<Guid>, false);
            Eval(6450, o is NotEmptyClassGen<Guid>[], false);
            Eval(6451, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(6452, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(6453, o is NestedClass, false);
            Eval(6454, o is NestedClass[], false);
            Eval(6455, o is NestedClassGen<Decimal>, false);
            Eval(6456, o is NestedClassGen<Decimal>[], false);
            Eval(6457, o is ImplementOneInterfaceC, false);
            Eval(6458, o is ImplementOneInterfaceC[], false);
            Eval(6459, o is ImplementTwoInterfaceC, false);
            Eval(6460, o is ImplementTwoInterfaceC[], false);
            Eval(6461, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(6462, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(6463, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(6464, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(6465, o is ImplementAllInterfaceC<int>, false);
            Eval(6466, o is ImplementAllInterfaceC<int>[], false);
            Eval(6467, o is SealedClass, false);
            Eval(6468, o is SealedClass[], false);
        }
    }  // end of test case 0011
    private static void TestCase0012()
    {
        {
            ImplementOneInterface v = default(ImplementOneInterface);
            ValueType o = v;
            Eval(6469, o is EmptyStruct, false);
            Eval(6470, o is EmptyStruct[], false);
            Eval(6471, o is EmptyStruct?, false);
            Eval(6472, o is EmptyStruct?[], false);
            Eval(6473, o is NotEmptyStruct, false);
            Eval(6474, o is NotEmptyStruct[], false);
            Eval(6475, o is NotEmptyStruct?, false);
            Eval(6476, o is NotEmptyStruct?[], false);
            Eval(6477, o is EmptyStructGen<int>, false);
            Eval(6478, o is EmptyStructGen<int>[], false);
            Eval(6479, o is EmptyStructGen<int>?, false);
            Eval(6480, o is EmptyStructGen<int>?[], false);
            Eval(6481, o is NotEmptyStructGen<Guid>, false);
            Eval(6482, o is NotEmptyStructGen<Guid>[], false);
            Eval(6483, o is NotEmptyStructGen<Guid>?, false);
            Eval(6484, o is NotEmptyStructGen<Guid>?[], false);
            Eval(6485, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(6486, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(6487, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(6488, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(6489, o is NestedStruct, false);
            Eval(6490, o is NestedStruct[], false);
            Eval(6491, o is NestedStruct?, false);
            Eval(6492, o is NestedStruct?[], false);
            Eval(6493, o is NestedStructGen<Decimal>, false);
            Eval(6494, o is NestedStructGen<Decimal>[], false);
            Eval(6495, o is NestedStructGen<Decimal>?, false);
            Eval(6496, o is NestedStructGen<Decimal>?[], false);
            Eval(6497, o is ExplicitFieldOffsetStruct, false);
            Eval(6498, o is ExplicitFieldOffsetStruct[], false);
            Eval(6499, o is ExplicitFieldOffsetStruct?, false);
            Eval(6500, o is ExplicitFieldOffsetStruct?[], false);
            Eval(6509, o is MarshalAsStruct, false);
            Eval(6510, o is MarshalAsStruct[], false);
            Eval(6511, o is MarshalAsStruct?, false);
            Eval(6512, o is MarshalAsStruct?[], false);
            Eval(6513, o is ImplementOneInterface, true);
            Eval(6514, o is ImplementOneInterface[], false);
            Eval(6515, o is ImplementOneInterface?, true);
            Eval(6516, o is ImplementOneInterface?[], false);
            Eval(6517, o is ImplementTwoInterface, false);
            Eval(6518, o is ImplementTwoInterface[], false);
            Eval(6519, o is ImplementTwoInterface?, false);
            Eval(6520, o is ImplementTwoInterface?[], false);
            Eval(6521, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(6522, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(6523, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(6524, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(6525, o is ImplementTwoInterfaceGen<int>, false);
            Eval(6526, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(6527, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(6528, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(6529, o is ImplementAllInterface<int>, false);
            Eval(6530, o is ImplementAllInterface<int>[], false);
            Eval(6531, o is ImplementAllInterface<int>?, false);
            Eval(6532, o is ImplementAllInterface<int>?[], false);
            Eval(6533, o is IntE, false);
            Eval(6534, o is IntE[], false);
            Eval(6535, o is IntE?, false);
            Eval(6536, o is IntE?[], false);
            Eval(6537, o is ByteE, false);
            Eval(6538, o is ByteE[], false);
            Eval(6539, o is ByteE?, false);
            Eval(6540, o is ByteE?[], false);
            Eval(6541, o is LongE, false);
            Eval(6542, o is LongE[], false);
            Eval(6543, o is LongE?, false);
            Eval(6544, o is LongE?[], false);
            Eval(6545, o is char, false);
            Eval(6546, o is char[], false);
            Eval(6547, o is char?, false);
            Eval(6548, o is char?[], false);
            Eval(6549, o is bool, false);
            Eval(6550, o is bool[], false);
            Eval(6551, o is bool?, false);
            Eval(6552, o is bool?[], false);
            Eval(6553, o is byte, false);
            Eval(6554, o is byte[], false);
            Eval(6555, o is byte?, false);
            Eval(6556, o is byte?[], false);
            Eval(6557, o is sbyte, false);
            Eval(6558, o is sbyte[], false);
            Eval(6559, o is sbyte?, false);
            Eval(6560, o is sbyte?[], false);
            Eval(6561, o is short, false);
            Eval(6562, o is short[], false);
            Eval(6563, o is short?, false);
            Eval(6564, o is short?[], false);
            Eval(6565, o is ushort, false);
            Eval(6566, o is ushort[], false);
            Eval(6567, o is ushort?, false);
            Eval(6568, o is ushort?[], false);
            Eval(6569, o is int, false);
            Eval(6570, o is int[], false);
            Eval(6571, o is int?, false);
            Eval(6572, o is int?[], false);
            Eval(6573, o is uint, false);
            Eval(6574, o is uint[], false);
            Eval(6575, o is uint?, false);
            Eval(6576, o is uint?[], false);
            Eval(6577, o is long, false);
            Eval(6578, o is long[], false);
            Eval(6579, o is long?, false);
            Eval(6580, o is long?[], false);
            Eval(6581, o is ulong, false);
            Eval(6582, o is ulong[], false);
            Eval(6583, o is ulong?, false);
            Eval(6584, o is ulong?[], false);
            Eval(6585, o is float, false);
            Eval(6586, o is float[], false);
            Eval(6587, o is float?, false);
            Eval(6588, o is float?[], false);
            Eval(6589, o is double, false);
            Eval(6590, o is double[], false);
            Eval(6591, o is double?, false);
            Eval(6592, o is double?[], false);
            Eval(6593, o is decimal, false);
            Eval(6594, o is decimal[], false);
            Eval(6595, o is decimal?, false);
            Eval(6596, o is decimal?[], false);
            Eval(6597, o is IntPtr, false);
            Eval(6598, o is IntPtr[], false);
            Eval(6599, o is IntPtr?, false);
            Eval(6600, o is IntPtr?[], false);
            Eval(6601, o is UIntPtr, false);
            Eval(6602, o is UIntPtr[], false);
            Eval(6603, o is UIntPtr?, false);
            Eval(6604, o is UIntPtr?[], false);
            Eval(6605, o is Guid, false);
            Eval(6606, o is Guid[], false);
            Eval(6607, o is Guid?, false);
            Eval(6608, o is Guid?[], false);
            Eval(6609, o is GCHandle, false);
            Eval(6610, o is GCHandle[], false);
            Eval(6611, o is GCHandle?, false);
            Eval(6612, o is GCHandle?[], false);
            Eval(6613, o is object, true);
            Eval(6614, o is object[], false);
            Eval(6615, o is string, false);
            Eval(6616, o is string[], false);
            Eval(6617, o is ValueType, true);
            Eval(6618, o is ValueType[], false);
            Eval(6619, o is Array, false);
            Eval(6620, o is Array[], false);
            Eval(6621, o is Enum, false);
            Eval(6622, o is Enum[], false);
            Eval(6623, o is Delegate, false);
            Eval(6624, o is Delegate[], false);
            Eval(6625, o is MulticastDelegate, false);
            Eval(6626, o is MulticastDelegate[], false);
            Eval(6627, o is IEmpty, true);
            Eval(6628, o is IEmpty[], false);
            Eval(6629, o is INotEmpty, false);
            Eval(6630, o is INotEmpty[], false);
            Eval(6631, o is IEmptyGen<int>, false);
            Eval(6632, o is IEmptyGen<int>[], false);
            Eval(6633, o is INotEmptyGen<int>, false);
            Eval(6634, o is INotEmptyGen<int>[], false);
            Eval(6635, o is SimpleDelegate, false);
            Eval(6636, o is SimpleDelegate[], false);
            Eval(6637, o is GenericDelegate<int>, false);
            Eval(6638, o is GenericDelegate<int>[], false);
            Eval(6639, o is EmptyClass, false);
            Eval(6640, o is EmptyClass[], false);
            Eval(6641, o is NotEmptyClass, false);
            Eval(6642, o is NotEmptyClass[], false);
            Eval(6643, o is EmptyClassGen<int>, false);
            Eval(6644, o is EmptyClassGen<int>[], false);
            Eval(6645, o is NotEmptyClassGen<Guid>, false);
            Eval(6646, o is NotEmptyClassGen<Guid>[], false);
            Eval(6647, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(6648, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(6649, o is NestedClass, false);
            Eval(6650, o is NestedClass[], false);
            Eval(6651, o is NestedClassGen<Decimal>, false);
            Eval(6652, o is NestedClassGen<Decimal>[], false);
            Eval(6653, o is ImplementOneInterfaceC, false);
            Eval(6654, o is ImplementOneInterfaceC[], false);
            Eval(6655, o is ImplementTwoInterfaceC, false);
            Eval(6656, o is ImplementTwoInterfaceC[], false);
            Eval(6657, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(6658, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(6659, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(6660, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(6661, o is ImplementAllInterfaceC<int>, false);
            Eval(6662, o is ImplementAllInterfaceC<int>[], false);
            Eval(6663, o is SealedClass, false);
            Eval(6664, o is SealedClass[], false);
        }
        {
            ImplementOneInterface? v = default(ImplementOneInterface);
            ValueType o = v;
            Eval(6665, o is EmptyStruct, false);
            Eval(6666, o is EmptyStruct[], false);
            Eval(6667, o is EmptyStruct?, false);
            Eval(6668, o is EmptyStruct?[], false);
            Eval(6669, o is NotEmptyStruct, false);
            Eval(6670, o is NotEmptyStruct[], false);
            Eval(6671, o is NotEmptyStruct?, false);
            Eval(6672, o is NotEmptyStruct?[], false);
            Eval(6673, o is EmptyStructGen<int>, false);
            Eval(6674, o is EmptyStructGen<int>[], false);
            Eval(6675, o is EmptyStructGen<int>?, false);
            Eval(6676, o is EmptyStructGen<int>?[], false);
            Eval(6677, o is NotEmptyStructGen<Guid>, false);
            Eval(6678, o is NotEmptyStructGen<Guid>[], false);
            Eval(6679, o is NotEmptyStructGen<Guid>?, false);
            Eval(6680, o is NotEmptyStructGen<Guid>?[], false);
            Eval(6681, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(6682, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(6683, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(6684, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(6685, o is NestedStruct, false);
            Eval(6686, o is NestedStruct[], false);
            Eval(6687, o is NestedStruct?, false);
            Eval(6688, o is NestedStruct?[], false);
            Eval(6689, o is NestedStructGen<Decimal>, false);
            Eval(6690, o is NestedStructGen<Decimal>[], false);
            Eval(6691, o is NestedStructGen<Decimal>?, false);
            Eval(6692, o is NestedStructGen<Decimal>?[], false);
            Eval(6693, o is ExplicitFieldOffsetStruct, false);
            Eval(6694, o is ExplicitFieldOffsetStruct[], false);
            Eval(6695, o is ExplicitFieldOffsetStruct?, false);
            Eval(6696, o is ExplicitFieldOffsetStruct?[], false);
            Eval(6705, o is MarshalAsStruct, false);
            Eval(6706, o is MarshalAsStruct[], false);
            Eval(6707, o is MarshalAsStruct?, false);
            Eval(6708, o is MarshalAsStruct?[], false);
            Eval(6709, o is ImplementOneInterface, true);
            Eval(6710, o is ImplementOneInterface[], false);
            Eval(6711, o is ImplementOneInterface?, true);
            Eval(6712, o is ImplementOneInterface?[], false);
            Eval(6713, o is ImplementTwoInterface, false);
            Eval(6714, o is ImplementTwoInterface[], false);
            Eval(6715, o is ImplementTwoInterface?, false);
            Eval(6716, o is ImplementTwoInterface?[], false);
            Eval(6717, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(6718, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(6719, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(6720, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(6721, o is ImplementTwoInterfaceGen<int>, false);
            Eval(6722, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(6723, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(6724, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(6725, o is ImplementAllInterface<int>, false);
            Eval(6726, o is ImplementAllInterface<int>[], false);
            Eval(6727, o is ImplementAllInterface<int>?, false);
            Eval(6728, o is ImplementAllInterface<int>?[], false);
            Eval(6729, o is IntE, false);
            Eval(6730, o is IntE[], false);
            Eval(6731, o is IntE?, false);
            Eval(6732, o is IntE?[], false);
            Eval(6733, o is ByteE, false);
            Eval(6734, o is ByteE[], false);
            Eval(6735, o is ByteE?, false);
            Eval(6736, o is ByteE?[], false);
            Eval(6737, o is LongE, false);
            Eval(6738, o is LongE[], false);
            Eval(6739, o is LongE?, false);
            Eval(6740, o is LongE?[], false);
            Eval(6741, o is char, false);
            Eval(6742, o is char[], false);
            Eval(6743, o is char?, false);
            Eval(6744, o is char?[], false);
            Eval(6745, o is bool, false);
            Eval(6746, o is bool[], false);
            Eval(6747, o is bool?, false);
            Eval(6748, o is bool?[], false);
            Eval(6749, o is byte, false);
            Eval(6750, o is byte[], false);
            Eval(6751, o is byte?, false);
            Eval(6752, o is byte?[], false);
            Eval(6753, o is sbyte, false);
            Eval(6754, o is sbyte[], false);
            Eval(6755, o is sbyte?, false);
            Eval(6756, o is sbyte?[], false);
            Eval(6757, o is short, false);
            Eval(6758, o is short[], false);
            Eval(6759, o is short?, false);
            Eval(6760, o is short?[], false);
            Eval(6761, o is ushort, false);
            Eval(6762, o is ushort[], false);
            Eval(6763, o is ushort?, false);
            Eval(6764, o is ushort?[], false);
            Eval(6765, o is int, false);
            Eval(6766, o is int[], false);
            Eval(6767, o is int?, false);
            Eval(6768, o is int?[], false);
            Eval(6769, o is uint, false);
            Eval(6770, o is uint[], false);
            Eval(6771, o is uint?, false);
            Eval(6772, o is uint?[], false);
            Eval(6773, o is long, false);
            Eval(6774, o is long[], false);
            Eval(6775, o is long?, false);
            Eval(6776, o is long?[], false);
            Eval(6777, o is ulong, false);
            Eval(6778, o is ulong[], false);
            Eval(6779, o is ulong?, false);
            Eval(6780, o is ulong?[], false);
            Eval(6781, o is float, false);
            Eval(6782, o is float[], false);
            Eval(6783, o is float?, false);
            Eval(6784, o is float?[], false);
            Eval(6785, o is double, false);
            Eval(6786, o is double[], false);
            Eval(6787, o is double?, false);
            Eval(6788, o is double?[], false);
            Eval(6789, o is decimal, false);
            Eval(6790, o is decimal[], false);
            Eval(6791, o is decimal?, false);
            Eval(6792, o is decimal?[], false);
            Eval(6793, o is IntPtr, false);
            Eval(6794, o is IntPtr[], false);
            Eval(6795, o is IntPtr?, false);
            Eval(6796, o is IntPtr?[], false);
            Eval(6797, o is UIntPtr, false);
            Eval(6798, o is UIntPtr[], false);
            Eval(6799, o is UIntPtr?, false);
            Eval(6800, o is UIntPtr?[], false);
            Eval(6801, o is Guid, false);
            Eval(6802, o is Guid[], false);
            Eval(6803, o is Guid?, false);
            Eval(6804, o is Guid?[], false);
            Eval(6805, o is GCHandle, false);
            Eval(6806, o is GCHandle[], false);
            Eval(6807, o is GCHandle?, false);
            Eval(6808, o is GCHandle?[], false);
            Eval(6809, o is object, true);
            Eval(6810, o is object[], false);
            Eval(6811, o is string, false);
            Eval(6812, o is string[], false);
            Eval(6813, o is ValueType, true);
            Eval(6814, o is ValueType[], false);
            Eval(6815, o is Array, false);
            Eval(6816, o is Array[], false);
            Eval(6817, o is Enum, false);
            Eval(6818, o is Enum[], false);
            Eval(6819, o is Delegate, false);
            Eval(6820, o is Delegate[], false);
            Eval(6821, o is MulticastDelegate, false);
            Eval(6822, o is MulticastDelegate[], false);
            Eval(6823, o is IEmpty, true);
            Eval(6824, o is IEmpty[], false);
            Eval(6825, o is INotEmpty, false);
            Eval(6826, o is INotEmpty[], false);
            Eval(6827, o is IEmptyGen<int>, false);
            Eval(6828, o is IEmptyGen<int>[], false);
            Eval(6829, o is INotEmptyGen<int>, false);
            Eval(6830, o is INotEmptyGen<int>[], false);
            Eval(6831, o is SimpleDelegate, false);
            Eval(6832, o is SimpleDelegate[], false);
            Eval(6833, o is GenericDelegate<int>, false);
            Eval(6834, o is GenericDelegate<int>[], false);
            Eval(6835, o is EmptyClass, false);
            Eval(6836, o is EmptyClass[], false);
            Eval(6837, o is NotEmptyClass, false);
            Eval(6838, o is NotEmptyClass[], false);
            Eval(6839, o is EmptyClassGen<int>, false);
            Eval(6840, o is EmptyClassGen<int>[], false);
            Eval(6841, o is NotEmptyClassGen<Guid>, false);
            Eval(6842, o is NotEmptyClassGen<Guid>[], false);
            Eval(6843, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(6844, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(6845, o is NestedClass, false);
            Eval(6846, o is NestedClass[], false);
            Eval(6847, o is NestedClassGen<Decimal>, false);
            Eval(6848, o is NestedClassGen<Decimal>[], false);
            Eval(6849, o is ImplementOneInterfaceC, false);
            Eval(6850, o is ImplementOneInterfaceC[], false);
            Eval(6851, o is ImplementTwoInterfaceC, false);
            Eval(6852, o is ImplementTwoInterfaceC[], false);
            Eval(6853, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(6854, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(6855, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(6856, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(6857, o is ImplementAllInterfaceC<int>, false);
            Eval(6858, o is ImplementAllInterfaceC<int>[], false);
            Eval(6859, o is SealedClass, false);
            Eval(6860, o is SealedClass[], false);
        }
        {
            ImplementOneInterface? v = default(ImplementOneInterface?);
            ValueType o = v;
            Eval(6861, o is EmptyStruct, false);
            Eval(6862, o is EmptyStruct[], false);
            Eval(6863, o is EmptyStruct?, false);
            Eval(6864, o is EmptyStruct?[], false);
            Eval(6865, o is NotEmptyStruct, false);
            Eval(6866, o is NotEmptyStruct[], false);
            Eval(6867, o is NotEmptyStruct?, false);
            Eval(6868, o is NotEmptyStruct?[], false);
            Eval(6869, o is EmptyStructGen<int>, false);
            Eval(6870, o is EmptyStructGen<int>[], false);
            Eval(6871, o is EmptyStructGen<int>?, false);
            Eval(6872, o is EmptyStructGen<int>?[], false);
            Eval(6873, o is NotEmptyStructGen<Guid>, false);
            Eval(6874, o is NotEmptyStructGen<Guid>[], false);
            Eval(6875, o is NotEmptyStructGen<Guid>?, false);
            Eval(6876, o is NotEmptyStructGen<Guid>?[], false);
            Eval(6877, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(6878, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(6879, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(6880, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(6881, o is NestedStruct, false);
            Eval(6882, o is NestedStruct[], false);
            Eval(6883, o is NestedStruct?, false);
            Eval(6884, o is NestedStruct?[], false);
            Eval(6885, o is NestedStructGen<Decimal>, false);
            Eval(6886, o is NestedStructGen<Decimal>[], false);
            Eval(6887, o is NestedStructGen<Decimal>?, false);
            Eval(6888, o is NestedStructGen<Decimal>?[], false);
            Eval(6889, o is ExplicitFieldOffsetStruct, false);
            Eval(6890, o is ExplicitFieldOffsetStruct[], false);
            Eval(6891, o is ExplicitFieldOffsetStruct?, false);
            Eval(6892, o is ExplicitFieldOffsetStruct?[], false);
            Eval(6901, o is MarshalAsStruct, false);
            Eval(6902, o is MarshalAsStruct[], false);
            Eval(6903, o is MarshalAsStruct?, false);
            Eval(6904, o is MarshalAsStruct?[], false);
            Eval(6905, o is ImplementOneInterface, false);
            Eval(6906, o is ImplementOneInterface[], false);
            Eval(6907, o is ImplementOneInterface?, false);
            Eval(6908, o is ImplementOneInterface?[], false);
            Eval(6909, o is ImplementTwoInterface, false);
            Eval(6910, o is ImplementTwoInterface[], false);
            Eval(6911, o is ImplementTwoInterface?, false);
            Eval(6912, o is ImplementTwoInterface?[], false);
            Eval(6913, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(6914, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(6915, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(6916, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(6917, o is ImplementTwoInterfaceGen<int>, false);
            Eval(6918, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(6919, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(6920, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(6921, o is ImplementAllInterface<int>, false);
            Eval(6922, o is ImplementAllInterface<int>[], false);
            Eval(6923, o is ImplementAllInterface<int>?, false);
            Eval(6924, o is ImplementAllInterface<int>?[], false);
            Eval(6925, o is IntE, false);
            Eval(6926, o is IntE[], false);
            Eval(6927, o is IntE?, false);
            Eval(6928, o is IntE?[], false);
            Eval(6929, o is ByteE, false);
            Eval(6930, o is ByteE[], false);
            Eval(6931, o is ByteE?, false);
            Eval(6932, o is ByteE?[], false);
            Eval(6933, o is LongE, false);
            Eval(6934, o is LongE[], false);
            Eval(6935, o is LongE?, false);
            Eval(6936, o is LongE?[], false);
            Eval(6937, o is char, false);
            Eval(6938, o is char[], false);
            Eval(6939, o is char?, false);
            Eval(6940, o is char?[], false);
            Eval(6941, o is bool, false);
            Eval(6942, o is bool[], false);
            Eval(6943, o is bool?, false);
            Eval(6944, o is bool?[], false);
            Eval(6945, o is byte, false);
            Eval(6946, o is byte[], false);
            Eval(6947, o is byte?, false);
            Eval(6948, o is byte?[], false);
            Eval(6949, o is sbyte, false);
            Eval(6950, o is sbyte[], false);
            Eval(6951, o is sbyte?, false);
            Eval(6952, o is sbyte?[], false);
            Eval(6953, o is short, false);
            Eval(6954, o is short[], false);
            Eval(6955, o is short?, false);
            Eval(6956, o is short?[], false);
            Eval(6957, o is ushort, false);
            Eval(6958, o is ushort[], false);
            Eval(6959, o is ushort?, false);
            Eval(6960, o is ushort?[], false);
            Eval(6961, o is int, false);
            Eval(6962, o is int[], false);
            Eval(6963, o is int?, false);
            Eval(6964, o is int?[], false);
            Eval(6965, o is uint, false);
            Eval(6966, o is uint[], false);
            Eval(6967, o is uint?, false);
            Eval(6968, o is uint?[], false);
            Eval(6969, o is long, false);
            Eval(6970, o is long[], false);
            Eval(6971, o is long?, false);
            Eval(6972, o is long?[], false);
            Eval(6973, o is ulong, false);
            Eval(6974, o is ulong[], false);
            Eval(6975, o is ulong?, false);
            Eval(6976, o is ulong?[], false);
            Eval(6977, o is float, false);
            Eval(6978, o is float[], false);
            Eval(6979, o is float?, false);
            Eval(6980, o is float?[], false);
            Eval(6981, o is double, false);
            Eval(6982, o is double[], false);
            Eval(6983, o is double?, false);
            Eval(6984, o is double?[], false);
            Eval(6985, o is decimal, false);
            Eval(6986, o is decimal[], false);
            Eval(6987, o is decimal?, false);
            Eval(6988, o is decimal?[], false);
            Eval(6989, o is IntPtr, false);
            Eval(6990, o is IntPtr[], false);
            Eval(6991, o is IntPtr?, false);
            Eval(6992, o is IntPtr?[], false);
            Eval(6993, o is UIntPtr, false);
            Eval(6994, o is UIntPtr[], false);
            Eval(6995, o is UIntPtr?, false);
            Eval(6996, o is UIntPtr?[], false);
            Eval(6997, o is Guid, false);
            Eval(6998, o is Guid[], false);
            Eval(6999, o is Guid?, false);
            Eval(7000, o is Guid?[], false);
            Eval(7001, o is GCHandle, false);
            Eval(7002, o is GCHandle[], false);
            Eval(7003, o is GCHandle?, false);
            Eval(7004, o is GCHandle?[], false);
            Eval(7005, o is object, false);
            Eval(7006, o is object[], false);
            Eval(7007, o is string, false);
            Eval(7008, o is string[], false);
            Eval(7009, o is ValueType, false);
            Eval(7010, o is ValueType[], false);
            Eval(7011, o is Array, false);
            Eval(7012, o is Array[], false);
            Eval(7013, o is Enum, false);
            Eval(7014, o is Enum[], false);
            Eval(7015, o is Delegate, false);
            Eval(7016, o is Delegate[], false);
            Eval(7017, o is MulticastDelegate, false);
            Eval(7018, o is MulticastDelegate[], false);
            Eval(7019, o is IEmpty, false);
            Eval(7020, o is IEmpty[], false);
            Eval(7021, o is INotEmpty, false);
            Eval(7022, o is INotEmpty[], false);
            Eval(7023, o is IEmptyGen<int>, false);
            Eval(7024, o is IEmptyGen<int>[], false);
            Eval(7025, o is INotEmptyGen<int>, false);
            Eval(7026, o is INotEmptyGen<int>[], false);
            Eval(7027, o is SimpleDelegate, false);
            Eval(7028, o is SimpleDelegate[], false);
            Eval(7029, o is GenericDelegate<int>, false);
            Eval(7030, o is GenericDelegate<int>[], false);
            Eval(7031, o is EmptyClass, false);
            Eval(7032, o is EmptyClass[], false);
            Eval(7033, o is NotEmptyClass, false);
            Eval(7034, o is NotEmptyClass[], false);
            Eval(7035, o is EmptyClassGen<int>, false);
            Eval(7036, o is EmptyClassGen<int>[], false);
            Eval(7037, o is NotEmptyClassGen<Guid>, false);
            Eval(7038, o is NotEmptyClassGen<Guid>[], false);
            Eval(7039, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(7040, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(7041, o is NestedClass, false);
            Eval(7042, o is NestedClass[], false);
            Eval(7043, o is NestedClassGen<Decimal>, false);
            Eval(7044, o is NestedClassGen<Decimal>[], false);
            Eval(7045, o is ImplementOneInterfaceC, false);
            Eval(7046, o is ImplementOneInterfaceC[], false);
            Eval(7047, o is ImplementTwoInterfaceC, false);
            Eval(7048, o is ImplementTwoInterfaceC[], false);
            Eval(7049, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(7050, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(7051, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(7052, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(7053, o is ImplementAllInterfaceC<int>, false);
            Eval(7054, o is ImplementAllInterfaceC<int>[], false);
            Eval(7055, o is SealedClass, false);
            Eval(7056, o is SealedClass[], false);
        }
    }  // end of test case 0012
    private static void TestCase0013()
    {
        {
            ImplementTwoInterface v = default(ImplementTwoInterface);
            ValueType o = v;
            Eval(7057, o is EmptyStruct, false);
            Eval(7058, o is EmptyStruct[], false);
            Eval(7059, o is EmptyStruct?, false);
            Eval(7060, o is EmptyStruct?[], false);
            Eval(7061, o is NotEmptyStruct, false);
            Eval(7062, o is NotEmptyStruct[], false);
            Eval(7063, o is NotEmptyStruct?, false);
            Eval(7064, o is NotEmptyStruct?[], false);
            Eval(7065, o is EmptyStructGen<int>, false);
            Eval(7066, o is EmptyStructGen<int>[], false);
            Eval(7067, o is EmptyStructGen<int>?, false);
            Eval(7068, o is EmptyStructGen<int>?[], false);
            Eval(7069, o is NotEmptyStructGen<Guid>, false);
            Eval(7070, o is NotEmptyStructGen<Guid>[], false);
            Eval(7071, o is NotEmptyStructGen<Guid>?, false);
            Eval(7072, o is NotEmptyStructGen<Guid>?[], false);
            Eval(7073, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(7074, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(7075, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(7076, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(7077, o is NestedStruct, false);
            Eval(7078, o is NestedStruct[], false);
            Eval(7079, o is NestedStruct?, false);
            Eval(7080, o is NestedStruct?[], false);
            Eval(7081, o is NestedStructGen<Decimal>, false);
            Eval(7082, o is NestedStructGen<Decimal>[], false);
            Eval(7083, o is NestedStructGen<Decimal>?, false);
            Eval(7084, o is NestedStructGen<Decimal>?[], false);
            Eval(7085, o is ExplicitFieldOffsetStruct, false);
            Eval(7086, o is ExplicitFieldOffsetStruct[], false);
            Eval(7087, o is ExplicitFieldOffsetStruct?, false);
            Eval(7088, o is ExplicitFieldOffsetStruct?[], false);
            Eval(7097, o is MarshalAsStruct, false);
            Eval(7098, o is MarshalAsStruct[], false);
            Eval(7099, o is MarshalAsStruct?, false);
            Eval(7100, o is MarshalAsStruct?[], false);
            Eval(7101, o is ImplementOneInterface, false);
            Eval(7102, o is ImplementOneInterface[], false);
            Eval(7103, o is ImplementOneInterface?, false);
            Eval(7104, o is ImplementOneInterface?[], false);
            Eval(7105, o is ImplementTwoInterface, true);
            Eval(7106, o is ImplementTwoInterface[], false);
            Eval(7107, o is ImplementTwoInterface?, true);
            Eval(7108, o is ImplementTwoInterface?[], false);
            Eval(7109, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(7110, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(7111, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(7112, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(7113, o is ImplementTwoInterfaceGen<int>, false);
            Eval(7114, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(7115, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(7116, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(7117, o is ImplementAllInterface<int>, false);
            Eval(7118, o is ImplementAllInterface<int>[], false);
            Eval(7119, o is ImplementAllInterface<int>?, false);
            Eval(7120, o is ImplementAllInterface<int>?[], false);
            Eval(7121, o is IntE, false);
            Eval(7122, o is IntE[], false);
            Eval(7123, o is IntE?, false);
            Eval(7124, o is IntE?[], false);
            Eval(7125, o is ByteE, false);
            Eval(7126, o is ByteE[], false);
            Eval(7127, o is ByteE?, false);
            Eval(7128, o is ByteE?[], false);
            Eval(7129, o is LongE, false);
            Eval(7130, o is LongE[], false);
            Eval(7131, o is LongE?, false);
            Eval(7132, o is LongE?[], false);
            Eval(7133, o is char, false);
            Eval(7134, o is char[], false);
            Eval(7135, o is char?, false);
            Eval(7136, o is char?[], false);
            Eval(7137, o is bool, false);
            Eval(7138, o is bool[], false);
            Eval(7139, o is bool?, false);
            Eval(7140, o is bool?[], false);
            Eval(7141, o is byte, false);
            Eval(7142, o is byte[], false);
            Eval(7143, o is byte?, false);
            Eval(7144, o is byte?[], false);
            Eval(7145, o is sbyte, false);
            Eval(7146, o is sbyte[], false);
            Eval(7147, o is sbyte?, false);
            Eval(7148, o is sbyte?[], false);
            Eval(7149, o is short, false);
            Eval(7150, o is short[], false);
            Eval(7151, o is short?, false);
            Eval(7152, o is short?[], false);
            Eval(7153, o is ushort, false);
            Eval(7154, o is ushort[], false);
            Eval(7155, o is ushort?, false);
            Eval(7156, o is ushort?[], false);
            Eval(7157, o is int, false);
            Eval(7158, o is int[], false);
            Eval(7159, o is int?, false);
            Eval(7160, o is int?[], false);
            Eval(7161, o is uint, false);
            Eval(7162, o is uint[], false);
            Eval(7163, o is uint?, false);
            Eval(7164, o is uint?[], false);
            Eval(7165, o is long, false);
            Eval(7166, o is long[], false);
            Eval(7167, o is long?, false);
            Eval(7168, o is long?[], false);
            Eval(7169, o is ulong, false);
            Eval(7170, o is ulong[], false);
            Eval(7171, o is ulong?, false);
            Eval(7172, o is ulong?[], false);
            Eval(7173, o is float, false);
            Eval(7174, o is float[], false);
            Eval(7175, o is float?, false);
            Eval(7176, o is float?[], false);
            Eval(7177, o is double, false);
            Eval(7178, o is double[], false);
            Eval(7179, o is double?, false);
            Eval(7180, o is double?[], false);
            Eval(7181, o is decimal, false);
            Eval(7182, o is decimal[], false);
            Eval(7183, o is decimal?, false);
            Eval(7184, o is decimal?[], false);
            Eval(7185, o is IntPtr, false);
            Eval(7186, o is IntPtr[], false);
            Eval(7187, o is IntPtr?, false);
            Eval(7188, o is IntPtr?[], false);
            Eval(7189, o is UIntPtr, false);
            Eval(7190, o is UIntPtr[], false);
            Eval(7191, o is UIntPtr?, false);
            Eval(7192, o is UIntPtr?[], false);
            Eval(7193, o is Guid, false);
            Eval(7194, o is Guid[], false);
            Eval(7195, o is Guid?, false);
            Eval(7196, o is Guid?[], false);
            Eval(7197, o is GCHandle, false);
            Eval(7198, o is GCHandle[], false);
            Eval(7199, o is GCHandle?, false);
            Eval(7200, o is GCHandle?[], false);
            Eval(7201, o is object, true);
            Eval(7202, o is object[], false);
            Eval(7203, o is string, false);
            Eval(7204, o is string[], false);
            Eval(7205, o is ValueType, true);
            Eval(7206, o is ValueType[], false);
            Eval(7207, o is Array, false);
            Eval(7208, o is Array[], false);
            Eval(7209, o is Enum, false);
            Eval(7210, o is Enum[], false);
            Eval(7211, o is Delegate, false);
            Eval(7212, o is Delegate[], false);
            Eval(7213, o is MulticastDelegate, false);
            Eval(7214, o is MulticastDelegate[], false);
            Eval(7215, o is IEmpty, true);
            Eval(7216, o is IEmpty[], false);
            Eval(7217, o is INotEmpty, true);
            Eval(7218, o is INotEmpty[], false);
            Eval(7219, o is IEmptyGen<int>, false);
            Eval(7220, o is IEmptyGen<int>[], false);
            Eval(7221, o is INotEmptyGen<int>, false);
            Eval(7222, o is INotEmptyGen<int>[], false);
            Eval(7223, o is SimpleDelegate, false);
            Eval(7224, o is SimpleDelegate[], false);
            Eval(7225, o is GenericDelegate<int>, false);
            Eval(7226, o is GenericDelegate<int>[], false);
            Eval(7227, o is EmptyClass, false);
            Eval(7228, o is EmptyClass[], false);
            Eval(7229, o is NotEmptyClass, false);
            Eval(7230, o is NotEmptyClass[], false);
            Eval(7231, o is EmptyClassGen<int>, false);
            Eval(7232, o is EmptyClassGen<int>[], false);
            Eval(7233, o is NotEmptyClassGen<Guid>, false);
            Eval(7234, o is NotEmptyClassGen<Guid>[], false);
            Eval(7235, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(7236, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(7237, o is NestedClass, false);
            Eval(7238, o is NestedClass[], false);
            Eval(7239, o is NestedClassGen<Decimal>, false);
            Eval(7240, o is NestedClassGen<Decimal>[], false);
            Eval(7241, o is ImplementOneInterfaceC, false);
            Eval(7242, o is ImplementOneInterfaceC[], false);
            Eval(7243, o is ImplementTwoInterfaceC, false);
            Eval(7244, o is ImplementTwoInterfaceC[], false);
            Eval(7245, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(7246, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(7247, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(7248, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(7249, o is ImplementAllInterfaceC<int>, false);
            Eval(7250, o is ImplementAllInterfaceC<int>[], false);
            Eval(7251, o is SealedClass, false);
            Eval(7252, o is SealedClass[], false);
        }
        {
            ImplementTwoInterface? v = default(ImplementTwoInterface);
            ValueType o = v;
            Eval(7253, o is EmptyStruct, false);
            Eval(7254, o is EmptyStruct[], false);
            Eval(7255, o is EmptyStruct?, false);
            Eval(7256, o is EmptyStruct?[], false);
            Eval(7257, o is NotEmptyStruct, false);
            Eval(7258, o is NotEmptyStruct[], false);
            Eval(7259, o is NotEmptyStruct?, false);
            Eval(7260, o is NotEmptyStruct?[], false);
            Eval(7261, o is EmptyStructGen<int>, false);
            Eval(7262, o is EmptyStructGen<int>[], false);
            Eval(7263, o is EmptyStructGen<int>?, false);
            Eval(7264, o is EmptyStructGen<int>?[], false);
            Eval(7265, o is NotEmptyStructGen<Guid>, false);
            Eval(7266, o is NotEmptyStructGen<Guid>[], false);
            Eval(7267, o is NotEmptyStructGen<Guid>?, false);
            Eval(7268, o is NotEmptyStructGen<Guid>?[], false);
            Eval(7269, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(7270, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(7271, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(7272, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(7273, o is NestedStruct, false);
            Eval(7274, o is NestedStruct[], false);
            Eval(7275, o is NestedStruct?, false);
            Eval(7276, o is NestedStruct?[], false);
            Eval(7277, o is NestedStructGen<Decimal>, false);
            Eval(7278, o is NestedStructGen<Decimal>[], false);
            Eval(7279, o is NestedStructGen<Decimal>?, false);
            Eval(7280, o is NestedStructGen<Decimal>?[], false);
            Eval(7281, o is ExplicitFieldOffsetStruct, false);
            Eval(7282, o is ExplicitFieldOffsetStruct[], false);
            Eval(7283, o is ExplicitFieldOffsetStruct?, false);
            Eval(7284, o is ExplicitFieldOffsetStruct?[], false);
            Eval(7293, o is MarshalAsStruct, false);
            Eval(7294, o is MarshalAsStruct[], false);
            Eval(7295, o is MarshalAsStruct?, false);
            Eval(7296, o is MarshalAsStruct?[], false);
            Eval(7297, o is ImplementOneInterface, false);
            Eval(7298, o is ImplementOneInterface[], false);
            Eval(7299, o is ImplementOneInterface?, false);
            Eval(7300, o is ImplementOneInterface?[], false);
            Eval(7301, o is ImplementTwoInterface, true);
            Eval(7302, o is ImplementTwoInterface[], false);
            Eval(7303, o is ImplementTwoInterface?, true);
            Eval(7304, o is ImplementTwoInterface?[], false);
            Eval(7305, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(7306, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(7307, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(7308, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(7309, o is ImplementTwoInterfaceGen<int>, false);
            Eval(7310, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(7311, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(7312, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(7313, o is ImplementAllInterface<int>, false);
            Eval(7314, o is ImplementAllInterface<int>[], false);
            Eval(7315, o is ImplementAllInterface<int>?, false);
            Eval(7316, o is ImplementAllInterface<int>?[], false);
            Eval(7317, o is IntE, false);
            Eval(7318, o is IntE[], false);
            Eval(7319, o is IntE?, false);
            Eval(7320, o is IntE?[], false);
            Eval(7321, o is ByteE, false);
            Eval(7322, o is ByteE[], false);
            Eval(7323, o is ByteE?, false);
            Eval(7324, o is ByteE?[], false);
            Eval(7325, o is LongE, false);
            Eval(7326, o is LongE[], false);
            Eval(7327, o is LongE?, false);
            Eval(7328, o is LongE?[], false);
            Eval(7329, o is char, false);
            Eval(7330, o is char[], false);
            Eval(7331, o is char?, false);
            Eval(7332, o is char?[], false);
            Eval(7333, o is bool, false);
            Eval(7334, o is bool[], false);
            Eval(7335, o is bool?, false);
            Eval(7336, o is bool?[], false);
            Eval(7337, o is byte, false);
            Eval(7338, o is byte[], false);
            Eval(7339, o is byte?, false);
            Eval(7340, o is byte?[], false);
            Eval(7341, o is sbyte, false);
            Eval(7342, o is sbyte[], false);
            Eval(7343, o is sbyte?, false);
            Eval(7344, o is sbyte?[], false);
            Eval(7345, o is short, false);
            Eval(7346, o is short[], false);
            Eval(7347, o is short?, false);
            Eval(7348, o is short?[], false);
            Eval(7349, o is ushort, false);
            Eval(7350, o is ushort[], false);
            Eval(7351, o is ushort?, false);
            Eval(7352, o is ushort?[], false);
            Eval(7353, o is int, false);
            Eval(7354, o is int[], false);
            Eval(7355, o is int?, false);
            Eval(7356, o is int?[], false);
            Eval(7357, o is uint, false);
            Eval(7358, o is uint[], false);
            Eval(7359, o is uint?, false);
            Eval(7360, o is uint?[], false);
            Eval(7361, o is long, false);
            Eval(7362, o is long[], false);
            Eval(7363, o is long?, false);
            Eval(7364, o is long?[], false);
            Eval(7365, o is ulong, false);
            Eval(7366, o is ulong[], false);
            Eval(7367, o is ulong?, false);
            Eval(7368, o is ulong?[], false);
            Eval(7369, o is float, false);
            Eval(7370, o is float[], false);
            Eval(7371, o is float?, false);
            Eval(7372, o is float?[], false);
            Eval(7373, o is double, false);
            Eval(7374, o is double[], false);
            Eval(7375, o is double?, false);
            Eval(7376, o is double?[], false);
            Eval(7377, o is decimal, false);
            Eval(7378, o is decimal[], false);
            Eval(7379, o is decimal?, false);
            Eval(7380, o is decimal?[], false);
            Eval(7381, o is IntPtr, false);
            Eval(7382, o is IntPtr[], false);
            Eval(7383, o is IntPtr?, false);
            Eval(7384, o is IntPtr?[], false);
            Eval(7385, o is UIntPtr, false);
            Eval(7386, o is UIntPtr[], false);
            Eval(7387, o is UIntPtr?, false);
            Eval(7388, o is UIntPtr?[], false);
            Eval(7389, o is Guid, false);
            Eval(7390, o is Guid[], false);
            Eval(7391, o is Guid?, false);
            Eval(7392, o is Guid?[], false);
            Eval(7393, o is GCHandle, false);
            Eval(7394, o is GCHandle[], false);
            Eval(7395, o is GCHandle?, false);
            Eval(7396, o is GCHandle?[], false);
            Eval(7397, o is object, true);
            Eval(7398, o is object[], false);
            Eval(7399, o is string, false);
            Eval(7400, o is string[], false);
            Eval(7401, o is ValueType, true);
            Eval(7402, o is ValueType[], false);
            Eval(7403, o is Array, false);
            Eval(7404, o is Array[], false);
            Eval(7405, o is Enum, false);
            Eval(7406, o is Enum[], false);
            Eval(7407, o is Delegate, false);
            Eval(7408, o is Delegate[], false);
            Eval(7409, o is MulticastDelegate, false);
            Eval(7410, o is MulticastDelegate[], false);
            Eval(7411, o is IEmpty, true);
            Eval(7412, o is IEmpty[], false);
            Eval(7413, o is INotEmpty, true);
            Eval(7414, o is INotEmpty[], false);
            Eval(7415, o is IEmptyGen<int>, false);
            Eval(7416, o is IEmptyGen<int>[], false);
            Eval(7417, o is INotEmptyGen<int>, false);
            Eval(7418, o is INotEmptyGen<int>[], false);
            Eval(7419, o is SimpleDelegate, false);
            Eval(7420, o is SimpleDelegate[], false);
            Eval(7421, o is GenericDelegate<int>, false);
            Eval(7422, o is GenericDelegate<int>[], false);
            Eval(7423, o is EmptyClass, false);
            Eval(7424, o is EmptyClass[], false);
            Eval(7425, o is NotEmptyClass, false);
            Eval(7426, o is NotEmptyClass[], false);
            Eval(7427, o is EmptyClassGen<int>, false);
            Eval(7428, o is EmptyClassGen<int>[], false);
            Eval(7429, o is NotEmptyClassGen<Guid>, false);
            Eval(7430, o is NotEmptyClassGen<Guid>[], false);
            Eval(7431, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(7432, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(7433, o is NestedClass, false);
            Eval(7434, o is NestedClass[], false);
            Eval(7435, o is NestedClassGen<Decimal>, false);
            Eval(7436, o is NestedClassGen<Decimal>[], false);
            Eval(7437, o is ImplementOneInterfaceC, false);
            Eval(7438, o is ImplementOneInterfaceC[], false);
            Eval(7439, o is ImplementTwoInterfaceC, false);
            Eval(7440, o is ImplementTwoInterfaceC[], false);
            Eval(7441, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(7442, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(7443, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(7444, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(7445, o is ImplementAllInterfaceC<int>, false);
            Eval(7446, o is ImplementAllInterfaceC<int>[], false);
            Eval(7447, o is SealedClass, false);
            Eval(7448, o is SealedClass[], false);
        }
        {
            ImplementTwoInterface? v = default(ImplementTwoInterface?);
            ValueType o = v;
            Eval(7449, o is EmptyStruct, false);
            Eval(7450, o is EmptyStruct[], false);
            Eval(7451, o is EmptyStruct?, false);
            Eval(7452, o is EmptyStruct?[], false);
            Eval(7453, o is NotEmptyStruct, false);
            Eval(7454, o is NotEmptyStruct[], false);
            Eval(7455, o is NotEmptyStruct?, false);
            Eval(7456, o is NotEmptyStruct?[], false);
            Eval(7457, o is EmptyStructGen<int>, false);
            Eval(7458, o is EmptyStructGen<int>[], false);
            Eval(7459, o is EmptyStructGen<int>?, false);
            Eval(7460, o is EmptyStructGen<int>?[], false);
            Eval(7461, o is NotEmptyStructGen<Guid>, false);
            Eval(7462, o is NotEmptyStructGen<Guid>[], false);
            Eval(7463, o is NotEmptyStructGen<Guid>?, false);
            Eval(7464, o is NotEmptyStructGen<Guid>?[], false);
            Eval(7465, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(7466, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(7467, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(7468, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(7469, o is NestedStruct, false);
            Eval(7470, o is NestedStruct[], false);
            Eval(7471, o is NestedStruct?, false);
            Eval(7472, o is NestedStruct?[], false);
            Eval(7473, o is NestedStructGen<Decimal>, false);
            Eval(7474, o is NestedStructGen<Decimal>[], false);
            Eval(7475, o is NestedStructGen<Decimal>?, false);
            Eval(7476, o is NestedStructGen<Decimal>?[], false);
            Eval(7477, o is ExplicitFieldOffsetStruct, false);
            Eval(7478, o is ExplicitFieldOffsetStruct[], false);
            Eval(7479, o is ExplicitFieldOffsetStruct?, false);
            Eval(7480, o is ExplicitFieldOffsetStruct?[], false);
            Eval(7489, o is MarshalAsStruct, false);
            Eval(7490, o is MarshalAsStruct[], false);
            Eval(7491, o is MarshalAsStruct?, false);
            Eval(7492, o is MarshalAsStruct?[], false);
            Eval(7493, o is ImplementOneInterface, false);
            Eval(7494, o is ImplementOneInterface[], false);
            Eval(7495, o is ImplementOneInterface?, false);
            Eval(7496, o is ImplementOneInterface?[], false);
            Eval(7497, o is ImplementTwoInterface, false);
            Eval(7498, o is ImplementTwoInterface[], false);
            Eval(7499, o is ImplementTwoInterface?, false);
            Eval(7500, o is ImplementTwoInterface?[], false);
            Eval(7501, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(7502, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(7503, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(7504, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(7505, o is ImplementTwoInterfaceGen<int>, false);
            Eval(7506, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(7507, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(7508, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(7509, o is ImplementAllInterface<int>, false);
            Eval(7510, o is ImplementAllInterface<int>[], false);
            Eval(7511, o is ImplementAllInterface<int>?, false);
            Eval(7512, o is ImplementAllInterface<int>?[], false);
            Eval(7513, o is IntE, false);
            Eval(7514, o is IntE[], false);
            Eval(7515, o is IntE?, false);
            Eval(7516, o is IntE?[], false);
            Eval(7517, o is ByteE, false);
            Eval(7518, o is ByteE[], false);
            Eval(7519, o is ByteE?, false);
            Eval(7520, o is ByteE?[], false);
            Eval(7521, o is LongE, false);
            Eval(7522, o is LongE[], false);
            Eval(7523, o is LongE?, false);
            Eval(7524, o is LongE?[], false);
            Eval(7525, o is char, false);
            Eval(7526, o is char[], false);
            Eval(7527, o is char?, false);
            Eval(7528, o is char?[], false);
            Eval(7529, o is bool, false);
            Eval(7530, o is bool[], false);
            Eval(7531, o is bool?, false);
            Eval(7532, o is bool?[], false);
            Eval(7533, o is byte, false);
            Eval(7534, o is byte[], false);
            Eval(7535, o is byte?, false);
            Eval(7536, o is byte?[], false);
            Eval(7537, o is sbyte, false);
            Eval(7538, o is sbyte[], false);
            Eval(7539, o is sbyte?, false);
            Eval(7540, o is sbyte?[], false);
            Eval(7541, o is short, false);
            Eval(7542, o is short[], false);
            Eval(7543, o is short?, false);
            Eval(7544, o is short?[], false);
            Eval(7545, o is ushort, false);
            Eval(7546, o is ushort[], false);
            Eval(7547, o is ushort?, false);
            Eval(7548, o is ushort?[], false);
            Eval(7549, o is int, false);
            Eval(7550, o is int[], false);
            Eval(7551, o is int?, false);
            Eval(7552, o is int?[], false);
            Eval(7553, o is uint, false);
            Eval(7554, o is uint[], false);
            Eval(7555, o is uint?, false);
            Eval(7556, o is uint?[], false);
            Eval(7557, o is long, false);
            Eval(7558, o is long[], false);
            Eval(7559, o is long?, false);
            Eval(7560, o is long?[], false);
            Eval(7561, o is ulong, false);
            Eval(7562, o is ulong[], false);
            Eval(7563, o is ulong?, false);
            Eval(7564, o is ulong?[], false);
            Eval(7565, o is float, false);
            Eval(7566, o is float[], false);
            Eval(7567, o is float?, false);
            Eval(7568, o is float?[], false);
            Eval(7569, o is double, false);
            Eval(7570, o is double[], false);
            Eval(7571, o is double?, false);
            Eval(7572, o is double?[], false);
            Eval(7573, o is decimal, false);
            Eval(7574, o is decimal[], false);
            Eval(7575, o is decimal?, false);
            Eval(7576, o is decimal?[], false);
            Eval(7577, o is IntPtr, false);
            Eval(7578, o is IntPtr[], false);
            Eval(7579, o is IntPtr?, false);
            Eval(7580, o is IntPtr?[], false);
            Eval(7581, o is UIntPtr, false);
            Eval(7582, o is UIntPtr[], false);
            Eval(7583, o is UIntPtr?, false);
            Eval(7584, o is UIntPtr?[], false);
            Eval(7585, o is Guid, false);
            Eval(7586, o is Guid[], false);
            Eval(7587, o is Guid?, false);
            Eval(7588, o is Guid?[], false);
            Eval(7589, o is GCHandle, false);
            Eval(7590, o is GCHandle[], false);
            Eval(7591, o is GCHandle?, false);
            Eval(7592, o is GCHandle?[], false);
            Eval(7593, o is object, false);
            Eval(7594, o is object[], false);
            Eval(7595, o is string, false);
            Eval(7596, o is string[], false);
            Eval(7597, o is ValueType, false);
            Eval(7598, o is ValueType[], false);
            Eval(7599, o is Array, false);
            Eval(7600, o is Array[], false);
            Eval(7601, o is Enum, false);
            Eval(7602, o is Enum[], false);
            Eval(7603, o is Delegate, false);
            Eval(7604, o is Delegate[], false);
            Eval(7605, o is MulticastDelegate, false);
            Eval(7606, o is MulticastDelegate[], false);
            Eval(7607, o is IEmpty, false);
            Eval(7608, o is IEmpty[], false);
            Eval(7609, o is INotEmpty, false);
            Eval(7610, o is INotEmpty[], false);
            Eval(7611, o is IEmptyGen<int>, false);
            Eval(7612, o is IEmptyGen<int>[], false);
            Eval(7613, o is INotEmptyGen<int>, false);
            Eval(7614, o is INotEmptyGen<int>[], false);
            Eval(7615, o is SimpleDelegate, false);
            Eval(7616, o is SimpleDelegate[], false);
            Eval(7617, o is GenericDelegate<int>, false);
            Eval(7618, o is GenericDelegate<int>[], false);
            Eval(7619, o is EmptyClass, false);
            Eval(7620, o is EmptyClass[], false);
            Eval(7621, o is NotEmptyClass, false);
            Eval(7622, o is NotEmptyClass[], false);
            Eval(7623, o is EmptyClassGen<int>, false);
            Eval(7624, o is EmptyClassGen<int>[], false);
            Eval(7625, o is NotEmptyClassGen<Guid>, false);
            Eval(7626, o is NotEmptyClassGen<Guid>[], false);
            Eval(7627, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(7628, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(7629, o is NestedClass, false);
            Eval(7630, o is NestedClass[], false);
            Eval(7631, o is NestedClassGen<Decimal>, false);
            Eval(7632, o is NestedClassGen<Decimal>[], false);
            Eval(7633, o is ImplementOneInterfaceC, false);
            Eval(7634, o is ImplementOneInterfaceC[], false);
            Eval(7635, o is ImplementTwoInterfaceC, false);
            Eval(7636, o is ImplementTwoInterfaceC[], false);
            Eval(7637, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(7638, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(7639, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(7640, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(7641, o is ImplementAllInterfaceC<int>, false);
            Eval(7642, o is ImplementAllInterfaceC<int>[], false);
            Eval(7643, o is SealedClass, false);
            Eval(7644, o is SealedClass[], false);
        }
    }  // end of test case 0013
    private static void TestCase0014()
    {
        {
            ImplementOneInterfaceGen<EmptyStructGen<int>> v = default(ImplementOneInterfaceGen<EmptyStructGen<int>>);
            ValueType o = v;
            Eval(7645, o is EmptyStruct, false);
            Eval(7646, o is EmptyStruct[], false);
            Eval(7647, o is EmptyStruct?, false);
            Eval(7648, o is EmptyStruct?[], false);
            Eval(7649, o is NotEmptyStruct, false);
            Eval(7650, o is NotEmptyStruct[], false);
            Eval(7651, o is NotEmptyStruct?, false);
            Eval(7652, o is NotEmptyStruct?[], false);
            Eval(7653, o is EmptyStructGen<int>, false);
            Eval(7654, o is EmptyStructGen<int>[], false);
            Eval(7655, o is EmptyStructGen<int>?, false);
            Eval(7656, o is EmptyStructGen<int>?[], false);
            Eval(7657, o is NotEmptyStructGen<Guid>, false);
            Eval(7658, o is NotEmptyStructGen<Guid>[], false);
            Eval(7659, o is NotEmptyStructGen<Guid>?, false);
            Eval(7660, o is NotEmptyStructGen<Guid>?[], false);
            Eval(7661, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(7662, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(7663, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(7664, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(7665, o is NestedStruct, false);
            Eval(7666, o is NestedStruct[], false);
            Eval(7667, o is NestedStruct?, false);
            Eval(7668, o is NestedStruct?[], false);
            Eval(7669, o is NestedStructGen<Decimal>, false);
            Eval(7670, o is NestedStructGen<Decimal>[], false);
            Eval(7671, o is NestedStructGen<Decimal>?, false);
            Eval(7672, o is NestedStructGen<Decimal>?[], false);
            Eval(7673, o is ExplicitFieldOffsetStruct, false);
            Eval(7674, o is ExplicitFieldOffsetStruct[], false);
            Eval(7675, o is ExplicitFieldOffsetStruct?, false);
            Eval(7676, o is ExplicitFieldOffsetStruct?[], false);
            Eval(7685, o is MarshalAsStruct, false);
            Eval(7686, o is MarshalAsStruct[], false);
            Eval(7687, o is MarshalAsStruct?, false);
            Eval(7688, o is MarshalAsStruct?[], false);
            Eval(7689, o is ImplementOneInterface, false);
            Eval(7690, o is ImplementOneInterface[], false);
            Eval(7691, o is ImplementOneInterface?, false);
            Eval(7692, o is ImplementOneInterface?[], false);
            Eval(7693, o is ImplementTwoInterface, false);
            Eval(7694, o is ImplementTwoInterface[], false);
            Eval(7695, o is ImplementTwoInterface?, false);
            Eval(7696, o is ImplementTwoInterface?[], false);
            Eval(7697, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, true);
            Eval(7698, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(7699, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, true);
            Eval(7700, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(7701, o is ImplementTwoInterfaceGen<int>, false);
            Eval(7702, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(7703, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(7704, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(7705, o is ImplementAllInterface<int>, false);
            Eval(7706, o is ImplementAllInterface<int>[], false);
            Eval(7707, o is ImplementAllInterface<int>?, false);
            Eval(7708, o is ImplementAllInterface<int>?[], false);
            Eval(7709, o is IntE, false);
            Eval(7710, o is IntE[], false);
            Eval(7711, o is IntE?, false);
            Eval(7712, o is IntE?[], false);
            Eval(7713, o is ByteE, false);
            Eval(7714, o is ByteE[], false);
            Eval(7715, o is ByteE?, false);
            Eval(7716, o is ByteE?[], false);
            Eval(7717, o is LongE, false);
            Eval(7718, o is LongE[], false);
            Eval(7719, o is LongE?, false);
            Eval(7720, o is LongE?[], false);
            Eval(7721, o is char, false);
            Eval(7722, o is char[], false);
            Eval(7723, o is char?, false);
            Eval(7724, o is char?[], false);
            Eval(7725, o is bool, false);
            Eval(7726, o is bool[], false);
            Eval(7727, o is bool?, false);
            Eval(7728, o is bool?[], false);
            Eval(7729, o is byte, false);
            Eval(7730, o is byte[], false);
            Eval(7731, o is byte?, false);
            Eval(7732, o is byte?[], false);
            Eval(7733, o is sbyte, false);
            Eval(7734, o is sbyte[], false);
            Eval(7735, o is sbyte?, false);
            Eval(7736, o is sbyte?[], false);
            Eval(7737, o is short, false);
            Eval(7738, o is short[], false);
            Eval(7739, o is short?, false);
            Eval(7740, o is short?[], false);
            Eval(7741, o is ushort, false);
            Eval(7742, o is ushort[], false);
            Eval(7743, o is ushort?, false);
            Eval(7744, o is ushort?[], false);
            Eval(7745, o is int, false);
            Eval(7746, o is int[], false);
            Eval(7747, o is int?, false);
            Eval(7748, o is int?[], false);
            Eval(7749, o is uint, false);
            Eval(7750, o is uint[], false);
            Eval(7751, o is uint?, false);
            Eval(7752, o is uint?[], false);
            Eval(7753, o is long, false);
            Eval(7754, o is long[], false);
            Eval(7755, o is long?, false);
            Eval(7756, o is long?[], false);
            Eval(7757, o is ulong, false);
            Eval(7758, o is ulong[], false);
            Eval(7759, o is ulong?, false);
            Eval(7760, o is ulong?[], false);
            Eval(7761, o is float, false);
            Eval(7762, o is float[], false);
            Eval(7763, o is float?, false);
            Eval(7764, o is float?[], false);
            Eval(7765, o is double, false);
            Eval(7766, o is double[], false);
            Eval(7767, o is double?, false);
            Eval(7768, o is double?[], false);
            Eval(7769, o is decimal, false);
            Eval(7770, o is decimal[], false);
            Eval(7771, o is decimal?, false);
            Eval(7772, o is decimal?[], false);
            Eval(7773, o is IntPtr, false);
            Eval(7774, o is IntPtr[], false);
            Eval(7775, o is IntPtr?, false);
            Eval(7776, o is IntPtr?[], false);
            Eval(7777, o is UIntPtr, false);
            Eval(7778, o is UIntPtr[], false);
            Eval(7779, o is UIntPtr?, false);
            Eval(7780, o is UIntPtr?[], false);
            Eval(7781, o is Guid, false);
            Eval(7782, o is Guid[], false);
            Eval(7783, o is Guid?, false);
            Eval(7784, o is Guid?[], false);
            Eval(7785, o is GCHandle, false);
            Eval(7786, o is GCHandle[], false);
            Eval(7787, o is GCHandle?, false);
            Eval(7788, o is GCHandle?[], false);
            Eval(7789, o is object, true);
            Eval(7790, o is object[], false);
            Eval(7791, o is string, false);
            Eval(7792, o is string[], false);
            Eval(7793, o is ValueType, true);
            Eval(7794, o is ValueType[], false);
            Eval(7795, o is Array, false);
            Eval(7796, o is Array[], false);
            Eval(7797, o is Enum, false);
            Eval(7798, o is Enum[], false);
            Eval(7799, o is Delegate, false);
            Eval(7800, o is Delegate[], false);
            Eval(7801, o is MulticastDelegate, false);
            Eval(7802, o is MulticastDelegate[], false);
            Eval(7803, o is IEmpty, false);
            Eval(7804, o is IEmpty[], false);
            Eval(7805, o is INotEmpty, false);
            Eval(7806, o is INotEmpty[], false);
            Eval(7807, o is IEmptyGen<int>, false);
            Eval(7808, o is IEmptyGen<int>[], false);
            Eval(7809, o is INotEmptyGen<int>, false);
            Eval(7810, o is INotEmptyGen<int>[], false);
            Eval(7811, o is SimpleDelegate, false);
            Eval(7812, o is SimpleDelegate[], false);
            Eval(7813, o is GenericDelegate<int>, false);
            Eval(7814, o is GenericDelegate<int>[], false);
            Eval(7815, o is EmptyClass, false);
            Eval(7816, o is EmptyClass[], false);
            Eval(7817, o is NotEmptyClass, false);
            Eval(7818, o is NotEmptyClass[], false);
            Eval(7819, o is EmptyClassGen<int>, false);
            Eval(7820, o is EmptyClassGen<int>[], false);
            Eval(7821, o is NotEmptyClassGen<Guid>, false);
            Eval(7822, o is NotEmptyClassGen<Guid>[], false);
            Eval(7823, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(7824, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(7825, o is NestedClass, false);
            Eval(7826, o is NestedClass[], false);
            Eval(7827, o is NestedClassGen<Decimal>, false);
            Eval(7828, o is NestedClassGen<Decimal>[], false);
            Eval(7829, o is ImplementOneInterfaceC, false);
            Eval(7830, o is ImplementOneInterfaceC[], false);
            Eval(7831, o is ImplementTwoInterfaceC, false);
            Eval(7832, o is ImplementTwoInterfaceC[], false);
            Eval(7833, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(7834, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(7835, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(7836, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(7837, o is ImplementAllInterfaceC<int>, false);
            Eval(7838, o is ImplementAllInterfaceC<int>[], false);
            Eval(7839, o is SealedClass, false);
            Eval(7840, o is SealedClass[], false);
        }
        {
            ImplementOneInterfaceGen<EmptyStructGen<int>>? v = default(ImplementOneInterfaceGen<EmptyStructGen<int>>);
            ValueType o = v;
            Eval(7841, o is EmptyStruct, false);
            Eval(7842, o is EmptyStruct[], false);
            Eval(7843, o is EmptyStruct?, false);
            Eval(7844, o is EmptyStruct?[], false);
            Eval(7845, o is NotEmptyStruct, false);
            Eval(7846, o is NotEmptyStruct[], false);
            Eval(7847, o is NotEmptyStruct?, false);
            Eval(7848, o is NotEmptyStruct?[], false);
            Eval(7849, o is EmptyStructGen<int>, false);
            Eval(7850, o is EmptyStructGen<int>[], false);
            Eval(7851, o is EmptyStructGen<int>?, false);
            Eval(7852, o is EmptyStructGen<int>?[], false);
            Eval(7853, o is NotEmptyStructGen<Guid>, false);
            Eval(7854, o is NotEmptyStructGen<Guid>[], false);
            Eval(7855, o is NotEmptyStructGen<Guid>?, false);
            Eval(7856, o is NotEmptyStructGen<Guid>?[], false);
            Eval(7857, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(7858, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(7859, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(7860, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(7861, o is NestedStruct, false);
            Eval(7862, o is NestedStruct[], false);
            Eval(7863, o is NestedStruct?, false);
            Eval(7864, o is NestedStruct?[], false);
            Eval(7865, o is NestedStructGen<Decimal>, false);
            Eval(7866, o is NestedStructGen<Decimal>[], false);
            Eval(7867, o is NestedStructGen<Decimal>?, false);
            Eval(7868, o is NestedStructGen<Decimal>?[], false);
            Eval(7869, o is ExplicitFieldOffsetStruct, false);
            Eval(7870, o is ExplicitFieldOffsetStruct[], false);
            Eval(7871, o is ExplicitFieldOffsetStruct?, false);
            Eval(7872, o is ExplicitFieldOffsetStruct?[], false);
            Eval(7881, o is MarshalAsStruct, false);
            Eval(7882, o is MarshalAsStruct[], false);
            Eval(7883, o is MarshalAsStruct?, false);
            Eval(7884, o is MarshalAsStruct?[], false);
            Eval(7885, o is ImplementOneInterface, false);
            Eval(7886, o is ImplementOneInterface[], false);
            Eval(7887, o is ImplementOneInterface?, false);
            Eval(7888, o is ImplementOneInterface?[], false);
            Eval(7889, o is ImplementTwoInterface, false);
            Eval(7890, o is ImplementTwoInterface[], false);
            Eval(7891, o is ImplementTwoInterface?, false);
            Eval(7892, o is ImplementTwoInterface?[], false);
            Eval(7893, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, true);
            Eval(7894, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(7895, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, true);
            Eval(7896, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(7897, o is ImplementTwoInterfaceGen<int>, false);
            Eval(7898, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(7899, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(7900, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(7901, o is ImplementAllInterface<int>, false);
            Eval(7902, o is ImplementAllInterface<int>[], false);
            Eval(7903, o is ImplementAllInterface<int>?, false);
            Eval(7904, o is ImplementAllInterface<int>?[], false);
            Eval(7905, o is IntE, false);
            Eval(7906, o is IntE[], false);
            Eval(7907, o is IntE?, false);
            Eval(7908, o is IntE?[], false);
            Eval(7909, o is ByteE, false);
            Eval(7910, o is ByteE[], false);
            Eval(7911, o is ByteE?, false);
            Eval(7912, o is ByteE?[], false);
            Eval(7913, o is LongE, false);
            Eval(7914, o is LongE[], false);
            Eval(7915, o is LongE?, false);
            Eval(7916, o is LongE?[], false);
            Eval(7917, o is char, false);
            Eval(7918, o is char[], false);
            Eval(7919, o is char?, false);
            Eval(7920, o is char?[], false);
            Eval(7921, o is bool, false);
            Eval(7922, o is bool[], false);
            Eval(7923, o is bool?, false);
            Eval(7924, o is bool?[], false);
            Eval(7925, o is byte, false);
            Eval(7926, o is byte[], false);
            Eval(7927, o is byte?, false);
            Eval(7928, o is byte?[], false);
            Eval(7929, o is sbyte, false);
            Eval(7930, o is sbyte[], false);
            Eval(7931, o is sbyte?, false);
            Eval(7932, o is sbyte?[], false);
            Eval(7933, o is short, false);
            Eval(7934, o is short[], false);
            Eval(7935, o is short?, false);
            Eval(7936, o is short?[], false);
            Eval(7937, o is ushort, false);
            Eval(7938, o is ushort[], false);
            Eval(7939, o is ushort?, false);
            Eval(7940, o is ushort?[], false);
            Eval(7941, o is int, false);
            Eval(7942, o is int[], false);
            Eval(7943, o is int?, false);
            Eval(7944, o is int?[], false);
            Eval(7945, o is uint, false);
            Eval(7946, o is uint[], false);
            Eval(7947, o is uint?, false);
            Eval(7948, o is uint?[], false);
            Eval(7949, o is long, false);
            Eval(7950, o is long[], false);
            Eval(7951, o is long?, false);
            Eval(7952, o is long?[], false);
            Eval(7953, o is ulong, false);
            Eval(7954, o is ulong[], false);
            Eval(7955, o is ulong?, false);
            Eval(7956, o is ulong?[], false);
            Eval(7957, o is float, false);
            Eval(7958, o is float[], false);
            Eval(7959, o is float?, false);
            Eval(7960, o is float?[], false);
            Eval(7961, o is double, false);
            Eval(7962, o is double[], false);
            Eval(7963, o is double?, false);
            Eval(7964, o is double?[], false);
            Eval(7965, o is decimal, false);
            Eval(7966, o is decimal[], false);
            Eval(7967, o is decimal?, false);
            Eval(7968, o is decimal?[], false);
            Eval(7969, o is IntPtr, false);
            Eval(7970, o is IntPtr[], false);
            Eval(7971, o is IntPtr?, false);
            Eval(7972, o is IntPtr?[], false);
            Eval(7973, o is UIntPtr, false);
            Eval(7974, o is UIntPtr[], false);
            Eval(7975, o is UIntPtr?, false);
            Eval(7976, o is UIntPtr?[], false);
            Eval(7977, o is Guid, false);
            Eval(7978, o is Guid[], false);
            Eval(7979, o is Guid?, false);
            Eval(7980, o is Guid?[], false);
            Eval(7981, o is GCHandle, false);
            Eval(7982, o is GCHandle[], false);
            Eval(7983, o is GCHandle?, false);
            Eval(7984, o is GCHandle?[], false);
            Eval(7985, o is object, true);
            Eval(7986, o is object[], false);
            Eval(7987, o is string, false);
            Eval(7988, o is string[], false);
            Eval(7989, o is ValueType, true);
            Eval(7990, o is ValueType[], false);
            Eval(7991, o is Array, false);
            Eval(7992, o is Array[], false);
            Eval(7993, o is Enum, false);
            Eval(7994, o is Enum[], false);
            Eval(7995, o is Delegate, false);
            Eval(7996, o is Delegate[], false);
            Eval(7997, o is MulticastDelegate, false);
            Eval(7998, o is MulticastDelegate[], false);
            Eval(7999, o is IEmpty, false);
            Eval(8000, o is IEmpty[], false);
            Eval(8001, o is INotEmpty, false);
            Eval(8002, o is INotEmpty[], false);
            Eval(8003, o is IEmptyGen<int>, false);
            Eval(8004, o is IEmptyGen<int>[], false);
            Eval(8005, o is INotEmptyGen<int>, false);
            Eval(8006, o is INotEmptyGen<int>[], false);
            Eval(8007, o is SimpleDelegate, false);
            Eval(8008, o is SimpleDelegate[], false);
            Eval(8009, o is GenericDelegate<int>, false);
            Eval(8010, o is GenericDelegate<int>[], false);
            Eval(8011, o is EmptyClass, false);
            Eval(8012, o is EmptyClass[], false);
            Eval(8013, o is NotEmptyClass, false);
            Eval(8014, o is NotEmptyClass[], false);
            Eval(8015, o is EmptyClassGen<int>, false);
            Eval(8016, o is EmptyClassGen<int>[], false);
            Eval(8017, o is NotEmptyClassGen<Guid>, false);
            Eval(8018, o is NotEmptyClassGen<Guid>[], false);
            Eval(8019, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(8020, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(8021, o is NestedClass, false);
            Eval(8022, o is NestedClass[], false);
            Eval(8023, o is NestedClassGen<Decimal>, false);
            Eval(8024, o is NestedClassGen<Decimal>[], false);
            Eval(8025, o is ImplementOneInterfaceC, false);
            Eval(8026, o is ImplementOneInterfaceC[], false);
            Eval(8027, o is ImplementTwoInterfaceC, false);
            Eval(8028, o is ImplementTwoInterfaceC[], false);
            Eval(8029, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(8030, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(8031, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(8032, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(8033, o is ImplementAllInterfaceC<int>, false);
            Eval(8034, o is ImplementAllInterfaceC<int>[], false);
            Eval(8035, o is SealedClass, false);
            Eval(8036, o is SealedClass[], false);
        }
        {
            ImplementOneInterfaceGen<EmptyStructGen<int>>? v = default(ImplementOneInterfaceGen<EmptyStructGen<int>>?);
            ValueType o = v;
            Eval(8037, o is EmptyStruct, false);
            Eval(8038, o is EmptyStruct[], false);
            Eval(8039, o is EmptyStruct?, false);
            Eval(8040, o is EmptyStruct?[], false);
            Eval(8041, o is NotEmptyStruct, false);
            Eval(8042, o is NotEmptyStruct[], false);
            Eval(8043, o is NotEmptyStruct?, false);
            Eval(8044, o is NotEmptyStruct?[], false);
            Eval(8045, o is EmptyStructGen<int>, false);
            Eval(8046, o is EmptyStructGen<int>[], false);
            Eval(8047, o is EmptyStructGen<int>?, false);
            Eval(8048, o is EmptyStructGen<int>?[], false);
            Eval(8049, o is NotEmptyStructGen<Guid>, false);
            Eval(8050, o is NotEmptyStructGen<Guid>[], false);
            Eval(8051, o is NotEmptyStructGen<Guid>?, false);
            Eval(8052, o is NotEmptyStructGen<Guid>?[], false);
            Eval(8053, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(8054, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(8055, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(8056, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(8057, o is NestedStruct, false);
            Eval(8058, o is NestedStruct[], false);
            Eval(8059, o is NestedStruct?, false);
            Eval(8060, o is NestedStruct?[], false);
            Eval(8061, o is NestedStructGen<Decimal>, false);
            Eval(8062, o is NestedStructGen<Decimal>[], false);
            Eval(8063, o is NestedStructGen<Decimal>?, false);
            Eval(8064, o is NestedStructGen<Decimal>?[], false);
            Eval(8065, o is ExplicitFieldOffsetStruct, false);
            Eval(8066, o is ExplicitFieldOffsetStruct[], false);
            Eval(8067, o is ExplicitFieldOffsetStruct?, false);
            Eval(8068, o is ExplicitFieldOffsetStruct?[], false);
            Eval(8077, o is MarshalAsStruct, false);
            Eval(8078, o is MarshalAsStruct[], false);
            Eval(8079, o is MarshalAsStruct?, false);
            Eval(8080, o is MarshalAsStruct?[], false);
            Eval(8081, o is ImplementOneInterface, false);
            Eval(8082, o is ImplementOneInterface[], false);
            Eval(8083, o is ImplementOneInterface?, false);
            Eval(8084, o is ImplementOneInterface?[], false);
            Eval(8085, o is ImplementTwoInterface, false);
            Eval(8086, o is ImplementTwoInterface[], false);
            Eval(8087, o is ImplementTwoInterface?, false);
            Eval(8088, o is ImplementTwoInterface?[], false);
            Eval(8089, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(8090, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(8091, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(8092, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(8093, o is ImplementTwoInterfaceGen<int>, false);
            Eval(8094, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(8095, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(8096, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(8097, o is ImplementAllInterface<int>, false);
            Eval(8098, o is ImplementAllInterface<int>[], false);
            Eval(8099, o is ImplementAllInterface<int>?, false);
            Eval(8100, o is ImplementAllInterface<int>?[], false);
            Eval(8101, o is IntE, false);
            Eval(8102, o is IntE[], false);
            Eval(8103, o is IntE?, false);
            Eval(8104, o is IntE?[], false);
            Eval(8105, o is ByteE, false);
            Eval(8106, o is ByteE[], false);
            Eval(8107, o is ByteE?, false);
            Eval(8108, o is ByteE?[], false);
            Eval(8109, o is LongE, false);
            Eval(8110, o is LongE[], false);
            Eval(8111, o is LongE?, false);
            Eval(8112, o is LongE?[], false);
            Eval(8113, o is char, false);
            Eval(8114, o is char[], false);
            Eval(8115, o is char?, false);
            Eval(8116, o is char?[], false);
            Eval(8117, o is bool, false);
            Eval(8118, o is bool[], false);
            Eval(8119, o is bool?, false);
            Eval(8120, o is bool?[], false);
            Eval(8121, o is byte, false);
            Eval(8122, o is byte[], false);
            Eval(8123, o is byte?, false);
            Eval(8124, o is byte?[], false);
            Eval(8125, o is sbyte, false);
            Eval(8126, o is sbyte[], false);
            Eval(8127, o is sbyte?, false);
            Eval(8128, o is sbyte?[], false);
            Eval(8129, o is short, false);
            Eval(8130, o is short[], false);
            Eval(8131, o is short?, false);
            Eval(8132, o is short?[], false);
            Eval(8133, o is ushort, false);
            Eval(8134, o is ushort[], false);
            Eval(8135, o is ushort?, false);
            Eval(8136, o is ushort?[], false);
            Eval(8137, o is int, false);
            Eval(8138, o is int[], false);
            Eval(8139, o is int?, false);
            Eval(8140, o is int?[], false);
            Eval(8141, o is uint, false);
            Eval(8142, o is uint[], false);
            Eval(8143, o is uint?, false);
            Eval(8144, o is uint?[], false);
            Eval(8145, o is long, false);
            Eval(8146, o is long[], false);
            Eval(8147, o is long?, false);
            Eval(8148, o is long?[], false);
            Eval(8149, o is ulong, false);
            Eval(8150, o is ulong[], false);
            Eval(8151, o is ulong?, false);
            Eval(8152, o is ulong?[], false);
            Eval(8153, o is float, false);
            Eval(8154, o is float[], false);
            Eval(8155, o is float?, false);
            Eval(8156, o is float?[], false);
            Eval(8157, o is double, false);
            Eval(8158, o is double[], false);
            Eval(8159, o is double?, false);
            Eval(8160, o is double?[], false);
            Eval(8161, o is decimal, false);
            Eval(8162, o is decimal[], false);
            Eval(8163, o is decimal?, false);
            Eval(8164, o is decimal?[], false);
            Eval(8165, o is IntPtr, false);
            Eval(8166, o is IntPtr[], false);
            Eval(8167, o is IntPtr?, false);
            Eval(8168, o is IntPtr?[], false);
            Eval(8169, o is UIntPtr, false);
            Eval(8170, o is UIntPtr[], false);
            Eval(8171, o is UIntPtr?, false);
            Eval(8172, o is UIntPtr?[], false);
            Eval(8173, o is Guid, false);
            Eval(8174, o is Guid[], false);
            Eval(8175, o is Guid?, false);
            Eval(8176, o is Guid?[], false);
            Eval(8177, o is GCHandle, false);
            Eval(8178, o is GCHandle[], false);
            Eval(8179, o is GCHandle?, false);
            Eval(8180, o is GCHandle?[], false);
            Eval(8181, o is object, false);
            Eval(8182, o is object[], false);
            Eval(8183, o is string, false);
            Eval(8184, o is string[], false);
            Eval(8185, o is ValueType, false);
            Eval(8186, o is ValueType[], false);
            Eval(8187, o is Array, false);
            Eval(8188, o is Array[], false);
            Eval(8189, o is Enum, false);
            Eval(8190, o is Enum[], false);
            Eval(8191, o is Delegate, false);
            Eval(8192, o is Delegate[], false);
            Eval(8193, o is MulticastDelegate, false);
            Eval(8194, o is MulticastDelegate[], false);
            Eval(8195, o is IEmpty, false);
            Eval(8196, o is IEmpty[], false);
            Eval(8197, o is INotEmpty, false);
            Eval(8198, o is INotEmpty[], false);
            Eval(8199, o is IEmptyGen<int>, false);
            Eval(8200, o is IEmptyGen<int>[], false);
            Eval(8201, o is INotEmptyGen<int>, false);
            Eval(8202, o is INotEmptyGen<int>[], false);
            Eval(8203, o is SimpleDelegate, false);
            Eval(8204, o is SimpleDelegate[], false);
            Eval(8205, o is GenericDelegate<int>, false);
            Eval(8206, o is GenericDelegate<int>[], false);
            Eval(8207, o is EmptyClass, false);
            Eval(8208, o is EmptyClass[], false);
            Eval(8209, o is NotEmptyClass, false);
            Eval(8210, o is NotEmptyClass[], false);
            Eval(8211, o is EmptyClassGen<int>, false);
            Eval(8212, o is EmptyClassGen<int>[], false);
            Eval(8213, o is NotEmptyClassGen<Guid>, false);
            Eval(8214, o is NotEmptyClassGen<Guid>[], false);
            Eval(8215, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(8216, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(8217, o is NestedClass, false);
            Eval(8218, o is NestedClass[], false);
            Eval(8219, o is NestedClassGen<Decimal>, false);
            Eval(8220, o is NestedClassGen<Decimal>[], false);
            Eval(8221, o is ImplementOneInterfaceC, false);
            Eval(8222, o is ImplementOneInterfaceC[], false);
            Eval(8223, o is ImplementTwoInterfaceC, false);
            Eval(8224, o is ImplementTwoInterfaceC[], false);
            Eval(8225, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(8226, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(8227, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(8228, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(8229, o is ImplementAllInterfaceC<int>, false);
            Eval(8230, o is ImplementAllInterfaceC<int>[], false);
            Eval(8231, o is SealedClass, false);
            Eval(8232, o is SealedClass[], false);
        }
    }  // end of test case 0014
    private static void TestCase0015()
    {
        {
            ImplementTwoInterfaceGen<int> v = default(ImplementTwoInterfaceGen<int>);
            ValueType o = v;
            Eval(8233, o is EmptyStruct, false);
            Eval(8234, o is EmptyStruct[], false);
            Eval(8235, o is EmptyStruct?, false);
            Eval(8236, o is EmptyStruct?[], false);
            Eval(8237, o is NotEmptyStruct, false);
            Eval(8238, o is NotEmptyStruct[], false);
            Eval(8239, o is NotEmptyStruct?, false);
            Eval(8240, o is NotEmptyStruct?[], false);
            Eval(8241, o is EmptyStructGen<int>, false);
            Eval(8242, o is EmptyStructGen<int>[], false);
            Eval(8243, o is EmptyStructGen<int>?, false);
            Eval(8244, o is EmptyStructGen<int>?[], false);
            Eval(8245, o is NotEmptyStructGen<Guid>, false);
            Eval(8246, o is NotEmptyStructGen<Guid>[], false);
            Eval(8247, o is NotEmptyStructGen<Guid>?, false);
            Eval(8248, o is NotEmptyStructGen<Guid>?[], false);
            Eval(8249, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(8250, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(8251, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(8252, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(8253, o is NestedStruct, false);
            Eval(8254, o is NestedStruct[], false);
            Eval(8255, o is NestedStruct?, false);
            Eval(8256, o is NestedStruct?[], false);
            Eval(8257, o is NestedStructGen<Decimal>, false);
            Eval(8258, o is NestedStructGen<Decimal>[], false);
            Eval(8259, o is NestedStructGen<Decimal>?, false);
            Eval(8260, o is NestedStructGen<Decimal>?[], false);
            Eval(8261, o is ExplicitFieldOffsetStruct, false);
            Eval(8262, o is ExplicitFieldOffsetStruct[], false);
            Eval(8263, o is ExplicitFieldOffsetStruct?, false);
            Eval(8264, o is ExplicitFieldOffsetStruct?[], false);
            Eval(8273, o is MarshalAsStruct, false);
            Eval(8274, o is MarshalAsStruct[], false);
            Eval(8275, o is MarshalAsStruct?, false);
            Eval(8276, o is MarshalAsStruct?[], false);
            Eval(8277, o is ImplementOneInterface, false);
            Eval(8278, o is ImplementOneInterface[], false);
            Eval(8279, o is ImplementOneInterface?, false);
            Eval(8280, o is ImplementOneInterface?[], false);
            Eval(8281, o is ImplementTwoInterface, false);
            Eval(8282, o is ImplementTwoInterface[], false);
            Eval(8283, o is ImplementTwoInterface?, false);
            Eval(8284, o is ImplementTwoInterface?[], false);
            Eval(8285, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(8286, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(8287, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(8288, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(8289, o is ImplementTwoInterfaceGen<int>, true);
            Eval(8290, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(8291, o is ImplementTwoInterfaceGen<int>?, true);
            Eval(8292, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(8293, o is ImplementAllInterface<int>, false);
            Eval(8294, o is ImplementAllInterface<int>[], false);
            Eval(8295, o is ImplementAllInterface<int>?, false);
            Eval(8296, o is ImplementAllInterface<int>?[], false);
            Eval(8297, o is IntE, false);
            Eval(8298, o is IntE[], false);
            Eval(8299, o is IntE?, false);
            Eval(8300, o is IntE?[], false);
            Eval(8301, o is ByteE, false);
            Eval(8302, o is ByteE[], false);
            Eval(8303, o is ByteE?, false);
            Eval(8304, o is ByteE?[], false);
            Eval(8305, o is LongE, false);
            Eval(8306, o is LongE[], false);
            Eval(8307, o is LongE?, false);
            Eval(8308, o is LongE?[], false);
            Eval(8309, o is char, false);
            Eval(8310, o is char[], false);
            Eval(8311, o is char?, false);
            Eval(8312, o is char?[], false);
            Eval(8313, o is bool, false);
            Eval(8314, o is bool[], false);
            Eval(8315, o is bool?, false);
            Eval(8316, o is bool?[], false);
            Eval(8317, o is byte, false);
            Eval(8318, o is byte[], false);
            Eval(8319, o is byte?, false);
            Eval(8320, o is byte?[], false);
            Eval(8321, o is sbyte, false);
            Eval(8322, o is sbyte[], false);
            Eval(8323, o is sbyte?, false);
            Eval(8324, o is sbyte?[], false);
            Eval(8325, o is short, false);
            Eval(8326, o is short[], false);
            Eval(8327, o is short?, false);
            Eval(8328, o is short?[], false);
            Eval(8329, o is ushort, false);
            Eval(8330, o is ushort[], false);
            Eval(8331, o is ushort?, false);
            Eval(8332, o is ushort?[], false);
            Eval(8333, o is int, false);
            Eval(8334, o is int[], false);
            Eval(8335, o is int?, false);
            Eval(8336, o is int?[], false);
            Eval(8337, o is uint, false);
            Eval(8338, o is uint[], false);
            Eval(8339, o is uint?, false);
            Eval(8340, o is uint?[], false);
            Eval(8341, o is long, false);
            Eval(8342, o is long[], false);
            Eval(8343, o is long?, false);
            Eval(8344, o is long?[], false);
            Eval(8345, o is ulong, false);
            Eval(8346, o is ulong[], false);
            Eval(8347, o is ulong?, false);
            Eval(8348, o is ulong?[], false);
            Eval(8349, o is float, false);
            Eval(8350, o is float[], false);
            Eval(8351, o is float?, false);
            Eval(8352, o is float?[], false);
            Eval(8353, o is double, false);
            Eval(8354, o is double[], false);
            Eval(8355, o is double?, false);
            Eval(8356, o is double?[], false);
            Eval(8357, o is decimal, false);
            Eval(8358, o is decimal[], false);
            Eval(8359, o is decimal?, false);
            Eval(8360, o is decimal?[], false);
            Eval(8361, o is IntPtr, false);
            Eval(8362, o is IntPtr[], false);
            Eval(8363, o is IntPtr?, false);
            Eval(8364, o is IntPtr?[], false);
            Eval(8365, o is UIntPtr, false);
            Eval(8366, o is UIntPtr[], false);
            Eval(8367, o is UIntPtr?, false);
            Eval(8368, o is UIntPtr?[], false);
            Eval(8369, o is Guid, false);
            Eval(8370, o is Guid[], false);
            Eval(8371, o is Guid?, false);
            Eval(8372, o is Guid?[], false);
            Eval(8373, o is GCHandle, false);
            Eval(8374, o is GCHandle[], false);
            Eval(8375, o is GCHandle?, false);
            Eval(8376, o is GCHandle?[], false);
            Eval(8377, o is object, true);
            Eval(8378, o is object[], false);
            Eval(8379, o is string, false);
            Eval(8380, o is string[], false);
            Eval(8381, o is ValueType, true);
            Eval(8382, o is ValueType[], false);
            Eval(8383, o is Array, false);
            Eval(8384, o is Array[], false);
            Eval(8385, o is Enum, false);
            Eval(8386, o is Enum[], false);
            Eval(8387, o is Delegate, false);
            Eval(8388, o is Delegate[], false);
            Eval(8389, o is MulticastDelegate, false);
            Eval(8390, o is MulticastDelegate[], false);
            Eval(8391, o is IEmpty, false);
            Eval(8392, o is IEmpty[], false);
            Eval(8393, o is INotEmpty, false);
            Eval(8394, o is INotEmpty[], false);
            Eval(8395, o is IEmptyGen<int>, true);
            Eval(8396, o is IEmptyGen<int>[], false);
            Eval(8397, o is INotEmptyGen<int>, true);
            Eval(8398, o is INotEmptyGen<int>[], false);
            Eval(8399, o is SimpleDelegate, false);
            Eval(8400, o is SimpleDelegate[], false);
            Eval(8401, o is GenericDelegate<int>, false);
            Eval(8402, o is GenericDelegate<int>[], false);
            Eval(8403, o is EmptyClass, false);
            Eval(8404, o is EmptyClass[], false);
            Eval(8405, o is NotEmptyClass, false);
            Eval(8406, o is NotEmptyClass[], false);
            Eval(8407, o is EmptyClassGen<int>, false);
            Eval(8408, o is EmptyClassGen<int>[], false);
            Eval(8409, o is NotEmptyClassGen<Guid>, false);
            Eval(8410, o is NotEmptyClassGen<Guid>[], false);
            Eval(8411, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(8412, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(8413, o is NestedClass, false);
            Eval(8414, o is NestedClass[], false);
            Eval(8415, o is NestedClassGen<Decimal>, false);
            Eval(8416, o is NestedClassGen<Decimal>[], false);
            Eval(8417, o is ImplementOneInterfaceC, false);
            Eval(8418, o is ImplementOneInterfaceC[], false);
            Eval(8419, o is ImplementTwoInterfaceC, false);
            Eval(8420, o is ImplementTwoInterfaceC[], false);
            Eval(8421, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(8422, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(8423, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(8424, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(8425, o is ImplementAllInterfaceC<int>, false);
            Eval(8426, o is ImplementAllInterfaceC<int>[], false);
            Eval(8427, o is SealedClass, false);
            Eval(8428, o is SealedClass[], false);
        }
        {
            ImplementTwoInterfaceGen<int>? v = default(ImplementTwoInterfaceGen<int>);
            ValueType o = v;
            Eval(8429, o is EmptyStruct, false);
            Eval(8430, o is EmptyStruct[], false);
            Eval(8431, o is EmptyStruct?, false);
            Eval(8432, o is EmptyStruct?[], false);
            Eval(8433, o is NotEmptyStruct, false);
            Eval(8434, o is NotEmptyStruct[], false);
            Eval(8435, o is NotEmptyStruct?, false);
            Eval(8436, o is NotEmptyStruct?[], false);
            Eval(8437, o is EmptyStructGen<int>, false);
            Eval(8438, o is EmptyStructGen<int>[], false);
            Eval(8439, o is EmptyStructGen<int>?, false);
            Eval(8440, o is EmptyStructGen<int>?[], false);
            Eval(8441, o is NotEmptyStructGen<Guid>, false);
            Eval(8442, o is NotEmptyStructGen<Guid>[], false);
            Eval(8443, o is NotEmptyStructGen<Guid>?, false);
            Eval(8444, o is NotEmptyStructGen<Guid>?[], false);
            Eval(8445, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(8446, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(8447, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(8448, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(8449, o is NestedStruct, false);
            Eval(8450, o is NestedStruct[], false);
            Eval(8451, o is NestedStruct?, false);
            Eval(8452, o is NestedStruct?[], false);
            Eval(8453, o is NestedStructGen<Decimal>, false);
            Eval(8454, o is NestedStructGen<Decimal>[], false);
            Eval(8455, o is NestedStructGen<Decimal>?, false);
            Eval(8456, o is NestedStructGen<Decimal>?[], false);
            Eval(8457, o is ExplicitFieldOffsetStruct, false);
            Eval(8458, o is ExplicitFieldOffsetStruct[], false);
            Eval(8459, o is ExplicitFieldOffsetStruct?, false);
            Eval(8460, o is ExplicitFieldOffsetStruct?[], false);
            Eval(8469, o is MarshalAsStruct, false);
            Eval(8470, o is MarshalAsStruct[], false);
            Eval(8471, o is MarshalAsStruct?, false);
            Eval(8472, o is MarshalAsStruct?[], false);
            Eval(8473, o is ImplementOneInterface, false);
            Eval(8474, o is ImplementOneInterface[], false);
            Eval(8475, o is ImplementOneInterface?, false);
            Eval(8476, o is ImplementOneInterface?[], false);
            Eval(8477, o is ImplementTwoInterface, false);
            Eval(8478, o is ImplementTwoInterface[], false);
            Eval(8479, o is ImplementTwoInterface?, false);
            Eval(8480, o is ImplementTwoInterface?[], false);
            Eval(8481, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(8482, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(8483, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(8484, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(8485, o is ImplementTwoInterfaceGen<int>, true);
            Eval(8486, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(8487, o is ImplementTwoInterfaceGen<int>?, true);
            Eval(8488, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(8489, o is ImplementAllInterface<int>, false);
            Eval(8490, o is ImplementAllInterface<int>[], false);
            Eval(8491, o is ImplementAllInterface<int>?, false);
            Eval(8492, o is ImplementAllInterface<int>?[], false);
            Eval(8493, o is IntE, false);
            Eval(8494, o is IntE[], false);
            Eval(8495, o is IntE?, false);
            Eval(8496, o is IntE?[], false);
            Eval(8497, o is ByteE, false);
            Eval(8498, o is ByteE[], false);
            Eval(8499, o is ByteE?, false);
            Eval(8500, o is ByteE?[], false);
            Eval(8501, o is LongE, false);
            Eval(8502, o is LongE[], false);
            Eval(8503, o is LongE?, false);
            Eval(8504, o is LongE?[], false);
            Eval(8505, o is char, false);
            Eval(8506, o is char[], false);
            Eval(8507, o is char?, false);
            Eval(8508, o is char?[], false);
            Eval(8509, o is bool, false);
            Eval(8510, o is bool[], false);
            Eval(8511, o is bool?, false);
            Eval(8512, o is bool?[], false);
            Eval(8513, o is byte, false);
            Eval(8514, o is byte[], false);
            Eval(8515, o is byte?, false);
            Eval(8516, o is byte?[], false);
            Eval(8517, o is sbyte, false);
            Eval(8518, o is sbyte[], false);
            Eval(8519, o is sbyte?, false);
            Eval(8520, o is sbyte?[], false);
            Eval(8521, o is short, false);
            Eval(8522, o is short[], false);
            Eval(8523, o is short?, false);
            Eval(8524, o is short?[], false);
            Eval(8525, o is ushort, false);
            Eval(8526, o is ushort[], false);
            Eval(8527, o is ushort?, false);
            Eval(8528, o is ushort?[], false);
            Eval(8529, o is int, false);
            Eval(8530, o is int[], false);
            Eval(8531, o is int?, false);
            Eval(8532, o is int?[], false);
            Eval(8533, o is uint, false);
            Eval(8534, o is uint[], false);
            Eval(8535, o is uint?, false);
            Eval(8536, o is uint?[], false);
            Eval(8537, o is long, false);
            Eval(8538, o is long[], false);
            Eval(8539, o is long?, false);
            Eval(8540, o is long?[], false);
            Eval(8541, o is ulong, false);
            Eval(8542, o is ulong[], false);
            Eval(8543, o is ulong?, false);
            Eval(8544, o is ulong?[], false);
            Eval(8545, o is float, false);
            Eval(8546, o is float[], false);
            Eval(8547, o is float?, false);
            Eval(8548, o is float?[], false);
            Eval(8549, o is double, false);
            Eval(8550, o is double[], false);
            Eval(8551, o is double?, false);
            Eval(8552, o is double?[], false);
            Eval(8553, o is decimal, false);
            Eval(8554, o is decimal[], false);
            Eval(8555, o is decimal?, false);
            Eval(8556, o is decimal?[], false);
            Eval(8557, o is IntPtr, false);
            Eval(8558, o is IntPtr[], false);
            Eval(8559, o is IntPtr?, false);
            Eval(8560, o is IntPtr?[], false);
            Eval(8561, o is UIntPtr, false);
            Eval(8562, o is UIntPtr[], false);
            Eval(8563, o is UIntPtr?, false);
            Eval(8564, o is UIntPtr?[], false);
            Eval(8565, o is Guid, false);
            Eval(8566, o is Guid[], false);
            Eval(8567, o is Guid?, false);
            Eval(8568, o is Guid?[], false);
            Eval(8569, o is GCHandle, false);
            Eval(8570, o is GCHandle[], false);
            Eval(8571, o is GCHandle?, false);
            Eval(8572, o is GCHandle?[], false);
            Eval(8573, o is object, true);
            Eval(8574, o is object[], false);
            Eval(8575, o is string, false);
            Eval(8576, o is string[], false);
            Eval(8577, o is ValueType, true);
            Eval(8578, o is ValueType[], false);
            Eval(8579, o is Array, false);
            Eval(8580, o is Array[], false);
            Eval(8581, o is Enum, false);
            Eval(8582, o is Enum[], false);
            Eval(8583, o is Delegate, false);
            Eval(8584, o is Delegate[], false);
            Eval(8585, o is MulticastDelegate, false);
            Eval(8586, o is MulticastDelegate[], false);
            Eval(8587, o is IEmpty, false);
            Eval(8588, o is IEmpty[], false);
            Eval(8589, o is INotEmpty, false);
            Eval(8590, o is INotEmpty[], false);
            Eval(8591, o is IEmptyGen<int>, true);
            Eval(8592, o is IEmptyGen<int>[], false);
            Eval(8593, o is INotEmptyGen<int>, true);
            Eval(8594, o is INotEmptyGen<int>[], false);
            Eval(8595, o is SimpleDelegate, false);
            Eval(8596, o is SimpleDelegate[], false);
            Eval(8597, o is GenericDelegate<int>, false);
            Eval(8598, o is GenericDelegate<int>[], false);
            Eval(8599, o is EmptyClass, false);
            Eval(8600, o is EmptyClass[], false);
            Eval(8601, o is NotEmptyClass, false);
            Eval(8602, o is NotEmptyClass[], false);
            Eval(8603, o is EmptyClassGen<int>, false);
            Eval(8604, o is EmptyClassGen<int>[], false);
            Eval(8605, o is NotEmptyClassGen<Guid>, false);
            Eval(8606, o is NotEmptyClassGen<Guid>[], false);
            Eval(8607, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(8608, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(8609, o is NestedClass, false);
            Eval(8610, o is NestedClass[], false);
            Eval(8611, o is NestedClassGen<Decimal>, false);
            Eval(8612, o is NestedClassGen<Decimal>[], false);
            Eval(8613, o is ImplementOneInterfaceC, false);
            Eval(8614, o is ImplementOneInterfaceC[], false);
            Eval(8615, o is ImplementTwoInterfaceC, false);
            Eval(8616, o is ImplementTwoInterfaceC[], false);
            Eval(8617, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(8618, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(8619, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(8620, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(8621, o is ImplementAllInterfaceC<int>, false);
            Eval(8622, o is ImplementAllInterfaceC<int>[], false);
            Eval(8623, o is SealedClass, false);
            Eval(8624, o is SealedClass[], false);
        }
        {
            ImplementTwoInterfaceGen<int>? v = default(ImplementTwoInterfaceGen<int>?);
            ValueType o = v;
            Eval(8625, o is EmptyStruct, false);
            Eval(8626, o is EmptyStruct[], false);
            Eval(8627, o is EmptyStruct?, false);
            Eval(8628, o is EmptyStruct?[], false);
            Eval(8629, o is NotEmptyStruct, false);
            Eval(8630, o is NotEmptyStruct[], false);
            Eval(8631, o is NotEmptyStruct?, false);
            Eval(8632, o is NotEmptyStruct?[], false);
            Eval(8633, o is EmptyStructGen<int>, false);
            Eval(8634, o is EmptyStructGen<int>[], false);
            Eval(8635, o is EmptyStructGen<int>?, false);
            Eval(8636, o is EmptyStructGen<int>?[], false);
            Eval(8637, o is NotEmptyStructGen<Guid>, false);
            Eval(8638, o is NotEmptyStructGen<Guid>[], false);
            Eval(8639, o is NotEmptyStructGen<Guid>?, false);
            Eval(8640, o is NotEmptyStructGen<Guid>?[], false);
            Eval(8641, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(8642, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(8643, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(8644, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(8645, o is NestedStruct, false);
            Eval(8646, o is NestedStruct[], false);
            Eval(8647, o is NestedStruct?, false);
            Eval(8648, o is NestedStruct?[], false);
            Eval(8649, o is NestedStructGen<Decimal>, false);
            Eval(8650, o is NestedStructGen<Decimal>[], false);
            Eval(8651, o is NestedStructGen<Decimal>?, false);
            Eval(8652, o is NestedStructGen<Decimal>?[], false);
            Eval(8653, o is ExplicitFieldOffsetStruct, false);
            Eval(8654, o is ExplicitFieldOffsetStruct[], false);
            Eval(8655, o is ExplicitFieldOffsetStruct?, false);
            Eval(8656, o is ExplicitFieldOffsetStruct?[], false);
            Eval(8665, o is MarshalAsStruct, false);
            Eval(8666, o is MarshalAsStruct[], false);
            Eval(8667, o is MarshalAsStruct?, false);
            Eval(8668, o is MarshalAsStruct?[], false);
            Eval(8669, o is ImplementOneInterface, false);
            Eval(8670, o is ImplementOneInterface[], false);
            Eval(8671, o is ImplementOneInterface?, false);
            Eval(8672, o is ImplementOneInterface?[], false);
            Eval(8673, o is ImplementTwoInterface, false);
            Eval(8674, o is ImplementTwoInterface[], false);
            Eval(8675, o is ImplementTwoInterface?, false);
            Eval(8676, o is ImplementTwoInterface?[], false);
            Eval(8677, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(8678, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(8679, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(8680, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(8681, o is ImplementTwoInterfaceGen<int>, false);
            Eval(8682, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(8683, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(8684, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(8685, o is ImplementAllInterface<int>, false);
            Eval(8686, o is ImplementAllInterface<int>[], false);
            Eval(8687, o is ImplementAllInterface<int>?, false);
            Eval(8688, o is ImplementAllInterface<int>?[], false);
            Eval(8689, o is IntE, false);
            Eval(8690, o is IntE[], false);
            Eval(8691, o is IntE?, false);
            Eval(8692, o is IntE?[], false);
            Eval(8693, o is ByteE, false);
            Eval(8694, o is ByteE[], false);
            Eval(8695, o is ByteE?, false);
            Eval(8696, o is ByteE?[], false);
            Eval(8697, o is LongE, false);
            Eval(8698, o is LongE[], false);
            Eval(8699, o is LongE?, false);
            Eval(8700, o is LongE?[], false);
            Eval(8701, o is char, false);
            Eval(8702, o is char[], false);
            Eval(8703, o is char?, false);
            Eval(8704, o is char?[], false);
            Eval(8705, o is bool, false);
            Eval(8706, o is bool[], false);
            Eval(8707, o is bool?, false);
            Eval(8708, o is bool?[], false);
            Eval(8709, o is byte, false);
            Eval(8710, o is byte[], false);
            Eval(8711, o is byte?, false);
            Eval(8712, o is byte?[], false);
            Eval(8713, o is sbyte, false);
            Eval(8714, o is sbyte[], false);
            Eval(8715, o is sbyte?, false);
            Eval(8716, o is sbyte?[], false);
            Eval(8717, o is short, false);
            Eval(8718, o is short[], false);
            Eval(8719, o is short?, false);
            Eval(8720, o is short?[], false);
            Eval(8721, o is ushort, false);
            Eval(8722, o is ushort[], false);
            Eval(8723, o is ushort?, false);
            Eval(8724, o is ushort?[], false);
            Eval(8725, o is int, false);
            Eval(8726, o is int[], false);
            Eval(8727, o is int?, false);
            Eval(8728, o is int?[], false);
            Eval(8729, o is uint, false);
            Eval(8730, o is uint[], false);
            Eval(8731, o is uint?, false);
            Eval(8732, o is uint?[], false);
            Eval(8733, o is long, false);
            Eval(8734, o is long[], false);
            Eval(8735, o is long?, false);
            Eval(8736, o is long?[], false);
            Eval(8737, o is ulong, false);
            Eval(8738, o is ulong[], false);
            Eval(8739, o is ulong?, false);
            Eval(8740, o is ulong?[], false);
            Eval(8741, o is float, false);
            Eval(8742, o is float[], false);
            Eval(8743, o is float?, false);
            Eval(8744, o is float?[], false);
            Eval(8745, o is double, false);
            Eval(8746, o is double[], false);
            Eval(8747, o is double?, false);
            Eval(8748, o is double?[], false);
            Eval(8749, o is decimal, false);
            Eval(8750, o is decimal[], false);
            Eval(8751, o is decimal?, false);
            Eval(8752, o is decimal?[], false);
            Eval(8753, o is IntPtr, false);
            Eval(8754, o is IntPtr[], false);
            Eval(8755, o is IntPtr?, false);
            Eval(8756, o is IntPtr?[], false);
            Eval(8757, o is UIntPtr, false);
            Eval(8758, o is UIntPtr[], false);
            Eval(8759, o is UIntPtr?, false);
            Eval(8760, o is UIntPtr?[], false);
            Eval(8761, o is Guid, false);
            Eval(8762, o is Guid[], false);
            Eval(8763, o is Guid?, false);
            Eval(8764, o is Guid?[], false);
            Eval(8765, o is GCHandle, false);
            Eval(8766, o is GCHandle[], false);
            Eval(8767, o is GCHandle?, false);
            Eval(8768, o is GCHandle?[], false);
            Eval(8769, o is object, false);
            Eval(8770, o is object[], false);
            Eval(8771, o is string, false);
            Eval(8772, o is string[], false);
            Eval(8773, o is ValueType, false);
            Eval(8774, o is ValueType[], false);
            Eval(8775, o is Array, false);
            Eval(8776, o is Array[], false);
            Eval(8777, o is Enum, false);
            Eval(8778, o is Enum[], false);
            Eval(8779, o is Delegate, false);
            Eval(8780, o is Delegate[], false);
            Eval(8781, o is MulticastDelegate, false);
            Eval(8782, o is MulticastDelegate[], false);
            Eval(8783, o is IEmpty, false);
            Eval(8784, o is IEmpty[], false);
            Eval(8785, o is INotEmpty, false);
            Eval(8786, o is INotEmpty[], false);
            Eval(8787, o is IEmptyGen<int>, false);
            Eval(8788, o is IEmptyGen<int>[], false);
            Eval(8789, o is INotEmptyGen<int>, false);
            Eval(8790, o is INotEmptyGen<int>[], false);
            Eval(8791, o is SimpleDelegate, false);
            Eval(8792, o is SimpleDelegate[], false);
            Eval(8793, o is GenericDelegate<int>, false);
            Eval(8794, o is GenericDelegate<int>[], false);
            Eval(8795, o is EmptyClass, false);
            Eval(8796, o is EmptyClass[], false);
            Eval(8797, o is NotEmptyClass, false);
            Eval(8798, o is NotEmptyClass[], false);
            Eval(8799, o is EmptyClassGen<int>, false);
            Eval(8800, o is EmptyClassGen<int>[], false);
            Eval(8801, o is NotEmptyClassGen<Guid>, false);
            Eval(8802, o is NotEmptyClassGen<Guid>[], false);
            Eval(8803, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(8804, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(8805, o is NestedClass, false);
            Eval(8806, o is NestedClass[], false);
            Eval(8807, o is NestedClassGen<Decimal>, false);
            Eval(8808, o is NestedClassGen<Decimal>[], false);
            Eval(8809, o is ImplementOneInterfaceC, false);
            Eval(8810, o is ImplementOneInterfaceC[], false);
            Eval(8811, o is ImplementTwoInterfaceC, false);
            Eval(8812, o is ImplementTwoInterfaceC[], false);
            Eval(8813, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(8814, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(8815, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(8816, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(8817, o is ImplementAllInterfaceC<int>, false);
            Eval(8818, o is ImplementAllInterfaceC<int>[], false);
            Eval(8819, o is SealedClass, false);
            Eval(8820, o is SealedClass[], false);
        }
    }  // end of test case 0015
    private static void TestCase0016()
    {
        {
            ImplementAllInterface<int> v = default(ImplementAllInterface<int>);
            ValueType o = v;
            Eval(8821, o is EmptyStruct, false);
            Eval(8822, o is EmptyStruct[], false);
            Eval(8823, o is EmptyStruct?, false);
            Eval(8824, o is EmptyStruct?[], false);
            Eval(8825, o is NotEmptyStruct, false);
            Eval(8826, o is NotEmptyStruct[], false);
            Eval(8827, o is NotEmptyStruct?, false);
            Eval(8828, o is NotEmptyStruct?[], false);
            Eval(8829, o is EmptyStructGen<int>, false);
            Eval(8830, o is EmptyStructGen<int>[], false);
            Eval(8831, o is EmptyStructGen<int>?, false);
            Eval(8832, o is EmptyStructGen<int>?[], false);
            Eval(8833, o is NotEmptyStructGen<Guid>, false);
            Eval(8834, o is NotEmptyStructGen<Guid>[], false);
            Eval(8835, o is NotEmptyStructGen<Guid>?, false);
            Eval(8836, o is NotEmptyStructGen<Guid>?[], false);
            Eval(8837, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(8838, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(8839, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(8840, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(8841, o is NestedStruct, false);
            Eval(8842, o is NestedStruct[], false);
            Eval(8843, o is NestedStruct?, false);
            Eval(8844, o is NestedStruct?[], false);
            Eval(8845, o is NestedStructGen<Decimal>, false);
            Eval(8846, o is NestedStructGen<Decimal>[], false);
            Eval(8847, o is NestedStructGen<Decimal>?, false);
            Eval(8848, o is NestedStructGen<Decimal>?[], false);
            Eval(8849, o is ExplicitFieldOffsetStruct, false);
            Eval(8850, o is ExplicitFieldOffsetStruct[], false);
            Eval(8851, o is ExplicitFieldOffsetStruct?, false);
            Eval(8852, o is ExplicitFieldOffsetStruct?[], false);
            Eval(8861, o is MarshalAsStruct, false);
            Eval(8862, o is MarshalAsStruct[], false);
            Eval(8863, o is MarshalAsStruct?, false);
            Eval(8864, o is MarshalAsStruct?[], false);
            Eval(8865, o is ImplementOneInterface, false);
            Eval(8866, o is ImplementOneInterface[], false);
            Eval(8867, o is ImplementOneInterface?, false);
            Eval(8868, o is ImplementOneInterface?[], false);
            Eval(8869, o is ImplementTwoInterface, false);
            Eval(8870, o is ImplementTwoInterface[], false);
            Eval(8871, o is ImplementTwoInterface?, false);
            Eval(8872, o is ImplementTwoInterface?[], false);
            Eval(8873, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(8874, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(8875, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(8876, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(8877, o is ImplementTwoInterfaceGen<int>, false);
            Eval(8878, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(8879, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(8880, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(8881, o is ImplementAllInterface<int>, true);
            Eval(8882, o is ImplementAllInterface<int>[], false);
            Eval(8883, o is ImplementAllInterface<int>?, true);
            Eval(8884, o is ImplementAllInterface<int>?[], false);
            Eval(8885, o is IntE, false);
            Eval(8886, o is IntE[], false);
            Eval(8887, o is IntE?, false);
            Eval(8888, o is IntE?[], false);
            Eval(8889, o is ByteE, false);
            Eval(8890, o is ByteE[], false);
            Eval(8891, o is ByteE?, false);
            Eval(8892, o is ByteE?[], false);
            Eval(8893, o is LongE, false);
            Eval(8894, o is LongE[], false);
            Eval(8895, o is LongE?, false);
            Eval(8896, o is LongE?[], false);
            Eval(8897, o is char, false);
            Eval(8898, o is char[], false);
            Eval(8899, o is char?, false);
            Eval(8900, o is char?[], false);
            Eval(8901, o is bool, false);
            Eval(8902, o is bool[], false);
            Eval(8903, o is bool?, false);
            Eval(8904, o is bool?[], false);
            Eval(8905, o is byte, false);
            Eval(8906, o is byte[], false);
            Eval(8907, o is byte?, false);
            Eval(8908, o is byte?[], false);
            Eval(8909, o is sbyte, false);
            Eval(8910, o is sbyte[], false);
            Eval(8911, o is sbyte?, false);
            Eval(8912, o is sbyte?[], false);
            Eval(8913, o is short, false);
            Eval(8914, o is short[], false);
            Eval(8915, o is short?, false);
            Eval(8916, o is short?[], false);
            Eval(8917, o is ushort, false);
            Eval(8918, o is ushort[], false);
            Eval(8919, o is ushort?, false);
            Eval(8920, o is ushort?[], false);
            Eval(8921, o is int, false);
            Eval(8922, o is int[], false);
            Eval(8923, o is int?, false);
            Eval(8924, o is int?[], false);
            Eval(8925, o is uint, false);
            Eval(8926, o is uint[], false);
            Eval(8927, o is uint?, false);
            Eval(8928, o is uint?[], false);
            Eval(8929, o is long, false);
            Eval(8930, o is long[], false);
            Eval(8931, o is long?, false);
            Eval(8932, o is long?[], false);
            Eval(8933, o is ulong, false);
            Eval(8934, o is ulong[], false);
            Eval(8935, o is ulong?, false);
            Eval(8936, o is ulong?[], false);
            Eval(8937, o is float, false);
            Eval(8938, o is float[], false);
            Eval(8939, o is float?, false);
            Eval(8940, o is float?[], false);
            Eval(8941, o is double, false);
            Eval(8942, o is double[], false);
            Eval(8943, o is double?, false);
            Eval(8944, o is double?[], false);
            Eval(8945, o is decimal, false);
            Eval(8946, o is decimal[], false);
            Eval(8947, o is decimal?, false);
            Eval(8948, o is decimal?[], false);
            Eval(8949, o is IntPtr, false);
            Eval(8950, o is IntPtr[], false);
            Eval(8951, o is IntPtr?, false);
            Eval(8952, o is IntPtr?[], false);
            Eval(8953, o is UIntPtr, false);
            Eval(8954, o is UIntPtr[], false);
            Eval(8955, o is UIntPtr?, false);
            Eval(8956, o is UIntPtr?[], false);
            Eval(8957, o is Guid, false);
            Eval(8958, o is Guid[], false);
            Eval(8959, o is Guid?, false);
            Eval(8960, o is Guid?[], false);
            Eval(8961, o is GCHandle, false);
            Eval(8962, o is GCHandle[], false);
            Eval(8963, o is GCHandle?, false);
            Eval(8964, o is GCHandle?[], false);
            Eval(8965, o is object, true);
            Eval(8966, o is object[], false);
            Eval(8967, o is string, false);
            Eval(8968, o is string[], false);
            Eval(8969, o is ValueType, true);
            Eval(8970, o is ValueType[], false);
            Eval(8971, o is Array, false);
            Eval(8972, o is Array[], false);
            Eval(8973, o is Enum, false);
            Eval(8974, o is Enum[], false);
            Eval(8975, o is Delegate, false);
            Eval(8976, o is Delegate[], false);
            Eval(8977, o is MulticastDelegate, false);
            Eval(8978, o is MulticastDelegate[], false);
            Eval(8979, o is IEmpty, true);
            Eval(8980, o is IEmpty[], false);
            Eval(8981, o is INotEmpty, true);
            Eval(8982, o is INotEmpty[], false);
            Eval(8983, o is IEmptyGen<int>, true);
            Eval(8984, o is IEmptyGen<int>[], false);
            Eval(8985, o is INotEmptyGen<int>, true);
            Eval(8986, o is INotEmptyGen<int>[], false);
            Eval(8987, o is SimpleDelegate, false);
            Eval(8988, o is SimpleDelegate[], false);
            Eval(8989, o is GenericDelegate<int>, false);
            Eval(8990, o is GenericDelegate<int>[], false);
            Eval(8991, o is EmptyClass, false);
            Eval(8992, o is EmptyClass[], false);
            Eval(8993, o is NotEmptyClass, false);
            Eval(8994, o is NotEmptyClass[], false);
            Eval(8995, o is EmptyClassGen<int>, false);
            Eval(8996, o is EmptyClassGen<int>[], false);
            Eval(8997, o is NotEmptyClassGen<Guid>, false);
            Eval(8998, o is NotEmptyClassGen<Guid>[], false);
            Eval(8999, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(9000, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(9001, o is NestedClass, false);
            Eval(9002, o is NestedClass[], false);
            Eval(9003, o is NestedClassGen<Decimal>, false);
            Eval(9004, o is NestedClassGen<Decimal>[], false);
            Eval(9005, o is ImplementOneInterfaceC, false);
            Eval(9006, o is ImplementOneInterfaceC[], false);
            Eval(9007, o is ImplementTwoInterfaceC, false);
            Eval(9008, o is ImplementTwoInterfaceC[], false);
            Eval(9009, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(9010, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(9011, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(9012, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(9013, o is ImplementAllInterfaceC<int>, false);
            Eval(9014, o is ImplementAllInterfaceC<int>[], false);
            Eval(9015, o is SealedClass, false);
            Eval(9016, o is SealedClass[], false);
        }
        {
            ImplementAllInterface<int>? v = default(ImplementAllInterface<int>);
            ValueType o = v;
            Eval(9017, o is EmptyStruct, false);
            Eval(9018, o is EmptyStruct[], false);
            Eval(9019, o is EmptyStruct?, false);
            Eval(9020, o is EmptyStruct?[], false);
            Eval(9021, o is NotEmptyStruct, false);
            Eval(9022, o is NotEmptyStruct[], false);
            Eval(9023, o is NotEmptyStruct?, false);
            Eval(9024, o is NotEmptyStruct?[], false);
            Eval(9025, o is EmptyStructGen<int>, false);
            Eval(9026, o is EmptyStructGen<int>[], false);
            Eval(9027, o is EmptyStructGen<int>?, false);
            Eval(9028, o is EmptyStructGen<int>?[], false);
            Eval(9029, o is NotEmptyStructGen<Guid>, false);
            Eval(9030, o is NotEmptyStructGen<Guid>[], false);
            Eval(9031, o is NotEmptyStructGen<Guid>?, false);
            Eval(9032, o is NotEmptyStructGen<Guid>?[], false);
            Eval(9033, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(9034, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(9035, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(9036, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(9037, o is NestedStruct, false);
            Eval(9038, o is NestedStruct[], false);
            Eval(9039, o is NestedStruct?, false);
            Eval(9040, o is NestedStruct?[], false);
            Eval(9041, o is NestedStructGen<Decimal>, false);
            Eval(9042, o is NestedStructGen<Decimal>[], false);
            Eval(9043, o is NestedStructGen<Decimal>?, false);
            Eval(9044, o is NestedStructGen<Decimal>?[], false);
            Eval(9045, o is ExplicitFieldOffsetStruct, false);
            Eval(9046, o is ExplicitFieldOffsetStruct[], false);
            Eval(9047, o is ExplicitFieldOffsetStruct?, false);
            Eval(9048, o is ExplicitFieldOffsetStruct?[], false);
            Eval(9057, o is MarshalAsStruct, false);
            Eval(9058, o is MarshalAsStruct[], false);
            Eval(9059, o is MarshalAsStruct?, false);
            Eval(9060, o is MarshalAsStruct?[], false);
            Eval(9061, o is ImplementOneInterface, false);
            Eval(9062, o is ImplementOneInterface[], false);
            Eval(9063, o is ImplementOneInterface?, false);
            Eval(9064, o is ImplementOneInterface?[], false);
            Eval(9065, o is ImplementTwoInterface, false);
            Eval(9066, o is ImplementTwoInterface[], false);
            Eval(9067, o is ImplementTwoInterface?, false);
            Eval(9068, o is ImplementTwoInterface?[], false);
            Eval(9069, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(9070, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(9071, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(9072, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(9073, o is ImplementTwoInterfaceGen<int>, false);
            Eval(9074, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(9075, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(9076, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(9077, o is ImplementAllInterface<int>, true);
            Eval(9078, o is ImplementAllInterface<int>[], false);
            Eval(9079, o is ImplementAllInterface<int>?, true);
            Eval(9080, o is ImplementAllInterface<int>?[], false);
            Eval(9081, o is IntE, false);
            Eval(9082, o is IntE[], false);
            Eval(9083, o is IntE?, false);
            Eval(9084, o is IntE?[], false);
            Eval(9085, o is ByteE, false);
            Eval(9086, o is ByteE[], false);
            Eval(9087, o is ByteE?, false);
            Eval(9088, o is ByteE?[], false);
            Eval(9089, o is LongE, false);
            Eval(9090, o is LongE[], false);
            Eval(9091, o is LongE?, false);
            Eval(9092, o is LongE?[], false);
            Eval(9093, o is char, false);
            Eval(9094, o is char[], false);
            Eval(9095, o is char?, false);
            Eval(9096, o is char?[], false);
            Eval(9097, o is bool, false);
            Eval(9098, o is bool[], false);
            Eval(9099, o is bool?, false);
            Eval(9100, o is bool?[], false);
            Eval(9101, o is byte, false);
            Eval(9102, o is byte[], false);
            Eval(9103, o is byte?, false);
            Eval(9104, o is byte?[], false);
            Eval(9105, o is sbyte, false);
            Eval(9106, o is sbyte[], false);
            Eval(9107, o is sbyte?, false);
            Eval(9108, o is sbyte?[], false);
            Eval(9109, o is short, false);
            Eval(9110, o is short[], false);
            Eval(9111, o is short?, false);
            Eval(9112, o is short?[], false);
            Eval(9113, o is ushort, false);
            Eval(9114, o is ushort[], false);
            Eval(9115, o is ushort?, false);
            Eval(9116, o is ushort?[], false);
            Eval(9117, o is int, false);
            Eval(9118, o is int[], false);
            Eval(9119, o is int?, false);
            Eval(9120, o is int?[], false);
            Eval(9121, o is uint, false);
            Eval(9122, o is uint[], false);
            Eval(9123, o is uint?, false);
            Eval(9124, o is uint?[], false);
            Eval(9125, o is long, false);
            Eval(9126, o is long[], false);
            Eval(9127, o is long?, false);
            Eval(9128, o is long?[], false);
            Eval(9129, o is ulong, false);
            Eval(9130, o is ulong[], false);
            Eval(9131, o is ulong?, false);
            Eval(9132, o is ulong?[], false);
            Eval(9133, o is float, false);
            Eval(9134, o is float[], false);
            Eval(9135, o is float?, false);
            Eval(9136, o is float?[], false);
            Eval(9137, o is double, false);
            Eval(9138, o is double[], false);
            Eval(9139, o is double?, false);
            Eval(9140, o is double?[], false);
            Eval(9141, o is decimal, false);
            Eval(9142, o is decimal[], false);
            Eval(9143, o is decimal?, false);
            Eval(9144, o is decimal?[], false);
            Eval(9145, o is IntPtr, false);
            Eval(9146, o is IntPtr[], false);
            Eval(9147, o is IntPtr?, false);
            Eval(9148, o is IntPtr?[], false);
            Eval(9149, o is UIntPtr, false);
            Eval(9150, o is UIntPtr[], false);
            Eval(9151, o is UIntPtr?, false);
            Eval(9152, o is UIntPtr?[], false);
            Eval(9153, o is Guid, false);
            Eval(9154, o is Guid[], false);
            Eval(9155, o is Guid?, false);
            Eval(9156, o is Guid?[], false);
            Eval(9157, o is GCHandle, false);
            Eval(9158, o is GCHandle[], false);
            Eval(9159, o is GCHandle?, false);
            Eval(9160, o is GCHandle?[], false);
            Eval(9161, o is object, true);
            Eval(9162, o is object[], false);
            Eval(9163, o is string, false);
            Eval(9164, o is string[], false);
            Eval(9165, o is ValueType, true);
            Eval(9166, o is ValueType[], false);
            Eval(9167, o is Array, false);
            Eval(9168, o is Array[], false);
            Eval(9169, o is Enum, false);
            Eval(9170, o is Enum[], false);
            Eval(9171, o is Delegate, false);
            Eval(9172, o is Delegate[], false);
            Eval(9173, o is MulticastDelegate, false);
            Eval(9174, o is MulticastDelegate[], false);
            Eval(9175, o is IEmpty, true);
            Eval(9176, o is IEmpty[], false);
            Eval(9177, o is INotEmpty, true);
            Eval(9178, o is INotEmpty[], false);
            Eval(9179, o is IEmptyGen<int>, true);
            Eval(9180, o is IEmptyGen<int>[], false);
            Eval(9181, o is INotEmptyGen<int>, true);
            Eval(9182, o is INotEmptyGen<int>[], false);
            Eval(9183, o is SimpleDelegate, false);
            Eval(9184, o is SimpleDelegate[], false);
            Eval(9185, o is GenericDelegate<int>, false);
            Eval(9186, o is GenericDelegate<int>[], false);
            Eval(9187, o is EmptyClass, false);
            Eval(9188, o is EmptyClass[], false);
            Eval(9189, o is NotEmptyClass, false);
            Eval(9190, o is NotEmptyClass[], false);
            Eval(9191, o is EmptyClassGen<int>, false);
            Eval(9192, o is EmptyClassGen<int>[], false);
            Eval(9193, o is NotEmptyClassGen<Guid>, false);
            Eval(9194, o is NotEmptyClassGen<Guid>[], false);
            Eval(9195, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(9196, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(9197, o is NestedClass, false);
            Eval(9198, o is NestedClass[], false);
            Eval(9199, o is NestedClassGen<Decimal>, false);
            Eval(9200, o is NestedClassGen<Decimal>[], false);
            Eval(9201, o is ImplementOneInterfaceC, false);
            Eval(9202, o is ImplementOneInterfaceC[], false);
            Eval(9203, o is ImplementTwoInterfaceC, false);
            Eval(9204, o is ImplementTwoInterfaceC[], false);
            Eval(9205, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(9206, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(9207, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(9208, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(9209, o is ImplementAllInterfaceC<int>, false);
            Eval(9210, o is ImplementAllInterfaceC<int>[], false);
            Eval(9211, o is SealedClass, false);
            Eval(9212, o is SealedClass[], false);
        }
        {
            ImplementAllInterface<int>? v = default(ImplementAllInterface<int>?);
            ValueType o = v;
            Eval(9213, o is EmptyStruct, false);
            Eval(9214, o is EmptyStruct[], false);
            Eval(9215, o is EmptyStruct?, false);
            Eval(9216, o is EmptyStruct?[], false);
            Eval(9217, o is NotEmptyStruct, false);
            Eval(9218, o is NotEmptyStruct[], false);
            Eval(9219, o is NotEmptyStruct?, false);
            Eval(9220, o is NotEmptyStruct?[], false);
            Eval(9221, o is EmptyStructGen<int>, false);
            Eval(9222, o is EmptyStructGen<int>[], false);
            Eval(9223, o is EmptyStructGen<int>?, false);
            Eval(9224, o is EmptyStructGen<int>?[], false);
            Eval(9225, o is NotEmptyStructGen<Guid>, false);
            Eval(9226, o is NotEmptyStructGen<Guid>[], false);
            Eval(9227, o is NotEmptyStructGen<Guid>?, false);
            Eval(9228, o is NotEmptyStructGen<Guid>?[], false);
            Eval(9229, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(9230, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(9231, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(9232, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(9233, o is NestedStruct, false);
            Eval(9234, o is NestedStruct[], false);
            Eval(9235, o is NestedStruct?, false);
            Eval(9236, o is NestedStruct?[], false);
            Eval(9237, o is NestedStructGen<Decimal>, false);
            Eval(9238, o is NestedStructGen<Decimal>[], false);
            Eval(9239, o is NestedStructGen<Decimal>?, false);
            Eval(9240, o is NestedStructGen<Decimal>?[], false);
            Eval(9241, o is ExplicitFieldOffsetStruct, false);
            Eval(9242, o is ExplicitFieldOffsetStruct[], false);
            Eval(9243, o is ExplicitFieldOffsetStruct?, false);
            Eval(9244, o is ExplicitFieldOffsetStruct?[], false);
            Eval(9253, o is MarshalAsStruct, false);
            Eval(9254, o is MarshalAsStruct[], false);
            Eval(9255, o is MarshalAsStruct?, false);
            Eval(9256, o is MarshalAsStruct?[], false);
            Eval(9257, o is ImplementOneInterface, false);
            Eval(9258, o is ImplementOneInterface[], false);
            Eval(9259, o is ImplementOneInterface?, false);
            Eval(9260, o is ImplementOneInterface?[], false);
            Eval(9261, o is ImplementTwoInterface, false);
            Eval(9262, o is ImplementTwoInterface[], false);
            Eval(9263, o is ImplementTwoInterface?, false);
            Eval(9264, o is ImplementTwoInterface?[], false);
            Eval(9265, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(9266, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(9267, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(9268, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(9269, o is ImplementTwoInterfaceGen<int>, false);
            Eval(9270, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(9271, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(9272, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(9273, o is ImplementAllInterface<int>, false);
            Eval(9274, o is ImplementAllInterface<int>[], false);
            Eval(9275, o is ImplementAllInterface<int>?, false);
            Eval(9276, o is ImplementAllInterface<int>?[], false);
            Eval(9277, o is IntE, false);
            Eval(9278, o is IntE[], false);
            Eval(9279, o is IntE?, false);
            Eval(9280, o is IntE?[], false);
            Eval(9281, o is ByteE, false);
            Eval(9282, o is ByteE[], false);
            Eval(9283, o is ByteE?, false);
            Eval(9284, o is ByteE?[], false);
            Eval(9285, o is LongE, false);
            Eval(9286, o is LongE[], false);
            Eval(9287, o is LongE?, false);
            Eval(9288, o is LongE?[], false);
            Eval(9289, o is char, false);
            Eval(9290, o is char[], false);
            Eval(9291, o is char?, false);
            Eval(9292, o is char?[], false);
            Eval(9293, o is bool, false);
            Eval(9294, o is bool[], false);
            Eval(9295, o is bool?, false);
            Eval(9296, o is bool?[], false);
            Eval(9297, o is byte, false);
            Eval(9298, o is byte[], false);
            Eval(9299, o is byte?, false);
            Eval(9300, o is byte?[], false);
            Eval(9301, o is sbyte, false);
            Eval(9302, o is sbyte[], false);
            Eval(9303, o is sbyte?, false);
            Eval(9304, o is sbyte?[], false);
            Eval(9305, o is short, false);
            Eval(9306, o is short[], false);
            Eval(9307, o is short?, false);
            Eval(9308, o is short?[], false);
            Eval(9309, o is ushort, false);
            Eval(9310, o is ushort[], false);
            Eval(9311, o is ushort?, false);
            Eval(9312, o is ushort?[], false);
            Eval(9313, o is int, false);
            Eval(9314, o is int[], false);
            Eval(9315, o is int?, false);
            Eval(9316, o is int?[], false);
            Eval(9317, o is uint, false);
            Eval(9318, o is uint[], false);
            Eval(9319, o is uint?, false);
            Eval(9320, o is uint?[], false);
            Eval(9321, o is long, false);
            Eval(9322, o is long[], false);
            Eval(9323, o is long?, false);
            Eval(9324, o is long?[], false);
            Eval(9325, o is ulong, false);
            Eval(9326, o is ulong[], false);
            Eval(9327, o is ulong?, false);
            Eval(9328, o is ulong?[], false);
            Eval(9329, o is float, false);
            Eval(9330, o is float[], false);
            Eval(9331, o is float?, false);
            Eval(9332, o is float?[], false);
            Eval(9333, o is double, false);
            Eval(9334, o is double[], false);
            Eval(9335, o is double?, false);
            Eval(9336, o is double?[], false);
            Eval(9337, o is decimal, false);
            Eval(9338, o is decimal[], false);
            Eval(9339, o is decimal?, false);
            Eval(9340, o is decimal?[], false);
            Eval(9341, o is IntPtr, false);
            Eval(9342, o is IntPtr[], false);
            Eval(9343, o is IntPtr?, false);
            Eval(9344, o is IntPtr?[], false);
            Eval(9345, o is UIntPtr, false);
            Eval(9346, o is UIntPtr[], false);
            Eval(9347, o is UIntPtr?, false);
            Eval(9348, o is UIntPtr?[], false);
            Eval(9349, o is Guid, false);
            Eval(9350, o is Guid[], false);
            Eval(9351, o is Guid?, false);
            Eval(9352, o is Guid?[], false);
            Eval(9353, o is GCHandle, false);
            Eval(9354, o is GCHandle[], false);
            Eval(9355, o is GCHandle?, false);
            Eval(9356, o is GCHandle?[], false);
            Eval(9357, o is object, false);
            Eval(9358, o is object[], false);
            Eval(9359, o is string, false);
            Eval(9360, o is string[], false);
            Eval(9361, o is ValueType, false);
            Eval(9362, o is ValueType[], false);
            Eval(9363, o is Array, false);
            Eval(9364, o is Array[], false);
            Eval(9365, o is Enum, false);
            Eval(9366, o is Enum[], false);
            Eval(9367, o is Delegate, false);
            Eval(9368, o is Delegate[], false);
            Eval(9369, o is MulticastDelegate, false);
            Eval(9370, o is MulticastDelegate[], false);
            Eval(9371, o is IEmpty, false);
            Eval(9372, o is IEmpty[], false);
            Eval(9373, o is INotEmpty, false);
            Eval(9374, o is INotEmpty[], false);
            Eval(9375, o is IEmptyGen<int>, false);
            Eval(9376, o is IEmptyGen<int>[], false);
            Eval(9377, o is INotEmptyGen<int>, false);
            Eval(9378, o is INotEmptyGen<int>[], false);
            Eval(9379, o is SimpleDelegate, false);
            Eval(9380, o is SimpleDelegate[], false);
            Eval(9381, o is GenericDelegate<int>, false);
            Eval(9382, o is GenericDelegate<int>[], false);
            Eval(9383, o is EmptyClass, false);
            Eval(9384, o is EmptyClass[], false);
            Eval(9385, o is NotEmptyClass, false);
            Eval(9386, o is NotEmptyClass[], false);
            Eval(9387, o is EmptyClassGen<int>, false);
            Eval(9388, o is EmptyClassGen<int>[], false);
            Eval(9389, o is NotEmptyClassGen<Guid>, false);
            Eval(9390, o is NotEmptyClassGen<Guid>[], false);
            Eval(9391, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(9392, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(9393, o is NestedClass, false);
            Eval(9394, o is NestedClass[], false);
            Eval(9395, o is NestedClassGen<Decimal>, false);
            Eval(9396, o is NestedClassGen<Decimal>[], false);
            Eval(9397, o is ImplementOneInterfaceC, false);
            Eval(9398, o is ImplementOneInterfaceC[], false);
            Eval(9399, o is ImplementTwoInterfaceC, false);
            Eval(9400, o is ImplementTwoInterfaceC[], false);
            Eval(9401, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(9402, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(9403, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(9404, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(9405, o is ImplementAllInterfaceC<int>, false);
            Eval(9406, o is ImplementAllInterfaceC<int>[], false);
            Eval(9407, o is SealedClass, false);
            Eval(9408, o is SealedClass[], false);
        }
    }  // end of test case 0016
    private static void TestCase0017()
    {
        {
            IntE v = default(IntE);
            ValueType o = v;
            Eval(9409, o is EmptyStruct, false);
            Eval(9410, o is EmptyStruct[], false);
            Eval(9411, o is EmptyStruct?, false);
            Eval(9412, o is EmptyStruct?[], false);
            Eval(9413, o is NotEmptyStruct, false);
            Eval(9414, o is NotEmptyStruct[], false);
            Eval(9415, o is NotEmptyStruct?, false);
            Eval(9416, o is NotEmptyStruct?[], false);
            Eval(9417, o is EmptyStructGen<int>, false);
            Eval(9418, o is EmptyStructGen<int>[], false);
            Eval(9419, o is EmptyStructGen<int>?, false);
            Eval(9420, o is EmptyStructGen<int>?[], false);
            Eval(9421, o is NotEmptyStructGen<Guid>, false);
            Eval(9422, o is NotEmptyStructGen<Guid>[], false);
            Eval(9423, o is NotEmptyStructGen<Guid>?, false);
            Eval(9424, o is NotEmptyStructGen<Guid>?[], false);
            Eval(9425, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(9426, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(9427, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(9428, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(9429, o is NestedStruct, false);
            Eval(9430, o is NestedStruct[], false);
            Eval(9431, o is NestedStruct?, false);
            Eval(9432, o is NestedStruct?[], false);
            Eval(9433, o is NestedStructGen<Decimal>, false);
            Eval(9434, o is NestedStructGen<Decimal>[], false);
            Eval(9435, o is NestedStructGen<Decimal>?, false);
            Eval(9436, o is NestedStructGen<Decimal>?[], false);
            Eval(9437, o is ExplicitFieldOffsetStruct, false);
            Eval(9438, o is ExplicitFieldOffsetStruct[], false);
            Eval(9439, o is ExplicitFieldOffsetStruct?, false);
            Eval(9440, o is ExplicitFieldOffsetStruct?[], false);
            Eval(9449, o is MarshalAsStruct, false);
            Eval(9450, o is MarshalAsStruct[], false);
            Eval(9451, o is MarshalAsStruct?, false);
            Eval(9452, o is MarshalAsStruct?[], false);
            Eval(9453, o is ImplementOneInterface, false);
            Eval(9454, o is ImplementOneInterface[], false);
            Eval(9455, o is ImplementOneInterface?, false);
            Eval(9456, o is ImplementOneInterface?[], false);
            Eval(9457, o is ImplementTwoInterface, false);
            Eval(9458, o is ImplementTwoInterface[], false);
            Eval(9459, o is ImplementTwoInterface?, false);
            Eval(9460, o is ImplementTwoInterface?[], false);
            Eval(9461, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(9462, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(9463, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(9464, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(9465, o is ImplementTwoInterfaceGen<int>, false);
            Eval(9466, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(9467, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(9468, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(9469, o is ImplementAllInterface<int>, false);
            Eval(9470, o is ImplementAllInterface<int>[], false);
            Eval(9471, o is ImplementAllInterface<int>?, false);
            Eval(9472, o is ImplementAllInterface<int>?[], false);
            Eval(9473, o is IntE, true);
            Eval(9474, o is IntE[], false);
            Eval(9475, o is IntE?, true);
            Eval(9476, o is IntE?[], false);
            Eval(9477, o is ByteE, false);
            Eval(9478, o is ByteE[], false);
            Eval(9479, o is ByteE?, false);
            Eval(9480, o is ByteE?[], false);
            Eval(9481, o is LongE, false);
            Eval(9482, o is LongE[], false);
            Eval(9483, o is LongE?, false);
            Eval(9484, o is LongE?[], false);
            Eval(9485, o is char, false);
            Eval(9486, o is char[], false);
            Eval(9487, o is char?, false);
            Eval(9488, o is char?[], false);
            Eval(9489, o is bool, false);
            Eval(9490, o is bool[], false);
            Eval(9491, o is bool?, false);
            Eval(9492, o is bool?[], false);
            Eval(9493, o is byte, false);
            Eval(9494, o is byte[], false);
            Eval(9495, o is byte?, false);
            Eval(9496, o is byte?[], false);
            Eval(9497, o is sbyte, false);
            Eval(9498, o is sbyte[], false);
            Eval(9499, o is sbyte?, false);
            Eval(9500, o is sbyte?[], false);
            Eval(9501, o is short, false);
            Eval(9502, o is short[], false);
            Eval(9503, o is short?, false);
            Eval(9504, o is short?[], false);
            Eval(9505, o is ushort, false);
            Eval(9506, o is ushort[], false);
            Eval(9507, o is ushort?, false);
            Eval(9508, o is ushort?[], false);
            Eval(9509, o is int, false);
            Eval(9510, o is int[], false);
            Eval(9511, o is int?, false);
            Eval(9512, o is int?[], false);
            Eval(9513, o is uint, false);
            Eval(9514, o is uint[], false);
            Eval(9515, o is uint?, false);
            Eval(9516, o is uint?[], false);
            Eval(9517, o is long, false);
            Eval(9518, o is long[], false);
            Eval(9519, o is long?, false);
            Eval(9520, o is long?[], false);
            Eval(9521, o is ulong, false);
            Eval(9522, o is ulong[], false);
            Eval(9523, o is ulong?, false);
            Eval(9524, o is ulong?[], false);
            Eval(9525, o is float, false);
            Eval(9526, o is float[], false);
            Eval(9527, o is float?, false);
            Eval(9528, o is float?[], false);
            Eval(9529, o is double, false);
            Eval(9530, o is double[], false);
            Eval(9531, o is double?, false);
            Eval(9532, o is double?[], false);
            Eval(9533, o is decimal, false);
            Eval(9534, o is decimal[], false);
            Eval(9535, o is decimal?, false);
            Eval(9536, o is decimal?[], false);
            Eval(9537, o is IntPtr, false);
            Eval(9538, o is IntPtr[], false);
            Eval(9539, o is IntPtr?, false);
            Eval(9540, o is IntPtr?[], false);
            Eval(9541, o is UIntPtr, false);
            Eval(9542, o is UIntPtr[], false);
            Eval(9543, o is UIntPtr?, false);
            Eval(9544, o is UIntPtr?[], false);
            Eval(9545, o is Guid, false);
            Eval(9546, o is Guid[], false);
            Eval(9547, o is Guid?, false);
            Eval(9548, o is Guid?[], false);
            Eval(9549, o is GCHandle, false);
            Eval(9550, o is GCHandle[], false);
            Eval(9551, o is GCHandle?, false);
            Eval(9552, o is GCHandle?[], false);
            Eval(9553, o is object, true);
            Eval(9554, o is object[], false);
            Eval(9555, o is string, false);
            Eval(9556, o is string[], false);
            Eval(9557, o is ValueType, true);
            Eval(9558, o is ValueType[], false);
            Eval(9559, o is Array, false);
            Eval(9560, o is Array[], false);
            Eval(9561, o is Enum, true);
            Eval(9562, o is Enum[], false);
            Eval(9563, o is Delegate, false);
            Eval(9564, o is Delegate[], false);
            Eval(9565, o is MulticastDelegate, false);
            Eval(9566, o is MulticastDelegate[], false);
            Eval(9567, o is IEmpty, false);
            Eval(9568, o is IEmpty[], false);
            Eval(9569, o is INotEmpty, false);
            Eval(9570, o is INotEmpty[], false);
            Eval(9571, o is IEmptyGen<int>, false);
            Eval(9572, o is IEmptyGen<int>[], false);
            Eval(9573, o is INotEmptyGen<int>, false);
            Eval(9574, o is INotEmptyGen<int>[], false);
            Eval(9575, o is SimpleDelegate, false);
            Eval(9576, o is SimpleDelegate[], false);
            Eval(9577, o is GenericDelegate<int>, false);
            Eval(9578, o is GenericDelegate<int>[], false);
            Eval(9579, o is EmptyClass, false);
            Eval(9580, o is EmptyClass[], false);
            Eval(9581, o is NotEmptyClass, false);
            Eval(9582, o is NotEmptyClass[], false);
            Eval(9583, o is EmptyClassGen<int>, false);
            Eval(9584, o is EmptyClassGen<int>[], false);
            Eval(9585, o is NotEmptyClassGen<Guid>, false);
            Eval(9586, o is NotEmptyClassGen<Guid>[], false);
            Eval(9587, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(9588, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(9589, o is NestedClass, false);
            Eval(9590, o is NestedClass[], false);
            Eval(9591, o is NestedClassGen<Decimal>, false);
            Eval(9592, o is NestedClassGen<Decimal>[], false);
            Eval(9593, o is ImplementOneInterfaceC, false);
            Eval(9594, o is ImplementOneInterfaceC[], false);
            Eval(9595, o is ImplementTwoInterfaceC, false);
            Eval(9596, o is ImplementTwoInterfaceC[], false);
            Eval(9597, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(9598, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(9599, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(9600, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(9601, o is ImplementAllInterfaceC<int>, false);
            Eval(9602, o is ImplementAllInterfaceC<int>[], false);
            Eval(9603, o is SealedClass, false);
            Eval(9604, o is SealedClass[], false);
        }
        {
            IntE? v = default(IntE);
            ValueType o = v;
            Eval(9605, o is EmptyStruct, false);
            Eval(9606, o is EmptyStruct[], false);
            Eval(9607, o is EmptyStruct?, false);
            Eval(9608, o is EmptyStruct?[], false);
            Eval(9609, o is NotEmptyStruct, false);
            Eval(9610, o is NotEmptyStruct[], false);
            Eval(9611, o is NotEmptyStruct?, false);
            Eval(9612, o is NotEmptyStruct?[], false);
            Eval(9613, o is EmptyStructGen<int>, false);
            Eval(9614, o is EmptyStructGen<int>[], false);
            Eval(9615, o is EmptyStructGen<int>?, false);
            Eval(9616, o is EmptyStructGen<int>?[], false);
            Eval(9617, o is NotEmptyStructGen<Guid>, false);
            Eval(9618, o is NotEmptyStructGen<Guid>[], false);
            Eval(9619, o is NotEmptyStructGen<Guid>?, false);
            Eval(9620, o is NotEmptyStructGen<Guid>?[], false);
            Eval(9621, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(9622, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(9623, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(9624, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(9625, o is NestedStruct, false);
            Eval(9626, o is NestedStruct[], false);
            Eval(9627, o is NestedStruct?, false);
            Eval(9628, o is NestedStruct?[], false);
            Eval(9629, o is NestedStructGen<Decimal>, false);
            Eval(9630, o is NestedStructGen<Decimal>[], false);
            Eval(9631, o is NestedStructGen<Decimal>?, false);
            Eval(9632, o is NestedStructGen<Decimal>?[], false);
            Eval(9633, o is ExplicitFieldOffsetStruct, false);
            Eval(9634, o is ExplicitFieldOffsetStruct[], false);
            Eval(9635, o is ExplicitFieldOffsetStruct?, false);
            Eval(9636, o is ExplicitFieldOffsetStruct?[], false);
            Eval(9645, o is MarshalAsStruct, false);
            Eval(9646, o is MarshalAsStruct[], false);
            Eval(9647, o is MarshalAsStruct?, false);
            Eval(9648, o is MarshalAsStruct?[], false);
            Eval(9649, o is ImplementOneInterface, false);
            Eval(9650, o is ImplementOneInterface[], false);
            Eval(9651, o is ImplementOneInterface?, false);
            Eval(9652, o is ImplementOneInterface?[], false);
            Eval(9653, o is ImplementTwoInterface, false);
            Eval(9654, o is ImplementTwoInterface[], false);
            Eval(9655, o is ImplementTwoInterface?, false);
            Eval(9656, o is ImplementTwoInterface?[], false);
            Eval(9657, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(9658, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(9659, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(9660, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(9661, o is ImplementTwoInterfaceGen<int>, false);
            Eval(9662, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(9663, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(9664, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(9665, o is ImplementAllInterface<int>, false);
            Eval(9666, o is ImplementAllInterface<int>[], false);
            Eval(9667, o is ImplementAllInterface<int>?, false);
            Eval(9668, o is ImplementAllInterface<int>?[], false);
            Eval(9669, o is IntE, true);
            Eval(9670, o is IntE[], false);
            Eval(9671, o is IntE?, true);
            Eval(9672, o is IntE?[], false);
            Eval(9673, o is ByteE, false);
            Eval(9674, o is ByteE[], false);
            Eval(9675, o is ByteE?, false);
            Eval(9676, o is ByteE?[], false);
            Eval(9677, o is LongE, false);
            Eval(9678, o is LongE[], false);
            Eval(9679, o is LongE?, false);
            Eval(9680, o is LongE?[], false);
            Eval(9681, o is char, false);
            Eval(9682, o is char[], false);
            Eval(9683, o is char?, false);
            Eval(9684, o is char?[], false);
            Eval(9685, o is bool, false);
            Eval(9686, o is bool[], false);
            Eval(9687, o is bool?, false);
            Eval(9688, o is bool?[], false);
            Eval(9689, o is byte, false);
            Eval(9690, o is byte[], false);
            Eval(9691, o is byte?, false);
            Eval(9692, o is byte?[], false);
            Eval(9693, o is sbyte, false);
            Eval(9694, o is sbyte[], false);
            Eval(9695, o is sbyte?, false);
            Eval(9696, o is sbyte?[], false);
            Eval(9697, o is short, false);
            Eval(9698, o is short[], false);
            Eval(9699, o is short?, false);
            Eval(9700, o is short?[], false);
            Eval(9701, o is ushort, false);
            Eval(9702, o is ushort[], false);
            Eval(9703, o is ushort?, false);
            Eval(9704, o is ushort?[], false);
            Eval(9705, o is int, false);
            Eval(9706, o is int[], false);
            Eval(9707, o is int?, false);
            Eval(9708, o is int?[], false);
            Eval(9709, o is uint, false);
            Eval(9710, o is uint[], false);
            Eval(9711, o is uint?, false);
            Eval(9712, o is uint?[], false);
            Eval(9713, o is long, false);
            Eval(9714, o is long[], false);
            Eval(9715, o is long?, false);
            Eval(9716, o is long?[], false);
            Eval(9717, o is ulong, false);
            Eval(9718, o is ulong[], false);
            Eval(9719, o is ulong?, false);
            Eval(9720, o is ulong?[], false);
            Eval(9721, o is float, false);
            Eval(9722, o is float[], false);
            Eval(9723, o is float?, false);
            Eval(9724, o is float?[], false);
            Eval(9725, o is double, false);
            Eval(9726, o is double[], false);
            Eval(9727, o is double?, false);
            Eval(9728, o is double?[], false);
            Eval(9729, o is decimal, false);
            Eval(9730, o is decimal[], false);
            Eval(9731, o is decimal?, false);
            Eval(9732, o is decimal?[], false);
            Eval(9733, o is IntPtr, false);
            Eval(9734, o is IntPtr[], false);
            Eval(9735, o is IntPtr?, false);
            Eval(9736, o is IntPtr?[], false);
            Eval(9737, o is UIntPtr, false);
            Eval(9738, o is UIntPtr[], false);
            Eval(9739, o is UIntPtr?, false);
            Eval(9740, o is UIntPtr?[], false);
            Eval(9741, o is Guid, false);
            Eval(9742, o is Guid[], false);
            Eval(9743, o is Guid?, false);
            Eval(9744, o is Guid?[], false);
            Eval(9745, o is GCHandle, false);
            Eval(9746, o is GCHandle[], false);
            Eval(9747, o is GCHandle?, false);
            Eval(9748, o is GCHandle?[], false);
            Eval(9749, o is object, true);
            Eval(9750, o is object[], false);
            Eval(9751, o is string, false);
            Eval(9752, o is string[], false);
            Eval(9753, o is ValueType, true);
            Eval(9754, o is ValueType[], false);
            Eval(9755, o is Array, false);
            Eval(9756, o is Array[], false);
            Eval(9757, o is Enum, true);
            Eval(9758, o is Enum[], false);
            Eval(9759, o is Delegate, false);
            Eval(9760, o is Delegate[], false);
            Eval(9761, o is MulticastDelegate, false);
            Eval(9762, o is MulticastDelegate[], false);
            Eval(9763, o is IEmpty, false);
            Eval(9764, o is IEmpty[], false);
            Eval(9765, o is INotEmpty, false);
            Eval(9766, o is INotEmpty[], false);
            Eval(9767, o is IEmptyGen<int>, false);
            Eval(9768, o is IEmptyGen<int>[], false);
            Eval(9769, o is INotEmptyGen<int>, false);
            Eval(9770, o is INotEmptyGen<int>[], false);
            Eval(9771, o is SimpleDelegate, false);
            Eval(9772, o is SimpleDelegate[], false);
            Eval(9773, o is GenericDelegate<int>, false);
            Eval(9774, o is GenericDelegate<int>[], false);
            Eval(9775, o is EmptyClass, false);
            Eval(9776, o is EmptyClass[], false);
            Eval(9777, o is NotEmptyClass, false);
            Eval(9778, o is NotEmptyClass[], false);
            Eval(9779, o is EmptyClassGen<int>, false);
            Eval(9780, o is EmptyClassGen<int>[], false);
            Eval(9781, o is NotEmptyClassGen<Guid>, false);
            Eval(9782, o is NotEmptyClassGen<Guid>[], false);
            Eval(9783, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(9784, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(9785, o is NestedClass, false);
            Eval(9786, o is NestedClass[], false);
            Eval(9787, o is NestedClassGen<Decimal>, false);
            Eval(9788, o is NestedClassGen<Decimal>[], false);
            Eval(9789, o is ImplementOneInterfaceC, false);
            Eval(9790, o is ImplementOneInterfaceC[], false);
            Eval(9791, o is ImplementTwoInterfaceC, false);
            Eval(9792, o is ImplementTwoInterfaceC[], false);
            Eval(9793, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(9794, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(9795, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(9796, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(9797, o is ImplementAllInterfaceC<int>, false);
            Eval(9798, o is ImplementAllInterfaceC<int>[], false);
            Eval(9799, o is SealedClass, false);
            Eval(9800, o is SealedClass[], false);
        }
        {
            IntE? v = default(IntE?);
            ValueType o = v;
            Eval(9801, o is EmptyStruct, false);
            Eval(9802, o is EmptyStruct[], false);
            Eval(9803, o is EmptyStruct?, false);
            Eval(9804, o is EmptyStruct?[], false);
            Eval(9805, o is NotEmptyStruct, false);
            Eval(9806, o is NotEmptyStruct[], false);
            Eval(9807, o is NotEmptyStruct?, false);
            Eval(9808, o is NotEmptyStruct?[], false);
            Eval(9809, o is EmptyStructGen<int>, false);
            Eval(9810, o is EmptyStructGen<int>[], false);
            Eval(9811, o is EmptyStructGen<int>?, false);
            Eval(9812, o is EmptyStructGen<int>?[], false);
            Eval(9813, o is NotEmptyStructGen<Guid>, false);
            Eval(9814, o is NotEmptyStructGen<Guid>[], false);
            Eval(9815, o is NotEmptyStructGen<Guid>?, false);
            Eval(9816, o is NotEmptyStructGen<Guid>?[], false);
            Eval(9817, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(9818, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(9819, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(9820, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(9821, o is NestedStruct, false);
            Eval(9822, o is NestedStruct[], false);
            Eval(9823, o is NestedStruct?, false);
            Eval(9824, o is NestedStruct?[], false);
            Eval(9825, o is NestedStructGen<Decimal>, false);
            Eval(9826, o is NestedStructGen<Decimal>[], false);
            Eval(9827, o is NestedStructGen<Decimal>?, false);
            Eval(9828, o is NestedStructGen<Decimal>?[], false);
            Eval(9829, o is ExplicitFieldOffsetStruct, false);
            Eval(9830, o is ExplicitFieldOffsetStruct[], false);
            Eval(9831, o is ExplicitFieldOffsetStruct?, false);
            Eval(9832, o is ExplicitFieldOffsetStruct?[], false);
            Eval(9841, o is MarshalAsStruct, false);
            Eval(9842, o is MarshalAsStruct[], false);
            Eval(9843, o is MarshalAsStruct?, false);
            Eval(9844, o is MarshalAsStruct?[], false);
            Eval(9845, o is ImplementOneInterface, false);
            Eval(9846, o is ImplementOneInterface[], false);
            Eval(9847, o is ImplementOneInterface?, false);
            Eval(9848, o is ImplementOneInterface?[], false);
            Eval(9849, o is ImplementTwoInterface, false);
            Eval(9850, o is ImplementTwoInterface[], false);
            Eval(9851, o is ImplementTwoInterface?, false);
            Eval(9852, o is ImplementTwoInterface?[], false);
            Eval(9853, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(9854, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(9855, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(9856, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(9857, o is ImplementTwoInterfaceGen<int>, false);
            Eval(9858, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(9859, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(9860, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(9861, o is ImplementAllInterface<int>, false);
            Eval(9862, o is ImplementAllInterface<int>[], false);
            Eval(9863, o is ImplementAllInterface<int>?, false);
            Eval(9864, o is ImplementAllInterface<int>?[], false);
            Eval(9865, o is IntE, false);
            Eval(9866, o is IntE[], false);
            Eval(9867, o is IntE?, false);
            Eval(9868, o is IntE?[], false);
            Eval(9869, o is ByteE, false);
            Eval(9870, o is ByteE[], false);
            Eval(9871, o is ByteE?, false);
            Eval(9872, o is ByteE?[], false);
            Eval(9873, o is LongE, false);
            Eval(9874, o is LongE[], false);
            Eval(9875, o is LongE?, false);
            Eval(9876, o is LongE?[], false);
            Eval(9877, o is char, false);
            Eval(9878, o is char[], false);
            Eval(9879, o is char?, false);
            Eval(9880, o is char?[], false);
            Eval(9881, o is bool, false);
            Eval(9882, o is bool[], false);
            Eval(9883, o is bool?, false);
            Eval(9884, o is bool?[], false);
            Eval(9885, o is byte, false);
            Eval(9886, o is byte[], false);
            Eval(9887, o is byte?, false);
            Eval(9888, o is byte?[], false);
            Eval(9889, o is sbyte, false);
            Eval(9890, o is sbyte[], false);
            Eval(9891, o is sbyte?, false);
            Eval(9892, o is sbyte?[], false);
            Eval(9893, o is short, false);
            Eval(9894, o is short[], false);
            Eval(9895, o is short?, false);
            Eval(9896, o is short?[], false);
            Eval(9897, o is ushort, false);
            Eval(9898, o is ushort[], false);
            Eval(9899, o is ushort?, false);
            Eval(9900, o is ushort?[], false);
            Eval(9901, o is int, false);
            Eval(9902, o is int[], false);
            Eval(9903, o is int?, false);
            Eval(9904, o is int?[], false);
            Eval(9905, o is uint, false);
            Eval(9906, o is uint[], false);
            Eval(9907, o is uint?, false);
            Eval(9908, o is uint?[], false);
            Eval(9909, o is long, false);
            Eval(9910, o is long[], false);
            Eval(9911, o is long?, false);
            Eval(9912, o is long?[], false);
            Eval(9913, o is ulong, false);
            Eval(9914, o is ulong[], false);
            Eval(9915, o is ulong?, false);
            Eval(9916, o is ulong?[], false);
            Eval(9917, o is float, false);
            Eval(9918, o is float[], false);
            Eval(9919, o is float?, false);
            Eval(9920, o is float?[], false);
            Eval(9921, o is double, false);
            Eval(9922, o is double[], false);
            Eval(9923, o is double?, false);
            Eval(9924, o is double?[], false);
            Eval(9925, o is decimal, false);
            Eval(9926, o is decimal[], false);
            Eval(9927, o is decimal?, false);
            Eval(9928, o is decimal?[], false);
            Eval(9929, o is IntPtr, false);
            Eval(9930, o is IntPtr[], false);
            Eval(9931, o is IntPtr?, false);
            Eval(9932, o is IntPtr?[], false);
            Eval(9933, o is UIntPtr, false);
            Eval(9934, o is UIntPtr[], false);
            Eval(9935, o is UIntPtr?, false);
            Eval(9936, o is UIntPtr?[], false);
            Eval(9937, o is Guid, false);
            Eval(9938, o is Guid[], false);
            Eval(9939, o is Guid?, false);
            Eval(9940, o is Guid?[], false);
            Eval(9941, o is GCHandle, false);
            Eval(9942, o is GCHandle[], false);
            Eval(9943, o is GCHandle?, false);
            Eval(9944, o is GCHandle?[], false);
            Eval(9945, o is object, false);
            Eval(9946, o is object[], false);
            Eval(9947, o is string, false);
            Eval(9948, o is string[], false);
            Eval(9949, o is ValueType, false);
            Eval(9950, o is ValueType[], false);
            Eval(9951, o is Array, false);
            Eval(9952, o is Array[], false);
            Eval(9953, o is Enum, false);
            Eval(9954, o is Enum[], false);
            Eval(9955, o is Delegate, false);
            Eval(9956, o is Delegate[], false);
            Eval(9957, o is MulticastDelegate, false);
            Eval(9958, o is MulticastDelegate[], false);
            Eval(9959, o is IEmpty, false);
            Eval(9960, o is IEmpty[], false);
            Eval(9961, o is INotEmpty, false);
            Eval(9962, o is INotEmpty[], false);
            Eval(9963, o is IEmptyGen<int>, false);
            Eval(9964, o is IEmptyGen<int>[], false);
            Eval(9965, o is INotEmptyGen<int>, false);
            Eval(9966, o is INotEmptyGen<int>[], false);
            Eval(9967, o is SimpleDelegate, false);
            Eval(9968, o is SimpleDelegate[], false);
            Eval(9969, o is GenericDelegate<int>, false);
            Eval(9970, o is GenericDelegate<int>[], false);
            Eval(9971, o is EmptyClass, false);
            Eval(9972, o is EmptyClass[], false);
            Eval(9973, o is NotEmptyClass, false);
            Eval(9974, o is NotEmptyClass[], false);
            Eval(9975, o is EmptyClassGen<int>, false);
            Eval(9976, o is EmptyClassGen<int>[], false);
            Eval(9977, o is NotEmptyClassGen<Guid>, false);
            Eval(9978, o is NotEmptyClassGen<Guid>[], false);
            Eval(9979, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(9980, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(9981, o is NestedClass, false);
            Eval(9982, o is NestedClass[], false);
            Eval(9983, o is NestedClassGen<Decimal>, false);
            Eval(9984, o is NestedClassGen<Decimal>[], false);
            Eval(9985, o is ImplementOneInterfaceC, false);
            Eval(9986, o is ImplementOneInterfaceC[], false);
            Eval(9987, o is ImplementTwoInterfaceC, false);
            Eval(9988, o is ImplementTwoInterfaceC[], false);
            Eval(9989, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(9990, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(9991, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(9992, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(9993, o is ImplementAllInterfaceC<int>, false);
            Eval(9994, o is ImplementAllInterfaceC<int>[], false);
            Eval(9995, o is SealedClass, false);
            Eval(9996, o is SealedClass[], false);
        }
    }  // end of test case 0017
    private static void TestCase0018()
    {
        {
            ByteE v = default(ByteE);
            ValueType o = v;
            Eval(9997, o is EmptyStruct, false);
            Eval(9998, o is EmptyStruct[], false);
            Eval(9999, o is EmptyStruct?, false);
            Eval(10000, o is EmptyStruct?[], false);
            Eval(10001, o is NotEmptyStruct, false);
            Eval(10002, o is NotEmptyStruct[], false);
            Eval(10003, o is NotEmptyStruct?, false);
            Eval(10004, o is NotEmptyStruct?[], false);
            Eval(10005, o is EmptyStructGen<int>, false);
            Eval(10006, o is EmptyStructGen<int>[], false);
            Eval(10007, o is EmptyStructGen<int>?, false);
            Eval(10008, o is EmptyStructGen<int>?[], false);
            Eval(10009, o is NotEmptyStructGen<Guid>, false);
            Eval(10010, o is NotEmptyStructGen<Guid>[], false);
            Eval(10011, o is NotEmptyStructGen<Guid>?, false);
            Eval(10012, o is NotEmptyStructGen<Guid>?[], false);
            Eval(10013, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(10014, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(10015, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(10016, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(10017, o is NestedStruct, false);
            Eval(10018, o is NestedStruct[], false);
            Eval(10019, o is NestedStruct?, false);
            Eval(10020, o is NestedStruct?[], false);
            Eval(10021, o is NestedStructGen<Decimal>, false);
            Eval(10022, o is NestedStructGen<Decimal>[], false);
            Eval(10023, o is NestedStructGen<Decimal>?, false);
            Eval(10024, o is NestedStructGen<Decimal>?[], false);
            Eval(10025, o is ExplicitFieldOffsetStruct, false);
            Eval(10026, o is ExplicitFieldOffsetStruct[], false);
            Eval(10027, o is ExplicitFieldOffsetStruct?, false);
            Eval(10028, o is ExplicitFieldOffsetStruct?[], false);
            Eval(10037, o is MarshalAsStruct, false);
            Eval(10038, o is MarshalAsStruct[], false);
            Eval(10039, o is MarshalAsStruct?, false);
            Eval(10040, o is MarshalAsStruct?[], false);
            Eval(10041, o is ImplementOneInterface, false);
            Eval(10042, o is ImplementOneInterface[], false);
            Eval(10043, o is ImplementOneInterface?, false);
            Eval(10044, o is ImplementOneInterface?[], false);
            Eval(10045, o is ImplementTwoInterface, false);
            Eval(10046, o is ImplementTwoInterface[], false);
            Eval(10047, o is ImplementTwoInterface?, false);
            Eval(10048, o is ImplementTwoInterface?[], false);
            Eval(10049, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(10050, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(10051, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(10052, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(10053, o is ImplementTwoInterfaceGen<int>, false);
            Eval(10054, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(10055, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(10056, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(10057, o is ImplementAllInterface<int>, false);
            Eval(10058, o is ImplementAllInterface<int>[], false);
            Eval(10059, o is ImplementAllInterface<int>?, false);
            Eval(10060, o is ImplementAllInterface<int>?[], false);
            Eval(10061, o is IntE, false);
            Eval(10062, o is IntE[], false);
            Eval(10063, o is IntE?, false);
            Eval(10064, o is IntE?[], false);
            Eval(10065, o is ByteE, true);
            Eval(10066, o is ByteE[], false);
            Eval(10067, o is ByteE?, true);
            Eval(10068, o is ByteE?[], false);
            Eval(10069, o is LongE, false);
            Eval(10070, o is LongE[], false);
            Eval(10071, o is LongE?, false);
            Eval(10072, o is LongE?[], false);
            Eval(10073, o is char, false);
            Eval(10074, o is char[], false);
            Eval(10075, o is char?, false);
            Eval(10076, o is char?[], false);
            Eval(10077, o is bool, false);
            Eval(10078, o is bool[], false);
            Eval(10079, o is bool?, false);
            Eval(10080, o is bool?[], false);
            Eval(10081, o is byte, false);
            Eval(10082, o is byte[], false);
            Eval(10083, o is byte?, false);
            Eval(10084, o is byte?[], false);
            Eval(10085, o is sbyte, false);
            Eval(10086, o is sbyte[], false);
            Eval(10087, o is sbyte?, false);
            Eval(10088, o is sbyte?[], false);
            Eval(10089, o is short, false);
            Eval(10090, o is short[], false);
            Eval(10091, o is short?, false);
            Eval(10092, o is short?[], false);
            Eval(10093, o is ushort, false);
            Eval(10094, o is ushort[], false);
            Eval(10095, o is ushort?, false);
            Eval(10096, o is ushort?[], false);
            Eval(10097, o is int, false);
            Eval(10098, o is int[], false);
            Eval(10099, o is int?, false);
            Eval(10100, o is int?[], false);
            Eval(10101, o is uint, false);
            Eval(10102, o is uint[], false);
            Eval(10103, o is uint?, false);
            Eval(10104, o is uint?[], false);
            Eval(10105, o is long, false);
            Eval(10106, o is long[], false);
            Eval(10107, o is long?, false);
            Eval(10108, o is long?[], false);
            Eval(10109, o is ulong, false);
            Eval(10110, o is ulong[], false);
            Eval(10111, o is ulong?, false);
            Eval(10112, o is ulong?[], false);
            Eval(10113, o is float, false);
            Eval(10114, o is float[], false);
            Eval(10115, o is float?, false);
            Eval(10116, o is float?[], false);
            Eval(10117, o is double, false);
            Eval(10118, o is double[], false);
            Eval(10119, o is double?, false);
            Eval(10120, o is double?[], false);
            Eval(10121, o is decimal, false);
            Eval(10122, o is decimal[], false);
            Eval(10123, o is decimal?, false);
            Eval(10124, o is decimal?[], false);
            Eval(10125, o is IntPtr, false);
            Eval(10126, o is IntPtr[], false);
            Eval(10127, o is IntPtr?, false);
            Eval(10128, o is IntPtr?[], false);
            Eval(10129, o is UIntPtr, false);
            Eval(10130, o is UIntPtr[], false);
            Eval(10131, o is UIntPtr?, false);
            Eval(10132, o is UIntPtr?[], false);
            Eval(10133, o is Guid, false);
            Eval(10134, o is Guid[], false);
            Eval(10135, o is Guid?, false);
            Eval(10136, o is Guid?[], false);
            Eval(10137, o is GCHandle, false);
            Eval(10138, o is GCHandle[], false);
            Eval(10139, o is GCHandle?, false);
            Eval(10140, o is GCHandle?[], false);
            Eval(10141, o is object, true);
            Eval(10142, o is object[], false);
            Eval(10143, o is string, false);
            Eval(10144, o is string[], false);
            Eval(10145, o is ValueType, true);
            Eval(10146, o is ValueType[], false);
            Eval(10147, o is Array, false);
            Eval(10148, o is Array[], false);
            Eval(10149, o is Enum, true);
            Eval(10150, o is Enum[], false);
            Eval(10151, o is Delegate, false);
            Eval(10152, o is Delegate[], false);
            Eval(10153, o is MulticastDelegate, false);
            Eval(10154, o is MulticastDelegate[], false);
            Eval(10155, o is IEmpty, false);
            Eval(10156, o is IEmpty[], false);
            Eval(10157, o is INotEmpty, false);
            Eval(10158, o is INotEmpty[], false);
            Eval(10159, o is IEmptyGen<int>, false);
            Eval(10160, o is IEmptyGen<int>[], false);
            Eval(10161, o is INotEmptyGen<int>, false);
            Eval(10162, o is INotEmptyGen<int>[], false);
            Eval(10163, o is SimpleDelegate, false);
            Eval(10164, o is SimpleDelegate[], false);
            Eval(10165, o is GenericDelegate<int>, false);
            Eval(10166, o is GenericDelegate<int>[], false);
            Eval(10167, o is EmptyClass, false);
            Eval(10168, o is EmptyClass[], false);
            Eval(10169, o is NotEmptyClass, false);
            Eval(10170, o is NotEmptyClass[], false);
            Eval(10171, o is EmptyClassGen<int>, false);
            Eval(10172, o is EmptyClassGen<int>[], false);
            Eval(10173, o is NotEmptyClassGen<Guid>, false);
            Eval(10174, o is NotEmptyClassGen<Guid>[], false);
            Eval(10175, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(10176, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(10177, o is NestedClass, false);
            Eval(10178, o is NestedClass[], false);
            Eval(10179, o is NestedClassGen<Decimal>, false);
            Eval(10180, o is NestedClassGen<Decimal>[], false);
            Eval(10181, o is ImplementOneInterfaceC, false);
            Eval(10182, o is ImplementOneInterfaceC[], false);
            Eval(10183, o is ImplementTwoInterfaceC, false);
            Eval(10184, o is ImplementTwoInterfaceC[], false);
            Eval(10185, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(10186, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(10187, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(10188, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(10189, o is ImplementAllInterfaceC<int>, false);
            Eval(10190, o is ImplementAllInterfaceC<int>[], false);
            Eval(10191, o is SealedClass, false);
            Eval(10192, o is SealedClass[], false);
        }
        {
            ByteE? v = default(ByteE);
            ValueType o = v;
            Eval(10193, o is EmptyStruct, false);
            Eval(10194, o is EmptyStruct[], false);
            Eval(10195, o is EmptyStruct?, false);
            Eval(10196, o is EmptyStruct?[], false);
            Eval(10197, o is NotEmptyStruct, false);
            Eval(10198, o is NotEmptyStruct[], false);
            Eval(10199, o is NotEmptyStruct?, false);
            Eval(10200, o is NotEmptyStruct?[], false);
            Eval(10201, o is EmptyStructGen<int>, false);
            Eval(10202, o is EmptyStructGen<int>[], false);
            Eval(10203, o is EmptyStructGen<int>?, false);
            Eval(10204, o is EmptyStructGen<int>?[], false);
            Eval(10205, o is NotEmptyStructGen<Guid>, false);
            Eval(10206, o is NotEmptyStructGen<Guid>[], false);
            Eval(10207, o is NotEmptyStructGen<Guid>?, false);
            Eval(10208, o is NotEmptyStructGen<Guid>?[], false);
            Eval(10209, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(10210, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(10211, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(10212, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(10213, o is NestedStruct, false);
            Eval(10214, o is NestedStruct[], false);
            Eval(10215, o is NestedStruct?, false);
            Eval(10216, o is NestedStruct?[], false);
            Eval(10217, o is NestedStructGen<Decimal>, false);
            Eval(10218, o is NestedStructGen<Decimal>[], false);
            Eval(10219, o is NestedStructGen<Decimal>?, false);
            Eval(10220, o is NestedStructGen<Decimal>?[], false);
            Eval(10221, o is ExplicitFieldOffsetStruct, false);
            Eval(10222, o is ExplicitFieldOffsetStruct[], false);
            Eval(10223, o is ExplicitFieldOffsetStruct?, false);
            Eval(10224, o is ExplicitFieldOffsetStruct?[], false);
            Eval(10233, o is MarshalAsStruct, false);
            Eval(10234, o is MarshalAsStruct[], false);
            Eval(10235, o is MarshalAsStruct?, false);
            Eval(10236, o is MarshalAsStruct?[], false);
            Eval(10237, o is ImplementOneInterface, false);
            Eval(10238, o is ImplementOneInterface[], false);
            Eval(10239, o is ImplementOneInterface?, false);
            Eval(10240, o is ImplementOneInterface?[], false);
            Eval(10241, o is ImplementTwoInterface, false);
            Eval(10242, o is ImplementTwoInterface[], false);
            Eval(10243, o is ImplementTwoInterface?, false);
            Eval(10244, o is ImplementTwoInterface?[], false);
            Eval(10245, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(10246, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(10247, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(10248, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(10249, o is ImplementTwoInterfaceGen<int>, false);
            Eval(10250, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(10251, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(10252, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(10253, o is ImplementAllInterface<int>, false);
            Eval(10254, o is ImplementAllInterface<int>[], false);
            Eval(10255, o is ImplementAllInterface<int>?, false);
            Eval(10256, o is ImplementAllInterface<int>?[], false);
            Eval(10257, o is IntE, false);
            Eval(10258, o is IntE[], false);
            Eval(10259, o is IntE?, false);
            Eval(10260, o is IntE?[], false);
            Eval(10261, o is ByteE, true);
            Eval(10262, o is ByteE[], false);
            Eval(10263, o is ByteE?, true);
            Eval(10264, o is ByteE?[], false);
            Eval(10265, o is LongE, false);
            Eval(10266, o is LongE[], false);
            Eval(10267, o is LongE?, false);
            Eval(10268, o is LongE?[], false);
            Eval(10269, o is char, false);
            Eval(10270, o is char[], false);
            Eval(10271, o is char?, false);
            Eval(10272, o is char?[], false);
            Eval(10273, o is bool, false);
            Eval(10274, o is bool[], false);
            Eval(10275, o is bool?, false);
            Eval(10276, o is bool?[], false);
            Eval(10277, o is byte, false);
            Eval(10278, o is byte[], false);
            Eval(10279, o is byte?, false);
            Eval(10280, o is byte?[], false);
            Eval(10281, o is sbyte, false);
            Eval(10282, o is sbyte[], false);
            Eval(10283, o is sbyte?, false);
            Eval(10284, o is sbyte?[], false);
            Eval(10285, o is short, false);
            Eval(10286, o is short[], false);
            Eval(10287, o is short?, false);
            Eval(10288, o is short?[], false);
            Eval(10289, o is ushort, false);
            Eval(10290, o is ushort[], false);
            Eval(10291, o is ushort?, false);
            Eval(10292, o is ushort?[], false);
            Eval(10293, o is int, false);
            Eval(10294, o is int[], false);
            Eval(10295, o is int?, false);
            Eval(10296, o is int?[], false);
            Eval(10297, o is uint, false);
            Eval(10298, o is uint[], false);
            Eval(10299, o is uint?, false);
            Eval(10300, o is uint?[], false);
            Eval(10301, o is long, false);
            Eval(10302, o is long[], false);
            Eval(10303, o is long?, false);
            Eval(10304, o is long?[], false);
            Eval(10305, o is ulong, false);
            Eval(10306, o is ulong[], false);
            Eval(10307, o is ulong?, false);
            Eval(10308, o is ulong?[], false);
            Eval(10309, o is float, false);
            Eval(10310, o is float[], false);
            Eval(10311, o is float?, false);
            Eval(10312, o is float?[], false);
            Eval(10313, o is double, false);
            Eval(10314, o is double[], false);
            Eval(10315, o is double?, false);
            Eval(10316, o is double?[], false);
            Eval(10317, o is decimal, false);
            Eval(10318, o is decimal[], false);
            Eval(10319, o is decimal?, false);
            Eval(10320, o is decimal?[], false);
            Eval(10321, o is IntPtr, false);
            Eval(10322, o is IntPtr[], false);
            Eval(10323, o is IntPtr?, false);
            Eval(10324, o is IntPtr?[], false);
            Eval(10325, o is UIntPtr, false);
            Eval(10326, o is UIntPtr[], false);
            Eval(10327, o is UIntPtr?, false);
            Eval(10328, o is UIntPtr?[], false);
            Eval(10329, o is Guid, false);
            Eval(10330, o is Guid[], false);
            Eval(10331, o is Guid?, false);
            Eval(10332, o is Guid?[], false);
            Eval(10333, o is GCHandle, false);
            Eval(10334, o is GCHandle[], false);
            Eval(10335, o is GCHandle?, false);
            Eval(10336, o is GCHandle?[], false);
            Eval(10337, o is object, true);
            Eval(10338, o is object[], false);
            Eval(10339, o is string, false);
            Eval(10340, o is string[], false);
            Eval(10341, o is ValueType, true);
            Eval(10342, o is ValueType[], false);
            Eval(10343, o is Array, false);
            Eval(10344, o is Array[], false);
            Eval(10345, o is Enum, true);
            Eval(10346, o is Enum[], false);
            Eval(10347, o is Delegate, false);
            Eval(10348, o is Delegate[], false);
            Eval(10349, o is MulticastDelegate, false);
            Eval(10350, o is MulticastDelegate[], false);
            Eval(10351, o is IEmpty, false);
            Eval(10352, o is IEmpty[], false);
            Eval(10353, o is INotEmpty, false);
            Eval(10354, o is INotEmpty[], false);
            Eval(10355, o is IEmptyGen<int>, false);
            Eval(10356, o is IEmptyGen<int>[], false);
            Eval(10357, o is INotEmptyGen<int>, false);
            Eval(10358, o is INotEmptyGen<int>[], false);
            Eval(10359, o is SimpleDelegate, false);
            Eval(10360, o is SimpleDelegate[], false);
            Eval(10361, o is GenericDelegate<int>, false);
            Eval(10362, o is GenericDelegate<int>[], false);
            Eval(10363, o is EmptyClass, false);
            Eval(10364, o is EmptyClass[], false);
            Eval(10365, o is NotEmptyClass, false);
            Eval(10366, o is NotEmptyClass[], false);
            Eval(10367, o is EmptyClassGen<int>, false);
            Eval(10368, o is EmptyClassGen<int>[], false);
            Eval(10369, o is NotEmptyClassGen<Guid>, false);
            Eval(10370, o is NotEmptyClassGen<Guid>[], false);
            Eval(10371, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(10372, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(10373, o is NestedClass, false);
            Eval(10374, o is NestedClass[], false);
            Eval(10375, o is NestedClassGen<Decimal>, false);
            Eval(10376, o is NestedClassGen<Decimal>[], false);
            Eval(10377, o is ImplementOneInterfaceC, false);
            Eval(10378, o is ImplementOneInterfaceC[], false);
            Eval(10379, o is ImplementTwoInterfaceC, false);
            Eval(10380, o is ImplementTwoInterfaceC[], false);
            Eval(10381, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(10382, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(10383, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(10384, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(10385, o is ImplementAllInterfaceC<int>, false);
            Eval(10386, o is ImplementAllInterfaceC<int>[], false);
            Eval(10387, o is SealedClass, false);
            Eval(10388, o is SealedClass[], false);
        }
        {
            ByteE? v = default(ByteE?);
            ValueType o = v;
            Eval(10389, o is EmptyStruct, false);
            Eval(10390, o is EmptyStruct[], false);
            Eval(10391, o is EmptyStruct?, false);
            Eval(10392, o is EmptyStruct?[], false);
            Eval(10393, o is NotEmptyStruct, false);
            Eval(10394, o is NotEmptyStruct[], false);
            Eval(10395, o is NotEmptyStruct?, false);
            Eval(10396, o is NotEmptyStruct?[], false);
            Eval(10397, o is EmptyStructGen<int>, false);
            Eval(10398, o is EmptyStructGen<int>[], false);
            Eval(10399, o is EmptyStructGen<int>?, false);
            Eval(10400, o is EmptyStructGen<int>?[], false);
            Eval(10401, o is NotEmptyStructGen<Guid>, false);
            Eval(10402, o is NotEmptyStructGen<Guid>[], false);
            Eval(10403, o is NotEmptyStructGen<Guid>?, false);
            Eval(10404, o is NotEmptyStructGen<Guid>?[], false);
            Eval(10405, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(10406, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(10407, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(10408, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(10409, o is NestedStruct, false);
            Eval(10410, o is NestedStruct[], false);
            Eval(10411, o is NestedStruct?, false);
            Eval(10412, o is NestedStruct?[], false);
            Eval(10413, o is NestedStructGen<Decimal>, false);
            Eval(10414, o is NestedStructGen<Decimal>[], false);
            Eval(10415, o is NestedStructGen<Decimal>?, false);
            Eval(10416, o is NestedStructGen<Decimal>?[], false);
            Eval(10417, o is ExplicitFieldOffsetStruct, false);
            Eval(10418, o is ExplicitFieldOffsetStruct[], false);
            Eval(10419, o is ExplicitFieldOffsetStruct?, false);
            Eval(10420, o is ExplicitFieldOffsetStruct?[], false);
            Eval(10429, o is MarshalAsStruct, false);
            Eval(10430, o is MarshalAsStruct[], false);
            Eval(10431, o is MarshalAsStruct?, false);
            Eval(10432, o is MarshalAsStruct?[], false);
            Eval(10433, o is ImplementOneInterface, false);
            Eval(10434, o is ImplementOneInterface[], false);
            Eval(10435, o is ImplementOneInterface?, false);
            Eval(10436, o is ImplementOneInterface?[], false);
            Eval(10437, o is ImplementTwoInterface, false);
            Eval(10438, o is ImplementTwoInterface[], false);
            Eval(10439, o is ImplementTwoInterface?, false);
            Eval(10440, o is ImplementTwoInterface?[], false);
            Eval(10441, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(10442, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(10443, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(10444, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(10445, o is ImplementTwoInterfaceGen<int>, false);
            Eval(10446, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(10447, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(10448, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(10449, o is ImplementAllInterface<int>, false);
            Eval(10450, o is ImplementAllInterface<int>[], false);
            Eval(10451, o is ImplementAllInterface<int>?, false);
            Eval(10452, o is ImplementAllInterface<int>?[], false);
            Eval(10453, o is IntE, false);
            Eval(10454, o is IntE[], false);
            Eval(10455, o is IntE?, false);
            Eval(10456, o is IntE?[], false);
            Eval(10457, o is ByteE, false);
            Eval(10458, o is ByteE[], false);
            Eval(10459, o is ByteE?, false);
            Eval(10460, o is ByteE?[], false);
            Eval(10461, o is LongE, false);
            Eval(10462, o is LongE[], false);
            Eval(10463, o is LongE?, false);
            Eval(10464, o is LongE?[], false);
            Eval(10465, o is char, false);
            Eval(10466, o is char[], false);
            Eval(10467, o is char?, false);
            Eval(10468, o is char?[], false);
            Eval(10469, o is bool, false);
            Eval(10470, o is bool[], false);
            Eval(10471, o is bool?, false);
            Eval(10472, o is bool?[], false);
            Eval(10473, o is byte, false);
            Eval(10474, o is byte[], false);
            Eval(10475, o is byte?, false);
            Eval(10476, o is byte?[], false);
            Eval(10477, o is sbyte, false);
            Eval(10478, o is sbyte[], false);
            Eval(10479, o is sbyte?, false);
            Eval(10480, o is sbyte?[], false);
            Eval(10481, o is short, false);
            Eval(10482, o is short[], false);
            Eval(10483, o is short?, false);
            Eval(10484, o is short?[], false);
            Eval(10485, o is ushort, false);
            Eval(10486, o is ushort[], false);
            Eval(10487, o is ushort?, false);
            Eval(10488, o is ushort?[], false);
            Eval(10489, o is int, false);
            Eval(10490, o is int[], false);
            Eval(10491, o is int?, false);
            Eval(10492, o is int?[], false);
            Eval(10493, o is uint, false);
            Eval(10494, o is uint[], false);
            Eval(10495, o is uint?, false);
            Eval(10496, o is uint?[], false);
            Eval(10497, o is long, false);
            Eval(10498, o is long[], false);
            Eval(10499, o is long?, false);
            Eval(10500, o is long?[], false);
            Eval(10501, o is ulong, false);
            Eval(10502, o is ulong[], false);
            Eval(10503, o is ulong?, false);
            Eval(10504, o is ulong?[], false);
            Eval(10505, o is float, false);
            Eval(10506, o is float[], false);
            Eval(10507, o is float?, false);
            Eval(10508, o is float?[], false);
            Eval(10509, o is double, false);
            Eval(10510, o is double[], false);
            Eval(10511, o is double?, false);
            Eval(10512, o is double?[], false);
            Eval(10513, o is decimal, false);
            Eval(10514, o is decimal[], false);
            Eval(10515, o is decimal?, false);
            Eval(10516, o is decimal?[], false);
            Eval(10517, o is IntPtr, false);
            Eval(10518, o is IntPtr[], false);
            Eval(10519, o is IntPtr?, false);
            Eval(10520, o is IntPtr?[], false);
            Eval(10521, o is UIntPtr, false);
            Eval(10522, o is UIntPtr[], false);
            Eval(10523, o is UIntPtr?, false);
            Eval(10524, o is UIntPtr?[], false);
            Eval(10525, o is Guid, false);
            Eval(10526, o is Guid[], false);
            Eval(10527, o is Guid?, false);
            Eval(10528, o is Guid?[], false);
            Eval(10529, o is GCHandle, false);
            Eval(10530, o is GCHandle[], false);
            Eval(10531, o is GCHandle?, false);
            Eval(10532, o is GCHandle?[], false);
            Eval(10533, o is object, false);
            Eval(10534, o is object[], false);
            Eval(10535, o is string, false);
            Eval(10536, o is string[], false);
            Eval(10537, o is ValueType, false);
            Eval(10538, o is ValueType[], false);
            Eval(10539, o is Array, false);
            Eval(10540, o is Array[], false);
            Eval(10541, o is Enum, false);
            Eval(10542, o is Enum[], false);
            Eval(10543, o is Delegate, false);
            Eval(10544, o is Delegate[], false);
            Eval(10545, o is MulticastDelegate, false);
            Eval(10546, o is MulticastDelegate[], false);
            Eval(10547, o is IEmpty, false);
            Eval(10548, o is IEmpty[], false);
            Eval(10549, o is INotEmpty, false);
            Eval(10550, o is INotEmpty[], false);
            Eval(10551, o is IEmptyGen<int>, false);
            Eval(10552, o is IEmptyGen<int>[], false);
            Eval(10553, o is INotEmptyGen<int>, false);
            Eval(10554, o is INotEmptyGen<int>[], false);
            Eval(10555, o is SimpleDelegate, false);
            Eval(10556, o is SimpleDelegate[], false);
            Eval(10557, o is GenericDelegate<int>, false);
            Eval(10558, o is GenericDelegate<int>[], false);
            Eval(10559, o is EmptyClass, false);
            Eval(10560, o is EmptyClass[], false);
            Eval(10561, o is NotEmptyClass, false);
            Eval(10562, o is NotEmptyClass[], false);
            Eval(10563, o is EmptyClassGen<int>, false);
            Eval(10564, o is EmptyClassGen<int>[], false);
            Eval(10565, o is NotEmptyClassGen<Guid>, false);
            Eval(10566, o is NotEmptyClassGen<Guid>[], false);
            Eval(10567, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(10568, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(10569, o is NestedClass, false);
            Eval(10570, o is NestedClass[], false);
            Eval(10571, o is NestedClassGen<Decimal>, false);
            Eval(10572, o is NestedClassGen<Decimal>[], false);
            Eval(10573, o is ImplementOneInterfaceC, false);
            Eval(10574, o is ImplementOneInterfaceC[], false);
            Eval(10575, o is ImplementTwoInterfaceC, false);
            Eval(10576, o is ImplementTwoInterfaceC[], false);
            Eval(10577, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(10578, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(10579, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(10580, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(10581, o is ImplementAllInterfaceC<int>, false);
            Eval(10582, o is ImplementAllInterfaceC<int>[], false);
            Eval(10583, o is SealedClass, false);
            Eval(10584, o is SealedClass[], false);
        }
    }  // end of test case 0018
    private static void TestCase0019()
    {
        {
            LongE v = default(LongE);
            ValueType o = v;
            Eval(10585, o is EmptyStruct, false);
            Eval(10586, o is EmptyStruct[], false);
            Eval(10587, o is EmptyStruct?, false);
            Eval(10588, o is EmptyStruct?[], false);
            Eval(10589, o is NotEmptyStruct, false);
            Eval(10590, o is NotEmptyStruct[], false);
            Eval(10591, o is NotEmptyStruct?, false);
            Eval(10592, o is NotEmptyStruct?[], false);
            Eval(10593, o is EmptyStructGen<int>, false);
            Eval(10594, o is EmptyStructGen<int>[], false);
            Eval(10595, o is EmptyStructGen<int>?, false);
            Eval(10596, o is EmptyStructGen<int>?[], false);
            Eval(10597, o is NotEmptyStructGen<Guid>, false);
            Eval(10598, o is NotEmptyStructGen<Guid>[], false);
            Eval(10599, o is NotEmptyStructGen<Guid>?, false);
            Eval(10600, o is NotEmptyStructGen<Guid>?[], false);
            Eval(10601, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(10602, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(10603, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(10604, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(10605, o is NestedStruct, false);
            Eval(10606, o is NestedStruct[], false);
            Eval(10607, o is NestedStruct?, false);
            Eval(10608, o is NestedStruct?[], false);
            Eval(10609, o is NestedStructGen<Decimal>, false);
            Eval(10610, o is NestedStructGen<Decimal>[], false);
            Eval(10611, o is NestedStructGen<Decimal>?, false);
            Eval(10612, o is NestedStructGen<Decimal>?[], false);
            Eval(10613, o is ExplicitFieldOffsetStruct, false);
            Eval(10614, o is ExplicitFieldOffsetStruct[], false);
            Eval(10615, o is ExplicitFieldOffsetStruct?, false);
            Eval(10616, o is ExplicitFieldOffsetStruct?[], false);
            Eval(10625, o is MarshalAsStruct, false);
            Eval(10626, o is MarshalAsStruct[], false);
            Eval(10627, o is MarshalAsStruct?, false);
            Eval(10628, o is MarshalAsStruct?[], false);
            Eval(10629, o is ImplementOneInterface, false);
            Eval(10630, o is ImplementOneInterface[], false);
            Eval(10631, o is ImplementOneInterface?, false);
            Eval(10632, o is ImplementOneInterface?[], false);
            Eval(10633, o is ImplementTwoInterface, false);
            Eval(10634, o is ImplementTwoInterface[], false);
            Eval(10635, o is ImplementTwoInterface?, false);
            Eval(10636, o is ImplementTwoInterface?[], false);
            Eval(10637, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(10638, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(10639, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(10640, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(10641, o is ImplementTwoInterfaceGen<int>, false);
            Eval(10642, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(10643, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(10644, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(10645, o is ImplementAllInterface<int>, false);
            Eval(10646, o is ImplementAllInterface<int>[], false);
            Eval(10647, o is ImplementAllInterface<int>?, false);
            Eval(10648, o is ImplementAllInterface<int>?[], false);
            Eval(10649, o is IntE, false);
            Eval(10650, o is IntE[], false);
            Eval(10651, o is IntE?, false);
            Eval(10652, o is IntE?[], false);
            Eval(10653, o is ByteE, false);
            Eval(10654, o is ByteE[], false);
            Eval(10655, o is ByteE?, false);
            Eval(10656, o is ByteE?[], false);
            Eval(10657, o is LongE, true);
            Eval(10658, o is LongE[], false);
            Eval(10659, o is LongE?, true);
            Eval(10660, o is LongE?[], false);
            Eval(10661, o is char, false);
            Eval(10662, o is char[], false);
            Eval(10663, o is char?, false);
            Eval(10664, o is char?[], false);
            Eval(10665, o is bool, false);
            Eval(10666, o is bool[], false);
            Eval(10667, o is bool?, false);
            Eval(10668, o is bool?[], false);
            Eval(10669, o is byte, false);
            Eval(10670, o is byte[], false);
            Eval(10671, o is byte?, false);
            Eval(10672, o is byte?[], false);
            Eval(10673, o is sbyte, false);
            Eval(10674, o is sbyte[], false);
            Eval(10675, o is sbyte?, false);
            Eval(10676, o is sbyte?[], false);
            Eval(10677, o is short, false);
            Eval(10678, o is short[], false);
            Eval(10679, o is short?, false);
            Eval(10680, o is short?[], false);
            Eval(10681, o is ushort, false);
            Eval(10682, o is ushort[], false);
            Eval(10683, o is ushort?, false);
            Eval(10684, o is ushort?[], false);
            Eval(10685, o is int, false);
            Eval(10686, o is int[], false);
            Eval(10687, o is int?, false);
            Eval(10688, o is int?[], false);
            Eval(10689, o is uint, false);
            Eval(10690, o is uint[], false);
            Eval(10691, o is uint?, false);
            Eval(10692, o is uint?[], false);
            Eval(10693, o is long, false);
            Eval(10694, o is long[], false);
            Eval(10695, o is long?, false);
            Eval(10696, o is long?[], false);
            Eval(10697, o is ulong, false);
            Eval(10698, o is ulong[], false);
            Eval(10699, o is ulong?, false);
            Eval(10700, o is ulong?[], false);
            Eval(10701, o is float, false);
            Eval(10702, o is float[], false);
            Eval(10703, o is float?, false);
            Eval(10704, o is float?[], false);
            Eval(10705, o is double, false);
            Eval(10706, o is double[], false);
            Eval(10707, o is double?, false);
            Eval(10708, o is double?[], false);
            Eval(10709, o is decimal, false);
            Eval(10710, o is decimal[], false);
            Eval(10711, o is decimal?, false);
            Eval(10712, o is decimal?[], false);
            Eval(10713, o is IntPtr, false);
            Eval(10714, o is IntPtr[], false);
            Eval(10715, o is IntPtr?, false);
            Eval(10716, o is IntPtr?[], false);
            Eval(10717, o is UIntPtr, false);
            Eval(10718, o is UIntPtr[], false);
            Eval(10719, o is UIntPtr?, false);
            Eval(10720, o is UIntPtr?[], false);
            Eval(10721, o is Guid, false);
            Eval(10722, o is Guid[], false);
            Eval(10723, o is Guid?, false);
            Eval(10724, o is Guid?[], false);
            Eval(10725, o is GCHandle, false);
            Eval(10726, o is GCHandle[], false);
            Eval(10727, o is GCHandle?, false);
            Eval(10728, o is GCHandle?[], false);
            Eval(10729, o is object, true);
            Eval(10730, o is object[], false);
            Eval(10731, o is string, false);
            Eval(10732, o is string[], false);
            Eval(10733, o is ValueType, true);
            Eval(10734, o is ValueType[], false);
            Eval(10735, o is Array, false);
            Eval(10736, o is Array[], false);
            Eval(10737, o is Enum, true);
            Eval(10738, o is Enum[], false);
            Eval(10739, o is Delegate, false);
            Eval(10740, o is Delegate[], false);
            Eval(10741, o is MulticastDelegate, false);
            Eval(10742, o is MulticastDelegate[], false);
            Eval(10743, o is IEmpty, false);
            Eval(10744, o is IEmpty[], false);
            Eval(10745, o is INotEmpty, false);
            Eval(10746, o is INotEmpty[], false);
            Eval(10747, o is IEmptyGen<int>, false);
            Eval(10748, o is IEmptyGen<int>[], false);
            Eval(10749, o is INotEmptyGen<int>, false);
            Eval(10750, o is INotEmptyGen<int>[], false);
            Eval(10751, o is SimpleDelegate, false);
            Eval(10752, o is SimpleDelegate[], false);
            Eval(10753, o is GenericDelegate<int>, false);
            Eval(10754, o is GenericDelegate<int>[], false);
            Eval(10755, o is EmptyClass, false);
            Eval(10756, o is EmptyClass[], false);
            Eval(10757, o is NotEmptyClass, false);
            Eval(10758, o is NotEmptyClass[], false);
            Eval(10759, o is EmptyClassGen<int>, false);
            Eval(10760, o is EmptyClassGen<int>[], false);
            Eval(10761, o is NotEmptyClassGen<Guid>, false);
            Eval(10762, o is NotEmptyClassGen<Guid>[], false);
            Eval(10763, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(10764, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(10765, o is NestedClass, false);
            Eval(10766, o is NestedClass[], false);
            Eval(10767, o is NestedClassGen<Decimal>, false);
            Eval(10768, o is NestedClassGen<Decimal>[], false);
            Eval(10769, o is ImplementOneInterfaceC, false);
            Eval(10770, o is ImplementOneInterfaceC[], false);
            Eval(10771, o is ImplementTwoInterfaceC, false);
            Eval(10772, o is ImplementTwoInterfaceC[], false);
            Eval(10773, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(10774, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(10775, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(10776, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(10777, o is ImplementAllInterfaceC<int>, false);
            Eval(10778, o is ImplementAllInterfaceC<int>[], false);
            Eval(10779, o is SealedClass, false);
            Eval(10780, o is SealedClass[], false);
        }
        {
            LongE? v = default(LongE);
            ValueType o = v;
            Eval(10781, o is EmptyStruct, false);
            Eval(10782, o is EmptyStruct[], false);
            Eval(10783, o is EmptyStruct?, false);
            Eval(10784, o is EmptyStruct?[], false);
            Eval(10785, o is NotEmptyStruct, false);
            Eval(10786, o is NotEmptyStruct[], false);
            Eval(10787, o is NotEmptyStruct?, false);
            Eval(10788, o is NotEmptyStruct?[], false);
            Eval(10789, o is EmptyStructGen<int>, false);
            Eval(10790, o is EmptyStructGen<int>[], false);
            Eval(10791, o is EmptyStructGen<int>?, false);
            Eval(10792, o is EmptyStructGen<int>?[], false);
            Eval(10793, o is NotEmptyStructGen<Guid>, false);
            Eval(10794, o is NotEmptyStructGen<Guid>[], false);
            Eval(10795, o is NotEmptyStructGen<Guid>?, false);
            Eval(10796, o is NotEmptyStructGen<Guid>?[], false);
            Eval(10797, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(10798, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(10799, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(10800, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(10801, o is NestedStruct, false);
            Eval(10802, o is NestedStruct[], false);
            Eval(10803, o is NestedStruct?, false);
            Eval(10804, o is NestedStruct?[], false);
            Eval(10805, o is NestedStructGen<Decimal>, false);
            Eval(10806, o is NestedStructGen<Decimal>[], false);
            Eval(10807, o is NestedStructGen<Decimal>?, false);
            Eval(10808, o is NestedStructGen<Decimal>?[], false);
            Eval(10809, o is ExplicitFieldOffsetStruct, false);
            Eval(10810, o is ExplicitFieldOffsetStruct[], false);
            Eval(10811, o is ExplicitFieldOffsetStruct?, false);
            Eval(10812, o is ExplicitFieldOffsetStruct?[], false);
            Eval(10821, o is MarshalAsStruct, false);
            Eval(10822, o is MarshalAsStruct[], false);
            Eval(10823, o is MarshalAsStruct?, false);
            Eval(10824, o is MarshalAsStruct?[], false);
            Eval(10825, o is ImplementOneInterface, false);
            Eval(10826, o is ImplementOneInterface[], false);
            Eval(10827, o is ImplementOneInterface?, false);
            Eval(10828, o is ImplementOneInterface?[], false);
            Eval(10829, o is ImplementTwoInterface, false);
            Eval(10830, o is ImplementTwoInterface[], false);
            Eval(10831, o is ImplementTwoInterface?, false);
            Eval(10832, o is ImplementTwoInterface?[], false);
            Eval(10833, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(10834, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(10835, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(10836, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(10837, o is ImplementTwoInterfaceGen<int>, false);
            Eval(10838, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(10839, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(10840, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(10841, o is ImplementAllInterface<int>, false);
            Eval(10842, o is ImplementAllInterface<int>[], false);
            Eval(10843, o is ImplementAllInterface<int>?, false);
            Eval(10844, o is ImplementAllInterface<int>?[], false);
            Eval(10845, o is IntE, false);
            Eval(10846, o is IntE[], false);
            Eval(10847, o is IntE?, false);
            Eval(10848, o is IntE?[], false);
            Eval(10849, o is ByteE, false);
            Eval(10850, o is ByteE[], false);
            Eval(10851, o is ByteE?, false);
            Eval(10852, o is ByteE?[], false);
            Eval(10853, o is LongE, true);
            Eval(10854, o is LongE[], false);
            Eval(10855, o is LongE?, true);
            Eval(10856, o is LongE?[], false);
            Eval(10857, o is char, false);
            Eval(10858, o is char[], false);
            Eval(10859, o is char?, false);
            Eval(10860, o is char?[], false);
            Eval(10861, o is bool, false);
            Eval(10862, o is bool[], false);
            Eval(10863, o is bool?, false);
            Eval(10864, o is bool?[], false);
            Eval(10865, o is byte, false);
            Eval(10866, o is byte[], false);
            Eval(10867, o is byte?, false);
            Eval(10868, o is byte?[], false);
            Eval(10869, o is sbyte, false);
            Eval(10870, o is sbyte[], false);
            Eval(10871, o is sbyte?, false);
            Eval(10872, o is sbyte?[], false);
            Eval(10873, o is short, false);
            Eval(10874, o is short[], false);
            Eval(10875, o is short?, false);
            Eval(10876, o is short?[], false);
            Eval(10877, o is ushort, false);
            Eval(10878, o is ushort[], false);
            Eval(10879, o is ushort?, false);
            Eval(10880, o is ushort?[], false);
            Eval(10881, o is int, false);
            Eval(10882, o is int[], false);
            Eval(10883, o is int?, false);
            Eval(10884, o is int?[], false);
            Eval(10885, o is uint, false);
            Eval(10886, o is uint[], false);
            Eval(10887, o is uint?, false);
            Eval(10888, o is uint?[], false);
            Eval(10889, o is long, false);
            Eval(10890, o is long[], false);
            Eval(10891, o is long?, false);
            Eval(10892, o is long?[], false);
            Eval(10893, o is ulong, false);
            Eval(10894, o is ulong[], false);
            Eval(10895, o is ulong?, false);
            Eval(10896, o is ulong?[], false);
            Eval(10897, o is float, false);
            Eval(10898, o is float[], false);
            Eval(10899, o is float?, false);
            Eval(10900, o is float?[], false);
            Eval(10901, o is double, false);
            Eval(10902, o is double[], false);
            Eval(10903, o is double?, false);
            Eval(10904, o is double?[], false);
            Eval(10905, o is decimal, false);
            Eval(10906, o is decimal[], false);
            Eval(10907, o is decimal?, false);
            Eval(10908, o is decimal?[], false);
            Eval(10909, o is IntPtr, false);
            Eval(10910, o is IntPtr[], false);
            Eval(10911, o is IntPtr?, false);
            Eval(10912, o is IntPtr?[], false);
            Eval(10913, o is UIntPtr, false);
            Eval(10914, o is UIntPtr[], false);
            Eval(10915, o is UIntPtr?, false);
            Eval(10916, o is UIntPtr?[], false);
            Eval(10917, o is Guid, false);
            Eval(10918, o is Guid[], false);
            Eval(10919, o is Guid?, false);
            Eval(10920, o is Guid?[], false);
            Eval(10921, o is GCHandle, false);
            Eval(10922, o is GCHandle[], false);
            Eval(10923, o is GCHandle?, false);
            Eval(10924, o is GCHandle?[], false);
            Eval(10925, o is object, true);
            Eval(10926, o is object[], false);
            Eval(10927, o is string, false);
            Eval(10928, o is string[], false);
            Eval(10929, o is ValueType, true);
            Eval(10930, o is ValueType[], false);
            Eval(10931, o is Array, false);
            Eval(10932, o is Array[], false);
            Eval(10933, o is Enum, true);
            Eval(10934, o is Enum[], false);
            Eval(10935, o is Delegate, false);
            Eval(10936, o is Delegate[], false);
            Eval(10937, o is MulticastDelegate, false);
            Eval(10938, o is MulticastDelegate[], false);
            Eval(10939, o is IEmpty, false);
            Eval(10940, o is IEmpty[], false);
            Eval(10941, o is INotEmpty, false);
            Eval(10942, o is INotEmpty[], false);
            Eval(10943, o is IEmptyGen<int>, false);
            Eval(10944, o is IEmptyGen<int>[], false);
            Eval(10945, o is INotEmptyGen<int>, false);
            Eval(10946, o is INotEmptyGen<int>[], false);
            Eval(10947, o is SimpleDelegate, false);
            Eval(10948, o is SimpleDelegate[], false);
            Eval(10949, o is GenericDelegate<int>, false);
            Eval(10950, o is GenericDelegate<int>[], false);
            Eval(10951, o is EmptyClass, false);
            Eval(10952, o is EmptyClass[], false);
            Eval(10953, o is NotEmptyClass, false);
            Eval(10954, o is NotEmptyClass[], false);
            Eval(10955, o is EmptyClassGen<int>, false);
            Eval(10956, o is EmptyClassGen<int>[], false);
            Eval(10957, o is NotEmptyClassGen<Guid>, false);
            Eval(10958, o is NotEmptyClassGen<Guid>[], false);
            Eval(10959, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(10960, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(10961, o is NestedClass, false);
            Eval(10962, o is NestedClass[], false);
            Eval(10963, o is NestedClassGen<Decimal>, false);
            Eval(10964, o is NestedClassGen<Decimal>[], false);
            Eval(10965, o is ImplementOneInterfaceC, false);
            Eval(10966, o is ImplementOneInterfaceC[], false);
            Eval(10967, o is ImplementTwoInterfaceC, false);
            Eval(10968, o is ImplementTwoInterfaceC[], false);
            Eval(10969, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(10970, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(10971, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(10972, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(10973, o is ImplementAllInterfaceC<int>, false);
            Eval(10974, o is ImplementAllInterfaceC<int>[], false);
            Eval(10975, o is SealedClass, false);
            Eval(10976, o is SealedClass[], false);
        }
        {
            LongE? v = default(LongE?);
            ValueType o = v;
            Eval(10977, o is EmptyStruct, false);
            Eval(10978, o is EmptyStruct[], false);
            Eval(10979, o is EmptyStruct?, false);
            Eval(10980, o is EmptyStruct?[], false);
            Eval(10981, o is NotEmptyStruct, false);
            Eval(10982, o is NotEmptyStruct[], false);
            Eval(10983, o is NotEmptyStruct?, false);
            Eval(10984, o is NotEmptyStruct?[], false);
            Eval(10985, o is EmptyStructGen<int>, false);
            Eval(10986, o is EmptyStructGen<int>[], false);
            Eval(10987, o is EmptyStructGen<int>?, false);
            Eval(10988, o is EmptyStructGen<int>?[], false);
            Eval(10989, o is NotEmptyStructGen<Guid>, false);
            Eval(10990, o is NotEmptyStructGen<Guid>[], false);
            Eval(10991, o is NotEmptyStructGen<Guid>?, false);
            Eval(10992, o is NotEmptyStructGen<Guid>?[], false);
            Eval(10993, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(10994, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(10995, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(10996, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(10997, o is NestedStruct, false);
            Eval(10998, o is NestedStruct[], false);
            Eval(10999, o is NestedStruct?, false);
            Eval(11000, o is NestedStruct?[], false);
            Eval(11001, o is NestedStructGen<Decimal>, false);
            Eval(11002, o is NestedStructGen<Decimal>[], false);
            Eval(11003, o is NestedStructGen<Decimal>?, false);
            Eval(11004, o is NestedStructGen<Decimal>?[], false);
            Eval(11005, o is ExplicitFieldOffsetStruct, false);
            Eval(11006, o is ExplicitFieldOffsetStruct[], false);
            Eval(11007, o is ExplicitFieldOffsetStruct?, false);
            Eval(11008, o is ExplicitFieldOffsetStruct?[], false);
            Eval(11017, o is MarshalAsStruct, false);
            Eval(11018, o is MarshalAsStruct[], false);
            Eval(11019, o is MarshalAsStruct?, false);
            Eval(11020, o is MarshalAsStruct?[], false);
            Eval(11021, o is ImplementOneInterface, false);
            Eval(11022, o is ImplementOneInterface[], false);
            Eval(11023, o is ImplementOneInterface?, false);
            Eval(11024, o is ImplementOneInterface?[], false);
            Eval(11025, o is ImplementTwoInterface, false);
            Eval(11026, o is ImplementTwoInterface[], false);
            Eval(11027, o is ImplementTwoInterface?, false);
            Eval(11028, o is ImplementTwoInterface?[], false);
            Eval(11029, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(11030, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(11031, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(11032, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(11033, o is ImplementTwoInterfaceGen<int>, false);
            Eval(11034, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(11035, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(11036, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(11037, o is ImplementAllInterface<int>, false);
            Eval(11038, o is ImplementAllInterface<int>[], false);
            Eval(11039, o is ImplementAllInterface<int>?, false);
            Eval(11040, o is ImplementAllInterface<int>?[], false);
            Eval(11041, o is IntE, false);
            Eval(11042, o is IntE[], false);
            Eval(11043, o is IntE?, false);
            Eval(11044, o is IntE?[], false);
            Eval(11045, o is ByteE, false);
            Eval(11046, o is ByteE[], false);
            Eval(11047, o is ByteE?, false);
            Eval(11048, o is ByteE?[], false);
            Eval(11049, o is LongE, false);
            Eval(11050, o is LongE[], false);
            Eval(11051, o is LongE?, false);
            Eval(11052, o is LongE?[], false);
            Eval(11053, o is char, false);
            Eval(11054, o is char[], false);
            Eval(11055, o is char?, false);
            Eval(11056, o is char?[], false);
            Eval(11057, o is bool, false);
            Eval(11058, o is bool[], false);
            Eval(11059, o is bool?, false);
            Eval(11060, o is bool?[], false);
            Eval(11061, o is byte, false);
            Eval(11062, o is byte[], false);
            Eval(11063, o is byte?, false);
            Eval(11064, o is byte?[], false);
            Eval(11065, o is sbyte, false);
            Eval(11066, o is sbyte[], false);
            Eval(11067, o is sbyte?, false);
            Eval(11068, o is sbyte?[], false);
            Eval(11069, o is short, false);
            Eval(11070, o is short[], false);
            Eval(11071, o is short?, false);
            Eval(11072, o is short?[], false);
            Eval(11073, o is ushort, false);
            Eval(11074, o is ushort[], false);
            Eval(11075, o is ushort?, false);
            Eval(11076, o is ushort?[], false);
            Eval(11077, o is int, false);
            Eval(11078, o is int[], false);
            Eval(11079, o is int?, false);
            Eval(11080, o is int?[], false);
            Eval(11081, o is uint, false);
            Eval(11082, o is uint[], false);
            Eval(11083, o is uint?, false);
            Eval(11084, o is uint?[], false);
            Eval(11085, o is long, false);
            Eval(11086, o is long[], false);
            Eval(11087, o is long?, false);
            Eval(11088, o is long?[], false);
            Eval(11089, o is ulong, false);
            Eval(11090, o is ulong[], false);
            Eval(11091, o is ulong?, false);
            Eval(11092, o is ulong?[], false);
            Eval(11093, o is float, false);
            Eval(11094, o is float[], false);
            Eval(11095, o is float?, false);
            Eval(11096, o is float?[], false);
            Eval(11097, o is double, false);
            Eval(11098, o is double[], false);
            Eval(11099, o is double?, false);
            Eval(11100, o is double?[], false);
            Eval(11101, o is decimal, false);
            Eval(11102, o is decimal[], false);
            Eval(11103, o is decimal?, false);
            Eval(11104, o is decimal?[], false);
            Eval(11105, o is IntPtr, false);
            Eval(11106, o is IntPtr[], false);
            Eval(11107, o is IntPtr?, false);
            Eval(11108, o is IntPtr?[], false);
            Eval(11109, o is UIntPtr, false);
            Eval(11110, o is UIntPtr[], false);
            Eval(11111, o is UIntPtr?, false);
            Eval(11112, o is UIntPtr?[], false);
            Eval(11113, o is Guid, false);
            Eval(11114, o is Guid[], false);
            Eval(11115, o is Guid?, false);
            Eval(11116, o is Guid?[], false);
            Eval(11117, o is GCHandle, false);
            Eval(11118, o is GCHandle[], false);
            Eval(11119, o is GCHandle?, false);
            Eval(11120, o is GCHandle?[], false);
            Eval(11121, o is object, false);
            Eval(11122, o is object[], false);
            Eval(11123, o is string, false);
            Eval(11124, o is string[], false);
            Eval(11125, o is ValueType, false);
            Eval(11126, o is ValueType[], false);
            Eval(11127, o is Array, false);
            Eval(11128, o is Array[], false);
            Eval(11129, o is Enum, false);
            Eval(11130, o is Enum[], false);
            Eval(11131, o is Delegate, false);
            Eval(11132, o is Delegate[], false);
            Eval(11133, o is MulticastDelegate, false);
            Eval(11134, o is MulticastDelegate[], false);
            Eval(11135, o is IEmpty, false);
            Eval(11136, o is IEmpty[], false);
            Eval(11137, o is INotEmpty, false);
            Eval(11138, o is INotEmpty[], false);
            Eval(11139, o is IEmptyGen<int>, false);
            Eval(11140, o is IEmptyGen<int>[], false);
            Eval(11141, o is INotEmptyGen<int>, false);
            Eval(11142, o is INotEmptyGen<int>[], false);
            Eval(11143, o is SimpleDelegate, false);
            Eval(11144, o is SimpleDelegate[], false);
            Eval(11145, o is GenericDelegate<int>, false);
            Eval(11146, o is GenericDelegate<int>[], false);
            Eval(11147, o is EmptyClass, false);
            Eval(11148, o is EmptyClass[], false);
            Eval(11149, o is NotEmptyClass, false);
            Eval(11150, o is NotEmptyClass[], false);
            Eval(11151, o is EmptyClassGen<int>, false);
            Eval(11152, o is EmptyClassGen<int>[], false);
            Eval(11153, o is NotEmptyClassGen<Guid>, false);
            Eval(11154, o is NotEmptyClassGen<Guid>[], false);
            Eval(11155, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(11156, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(11157, o is NestedClass, false);
            Eval(11158, o is NestedClass[], false);
            Eval(11159, o is NestedClassGen<Decimal>, false);
            Eval(11160, o is NestedClassGen<Decimal>[], false);
            Eval(11161, o is ImplementOneInterfaceC, false);
            Eval(11162, o is ImplementOneInterfaceC[], false);
            Eval(11163, o is ImplementTwoInterfaceC, false);
            Eval(11164, o is ImplementTwoInterfaceC[], false);
            Eval(11165, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(11166, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(11167, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(11168, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(11169, o is ImplementAllInterfaceC<int>, false);
            Eval(11170, o is ImplementAllInterfaceC<int>[], false);
            Eval(11171, o is SealedClass, false);
            Eval(11172, o is SealedClass[], false);
        }
    }  // end of test case 0019
    private static void TestCase0020()
    {
        {
            char v = default(char);
            ValueType o = v;
            Eval(11173, o is EmptyStruct, false);
            Eval(11174, o is EmptyStruct[], false);
            Eval(11175, o is EmptyStruct?, false);
            Eval(11176, o is EmptyStruct?[], false);
            Eval(11177, o is NotEmptyStruct, false);
            Eval(11178, o is NotEmptyStruct[], false);
            Eval(11179, o is NotEmptyStruct?, false);
            Eval(11180, o is NotEmptyStruct?[], false);
            Eval(11181, o is EmptyStructGen<int>, false);
            Eval(11182, o is EmptyStructGen<int>[], false);
            Eval(11183, o is EmptyStructGen<int>?, false);
            Eval(11184, o is EmptyStructGen<int>?[], false);
            Eval(11185, o is NotEmptyStructGen<Guid>, false);
            Eval(11186, o is NotEmptyStructGen<Guid>[], false);
            Eval(11187, o is NotEmptyStructGen<Guid>?, false);
            Eval(11188, o is NotEmptyStructGen<Guid>?[], false);
            Eval(11189, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(11190, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(11191, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(11192, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(11193, o is NestedStruct, false);
            Eval(11194, o is NestedStruct[], false);
            Eval(11195, o is NestedStruct?, false);
            Eval(11196, o is NestedStruct?[], false);
            Eval(11197, o is NestedStructGen<Decimal>, false);
            Eval(11198, o is NestedStructGen<Decimal>[], false);
            Eval(11199, o is NestedStructGen<Decimal>?, false);
            Eval(11200, o is NestedStructGen<Decimal>?[], false);
            Eval(11201, o is ExplicitFieldOffsetStruct, false);
            Eval(11202, o is ExplicitFieldOffsetStruct[], false);
            Eval(11203, o is ExplicitFieldOffsetStruct?, false);
            Eval(11204, o is ExplicitFieldOffsetStruct?[], false);
            Eval(11213, o is MarshalAsStruct, false);
            Eval(11214, o is MarshalAsStruct[], false);
            Eval(11215, o is MarshalAsStruct?, false);
            Eval(11216, o is MarshalAsStruct?[], false);
            Eval(11217, o is ImplementOneInterface, false);
            Eval(11218, o is ImplementOneInterface[], false);
            Eval(11219, o is ImplementOneInterface?, false);
            Eval(11220, o is ImplementOneInterface?[], false);
            Eval(11221, o is ImplementTwoInterface, false);
            Eval(11222, o is ImplementTwoInterface[], false);
            Eval(11223, o is ImplementTwoInterface?, false);
            Eval(11224, o is ImplementTwoInterface?[], false);
            Eval(11225, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(11226, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(11227, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(11228, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(11229, o is ImplementTwoInterfaceGen<int>, false);
            Eval(11230, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(11231, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(11232, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(11233, o is ImplementAllInterface<int>, false);
            Eval(11234, o is ImplementAllInterface<int>[], false);
            Eval(11235, o is ImplementAllInterface<int>?, false);
            Eval(11236, o is ImplementAllInterface<int>?[], false);
            Eval(11237, o is IntE, false);
            Eval(11238, o is IntE[], false);
            Eval(11239, o is IntE?, false);
            Eval(11240, o is IntE?[], false);
            Eval(11241, o is ByteE, false);
            Eval(11242, o is ByteE[], false);
            Eval(11243, o is ByteE?, false);
            Eval(11244, o is ByteE?[], false);
            Eval(11245, o is LongE, false);
            Eval(11246, o is LongE[], false);
            Eval(11247, o is LongE?, false);
            Eval(11248, o is LongE?[], false);
            Eval(11249, o is char, true);
            Eval(11250, o is char[], false);
            Eval(11251, o is char?, true);
            Eval(11252, o is char?[], false);
            Eval(11253, o is bool, false);
            Eval(11254, o is bool[], false);
            Eval(11255, o is bool?, false);
            Eval(11256, o is bool?[], false);
            Eval(11257, o is byte, false);
            Eval(11258, o is byte[], false);
            Eval(11259, o is byte?, false);
            Eval(11260, o is byte?[], false);
            Eval(11261, o is sbyte, false);
            Eval(11262, o is sbyte[], false);
            Eval(11263, o is sbyte?, false);
            Eval(11264, o is sbyte?[], false);
            Eval(11265, o is short, false);
            Eval(11266, o is short[], false);
            Eval(11267, o is short?, false);
            Eval(11268, o is short?[], false);
            Eval(11269, o is ushort, false);
            Eval(11270, o is ushort[], false);
            Eval(11271, o is ushort?, false);
            Eval(11272, o is ushort?[], false);
            Eval(11273, o is int, false);
            Eval(11274, o is int[], false);
            Eval(11275, o is int?, false);
            Eval(11276, o is int?[], false);
            Eval(11277, o is uint, false);
            Eval(11278, o is uint[], false);
            Eval(11279, o is uint?, false);
            Eval(11280, o is uint?[], false);
            Eval(11281, o is long, false);
            Eval(11282, o is long[], false);
            Eval(11283, o is long?, false);
            Eval(11284, o is long?[], false);
            Eval(11285, o is ulong, false);
            Eval(11286, o is ulong[], false);
            Eval(11287, o is ulong?, false);
            Eval(11288, o is ulong?[], false);
            Eval(11289, o is float, false);
            Eval(11290, o is float[], false);
            Eval(11291, o is float?, false);
            Eval(11292, o is float?[], false);
            Eval(11293, o is double, false);
            Eval(11294, o is double[], false);
            Eval(11295, o is double?, false);
            Eval(11296, o is double?[], false);
            Eval(11297, o is decimal, false);
            Eval(11298, o is decimal[], false);
            Eval(11299, o is decimal?, false);
            Eval(11300, o is decimal?[], false);
            Eval(11301, o is IntPtr, false);
            Eval(11302, o is IntPtr[], false);
            Eval(11303, o is IntPtr?, false);
            Eval(11304, o is IntPtr?[], false);
            Eval(11305, o is UIntPtr, false);
            Eval(11306, o is UIntPtr[], false);
            Eval(11307, o is UIntPtr?, false);
            Eval(11308, o is UIntPtr?[], false);
            Eval(11309, o is Guid, false);
            Eval(11310, o is Guid[], false);
            Eval(11311, o is Guid?, false);
            Eval(11312, o is Guid?[], false);
            Eval(11313, o is GCHandle, false);
            Eval(11314, o is GCHandle[], false);
            Eval(11315, o is GCHandle?, false);
            Eval(11316, o is GCHandle?[], false);
            Eval(11317, o is object, true);
            Eval(11318, o is object[], false);
            Eval(11319, o is string, false);
            Eval(11320, o is string[], false);
            Eval(11321, o is ValueType, true);
            Eval(11322, o is ValueType[], false);
            Eval(11323, o is Array, false);
            Eval(11324, o is Array[], false);
            Eval(11325, o is Enum, false);
            Eval(11326, o is Enum[], false);
            Eval(11327, o is Delegate, false);
            Eval(11328, o is Delegate[], false);
            Eval(11329, o is MulticastDelegate, false);
            Eval(11330, o is MulticastDelegate[], false);
            Eval(11331, o is IEmpty, false);
            Eval(11332, o is IEmpty[], false);
            Eval(11333, o is INotEmpty, false);
            Eval(11334, o is INotEmpty[], false);
            Eval(11335, o is IEmptyGen<int>, false);
            Eval(11336, o is IEmptyGen<int>[], false);
            Eval(11337, o is INotEmptyGen<int>, false);
            Eval(11338, o is INotEmptyGen<int>[], false);
            Eval(11339, o is SimpleDelegate, false);
            Eval(11340, o is SimpleDelegate[], false);
            Eval(11341, o is GenericDelegate<int>, false);
            Eval(11342, o is GenericDelegate<int>[], false);
            Eval(11343, o is EmptyClass, false);
            Eval(11344, o is EmptyClass[], false);
            Eval(11345, o is NotEmptyClass, false);
            Eval(11346, o is NotEmptyClass[], false);
            Eval(11347, o is EmptyClassGen<int>, false);
            Eval(11348, o is EmptyClassGen<int>[], false);
            Eval(11349, o is NotEmptyClassGen<Guid>, false);
            Eval(11350, o is NotEmptyClassGen<Guid>[], false);
            Eval(11351, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(11352, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(11353, o is NestedClass, false);
            Eval(11354, o is NestedClass[], false);
            Eval(11355, o is NestedClassGen<Decimal>, false);
            Eval(11356, o is NestedClassGen<Decimal>[], false);
            Eval(11357, o is ImplementOneInterfaceC, false);
            Eval(11358, o is ImplementOneInterfaceC[], false);
            Eval(11359, o is ImplementTwoInterfaceC, false);
            Eval(11360, o is ImplementTwoInterfaceC[], false);
            Eval(11361, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(11362, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(11363, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(11364, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(11365, o is ImplementAllInterfaceC<int>, false);
            Eval(11366, o is ImplementAllInterfaceC<int>[], false);
            Eval(11367, o is SealedClass, false);
            Eval(11368, o is SealedClass[], false);
        }
        {
            char? v = default(char);
            ValueType o = v;
            Eval(11369, o is EmptyStruct, false);
            Eval(11370, o is EmptyStruct[], false);
            Eval(11371, o is EmptyStruct?, false);
            Eval(11372, o is EmptyStruct?[], false);
            Eval(11373, o is NotEmptyStruct, false);
            Eval(11374, o is NotEmptyStruct[], false);
            Eval(11375, o is NotEmptyStruct?, false);
            Eval(11376, o is NotEmptyStruct?[], false);
            Eval(11377, o is EmptyStructGen<int>, false);
            Eval(11378, o is EmptyStructGen<int>[], false);
            Eval(11379, o is EmptyStructGen<int>?, false);
            Eval(11380, o is EmptyStructGen<int>?[], false);
            Eval(11381, o is NotEmptyStructGen<Guid>, false);
            Eval(11382, o is NotEmptyStructGen<Guid>[], false);
            Eval(11383, o is NotEmptyStructGen<Guid>?, false);
            Eval(11384, o is NotEmptyStructGen<Guid>?[], false);
            Eval(11385, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(11386, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(11387, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(11388, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(11389, o is NestedStruct, false);
            Eval(11390, o is NestedStruct[], false);
            Eval(11391, o is NestedStruct?, false);
            Eval(11392, o is NestedStruct?[], false);
            Eval(11393, o is NestedStructGen<Decimal>, false);
            Eval(11394, o is NestedStructGen<Decimal>[], false);
            Eval(11395, o is NestedStructGen<Decimal>?, false);
            Eval(11396, o is NestedStructGen<Decimal>?[], false);
            Eval(11397, o is ExplicitFieldOffsetStruct, false);
            Eval(11398, o is ExplicitFieldOffsetStruct[], false);
            Eval(11399, o is ExplicitFieldOffsetStruct?, false);
            Eval(11400, o is ExplicitFieldOffsetStruct?[], false);
            Eval(11409, o is MarshalAsStruct, false);
            Eval(11410, o is MarshalAsStruct[], false);
            Eval(11411, o is MarshalAsStruct?, false);
            Eval(11412, o is MarshalAsStruct?[], false);
            Eval(11413, o is ImplementOneInterface, false);
            Eval(11414, o is ImplementOneInterface[], false);
            Eval(11415, o is ImplementOneInterface?, false);
            Eval(11416, o is ImplementOneInterface?[], false);
            Eval(11417, o is ImplementTwoInterface, false);
            Eval(11418, o is ImplementTwoInterface[], false);
            Eval(11419, o is ImplementTwoInterface?, false);
            Eval(11420, o is ImplementTwoInterface?[], false);
            Eval(11421, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(11422, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(11423, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(11424, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(11425, o is ImplementTwoInterfaceGen<int>, false);
            Eval(11426, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(11427, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(11428, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(11429, o is ImplementAllInterface<int>, false);
            Eval(11430, o is ImplementAllInterface<int>[], false);
            Eval(11431, o is ImplementAllInterface<int>?, false);
            Eval(11432, o is ImplementAllInterface<int>?[], false);
            Eval(11433, o is IntE, false);
            Eval(11434, o is IntE[], false);
            Eval(11435, o is IntE?, false);
            Eval(11436, o is IntE?[], false);
            Eval(11437, o is ByteE, false);
            Eval(11438, o is ByteE[], false);
            Eval(11439, o is ByteE?, false);
            Eval(11440, o is ByteE?[], false);
            Eval(11441, o is LongE, false);
            Eval(11442, o is LongE[], false);
            Eval(11443, o is LongE?, false);
            Eval(11444, o is LongE?[], false);
            Eval(11445, o is char, true);
            Eval(11446, o is char[], false);
            Eval(11447, o is char?, true);
            Eval(11448, o is char?[], false);
            Eval(11449, o is bool, false);
            Eval(11450, o is bool[], false);
            Eval(11451, o is bool?, false);
            Eval(11452, o is bool?[], false);
            Eval(11453, o is byte, false);
            Eval(11454, o is byte[], false);
            Eval(11455, o is byte?, false);
            Eval(11456, o is byte?[], false);
            Eval(11457, o is sbyte, false);
            Eval(11458, o is sbyte[], false);
            Eval(11459, o is sbyte?, false);
            Eval(11460, o is sbyte?[], false);
            Eval(11461, o is short, false);
            Eval(11462, o is short[], false);
            Eval(11463, o is short?, false);
            Eval(11464, o is short?[], false);
            Eval(11465, o is ushort, false);
            Eval(11466, o is ushort[], false);
            Eval(11467, o is ushort?, false);
            Eval(11468, o is ushort?[], false);
            Eval(11469, o is int, false);
            Eval(11470, o is int[], false);
            Eval(11471, o is int?, false);
            Eval(11472, o is int?[], false);
            Eval(11473, o is uint, false);
            Eval(11474, o is uint[], false);
            Eval(11475, o is uint?, false);
            Eval(11476, o is uint?[], false);
            Eval(11477, o is long, false);
            Eval(11478, o is long[], false);
            Eval(11479, o is long?, false);
            Eval(11480, o is long?[], false);
            Eval(11481, o is ulong, false);
            Eval(11482, o is ulong[], false);
            Eval(11483, o is ulong?, false);
            Eval(11484, o is ulong?[], false);
            Eval(11485, o is float, false);
            Eval(11486, o is float[], false);
            Eval(11487, o is float?, false);
            Eval(11488, o is float?[], false);
            Eval(11489, o is double, false);
            Eval(11490, o is double[], false);
            Eval(11491, o is double?, false);
            Eval(11492, o is double?[], false);
            Eval(11493, o is decimal, false);
            Eval(11494, o is decimal[], false);
            Eval(11495, o is decimal?, false);
            Eval(11496, o is decimal?[], false);
            Eval(11497, o is IntPtr, false);
            Eval(11498, o is IntPtr[], false);
            Eval(11499, o is IntPtr?, false);
            Eval(11500, o is IntPtr?[], false);
            Eval(11501, o is UIntPtr, false);
            Eval(11502, o is UIntPtr[], false);
            Eval(11503, o is UIntPtr?, false);
            Eval(11504, o is UIntPtr?[], false);
            Eval(11505, o is Guid, false);
            Eval(11506, o is Guid[], false);
            Eval(11507, o is Guid?, false);
            Eval(11508, o is Guid?[], false);
            Eval(11509, o is GCHandle, false);
            Eval(11510, o is GCHandle[], false);
            Eval(11511, o is GCHandle?, false);
            Eval(11512, o is GCHandle?[], false);
            Eval(11513, o is object, true);
            Eval(11514, o is object[], false);
            Eval(11515, o is string, false);
            Eval(11516, o is string[], false);
            Eval(11517, o is ValueType, true);
            Eval(11518, o is ValueType[], false);
            Eval(11519, o is Array, false);
            Eval(11520, o is Array[], false);
            Eval(11521, o is Enum, false);
            Eval(11522, o is Enum[], false);
            Eval(11523, o is Delegate, false);
            Eval(11524, o is Delegate[], false);
            Eval(11525, o is MulticastDelegate, false);
            Eval(11526, o is MulticastDelegate[], false);
            Eval(11527, o is IEmpty, false);
            Eval(11528, o is IEmpty[], false);
            Eval(11529, o is INotEmpty, false);
            Eval(11530, o is INotEmpty[], false);
            Eval(11531, o is IEmptyGen<int>, false);
            Eval(11532, o is IEmptyGen<int>[], false);
            Eval(11533, o is INotEmptyGen<int>, false);
            Eval(11534, o is INotEmptyGen<int>[], false);
            Eval(11535, o is SimpleDelegate, false);
            Eval(11536, o is SimpleDelegate[], false);
            Eval(11537, o is GenericDelegate<int>, false);
            Eval(11538, o is GenericDelegate<int>[], false);
            Eval(11539, o is EmptyClass, false);
            Eval(11540, o is EmptyClass[], false);
            Eval(11541, o is NotEmptyClass, false);
            Eval(11542, o is NotEmptyClass[], false);
            Eval(11543, o is EmptyClassGen<int>, false);
            Eval(11544, o is EmptyClassGen<int>[], false);
            Eval(11545, o is NotEmptyClassGen<Guid>, false);
            Eval(11546, o is NotEmptyClassGen<Guid>[], false);
            Eval(11547, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(11548, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(11549, o is NestedClass, false);
            Eval(11550, o is NestedClass[], false);
            Eval(11551, o is NestedClassGen<Decimal>, false);
            Eval(11552, o is NestedClassGen<Decimal>[], false);
            Eval(11553, o is ImplementOneInterfaceC, false);
            Eval(11554, o is ImplementOneInterfaceC[], false);
            Eval(11555, o is ImplementTwoInterfaceC, false);
            Eval(11556, o is ImplementTwoInterfaceC[], false);
            Eval(11557, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(11558, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(11559, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(11560, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(11561, o is ImplementAllInterfaceC<int>, false);
            Eval(11562, o is ImplementAllInterfaceC<int>[], false);
            Eval(11563, o is SealedClass, false);
            Eval(11564, o is SealedClass[], false);
        }
        {
            char? v = default(char?);
            ValueType o = v;
            Eval(11565, o is EmptyStruct, false);
            Eval(11566, o is EmptyStruct[], false);
            Eval(11567, o is EmptyStruct?, false);
            Eval(11568, o is EmptyStruct?[], false);
            Eval(11569, o is NotEmptyStruct, false);
            Eval(11570, o is NotEmptyStruct[], false);
            Eval(11571, o is NotEmptyStruct?, false);
            Eval(11572, o is NotEmptyStruct?[], false);
            Eval(11573, o is EmptyStructGen<int>, false);
            Eval(11574, o is EmptyStructGen<int>[], false);
            Eval(11575, o is EmptyStructGen<int>?, false);
            Eval(11576, o is EmptyStructGen<int>?[], false);
            Eval(11577, o is NotEmptyStructGen<Guid>, false);
            Eval(11578, o is NotEmptyStructGen<Guid>[], false);
            Eval(11579, o is NotEmptyStructGen<Guid>?, false);
            Eval(11580, o is NotEmptyStructGen<Guid>?[], false);
            Eval(11581, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(11582, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(11583, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(11584, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(11585, o is NestedStruct, false);
            Eval(11586, o is NestedStruct[], false);
            Eval(11587, o is NestedStruct?, false);
            Eval(11588, o is NestedStruct?[], false);
            Eval(11589, o is NestedStructGen<Decimal>, false);
            Eval(11590, o is NestedStructGen<Decimal>[], false);
            Eval(11591, o is NestedStructGen<Decimal>?, false);
            Eval(11592, o is NestedStructGen<Decimal>?[], false);
            Eval(11593, o is ExplicitFieldOffsetStruct, false);
            Eval(11594, o is ExplicitFieldOffsetStruct[], false);
            Eval(11595, o is ExplicitFieldOffsetStruct?, false);
            Eval(11596, o is ExplicitFieldOffsetStruct?[], false);
            Eval(11605, o is MarshalAsStruct, false);
            Eval(11606, o is MarshalAsStruct[], false);
            Eval(11607, o is MarshalAsStruct?, false);
            Eval(11608, o is MarshalAsStruct?[], false);
            Eval(11609, o is ImplementOneInterface, false);
            Eval(11610, o is ImplementOneInterface[], false);
            Eval(11611, o is ImplementOneInterface?, false);
            Eval(11612, o is ImplementOneInterface?[], false);
            Eval(11613, o is ImplementTwoInterface, false);
            Eval(11614, o is ImplementTwoInterface[], false);
            Eval(11615, o is ImplementTwoInterface?, false);
            Eval(11616, o is ImplementTwoInterface?[], false);
            Eval(11617, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(11618, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(11619, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(11620, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(11621, o is ImplementTwoInterfaceGen<int>, false);
            Eval(11622, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(11623, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(11624, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(11625, o is ImplementAllInterface<int>, false);
            Eval(11626, o is ImplementAllInterface<int>[], false);
            Eval(11627, o is ImplementAllInterface<int>?, false);
            Eval(11628, o is ImplementAllInterface<int>?[], false);
            Eval(11629, o is IntE, false);
            Eval(11630, o is IntE[], false);
            Eval(11631, o is IntE?, false);
            Eval(11632, o is IntE?[], false);
            Eval(11633, o is ByteE, false);
            Eval(11634, o is ByteE[], false);
            Eval(11635, o is ByteE?, false);
            Eval(11636, o is ByteE?[], false);
            Eval(11637, o is LongE, false);
            Eval(11638, o is LongE[], false);
            Eval(11639, o is LongE?, false);
            Eval(11640, o is LongE?[], false);
            Eval(11641, o is char, false);
            Eval(11642, o is char[], false);
            Eval(11643, o is char?, false);
            Eval(11644, o is char?[], false);
            Eval(11645, o is bool, false);
            Eval(11646, o is bool[], false);
            Eval(11647, o is bool?, false);
            Eval(11648, o is bool?[], false);
            Eval(11649, o is byte, false);
            Eval(11650, o is byte[], false);
            Eval(11651, o is byte?, false);
            Eval(11652, o is byte?[], false);
            Eval(11653, o is sbyte, false);
            Eval(11654, o is sbyte[], false);
            Eval(11655, o is sbyte?, false);
            Eval(11656, o is sbyte?[], false);
            Eval(11657, o is short, false);
            Eval(11658, o is short[], false);
            Eval(11659, o is short?, false);
            Eval(11660, o is short?[], false);
            Eval(11661, o is ushort, false);
            Eval(11662, o is ushort[], false);
            Eval(11663, o is ushort?, false);
            Eval(11664, o is ushort?[], false);
            Eval(11665, o is int, false);
            Eval(11666, o is int[], false);
            Eval(11667, o is int?, false);
            Eval(11668, o is int?[], false);
            Eval(11669, o is uint, false);
            Eval(11670, o is uint[], false);
            Eval(11671, o is uint?, false);
            Eval(11672, o is uint?[], false);
            Eval(11673, o is long, false);
            Eval(11674, o is long[], false);
            Eval(11675, o is long?, false);
            Eval(11676, o is long?[], false);
            Eval(11677, o is ulong, false);
            Eval(11678, o is ulong[], false);
            Eval(11679, o is ulong?, false);
            Eval(11680, o is ulong?[], false);
            Eval(11681, o is float, false);
            Eval(11682, o is float[], false);
            Eval(11683, o is float?, false);
            Eval(11684, o is float?[], false);
            Eval(11685, o is double, false);
            Eval(11686, o is double[], false);
            Eval(11687, o is double?, false);
            Eval(11688, o is double?[], false);
            Eval(11689, o is decimal, false);
            Eval(11690, o is decimal[], false);
            Eval(11691, o is decimal?, false);
            Eval(11692, o is decimal?[], false);
            Eval(11693, o is IntPtr, false);
            Eval(11694, o is IntPtr[], false);
            Eval(11695, o is IntPtr?, false);
            Eval(11696, o is IntPtr?[], false);
            Eval(11697, o is UIntPtr, false);
            Eval(11698, o is UIntPtr[], false);
            Eval(11699, o is UIntPtr?, false);
            Eval(11700, o is UIntPtr?[], false);
            Eval(11701, o is Guid, false);
            Eval(11702, o is Guid[], false);
            Eval(11703, o is Guid?, false);
            Eval(11704, o is Guid?[], false);
            Eval(11705, o is GCHandle, false);
            Eval(11706, o is GCHandle[], false);
            Eval(11707, o is GCHandle?, false);
            Eval(11708, o is GCHandle?[], false);
            Eval(11709, o is object, false);
            Eval(11710, o is object[], false);
            Eval(11711, o is string, false);
            Eval(11712, o is string[], false);
            Eval(11713, o is ValueType, false);
            Eval(11714, o is ValueType[], false);
            Eval(11715, o is Array, false);
            Eval(11716, o is Array[], false);
            Eval(11717, o is Enum, false);
            Eval(11718, o is Enum[], false);
            Eval(11719, o is Delegate, false);
            Eval(11720, o is Delegate[], false);
            Eval(11721, o is MulticastDelegate, false);
            Eval(11722, o is MulticastDelegate[], false);
            Eval(11723, o is IEmpty, false);
            Eval(11724, o is IEmpty[], false);
            Eval(11725, o is INotEmpty, false);
            Eval(11726, o is INotEmpty[], false);
            Eval(11727, o is IEmptyGen<int>, false);
            Eval(11728, o is IEmptyGen<int>[], false);
            Eval(11729, o is INotEmptyGen<int>, false);
            Eval(11730, o is INotEmptyGen<int>[], false);
            Eval(11731, o is SimpleDelegate, false);
            Eval(11732, o is SimpleDelegate[], false);
            Eval(11733, o is GenericDelegate<int>, false);
            Eval(11734, o is GenericDelegate<int>[], false);
            Eval(11735, o is EmptyClass, false);
            Eval(11736, o is EmptyClass[], false);
            Eval(11737, o is NotEmptyClass, false);
            Eval(11738, o is NotEmptyClass[], false);
            Eval(11739, o is EmptyClassGen<int>, false);
            Eval(11740, o is EmptyClassGen<int>[], false);
            Eval(11741, o is NotEmptyClassGen<Guid>, false);
            Eval(11742, o is NotEmptyClassGen<Guid>[], false);
            Eval(11743, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(11744, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(11745, o is NestedClass, false);
            Eval(11746, o is NestedClass[], false);
            Eval(11747, o is NestedClassGen<Decimal>, false);
            Eval(11748, o is NestedClassGen<Decimal>[], false);
            Eval(11749, o is ImplementOneInterfaceC, false);
            Eval(11750, o is ImplementOneInterfaceC[], false);
            Eval(11751, o is ImplementTwoInterfaceC, false);
            Eval(11752, o is ImplementTwoInterfaceC[], false);
            Eval(11753, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(11754, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(11755, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(11756, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(11757, o is ImplementAllInterfaceC<int>, false);
            Eval(11758, o is ImplementAllInterfaceC<int>[], false);
            Eval(11759, o is SealedClass, false);
            Eval(11760, o is SealedClass[], false);
        }
    }  // end of test case 0020
    private static void TestCase0021()
    {
        {
            bool v = default(bool);
            ValueType o = v;
            Eval(11761, o is EmptyStruct, false);
            Eval(11762, o is EmptyStruct[], false);
            Eval(11763, o is EmptyStruct?, false);
            Eval(11764, o is EmptyStruct?[], false);
            Eval(11765, o is NotEmptyStruct, false);
            Eval(11766, o is NotEmptyStruct[], false);
            Eval(11767, o is NotEmptyStruct?, false);
            Eval(11768, o is NotEmptyStruct?[], false);
            Eval(11769, o is EmptyStructGen<int>, false);
            Eval(11770, o is EmptyStructGen<int>[], false);
            Eval(11771, o is EmptyStructGen<int>?, false);
            Eval(11772, o is EmptyStructGen<int>?[], false);
            Eval(11773, o is NotEmptyStructGen<Guid>, false);
            Eval(11774, o is NotEmptyStructGen<Guid>[], false);
            Eval(11775, o is NotEmptyStructGen<Guid>?, false);
            Eval(11776, o is NotEmptyStructGen<Guid>?[], false);
            Eval(11777, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(11778, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(11779, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(11780, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(11781, o is NestedStruct, false);
            Eval(11782, o is NestedStruct[], false);
            Eval(11783, o is NestedStruct?, false);
            Eval(11784, o is NestedStruct?[], false);
            Eval(11785, o is NestedStructGen<Decimal>, false);
            Eval(11786, o is NestedStructGen<Decimal>[], false);
            Eval(11787, o is NestedStructGen<Decimal>?, false);
            Eval(11788, o is NestedStructGen<Decimal>?[], false);
            Eval(11789, o is ExplicitFieldOffsetStruct, false);
            Eval(11790, o is ExplicitFieldOffsetStruct[], false);
            Eval(11791, o is ExplicitFieldOffsetStruct?, false);
            Eval(11792, o is ExplicitFieldOffsetStruct?[], false);
            Eval(11801, o is MarshalAsStruct, false);
            Eval(11802, o is MarshalAsStruct[], false);
            Eval(11803, o is MarshalAsStruct?, false);
            Eval(11804, o is MarshalAsStruct?[], false);
            Eval(11805, o is ImplementOneInterface, false);
            Eval(11806, o is ImplementOneInterface[], false);
            Eval(11807, o is ImplementOneInterface?, false);
            Eval(11808, o is ImplementOneInterface?[], false);
            Eval(11809, o is ImplementTwoInterface, false);
            Eval(11810, o is ImplementTwoInterface[], false);
            Eval(11811, o is ImplementTwoInterface?, false);
            Eval(11812, o is ImplementTwoInterface?[], false);
            Eval(11813, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(11814, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(11815, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(11816, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(11817, o is ImplementTwoInterfaceGen<int>, false);
            Eval(11818, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(11819, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(11820, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(11821, o is ImplementAllInterface<int>, false);
            Eval(11822, o is ImplementAllInterface<int>[], false);
            Eval(11823, o is ImplementAllInterface<int>?, false);
            Eval(11824, o is ImplementAllInterface<int>?[], false);
            Eval(11825, o is IntE, false);
            Eval(11826, o is IntE[], false);
            Eval(11827, o is IntE?, false);
            Eval(11828, o is IntE?[], false);
            Eval(11829, o is ByteE, false);
            Eval(11830, o is ByteE[], false);
            Eval(11831, o is ByteE?, false);
            Eval(11832, o is ByteE?[], false);
            Eval(11833, o is LongE, false);
            Eval(11834, o is LongE[], false);
            Eval(11835, o is LongE?, false);
            Eval(11836, o is LongE?[], false);
            Eval(11837, o is char, false);
            Eval(11838, o is char[], false);
            Eval(11839, o is char?, false);
            Eval(11840, o is char?[], false);
            Eval(11841, o is bool, true);
            Eval(11842, o is bool[], false);
            Eval(11843, o is bool?, true);
            Eval(11844, o is bool?[], false);
            Eval(11845, o is byte, false);
            Eval(11846, o is byte[], false);
            Eval(11847, o is byte?, false);
            Eval(11848, o is byte?[], false);
            Eval(11849, o is sbyte, false);
            Eval(11850, o is sbyte[], false);
            Eval(11851, o is sbyte?, false);
            Eval(11852, o is sbyte?[], false);
            Eval(11853, o is short, false);
            Eval(11854, o is short[], false);
            Eval(11855, o is short?, false);
            Eval(11856, o is short?[], false);
            Eval(11857, o is ushort, false);
            Eval(11858, o is ushort[], false);
            Eval(11859, o is ushort?, false);
            Eval(11860, o is ushort?[], false);
            Eval(11861, o is int, false);
            Eval(11862, o is int[], false);
            Eval(11863, o is int?, false);
            Eval(11864, o is int?[], false);
            Eval(11865, o is uint, false);
            Eval(11866, o is uint[], false);
            Eval(11867, o is uint?, false);
            Eval(11868, o is uint?[], false);
            Eval(11869, o is long, false);
            Eval(11870, o is long[], false);
            Eval(11871, o is long?, false);
            Eval(11872, o is long?[], false);
            Eval(11873, o is ulong, false);
            Eval(11874, o is ulong[], false);
            Eval(11875, o is ulong?, false);
            Eval(11876, o is ulong?[], false);
            Eval(11877, o is float, false);
            Eval(11878, o is float[], false);
            Eval(11879, o is float?, false);
            Eval(11880, o is float?[], false);
            Eval(11881, o is double, false);
            Eval(11882, o is double[], false);
            Eval(11883, o is double?, false);
            Eval(11884, o is double?[], false);
            Eval(11885, o is decimal, false);
            Eval(11886, o is decimal[], false);
            Eval(11887, o is decimal?, false);
            Eval(11888, o is decimal?[], false);
            Eval(11889, o is IntPtr, false);
            Eval(11890, o is IntPtr[], false);
            Eval(11891, o is IntPtr?, false);
            Eval(11892, o is IntPtr?[], false);
            Eval(11893, o is UIntPtr, false);
            Eval(11894, o is UIntPtr[], false);
            Eval(11895, o is UIntPtr?, false);
            Eval(11896, o is UIntPtr?[], false);
            Eval(11897, o is Guid, false);
            Eval(11898, o is Guid[], false);
            Eval(11899, o is Guid?, false);
            Eval(11900, o is Guid?[], false);
            Eval(11901, o is GCHandle, false);
            Eval(11902, o is GCHandle[], false);
            Eval(11903, o is GCHandle?, false);
            Eval(11904, o is GCHandle?[], false);
            Eval(11905, o is object, true);
            Eval(11906, o is object[], false);
            Eval(11907, o is string, false);
            Eval(11908, o is string[], false);
            Eval(11909, o is ValueType, true);
            Eval(11910, o is ValueType[], false);
            Eval(11911, o is Array, false);
            Eval(11912, o is Array[], false);
            Eval(11913, o is Enum, false);
            Eval(11914, o is Enum[], false);
            Eval(11915, o is Delegate, false);
            Eval(11916, o is Delegate[], false);
            Eval(11917, o is MulticastDelegate, false);
            Eval(11918, o is MulticastDelegate[], false);
            Eval(11919, o is IEmpty, false);
            Eval(11920, o is IEmpty[], false);
            Eval(11921, o is INotEmpty, false);
            Eval(11922, o is INotEmpty[], false);
            Eval(11923, o is IEmptyGen<int>, false);
            Eval(11924, o is IEmptyGen<int>[], false);
            Eval(11925, o is INotEmptyGen<int>, false);
            Eval(11926, o is INotEmptyGen<int>[], false);
            Eval(11927, o is SimpleDelegate, false);
            Eval(11928, o is SimpleDelegate[], false);
            Eval(11929, o is GenericDelegate<int>, false);
            Eval(11930, o is GenericDelegate<int>[], false);
            Eval(11931, o is EmptyClass, false);
            Eval(11932, o is EmptyClass[], false);
            Eval(11933, o is NotEmptyClass, false);
            Eval(11934, o is NotEmptyClass[], false);
            Eval(11935, o is EmptyClassGen<int>, false);
            Eval(11936, o is EmptyClassGen<int>[], false);
            Eval(11937, o is NotEmptyClassGen<Guid>, false);
            Eval(11938, o is NotEmptyClassGen<Guid>[], false);
            Eval(11939, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(11940, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(11941, o is NestedClass, false);
            Eval(11942, o is NestedClass[], false);
            Eval(11943, o is NestedClassGen<Decimal>, false);
            Eval(11944, o is NestedClassGen<Decimal>[], false);
            Eval(11945, o is ImplementOneInterfaceC, false);
            Eval(11946, o is ImplementOneInterfaceC[], false);
            Eval(11947, o is ImplementTwoInterfaceC, false);
            Eval(11948, o is ImplementTwoInterfaceC[], false);
            Eval(11949, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(11950, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(11951, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(11952, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(11953, o is ImplementAllInterfaceC<int>, false);
            Eval(11954, o is ImplementAllInterfaceC<int>[], false);
            Eval(11955, o is SealedClass, false);
            Eval(11956, o is SealedClass[], false);
        }
        {
            bool? v = default(bool);
            ValueType o = v;
            Eval(11957, o is EmptyStruct, false);
            Eval(11958, o is EmptyStruct[], false);
            Eval(11959, o is EmptyStruct?, false);
            Eval(11960, o is EmptyStruct?[], false);
            Eval(11961, o is NotEmptyStruct, false);
            Eval(11962, o is NotEmptyStruct[], false);
            Eval(11963, o is NotEmptyStruct?, false);
            Eval(11964, o is NotEmptyStruct?[], false);
            Eval(11965, o is EmptyStructGen<int>, false);
            Eval(11966, o is EmptyStructGen<int>[], false);
            Eval(11967, o is EmptyStructGen<int>?, false);
            Eval(11968, o is EmptyStructGen<int>?[], false);
            Eval(11969, o is NotEmptyStructGen<Guid>, false);
            Eval(11970, o is NotEmptyStructGen<Guid>[], false);
            Eval(11971, o is NotEmptyStructGen<Guid>?, false);
            Eval(11972, o is NotEmptyStructGen<Guid>?[], false);
            Eval(11973, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(11974, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(11975, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(11976, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(11977, o is NestedStruct, false);
            Eval(11978, o is NestedStruct[], false);
            Eval(11979, o is NestedStruct?, false);
            Eval(11980, o is NestedStruct?[], false);
            Eval(11981, o is NestedStructGen<Decimal>, false);
            Eval(11982, o is NestedStructGen<Decimal>[], false);
            Eval(11983, o is NestedStructGen<Decimal>?, false);
            Eval(11984, o is NestedStructGen<Decimal>?[], false);
            Eval(11985, o is ExplicitFieldOffsetStruct, false);
            Eval(11986, o is ExplicitFieldOffsetStruct[], false);
            Eval(11987, o is ExplicitFieldOffsetStruct?, false);
            Eval(11988, o is ExplicitFieldOffsetStruct?[], false);
            Eval(11997, o is MarshalAsStruct, false);
            Eval(11998, o is MarshalAsStruct[], false);
            Eval(11999, o is MarshalAsStruct?, false);
            Eval(12000, o is MarshalAsStruct?[], false);
            Eval(12001, o is ImplementOneInterface, false);
            Eval(12002, o is ImplementOneInterface[], false);
            Eval(12003, o is ImplementOneInterface?, false);
            Eval(12004, o is ImplementOneInterface?[], false);
            Eval(12005, o is ImplementTwoInterface, false);
            Eval(12006, o is ImplementTwoInterface[], false);
            Eval(12007, o is ImplementTwoInterface?, false);
            Eval(12008, o is ImplementTwoInterface?[], false);
            Eval(12009, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(12010, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(12011, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(12012, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(12013, o is ImplementTwoInterfaceGen<int>, false);
            Eval(12014, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(12015, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(12016, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(12017, o is ImplementAllInterface<int>, false);
            Eval(12018, o is ImplementAllInterface<int>[], false);
            Eval(12019, o is ImplementAllInterface<int>?, false);
            Eval(12020, o is ImplementAllInterface<int>?[], false);
            Eval(12021, o is IntE, false);
            Eval(12022, o is IntE[], false);
            Eval(12023, o is IntE?, false);
            Eval(12024, o is IntE?[], false);
            Eval(12025, o is ByteE, false);
            Eval(12026, o is ByteE[], false);
            Eval(12027, o is ByteE?, false);
            Eval(12028, o is ByteE?[], false);
            Eval(12029, o is LongE, false);
            Eval(12030, o is LongE[], false);
            Eval(12031, o is LongE?, false);
            Eval(12032, o is LongE?[], false);
            Eval(12033, o is char, false);
            Eval(12034, o is char[], false);
            Eval(12035, o is char?, false);
            Eval(12036, o is char?[], false);
            Eval(12037, o is bool, true);
            Eval(12038, o is bool[], false);
            Eval(12039, o is bool?, true);
            Eval(12040, o is bool?[], false);
            Eval(12041, o is byte, false);
            Eval(12042, o is byte[], false);
            Eval(12043, o is byte?, false);
            Eval(12044, o is byte?[], false);
            Eval(12045, o is sbyte, false);
            Eval(12046, o is sbyte[], false);
            Eval(12047, o is sbyte?, false);
            Eval(12048, o is sbyte?[], false);
            Eval(12049, o is short, false);
            Eval(12050, o is short[], false);
            Eval(12051, o is short?, false);
            Eval(12052, o is short?[], false);
            Eval(12053, o is ushort, false);
            Eval(12054, o is ushort[], false);
            Eval(12055, o is ushort?, false);
            Eval(12056, o is ushort?[], false);
            Eval(12057, o is int, false);
            Eval(12058, o is int[], false);
            Eval(12059, o is int?, false);
            Eval(12060, o is int?[], false);
            Eval(12061, o is uint, false);
            Eval(12062, o is uint[], false);
            Eval(12063, o is uint?, false);
            Eval(12064, o is uint?[], false);
            Eval(12065, o is long, false);
            Eval(12066, o is long[], false);
            Eval(12067, o is long?, false);
            Eval(12068, o is long?[], false);
            Eval(12069, o is ulong, false);
            Eval(12070, o is ulong[], false);
            Eval(12071, o is ulong?, false);
            Eval(12072, o is ulong?[], false);
            Eval(12073, o is float, false);
            Eval(12074, o is float[], false);
            Eval(12075, o is float?, false);
            Eval(12076, o is float?[], false);
            Eval(12077, o is double, false);
            Eval(12078, o is double[], false);
            Eval(12079, o is double?, false);
            Eval(12080, o is double?[], false);
            Eval(12081, o is decimal, false);
            Eval(12082, o is decimal[], false);
            Eval(12083, o is decimal?, false);
            Eval(12084, o is decimal?[], false);
            Eval(12085, o is IntPtr, false);
            Eval(12086, o is IntPtr[], false);
            Eval(12087, o is IntPtr?, false);
            Eval(12088, o is IntPtr?[], false);
            Eval(12089, o is UIntPtr, false);
            Eval(12090, o is UIntPtr[], false);
            Eval(12091, o is UIntPtr?, false);
            Eval(12092, o is UIntPtr?[], false);
            Eval(12093, o is Guid, false);
            Eval(12094, o is Guid[], false);
            Eval(12095, o is Guid?, false);
            Eval(12096, o is Guid?[], false);
            Eval(12097, o is GCHandle, false);
            Eval(12098, o is GCHandle[], false);
            Eval(12099, o is GCHandle?, false);
            Eval(12100, o is GCHandle?[], false);
            Eval(12101, o is object, true);
            Eval(12102, o is object[], false);
            Eval(12103, o is string, false);
            Eval(12104, o is string[], false);
            Eval(12105, o is ValueType, true);
            Eval(12106, o is ValueType[], false);
            Eval(12107, o is Array, false);
            Eval(12108, o is Array[], false);
            Eval(12109, o is Enum, false);
            Eval(12110, o is Enum[], false);
            Eval(12111, o is Delegate, false);
            Eval(12112, o is Delegate[], false);
            Eval(12113, o is MulticastDelegate, false);
            Eval(12114, o is MulticastDelegate[], false);
            Eval(12115, o is IEmpty, false);
            Eval(12116, o is IEmpty[], false);
            Eval(12117, o is INotEmpty, false);
            Eval(12118, o is INotEmpty[], false);
            Eval(12119, o is IEmptyGen<int>, false);
            Eval(12120, o is IEmptyGen<int>[], false);
            Eval(12121, o is INotEmptyGen<int>, false);
            Eval(12122, o is INotEmptyGen<int>[], false);
            Eval(12123, o is SimpleDelegate, false);
            Eval(12124, o is SimpleDelegate[], false);
            Eval(12125, o is GenericDelegate<int>, false);
            Eval(12126, o is GenericDelegate<int>[], false);
            Eval(12127, o is EmptyClass, false);
            Eval(12128, o is EmptyClass[], false);
            Eval(12129, o is NotEmptyClass, false);
            Eval(12130, o is NotEmptyClass[], false);
            Eval(12131, o is EmptyClassGen<int>, false);
            Eval(12132, o is EmptyClassGen<int>[], false);
            Eval(12133, o is NotEmptyClassGen<Guid>, false);
            Eval(12134, o is NotEmptyClassGen<Guid>[], false);
            Eval(12135, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(12136, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(12137, o is NestedClass, false);
            Eval(12138, o is NestedClass[], false);
            Eval(12139, o is NestedClassGen<Decimal>, false);
            Eval(12140, o is NestedClassGen<Decimal>[], false);
            Eval(12141, o is ImplementOneInterfaceC, false);
            Eval(12142, o is ImplementOneInterfaceC[], false);
            Eval(12143, o is ImplementTwoInterfaceC, false);
            Eval(12144, o is ImplementTwoInterfaceC[], false);
            Eval(12145, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(12146, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(12147, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(12148, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(12149, o is ImplementAllInterfaceC<int>, false);
            Eval(12150, o is ImplementAllInterfaceC<int>[], false);
            Eval(12151, o is SealedClass, false);
            Eval(12152, o is SealedClass[], false);
        }
        {
            bool? v = default(bool?);
            ValueType o = v;
            Eval(12153, o is EmptyStruct, false);
            Eval(12154, o is EmptyStruct[], false);
            Eval(12155, o is EmptyStruct?, false);
            Eval(12156, o is EmptyStruct?[], false);
            Eval(12157, o is NotEmptyStruct, false);
            Eval(12158, o is NotEmptyStruct[], false);
            Eval(12159, o is NotEmptyStruct?, false);
            Eval(12160, o is NotEmptyStruct?[], false);
            Eval(12161, o is EmptyStructGen<int>, false);
            Eval(12162, o is EmptyStructGen<int>[], false);
            Eval(12163, o is EmptyStructGen<int>?, false);
            Eval(12164, o is EmptyStructGen<int>?[], false);
            Eval(12165, o is NotEmptyStructGen<Guid>, false);
            Eval(12166, o is NotEmptyStructGen<Guid>[], false);
            Eval(12167, o is NotEmptyStructGen<Guid>?, false);
            Eval(12168, o is NotEmptyStructGen<Guid>?[], false);
            Eval(12169, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(12170, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(12171, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(12172, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(12173, o is NestedStruct, false);
            Eval(12174, o is NestedStruct[], false);
            Eval(12175, o is NestedStruct?, false);
            Eval(12176, o is NestedStruct?[], false);
            Eval(12177, o is NestedStructGen<Decimal>, false);
            Eval(12178, o is NestedStructGen<Decimal>[], false);
            Eval(12179, o is NestedStructGen<Decimal>?, false);
            Eval(12180, o is NestedStructGen<Decimal>?[], false);
            Eval(12181, o is ExplicitFieldOffsetStruct, false);
            Eval(12182, o is ExplicitFieldOffsetStruct[], false);
            Eval(12183, o is ExplicitFieldOffsetStruct?, false);
            Eval(12184, o is ExplicitFieldOffsetStruct?[], false);
            Eval(12193, o is MarshalAsStruct, false);
            Eval(12194, o is MarshalAsStruct[], false);
            Eval(12195, o is MarshalAsStruct?, false);
            Eval(12196, o is MarshalAsStruct?[], false);
            Eval(12197, o is ImplementOneInterface, false);
            Eval(12198, o is ImplementOneInterface[], false);
            Eval(12199, o is ImplementOneInterface?, false);
            Eval(12200, o is ImplementOneInterface?[], false);
            Eval(12201, o is ImplementTwoInterface, false);
            Eval(12202, o is ImplementTwoInterface[], false);
            Eval(12203, o is ImplementTwoInterface?, false);
            Eval(12204, o is ImplementTwoInterface?[], false);
            Eval(12205, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(12206, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(12207, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(12208, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(12209, o is ImplementTwoInterfaceGen<int>, false);
            Eval(12210, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(12211, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(12212, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(12213, o is ImplementAllInterface<int>, false);
            Eval(12214, o is ImplementAllInterface<int>[], false);
            Eval(12215, o is ImplementAllInterface<int>?, false);
            Eval(12216, o is ImplementAllInterface<int>?[], false);
            Eval(12217, o is IntE, false);
            Eval(12218, o is IntE[], false);
            Eval(12219, o is IntE?, false);
            Eval(12220, o is IntE?[], false);
            Eval(12221, o is ByteE, false);
            Eval(12222, o is ByteE[], false);
            Eval(12223, o is ByteE?, false);
            Eval(12224, o is ByteE?[], false);
            Eval(12225, o is LongE, false);
            Eval(12226, o is LongE[], false);
            Eval(12227, o is LongE?, false);
            Eval(12228, o is LongE?[], false);
            Eval(12229, o is char, false);
            Eval(12230, o is char[], false);
            Eval(12231, o is char?, false);
            Eval(12232, o is char?[], false);
            Eval(12233, o is bool, false);
            Eval(12234, o is bool[], false);
            Eval(12235, o is bool?, false);
            Eval(12236, o is bool?[], false);
            Eval(12237, o is byte, false);
            Eval(12238, o is byte[], false);
            Eval(12239, o is byte?, false);
            Eval(12240, o is byte?[], false);
            Eval(12241, o is sbyte, false);
            Eval(12242, o is sbyte[], false);
            Eval(12243, o is sbyte?, false);
            Eval(12244, o is sbyte?[], false);
            Eval(12245, o is short, false);
            Eval(12246, o is short[], false);
            Eval(12247, o is short?, false);
            Eval(12248, o is short?[], false);
            Eval(12249, o is ushort, false);
            Eval(12250, o is ushort[], false);
            Eval(12251, o is ushort?, false);
            Eval(12252, o is ushort?[], false);
            Eval(12253, o is int, false);
            Eval(12254, o is int[], false);
            Eval(12255, o is int?, false);
            Eval(12256, o is int?[], false);
            Eval(12257, o is uint, false);
            Eval(12258, o is uint[], false);
            Eval(12259, o is uint?, false);
            Eval(12260, o is uint?[], false);
            Eval(12261, o is long, false);
            Eval(12262, o is long[], false);
            Eval(12263, o is long?, false);
            Eval(12264, o is long?[], false);
            Eval(12265, o is ulong, false);
            Eval(12266, o is ulong[], false);
            Eval(12267, o is ulong?, false);
            Eval(12268, o is ulong?[], false);
            Eval(12269, o is float, false);
            Eval(12270, o is float[], false);
            Eval(12271, o is float?, false);
            Eval(12272, o is float?[], false);
            Eval(12273, o is double, false);
            Eval(12274, o is double[], false);
            Eval(12275, o is double?, false);
            Eval(12276, o is double?[], false);
            Eval(12277, o is decimal, false);
            Eval(12278, o is decimal[], false);
            Eval(12279, o is decimal?, false);
            Eval(12280, o is decimal?[], false);
            Eval(12281, o is IntPtr, false);
            Eval(12282, o is IntPtr[], false);
            Eval(12283, o is IntPtr?, false);
            Eval(12284, o is IntPtr?[], false);
            Eval(12285, o is UIntPtr, false);
            Eval(12286, o is UIntPtr[], false);
            Eval(12287, o is UIntPtr?, false);
            Eval(12288, o is UIntPtr?[], false);
            Eval(12289, o is Guid, false);
            Eval(12290, o is Guid[], false);
            Eval(12291, o is Guid?, false);
            Eval(12292, o is Guid?[], false);
            Eval(12293, o is GCHandle, false);
            Eval(12294, o is GCHandle[], false);
            Eval(12295, o is GCHandle?, false);
            Eval(12296, o is GCHandle?[], false);
            Eval(12297, o is object, false);
            Eval(12298, o is object[], false);
            Eval(12299, o is string, false);
            Eval(12300, o is string[], false);
            Eval(12301, o is ValueType, false);
            Eval(12302, o is ValueType[], false);
            Eval(12303, o is Array, false);
            Eval(12304, o is Array[], false);
            Eval(12305, o is Enum, false);
            Eval(12306, o is Enum[], false);
            Eval(12307, o is Delegate, false);
            Eval(12308, o is Delegate[], false);
            Eval(12309, o is MulticastDelegate, false);
            Eval(12310, o is MulticastDelegate[], false);
            Eval(12311, o is IEmpty, false);
            Eval(12312, o is IEmpty[], false);
            Eval(12313, o is INotEmpty, false);
            Eval(12314, o is INotEmpty[], false);
            Eval(12315, o is IEmptyGen<int>, false);
            Eval(12316, o is IEmptyGen<int>[], false);
            Eval(12317, o is INotEmptyGen<int>, false);
            Eval(12318, o is INotEmptyGen<int>[], false);
            Eval(12319, o is SimpleDelegate, false);
            Eval(12320, o is SimpleDelegate[], false);
            Eval(12321, o is GenericDelegate<int>, false);
            Eval(12322, o is GenericDelegate<int>[], false);
            Eval(12323, o is EmptyClass, false);
            Eval(12324, o is EmptyClass[], false);
            Eval(12325, o is NotEmptyClass, false);
            Eval(12326, o is NotEmptyClass[], false);
            Eval(12327, o is EmptyClassGen<int>, false);
            Eval(12328, o is EmptyClassGen<int>[], false);
            Eval(12329, o is NotEmptyClassGen<Guid>, false);
            Eval(12330, o is NotEmptyClassGen<Guid>[], false);
            Eval(12331, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(12332, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(12333, o is NestedClass, false);
            Eval(12334, o is NestedClass[], false);
            Eval(12335, o is NestedClassGen<Decimal>, false);
            Eval(12336, o is NestedClassGen<Decimal>[], false);
            Eval(12337, o is ImplementOneInterfaceC, false);
            Eval(12338, o is ImplementOneInterfaceC[], false);
            Eval(12339, o is ImplementTwoInterfaceC, false);
            Eval(12340, o is ImplementTwoInterfaceC[], false);
            Eval(12341, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(12342, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(12343, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(12344, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(12345, o is ImplementAllInterfaceC<int>, false);
            Eval(12346, o is ImplementAllInterfaceC<int>[], false);
            Eval(12347, o is SealedClass, false);
            Eval(12348, o is SealedClass[], false);
        }
    }  // end of test case 0021
    private static void TestCase0022()
    {
        {
            byte v = default(byte);
            ValueType o = v;
            Eval(12349, o is EmptyStruct, false);
            Eval(12350, o is EmptyStruct[], false);
            Eval(12351, o is EmptyStruct?, false);
            Eval(12352, o is EmptyStruct?[], false);
            Eval(12353, o is NotEmptyStruct, false);
            Eval(12354, o is NotEmptyStruct[], false);
            Eval(12355, o is NotEmptyStruct?, false);
            Eval(12356, o is NotEmptyStruct?[], false);
            Eval(12357, o is EmptyStructGen<int>, false);
            Eval(12358, o is EmptyStructGen<int>[], false);
            Eval(12359, o is EmptyStructGen<int>?, false);
            Eval(12360, o is EmptyStructGen<int>?[], false);
            Eval(12361, o is NotEmptyStructGen<Guid>, false);
            Eval(12362, o is NotEmptyStructGen<Guid>[], false);
            Eval(12363, o is NotEmptyStructGen<Guid>?, false);
            Eval(12364, o is NotEmptyStructGen<Guid>?[], false);
            Eval(12365, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(12366, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(12367, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(12368, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(12369, o is NestedStruct, false);
            Eval(12370, o is NestedStruct[], false);
            Eval(12371, o is NestedStruct?, false);
            Eval(12372, o is NestedStruct?[], false);
            Eval(12373, o is NestedStructGen<Decimal>, false);
            Eval(12374, o is NestedStructGen<Decimal>[], false);
            Eval(12375, o is NestedStructGen<Decimal>?, false);
            Eval(12376, o is NestedStructGen<Decimal>?[], false);
            Eval(12377, o is ExplicitFieldOffsetStruct, false);
            Eval(12378, o is ExplicitFieldOffsetStruct[], false);
            Eval(12379, o is ExplicitFieldOffsetStruct?, false);
            Eval(12380, o is ExplicitFieldOffsetStruct?[], false);
            Eval(12389, o is MarshalAsStruct, false);
            Eval(12390, o is MarshalAsStruct[], false);
            Eval(12391, o is MarshalAsStruct?, false);
            Eval(12392, o is MarshalAsStruct?[], false);
            Eval(12393, o is ImplementOneInterface, false);
            Eval(12394, o is ImplementOneInterface[], false);
            Eval(12395, o is ImplementOneInterface?, false);
            Eval(12396, o is ImplementOneInterface?[], false);
            Eval(12397, o is ImplementTwoInterface, false);
            Eval(12398, o is ImplementTwoInterface[], false);
            Eval(12399, o is ImplementTwoInterface?, false);
            Eval(12400, o is ImplementTwoInterface?[], false);
            Eval(12401, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(12402, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(12403, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(12404, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(12405, o is ImplementTwoInterfaceGen<int>, false);
            Eval(12406, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(12407, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(12408, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(12409, o is ImplementAllInterface<int>, false);
            Eval(12410, o is ImplementAllInterface<int>[], false);
            Eval(12411, o is ImplementAllInterface<int>?, false);
            Eval(12412, o is ImplementAllInterface<int>?[], false);
            Eval(12413, o is IntE, false);
            Eval(12414, o is IntE[], false);
            Eval(12415, o is IntE?, false);
            Eval(12416, o is IntE?[], false);
            Eval(12417, o is ByteE, false);
            Eval(12418, o is ByteE[], false);
            Eval(12419, o is ByteE?, false);
            Eval(12420, o is ByteE?[], false);
            Eval(12421, o is LongE, false);
            Eval(12422, o is LongE[], false);
            Eval(12423, o is LongE?, false);
            Eval(12424, o is LongE?[], false);
            Eval(12425, o is char, false);
            Eval(12426, o is char[], false);
            Eval(12427, o is char?, false);
            Eval(12428, o is char?[], false);
            Eval(12429, o is bool, false);
            Eval(12430, o is bool[], false);
            Eval(12431, o is bool?, false);
            Eval(12432, o is bool?[], false);
            Eval(12433, o is byte, true);
            Eval(12434, o is byte[], false);
            Eval(12435, o is byte?, true);
            Eval(12436, o is byte?[], false);
            Eval(12437, o is sbyte, false);
            Eval(12438, o is sbyte[], false);
            Eval(12439, o is sbyte?, false);
            Eval(12440, o is sbyte?[], false);
            Eval(12441, o is short, false);
            Eval(12442, o is short[], false);
            Eval(12443, o is short?, false);
            Eval(12444, o is short?[], false);
            Eval(12445, o is ushort, false);
            Eval(12446, o is ushort[], false);
            Eval(12447, o is ushort?, false);
            Eval(12448, o is ushort?[], false);
            Eval(12449, o is int, false);
            Eval(12450, o is int[], false);
            Eval(12451, o is int?, false);
            Eval(12452, o is int?[], false);
            Eval(12453, o is uint, false);
            Eval(12454, o is uint[], false);
            Eval(12455, o is uint?, false);
            Eval(12456, o is uint?[], false);
            Eval(12457, o is long, false);
            Eval(12458, o is long[], false);
            Eval(12459, o is long?, false);
            Eval(12460, o is long?[], false);
            Eval(12461, o is ulong, false);
            Eval(12462, o is ulong[], false);
            Eval(12463, o is ulong?, false);
            Eval(12464, o is ulong?[], false);
            Eval(12465, o is float, false);
            Eval(12466, o is float[], false);
            Eval(12467, o is float?, false);
            Eval(12468, o is float?[], false);
            Eval(12469, o is double, false);
            Eval(12470, o is double[], false);
            Eval(12471, o is double?, false);
            Eval(12472, o is double?[], false);
            Eval(12473, o is decimal, false);
            Eval(12474, o is decimal[], false);
            Eval(12475, o is decimal?, false);
            Eval(12476, o is decimal?[], false);
            Eval(12477, o is IntPtr, false);
            Eval(12478, o is IntPtr[], false);
            Eval(12479, o is IntPtr?, false);
            Eval(12480, o is IntPtr?[], false);
            Eval(12481, o is UIntPtr, false);
            Eval(12482, o is UIntPtr[], false);
            Eval(12483, o is UIntPtr?, false);
            Eval(12484, o is UIntPtr?[], false);
            Eval(12485, o is Guid, false);
            Eval(12486, o is Guid[], false);
            Eval(12487, o is Guid?, false);
            Eval(12488, o is Guid?[], false);
            Eval(12489, o is GCHandle, false);
            Eval(12490, o is GCHandle[], false);
            Eval(12491, o is GCHandle?, false);
            Eval(12492, o is GCHandle?[], false);
            Eval(12493, o is object, true);
            Eval(12494, o is object[], false);
            Eval(12495, o is string, false);
            Eval(12496, o is string[], false);
            Eval(12497, o is ValueType, true);
            Eval(12498, o is ValueType[], false);
            Eval(12499, o is Array, false);
            Eval(12500, o is Array[], false);
            Eval(12501, o is Enum, false);
            Eval(12502, o is Enum[], false);
            Eval(12503, o is Delegate, false);
            Eval(12504, o is Delegate[], false);
            Eval(12505, o is MulticastDelegate, false);
            Eval(12506, o is MulticastDelegate[], false);
            Eval(12507, o is IEmpty, false);
            Eval(12508, o is IEmpty[], false);
            Eval(12509, o is INotEmpty, false);
            Eval(12510, o is INotEmpty[], false);
            Eval(12511, o is IEmptyGen<int>, false);
            Eval(12512, o is IEmptyGen<int>[], false);
            Eval(12513, o is INotEmptyGen<int>, false);
            Eval(12514, o is INotEmptyGen<int>[], false);
            Eval(12515, o is SimpleDelegate, false);
            Eval(12516, o is SimpleDelegate[], false);
            Eval(12517, o is GenericDelegate<int>, false);
            Eval(12518, o is GenericDelegate<int>[], false);
            Eval(12519, o is EmptyClass, false);
            Eval(12520, o is EmptyClass[], false);
            Eval(12521, o is NotEmptyClass, false);
            Eval(12522, o is NotEmptyClass[], false);
            Eval(12523, o is EmptyClassGen<int>, false);
            Eval(12524, o is EmptyClassGen<int>[], false);
            Eval(12525, o is NotEmptyClassGen<Guid>, false);
            Eval(12526, o is NotEmptyClassGen<Guid>[], false);
            Eval(12527, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(12528, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(12529, o is NestedClass, false);
            Eval(12530, o is NestedClass[], false);
            Eval(12531, o is NestedClassGen<Decimal>, false);
            Eval(12532, o is NestedClassGen<Decimal>[], false);
            Eval(12533, o is ImplementOneInterfaceC, false);
            Eval(12534, o is ImplementOneInterfaceC[], false);
            Eval(12535, o is ImplementTwoInterfaceC, false);
            Eval(12536, o is ImplementTwoInterfaceC[], false);
            Eval(12537, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(12538, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(12539, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(12540, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(12541, o is ImplementAllInterfaceC<int>, false);
            Eval(12542, o is ImplementAllInterfaceC<int>[], false);
            Eval(12543, o is SealedClass, false);
            Eval(12544, o is SealedClass[], false);
        }
        {
            byte? v = default(byte);
            ValueType o = v;
            Eval(12545, o is EmptyStruct, false);
            Eval(12546, o is EmptyStruct[], false);
            Eval(12547, o is EmptyStruct?, false);
            Eval(12548, o is EmptyStruct?[], false);
            Eval(12549, o is NotEmptyStruct, false);
            Eval(12550, o is NotEmptyStruct[], false);
            Eval(12551, o is NotEmptyStruct?, false);
            Eval(12552, o is NotEmptyStruct?[], false);
            Eval(12553, o is EmptyStructGen<int>, false);
            Eval(12554, o is EmptyStructGen<int>[], false);
            Eval(12555, o is EmptyStructGen<int>?, false);
            Eval(12556, o is EmptyStructGen<int>?[], false);
            Eval(12557, o is NotEmptyStructGen<Guid>, false);
            Eval(12558, o is NotEmptyStructGen<Guid>[], false);
            Eval(12559, o is NotEmptyStructGen<Guid>?, false);
            Eval(12560, o is NotEmptyStructGen<Guid>?[], false);
            Eval(12561, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(12562, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(12563, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(12564, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(12565, o is NestedStruct, false);
            Eval(12566, o is NestedStruct[], false);
            Eval(12567, o is NestedStruct?, false);
            Eval(12568, o is NestedStruct?[], false);
            Eval(12569, o is NestedStructGen<Decimal>, false);
            Eval(12570, o is NestedStructGen<Decimal>[], false);
            Eval(12571, o is NestedStructGen<Decimal>?, false);
            Eval(12572, o is NestedStructGen<Decimal>?[], false);
            Eval(12573, o is ExplicitFieldOffsetStruct, false);
            Eval(12574, o is ExplicitFieldOffsetStruct[], false);
            Eval(12575, o is ExplicitFieldOffsetStruct?, false);
            Eval(12576, o is ExplicitFieldOffsetStruct?[], false);
            Eval(12585, o is MarshalAsStruct, false);
            Eval(12586, o is MarshalAsStruct[], false);
            Eval(12587, o is MarshalAsStruct?, false);
            Eval(12588, o is MarshalAsStruct?[], false);
            Eval(12589, o is ImplementOneInterface, false);
            Eval(12590, o is ImplementOneInterface[], false);
            Eval(12591, o is ImplementOneInterface?, false);
            Eval(12592, o is ImplementOneInterface?[], false);
            Eval(12593, o is ImplementTwoInterface, false);
            Eval(12594, o is ImplementTwoInterface[], false);
            Eval(12595, o is ImplementTwoInterface?, false);
            Eval(12596, o is ImplementTwoInterface?[], false);
            Eval(12597, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(12598, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(12599, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(12600, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(12601, o is ImplementTwoInterfaceGen<int>, false);
            Eval(12602, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(12603, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(12604, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(12605, o is ImplementAllInterface<int>, false);
            Eval(12606, o is ImplementAllInterface<int>[], false);
            Eval(12607, o is ImplementAllInterface<int>?, false);
            Eval(12608, o is ImplementAllInterface<int>?[], false);
            Eval(12609, o is IntE, false);
            Eval(12610, o is IntE[], false);
            Eval(12611, o is IntE?, false);
            Eval(12612, o is IntE?[], false);
            Eval(12613, o is ByteE, false);
            Eval(12614, o is ByteE[], false);
            Eval(12615, o is ByteE?, false);
            Eval(12616, o is ByteE?[], false);
            Eval(12617, o is LongE, false);
            Eval(12618, o is LongE[], false);
            Eval(12619, o is LongE?, false);
            Eval(12620, o is LongE?[], false);
            Eval(12621, o is char, false);
            Eval(12622, o is char[], false);
            Eval(12623, o is char?, false);
            Eval(12624, o is char?[], false);
            Eval(12625, o is bool, false);
            Eval(12626, o is bool[], false);
            Eval(12627, o is bool?, false);
            Eval(12628, o is bool?[], false);
            Eval(12629, o is byte, true);
            Eval(12630, o is byte[], false);
            Eval(12631, o is byte?, true);
            Eval(12632, o is byte?[], false);
            Eval(12633, o is sbyte, false);
            Eval(12634, o is sbyte[], false);
            Eval(12635, o is sbyte?, false);
            Eval(12636, o is sbyte?[], false);
            Eval(12637, o is short, false);
            Eval(12638, o is short[], false);
            Eval(12639, o is short?, false);
            Eval(12640, o is short?[], false);
            Eval(12641, o is ushort, false);
            Eval(12642, o is ushort[], false);
            Eval(12643, o is ushort?, false);
            Eval(12644, o is ushort?[], false);
            Eval(12645, o is int, false);
            Eval(12646, o is int[], false);
            Eval(12647, o is int?, false);
            Eval(12648, o is int?[], false);
            Eval(12649, o is uint, false);
            Eval(12650, o is uint[], false);
            Eval(12651, o is uint?, false);
            Eval(12652, o is uint?[], false);
            Eval(12653, o is long, false);
            Eval(12654, o is long[], false);
            Eval(12655, o is long?, false);
            Eval(12656, o is long?[], false);
            Eval(12657, o is ulong, false);
            Eval(12658, o is ulong[], false);
            Eval(12659, o is ulong?, false);
            Eval(12660, o is ulong?[], false);
            Eval(12661, o is float, false);
            Eval(12662, o is float[], false);
            Eval(12663, o is float?, false);
            Eval(12664, o is float?[], false);
            Eval(12665, o is double, false);
            Eval(12666, o is double[], false);
            Eval(12667, o is double?, false);
            Eval(12668, o is double?[], false);
            Eval(12669, o is decimal, false);
            Eval(12670, o is decimal[], false);
            Eval(12671, o is decimal?, false);
            Eval(12672, o is decimal?[], false);
            Eval(12673, o is IntPtr, false);
            Eval(12674, o is IntPtr[], false);
            Eval(12675, o is IntPtr?, false);
            Eval(12676, o is IntPtr?[], false);
            Eval(12677, o is UIntPtr, false);
            Eval(12678, o is UIntPtr[], false);
            Eval(12679, o is UIntPtr?, false);
            Eval(12680, o is UIntPtr?[], false);
            Eval(12681, o is Guid, false);
            Eval(12682, o is Guid[], false);
            Eval(12683, o is Guid?, false);
            Eval(12684, o is Guid?[], false);
            Eval(12685, o is GCHandle, false);
            Eval(12686, o is GCHandle[], false);
            Eval(12687, o is GCHandle?, false);
            Eval(12688, o is GCHandle?[], false);
            Eval(12689, o is object, true);
            Eval(12690, o is object[], false);
            Eval(12691, o is string, false);
            Eval(12692, o is string[], false);
            Eval(12693, o is ValueType, true);
            Eval(12694, o is ValueType[], false);
            Eval(12695, o is Array, false);
            Eval(12696, o is Array[], false);
            Eval(12697, o is Enum, false);
            Eval(12698, o is Enum[], false);
            Eval(12699, o is Delegate, false);
            Eval(12700, o is Delegate[], false);
            Eval(12701, o is MulticastDelegate, false);
            Eval(12702, o is MulticastDelegate[], false);
            Eval(12703, o is IEmpty, false);
            Eval(12704, o is IEmpty[], false);
            Eval(12705, o is INotEmpty, false);
            Eval(12706, o is INotEmpty[], false);
            Eval(12707, o is IEmptyGen<int>, false);
            Eval(12708, o is IEmptyGen<int>[], false);
            Eval(12709, o is INotEmptyGen<int>, false);
            Eval(12710, o is INotEmptyGen<int>[], false);
            Eval(12711, o is SimpleDelegate, false);
            Eval(12712, o is SimpleDelegate[], false);
            Eval(12713, o is GenericDelegate<int>, false);
            Eval(12714, o is GenericDelegate<int>[], false);
            Eval(12715, o is EmptyClass, false);
            Eval(12716, o is EmptyClass[], false);
            Eval(12717, o is NotEmptyClass, false);
            Eval(12718, o is NotEmptyClass[], false);
            Eval(12719, o is EmptyClassGen<int>, false);
            Eval(12720, o is EmptyClassGen<int>[], false);
            Eval(12721, o is NotEmptyClassGen<Guid>, false);
            Eval(12722, o is NotEmptyClassGen<Guid>[], false);
            Eval(12723, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(12724, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(12725, o is NestedClass, false);
            Eval(12726, o is NestedClass[], false);
            Eval(12727, o is NestedClassGen<Decimal>, false);
            Eval(12728, o is NestedClassGen<Decimal>[], false);
            Eval(12729, o is ImplementOneInterfaceC, false);
            Eval(12730, o is ImplementOneInterfaceC[], false);
            Eval(12731, o is ImplementTwoInterfaceC, false);
            Eval(12732, o is ImplementTwoInterfaceC[], false);
            Eval(12733, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(12734, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(12735, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(12736, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(12737, o is ImplementAllInterfaceC<int>, false);
            Eval(12738, o is ImplementAllInterfaceC<int>[], false);
            Eval(12739, o is SealedClass, false);
            Eval(12740, o is SealedClass[], false);
        }
        {
            byte? v = default(byte?);
            ValueType o = v;
            Eval(12741, o is EmptyStruct, false);
            Eval(12742, o is EmptyStruct[], false);
            Eval(12743, o is EmptyStruct?, false);
            Eval(12744, o is EmptyStruct?[], false);
            Eval(12745, o is NotEmptyStruct, false);
            Eval(12746, o is NotEmptyStruct[], false);
            Eval(12747, o is NotEmptyStruct?, false);
            Eval(12748, o is NotEmptyStruct?[], false);
            Eval(12749, o is EmptyStructGen<int>, false);
            Eval(12750, o is EmptyStructGen<int>[], false);
            Eval(12751, o is EmptyStructGen<int>?, false);
            Eval(12752, o is EmptyStructGen<int>?[], false);
            Eval(12753, o is NotEmptyStructGen<Guid>, false);
            Eval(12754, o is NotEmptyStructGen<Guid>[], false);
            Eval(12755, o is NotEmptyStructGen<Guid>?, false);
            Eval(12756, o is NotEmptyStructGen<Guid>?[], false);
            Eval(12757, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(12758, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(12759, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(12760, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(12761, o is NestedStruct, false);
            Eval(12762, o is NestedStruct[], false);
            Eval(12763, o is NestedStruct?, false);
            Eval(12764, o is NestedStruct?[], false);
            Eval(12765, o is NestedStructGen<Decimal>, false);
            Eval(12766, o is NestedStructGen<Decimal>[], false);
            Eval(12767, o is NestedStructGen<Decimal>?, false);
            Eval(12768, o is NestedStructGen<Decimal>?[], false);
            Eval(12769, o is ExplicitFieldOffsetStruct, false);
            Eval(12770, o is ExplicitFieldOffsetStruct[], false);
            Eval(12771, o is ExplicitFieldOffsetStruct?, false);
            Eval(12772, o is ExplicitFieldOffsetStruct?[], false);
            Eval(12781, o is MarshalAsStruct, false);
            Eval(12782, o is MarshalAsStruct[], false);
            Eval(12783, o is MarshalAsStruct?, false);
            Eval(12784, o is MarshalAsStruct?[], false);
            Eval(12785, o is ImplementOneInterface, false);
            Eval(12786, o is ImplementOneInterface[], false);
            Eval(12787, o is ImplementOneInterface?, false);
            Eval(12788, o is ImplementOneInterface?[], false);
            Eval(12789, o is ImplementTwoInterface, false);
            Eval(12790, o is ImplementTwoInterface[], false);
            Eval(12791, o is ImplementTwoInterface?, false);
            Eval(12792, o is ImplementTwoInterface?[], false);
            Eval(12793, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(12794, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(12795, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(12796, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(12797, o is ImplementTwoInterfaceGen<int>, false);
            Eval(12798, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(12799, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(12800, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(12801, o is ImplementAllInterface<int>, false);
            Eval(12802, o is ImplementAllInterface<int>[], false);
            Eval(12803, o is ImplementAllInterface<int>?, false);
            Eval(12804, o is ImplementAllInterface<int>?[], false);
            Eval(12805, o is IntE, false);
            Eval(12806, o is IntE[], false);
            Eval(12807, o is IntE?, false);
            Eval(12808, o is IntE?[], false);
            Eval(12809, o is ByteE, false);
            Eval(12810, o is ByteE[], false);
            Eval(12811, o is ByteE?, false);
            Eval(12812, o is ByteE?[], false);
            Eval(12813, o is LongE, false);
            Eval(12814, o is LongE[], false);
            Eval(12815, o is LongE?, false);
            Eval(12816, o is LongE?[], false);
            Eval(12817, o is char, false);
            Eval(12818, o is char[], false);
            Eval(12819, o is char?, false);
            Eval(12820, o is char?[], false);
            Eval(12821, o is bool, false);
            Eval(12822, o is bool[], false);
            Eval(12823, o is bool?, false);
            Eval(12824, o is bool?[], false);
            Eval(12825, o is byte, false);
            Eval(12826, o is byte[], false);
            Eval(12827, o is byte?, false);
            Eval(12828, o is byte?[], false);
            Eval(12829, o is sbyte, false);
            Eval(12830, o is sbyte[], false);
            Eval(12831, o is sbyte?, false);
            Eval(12832, o is sbyte?[], false);
            Eval(12833, o is short, false);
            Eval(12834, o is short[], false);
            Eval(12835, o is short?, false);
            Eval(12836, o is short?[], false);
            Eval(12837, o is ushort, false);
            Eval(12838, o is ushort[], false);
            Eval(12839, o is ushort?, false);
            Eval(12840, o is ushort?[], false);
            Eval(12841, o is int, false);
            Eval(12842, o is int[], false);
            Eval(12843, o is int?, false);
            Eval(12844, o is int?[], false);
            Eval(12845, o is uint, false);
            Eval(12846, o is uint[], false);
            Eval(12847, o is uint?, false);
            Eval(12848, o is uint?[], false);
            Eval(12849, o is long, false);
            Eval(12850, o is long[], false);
            Eval(12851, o is long?, false);
            Eval(12852, o is long?[], false);
            Eval(12853, o is ulong, false);
            Eval(12854, o is ulong[], false);
            Eval(12855, o is ulong?, false);
            Eval(12856, o is ulong?[], false);
            Eval(12857, o is float, false);
            Eval(12858, o is float[], false);
            Eval(12859, o is float?, false);
            Eval(12860, o is float?[], false);
            Eval(12861, o is double, false);
            Eval(12862, o is double[], false);
            Eval(12863, o is double?, false);
            Eval(12864, o is double?[], false);
            Eval(12865, o is decimal, false);
            Eval(12866, o is decimal[], false);
            Eval(12867, o is decimal?, false);
            Eval(12868, o is decimal?[], false);
            Eval(12869, o is IntPtr, false);
            Eval(12870, o is IntPtr[], false);
            Eval(12871, o is IntPtr?, false);
            Eval(12872, o is IntPtr?[], false);
            Eval(12873, o is UIntPtr, false);
            Eval(12874, o is UIntPtr[], false);
            Eval(12875, o is UIntPtr?, false);
            Eval(12876, o is UIntPtr?[], false);
            Eval(12877, o is Guid, false);
            Eval(12878, o is Guid[], false);
            Eval(12879, o is Guid?, false);
            Eval(12880, o is Guid?[], false);
            Eval(12881, o is GCHandle, false);
            Eval(12882, o is GCHandle[], false);
            Eval(12883, o is GCHandle?, false);
            Eval(12884, o is GCHandle?[], false);
            Eval(12885, o is object, false);
            Eval(12886, o is object[], false);
            Eval(12887, o is string, false);
            Eval(12888, o is string[], false);
            Eval(12889, o is ValueType, false);
            Eval(12890, o is ValueType[], false);
            Eval(12891, o is Array, false);
            Eval(12892, o is Array[], false);
            Eval(12893, o is Enum, false);
            Eval(12894, o is Enum[], false);
            Eval(12895, o is Delegate, false);
            Eval(12896, o is Delegate[], false);
            Eval(12897, o is MulticastDelegate, false);
            Eval(12898, o is MulticastDelegate[], false);
            Eval(12899, o is IEmpty, false);
            Eval(12900, o is IEmpty[], false);
            Eval(12901, o is INotEmpty, false);
            Eval(12902, o is INotEmpty[], false);
            Eval(12903, o is IEmptyGen<int>, false);
            Eval(12904, o is IEmptyGen<int>[], false);
            Eval(12905, o is INotEmptyGen<int>, false);
            Eval(12906, o is INotEmptyGen<int>[], false);
            Eval(12907, o is SimpleDelegate, false);
            Eval(12908, o is SimpleDelegate[], false);
            Eval(12909, o is GenericDelegate<int>, false);
            Eval(12910, o is GenericDelegate<int>[], false);
            Eval(12911, o is EmptyClass, false);
            Eval(12912, o is EmptyClass[], false);
            Eval(12913, o is NotEmptyClass, false);
            Eval(12914, o is NotEmptyClass[], false);
            Eval(12915, o is EmptyClassGen<int>, false);
            Eval(12916, o is EmptyClassGen<int>[], false);
            Eval(12917, o is NotEmptyClassGen<Guid>, false);
            Eval(12918, o is NotEmptyClassGen<Guid>[], false);
            Eval(12919, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(12920, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(12921, o is NestedClass, false);
            Eval(12922, o is NestedClass[], false);
            Eval(12923, o is NestedClassGen<Decimal>, false);
            Eval(12924, o is NestedClassGen<Decimal>[], false);
            Eval(12925, o is ImplementOneInterfaceC, false);
            Eval(12926, o is ImplementOneInterfaceC[], false);
            Eval(12927, o is ImplementTwoInterfaceC, false);
            Eval(12928, o is ImplementTwoInterfaceC[], false);
            Eval(12929, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(12930, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(12931, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(12932, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(12933, o is ImplementAllInterfaceC<int>, false);
            Eval(12934, o is ImplementAllInterfaceC<int>[], false);
            Eval(12935, o is SealedClass, false);
            Eval(12936, o is SealedClass[], false);
        }
    }  // end of test case 0022
    private static void TestCase0023()
    {
        {
            sbyte v = default(sbyte);
            ValueType o = v;
            Eval(12937, o is EmptyStruct, false);
            Eval(12938, o is EmptyStruct[], false);
            Eval(12939, o is EmptyStruct?, false);
            Eval(12940, o is EmptyStruct?[], false);
            Eval(12941, o is NotEmptyStruct, false);
            Eval(12942, o is NotEmptyStruct[], false);
            Eval(12943, o is NotEmptyStruct?, false);
            Eval(12944, o is NotEmptyStruct?[], false);
            Eval(12945, o is EmptyStructGen<int>, false);
            Eval(12946, o is EmptyStructGen<int>[], false);
            Eval(12947, o is EmptyStructGen<int>?, false);
            Eval(12948, o is EmptyStructGen<int>?[], false);
            Eval(12949, o is NotEmptyStructGen<Guid>, false);
            Eval(12950, o is NotEmptyStructGen<Guid>[], false);
            Eval(12951, o is NotEmptyStructGen<Guid>?, false);
            Eval(12952, o is NotEmptyStructGen<Guid>?[], false);
            Eval(12953, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(12954, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(12955, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(12956, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(12957, o is NestedStruct, false);
            Eval(12958, o is NestedStruct[], false);
            Eval(12959, o is NestedStruct?, false);
            Eval(12960, o is NestedStruct?[], false);
            Eval(12961, o is NestedStructGen<Decimal>, false);
            Eval(12962, o is NestedStructGen<Decimal>[], false);
            Eval(12963, o is NestedStructGen<Decimal>?, false);
            Eval(12964, o is NestedStructGen<Decimal>?[], false);
            Eval(12965, o is ExplicitFieldOffsetStruct, false);
            Eval(12966, o is ExplicitFieldOffsetStruct[], false);
            Eval(12967, o is ExplicitFieldOffsetStruct?, false);
            Eval(12968, o is ExplicitFieldOffsetStruct?[], false);
            Eval(12977, o is MarshalAsStruct, false);
            Eval(12978, o is MarshalAsStruct[], false);
            Eval(12979, o is MarshalAsStruct?, false);
            Eval(12980, o is MarshalAsStruct?[], false);
            Eval(12981, o is ImplementOneInterface, false);
            Eval(12982, o is ImplementOneInterface[], false);
            Eval(12983, o is ImplementOneInterface?, false);
            Eval(12984, o is ImplementOneInterface?[], false);
            Eval(12985, o is ImplementTwoInterface, false);
            Eval(12986, o is ImplementTwoInterface[], false);
            Eval(12987, o is ImplementTwoInterface?, false);
            Eval(12988, o is ImplementTwoInterface?[], false);
            Eval(12989, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(12990, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(12991, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(12992, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(12993, o is ImplementTwoInterfaceGen<int>, false);
            Eval(12994, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(12995, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(12996, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(12997, o is ImplementAllInterface<int>, false);
            Eval(12998, o is ImplementAllInterface<int>[], false);
            Eval(12999, o is ImplementAllInterface<int>?, false);
            Eval(13000, o is ImplementAllInterface<int>?[], false);
            Eval(13001, o is IntE, false);
            Eval(13002, o is IntE[], false);
            Eval(13003, o is IntE?, false);
            Eval(13004, o is IntE?[], false);
            Eval(13005, o is ByteE, false);
            Eval(13006, o is ByteE[], false);
            Eval(13007, o is ByteE?, false);
            Eval(13008, o is ByteE?[], false);
            Eval(13009, o is LongE, false);
            Eval(13010, o is LongE[], false);
            Eval(13011, o is LongE?, false);
            Eval(13012, o is LongE?[], false);
            Eval(13013, o is char, false);
            Eval(13014, o is char[], false);
            Eval(13015, o is char?, false);
            Eval(13016, o is char?[], false);
            Eval(13017, o is bool, false);
            Eval(13018, o is bool[], false);
            Eval(13019, o is bool?, false);
            Eval(13020, o is bool?[], false);
            Eval(13021, o is byte, false);
            Eval(13022, o is byte[], false);
            Eval(13023, o is byte?, false);
            Eval(13024, o is byte?[], false);
            Eval(13025, o is sbyte, true);
            Eval(13026, o is sbyte[], false);
            Eval(13027, o is sbyte?, true);
            Eval(13028, o is sbyte?[], false);
            Eval(13029, o is short, false);
            Eval(13030, o is short[], false);
            Eval(13031, o is short?, false);
            Eval(13032, o is short?[], false);
            Eval(13033, o is ushort, false);
            Eval(13034, o is ushort[], false);
            Eval(13035, o is ushort?, false);
            Eval(13036, o is ushort?[], false);
            Eval(13037, o is int, false);
            Eval(13038, o is int[], false);
            Eval(13039, o is int?, false);
            Eval(13040, o is int?[], false);
            Eval(13041, o is uint, false);
            Eval(13042, o is uint[], false);
            Eval(13043, o is uint?, false);
            Eval(13044, o is uint?[], false);
            Eval(13045, o is long, false);
            Eval(13046, o is long[], false);
            Eval(13047, o is long?, false);
            Eval(13048, o is long?[], false);
            Eval(13049, o is ulong, false);
            Eval(13050, o is ulong[], false);
            Eval(13051, o is ulong?, false);
            Eval(13052, o is ulong?[], false);
            Eval(13053, o is float, false);
            Eval(13054, o is float[], false);
            Eval(13055, o is float?, false);
            Eval(13056, o is float?[], false);
            Eval(13057, o is double, false);
            Eval(13058, o is double[], false);
            Eval(13059, o is double?, false);
            Eval(13060, o is double?[], false);
            Eval(13061, o is decimal, false);
            Eval(13062, o is decimal[], false);
            Eval(13063, o is decimal?, false);
            Eval(13064, o is decimal?[], false);
            Eval(13065, o is IntPtr, false);
            Eval(13066, o is IntPtr[], false);
            Eval(13067, o is IntPtr?, false);
            Eval(13068, o is IntPtr?[], false);
            Eval(13069, o is UIntPtr, false);
            Eval(13070, o is UIntPtr[], false);
            Eval(13071, o is UIntPtr?, false);
            Eval(13072, o is UIntPtr?[], false);
            Eval(13073, o is Guid, false);
            Eval(13074, o is Guid[], false);
            Eval(13075, o is Guid?, false);
            Eval(13076, o is Guid?[], false);
            Eval(13077, o is GCHandle, false);
            Eval(13078, o is GCHandle[], false);
            Eval(13079, o is GCHandle?, false);
            Eval(13080, o is GCHandle?[], false);
            Eval(13081, o is object, true);
            Eval(13082, o is object[], false);
            Eval(13083, o is string, false);
            Eval(13084, o is string[], false);
            Eval(13085, o is ValueType, true);
            Eval(13086, o is ValueType[], false);
            Eval(13087, o is Array, false);
            Eval(13088, o is Array[], false);
            Eval(13089, o is Enum, false);
            Eval(13090, o is Enum[], false);
            Eval(13091, o is Delegate, false);
            Eval(13092, o is Delegate[], false);
            Eval(13093, o is MulticastDelegate, false);
            Eval(13094, o is MulticastDelegate[], false);
            Eval(13095, o is IEmpty, false);
            Eval(13096, o is IEmpty[], false);
            Eval(13097, o is INotEmpty, false);
            Eval(13098, o is INotEmpty[], false);
            Eval(13099, o is IEmptyGen<int>, false);
            Eval(13100, o is IEmptyGen<int>[], false);
            Eval(13101, o is INotEmptyGen<int>, false);
            Eval(13102, o is INotEmptyGen<int>[], false);
            Eval(13103, o is SimpleDelegate, false);
            Eval(13104, o is SimpleDelegate[], false);
            Eval(13105, o is GenericDelegate<int>, false);
            Eval(13106, o is GenericDelegate<int>[], false);
            Eval(13107, o is EmptyClass, false);
            Eval(13108, o is EmptyClass[], false);
            Eval(13109, o is NotEmptyClass, false);
            Eval(13110, o is NotEmptyClass[], false);
            Eval(13111, o is EmptyClassGen<int>, false);
            Eval(13112, o is EmptyClassGen<int>[], false);
            Eval(13113, o is NotEmptyClassGen<Guid>, false);
            Eval(13114, o is NotEmptyClassGen<Guid>[], false);
            Eval(13115, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(13116, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(13117, o is NestedClass, false);
            Eval(13118, o is NestedClass[], false);
            Eval(13119, o is NestedClassGen<Decimal>, false);
            Eval(13120, o is NestedClassGen<Decimal>[], false);
            Eval(13121, o is ImplementOneInterfaceC, false);
            Eval(13122, o is ImplementOneInterfaceC[], false);
            Eval(13123, o is ImplementTwoInterfaceC, false);
            Eval(13124, o is ImplementTwoInterfaceC[], false);
            Eval(13125, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(13126, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(13127, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(13128, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(13129, o is ImplementAllInterfaceC<int>, false);
            Eval(13130, o is ImplementAllInterfaceC<int>[], false);
            Eval(13131, o is SealedClass, false);
            Eval(13132, o is SealedClass[], false);
        }
        {
            sbyte? v = default(sbyte);
            ValueType o = v;
            Eval(13133, o is EmptyStruct, false);
            Eval(13134, o is EmptyStruct[], false);
            Eval(13135, o is EmptyStruct?, false);
            Eval(13136, o is EmptyStruct?[], false);
            Eval(13137, o is NotEmptyStruct, false);
            Eval(13138, o is NotEmptyStruct[], false);
            Eval(13139, o is NotEmptyStruct?, false);
            Eval(13140, o is NotEmptyStruct?[], false);
            Eval(13141, o is EmptyStructGen<int>, false);
            Eval(13142, o is EmptyStructGen<int>[], false);
            Eval(13143, o is EmptyStructGen<int>?, false);
            Eval(13144, o is EmptyStructGen<int>?[], false);
            Eval(13145, o is NotEmptyStructGen<Guid>, false);
            Eval(13146, o is NotEmptyStructGen<Guid>[], false);
            Eval(13147, o is NotEmptyStructGen<Guid>?, false);
            Eval(13148, o is NotEmptyStructGen<Guid>?[], false);
            Eval(13149, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(13150, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(13151, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(13152, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(13153, o is NestedStruct, false);
            Eval(13154, o is NestedStruct[], false);
            Eval(13155, o is NestedStruct?, false);
            Eval(13156, o is NestedStruct?[], false);
            Eval(13157, o is NestedStructGen<Decimal>, false);
            Eval(13158, o is NestedStructGen<Decimal>[], false);
            Eval(13159, o is NestedStructGen<Decimal>?, false);
            Eval(13160, o is NestedStructGen<Decimal>?[], false);
            Eval(13161, o is ExplicitFieldOffsetStruct, false);
            Eval(13162, o is ExplicitFieldOffsetStruct[], false);
            Eval(13163, o is ExplicitFieldOffsetStruct?, false);
            Eval(13164, o is ExplicitFieldOffsetStruct?[], false);
            Eval(13173, o is MarshalAsStruct, false);
            Eval(13174, o is MarshalAsStruct[], false);
            Eval(13175, o is MarshalAsStruct?, false);
            Eval(13176, o is MarshalAsStruct?[], false);
            Eval(13177, o is ImplementOneInterface, false);
            Eval(13178, o is ImplementOneInterface[], false);
            Eval(13179, o is ImplementOneInterface?, false);
            Eval(13180, o is ImplementOneInterface?[], false);
            Eval(13181, o is ImplementTwoInterface, false);
            Eval(13182, o is ImplementTwoInterface[], false);
            Eval(13183, o is ImplementTwoInterface?, false);
            Eval(13184, o is ImplementTwoInterface?[], false);
            Eval(13185, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(13186, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(13187, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(13188, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(13189, o is ImplementTwoInterfaceGen<int>, false);
            Eval(13190, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(13191, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(13192, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(13193, o is ImplementAllInterface<int>, false);
            Eval(13194, o is ImplementAllInterface<int>[], false);
            Eval(13195, o is ImplementAllInterface<int>?, false);
            Eval(13196, o is ImplementAllInterface<int>?[], false);
            Eval(13197, o is IntE, false);
            Eval(13198, o is IntE[], false);
            Eval(13199, o is IntE?, false);
            Eval(13200, o is IntE?[], false);
            Eval(13201, o is ByteE, false);
            Eval(13202, o is ByteE[], false);
            Eval(13203, o is ByteE?, false);
            Eval(13204, o is ByteE?[], false);
            Eval(13205, o is LongE, false);
            Eval(13206, o is LongE[], false);
            Eval(13207, o is LongE?, false);
            Eval(13208, o is LongE?[], false);
            Eval(13209, o is char, false);
            Eval(13210, o is char[], false);
            Eval(13211, o is char?, false);
            Eval(13212, o is char?[], false);
            Eval(13213, o is bool, false);
            Eval(13214, o is bool[], false);
            Eval(13215, o is bool?, false);
            Eval(13216, o is bool?[], false);
            Eval(13217, o is byte, false);
            Eval(13218, o is byte[], false);
            Eval(13219, o is byte?, false);
            Eval(13220, o is byte?[], false);
            Eval(13221, o is sbyte, true);
            Eval(13222, o is sbyte[], false);
            Eval(13223, o is sbyte?, true);
            Eval(13224, o is sbyte?[], false);
            Eval(13225, o is short, false);
            Eval(13226, o is short[], false);
            Eval(13227, o is short?, false);
            Eval(13228, o is short?[], false);
            Eval(13229, o is ushort, false);
            Eval(13230, o is ushort[], false);
            Eval(13231, o is ushort?, false);
            Eval(13232, o is ushort?[], false);
            Eval(13233, o is int, false);
            Eval(13234, o is int[], false);
            Eval(13235, o is int?, false);
            Eval(13236, o is int?[], false);
            Eval(13237, o is uint, false);
            Eval(13238, o is uint[], false);
            Eval(13239, o is uint?, false);
            Eval(13240, o is uint?[], false);
            Eval(13241, o is long, false);
            Eval(13242, o is long[], false);
            Eval(13243, o is long?, false);
            Eval(13244, o is long?[], false);
            Eval(13245, o is ulong, false);
            Eval(13246, o is ulong[], false);
            Eval(13247, o is ulong?, false);
            Eval(13248, o is ulong?[], false);
            Eval(13249, o is float, false);
            Eval(13250, o is float[], false);
            Eval(13251, o is float?, false);
            Eval(13252, o is float?[], false);
            Eval(13253, o is double, false);
            Eval(13254, o is double[], false);
            Eval(13255, o is double?, false);
            Eval(13256, o is double?[], false);
            Eval(13257, o is decimal, false);
            Eval(13258, o is decimal[], false);
            Eval(13259, o is decimal?, false);
            Eval(13260, o is decimal?[], false);
            Eval(13261, o is IntPtr, false);
            Eval(13262, o is IntPtr[], false);
            Eval(13263, o is IntPtr?, false);
            Eval(13264, o is IntPtr?[], false);
            Eval(13265, o is UIntPtr, false);
            Eval(13266, o is UIntPtr[], false);
            Eval(13267, o is UIntPtr?, false);
            Eval(13268, o is UIntPtr?[], false);
            Eval(13269, o is Guid, false);
            Eval(13270, o is Guid[], false);
            Eval(13271, o is Guid?, false);
            Eval(13272, o is Guid?[], false);
            Eval(13273, o is GCHandle, false);
            Eval(13274, o is GCHandle[], false);
            Eval(13275, o is GCHandle?, false);
            Eval(13276, o is GCHandle?[], false);
            Eval(13277, o is object, true);
            Eval(13278, o is object[], false);
            Eval(13279, o is string, false);
            Eval(13280, o is string[], false);
            Eval(13281, o is ValueType, true);
            Eval(13282, o is ValueType[], false);
            Eval(13283, o is Array, false);
            Eval(13284, o is Array[], false);
            Eval(13285, o is Enum, false);
            Eval(13286, o is Enum[], false);
            Eval(13287, o is Delegate, false);
            Eval(13288, o is Delegate[], false);
            Eval(13289, o is MulticastDelegate, false);
            Eval(13290, o is MulticastDelegate[], false);
            Eval(13291, o is IEmpty, false);
            Eval(13292, o is IEmpty[], false);
            Eval(13293, o is INotEmpty, false);
            Eval(13294, o is INotEmpty[], false);
            Eval(13295, o is IEmptyGen<int>, false);
            Eval(13296, o is IEmptyGen<int>[], false);
            Eval(13297, o is INotEmptyGen<int>, false);
            Eval(13298, o is INotEmptyGen<int>[], false);
            Eval(13299, o is SimpleDelegate, false);
            Eval(13300, o is SimpleDelegate[], false);
            Eval(13301, o is GenericDelegate<int>, false);
            Eval(13302, o is GenericDelegate<int>[], false);
            Eval(13303, o is EmptyClass, false);
            Eval(13304, o is EmptyClass[], false);
            Eval(13305, o is NotEmptyClass, false);
            Eval(13306, o is NotEmptyClass[], false);
            Eval(13307, o is EmptyClassGen<int>, false);
            Eval(13308, o is EmptyClassGen<int>[], false);
            Eval(13309, o is NotEmptyClassGen<Guid>, false);
            Eval(13310, o is NotEmptyClassGen<Guid>[], false);
            Eval(13311, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(13312, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(13313, o is NestedClass, false);
            Eval(13314, o is NestedClass[], false);
            Eval(13315, o is NestedClassGen<Decimal>, false);
            Eval(13316, o is NestedClassGen<Decimal>[], false);
            Eval(13317, o is ImplementOneInterfaceC, false);
            Eval(13318, o is ImplementOneInterfaceC[], false);
            Eval(13319, o is ImplementTwoInterfaceC, false);
            Eval(13320, o is ImplementTwoInterfaceC[], false);
            Eval(13321, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(13322, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(13323, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(13324, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(13325, o is ImplementAllInterfaceC<int>, false);
            Eval(13326, o is ImplementAllInterfaceC<int>[], false);
            Eval(13327, o is SealedClass, false);
            Eval(13328, o is SealedClass[], false);
        }
        {
            sbyte? v = default(sbyte?);
            ValueType o = v;
            Eval(13329, o is EmptyStruct, false);
            Eval(13330, o is EmptyStruct[], false);
            Eval(13331, o is EmptyStruct?, false);
            Eval(13332, o is EmptyStruct?[], false);
            Eval(13333, o is NotEmptyStruct, false);
            Eval(13334, o is NotEmptyStruct[], false);
            Eval(13335, o is NotEmptyStruct?, false);
            Eval(13336, o is NotEmptyStruct?[], false);
            Eval(13337, o is EmptyStructGen<int>, false);
            Eval(13338, o is EmptyStructGen<int>[], false);
            Eval(13339, o is EmptyStructGen<int>?, false);
            Eval(13340, o is EmptyStructGen<int>?[], false);
            Eval(13341, o is NotEmptyStructGen<Guid>, false);
            Eval(13342, o is NotEmptyStructGen<Guid>[], false);
            Eval(13343, o is NotEmptyStructGen<Guid>?, false);
            Eval(13344, o is NotEmptyStructGen<Guid>?[], false);
            Eval(13345, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(13346, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(13347, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(13348, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(13349, o is NestedStruct, false);
            Eval(13350, o is NestedStruct[], false);
            Eval(13351, o is NestedStruct?, false);
            Eval(13352, o is NestedStruct?[], false);
            Eval(13353, o is NestedStructGen<Decimal>, false);
            Eval(13354, o is NestedStructGen<Decimal>[], false);
            Eval(13355, o is NestedStructGen<Decimal>?, false);
            Eval(13356, o is NestedStructGen<Decimal>?[], false);
            Eval(13357, o is ExplicitFieldOffsetStruct, false);
            Eval(13358, o is ExplicitFieldOffsetStruct[], false);
            Eval(13359, o is ExplicitFieldOffsetStruct?, false);
            Eval(13360, o is ExplicitFieldOffsetStruct?[], false);
            Eval(13369, o is MarshalAsStruct, false);
            Eval(13370, o is MarshalAsStruct[], false);
            Eval(13371, o is MarshalAsStruct?, false);
            Eval(13372, o is MarshalAsStruct?[], false);
            Eval(13373, o is ImplementOneInterface, false);
            Eval(13374, o is ImplementOneInterface[], false);
            Eval(13375, o is ImplementOneInterface?, false);
            Eval(13376, o is ImplementOneInterface?[], false);
            Eval(13377, o is ImplementTwoInterface, false);
            Eval(13378, o is ImplementTwoInterface[], false);
            Eval(13379, o is ImplementTwoInterface?, false);
            Eval(13380, o is ImplementTwoInterface?[], false);
            Eval(13381, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(13382, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(13383, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(13384, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(13385, o is ImplementTwoInterfaceGen<int>, false);
            Eval(13386, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(13387, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(13388, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(13389, o is ImplementAllInterface<int>, false);
            Eval(13390, o is ImplementAllInterface<int>[], false);
            Eval(13391, o is ImplementAllInterface<int>?, false);
            Eval(13392, o is ImplementAllInterface<int>?[], false);
            Eval(13393, o is IntE, false);
            Eval(13394, o is IntE[], false);
            Eval(13395, o is IntE?, false);
            Eval(13396, o is IntE?[], false);
            Eval(13397, o is ByteE, false);
            Eval(13398, o is ByteE[], false);
            Eval(13399, o is ByteE?, false);
            Eval(13400, o is ByteE?[], false);
            Eval(13401, o is LongE, false);
            Eval(13402, o is LongE[], false);
            Eval(13403, o is LongE?, false);
            Eval(13404, o is LongE?[], false);
            Eval(13405, o is char, false);
            Eval(13406, o is char[], false);
            Eval(13407, o is char?, false);
            Eval(13408, o is char?[], false);
            Eval(13409, o is bool, false);
            Eval(13410, o is bool[], false);
            Eval(13411, o is bool?, false);
            Eval(13412, o is bool?[], false);
            Eval(13413, o is byte, false);
            Eval(13414, o is byte[], false);
            Eval(13415, o is byte?, false);
            Eval(13416, o is byte?[], false);
            Eval(13417, o is sbyte, false);
            Eval(13418, o is sbyte[], false);
            Eval(13419, o is sbyte?, false);
            Eval(13420, o is sbyte?[], false);
            Eval(13421, o is short, false);
            Eval(13422, o is short[], false);
            Eval(13423, o is short?, false);
            Eval(13424, o is short?[], false);
            Eval(13425, o is ushort, false);
            Eval(13426, o is ushort[], false);
            Eval(13427, o is ushort?, false);
            Eval(13428, o is ushort?[], false);
            Eval(13429, o is int, false);
            Eval(13430, o is int[], false);
            Eval(13431, o is int?, false);
            Eval(13432, o is int?[], false);
            Eval(13433, o is uint, false);
            Eval(13434, o is uint[], false);
            Eval(13435, o is uint?, false);
            Eval(13436, o is uint?[], false);
            Eval(13437, o is long, false);
            Eval(13438, o is long[], false);
            Eval(13439, o is long?, false);
            Eval(13440, o is long?[], false);
            Eval(13441, o is ulong, false);
            Eval(13442, o is ulong[], false);
            Eval(13443, o is ulong?, false);
            Eval(13444, o is ulong?[], false);
            Eval(13445, o is float, false);
            Eval(13446, o is float[], false);
            Eval(13447, o is float?, false);
            Eval(13448, o is float?[], false);
            Eval(13449, o is double, false);
            Eval(13450, o is double[], false);
            Eval(13451, o is double?, false);
            Eval(13452, o is double?[], false);
            Eval(13453, o is decimal, false);
            Eval(13454, o is decimal[], false);
            Eval(13455, o is decimal?, false);
            Eval(13456, o is decimal?[], false);
            Eval(13457, o is IntPtr, false);
            Eval(13458, o is IntPtr[], false);
            Eval(13459, o is IntPtr?, false);
            Eval(13460, o is IntPtr?[], false);
            Eval(13461, o is UIntPtr, false);
            Eval(13462, o is UIntPtr[], false);
            Eval(13463, o is UIntPtr?, false);
            Eval(13464, o is UIntPtr?[], false);
            Eval(13465, o is Guid, false);
            Eval(13466, o is Guid[], false);
            Eval(13467, o is Guid?, false);
            Eval(13468, o is Guid?[], false);
            Eval(13469, o is GCHandle, false);
            Eval(13470, o is GCHandle[], false);
            Eval(13471, o is GCHandle?, false);
            Eval(13472, o is GCHandle?[], false);
            Eval(13473, o is object, false);
            Eval(13474, o is object[], false);
            Eval(13475, o is string, false);
            Eval(13476, o is string[], false);
            Eval(13477, o is ValueType, false);
            Eval(13478, o is ValueType[], false);
            Eval(13479, o is Array, false);
            Eval(13480, o is Array[], false);
            Eval(13481, o is Enum, false);
            Eval(13482, o is Enum[], false);
            Eval(13483, o is Delegate, false);
            Eval(13484, o is Delegate[], false);
            Eval(13485, o is MulticastDelegate, false);
            Eval(13486, o is MulticastDelegate[], false);
            Eval(13487, o is IEmpty, false);
            Eval(13488, o is IEmpty[], false);
            Eval(13489, o is INotEmpty, false);
            Eval(13490, o is INotEmpty[], false);
            Eval(13491, o is IEmptyGen<int>, false);
            Eval(13492, o is IEmptyGen<int>[], false);
            Eval(13493, o is INotEmptyGen<int>, false);
            Eval(13494, o is INotEmptyGen<int>[], false);
            Eval(13495, o is SimpleDelegate, false);
            Eval(13496, o is SimpleDelegate[], false);
            Eval(13497, o is GenericDelegate<int>, false);
            Eval(13498, o is GenericDelegate<int>[], false);
            Eval(13499, o is EmptyClass, false);
            Eval(13500, o is EmptyClass[], false);
            Eval(13501, o is NotEmptyClass, false);
            Eval(13502, o is NotEmptyClass[], false);
            Eval(13503, o is EmptyClassGen<int>, false);
            Eval(13504, o is EmptyClassGen<int>[], false);
            Eval(13505, o is NotEmptyClassGen<Guid>, false);
            Eval(13506, o is NotEmptyClassGen<Guid>[], false);
            Eval(13507, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(13508, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(13509, o is NestedClass, false);
            Eval(13510, o is NestedClass[], false);
            Eval(13511, o is NestedClassGen<Decimal>, false);
            Eval(13512, o is NestedClassGen<Decimal>[], false);
            Eval(13513, o is ImplementOneInterfaceC, false);
            Eval(13514, o is ImplementOneInterfaceC[], false);
            Eval(13515, o is ImplementTwoInterfaceC, false);
            Eval(13516, o is ImplementTwoInterfaceC[], false);
            Eval(13517, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(13518, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(13519, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(13520, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(13521, o is ImplementAllInterfaceC<int>, false);
            Eval(13522, o is ImplementAllInterfaceC<int>[], false);
            Eval(13523, o is SealedClass, false);
            Eval(13524, o is SealedClass[], false);
        }
    }  // end of test case 0023
    private static void TestCase0024()
    {
        {
            short v = default(short);
            ValueType o = v;
            Eval(13525, o is EmptyStruct, false);
            Eval(13526, o is EmptyStruct[], false);
            Eval(13527, o is EmptyStruct?, false);
            Eval(13528, o is EmptyStruct?[], false);
            Eval(13529, o is NotEmptyStruct, false);
            Eval(13530, o is NotEmptyStruct[], false);
            Eval(13531, o is NotEmptyStruct?, false);
            Eval(13532, o is NotEmptyStruct?[], false);
            Eval(13533, o is EmptyStructGen<int>, false);
            Eval(13534, o is EmptyStructGen<int>[], false);
            Eval(13535, o is EmptyStructGen<int>?, false);
            Eval(13536, o is EmptyStructGen<int>?[], false);
            Eval(13537, o is NotEmptyStructGen<Guid>, false);
            Eval(13538, o is NotEmptyStructGen<Guid>[], false);
            Eval(13539, o is NotEmptyStructGen<Guid>?, false);
            Eval(13540, o is NotEmptyStructGen<Guid>?[], false);
            Eval(13541, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(13542, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(13543, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(13544, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(13545, o is NestedStruct, false);
            Eval(13546, o is NestedStruct[], false);
            Eval(13547, o is NestedStruct?, false);
            Eval(13548, o is NestedStruct?[], false);
            Eval(13549, o is NestedStructGen<Decimal>, false);
            Eval(13550, o is NestedStructGen<Decimal>[], false);
            Eval(13551, o is NestedStructGen<Decimal>?, false);
            Eval(13552, o is NestedStructGen<Decimal>?[], false);
            Eval(13553, o is ExplicitFieldOffsetStruct, false);
            Eval(13554, o is ExplicitFieldOffsetStruct[], false);
            Eval(13555, o is ExplicitFieldOffsetStruct?, false);
            Eval(13556, o is ExplicitFieldOffsetStruct?[], false);
            Eval(13565, o is MarshalAsStruct, false);
            Eval(13566, o is MarshalAsStruct[], false);
            Eval(13567, o is MarshalAsStruct?, false);
            Eval(13568, o is MarshalAsStruct?[], false);
            Eval(13569, o is ImplementOneInterface, false);
            Eval(13570, o is ImplementOneInterface[], false);
            Eval(13571, o is ImplementOneInterface?, false);
            Eval(13572, o is ImplementOneInterface?[], false);
            Eval(13573, o is ImplementTwoInterface, false);
            Eval(13574, o is ImplementTwoInterface[], false);
            Eval(13575, o is ImplementTwoInterface?, false);
            Eval(13576, o is ImplementTwoInterface?[], false);
            Eval(13577, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(13578, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(13579, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(13580, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(13581, o is ImplementTwoInterfaceGen<int>, false);
            Eval(13582, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(13583, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(13584, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(13585, o is ImplementAllInterface<int>, false);
            Eval(13586, o is ImplementAllInterface<int>[], false);
            Eval(13587, o is ImplementAllInterface<int>?, false);
            Eval(13588, o is ImplementAllInterface<int>?[], false);
            Eval(13589, o is IntE, false);
            Eval(13590, o is IntE[], false);
            Eval(13591, o is IntE?, false);
            Eval(13592, o is IntE?[], false);
            Eval(13593, o is ByteE, false);
            Eval(13594, o is ByteE[], false);
            Eval(13595, o is ByteE?, false);
            Eval(13596, o is ByteE?[], false);
            Eval(13597, o is LongE, false);
            Eval(13598, o is LongE[], false);
            Eval(13599, o is LongE?, false);
            Eval(13600, o is LongE?[], false);
            Eval(13601, o is char, false);
            Eval(13602, o is char[], false);
            Eval(13603, o is char?, false);
            Eval(13604, o is char?[], false);
            Eval(13605, o is bool, false);
            Eval(13606, o is bool[], false);
            Eval(13607, o is bool?, false);
            Eval(13608, o is bool?[], false);
            Eval(13609, o is byte, false);
            Eval(13610, o is byte[], false);
            Eval(13611, o is byte?, false);
            Eval(13612, o is byte?[], false);
            Eval(13613, o is sbyte, false);
            Eval(13614, o is sbyte[], false);
            Eval(13615, o is sbyte?, false);
            Eval(13616, o is sbyte?[], false);
            Eval(13617, o is short, true);
            Eval(13618, o is short[], false);
            Eval(13619, o is short?, true);
            Eval(13620, o is short?[], false);
            Eval(13621, o is ushort, false);
            Eval(13622, o is ushort[], false);
            Eval(13623, o is ushort?, false);
            Eval(13624, o is ushort?[], false);
            Eval(13625, o is int, false);
            Eval(13626, o is int[], false);
            Eval(13627, o is int?, false);
            Eval(13628, o is int?[], false);
            Eval(13629, o is uint, false);
            Eval(13630, o is uint[], false);
            Eval(13631, o is uint?, false);
            Eval(13632, o is uint?[], false);
            Eval(13633, o is long, false);
            Eval(13634, o is long[], false);
            Eval(13635, o is long?, false);
            Eval(13636, o is long?[], false);
            Eval(13637, o is ulong, false);
            Eval(13638, o is ulong[], false);
            Eval(13639, o is ulong?, false);
            Eval(13640, o is ulong?[], false);
            Eval(13641, o is float, false);
            Eval(13642, o is float[], false);
            Eval(13643, o is float?, false);
            Eval(13644, o is float?[], false);
            Eval(13645, o is double, false);
            Eval(13646, o is double[], false);
            Eval(13647, o is double?, false);
            Eval(13648, o is double?[], false);
            Eval(13649, o is decimal, false);
            Eval(13650, o is decimal[], false);
            Eval(13651, o is decimal?, false);
            Eval(13652, o is decimal?[], false);
            Eval(13653, o is IntPtr, false);
            Eval(13654, o is IntPtr[], false);
            Eval(13655, o is IntPtr?, false);
            Eval(13656, o is IntPtr?[], false);
            Eval(13657, o is UIntPtr, false);
            Eval(13658, o is UIntPtr[], false);
            Eval(13659, o is UIntPtr?, false);
            Eval(13660, o is UIntPtr?[], false);
            Eval(13661, o is Guid, false);
            Eval(13662, o is Guid[], false);
            Eval(13663, o is Guid?, false);
            Eval(13664, o is Guid?[], false);
            Eval(13665, o is GCHandle, false);
            Eval(13666, o is GCHandle[], false);
            Eval(13667, o is GCHandle?, false);
            Eval(13668, o is GCHandle?[], false);
            Eval(13669, o is object, true);
            Eval(13670, o is object[], false);
            Eval(13671, o is string, false);
            Eval(13672, o is string[], false);
            Eval(13673, o is ValueType, true);
            Eval(13674, o is ValueType[], false);
            Eval(13675, o is Array, false);
            Eval(13676, o is Array[], false);
            Eval(13677, o is Enum, false);
            Eval(13678, o is Enum[], false);
            Eval(13679, o is Delegate, false);
            Eval(13680, o is Delegate[], false);
            Eval(13681, o is MulticastDelegate, false);
            Eval(13682, o is MulticastDelegate[], false);
            Eval(13683, o is IEmpty, false);
            Eval(13684, o is IEmpty[], false);
            Eval(13685, o is INotEmpty, false);
            Eval(13686, o is INotEmpty[], false);
            Eval(13687, o is IEmptyGen<int>, false);
            Eval(13688, o is IEmptyGen<int>[], false);
            Eval(13689, o is INotEmptyGen<int>, false);
            Eval(13690, o is INotEmptyGen<int>[], false);
            Eval(13691, o is SimpleDelegate, false);
            Eval(13692, o is SimpleDelegate[], false);
            Eval(13693, o is GenericDelegate<int>, false);
            Eval(13694, o is GenericDelegate<int>[], false);
            Eval(13695, o is EmptyClass, false);
            Eval(13696, o is EmptyClass[], false);
            Eval(13697, o is NotEmptyClass, false);
            Eval(13698, o is NotEmptyClass[], false);
            Eval(13699, o is EmptyClassGen<int>, false);
            Eval(13700, o is EmptyClassGen<int>[], false);
            Eval(13701, o is NotEmptyClassGen<Guid>, false);
            Eval(13702, o is NotEmptyClassGen<Guid>[], false);
            Eval(13703, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(13704, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(13705, o is NestedClass, false);
            Eval(13706, o is NestedClass[], false);
            Eval(13707, o is NestedClassGen<Decimal>, false);
            Eval(13708, o is NestedClassGen<Decimal>[], false);
            Eval(13709, o is ImplementOneInterfaceC, false);
            Eval(13710, o is ImplementOneInterfaceC[], false);
            Eval(13711, o is ImplementTwoInterfaceC, false);
            Eval(13712, o is ImplementTwoInterfaceC[], false);
            Eval(13713, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(13714, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(13715, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(13716, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(13717, o is ImplementAllInterfaceC<int>, false);
            Eval(13718, o is ImplementAllInterfaceC<int>[], false);
            Eval(13719, o is SealedClass, false);
            Eval(13720, o is SealedClass[], false);
        }
        {
            short? v = default(short);
            ValueType o = v;
            Eval(13721, o is EmptyStruct, false);
            Eval(13722, o is EmptyStruct[], false);
            Eval(13723, o is EmptyStruct?, false);
            Eval(13724, o is EmptyStruct?[], false);
            Eval(13725, o is NotEmptyStruct, false);
            Eval(13726, o is NotEmptyStruct[], false);
            Eval(13727, o is NotEmptyStruct?, false);
            Eval(13728, o is NotEmptyStruct?[], false);
            Eval(13729, o is EmptyStructGen<int>, false);
            Eval(13730, o is EmptyStructGen<int>[], false);
            Eval(13731, o is EmptyStructGen<int>?, false);
            Eval(13732, o is EmptyStructGen<int>?[], false);
            Eval(13733, o is NotEmptyStructGen<Guid>, false);
            Eval(13734, o is NotEmptyStructGen<Guid>[], false);
            Eval(13735, o is NotEmptyStructGen<Guid>?, false);
            Eval(13736, o is NotEmptyStructGen<Guid>?[], false);
            Eval(13737, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(13738, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(13739, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(13740, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(13741, o is NestedStruct, false);
            Eval(13742, o is NestedStruct[], false);
            Eval(13743, o is NestedStruct?, false);
            Eval(13744, o is NestedStruct?[], false);
            Eval(13745, o is NestedStructGen<Decimal>, false);
            Eval(13746, o is NestedStructGen<Decimal>[], false);
            Eval(13747, o is NestedStructGen<Decimal>?, false);
            Eval(13748, o is NestedStructGen<Decimal>?[], false);
            Eval(13749, o is ExplicitFieldOffsetStruct, false);
            Eval(13750, o is ExplicitFieldOffsetStruct[], false);
            Eval(13751, o is ExplicitFieldOffsetStruct?, false);
            Eval(13752, o is ExplicitFieldOffsetStruct?[], false);
            Eval(13761, o is MarshalAsStruct, false);
            Eval(13762, o is MarshalAsStruct[], false);
            Eval(13763, o is MarshalAsStruct?, false);
            Eval(13764, o is MarshalAsStruct?[], false);
            Eval(13765, o is ImplementOneInterface, false);
            Eval(13766, o is ImplementOneInterface[], false);
            Eval(13767, o is ImplementOneInterface?, false);
            Eval(13768, o is ImplementOneInterface?[], false);
            Eval(13769, o is ImplementTwoInterface, false);
            Eval(13770, o is ImplementTwoInterface[], false);
            Eval(13771, o is ImplementTwoInterface?, false);
            Eval(13772, o is ImplementTwoInterface?[], false);
            Eval(13773, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(13774, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(13775, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(13776, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(13777, o is ImplementTwoInterfaceGen<int>, false);
            Eval(13778, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(13779, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(13780, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(13781, o is ImplementAllInterface<int>, false);
            Eval(13782, o is ImplementAllInterface<int>[], false);
            Eval(13783, o is ImplementAllInterface<int>?, false);
            Eval(13784, o is ImplementAllInterface<int>?[], false);
            Eval(13785, o is IntE, false);
            Eval(13786, o is IntE[], false);
            Eval(13787, o is IntE?, false);
            Eval(13788, o is IntE?[], false);
            Eval(13789, o is ByteE, false);
            Eval(13790, o is ByteE[], false);
            Eval(13791, o is ByteE?, false);
            Eval(13792, o is ByteE?[], false);
            Eval(13793, o is LongE, false);
            Eval(13794, o is LongE[], false);
            Eval(13795, o is LongE?, false);
            Eval(13796, o is LongE?[], false);
            Eval(13797, o is char, false);
            Eval(13798, o is char[], false);
            Eval(13799, o is char?, false);
            Eval(13800, o is char?[], false);
            Eval(13801, o is bool, false);
            Eval(13802, o is bool[], false);
            Eval(13803, o is bool?, false);
            Eval(13804, o is bool?[], false);
            Eval(13805, o is byte, false);
            Eval(13806, o is byte[], false);
            Eval(13807, o is byte?, false);
            Eval(13808, o is byte?[], false);
            Eval(13809, o is sbyte, false);
            Eval(13810, o is sbyte[], false);
            Eval(13811, o is sbyte?, false);
            Eval(13812, o is sbyte?[], false);
            Eval(13813, o is short, true);
            Eval(13814, o is short[], false);
            Eval(13815, o is short?, true);
            Eval(13816, o is short?[], false);
            Eval(13817, o is ushort, false);
            Eval(13818, o is ushort[], false);
            Eval(13819, o is ushort?, false);
            Eval(13820, o is ushort?[], false);
            Eval(13821, o is int, false);
            Eval(13822, o is int[], false);
            Eval(13823, o is int?, false);
            Eval(13824, o is int?[], false);
            Eval(13825, o is uint, false);
            Eval(13826, o is uint[], false);
            Eval(13827, o is uint?, false);
            Eval(13828, o is uint?[], false);
            Eval(13829, o is long, false);
            Eval(13830, o is long[], false);
            Eval(13831, o is long?, false);
            Eval(13832, o is long?[], false);
            Eval(13833, o is ulong, false);
            Eval(13834, o is ulong[], false);
            Eval(13835, o is ulong?, false);
            Eval(13836, o is ulong?[], false);
            Eval(13837, o is float, false);
            Eval(13838, o is float[], false);
            Eval(13839, o is float?, false);
            Eval(13840, o is float?[], false);
            Eval(13841, o is double, false);
            Eval(13842, o is double[], false);
            Eval(13843, o is double?, false);
            Eval(13844, o is double?[], false);
            Eval(13845, o is decimal, false);
            Eval(13846, o is decimal[], false);
            Eval(13847, o is decimal?, false);
            Eval(13848, o is decimal?[], false);
            Eval(13849, o is IntPtr, false);
            Eval(13850, o is IntPtr[], false);
            Eval(13851, o is IntPtr?, false);
            Eval(13852, o is IntPtr?[], false);
            Eval(13853, o is UIntPtr, false);
            Eval(13854, o is UIntPtr[], false);
            Eval(13855, o is UIntPtr?, false);
            Eval(13856, o is UIntPtr?[], false);
            Eval(13857, o is Guid, false);
            Eval(13858, o is Guid[], false);
            Eval(13859, o is Guid?, false);
            Eval(13860, o is Guid?[], false);
            Eval(13861, o is GCHandle, false);
            Eval(13862, o is GCHandle[], false);
            Eval(13863, o is GCHandle?, false);
            Eval(13864, o is GCHandle?[], false);
            Eval(13865, o is object, true);
            Eval(13866, o is object[], false);
            Eval(13867, o is string, false);
            Eval(13868, o is string[], false);
            Eval(13869, o is ValueType, true);
            Eval(13870, o is ValueType[], false);
            Eval(13871, o is Array, false);
            Eval(13872, o is Array[], false);
            Eval(13873, o is Enum, false);
            Eval(13874, o is Enum[], false);
            Eval(13875, o is Delegate, false);
            Eval(13876, o is Delegate[], false);
            Eval(13877, o is MulticastDelegate, false);
            Eval(13878, o is MulticastDelegate[], false);
            Eval(13879, o is IEmpty, false);
            Eval(13880, o is IEmpty[], false);
            Eval(13881, o is INotEmpty, false);
            Eval(13882, o is INotEmpty[], false);
            Eval(13883, o is IEmptyGen<int>, false);
            Eval(13884, o is IEmptyGen<int>[], false);
            Eval(13885, o is INotEmptyGen<int>, false);
            Eval(13886, o is INotEmptyGen<int>[], false);
            Eval(13887, o is SimpleDelegate, false);
            Eval(13888, o is SimpleDelegate[], false);
            Eval(13889, o is GenericDelegate<int>, false);
            Eval(13890, o is GenericDelegate<int>[], false);
            Eval(13891, o is EmptyClass, false);
            Eval(13892, o is EmptyClass[], false);
            Eval(13893, o is NotEmptyClass, false);
            Eval(13894, o is NotEmptyClass[], false);
            Eval(13895, o is EmptyClassGen<int>, false);
            Eval(13896, o is EmptyClassGen<int>[], false);
            Eval(13897, o is NotEmptyClassGen<Guid>, false);
            Eval(13898, o is NotEmptyClassGen<Guid>[], false);
            Eval(13899, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(13900, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(13901, o is NestedClass, false);
            Eval(13902, o is NestedClass[], false);
            Eval(13903, o is NestedClassGen<Decimal>, false);
            Eval(13904, o is NestedClassGen<Decimal>[], false);
            Eval(13905, o is ImplementOneInterfaceC, false);
            Eval(13906, o is ImplementOneInterfaceC[], false);
            Eval(13907, o is ImplementTwoInterfaceC, false);
            Eval(13908, o is ImplementTwoInterfaceC[], false);
            Eval(13909, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(13910, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(13911, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(13912, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(13913, o is ImplementAllInterfaceC<int>, false);
            Eval(13914, o is ImplementAllInterfaceC<int>[], false);
            Eval(13915, o is SealedClass, false);
            Eval(13916, o is SealedClass[], false);
        }
        {
            short? v = default(short?);
            ValueType o = v;
            Eval(13917, o is EmptyStruct, false);
            Eval(13918, o is EmptyStruct[], false);
            Eval(13919, o is EmptyStruct?, false);
            Eval(13920, o is EmptyStruct?[], false);
            Eval(13921, o is NotEmptyStruct, false);
            Eval(13922, o is NotEmptyStruct[], false);
            Eval(13923, o is NotEmptyStruct?, false);
            Eval(13924, o is NotEmptyStruct?[], false);
            Eval(13925, o is EmptyStructGen<int>, false);
            Eval(13926, o is EmptyStructGen<int>[], false);
            Eval(13927, o is EmptyStructGen<int>?, false);
            Eval(13928, o is EmptyStructGen<int>?[], false);
            Eval(13929, o is NotEmptyStructGen<Guid>, false);
            Eval(13930, o is NotEmptyStructGen<Guid>[], false);
            Eval(13931, o is NotEmptyStructGen<Guid>?, false);
            Eval(13932, o is NotEmptyStructGen<Guid>?[], false);
            Eval(13933, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(13934, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(13935, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(13936, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(13937, o is NestedStruct, false);
            Eval(13938, o is NestedStruct[], false);
            Eval(13939, o is NestedStruct?, false);
            Eval(13940, o is NestedStruct?[], false);
            Eval(13941, o is NestedStructGen<Decimal>, false);
            Eval(13942, o is NestedStructGen<Decimal>[], false);
            Eval(13943, o is NestedStructGen<Decimal>?, false);
            Eval(13944, o is NestedStructGen<Decimal>?[], false);
            Eval(13945, o is ExplicitFieldOffsetStruct, false);
            Eval(13946, o is ExplicitFieldOffsetStruct[], false);
            Eval(13947, o is ExplicitFieldOffsetStruct?, false);
            Eval(13948, o is ExplicitFieldOffsetStruct?[], false);
            Eval(13957, o is MarshalAsStruct, false);
            Eval(13958, o is MarshalAsStruct[], false);
            Eval(13959, o is MarshalAsStruct?, false);
            Eval(13960, o is MarshalAsStruct?[], false);
            Eval(13961, o is ImplementOneInterface, false);
            Eval(13962, o is ImplementOneInterface[], false);
            Eval(13963, o is ImplementOneInterface?, false);
            Eval(13964, o is ImplementOneInterface?[], false);
            Eval(13965, o is ImplementTwoInterface, false);
            Eval(13966, o is ImplementTwoInterface[], false);
            Eval(13967, o is ImplementTwoInterface?, false);
            Eval(13968, o is ImplementTwoInterface?[], false);
            Eval(13969, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(13970, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(13971, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(13972, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(13973, o is ImplementTwoInterfaceGen<int>, false);
            Eval(13974, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(13975, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(13976, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(13977, o is ImplementAllInterface<int>, false);
            Eval(13978, o is ImplementAllInterface<int>[], false);
            Eval(13979, o is ImplementAllInterface<int>?, false);
            Eval(13980, o is ImplementAllInterface<int>?[], false);
            Eval(13981, o is IntE, false);
            Eval(13982, o is IntE[], false);
            Eval(13983, o is IntE?, false);
            Eval(13984, o is IntE?[], false);
            Eval(13985, o is ByteE, false);
            Eval(13986, o is ByteE[], false);
            Eval(13987, o is ByteE?, false);
            Eval(13988, o is ByteE?[], false);
            Eval(13989, o is LongE, false);
            Eval(13990, o is LongE[], false);
            Eval(13991, o is LongE?, false);
            Eval(13992, o is LongE?[], false);
            Eval(13993, o is char, false);
            Eval(13994, o is char[], false);
            Eval(13995, o is char?, false);
            Eval(13996, o is char?[], false);
            Eval(13997, o is bool, false);
            Eval(13998, o is bool[], false);
            Eval(13999, o is bool?, false);
            Eval(14000, o is bool?[], false);
            Eval(14001, o is byte, false);
            Eval(14002, o is byte[], false);
            Eval(14003, o is byte?, false);
            Eval(14004, o is byte?[], false);
            Eval(14005, o is sbyte, false);
            Eval(14006, o is sbyte[], false);
            Eval(14007, o is sbyte?, false);
            Eval(14008, o is sbyte?[], false);
            Eval(14009, o is short, false);
            Eval(14010, o is short[], false);
            Eval(14011, o is short?, false);
            Eval(14012, o is short?[], false);
            Eval(14013, o is ushort, false);
            Eval(14014, o is ushort[], false);
            Eval(14015, o is ushort?, false);
            Eval(14016, o is ushort?[], false);
            Eval(14017, o is int, false);
            Eval(14018, o is int[], false);
            Eval(14019, o is int?, false);
            Eval(14020, o is int?[], false);
            Eval(14021, o is uint, false);
            Eval(14022, o is uint[], false);
            Eval(14023, o is uint?, false);
            Eval(14024, o is uint?[], false);
            Eval(14025, o is long, false);
            Eval(14026, o is long[], false);
            Eval(14027, o is long?, false);
            Eval(14028, o is long?[], false);
            Eval(14029, o is ulong, false);
            Eval(14030, o is ulong[], false);
            Eval(14031, o is ulong?, false);
            Eval(14032, o is ulong?[], false);
            Eval(14033, o is float, false);
            Eval(14034, o is float[], false);
            Eval(14035, o is float?, false);
            Eval(14036, o is float?[], false);
            Eval(14037, o is double, false);
            Eval(14038, o is double[], false);
            Eval(14039, o is double?, false);
            Eval(14040, o is double?[], false);
            Eval(14041, o is decimal, false);
            Eval(14042, o is decimal[], false);
            Eval(14043, o is decimal?, false);
            Eval(14044, o is decimal?[], false);
            Eval(14045, o is IntPtr, false);
            Eval(14046, o is IntPtr[], false);
            Eval(14047, o is IntPtr?, false);
            Eval(14048, o is IntPtr?[], false);
            Eval(14049, o is UIntPtr, false);
            Eval(14050, o is UIntPtr[], false);
            Eval(14051, o is UIntPtr?, false);
            Eval(14052, o is UIntPtr?[], false);
            Eval(14053, o is Guid, false);
            Eval(14054, o is Guid[], false);
            Eval(14055, o is Guid?, false);
            Eval(14056, o is Guid?[], false);
            Eval(14057, o is GCHandle, false);
            Eval(14058, o is GCHandle[], false);
            Eval(14059, o is GCHandle?, false);
            Eval(14060, o is GCHandle?[], false);
            Eval(14061, o is object, false);
            Eval(14062, o is object[], false);
            Eval(14063, o is string, false);
            Eval(14064, o is string[], false);
            Eval(14065, o is ValueType, false);
            Eval(14066, o is ValueType[], false);
            Eval(14067, o is Array, false);
            Eval(14068, o is Array[], false);
            Eval(14069, o is Enum, false);
            Eval(14070, o is Enum[], false);
            Eval(14071, o is Delegate, false);
            Eval(14072, o is Delegate[], false);
            Eval(14073, o is MulticastDelegate, false);
            Eval(14074, o is MulticastDelegate[], false);
            Eval(14075, o is IEmpty, false);
            Eval(14076, o is IEmpty[], false);
            Eval(14077, o is INotEmpty, false);
            Eval(14078, o is INotEmpty[], false);
            Eval(14079, o is IEmptyGen<int>, false);
            Eval(14080, o is IEmptyGen<int>[], false);
            Eval(14081, o is INotEmptyGen<int>, false);
            Eval(14082, o is INotEmptyGen<int>[], false);
            Eval(14083, o is SimpleDelegate, false);
            Eval(14084, o is SimpleDelegate[], false);
            Eval(14085, o is GenericDelegate<int>, false);
            Eval(14086, o is GenericDelegate<int>[], false);
            Eval(14087, o is EmptyClass, false);
            Eval(14088, o is EmptyClass[], false);
            Eval(14089, o is NotEmptyClass, false);
            Eval(14090, o is NotEmptyClass[], false);
            Eval(14091, o is EmptyClassGen<int>, false);
            Eval(14092, o is EmptyClassGen<int>[], false);
            Eval(14093, o is NotEmptyClassGen<Guid>, false);
            Eval(14094, o is NotEmptyClassGen<Guid>[], false);
            Eval(14095, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(14096, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(14097, o is NestedClass, false);
            Eval(14098, o is NestedClass[], false);
            Eval(14099, o is NestedClassGen<Decimal>, false);
            Eval(14100, o is NestedClassGen<Decimal>[], false);
            Eval(14101, o is ImplementOneInterfaceC, false);
            Eval(14102, o is ImplementOneInterfaceC[], false);
            Eval(14103, o is ImplementTwoInterfaceC, false);
            Eval(14104, o is ImplementTwoInterfaceC[], false);
            Eval(14105, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(14106, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(14107, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(14108, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(14109, o is ImplementAllInterfaceC<int>, false);
            Eval(14110, o is ImplementAllInterfaceC<int>[], false);
            Eval(14111, o is SealedClass, false);
            Eval(14112, o is SealedClass[], false);
        }
    }  // end of test case 0024
    private static void TestCase0025()
    {
        {
            ushort v = default(ushort);
            ValueType o = v;
            Eval(14113, o is EmptyStruct, false);
            Eval(14114, o is EmptyStruct[], false);
            Eval(14115, o is EmptyStruct?, false);
            Eval(14116, o is EmptyStruct?[], false);
            Eval(14117, o is NotEmptyStruct, false);
            Eval(14118, o is NotEmptyStruct[], false);
            Eval(14119, o is NotEmptyStruct?, false);
            Eval(14120, o is NotEmptyStruct?[], false);
            Eval(14121, o is EmptyStructGen<int>, false);
            Eval(14122, o is EmptyStructGen<int>[], false);
            Eval(14123, o is EmptyStructGen<int>?, false);
            Eval(14124, o is EmptyStructGen<int>?[], false);
            Eval(14125, o is NotEmptyStructGen<Guid>, false);
            Eval(14126, o is NotEmptyStructGen<Guid>[], false);
            Eval(14127, o is NotEmptyStructGen<Guid>?, false);
            Eval(14128, o is NotEmptyStructGen<Guid>?[], false);
            Eval(14129, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(14130, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(14131, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(14132, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(14133, o is NestedStruct, false);
            Eval(14134, o is NestedStruct[], false);
            Eval(14135, o is NestedStruct?, false);
            Eval(14136, o is NestedStruct?[], false);
            Eval(14137, o is NestedStructGen<Decimal>, false);
            Eval(14138, o is NestedStructGen<Decimal>[], false);
            Eval(14139, o is NestedStructGen<Decimal>?, false);
            Eval(14140, o is NestedStructGen<Decimal>?[], false);
            Eval(14141, o is ExplicitFieldOffsetStruct, false);
            Eval(14142, o is ExplicitFieldOffsetStruct[], false);
            Eval(14143, o is ExplicitFieldOffsetStruct?, false);
            Eval(14144, o is ExplicitFieldOffsetStruct?[], false);
            Eval(14153, o is MarshalAsStruct, false);
            Eval(14154, o is MarshalAsStruct[], false);
            Eval(14155, o is MarshalAsStruct?, false);
            Eval(14156, o is MarshalAsStruct?[], false);
            Eval(14157, o is ImplementOneInterface, false);
            Eval(14158, o is ImplementOneInterface[], false);
            Eval(14159, o is ImplementOneInterface?, false);
            Eval(14160, o is ImplementOneInterface?[], false);
            Eval(14161, o is ImplementTwoInterface, false);
            Eval(14162, o is ImplementTwoInterface[], false);
            Eval(14163, o is ImplementTwoInterface?, false);
            Eval(14164, o is ImplementTwoInterface?[], false);
            Eval(14165, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(14166, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(14167, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(14168, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(14169, o is ImplementTwoInterfaceGen<int>, false);
            Eval(14170, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(14171, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(14172, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(14173, o is ImplementAllInterface<int>, false);
            Eval(14174, o is ImplementAllInterface<int>[], false);
            Eval(14175, o is ImplementAllInterface<int>?, false);
            Eval(14176, o is ImplementAllInterface<int>?[], false);
            Eval(14177, o is IntE, false);
            Eval(14178, o is IntE[], false);
            Eval(14179, o is IntE?, false);
            Eval(14180, o is IntE?[], false);
            Eval(14181, o is ByteE, false);
            Eval(14182, o is ByteE[], false);
            Eval(14183, o is ByteE?, false);
            Eval(14184, o is ByteE?[], false);
            Eval(14185, o is LongE, false);
            Eval(14186, o is LongE[], false);
            Eval(14187, o is LongE?, false);
            Eval(14188, o is LongE?[], false);
            Eval(14189, o is char, false);
            Eval(14190, o is char[], false);
            Eval(14191, o is char?, false);
            Eval(14192, o is char?[], false);
            Eval(14193, o is bool, false);
            Eval(14194, o is bool[], false);
            Eval(14195, o is bool?, false);
            Eval(14196, o is bool?[], false);
            Eval(14197, o is byte, false);
            Eval(14198, o is byte[], false);
            Eval(14199, o is byte?, false);
            Eval(14200, o is byte?[], false);
            Eval(14201, o is sbyte, false);
            Eval(14202, o is sbyte[], false);
            Eval(14203, o is sbyte?, false);
            Eval(14204, o is sbyte?[], false);
            Eval(14205, o is short, false);
            Eval(14206, o is short[], false);
            Eval(14207, o is short?, false);
            Eval(14208, o is short?[], false);
            Eval(14209, o is ushort, true);
            Eval(14210, o is ushort[], false);
            Eval(14211, o is ushort?, true);
            Eval(14212, o is ushort?[], false);
            Eval(14213, o is int, false);
            Eval(14214, o is int[], false);
            Eval(14215, o is int?, false);
            Eval(14216, o is int?[], false);
            Eval(14217, o is uint, false);
            Eval(14218, o is uint[], false);
            Eval(14219, o is uint?, false);
            Eval(14220, o is uint?[], false);
            Eval(14221, o is long, false);
            Eval(14222, o is long[], false);
            Eval(14223, o is long?, false);
            Eval(14224, o is long?[], false);
            Eval(14225, o is ulong, false);
            Eval(14226, o is ulong[], false);
            Eval(14227, o is ulong?, false);
            Eval(14228, o is ulong?[], false);
            Eval(14229, o is float, false);
            Eval(14230, o is float[], false);
            Eval(14231, o is float?, false);
            Eval(14232, o is float?[], false);
            Eval(14233, o is double, false);
            Eval(14234, o is double[], false);
            Eval(14235, o is double?, false);
            Eval(14236, o is double?[], false);
            Eval(14237, o is decimal, false);
            Eval(14238, o is decimal[], false);
            Eval(14239, o is decimal?, false);
            Eval(14240, o is decimal?[], false);
            Eval(14241, o is IntPtr, false);
            Eval(14242, o is IntPtr[], false);
            Eval(14243, o is IntPtr?, false);
            Eval(14244, o is IntPtr?[], false);
            Eval(14245, o is UIntPtr, false);
            Eval(14246, o is UIntPtr[], false);
            Eval(14247, o is UIntPtr?, false);
            Eval(14248, o is UIntPtr?[], false);
            Eval(14249, o is Guid, false);
            Eval(14250, o is Guid[], false);
            Eval(14251, o is Guid?, false);
            Eval(14252, o is Guid?[], false);
            Eval(14253, o is GCHandle, false);
            Eval(14254, o is GCHandle[], false);
            Eval(14255, o is GCHandle?, false);
            Eval(14256, o is GCHandle?[], false);
            Eval(14257, o is object, true);
            Eval(14258, o is object[], false);
            Eval(14259, o is string, false);
            Eval(14260, o is string[], false);
            Eval(14261, o is ValueType, true);
            Eval(14262, o is ValueType[], false);
            Eval(14263, o is Array, false);
            Eval(14264, o is Array[], false);
            Eval(14265, o is Enum, false);
            Eval(14266, o is Enum[], false);
            Eval(14267, o is Delegate, false);
            Eval(14268, o is Delegate[], false);
            Eval(14269, o is MulticastDelegate, false);
            Eval(14270, o is MulticastDelegate[], false);
            Eval(14271, o is IEmpty, false);
            Eval(14272, o is IEmpty[], false);
            Eval(14273, o is INotEmpty, false);
            Eval(14274, o is INotEmpty[], false);
            Eval(14275, o is IEmptyGen<int>, false);
            Eval(14276, o is IEmptyGen<int>[], false);
            Eval(14277, o is INotEmptyGen<int>, false);
            Eval(14278, o is INotEmptyGen<int>[], false);
            Eval(14279, o is SimpleDelegate, false);
            Eval(14280, o is SimpleDelegate[], false);
            Eval(14281, o is GenericDelegate<int>, false);
            Eval(14282, o is GenericDelegate<int>[], false);
            Eval(14283, o is EmptyClass, false);
            Eval(14284, o is EmptyClass[], false);
            Eval(14285, o is NotEmptyClass, false);
            Eval(14286, o is NotEmptyClass[], false);
            Eval(14287, o is EmptyClassGen<int>, false);
            Eval(14288, o is EmptyClassGen<int>[], false);
            Eval(14289, o is NotEmptyClassGen<Guid>, false);
            Eval(14290, o is NotEmptyClassGen<Guid>[], false);
            Eval(14291, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(14292, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(14293, o is NestedClass, false);
            Eval(14294, o is NestedClass[], false);
            Eval(14295, o is NestedClassGen<Decimal>, false);
            Eval(14296, o is NestedClassGen<Decimal>[], false);
            Eval(14297, o is ImplementOneInterfaceC, false);
            Eval(14298, o is ImplementOneInterfaceC[], false);
            Eval(14299, o is ImplementTwoInterfaceC, false);
            Eval(14300, o is ImplementTwoInterfaceC[], false);
            Eval(14301, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(14302, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(14303, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(14304, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(14305, o is ImplementAllInterfaceC<int>, false);
            Eval(14306, o is ImplementAllInterfaceC<int>[], false);
            Eval(14307, o is SealedClass, false);
            Eval(14308, o is SealedClass[], false);
        }
        {
            ushort? v = default(ushort);
            ValueType o = v;
            Eval(14309, o is EmptyStruct, false);
            Eval(14310, o is EmptyStruct[], false);
            Eval(14311, o is EmptyStruct?, false);
            Eval(14312, o is EmptyStruct?[], false);
            Eval(14313, o is NotEmptyStruct, false);
            Eval(14314, o is NotEmptyStruct[], false);
            Eval(14315, o is NotEmptyStruct?, false);
            Eval(14316, o is NotEmptyStruct?[], false);
            Eval(14317, o is EmptyStructGen<int>, false);
            Eval(14318, o is EmptyStructGen<int>[], false);
            Eval(14319, o is EmptyStructGen<int>?, false);
            Eval(14320, o is EmptyStructGen<int>?[], false);
            Eval(14321, o is NotEmptyStructGen<Guid>, false);
            Eval(14322, o is NotEmptyStructGen<Guid>[], false);
            Eval(14323, o is NotEmptyStructGen<Guid>?, false);
            Eval(14324, o is NotEmptyStructGen<Guid>?[], false);
            Eval(14325, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(14326, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(14327, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(14328, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(14329, o is NestedStruct, false);
            Eval(14330, o is NestedStruct[], false);
            Eval(14331, o is NestedStruct?, false);
            Eval(14332, o is NestedStruct?[], false);
            Eval(14333, o is NestedStructGen<Decimal>, false);
            Eval(14334, o is NestedStructGen<Decimal>[], false);
            Eval(14335, o is NestedStructGen<Decimal>?, false);
            Eval(14336, o is NestedStructGen<Decimal>?[], false);
            Eval(14337, o is ExplicitFieldOffsetStruct, false);
            Eval(14338, o is ExplicitFieldOffsetStruct[], false);
            Eval(14339, o is ExplicitFieldOffsetStruct?, false);
            Eval(14340, o is ExplicitFieldOffsetStruct?[], false);
            Eval(14349, o is MarshalAsStruct, false);
            Eval(14350, o is MarshalAsStruct[], false);
            Eval(14351, o is MarshalAsStruct?, false);
            Eval(14352, o is MarshalAsStruct?[], false);
            Eval(14353, o is ImplementOneInterface, false);
            Eval(14354, o is ImplementOneInterface[], false);
            Eval(14355, o is ImplementOneInterface?, false);
            Eval(14356, o is ImplementOneInterface?[], false);
            Eval(14357, o is ImplementTwoInterface, false);
            Eval(14358, o is ImplementTwoInterface[], false);
            Eval(14359, o is ImplementTwoInterface?, false);
            Eval(14360, o is ImplementTwoInterface?[], false);
            Eval(14361, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(14362, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(14363, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(14364, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(14365, o is ImplementTwoInterfaceGen<int>, false);
            Eval(14366, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(14367, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(14368, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(14369, o is ImplementAllInterface<int>, false);
            Eval(14370, o is ImplementAllInterface<int>[], false);
            Eval(14371, o is ImplementAllInterface<int>?, false);
            Eval(14372, o is ImplementAllInterface<int>?[], false);
            Eval(14373, o is IntE, false);
            Eval(14374, o is IntE[], false);
            Eval(14375, o is IntE?, false);
            Eval(14376, o is IntE?[], false);
            Eval(14377, o is ByteE, false);
            Eval(14378, o is ByteE[], false);
            Eval(14379, o is ByteE?, false);
            Eval(14380, o is ByteE?[], false);
            Eval(14381, o is LongE, false);
            Eval(14382, o is LongE[], false);
            Eval(14383, o is LongE?, false);
            Eval(14384, o is LongE?[], false);
            Eval(14385, o is char, false);
            Eval(14386, o is char[], false);
            Eval(14387, o is char?, false);
            Eval(14388, o is char?[], false);
            Eval(14389, o is bool, false);
            Eval(14390, o is bool[], false);
            Eval(14391, o is bool?, false);
            Eval(14392, o is bool?[], false);
            Eval(14393, o is byte, false);
            Eval(14394, o is byte[], false);
            Eval(14395, o is byte?, false);
            Eval(14396, o is byte?[], false);
            Eval(14397, o is sbyte, false);
            Eval(14398, o is sbyte[], false);
            Eval(14399, o is sbyte?, false);
            Eval(14400, o is sbyte?[], false);
            Eval(14401, o is short, false);
            Eval(14402, o is short[], false);
            Eval(14403, o is short?, false);
            Eval(14404, o is short?[], false);
            Eval(14405, o is ushort, true);
            Eval(14406, o is ushort[], false);
            Eval(14407, o is ushort?, true);
            Eval(14408, o is ushort?[], false);
            Eval(14409, o is int, false);
            Eval(14410, o is int[], false);
            Eval(14411, o is int?, false);
            Eval(14412, o is int?[], false);
            Eval(14413, o is uint, false);
            Eval(14414, o is uint[], false);
            Eval(14415, o is uint?, false);
            Eval(14416, o is uint?[], false);
            Eval(14417, o is long, false);
            Eval(14418, o is long[], false);
            Eval(14419, o is long?, false);
            Eval(14420, o is long?[], false);
            Eval(14421, o is ulong, false);
            Eval(14422, o is ulong[], false);
            Eval(14423, o is ulong?, false);
            Eval(14424, o is ulong?[], false);
            Eval(14425, o is float, false);
            Eval(14426, o is float[], false);
            Eval(14427, o is float?, false);
            Eval(14428, o is float?[], false);
            Eval(14429, o is double, false);
            Eval(14430, o is double[], false);
            Eval(14431, o is double?, false);
            Eval(14432, o is double?[], false);
            Eval(14433, o is decimal, false);
            Eval(14434, o is decimal[], false);
            Eval(14435, o is decimal?, false);
            Eval(14436, o is decimal?[], false);
            Eval(14437, o is IntPtr, false);
            Eval(14438, o is IntPtr[], false);
            Eval(14439, o is IntPtr?, false);
            Eval(14440, o is IntPtr?[], false);
            Eval(14441, o is UIntPtr, false);
            Eval(14442, o is UIntPtr[], false);
            Eval(14443, o is UIntPtr?, false);
            Eval(14444, o is UIntPtr?[], false);
            Eval(14445, o is Guid, false);
            Eval(14446, o is Guid[], false);
            Eval(14447, o is Guid?, false);
            Eval(14448, o is Guid?[], false);
            Eval(14449, o is GCHandle, false);
            Eval(14450, o is GCHandle[], false);
            Eval(14451, o is GCHandle?, false);
            Eval(14452, o is GCHandle?[], false);
            Eval(14453, o is object, true);
            Eval(14454, o is object[], false);
            Eval(14455, o is string, false);
            Eval(14456, o is string[], false);
            Eval(14457, o is ValueType, true);
            Eval(14458, o is ValueType[], false);
            Eval(14459, o is Array, false);
            Eval(14460, o is Array[], false);
            Eval(14461, o is Enum, false);
            Eval(14462, o is Enum[], false);
            Eval(14463, o is Delegate, false);
            Eval(14464, o is Delegate[], false);
            Eval(14465, o is MulticastDelegate, false);
            Eval(14466, o is MulticastDelegate[], false);
            Eval(14467, o is IEmpty, false);
            Eval(14468, o is IEmpty[], false);
            Eval(14469, o is INotEmpty, false);
            Eval(14470, o is INotEmpty[], false);
            Eval(14471, o is IEmptyGen<int>, false);
            Eval(14472, o is IEmptyGen<int>[], false);
            Eval(14473, o is INotEmptyGen<int>, false);
            Eval(14474, o is INotEmptyGen<int>[], false);
            Eval(14475, o is SimpleDelegate, false);
            Eval(14476, o is SimpleDelegate[], false);
            Eval(14477, o is GenericDelegate<int>, false);
            Eval(14478, o is GenericDelegate<int>[], false);
            Eval(14479, o is EmptyClass, false);
            Eval(14480, o is EmptyClass[], false);
            Eval(14481, o is NotEmptyClass, false);
            Eval(14482, o is NotEmptyClass[], false);
            Eval(14483, o is EmptyClassGen<int>, false);
            Eval(14484, o is EmptyClassGen<int>[], false);
            Eval(14485, o is NotEmptyClassGen<Guid>, false);
            Eval(14486, o is NotEmptyClassGen<Guid>[], false);
            Eval(14487, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(14488, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(14489, o is NestedClass, false);
            Eval(14490, o is NestedClass[], false);
            Eval(14491, o is NestedClassGen<Decimal>, false);
            Eval(14492, o is NestedClassGen<Decimal>[], false);
            Eval(14493, o is ImplementOneInterfaceC, false);
            Eval(14494, o is ImplementOneInterfaceC[], false);
            Eval(14495, o is ImplementTwoInterfaceC, false);
            Eval(14496, o is ImplementTwoInterfaceC[], false);
            Eval(14497, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(14498, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(14499, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(14500, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(14501, o is ImplementAllInterfaceC<int>, false);
            Eval(14502, o is ImplementAllInterfaceC<int>[], false);
            Eval(14503, o is SealedClass, false);
            Eval(14504, o is SealedClass[], false);
        }
        {
            ushort? v = default(ushort?);
            ValueType o = v;
            Eval(14505, o is EmptyStruct, false);
            Eval(14506, o is EmptyStruct[], false);
            Eval(14507, o is EmptyStruct?, false);
            Eval(14508, o is EmptyStruct?[], false);
            Eval(14509, o is NotEmptyStruct, false);
            Eval(14510, o is NotEmptyStruct[], false);
            Eval(14511, o is NotEmptyStruct?, false);
            Eval(14512, o is NotEmptyStruct?[], false);
            Eval(14513, o is EmptyStructGen<int>, false);
            Eval(14514, o is EmptyStructGen<int>[], false);
            Eval(14515, o is EmptyStructGen<int>?, false);
            Eval(14516, o is EmptyStructGen<int>?[], false);
            Eval(14517, o is NotEmptyStructGen<Guid>, false);
            Eval(14518, o is NotEmptyStructGen<Guid>[], false);
            Eval(14519, o is NotEmptyStructGen<Guid>?, false);
            Eval(14520, o is NotEmptyStructGen<Guid>?[], false);
            Eval(14521, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(14522, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(14523, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(14524, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(14525, o is NestedStruct, false);
            Eval(14526, o is NestedStruct[], false);
            Eval(14527, o is NestedStruct?, false);
            Eval(14528, o is NestedStruct?[], false);
            Eval(14529, o is NestedStructGen<Decimal>, false);
            Eval(14530, o is NestedStructGen<Decimal>[], false);
            Eval(14531, o is NestedStructGen<Decimal>?, false);
            Eval(14532, o is NestedStructGen<Decimal>?[], false);
            Eval(14533, o is ExplicitFieldOffsetStruct, false);
            Eval(14534, o is ExplicitFieldOffsetStruct[], false);
            Eval(14535, o is ExplicitFieldOffsetStruct?, false);
            Eval(14536, o is ExplicitFieldOffsetStruct?[], false);
            Eval(14545, o is MarshalAsStruct, false);
            Eval(14546, o is MarshalAsStruct[], false);
            Eval(14547, o is MarshalAsStruct?, false);
            Eval(14548, o is MarshalAsStruct?[], false);
            Eval(14549, o is ImplementOneInterface, false);
            Eval(14550, o is ImplementOneInterface[], false);
            Eval(14551, o is ImplementOneInterface?, false);
            Eval(14552, o is ImplementOneInterface?[], false);
            Eval(14553, o is ImplementTwoInterface, false);
            Eval(14554, o is ImplementTwoInterface[], false);
            Eval(14555, o is ImplementTwoInterface?, false);
            Eval(14556, o is ImplementTwoInterface?[], false);
            Eval(14557, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(14558, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(14559, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(14560, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(14561, o is ImplementTwoInterfaceGen<int>, false);
            Eval(14562, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(14563, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(14564, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(14565, o is ImplementAllInterface<int>, false);
            Eval(14566, o is ImplementAllInterface<int>[], false);
            Eval(14567, o is ImplementAllInterface<int>?, false);
            Eval(14568, o is ImplementAllInterface<int>?[], false);
            Eval(14569, o is IntE, false);
            Eval(14570, o is IntE[], false);
            Eval(14571, o is IntE?, false);
            Eval(14572, o is IntE?[], false);
            Eval(14573, o is ByteE, false);
            Eval(14574, o is ByteE[], false);
            Eval(14575, o is ByteE?, false);
            Eval(14576, o is ByteE?[], false);
            Eval(14577, o is LongE, false);
            Eval(14578, o is LongE[], false);
            Eval(14579, o is LongE?, false);
            Eval(14580, o is LongE?[], false);
            Eval(14581, o is char, false);
            Eval(14582, o is char[], false);
            Eval(14583, o is char?, false);
            Eval(14584, o is char?[], false);
            Eval(14585, o is bool, false);
            Eval(14586, o is bool[], false);
            Eval(14587, o is bool?, false);
            Eval(14588, o is bool?[], false);
            Eval(14589, o is byte, false);
            Eval(14590, o is byte[], false);
            Eval(14591, o is byte?, false);
            Eval(14592, o is byte?[], false);
            Eval(14593, o is sbyte, false);
            Eval(14594, o is sbyte[], false);
            Eval(14595, o is sbyte?, false);
            Eval(14596, o is sbyte?[], false);
            Eval(14597, o is short, false);
            Eval(14598, o is short[], false);
            Eval(14599, o is short?, false);
            Eval(14600, o is short?[], false);
            Eval(14601, o is ushort, false);
            Eval(14602, o is ushort[], false);
            Eval(14603, o is ushort?, false);
            Eval(14604, o is ushort?[], false);
            Eval(14605, o is int, false);
            Eval(14606, o is int[], false);
            Eval(14607, o is int?, false);
            Eval(14608, o is int?[], false);
            Eval(14609, o is uint, false);
            Eval(14610, o is uint[], false);
            Eval(14611, o is uint?, false);
            Eval(14612, o is uint?[], false);
            Eval(14613, o is long, false);
            Eval(14614, o is long[], false);
            Eval(14615, o is long?, false);
            Eval(14616, o is long?[], false);
            Eval(14617, o is ulong, false);
            Eval(14618, o is ulong[], false);
            Eval(14619, o is ulong?, false);
            Eval(14620, o is ulong?[], false);
            Eval(14621, o is float, false);
            Eval(14622, o is float[], false);
            Eval(14623, o is float?, false);
            Eval(14624, o is float?[], false);
            Eval(14625, o is double, false);
            Eval(14626, o is double[], false);
            Eval(14627, o is double?, false);
            Eval(14628, o is double?[], false);
            Eval(14629, o is decimal, false);
            Eval(14630, o is decimal[], false);
            Eval(14631, o is decimal?, false);
            Eval(14632, o is decimal?[], false);
            Eval(14633, o is IntPtr, false);
            Eval(14634, o is IntPtr[], false);
            Eval(14635, o is IntPtr?, false);
            Eval(14636, o is IntPtr?[], false);
            Eval(14637, o is UIntPtr, false);
            Eval(14638, o is UIntPtr[], false);
            Eval(14639, o is UIntPtr?, false);
            Eval(14640, o is UIntPtr?[], false);
            Eval(14641, o is Guid, false);
            Eval(14642, o is Guid[], false);
            Eval(14643, o is Guid?, false);
            Eval(14644, o is Guid?[], false);
            Eval(14645, o is GCHandle, false);
            Eval(14646, o is GCHandle[], false);
            Eval(14647, o is GCHandle?, false);
            Eval(14648, o is GCHandle?[], false);
            Eval(14649, o is object, false);
            Eval(14650, o is object[], false);
            Eval(14651, o is string, false);
            Eval(14652, o is string[], false);
            Eval(14653, o is ValueType, false);
            Eval(14654, o is ValueType[], false);
            Eval(14655, o is Array, false);
            Eval(14656, o is Array[], false);
            Eval(14657, o is Enum, false);
            Eval(14658, o is Enum[], false);
            Eval(14659, o is Delegate, false);
            Eval(14660, o is Delegate[], false);
            Eval(14661, o is MulticastDelegate, false);
            Eval(14662, o is MulticastDelegate[], false);
            Eval(14663, o is IEmpty, false);
            Eval(14664, o is IEmpty[], false);
            Eval(14665, o is INotEmpty, false);
            Eval(14666, o is INotEmpty[], false);
            Eval(14667, o is IEmptyGen<int>, false);
            Eval(14668, o is IEmptyGen<int>[], false);
            Eval(14669, o is INotEmptyGen<int>, false);
            Eval(14670, o is INotEmptyGen<int>[], false);
            Eval(14671, o is SimpleDelegate, false);
            Eval(14672, o is SimpleDelegate[], false);
            Eval(14673, o is GenericDelegate<int>, false);
            Eval(14674, o is GenericDelegate<int>[], false);
            Eval(14675, o is EmptyClass, false);
            Eval(14676, o is EmptyClass[], false);
            Eval(14677, o is NotEmptyClass, false);
            Eval(14678, o is NotEmptyClass[], false);
            Eval(14679, o is EmptyClassGen<int>, false);
            Eval(14680, o is EmptyClassGen<int>[], false);
            Eval(14681, o is NotEmptyClassGen<Guid>, false);
            Eval(14682, o is NotEmptyClassGen<Guid>[], false);
            Eval(14683, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(14684, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(14685, o is NestedClass, false);
            Eval(14686, o is NestedClass[], false);
            Eval(14687, o is NestedClassGen<Decimal>, false);
            Eval(14688, o is NestedClassGen<Decimal>[], false);
            Eval(14689, o is ImplementOneInterfaceC, false);
            Eval(14690, o is ImplementOneInterfaceC[], false);
            Eval(14691, o is ImplementTwoInterfaceC, false);
            Eval(14692, o is ImplementTwoInterfaceC[], false);
            Eval(14693, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(14694, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(14695, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(14696, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(14697, o is ImplementAllInterfaceC<int>, false);
            Eval(14698, o is ImplementAllInterfaceC<int>[], false);
            Eval(14699, o is SealedClass, false);
            Eval(14700, o is SealedClass[], false);
        }
    }  // end of test case 0025
    private static void TestCase0026()
    {
        {
            int v = default(int);
            ValueType o = v;
            Eval(14701, o is EmptyStruct, false);
            Eval(14702, o is EmptyStruct[], false);
            Eval(14703, o is EmptyStruct?, false);
            Eval(14704, o is EmptyStruct?[], false);
            Eval(14705, o is NotEmptyStruct, false);
            Eval(14706, o is NotEmptyStruct[], false);
            Eval(14707, o is NotEmptyStruct?, false);
            Eval(14708, o is NotEmptyStruct?[], false);
            Eval(14709, o is EmptyStructGen<int>, false);
            Eval(14710, o is EmptyStructGen<int>[], false);
            Eval(14711, o is EmptyStructGen<int>?, false);
            Eval(14712, o is EmptyStructGen<int>?[], false);
            Eval(14713, o is NotEmptyStructGen<Guid>, false);
            Eval(14714, o is NotEmptyStructGen<Guid>[], false);
            Eval(14715, o is NotEmptyStructGen<Guid>?, false);
            Eval(14716, o is NotEmptyStructGen<Guid>?[], false);
            Eval(14717, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(14718, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(14719, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(14720, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(14721, o is NestedStruct, false);
            Eval(14722, o is NestedStruct[], false);
            Eval(14723, o is NestedStruct?, false);
            Eval(14724, o is NestedStruct?[], false);
            Eval(14725, o is NestedStructGen<Decimal>, false);
            Eval(14726, o is NestedStructGen<Decimal>[], false);
            Eval(14727, o is NestedStructGen<Decimal>?, false);
            Eval(14728, o is NestedStructGen<Decimal>?[], false);
            Eval(14729, o is ExplicitFieldOffsetStruct, false);
            Eval(14730, o is ExplicitFieldOffsetStruct[], false);
            Eval(14731, o is ExplicitFieldOffsetStruct?, false);
            Eval(14732, o is ExplicitFieldOffsetStruct?[], false);
            Eval(14741, o is MarshalAsStruct, false);
            Eval(14742, o is MarshalAsStruct[], false);
            Eval(14743, o is MarshalAsStruct?, false);
            Eval(14744, o is MarshalAsStruct?[], false);
            Eval(14745, o is ImplementOneInterface, false);
            Eval(14746, o is ImplementOneInterface[], false);
            Eval(14747, o is ImplementOneInterface?, false);
            Eval(14748, o is ImplementOneInterface?[], false);
            Eval(14749, o is ImplementTwoInterface, false);
            Eval(14750, o is ImplementTwoInterface[], false);
            Eval(14751, o is ImplementTwoInterface?, false);
            Eval(14752, o is ImplementTwoInterface?[], false);
            Eval(14753, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(14754, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(14755, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(14756, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(14757, o is ImplementTwoInterfaceGen<int>, false);
            Eval(14758, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(14759, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(14760, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(14761, o is ImplementAllInterface<int>, false);
            Eval(14762, o is ImplementAllInterface<int>[], false);
            Eval(14763, o is ImplementAllInterface<int>?, false);
            Eval(14764, o is ImplementAllInterface<int>?[], false);
            Eval(14765, o is IntE, false);
            Eval(14766, o is IntE[], false);
            Eval(14767, o is IntE?, false);
            Eval(14768, o is IntE?[], false);
            Eval(14769, o is ByteE, false);
            Eval(14770, o is ByteE[], false);
            Eval(14771, o is ByteE?, false);
            Eval(14772, o is ByteE?[], false);
            Eval(14773, o is LongE, false);
            Eval(14774, o is LongE[], false);
            Eval(14775, o is LongE?, false);
            Eval(14776, o is LongE?[], false);
            Eval(14777, o is char, false);
            Eval(14778, o is char[], false);
            Eval(14779, o is char?, false);
            Eval(14780, o is char?[], false);
            Eval(14781, o is bool, false);
            Eval(14782, o is bool[], false);
            Eval(14783, o is bool?, false);
            Eval(14784, o is bool?[], false);
            Eval(14785, o is byte, false);
            Eval(14786, o is byte[], false);
            Eval(14787, o is byte?, false);
            Eval(14788, o is byte?[], false);
            Eval(14789, o is sbyte, false);
            Eval(14790, o is sbyte[], false);
            Eval(14791, o is sbyte?, false);
            Eval(14792, o is sbyte?[], false);
            Eval(14793, o is short, false);
            Eval(14794, o is short[], false);
            Eval(14795, o is short?, false);
            Eval(14796, o is short?[], false);
            Eval(14797, o is ushort, false);
            Eval(14798, o is ushort[], false);
            Eval(14799, o is ushort?, false);
            Eval(14800, o is ushort?[], false);
            Eval(14801, o is int, true);
            Eval(14802, o is int[], false);
            Eval(14803, o is int?, true);
            Eval(14804, o is int?[], false);
            Eval(14805, o is uint, false);
            Eval(14806, o is uint[], false);
            Eval(14807, o is uint?, false);
            Eval(14808, o is uint?[], false);
            Eval(14809, o is long, false);
            Eval(14810, o is long[], false);
            Eval(14811, o is long?, false);
            Eval(14812, o is long?[], false);
            Eval(14813, o is ulong, false);
            Eval(14814, o is ulong[], false);
            Eval(14815, o is ulong?, false);
            Eval(14816, o is ulong?[], false);
            Eval(14817, o is float, false);
            Eval(14818, o is float[], false);
            Eval(14819, o is float?, false);
            Eval(14820, o is float?[], false);
            Eval(14821, o is double, false);
            Eval(14822, o is double[], false);
            Eval(14823, o is double?, false);
            Eval(14824, o is double?[], false);
            Eval(14825, o is decimal, false);
            Eval(14826, o is decimal[], false);
            Eval(14827, o is decimal?, false);
            Eval(14828, o is decimal?[], false);
            Eval(14829, o is IntPtr, false);
            Eval(14830, o is IntPtr[], false);
            Eval(14831, o is IntPtr?, false);
            Eval(14832, o is IntPtr?[], false);
            Eval(14833, o is UIntPtr, false);
            Eval(14834, o is UIntPtr[], false);
            Eval(14835, o is UIntPtr?, false);
            Eval(14836, o is UIntPtr?[], false);
            Eval(14837, o is Guid, false);
            Eval(14838, o is Guid[], false);
            Eval(14839, o is Guid?, false);
            Eval(14840, o is Guid?[], false);
            Eval(14841, o is GCHandle, false);
            Eval(14842, o is GCHandle[], false);
            Eval(14843, o is GCHandle?, false);
            Eval(14844, o is GCHandle?[], false);
            Eval(14845, o is object, true);
            Eval(14846, o is object[], false);
            Eval(14847, o is string, false);
            Eval(14848, o is string[], false);
            Eval(14849, o is ValueType, true);
            Eval(14850, o is ValueType[], false);
            Eval(14851, o is Array, false);
            Eval(14852, o is Array[], false);
            Eval(14853, o is Enum, false);
            Eval(14854, o is Enum[], false);
            Eval(14855, o is Delegate, false);
            Eval(14856, o is Delegate[], false);
            Eval(14857, o is MulticastDelegate, false);
            Eval(14858, o is MulticastDelegate[], false);
            Eval(14859, o is IEmpty, false);
            Eval(14860, o is IEmpty[], false);
            Eval(14861, o is INotEmpty, false);
            Eval(14862, o is INotEmpty[], false);
            Eval(14863, o is IEmptyGen<int>, false);
            Eval(14864, o is IEmptyGen<int>[], false);
            Eval(14865, o is INotEmptyGen<int>, false);
            Eval(14866, o is INotEmptyGen<int>[], false);
            Eval(14867, o is SimpleDelegate, false);
            Eval(14868, o is SimpleDelegate[], false);
            Eval(14869, o is GenericDelegate<int>, false);
            Eval(14870, o is GenericDelegate<int>[], false);
            Eval(14871, o is EmptyClass, false);
            Eval(14872, o is EmptyClass[], false);
            Eval(14873, o is NotEmptyClass, false);
            Eval(14874, o is NotEmptyClass[], false);
            Eval(14875, o is EmptyClassGen<int>, false);
            Eval(14876, o is EmptyClassGen<int>[], false);
            Eval(14877, o is NotEmptyClassGen<Guid>, false);
            Eval(14878, o is NotEmptyClassGen<Guid>[], false);
            Eval(14879, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(14880, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(14881, o is NestedClass, false);
            Eval(14882, o is NestedClass[], false);
            Eval(14883, o is NestedClassGen<Decimal>, false);
            Eval(14884, o is NestedClassGen<Decimal>[], false);
            Eval(14885, o is ImplementOneInterfaceC, false);
            Eval(14886, o is ImplementOneInterfaceC[], false);
            Eval(14887, o is ImplementTwoInterfaceC, false);
            Eval(14888, o is ImplementTwoInterfaceC[], false);
            Eval(14889, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(14890, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(14891, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(14892, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(14893, o is ImplementAllInterfaceC<int>, false);
            Eval(14894, o is ImplementAllInterfaceC<int>[], false);
            Eval(14895, o is SealedClass, false);
            Eval(14896, o is SealedClass[], false);
        }
        {
            int? v = default(int);
            ValueType o = v;
            Eval(14897, o is EmptyStruct, false);
            Eval(14898, o is EmptyStruct[], false);
            Eval(14899, o is EmptyStruct?, false);
            Eval(14900, o is EmptyStruct?[], false);
            Eval(14901, o is NotEmptyStruct, false);
            Eval(14902, o is NotEmptyStruct[], false);
            Eval(14903, o is NotEmptyStruct?, false);
            Eval(14904, o is NotEmptyStruct?[], false);
            Eval(14905, o is EmptyStructGen<int>, false);
            Eval(14906, o is EmptyStructGen<int>[], false);
            Eval(14907, o is EmptyStructGen<int>?, false);
            Eval(14908, o is EmptyStructGen<int>?[], false);
            Eval(14909, o is NotEmptyStructGen<Guid>, false);
            Eval(14910, o is NotEmptyStructGen<Guid>[], false);
            Eval(14911, o is NotEmptyStructGen<Guid>?, false);
            Eval(14912, o is NotEmptyStructGen<Guid>?[], false);
            Eval(14913, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(14914, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(14915, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(14916, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(14917, o is NestedStruct, false);
            Eval(14918, o is NestedStruct[], false);
            Eval(14919, o is NestedStruct?, false);
            Eval(14920, o is NestedStruct?[], false);
            Eval(14921, o is NestedStructGen<Decimal>, false);
            Eval(14922, o is NestedStructGen<Decimal>[], false);
            Eval(14923, o is NestedStructGen<Decimal>?, false);
            Eval(14924, o is NestedStructGen<Decimal>?[], false);
            Eval(14925, o is ExplicitFieldOffsetStruct, false);
            Eval(14926, o is ExplicitFieldOffsetStruct[], false);
            Eval(14927, o is ExplicitFieldOffsetStruct?, false);
            Eval(14928, o is ExplicitFieldOffsetStruct?[], false);
            Eval(14937, o is MarshalAsStruct, false);
            Eval(14938, o is MarshalAsStruct[], false);
            Eval(14939, o is MarshalAsStruct?, false);
            Eval(14940, o is MarshalAsStruct?[], false);
            Eval(14941, o is ImplementOneInterface, false);
            Eval(14942, o is ImplementOneInterface[], false);
            Eval(14943, o is ImplementOneInterface?, false);
            Eval(14944, o is ImplementOneInterface?[], false);
            Eval(14945, o is ImplementTwoInterface, false);
            Eval(14946, o is ImplementTwoInterface[], false);
            Eval(14947, o is ImplementTwoInterface?, false);
            Eval(14948, o is ImplementTwoInterface?[], false);
            Eval(14949, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(14950, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(14951, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(14952, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(14953, o is ImplementTwoInterfaceGen<int>, false);
            Eval(14954, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(14955, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(14956, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(14957, o is ImplementAllInterface<int>, false);
            Eval(14958, o is ImplementAllInterface<int>[], false);
            Eval(14959, o is ImplementAllInterface<int>?, false);
            Eval(14960, o is ImplementAllInterface<int>?[], false);
            Eval(14961, o is IntE, false);
            Eval(14962, o is IntE[], false);
            Eval(14963, o is IntE?, false);
            Eval(14964, o is IntE?[], false);
            Eval(14965, o is ByteE, false);
            Eval(14966, o is ByteE[], false);
            Eval(14967, o is ByteE?, false);
            Eval(14968, o is ByteE?[], false);
            Eval(14969, o is LongE, false);
            Eval(14970, o is LongE[], false);
            Eval(14971, o is LongE?, false);
            Eval(14972, o is LongE?[], false);
            Eval(14973, o is char, false);
            Eval(14974, o is char[], false);
            Eval(14975, o is char?, false);
            Eval(14976, o is char?[], false);
            Eval(14977, o is bool, false);
            Eval(14978, o is bool[], false);
            Eval(14979, o is bool?, false);
            Eval(14980, o is bool?[], false);
            Eval(14981, o is byte, false);
            Eval(14982, o is byte[], false);
            Eval(14983, o is byte?, false);
            Eval(14984, o is byte?[], false);
            Eval(14985, o is sbyte, false);
            Eval(14986, o is sbyte[], false);
            Eval(14987, o is sbyte?, false);
            Eval(14988, o is sbyte?[], false);
            Eval(14989, o is short, false);
            Eval(14990, o is short[], false);
            Eval(14991, o is short?, false);
            Eval(14992, o is short?[], false);
            Eval(14993, o is ushort, false);
            Eval(14994, o is ushort[], false);
            Eval(14995, o is ushort?, false);
            Eval(14996, o is ushort?[], false);
            Eval(14997, o is int, true);
            Eval(14998, o is int[], false);
            Eval(14999, o is int?, true);
            Eval(15000, o is int?[], false);
            Eval(15001, o is uint, false);
            Eval(15002, o is uint[], false);
            Eval(15003, o is uint?, false);
            Eval(15004, o is uint?[], false);
            Eval(15005, o is long, false);
            Eval(15006, o is long[], false);
            Eval(15007, o is long?, false);
            Eval(15008, o is long?[], false);
            Eval(15009, o is ulong, false);
            Eval(15010, o is ulong[], false);
            Eval(15011, o is ulong?, false);
            Eval(15012, o is ulong?[], false);
            Eval(15013, o is float, false);
            Eval(15014, o is float[], false);
            Eval(15015, o is float?, false);
            Eval(15016, o is float?[], false);
            Eval(15017, o is double, false);
            Eval(15018, o is double[], false);
            Eval(15019, o is double?, false);
            Eval(15020, o is double?[], false);
            Eval(15021, o is decimal, false);
            Eval(15022, o is decimal[], false);
            Eval(15023, o is decimal?, false);
            Eval(15024, o is decimal?[], false);
            Eval(15025, o is IntPtr, false);
            Eval(15026, o is IntPtr[], false);
            Eval(15027, o is IntPtr?, false);
            Eval(15028, o is IntPtr?[], false);
            Eval(15029, o is UIntPtr, false);
            Eval(15030, o is UIntPtr[], false);
            Eval(15031, o is UIntPtr?, false);
            Eval(15032, o is UIntPtr?[], false);
            Eval(15033, o is Guid, false);
            Eval(15034, o is Guid[], false);
            Eval(15035, o is Guid?, false);
            Eval(15036, o is Guid?[], false);
            Eval(15037, o is GCHandle, false);
            Eval(15038, o is GCHandle[], false);
            Eval(15039, o is GCHandle?, false);
            Eval(15040, o is GCHandle?[], false);
            Eval(15041, o is object, true);
            Eval(15042, o is object[], false);
            Eval(15043, o is string, false);
            Eval(15044, o is string[], false);
            Eval(15045, o is ValueType, true);
            Eval(15046, o is ValueType[], false);
            Eval(15047, o is Array, false);
            Eval(15048, o is Array[], false);
            Eval(15049, o is Enum, false);
            Eval(15050, o is Enum[], false);
            Eval(15051, o is Delegate, false);
            Eval(15052, o is Delegate[], false);
            Eval(15053, o is MulticastDelegate, false);
            Eval(15054, o is MulticastDelegate[], false);
            Eval(15055, o is IEmpty, false);
            Eval(15056, o is IEmpty[], false);
            Eval(15057, o is INotEmpty, false);
            Eval(15058, o is INotEmpty[], false);
            Eval(15059, o is IEmptyGen<int>, false);
            Eval(15060, o is IEmptyGen<int>[], false);
            Eval(15061, o is INotEmptyGen<int>, false);
            Eval(15062, o is INotEmptyGen<int>[], false);
            Eval(15063, o is SimpleDelegate, false);
            Eval(15064, o is SimpleDelegate[], false);
            Eval(15065, o is GenericDelegate<int>, false);
            Eval(15066, o is GenericDelegate<int>[], false);
            Eval(15067, o is EmptyClass, false);
            Eval(15068, o is EmptyClass[], false);
            Eval(15069, o is NotEmptyClass, false);
            Eval(15070, o is NotEmptyClass[], false);
            Eval(15071, o is EmptyClassGen<int>, false);
            Eval(15072, o is EmptyClassGen<int>[], false);
            Eval(15073, o is NotEmptyClassGen<Guid>, false);
            Eval(15074, o is NotEmptyClassGen<Guid>[], false);
            Eval(15075, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(15076, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(15077, o is NestedClass, false);
            Eval(15078, o is NestedClass[], false);
            Eval(15079, o is NestedClassGen<Decimal>, false);
            Eval(15080, o is NestedClassGen<Decimal>[], false);
            Eval(15081, o is ImplementOneInterfaceC, false);
            Eval(15082, o is ImplementOneInterfaceC[], false);
            Eval(15083, o is ImplementTwoInterfaceC, false);
            Eval(15084, o is ImplementTwoInterfaceC[], false);
            Eval(15085, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(15086, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(15087, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(15088, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(15089, o is ImplementAllInterfaceC<int>, false);
            Eval(15090, o is ImplementAllInterfaceC<int>[], false);
            Eval(15091, o is SealedClass, false);
            Eval(15092, o is SealedClass[], false);
        }
        {
            int? v = default(int?);
            ValueType o = v;
            Eval(15093, o is EmptyStruct, false);
            Eval(15094, o is EmptyStruct[], false);
            Eval(15095, o is EmptyStruct?, false);
            Eval(15096, o is EmptyStruct?[], false);
            Eval(15097, o is NotEmptyStruct, false);
            Eval(15098, o is NotEmptyStruct[], false);
            Eval(15099, o is NotEmptyStruct?, false);
            Eval(15100, o is NotEmptyStruct?[], false);
            Eval(15101, o is EmptyStructGen<int>, false);
            Eval(15102, o is EmptyStructGen<int>[], false);
            Eval(15103, o is EmptyStructGen<int>?, false);
            Eval(15104, o is EmptyStructGen<int>?[], false);
            Eval(15105, o is NotEmptyStructGen<Guid>, false);
            Eval(15106, o is NotEmptyStructGen<Guid>[], false);
            Eval(15107, o is NotEmptyStructGen<Guid>?, false);
            Eval(15108, o is NotEmptyStructGen<Guid>?[], false);
            Eval(15109, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(15110, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(15111, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(15112, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(15113, o is NestedStruct, false);
            Eval(15114, o is NestedStruct[], false);
            Eval(15115, o is NestedStruct?, false);
            Eval(15116, o is NestedStruct?[], false);
            Eval(15117, o is NestedStructGen<Decimal>, false);
            Eval(15118, o is NestedStructGen<Decimal>[], false);
            Eval(15119, o is NestedStructGen<Decimal>?, false);
            Eval(15120, o is NestedStructGen<Decimal>?[], false);
            Eval(15121, o is ExplicitFieldOffsetStruct, false);
            Eval(15122, o is ExplicitFieldOffsetStruct[], false);
            Eval(15123, o is ExplicitFieldOffsetStruct?, false);
            Eval(15124, o is ExplicitFieldOffsetStruct?[], false);
            Eval(15133, o is MarshalAsStruct, false);
            Eval(15134, o is MarshalAsStruct[], false);
            Eval(15135, o is MarshalAsStruct?, false);
            Eval(15136, o is MarshalAsStruct?[], false);
            Eval(15137, o is ImplementOneInterface, false);
            Eval(15138, o is ImplementOneInterface[], false);
            Eval(15139, o is ImplementOneInterface?, false);
            Eval(15140, o is ImplementOneInterface?[], false);
            Eval(15141, o is ImplementTwoInterface, false);
            Eval(15142, o is ImplementTwoInterface[], false);
            Eval(15143, o is ImplementTwoInterface?, false);
            Eval(15144, o is ImplementTwoInterface?[], false);
            Eval(15145, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(15146, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(15147, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(15148, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(15149, o is ImplementTwoInterfaceGen<int>, false);
            Eval(15150, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(15151, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(15152, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(15153, o is ImplementAllInterface<int>, false);
            Eval(15154, o is ImplementAllInterface<int>[], false);
            Eval(15155, o is ImplementAllInterface<int>?, false);
            Eval(15156, o is ImplementAllInterface<int>?[], false);
            Eval(15157, o is IntE, false);
            Eval(15158, o is IntE[], false);
            Eval(15159, o is IntE?, false);
            Eval(15160, o is IntE?[], false);
            Eval(15161, o is ByteE, false);
            Eval(15162, o is ByteE[], false);
            Eval(15163, o is ByteE?, false);
            Eval(15164, o is ByteE?[], false);
            Eval(15165, o is LongE, false);
            Eval(15166, o is LongE[], false);
            Eval(15167, o is LongE?, false);
            Eval(15168, o is LongE?[], false);
            Eval(15169, o is char, false);
            Eval(15170, o is char[], false);
            Eval(15171, o is char?, false);
            Eval(15172, o is char?[], false);
            Eval(15173, o is bool, false);
            Eval(15174, o is bool[], false);
            Eval(15175, o is bool?, false);
            Eval(15176, o is bool?[], false);
            Eval(15177, o is byte, false);
            Eval(15178, o is byte[], false);
            Eval(15179, o is byte?, false);
            Eval(15180, o is byte?[], false);
            Eval(15181, o is sbyte, false);
            Eval(15182, o is sbyte[], false);
            Eval(15183, o is sbyte?, false);
            Eval(15184, o is sbyte?[], false);
            Eval(15185, o is short, false);
            Eval(15186, o is short[], false);
            Eval(15187, o is short?, false);
            Eval(15188, o is short?[], false);
            Eval(15189, o is ushort, false);
            Eval(15190, o is ushort[], false);
            Eval(15191, o is ushort?, false);
            Eval(15192, o is ushort?[], false);
            Eval(15193, o is int, false);
            Eval(15194, o is int[], false);
            Eval(15195, o is int?, false);
            Eval(15196, o is int?[], false);
            Eval(15197, o is uint, false);
            Eval(15198, o is uint[], false);
            Eval(15199, o is uint?, false);
            Eval(15200, o is uint?[], false);
            Eval(15201, o is long, false);
            Eval(15202, o is long[], false);
            Eval(15203, o is long?, false);
            Eval(15204, o is long?[], false);
            Eval(15205, o is ulong, false);
            Eval(15206, o is ulong[], false);
            Eval(15207, o is ulong?, false);
            Eval(15208, o is ulong?[], false);
            Eval(15209, o is float, false);
            Eval(15210, o is float[], false);
            Eval(15211, o is float?, false);
            Eval(15212, o is float?[], false);
            Eval(15213, o is double, false);
            Eval(15214, o is double[], false);
            Eval(15215, o is double?, false);
            Eval(15216, o is double?[], false);
            Eval(15217, o is decimal, false);
            Eval(15218, o is decimal[], false);
            Eval(15219, o is decimal?, false);
            Eval(15220, o is decimal?[], false);
            Eval(15221, o is IntPtr, false);
            Eval(15222, o is IntPtr[], false);
            Eval(15223, o is IntPtr?, false);
            Eval(15224, o is IntPtr?[], false);
            Eval(15225, o is UIntPtr, false);
            Eval(15226, o is UIntPtr[], false);
            Eval(15227, o is UIntPtr?, false);
            Eval(15228, o is UIntPtr?[], false);
            Eval(15229, o is Guid, false);
            Eval(15230, o is Guid[], false);
            Eval(15231, o is Guid?, false);
            Eval(15232, o is Guid?[], false);
            Eval(15233, o is GCHandle, false);
            Eval(15234, o is GCHandle[], false);
            Eval(15235, o is GCHandle?, false);
            Eval(15236, o is GCHandle?[], false);
            Eval(15237, o is object, false);
            Eval(15238, o is object[], false);
            Eval(15239, o is string, false);
            Eval(15240, o is string[], false);
            Eval(15241, o is ValueType, false);
            Eval(15242, o is ValueType[], false);
            Eval(15243, o is Array, false);
            Eval(15244, o is Array[], false);
            Eval(15245, o is Enum, false);
            Eval(15246, o is Enum[], false);
            Eval(15247, o is Delegate, false);
            Eval(15248, o is Delegate[], false);
            Eval(15249, o is MulticastDelegate, false);
            Eval(15250, o is MulticastDelegate[], false);
            Eval(15251, o is IEmpty, false);
            Eval(15252, o is IEmpty[], false);
            Eval(15253, o is INotEmpty, false);
            Eval(15254, o is INotEmpty[], false);
            Eval(15255, o is IEmptyGen<int>, false);
            Eval(15256, o is IEmptyGen<int>[], false);
            Eval(15257, o is INotEmptyGen<int>, false);
            Eval(15258, o is INotEmptyGen<int>[], false);
            Eval(15259, o is SimpleDelegate, false);
            Eval(15260, o is SimpleDelegate[], false);
            Eval(15261, o is GenericDelegate<int>, false);
            Eval(15262, o is GenericDelegate<int>[], false);
            Eval(15263, o is EmptyClass, false);
            Eval(15264, o is EmptyClass[], false);
            Eval(15265, o is NotEmptyClass, false);
            Eval(15266, o is NotEmptyClass[], false);
            Eval(15267, o is EmptyClassGen<int>, false);
            Eval(15268, o is EmptyClassGen<int>[], false);
            Eval(15269, o is NotEmptyClassGen<Guid>, false);
            Eval(15270, o is NotEmptyClassGen<Guid>[], false);
            Eval(15271, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(15272, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(15273, o is NestedClass, false);
            Eval(15274, o is NestedClass[], false);
            Eval(15275, o is NestedClassGen<Decimal>, false);
            Eval(15276, o is NestedClassGen<Decimal>[], false);
            Eval(15277, o is ImplementOneInterfaceC, false);
            Eval(15278, o is ImplementOneInterfaceC[], false);
            Eval(15279, o is ImplementTwoInterfaceC, false);
            Eval(15280, o is ImplementTwoInterfaceC[], false);
            Eval(15281, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(15282, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(15283, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(15284, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(15285, o is ImplementAllInterfaceC<int>, false);
            Eval(15286, o is ImplementAllInterfaceC<int>[], false);
            Eval(15287, o is SealedClass, false);
            Eval(15288, o is SealedClass[], false);
        }
    }  // end of test case 0026
    private static void TestCase0027()
    {
        {
            uint v = default(uint);
            ValueType o = v;
            Eval(15289, o is EmptyStruct, false);
            Eval(15290, o is EmptyStruct[], false);
            Eval(15291, o is EmptyStruct?, false);
            Eval(15292, o is EmptyStruct?[], false);
            Eval(15293, o is NotEmptyStruct, false);
            Eval(15294, o is NotEmptyStruct[], false);
            Eval(15295, o is NotEmptyStruct?, false);
            Eval(15296, o is NotEmptyStruct?[], false);
            Eval(15297, o is EmptyStructGen<int>, false);
            Eval(15298, o is EmptyStructGen<int>[], false);
            Eval(15299, o is EmptyStructGen<int>?, false);
            Eval(15300, o is EmptyStructGen<int>?[], false);
            Eval(15301, o is NotEmptyStructGen<Guid>, false);
            Eval(15302, o is NotEmptyStructGen<Guid>[], false);
            Eval(15303, o is NotEmptyStructGen<Guid>?, false);
            Eval(15304, o is NotEmptyStructGen<Guid>?[], false);
            Eval(15305, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(15306, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(15307, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(15308, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(15309, o is NestedStruct, false);
            Eval(15310, o is NestedStruct[], false);
            Eval(15311, o is NestedStruct?, false);
            Eval(15312, o is NestedStruct?[], false);
            Eval(15313, o is NestedStructGen<Decimal>, false);
            Eval(15314, o is NestedStructGen<Decimal>[], false);
            Eval(15315, o is NestedStructGen<Decimal>?, false);
            Eval(15316, o is NestedStructGen<Decimal>?[], false);
            Eval(15317, o is ExplicitFieldOffsetStruct, false);
            Eval(15318, o is ExplicitFieldOffsetStruct[], false);
            Eval(15319, o is ExplicitFieldOffsetStruct?, false);
            Eval(15320, o is ExplicitFieldOffsetStruct?[], false);
            Eval(15329, o is MarshalAsStruct, false);
            Eval(15330, o is MarshalAsStruct[], false);
            Eval(15331, o is MarshalAsStruct?, false);
            Eval(15332, o is MarshalAsStruct?[], false);
            Eval(15333, o is ImplementOneInterface, false);
            Eval(15334, o is ImplementOneInterface[], false);
            Eval(15335, o is ImplementOneInterface?, false);
            Eval(15336, o is ImplementOneInterface?[], false);
            Eval(15337, o is ImplementTwoInterface, false);
            Eval(15338, o is ImplementTwoInterface[], false);
            Eval(15339, o is ImplementTwoInterface?, false);
            Eval(15340, o is ImplementTwoInterface?[], false);
            Eval(15341, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(15342, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(15343, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(15344, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(15345, o is ImplementTwoInterfaceGen<int>, false);
            Eval(15346, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(15347, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(15348, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(15349, o is ImplementAllInterface<int>, false);
            Eval(15350, o is ImplementAllInterface<int>[], false);
            Eval(15351, o is ImplementAllInterface<int>?, false);
            Eval(15352, o is ImplementAllInterface<int>?[], false);
            Eval(15353, o is IntE, false);
            Eval(15354, o is IntE[], false);
            Eval(15355, o is IntE?, false);
            Eval(15356, o is IntE?[], false);
            Eval(15357, o is ByteE, false);
            Eval(15358, o is ByteE[], false);
            Eval(15359, o is ByteE?, false);
            Eval(15360, o is ByteE?[], false);
            Eval(15361, o is LongE, false);
            Eval(15362, o is LongE[], false);
            Eval(15363, o is LongE?, false);
            Eval(15364, o is LongE?[], false);
            Eval(15365, o is char, false);
            Eval(15366, o is char[], false);
            Eval(15367, o is char?, false);
            Eval(15368, o is char?[], false);
            Eval(15369, o is bool, false);
            Eval(15370, o is bool[], false);
            Eval(15371, o is bool?, false);
            Eval(15372, o is bool?[], false);
            Eval(15373, o is byte, false);
            Eval(15374, o is byte[], false);
            Eval(15375, o is byte?, false);
            Eval(15376, o is byte?[], false);
            Eval(15377, o is sbyte, false);
            Eval(15378, o is sbyte[], false);
            Eval(15379, o is sbyte?, false);
            Eval(15380, o is sbyte?[], false);
            Eval(15381, o is short, false);
            Eval(15382, o is short[], false);
            Eval(15383, o is short?, false);
            Eval(15384, o is short?[], false);
            Eval(15385, o is ushort, false);
            Eval(15386, o is ushort[], false);
            Eval(15387, o is ushort?, false);
            Eval(15388, o is ushort?[], false);
            Eval(15389, o is int, false);
            Eval(15390, o is int[], false);
            Eval(15391, o is int?, false);
            Eval(15392, o is int?[], false);
            Eval(15393, o is uint, true);
            Eval(15394, o is uint[], false);
            Eval(15395, o is uint?, true);
            Eval(15396, o is uint?[], false);
            Eval(15397, o is long, false);
            Eval(15398, o is long[], false);
            Eval(15399, o is long?, false);
            Eval(15400, o is long?[], false);
            Eval(15401, o is ulong, false);
            Eval(15402, o is ulong[], false);
            Eval(15403, o is ulong?, false);
            Eval(15404, o is ulong?[], false);
            Eval(15405, o is float, false);
            Eval(15406, o is float[], false);
            Eval(15407, o is float?, false);
            Eval(15408, o is float?[], false);
            Eval(15409, o is double, false);
            Eval(15410, o is double[], false);
            Eval(15411, o is double?, false);
            Eval(15412, o is double?[], false);
            Eval(15413, o is decimal, false);
            Eval(15414, o is decimal[], false);
            Eval(15415, o is decimal?, false);
            Eval(15416, o is decimal?[], false);
            Eval(15417, o is IntPtr, false);
            Eval(15418, o is IntPtr[], false);
            Eval(15419, o is IntPtr?, false);
            Eval(15420, o is IntPtr?[], false);
            Eval(15421, o is UIntPtr, false);
            Eval(15422, o is UIntPtr[], false);
            Eval(15423, o is UIntPtr?, false);
            Eval(15424, o is UIntPtr?[], false);
            Eval(15425, o is Guid, false);
            Eval(15426, o is Guid[], false);
            Eval(15427, o is Guid?, false);
            Eval(15428, o is Guid?[], false);
            Eval(15429, o is GCHandle, false);
            Eval(15430, o is GCHandle[], false);
            Eval(15431, o is GCHandle?, false);
            Eval(15432, o is GCHandle?[], false);
            Eval(15433, o is object, true);
            Eval(15434, o is object[], false);
            Eval(15435, o is string, false);
            Eval(15436, o is string[], false);
            Eval(15437, o is ValueType, true);
            Eval(15438, o is ValueType[], false);
            Eval(15439, o is Array, false);
            Eval(15440, o is Array[], false);
            Eval(15441, o is Enum, false);
            Eval(15442, o is Enum[], false);
            Eval(15443, o is Delegate, false);
            Eval(15444, o is Delegate[], false);
            Eval(15445, o is MulticastDelegate, false);
            Eval(15446, o is MulticastDelegate[], false);
            Eval(15447, o is IEmpty, false);
            Eval(15448, o is IEmpty[], false);
            Eval(15449, o is INotEmpty, false);
            Eval(15450, o is INotEmpty[], false);
            Eval(15451, o is IEmptyGen<int>, false);
            Eval(15452, o is IEmptyGen<int>[], false);
            Eval(15453, o is INotEmptyGen<int>, false);
            Eval(15454, o is INotEmptyGen<int>[], false);
            Eval(15455, o is SimpleDelegate, false);
            Eval(15456, o is SimpleDelegate[], false);
            Eval(15457, o is GenericDelegate<int>, false);
            Eval(15458, o is GenericDelegate<int>[], false);
            Eval(15459, o is EmptyClass, false);
            Eval(15460, o is EmptyClass[], false);
            Eval(15461, o is NotEmptyClass, false);
            Eval(15462, o is NotEmptyClass[], false);
            Eval(15463, o is EmptyClassGen<int>, false);
            Eval(15464, o is EmptyClassGen<int>[], false);
            Eval(15465, o is NotEmptyClassGen<Guid>, false);
            Eval(15466, o is NotEmptyClassGen<Guid>[], false);
            Eval(15467, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(15468, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(15469, o is NestedClass, false);
            Eval(15470, o is NestedClass[], false);
            Eval(15471, o is NestedClassGen<Decimal>, false);
            Eval(15472, o is NestedClassGen<Decimal>[], false);
            Eval(15473, o is ImplementOneInterfaceC, false);
            Eval(15474, o is ImplementOneInterfaceC[], false);
            Eval(15475, o is ImplementTwoInterfaceC, false);
            Eval(15476, o is ImplementTwoInterfaceC[], false);
            Eval(15477, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(15478, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(15479, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(15480, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(15481, o is ImplementAllInterfaceC<int>, false);
            Eval(15482, o is ImplementAllInterfaceC<int>[], false);
            Eval(15483, o is SealedClass, false);
            Eval(15484, o is SealedClass[], false);
        }
        {
            uint? v = default(uint);
            ValueType o = v;
            Eval(15485, o is EmptyStruct, false);
            Eval(15486, o is EmptyStruct[], false);
            Eval(15487, o is EmptyStruct?, false);
            Eval(15488, o is EmptyStruct?[], false);
            Eval(15489, o is NotEmptyStruct, false);
            Eval(15490, o is NotEmptyStruct[], false);
            Eval(15491, o is NotEmptyStruct?, false);
            Eval(15492, o is NotEmptyStruct?[], false);
            Eval(15493, o is EmptyStructGen<int>, false);
            Eval(15494, o is EmptyStructGen<int>[], false);
            Eval(15495, o is EmptyStructGen<int>?, false);
            Eval(15496, o is EmptyStructGen<int>?[], false);
            Eval(15497, o is NotEmptyStructGen<Guid>, false);
            Eval(15498, o is NotEmptyStructGen<Guid>[], false);
            Eval(15499, o is NotEmptyStructGen<Guid>?, false);
            Eval(15500, o is NotEmptyStructGen<Guid>?[], false);
            Eval(15501, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(15502, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(15503, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(15504, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(15505, o is NestedStruct, false);
            Eval(15506, o is NestedStruct[], false);
            Eval(15507, o is NestedStruct?, false);
            Eval(15508, o is NestedStruct?[], false);
            Eval(15509, o is NestedStructGen<Decimal>, false);
            Eval(15510, o is NestedStructGen<Decimal>[], false);
            Eval(15511, o is NestedStructGen<Decimal>?, false);
            Eval(15512, o is NestedStructGen<Decimal>?[], false);
            Eval(15513, o is ExplicitFieldOffsetStruct, false);
            Eval(15514, o is ExplicitFieldOffsetStruct[], false);
            Eval(15515, o is ExplicitFieldOffsetStruct?, false);
            Eval(15516, o is ExplicitFieldOffsetStruct?[], false);
            Eval(15525, o is MarshalAsStruct, false);
            Eval(15526, o is MarshalAsStruct[], false);
            Eval(15527, o is MarshalAsStruct?, false);
            Eval(15528, o is MarshalAsStruct?[], false);
            Eval(15529, o is ImplementOneInterface, false);
            Eval(15530, o is ImplementOneInterface[], false);
            Eval(15531, o is ImplementOneInterface?, false);
            Eval(15532, o is ImplementOneInterface?[], false);
            Eval(15533, o is ImplementTwoInterface, false);
            Eval(15534, o is ImplementTwoInterface[], false);
            Eval(15535, o is ImplementTwoInterface?, false);
            Eval(15536, o is ImplementTwoInterface?[], false);
            Eval(15537, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(15538, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(15539, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(15540, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(15541, o is ImplementTwoInterfaceGen<int>, false);
            Eval(15542, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(15543, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(15544, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(15545, o is ImplementAllInterface<int>, false);
            Eval(15546, o is ImplementAllInterface<int>[], false);
            Eval(15547, o is ImplementAllInterface<int>?, false);
            Eval(15548, o is ImplementAllInterface<int>?[], false);
            Eval(15549, o is IntE, false);
            Eval(15550, o is IntE[], false);
            Eval(15551, o is IntE?, false);
            Eval(15552, o is IntE?[], false);
            Eval(15553, o is ByteE, false);
            Eval(15554, o is ByteE[], false);
            Eval(15555, o is ByteE?, false);
            Eval(15556, o is ByteE?[], false);
            Eval(15557, o is LongE, false);
            Eval(15558, o is LongE[], false);
            Eval(15559, o is LongE?, false);
            Eval(15560, o is LongE?[], false);
            Eval(15561, o is char, false);
            Eval(15562, o is char[], false);
            Eval(15563, o is char?, false);
            Eval(15564, o is char?[], false);
            Eval(15565, o is bool, false);
            Eval(15566, o is bool[], false);
            Eval(15567, o is bool?, false);
            Eval(15568, o is bool?[], false);
            Eval(15569, o is byte, false);
            Eval(15570, o is byte[], false);
            Eval(15571, o is byte?, false);
            Eval(15572, o is byte?[], false);
            Eval(15573, o is sbyte, false);
            Eval(15574, o is sbyte[], false);
            Eval(15575, o is sbyte?, false);
            Eval(15576, o is sbyte?[], false);
            Eval(15577, o is short, false);
            Eval(15578, o is short[], false);
            Eval(15579, o is short?, false);
            Eval(15580, o is short?[], false);
            Eval(15581, o is ushort, false);
            Eval(15582, o is ushort[], false);
            Eval(15583, o is ushort?, false);
            Eval(15584, o is ushort?[], false);
            Eval(15585, o is int, false);
            Eval(15586, o is int[], false);
            Eval(15587, o is int?, false);
            Eval(15588, o is int?[], false);
            Eval(15589, o is uint, true);
            Eval(15590, o is uint[], false);
            Eval(15591, o is uint?, true);
            Eval(15592, o is uint?[], false);
            Eval(15593, o is long, false);
            Eval(15594, o is long[], false);
            Eval(15595, o is long?, false);
            Eval(15596, o is long?[], false);
            Eval(15597, o is ulong, false);
            Eval(15598, o is ulong[], false);
            Eval(15599, o is ulong?, false);
            Eval(15600, o is ulong?[], false);
            Eval(15601, o is float, false);
            Eval(15602, o is float[], false);
            Eval(15603, o is float?, false);
            Eval(15604, o is float?[], false);
            Eval(15605, o is double, false);
            Eval(15606, o is double[], false);
            Eval(15607, o is double?, false);
            Eval(15608, o is double?[], false);
            Eval(15609, o is decimal, false);
            Eval(15610, o is decimal[], false);
            Eval(15611, o is decimal?, false);
            Eval(15612, o is decimal?[], false);
            Eval(15613, o is IntPtr, false);
            Eval(15614, o is IntPtr[], false);
            Eval(15615, o is IntPtr?, false);
            Eval(15616, o is IntPtr?[], false);
            Eval(15617, o is UIntPtr, false);
            Eval(15618, o is UIntPtr[], false);
            Eval(15619, o is UIntPtr?, false);
            Eval(15620, o is UIntPtr?[], false);
            Eval(15621, o is Guid, false);
            Eval(15622, o is Guid[], false);
            Eval(15623, o is Guid?, false);
            Eval(15624, o is Guid?[], false);
            Eval(15625, o is GCHandle, false);
            Eval(15626, o is GCHandle[], false);
            Eval(15627, o is GCHandle?, false);
            Eval(15628, o is GCHandle?[], false);
            Eval(15629, o is object, true);
            Eval(15630, o is object[], false);
            Eval(15631, o is string, false);
            Eval(15632, o is string[], false);
            Eval(15633, o is ValueType, true);
            Eval(15634, o is ValueType[], false);
            Eval(15635, o is Array, false);
            Eval(15636, o is Array[], false);
            Eval(15637, o is Enum, false);
            Eval(15638, o is Enum[], false);
            Eval(15639, o is Delegate, false);
            Eval(15640, o is Delegate[], false);
            Eval(15641, o is MulticastDelegate, false);
            Eval(15642, o is MulticastDelegate[], false);
            Eval(15643, o is IEmpty, false);
            Eval(15644, o is IEmpty[], false);
            Eval(15645, o is INotEmpty, false);
            Eval(15646, o is INotEmpty[], false);
            Eval(15647, o is IEmptyGen<int>, false);
            Eval(15648, o is IEmptyGen<int>[], false);
            Eval(15649, o is INotEmptyGen<int>, false);
            Eval(15650, o is INotEmptyGen<int>[], false);
            Eval(15651, o is SimpleDelegate, false);
            Eval(15652, o is SimpleDelegate[], false);
            Eval(15653, o is GenericDelegate<int>, false);
            Eval(15654, o is GenericDelegate<int>[], false);
            Eval(15655, o is EmptyClass, false);
            Eval(15656, o is EmptyClass[], false);
            Eval(15657, o is NotEmptyClass, false);
            Eval(15658, o is NotEmptyClass[], false);
            Eval(15659, o is EmptyClassGen<int>, false);
            Eval(15660, o is EmptyClassGen<int>[], false);
            Eval(15661, o is NotEmptyClassGen<Guid>, false);
            Eval(15662, o is NotEmptyClassGen<Guid>[], false);
            Eval(15663, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(15664, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(15665, o is NestedClass, false);
            Eval(15666, o is NestedClass[], false);
            Eval(15667, o is NestedClassGen<Decimal>, false);
            Eval(15668, o is NestedClassGen<Decimal>[], false);
            Eval(15669, o is ImplementOneInterfaceC, false);
            Eval(15670, o is ImplementOneInterfaceC[], false);
            Eval(15671, o is ImplementTwoInterfaceC, false);
            Eval(15672, o is ImplementTwoInterfaceC[], false);
            Eval(15673, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(15674, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(15675, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(15676, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(15677, o is ImplementAllInterfaceC<int>, false);
            Eval(15678, o is ImplementAllInterfaceC<int>[], false);
            Eval(15679, o is SealedClass, false);
            Eval(15680, o is SealedClass[], false);
        }
        {
            uint? v = default(uint?);
            ValueType o = v;
            Eval(15681, o is EmptyStruct, false);
            Eval(15682, o is EmptyStruct[], false);
            Eval(15683, o is EmptyStruct?, false);
            Eval(15684, o is EmptyStruct?[], false);
            Eval(15685, o is NotEmptyStruct, false);
            Eval(15686, o is NotEmptyStruct[], false);
            Eval(15687, o is NotEmptyStruct?, false);
            Eval(15688, o is NotEmptyStruct?[], false);
            Eval(15689, o is EmptyStructGen<int>, false);
            Eval(15690, o is EmptyStructGen<int>[], false);
            Eval(15691, o is EmptyStructGen<int>?, false);
            Eval(15692, o is EmptyStructGen<int>?[], false);
            Eval(15693, o is NotEmptyStructGen<Guid>, false);
            Eval(15694, o is NotEmptyStructGen<Guid>[], false);
            Eval(15695, o is NotEmptyStructGen<Guid>?, false);
            Eval(15696, o is NotEmptyStructGen<Guid>?[], false);
            Eval(15697, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(15698, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(15699, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(15700, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(15701, o is NestedStruct, false);
            Eval(15702, o is NestedStruct[], false);
            Eval(15703, o is NestedStruct?, false);
            Eval(15704, o is NestedStruct?[], false);
            Eval(15705, o is NestedStructGen<Decimal>, false);
            Eval(15706, o is NestedStructGen<Decimal>[], false);
            Eval(15707, o is NestedStructGen<Decimal>?, false);
            Eval(15708, o is NestedStructGen<Decimal>?[], false);
            Eval(15709, o is ExplicitFieldOffsetStruct, false);
            Eval(15710, o is ExplicitFieldOffsetStruct[], false);
            Eval(15711, o is ExplicitFieldOffsetStruct?, false);
            Eval(15712, o is ExplicitFieldOffsetStruct?[], false);
            Eval(15721, o is MarshalAsStruct, false);
            Eval(15722, o is MarshalAsStruct[], false);
            Eval(15723, o is MarshalAsStruct?, false);
            Eval(15724, o is MarshalAsStruct?[], false);
            Eval(15725, o is ImplementOneInterface, false);
            Eval(15726, o is ImplementOneInterface[], false);
            Eval(15727, o is ImplementOneInterface?, false);
            Eval(15728, o is ImplementOneInterface?[], false);
            Eval(15729, o is ImplementTwoInterface, false);
            Eval(15730, o is ImplementTwoInterface[], false);
            Eval(15731, o is ImplementTwoInterface?, false);
            Eval(15732, o is ImplementTwoInterface?[], false);
            Eval(15733, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(15734, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(15735, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(15736, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(15737, o is ImplementTwoInterfaceGen<int>, false);
            Eval(15738, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(15739, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(15740, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(15741, o is ImplementAllInterface<int>, false);
            Eval(15742, o is ImplementAllInterface<int>[], false);
            Eval(15743, o is ImplementAllInterface<int>?, false);
            Eval(15744, o is ImplementAllInterface<int>?[], false);
            Eval(15745, o is IntE, false);
            Eval(15746, o is IntE[], false);
            Eval(15747, o is IntE?, false);
            Eval(15748, o is IntE?[], false);
            Eval(15749, o is ByteE, false);
            Eval(15750, o is ByteE[], false);
            Eval(15751, o is ByteE?, false);
            Eval(15752, o is ByteE?[], false);
            Eval(15753, o is LongE, false);
            Eval(15754, o is LongE[], false);
            Eval(15755, o is LongE?, false);
            Eval(15756, o is LongE?[], false);
            Eval(15757, o is char, false);
            Eval(15758, o is char[], false);
            Eval(15759, o is char?, false);
            Eval(15760, o is char?[], false);
            Eval(15761, o is bool, false);
            Eval(15762, o is bool[], false);
            Eval(15763, o is bool?, false);
            Eval(15764, o is bool?[], false);
            Eval(15765, o is byte, false);
            Eval(15766, o is byte[], false);
            Eval(15767, o is byte?, false);
            Eval(15768, o is byte?[], false);
            Eval(15769, o is sbyte, false);
            Eval(15770, o is sbyte[], false);
            Eval(15771, o is sbyte?, false);
            Eval(15772, o is sbyte?[], false);
            Eval(15773, o is short, false);
            Eval(15774, o is short[], false);
            Eval(15775, o is short?, false);
            Eval(15776, o is short?[], false);
            Eval(15777, o is ushort, false);
            Eval(15778, o is ushort[], false);
            Eval(15779, o is ushort?, false);
            Eval(15780, o is ushort?[], false);
            Eval(15781, o is int, false);
            Eval(15782, o is int[], false);
            Eval(15783, o is int?, false);
            Eval(15784, o is int?[], false);
            Eval(15785, o is uint, false);
            Eval(15786, o is uint[], false);
            Eval(15787, o is uint?, false);
            Eval(15788, o is uint?[], false);
            Eval(15789, o is long, false);
            Eval(15790, o is long[], false);
            Eval(15791, o is long?, false);
            Eval(15792, o is long?[], false);
            Eval(15793, o is ulong, false);
            Eval(15794, o is ulong[], false);
            Eval(15795, o is ulong?, false);
            Eval(15796, o is ulong?[], false);
            Eval(15797, o is float, false);
            Eval(15798, o is float[], false);
            Eval(15799, o is float?, false);
            Eval(15800, o is float?[], false);
            Eval(15801, o is double, false);
            Eval(15802, o is double[], false);
            Eval(15803, o is double?, false);
            Eval(15804, o is double?[], false);
            Eval(15805, o is decimal, false);
            Eval(15806, o is decimal[], false);
            Eval(15807, o is decimal?, false);
            Eval(15808, o is decimal?[], false);
            Eval(15809, o is IntPtr, false);
            Eval(15810, o is IntPtr[], false);
            Eval(15811, o is IntPtr?, false);
            Eval(15812, o is IntPtr?[], false);
            Eval(15813, o is UIntPtr, false);
            Eval(15814, o is UIntPtr[], false);
            Eval(15815, o is UIntPtr?, false);
            Eval(15816, o is UIntPtr?[], false);
            Eval(15817, o is Guid, false);
            Eval(15818, o is Guid[], false);
            Eval(15819, o is Guid?, false);
            Eval(15820, o is Guid?[], false);
            Eval(15821, o is GCHandle, false);
            Eval(15822, o is GCHandle[], false);
            Eval(15823, o is GCHandle?, false);
            Eval(15824, o is GCHandle?[], false);
            Eval(15825, o is object, false);
            Eval(15826, o is object[], false);
            Eval(15827, o is string, false);
            Eval(15828, o is string[], false);
            Eval(15829, o is ValueType, false);
            Eval(15830, o is ValueType[], false);
            Eval(15831, o is Array, false);
            Eval(15832, o is Array[], false);
            Eval(15833, o is Enum, false);
            Eval(15834, o is Enum[], false);
            Eval(15835, o is Delegate, false);
            Eval(15836, o is Delegate[], false);
            Eval(15837, o is MulticastDelegate, false);
            Eval(15838, o is MulticastDelegate[], false);
            Eval(15839, o is IEmpty, false);
            Eval(15840, o is IEmpty[], false);
            Eval(15841, o is INotEmpty, false);
            Eval(15842, o is INotEmpty[], false);
            Eval(15843, o is IEmptyGen<int>, false);
            Eval(15844, o is IEmptyGen<int>[], false);
            Eval(15845, o is INotEmptyGen<int>, false);
            Eval(15846, o is INotEmptyGen<int>[], false);
            Eval(15847, o is SimpleDelegate, false);
            Eval(15848, o is SimpleDelegate[], false);
            Eval(15849, o is GenericDelegate<int>, false);
            Eval(15850, o is GenericDelegate<int>[], false);
            Eval(15851, o is EmptyClass, false);
            Eval(15852, o is EmptyClass[], false);
            Eval(15853, o is NotEmptyClass, false);
            Eval(15854, o is NotEmptyClass[], false);
            Eval(15855, o is EmptyClassGen<int>, false);
            Eval(15856, o is EmptyClassGen<int>[], false);
            Eval(15857, o is NotEmptyClassGen<Guid>, false);
            Eval(15858, o is NotEmptyClassGen<Guid>[], false);
            Eval(15859, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(15860, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(15861, o is NestedClass, false);
            Eval(15862, o is NestedClass[], false);
            Eval(15863, o is NestedClassGen<Decimal>, false);
            Eval(15864, o is NestedClassGen<Decimal>[], false);
            Eval(15865, o is ImplementOneInterfaceC, false);
            Eval(15866, o is ImplementOneInterfaceC[], false);
            Eval(15867, o is ImplementTwoInterfaceC, false);
            Eval(15868, o is ImplementTwoInterfaceC[], false);
            Eval(15869, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(15870, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(15871, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(15872, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(15873, o is ImplementAllInterfaceC<int>, false);
            Eval(15874, o is ImplementAllInterfaceC<int>[], false);
            Eval(15875, o is SealedClass, false);
            Eval(15876, o is SealedClass[], false);
        }
    }  // end of test case 0027
    private static void TestCase0028()
    {
        {
            long v = default(long);
            ValueType o = v;
            Eval(15877, o is EmptyStruct, false);
            Eval(15878, o is EmptyStruct[], false);
            Eval(15879, o is EmptyStruct?, false);
            Eval(15880, o is EmptyStruct?[], false);
            Eval(15881, o is NotEmptyStruct, false);
            Eval(15882, o is NotEmptyStruct[], false);
            Eval(15883, o is NotEmptyStruct?, false);
            Eval(15884, o is NotEmptyStruct?[], false);
            Eval(15885, o is EmptyStructGen<int>, false);
            Eval(15886, o is EmptyStructGen<int>[], false);
            Eval(15887, o is EmptyStructGen<int>?, false);
            Eval(15888, o is EmptyStructGen<int>?[], false);
            Eval(15889, o is NotEmptyStructGen<Guid>, false);
            Eval(15890, o is NotEmptyStructGen<Guid>[], false);
            Eval(15891, o is NotEmptyStructGen<Guid>?, false);
            Eval(15892, o is NotEmptyStructGen<Guid>?[], false);
            Eval(15893, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(15894, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(15895, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(15896, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(15897, o is NestedStruct, false);
            Eval(15898, o is NestedStruct[], false);
            Eval(15899, o is NestedStruct?, false);
            Eval(15900, o is NestedStruct?[], false);
            Eval(15901, o is NestedStructGen<Decimal>, false);
            Eval(15902, o is NestedStructGen<Decimal>[], false);
            Eval(15903, o is NestedStructGen<Decimal>?, false);
            Eval(15904, o is NestedStructGen<Decimal>?[], false);
            Eval(15905, o is ExplicitFieldOffsetStruct, false);
            Eval(15906, o is ExplicitFieldOffsetStruct[], false);
            Eval(15907, o is ExplicitFieldOffsetStruct?, false);
            Eval(15908, o is ExplicitFieldOffsetStruct?[], false);
            Eval(15917, o is MarshalAsStruct, false);
            Eval(15918, o is MarshalAsStruct[], false);
            Eval(15919, o is MarshalAsStruct?, false);
            Eval(15920, o is MarshalAsStruct?[], false);
            Eval(15921, o is ImplementOneInterface, false);
            Eval(15922, o is ImplementOneInterface[], false);
            Eval(15923, o is ImplementOneInterface?, false);
            Eval(15924, o is ImplementOneInterface?[], false);
            Eval(15925, o is ImplementTwoInterface, false);
            Eval(15926, o is ImplementTwoInterface[], false);
            Eval(15927, o is ImplementTwoInterface?, false);
            Eval(15928, o is ImplementTwoInterface?[], false);
            Eval(15929, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(15930, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(15931, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(15932, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(15933, o is ImplementTwoInterfaceGen<int>, false);
            Eval(15934, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(15935, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(15936, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(15937, o is ImplementAllInterface<int>, false);
            Eval(15938, o is ImplementAllInterface<int>[], false);
            Eval(15939, o is ImplementAllInterface<int>?, false);
            Eval(15940, o is ImplementAllInterface<int>?[], false);
            Eval(15941, o is IntE, false);
            Eval(15942, o is IntE[], false);
            Eval(15943, o is IntE?, false);
            Eval(15944, o is IntE?[], false);
            Eval(15945, o is ByteE, false);
            Eval(15946, o is ByteE[], false);
            Eval(15947, o is ByteE?, false);
            Eval(15948, o is ByteE?[], false);
            Eval(15949, o is LongE, false);
            Eval(15950, o is LongE[], false);
            Eval(15951, o is LongE?, false);
            Eval(15952, o is LongE?[], false);
            Eval(15953, o is char, false);
            Eval(15954, o is char[], false);
            Eval(15955, o is char?, false);
            Eval(15956, o is char?[], false);
            Eval(15957, o is bool, false);
            Eval(15958, o is bool[], false);
            Eval(15959, o is bool?, false);
            Eval(15960, o is bool?[], false);
            Eval(15961, o is byte, false);
            Eval(15962, o is byte[], false);
            Eval(15963, o is byte?, false);
            Eval(15964, o is byte?[], false);
            Eval(15965, o is sbyte, false);
            Eval(15966, o is sbyte[], false);
            Eval(15967, o is sbyte?, false);
            Eval(15968, o is sbyte?[], false);
            Eval(15969, o is short, false);
            Eval(15970, o is short[], false);
            Eval(15971, o is short?, false);
            Eval(15972, o is short?[], false);
            Eval(15973, o is ushort, false);
            Eval(15974, o is ushort[], false);
            Eval(15975, o is ushort?, false);
            Eval(15976, o is ushort?[], false);
            Eval(15977, o is int, false);
            Eval(15978, o is int[], false);
            Eval(15979, o is int?, false);
            Eval(15980, o is int?[], false);
            Eval(15981, o is uint, false);
            Eval(15982, o is uint[], false);
            Eval(15983, o is uint?, false);
            Eval(15984, o is uint?[], false);
            Eval(15985, o is long, true);
            Eval(15986, o is long[], false);
            Eval(15987, o is long?, true);
            Eval(15988, o is long?[], false);
            Eval(15989, o is ulong, false);
            Eval(15990, o is ulong[], false);
            Eval(15991, o is ulong?, false);
            Eval(15992, o is ulong?[], false);
            Eval(15993, o is float, false);
            Eval(15994, o is float[], false);
            Eval(15995, o is float?, false);
            Eval(15996, o is float?[], false);
            Eval(15997, o is double, false);
            Eval(15998, o is double[], false);
            Eval(15999, o is double?, false);
            Eval(16000, o is double?[], false);
            Eval(16001, o is decimal, false);
            Eval(16002, o is decimal[], false);
            Eval(16003, o is decimal?, false);
            Eval(16004, o is decimal?[], false);
            Eval(16005, o is IntPtr, false);
            Eval(16006, o is IntPtr[], false);
            Eval(16007, o is IntPtr?, false);
            Eval(16008, o is IntPtr?[], false);
            Eval(16009, o is UIntPtr, false);
            Eval(16010, o is UIntPtr[], false);
            Eval(16011, o is UIntPtr?, false);
            Eval(16012, o is UIntPtr?[], false);
            Eval(16013, o is Guid, false);
            Eval(16014, o is Guid[], false);
            Eval(16015, o is Guid?, false);
            Eval(16016, o is Guid?[], false);
            Eval(16017, o is GCHandle, false);
            Eval(16018, o is GCHandle[], false);
            Eval(16019, o is GCHandle?, false);
            Eval(16020, o is GCHandle?[], false);
            Eval(16021, o is object, true);
            Eval(16022, o is object[], false);
            Eval(16023, o is string, false);
            Eval(16024, o is string[], false);
            Eval(16025, o is ValueType, true);
            Eval(16026, o is ValueType[], false);
            Eval(16027, o is Array, false);
            Eval(16028, o is Array[], false);
            Eval(16029, o is Enum, false);
            Eval(16030, o is Enum[], false);
            Eval(16031, o is Delegate, false);
            Eval(16032, o is Delegate[], false);
            Eval(16033, o is MulticastDelegate, false);
            Eval(16034, o is MulticastDelegate[], false);
            Eval(16035, o is IEmpty, false);
            Eval(16036, o is IEmpty[], false);
            Eval(16037, o is INotEmpty, false);
            Eval(16038, o is INotEmpty[], false);
            Eval(16039, o is IEmptyGen<int>, false);
            Eval(16040, o is IEmptyGen<int>[], false);
            Eval(16041, o is INotEmptyGen<int>, false);
            Eval(16042, o is INotEmptyGen<int>[], false);
            Eval(16043, o is SimpleDelegate, false);
            Eval(16044, o is SimpleDelegate[], false);
            Eval(16045, o is GenericDelegate<int>, false);
            Eval(16046, o is GenericDelegate<int>[], false);
            Eval(16047, o is EmptyClass, false);
            Eval(16048, o is EmptyClass[], false);
            Eval(16049, o is NotEmptyClass, false);
            Eval(16050, o is NotEmptyClass[], false);
            Eval(16051, o is EmptyClassGen<int>, false);
            Eval(16052, o is EmptyClassGen<int>[], false);
            Eval(16053, o is NotEmptyClassGen<Guid>, false);
            Eval(16054, o is NotEmptyClassGen<Guid>[], false);
            Eval(16055, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(16056, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(16057, o is NestedClass, false);
            Eval(16058, o is NestedClass[], false);
            Eval(16059, o is NestedClassGen<Decimal>, false);
            Eval(16060, o is NestedClassGen<Decimal>[], false);
            Eval(16061, o is ImplementOneInterfaceC, false);
            Eval(16062, o is ImplementOneInterfaceC[], false);
            Eval(16063, o is ImplementTwoInterfaceC, false);
            Eval(16064, o is ImplementTwoInterfaceC[], false);
            Eval(16065, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(16066, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(16067, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(16068, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(16069, o is ImplementAllInterfaceC<int>, false);
            Eval(16070, o is ImplementAllInterfaceC<int>[], false);
            Eval(16071, o is SealedClass, false);
            Eval(16072, o is SealedClass[], false);
        }
        {
            long? v = default(long);
            ValueType o = v;
            Eval(16073, o is EmptyStruct, false);
            Eval(16074, o is EmptyStruct[], false);
            Eval(16075, o is EmptyStruct?, false);
            Eval(16076, o is EmptyStruct?[], false);
            Eval(16077, o is NotEmptyStruct, false);
            Eval(16078, o is NotEmptyStruct[], false);
            Eval(16079, o is NotEmptyStruct?, false);
            Eval(16080, o is NotEmptyStruct?[], false);
            Eval(16081, o is EmptyStructGen<int>, false);
            Eval(16082, o is EmptyStructGen<int>[], false);
            Eval(16083, o is EmptyStructGen<int>?, false);
            Eval(16084, o is EmptyStructGen<int>?[], false);
            Eval(16085, o is NotEmptyStructGen<Guid>, false);
            Eval(16086, o is NotEmptyStructGen<Guid>[], false);
            Eval(16087, o is NotEmptyStructGen<Guid>?, false);
            Eval(16088, o is NotEmptyStructGen<Guid>?[], false);
            Eval(16089, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(16090, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(16091, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(16092, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(16093, o is NestedStruct, false);
            Eval(16094, o is NestedStruct[], false);
            Eval(16095, o is NestedStruct?, false);
            Eval(16096, o is NestedStruct?[], false);
            Eval(16097, o is NestedStructGen<Decimal>, false);
            Eval(16098, o is NestedStructGen<Decimal>[], false);
            Eval(16099, o is NestedStructGen<Decimal>?, false);
            Eval(16100, o is NestedStructGen<Decimal>?[], false);
            Eval(16101, o is ExplicitFieldOffsetStruct, false);
            Eval(16102, o is ExplicitFieldOffsetStruct[], false);
            Eval(16103, o is ExplicitFieldOffsetStruct?, false);
            Eval(16104, o is ExplicitFieldOffsetStruct?[], false);
            Eval(16113, o is MarshalAsStruct, false);
            Eval(16114, o is MarshalAsStruct[], false);
            Eval(16115, o is MarshalAsStruct?, false);
            Eval(16116, o is MarshalAsStruct?[], false);
            Eval(16117, o is ImplementOneInterface, false);
            Eval(16118, o is ImplementOneInterface[], false);
            Eval(16119, o is ImplementOneInterface?, false);
            Eval(16120, o is ImplementOneInterface?[], false);
            Eval(16121, o is ImplementTwoInterface, false);
            Eval(16122, o is ImplementTwoInterface[], false);
            Eval(16123, o is ImplementTwoInterface?, false);
            Eval(16124, o is ImplementTwoInterface?[], false);
            Eval(16125, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(16126, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(16127, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(16128, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(16129, o is ImplementTwoInterfaceGen<int>, false);
            Eval(16130, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(16131, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(16132, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(16133, o is ImplementAllInterface<int>, false);
            Eval(16134, o is ImplementAllInterface<int>[], false);
            Eval(16135, o is ImplementAllInterface<int>?, false);
            Eval(16136, o is ImplementAllInterface<int>?[], false);
            Eval(16137, o is IntE, false);
            Eval(16138, o is IntE[], false);
            Eval(16139, o is IntE?, false);
            Eval(16140, o is IntE?[], false);
            Eval(16141, o is ByteE, false);
            Eval(16142, o is ByteE[], false);
            Eval(16143, o is ByteE?, false);
            Eval(16144, o is ByteE?[], false);
            Eval(16145, o is LongE, false);
            Eval(16146, o is LongE[], false);
            Eval(16147, o is LongE?, false);
            Eval(16148, o is LongE?[], false);
            Eval(16149, o is char, false);
            Eval(16150, o is char[], false);
            Eval(16151, o is char?, false);
            Eval(16152, o is char?[], false);
            Eval(16153, o is bool, false);
            Eval(16154, o is bool[], false);
            Eval(16155, o is bool?, false);
            Eval(16156, o is bool?[], false);
            Eval(16157, o is byte, false);
            Eval(16158, o is byte[], false);
            Eval(16159, o is byte?, false);
            Eval(16160, o is byte?[], false);
            Eval(16161, o is sbyte, false);
            Eval(16162, o is sbyte[], false);
            Eval(16163, o is sbyte?, false);
            Eval(16164, o is sbyte?[], false);
            Eval(16165, o is short, false);
            Eval(16166, o is short[], false);
            Eval(16167, o is short?, false);
            Eval(16168, o is short?[], false);
            Eval(16169, o is ushort, false);
            Eval(16170, o is ushort[], false);
            Eval(16171, o is ushort?, false);
            Eval(16172, o is ushort?[], false);
            Eval(16173, o is int, false);
            Eval(16174, o is int[], false);
            Eval(16175, o is int?, false);
            Eval(16176, o is int?[], false);
            Eval(16177, o is uint, false);
            Eval(16178, o is uint[], false);
            Eval(16179, o is uint?, false);
            Eval(16180, o is uint?[], false);
            Eval(16181, o is long, true);
            Eval(16182, o is long[], false);
            Eval(16183, o is long?, true);
            Eval(16184, o is long?[], false);
            Eval(16185, o is ulong, false);
            Eval(16186, o is ulong[], false);
            Eval(16187, o is ulong?, false);
            Eval(16188, o is ulong?[], false);
            Eval(16189, o is float, false);
            Eval(16190, o is float[], false);
            Eval(16191, o is float?, false);
            Eval(16192, o is float?[], false);
            Eval(16193, o is double, false);
            Eval(16194, o is double[], false);
            Eval(16195, o is double?, false);
            Eval(16196, o is double?[], false);
            Eval(16197, o is decimal, false);
            Eval(16198, o is decimal[], false);
            Eval(16199, o is decimal?, false);
            Eval(16200, o is decimal?[], false);
            Eval(16201, o is IntPtr, false);
            Eval(16202, o is IntPtr[], false);
            Eval(16203, o is IntPtr?, false);
            Eval(16204, o is IntPtr?[], false);
            Eval(16205, o is UIntPtr, false);
            Eval(16206, o is UIntPtr[], false);
            Eval(16207, o is UIntPtr?, false);
            Eval(16208, o is UIntPtr?[], false);
            Eval(16209, o is Guid, false);
            Eval(16210, o is Guid[], false);
            Eval(16211, o is Guid?, false);
            Eval(16212, o is Guid?[], false);
            Eval(16213, o is GCHandle, false);
            Eval(16214, o is GCHandle[], false);
            Eval(16215, o is GCHandle?, false);
            Eval(16216, o is GCHandle?[], false);
            Eval(16217, o is object, true);
            Eval(16218, o is object[], false);
            Eval(16219, o is string, false);
            Eval(16220, o is string[], false);
            Eval(16221, o is ValueType, true);
            Eval(16222, o is ValueType[], false);
            Eval(16223, o is Array, false);
            Eval(16224, o is Array[], false);
            Eval(16225, o is Enum, false);
            Eval(16226, o is Enum[], false);
            Eval(16227, o is Delegate, false);
            Eval(16228, o is Delegate[], false);
            Eval(16229, o is MulticastDelegate, false);
            Eval(16230, o is MulticastDelegate[], false);
            Eval(16231, o is IEmpty, false);
            Eval(16232, o is IEmpty[], false);
            Eval(16233, o is INotEmpty, false);
            Eval(16234, o is INotEmpty[], false);
            Eval(16235, o is IEmptyGen<int>, false);
            Eval(16236, o is IEmptyGen<int>[], false);
            Eval(16237, o is INotEmptyGen<int>, false);
            Eval(16238, o is INotEmptyGen<int>[], false);
            Eval(16239, o is SimpleDelegate, false);
            Eval(16240, o is SimpleDelegate[], false);
            Eval(16241, o is GenericDelegate<int>, false);
            Eval(16242, o is GenericDelegate<int>[], false);
            Eval(16243, o is EmptyClass, false);
            Eval(16244, o is EmptyClass[], false);
            Eval(16245, o is NotEmptyClass, false);
            Eval(16246, o is NotEmptyClass[], false);
            Eval(16247, o is EmptyClassGen<int>, false);
            Eval(16248, o is EmptyClassGen<int>[], false);
            Eval(16249, o is NotEmptyClassGen<Guid>, false);
            Eval(16250, o is NotEmptyClassGen<Guid>[], false);
            Eval(16251, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(16252, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(16253, o is NestedClass, false);
            Eval(16254, o is NestedClass[], false);
            Eval(16255, o is NestedClassGen<Decimal>, false);
            Eval(16256, o is NestedClassGen<Decimal>[], false);
            Eval(16257, o is ImplementOneInterfaceC, false);
            Eval(16258, o is ImplementOneInterfaceC[], false);
            Eval(16259, o is ImplementTwoInterfaceC, false);
            Eval(16260, o is ImplementTwoInterfaceC[], false);
            Eval(16261, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(16262, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(16263, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(16264, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(16265, o is ImplementAllInterfaceC<int>, false);
            Eval(16266, o is ImplementAllInterfaceC<int>[], false);
            Eval(16267, o is SealedClass, false);
            Eval(16268, o is SealedClass[], false);
        }
        {
            long? v = default(long?);
            ValueType o = v;
            Eval(16269, o is EmptyStruct, false);
            Eval(16270, o is EmptyStruct[], false);
            Eval(16271, o is EmptyStruct?, false);
            Eval(16272, o is EmptyStruct?[], false);
            Eval(16273, o is NotEmptyStruct, false);
            Eval(16274, o is NotEmptyStruct[], false);
            Eval(16275, o is NotEmptyStruct?, false);
            Eval(16276, o is NotEmptyStruct?[], false);
            Eval(16277, o is EmptyStructGen<int>, false);
            Eval(16278, o is EmptyStructGen<int>[], false);
            Eval(16279, o is EmptyStructGen<int>?, false);
            Eval(16280, o is EmptyStructGen<int>?[], false);
            Eval(16281, o is NotEmptyStructGen<Guid>, false);
            Eval(16282, o is NotEmptyStructGen<Guid>[], false);
            Eval(16283, o is NotEmptyStructGen<Guid>?, false);
            Eval(16284, o is NotEmptyStructGen<Guid>?[], false);
            Eval(16285, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(16286, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(16287, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(16288, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(16289, o is NestedStruct, false);
            Eval(16290, o is NestedStruct[], false);
            Eval(16291, o is NestedStruct?, false);
            Eval(16292, o is NestedStruct?[], false);
            Eval(16293, o is NestedStructGen<Decimal>, false);
            Eval(16294, o is NestedStructGen<Decimal>[], false);
            Eval(16295, o is NestedStructGen<Decimal>?, false);
            Eval(16296, o is NestedStructGen<Decimal>?[], false);
            Eval(16297, o is ExplicitFieldOffsetStruct, false);
            Eval(16298, o is ExplicitFieldOffsetStruct[], false);
            Eval(16299, o is ExplicitFieldOffsetStruct?, false);
            Eval(16300, o is ExplicitFieldOffsetStruct?[], false);
            Eval(16309, o is MarshalAsStruct, false);
            Eval(16310, o is MarshalAsStruct[], false);
            Eval(16311, o is MarshalAsStruct?, false);
            Eval(16312, o is MarshalAsStruct?[], false);
            Eval(16313, o is ImplementOneInterface, false);
            Eval(16314, o is ImplementOneInterface[], false);
            Eval(16315, o is ImplementOneInterface?, false);
            Eval(16316, o is ImplementOneInterface?[], false);
            Eval(16317, o is ImplementTwoInterface, false);
            Eval(16318, o is ImplementTwoInterface[], false);
            Eval(16319, o is ImplementTwoInterface?, false);
            Eval(16320, o is ImplementTwoInterface?[], false);
            Eval(16321, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(16322, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(16323, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(16324, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(16325, o is ImplementTwoInterfaceGen<int>, false);
            Eval(16326, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(16327, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(16328, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(16329, o is ImplementAllInterface<int>, false);
            Eval(16330, o is ImplementAllInterface<int>[], false);
            Eval(16331, o is ImplementAllInterface<int>?, false);
            Eval(16332, o is ImplementAllInterface<int>?[], false);
            Eval(16333, o is IntE, false);
            Eval(16334, o is IntE[], false);
            Eval(16335, o is IntE?, false);
            Eval(16336, o is IntE?[], false);
            Eval(16337, o is ByteE, false);
            Eval(16338, o is ByteE[], false);
            Eval(16339, o is ByteE?, false);
            Eval(16340, o is ByteE?[], false);
            Eval(16341, o is LongE, false);
            Eval(16342, o is LongE[], false);
            Eval(16343, o is LongE?, false);
            Eval(16344, o is LongE?[], false);
            Eval(16345, o is char, false);
            Eval(16346, o is char[], false);
            Eval(16347, o is char?, false);
            Eval(16348, o is char?[], false);
            Eval(16349, o is bool, false);
            Eval(16350, o is bool[], false);
            Eval(16351, o is bool?, false);
            Eval(16352, o is bool?[], false);
            Eval(16353, o is byte, false);
            Eval(16354, o is byte[], false);
            Eval(16355, o is byte?, false);
            Eval(16356, o is byte?[], false);
            Eval(16357, o is sbyte, false);
            Eval(16358, o is sbyte[], false);
            Eval(16359, o is sbyte?, false);
            Eval(16360, o is sbyte?[], false);
            Eval(16361, o is short, false);
            Eval(16362, o is short[], false);
            Eval(16363, o is short?, false);
            Eval(16364, o is short?[], false);
            Eval(16365, o is ushort, false);
            Eval(16366, o is ushort[], false);
            Eval(16367, o is ushort?, false);
            Eval(16368, o is ushort?[], false);
            Eval(16369, o is int, false);
            Eval(16370, o is int[], false);
            Eval(16371, o is int?, false);
            Eval(16372, o is int?[], false);
            Eval(16373, o is uint, false);
            Eval(16374, o is uint[], false);
            Eval(16375, o is uint?, false);
            Eval(16376, o is uint?[], false);
            Eval(16377, o is long, false);
            Eval(16378, o is long[], false);
            Eval(16379, o is long?, false);
            Eval(16380, o is long?[], false);
            Eval(16381, o is ulong, false);
            Eval(16382, o is ulong[], false);
            Eval(16383, o is ulong?, false);
            Eval(16384, o is ulong?[], false);
            Eval(16385, o is float, false);
            Eval(16386, o is float[], false);
            Eval(16387, o is float?, false);
            Eval(16388, o is float?[], false);
            Eval(16389, o is double, false);
            Eval(16390, o is double[], false);
            Eval(16391, o is double?, false);
            Eval(16392, o is double?[], false);
            Eval(16393, o is decimal, false);
            Eval(16394, o is decimal[], false);
            Eval(16395, o is decimal?, false);
            Eval(16396, o is decimal?[], false);
            Eval(16397, o is IntPtr, false);
            Eval(16398, o is IntPtr[], false);
            Eval(16399, o is IntPtr?, false);
            Eval(16400, o is IntPtr?[], false);
            Eval(16401, o is UIntPtr, false);
            Eval(16402, o is UIntPtr[], false);
            Eval(16403, o is UIntPtr?, false);
            Eval(16404, o is UIntPtr?[], false);
            Eval(16405, o is Guid, false);
            Eval(16406, o is Guid[], false);
            Eval(16407, o is Guid?, false);
            Eval(16408, o is Guid?[], false);
            Eval(16409, o is GCHandle, false);
            Eval(16410, o is GCHandle[], false);
            Eval(16411, o is GCHandle?, false);
            Eval(16412, o is GCHandle?[], false);
            Eval(16413, o is object, false);
            Eval(16414, o is object[], false);
            Eval(16415, o is string, false);
            Eval(16416, o is string[], false);
            Eval(16417, o is ValueType, false);
            Eval(16418, o is ValueType[], false);
            Eval(16419, o is Array, false);
            Eval(16420, o is Array[], false);
            Eval(16421, o is Enum, false);
            Eval(16422, o is Enum[], false);
            Eval(16423, o is Delegate, false);
            Eval(16424, o is Delegate[], false);
            Eval(16425, o is MulticastDelegate, false);
            Eval(16426, o is MulticastDelegate[], false);
            Eval(16427, o is IEmpty, false);
            Eval(16428, o is IEmpty[], false);
            Eval(16429, o is INotEmpty, false);
            Eval(16430, o is INotEmpty[], false);
            Eval(16431, o is IEmptyGen<int>, false);
            Eval(16432, o is IEmptyGen<int>[], false);
            Eval(16433, o is INotEmptyGen<int>, false);
            Eval(16434, o is INotEmptyGen<int>[], false);
            Eval(16435, o is SimpleDelegate, false);
            Eval(16436, o is SimpleDelegate[], false);
            Eval(16437, o is GenericDelegate<int>, false);
            Eval(16438, o is GenericDelegate<int>[], false);
            Eval(16439, o is EmptyClass, false);
            Eval(16440, o is EmptyClass[], false);
            Eval(16441, o is NotEmptyClass, false);
            Eval(16442, o is NotEmptyClass[], false);
            Eval(16443, o is EmptyClassGen<int>, false);
            Eval(16444, o is EmptyClassGen<int>[], false);
            Eval(16445, o is NotEmptyClassGen<Guid>, false);
            Eval(16446, o is NotEmptyClassGen<Guid>[], false);
            Eval(16447, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(16448, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(16449, o is NestedClass, false);
            Eval(16450, o is NestedClass[], false);
            Eval(16451, o is NestedClassGen<Decimal>, false);
            Eval(16452, o is NestedClassGen<Decimal>[], false);
            Eval(16453, o is ImplementOneInterfaceC, false);
            Eval(16454, o is ImplementOneInterfaceC[], false);
            Eval(16455, o is ImplementTwoInterfaceC, false);
            Eval(16456, o is ImplementTwoInterfaceC[], false);
            Eval(16457, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(16458, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(16459, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(16460, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(16461, o is ImplementAllInterfaceC<int>, false);
            Eval(16462, o is ImplementAllInterfaceC<int>[], false);
            Eval(16463, o is SealedClass, false);
            Eval(16464, o is SealedClass[], false);
        }
    }  // end of test case 0028
    private static void TestCase0029()
    {
        {
            ulong v = default(ulong);
            ValueType o = v;
            Eval(16465, o is EmptyStruct, false);
            Eval(16466, o is EmptyStruct[], false);
            Eval(16467, o is EmptyStruct?, false);
            Eval(16468, o is EmptyStruct?[], false);
            Eval(16469, o is NotEmptyStruct, false);
            Eval(16470, o is NotEmptyStruct[], false);
            Eval(16471, o is NotEmptyStruct?, false);
            Eval(16472, o is NotEmptyStruct?[], false);
            Eval(16473, o is EmptyStructGen<int>, false);
            Eval(16474, o is EmptyStructGen<int>[], false);
            Eval(16475, o is EmptyStructGen<int>?, false);
            Eval(16476, o is EmptyStructGen<int>?[], false);
            Eval(16477, o is NotEmptyStructGen<Guid>, false);
            Eval(16478, o is NotEmptyStructGen<Guid>[], false);
            Eval(16479, o is NotEmptyStructGen<Guid>?, false);
            Eval(16480, o is NotEmptyStructGen<Guid>?[], false);
            Eval(16481, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(16482, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(16483, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(16484, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(16485, o is NestedStruct, false);
            Eval(16486, o is NestedStruct[], false);
            Eval(16487, o is NestedStruct?, false);
            Eval(16488, o is NestedStruct?[], false);
            Eval(16489, o is NestedStructGen<Decimal>, false);
            Eval(16490, o is NestedStructGen<Decimal>[], false);
            Eval(16491, o is NestedStructGen<Decimal>?, false);
            Eval(16492, o is NestedStructGen<Decimal>?[], false);
            Eval(16493, o is ExplicitFieldOffsetStruct, false);
            Eval(16494, o is ExplicitFieldOffsetStruct[], false);
            Eval(16495, o is ExplicitFieldOffsetStruct?, false);
            Eval(16496, o is ExplicitFieldOffsetStruct?[], false);
            Eval(16505, o is MarshalAsStruct, false);
            Eval(16506, o is MarshalAsStruct[], false);
            Eval(16507, o is MarshalAsStruct?, false);
            Eval(16508, o is MarshalAsStruct?[], false);
            Eval(16509, o is ImplementOneInterface, false);
            Eval(16510, o is ImplementOneInterface[], false);
            Eval(16511, o is ImplementOneInterface?, false);
            Eval(16512, o is ImplementOneInterface?[], false);
            Eval(16513, o is ImplementTwoInterface, false);
            Eval(16514, o is ImplementTwoInterface[], false);
            Eval(16515, o is ImplementTwoInterface?, false);
            Eval(16516, o is ImplementTwoInterface?[], false);
            Eval(16517, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(16518, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(16519, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(16520, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(16521, o is ImplementTwoInterfaceGen<int>, false);
            Eval(16522, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(16523, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(16524, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(16525, o is ImplementAllInterface<int>, false);
            Eval(16526, o is ImplementAllInterface<int>[], false);
            Eval(16527, o is ImplementAllInterface<int>?, false);
            Eval(16528, o is ImplementAllInterface<int>?[], false);
            Eval(16529, o is IntE, false);
            Eval(16530, o is IntE[], false);
            Eval(16531, o is IntE?, false);
            Eval(16532, o is IntE?[], false);
            Eval(16533, o is ByteE, false);
            Eval(16534, o is ByteE[], false);
            Eval(16535, o is ByteE?, false);
            Eval(16536, o is ByteE?[], false);
            Eval(16537, o is LongE, false);
            Eval(16538, o is LongE[], false);
            Eval(16539, o is LongE?, false);
            Eval(16540, o is LongE?[], false);
            Eval(16541, o is char, false);
            Eval(16542, o is char[], false);
            Eval(16543, o is char?, false);
            Eval(16544, o is char?[], false);
            Eval(16545, o is bool, false);
            Eval(16546, o is bool[], false);
            Eval(16547, o is bool?, false);
            Eval(16548, o is bool?[], false);
            Eval(16549, o is byte, false);
            Eval(16550, o is byte[], false);
            Eval(16551, o is byte?, false);
            Eval(16552, o is byte?[], false);
            Eval(16553, o is sbyte, false);
            Eval(16554, o is sbyte[], false);
            Eval(16555, o is sbyte?, false);
            Eval(16556, o is sbyte?[], false);
            Eval(16557, o is short, false);
            Eval(16558, o is short[], false);
            Eval(16559, o is short?, false);
            Eval(16560, o is short?[], false);
            Eval(16561, o is ushort, false);
            Eval(16562, o is ushort[], false);
            Eval(16563, o is ushort?, false);
            Eval(16564, o is ushort?[], false);
            Eval(16565, o is int, false);
            Eval(16566, o is int[], false);
            Eval(16567, o is int?, false);
            Eval(16568, o is int?[], false);
            Eval(16569, o is uint, false);
            Eval(16570, o is uint[], false);
            Eval(16571, o is uint?, false);
            Eval(16572, o is uint?[], false);
            Eval(16573, o is long, false);
            Eval(16574, o is long[], false);
            Eval(16575, o is long?, false);
            Eval(16576, o is long?[], false);
            Eval(16577, o is ulong, true);
            Eval(16578, o is ulong[], false);
            Eval(16579, o is ulong?, true);
            Eval(16580, o is ulong?[], false);
            Eval(16581, o is float, false);
            Eval(16582, o is float[], false);
            Eval(16583, o is float?, false);
            Eval(16584, o is float?[], false);
            Eval(16585, o is double, false);
            Eval(16586, o is double[], false);
            Eval(16587, o is double?, false);
            Eval(16588, o is double?[], false);
            Eval(16589, o is decimal, false);
            Eval(16590, o is decimal[], false);
            Eval(16591, o is decimal?, false);
            Eval(16592, o is decimal?[], false);
            Eval(16593, o is IntPtr, false);
            Eval(16594, o is IntPtr[], false);
            Eval(16595, o is IntPtr?, false);
            Eval(16596, o is IntPtr?[], false);
            Eval(16597, o is UIntPtr, false);
            Eval(16598, o is UIntPtr[], false);
            Eval(16599, o is UIntPtr?, false);
            Eval(16600, o is UIntPtr?[], false);
            Eval(16601, o is Guid, false);
            Eval(16602, o is Guid[], false);
            Eval(16603, o is Guid?, false);
            Eval(16604, o is Guid?[], false);
            Eval(16605, o is GCHandle, false);
            Eval(16606, o is GCHandle[], false);
            Eval(16607, o is GCHandle?, false);
            Eval(16608, o is GCHandle?[], false);
            Eval(16609, o is object, true);
            Eval(16610, o is object[], false);
            Eval(16611, o is string, false);
            Eval(16612, o is string[], false);
            Eval(16613, o is ValueType, true);
            Eval(16614, o is ValueType[], false);
            Eval(16615, o is Array, false);
            Eval(16616, o is Array[], false);
            Eval(16617, o is Enum, false);
            Eval(16618, o is Enum[], false);
            Eval(16619, o is Delegate, false);
            Eval(16620, o is Delegate[], false);
            Eval(16621, o is MulticastDelegate, false);
            Eval(16622, o is MulticastDelegate[], false);
            Eval(16623, o is IEmpty, false);
            Eval(16624, o is IEmpty[], false);
            Eval(16625, o is INotEmpty, false);
            Eval(16626, o is INotEmpty[], false);
            Eval(16627, o is IEmptyGen<int>, false);
            Eval(16628, o is IEmptyGen<int>[], false);
            Eval(16629, o is INotEmptyGen<int>, false);
            Eval(16630, o is INotEmptyGen<int>[], false);
            Eval(16631, o is SimpleDelegate, false);
            Eval(16632, o is SimpleDelegate[], false);
            Eval(16633, o is GenericDelegate<int>, false);
            Eval(16634, o is GenericDelegate<int>[], false);
            Eval(16635, o is EmptyClass, false);
            Eval(16636, o is EmptyClass[], false);
            Eval(16637, o is NotEmptyClass, false);
            Eval(16638, o is NotEmptyClass[], false);
            Eval(16639, o is EmptyClassGen<int>, false);
            Eval(16640, o is EmptyClassGen<int>[], false);
            Eval(16641, o is NotEmptyClassGen<Guid>, false);
            Eval(16642, o is NotEmptyClassGen<Guid>[], false);
            Eval(16643, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(16644, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(16645, o is NestedClass, false);
            Eval(16646, o is NestedClass[], false);
            Eval(16647, o is NestedClassGen<Decimal>, false);
            Eval(16648, o is NestedClassGen<Decimal>[], false);
            Eval(16649, o is ImplementOneInterfaceC, false);
            Eval(16650, o is ImplementOneInterfaceC[], false);
            Eval(16651, o is ImplementTwoInterfaceC, false);
            Eval(16652, o is ImplementTwoInterfaceC[], false);
            Eval(16653, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(16654, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(16655, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(16656, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(16657, o is ImplementAllInterfaceC<int>, false);
            Eval(16658, o is ImplementAllInterfaceC<int>[], false);
            Eval(16659, o is SealedClass, false);
            Eval(16660, o is SealedClass[], false);
        }
        {
            ulong? v = default(ulong);
            ValueType o = v;
            Eval(16661, o is EmptyStruct, false);
            Eval(16662, o is EmptyStruct[], false);
            Eval(16663, o is EmptyStruct?, false);
            Eval(16664, o is EmptyStruct?[], false);
            Eval(16665, o is NotEmptyStruct, false);
            Eval(16666, o is NotEmptyStruct[], false);
            Eval(16667, o is NotEmptyStruct?, false);
            Eval(16668, o is NotEmptyStruct?[], false);
            Eval(16669, o is EmptyStructGen<int>, false);
            Eval(16670, o is EmptyStructGen<int>[], false);
            Eval(16671, o is EmptyStructGen<int>?, false);
            Eval(16672, o is EmptyStructGen<int>?[], false);
            Eval(16673, o is NotEmptyStructGen<Guid>, false);
            Eval(16674, o is NotEmptyStructGen<Guid>[], false);
            Eval(16675, o is NotEmptyStructGen<Guid>?, false);
            Eval(16676, o is NotEmptyStructGen<Guid>?[], false);
            Eval(16677, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(16678, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(16679, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(16680, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(16681, o is NestedStruct, false);
            Eval(16682, o is NestedStruct[], false);
            Eval(16683, o is NestedStruct?, false);
            Eval(16684, o is NestedStruct?[], false);
            Eval(16685, o is NestedStructGen<Decimal>, false);
            Eval(16686, o is NestedStructGen<Decimal>[], false);
            Eval(16687, o is NestedStructGen<Decimal>?, false);
            Eval(16688, o is NestedStructGen<Decimal>?[], false);
            Eval(16689, o is ExplicitFieldOffsetStruct, false);
            Eval(16690, o is ExplicitFieldOffsetStruct[], false);
            Eval(16691, o is ExplicitFieldOffsetStruct?, false);
            Eval(16692, o is ExplicitFieldOffsetStruct?[], false);
            Eval(16701, o is MarshalAsStruct, false);
            Eval(16702, o is MarshalAsStruct[], false);
            Eval(16703, o is MarshalAsStruct?, false);
            Eval(16704, o is MarshalAsStruct?[], false);
            Eval(16705, o is ImplementOneInterface, false);
            Eval(16706, o is ImplementOneInterface[], false);
            Eval(16707, o is ImplementOneInterface?, false);
            Eval(16708, o is ImplementOneInterface?[], false);
            Eval(16709, o is ImplementTwoInterface, false);
            Eval(16710, o is ImplementTwoInterface[], false);
            Eval(16711, o is ImplementTwoInterface?, false);
            Eval(16712, o is ImplementTwoInterface?[], false);
            Eval(16713, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(16714, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(16715, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(16716, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(16717, o is ImplementTwoInterfaceGen<int>, false);
            Eval(16718, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(16719, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(16720, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(16721, o is ImplementAllInterface<int>, false);
            Eval(16722, o is ImplementAllInterface<int>[], false);
            Eval(16723, o is ImplementAllInterface<int>?, false);
            Eval(16724, o is ImplementAllInterface<int>?[], false);
            Eval(16725, o is IntE, false);
            Eval(16726, o is IntE[], false);
            Eval(16727, o is IntE?, false);
            Eval(16728, o is IntE?[], false);
            Eval(16729, o is ByteE, false);
            Eval(16730, o is ByteE[], false);
            Eval(16731, o is ByteE?, false);
            Eval(16732, o is ByteE?[], false);
            Eval(16733, o is LongE, false);
            Eval(16734, o is LongE[], false);
            Eval(16735, o is LongE?, false);
            Eval(16736, o is LongE?[], false);
            Eval(16737, o is char, false);
            Eval(16738, o is char[], false);
            Eval(16739, o is char?, false);
            Eval(16740, o is char?[], false);
            Eval(16741, o is bool, false);
            Eval(16742, o is bool[], false);
            Eval(16743, o is bool?, false);
            Eval(16744, o is bool?[], false);
            Eval(16745, o is byte, false);
            Eval(16746, o is byte[], false);
            Eval(16747, o is byte?, false);
            Eval(16748, o is byte?[], false);
            Eval(16749, o is sbyte, false);
            Eval(16750, o is sbyte[], false);
            Eval(16751, o is sbyte?, false);
            Eval(16752, o is sbyte?[], false);
            Eval(16753, o is short, false);
            Eval(16754, o is short[], false);
            Eval(16755, o is short?, false);
            Eval(16756, o is short?[], false);
            Eval(16757, o is ushort, false);
            Eval(16758, o is ushort[], false);
            Eval(16759, o is ushort?, false);
            Eval(16760, o is ushort?[], false);
            Eval(16761, o is int, false);
            Eval(16762, o is int[], false);
            Eval(16763, o is int?, false);
            Eval(16764, o is int?[], false);
            Eval(16765, o is uint, false);
            Eval(16766, o is uint[], false);
            Eval(16767, o is uint?, false);
            Eval(16768, o is uint?[], false);
            Eval(16769, o is long, false);
            Eval(16770, o is long[], false);
            Eval(16771, o is long?, false);
            Eval(16772, o is long?[], false);
            Eval(16773, o is ulong, true);
            Eval(16774, o is ulong[], false);
            Eval(16775, o is ulong?, true);
            Eval(16776, o is ulong?[], false);
            Eval(16777, o is float, false);
            Eval(16778, o is float[], false);
            Eval(16779, o is float?, false);
            Eval(16780, o is float?[], false);
            Eval(16781, o is double, false);
            Eval(16782, o is double[], false);
            Eval(16783, o is double?, false);
            Eval(16784, o is double?[], false);
            Eval(16785, o is decimal, false);
            Eval(16786, o is decimal[], false);
            Eval(16787, o is decimal?, false);
            Eval(16788, o is decimal?[], false);
            Eval(16789, o is IntPtr, false);
            Eval(16790, o is IntPtr[], false);
            Eval(16791, o is IntPtr?, false);
            Eval(16792, o is IntPtr?[], false);
            Eval(16793, o is UIntPtr, false);
            Eval(16794, o is UIntPtr[], false);
            Eval(16795, o is UIntPtr?, false);
            Eval(16796, o is UIntPtr?[], false);
            Eval(16797, o is Guid, false);
            Eval(16798, o is Guid[], false);
            Eval(16799, o is Guid?, false);
            Eval(16800, o is Guid?[], false);
            Eval(16801, o is GCHandle, false);
            Eval(16802, o is GCHandle[], false);
            Eval(16803, o is GCHandle?, false);
            Eval(16804, o is GCHandle?[], false);
            Eval(16805, o is object, true);
            Eval(16806, o is object[], false);
            Eval(16807, o is string, false);
            Eval(16808, o is string[], false);
            Eval(16809, o is ValueType, true);
            Eval(16810, o is ValueType[], false);
            Eval(16811, o is Array, false);
            Eval(16812, o is Array[], false);
            Eval(16813, o is Enum, false);
            Eval(16814, o is Enum[], false);
            Eval(16815, o is Delegate, false);
            Eval(16816, o is Delegate[], false);
            Eval(16817, o is MulticastDelegate, false);
            Eval(16818, o is MulticastDelegate[], false);
            Eval(16819, o is IEmpty, false);
            Eval(16820, o is IEmpty[], false);
            Eval(16821, o is INotEmpty, false);
            Eval(16822, o is INotEmpty[], false);
            Eval(16823, o is IEmptyGen<int>, false);
            Eval(16824, o is IEmptyGen<int>[], false);
            Eval(16825, o is INotEmptyGen<int>, false);
            Eval(16826, o is INotEmptyGen<int>[], false);
            Eval(16827, o is SimpleDelegate, false);
            Eval(16828, o is SimpleDelegate[], false);
            Eval(16829, o is GenericDelegate<int>, false);
            Eval(16830, o is GenericDelegate<int>[], false);
            Eval(16831, o is EmptyClass, false);
            Eval(16832, o is EmptyClass[], false);
            Eval(16833, o is NotEmptyClass, false);
            Eval(16834, o is NotEmptyClass[], false);
            Eval(16835, o is EmptyClassGen<int>, false);
            Eval(16836, o is EmptyClassGen<int>[], false);
            Eval(16837, o is NotEmptyClassGen<Guid>, false);
            Eval(16838, o is NotEmptyClassGen<Guid>[], false);
            Eval(16839, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(16840, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(16841, o is NestedClass, false);
            Eval(16842, o is NestedClass[], false);
            Eval(16843, o is NestedClassGen<Decimal>, false);
            Eval(16844, o is NestedClassGen<Decimal>[], false);
            Eval(16845, o is ImplementOneInterfaceC, false);
            Eval(16846, o is ImplementOneInterfaceC[], false);
            Eval(16847, o is ImplementTwoInterfaceC, false);
            Eval(16848, o is ImplementTwoInterfaceC[], false);
            Eval(16849, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(16850, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(16851, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(16852, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(16853, o is ImplementAllInterfaceC<int>, false);
            Eval(16854, o is ImplementAllInterfaceC<int>[], false);
            Eval(16855, o is SealedClass, false);
            Eval(16856, o is SealedClass[], false);
        }
        {
            ulong? v = default(ulong?);
            ValueType o = v;
            Eval(16857, o is EmptyStruct, false);
            Eval(16858, o is EmptyStruct[], false);
            Eval(16859, o is EmptyStruct?, false);
            Eval(16860, o is EmptyStruct?[], false);
            Eval(16861, o is NotEmptyStruct, false);
            Eval(16862, o is NotEmptyStruct[], false);
            Eval(16863, o is NotEmptyStruct?, false);
            Eval(16864, o is NotEmptyStruct?[], false);
            Eval(16865, o is EmptyStructGen<int>, false);
            Eval(16866, o is EmptyStructGen<int>[], false);
            Eval(16867, o is EmptyStructGen<int>?, false);
            Eval(16868, o is EmptyStructGen<int>?[], false);
            Eval(16869, o is NotEmptyStructGen<Guid>, false);
            Eval(16870, o is NotEmptyStructGen<Guid>[], false);
            Eval(16871, o is NotEmptyStructGen<Guid>?, false);
            Eval(16872, o is NotEmptyStructGen<Guid>?[], false);
            Eval(16873, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(16874, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(16875, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(16876, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(16877, o is NestedStruct, false);
            Eval(16878, o is NestedStruct[], false);
            Eval(16879, o is NestedStruct?, false);
            Eval(16880, o is NestedStruct?[], false);
            Eval(16881, o is NestedStructGen<Decimal>, false);
            Eval(16882, o is NestedStructGen<Decimal>[], false);
            Eval(16883, o is NestedStructGen<Decimal>?, false);
            Eval(16884, o is NestedStructGen<Decimal>?[], false);
            Eval(16885, o is ExplicitFieldOffsetStruct, false);
            Eval(16886, o is ExplicitFieldOffsetStruct[], false);
            Eval(16887, o is ExplicitFieldOffsetStruct?, false);
            Eval(16888, o is ExplicitFieldOffsetStruct?[], false);
            Eval(16897, o is MarshalAsStruct, false);
            Eval(16898, o is MarshalAsStruct[], false);
            Eval(16899, o is MarshalAsStruct?, false);
            Eval(16900, o is MarshalAsStruct?[], false);
            Eval(16901, o is ImplementOneInterface, false);
            Eval(16902, o is ImplementOneInterface[], false);
            Eval(16903, o is ImplementOneInterface?, false);
            Eval(16904, o is ImplementOneInterface?[], false);
            Eval(16905, o is ImplementTwoInterface, false);
            Eval(16906, o is ImplementTwoInterface[], false);
            Eval(16907, o is ImplementTwoInterface?, false);
            Eval(16908, o is ImplementTwoInterface?[], false);
            Eval(16909, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(16910, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(16911, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(16912, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(16913, o is ImplementTwoInterfaceGen<int>, false);
            Eval(16914, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(16915, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(16916, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(16917, o is ImplementAllInterface<int>, false);
            Eval(16918, o is ImplementAllInterface<int>[], false);
            Eval(16919, o is ImplementAllInterface<int>?, false);
            Eval(16920, o is ImplementAllInterface<int>?[], false);
            Eval(16921, o is IntE, false);
            Eval(16922, o is IntE[], false);
            Eval(16923, o is IntE?, false);
            Eval(16924, o is IntE?[], false);
            Eval(16925, o is ByteE, false);
            Eval(16926, o is ByteE[], false);
            Eval(16927, o is ByteE?, false);
            Eval(16928, o is ByteE?[], false);
            Eval(16929, o is LongE, false);
            Eval(16930, o is LongE[], false);
            Eval(16931, o is LongE?, false);
            Eval(16932, o is LongE?[], false);
            Eval(16933, o is char, false);
            Eval(16934, o is char[], false);
            Eval(16935, o is char?, false);
            Eval(16936, o is char?[], false);
            Eval(16937, o is bool, false);
            Eval(16938, o is bool[], false);
            Eval(16939, o is bool?, false);
            Eval(16940, o is bool?[], false);
            Eval(16941, o is byte, false);
            Eval(16942, o is byte[], false);
            Eval(16943, o is byte?, false);
            Eval(16944, o is byte?[], false);
            Eval(16945, o is sbyte, false);
            Eval(16946, o is sbyte[], false);
            Eval(16947, o is sbyte?, false);
            Eval(16948, o is sbyte?[], false);
            Eval(16949, o is short, false);
            Eval(16950, o is short[], false);
            Eval(16951, o is short?, false);
            Eval(16952, o is short?[], false);
            Eval(16953, o is ushort, false);
            Eval(16954, o is ushort[], false);
            Eval(16955, o is ushort?, false);
            Eval(16956, o is ushort?[], false);
            Eval(16957, o is int, false);
            Eval(16958, o is int[], false);
            Eval(16959, o is int?, false);
            Eval(16960, o is int?[], false);
            Eval(16961, o is uint, false);
            Eval(16962, o is uint[], false);
            Eval(16963, o is uint?, false);
            Eval(16964, o is uint?[], false);
            Eval(16965, o is long, false);
            Eval(16966, o is long[], false);
            Eval(16967, o is long?, false);
            Eval(16968, o is long?[], false);
            Eval(16969, o is ulong, false);
            Eval(16970, o is ulong[], false);
            Eval(16971, o is ulong?, false);
            Eval(16972, o is ulong?[], false);
            Eval(16973, o is float, false);
            Eval(16974, o is float[], false);
            Eval(16975, o is float?, false);
            Eval(16976, o is float?[], false);
            Eval(16977, o is double, false);
            Eval(16978, o is double[], false);
            Eval(16979, o is double?, false);
            Eval(16980, o is double?[], false);
            Eval(16981, o is decimal, false);
            Eval(16982, o is decimal[], false);
            Eval(16983, o is decimal?, false);
            Eval(16984, o is decimal?[], false);
            Eval(16985, o is IntPtr, false);
            Eval(16986, o is IntPtr[], false);
            Eval(16987, o is IntPtr?, false);
            Eval(16988, o is IntPtr?[], false);
            Eval(16989, o is UIntPtr, false);
            Eval(16990, o is UIntPtr[], false);
            Eval(16991, o is UIntPtr?, false);
            Eval(16992, o is UIntPtr?[], false);
            Eval(16993, o is Guid, false);
            Eval(16994, o is Guid[], false);
            Eval(16995, o is Guid?, false);
            Eval(16996, o is Guid?[], false);
            Eval(16997, o is GCHandle, false);
            Eval(16998, o is GCHandle[], false);
            Eval(16999, o is GCHandle?, false);
            Eval(17000, o is GCHandle?[], false);
            Eval(17001, o is object, false);
            Eval(17002, o is object[], false);
            Eval(17003, o is string, false);
            Eval(17004, o is string[], false);
            Eval(17005, o is ValueType, false);
            Eval(17006, o is ValueType[], false);
            Eval(17007, o is Array, false);
            Eval(17008, o is Array[], false);
            Eval(17009, o is Enum, false);
            Eval(17010, o is Enum[], false);
            Eval(17011, o is Delegate, false);
            Eval(17012, o is Delegate[], false);
            Eval(17013, o is MulticastDelegate, false);
            Eval(17014, o is MulticastDelegate[], false);
            Eval(17015, o is IEmpty, false);
            Eval(17016, o is IEmpty[], false);
            Eval(17017, o is INotEmpty, false);
            Eval(17018, o is INotEmpty[], false);
            Eval(17019, o is IEmptyGen<int>, false);
            Eval(17020, o is IEmptyGen<int>[], false);
            Eval(17021, o is INotEmptyGen<int>, false);
            Eval(17022, o is INotEmptyGen<int>[], false);
            Eval(17023, o is SimpleDelegate, false);
            Eval(17024, o is SimpleDelegate[], false);
            Eval(17025, o is GenericDelegate<int>, false);
            Eval(17026, o is GenericDelegate<int>[], false);
            Eval(17027, o is EmptyClass, false);
            Eval(17028, o is EmptyClass[], false);
            Eval(17029, o is NotEmptyClass, false);
            Eval(17030, o is NotEmptyClass[], false);
            Eval(17031, o is EmptyClassGen<int>, false);
            Eval(17032, o is EmptyClassGen<int>[], false);
            Eval(17033, o is NotEmptyClassGen<Guid>, false);
            Eval(17034, o is NotEmptyClassGen<Guid>[], false);
            Eval(17035, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(17036, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(17037, o is NestedClass, false);
            Eval(17038, o is NestedClass[], false);
            Eval(17039, o is NestedClassGen<Decimal>, false);
            Eval(17040, o is NestedClassGen<Decimal>[], false);
            Eval(17041, o is ImplementOneInterfaceC, false);
            Eval(17042, o is ImplementOneInterfaceC[], false);
            Eval(17043, o is ImplementTwoInterfaceC, false);
            Eval(17044, o is ImplementTwoInterfaceC[], false);
            Eval(17045, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(17046, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(17047, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(17048, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(17049, o is ImplementAllInterfaceC<int>, false);
            Eval(17050, o is ImplementAllInterfaceC<int>[], false);
            Eval(17051, o is SealedClass, false);
            Eval(17052, o is SealedClass[], false);
        }
    }  // end of test case 0029
    private static void TestCase0030()
    {
        {
            float v = default(float);
            ValueType o = v;
            Eval(17053, o is EmptyStruct, false);
            Eval(17054, o is EmptyStruct[], false);
            Eval(17055, o is EmptyStruct?, false);
            Eval(17056, o is EmptyStruct?[], false);
            Eval(17057, o is NotEmptyStruct, false);
            Eval(17058, o is NotEmptyStruct[], false);
            Eval(17059, o is NotEmptyStruct?, false);
            Eval(17060, o is NotEmptyStruct?[], false);
            Eval(17061, o is EmptyStructGen<int>, false);
            Eval(17062, o is EmptyStructGen<int>[], false);
            Eval(17063, o is EmptyStructGen<int>?, false);
            Eval(17064, o is EmptyStructGen<int>?[], false);
            Eval(17065, o is NotEmptyStructGen<Guid>, false);
            Eval(17066, o is NotEmptyStructGen<Guid>[], false);
            Eval(17067, o is NotEmptyStructGen<Guid>?, false);
            Eval(17068, o is NotEmptyStructGen<Guid>?[], false);
            Eval(17069, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(17070, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(17071, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(17072, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(17073, o is NestedStruct, false);
            Eval(17074, o is NestedStruct[], false);
            Eval(17075, o is NestedStruct?, false);
            Eval(17076, o is NestedStruct?[], false);
            Eval(17077, o is NestedStructGen<Decimal>, false);
            Eval(17078, o is NestedStructGen<Decimal>[], false);
            Eval(17079, o is NestedStructGen<Decimal>?, false);
            Eval(17080, o is NestedStructGen<Decimal>?[], false);
            Eval(17081, o is ExplicitFieldOffsetStruct, false);
            Eval(17082, o is ExplicitFieldOffsetStruct[], false);
            Eval(17083, o is ExplicitFieldOffsetStruct?, false);
            Eval(17084, o is ExplicitFieldOffsetStruct?[], false);
            Eval(17093, o is MarshalAsStruct, false);
            Eval(17094, o is MarshalAsStruct[], false);
            Eval(17095, o is MarshalAsStruct?, false);
            Eval(17096, o is MarshalAsStruct?[], false);
            Eval(17097, o is ImplementOneInterface, false);
            Eval(17098, o is ImplementOneInterface[], false);
            Eval(17099, o is ImplementOneInterface?, false);
            Eval(17100, o is ImplementOneInterface?[], false);
            Eval(17101, o is ImplementTwoInterface, false);
            Eval(17102, o is ImplementTwoInterface[], false);
            Eval(17103, o is ImplementTwoInterface?, false);
            Eval(17104, o is ImplementTwoInterface?[], false);
            Eval(17105, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(17106, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(17107, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(17108, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(17109, o is ImplementTwoInterfaceGen<int>, false);
            Eval(17110, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(17111, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(17112, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(17113, o is ImplementAllInterface<int>, false);
            Eval(17114, o is ImplementAllInterface<int>[], false);
            Eval(17115, o is ImplementAllInterface<int>?, false);
            Eval(17116, o is ImplementAllInterface<int>?[], false);
            Eval(17117, o is IntE, false);
            Eval(17118, o is IntE[], false);
            Eval(17119, o is IntE?, false);
            Eval(17120, o is IntE?[], false);
            Eval(17121, o is ByteE, false);
            Eval(17122, o is ByteE[], false);
            Eval(17123, o is ByteE?, false);
            Eval(17124, o is ByteE?[], false);
            Eval(17125, o is LongE, false);
            Eval(17126, o is LongE[], false);
            Eval(17127, o is LongE?, false);
            Eval(17128, o is LongE?[], false);
            Eval(17129, o is char, false);
            Eval(17130, o is char[], false);
            Eval(17131, o is char?, false);
            Eval(17132, o is char?[], false);
            Eval(17133, o is bool, false);
            Eval(17134, o is bool[], false);
            Eval(17135, o is bool?, false);
            Eval(17136, o is bool?[], false);
            Eval(17137, o is byte, false);
            Eval(17138, o is byte[], false);
            Eval(17139, o is byte?, false);
            Eval(17140, o is byte?[], false);
            Eval(17141, o is sbyte, false);
            Eval(17142, o is sbyte[], false);
            Eval(17143, o is sbyte?, false);
            Eval(17144, o is sbyte?[], false);
            Eval(17145, o is short, false);
            Eval(17146, o is short[], false);
            Eval(17147, o is short?, false);
            Eval(17148, o is short?[], false);
            Eval(17149, o is ushort, false);
            Eval(17150, o is ushort[], false);
            Eval(17151, o is ushort?, false);
            Eval(17152, o is ushort?[], false);
            Eval(17153, o is int, false);
            Eval(17154, o is int[], false);
            Eval(17155, o is int?, false);
            Eval(17156, o is int?[], false);
            Eval(17157, o is uint, false);
            Eval(17158, o is uint[], false);
            Eval(17159, o is uint?, false);
            Eval(17160, o is uint?[], false);
            Eval(17161, o is long, false);
            Eval(17162, o is long[], false);
            Eval(17163, o is long?, false);
            Eval(17164, o is long?[], false);
            Eval(17165, o is ulong, false);
            Eval(17166, o is ulong[], false);
            Eval(17167, o is ulong?, false);
            Eval(17168, o is ulong?[], false);
            Eval(17169, o is float, true);
            Eval(17170, o is float[], false);
            Eval(17171, o is float?, true);
            Eval(17172, o is float?[], false);
            Eval(17173, o is double, false);
            Eval(17174, o is double[], false);
            Eval(17175, o is double?, false);
            Eval(17176, o is double?[], false);
            Eval(17177, o is decimal, false);
            Eval(17178, o is decimal[], false);
            Eval(17179, o is decimal?, false);
            Eval(17180, o is decimal?[], false);
            Eval(17181, o is IntPtr, false);
            Eval(17182, o is IntPtr[], false);
            Eval(17183, o is IntPtr?, false);
            Eval(17184, o is IntPtr?[], false);
            Eval(17185, o is UIntPtr, false);
            Eval(17186, o is UIntPtr[], false);
            Eval(17187, o is UIntPtr?, false);
            Eval(17188, o is UIntPtr?[], false);
            Eval(17189, o is Guid, false);
            Eval(17190, o is Guid[], false);
            Eval(17191, o is Guid?, false);
            Eval(17192, o is Guid?[], false);
            Eval(17193, o is GCHandle, false);
            Eval(17194, o is GCHandle[], false);
            Eval(17195, o is GCHandle?, false);
            Eval(17196, o is GCHandle?[], false);
            Eval(17197, o is object, true);
            Eval(17198, o is object[], false);
            Eval(17199, o is string, false);
            Eval(17200, o is string[], false);
            Eval(17201, o is ValueType, true);
            Eval(17202, o is ValueType[], false);
            Eval(17203, o is Array, false);
            Eval(17204, o is Array[], false);
            Eval(17205, o is Enum, false);
            Eval(17206, o is Enum[], false);
            Eval(17207, o is Delegate, false);
            Eval(17208, o is Delegate[], false);
            Eval(17209, o is MulticastDelegate, false);
            Eval(17210, o is MulticastDelegate[], false);
            Eval(17211, o is IEmpty, false);
            Eval(17212, o is IEmpty[], false);
            Eval(17213, o is INotEmpty, false);
            Eval(17214, o is INotEmpty[], false);
            Eval(17215, o is IEmptyGen<int>, false);
            Eval(17216, o is IEmptyGen<int>[], false);
            Eval(17217, o is INotEmptyGen<int>, false);
            Eval(17218, o is INotEmptyGen<int>[], false);
            Eval(17219, o is SimpleDelegate, false);
            Eval(17220, o is SimpleDelegate[], false);
            Eval(17221, o is GenericDelegate<int>, false);
            Eval(17222, o is GenericDelegate<int>[], false);
            Eval(17223, o is EmptyClass, false);
            Eval(17224, o is EmptyClass[], false);
            Eval(17225, o is NotEmptyClass, false);
            Eval(17226, o is NotEmptyClass[], false);
            Eval(17227, o is EmptyClassGen<int>, false);
            Eval(17228, o is EmptyClassGen<int>[], false);
            Eval(17229, o is NotEmptyClassGen<Guid>, false);
            Eval(17230, o is NotEmptyClassGen<Guid>[], false);
            Eval(17231, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(17232, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(17233, o is NestedClass, false);
            Eval(17234, o is NestedClass[], false);
            Eval(17235, o is NestedClassGen<Decimal>, false);
            Eval(17236, o is NestedClassGen<Decimal>[], false);
            Eval(17237, o is ImplementOneInterfaceC, false);
            Eval(17238, o is ImplementOneInterfaceC[], false);
            Eval(17239, o is ImplementTwoInterfaceC, false);
            Eval(17240, o is ImplementTwoInterfaceC[], false);
            Eval(17241, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(17242, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(17243, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(17244, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(17245, o is ImplementAllInterfaceC<int>, false);
            Eval(17246, o is ImplementAllInterfaceC<int>[], false);
            Eval(17247, o is SealedClass, false);
            Eval(17248, o is SealedClass[], false);
        }
        {
            float? v = default(float);
            ValueType o = v;
            Eval(17249, o is EmptyStruct, false);
            Eval(17250, o is EmptyStruct[], false);
            Eval(17251, o is EmptyStruct?, false);
            Eval(17252, o is EmptyStruct?[], false);
            Eval(17253, o is NotEmptyStruct, false);
            Eval(17254, o is NotEmptyStruct[], false);
            Eval(17255, o is NotEmptyStruct?, false);
            Eval(17256, o is NotEmptyStruct?[], false);
            Eval(17257, o is EmptyStructGen<int>, false);
            Eval(17258, o is EmptyStructGen<int>[], false);
            Eval(17259, o is EmptyStructGen<int>?, false);
            Eval(17260, o is EmptyStructGen<int>?[], false);
            Eval(17261, o is NotEmptyStructGen<Guid>, false);
            Eval(17262, o is NotEmptyStructGen<Guid>[], false);
            Eval(17263, o is NotEmptyStructGen<Guid>?, false);
            Eval(17264, o is NotEmptyStructGen<Guid>?[], false);
            Eval(17265, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(17266, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(17267, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(17268, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(17269, o is NestedStruct, false);
            Eval(17270, o is NestedStruct[], false);
            Eval(17271, o is NestedStruct?, false);
            Eval(17272, o is NestedStruct?[], false);
            Eval(17273, o is NestedStructGen<Decimal>, false);
            Eval(17274, o is NestedStructGen<Decimal>[], false);
            Eval(17275, o is NestedStructGen<Decimal>?, false);
            Eval(17276, o is NestedStructGen<Decimal>?[], false);
            Eval(17277, o is ExplicitFieldOffsetStruct, false);
            Eval(17278, o is ExplicitFieldOffsetStruct[], false);
            Eval(17279, o is ExplicitFieldOffsetStruct?, false);
            Eval(17280, o is ExplicitFieldOffsetStruct?[], false);
            Eval(17289, o is MarshalAsStruct, false);
            Eval(17290, o is MarshalAsStruct[], false);
            Eval(17291, o is MarshalAsStruct?, false);
            Eval(17292, o is MarshalAsStruct?[], false);
            Eval(17293, o is ImplementOneInterface, false);
            Eval(17294, o is ImplementOneInterface[], false);
            Eval(17295, o is ImplementOneInterface?, false);
            Eval(17296, o is ImplementOneInterface?[], false);
            Eval(17297, o is ImplementTwoInterface, false);
            Eval(17298, o is ImplementTwoInterface[], false);
            Eval(17299, o is ImplementTwoInterface?, false);
            Eval(17300, o is ImplementTwoInterface?[], false);
            Eval(17301, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(17302, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(17303, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(17304, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(17305, o is ImplementTwoInterfaceGen<int>, false);
            Eval(17306, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(17307, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(17308, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(17309, o is ImplementAllInterface<int>, false);
            Eval(17310, o is ImplementAllInterface<int>[], false);
            Eval(17311, o is ImplementAllInterface<int>?, false);
            Eval(17312, o is ImplementAllInterface<int>?[], false);
            Eval(17313, o is IntE, false);
            Eval(17314, o is IntE[], false);
            Eval(17315, o is IntE?, false);
            Eval(17316, o is IntE?[], false);
            Eval(17317, o is ByteE, false);
            Eval(17318, o is ByteE[], false);
            Eval(17319, o is ByteE?, false);
            Eval(17320, o is ByteE?[], false);
            Eval(17321, o is LongE, false);
            Eval(17322, o is LongE[], false);
            Eval(17323, o is LongE?, false);
            Eval(17324, o is LongE?[], false);
            Eval(17325, o is char, false);
            Eval(17326, o is char[], false);
            Eval(17327, o is char?, false);
            Eval(17328, o is char?[], false);
            Eval(17329, o is bool, false);
            Eval(17330, o is bool[], false);
            Eval(17331, o is bool?, false);
            Eval(17332, o is bool?[], false);
            Eval(17333, o is byte, false);
            Eval(17334, o is byte[], false);
            Eval(17335, o is byte?, false);
            Eval(17336, o is byte?[], false);
            Eval(17337, o is sbyte, false);
            Eval(17338, o is sbyte[], false);
            Eval(17339, o is sbyte?, false);
            Eval(17340, o is sbyte?[], false);
            Eval(17341, o is short, false);
            Eval(17342, o is short[], false);
            Eval(17343, o is short?, false);
            Eval(17344, o is short?[], false);
            Eval(17345, o is ushort, false);
            Eval(17346, o is ushort[], false);
            Eval(17347, o is ushort?, false);
            Eval(17348, o is ushort?[], false);
            Eval(17349, o is int, false);
            Eval(17350, o is int[], false);
            Eval(17351, o is int?, false);
            Eval(17352, o is int?[], false);
            Eval(17353, o is uint, false);
            Eval(17354, o is uint[], false);
            Eval(17355, o is uint?, false);
            Eval(17356, o is uint?[], false);
            Eval(17357, o is long, false);
            Eval(17358, o is long[], false);
            Eval(17359, o is long?, false);
            Eval(17360, o is long?[], false);
            Eval(17361, o is ulong, false);
            Eval(17362, o is ulong[], false);
            Eval(17363, o is ulong?, false);
            Eval(17364, o is ulong?[], false);
            Eval(17365, o is float, true);
            Eval(17366, o is float[], false);
            Eval(17367, o is float?, true);
            Eval(17368, o is float?[], false);
            Eval(17369, o is double, false);
            Eval(17370, o is double[], false);
            Eval(17371, o is double?, false);
            Eval(17372, o is double?[], false);
            Eval(17373, o is decimal, false);
            Eval(17374, o is decimal[], false);
            Eval(17375, o is decimal?, false);
            Eval(17376, o is decimal?[], false);
            Eval(17377, o is IntPtr, false);
            Eval(17378, o is IntPtr[], false);
            Eval(17379, o is IntPtr?, false);
            Eval(17380, o is IntPtr?[], false);
            Eval(17381, o is UIntPtr, false);
            Eval(17382, o is UIntPtr[], false);
            Eval(17383, o is UIntPtr?, false);
            Eval(17384, o is UIntPtr?[], false);
            Eval(17385, o is Guid, false);
            Eval(17386, o is Guid[], false);
            Eval(17387, o is Guid?, false);
            Eval(17388, o is Guid?[], false);
            Eval(17389, o is GCHandle, false);
            Eval(17390, o is GCHandle[], false);
            Eval(17391, o is GCHandle?, false);
            Eval(17392, o is GCHandle?[], false);
            Eval(17393, o is object, true);
            Eval(17394, o is object[], false);
            Eval(17395, o is string, false);
            Eval(17396, o is string[], false);
            Eval(17397, o is ValueType, true);
            Eval(17398, o is ValueType[], false);
            Eval(17399, o is Array, false);
            Eval(17400, o is Array[], false);
            Eval(17401, o is Enum, false);
            Eval(17402, o is Enum[], false);
            Eval(17403, o is Delegate, false);
            Eval(17404, o is Delegate[], false);
            Eval(17405, o is MulticastDelegate, false);
            Eval(17406, o is MulticastDelegate[], false);
            Eval(17407, o is IEmpty, false);
            Eval(17408, o is IEmpty[], false);
            Eval(17409, o is INotEmpty, false);
            Eval(17410, o is INotEmpty[], false);
            Eval(17411, o is IEmptyGen<int>, false);
            Eval(17412, o is IEmptyGen<int>[], false);
            Eval(17413, o is INotEmptyGen<int>, false);
            Eval(17414, o is INotEmptyGen<int>[], false);
            Eval(17415, o is SimpleDelegate, false);
            Eval(17416, o is SimpleDelegate[], false);
            Eval(17417, o is GenericDelegate<int>, false);
            Eval(17418, o is GenericDelegate<int>[], false);
            Eval(17419, o is EmptyClass, false);
            Eval(17420, o is EmptyClass[], false);
            Eval(17421, o is NotEmptyClass, false);
            Eval(17422, o is NotEmptyClass[], false);
            Eval(17423, o is EmptyClassGen<int>, false);
            Eval(17424, o is EmptyClassGen<int>[], false);
            Eval(17425, o is NotEmptyClassGen<Guid>, false);
            Eval(17426, o is NotEmptyClassGen<Guid>[], false);
            Eval(17427, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(17428, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(17429, o is NestedClass, false);
            Eval(17430, o is NestedClass[], false);
            Eval(17431, o is NestedClassGen<Decimal>, false);
            Eval(17432, o is NestedClassGen<Decimal>[], false);
            Eval(17433, o is ImplementOneInterfaceC, false);
            Eval(17434, o is ImplementOneInterfaceC[], false);
            Eval(17435, o is ImplementTwoInterfaceC, false);
            Eval(17436, o is ImplementTwoInterfaceC[], false);
            Eval(17437, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(17438, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(17439, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(17440, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(17441, o is ImplementAllInterfaceC<int>, false);
            Eval(17442, o is ImplementAllInterfaceC<int>[], false);
            Eval(17443, o is SealedClass, false);
            Eval(17444, o is SealedClass[], false);
        }
        {
            float? v = default(float?);
            ValueType o = v;
            Eval(17445, o is EmptyStruct, false);
            Eval(17446, o is EmptyStruct[], false);
            Eval(17447, o is EmptyStruct?, false);
            Eval(17448, o is EmptyStruct?[], false);
            Eval(17449, o is NotEmptyStruct, false);
            Eval(17450, o is NotEmptyStruct[], false);
            Eval(17451, o is NotEmptyStruct?, false);
            Eval(17452, o is NotEmptyStruct?[], false);
            Eval(17453, o is EmptyStructGen<int>, false);
            Eval(17454, o is EmptyStructGen<int>[], false);
            Eval(17455, o is EmptyStructGen<int>?, false);
            Eval(17456, o is EmptyStructGen<int>?[], false);
            Eval(17457, o is NotEmptyStructGen<Guid>, false);
            Eval(17458, o is NotEmptyStructGen<Guid>[], false);
            Eval(17459, o is NotEmptyStructGen<Guid>?, false);
            Eval(17460, o is NotEmptyStructGen<Guid>?[], false);
            Eval(17461, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(17462, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(17463, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(17464, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(17465, o is NestedStruct, false);
            Eval(17466, o is NestedStruct[], false);
            Eval(17467, o is NestedStruct?, false);
            Eval(17468, o is NestedStruct?[], false);
            Eval(17469, o is NestedStructGen<Decimal>, false);
            Eval(17470, o is NestedStructGen<Decimal>[], false);
            Eval(17471, o is NestedStructGen<Decimal>?, false);
            Eval(17472, o is NestedStructGen<Decimal>?[], false);
            Eval(17473, o is ExplicitFieldOffsetStruct, false);
            Eval(17474, o is ExplicitFieldOffsetStruct[], false);
            Eval(17475, o is ExplicitFieldOffsetStruct?, false);
            Eval(17476, o is ExplicitFieldOffsetStruct?[], false);
            Eval(17485, o is MarshalAsStruct, false);
            Eval(17486, o is MarshalAsStruct[], false);
            Eval(17487, o is MarshalAsStruct?, false);
            Eval(17488, o is MarshalAsStruct?[], false);
            Eval(17489, o is ImplementOneInterface, false);
            Eval(17490, o is ImplementOneInterface[], false);
            Eval(17491, o is ImplementOneInterface?, false);
            Eval(17492, o is ImplementOneInterface?[], false);
            Eval(17493, o is ImplementTwoInterface, false);
            Eval(17494, o is ImplementTwoInterface[], false);
            Eval(17495, o is ImplementTwoInterface?, false);
            Eval(17496, o is ImplementTwoInterface?[], false);
            Eval(17497, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(17498, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(17499, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(17500, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(17501, o is ImplementTwoInterfaceGen<int>, false);
            Eval(17502, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(17503, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(17504, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(17505, o is ImplementAllInterface<int>, false);
            Eval(17506, o is ImplementAllInterface<int>[], false);
            Eval(17507, o is ImplementAllInterface<int>?, false);
            Eval(17508, o is ImplementAllInterface<int>?[], false);
            Eval(17509, o is IntE, false);
            Eval(17510, o is IntE[], false);
            Eval(17511, o is IntE?, false);
            Eval(17512, o is IntE?[], false);
            Eval(17513, o is ByteE, false);
            Eval(17514, o is ByteE[], false);
            Eval(17515, o is ByteE?, false);
            Eval(17516, o is ByteE?[], false);
            Eval(17517, o is LongE, false);
            Eval(17518, o is LongE[], false);
            Eval(17519, o is LongE?, false);
            Eval(17520, o is LongE?[], false);
            Eval(17521, o is char, false);
            Eval(17522, o is char[], false);
            Eval(17523, o is char?, false);
            Eval(17524, o is char?[], false);
            Eval(17525, o is bool, false);
            Eval(17526, o is bool[], false);
            Eval(17527, o is bool?, false);
            Eval(17528, o is bool?[], false);
            Eval(17529, o is byte, false);
            Eval(17530, o is byte[], false);
            Eval(17531, o is byte?, false);
            Eval(17532, o is byte?[], false);
            Eval(17533, o is sbyte, false);
            Eval(17534, o is sbyte[], false);
            Eval(17535, o is sbyte?, false);
            Eval(17536, o is sbyte?[], false);
            Eval(17537, o is short, false);
            Eval(17538, o is short[], false);
            Eval(17539, o is short?, false);
            Eval(17540, o is short?[], false);
            Eval(17541, o is ushort, false);
            Eval(17542, o is ushort[], false);
            Eval(17543, o is ushort?, false);
            Eval(17544, o is ushort?[], false);
            Eval(17545, o is int, false);
            Eval(17546, o is int[], false);
            Eval(17547, o is int?, false);
            Eval(17548, o is int?[], false);
            Eval(17549, o is uint, false);
            Eval(17550, o is uint[], false);
            Eval(17551, o is uint?, false);
            Eval(17552, o is uint?[], false);
            Eval(17553, o is long, false);
            Eval(17554, o is long[], false);
            Eval(17555, o is long?, false);
            Eval(17556, o is long?[], false);
            Eval(17557, o is ulong, false);
            Eval(17558, o is ulong[], false);
            Eval(17559, o is ulong?, false);
            Eval(17560, o is ulong?[], false);
            Eval(17561, o is float, false);
            Eval(17562, o is float[], false);
            Eval(17563, o is float?, false);
            Eval(17564, o is float?[], false);
            Eval(17565, o is double, false);
            Eval(17566, o is double[], false);
            Eval(17567, o is double?, false);
            Eval(17568, o is double?[], false);
            Eval(17569, o is decimal, false);
            Eval(17570, o is decimal[], false);
            Eval(17571, o is decimal?, false);
            Eval(17572, o is decimal?[], false);
            Eval(17573, o is IntPtr, false);
            Eval(17574, o is IntPtr[], false);
            Eval(17575, o is IntPtr?, false);
            Eval(17576, o is IntPtr?[], false);
            Eval(17577, o is UIntPtr, false);
            Eval(17578, o is UIntPtr[], false);
            Eval(17579, o is UIntPtr?, false);
            Eval(17580, o is UIntPtr?[], false);
            Eval(17581, o is Guid, false);
            Eval(17582, o is Guid[], false);
            Eval(17583, o is Guid?, false);
            Eval(17584, o is Guid?[], false);
            Eval(17585, o is GCHandle, false);
            Eval(17586, o is GCHandle[], false);
            Eval(17587, o is GCHandle?, false);
            Eval(17588, o is GCHandle?[], false);
            Eval(17589, o is object, false);
            Eval(17590, o is object[], false);
            Eval(17591, o is string, false);
            Eval(17592, o is string[], false);
            Eval(17593, o is ValueType, false);
            Eval(17594, o is ValueType[], false);
            Eval(17595, o is Array, false);
            Eval(17596, o is Array[], false);
            Eval(17597, o is Enum, false);
            Eval(17598, o is Enum[], false);
            Eval(17599, o is Delegate, false);
            Eval(17600, o is Delegate[], false);
            Eval(17601, o is MulticastDelegate, false);
            Eval(17602, o is MulticastDelegate[], false);
            Eval(17603, o is IEmpty, false);
            Eval(17604, o is IEmpty[], false);
            Eval(17605, o is INotEmpty, false);
            Eval(17606, o is INotEmpty[], false);
            Eval(17607, o is IEmptyGen<int>, false);
            Eval(17608, o is IEmptyGen<int>[], false);
            Eval(17609, o is INotEmptyGen<int>, false);
            Eval(17610, o is INotEmptyGen<int>[], false);
            Eval(17611, o is SimpleDelegate, false);
            Eval(17612, o is SimpleDelegate[], false);
            Eval(17613, o is GenericDelegate<int>, false);
            Eval(17614, o is GenericDelegate<int>[], false);
            Eval(17615, o is EmptyClass, false);
            Eval(17616, o is EmptyClass[], false);
            Eval(17617, o is NotEmptyClass, false);
            Eval(17618, o is NotEmptyClass[], false);
            Eval(17619, o is EmptyClassGen<int>, false);
            Eval(17620, o is EmptyClassGen<int>[], false);
            Eval(17621, o is NotEmptyClassGen<Guid>, false);
            Eval(17622, o is NotEmptyClassGen<Guid>[], false);
            Eval(17623, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(17624, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(17625, o is NestedClass, false);
            Eval(17626, o is NestedClass[], false);
            Eval(17627, o is NestedClassGen<Decimal>, false);
            Eval(17628, o is NestedClassGen<Decimal>[], false);
            Eval(17629, o is ImplementOneInterfaceC, false);
            Eval(17630, o is ImplementOneInterfaceC[], false);
            Eval(17631, o is ImplementTwoInterfaceC, false);
            Eval(17632, o is ImplementTwoInterfaceC[], false);
            Eval(17633, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(17634, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(17635, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(17636, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(17637, o is ImplementAllInterfaceC<int>, false);
            Eval(17638, o is ImplementAllInterfaceC<int>[], false);
            Eval(17639, o is SealedClass, false);
            Eval(17640, o is SealedClass[], false);
        }
    }  // end of test case 0030
    private static void TestCase0031()
    {
        {
            double v = default(double);
            ValueType o = v;
            Eval(17641, o is EmptyStruct, false);
            Eval(17642, o is EmptyStruct[], false);
            Eval(17643, o is EmptyStruct?, false);
            Eval(17644, o is EmptyStruct?[], false);
            Eval(17645, o is NotEmptyStruct, false);
            Eval(17646, o is NotEmptyStruct[], false);
            Eval(17647, o is NotEmptyStruct?, false);
            Eval(17648, o is NotEmptyStruct?[], false);
            Eval(17649, o is EmptyStructGen<int>, false);
            Eval(17650, o is EmptyStructGen<int>[], false);
            Eval(17651, o is EmptyStructGen<int>?, false);
            Eval(17652, o is EmptyStructGen<int>?[], false);
            Eval(17653, o is NotEmptyStructGen<Guid>, false);
            Eval(17654, o is NotEmptyStructGen<Guid>[], false);
            Eval(17655, o is NotEmptyStructGen<Guid>?, false);
            Eval(17656, o is NotEmptyStructGen<Guid>?[], false);
            Eval(17657, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(17658, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(17659, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(17660, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(17661, o is NestedStruct, false);
            Eval(17662, o is NestedStruct[], false);
            Eval(17663, o is NestedStruct?, false);
            Eval(17664, o is NestedStruct?[], false);
            Eval(17665, o is NestedStructGen<Decimal>, false);
            Eval(17666, o is NestedStructGen<Decimal>[], false);
            Eval(17667, o is NestedStructGen<Decimal>?, false);
            Eval(17668, o is NestedStructGen<Decimal>?[], false);
            Eval(17669, o is ExplicitFieldOffsetStruct, false);
            Eval(17670, o is ExplicitFieldOffsetStruct[], false);
            Eval(17671, o is ExplicitFieldOffsetStruct?, false);
            Eval(17672, o is ExplicitFieldOffsetStruct?[], false);
            Eval(17681, o is MarshalAsStruct, false);
            Eval(17682, o is MarshalAsStruct[], false);
            Eval(17683, o is MarshalAsStruct?, false);
            Eval(17684, o is MarshalAsStruct?[], false);
            Eval(17685, o is ImplementOneInterface, false);
            Eval(17686, o is ImplementOneInterface[], false);
            Eval(17687, o is ImplementOneInterface?, false);
            Eval(17688, o is ImplementOneInterface?[], false);
            Eval(17689, o is ImplementTwoInterface, false);
            Eval(17690, o is ImplementTwoInterface[], false);
            Eval(17691, o is ImplementTwoInterface?, false);
            Eval(17692, o is ImplementTwoInterface?[], false);
            Eval(17693, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(17694, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(17695, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(17696, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(17697, o is ImplementTwoInterfaceGen<int>, false);
            Eval(17698, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(17699, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(17700, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(17701, o is ImplementAllInterface<int>, false);
            Eval(17702, o is ImplementAllInterface<int>[], false);
            Eval(17703, o is ImplementAllInterface<int>?, false);
            Eval(17704, o is ImplementAllInterface<int>?[], false);
            Eval(17705, o is IntE, false);
            Eval(17706, o is IntE[], false);
            Eval(17707, o is IntE?, false);
            Eval(17708, o is IntE?[], false);
            Eval(17709, o is ByteE, false);
            Eval(17710, o is ByteE[], false);
            Eval(17711, o is ByteE?, false);
            Eval(17712, o is ByteE?[], false);
            Eval(17713, o is LongE, false);
            Eval(17714, o is LongE[], false);
            Eval(17715, o is LongE?, false);
            Eval(17716, o is LongE?[], false);
            Eval(17717, o is char, false);
            Eval(17718, o is char[], false);
            Eval(17719, o is char?, false);
            Eval(17720, o is char?[], false);
            Eval(17721, o is bool, false);
            Eval(17722, o is bool[], false);
            Eval(17723, o is bool?, false);
            Eval(17724, o is bool?[], false);
            Eval(17725, o is byte, false);
            Eval(17726, o is byte[], false);
            Eval(17727, o is byte?, false);
            Eval(17728, o is byte?[], false);
            Eval(17729, o is sbyte, false);
            Eval(17730, o is sbyte[], false);
            Eval(17731, o is sbyte?, false);
            Eval(17732, o is sbyte?[], false);
            Eval(17733, o is short, false);
            Eval(17734, o is short[], false);
            Eval(17735, o is short?, false);
            Eval(17736, o is short?[], false);
            Eval(17737, o is ushort, false);
            Eval(17738, o is ushort[], false);
            Eval(17739, o is ushort?, false);
            Eval(17740, o is ushort?[], false);
            Eval(17741, o is int, false);
            Eval(17742, o is int[], false);
            Eval(17743, o is int?, false);
            Eval(17744, o is int?[], false);
            Eval(17745, o is uint, false);
            Eval(17746, o is uint[], false);
            Eval(17747, o is uint?, false);
            Eval(17748, o is uint?[], false);
            Eval(17749, o is long, false);
            Eval(17750, o is long[], false);
            Eval(17751, o is long?, false);
            Eval(17752, o is long?[], false);
            Eval(17753, o is ulong, false);
            Eval(17754, o is ulong[], false);
            Eval(17755, o is ulong?, false);
            Eval(17756, o is ulong?[], false);
            Eval(17757, o is float, false);
            Eval(17758, o is float[], false);
            Eval(17759, o is float?, false);
            Eval(17760, o is float?[], false);
            Eval(17761, o is double, true);
            Eval(17762, o is double[], false);
            Eval(17763, o is double?, true);
            Eval(17764, o is double?[], false);
            Eval(17765, o is decimal, false);
            Eval(17766, o is decimal[], false);
            Eval(17767, o is decimal?, false);
            Eval(17768, o is decimal?[], false);
            Eval(17769, o is IntPtr, false);
            Eval(17770, o is IntPtr[], false);
            Eval(17771, o is IntPtr?, false);
            Eval(17772, o is IntPtr?[], false);
            Eval(17773, o is UIntPtr, false);
            Eval(17774, o is UIntPtr[], false);
            Eval(17775, o is UIntPtr?, false);
            Eval(17776, o is UIntPtr?[], false);
            Eval(17777, o is Guid, false);
            Eval(17778, o is Guid[], false);
            Eval(17779, o is Guid?, false);
            Eval(17780, o is Guid?[], false);
            Eval(17781, o is GCHandle, false);
            Eval(17782, o is GCHandle[], false);
            Eval(17783, o is GCHandle?, false);
            Eval(17784, o is GCHandle?[], false);
            Eval(17785, o is object, true);
            Eval(17786, o is object[], false);
            Eval(17787, o is string, false);
            Eval(17788, o is string[], false);
            Eval(17789, o is ValueType, true);
            Eval(17790, o is ValueType[], false);
            Eval(17791, o is Array, false);
            Eval(17792, o is Array[], false);
            Eval(17793, o is Enum, false);
            Eval(17794, o is Enum[], false);
            Eval(17795, o is Delegate, false);
            Eval(17796, o is Delegate[], false);
            Eval(17797, o is MulticastDelegate, false);
            Eval(17798, o is MulticastDelegate[], false);
            Eval(17799, o is IEmpty, false);
            Eval(17800, o is IEmpty[], false);
            Eval(17801, o is INotEmpty, false);
            Eval(17802, o is INotEmpty[], false);
            Eval(17803, o is IEmptyGen<int>, false);
            Eval(17804, o is IEmptyGen<int>[], false);
            Eval(17805, o is INotEmptyGen<int>, false);
            Eval(17806, o is INotEmptyGen<int>[], false);
            Eval(17807, o is SimpleDelegate, false);
            Eval(17808, o is SimpleDelegate[], false);
            Eval(17809, o is GenericDelegate<int>, false);
            Eval(17810, o is GenericDelegate<int>[], false);
            Eval(17811, o is EmptyClass, false);
            Eval(17812, o is EmptyClass[], false);
            Eval(17813, o is NotEmptyClass, false);
            Eval(17814, o is NotEmptyClass[], false);
            Eval(17815, o is EmptyClassGen<int>, false);
            Eval(17816, o is EmptyClassGen<int>[], false);
            Eval(17817, o is NotEmptyClassGen<Guid>, false);
            Eval(17818, o is NotEmptyClassGen<Guid>[], false);
            Eval(17819, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(17820, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(17821, o is NestedClass, false);
            Eval(17822, o is NestedClass[], false);
            Eval(17823, o is NestedClassGen<Decimal>, false);
            Eval(17824, o is NestedClassGen<Decimal>[], false);
            Eval(17825, o is ImplementOneInterfaceC, false);
            Eval(17826, o is ImplementOneInterfaceC[], false);
            Eval(17827, o is ImplementTwoInterfaceC, false);
            Eval(17828, o is ImplementTwoInterfaceC[], false);
            Eval(17829, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(17830, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(17831, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(17832, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(17833, o is ImplementAllInterfaceC<int>, false);
            Eval(17834, o is ImplementAllInterfaceC<int>[], false);
            Eval(17835, o is SealedClass, false);
            Eval(17836, o is SealedClass[], false);
        }
        {
            double? v = default(double);
            ValueType o = v;
            Eval(17837, o is EmptyStruct, false);
            Eval(17838, o is EmptyStruct[], false);
            Eval(17839, o is EmptyStruct?, false);
            Eval(17840, o is EmptyStruct?[], false);
            Eval(17841, o is NotEmptyStruct, false);
            Eval(17842, o is NotEmptyStruct[], false);
            Eval(17843, o is NotEmptyStruct?, false);
            Eval(17844, o is NotEmptyStruct?[], false);
            Eval(17845, o is EmptyStructGen<int>, false);
            Eval(17846, o is EmptyStructGen<int>[], false);
            Eval(17847, o is EmptyStructGen<int>?, false);
            Eval(17848, o is EmptyStructGen<int>?[], false);
            Eval(17849, o is NotEmptyStructGen<Guid>, false);
            Eval(17850, o is NotEmptyStructGen<Guid>[], false);
            Eval(17851, o is NotEmptyStructGen<Guid>?, false);
            Eval(17852, o is NotEmptyStructGen<Guid>?[], false);
            Eval(17853, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(17854, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(17855, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(17856, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(17857, o is NestedStruct, false);
            Eval(17858, o is NestedStruct[], false);
            Eval(17859, o is NestedStruct?, false);
            Eval(17860, o is NestedStruct?[], false);
            Eval(17861, o is NestedStructGen<Decimal>, false);
            Eval(17862, o is NestedStructGen<Decimal>[], false);
            Eval(17863, o is NestedStructGen<Decimal>?, false);
            Eval(17864, o is NestedStructGen<Decimal>?[], false);
            Eval(17865, o is ExplicitFieldOffsetStruct, false);
            Eval(17866, o is ExplicitFieldOffsetStruct[], false);
            Eval(17867, o is ExplicitFieldOffsetStruct?, false);
            Eval(17868, o is ExplicitFieldOffsetStruct?[], false);
            Eval(17877, o is MarshalAsStruct, false);
            Eval(17878, o is MarshalAsStruct[], false);
            Eval(17879, o is MarshalAsStruct?, false);
            Eval(17880, o is MarshalAsStruct?[], false);
            Eval(17881, o is ImplementOneInterface, false);
            Eval(17882, o is ImplementOneInterface[], false);
            Eval(17883, o is ImplementOneInterface?, false);
            Eval(17884, o is ImplementOneInterface?[], false);
            Eval(17885, o is ImplementTwoInterface, false);
            Eval(17886, o is ImplementTwoInterface[], false);
            Eval(17887, o is ImplementTwoInterface?, false);
            Eval(17888, o is ImplementTwoInterface?[], false);
            Eval(17889, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(17890, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(17891, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(17892, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(17893, o is ImplementTwoInterfaceGen<int>, false);
            Eval(17894, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(17895, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(17896, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(17897, o is ImplementAllInterface<int>, false);
            Eval(17898, o is ImplementAllInterface<int>[], false);
            Eval(17899, o is ImplementAllInterface<int>?, false);
            Eval(17900, o is ImplementAllInterface<int>?[], false);
            Eval(17901, o is IntE, false);
            Eval(17902, o is IntE[], false);
            Eval(17903, o is IntE?, false);
            Eval(17904, o is IntE?[], false);
            Eval(17905, o is ByteE, false);
            Eval(17906, o is ByteE[], false);
            Eval(17907, o is ByteE?, false);
            Eval(17908, o is ByteE?[], false);
            Eval(17909, o is LongE, false);
            Eval(17910, o is LongE[], false);
            Eval(17911, o is LongE?, false);
            Eval(17912, o is LongE?[], false);
            Eval(17913, o is char, false);
            Eval(17914, o is char[], false);
            Eval(17915, o is char?, false);
            Eval(17916, o is char?[], false);
            Eval(17917, o is bool, false);
            Eval(17918, o is bool[], false);
            Eval(17919, o is bool?, false);
            Eval(17920, o is bool?[], false);
            Eval(17921, o is byte, false);
            Eval(17922, o is byte[], false);
            Eval(17923, o is byte?, false);
            Eval(17924, o is byte?[], false);
            Eval(17925, o is sbyte, false);
            Eval(17926, o is sbyte[], false);
            Eval(17927, o is sbyte?, false);
            Eval(17928, o is sbyte?[], false);
            Eval(17929, o is short, false);
            Eval(17930, o is short[], false);
            Eval(17931, o is short?, false);
            Eval(17932, o is short?[], false);
            Eval(17933, o is ushort, false);
            Eval(17934, o is ushort[], false);
            Eval(17935, o is ushort?, false);
            Eval(17936, o is ushort?[], false);
            Eval(17937, o is int, false);
            Eval(17938, o is int[], false);
            Eval(17939, o is int?, false);
            Eval(17940, o is int?[], false);
            Eval(17941, o is uint, false);
            Eval(17942, o is uint[], false);
            Eval(17943, o is uint?, false);
            Eval(17944, o is uint?[], false);
            Eval(17945, o is long, false);
            Eval(17946, o is long[], false);
            Eval(17947, o is long?, false);
            Eval(17948, o is long?[], false);
            Eval(17949, o is ulong, false);
            Eval(17950, o is ulong[], false);
            Eval(17951, o is ulong?, false);
            Eval(17952, o is ulong?[], false);
            Eval(17953, o is float, false);
            Eval(17954, o is float[], false);
            Eval(17955, o is float?, false);
            Eval(17956, o is float?[], false);
            Eval(17957, o is double, true);
            Eval(17958, o is double[], false);
            Eval(17959, o is double?, true);
            Eval(17960, o is double?[], false);
            Eval(17961, o is decimal, false);
            Eval(17962, o is decimal[], false);
            Eval(17963, o is decimal?, false);
            Eval(17964, o is decimal?[], false);
            Eval(17965, o is IntPtr, false);
            Eval(17966, o is IntPtr[], false);
            Eval(17967, o is IntPtr?, false);
            Eval(17968, o is IntPtr?[], false);
            Eval(17969, o is UIntPtr, false);
            Eval(17970, o is UIntPtr[], false);
            Eval(17971, o is UIntPtr?, false);
            Eval(17972, o is UIntPtr?[], false);
            Eval(17973, o is Guid, false);
            Eval(17974, o is Guid[], false);
            Eval(17975, o is Guid?, false);
            Eval(17976, o is Guid?[], false);
            Eval(17977, o is GCHandle, false);
            Eval(17978, o is GCHandle[], false);
            Eval(17979, o is GCHandle?, false);
            Eval(17980, o is GCHandle?[], false);
            Eval(17981, o is object, true);
            Eval(17982, o is object[], false);
            Eval(17983, o is string, false);
            Eval(17984, o is string[], false);
            Eval(17985, o is ValueType, true);
            Eval(17986, o is ValueType[], false);
            Eval(17987, o is Array, false);
            Eval(17988, o is Array[], false);
            Eval(17989, o is Enum, false);
            Eval(17990, o is Enum[], false);
            Eval(17991, o is Delegate, false);
            Eval(17992, o is Delegate[], false);
            Eval(17993, o is MulticastDelegate, false);
            Eval(17994, o is MulticastDelegate[], false);
            Eval(17995, o is IEmpty, false);
            Eval(17996, o is IEmpty[], false);
            Eval(17997, o is INotEmpty, false);
            Eval(17998, o is INotEmpty[], false);
            Eval(17999, o is IEmptyGen<int>, false);
            Eval(18000, o is IEmptyGen<int>[], false);
            Eval(18001, o is INotEmptyGen<int>, false);
            Eval(18002, o is INotEmptyGen<int>[], false);
            Eval(18003, o is SimpleDelegate, false);
            Eval(18004, o is SimpleDelegate[], false);
            Eval(18005, o is GenericDelegate<int>, false);
            Eval(18006, o is GenericDelegate<int>[], false);
            Eval(18007, o is EmptyClass, false);
            Eval(18008, o is EmptyClass[], false);
            Eval(18009, o is NotEmptyClass, false);
            Eval(18010, o is NotEmptyClass[], false);
            Eval(18011, o is EmptyClassGen<int>, false);
            Eval(18012, o is EmptyClassGen<int>[], false);
            Eval(18013, o is NotEmptyClassGen<Guid>, false);
            Eval(18014, o is NotEmptyClassGen<Guid>[], false);
            Eval(18015, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(18016, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(18017, o is NestedClass, false);
            Eval(18018, o is NestedClass[], false);
            Eval(18019, o is NestedClassGen<Decimal>, false);
            Eval(18020, o is NestedClassGen<Decimal>[], false);
            Eval(18021, o is ImplementOneInterfaceC, false);
            Eval(18022, o is ImplementOneInterfaceC[], false);
            Eval(18023, o is ImplementTwoInterfaceC, false);
            Eval(18024, o is ImplementTwoInterfaceC[], false);
            Eval(18025, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(18026, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(18027, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(18028, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(18029, o is ImplementAllInterfaceC<int>, false);
            Eval(18030, o is ImplementAllInterfaceC<int>[], false);
            Eval(18031, o is SealedClass, false);
            Eval(18032, o is SealedClass[], false);
        }
        {
            double? v = default(double?);
            ValueType o = v;
            Eval(18033, o is EmptyStruct, false);
            Eval(18034, o is EmptyStruct[], false);
            Eval(18035, o is EmptyStruct?, false);
            Eval(18036, o is EmptyStruct?[], false);
            Eval(18037, o is NotEmptyStruct, false);
            Eval(18038, o is NotEmptyStruct[], false);
            Eval(18039, o is NotEmptyStruct?, false);
            Eval(18040, o is NotEmptyStruct?[], false);
            Eval(18041, o is EmptyStructGen<int>, false);
            Eval(18042, o is EmptyStructGen<int>[], false);
            Eval(18043, o is EmptyStructGen<int>?, false);
            Eval(18044, o is EmptyStructGen<int>?[], false);
            Eval(18045, o is NotEmptyStructGen<Guid>, false);
            Eval(18046, o is NotEmptyStructGen<Guid>[], false);
            Eval(18047, o is NotEmptyStructGen<Guid>?, false);
            Eval(18048, o is NotEmptyStructGen<Guid>?[], false);
            Eval(18049, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(18050, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(18051, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(18052, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(18053, o is NestedStruct, false);
            Eval(18054, o is NestedStruct[], false);
            Eval(18055, o is NestedStruct?, false);
            Eval(18056, o is NestedStruct?[], false);
            Eval(18057, o is NestedStructGen<Decimal>, false);
            Eval(18058, o is NestedStructGen<Decimal>[], false);
            Eval(18059, o is NestedStructGen<Decimal>?, false);
            Eval(18060, o is NestedStructGen<Decimal>?[], false);
            Eval(18061, o is ExplicitFieldOffsetStruct, false);
            Eval(18062, o is ExplicitFieldOffsetStruct[], false);
            Eval(18063, o is ExplicitFieldOffsetStruct?, false);
            Eval(18064, o is ExplicitFieldOffsetStruct?[], false);
            Eval(18073, o is MarshalAsStruct, false);
            Eval(18074, o is MarshalAsStruct[], false);
            Eval(18075, o is MarshalAsStruct?, false);
            Eval(18076, o is MarshalAsStruct?[], false);
            Eval(18077, o is ImplementOneInterface, false);
            Eval(18078, o is ImplementOneInterface[], false);
            Eval(18079, o is ImplementOneInterface?, false);
            Eval(18080, o is ImplementOneInterface?[], false);
            Eval(18081, o is ImplementTwoInterface, false);
            Eval(18082, o is ImplementTwoInterface[], false);
            Eval(18083, o is ImplementTwoInterface?, false);
            Eval(18084, o is ImplementTwoInterface?[], false);
            Eval(18085, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(18086, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(18087, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(18088, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(18089, o is ImplementTwoInterfaceGen<int>, false);
            Eval(18090, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(18091, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(18092, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(18093, o is ImplementAllInterface<int>, false);
            Eval(18094, o is ImplementAllInterface<int>[], false);
            Eval(18095, o is ImplementAllInterface<int>?, false);
            Eval(18096, o is ImplementAllInterface<int>?[], false);
            Eval(18097, o is IntE, false);
            Eval(18098, o is IntE[], false);
            Eval(18099, o is IntE?, false);
            Eval(18100, o is IntE?[], false);
            Eval(18101, o is ByteE, false);
            Eval(18102, o is ByteE[], false);
            Eval(18103, o is ByteE?, false);
            Eval(18104, o is ByteE?[], false);
            Eval(18105, o is LongE, false);
            Eval(18106, o is LongE[], false);
            Eval(18107, o is LongE?, false);
            Eval(18108, o is LongE?[], false);
            Eval(18109, o is char, false);
            Eval(18110, o is char[], false);
            Eval(18111, o is char?, false);
            Eval(18112, o is char?[], false);
            Eval(18113, o is bool, false);
            Eval(18114, o is bool[], false);
            Eval(18115, o is bool?, false);
            Eval(18116, o is bool?[], false);
            Eval(18117, o is byte, false);
            Eval(18118, o is byte[], false);
            Eval(18119, o is byte?, false);
            Eval(18120, o is byte?[], false);
            Eval(18121, o is sbyte, false);
            Eval(18122, o is sbyte[], false);
            Eval(18123, o is sbyte?, false);
            Eval(18124, o is sbyte?[], false);
            Eval(18125, o is short, false);
            Eval(18126, o is short[], false);
            Eval(18127, o is short?, false);
            Eval(18128, o is short?[], false);
            Eval(18129, o is ushort, false);
            Eval(18130, o is ushort[], false);
            Eval(18131, o is ushort?, false);
            Eval(18132, o is ushort?[], false);
            Eval(18133, o is int, false);
            Eval(18134, o is int[], false);
            Eval(18135, o is int?, false);
            Eval(18136, o is int?[], false);
            Eval(18137, o is uint, false);
            Eval(18138, o is uint[], false);
            Eval(18139, o is uint?, false);
            Eval(18140, o is uint?[], false);
            Eval(18141, o is long, false);
            Eval(18142, o is long[], false);
            Eval(18143, o is long?, false);
            Eval(18144, o is long?[], false);
            Eval(18145, o is ulong, false);
            Eval(18146, o is ulong[], false);
            Eval(18147, o is ulong?, false);
            Eval(18148, o is ulong?[], false);
            Eval(18149, o is float, false);
            Eval(18150, o is float[], false);
            Eval(18151, o is float?, false);
            Eval(18152, o is float?[], false);
            Eval(18153, o is double, false);
            Eval(18154, o is double[], false);
            Eval(18155, o is double?, false);
            Eval(18156, o is double?[], false);
            Eval(18157, o is decimal, false);
            Eval(18158, o is decimal[], false);
            Eval(18159, o is decimal?, false);
            Eval(18160, o is decimal?[], false);
            Eval(18161, o is IntPtr, false);
            Eval(18162, o is IntPtr[], false);
            Eval(18163, o is IntPtr?, false);
            Eval(18164, o is IntPtr?[], false);
            Eval(18165, o is UIntPtr, false);
            Eval(18166, o is UIntPtr[], false);
            Eval(18167, o is UIntPtr?, false);
            Eval(18168, o is UIntPtr?[], false);
            Eval(18169, o is Guid, false);
            Eval(18170, o is Guid[], false);
            Eval(18171, o is Guid?, false);
            Eval(18172, o is Guid?[], false);
            Eval(18173, o is GCHandle, false);
            Eval(18174, o is GCHandle[], false);
            Eval(18175, o is GCHandle?, false);
            Eval(18176, o is GCHandle?[], false);
            Eval(18177, o is object, false);
            Eval(18178, o is object[], false);
            Eval(18179, o is string, false);
            Eval(18180, o is string[], false);
            Eval(18181, o is ValueType, false);
            Eval(18182, o is ValueType[], false);
            Eval(18183, o is Array, false);
            Eval(18184, o is Array[], false);
            Eval(18185, o is Enum, false);
            Eval(18186, o is Enum[], false);
            Eval(18187, o is Delegate, false);
            Eval(18188, o is Delegate[], false);
            Eval(18189, o is MulticastDelegate, false);
            Eval(18190, o is MulticastDelegate[], false);
            Eval(18191, o is IEmpty, false);
            Eval(18192, o is IEmpty[], false);
            Eval(18193, o is INotEmpty, false);
            Eval(18194, o is INotEmpty[], false);
            Eval(18195, o is IEmptyGen<int>, false);
            Eval(18196, o is IEmptyGen<int>[], false);
            Eval(18197, o is INotEmptyGen<int>, false);
            Eval(18198, o is INotEmptyGen<int>[], false);
            Eval(18199, o is SimpleDelegate, false);
            Eval(18200, o is SimpleDelegate[], false);
            Eval(18201, o is GenericDelegate<int>, false);
            Eval(18202, o is GenericDelegate<int>[], false);
            Eval(18203, o is EmptyClass, false);
            Eval(18204, o is EmptyClass[], false);
            Eval(18205, o is NotEmptyClass, false);
            Eval(18206, o is NotEmptyClass[], false);
            Eval(18207, o is EmptyClassGen<int>, false);
            Eval(18208, o is EmptyClassGen<int>[], false);
            Eval(18209, o is NotEmptyClassGen<Guid>, false);
            Eval(18210, o is NotEmptyClassGen<Guid>[], false);
            Eval(18211, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(18212, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(18213, o is NestedClass, false);
            Eval(18214, o is NestedClass[], false);
            Eval(18215, o is NestedClassGen<Decimal>, false);
            Eval(18216, o is NestedClassGen<Decimal>[], false);
            Eval(18217, o is ImplementOneInterfaceC, false);
            Eval(18218, o is ImplementOneInterfaceC[], false);
            Eval(18219, o is ImplementTwoInterfaceC, false);
            Eval(18220, o is ImplementTwoInterfaceC[], false);
            Eval(18221, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(18222, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(18223, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(18224, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(18225, o is ImplementAllInterfaceC<int>, false);
            Eval(18226, o is ImplementAllInterfaceC<int>[], false);
            Eval(18227, o is SealedClass, false);
            Eval(18228, o is SealedClass[], false);
        }
    }  // end of test case 0031
    private static void TestCase0032()
    {
        {
            decimal v = default(decimal);
            ValueType o = v;
            Eval(18229, o is EmptyStruct, false);
            Eval(18230, o is EmptyStruct[], false);
            Eval(18231, o is EmptyStruct?, false);
            Eval(18232, o is EmptyStruct?[], false);
            Eval(18233, o is NotEmptyStruct, false);
            Eval(18234, o is NotEmptyStruct[], false);
            Eval(18235, o is NotEmptyStruct?, false);
            Eval(18236, o is NotEmptyStruct?[], false);
            Eval(18237, o is EmptyStructGen<int>, false);
            Eval(18238, o is EmptyStructGen<int>[], false);
            Eval(18239, o is EmptyStructGen<int>?, false);
            Eval(18240, o is EmptyStructGen<int>?[], false);
            Eval(18241, o is NotEmptyStructGen<Guid>, false);
            Eval(18242, o is NotEmptyStructGen<Guid>[], false);
            Eval(18243, o is NotEmptyStructGen<Guid>?, false);
            Eval(18244, o is NotEmptyStructGen<Guid>?[], false);
            Eval(18245, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(18246, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(18247, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(18248, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(18249, o is NestedStruct, false);
            Eval(18250, o is NestedStruct[], false);
            Eval(18251, o is NestedStruct?, false);
            Eval(18252, o is NestedStruct?[], false);
            Eval(18253, o is NestedStructGen<Decimal>, false);
            Eval(18254, o is NestedStructGen<Decimal>[], false);
            Eval(18255, o is NestedStructGen<Decimal>?, false);
            Eval(18256, o is NestedStructGen<Decimal>?[], false);
            Eval(18257, o is ExplicitFieldOffsetStruct, false);
            Eval(18258, o is ExplicitFieldOffsetStruct[], false);
            Eval(18259, o is ExplicitFieldOffsetStruct?, false);
            Eval(18260, o is ExplicitFieldOffsetStruct?[], false);
            Eval(18269, o is MarshalAsStruct, false);
            Eval(18270, o is MarshalAsStruct[], false);
            Eval(18271, o is MarshalAsStruct?, false);
            Eval(18272, o is MarshalAsStruct?[], false);
            Eval(18273, o is ImplementOneInterface, false);
            Eval(18274, o is ImplementOneInterface[], false);
            Eval(18275, o is ImplementOneInterface?, false);
            Eval(18276, o is ImplementOneInterface?[], false);
            Eval(18277, o is ImplementTwoInterface, false);
            Eval(18278, o is ImplementTwoInterface[], false);
            Eval(18279, o is ImplementTwoInterface?, false);
            Eval(18280, o is ImplementTwoInterface?[], false);
            Eval(18281, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(18282, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(18283, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(18284, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(18285, o is ImplementTwoInterfaceGen<int>, false);
            Eval(18286, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(18287, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(18288, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(18289, o is ImplementAllInterface<int>, false);
            Eval(18290, o is ImplementAllInterface<int>[], false);
            Eval(18291, o is ImplementAllInterface<int>?, false);
            Eval(18292, o is ImplementAllInterface<int>?[], false);
            Eval(18293, o is IntE, false);
            Eval(18294, o is IntE[], false);
            Eval(18295, o is IntE?, false);
            Eval(18296, o is IntE?[], false);
            Eval(18297, o is ByteE, false);
            Eval(18298, o is ByteE[], false);
            Eval(18299, o is ByteE?, false);
            Eval(18300, o is ByteE?[], false);
            Eval(18301, o is LongE, false);
            Eval(18302, o is LongE[], false);
            Eval(18303, o is LongE?, false);
            Eval(18304, o is LongE?[], false);
            Eval(18305, o is char, false);
            Eval(18306, o is char[], false);
            Eval(18307, o is char?, false);
            Eval(18308, o is char?[], false);
            Eval(18309, o is bool, false);
            Eval(18310, o is bool[], false);
            Eval(18311, o is bool?, false);
            Eval(18312, o is bool?[], false);
            Eval(18313, o is byte, false);
            Eval(18314, o is byte[], false);
            Eval(18315, o is byte?, false);
            Eval(18316, o is byte?[], false);
            Eval(18317, o is sbyte, false);
            Eval(18318, o is sbyte[], false);
            Eval(18319, o is sbyte?, false);
            Eval(18320, o is sbyte?[], false);
            Eval(18321, o is short, false);
            Eval(18322, o is short[], false);
            Eval(18323, o is short?, false);
            Eval(18324, o is short?[], false);
            Eval(18325, o is ushort, false);
            Eval(18326, o is ushort[], false);
            Eval(18327, o is ushort?, false);
            Eval(18328, o is ushort?[], false);
            Eval(18329, o is int, false);
            Eval(18330, o is int[], false);
            Eval(18331, o is int?, false);
            Eval(18332, o is int?[], false);
            Eval(18333, o is uint, false);
            Eval(18334, o is uint[], false);
            Eval(18335, o is uint?, false);
            Eval(18336, o is uint?[], false);
            Eval(18337, o is long, false);
            Eval(18338, o is long[], false);
            Eval(18339, o is long?, false);
            Eval(18340, o is long?[], false);
            Eval(18341, o is ulong, false);
            Eval(18342, o is ulong[], false);
            Eval(18343, o is ulong?, false);
            Eval(18344, o is ulong?[], false);
            Eval(18345, o is float, false);
            Eval(18346, o is float[], false);
            Eval(18347, o is float?, false);
            Eval(18348, o is float?[], false);
            Eval(18349, o is double, false);
            Eval(18350, o is double[], false);
            Eval(18351, o is double?, false);
            Eval(18352, o is double?[], false);
            Eval(18353, o is decimal, true);
            Eval(18354, o is decimal[], false);
            Eval(18355, o is decimal?, true);
            Eval(18356, o is decimal?[], false);
            Eval(18357, o is IntPtr, false);
            Eval(18358, o is IntPtr[], false);
            Eval(18359, o is IntPtr?, false);
            Eval(18360, o is IntPtr?[], false);
            Eval(18361, o is UIntPtr, false);
            Eval(18362, o is UIntPtr[], false);
            Eval(18363, o is UIntPtr?, false);
            Eval(18364, o is UIntPtr?[], false);
            Eval(18365, o is Guid, false);
            Eval(18366, o is Guid[], false);
            Eval(18367, o is Guid?, false);
            Eval(18368, o is Guid?[], false);
            Eval(18369, o is GCHandle, false);
            Eval(18370, o is GCHandle[], false);
            Eval(18371, o is GCHandle?, false);
            Eval(18372, o is GCHandle?[], false);
            Eval(18373, o is object, true);
            Eval(18374, o is object[], false);
            Eval(18375, o is string, false);
            Eval(18376, o is string[], false);
            Eval(18377, o is ValueType, true);
            Eval(18378, o is ValueType[], false);
            Eval(18379, o is Array, false);
            Eval(18380, o is Array[], false);
            Eval(18381, o is Enum, false);
            Eval(18382, o is Enum[], false);
            Eval(18383, o is Delegate, false);
            Eval(18384, o is Delegate[], false);
            Eval(18385, o is MulticastDelegate, false);
            Eval(18386, o is MulticastDelegate[], false);
            Eval(18387, o is IEmpty, false);
            Eval(18388, o is IEmpty[], false);
            Eval(18389, o is INotEmpty, false);
            Eval(18390, o is INotEmpty[], false);
            Eval(18391, o is IEmptyGen<int>, false);
            Eval(18392, o is IEmptyGen<int>[], false);
            Eval(18393, o is INotEmptyGen<int>, false);
            Eval(18394, o is INotEmptyGen<int>[], false);
            Eval(18395, o is SimpleDelegate, false);
            Eval(18396, o is SimpleDelegate[], false);
            Eval(18397, o is GenericDelegate<int>, false);
            Eval(18398, o is GenericDelegate<int>[], false);
            Eval(18399, o is EmptyClass, false);
            Eval(18400, o is EmptyClass[], false);
            Eval(18401, o is NotEmptyClass, false);
            Eval(18402, o is NotEmptyClass[], false);
            Eval(18403, o is EmptyClassGen<int>, false);
            Eval(18404, o is EmptyClassGen<int>[], false);
            Eval(18405, o is NotEmptyClassGen<Guid>, false);
            Eval(18406, o is NotEmptyClassGen<Guid>[], false);
            Eval(18407, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(18408, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(18409, o is NestedClass, false);
            Eval(18410, o is NestedClass[], false);
            Eval(18411, o is NestedClassGen<Decimal>, false);
            Eval(18412, o is NestedClassGen<Decimal>[], false);
            Eval(18413, o is ImplementOneInterfaceC, false);
            Eval(18414, o is ImplementOneInterfaceC[], false);
            Eval(18415, o is ImplementTwoInterfaceC, false);
            Eval(18416, o is ImplementTwoInterfaceC[], false);
            Eval(18417, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(18418, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(18419, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(18420, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(18421, o is ImplementAllInterfaceC<int>, false);
            Eval(18422, o is ImplementAllInterfaceC<int>[], false);
            Eval(18423, o is SealedClass, false);
            Eval(18424, o is SealedClass[], false);
        }
        {
            decimal? v = default(decimal);
            ValueType o = v;
            Eval(18425, o is EmptyStruct, false);
            Eval(18426, o is EmptyStruct[], false);
            Eval(18427, o is EmptyStruct?, false);
            Eval(18428, o is EmptyStruct?[], false);
            Eval(18429, o is NotEmptyStruct, false);
            Eval(18430, o is NotEmptyStruct[], false);
            Eval(18431, o is NotEmptyStruct?, false);
            Eval(18432, o is NotEmptyStruct?[], false);
            Eval(18433, o is EmptyStructGen<int>, false);
            Eval(18434, o is EmptyStructGen<int>[], false);
            Eval(18435, o is EmptyStructGen<int>?, false);
            Eval(18436, o is EmptyStructGen<int>?[], false);
            Eval(18437, o is NotEmptyStructGen<Guid>, false);
            Eval(18438, o is NotEmptyStructGen<Guid>[], false);
            Eval(18439, o is NotEmptyStructGen<Guid>?, false);
            Eval(18440, o is NotEmptyStructGen<Guid>?[], false);
            Eval(18441, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(18442, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(18443, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(18444, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(18445, o is NestedStruct, false);
            Eval(18446, o is NestedStruct[], false);
            Eval(18447, o is NestedStruct?, false);
            Eval(18448, o is NestedStruct?[], false);
            Eval(18449, o is NestedStructGen<Decimal>, false);
            Eval(18450, o is NestedStructGen<Decimal>[], false);
            Eval(18451, o is NestedStructGen<Decimal>?, false);
            Eval(18452, o is NestedStructGen<Decimal>?[], false);
            Eval(18453, o is ExplicitFieldOffsetStruct, false);
            Eval(18454, o is ExplicitFieldOffsetStruct[], false);
            Eval(18455, o is ExplicitFieldOffsetStruct?, false);
            Eval(18456, o is ExplicitFieldOffsetStruct?[], false);
            Eval(18465, o is MarshalAsStruct, false);
            Eval(18466, o is MarshalAsStruct[], false);
            Eval(18467, o is MarshalAsStruct?, false);
            Eval(18468, o is MarshalAsStruct?[], false);
            Eval(18469, o is ImplementOneInterface, false);
            Eval(18470, o is ImplementOneInterface[], false);
            Eval(18471, o is ImplementOneInterface?, false);
            Eval(18472, o is ImplementOneInterface?[], false);
            Eval(18473, o is ImplementTwoInterface, false);
            Eval(18474, o is ImplementTwoInterface[], false);
            Eval(18475, o is ImplementTwoInterface?, false);
            Eval(18476, o is ImplementTwoInterface?[], false);
            Eval(18477, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(18478, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(18479, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(18480, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(18481, o is ImplementTwoInterfaceGen<int>, false);
            Eval(18482, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(18483, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(18484, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(18485, o is ImplementAllInterface<int>, false);
            Eval(18486, o is ImplementAllInterface<int>[], false);
            Eval(18487, o is ImplementAllInterface<int>?, false);
            Eval(18488, o is ImplementAllInterface<int>?[], false);
            Eval(18489, o is IntE, false);
            Eval(18490, o is IntE[], false);
            Eval(18491, o is IntE?, false);
            Eval(18492, o is IntE?[], false);
            Eval(18493, o is ByteE, false);
            Eval(18494, o is ByteE[], false);
            Eval(18495, o is ByteE?, false);
            Eval(18496, o is ByteE?[], false);
            Eval(18497, o is LongE, false);
            Eval(18498, o is LongE[], false);
            Eval(18499, o is LongE?, false);
            Eval(18500, o is LongE?[], false);
            Eval(18501, o is char, false);
            Eval(18502, o is char[], false);
            Eval(18503, o is char?, false);
            Eval(18504, o is char?[], false);
            Eval(18505, o is bool, false);
            Eval(18506, o is bool[], false);
            Eval(18507, o is bool?, false);
            Eval(18508, o is bool?[], false);
            Eval(18509, o is byte, false);
            Eval(18510, o is byte[], false);
            Eval(18511, o is byte?, false);
            Eval(18512, o is byte?[], false);
            Eval(18513, o is sbyte, false);
            Eval(18514, o is sbyte[], false);
            Eval(18515, o is sbyte?, false);
            Eval(18516, o is sbyte?[], false);
            Eval(18517, o is short, false);
            Eval(18518, o is short[], false);
            Eval(18519, o is short?, false);
            Eval(18520, o is short?[], false);
            Eval(18521, o is ushort, false);
            Eval(18522, o is ushort[], false);
            Eval(18523, o is ushort?, false);
            Eval(18524, o is ushort?[], false);
            Eval(18525, o is int, false);
            Eval(18526, o is int[], false);
            Eval(18527, o is int?, false);
            Eval(18528, o is int?[], false);
            Eval(18529, o is uint, false);
            Eval(18530, o is uint[], false);
            Eval(18531, o is uint?, false);
            Eval(18532, o is uint?[], false);
            Eval(18533, o is long, false);
            Eval(18534, o is long[], false);
            Eval(18535, o is long?, false);
            Eval(18536, o is long?[], false);
            Eval(18537, o is ulong, false);
            Eval(18538, o is ulong[], false);
            Eval(18539, o is ulong?, false);
            Eval(18540, o is ulong?[], false);
            Eval(18541, o is float, false);
            Eval(18542, o is float[], false);
            Eval(18543, o is float?, false);
            Eval(18544, o is float?[], false);
            Eval(18545, o is double, false);
            Eval(18546, o is double[], false);
            Eval(18547, o is double?, false);
            Eval(18548, o is double?[], false);
            Eval(18549, o is decimal, true);
            Eval(18550, o is decimal[], false);
            Eval(18551, o is decimal?, true);
            Eval(18552, o is decimal?[], false);
            Eval(18553, o is IntPtr, false);
            Eval(18554, o is IntPtr[], false);
            Eval(18555, o is IntPtr?, false);
            Eval(18556, o is IntPtr?[], false);
            Eval(18557, o is UIntPtr, false);
            Eval(18558, o is UIntPtr[], false);
            Eval(18559, o is UIntPtr?, false);
            Eval(18560, o is UIntPtr?[], false);
            Eval(18561, o is Guid, false);
            Eval(18562, o is Guid[], false);
            Eval(18563, o is Guid?, false);
            Eval(18564, o is Guid?[], false);
            Eval(18565, o is GCHandle, false);
            Eval(18566, o is GCHandle[], false);
            Eval(18567, o is GCHandle?, false);
            Eval(18568, o is GCHandle?[], false);
            Eval(18569, o is object, true);
            Eval(18570, o is object[], false);
            Eval(18571, o is string, false);
            Eval(18572, o is string[], false);
            Eval(18573, o is ValueType, true);
            Eval(18574, o is ValueType[], false);
            Eval(18575, o is Array, false);
            Eval(18576, o is Array[], false);
            Eval(18577, o is Enum, false);
            Eval(18578, o is Enum[], false);
            Eval(18579, o is Delegate, false);
            Eval(18580, o is Delegate[], false);
            Eval(18581, o is MulticastDelegate, false);
            Eval(18582, o is MulticastDelegate[], false);
            Eval(18583, o is IEmpty, false);
            Eval(18584, o is IEmpty[], false);
            Eval(18585, o is INotEmpty, false);
            Eval(18586, o is INotEmpty[], false);
            Eval(18587, o is IEmptyGen<int>, false);
            Eval(18588, o is IEmptyGen<int>[], false);
            Eval(18589, o is INotEmptyGen<int>, false);
            Eval(18590, o is INotEmptyGen<int>[], false);
            Eval(18591, o is SimpleDelegate, false);
            Eval(18592, o is SimpleDelegate[], false);
            Eval(18593, o is GenericDelegate<int>, false);
            Eval(18594, o is GenericDelegate<int>[], false);
            Eval(18595, o is EmptyClass, false);
            Eval(18596, o is EmptyClass[], false);
            Eval(18597, o is NotEmptyClass, false);
            Eval(18598, o is NotEmptyClass[], false);
            Eval(18599, o is EmptyClassGen<int>, false);
            Eval(18600, o is EmptyClassGen<int>[], false);
            Eval(18601, o is NotEmptyClassGen<Guid>, false);
            Eval(18602, o is NotEmptyClassGen<Guid>[], false);
            Eval(18603, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(18604, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(18605, o is NestedClass, false);
            Eval(18606, o is NestedClass[], false);
            Eval(18607, o is NestedClassGen<Decimal>, false);
            Eval(18608, o is NestedClassGen<Decimal>[], false);
            Eval(18609, o is ImplementOneInterfaceC, false);
            Eval(18610, o is ImplementOneInterfaceC[], false);
            Eval(18611, o is ImplementTwoInterfaceC, false);
            Eval(18612, o is ImplementTwoInterfaceC[], false);
            Eval(18613, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(18614, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(18615, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(18616, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(18617, o is ImplementAllInterfaceC<int>, false);
            Eval(18618, o is ImplementAllInterfaceC<int>[], false);
            Eval(18619, o is SealedClass, false);
            Eval(18620, o is SealedClass[], false);
        }
        {
            decimal? v = default(decimal?);
            ValueType o = v;
            Eval(18621, o is EmptyStruct, false);
            Eval(18622, o is EmptyStruct[], false);
            Eval(18623, o is EmptyStruct?, false);
            Eval(18624, o is EmptyStruct?[], false);
            Eval(18625, o is NotEmptyStruct, false);
            Eval(18626, o is NotEmptyStruct[], false);
            Eval(18627, o is NotEmptyStruct?, false);
            Eval(18628, o is NotEmptyStruct?[], false);
            Eval(18629, o is EmptyStructGen<int>, false);
            Eval(18630, o is EmptyStructGen<int>[], false);
            Eval(18631, o is EmptyStructGen<int>?, false);
            Eval(18632, o is EmptyStructGen<int>?[], false);
            Eval(18633, o is NotEmptyStructGen<Guid>, false);
            Eval(18634, o is NotEmptyStructGen<Guid>[], false);
            Eval(18635, o is NotEmptyStructGen<Guid>?, false);
            Eval(18636, o is NotEmptyStructGen<Guid>?[], false);
            Eval(18637, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(18638, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(18639, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(18640, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(18641, o is NestedStruct, false);
            Eval(18642, o is NestedStruct[], false);
            Eval(18643, o is NestedStruct?, false);
            Eval(18644, o is NestedStruct?[], false);
            Eval(18645, o is NestedStructGen<Decimal>, false);
            Eval(18646, o is NestedStructGen<Decimal>[], false);
            Eval(18647, o is NestedStructGen<Decimal>?, false);
            Eval(18648, o is NestedStructGen<Decimal>?[], false);
            Eval(18649, o is ExplicitFieldOffsetStruct, false);
            Eval(18650, o is ExplicitFieldOffsetStruct[], false);
            Eval(18651, o is ExplicitFieldOffsetStruct?, false);
            Eval(18652, o is ExplicitFieldOffsetStruct?[], false);
            Eval(18661, o is MarshalAsStruct, false);
            Eval(18662, o is MarshalAsStruct[], false);
            Eval(18663, o is MarshalAsStruct?, false);
            Eval(18664, o is MarshalAsStruct?[], false);
            Eval(18665, o is ImplementOneInterface, false);
            Eval(18666, o is ImplementOneInterface[], false);
            Eval(18667, o is ImplementOneInterface?, false);
            Eval(18668, o is ImplementOneInterface?[], false);
            Eval(18669, o is ImplementTwoInterface, false);
            Eval(18670, o is ImplementTwoInterface[], false);
            Eval(18671, o is ImplementTwoInterface?, false);
            Eval(18672, o is ImplementTwoInterface?[], false);
            Eval(18673, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(18674, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(18675, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(18676, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(18677, o is ImplementTwoInterfaceGen<int>, false);
            Eval(18678, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(18679, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(18680, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(18681, o is ImplementAllInterface<int>, false);
            Eval(18682, o is ImplementAllInterface<int>[], false);
            Eval(18683, o is ImplementAllInterface<int>?, false);
            Eval(18684, o is ImplementAllInterface<int>?[], false);
            Eval(18685, o is IntE, false);
            Eval(18686, o is IntE[], false);
            Eval(18687, o is IntE?, false);
            Eval(18688, o is IntE?[], false);
            Eval(18689, o is ByteE, false);
            Eval(18690, o is ByteE[], false);
            Eval(18691, o is ByteE?, false);
            Eval(18692, o is ByteE?[], false);
            Eval(18693, o is LongE, false);
            Eval(18694, o is LongE[], false);
            Eval(18695, o is LongE?, false);
            Eval(18696, o is LongE?[], false);
            Eval(18697, o is char, false);
            Eval(18698, o is char[], false);
            Eval(18699, o is char?, false);
            Eval(18700, o is char?[], false);
            Eval(18701, o is bool, false);
            Eval(18702, o is bool[], false);
            Eval(18703, o is bool?, false);
            Eval(18704, o is bool?[], false);
            Eval(18705, o is byte, false);
            Eval(18706, o is byte[], false);
            Eval(18707, o is byte?, false);
            Eval(18708, o is byte?[], false);
            Eval(18709, o is sbyte, false);
            Eval(18710, o is sbyte[], false);
            Eval(18711, o is sbyte?, false);
            Eval(18712, o is sbyte?[], false);
            Eval(18713, o is short, false);
            Eval(18714, o is short[], false);
            Eval(18715, o is short?, false);
            Eval(18716, o is short?[], false);
            Eval(18717, o is ushort, false);
            Eval(18718, o is ushort[], false);
            Eval(18719, o is ushort?, false);
            Eval(18720, o is ushort?[], false);
            Eval(18721, o is int, false);
            Eval(18722, o is int[], false);
            Eval(18723, o is int?, false);
            Eval(18724, o is int?[], false);
            Eval(18725, o is uint, false);
            Eval(18726, o is uint[], false);
            Eval(18727, o is uint?, false);
            Eval(18728, o is uint?[], false);
            Eval(18729, o is long, false);
            Eval(18730, o is long[], false);
            Eval(18731, o is long?, false);
            Eval(18732, o is long?[], false);
            Eval(18733, o is ulong, false);
            Eval(18734, o is ulong[], false);
            Eval(18735, o is ulong?, false);
            Eval(18736, o is ulong?[], false);
            Eval(18737, o is float, false);
            Eval(18738, o is float[], false);
            Eval(18739, o is float?, false);
            Eval(18740, o is float?[], false);
            Eval(18741, o is double, false);
            Eval(18742, o is double[], false);
            Eval(18743, o is double?, false);
            Eval(18744, o is double?[], false);
            Eval(18745, o is decimal, false);
            Eval(18746, o is decimal[], false);
            Eval(18747, o is decimal?, false);
            Eval(18748, o is decimal?[], false);
            Eval(18749, o is IntPtr, false);
            Eval(18750, o is IntPtr[], false);
            Eval(18751, o is IntPtr?, false);
            Eval(18752, o is IntPtr?[], false);
            Eval(18753, o is UIntPtr, false);
            Eval(18754, o is UIntPtr[], false);
            Eval(18755, o is UIntPtr?, false);
            Eval(18756, o is UIntPtr?[], false);
            Eval(18757, o is Guid, false);
            Eval(18758, o is Guid[], false);
            Eval(18759, o is Guid?, false);
            Eval(18760, o is Guid?[], false);
            Eval(18761, o is GCHandle, false);
            Eval(18762, o is GCHandle[], false);
            Eval(18763, o is GCHandle?, false);
            Eval(18764, o is GCHandle?[], false);
            Eval(18765, o is object, false);
            Eval(18766, o is object[], false);
            Eval(18767, o is string, false);
            Eval(18768, o is string[], false);
            Eval(18769, o is ValueType, false);
            Eval(18770, o is ValueType[], false);
            Eval(18771, o is Array, false);
            Eval(18772, o is Array[], false);
            Eval(18773, o is Enum, false);
            Eval(18774, o is Enum[], false);
            Eval(18775, o is Delegate, false);
            Eval(18776, o is Delegate[], false);
            Eval(18777, o is MulticastDelegate, false);
            Eval(18778, o is MulticastDelegate[], false);
            Eval(18779, o is IEmpty, false);
            Eval(18780, o is IEmpty[], false);
            Eval(18781, o is INotEmpty, false);
            Eval(18782, o is INotEmpty[], false);
            Eval(18783, o is IEmptyGen<int>, false);
            Eval(18784, o is IEmptyGen<int>[], false);
            Eval(18785, o is INotEmptyGen<int>, false);
            Eval(18786, o is INotEmptyGen<int>[], false);
            Eval(18787, o is SimpleDelegate, false);
            Eval(18788, o is SimpleDelegate[], false);
            Eval(18789, o is GenericDelegate<int>, false);
            Eval(18790, o is GenericDelegate<int>[], false);
            Eval(18791, o is EmptyClass, false);
            Eval(18792, o is EmptyClass[], false);
            Eval(18793, o is NotEmptyClass, false);
            Eval(18794, o is NotEmptyClass[], false);
            Eval(18795, o is EmptyClassGen<int>, false);
            Eval(18796, o is EmptyClassGen<int>[], false);
            Eval(18797, o is NotEmptyClassGen<Guid>, false);
            Eval(18798, o is NotEmptyClassGen<Guid>[], false);
            Eval(18799, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(18800, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(18801, o is NestedClass, false);
            Eval(18802, o is NestedClass[], false);
            Eval(18803, o is NestedClassGen<Decimal>, false);
            Eval(18804, o is NestedClassGen<Decimal>[], false);
            Eval(18805, o is ImplementOneInterfaceC, false);
            Eval(18806, o is ImplementOneInterfaceC[], false);
            Eval(18807, o is ImplementTwoInterfaceC, false);
            Eval(18808, o is ImplementTwoInterfaceC[], false);
            Eval(18809, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(18810, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(18811, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(18812, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(18813, o is ImplementAllInterfaceC<int>, false);
            Eval(18814, o is ImplementAllInterfaceC<int>[], false);
            Eval(18815, o is SealedClass, false);
            Eval(18816, o is SealedClass[], false);
        }
    }  // end of test case 0032
    private static void TestCase0033()
    {
        {
            IntPtr v = default(IntPtr);
            ValueType o = v;
            Eval(18817, o is EmptyStruct, false);
            Eval(18818, o is EmptyStruct[], false);
            Eval(18819, o is EmptyStruct?, false);
            Eval(18820, o is EmptyStruct?[], false);
            Eval(18821, o is NotEmptyStruct, false);
            Eval(18822, o is NotEmptyStruct[], false);
            Eval(18823, o is NotEmptyStruct?, false);
            Eval(18824, o is NotEmptyStruct?[], false);
            Eval(18825, o is EmptyStructGen<int>, false);
            Eval(18826, o is EmptyStructGen<int>[], false);
            Eval(18827, o is EmptyStructGen<int>?, false);
            Eval(18828, o is EmptyStructGen<int>?[], false);
            Eval(18829, o is NotEmptyStructGen<Guid>, false);
            Eval(18830, o is NotEmptyStructGen<Guid>[], false);
            Eval(18831, o is NotEmptyStructGen<Guid>?, false);
            Eval(18832, o is NotEmptyStructGen<Guid>?[], false);
            Eval(18833, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(18834, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(18835, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(18836, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(18837, o is NestedStruct, false);
            Eval(18838, o is NestedStruct[], false);
            Eval(18839, o is NestedStruct?, false);
            Eval(18840, o is NestedStruct?[], false);
            Eval(18841, o is NestedStructGen<Decimal>, false);
            Eval(18842, o is NestedStructGen<Decimal>[], false);
            Eval(18843, o is NestedStructGen<Decimal>?, false);
            Eval(18844, o is NestedStructGen<Decimal>?[], false);
            Eval(18845, o is ExplicitFieldOffsetStruct, false);
            Eval(18846, o is ExplicitFieldOffsetStruct[], false);
            Eval(18847, o is ExplicitFieldOffsetStruct?, false);
            Eval(18848, o is ExplicitFieldOffsetStruct?[], false);
            Eval(18857, o is MarshalAsStruct, false);
            Eval(18858, o is MarshalAsStruct[], false);
            Eval(18859, o is MarshalAsStruct?, false);
            Eval(18860, o is MarshalAsStruct?[], false);
            Eval(18861, o is ImplementOneInterface, false);
            Eval(18862, o is ImplementOneInterface[], false);
            Eval(18863, o is ImplementOneInterface?, false);
            Eval(18864, o is ImplementOneInterface?[], false);
            Eval(18865, o is ImplementTwoInterface, false);
            Eval(18866, o is ImplementTwoInterface[], false);
            Eval(18867, o is ImplementTwoInterface?, false);
            Eval(18868, o is ImplementTwoInterface?[], false);
            Eval(18869, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(18870, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(18871, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(18872, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(18873, o is ImplementTwoInterfaceGen<int>, false);
            Eval(18874, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(18875, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(18876, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(18877, o is ImplementAllInterface<int>, false);
            Eval(18878, o is ImplementAllInterface<int>[], false);
            Eval(18879, o is ImplementAllInterface<int>?, false);
            Eval(18880, o is ImplementAllInterface<int>?[], false);
            Eval(18881, o is IntE, false);
            Eval(18882, o is IntE[], false);
            Eval(18883, o is IntE?, false);
            Eval(18884, o is IntE?[], false);
            Eval(18885, o is ByteE, false);
            Eval(18886, o is ByteE[], false);
            Eval(18887, o is ByteE?, false);
            Eval(18888, o is ByteE?[], false);
            Eval(18889, o is LongE, false);
            Eval(18890, o is LongE[], false);
            Eval(18891, o is LongE?, false);
            Eval(18892, o is LongE?[], false);
            Eval(18893, o is char, false);
            Eval(18894, o is char[], false);
            Eval(18895, o is char?, false);
            Eval(18896, o is char?[], false);
            Eval(18897, o is bool, false);
            Eval(18898, o is bool[], false);
            Eval(18899, o is bool?, false);
            Eval(18900, o is bool?[], false);
            Eval(18901, o is byte, false);
            Eval(18902, o is byte[], false);
            Eval(18903, o is byte?, false);
            Eval(18904, o is byte?[], false);
            Eval(18905, o is sbyte, false);
            Eval(18906, o is sbyte[], false);
            Eval(18907, o is sbyte?, false);
            Eval(18908, o is sbyte?[], false);
            Eval(18909, o is short, false);
            Eval(18910, o is short[], false);
            Eval(18911, o is short?, false);
            Eval(18912, o is short?[], false);
            Eval(18913, o is ushort, false);
            Eval(18914, o is ushort[], false);
            Eval(18915, o is ushort?, false);
            Eval(18916, o is ushort?[], false);
            Eval(18917, o is int, false);
            Eval(18918, o is int[], false);
            Eval(18919, o is int?, false);
            Eval(18920, o is int?[], false);
            Eval(18921, o is uint, false);
            Eval(18922, o is uint[], false);
            Eval(18923, o is uint?, false);
            Eval(18924, o is uint?[], false);
            Eval(18925, o is long, false);
            Eval(18926, o is long[], false);
            Eval(18927, o is long?, false);
            Eval(18928, o is long?[], false);
            Eval(18929, o is ulong, false);
            Eval(18930, o is ulong[], false);
            Eval(18931, o is ulong?, false);
            Eval(18932, o is ulong?[], false);
            Eval(18933, o is float, false);
            Eval(18934, o is float[], false);
            Eval(18935, o is float?, false);
            Eval(18936, o is float?[], false);
            Eval(18937, o is double, false);
            Eval(18938, o is double[], false);
            Eval(18939, o is double?, false);
            Eval(18940, o is double?[], false);
            Eval(18941, o is decimal, false);
            Eval(18942, o is decimal[], false);
            Eval(18943, o is decimal?, false);
            Eval(18944, o is decimal?[], false);
            Eval(18945, o is IntPtr, true);
            Eval(18946, o is IntPtr[], false);
            Eval(18947, o is IntPtr?, true);
            Eval(18948, o is IntPtr?[], false);
            Eval(18949, o is UIntPtr, false);
            Eval(18950, o is UIntPtr[], false);
            Eval(18951, o is UIntPtr?, false);
            Eval(18952, o is UIntPtr?[], false);
            Eval(18953, o is Guid, false);
            Eval(18954, o is Guid[], false);
            Eval(18955, o is Guid?, false);
            Eval(18956, o is Guid?[], false);
            Eval(18957, o is GCHandle, false);
            Eval(18958, o is GCHandle[], false);
            Eval(18959, o is GCHandle?, false);
            Eval(18960, o is GCHandle?[], false);
            Eval(18961, o is object, true);
            Eval(18962, o is object[], false);
            Eval(18963, o is string, false);
            Eval(18964, o is string[], false);
            Eval(18965, o is ValueType, true);
            Eval(18966, o is ValueType[], false);
            Eval(18967, o is Array, false);
            Eval(18968, o is Array[], false);
            Eval(18969, o is Enum, false);
            Eval(18970, o is Enum[], false);
            Eval(18971, o is Delegate, false);
            Eval(18972, o is Delegate[], false);
            Eval(18973, o is MulticastDelegate, false);
            Eval(18974, o is MulticastDelegate[], false);
            Eval(18975, o is IEmpty, false);
            Eval(18976, o is IEmpty[], false);
            Eval(18977, o is INotEmpty, false);
            Eval(18978, o is INotEmpty[], false);
            Eval(18979, o is IEmptyGen<int>, false);
            Eval(18980, o is IEmptyGen<int>[], false);
            Eval(18981, o is INotEmptyGen<int>, false);
            Eval(18982, o is INotEmptyGen<int>[], false);
            Eval(18983, o is SimpleDelegate, false);
            Eval(18984, o is SimpleDelegate[], false);
            Eval(18985, o is GenericDelegate<int>, false);
            Eval(18986, o is GenericDelegate<int>[], false);
            Eval(18987, o is EmptyClass, false);
            Eval(18988, o is EmptyClass[], false);
            Eval(18989, o is NotEmptyClass, false);
            Eval(18990, o is NotEmptyClass[], false);
            Eval(18991, o is EmptyClassGen<int>, false);
            Eval(18992, o is EmptyClassGen<int>[], false);
            Eval(18993, o is NotEmptyClassGen<Guid>, false);
            Eval(18994, o is NotEmptyClassGen<Guid>[], false);
            Eval(18995, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(18996, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(18997, o is NestedClass, false);
            Eval(18998, o is NestedClass[], false);
            Eval(18999, o is NestedClassGen<Decimal>, false);
            Eval(19000, o is NestedClassGen<Decimal>[], false);
            Eval(19001, o is ImplementOneInterfaceC, false);
            Eval(19002, o is ImplementOneInterfaceC[], false);
            Eval(19003, o is ImplementTwoInterfaceC, false);
            Eval(19004, o is ImplementTwoInterfaceC[], false);
            Eval(19005, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(19006, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(19007, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(19008, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(19009, o is ImplementAllInterfaceC<int>, false);
            Eval(19010, o is ImplementAllInterfaceC<int>[], false);
            Eval(19011, o is SealedClass, false);
            Eval(19012, o is SealedClass[], false);
        }
        {
            IntPtr? v = default(IntPtr);
            ValueType o = v;
            Eval(19013, o is EmptyStruct, false);
            Eval(19014, o is EmptyStruct[], false);
            Eval(19015, o is EmptyStruct?, false);
            Eval(19016, o is EmptyStruct?[], false);
            Eval(19017, o is NotEmptyStruct, false);
            Eval(19018, o is NotEmptyStruct[], false);
            Eval(19019, o is NotEmptyStruct?, false);
            Eval(19020, o is NotEmptyStruct?[], false);
            Eval(19021, o is EmptyStructGen<int>, false);
            Eval(19022, o is EmptyStructGen<int>[], false);
            Eval(19023, o is EmptyStructGen<int>?, false);
            Eval(19024, o is EmptyStructGen<int>?[], false);
            Eval(19025, o is NotEmptyStructGen<Guid>, false);
            Eval(19026, o is NotEmptyStructGen<Guid>[], false);
            Eval(19027, o is NotEmptyStructGen<Guid>?, false);
            Eval(19028, o is NotEmptyStructGen<Guid>?[], false);
            Eval(19029, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(19030, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(19031, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(19032, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(19033, o is NestedStruct, false);
            Eval(19034, o is NestedStruct[], false);
            Eval(19035, o is NestedStruct?, false);
            Eval(19036, o is NestedStruct?[], false);
            Eval(19037, o is NestedStructGen<Decimal>, false);
            Eval(19038, o is NestedStructGen<Decimal>[], false);
            Eval(19039, o is NestedStructGen<Decimal>?, false);
            Eval(19040, o is NestedStructGen<Decimal>?[], false);
            Eval(19041, o is ExplicitFieldOffsetStruct, false);
            Eval(19042, o is ExplicitFieldOffsetStruct[], false);
            Eval(19043, o is ExplicitFieldOffsetStruct?, false);
            Eval(19044, o is ExplicitFieldOffsetStruct?[], false);
            Eval(19053, o is MarshalAsStruct, false);
            Eval(19054, o is MarshalAsStruct[], false);
            Eval(19055, o is MarshalAsStruct?, false);
            Eval(19056, o is MarshalAsStruct?[], false);
            Eval(19057, o is ImplementOneInterface, false);
            Eval(19058, o is ImplementOneInterface[], false);
            Eval(19059, o is ImplementOneInterface?, false);
            Eval(19060, o is ImplementOneInterface?[], false);
            Eval(19061, o is ImplementTwoInterface, false);
            Eval(19062, o is ImplementTwoInterface[], false);
            Eval(19063, o is ImplementTwoInterface?, false);
            Eval(19064, o is ImplementTwoInterface?[], false);
            Eval(19065, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(19066, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(19067, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(19068, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(19069, o is ImplementTwoInterfaceGen<int>, false);
            Eval(19070, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(19071, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(19072, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(19073, o is ImplementAllInterface<int>, false);
            Eval(19074, o is ImplementAllInterface<int>[], false);
            Eval(19075, o is ImplementAllInterface<int>?, false);
            Eval(19076, o is ImplementAllInterface<int>?[], false);
            Eval(19077, o is IntE, false);
            Eval(19078, o is IntE[], false);
            Eval(19079, o is IntE?, false);
            Eval(19080, o is IntE?[], false);
            Eval(19081, o is ByteE, false);
            Eval(19082, o is ByteE[], false);
            Eval(19083, o is ByteE?, false);
            Eval(19084, o is ByteE?[], false);
            Eval(19085, o is LongE, false);
            Eval(19086, o is LongE[], false);
            Eval(19087, o is LongE?, false);
            Eval(19088, o is LongE?[], false);
            Eval(19089, o is char, false);
            Eval(19090, o is char[], false);
            Eval(19091, o is char?, false);
            Eval(19092, o is char?[], false);
            Eval(19093, o is bool, false);
            Eval(19094, o is bool[], false);
            Eval(19095, o is bool?, false);
            Eval(19096, o is bool?[], false);
            Eval(19097, o is byte, false);
            Eval(19098, o is byte[], false);
            Eval(19099, o is byte?, false);
            Eval(19100, o is byte?[], false);
            Eval(19101, o is sbyte, false);
            Eval(19102, o is sbyte[], false);
            Eval(19103, o is sbyte?, false);
            Eval(19104, o is sbyte?[], false);
            Eval(19105, o is short, false);
            Eval(19106, o is short[], false);
            Eval(19107, o is short?, false);
            Eval(19108, o is short?[], false);
            Eval(19109, o is ushort, false);
            Eval(19110, o is ushort[], false);
            Eval(19111, o is ushort?, false);
            Eval(19112, o is ushort?[], false);
            Eval(19113, o is int, false);
            Eval(19114, o is int[], false);
            Eval(19115, o is int?, false);
            Eval(19116, o is int?[], false);
            Eval(19117, o is uint, false);
            Eval(19118, o is uint[], false);
            Eval(19119, o is uint?, false);
            Eval(19120, o is uint?[], false);
            Eval(19121, o is long, false);
            Eval(19122, o is long[], false);
            Eval(19123, o is long?, false);
            Eval(19124, o is long?[], false);
            Eval(19125, o is ulong, false);
            Eval(19126, o is ulong[], false);
            Eval(19127, o is ulong?, false);
            Eval(19128, o is ulong?[], false);
            Eval(19129, o is float, false);
            Eval(19130, o is float[], false);
            Eval(19131, o is float?, false);
            Eval(19132, o is float?[], false);
            Eval(19133, o is double, false);
            Eval(19134, o is double[], false);
            Eval(19135, o is double?, false);
            Eval(19136, o is double?[], false);
            Eval(19137, o is decimal, false);
            Eval(19138, o is decimal[], false);
            Eval(19139, o is decimal?, false);
            Eval(19140, o is decimal?[], false);
            Eval(19141, o is IntPtr, true);
            Eval(19142, o is IntPtr[], false);
            Eval(19143, o is IntPtr?, true);
            Eval(19144, o is IntPtr?[], false);
            Eval(19145, o is UIntPtr, false);
            Eval(19146, o is UIntPtr[], false);
            Eval(19147, o is UIntPtr?, false);
            Eval(19148, o is UIntPtr?[], false);
            Eval(19149, o is Guid, false);
            Eval(19150, o is Guid[], false);
            Eval(19151, o is Guid?, false);
            Eval(19152, o is Guid?[], false);
            Eval(19153, o is GCHandle, false);
            Eval(19154, o is GCHandle[], false);
            Eval(19155, o is GCHandle?, false);
            Eval(19156, o is GCHandle?[], false);
            Eval(19157, o is object, true);
            Eval(19158, o is object[], false);
            Eval(19159, o is string, false);
            Eval(19160, o is string[], false);
            Eval(19161, o is ValueType, true);
            Eval(19162, o is ValueType[], false);
            Eval(19163, o is Array, false);
            Eval(19164, o is Array[], false);
            Eval(19165, o is Enum, false);
            Eval(19166, o is Enum[], false);
            Eval(19167, o is Delegate, false);
            Eval(19168, o is Delegate[], false);
            Eval(19169, o is MulticastDelegate, false);
            Eval(19170, o is MulticastDelegate[], false);
            Eval(19171, o is IEmpty, false);
            Eval(19172, o is IEmpty[], false);
            Eval(19173, o is INotEmpty, false);
            Eval(19174, o is INotEmpty[], false);
            Eval(19175, o is IEmptyGen<int>, false);
            Eval(19176, o is IEmptyGen<int>[], false);
            Eval(19177, o is INotEmptyGen<int>, false);
            Eval(19178, o is INotEmptyGen<int>[], false);
            Eval(19179, o is SimpleDelegate, false);
            Eval(19180, o is SimpleDelegate[], false);
            Eval(19181, o is GenericDelegate<int>, false);
            Eval(19182, o is GenericDelegate<int>[], false);
            Eval(19183, o is EmptyClass, false);
            Eval(19184, o is EmptyClass[], false);
            Eval(19185, o is NotEmptyClass, false);
            Eval(19186, o is NotEmptyClass[], false);
            Eval(19187, o is EmptyClassGen<int>, false);
            Eval(19188, o is EmptyClassGen<int>[], false);
            Eval(19189, o is NotEmptyClassGen<Guid>, false);
            Eval(19190, o is NotEmptyClassGen<Guid>[], false);
            Eval(19191, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(19192, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(19193, o is NestedClass, false);
            Eval(19194, o is NestedClass[], false);
            Eval(19195, o is NestedClassGen<Decimal>, false);
            Eval(19196, o is NestedClassGen<Decimal>[], false);
            Eval(19197, o is ImplementOneInterfaceC, false);
            Eval(19198, o is ImplementOneInterfaceC[], false);
            Eval(19199, o is ImplementTwoInterfaceC, false);
            Eval(19200, o is ImplementTwoInterfaceC[], false);
            Eval(19201, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(19202, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(19203, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(19204, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(19205, o is ImplementAllInterfaceC<int>, false);
            Eval(19206, o is ImplementAllInterfaceC<int>[], false);
            Eval(19207, o is SealedClass, false);
            Eval(19208, o is SealedClass[], false);
        }
        {
            IntPtr? v = default(IntPtr?);
            ValueType o = v;
            Eval(19209, o is EmptyStruct, false);
            Eval(19210, o is EmptyStruct[], false);
            Eval(19211, o is EmptyStruct?, false);
            Eval(19212, o is EmptyStruct?[], false);
            Eval(19213, o is NotEmptyStruct, false);
            Eval(19214, o is NotEmptyStruct[], false);
            Eval(19215, o is NotEmptyStruct?, false);
            Eval(19216, o is NotEmptyStruct?[], false);
            Eval(19217, o is EmptyStructGen<int>, false);
            Eval(19218, o is EmptyStructGen<int>[], false);
            Eval(19219, o is EmptyStructGen<int>?, false);
            Eval(19220, o is EmptyStructGen<int>?[], false);
            Eval(19221, o is NotEmptyStructGen<Guid>, false);
            Eval(19222, o is NotEmptyStructGen<Guid>[], false);
            Eval(19223, o is NotEmptyStructGen<Guid>?, false);
            Eval(19224, o is NotEmptyStructGen<Guid>?[], false);
            Eval(19225, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(19226, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(19227, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(19228, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(19229, o is NestedStruct, false);
            Eval(19230, o is NestedStruct[], false);
            Eval(19231, o is NestedStruct?, false);
            Eval(19232, o is NestedStruct?[], false);
            Eval(19233, o is NestedStructGen<Decimal>, false);
            Eval(19234, o is NestedStructGen<Decimal>[], false);
            Eval(19235, o is NestedStructGen<Decimal>?, false);
            Eval(19236, o is NestedStructGen<Decimal>?[], false);
            Eval(19237, o is ExplicitFieldOffsetStruct, false);
            Eval(19238, o is ExplicitFieldOffsetStruct[], false);
            Eval(19239, o is ExplicitFieldOffsetStruct?, false);
            Eval(19240, o is ExplicitFieldOffsetStruct?[], false);
            Eval(19249, o is MarshalAsStruct, false);
            Eval(19250, o is MarshalAsStruct[], false);
            Eval(19251, o is MarshalAsStruct?, false);
            Eval(19252, o is MarshalAsStruct?[], false);
            Eval(19253, o is ImplementOneInterface, false);
            Eval(19254, o is ImplementOneInterface[], false);
            Eval(19255, o is ImplementOneInterface?, false);
            Eval(19256, o is ImplementOneInterface?[], false);
            Eval(19257, o is ImplementTwoInterface, false);
            Eval(19258, o is ImplementTwoInterface[], false);
            Eval(19259, o is ImplementTwoInterface?, false);
            Eval(19260, o is ImplementTwoInterface?[], false);
            Eval(19261, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(19262, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(19263, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(19264, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(19265, o is ImplementTwoInterfaceGen<int>, false);
            Eval(19266, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(19267, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(19268, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(19269, o is ImplementAllInterface<int>, false);
            Eval(19270, o is ImplementAllInterface<int>[], false);
            Eval(19271, o is ImplementAllInterface<int>?, false);
            Eval(19272, o is ImplementAllInterface<int>?[], false);
            Eval(19273, o is IntE, false);
            Eval(19274, o is IntE[], false);
            Eval(19275, o is IntE?, false);
            Eval(19276, o is IntE?[], false);
            Eval(19277, o is ByteE, false);
            Eval(19278, o is ByteE[], false);
            Eval(19279, o is ByteE?, false);
            Eval(19280, o is ByteE?[], false);
            Eval(19281, o is LongE, false);
            Eval(19282, o is LongE[], false);
            Eval(19283, o is LongE?, false);
            Eval(19284, o is LongE?[], false);
            Eval(19285, o is char, false);
            Eval(19286, o is char[], false);
            Eval(19287, o is char?, false);
            Eval(19288, o is char?[], false);
            Eval(19289, o is bool, false);
            Eval(19290, o is bool[], false);
            Eval(19291, o is bool?, false);
            Eval(19292, o is bool?[], false);
            Eval(19293, o is byte, false);
            Eval(19294, o is byte[], false);
            Eval(19295, o is byte?, false);
            Eval(19296, o is byte?[], false);
            Eval(19297, o is sbyte, false);
            Eval(19298, o is sbyte[], false);
            Eval(19299, o is sbyte?, false);
            Eval(19300, o is sbyte?[], false);
            Eval(19301, o is short, false);
            Eval(19302, o is short[], false);
            Eval(19303, o is short?, false);
            Eval(19304, o is short?[], false);
            Eval(19305, o is ushort, false);
            Eval(19306, o is ushort[], false);
            Eval(19307, o is ushort?, false);
            Eval(19308, o is ushort?[], false);
            Eval(19309, o is int, false);
            Eval(19310, o is int[], false);
            Eval(19311, o is int?, false);
            Eval(19312, o is int?[], false);
            Eval(19313, o is uint, false);
            Eval(19314, o is uint[], false);
            Eval(19315, o is uint?, false);
            Eval(19316, o is uint?[], false);
            Eval(19317, o is long, false);
            Eval(19318, o is long[], false);
            Eval(19319, o is long?, false);
            Eval(19320, o is long?[], false);
            Eval(19321, o is ulong, false);
            Eval(19322, o is ulong[], false);
            Eval(19323, o is ulong?, false);
            Eval(19324, o is ulong?[], false);
            Eval(19325, o is float, false);
            Eval(19326, o is float[], false);
            Eval(19327, o is float?, false);
            Eval(19328, o is float?[], false);
            Eval(19329, o is double, false);
            Eval(19330, o is double[], false);
            Eval(19331, o is double?, false);
            Eval(19332, o is double?[], false);
            Eval(19333, o is decimal, false);
            Eval(19334, o is decimal[], false);
            Eval(19335, o is decimal?, false);
            Eval(19336, o is decimal?[], false);
            Eval(19337, o is IntPtr, false);
            Eval(19338, o is IntPtr[], false);
            Eval(19339, o is IntPtr?, false);
            Eval(19340, o is IntPtr?[], false);
            Eval(19341, o is UIntPtr, false);
            Eval(19342, o is UIntPtr[], false);
            Eval(19343, o is UIntPtr?, false);
            Eval(19344, o is UIntPtr?[], false);
            Eval(19345, o is Guid, false);
            Eval(19346, o is Guid[], false);
            Eval(19347, o is Guid?, false);
            Eval(19348, o is Guid?[], false);
            Eval(19349, o is GCHandle, false);
            Eval(19350, o is GCHandle[], false);
            Eval(19351, o is GCHandle?, false);
            Eval(19352, o is GCHandle?[], false);
            Eval(19353, o is object, false);
            Eval(19354, o is object[], false);
            Eval(19355, o is string, false);
            Eval(19356, o is string[], false);
            Eval(19357, o is ValueType, false);
            Eval(19358, o is ValueType[], false);
            Eval(19359, o is Array, false);
            Eval(19360, o is Array[], false);
            Eval(19361, o is Enum, false);
            Eval(19362, o is Enum[], false);
            Eval(19363, o is Delegate, false);
            Eval(19364, o is Delegate[], false);
            Eval(19365, o is MulticastDelegate, false);
            Eval(19366, o is MulticastDelegate[], false);
            Eval(19367, o is IEmpty, false);
            Eval(19368, o is IEmpty[], false);
            Eval(19369, o is INotEmpty, false);
            Eval(19370, o is INotEmpty[], false);
            Eval(19371, o is IEmptyGen<int>, false);
            Eval(19372, o is IEmptyGen<int>[], false);
            Eval(19373, o is INotEmptyGen<int>, false);
            Eval(19374, o is INotEmptyGen<int>[], false);
            Eval(19375, o is SimpleDelegate, false);
            Eval(19376, o is SimpleDelegate[], false);
            Eval(19377, o is GenericDelegate<int>, false);
            Eval(19378, o is GenericDelegate<int>[], false);
            Eval(19379, o is EmptyClass, false);
            Eval(19380, o is EmptyClass[], false);
            Eval(19381, o is NotEmptyClass, false);
            Eval(19382, o is NotEmptyClass[], false);
            Eval(19383, o is EmptyClassGen<int>, false);
            Eval(19384, o is EmptyClassGen<int>[], false);
            Eval(19385, o is NotEmptyClassGen<Guid>, false);
            Eval(19386, o is NotEmptyClassGen<Guid>[], false);
            Eval(19387, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(19388, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(19389, o is NestedClass, false);
            Eval(19390, o is NestedClass[], false);
            Eval(19391, o is NestedClassGen<Decimal>, false);
            Eval(19392, o is NestedClassGen<Decimal>[], false);
            Eval(19393, o is ImplementOneInterfaceC, false);
            Eval(19394, o is ImplementOneInterfaceC[], false);
            Eval(19395, o is ImplementTwoInterfaceC, false);
            Eval(19396, o is ImplementTwoInterfaceC[], false);
            Eval(19397, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(19398, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(19399, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(19400, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(19401, o is ImplementAllInterfaceC<int>, false);
            Eval(19402, o is ImplementAllInterfaceC<int>[], false);
            Eval(19403, o is SealedClass, false);
            Eval(19404, o is SealedClass[], false);
        }
    }  // end of test case 0033
    private static void TestCase0034()
    {
        {
            UIntPtr v = default(UIntPtr);
            ValueType o = v;
            Eval(19405, o is EmptyStruct, false);
            Eval(19406, o is EmptyStruct[], false);
            Eval(19407, o is EmptyStruct?, false);
            Eval(19408, o is EmptyStruct?[], false);
            Eval(19409, o is NotEmptyStruct, false);
            Eval(19410, o is NotEmptyStruct[], false);
            Eval(19411, o is NotEmptyStruct?, false);
            Eval(19412, o is NotEmptyStruct?[], false);
            Eval(19413, o is EmptyStructGen<int>, false);
            Eval(19414, o is EmptyStructGen<int>[], false);
            Eval(19415, o is EmptyStructGen<int>?, false);
            Eval(19416, o is EmptyStructGen<int>?[], false);
            Eval(19417, o is NotEmptyStructGen<Guid>, false);
            Eval(19418, o is NotEmptyStructGen<Guid>[], false);
            Eval(19419, o is NotEmptyStructGen<Guid>?, false);
            Eval(19420, o is NotEmptyStructGen<Guid>?[], false);
            Eval(19421, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(19422, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(19423, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(19424, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(19425, o is NestedStruct, false);
            Eval(19426, o is NestedStruct[], false);
            Eval(19427, o is NestedStruct?, false);
            Eval(19428, o is NestedStruct?[], false);
            Eval(19429, o is NestedStructGen<Decimal>, false);
            Eval(19430, o is NestedStructGen<Decimal>[], false);
            Eval(19431, o is NestedStructGen<Decimal>?, false);
            Eval(19432, o is NestedStructGen<Decimal>?[], false);
            Eval(19433, o is ExplicitFieldOffsetStruct, false);
            Eval(19434, o is ExplicitFieldOffsetStruct[], false);
            Eval(19435, o is ExplicitFieldOffsetStruct?, false);
            Eval(19436, o is ExplicitFieldOffsetStruct?[], false);
            Eval(19445, o is MarshalAsStruct, false);
            Eval(19446, o is MarshalAsStruct[], false);
            Eval(19447, o is MarshalAsStruct?, false);
            Eval(19448, o is MarshalAsStruct?[], false);
            Eval(19449, o is ImplementOneInterface, false);
            Eval(19450, o is ImplementOneInterface[], false);
            Eval(19451, o is ImplementOneInterface?, false);
            Eval(19452, o is ImplementOneInterface?[], false);
            Eval(19453, o is ImplementTwoInterface, false);
            Eval(19454, o is ImplementTwoInterface[], false);
            Eval(19455, o is ImplementTwoInterface?, false);
            Eval(19456, o is ImplementTwoInterface?[], false);
            Eval(19457, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(19458, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(19459, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(19460, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(19461, o is ImplementTwoInterfaceGen<int>, false);
            Eval(19462, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(19463, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(19464, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(19465, o is ImplementAllInterface<int>, false);
            Eval(19466, o is ImplementAllInterface<int>[], false);
            Eval(19467, o is ImplementAllInterface<int>?, false);
            Eval(19468, o is ImplementAllInterface<int>?[], false);
            Eval(19469, o is IntE, false);
            Eval(19470, o is IntE[], false);
            Eval(19471, o is IntE?, false);
            Eval(19472, o is IntE?[], false);
            Eval(19473, o is ByteE, false);
            Eval(19474, o is ByteE[], false);
            Eval(19475, o is ByteE?, false);
            Eval(19476, o is ByteE?[], false);
            Eval(19477, o is LongE, false);
            Eval(19478, o is LongE[], false);
            Eval(19479, o is LongE?, false);
            Eval(19480, o is LongE?[], false);
            Eval(19481, o is char, false);
            Eval(19482, o is char[], false);
            Eval(19483, o is char?, false);
            Eval(19484, o is char?[], false);
            Eval(19485, o is bool, false);
            Eval(19486, o is bool[], false);
            Eval(19487, o is bool?, false);
            Eval(19488, o is bool?[], false);
            Eval(19489, o is byte, false);
            Eval(19490, o is byte[], false);
            Eval(19491, o is byte?, false);
            Eval(19492, o is byte?[], false);
            Eval(19493, o is sbyte, false);
            Eval(19494, o is sbyte[], false);
            Eval(19495, o is sbyte?, false);
            Eval(19496, o is sbyte?[], false);
            Eval(19497, o is short, false);
            Eval(19498, o is short[], false);
            Eval(19499, o is short?, false);
            Eval(19500, o is short?[], false);
            Eval(19501, o is ushort, false);
            Eval(19502, o is ushort[], false);
            Eval(19503, o is ushort?, false);
            Eval(19504, o is ushort?[], false);
            Eval(19505, o is int, false);
            Eval(19506, o is int[], false);
            Eval(19507, o is int?, false);
            Eval(19508, o is int?[], false);
            Eval(19509, o is uint, false);
            Eval(19510, o is uint[], false);
            Eval(19511, o is uint?, false);
            Eval(19512, o is uint?[], false);
            Eval(19513, o is long, false);
            Eval(19514, o is long[], false);
            Eval(19515, o is long?, false);
            Eval(19516, o is long?[], false);
            Eval(19517, o is ulong, false);
            Eval(19518, o is ulong[], false);
            Eval(19519, o is ulong?, false);
            Eval(19520, o is ulong?[], false);
            Eval(19521, o is float, false);
            Eval(19522, o is float[], false);
            Eval(19523, o is float?, false);
            Eval(19524, o is float?[], false);
            Eval(19525, o is double, false);
            Eval(19526, o is double[], false);
            Eval(19527, o is double?, false);
            Eval(19528, o is double?[], false);
            Eval(19529, o is decimal, false);
            Eval(19530, o is decimal[], false);
            Eval(19531, o is decimal?, false);
            Eval(19532, o is decimal?[], false);
            Eval(19533, o is IntPtr, false);
            Eval(19534, o is IntPtr[], false);
            Eval(19535, o is IntPtr?, false);
            Eval(19536, o is IntPtr?[], false);
            Eval(19537, o is UIntPtr, true);
            Eval(19538, o is UIntPtr[], false);
            Eval(19539, o is UIntPtr?, true);
            Eval(19540, o is UIntPtr?[], false);
            Eval(19541, o is Guid, false);
            Eval(19542, o is Guid[], false);
            Eval(19543, o is Guid?, false);
            Eval(19544, o is Guid?[], false);
            Eval(19545, o is GCHandle, false);
            Eval(19546, o is GCHandle[], false);
            Eval(19547, o is GCHandle?, false);
            Eval(19548, o is GCHandle?[], false);
            Eval(19549, o is object, true);
            Eval(19550, o is object[], false);
            Eval(19551, o is string, false);
            Eval(19552, o is string[], false);
            Eval(19553, o is ValueType, true);
            Eval(19554, o is ValueType[], false);
            Eval(19555, o is Array, false);
            Eval(19556, o is Array[], false);
            Eval(19557, o is Enum, false);
            Eval(19558, o is Enum[], false);
            Eval(19559, o is Delegate, false);
            Eval(19560, o is Delegate[], false);
            Eval(19561, o is MulticastDelegate, false);
            Eval(19562, o is MulticastDelegate[], false);
            Eval(19563, o is IEmpty, false);
            Eval(19564, o is IEmpty[], false);
            Eval(19565, o is INotEmpty, false);
            Eval(19566, o is INotEmpty[], false);
            Eval(19567, o is IEmptyGen<int>, false);
            Eval(19568, o is IEmptyGen<int>[], false);
            Eval(19569, o is INotEmptyGen<int>, false);
            Eval(19570, o is INotEmptyGen<int>[], false);
            Eval(19571, o is SimpleDelegate, false);
            Eval(19572, o is SimpleDelegate[], false);
            Eval(19573, o is GenericDelegate<int>, false);
            Eval(19574, o is GenericDelegate<int>[], false);
            Eval(19575, o is EmptyClass, false);
            Eval(19576, o is EmptyClass[], false);
            Eval(19577, o is NotEmptyClass, false);
            Eval(19578, o is NotEmptyClass[], false);
            Eval(19579, o is EmptyClassGen<int>, false);
            Eval(19580, o is EmptyClassGen<int>[], false);
            Eval(19581, o is NotEmptyClassGen<Guid>, false);
            Eval(19582, o is NotEmptyClassGen<Guid>[], false);
            Eval(19583, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(19584, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(19585, o is NestedClass, false);
            Eval(19586, o is NestedClass[], false);
            Eval(19587, o is NestedClassGen<Decimal>, false);
            Eval(19588, o is NestedClassGen<Decimal>[], false);
            Eval(19589, o is ImplementOneInterfaceC, false);
            Eval(19590, o is ImplementOneInterfaceC[], false);
            Eval(19591, o is ImplementTwoInterfaceC, false);
            Eval(19592, o is ImplementTwoInterfaceC[], false);
            Eval(19593, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(19594, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(19595, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(19596, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(19597, o is ImplementAllInterfaceC<int>, false);
            Eval(19598, o is ImplementAllInterfaceC<int>[], false);
            Eval(19599, o is SealedClass, false);
            Eval(19600, o is SealedClass[], false);
        }
        {
            UIntPtr? v = default(UIntPtr);
            ValueType o = v;
            Eval(19601, o is EmptyStruct, false);
            Eval(19602, o is EmptyStruct[], false);
            Eval(19603, o is EmptyStruct?, false);
            Eval(19604, o is EmptyStruct?[], false);
            Eval(19605, o is NotEmptyStruct, false);
            Eval(19606, o is NotEmptyStruct[], false);
            Eval(19607, o is NotEmptyStruct?, false);
            Eval(19608, o is NotEmptyStruct?[], false);
            Eval(19609, o is EmptyStructGen<int>, false);
            Eval(19610, o is EmptyStructGen<int>[], false);
            Eval(19611, o is EmptyStructGen<int>?, false);
            Eval(19612, o is EmptyStructGen<int>?[], false);
            Eval(19613, o is NotEmptyStructGen<Guid>, false);
            Eval(19614, o is NotEmptyStructGen<Guid>[], false);
            Eval(19615, o is NotEmptyStructGen<Guid>?, false);
            Eval(19616, o is NotEmptyStructGen<Guid>?[], false);
            Eval(19617, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(19618, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(19619, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(19620, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(19621, o is NestedStruct, false);
            Eval(19622, o is NestedStruct[], false);
            Eval(19623, o is NestedStruct?, false);
            Eval(19624, o is NestedStruct?[], false);
            Eval(19625, o is NestedStructGen<Decimal>, false);
            Eval(19626, o is NestedStructGen<Decimal>[], false);
            Eval(19627, o is NestedStructGen<Decimal>?, false);
            Eval(19628, o is NestedStructGen<Decimal>?[], false);
            Eval(19629, o is ExplicitFieldOffsetStruct, false);
            Eval(19630, o is ExplicitFieldOffsetStruct[], false);
            Eval(19631, o is ExplicitFieldOffsetStruct?, false);
            Eval(19632, o is ExplicitFieldOffsetStruct?[], false);
            Eval(19641, o is MarshalAsStruct, false);
            Eval(19642, o is MarshalAsStruct[], false);
            Eval(19643, o is MarshalAsStruct?, false);
            Eval(19644, o is MarshalAsStruct?[], false);
            Eval(19645, o is ImplementOneInterface, false);
            Eval(19646, o is ImplementOneInterface[], false);
            Eval(19647, o is ImplementOneInterface?, false);
            Eval(19648, o is ImplementOneInterface?[], false);
            Eval(19649, o is ImplementTwoInterface, false);
            Eval(19650, o is ImplementTwoInterface[], false);
            Eval(19651, o is ImplementTwoInterface?, false);
            Eval(19652, o is ImplementTwoInterface?[], false);
            Eval(19653, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(19654, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(19655, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(19656, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(19657, o is ImplementTwoInterfaceGen<int>, false);
            Eval(19658, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(19659, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(19660, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(19661, o is ImplementAllInterface<int>, false);
            Eval(19662, o is ImplementAllInterface<int>[], false);
            Eval(19663, o is ImplementAllInterface<int>?, false);
            Eval(19664, o is ImplementAllInterface<int>?[], false);
            Eval(19665, o is IntE, false);
            Eval(19666, o is IntE[], false);
            Eval(19667, o is IntE?, false);
            Eval(19668, o is IntE?[], false);
            Eval(19669, o is ByteE, false);
            Eval(19670, o is ByteE[], false);
            Eval(19671, o is ByteE?, false);
            Eval(19672, o is ByteE?[], false);
            Eval(19673, o is LongE, false);
            Eval(19674, o is LongE[], false);
            Eval(19675, o is LongE?, false);
            Eval(19676, o is LongE?[], false);
            Eval(19677, o is char, false);
            Eval(19678, o is char[], false);
            Eval(19679, o is char?, false);
            Eval(19680, o is char?[], false);
            Eval(19681, o is bool, false);
            Eval(19682, o is bool[], false);
            Eval(19683, o is bool?, false);
            Eval(19684, o is bool?[], false);
            Eval(19685, o is byte, false);
            Eval(19686, o is byte[], false);
            Eval(19687, o is byte?, false);
            Eval(19688, o is byte?[], false);
            Eval(19689, o is sbyte, false);
            Eval(19690, o is sbyte[], false);
            Eval(19691, o is sbyte?, false);
            Eval(19692, o is sbyte?[], false);
            Eval(19693, o is short, false);
            Eval(19694, o is short[], false);
            Eval(19695, o is short?, false);
            Eval(19696, o is short?[], false);
            Eval(19697, o is ushort, false);
            Eval(19698, o is ushort[], false);
            Eval(19699, o is ushort?, false);
            Eval(19700, o is ushort?[], false);
            Eval(19701, o is int, false);
            Eval(19702, o is int[], false);
            Eval(19703, o is int?, false);
            Eval(19704, o is int?[], false);
            Eval(19705, o is uint, false);
            Eval(19706, o is uint[], false);
            Eval(19707, o is uint?, false);
            Eval(19708, o is uint?[], false);
            Eval(19709, o is long, false);
            Eval(19710, o is long[], false);
            Eval(19711, o is long?, false);
            Eval(19712, o is long?[], false);
            Eval(19713, o is ulong, false);
            Eval(19714, o is ulong[], false);
            Eval(19715, o is ulong?, false);
            Eval(19716, o is ulong?[], false);
            Eval(19717, o is float, false);
            Eval(19718, o is float[], false);
            Eval(19719, o is float?, false);
            Eval(19720, o is float?[], false);
            Eval(19721, o is double, false);
            Eval(19722, o is double[], false);
            Eval(19723, o is double?, false);
            Eval(19724, o is double?[], false);
            Eval(19725, o is decimal, false);
            Eval(19726, o is decimal[], false);
            Eval(19727, o is decimal?, false);
            Eval(19728, o is decimal?[], false);
            Eval(19729, o is IntPtr, false);
            Eval(19730, o is IntPtr[], false);
            Eval(19731, o is IntPtr?, false);
            Eval(19732, o is IntPtr?[], false);
            Eval(19733, o is UIntPtr, true);
            Eval(19734, o is UIntPtr[], false);
            Eval(19735, o is UIntPtr?, true);
            Eval(19736, o is UIntPtr?[], false);
            Eval(19737, o is Guid, false);
            Eval(19738, o is Guid[], false);
            Eval(19739, o is Guid?, false);
            Eval(19740, o is Guid?[], false);
            Eval(19741, o is GCHandle, false);
            Eval(19742, o is GCHandle[], false);
            Eval(19743, o is GCHandle?, false);
            Eval(19744, o is GCHandle?[], false);
            Eval(19745, o is object, true);
            Eval(19746, o is object[], false);
            Eval(19747, o is string, false);
            Eval(19748, o is string[], false);
            Eval(19749, o is ValueType, true);
            Eval(19750, o is ValueType[], false);
            Eval(19751, o is Array, false);
            Eval(19752, o is Array[], false);
            Eval(19753, o is Enum, false);
            Eval(19754, o is Enum[], false);
            Eval(19755, o is Delegate, false);
            Eval(19756, o is Delegate[], false);
            Eval(19757, o is MulticastDelegate, false);
            Eval(19758, o is MulticastDelegate[], false);
            Eval(19759, o is IEmpty, false);
            Eval(19760, o is IEmpty[], false);
            Eval(19761, o is INotEmpty, false);
            Eval(19762, o is INotEmpty[], false);
            Eval(19763, o is IEmptyGen<int>, false);
            Eval(19764, o is IEmptyGen<int>[], false);
            Eval(19765, o is INotEmptyGen<int>, false);
            Eval(19766, o is INotEmptyGen<int>[], false);
            Eval(19767, o is SimpleDelegate, false);
            Eval(19768, o is SimpleDelegate[], false);
            Eval(19769, o is GenericDelegate<int>, false);
            Eval(19770, o is GenericDelegate<int>[], false);
            Eval(19771, o is EmptyClass, false);
            Eval(19772, o is EmptyClass[], false);
            Eval(19773, o is NotEmptyClass, false);
            Eval(19774, o is NotEmptyClass[], false);
            Eval(19775, o is EmptyClassGen<int>, false);
            Eval(19776, o is EmptyClassGen<int>[], false);
            Eval(19777, o is NotEmptyClassGen<Guid>, false);
            Eval(19778, o is NotEmptyClassGen<Guid>[], false);
            Eval(19779, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(19780, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(19781, o is NestedClass, false);
            Eval(19782, o is NestedClass[], false);
            Eval(19783, o is NestedClassGen<Decimal>, false);
            Eval(19784, o is NestedClassGen<Decimal>[], false);
            Eval(19785, o is ImplementOneInterfaceC, false);
            Eval(19786, o is ImplementOneInterfaceC[], false);
            Eval(19787, o is ImplementTwoInterfaceC, false);
            Eval(19788, o is ImplementTwoInterfaceC[], false);
            Eval(19789, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(19790, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(19791, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(19792, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(19793, o is ImplementAllInterfaceC<int>, false);
            Eval(19794, o is ImplementAllInterfaceC<int>[], false);
            Eval(19795, o is SealedClass, false);
            Eval(19796, o is SealedClass[], false);
        }
        {
            UIntPtr? v = default(UIntPtr?);
            ValueType o = v;
            Eval(19797, o is EmptyStruct, false);
            Eval(19798, o is EmptyStruct[], false);
            Eval(19799, o is EmptyStruct?, false);
            Eval(19800, o is EmptyStruct?[], false);
            Eval(19801, o is NotEmptyStruct, false);
            Eval(19802, o is NotEmptyStruct[], false);
            Eval(19803, o is NotEmptyStruct?, false);
            Eval(19804, o is NotEmptyStruct?[], false);
            Eval(19805, o is EmptyStructGen<int>, false);
            Eval(19806, o is EmptyStructGen<int>[], false);
            Eval(19807, o is EmptyStructGen<int>?, false);
            Eval(19808, o is EmptyStructGen<int>?[], false);
            Eval(19809, o is NotEmptyStructGen<Guid>, false);
            Eval(19810, o is NotEmptyStructGen<Guid>[], false);
            Eval(19811, o is NotEmptyStructGen<Guid>?, false);
            Eval(19812, o is NotEmptyStructGen<Guid>?[], false);
            Eval(19813, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(19814, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(19815, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(19816, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(19817, o is NestedStruct, false);
            Eval(19818, o is NestedStruct[], false);
            Eval(19819, o is NestedStruct?, false);
            Eval(19820, o is NestedStruct?[], false);
            Eval(19821, o is NestedStructGen<Decimal>, false);
            Eval(19822, o is NestedStructGen<Decimal>[], false);
            Eval(19823, o is NestedStructGen<Decimal>?, false);
            Eval(19824, o is NestedStructGen<Decimal>?[], false);
            Eval(19825, o is ExplicitFieldOffsetStruct, false);
            Eval(19826, o is ExplicitFieldOffsetStruct[], false);
            Eval(19827, o is ExplicitFieldOffsetStruct?, false);
            Eval(19828, o is ExplicitFieldOffsetStruct?[], false);
            Eval(19837, o is MarshalAsStruct, false);
            Eval(19838, o is MarshalAsStruct[], false);
            Eval(19839, o is MarshalAsStruct?, false);
            Eval(19840, o is MarshalAsStruct?[], false);
            Eval(19841, o is ImplementOneInterface, false);
            Eval(19842, o is ImplementOneInterface[], false);
            Eval(19843, o is ImplementOneInterface?, false);
            Eval(19844, o is ImplementOneInterface?[], false);
            Eval(19845, o is ImplementTwoInterface, false);
            Eval(19846, o is ImplementTwoInterface[], false);
            Eval(19847, o is ImplementTwoInterface?, false);
            Eval(19848, o is ImplementTwoInterface?[], false);
            Eval(19849, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(19850, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(19851, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(19852, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(19853, o is ImplementTwoInterfaceGen<int>, false);
            Eval(19854, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(19855, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(19856, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(19857, o is ImplementAllInterface<int>, false);
            Eval(19858, o is ImplementAllInterface<int>[], false);
            Eval(19859, o is ImplementAllInterface<int>?, false);
            Eval(19860, o is ImplementAllInterface<int>?[], false);
            Eval(19861, o is IntE, false);
            Eval(19862, o is IntE[], false);
            Eval(19863, o is IntE?, false);
            Eval(19864, o is IntE?[], false);
            Eval(19865, o is ByteE, false);
            Eval(19866, o is ByteE[], false);
            Eval(19867, o is ByteE?, false);
            Eval(19868, o is ByteE?[], false);
            Eval(19869, o is LongE, false);
            Eval(19870, o is LongE[], false);
            Eval(19871, o is LongE?, false);
            Eval(19872, o is LongE?[], false);
            Eval(19873, o is char, false);
            Eval(19874, o is char[], false);
            Eval(19875, o is char?, false);
            Eval(19876, o is char?[], false);
            Eval(19877, o is bool, false);
            Eval(19878, o is bool[], false);
            Eval(19879, o is bool?, false);
            Eval(19880, o is bool?[], false);
            Eval(19881, o is byte, false);
            Eval(19882, o is byte[], false);
            Eval(19883, o is byte?, false);
            Eval(19884, o is byte?[], false);
            Eval(19885, o is sbyte, false);
            Eval(19886, o is sbyte[], false);
            Eval(19887, o is sbyte?, false);
            Eval(19888, o is sbyte?[], false);
            Eval(19889, o is short, false);
            Eval(19890, o is short[], false);
            Eval(19891, o is short?, false);
            Eval(19892, o is short?[], false);
            Eval(19893, o is ushort, false);
            Eval(19894, o is ushort[], false);
            Eval(19895, o is ushort?, false);
            Eval(19896, o is ushort?[], false);
            Eval(19897, o is int, false);
            Eval(19898, o is int[], false);
            Eval(19899, o is int?, false);
            Eval(19900, o is int?[], false);
            Eval(19901, o is uint, false);
            Eval(19902, o is uint[], false);
            Eval(19903, o is uint?, false);
            Eval(19904, o is uint?[], false);
            Eval(19905, o is long, false);
            Eval(19906, o is long[], false);
            Eval(19907, o is long?, false);
            Eval(19908, o is long?[], false);
            Eval(19909, o is ulong, false);
            Eval(19910, o is ulong[], false);
            Eval(19911, o is ulong?, false);
            Eval(19912, o is ulong?[], false);
            Eval(19913, o is float, false);
            Eval(19914, o is float[], false);
            Eval(19915, o is float?, false);
            Eval(19916, o is float?[], false);
            Eval(19917, o is double, false);
            Eval(19918, o is double[], false);
            Eval(19919, o is double?, false);
            Eval(19920, o is double?[], false);
            Eval(19921, o is decimal, false);
            Eval(19922, o is decimal[], false);
            Eval(19923, o is decimal?, false);
            Eval(19924, o is decimal?[], false);
            Eval(19925, o is IntPtr, false);
            Eval(19926, o is IntPtr[], false);
            Eval(19927, o is IntPtr?, false);
            Eval(19928, o is IntPtr?[], false);
            Eval(19929, o is UIntPtr, false);
            Eval(19930, o is UIntPtr[], false);
            Eval(19931, o is UIntPtr?, false);
            Eval(19932, o is UIntPtr?[], false);
            Eval(19933, o is Guid, false);
            Eval(19934, o is Guid[], false);
            Eval(19935, o is Guid?, false);
            Eval(19936, o is Guid?[], false);
            Eval(19937, o is GCHandle, false);
            Eval(19938, o is GCHandle[], false);
            Eval(19939, o is GCHandle?, false);
            Eval(19940, o is GCHandle?[], false);
            Eval(19941, o is object, false);
            Eval(19942, o is object[], false);
            Eval(19943, o is string, false);
            Eval(19944, o is string[], false);
            Eval(19945, o is ValueType, false);
            Eval(19946, o is ValueType[], false);
            Eval(19947, o is Array, false);
            Eval(19948, o is Array[], false);
            Eval(19949, o is Enum, false);
            Eval(19950, o is Enum[], false);
            Eval(19951, o is Delegate, false);
            Eval(19952, o is Delegate[], false);
            Eval(19953, o is MulticastDelegate, false);
            Eval(19954, o is MulticastDelegate[], false);
            Eval(19955, o is IEmpty, false);
            Eval(19956, o is IEmpty[], false);
            Eval(19957, o is INotEmpty, false);
            Eval(19958, o is INotEmpty[], false);
            Eval(19959, o is IEmptyGen<int>, false);
            Eval(19960, o is IEmptyGen<int>[], false);
            Eval(19961, o is INotEmptyGen<int>, false);
            Eval(19962, o is INotEmptyGen<int>[], false);
            Eval(19963, o is SimpleDelegate, false);
            Eval(19964, o is SimpleDelegate[], false);
            Eval(19965, o is GenericDelegate<int>, false);
            Eval(19966, o is GenericDelegate<int>[], false);
            Eval(19967, o is EmptyClass, false);
            Eval(19968, o is EmptyClass[], false);
            Eval(19969, o is NotEmptyClass, false);
            Eval(19970, o is NotEmptyClass[], false);
            Eval(19971, o is EmptyClassGen<int>, false);
            Eval(19972, o is EmptyClassGen<int>[], false);
            Eval(19973, o is NotEmptyClassGen<Guid>, false);
            Eval(19974, o is NotEmptyClassGen<Guid>[], false);
            Eval(19975, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(19976, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(19977, o is NestedClass, false);
            Eval(19978, o is NestedClass[], false);
            Eval(19979, o is NestedClassGen<Decimal>, false);
            Eval(19980, o is NestedClassGen<Decimal>[], false);
            Eval(19981, o is ImplementOneInterfaceC, false);
            Eval(19982, o is ImplementOneInterfaceC[], false);
            Eval(19983, o is ImplementTwoInterfaceC, false);
            Eval(19984, o is ImplementTwoInterfaceC[], false);
            Eval(19985, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(19986, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(19987, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(19988, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(19989, o is ImplementAllInterfaceC<int>, false);
            Eval(19990, o is ImplementAllInterfaceC<int>[], false);
            Eval(19991, o is SealedClass, false);
            Eval(19992, o is SealedClass[], false);
        }
    }  // end of test case 0034
    private static void TestCase0035()
    {
        {
            Guid v = default(Guid);
            ValueType o = v;
            Eval(19993, o is EmptyStruct, false);
            Eval(19994, o is EmptyStruct[], false);
            Eval(19995, o is EmptyStruct?, false);
            Eval(19996, o is EmptyStruct?[], false);
            Eval(19997, o is NotEmptyStruct, false);
            Eval(19998, o is NotEmptyStruct[], false);
            Eval(19999, o is NotEmptyStruct?, false);
            Eval(20000, o is NotEmptyStruct?[], false);
            Eval(20001, o is EmptyStructGen<int>, false);
            Eval(20002, o is EmptyStructGen<int>[], false);
            Eval(20003, o is EmptyStructGen<int>?, false);
            Eval(20004, o is EmptyStructGen<int>?[], false);
            Eval(20005, o is NotEmptyStructGen<Guid>, false);
            Eval(20006, o is NotEmptyStructGen<Guid>[], false);
            Eval(20007, o is NotEmptyStructGen<Guid>?, false);
            Eval(20008, o is NotEmptyStructGen<Guid>?[], false);
            Eval(20009, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(20010, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(20011, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(20012, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(20013, o is NestedStruct, false);
            Eval(20014, o is NestedStruct[], false);
            Eval(20015, o is NestedStruct?, false);
            Eval(20016, o is NestedStruct?[], false);
            Eval(20017, o is NestedStructGen<Decimal>, false);
            Eval(20018, o is NestedStructGen<Decimal>[], false);
            Eval(20019, o is NestedStructGen<Decimal>?, false);
            Eval(20020, o is NestedStructGen<Decimal>?[], false);
            Eval(20021, o is ExplicitFieldOffsetStruct, false);
            Eval(20022, o is ExplicitFieldOffsetStruct[], false);
            Eval(20023, o is ExplicitFieldOffsetStruct?, false);
            Eval(20024, o is ExplicitFieldOffsetStruct?[], false);
            Eval(20033, o is MarshalAsStruct, false);
            Eval(20034, o is MarshalAsStruct[], false);
            Eval(20035, o is MarshalAsStruct?, false);
            Eval(20036, o is MarshalAsStruct?[], false);
            Eval(20037, o is ImplementOneInterface, false);
            Eval(20038, o is ImplementOneInterface[], false);
            Eval(20039, o is ImplementOneInterface?, false);
            Eval(20040, o is ImplementOneInterface?[], false);
            Eval(20041, o is ImplementTwoInterface, false);
            Eval(20042, o is ImplementTwoInterface[], false);
            Eval(20043, o is ImplementTwoInterface?, false);
            Eval(20044, o is ImplementTwoInterface?[], false);
            Eval(20045, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(20046, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(20047, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(20048, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(20049, o is ImplementTwoInterfaceGen<int>, false);
            Eval(20050, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(20051, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(20052, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(20053, o is ImplementAllInterface<int>, false);
            Eval(20054, o is ImplementAllInterface<int>[], false);
            Eval(20055, o is ImplementAllInterface<int>?, false);
            Eval(20056, o is ImplementAllInterface<int>?[], false);
            Eval(20057, o is IntE, false);
            Eval(20058, o is IntE[], false);
            Eval(20059, o is IntE?, false);
            Eval(20060, o is IntE?[], false);
            Eval(20061, o is ByteE, false);
            Eval(20062, o is ByteE[], false);
            Eval(20063, o is ByteE?, false);
            Eval(20064, o is ByteE?[], false);
            Eval(20065, o is LongE, false);
            Eval(20066, o is LongE[], false);
            Eval(20067, o is LongE?, false);
            Eval(20068, o is LongE?[], false);
            Eval(20069, o is char, false);
            Eval(20070, o is char[], false);
            Eval(20071, o is char?, false);
            Eval(20072, o is char?[], false);
            Eval(20073, o is bool, false);
            Eval(20074, o is bool[], false);
            Eval(20075, o is bool?, false);
            Eval(20076, o is bool?[], false);
            Eval(20077, o is byte, false);
            Eval(20078, o is byte[], false);
            Eval(20079, o is byte?, false);
            Eval(20080, o is byte?[], false);
            Eval(20081, o is sbyte, false);
            Eval(20082, o is sbyte[], false);
            Eval(20083, o is sbyte?, false);
            Eval(20084, o is sbyte?[], false);
            Eval(20085, o is short, false);
            Eval(20086, o is short[], false);
            Eval(20087, o is short?, false);
            Eval(20088, o is short?[], false);
            Eval(20089, o is ushort, false);
            Eval(20090, o is ushort[], false);
            Eval(20091, o is ushort?, false);
            Eval(20092, o is ushort?[], false);
            Eval(20093, o is int, false);
            Eval(20094, o is int[], false);
            Eval(20095, o is int?, false);
            Eval(20096, o is int?[], false);
            Eval(20097, o is uint, false);
            Eval(20098, o is uint[], false);
            Eval(20099, o is uint?, false);
            Eval(20100, o is uint?[], false);
            Eval(20101, o is long, false);
            Eval(20102, o is long[], false);
            Eval(20103, o is long?, false);
            Eval(20104, o is long?[], false);
            Eval(20105, o is ulong, false);
            Eval(20106, o is ulong[], false);
            Eval(20107, o is ulong?, false);
            Eval(20108, o is ulong?[], false);
            Eval(20109, o is float, false);
            Eval(20110, o is float[], false);
            Eval(20111, o is float?, false);
            Eval(20112, o is float?[], false);
            Eval(20113, o is double, false);
            Eval(20114, o is double[], false);
            Eval(20115, o is double?, false);
            Eval(20116, o is double?[], false);
            Eval(20117, o is decimal, false);
            Eval(20118, o is decimal[], false);
            Eval(20119, o is decimal?, false);
            Eval(20120, o is decimal?[], false);
            Eval(20121, o is IntPtr, false);
            Eval(20122, o is IntPtr[], false);
            Eval(20123, o is IntPtr?, false);
            Eval(20124, o is IntPtr?[], false);
            Eval(20125, o is UIntPtr, false);
            Eval(20126, o is UIntPtr[], false);
            Eval(20127, o is UIntPtr?, false);
            Eval(20128, o is UIntPtr?[], false);
            Eval(20129, o is Guid, true);
            Eval(20130, o is Guid[], false);
            Eval(20131, o is Guid?, true);
            Eval(20132, o is Guid?[], false);
            Eval(20133, o is GCHandle, false);
            Eval(20134, o is GCHandle[], false);
            Eval(20135, o is GCHandle?, false);
            Eval(20136, o is GCHandle?[], false);
            Eval(20137, o is object, true);
            Eval(20138, o is object[], false);
            Eval(20139, o is string, false);
            Eval(20140, o is string[], false);
            Eval(20141, o is ValueType, true);
            Eval(20142, o is ValueType[], false);
            Eval(20143, o is Array, false);
            Eval(20144, o is Array[], false);
            Eval(20145, o is Enum, false);
            Eval(20146, o is Enum[], false);
            Eval(20147, o is Delegate, false);
            Eval(20148, o is Delegate[], false);
            Eval(20149, o is MulticastDelegate, false);
            Eval(20150, o is MulticastDelegate[], false);
            Eval(20151, o is IEmpty, false);
            Eval(20152, o is IEmpty[], false);
            Eval(20153, o is INotEmpty, false);
            Eval(20154, o is INotEmpty[], false);
            Eval(20155, o is IEmptyGen<int>, false);
            Eval(20156, o is IEmptyGen<int>[], false);
            Eval(20157, o is INotEmptyGen<int>, false);
            Eval(20158, o is INotEmptyGen<int>[], false);
            Eval(20159, o is SimpleDelegate, false);
            Eval(20160, o is SimpleDelegate[], false);
            Eval(20161, o is GenericDelegate<int>, false);
            Eval(20162, o is GenericDelegate<int>[], false);
            Eval(20163, o is EmptyClass, false);
            Eval(20164, o is EmptyClass[], false);
            Eval(20165, o is NotEmptyClass, false);
            Eval(20166, o is NotEmptyClass[], false);
            Eval(20167, o is EmptyClassGen<int>, false);
            Eval(20168, o is EmptyClassGen<int>[], false);
            Eval(20169, o is NotEmptyClassGen<Guid>, false);
            Eval(20170, o is NotEmptyClassGen<Guid>[], false);
            Eval(20171, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(20172, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(20173, o is NestedClass, false);
            Eval(20174, o is NestedClass[], false);
            Eval(20175, o is NestedClassGen<Decimal>, false);
            Eval(20176, o is NestedClassGen<Decimal>[], false);
            Eval(20177, o is ImplementOneInterfaceC, false);
            Eval(20178, o is ImplementOneInterfaceC[], false);
            Eval(20179, o is ImplementTwoInterfaceC, false);
            Eval(20180, o is ImplementTwoInterfaceC[], false);
            Eval(20181, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(20182, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(20183, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(20184, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(20185, o is ImplementAllInterfaceC<int>, false);
            Eval(20186, o is ImplementAllInterfaceC<int>[], false);
            Eval(20187, o is SealedClass, false);
            Eval(20188, o is SealedClass[], false);
        }
        {
            Guid? v = default(Guid);
            ValueType o = v;
            Eval(20189, o is EmptyStruct, false);
            Eval(20190, o is EmptyStruct[], false);
            Eval(20191, o is EmptyStruct?, false);
            Eval(20192, o is EmptyStruct?[], false);
            Eval(20193, o is NotEmptyStruct, false);
            Eval(20194, o is NotEmptyStruct[], false);
            Eval(20195, o is NotEmptyStruct?, false);
            Eval(20196, o is NotEmptyStruct?[], false);
            Eval(20197, o is EmptyStructGen<int>, false);
            Eval(20198, o is EmptyStructGen<int>[], false);
            Eval(20199, o is EmptyStructGen<int>?, false);
            Eval(20200, o is EmptyStructGen<int>?[], false);
            Eval(20201, o is NotEmptyStructGen<Guid>, false);
            Eval(20202, o is NotEmptyStructGen<Guid>[], false);
            Eval(20203, o is NotEmptyStructGen<Guid>?, false);
            Eval(20204, o is NotEmptyStructGen<Guid>?[], false);
            Eval(20205, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(20206, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(20207, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(20208, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(20209, o is NestedStruct, false);
            Eval(20210, o is NestedStruct[], false);
            Eval(20211, o is NestedStruct?, false);
            Eval(20212, o is NestedStruct?[], false);
            Eval(20213, o is NestedStructGen<Decimal>, false);
            Eval(20214, o is NestedStructGen<Decimal>[], false);
            Eval(20215, o is NestedStructGen<Decimal>?, false);
            Eval(20216, o is NestedStructGen<Decimal>?[], false);
            Eval(20217, o is ExplicitFieldOffsetStruct, false);
            Eval(20218, o is ExplicitFieldOffsetStruct[], false);
            Eval(20219, o is ExplicitFieldOffsetStruct?, false);
            Eval(20220, o is ExplicitFieldOffsetStruct?[], false);
            Eval(20229, o is MarshalAsStruct, false);
            Eval(20230, o is MarshalAsStruct[], false);
            Eval(20231, o is MarshalAsStruct?, false);
            Eval(20232, o is MarshalAsStruct?[], false);
            Eval(20233, o is ImplementOneInterface, false);
            Eval(20234, o is ImplementOneInterface[], false);
            Eval(20235, o is ImplementOneInterface?, false);
            Eval(20236, o is ImplementOneInterface?[], false);
            Eval(20237, o is ImplementTwoInterface, false);
            Eval(20238, o is ImplementTwoInterface[], false);
            Eval(20239, o is ImplementTwoInterface?, false);
            Eval(20240, o is ImplementTwoInterface?[], false);
            Eval(20241, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(20242, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(20243, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(20244, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(20245, o is ImplementTwoInterfaceGen<int>, false);
            Eval(20246, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(20247, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(20248, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(20249, o is ImplementAllInterface<int>, false);
            Eval(20250, o is ImplementAllInterface<int>[], false);
            Eval(20251, o is ImplementAllInterface<int>?, false);
            Eval(20252, o is ImplementAllInterface<int>?[], false);
            Eval(20253, o is IntE, false);
            Eval(20254, o is IntE[], false);
            Eval(20255, o is IntE?, false);
            Eval(20256, o is IntE?[], false);
            Eval(20257, o is ByteE, false);
            Eval(20258, o is ByteE[], false);
            Eval(20259, o is ByteE?, false);
            Eval(20260, o is ByteE?[], false);
            Eval(20261, o is LongE, false);
            Eval(20262, o is LongE[], false);
            Eval(20263, o is LongE?, false);
            Eval(20264, o is LongE?[], false);
            Eval(20265, o is char, false);
            Eval(20266, o is char[], false);
            Eval(20267, o is char?, false);
            Eval(20268, o is char?[], false);
            Eval(20269, o is bool, false);
            Eval(20270, o is bool[], false);
            Eval(20271, o is bool?, false);
            Eval(20272, o is bool?[], false);
            Eval(20273, o is byte, false);
            Eval(20274, o is byte[], false);
            Eval(20275, o is byte?, false);
            Eval(20276, o is byte?[], false);
            Eval(20277, o is sbyte, false);
            Eval(20278, o is sbyte[], false);
            Eval(20279, o is sbyte?, false);
            Eval(20280, o is sbyte?[], false);
            Eval(20281, o is short, false);
            Eval(20282, o is short[], false);
            Eval(20283, o is short?, false);
            Eval(20284, o is short?[], false);
            Eval(20285, o is ushort, false);
            Eval(20286, o is ushort[], false);
            Eval(20287, o is ushort?, false);
            Eval(20288, o is ushort?[], false);
            Eval(20289, o is int, false);
            Eval(20290, o is int[], false);
            Eval(20291, o is int?, false);
            Eval(20292, o is int?[], false);
            Eval(20293, o is uint, false);
            Eval(20294, o is uint[], false);
            Eval(20295, o is uint?, false);
            Eval(20296, o is uint?[], false);
            Eval(20297, o is long, false);
            Eval(20298, o is long[], false);
            Eval(20299, o is long?, false);
            Eval(20300, o is long?[], false);
            Eval(20301, o is ulong, false);
            Eval(20302, o is ulong[], false);
            Eval(20303, o is ulong?, false);
            Eval(20304, o is ulong?[], false);
            Eval(20305, o is float, false);
            Eval(20306, o is float[], false);
            Eval(20307, o is float?, false);
            Eval(20308, o is float?[], false);
            Eval(20309, o is double, false);
            Eval(20310, o is double[], false);
            Eval(20311, o is double?, false);
            Eval(20312, o is double?[], false);
            Eval(20313, o is decimal, false);
            Eval(20314, o is decimal[], false);
            Eval(20315, o is decimal?, false);
            Eval(20316, o is decimal?[], false);
            Eval(20317, o is IntPtr, false);
            Eval(20318, o is IntPtr[], false);
            Eval(20319, o is IntPtr?, false);
            Eval(20320, o is IntPtr?[], false);
            Eval(20321, o is UIntPtr, false);
            Eval(20322, o is UIntPtr[], false);
            Eval(20323, o is UIntPtr?, false);
            Eval(20324, o is UIntPtr?[], false);
            Eval(20325, o is Guid, true);
            Eval(20326, o is Guid[], false);
            Eval(20327, o is Guid?, true);
            Eval(20328, o is Guid?[], false);
            Eval(20329, o is GCHandle, false);
            Eval(20330, o is GCHandle[], false);
            Eval(20331, o is GCHandle?, false);
            Eval(20332, o is GCHandle?[], false);
            Eval(20333, o is object, true);
            Eval(20334, o is object[], false);
            Eval(20335, o is string, false);
            Eval(20336, o is string[], false);
            Eval(20337, o is ValueType, true);
            Eval(20338, o is ValueType[], false);
            Eval(20339, o is Array, false);
            Eval(20340, o is Array[], false);
            Eval(20341, o is Enum, false);
            Eval(20342, o is Enum[], false);
            Eval(20343, o is Delegate, false);
            Eval(20344, o is Delegate[], false);
            Eval(20345, o is MulticastDelegate, false);
            Eval(20346, o is MulticastDelegate[], false);
            Eval(20347, o is IEmpty, false);
            Eval(20348, o is IEmpty[], false);
            Eval(20349, o is INotEmpty, false);
            Eval(20350, o is INotEmpty[], false);
            Eval(20351, o is IEmptyGen<int>, false);
            Eval(20352, o is IEmptyGen<int>[], false);
            Eval(20353, o is INotEmptyGen<int>, false);
            Eval(20354, o is INotEmptyGen<int>[], false);
            Eval(20355, o is SimpleDelegate, false);
            Eval(20356, o is SimpleDelegate[], false);
            Eval(20357, o is GenericDelegate<int>, false);
            Eval(20358, o is GenericDelegate<int>[], false);
            Eval(20359, o is EmptyClass, false);
            Eval(20360, o is EmptyClass[], false);
            Eval(20361, o is NotEmptyClass, false);
            Eval(20362, o is NotEmptyClass[], false);
            Eval(20363, o is EmptyClassGen<int>, false);
            Eval(20364, o is EmptyClassGen<int>[], false);
            Eval(20365, o is NotEmptyClassGen<Guid>, false);
            Eval(20366, o is NotEmptyClassGen<Guid>[], false);
            Eval(20367, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(20368, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(20369, o is NestedClass, false);
            Eval(20370, o is NestedClass[], false);
            Eval(20371, o is NestedClassGen<Decimal>, false);
            Eval(20372, o is NestedClassGen<Decimal>[], false);
            Eval(20373, o is ImplementOneInterfaceC, false);
            Eval(20374, o is ImplementOneInterfaceC[], false);
            Eval(20375, o is ImplementTwoInterfaceC, false);
            Eval(20376, o is ImplementTwoInterfaceC[], false);
            Eval(20377, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(20378, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(20379, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(20380, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(20381, o is ImplementAllInterfaceC<int>, false);
            Eval(20382, o is ImplementAllInterfaceC<int>[], false);
            Eval(20383, o is SealedClass, false);
            Eval(20384, o is SealedClass[], false);
        }
        {
            Guid? v = default(Guid?);
            ValueType o = v;
            Eval(20385, o is EmptyStruct, false);
            Eval(20386, o is EmptyStruct[], false);
            Eval(20387, o is EmptyStruct?, false);
            Eval(20388, o is EmptyStruct?[], false);
            Eval(20389, o is NotEmptyStruct, false);
            Eval(20390, o is NotEmptyStruct[], false);
            Eval(20391, o is NotEmptyStruct?, false);
            Eval(20392, o is NotEmptyStruct?[], false);
            Eval(20393, o is EmptyStructGen<int>, false);
            Eval(20394, o is EmptyStructGen<int>[], false);
            Eval(20395, o is EmptyStructGen<int>?, false);
            Eval(20396, o is EmptyStructGen<int>?[], false);
            Eval(20397, o is NotEmptyStructGen<Guid>, false);
            Eval(20398, o is NotEmptyStructGen<Guid>[], false);
            Eval(20399, o is NotEmptyStructGen<Guid>?, false);
            Eval(20400, o is NotEmptyStructGen<Guid>?[], false);
            Eval(20401, o is NotEmptyStructConstrainedGen<IntPtr>, false);
            Eval(20402, o is NotEmptyStructConstrainedGen<IntPtr>[], false);
            Eval(20403, o is NotEmptyStructConstrainedGen<IntPtr>?, false);
            Eval(20404, o is NotEmptyStructConstrainedGen<IntPtr>?[], false);
            Eval(20405, o is NestedStruct, false);
            Eval(20406, o is NestedStruct[], false);
            Eval(20407, o is NestedStruct?, false);
            Eval(20408, o is NestedStruct?[], false);
            Eval(20409, o is NestedStructGen<Decimal>, false);
            Eval(20410, o is NestedStructGen<Decimal>[], false);
            Eval(20411, o is NestedStructGen<Decimal>?, false);
            Eval(20412, o is NestedStructGen<Decimal>?[], false);
            Eval(20413, o is ExplicitFieldOffsetStruct, false);
            Eval(20414, o is ExplicitFieldOffsetStruct[], false);
            Eval(20415, o is ExplicitFieldOffsetStruct?, false);
            Eval(20416, o is ExplicitFieldOffsetStruct?[], false);
            Eval(20425, o is MarshalAsStruct, false);
            Eval(20426, o is MarshalAsStruct[], false);
            Eval(20427, o is MarshalAsStruct?, false);
            Eval(20428, o is MarshalAsStruct?[], false);
            Eval(20429, o is ImplementOneInterface, false);
            Eval(20430, o is ImplementOneInterface[], false);
            Eval(20431, o is ImplementOneInterface?, false);
            Eval(20432, o is ImplementOneInterface?[], false);
            Eval(20433, o is ImplementTwoInterface, false);
            Eval(20434, o is ImplementTwoInterface[], false);
            Eval(20435, o is ImplementTwoInterface?, false);
            Eval(20436, o is ImplementTwoInterface?[], false);
            Eval(20437, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(20438, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(20439, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(20440, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(20441, o is ImplementTwoInterfaceGen<int>, false);
            Eval(20442, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(20443, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(20444, o is Implemen