
# Zabbix server health

## Overview

This template is designed to monitor internal Zabbix metrics on the local Zabbix server.

## Requirements

Zabbix version: 7.0 and higher.

## Tested versions

This template has been tested on:
- Zabbix server 7.0

## Configuration

> Zabbix should be configured according to the instructions in the [Templates out of the box](https://www.zabbix.com/documentation/7.0/manual/config/templates_out_of_the_box) section.

## Setup

Link this template to the local Zabbix server host.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$ZABBIX.PROXY.LAST_SEEN.MAX}|<p>The maximum number of seconds that Zabbix proxy has not been seen.</p>|`600`|
|{$PROXY.GROUP.AVAIL.PERCENT.MIN}|<p>Minimum threshold for the proxy group availability percentage triggers.</p>|`75`|
|{$PROXY.GROUP.DISCOVERY.NAME.MATCHES}|<p>Filter to include discovered proxy groups by their name.</p>|`.*`|
|{$PROXY.GROUP.DISCOVERY.NAME.NOT_MATCHES}|<p>Filter to exclude discovered proxy groups by their name.</p>|`CHANGE_IF_NEEDED`|
|{$ZABBIX.SERVER.UTIL.MAX}|<p>Default maximum threshold for percentage utilization triggers (use macro context for specification).</p>|`75`|
|{$ZABBIX.SERVER.UTIL.MIN}|<p>Default minimum threshold for percentage utilization triggers (use macro context for specification).</p>|`65`|
|{$ZABBIX.SERVER.UTIL.MAX:"value cache"}|<p>Maximum threshold for the value cache utilization trigger.</p>|`95`|

### Items

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Zabbix stats cluster|<p>The master item of Zabbix cluster statistics.</p>|Zabbix internal|zabbix[cluster,discovery,nodes]|
|Zabbix proxies stats|<p>The master item of Zabbix proxies' statistics.</p>|Zabbix internal|zabbix[proxy,discovery]|
|Zabbix proxy groups stats|<p>The master item of Zabbix proxy groups' statistics.</p>|Zabbix internal|zabbix[proxy group,discovery]|
|Queue over 10 minutes|<p>The number of monitored items in the queue that are delayed by at least 10 minutes.</p>|Zabbix internal|zabbix[queue,10m]|
|Queue|<p>The number of monitored items in the queue that are delayed by at least 6 seconds.</p>|Zabbix internal|zabbix[queue]|
|Zabbix preprocessing|<p>The master item of Zabbix server's preprocessing statistics.</p>|Zabbix internal|zabbix[preprocessing]|
|Utilization of alert manager internal processes, in %|<p>The average percentage of the time during which the alert manager processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,alert manager,avg,busy]|
|Utilization of alert syncer internal processes, in %|<p>The average percentage of the time during which the alert syncer processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,alert syncer,avg,busy]|
|Utilization of alerter internal processes, in %|<p>The average percentage of the time during which the alerter processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,alerter,avg,busy]|
|Utilization of availability manager internal processes, in %|<p>The average percentage of the time during which the availability manager processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,availability manager,avg,busy]|
|Utilization of configuration syncer internal processes, in %|<p>The average percentage of the time during which the configuration syncer processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,configuration syncer,avg,busy]|
|Utilization of configuration syncer worker internal processes, in %|<p>The average percentage of the time during which the configuration syncer worker processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,configuration syncer worker,avg,busy]|
|Utilization of escalator internal processes, in %|<p>The average percentage of the time during which the escalator processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,escalator,avg,busy]|
|Utilization of history poller internal processes, in %|<p>The average percentage of the time during which the history poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,history poller,avg,busy]|
|Utilization of ODBC poller data collector processes, in %|<p>The average percentage of the time during which the ODBC poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,odbc poller,avg,busy]|
|Utilization of history syncer internal processes, in %|<p>The average percentage of the time during which the history syncer processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,history syncer,avg,busy]|
|Utilization of housekeeper internal processes, in %|<p>The average percentage of the time during which the housekeeper processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,housekeeper,avg,busy]|
|Utilization of http poller data collector processes, in %|<p>The average percentage of the time during which the http poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,http poller,avg,busy]|
|Utilization of icmp pinger data collector processes, in %|<p>The average percentage of the time during which the icmp pinger processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,icmp pinger,avg,busy]|
|Utilization of ipmi manager internal processes, in %|<p>The average percentage of the time during which the ipmi manager processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,ipmi manager,avg,busy]|
|Utilization of ipmi poller data collector processes, in %|<p>The average percentage of the time during which the ipmi poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,ipmi poller,avg,busy]|
|Utilization of java poller data collector processes, in %|<p>The average percentage of the time during which the java poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,java poller,avg,busy]|
|Utilization of LLD manager internal processes, in %|<p>The average percentage of the time during which the LLD manager processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,lld manager,avg,busy]|
|Utilization of LLD worker internal processes, in %|<p>The average percentage of the time during which the LLD worker processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,lld worker,avg,busy]|
|Utilization of connector manager internal processes, in %|<p>The average percentage of the time during which the connector manager processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,connector manager,avg,busy]|
|Utilization of connector worker internal processes, in %|<p>The average percentage of the time during which the connector worker processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,connector worker,avg,busy]|
|Utilization of discovery manager internal processes, in %|<p>The average percentage of the time during which the discovery manager processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,discovery manager,avg,busy]|
|Utilization of discovery worker internal processes, in %|<p>The average percentage of the time during which the discovery worker processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,discovery worker,avg,busy]|
|Utilization of poller data collector processes, in %|<p>The average percentage of the time during which the poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,poller,avg,busy]|
|Utilization of preprocessing worker internal processes, in %|<p>The average percentage of the time during which the preprocessing worker processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,preprocessing worker,avg,busy]|
|Utilization of preprocessing manager internal processes, in %|<p>The average percentage of the time during which the preprocessing manager processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,preprocessing manager,avg,busy]|
|Utilization of proxy poller data collector processes, in %|<p>The average percentage of the time during which the proxy poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,proxy poller,avg,busy]|
|Utilization of proxy group manager internal processes, in %|<p>The average percentage of the time during which the proxy group manager processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,proxy group manager,avg,busy]|
|Utilization of report manager internal processes, in %|<p>The average percentage of the time during which the report manager processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,report manager,avg,busy]|
|Utilization of report writer internal processes, in %|<p>The average percentage of the time during which the report writer processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,report writer,avg,busy]|
|Utilization of self-monitoring internal processes, in %|<p>The average percentage of the time during which the self-monitoring processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,self-monitoring,avg,busy]|
|Utilization of snmp trapper data collector processes, in %|<p>The average percentage of the time during which the snmp trapper processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,snmp trapper,avg,busy]|
|Utilization of task manager internal processes, in %|<p>The average percentage of the time during which the task manager processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,task manager,avg,busy]|
|Utilization of timer internal processes, in %|<p>The average percentage of the time during which the timer processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,timer,avg,busy]|
|Utilization of service manager internal processes, in %|<p>The average percentage of the time during which the service manager processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,service manager,avg,busy]|
|Utilization of trigger housekeeper internal processes, in %|<p>The average percentage of the time during which the trigger housekeeper processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,trigger housekeeper,avg,busy]|
|Utilization of trapper data collector processes, in %|<p>The average percentage of the time during which the trapper processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,trapper,avg,busy]|
|Utilization of unreachable poller data collector processes, in %|<p>The average percentage of the time during which the unreachable poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,unreachable poller,avg,busy]|
|Utilization of vmware collector data collector processes, in %|<p>The average percentage of the time during which the vmware collector processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,vmware collector,avg,busy]|
|Utilization of agent poller data collector processes, in %|<p>The average percentage of the time during which the agent poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,agent poller,avg,busy]|
|Utilization of http agent poller data collector processes, in %|<p>The average percentage of the time during which the http agent poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,http agent poller,avg,busy]|
|Utilization of snmp poller data collector processes, in %|<p>The average percentage of the time during which the snmp poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,snmp poller,avg,busy]|
|Utilization of internal poller data collector processes, in %|<p>The average percentage of the time during which the internal poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,internal poller,avg,busy]|
|Utilization of browser poller data collector processes, in %|<p>The average percentage of the time during which the browser poller processes have been busy for the last minute.</p>|Zabbix internal|zabbix[process,browser poller,avg,busy]|
|Configuration cache, % used|<p>The availability statistics of Zabbix configuration cache. The percentage of used data buffer.</p>|Zabbix internal|zabbix[rcache,buffer,pused]|
|Trend function cache, % of unique requests|<p>The effectiveness statistics of the Zabbix trend function cache. The percentage of cached items calculated from the sum of the cached items plus requests.</p><p>A low percentage most likely means that the cache size can be reduced.</p>|Zabbix internal|zabbix[tcache,cache,pitems]|
|Trend function cache, % of misses|<p>The effectiveness statistics of the Zabbix trend function cache. The percentage of cache misses.</p>|Zabbix internal|zabbix[tcache,cache,pmisses]|
|Value cache, % used|<p>The availability statistics of Zabbix value cache. The percentage of used data buffer.</p>|Zabbix internal|zabbix[vcache,buffer,pused]|
|Value cache hits|<p>The effectiveness statistics of Zabbix value cache. The number of cache hits (history values taken from the cache).</p>|Zabbix internal|zabbix[vcache,cache,hits]<p>**Preprocessing**</p><ul><li>Change per second</li></ul>|
|Value cache misses|<p>The effectiveness statistics of Zabbix value cache. The number of cache misses (history values taken from the database).</p>|Zabbix internal|zabbix[vcache,cache,misses]<p>**Preprocessing**</p><ul><li>Change per second</li></ul>|
|Value cache operating mode|<p>The operating mode of the value cache.</p>|Zabbix internal|zabbix[vcache,cache,mode]|
|Zabbix server check|<p>Flag indicating whether it is a server or not.</p>|Zabbix internal|zabbix[triggers]<p>**Preprocessing**</p><ul><li><p>Check for not supported value: `any error`</p><p>⛔️Custom on fail: Set value to: `0`</p></li><li><p>In range: ` -> 0`</p><p>⛔️Custom on fail: Set value to: `1`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Version|<p>The version of Zabbix server.</p>|Zabbix internal|zabbix[version]<p>**Preprocessing**</p><ul><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|VMware cache, % used|<p>The availability statistics of Zabbix vmware cache. The percentage of used data buffer.</p>|Zabbix internal|zabbix[vmware,buffer,pused]|
|History write cache, % used|<p>The statistics and availability of Zabbix write cache. The percentage of used history buffer.</p><p>The history cache is used to store item values. A high number indicates database performance problems.</p>|Zabbix internal|zabbix[wcache,history,pused]|
|History index cache, % used|<p>The statistics and availability of Zabbix write cache. The percentage of used history index buffer.</p><p>The history index cache is used to index values stored in the history cache.</p>|Zabbix internal|zabbix[wcache,index,pused]|
|Trend write cache, % used|<p>The statistics and availability of Zabbix write cache. The percentage of used trend buffer.</p><p>The trend cache stores the aggregate of all items that have received data for the current hour.</p>|Zabbix internal|zabbix[wcache,trend,pused]|
|Number of processed values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The total number of values processed by Zabbix server or Zabbix proxy, except unsupported items.</p>|Zabbix internal|zabbix[wcache,values]<p>**Preprocessing**</p><ul><li>Change per second</li></ul>|
|Number of processed numeric (unsigned) values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed numeric (unsigned) values.</p>|Zabbix internal|zabbix[wcache,values,uint]<p>**Preprocessing**</p><ul><li>Change per second</li></ul>|
|Number of processed numeric (float) values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed numeric (float) values.</p>|Zabbix internal|zabbix[wcache,values,float]<p>**Preprocessing**</p><ul><li>Change per second</li></ul>|
|Number of processed log values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed log values.</p>|Zabbix internal|zabbix[wcache,values,log]<p>**Preprocessing**</p><ul><li>Change per second</li></ul>|
|Number of processed not supported values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of times the item processing resulted in an item becoming unsupported or remaining in that state.</p>|Zabbix internal|zabbix[wcache,values,not supported]<p>**Preprocessing**</p><ul><li>Change per second</li></ul>|
|Number of processed character values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed character values.</p>|Zabbix internal|zabbix[wcache,values,str]<p>**Preprocessing**</p><ul><li>Change per second</li></ul>|
|Number of processed text values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed text values.</p>|Zabbix internal|zabbix[wcache,values,text]<p>**Preprocessing**</p><ul><li>Change per second</li></ul>|
|Number of values synchronized with the database per second|<p>Average quantity of values written to the database, recalculated once per minute.</p>|Zabbix internal|zabbix[vps,written]<p>**Preprocessing**</p><ul><li>Change per second</li></ul>|
|LLD queue|<p>The number of values enqueued in the low-level discovery processing queue.</p>|Zabbix internal|zabbix[lld_queue]|
|Preprocessing queue|<p>The number of values enqueued in the preprocessing queue.</p>|Dependent item|zabbix[preprocessing_queue]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.queue`</p></li></ul>|
|Preprocessing queued throughput|<p>Reflects the queued throughput of the preprocessing.</p>|Dependent item|zabbix[preprocessing_throughput_queued]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.queued.size`</p></li><li>Change per second</li></ul>|
|Preprocessing direct throughput|<p>Reflects the direct throughput of the preprocessing.</p>|Dependent item|zabbix[preprocessing_throughput_direct]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.direct.size`</p></li><li>Change per second</li></ul>|
|Preprocessing queued VPS|<p>Reflects the count of queued preprocessing values per second.</p>|Dependent item|zabbix[preprocessing_vps_queued]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.queued.count`</p></li><li>Change per second</li></ul>|
|Preprocessing direct VPS|<p>Reflects the count of direct preprocessing values per second.</p>|Dependent item|zabbix[preprocessing_vps_direct]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.direct.count`</p></li><li>Change per second</li></ul>|
|Connector queue|<p>The count of values enqueued in the connector queue.</p>|Zabbix internal|zabbix[connector_queue]|
|Discovery queue|<p>The count of values enqueued in the discovery queue.</p>|Zabbix internal|zabbix[discovery_queue]|

### Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Zabbix server: More than 100 items have been missing data for over 10 minutes|<p>Indicates potential issues with network connectivity, agent failures, or unresponsive monitored resources that require attention.</p>|`min(/Zabbix server health/zabbix[queue,10m],10m)>100`|Warning|**Manual close**: Yes|
|Zabbix server: Utilization of alert manager processes is high|<p>Indicates potential performance issues with the alert manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,alert manager,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"alert manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of alert syncer processes is high|<p>Indicates potential performance issues with the alert syncer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,alert syncer,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"alert syncer"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of alerter processes is high|<p>Indicates potential performance issues with the alerter, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,alerter,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"alerter"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of availability manager processes is high|<p>Indicates potential performance issues with the availability manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,availability manager,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"availability manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of configuration syncer processes is high|<p>Indicates potential performance issues with the configuration syncer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,configuration syncer,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"configuration syncer"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of configuration syncer worker processes is high|<p>Indicates potential performance issues with the configuration syncer worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,configuration syncer worker,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"configuration syncer worker"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of escalator processes is high|<p>Indicates potential performance issues with the escalator, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,escalator,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"escalator"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of history poller processes is high|<p>Indicates potential performance issues with the history poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,history poller,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"history poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of ODBC poller processes is high|<p>Indicates potential performance issues with the ODBC poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,odbc poller,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"ODBC poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of history syncer processes is high|<p>Indicates potential performance issues with the history syncer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,history syncer,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"history syncer"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of housekeeper processes is high|<p>Indicates potential performance issues with the housekeeper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,housekeeper,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"housekeeper"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of http poller processes is high|<p>Indicates potential performance issues with the http poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,http poller,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"http poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of icmp pinger processes is high|<p>Indicates potential performance issues with the icmp pinger, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,icmp pinger,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"icmp pinger"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of ipmi manager processes is high|<p>Indicates potential performance issues with the ipmi manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,ipmi manager,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"ipmi manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of ipmi poller processes is high|<p>Indicates potential performance issues with the ipmi poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,ipmi poller,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"ipmi poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of java poller processes is high|<p>Indicates potential performance issues with the java poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,java poller,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"java poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of LLD manager processes is high|<p>Indicates potential performance issues with the LLD manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,lld manager,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"LLD manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of LLD worker processes is high|<p>Indicates potential performance issues with the LLD worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,lld worker,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"LLD worker"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of connector manager processes is high|<p>Indicates potential performance issues with the connector manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,connector manager,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"connector manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of connector worker processes is high|<p>Indicates potential performance issues with the connector worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,connector worker,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"connector worker"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of discovery manager processes is high|<p>Indicates potential performance issues with the discovery manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,discovery manager,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"discovery manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of discovery worker processes is high|<p>Indicates potential performance issues with the discovery worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,discovery worker,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"discovery worker"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of poller processes is high|<p>Indicates potential performance issues with the poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,poller,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of preprocessing worker processes is high|<p>Indicates potential performance issues with the preprocessing worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,preprocessing worker,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"preprocessing worker"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of preprocessing manager processes is high|<p>Indicates potential performance issues with the preprocessing manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,preprocessing manager,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"preprocessing manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of proxy poller processes is high|<p>Indicates potential performance issues with the proxy poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,proxy poller,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"proxy poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of proxy group manager processes is high|<p>Indicates potential performance issues with the proxy group manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,proxy group manager,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"proxy group manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of report manager processes is high|<p>Indicates potential performance issues with the report manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,report manager,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"report manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of report writer processes is high|<p>Indicates potential performance issues with the report writer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,report writer,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"report writer"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of self-monitoring processes is high|<p>Indicates potential performance issues with the self-monitoring, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,self-monitoring,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"self-monitoring"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of snmp trapper processes is high|<p>Indicates potential performance issues with the snmp trapper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,snmp trapper,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"snmp trapper"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of task manager processes is high|<p>Indicates potential performance issues with the task manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,task manager,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"task manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of timer processes is high|<p>Indicates potential performance issues with the timer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,timer,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"timer"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of service manager processes is high|<p>Indicates potential performance issues with the service manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,service manager,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"service manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of trigger housekeeper processes is high|<p>Indicates potential performance issues with the trigger housekeeper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,trigger housekeeper,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"trigger housekeeper"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of trapper processes is high|<p>Indicates potential performance issues with the trapper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,trapper,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"trapper"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of unreachable poller processes is high|<p>Indicates potential performance issues with the unreachable poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,unreachable poller,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"unreachable poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of vmware collector processes is high|<p>Indicates potential performance issues with the vmware collector, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,vmware collector,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"vmware collector"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of agent poller processes is high|<p>Indicates potential performance issues with the agent poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,agent poller,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"agent poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of http agent poller processes is high|<p>Indicates potential performance issues with the http agent poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,http agent poller,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"http agent poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of snmp poller processes is high|<p>Indicates potential performance issues with the snmp poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,snmp poller,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"snmp poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of internal poller processes is high|<p>Indicates potential performance issues with the internal poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,internal poller,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"internal poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of browser poller processes is high|<p>Indicates potential performance issues with the browser poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health/zabbix[process,browser poller,avg,busy],10m)>{$ZABBIX.SERVER.UTIL.MAX:"browser poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Excessive configuration cache usage|<p>Consider increasing `CacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Zabbix server health/zabbix[rcache,buffer,pused],10m)>{$ZABBIX.SERVER.UTIL.MAX:"configuration cache"}`|Average|**Manual close**: Yes|
|Zabbix server: Excessive value cache usage|<p>Consider increasing `ValueCacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Zabbix server health/zabbix[vcache,buffer,pused],10m)>{$ZABBIX.SERVER.UTIL.MAX:"value cache"}`|Average|**Manual close**: Yes|
|Zabbix server: Zabbix value cache working in low-memory mode|<p>Once low-memory mode has been switched on, the value cache will remain in this state for 24 hours, even if the problem that triggered this mode is resolved sooner.</p>|`last(/Zabbix server health/zabbix[vcache,cache,mode])=1`|High|**Manual close**: Yes|
|Zabbix server: Wrong template assigned|<p>Check that the template has been selected correctly.</p>|`last(/Zabbix server health/zabbix[triggers])=0`|Disaster|**Manual close**: Yes|
|Zabbix server: Version has changed|<p>Zabbix server version has changed. Acknowledge to close the problem manually.</p>|`last(/Zabbix server health/zabbix[version],#1)<>last(/Zabbix server health/zabbix[version],#2) and length(last(/Zabbix server health/zabbix[version]))>0`|Info|**Manual close**: Yes|
|Zabbix server: Excessive vmware cache usage|<p>Consider increasing `VMwareCacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Zabbix server health/zabbix[vmware,buffer,pused],10m)>{$ZABBIX.SERVER.UTIL.MAX:"vmware cache"}`|Average|**Manual close**: Yes|
|Zabbix server: Excessive history cache usage|<p>Consider increasing `HistoryCacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Zabbix server health/zabbix[wcache,history,pused],10m)>{$ZABBIX.SERVER.UTIL.MAX:"history cache"}`|Average|**Manual close**: Yes|
|Zabbix server: Excessive history index cache usage|<p>Consider increasing `HistoryIndexCacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Zabbix server health/zabbix[wcache,index,pused],10m)>{$ZABBIX.SERVER.UTIL.MAX:"index cache"}`|Average|**Manual close**: Yes|
|Zabbix server: Excessive trends cache usage|<p>Consider increasing `TrendCacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Zabbix server health/zabbix[wcache,trend,pused],10m)>{$ZABBIX.SERVER.UTIL.MAX:"trend cache"}`|Average|**Manual close**: Yes|

### LLD rule Zabbix proxy discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Zabbix proxy discovery|<p>LLD rule with item and trigger prototypes for proxy discovery.</p>|Dependent item|zabbix.proxy.discovery<p>**Preprocessing**</p><ul><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|

### Item prototypes for Zabbix proxy discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Proxy [{#PROXY.NAME}]: Stats|<p>The statistics for the discovered proxy.</p>|Dependent item|zabbix.proxy.stats[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.[?(@.name=="{#PROXY.NAME}")].first()`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Mode|<p>The mode of Zabbix proxy.</p>|Dependent item|zabbix.proxy.mode[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.passive`</p></li><li><p>JavaScript: `return value === 'false' ? 0 : 1`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Unencrypted|<p>The encryption status for connections from a proxy.</p>|Dependent item|zabbix.proxy.unencrypted[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.unencrypted`</p></li><li><p>JavaScript: `return value === 'false' ? 0 : 1`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: PSK|<p>The encryption status for connections from a proxy.</p>|Dependent item|zabbix.proxy.psk[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.psk`</p></li><li><p>JavaScript: `return value === 'false' ? 0 : 1`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Certificate|<p>The encryption status for connections from a proxy.</p>|Dependent item|zabbix.proxy.cert[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.cert`</p></li><li><p>JavaScript: `return value === 'false' ? 0 : 1`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Compression|<p>The compression status of a proxy.</p>|Dependent item|zabbix.proxy.compression[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.compression`</p></li><li><p>JavaScript: `return value === 'false' ? 0 : 1`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Item count|<p>The number of enabled items on enabled hosts assigned to a proxy.</p>|Dependent item|zabbix.proxy.items[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.items`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Host count|<p>The number of enabled hosts assigned to a proxy.</p>|Dependent item|zabbix.proxy.hosts[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.hosts`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Version|<p>A version of Zabbix proxy.</p>|Dependent item|zabbix.proxy.version[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.version`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Last seen, in seconds|<p>The time when a proxy was last seen by a server.</p>|Dependent item|zabbix.proxy.last_seen[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.last_seen`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Compatibility|<p>Version of proxy compared to Zabbix server version.</p><p></p><p>Possible values:</p><p>0 - Undefined;</p><p>1 - Current version (proxy and server have the same major version);</p><p>2 - Outdated version (proxy version is older than server version, but is partially supported);</p><p>3 - Unsupported version (proxy version is older than server previous LTS release version or server major version is older than proxy major version).</p>|Dependent item|zabbix.proxy.compatibility[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.compatibility`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Required VPS|<p>The required performance of a proxy (the number of values that need to be collected per second).</p>|Dependent item|zabbix.proxy.requiredperformance[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.requiredperformance`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|

### Trigger prototypes for Zabbix proxy discovery

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Zabbix server: Proxy [{#PROXY.NAME}]: Zabbix proxy last seen|<p>Zabbix proxy is not updating the configuration data.</p>|`last(/Zabbix server health/zabbix.proxy.last_seen[{#PROXY.NAME}],#1)>{$ZABBIX.PROXY.LAST_SEEN.MAX}`|Warning||
|Zabbix server: Proxy [{#PROXY.NAME}]: Zabbix proxy never seen|<p>Zabbix proxy is not updating the configuration data.</p>|`last(/Zabbix server health/zabbix.proxy.last_seen[{#PROXY.NAME}],#1)=-1`|Warning||
|Zabbix server: Proxy [{#PROXY.NAME}]: Zabbix proxy is outdated|<p>Zabbix proxy version is older than server version, but is partially supported. Only data collection and remote execution is available.</p>|`last(/Zabbix server health/zabbix.proxy.compatibility[{#PROXY.NAME}],#1)=2`|Warning||
|Zabbix server: Proxy [{#PROXY.NAME}]: Zabbix proxy is not supported|<p>Zabbix proxy version is older than server previous LTS release version or server major version is older than proxy major version.</p>|`last(/Zabbix server health/zabbix.proxy.compatibility[{#PROXY.NAME}],#1)=3`|High||

### LLD rule Zabbix proxy groups discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Zabbix proxy groups discovery|<p>LLD rule with item and trigger prototypes for proxy groups discovery.</p>|Dependent item|zabbix.proxy.groups.discovery<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data`</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|

### Item prototypes for Zabbix proxy groups discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Proxy group [{#PROXY.GROUP.NAME}]: Stats|<p>The statistics for the discovered proxy group.</p>|Dependent item|zabbix.proxy.group.stats[{#PROXY.GROUP.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.rtdata["{#PROXY.GROUP.NAME}"]`</p></li></ul>|
|Proxy group [{#PROXY.GROUP.NAME}]: State|<p>State of the Zabbix proxy group.</p><p></p><p>Possible values:</p><p>0 - unknown;</p><p>1 - offline;</p><p>2 - recovering;</p><p>3 - online;</p><p>4 - degrading.</p>|Dependent item|zabbix.proxy.group.state[{#PROXY.GROUP.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.state`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy group [{#PROXY.GROUP.NAME}]: Available proxies|<p>Count of available proxies in the Zabbix proxy group.</p>|Dependent item|zabbix.proxy.group.avail.proxies[{#PROXY.GROUP.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.available`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy group [{#PROXY.GROUP.NAME}]: Available proxies, in %|<p>Percentage of available proxies in the Zabbix proxy group.</p>|Dependent item|zabbix.proxy.group.avail.proxies.percent[{#PROXY.GROUP.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.pavailable`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy group [{#PROXY.GROUP.NAME}]: Settings|<p>The settings for the discovered proxy group.</p>|Dependent item|zabbix.proxy.group.settings[{#PROXY.GROUP.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data[?(@.name=="{#PROXY.GROUP.NAME}")].first()`</p></li></ul>|
|Proxy group [{#PROXY.GROUP.NAME}]: Failover period|<p>Failover period in the Zabbix proxy group.</p>|Dependent item|zabbix.proxy.group.failover[{#PROXY.GROUP.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.failover_delay`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy group [{#PROXY.GROUP.NAME}]: Minimum number of proxies|<p>Minimum number of proxies online in the Zabbix proxy group.</p>|Dependent item|zabbix.proxy.group.online.min[{#PROXY.GROUP.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.min_online`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|

### Trigger prototypes for Zabbix proxy groups discovery

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Zabbix server: Proxy group [{#PROXY.GROUP.NAME}]: Status "offline"|<p>The state of the Zabbix proxy group is "offline".</p>|`last(/Zabbix server health/zabbix.proxy.group.state[{#PROXY.GROUP.NAME}],#1)=1`|High||
|Zabbix server: Proxy group [{#PROXY.GROUP.NAME}]: Status "degrading"|<p>The state of the Zabbix proxy group is "degrading".</p>|`last(/Zabbix server health/zabbix.proxy.group.state[{#PROXY.GROUP.NAME}],#1)=4`|Average|**Depends on**:<br><ul><li>Zabbix server: Proxy group [{#PROXY.GROUP.NAME}]: Status "offline"</li></ul>|
|Zabbix server: Proxy group [{#PROXY.GROUP.NAME}]: Status changed|<p>The state of the Zabbix proxy group has changed. Acknowledge to close the problem manually.</p>|`last(/Zabbix server health/zabbix.proxy.group.state[{#PROXY.GROUP.NAME}],#1)<>last(/Zabbix server health/zabbix.proxy.group.state[{#PROXY.GROUP.NAME}],#2) and length(last(/Zabbix server health/zabbix.proxy.group.state[{#PROXY.GROUP.NAME}]))>0`|Info|**Manual close**: Yes<br>**Depends on**:<br><ul><li>Zabbix server: Proxy group [{#PROXY.GROUP.NAME}]: Status "degrading"</li></ul>|
|Zabbix server: Proxy group [{#PROXY.GROUP.NAME}]: Availability too low|<p>The availability of proxies in a proxy group is below {$PROXY.GROUP.AVAIL.PERCENT.MIN}% for at least 3 minutes.</p>|`max(/Zabbix server health/zabbix.proxy.group.avail.proxies.percent[{#PROXY.GROUP.NAME}],3m)<{$PROXY.GROUP.AVAIL.PERCENT.MIN}`|Warning||
|Zabbix server: Proxy group [{#PROXY.GROUP.NAME}]: Failover invalid value|<p>Proxy group failover has an invalid value.</p>|`last(/Zabbix server health/zabbix.proxy.group.failover[{#PROXY.GROUP.NAME}],#1)=-1`|Warning||
|Zabbix server: Proxy group [{#PROXY.GROUP.NAME}]: Minimum number of proxies invalid value|<p>Proxy group minimum number of proxies has an invalid value.</p>|`last(/Zabbix server health/zabbix.proxy.group.online.min[{#PROXY.GROUP.NAME}],#1)=-1`|Warning||

### LLD rule High availability cluster node discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|High availability cluster node discovery|<p>LLD rule with item and trigger prototypes for node discovery.</p>|Dependent item|zabbix.nodes.discovery<p>**Preprocessing**</p><ul><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|

### Item prototypes for High availability cluster node discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Cluster node [{#NODE.NAME}]: Stats|<p>Provides the statistics of a node.</p>|Dependent item|zabbix.node.stats[{#NODE.ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.[?(@.id=="{#NODE.ID}")].first()`</p></li></ul>|
|Cluster node [{#NODE.NAME}]: Address|<p>The IPv4 address of a node.</p>|Dependent item|zabbix.node.address[{#NODE.ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.address`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Cluster node [{#NODE.NAME}]: Last access time|<p>Last access time.</p>|Dependent item|zabbix.node.lastaccess.time[{#NODE.ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.lastaccess`</p></li></ul>|
|Cluster node [{#NODE.NAME}]: Last access age|<p>The time between the database's `unix_timestamp()` and the last access time.</p>|Dependent item|zabbix.node.lastaccess.age[{#NODE.ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.lastaccess_age`</p></li></ul>|
|Cluster node [{#NODE.NAME}]: Status|<p>The status of a node.</p>|Dependent item|zabbix.node.status[{#NODE.ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.status`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|

### Trigger prototypes for High availability cluster node discovery

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Zabbix server: Cluster node [{#NODE.NAME}]: Status changed|<p>The state of the node has changed. Acknowledge to close the problem manually.</p>|`last(/Zabbix server health/zabbix.node.status[{#NODE.ID}],#1)<>last(/Zabbix server health/zabbix.node.status[{#NODE.ID}],#2)`|Info|**Manual close**: Yes|

# Remote Zabbix server health

## Overview

This template is designed to monitor internal Zabbix metrics on the remote Zabbix server.

## Requirements

Zabbix version: 7.0 and higher.

## Tested versions

This template has been tested on:
- Zabbix server 7.0

## Configuration

> Zabbix should be configured according to the instructions in the [Templates out of the box](https://www.zabbix.com/documentation/7.0/manual/config/templates_out_of_the_box) section.

## Setup

Specify the address of the remote Zabbix server by changing the `{$ZABBIX.SERVER.ADDRESS}` and `{$ZABBIX.SERVER.PORT}` macros. Don't forget to adjust the `StatsAllowedIP` parameter in the remote server's configuration file to allow the collection of statistics.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$ZABBIX.SERVER.ADDRESS}|<p>IP/DNS/network mask list of servers to be remotely queried (default is 127.0.0.1).</p>||
|{$ZABBIX.SERVER.PORT}|<p>Port of server to be remotely queried (default is 10051).</p>||
|{$ZABBIX.PROXY.LAST_SEEN.MAX}|<p>The maximum number of seconds that Zabbix proxy has not been seen.</p>|`600`|
|{$ZABBIX.SERVER.NODATA_TIMEOUT}|<p>The time threshold after which statistics are considered unavailable. Used in trigger expressions.</p>|`5m`|
|{$ZABBIX.SERVER.UTIL.MAX}|<p>Default maximum threshold for percentage utilization triggers (use macro context for specification).</p>|`75`|
|{$ZABBIX.SERVER.UTIL.MIN}|<p>Default minimum threshold for percentage utilization triggers (use macro context for specification).</p>|`65`|
|{$ZABBIX.SERVER.UTIL.MAX:"value cache"}|<p>Maximum threshold for value cache utilization triggers.</p>|`95`|

### Items

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Zabbix stats|<p>The master item of Zabbix server statistics.</p>|Zabbix internal|zabbix[stats,{$ZABBIX.SERVER.ADDRESS},{$ZABBIX.SERVER.PORT}]|
|Zabbix proxies stats|<p>The master item of Zabbix proxies' statistics.</p>|Dependent item|zabbix.proxies.stats<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.proxy`</p></li></ul>|
|Queue over 10 minutes|<p>The number of monitored items in the queue that are delayed by at least 10 minutes.</p>|Zabbix internal|zabbix[stats,{$ZABBIX.SERVER.ADDRESS},{$ZABBIX.SERVER.PORT},queue,10m]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.queue`</p></li></ul>|
|Queue|<p>The number of monitored items in the queue that are delayed by at least 6 seconds.</p>|Zabbix internal|zabbix[stats,{$ZABBIX.SERVER.ADDRESS},{$ZABBIX.SERVER.PORT},queue]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.queue`</p></li></ul>|
|Utilization of alert manager internal processes, in %|<p>The average percentage of the time during which the alert manager processes have been busy for the last minute.</p>|Dependent item|process.alert_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['alert manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "alert manager" processes started.`</p></li></ul>|
|Utilization of alert syncer internal processes, in %|<p>The average percentage of the time during which the alert syncer processes have been busy for the last minute.</p>|Dependent item|process.alert_syncer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['alert syncer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "alert syncer" processes started.`</p></li></ul>|
|Utilization of alerter internal processes, in %|<p>The average percentage of the time during which the alerter processes have been busy for the last minute.</p>|Dependent item|process.alerter.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['alerter'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "alerter" processes started.`</p></li></ul>|
|Utilization of availability manager internal processes, in %|<p>The average percentage of the time during which the availability manager processes have been busy for the last minute.</p>|Dependent item|process.availability_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['availability manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "availability manager" processes started.`</p></li></ul>|
|Utilization of configuration syncer internal processes, in %|<p>The average percentage of the time during which the configuration syncer processes have been busy for the last minute.</p>|Dependent item|process.configuration_syncer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['configuration syncer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "configuration syncer" processes started.`</p></li></ul>|
|Utilization of configuration syncer worker internal processes, in %|<p>The average percentage of the time during which the configuration syncer worker processes have been busy for the last minute.</p>|Dependent item|process.configuration_syncer_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['configuration syncer worker'].busy.avg`</p></li></ul>|
|Utilization of escalator internal processes, in %|<p>The average percentage of the time during which the escalator processes have been busy for the last minute.</p>|Dependent item|process.escalator.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['escalator'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "escalator" processes started.`</p></li></ul>|
|Utilization of history poller internal processes, in %|<p>The average percentage of the time during which the history poller processes have been busy for the last minute.</p>|Dependent item|process.history_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['history poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "history poller" processes started.`</p></li></ul>|
|Utilization of ODBC poller data collector processes, in %|<p>The average percentage of the time during which the ODBC poller processes have been busy for the last minute.</p>|Dependent item|process.odbc_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['odbc poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes odbc poller not started`</p></li></ul>|
|Utilization of history syncer internal processes, in %|<p>The average percentage of the time during which the history syncer processes have been busy for the last minute.</p>|Dependent item|process.history_syncer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['history syncer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "history syncer" processes started.`</p></li></ul>|
|Utilization of housekeeper internal processes, in %|<p>The average percentage of the time during which the housekeeper processes have been busy for the last minute.</p>|Dependent item|process.housekeeper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['housekeeper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "housekeeper" processes started.`</p></li></ul>|
|Utilization of http poller data collector processes, in %|<p>The average percentage of the time during which the http poller processes have been busy for the last minute.</p>|Dependent item|process.http_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['http poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "http poller" processes started.`</p></li></ul>|
|Utilization of icmp pinger data collector processes, in %|<p>The average percentage of the time during which the icmp pinger processes have been busy for the last minute.</p>|Dependent item|process.icmp_pinger.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['icmp pinger'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "icmp pinger" processes started.`</p></li></ul>|
|Utilization of ipmi manager internal processes, in %|<p>The average percentage of the time during which the ipmi manager processes have been busy for the last minute.</p>|Dependent item|process.ipmi_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['ipmi manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "ipmi manager" processes started.`</p></li></ul>|
|Utilization of ipmi poller data collector processes, in %|<p>The average percentage of the time during which the ipmi poller processes have been busy for the last minute.</p>|Dependent item|process.ipmi_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['ipmi poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "ipmi poller" processes started.`</p></li></ul>|
|Utilization of java poller data collector processes, in %|<p>The average percentage of the time during which the java poller processes have been busy for the last minute.</p>|Dependent item|process.java_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['java poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "java poller" processes started.`</p></li></ul>|
|Utilization of LLD manager internal processes, in %|<p>The average percentage of the time during which the LLD manager processes have been busy for the last minute.</p>|Dependent item|process.lld_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['lld manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "LLD manager" processes started.`</p></li></ul>|
|Utilization of LLD worker internal processes, in %|<p>The average percentage of the time during which the LLD worker processes have been busy for the last minute.</p>|Dependent item|process.lld_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['lld worker'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "LLD worker" processes started.`</p></li></ul>|
|Utilization of connector manager internal processes, in %|<p>The average percentage of the time during which the connector manager processes have been busy for the last minute.</p>|Dependent item|process.connector_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['connector manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "connector manager" processes started.`</p></li></ul>|
|Utilization of connector worker internal processes, in %|<p>The average percentage of the time during which the connector worker processes have been busy for the last minute.</p>|Dependent item|process.connector_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['connector worker'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "connector worker" processes started.`</p></li></ul>|
|Utilization of discovery manager internal processes, in %|<p>The average percentage of the time during which the discovery manager processes have been busy for the last minute.</p>|Dependent item|process.discovery_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['discovery manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "discovery manager" processes started.`</p></li></ul>|
|Utilization of discovery worker internal processes, in %|<p>The average percentage of the time during which the discovery worker processes have been busy for the last minute.</p>|Dependent item|process.discovery_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['discovery worker'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "discovery worker" processes started.`</p></li></ul>|
|Utilization of poller data collector processes, in %|<p>The average percentage of the time during which the poller processes have been busy for the last minute.</p>|Dependent item|process.poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "poller" processes started.`</p></li></ul>|
|Utilization of preprocessing worker internal processes, in %|<p>The average percentage of the time during which the preprocessing worker processes have been busy for the last minute.</p>|Dependent item|process.preprocessing_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['preprocessing worker'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "preprocessing worker" processes started.`</p></li></ul>|
|Utilization of preprocessing manager internal processes, in %|<p>The average percentage of the time during which the preprocessing manager processes have been busy for the last minute.</p>|Dependent item|process.preprocessing_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['preprocessing manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "preprocessing manager" processes started.`</p></li></ul>|
|Utilization of proxy poller data collector processes, in %|<p>The average percentage of the time during which the proxy poller processes have been busy for the last minute.</p>|Dependent item|process.proxy_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['proxy poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "proxy poller" processes started.`</p></li></ul>|
|Utilization of proxy group manager internal processes, in %|<p>The average percentage of the time during which the proxy group manager processes have been busy for the last minute.</p>|Dependent item|process.proxy_group_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['proxy group manager'].busy.avg`</p></li></ul>|
|Utilization of report manager internal processes, in %|<p>The average percentage of the time during which the report manager processes have been busy for the last minute.</p>|Dependent item|process.report_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['report manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "report manager" processes started.`</p></li></ul>|
|Utilization of report writer internal processes, in %|<p>The average percentage of the time during which the report writer processes have been busy for the last minute.</p>|Dependent item|process.report_writer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['report writer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "report writer" processes started.`</p></li></ul>|
|Utilization of self-monitoring internal processes, in %|<p>The average percentage of the time during which the self-monitoring processes have been busy for the last minute.</p>|Dependent item|process.self-monitoring.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['self-monitoring'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "self-monitoring" processes started.`</p></li></ul>|
|Utilization of snmp trapper data collector processes, in %|<p>The average percentage of the time during which the snmp trapper processes have been busy for the last minute.</p>|Dependent item|process.snmp_trapper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['snmp trapper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "snmp trapper" processes started.`</p></li></ul>|
|Utilization of task manager internal processes, in %|<p>The average percentage of the time during which the task manager processes have been busy for the last minute.</p>|Dependent item|process.task_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['task manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "task manager" processes started.`</p></li></ul>|
|Utilization of timer internal processes, in %|<p>The average percentage of the time during which the timer processes have been busy for the last minute.</p>|Dependent item|process.timer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['timer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "timer" processes started.`</p></li></ul>|
|Utilization of service manager internal processes, in %|<p>The average percentage of the time during which the service manager processes have been busy for the last minute.</p>|Dependent item|process.service_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['service manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "service manager" processes started.`</p></li></ul>|
|Utilization of trigger housekeeper internal processes, in %|<p>The average percentage of the time during which the trigger housekeeper processes have been busy for the last minute.</p>|Dependent item|process.trigger_housekeeper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['trigger housekeeper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "trigger housekeeper" processes started.`</p></li></ul>|
|Utilization of trapper data collector processes, in %|<p>The average percentage of the time during which the trapper processes have been busy for the last minute.</p>|Dependent item|process.trapper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['trapper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "trapper" processes started.`</p></li></ul>|
|Utilization of unreachable poller data collector processes, in %|<p>The average percentage of the time during which the unreachable poller processes have been busy for the last minute.</p>|Dependent item|process.unreachable_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['unreachable poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "unreachable poller" processes started.`</p></li></ul>|
|Utilization of vmware collector data collector processes, in %|<p>The average percentage of the time during which the vmware collector processes have been busy for the last minute.</p>|Dependent item|process.vmware_collector.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['vmware collector'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "vmware collector" processes started.`</p></li></ul>|
|Utilization of agent poller data collector processes, in %|<p>The average percentage of the time during which the agent poller processes have been busy for the last minute.</p>|Dependent item|process.agent_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['agent poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "agent poller" processes started.`</p></li></ul>|
|Utilization of http agent poller data collector processes, in %|<p>The average percentage of the time during which the http agent poller processes have been busy for the last minute.</p>|Dependent item|process.http_agent_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['http agent poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "http agent poller" processes started.`</p></li></ul>|
|Utilization of snmp poller data collector processes, in %|<p>The average percentage of the time during which the snmp poller processes have been busy for the last minute.</p>|Dependent item|process.snmp_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['snmp poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "snmp poller" processes started.`</p></li></ul>|
|Utilization of internal poller data collector processes, in %|<p>The average percentage of the time during which the internal poller processes have been busy for the last minute.</p>|Dependent item|process.internal_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['internal poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "internal poller" processes started.`</p></li></ul>|
|Utilization of browser poller data collector processes, in %|<p>The average percentage of the time during which the browser poller processes have been busy for the last minute.</p>|Dependent item|process.browser_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['browser poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "browser poller" processes started.`</p></li></ul>|
|Configuration cache, % used|<p>The availability statistics of Zabbix configuration cache. The percentage of used data buffer.</p>|Dependent item|rcache.buffer.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.rcache.pused`</p></li></ul>|
|Trend function cache, % of unique requests|<p>The effectiveness statistics of the Zabbix trend function cache. The percentage of cached items calculated from the sum of the cached items plus requests.</p><p>A low percentage most likely means that the cache size can be reduced.</p>|Dependent item|tcache.pitems<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.tcache.pitems`</p><p>⛔️Custom on fail: Set error to: `Not supported in this version.`</p></li></ul>|
|Trend function cache, % of misses|<p>The effectiveness statistics of the Zabbix trend function cache. The percentage of cache misses.</p>|Dependent item|tcache.pmisses<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.tcache.pmisses`</p><p>⛔️Custom on fail: Set error to: `Not supported in this version.`</p></li></ul>|
|Value cache, % used|<p>The availability statistics of Zabbix value cache. The percentage of used data buffer.</p>|Dependent item|vcache.buffer.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vcache.buffer.pused`</p></li></ul>|
|Value cache hits|<p>The effectiveness statistics of Zabbix value cache. The number of cache hits (history values taken from the cache).</p>|Dependent item|vcache.cache.hits<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vcache.cache.hits`</p></li><li>Change per second</li></ul>|
|Value cache misses|<p>The effectiveness statistics of Zabbix value cache. The number of cache misses (history values taken from the database).</p>|Dependent item|vcache.cache.misses<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vcache.cache.misses`</p></li><li>Change per second</li></ul>|
|Value cache operating mode|<p>The operating mode of the value cache.</p>|Dependent item|vcache.cache.mode<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vcache.cache.mode`</p></li></ul>|
|Zabbix server check|<p>Flag indicating whether it is a server or not.</p>|Dependent item|server_check<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.triggers`</p><p>⛔️Custom on fail: Set value to: `0`</p></li><li><p>In range: ` -> 0`</p><p>⛔️Custom on fail: Set value to: `1`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Version|<p>The version of Zabbix server.</p>|Dependent item|version<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.version`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|VMware cache, % used|<p>The availability statistics of Zabbix vmware cache. The percentage of used data buffer.</p>|Dependent item|vmware.buffer.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vmware.pused`</p><p>⛔️Custom on fail: Set error to: `No "vmware collector" processes started.`</p></li></ul>|
|History write cache, % used|<p>The statistics and availability of Zabbix write cache. The percentage of used history buffer.</p><p>The history cache is used to store item values. A high number indicates database performance problems.</p>|Dependent item|wcache.history.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.history.pused`</p></li></ul>|
|History index cache, % used|<p>The statistics and availability of Zabbix write cache. The percentage of used history index buffer.</p><p>The history index cache is used to index values stored in the history cache.</p>|Dependent item|wcache.index.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.index.pused`</p></li></ul>|
|Trend write cache, % used|<p>The statistics and availability of Zabbix write cache. The percentage of used trend buffer.</p><p>The trend cache stores the aggregate of all items that have received data for the current hour.</p>|Dependent item|wcache.trend.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.trend.pused`</p></li></ul>|
|Number of processed values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The total number of values processed by Zabbix server or Zabbix proxy, except unsupported items.</p>|Dependent item|wcache.values<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.all`</p></li><li>Change per second</li></ul>|
|Number of processed numeric (unsigned) values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed numeric (unsigned) values.</p>|Dependent item|wcache.values.uint<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.uint`</p></li><li>Change per second</li></ul>|
|Number of processed numeric (float) values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed numeric (float) values.</p>|Dependent item|wcache.values.float<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.float`</p></li><li>Change per second</li></ul>|
|Number of processed log values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed log values.</p>|Dependent item|wcache.values.log<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.log`</p></li><li>Change per second</li></ul>|
|Number of processed not supported values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of times the item processing resulted in an item becoming unsupported or remaining in that state.</p>|Dependent item|wcache.values.not_supported<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values['not supported']`</p></li><li>Change per second</li></ul>|
|Number of processed character values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed character values.</p>|Dependent item|wcache.values.str<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.str`</p></li><li>Change per second</li></ul>|
|Number of processed text values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed text values.</p>|Dependent item|wcache.values.text<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.text`</p></li><li>Change per second</li></ul>|
|Number of values synchronized with the database per second|<p>Average quantity of values written to the database, recalculated once per minute.</p>|Dependent item|vps.written<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vps.written_total`</p></li><li>Change per second</li></ul>|
|LLD queue|<p>The number of values enqueued in the low-level discovery processing queue.</p>|Dependent item|lld_queue<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.lld_queue`</p></li></ul>|
|Preprocessing queue|<p>The number of values enqueued in the preprocessing queue.</p>|Dependent item|preprocessing_queue<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.preprocessing.queue`</p></li></ul>|
|Preprocessing queued throughput|<p>Reflects the queued throughput of the preprocessing.</p>|Dependent item|preprocessing_throughput_queued<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.preprocessing.queued.size`</p><p>⛔️Custom on fail: Discard value</p></li><li>Change per second</li></ul>|
|Preprocessing direct throughput|<p>Reflects the direct throughput of the preprocessing.</p>|Dependent item|preprocessing_throughput_direct<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.preprocessing.direct.size`</p><p>⛔️Custom on fail: Discard value</p></li><li>Change per second</li></ul>|
|Preprocessing queued VPS|<p>Reflects the count of queued preprocessing values per second.</p>|Dependent item|preprocessing_vps_queued<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.preprocessing.queued.count`</p><p>⛔️Custom on fail: Discard value</p></li><li>Change per second</li></ul>|
|Preprocessing direct VPS|<p>Reflects the count of direct preprocessing values per second.</p>|Dependent item|preprocessing_vps_direct<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.preprocessing.direct.count`</p><p>⛔️Custom on fail: Discard value</p></li><li>Change per second</li></ul>|
|Connector queue|<p>The count of values enqueued in the connector queue.</p>|Dependent item|connector_queue<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.connector_queue`</p><p>⛔️Custom on fail: Set error to: `No "connector" processes started. Please check "StartConnectors" parameter in the server configuration file.`</p></li></ul>|
|Discovery queue|<p>The count of values enqueued in the discovery queue.</p>|Dependent item|discovery_queue<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.discovery_queue`</p><p>⛔️Custom on fail: Set error to: `No "discoverer" processes started. Please check "StartDiscoverers" parameter in the server configuration file.`</p></li></ul>|

### Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Zabbix server: More than 100 items have been missing data for over 10 minutes|<p>Indicates potential issues with network connectivity, agent failures, or unresponsive monitored resources that require attention.</p>|`min(/Remote Zabbix server health/zabbix[stats,{$ZABBIX.SERVER.ADDRESS},{$ZABBIX.SERVER.PORT},queue,10m],10m)>100`|Warning|**Manual close**: Yes|
|Zabbix server: Utilization of alert manager processes is high|<p>Indicates potential performance issues with the alert manager, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.alert_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"alert manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of alert syncer processes is high|<p>Indicates potential performance issues with the alert syncer, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.alert_syncer.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"alert syncer"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of alerter processes is high|<p>Indicates potential performance issues with the alerter, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.alerter.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"alerter"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of availability manager processes is high|<p>Indicates potential performance issues with the availability manager, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.availability_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"availability manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of configuration syncer processes is high|<p>Indicates potential performance issues with the configuration syncer, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.configuration_syncer.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"configuration syncer"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of configuration syncer worker processes is high|<p>Indicates potential performance issues with the configuration syncer worker, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.configuration_syncer_worker.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"configuration syncer worker"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of escalator processes is high|<p>Indicates potential performance issues with the escalator, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.escalator.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"escalator"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of history poller processes is high|<p>Indicates potential performance issues with the history poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.history_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"history poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of ODBC poller processes is high|<p>Indicates potential performance issues with the ODBC poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.odbc_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"ODBC poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of history syncer processes is high|<p>Indicates potential performance issues with the history syncer, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.history_syncer.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"history syncer"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of housekeeper processes is high|<p>Indicates potential performance issues with the housekeeper, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.housekeeper.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"housekeeper"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of http poller processes is high|<p>Indicates potential performance issues with the http poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.http_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"http poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of icmp pinger processes is high|<p>Indicates potential performance issues with the icmp pinger, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.icmp_pinger.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"icmp pinger"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of ipmi manager processes is high|<p>Indicates potential performance issues with the ipmi manager, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.ipmi_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"ipmi manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of ipmi poller processes is high|<p>Indicates potential performance issues with the ipmi poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.ipmi_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"ipmi poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of java poller processes is high|<p>Indicates potential performance issues with the java poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.java_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"java poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of LLD manager processes is high|<p>Indicates potential performance issues with the LLD manager, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.lld_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"LLD manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of LLD worker processes is high|<p>Indicates potential performance issues with the LLD worker, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.lld_worker.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"LLD worker"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of connector manager processes is high|<p>Indicates potential performance issues with the connector manager, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.connector_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"connector manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of connector worker processes is high|<p>Indicates potential performance issues with the connector worker, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.connector_worker.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"connector worker"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of discovery manager processes is high|<p>Indicates potential performance issues with the discovery manager, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.discovery_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"discovery manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of discovery worker processes is high|<p>Indicates potential performance issues with the discovery worker, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.discovery_worker.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"discovery worker"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of poller processes is high|<p>Indicates potential performance issues with the poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of preprocessing worker processes is high|<p>Indicates potential performance issues with the preprocessing worker, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.preprocessing_worker.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"preprocessing worker"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of preprocessing manager processes is high|<p>Indicates potential performance issues with the preprocessing manager, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.preprocessing_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"preprocessing manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of proxy poller processes is high|<p>Indicates potential performance issues with the proxy poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.proxy_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"proxy poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of proxy group manager processes is high|<p>Indicates potential performance issues with the proxy group manager, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.proxy_group_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"proxy group manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of report manager processes is high|<p>Indicates potential performance issues with the report manager, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.report_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"report manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of report writer processes is high|<p>Indicates potential performance issues with the report writer, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.report_writer.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"report writer"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of self-monitoring processes is high|<p>Indicates potential performance issues with the self-monitoring, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.self-monitoring.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"self-monitoring"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of snmp trapper processes is high|<p>Indicates potential performance issues with the snmp trapper, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.snmp_trapper.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"snmp trapper"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of task manager processes is high|<p>Indicates potential performance issues with the task manager, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.task_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"task manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of timer processes is high|<p>Indicates potential performance issues with the timer, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.timer.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"timer"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of service manager processes is high|<p>Indicates potential performance issues with the service manager, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.service_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"service manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of trigger housekeeper processes is high|<p>Indicates potential performance issues with the trigger housekeeper, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.trigger_housekeeper.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"trigger housekeeper"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of trapper processes is high|<p>Indicates potential performance issues with the trapper, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.trapper.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"trapper"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of unreachable poller processes is high|<p>Indicates potential performance issues with the unreachable poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.unreachable_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"unreachable poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of vmware collector processes is high|<p>Indicates potential performance issues with the vmware collector, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.vmware_collector.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"vmware collector"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of agent poller processes is high|<p>Indicates potential performance issues with the agent poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.agent_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"agent poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of http agent poller processes is high|<p>Indicates potential performance issues with the http agent poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.http_agent_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"http agent poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of snmp poller processes is high|<p>Indicates potential performance issues with the snmp poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.snmp_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"snmp poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of internal poller processes is high|<p>Indicates potential performance issues with the internal poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.internal_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"internal poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of browser poller processes is high|<p>Indicates potential performance issues with the browser poller, which may affect monitoring efficiency and response times.</p>|`avg(/Remote Zabbix server health/process.browser_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"browser poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Excessive configuration cache usage|<p>Consider increasing `CacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Remote Zabbix server health/rcache.buffer.pused,10m)>{$ZABBIX.SERVER.UTIL.MAX:"configuration cache"}`|Average|**Manual close**: Yes|
|Zabbix server: Failed to fetch stats data|<p>Zabbix has not received statistics data for `{$ZABBIX.SERVER.NODATA_TIMEOUT}`.</p>|`nodata(/Remote Zabbix server health/rcache.buffer.pused,{$ZABBIX.SERVER.NODATA_TIMEOUT})=1`|Warning||
|Zabbix server: Excessive value cache usage|<p>Consider increasing `ValueCacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Remote Zabbix server health/vcache.buffer.pused,10m)>{$ZABBIX.SERVER.UTIL.MAX:"value cache"}`|Average|**Manual close**: Yes|
|Zabbix server: Zabbix value cache working in low-memory mode|<p>Once low-memory mode has been switched on, the value cache will remain in this state for 24 hours, even if the problem that triggered this mode is resolved sooner.</p>|`last(/Remote Zabbix server health/vcache.cache.mode)=1`|High|**Manual close**: Yes|
|Zabbix server: Wrong template assigned|<p>Check that the template has been selected correctly.</p>|`last(/Remote Zabbix server health/server_check)=0`|Disaster|**Manual close**: Yes|
|Zabbix server: Version has changed|<p>Zabbix server version has changed. Acknowledge to close the problem manually.</p>|`last(/Remote Zabbix server health/version,#1)<>last(/Remote Zabbix server health/version,#2) and length(last(/Remote Zabbix server health/version))>0`|Info|**Manual close**: Yes|
|Zabbix server: Excessive vmware cache usage|<p>Consider increasing `VMwareCacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Remote Zabbix server health/vmware.buffer.pused,10m)>{$ZABBIX.SERVER.UTIL.MAX:"vmware cache"}`|Average|**Manual close**: Yes|
|Zabbix server: Excessive history cache usage|<p>Consider increasing `HistoryCacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Remote Zabbix server health/wcache.history.pused,10m)>{$ZABBIX.SERVER.UTIL.MAX:"history cache"}`|Average|**Manual close**: Yes|
|Zabbix server: Excessive history index cache usage|<p>Consider increasing `HistoryIndexCacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Remote Zabbix server health/wcache.index.pused,10m)>{$ZABBIX.SERVER.UTIL.MAX:"index cache"}`|Average|**Manual close**: Yes|
|Zabbix server: Excessive trends cache usage|<p>Consider increasing `TrendCacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Remote Zabbix server health/wcache.trend.pused,10m)>{$ZABBIX.SERVER.UTIL.MAX:"trend cache"}`|Average|**Manual close**: Yes|

### LLD rule Zabbix proxy discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Zabbix proxy discovery|<p>LLD rule with item and trigger prototypes for proxy discovery.</p>|Dependent item|zabbix.proxy.discovery<p>**Preprocessing**</p><ul><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|

### Item prototypes for Zabbix proxy discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Proxy [{#PROXY.NAME}]: Stats|<p>The statistics for the discovered proxy.</p>|Dependent item|zabbix.proxy.stats[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.[?(@.name=="{#PROXY.NAME}")].first()`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Mode|<p>The mode of Zabbix proxy.</p>|Dependent item|zabbix.proxy.mode[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.passive`</p></li><li><p>JavaScript: `return value === 'false' ? 0 : 1`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Unencrypted|<p>The encryption status for connections from a proxy.</p>|Dependent item|zabbix.proxy.unencrypted[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.unencrypted`</p></li><li><p>JavaScript: `return value === 'false' ? 0 : 1`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: PSK|<p>The encryption status for connections from a proxy.</p>|Dependent item|zabbix.proxy.psk[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.psk`</p></li><li><p>JavaScript: `return value === 'false' ? 0 : 1`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Certificate|<p>The encryption status for connections from a proxy.</p>|Dependent item|zabbix.proxy.cert[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.cert`</p></li><li><p>JavaScript: `return value === 'false' ? 0 : 1`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Compression|<p>The compression status of a proxy.</p>|Dependent item|zabbix.proxy.compression[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.compression`</p></li><li><p>JavaScript: `return value === 'false' ? 0 : 1`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Item count|<p>The number of enabled items on enabled hosts assigned to a proxy.</p>|Dependent item|zabbix.proxy.items[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.items`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Host count|<p>The number of enabled hosts assigned to a proxy.</p>|Dependent item|zabbix.proxy.hosts[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.hosts`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Version|<p>A version of Zabbix proxy.</p>|Dependent item|zabbix.proxy.version[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.version`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Last seen, in seconds|<p>The time when a proxy was last seen by a server.</p>|Dependent item|zabbix.proxy.last_seen[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.last_seen`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Compatibility|<p>Version of proxy compared to Zabbix server version.</p><p></p><p>Possible values:</p><p>0 - Undefined;</p><p>1 - Current version (proxy and server have the same major version);</p><p>2 - Outdated version (proxy version is older than server version, but is partially supported);</p><p>3 - Unsupported version (proxy version is older than server previous LTS release version or server major version is older than proxy major version).</p>|Dependent item|zabbix.proxy.compatibility[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.compatibility`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Required VPS|<p>The required performance of a proxy (the number of values that need to be collected per second).</p>|Dependent item|zabbix.proxy.requiredperformance[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.requiredperformance`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|

### Trigger prototypes for Zabbix proxy discovery

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Zabbix server: Proxy [{#PROXY.NAME}]: Zabbix proxy last seen|<p>Zabbix proxy is not updating the configuration data.</p>|`last(/Remote Zabbix server health/zabbix.proxy.last_seen[{#PROXY.NAME}],#1)>{$ZABBIX.PROXY.LAST_SEEN.MAX}`|Warning||
|Zabbix server: Proxy [{#PROXY.NAME}]: Zabbix proxy never seen|<p>Zabbix proxy is not updating the configuration data.</p>|`last(/Remote Zabbix server health/zabbix.proxy.last_seen[{#PROXY.NAME}],#1)=-1`|Warning||
|Zabbix server: Proxy [{#PROXY.NAME}]: Zabbix proxy is outdated|<p>Zabbix proxy version is older than server version, but is partially supported. Only data collection and remote execution is available.</p>|`last(/Remote Zabbix server health/zabbix.proxy.compatibility[{#PROXY.NAME}],#1)=2`|Warning||
|Zabbix server: Proxy [{#PROXY.NAME}]: Zabbix proxy is not supported|<p>Zabbix proxy version is older than server previous LTS release version or server major version is older than proxy major version.</p>|`last(/Remote Zabbix server health/zabbix.proxy.compatibility[{#PROXY.NAME}],#1)=3`|High||

### LLD rule High availability cluster node discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|High availability cluster node discovery|<p>LLD rule with item and trigger prototypes for node discovery.</p>|Dependent item|zabbix.nodes.discovery<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.ha`</p></li><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|

### Item prototypes for High availability cluster node discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Cluster node [{#NODE.NAME}]: Stats|<p>Provides the statistics of a node.</p>|Dependent item|zabbix.node.stats[{#NODE.ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.ha[?(@.id=="{#NODE.ID}")].first()`</p></li></ul>|
|Cluster node [{#NODE.NAME}]: Address|<p>The IPv4 address of a node.</p>|Dependent item|zabbix.node.address[{#NODE.ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.address`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Cluster node [{#NODE.NAME}]: Last access time|<p>Last access time.</p>|Dependent item|zabbix.node.lastaccess.time[{#NODE.ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.lastaccess`</p></li></ul>|
|Cluster node [{#NODE.NAME}]: Last access age|<p>The time between the database's `unix_timestamp()` and the last access time.</p>|Dependent item|zabbix.node.lastaccess.age[{#NODE.ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.lastaccess_age`</p></li></ul>|
|Cluster node [{#NODE.NAME}]: Status|<p>The status of a node.</p>|Dependent item|zabbix.nodes.status[{#NODE.ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.status`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|

### Trigger prototypes for High availability cluster node discovery

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Zabbix server: Cluster node [{#NODE.NAME}]: Status changed|<p>The state of the node has changed. Acknowledge to close the problem manually.</p>|`last(/Remote Zabbix server health/zabbix.nodes.status[{#NODE.ID}],#1)<>last(/Remote Zabbix server health/zabbix.nodes.status[{#NODE.ID}],#2)`|Info|**Manual close**: Yes|

# Zabbix server health by Zabbix agent

## Overview

This template is designed to monitor Zabbix server metrics via the passive Zabbix agent.

## Requirements

Zabbix version: 7.0 and higher.

## Tested versions

This template has been tested on:
- Zabbix server 7.0

## Configuration

> Zabbix should be configured according to the instructions in the [Templates out of the box](https://www.zabbix.com/documentation/7.0/manual/config/templates_out_of_the_box) section.

## Setup

Specify the address of the remote Zabbix server by changing the `{$ZABBIX.SERVER.ADDRESS}` and `{$ZABBIX.SERVER.PORT}` macros. Don't forget to adjust the `StatsAllowedIP` parameter in the remote server's configuration file to allow the collection of statistics.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$ZABBIX.SERVER.ADDRESS}|<p>IP/DNS/network mask list of servers to be remotely queried (default is 127.0.0.1).</p>||
|{$ZABBIX.SERVER.PORT}|<p>Port of server to be remotely queried (default is 10051).</p>||
|{$ZABBIX.PROXY.LAST_SEEN.MAX}|<p>The maximum number of seconds that Zabbix proxy has not been seen.</p>|`600`|
|{$ZABBIX.SERVER.NODATA_TIMEOUT}|<p>The time threshold after which statistics are considered unavailable. Used in trigger expressions.</p>|`5m`|
|{$ZABBIX.SERVER.UTIL.MAX}|<p>Default maximum threshold for percentage utilization triggers (use macro context for specification).</p>|`75`|
|{$ZABBIX.SERVER.UTIL.MIN}|<p>Default minimum threshold for percentage utilization triggers (use macro context for specification).</p>|`65`|
|{$ZABBIX.SERVER.UTIL.MAX:"value cache"}|<p>Maximum threshold for value cache utilization triggers.</p>|`95`|

### Items

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Zabbix stats|<p>The master item of Zabbix server statistics.</p>|Zabbix agent|zabbix.stats[{$ZABBIX.SERVER.ADDRESS},{$ZABBIX.SERVER.PORT}]|
|Zabbix proxies stats|<p>The master item of Zabbix proxies' statistics.</p>|Dependent item|zabbix.proxies.stats<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.proxy`</p></li></ul>|
|Queue over 10 minutes|<p>The number of monitored items in the queue that are delayed by at least 10 minutes.</p>|Zabbix agent|zabbix.stats[{$ZABBIX.SERVER.ADDRESS},{$ZABBIX.SERVER.PORT},queue,10m]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.queue`</p></li></ul>|
|Queue|<p>The number of monitored items in the queue that are delayed by at least 6 seconds.</p>|Zabbix agent|zabbix.stats[{$ZABBIX.SERVER.ADDRESS},{$ZABBIX.SERVER.PORT},queue]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.queue`</p></li></ul>|
|Utilization of alert manager internal processes, in %|<p>The average percentage of the time during which the alert manager processes have been busy for the last minute.</p>|Dependent item|process.alert_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['alert manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "alert manager" processes started.`</p></li></ul>|
|Utilization of alert syncer internal processes, in %|<p>The average percentage of the time during which the alert syncer processes have been busy for the last minute.</p>|Dependent item|process.alert_syncer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['alert syncer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "alert syncer" processes started.`</p></li></ul>|
|Utilization of alerter internal processes, in %|<p>The average percentage of the time during which the alerter processes have been busy for the last minute.</p>|Dependent item|process.alerter.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['alerter'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "alerter" processes started.`</p></li></ul>|
|Utilization of availability manager internal processes, in %|<p>The average percentage of the time during which the availability manager processes have been busy for the last minute.</p>|Dependent item|process.availability_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['availability manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "availability manager" processes started.`</p></li></ul>|
|Utilization of configuration syncer internal processes, in %|<p>The average percentage of the time during which the configuration syncer processes have been busy for the last minute.</p>|Dependent item|process.configuration_syncer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['configuration syncer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "configuration syncer" processes started.`</p></li></ul>|
|Utilization of configuration syncer worker internal processes, in %|<p>The average percentage of the time during which the configuration syncer worker processes have been busy for the last minute.</p>|Dependent item|process.configuration_syncer_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['configuration syncer worker'].busy.avg`</p></li></ul>|
|Utilization of escalator internal processes, in %|<p>The average percentage of the time during which the escalator processes have been busy for the last minute.</p>|Dependent item|process.escalator.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['escalator'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "escalator" processes started.`</p></li></ul>|
|Utilization of history poller internal processes, in %|<p>The average percentage of the time during which the history poller processes have been busy for the last minute.</p>|Dependent item|process.history_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['history poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "history poller" processes started.`</p></li></ul>|
|Utilization of ODBC poller data collector processes, in %|<p>The average percentage of the time during which the ODBC poller processes have been busy for the last minute.</p>|Dependent item|process.odbc_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['odbc poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes odbc poller not started`</p></li></ul>|
|Utilization of history syncer internal processes, in %|<p>The average percentage of the time during which the history syncer processes have been busy for the last minute.</p>|Dependent item|process.history_syncer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['history syncer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "history syncer" processes started.`</p></li></ul>|
|Utilization of housekeeper internal processes, in %|<p>The average percentage of the time during which the housekeeper processes have been busy for the last minute.</p>|Dependent item|process.housekeeper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['housekeeper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "housekeeper" processes started.`</p></li></ul>|
|Utilization of http poller data collector processes, in %|<p>The average percentage of the time during which the http poller processes have been busy for the last minute.</p>|Dependent item|process.http_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['http poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "http poller" processes started.`</p></li></ul>|
|Utilization of icmp pinger data collector processes, in %|<p>The average percentage of the time during which the icmp pinger processes have been busy for the last minute.</p>|Dependent item|process.icmp_pinger.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['icmp pinger'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "icmp pinger" processes started.`</p></li></ul>|
|Utilization of ipmi manager internal processes, in %|<p>The average percentage of the time during which the ipmi manager processes have been busy for the last minute.</p>|Dependent item|process.ipmi_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['ipmi manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "ipmi manager" processes started.`</p></li></ul>|
|Utilization of ipmi poller data collector processes, in %|<p>The average percentage of the time during which the ipmi poller processes have been busy for the last minute.</p>|Dependent item|process.ipmi_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['ipmi poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "ipmi poller" processes started.`</p></li></ul>|
|Utilization of java poller data collector processes, in %|<p>The average percentage of the time during which the java poller processes have been busy for the last minute.</p>|Dependent item|process.java_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['java poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "java poller" processes started.`</p></li></ul>|
|Utilization of LLD manager internal processes, in %|<p>The average percentage of the time during which the LLD manager processes have been busy for the last minute.</p>|Dependent item|process.lld_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['lld manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "LLD manager" processes started.`</p></li></ul>|
|Utilization of LLD worker internal processes, in %|<p>The average percentage of the time during which the LLD worker processes have been busy for the last minute.</p>|Dependent item|process.lld_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['lld worker'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "LLD worker" processes started.`</p></li></ul>|
|Utilization of connector manager internal processes, in %|<p>The average percentage of the time during which the connector manager processes have been busy for the last minute.</p>|Dependent item|process.connector_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['connector manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "connector manager" processes started.`</p></li></ul>|
|Utilization of connector worker internal processes, in %|<p>The average percentage of the time during which the connector worker processes have been busy for the last minute.</p>|Dependent item|process.connector_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['connector worker'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "connector worker" processes started.`</p></li></ul>|
|Utilization of discovery manager internal processes, in %|<p>The average percentage of the time during which the discovery manager processes have been busy for the last minute.</p>|Dependent item|process.discovery_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['discovery manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "discovery manager" processes started.`</p></li></ul>|
|Utilization of discovery worker internal processes, in %|<p>The average percentage of the time during which the discovery worker processes have been busy for the last minute.</p>|Dependent item|process.discovery_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['discovery worker'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "discovery worker" processes started.`</p></li></ul>|
|Utilization of poller data collector processes, in %|<p>The average percentage of the time during which the poller processes have been busy for the last minute.</p>|Dependent item|process.poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "poller" processes started.`</p></li></ul>|
|Utilization of preprocessing worker internal processes, in %|<p>The average percentage of the time during which the preprocessing worker processes have been busy for the last minute.</p>|Dependent item|process.preprocessing_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['preprocessing worker'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "preprocessing worker" processes started.`</p></li></ul>|
|Utilization of preprocessing manager internal processes, in %|<p>The average percentage of the time during which the preprocessing manager processes have been busy for the last minute.</p>|Dependent item|process.preprocessing_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['preprocessing manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "preprocessing manager" processes started.`</p></li></ul>|
|Utilization of proxy poller data collector processes, in %|<p>The average percentage of the time during which the proxy poller processes have been busy for the last minute.</p>|Dependent item|process.proxy_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['proxy poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "proxy poller" processes started.`</p></li></ul>|
|Utilization of proxy group manager internal processes, in %|<p>The average percentage of the time during which the proxy group manager processes have been busy for the last minute.</p>|Dependent item|process.proxy_group_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['proxy group manager'].busy.avg`</p></li></ul>|
|Utilization of report manager internal processes, in %|<p>The average percentage of the time during which the report manager processes have been busy for the last minute.</p>|Dependent item|process.report_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['report manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "report manager" processes started.`</p></li></ul>|
|Utilization of report writer internal processes, in %|<p>The average percentage of the time during which the report writer processes have been busy for the last minute.</p>|Dependent item|process.report_writer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['report writer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "report writer" processes started.`</p></li></ul>|
|Utilization of self-monitoring internal processes, in %|<p>The average percentage of the time during which the self-monitoring processes have been busy for the last minute.</p>|Dependent item|process.self-monitoring.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['self-monitoring'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "self-monitoring" processes started.`</p></li></ul>|
|Utilization of snmp trapper data collector processes, in %|<p>The average percentage of the time during which the snmp trapper processes have been busy for the last minute.</p>|Dependent item|process.snmp_trapper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['snmp trapper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "snmp trapper" processes started.`</p></li></ul>|
|Utilization of task manager internal processes, in %|<p>The average percentage of the time during which the task manager processes have been busy for the last minute.</p>|Dependent item|process.task_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['task manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "task manager" processes started.`</p></li></ul>|
|Utilization of timer internal processes, in %|<p>The average percentage of the time during which the timer processes have been busy for the last minute.</p>|Dependent item|process.timer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['timer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "timer" processes started.`</p></li></ul>|
|Utilization of service manager internal processes, in %|<p>The average percentage of the time during which the service manager processes have been busy for the last minute.</p>|Dependent item|process.service_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['service manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "service manager" processes started.`</p></li></ul>|
|Utilization of trigger housekeeper internal processes, in %|<p>The average percentage of the time during which the trigger housekeeper processes have been busy for the last minute.</p>|Dependent item|process.trigger_housekeeper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['trigger housekeeper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "trigger housekeeper" processes started.`</p></li></ul>|
|Utilization of trapper data collector processes, in %|<p>The average percentage of the time during which the trapper processes have been busy for the last minute.</p>|Dependent item|process.trapper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['trapper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "trapper" processes started.`</p></li></ul>|
|Utilization of unreachable poller data collector processes, in %|<p>The average percentage of the time during which the unreachable poller processes have been busy for the last minute.</p>|Dependent item|process.unreachable_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['unreachable poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "unreachable poller" processes started.`</p></li></ul>|
|Utilization of vmware collector data collector processes, in %|<p>The average percentage of the time during which the vmware collector processes have been busy for the last minute.</p>|Dependent item|process.vmware_collector.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['vmware collector'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "vmware collector" processes started.`</p></li></ul>|
|Utilization of agent poller data collector processes, in %|<p>The average percentage of the time during which the agent poller processes have been busy for the last minute.</p>|Dependent item|process.agent_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['agent poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "agent poller" processes started.`</p></li></ul>|
|Utilization of http agent poller data collector processes, in %|<p>The average percentage of the time during which the http agent poller processes have been busy for the last minute.</p>|Dependent item|process.http_agent_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['http agent poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "http agent poller" processes started.`</p></li></ul>|
|Utilization of snmp poller data collector processes, in %|<p>The average percentage of the time during which the snmp poller processes have been busy for the last minute.</p>|Dependent item|process.snmp_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['snmp poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "snmp poller" processes started.`</p></li></ul>|
|Utilization of internal poller data collector processes, in %|<p>The average percentage of the time during which the internal poller processes have been busy for the last minute.</p>|Dependent item|process.internal_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['internal poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "internal poller" processes started.`</p></li></ul>|
|Utilization of browser poller data collector processes, in %|<p>The average percentage of the time during which the browser poller processes have been busy for the last minute.</p>|Dependent item|process.browser_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['browser poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "browser poller" processes started.`</p></li></ul>|
|Configuration cache, % used|<p>The availability statistics of Zabbix configuration cache. The percentage of used data buffer.</p>|Dependent item|rcache.buffer.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.rcache.pused`</p></li></ul>|
|Trend function cache, % of unique requests|<p>The effectiveness statistics of the Zabbix trend function cache. The percentage of cached items calculated from the sum of the cached items plus requests.</p><p>A low percentage most likely means that the cache size can be reduced.</p>|Dependent item|tcache.pitems<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.tcache.pitems`</p><p>⛔️Custom on fail: Set error to: `Not supported in this version.`</p></li></ul>|
|Trend function cache, % of misses|<p>The effectiveness statistics of the Zabbix trend function cache. The percentage of cache misses.</p>|Dependent item|tcache.pmisses<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.tcache.pmisses`</p><p>⛔️Custom on fail: Set error to: `Not supported in this version.`</p></li></ul>|
|Value cache, % used|<p>The availability statistics of Zabbix value cache. The percentage of used data buffer.</p>|Dependent item|vcache.buffer.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vcache.buffer.pused`</p></li></ul>|
|Value cache hits|<p>The effectiveness statistics of Zabbix value cache. The number of cache hits (history values taken from the cache).</p>|Dependent item|vcache.cache.hits<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vcache.cache.hits`</p></li><li>Change per second</li></ul>|
|Value cache misses|<p>The effectiveness statistics of Zabbix value cache. The number of cache misses (history values taken from the database).</p>|Dependent item|vcache.cache.misses<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vcache.cache.misses`</p></li><li>Change per second</li></ul>|
|Value cache operating mode|<p>The operating mode of the value cache.</p>|Dependent item|vcache.cache.mode<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vcache.cache.mode`</p></li></ul>|
|Zabbix server check|<p>Flag indicating whether it is a server or not.</p>|Dependent item|server_check<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.triggers`</p><p>⛔️Custom on fail: Set value to: `0`</p></li><li><p>In range: ` -> 0`</p><p>⛔️Custom on fail: Set value to: `1`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Version|<p>The version of Zabbix server.</p>|Dependent item|version<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.version`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|VMware cache, % used|<p>The availability statistics of Zabbix vmware cache. The percentage of used data buffer.</p>|Dependent item|vmware.buffer.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vmware.pused`</p><p>⛔️Custom on fail: Set error to: `No "vmware collector" processes started.`</p></li></ul>|
|History write cache, % used|<p>The statistics and availability of Zabbix write cache. The percentage of used history buffer.</p><p>The history cache is used to store item values. A high number indicates database performance problems.</p>|Dependent item|wcache.history.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.history.pused`</p></li></ul>|
|History index cache, % used|<p>The statistics and availability of Zabbix write cache. The percentage of used history index buffer.</p><p>The history index cache is used to index values stored in the history cache.</p>|Dependent item|wcache.index.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.index.pused`</p></li></ul>|
|Trend write cache, % used|<p>The statistics and availability of Zabbix write cache. The percentage of used trend buffer.</p><p>The trend cache stores the aggregate of all items that have received data for the current hour.</p>|Dependent item|wcache.trend.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.trend.pused`</p></li></ul>|
|Number of processed values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The total number of values processed by Zabbix server or Zabbix proxy, except unsupported items.</p>|Dependent item|wcache.values<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.all`</p></li><li>Change per second</li></ul>|
|Number of processed numeric (unsigned) values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed numeric (unsigned) values.</p>|Dependent item|wcache.values.uint<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.uint`</p></li><li>Change per second</li></ul>|
|Number of processed numeric (float) values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed numeric (float) values.</p>|Dependent item|wcache.values.float<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.float`</p></li><li>Change per second</li></ul>|
|Number of processed log values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed log values.</p>|Dependent item|wcache.values.log<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.log`</p></li><li>Change per second</li></ul>|
|Number of processed not supported values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of times the item processing resulted in an item becoming unsupported or remaining in that state.</p>|Dependent item|wcache.values.not_supported<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values['not supported']`</p></li><li>Change per second</li></ul>|
|Number of processed character values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed character values.</p>|Dependent item|wcache.values.str<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.str`</p></li><li>Change per second</li></ul>|
|Number of processed text values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed text values.</p>|Dependent item|wcache.values.text<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.text`</p></li><li>Change per second</li></ul>|
|Number of values synchronized with the database per second|<p>Average quantity of values written to the database, recalculated once per minute.</p>|Dependent item|vps.written<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vps.written_total`</p></li><li>Change per second</li></ul>|
|LLD queue|<p>The number of values enqueued in the low-level discovery processing queue.</p>|Dependent item|lld_queue<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.lld_queue`</p></li></ul>|
|Preprocessing queue|<p>The number of values enqueued in the preprocessing queue.</p>|Dependent item|preprocessing_queue<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.preprocessing.queue`</p></li></ul>|
|Preprocessing queued throughput|<p>Reflects the queued throughput of the preprocessing.</p>|Dependent item|preprocessing_throughput_queued<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.preprocessing.queued.size`</p><p>⛔️Custom on fail: Discard value</p></li><li>Change per second</li></ul>|
|Preprocessing direct throughput|<p>Reflects the direct throughput of the preprocessing.</p>|Dependent item|preprocessing_throughput_direct<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.preprocessing.direct.size`</p><p>⛔️Custom on fail: Discard value</p></li><li>Change per second</li></ul>|
|Preprocessing queued VPS|<p>Reflects the count of queued preprocessing values per second.</p>|Dependent item|preprocessing_vps_queued<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.preprocessing.queued.count`</p><p>⛔️Custom on fail: Discard value</p></li><li>Change per second</li></ul>|
|Preprocessing direct VPS|<p>Reflects the count of direct preprocessing values per second.</p>|Dependent item|preprocessing_vps_direct<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.preprocessing.direct.count`</p><p>⛔️Custom on fail: Discard value</p></li><li>Change per second</li></ul>|
|Connector queue|<p>The count of values enqueued in the connector queue.</p>|Dependent item|connector_queue<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.connector_queue`</p><p>⛔️Custom on fail: Set error to: `No "connector" processes started. Please check "StartConnectors" parameter in the server configuration file.`</p></li></ul>|
|Discovery queue|<p>The count of values enqueued in the discovery queue.</p>|Dependent item|discovery_queue<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.discovery_queue`</p><p>⛔️Custom on fail: Set error to: `No "discoverer" processes started. Please check "StartDiscoverers" parameter in the server configuration file.`</p></li></ul>|

### Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Zabbix server: More than 100 items have been missing data for over 10 minutes|<p>Indicates potential issues with network connectivity, agent failures, or unresponsive monitored resources that require attention.</p>|`min(/Zabbix server health by Zabbix agent/zabbix.stats[{$ZABBIX.SERVER.ADDRESS},{$ZABBIX.SERVER.PORT},queue,10m],10m)>100`|Warning|**Manual close**: Yes|
|Zabbix server: Utilization of alert manager processes is high|<p>Indicates potential performance issues with the alert manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.alert_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"alert manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of alert syncer processes is high|<p>Indicates potential performance issues with the alert syncer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.alert_syncer.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"alert syncer"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of alerter processes is high|<p>Indicates potential performance issues with the alerter, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.alerter.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"alerter"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of availability manager processes is high|<p>Indicates potential performance issues with the availability manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.availability_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"availability manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of configuration syncer processes is high|<p>Indicates potential performance issues with the configuration syncer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.configuration_syncer.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"configuration syncer"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of configuration syncer worker processes is high|<p>Indicates potential performance issues with the configuration syncer worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.configuration_syncer_worker.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"configuration syncer worker"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of escalator processes is high|<p>Indicates potential performance issues with the escalator, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.escalator.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"escalator"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of history poller processes is high|<p>Indicates potential performance issues with the history poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.history_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"history poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of ODBC poller processes is high|<p>Indicates potential performance issues with the ODBC poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.odbc_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"ODBC poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of history syncer processes is high|<p>Indicates potential performance issues with the history syncer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.history_syncer.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"history syncer"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of housekeeper processes is high|<p>Indicates potential performance issues with the housekeeper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.housekeeper.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"housekeeper"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of http poller processes is high|<p>Indicates potential performance issues with the http poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.http_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"http poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of icmp pinger processes is high|<p>Indicates potential performance issues with the icmp pinger, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.icmp_pinger.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"icmp pinger"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of ipmi manager processes is high|<p>Indicates potential performance issues with the ipmi manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.ipmi_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"ipmi manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of ipmi poller processes is high|<p>Indicates potential performance issues with the ipmi poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.ipmi_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"ipmi poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of java poller processes is high|<p>Indicates potential performance issues with the java poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.java_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"java poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of LLD manager processes is high|<p>Indicates potential performance issues with the LLD manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.lld_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"LLD manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of LLD worker processes is high|<p>Indicates potential performance issues with the LLD worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.lld_worker.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"LLD worker"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of connector manager processes is high|<p>Indicates potential performance issues with the connector manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.connector_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"connector manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of connector worker processes is high|<p>Indicates potential performance issues with the connector worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.connector_worker.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"connector worker"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of discovery manager processes is high|<p>Indicates potential performance issues with the discovery manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.discovery_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"discovery manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of discovery worker processes is high|<p>Indicates potential performance issues with the discovery worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.discovery_worker.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"discovery worker"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of poller processes is high|<p>Indicates potential performance issues with the poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of preprocessing worker processes is high|<p>Indicates potential performance issues with the preprocessing worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.preprocessing_worker.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"preprocessing worker"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of preprocessing manager processes is high|<p>Indicates potential performance issues with the preprocessing manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.preprocessing_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"preprocessing manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of proxy poller processes is high|<p>Indicates potential performance issues with the proxy poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.proxy_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"proxy poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of proxy group manager processes is high|<p>Indicates potential performance issues with the proxy group manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.proxy_group_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"proxy group manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of report manager processes is high|<p>Indicates potential performance issues with the report manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.report_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"report manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of report writer processes is high|<p>Indicates potential performance issues with the report writer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.report_writer.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"report writer"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of self-monitoring processes is high|<p>Indicates potential performance issues with the self-monitoring, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.self-monitoring.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"self-monitoring"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of snmp trapper processes is high|<p>Indicates potential performance issues with the snmp trapper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.snmp_trapper.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"snmp trapper"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of task manager processes is high|<p>Indicates potential performance issues with the task manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.task_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"task manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of timer processes is high|<p>Indicates potential performance issues with the timer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.timer.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"timer"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of service manager processes is high|<p>Indicates potential performance issues with the service manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.service_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"service manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of trigger housekeeper processes is high|<p>Indicates potential performance issues with the trigger housekeeper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.trigger_housekeeper.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"trigger housekeeper"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of trapper processes is high|<p>Indicates potential performance issues with the trapper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.trapper.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"trapper"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of unreachable poller processes is high|<p>Indicates potential performance issues with the unreachable poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.unreachable_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"unreachable poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of vmware collector processes is high|<p>Indicates potential performance issues with the vmware collector, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.vmware_collector.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"vmware collector"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of agent poller processes is high|<p>Indicates potential performance issues with the agent poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.agent_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"agent poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of http agent poller processes is high|<p>Indicates potential performance issues with the http agent poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.http_agent_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"http agent poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of snmp poller processes is high|<p>Indicates potential performance issues with the snmp poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.snmp_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"snmp poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of internal poller processes is high|<p>Indicates potential performance issues with the internal poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.internal_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"internal poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of browser poller processes is high|<p>Indicates potential performance issues with the browser poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent/process.browser_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"browser poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Excessive configuration cache usage|<p>Consider increasing `CacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Zabbix server health by Zabbix agent/rcache.buffer.pused,10m)>{$ZABBIX.SERVER.UTIL.MAX:"configuration cache"}`|Average|**Manual close**: Yes|
|Zabbix server: Failed to fetch stats data|<p>Zabbix has not received statistics data for `{$ZABBIX.SERVER.NODATA_TIMEOUT}`.</p>|`nodata(/Zabbix server health by Zabbix agent/rcache.buffer.pused,{$ZABBIX.SERVER.NODATA_TIMEOUT})=1`|Warning||
|Zabbix server: Excessive value cache usage|<p>Consider increasing `ValueCacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Zabbix server health by Zabbix agent/vcache.buffer.pused,10m)>{$ZABBIX.SERVER.UTIL.MAX:"value cache"}`|Average|**Manual close**: Yes|
|Zabbix server: Zabbix value cache working in low-memory mode|<p>Once low-memory mode has been switched on, the value cache will remain in this state for 24 hours, even if the problem that triggered this mode is resolved sooner.</p>|`last(/Zabbix server health by Zabbix agent/vcache.cache.mode)=1`|High|**Manual close**: Yes|
|Zabbix server: Wrong template assigned|<p>Check that the template has been selected correctly.</p>|`last(/Zabbix server health by Zabbix agent/server_check)=0`|Disaster|**Manual close**: Yes|
|Zabbix server: Version has changed|<p>Zabbix server version has changed. Acknowledge to close the problem manually.</p>|`last(/Zabbix server health by Zabbix agent/version,#1)<>last(/Zabbix server health by Zabbix agent/version,#2) and length(last(/Zabbix server health by Zabbix agent/version))>0`|Info|**Manual close**: Yes|
|Zabbix server: Excessive vmware cache usage|<p>Consider increasing `VMwareCacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Zabbix server health by Zabbix agent/vmware.buffer.pused,10m)>{$ZABBIX.SERVER.UTIL.MAX:"vmware cache"}`|Average|**Manual close**: Yes|
|Zabbix server: Excessive history cache usage|<p>Consider increasing `HistoryCacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Zabbix server health by Zabbix agent/wcache.history.pused,10m)>{$ZABBIX.SERVER.UTIL.MAX:"history cache"}`|Average|**Manual close**: Yes|
|Zabbix server: Excessive history index cache usage|<p>Consider increasing `HistoryIndexCacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Zabbix server health by Zabbix agent/wcache.index.pused,10m)>{$ZABBIX.SERVER.UTIL.MAX:"index cache"}`|Average|**Manual close**: Yes|
|Zabbix server: Excessive trends cache usage|<p>Consider increasing `TrendCacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Zabbix server health by Zabbix agent/wcache.trend.pused,10m)>{$ZABBIX.SERVER.UTIL.MAX:"trend cache"}`|Average|**Manual close**: Yes|

### LLD rule Zabbix proxy discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Zabbix proxy discovery|<p>LLD rule with item and trigger prototypes for proxy discovery.</p>|Dependent item|zabbix.proxy.discovery<p>**Preprocessing**</p><ul><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|

### Item prototypes for Zabbix proxy discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Proxy [{#PROXY.NAME}]: Stats|<p>The statistics for the discovered proxy.</p>|Dependent item|zabbix.proxy.stats[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.[?(@.name=="{#PROXY.NAME}")].first()`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Mode|<p>The mode of Zabbix proxy.</p>|Dependent item|zabbix.proxy.mode[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.passive`</p></li><li><p>JavaScript: `return value === 'false' ? 0 : 1`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Unencrypted|<p>The encryption status for connections from a proxy.</p>|Dependent item|zabbix.proxy.unencrypted[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.unencrypted`</p></li><li><p>JavaScript: `return value === 'false' ? 0 : 1`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: PSK|<p>The encryption status for connections from a proxy.</p>|Dependent item|zabbix.proxy.psk[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.psk`</p></li><li><p>JavaScript: `return value === 'false' ? 0 : 1`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Certificate|<p>The encryption status for connections from a proxy.</p>|Dependent item|zabbix.proxy.cert[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.cert`</p></li><li><p>JavaScript: `return value === 'false' ? 0 : 1`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Compression|<p>The compression status of a proxy.</p>|Dependent item|zabbix.proxy.compression[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.compression`</p></li><li><p>JavaScript: `return value === 'false' ? 0 : 1`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Item count|<p>The number of enabled items on enabled hosts assigned to a proxy.</p>|Dependent item|zabbix.proxy.items[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.items`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Host count|<p>The number of enabled hosts assigned to a proxy.</p>|Dependent item|zabbix.proxy.hosts[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.hosts`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Version|<p>A version of Zabbix proxy.</p>|Dependent item|zabbix.proxy.version[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.version`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Last seen, in seconds|<p>The time when a proxy was last seen by a server.</p>|Dependent item|zabbix.proxy.last_seen[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.last_seen`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Compatibility|<p>Version of proxy compared to Zabbix server version.</p><p></p><p>Possible values:</p><p>0 - Undefined;</p><p>1 - Current version (proxy and server have the same major version);</p><p>2 - Outdated version (proxy version is older than server version, but is partially supported);</p><p>3 - Unsupported version (proxy version is older than server previous LTS release version or server major version is older than proxy major version).</p>|Dependent item|zabbix.proxy.compatibility[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.compatibility`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Required VPS|<p>The required performance of a proxy (the number of values that need to be collected per second).</p>|Dependent item|zabbix.proxy.requiredperformance[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.requiredperformance`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|

### Trigger prototypes for Zabbix proxy discovery

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Zabbix server: Proxy [{#PROXY.NAME}]: Zabbix proxy last seen|<p>Zabbix proxy is not updating the configuration data.</p>|`last(/Zabbix server health by Zabbix agent/zabbix.proxy.last_seen[{#PROXY.NAME}],#1)>{$ZABBIX.PROXY.LAST_SEEN.MAX}`|Warning||
|Zabbix server: Proxy [{#PROXY.NAME}]: Zabbix proxy never seen|<p>Zabbix proxy is not updating the configuration data.</p>|`last(/Zabbix server health by Zabbix agent/zabbix.proxy.last_seen[{#PROXY.NAME}],#1)=-1`|Warning||
|Zabbix server: Proxy [{#PROXY.NAME}]: Zabbix proxy is outdated|<p>Zabbix proxy version is older than server version, but is partially supported. Only data collection and remote execution is available.</p>|`last(/Zabbix server health by Zabbix agent/zabbix.proxy.compatibility[{#PROXY.NAME}],#1)=2`|Warning||
|Zabbix server: Proxy [{#PROXY.NAME}]: Zabbix proxy is not supported|<p>Zabbix proxy version is older than server previous LTS release version or server major version is older than proxy major version.</p>|`last(/Zabbix server health by Zabbix agent/zabbix.proxy.compatibility[{#PROXY.NAME}],#1)=3`|High||

### LLD rule High availability cluster node discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|High availability cluster node discovery|<p>LLD rule with item and trigger prototypes for node discovery.</p>|Dependent item|zabbix.nodes.discovery<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.ha`</p></li><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|

### Item prototypes for High availability cluster node discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Cluster node [{#NODE.NAME}]: Stats|<p>Provides the statistics of a node.</p>|Dependent item|zabbix.node.stats[{#NODE.ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.ha[?(@.id=="{#NODE.ID}")].first()`</p></li></ul>|
|Cluster node [{#NODE.NAME}]: Address|<p>The IPv4 address of a node.</p>|Dependent item|zabbix.node.address[{#NODE.ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.address`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Cluster node [{#NODE.NAME}]: Last access time|<p>Last access time.</p>|Dependent item|zabbix.node.lastaccess.time[{#NODE.ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.lastaccess`</p></li></ul>|
|Cluster node [{#NODE.NAME}]: Last access age|<p>The time between the database's `unix_timestamp()` and the last access time.</p>|Dependent item|zabbix.node.lastaccess.age[{#NODE.ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.lastaccess_age`</p></li></ul>|
|Cluster node [{#NODE.NAME}]: Status|<p>The status of a node.</p>|Dependent item|zabbix.nodes.status[{#NODE.ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.status`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|

### Trigger prototypes for High availability cluster node discovery

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Zabbix server: Cluster node [{#NODE.NAME}]: Status changed|<p>The state of the node has changed. Acknowledge to close the problem manually.</p>|`last(/Zabbix server health by Zabbix agent/zabbix.nodes.status[{#NODE.ID}],#1)<>last(/Zabbix server health by Zabbix agent/zabbix.nodes.status[{#NODE.ID}],#2)`|Info|**Manual close**: Yes|

# Zabbix server health by Zabbix agent active

## Overview

This template is designed to monitor Zabbix server metrics via the active Zabbix agent.

## Requirements

Zabbix version: 7.0 and higher.

## Tested versions

This template has been tested on:
- Zabbix server 7.0

## Configuration

> Zabbix should be configured according to the instructions in the [Templates out of the box](https://www.zabbix.com/documentation/7.0/manual/config/templates_out_of_the_box) section.

## Setup

Specify the address of the remote Zabbix server by changing the `{$ZABBIX.SERVER.ADDRESS}` and `{$ZABBIX.SERVER.PORT}` macros. Don't forget to adjust the `StatsAllowedIP` parameter in the remote server's configuration file to allow the collection of statistics.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$ZABBIX.SERVER.ADDRESS}|<p>IP/DNS/network mask list of servers to be remotely queried (default is 127.0.0.1).</p>||
|{$ZABBIX.SERVER.PORT}|<p>Port of server to be remotely queried (default is 10051).</p>||
|{$ZABBIX.PROXY.LAST_SEEN.MAX}|<p>The maximum number of seconds that Zabbix proxy has not been seen.</p>|`600`|
|{$ZABBIX.SERVER.NODATA_TIMEOUT}|<p>The time threshold after which statistics are considered unavailable. Used in trigger expression.</p>|`5m`|
|{$ZABBIX.SERVER.UTIL.MAX}|<p>Default maximum threshold for percentage utilization triggers (use macro context for specification).</p>|`75`|
|{$ZABBIX.SERVER.UTIL.MIN}|<p>Default minimum threshold for percentage utilization triggers (use macro context for specification).</p>|`65`|
|{$ZABBIX.SERVER.UTIL.MAX:"value cache"}|<p>Maximum threshold for value cache utilization triggers.</p>|`95`|

### Items

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Zabbix stats|<p>The master item of Zabbix server statistics.</p>|Zabbix agent (active)|zabbix.stats[{$ZABBIX.SERVER.ADDRESS},{$ZABBIX.SERVER.PORT}]|
|Zabbix proxies stats|<p>The master item of Zabbix proxies' statistics.</p>|Dependent item|zabbix.proxies.stats<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.proxy`</p></li></ul>|
|Queue over 10 minutes|<p>The number of monitored items in the queue that are delayed by at least 10 minutes.</p>|Zabbix agent (active)|zabbix.stats[{$ZABBIX.SERVER.ADDRESS},{$ZABBIX.SERVER.PORT},queue,10m]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.queue`</p></li></ul>|
|Queue|<p>The number of monitored items in the queue that are delayed by at least 6 seconds.</p>|Zabbix agent (active)|zabbix.stats[{$ZABBIX.SERVER.ADDRESS},{$ZABBIX.SERVER.PORT},queue]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.queue`</p></li></ul>|
|Utilization of alert manager internal processes, in %|<p>The average percentage of the time during which the alert manager processes have been busy for the last minute.</p>|Dependent item|process.alert_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['alert manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "alert manager" processes started.`</p></li></ul>|
|Utilization of alert syncer internal processes, in %|<p>The average percentage of the time during which the alert syncer processes have been busy for the last minute.</p>|Dependent item|process.alert_syncer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['alert syncer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "alert syncer" processes started.`</p></li></ul>|
|Utilization of alerter internal processes, in %|<p>The average percentage of the time during which the alerter processes have been busy for the last minute.</p>|Dependent item|process.alerter.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['alerter'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "alerter" processes started.`</p></li></ul>|
|Utilization of availability manager internal processes, in %|<p>The average percentage of the time during which the availability manager processes have been busy for the last minute.</p>|Dependent item|process.availability_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['availability manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "availability manager" processes started.`</p></li></ul>|
|Utilization of configuration syncer internal processes, in %|<p>The average percentage of the time during which the configuration syncer processes have been busy for the last minute.</p>|Dependent item|process.configuration_syncer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['configuration syncer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "configuration syncer" processes started.`</p></li></ul>|
|Utilization of configuration syncer worker internal processes, in %|<p>The average percentage of the time during which the configuration syncer worker processes have been busy for the last minute.</p>|Dependent item|process.configuration_syncer_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['configuration syncer worker'].busy.avg`</p></li></ul>|
|Utilization of escalator internal processes, in %|<p>The average percentage of the time during which the escalator processes have been busy for the last minute.</p>|Dependent item|process.escalator.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['escalator'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "escalator" processes started.`</p></li></ul>|
|Utilization of history poller internal processes, in %|<p>The average percentage of the time during which the history poller processes have been busy for the last minute.</p>|Dependent item|process.history_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['history poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "history poller" processes started.`</p></li></ul>|
|Utilization of ODBC poller data collector processes, in %|<p>The average percentage of the time during which the ODBC poller processes have been busy for the last minute.</p>|Dependent item|process.odbc_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['odbc poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `Processes odbc poller not started`</p></li></ul>|
|Utilization of history syncer internal processes, in %|<p>The average percentage of the time during which the history syncer processes have been busy for the last minute.</p>|Dependent item|process.history_syncer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['history syncer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "history syncer" processes started.`</p></li></ul>|
|Utilization of housekeeper internal processes, in %|<p>The average percentage of the time during which the housekeeper processes have been busy for the last minute.</p>|Dependent item|process.housekeeper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['housekeeper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "housekeeper" processes started.`</p></li></ul>|
|Utilization of http poller data collector processes, in %|<p>The average percentage of the time during which the http poller processes have been busy for the last minute.</p>|Dependent item|process.http_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['http poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "http poller" processes started.`</p></li></ul>|
|Utilization of icmp pinger data collector processes, in %|<p>The average percentage of the time during which the icmp pinger processes have been busy for the last minute.</p>|Dependent item|process.icmp_pinger.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['icmp pinger'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "icmp pinger" processes started.`</p></li></ul>|
|Utilization of ipmi manager internal processes, in %|<p>The average percentage of the time during which the ipmi manager processes have been busy for the last minute.</p>|Dependent item|process.ipmi_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['ipmi manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "ipmi manager" processes started.`</p></li></ul>|
|Utilization of ipmi poller data collector processes, in %|<p>The average percentage of the time during which the ipmi poller processes have been busy for the last minute.</p>|Dependent item|process.ipmi_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['ipmi poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "ipmi poller" processes started.`</p></li></ul>|
|Utilization of java poller data collector processes, in %|<p>The average percentage of the time during which the java poller processes have been busy for the last minute.</p>|Dependent item|process.java_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['java poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "java poller" processes started.`</p></li></ul>|
|Utilization of LLD manager internal processes, in %|<p>The average percentage of the time during which the LLD manager processes have been busy for the last minute.</p>|Dependent item|process.lld_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['lld manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "LLD manager" processes started.`</p></li></ul>|
|Utilization of LLD worker internal processes, in %|<p>The average percentage of the time during which the LLD worker processes have been busy for the last minute.</p>|Dependent item|process.lld_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['lld worker'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "LLD worker" processes started.`</p></li></ul>|
|Utilization of connector manager internal processes, in %|<p>The average percentage of the time during which the connector manager processes have been busy for the last minute.</p>|Dependent item|process.connector_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['connector manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "connector manager" processes started.`</p></li></ul>|
|Utilization of connector worker internal processes, in %|<p>The average percentage of the time during which the connector worker processes have been busy for the last minute.</p>|Dependent item|process.connector_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['connector worker'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "connector worker" processes started.`</p></li></ul>|
|Utilization of discovery manager internal processes, in %|<p>The average percentage of the time during which the discovery manager processes have been busy for the last minute.</p>|Dependent item|process.discovery_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['discovery manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "discovery manager" processes started.`</p></li></ul>|
|Utilization of discovery worker internal processes, in %|<p>The average percentage of the time during which the discovery worker processes have been busy for the last minute.</p>|Dependent item|process.discovery_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['discovery worker'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "discovery worker" processes started.`</p></li></ul>|
|Utilization of poller data collector processes, in %|<p>The average percentage of the time during which the poller processes have been busy for the last minute.</p>|Dependent item|process.poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "poller" processes started.`</p></li></ul>|
|Utilization of preprocessing worker internal processes, in %|<p>The average percentage of the time during which the preprocessing worker processes have been busy for the last minute.</p>|Dependent item|process.preprocessing_worker.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['preprocessing worker'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "preprocessing worker" processes started.`</p></li></ul>|
|Utilization of preprocessing manager internal processes, in %|<p>The average percentage of the time during which the preprocessing manager processes have been busy for the last minute.</p>|Dependent item|process.preprocessing_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['preprocessing manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "preprocessing manager" processes started.`</p></li></ul>|
|Utilization of proxy poller data collector processes, in %|<p>The average percentage of the time during which the proxy poller processes have been busy for the last minute.</p>|Dependent item|process.proxy_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['proxy poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "proxy poller" processes started.`</p></li></ul>|
|Utilization of proxy group manager internal processes, in %|<p>The average percentage of the time during which the proxy group manager processes have been busy for the last minute.</p>|Dependent item|process.proxy_group_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['proxy group manager'].busy.avg`</p></li></ul>|
|Utilization of report manager internal processes, in %|<p>The average percentage of the time during which the report manager processes have been busy for the last minute.</p>|Dependent item|process.report_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['report manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "report manager" processes started.`</p></li></ul>|
|Utilization of report writer internal processes, in %|<p>The average percentage of the time during which the report writer processes have been busy for the last minute.</p>|Dependent item|process.report_writer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['report writer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "report writer" processes started.`</p></li></ul>|
|Utilization of self-monitoring internal processes, in %|<p>The average percentage of the time during which the self-monitoring processes have been busy for the last minute.</p>|Dependent item|process.self-monitoring.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['self-monitoring'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "self-monitoring" processes started.`</p></li></ul>|
|Utilization of snmp trapper data collector processes, in %|<p>The average percentage of the time during which the snmp trapper processes have been busy for the last minute.</p>|Dependent item|process.snmp_trapper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['snmp trapper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "snmp trapper" processes started.`</p></li></ul>|
|Utilization of task manager internal processes, in %|<p>The average percentage of the time during which the task manager processes have been busy for the last minute.</p>|Dependent item|process.task_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['task manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "task manager" processes started.`</p></li></ul>|
|Utilization of timer internal processes, in %|<p>The average percentage of the time during which the timer processes have been busy for the last minute.</p>|Dependent item|process.timer.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['timer'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "timer" processes started.`</p></li></ul>|
|Utilization of service manager internal processes, in %|<p>The average percentage of the time during which the service manager processes have been busy for the last minute.</p>|Dependent item|process.service_manager.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['service manager'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "service manager" processes started.`</p></li></ul>|
|Utilization of trigger housekeeper internal processes, in %|<p>The average percentage of the time during which the trigger housekeeper processes have been busy for the last minute.</p>|Dependent item|process.trigger_housekeeper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['trigger housekeeper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "trigger housekeeper" processes started.`</p></li></ul>|
|Utilization of trapper data collector processes, in %|<p>The average percentage of the time during which the trapper processes have been busy for the last minute.</p>|Dependent item|process.trapper.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['trapper'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "trapper" processes started.`</p></li></ul>|
|Utilization of unreachable poller data collector processes, in %|<p>The average percentage of the time during which the unreachable poller processes have been busy for the last minute.</p>|Dependent item|process.unreachable_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['unreachable poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "unreachable poller" processes started.`</p></li></ul>|
|Utilization of vmware collector data collector processes, in %|<p>The average percentage of the time during which the vmware collector processes have been busy for the last minute.</p>|Dependent item|process.vmware_collector.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['vmware collector'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "vmware collector" processes started.`</p></li></ul>|
|Utilization of agent poller data collector processes, in %|<p>The average percentage of the time during which the agent poller processes have been busy for the last minute.</p>|Dependent item|process.agent_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['agent poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "agent poller" processes started.`</p></li></ul>|
|Utilization of http agent poller data collector processes, in %|<p>The average percentage of the time during which the http agent poller processes have been busy for the last minute.</p>|Dependent item|process.http_agent_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['http agent poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "http agent poller" processes started.`</p></li></ul>|
|Utilization of snmp poller data collector processes, in %|<p>The average percentage of the time during which the snmp poller processes have been busy for the last minute.</p>|Dependent item|process.snmp_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['snmp poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "snmp poller" processes started.`</p></li></ul>|
|Utilization of internal poller data collector processes, in %|<p>The average percentage of the time during which the internal poller processes have been busy for the last minute.</p>|Dependent item|process.internal_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['internal poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "internal poller" processes started.`</p></li></ul>|
|Utilization of browser poller data collector processes, in %|<p>The average percentage of the time during which the browser poller processes have been busy for the last minute.</p>|Dependent item|process.browser_poller.avg.busy<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.process['browser poller'].busy.avg`</p><p>⛔️Custom on fail: Set error to: `No "browser poller" processes started.`</p></li></ul>|
|Configuration cache, % used|<p>The availability statistics of Zabbix configuration cache. The percentage of used data buffer.</p>|Dependent item|rcache.buffer.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.rcache.pused`</p></li></ul>|
|Trend function cache, % of unique requests|<p>The effectiveness statistics of the Zabbix trend function cache. The percentage of cached items calculated from the sum of the cached items plus requests.</p><p>A low percentage most likely means that the cache size can be reduced.</p>|Dependent item|tcache.pitems<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.tcache.pitems`</p><p>⛔️Custom on fail: Set error to: `Not supported in this version.`</p></li></ul>|
|Trend function cache, % of misses|<p>The effectiveness statistics of the Zabbix trend function cache. The percentage of cache misses.</p>|Dependent item|tcache.pmisses<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.tcache.pmisses`</p><p>⛔️Custom on fail: Set error to: `Not supported in this version.`</p></li></ul>|
|Value cache, % used|<p>The availability statistics of Zabbix value cache. The percentage of used data buffer.</p>|Dependent item|vcache.buffer.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vcache.buffer.pused`</p></li></ul>|
|Value cache hits|<p>The effectiveness statistics of Zabbix value cache. The number of cache hits (history values taken from the cache).</p>|Dependent item|vcache.cache.hits<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vcache.cache.hits`</p></li><li>Change per second</li></ul>|
|Value cache misses|<p>The effectiveness statistics of Zabbix value cache. The number of cache misses (history values taken from the database).</p>|Dependent item|vcache.cache.misses<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vcache.cache.misses`</p></li><li>Change per second</li></ul>|
|Value cache operating mode|<p>The operating mode of the value cache.</p>|Dependent item|vcache.cache.mode<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vcache.cache.mode`</p></li></ul>|
|Zabbix server check|<p>Flag indicating whether it is a server or not.</p>|Dependent item|server_check<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.triggers`</p><p>⛔️Custom on fail: Set value to: `0`</p></li><li><p>In range: ` -> 0`</p><p>⛔️Custom on fail: Set value to: `1`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Version|<p>The version of Zabbix server.</p>|Dependent item|version<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.version`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|VMware cache, % used|<p>The availability statistics of Zabbix vmware cache. The percentage of used data buffer.</p>|Dependent item|vmware.buffer.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vmware.pused`</p><p>⛔️Custom on fail: Set error to: `No "vmware collector" processes started.`</p></li></ul>|
|History write cache, % used|<p>The statistics and availability of Zabbix write cache. The percentage of used history buffer.</p><p>The history cache is used to store item values. A high number indicates database performance problems.</p>|Dependent item|wcache.history.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.history.pused`</p></li></ul>|
|History index cache, % used|<p>The statistics and availability of Zabbix write cache. The percentage of used history index buffer.</p><p>The history index cache is used to index values stored in the history cache.</p>|Dependent item|wcache.index.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.index.pused`</p></li></ul>|
|Trend write cache, % used|<p>The statistics and availability of Zabbix write cache. The percentage of used trend buffer.</p><p>The trend cache stores the aggregate of all items that have received data for the current hour.</p>|Dependent item|wcache.trend.pused<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.trend.pused`</p></li></ul>|
|Number of processed values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The total number of values processed by Zabbix server or Zabbix proxy, except unsupported items.</p>|Dependent item|wcache.values<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.all`</p></li><li>Change per second</li></ul>|
|Number of processed numeric (unsigned) values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed numeric (unsigned) values.</p>|Dependent item|wcache.values.uint<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.uint`</p></li><li>Change per second</li></ul>|
|Number of processed numeric (float) values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed numeric (float) values.</p>|Dependent item|wcache.values.float<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.float`</p></li><li>Change per second</li></ul>|
|Number of processed log values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed log values.</p>|Dependent item|wcache.values.log<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.log`</p></li><li>Change per second</li></ul>|
|Number of processed not supported values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of times the item processing resulted in an item becoming unsupported or remaining in that state.</p>|Dependent item|wcache.values.not_supported<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values['not supported']`</p></li><li>Change per second</li></ul>|
|Number of processed character values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed character values.</p>|Dependent item|wcache.values.str<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.str`</p></li><li>Change per second</li></ul>|
|Number of processed text values per second|<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed text values.</p>|Dependent item|wcache.values.text<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.wcache.values.text`</p></li><li>Change per second</li></ul>|
|Number of values synchronized with the database per second|<p>Average quantity of values written to the database, recalculated once per minute.</p>|Dependent item|vps.written<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.vps.written_total`</p></li><li>Change per second</li></ul>|
|LLD queue|<p>The number of values enqueued in the low-level discovery processing queue.</p>|Dependent item|lld_queue<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.lld_queue`</p></li></ul>|
|Preprocessing queue|<p>The number of values enqueued in the preprocessing queue.</p>|Dependent item|preprocessing_queue<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.preprocessing.queue`</p></li></ul>|
|Preprocessing queued throughput|<p>Reflects the queued throughput of the preprocessing.</p>|Dependent item|preprocessing_throughput_queued<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.preprocessing.queued.size`</p><p>⛔️Custom on fail: Discard value</p></li><li>Change per second</li></ul>|
|Preprocessing direct throughput|<p>Reflects the direct throughput of the preprocessing.</p>|Dependent item|preprocessing_throughput_direct<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.preprocessing.direct.size`</p><p>⛔️Custom on fail: Discard value</p></li><li>Change per second</li></ul>|
|Preprocessing queued VPS|<p>Reflects the count of queued preprocessing values per second.</p>|Dependent item|preprocessing_vps_queued<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.preprocessing.queued.count`</p><p>⛔️Custom on fail: Discard value</p></li><li>Change per second</li></ul>|
|Preprocessing direct VPS|<p>Reflects the count of direct preprocessing values per second.</p>|Dependent item|preprocessing_vps_direct<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.preprocessing.direct.count`</p><p>⛔️Custom on fail: Discard value</p></li><li>Change per second</li></ul>|
|Connector queue|<p>The count of values enqueued in the connector queue.</p>|Dependent item|connector_queue<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.connector_queue`</p><p>⛔️Custom on fail: Set error to: `No "connector" processes started. Please check "StartConnectors" parameter in the server configuration file.`</p></li></ul>|
|Discovery queue|<p>The count of values enqueued in the discovery queue.</p>|Dependent item|discovery_queue<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.discovery_queue`</p><p>⛔️Custom on fail: Set error to: `No "discoverer" processes started. Please check "StartDiscoverers" parameter in the server configuration file.`</p></li></ul>|

### Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Zabbix server: More than 100 items have been missing data for over 10 minutes|<p>Indicates potential issues with network connectivity, agent failures, or unresponsive monitored resources that require attention.</p>|`min(/Zabbix server health by Zabbix agent active/zabbix.stats[{$ZABBIX.SERVER.ADDRESS},{$ZABBIX.SERVER.PORT},queue,10m],10m)>100`|Warning|**Manual close**: Yes|
|Zabbix server: Utilization of alert manager processes is high|<p>Indicates potential performance issues with the alert manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.alert_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"alert manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of alert syncer processes is high|<p>Indicates potential performance issues with the alert syncer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.alert_syncer.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"alert syncer"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of alerter processes is high|<p>Indicates potential performance issues with the alerter, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.alerter.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"alerter"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of availability manager processes is high|<p>Indicates potential performance issues with the availability manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.availability_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"availability manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of configuration syncer processes is high|<p>Indicates potential performance issues with the configuration syncer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.configuration_syncer.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"configuration syncer"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of configuration syncer worker processes is high|<p>Indicates potential performance issues with the configuration syncer worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.configuration_syncer_worker.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"configuration syncer worker"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of escalator processes is high|<p>Indicates potential performance issues with the escalator, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.escalator.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"escalator"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of history poller processes is high|<p>Indicates potential performance issues with the history poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.history_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"history poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of ODBC poller processes is high|<p>Indicates potential performance issues with the ODBC poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.odbc_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"ODBC poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of history syncer processes is high|<p>Indicates potential performance issues with the history syncer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.history_syncer.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"history syncer"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of housekeeper processes is high|<p>Indicates potential performance issues with the housekeeper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.housekeeper.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"housekeeper"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of http poller processes is high|<p>Indicates potential performance issues with the http poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.http_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"http poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of icmp pinger processes is high|<p>Indicates potential performance issues with the icmp pinger, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.icmp_pinger.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"icmp pinger"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of ipmi manager processes is high|<p>Indicates potential performance issues with the ipmi manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.ipmi_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"ipmi manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of ipmi poller processes is high|<p>Indicates potential performance issues with the ipmi poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.ipmi_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"ipmi poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of java poller processes is high|<p>Indicates potential performance issues with the java poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.java_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"java poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of LLD manager processes is high|<p>Indicates potential performance issues with the LLD manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.lld_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"LLD manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of LLD worker processes is high|<p>Indicates potential performance issues with the LLD worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.lld_worker.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"LLD worker"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of connector manager processes is high|<p>Indicates potential performance issues with the connector manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.connector_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"connector manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of connector worker processes is high|<p>Indicates potential performance issues with the connector worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.connector_worker.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"connector worker"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of discovery manager processes is high|<p>Indicates potential performance issues with the discovery manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.discovery_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"discovery manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of discovery worker processes is high|<p>Indicates potential performance issues with the discovery worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.discovery_worker.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"discovery worker"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of poller processes is high|<p>Indicates potential performance issues with the poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of preprocessing worker processes is high|<p>Indicates potential performance issues with the preprocessing worker, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.preprocessing_worker.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"preprocessing worker"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of preprocessing manager processes is high|<p>Indicates potential performance issues with the preprocessing manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.preprocessing_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"preprocessing manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of proxy poller processes is high|<p>Indicates potential performance issues with the proxy poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.proxy_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"proxy poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of proxy group manager processes is high|<p>Indicates potential performance issues with the proxy group manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.proxy_group_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"proxy group manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of report manager processes is high|<p>Indicates potential performance issues with the report manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.report_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"report manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of report writer processes is high|<p>Indicates potential performance issues with the report writer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.report_writer.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"report writer"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of self-monitoring processes is high|<p>Indicates potential performance issues with the self-monitoring, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.self-monitoring.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"self-monitoring"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of snmp trapper processes is high|<p>Indicates potential performance issues with the snmp trapper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.snmp_trapper.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"snmp trapper"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of task manager processes is high|<p>Indicates potential performance issues with the task manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.task_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"task manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of timer processes is high|<p>Indicates potential performance issues with the timer, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.timer.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"timer"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of service manager processes is high|<p>Indicates potential performance issues with the service manager, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.service_manager.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"service manager"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of trigger housekeeper processes is high|<p>Indicates potential performance issues with the trigger housekeeper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.trigger_housekeeper.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"trigger housekeeper"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of trapper processes is high|<p>Indicates potential performance issues with the trapper, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.trapper.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"trapper"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of unreachable poller processes is high|<p>Indicates potential performance issues with the unreachable poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.unreachable_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"unreachable poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of vmware collector processes is high|<p>Indicates potential performance issues with the vmware collector, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.vmware_collector.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"vmware collector"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of agent poller processes is high|<p>Indicates potential performance issues with the agent poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.agent_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"agent poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of http agent poller processes is high|<p>Indicates potential performance issues with the http agent poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.http_agent_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"http agent poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of snmp poller processes is high|<p>Indicates potential performance issues with the snmp poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.snmp_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"snmp poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of internal poller processes is high|<p>Indicates potential performance issues with the internal poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.internal_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"internal poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Utilization of browser poller processes is high|<p>Indicates potential performance issues with the browser poller, which may affect monitoring efficiency and response times.</p>|`avg(/Zabbix server health by Zabbix agent active/process.browser_poller.avg.busy,10m)>{$ZABBIX.SERVER.UTIL.MAX:"browser poller"}`|Average|**Manual close**: Yes|
|Zabbix server: Excessive configuration cache usage|<p>Consider increasing `CacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Zabbix server health by Zabbix agent active/rcache.buffer.pused,10m)>{$ZABBIX.SERVER.UTIL.MAX:"configuration cache"}`|Average|**Manual close**: Yes|
|Zabbix server: Failed to fetch stats data|<p>Zabbix has not received statistics data for `{$ZABBIX.SERVER.NODATA_TIMEOUT}`.</p>|`nodata(/Zabbix server health by Zabbix agent active/rcache.buffer.pused,{$ZABBIX.SERVER.NODATA_TIMEOUT})=1`|Warning||
|Zabbix server: Excessive value cache usage|<p>Consider increasing `ValueCacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Zabbix server health by Zabbix agent active/vcache.buffer.pused,10m)>{$ZABBIX.SERVER.UTIL.MAX:"value cache"}`|Average|**Manual close**: Yes|
|Zabbix server: Zabbix value cache working in low-memory mode|<p>Once low-memory mode has been switched on, the value cache will remain in this state for 24 hours, even if the problem that triggered this mode is resolved sooner.</p>|`last(/Zabbix server health by Zabbix agent active/vcache.cache.mode)=1`|High|**Manual close**: Yes|
|Zabbix server: Wrong template assigned|<p>Check that the template has been selected correctly.</p>|`last(/Zabbix server health by Zabbix agent active/server_check)=0`|Disaster|**Manual close**: Yes|
|Zabbix server: Version has changed|<p>Zabbix server version has changed. Acknowledge to close the problem manually.</p>|`last(/Zabbix server health by Zabbix agent active/version,#1)<>last(/Zabbix server health by Zabbix agent active/version,#2) and length(last(/Zabbix server health by Zabbix agent active/version))>0`|Info|**Manual close**: Yes|
|Zabbix server: Excessive vmware cache usage|<p>Consider increasing `VMwareCacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Zabbix server health by Zabbix agent active/vmware.buffer.pused,10m)>{$ZABBIX.SERVER.UTIL.MAX:"vmware cache"}`|Average|**Manual close**: Yes|
|Zabbix server: Excessive history cache usage|<p>Consider increasing `HistoryCacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Zabbix server health by Zabbix agent active/wcache.history.pused,10m)>{$ZABBIX.SERVER.UTIL.MAX:"history cache"}`|Average|**Manual close**: Yes|
|Zabbix server: Excessive history index cache usage|<p>Consider increasing `HistoryIndexCacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Zabbix server health by Zabbix agent active/wcache.index.pused,10m)>{$ZABBIX.SERVER.UTIL.MAX:"index cache"}`|Average|**Manual close**: Yes|
|Zabbix server: Excessive trends cache usage|<p>Consider increasing `TrendCacheSize` in the `zabbix_server.conf` configuration file.</p>|`max(/Zabbix server health by Zabbix agent active/wcache.trend.pused,10m)>{$ZABBIX.SERVER.UTIL.MAX:"trend cache"}`|Average|**Manual close**: Yes|

### LLD rule Zabbix proxy discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Zabbix proxy discovery|<p>LLD rule with item and trigger prototypes for proxy discovery.</p>|Dependent item|zabbix.proxy.discovery<p>**Preprocessing**</p><ul><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|

### Item prototypes for Zabbix proxy discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Proxy [{#PROXY.NAME}]: Stats|<p>The statistics for the discovered proxy.</p>|Dependent item|zabbix.proxy.stats[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.[?(@.name=="{#PROXY.NAME}")].first()`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Mode|<p>The mode of Zabbix proxy.</p>|Dependent item|zabbix.proxy.mode[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.passive`</p></li><li><p>JavaScript: `return value === 'false' ? 0 : 1`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Unencrypted|<p>The encryption status for connections from a proxy.</p>|Dependent item|zabbix.proxy.unencrypted[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.unencrypted`</p></li><li><p>JavaScript: `return value === 'false' ? 0 : 1`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: PSK|<p>The encryption status for connections from a proxy.</p>|Dependent item|zabbix.proxy.psk[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.psk`</p></li><li><p>JavaScript: `return value === 'false' ? 0 : 1`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Certificate|<p>The encryption status for connections from a proxy.</p>|Dependent item|zabbix.proxy.cert[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.cert`</p></li><li><p>JavaScript: `return value === 'false' ? 0 : 1`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Compression|<p>The compression status of a proxy.</p>|Dependent item|zabbix.proxy.compression[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.compression`</p></li><li><p>JavaScript: `return value === 'false' ? 0 : 1`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Item count|<p>The number of enabled items on enabled hosts assigned to a proxy.</p>|Dependent item|zabbix.proxy.items[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.items`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Host count|<p>The number of enabled hosts assigned to a proxy.</p>|Dependent item|zabbix.proxy.hosts[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.hosts`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Version|<p>A version of Zabbix proxy.</p>|Dependent item|zabbix.proxy.version[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.version`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Last seen, in seconds|<p>The time when a proxy was last seen by a server.</p>|Dependent item|zabbix.proxy.last_seen[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.last_seen`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Compatibility|<p>Version of proxy compared to Zabbix server version.</p><p></p><p>Possible values:</p><p>0 - Undefined;</p><p>1 - Current version (proxy and server have the same major version);</p><p>2 - Outdated version (proxy version is older than server version, but is partially supported);</p><p>3 - Unsupported version (proxy version is older than server previous LTS release version or server major version is older than proxy major version).</p>|Dependent item|zabbix.proxy.compatibility[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.compatibility`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Proxy [{#PROXY.NAME}]: Required VPS|<p>The required performance of a proxy (the number of values that need to be collected per second).</p>|Dependent item|zabbix.proxy.requiredperformance[{#PROXY.NAME}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.requiredperformance`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|

### Trigger prototypes for Zabbix proxy discovery

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Zabbix server: Proxy [{#PROXY.NAME}]: Zabbix proxy last seen|<p>Zabbix proxy is not updating the configuration data.</p>|`last(/Zabbix server health by Zabbix agent active/zabbix.proxy.last_seen[{#PROXY.NAME}],#1)>{$ZABBIX.PROXY.LAST_SEEN.MAX}`|Warning||
|Zabbix server: Proxy [{#PROXY.NAME}]: Zabbix proxy never seen|<p>Zabbix proxy is not updating the configuration data.</p>|`last(/Zabbix server health by Zabbix agent active/zabbix.proxy.last_seen[{#PROXY.NAME}],#1)=-1`|Warning||
|Zabbix server: Proxy [{#PROXY.NAME}]: Zabbix proxy is outdated|<p>Zabbix proxy version is older than server version, but is partially supported. Only data collection and remote execution is available.</p>|`last(/Zabbix server health by Zabbix agent active/zabbix.proxy.compatibility[{#PROXY.NAME}],#1)=2`|Warning||
|Zabbix server: Proxy [{#PROXY.NAME}]: Zabbix proxy is not supported|<p>Zabbix proxy version is older than server previous LTS release version or server major version is older than proxy major version.</p>|`last(/Zabbix server health by Zabbix agent active/zabbix.proxy.compatibility[{#PROXY.NAME}],#1)=3`|High||

### LLD rule High availability cluster node discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|High availability cluster node discovery|<p>LLD rule with item and trigger prototypes for node discovery.</p>|Dependent item|zabbix.nodes.discovery<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.ha`</p></li><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|

### Item prototypes for High availability cluster node discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Cluster node [{#NODE.NAME}]: Stats|<p>Provides the statistics of a node.</p>|Dependent item|zabbix.node.stats[{#NODE.ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.data.ha[?(@.id=="{#NODE.ID}")].first()`</p></li></ul>|
|Cluster node [{#NODE.NAME}]: Address|<p>The IPv4 address of a node.</p>|Dependent item|zabbix.node.address[{#NODE.ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.address`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|
|Cluster node [{#NODE.NAME}]: Last access time|<p>Last access time.</p>|Dependent item|zabbix.node.lastaccess.time[{#NODE.ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.lastaccess`</p></li></ul>|
|Cluster node [{#NODE.NAME}]: Last access age|<p>The time between the database's `unix_timestamp()` and the last access time.</p>|Dependent item|zabbix.node.lastaccess.age[{#NODE.ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.lastaccess_age`</p></li></ul>|
|Cluster node [{#NODE.NAME}]: Status|<p>The status of a node.</p>|Dependent item|zabbix.nodes.status[{#NODE.ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.status`</p></li><li><p>Discard unchanged with heartbeat: `12h`</p></li></ul>|

### Trigger prototypes for High availability cluster node discovery

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Zabbix server: Cluster node [{#NODE.NAME}]: Status changed|<p>The state of the node has changed. Acknowledge to close the problem manually.</p>|`last(/Zabbix server health by Zabbix agent active/zabbix.nodes.status[{#NODE.ID}],#1)<>last(/Zabbix server health by Zabbix agent active/zabbix.nodes.status[{#NODE.ID}],#2)`|Info|**Manual close**: Yes|

## Feedback

Please report any issues with the template at [`https://support.zabbix.com`](https://support.zabbix.com)

You can also provide feedback, discuss the template, or ask for help at [`ZABBIX forums`](https://www.zabbix.com/forum/zabbix-suggestions-and-feedback)

