/*
 * @(#)PyraminxP.h
 *
 * Copyright 1994 - 2023  David A. Bagley, bagleyd AT verizon.net
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Private header file for Pyraminx */

#ifndef _PyraminxP_h
#define _PyraminxP_h

#include "xwin.h"
#include "timer.h"
#include "Pyraminx.h"

#ifdef WINVER
extern void destroyPuzzle(HBRUSH brush);
extern void resizePuzzle(PyraminxWidget w);
extern void sizePuzzle(PyraminxWidget w);
extern void initializePuzzle(PyraminxWidget w, HBRUSH brush);
extern void exposePuzzle(PyraminxWidget w);
extern void periodModePuzzle(PyraminxWidget w, const int mode);
extern void dimPuzzle(PyraminxWidget w);
extern int  movePuzzleDir(PyraminxWidget w, const int direction);
extern void setPuzzleMove(PyraminxWidget w, int reason, int face, int position,
	int direction, int style, Boolean control, int fast);

#else

/* This gets around C's inability to do inheritance */
typedef struct _PyraminxClassPart {
	int         ignore;
} PyraminxClassPart;

typedef struct _PyraminxClassRec {
	CoreClassPart coreClass;
	PyraminxClassPart pyraminxClass;
} PyraminxClassRec;

extern PyraminxClassRec pyraminxClassRec;
extern void quitPuzzle(PyraminxWidget w, XEvent *event, char **args, int nArgs);
extern void movePuzzleCw(PyraminxWidget w, XEvent *event, char **args, int nArgs);
extern void movePuzzleCcw(PyraminxWidget w, XEvent *event, char **args,
	int nArgs);
#endif
extern void hidePuzzle(
#ifdef WINVER
const PyraminxWidget w
#else
PyraminxWidget w, XEvent *event, char **args, int nArgs
#endif
);
extern void selectPuzzle(PyraminxWidget w
#ifdef WINVER
, const int x, const int y, const int control
#else
, XEvent *event, char **args, int nArgs
#endif
);
extern void releasePuzzle(PyraminxWidget w
#ifdef WINVER
, const int x, const int y, const int control, const int alt
#else
, XEvent *event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void practicePuzzleWithQuery(PyraminxWidget w
, XEvent *event, char **args, int nArgs
);
extern void practicePuzzleWithDoubleClick(PyraminxWidget w
, XEvent *event, char **args, int nArgs
);
extern void randomizePuzzleWithQuery(PyraminxWidget w
, XEvent *event, char **args, int nArgs
);
extern void randomizePuzzleWithDoubleClick(PyraminxWidget w
, XEvent *event, char **args, int nArgs
);
#endif
extern void getPuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void writePuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void undoPuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void redoPuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void clearPuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void randomizePuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void solvePuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void findPuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void practicePuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void incrementPuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern
#ifdef WINVER
Boolean
#else
void
#endif
decrementPuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void orientizePuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void stickyModePuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void period2ModePuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void period3ModePuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void bothModePuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void viewPuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void speedUpPuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void slowDownPuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void toggleSoundPuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void enterPuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void leavePuzzle(PyraminxWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);

#ifndef MOVESOUND
#define MOVESOUND "move"
#endif

#define SYMBOL ':'

#define TOP 0
#define TR 1
#define RIGHT 2
#define BOTTOM 3
#define BL 4
#define LEFT 5
#define COORD 6
#define CW 7
#define BR 9
#define TL 10
#define CCW 11

#define DOWN 0
#define UP 1
#define MAX_VIEWS 2
#define MAX_SIDES (MAX_FACES/MAX_VIEWS)
#define MAX_ORIENT (3*MAX_SIDES)
#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

typedef struct _moveRecord {
#if 0
	int face, direction, style, control;
#endif
	unsigned short int packed;  /* This makes assumptions on the data. */
	int position;		    /* Do not make assumptions on this one. */
} moveRecord;

typedef struct _MoveStack {
	moveRecord move;
	struct _MoveStack *previous, *next;
} MoveStack;

typedef struct _PyraminxStack {
	MoveStack *currMove, *lastMove, *firstMove;
	int count;
} PyraminxStack;

typedef struct _PyraminxLoc {
	int         face, rotation;
} PyraminxLoc;

typedef struct _CRD {
	int column, row, diagonal;
} CRD;

typedef struct _PyraminxPart {
	PyraminxLoc *facetLoc[MAX_FACES];
	PyraminxLoc *faceLoc[MAX_SIDES];
	PyraminxLoc *rowLoc[3][MAX_SIDES];
	int         currentFace, currentPosition, currentDirection;
	int         currentJunk, currentStyle, currentFast, currentControl;
	Boolean     started, cheat, sound;
	Boolean     practice, orient, vertical, mono, reverse, sticky, focus;
	Boolean     scoreOnly, versionOnly;
	int         dim; /* This allows us to reuse code between 2d and 3d */
	int         degreeTurn, view;
	int         size, sizeSize, mode;
	int         delay;
	Position    delta;
	Position    facetLength;
	Position    faceLength;
	Position    viewLength;
	Position    sideOffset, orientLineLength, orientDiagLength;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          faceGC[MAX_FACES];
#ifdef WINVER
	char        userName[81], scoreFile[81], moveSound[81];
	char        faceChar[MAX_FACES];
#else
	int         menu, pixmapSize;
	char       *userName, *scoreFile, *moveSound, *font;
	XFontStruct *fontInfo;
	char       *faceName[MAX_FACES];
	Pixel       foreground, background;
	Pixel       frameColor, borderColor;
	Pixel       faceColor[MAX_FACES];
	XtCallbackList select;
#endif
} PyraminxPart;

typedef struct _PyraminxRec {
	CorePart    core;
	PyraminxPart pyraminx;
} PyraminxRec;

extern PyraminxLoc *startLoc[MAX_FACES];

extern void movePuzzleInput(PyraminxWidget w, int x, int y, int direction,
	int shift, int control);
extern void setPuzzle(PyraminxWidget w, int reason);
extern void movePuzzle(PyraminxWidget w, int face, int position,
	int direction, int style, int control, int fast);
extern void movePuzzleDelay(PyraminxWidget w, int face, int position,
	int direction, int style, int control);
extern void setAllColors(PyraminxWidget w);
extern void resetPieces(PyraminxWidget w);
extern void clearPieces(PyraminxWidget w);
extern void solveSomePieces(PyraminxWidget w);
extern void findSomeMoves(PyraminxWidget w);
extern void drawAllPieces(PyraminxWidget w);
extern Boolean checkSolved(PyraminxWidget w);
extern void newMoves(PyraminxStack *s);
extern void deleteMoves(PyraminxStack *s);
extern void setMove(PyraminxStack *s,
	int direction, int style, int control, int face, int position);
extern void getMove(PyraminxStack *s,
	int *direction, int *style, int *control, int *face, int *position);
extern int madeMoves(PyraminxStack *s);
extern void flushMoves(PyraminxWidget w, PyraminxStack *s, Boolean undo);
extern int numMoves(PyraminxStack *s);
extern Boolean scanMoves(FILE *fp, PyraminxWidget w, int moves);
extern void printMoves(FILE *fp, PyraminxStack *s);
extern Boolean scanStartPosition(FILE *fp, PyraminxWidget w);
extern void printStartPosition(FILE *fp, PyraminxWidget w);
extern void setStartPosition(PyraminxWidget w);
extern void toCRD(PyraminxWidget w, int face, int position, CRD * crd);
extern int toPosition(PyraminxWidget w, CRD crd);

#endif /* _PyraminxP_h */
