/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.math.BigDecimal;
import java.util.Date;
import spec.jbb.Address;
import spec.jbb.JBButil;
import spec.jbb.Order;

public class Customer {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,Licensed Materials - Property of SPEC";
    private static final String bad_credit = "BC";
    private static final String good_credit = "GC";
    private Order lastOrder = null;
    private String firstName;
    private String middleName;
    private String lastName;
    private Address address = new Address();
    private String phone;
    private Date since = new Date();
    private String data;
    private BigDecimal creditLimit = BigDecimal.valueOf(0L, 2);
    private BigDecimal discount;
    private BigDecimal balance = BigDecimal.valueOf(0L, 2);
    private BigDecimal ytd = BigDecimal.valueOf(0L, 2);
    private char credit1;
    private char credit2;
    private short customerId;
    private short paymentCount = 0;
    private short deliveryCount = 0;
    private byte districtId;
    private short warehouseId;

    public short getId() {
        return this.customerId;
    }

    public synchronized void display() {
        System.out.println("Customer Display *********************************");
        System.out.println("customerId =================> " + this.customerId);
        System.out.println("district ID ========> " + this.districtId);
        System.out.println("warehouse ID========> " + this.warehouseId);
        System.out.println("firstname===========> " + this.firstName);
        System.out.println("middlename =========> " + this.middleName);
        System.out.println("lastname ===========> " + this.lastName);
        this.address.display();
        System.out.println("END ****Customer Display *********************************");
    }

    public synchronized void addOrder(Order order) {
        this.lastOrder = order;
    }

    public synchronized Order getLatestOrder() {
        Order order = this.lastOrder;
        return order;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Address getAddress() {
        return this.address;
    }

    public BigDecimal getDiscountRate() {
        return this.discount;
    }

    public String getCreditStatus() {
        String string = this.credit1 == 'G' ? good_credit : bad_credit;
        return string;
    }

    public short getWarehouseId() {
        return this.warehouseId;
    }

    public byte getDistrictId() {
        return this.districtId;
    }

    public synchronized BigDecimal getBalance() {
        BigDecimal bigDecimal = this.balance;
        return bigDecimal;
    }

    public synchronized BigDecimal getCreditLimit() {
        return this.creditLimit;
    }

    public synchronized void adjustBalance(BigDecimal bigDecimal) {
        this.balance = this.balance.add(bigDecimal);
    }

    public synchronized void increaseYTD(BigDecimal bigDecimal) {
        this.ytd = this.ytd.add(bigDecimal);
    }

    public synchronized void incrementPaymentCount() {
        this.paymentCount = (short)(this.paymentCount + 1);
    }

    public synchronized void incrementDeliveryCount() {
        this.deliveryCount = (short)(this.deliveryCount + 1);
    }

    public synchronized void updateCustomerData(String string) {
        String string2 = this.data;
        if (string2.length() + string.length() <= 500) {
            this.data = new String(string + this.data);
        } else {
            String string3 = string2.substring(0, 500 - string.length());
            this.data = new String(string + string3);
        }
    }

    public synchronized void setUsingRandom(short s, short s2, byte by) {
        this.customerId = s;
        this.districtId = by;
        this.warehouseId = s2;
        this.lastName = JBButil.create_random_last_name(s, this.warehouseId);
        this.firstName = new String(JBButil.create_random_a_string(8, 16, this.warehouseId));
        this.middleName = new String("OE");
        this.address.setUsingRandom(this.warehouseId);
        this.phone = new String(JBButil.create_random_n_string(16, 16, this.warehouseId));
        if (JBButil.random(1, 10, this.warehouseId) > 1) {
            this.credit1 = (char)71;
            this.credit2 = (char)67;
        } else {
            this.credit1 = (char)66;
            this.credit2 = (char)67;
        }
        this.creditLimit = BigDecimal.valueOf(5000000L, 2);
        float f = JBButil.create_random_float_val_return(0.0f, 0.5f, 1.0E-4f, this.warehouseId);
        this.discount = new BigDecimal(f).setScale(4, 4);
        this.balance = BigDecimal.valueOf(-1000L, 2);
        this.ytd = BigDecimal.valueOf(1000L, 2);
        this.paymentCount = 1;
        this.deliveryCount = 0;
        this.data = new String(JBButil.create_random_a_string(300, 500, this.warehouseId));
    }

    public String getPhone() {
        return this.phone;
    }

    public Date getSince() {
        return this.since;
    }

    public synchronized String getCustomerDataParts() {
        String string = this.data;
        return string;
    }
}

