## TFSA-2021-007: Session operations in eager mode lead to null pointer dereferences

### CVE Number
CVE-2021-29518

### Impact
In eager mode (default in TF 2.0 and later), session operations are invalid.
However, users could still call the raw ops associated with them and trigger a
null pointer dereference:

```python
import tensorflow as tf
tf.raw_ops.GetSessionTensor(handle=['\x12\x1a\x07'],dtype=4)
```
```python
import tensorflow as tf
tf.raw_ops.DeleteSessionTensor(handle=['\x12\x1a\x07'])
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/eebb96c2830d48597d055d247c0e9aebaea94cd5/tensorflow/core/kernels/session_ops.cc#L104) dereferences the session state pointer without checking if it is valid:

```cc
  OP_REQUIRES_OK(ctx, ctx->session_state()->GetTensor(name, &val));
```

Thus, in eager mode, `ctx->session_state()` is nullptr and the call of the
member function is undefined behavior.

### Patches
We have patched the issue in GitHub commit
[ff70c47a396ef1e3cb73c90513da4f5cb71bebba](https://github.com/tensorflow/tensorflow/commit/ff70c47a396ef1e3cb73c90513da4f5cb71bebba).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
